<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service\Common;

class UserAppLogin
{
    private $loginObject;

    public function __construct($loginType, $redirectUri)
    {
        $objectName = 'User\\Service\\Common\\AppLogin\\' . ucfirst($loginType).'Login';
        $this->loginObject = new $objectName;
        $this->loginObject->redirectUri = $redirectUri;
    }

    public function toLogin()
    {
        $this->loginObject->toLogin();
    }

    public function loginCallBock()
    {
        $this->loginObject->loginCallBock();
    }

    public function getOpenId()
    {
        return $this->loginObject->openId();
    }

    public function getUnionId()
    {
        return $this->loginObject->unionId();
    }

    public function getLoginUserInfo()
    {
        return $this->loginObject->loginUserInfo();
    }

    public function clearOtherLoginSession()
    {
        $this->loginObject->clearOtherLoginSession();
    }
}