<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\IntegralRule;

class IntegralRuleManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加积分规则
     * @param array $data
     * @return IntegralRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addIntegralRule(array $data)
    {
        $integralRule = new IntegralRule();
        $integralRule->valuesSet($data);

        $this->entityManager->persist($integralRule);
        $this->entityManager->flush();

        return $integralRule;
    }

    /**
     * 编辑积分规则
     * @param array $data
     * @param IntegralRule $integralRule
     * @return IntegralRule
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editIntegralRule(array $data, IntegralRule $integralRule)
    {
        $integralRule->valuesSet($data);
        $this->entityManager->flush();

        return $integralRule;
    }

    /**
     * 删除积分规则
     * @param IntegralRule $integralRule
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteIntegralRule(IntegralRule $integralRule)
    {
        $this->entityManager->remove($integralRule);
        $this->entityManager->flush();

        return true;
    }
}