<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\IntegralType;

class IntegralTypeManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 编辑更新积分类型
     * @param array $data
     * @param IntegralType $integralType
     * @return IntegralType
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editIntegralType(array $data, IntegralType $integralType)
    {
        unset($data['integralTypeName']);

        $integralType->valuesSet($data);
        $this->entityManager->flush();

        return $integralType;
    }
}