<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserAddress;

class UserAddressManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加收货地址
     * @param array $data
     * @return UserAddress
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserAddress(array $data)
    {
        if(isset($data['addrDefault']) && $data['addrDefault'] == 1) $this->updateUserAddressDefaultState($data['userId']);

        $userAddress = new UserAddress();
        $userAddress->valuesSet($data);

        $this->entityManager->persist($userAddress);
        $this->entityManager->flush();

        return $userAddress;
    }

    /**
     * 更新收货地址
     * @param array $data
     * @param UserAddress $userAddress
     * @param int $addressId
     * @return object|UserAddress|null
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editUserAddress(array $data, UserAddress $userAddress, $addressId = 0)
    {
        if(isset($data['addrDefault']) && $data['addrDefault'] == 1) $this->updateUserAddressDefaultState($data['userId']);

        $addressInfo = $addressId == 0 ? $userAddress : $this->entityManager->getRepository(UserAddress::class)->findOneBy(['addressId' => $addressId]);
        if($addressInfo) {
            $addressInfo->valuesSet($data);
            $this->entityManager->flush();

            return $addressInfo;
        }
        return null;
    }

    /**
     * 删除收货地址
     * @param UserAddress $userAddress
     * @param int $addressId
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteUserAddress(UserAddress $userAddress, $addressId = 0)
    {
        $addressInfo = $addressId == 0 ? $userAddress : $this->entityManager->getRepository(UserAddress::class)->findOneBy(['addressId' => $addressId]);
        if($addressInfo) {
            $this->entityManager->remove($addressInfo);
            $this->entityManager->flush();

            return true;
        }
        return false;
    }

    /**
     * 修改默认状态
     * @param $userId
     * @return int|mixed|string
     */
    private function updateUserAddressDefaultState($userId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->update(UserAddress::class, 'a')->set('a.addrDefault', '0')
            ->where('a.userId = :userId')->setParameter('userId', $userId)
            ->andWhere('a.addrDefault = 1');

        return $qb->getQuery()->execute();
    }
}