<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserGoodsFavorites;

class UserGoodsFavoritesManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加会员收藏商品
     * @param array $data
     * @return UserGoodsFavorites
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserGoodsFavorites(array $data)
    {
        $goodsFavorites = new UserGoodsFavorites();
        $goodsFavorites->valuesSet($data);
        $goodsFavorites->setFavoritesTime(time());

        $this->entityManager->persist($goodsFavorites);
        $this->entityManager->flush();

        return $goodsFavorites;
    }

    /**
     * 删除收藏商品
     * @param $goodsFavoritesId
     * @param $userId
     * @return int|mixed|string
     */
    public function deleteUserGoodsFavorites($goodsFavoritesId, $userId)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(UserGoodsFavorites::class, 'f')
            ->where('f.goodsFavoritesId = :goodsFavoritesId')->setParameter('goodsFavoritesId', $goodsFavoritesId)
            ->andWhere('f.userId = :userId')->setParameter('userId', $userId);

        return $qb->getQuery()->execute();
    }
}