<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserGroup;

class UserGroupManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加客户组
     * @param array $data
     * @return UserGroup
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserGroup(array $data)
    {
        $userGroup = new UserGroup();
        $userGroup->valuesSet($data);

        $this->entityManager->persist($userGroup);
        $this->entityManager->flush();

        return $userGroup;
    }

    /**
     * 编辑客户组
     * @param array $data
     * @param UserGroup $userGroup
     * @return UserGroup
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editUserGroup(array $data, UserGroup $userGroup)
    {
        $userGroup->valuesSet($data);
        $this->entityManager->flush();

        return $userGroup;
    }

    /**
     * 删除客户组
     * @param UserGroup $userGroup
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteUserGroup(UserGroup $userGroup)
    {
        $this->entityManager->remove($userGroup);
        $this->entityManager->flush();

        return true;
    }
}