<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserIntegralConfirm;

class UserIntegralConfirmManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加确认获取积分表
     * @param array $data
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserIntegralConfirm(array $data)
    {
        $integralConfirm = new UserIntegralConfirm();
        $integralConfirm->valuesSet($data);

        $this->entityManager->persist($integralConfirm);
        $this->entityManager->flush();
    }

    /**
     * 更新确认获取积分表
     * @param array $data
     * @param UserIntegralConfirm $userIntegralConfirm
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editUserIntegralConfirm(array $data, UserIntegralConfirm $userIntegralConfirm)
    {
        $userIntegralConfirm->valuesSet($data);
        $this->entityManager->flush();
    }

    /**
     * 删除确认获取积分信息
     * @param $id
     * @param $type
     * @return int|mixed|string
     */
    public function deleteUserIntegralConfirm($id, $type)
    {
        $qb = $this->entityManager->createQueryBuilder();
        $qb->delete(UserIntegralConfirm::class, 'u')
            ->where('u.id = :id')->setParameter('id', $id)
            ->andWhere('u.confirmType = :type')->setParameter('type', $type);

        return $qb->getQuery()->execute();
    }
}