<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserOtherLogin;

class UserOtherLoginManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加第三方登录信息
     * @param array $data
     * @return UserOtherLogin
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserOtherLogin(array $data)
    {
        $otherLogin = new UserOtherLogin();
        $otherLogin->valuesSet($data);

        $this->entityManager->persist($otherLogin);
        $this->entityManager->flush();

        return $otherLogin;
    }

    /**
     * 更新第三方登录信息
     * @param $data
     * @param UserOtherLogin $userOtherLogin
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editUserOtherLogin($data, UserOtherLogin $userOtherLogin)
    {
        $userOtherLogin->valuesSet($data);
        $this->entityManager->flush();
    }

    /**
     * 删除第三方登录信息
     * @param UserOtherLogin $userOtherLogin
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteUserOtherLogin(UserOtherLogin $userOtherLogin)
    {
        $this->entityManager->remove($userOtherLogin);
        $this->entityManager->flush();

        return true;
    }
}