<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service;

use Doctrine\ORM\EntityManager;
use User\Entity\UserWithdraw;

class UserWithdrawManager
{
    private $entityManager;

    public function __construct(
        EntityManager $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * 添加提现申请
     * @param array $data
     * @return UserWithdraw
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function addUserWithdraw(array $data)
    {
        $userWithdraw = new UserWithdraw();
        $userWithdraw->valuesSet($data);
        $userWithdraw->setAddWithdrawTime(time());

        $this->entityManager->persist($userWithdraw);
        $this->entityManager->flush();

        return $userWithdraw;
    }

    /**
     * 编辑提现申请
     * @param $data
     * @param UserWithdraw $userWithdraw
     * @return UserWithdraw
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function editUserWithdraw($data, UserWithdraw $userWithdraw)
    {
        $userWithdraw->valuesSet($data);
        $this->entityManager->flush();

        return $userWithdraw;
    }

    /**
     * 删除提现申请
     * @param UserWithdraw $userWithdraw
     * @return bool
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function deleteUserWithdraw(UserWithdraw $userWithdraw)
    {
        $this->entityManager->remove($userWithdraw);
        $this->entityManager->flush();

        return true;
    }
}