<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Validator;

use Laminas\Validator\AbstractValidator;

class UserIntegralType1Validator extends AbstractValidator
{
    const NOT_SCALAR    = 'notScalar';
    const INVALID_VALUE = 'invalidValue';

    protected $options = [
        'userInfo'
    ];

    protected $messageTemplates = [
        self::NOT_SCALAR    => "这不是一个标准输入值",
        self::INVALID_VALUE   => "超出有效范围的数值"
    ];

    public function __construct($options = null)
    {
        if(is_array($options)) {
            if(isset($options['userInfo']))         $this->options['userInfo']      = $options['userInfo'];
        }

        parent::__construct($options);
    }

    public function isValid($value, $context = null)
    {
        if(!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        if($value <= 0) return true;

        if($this->options['userInfo'] == null) {
            $isValid = false;
        } else {
            $changeIntegralNum = $context['changeIntegral1'].$value;
            $integralNum = $this->options['userInfo']->getIntegralType1Num() + $changeIntegralNum;
            if($integralNum < 0)
                $isValid = false;
            else
                $isValid = true;
        }

        if(!$isValid) $this->error(self::INVALID_VALUE);

        return $isValid;
    }
}