<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\View;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Mvc\I18n\Translator;
use Laminas\View\Helper\AbstractHelper;

class UserHelper extends AbstractHelper
{
    private $translator;

    public function __construct(
        Translator  $translator
    )
    {
        $this->translator   = $translator;
    }

    /**
     * 客户状态
     * @param $status
     * @return mixed
     */
    public function userStatus($status)
    {
        $userStatus = Common::userStatus($this->translator, 2);

        return $userStatus[$status];
    }

    /**
     * 客户组等级积分状态
     * @param $state
     * @return mixed
     */
    public function userGroupIntegralState($state)
    {
        $userGroupIntegralState = Common::state($this->translator, 2);

        return $userGroupIntegralState[$state];
    }

    /**
     * 积分规则状态
     * @param $state
     * @return mixed
     */
    public function integralRuleState($state)
    {
        $integralRuleState = Common::state($this->translator, 2);

        return $integralRuleState[$state];
    }

    /**
     * 积分类型
     * @param $typeId
     * @return mixed
     */
    public function userIntegralType($typeId)
    {
        $integralType = Common::integralType($this->translator);

        return $integralType[$typeId];
    }

    /**
     * 余额处理类型
     * @param $typeId
     * @return mixed
     */
    public function userChangeBalanceType($typeId)
    {
        $changeBalanceType = Common::balanceChangeType($this->translator);

        return $changeBalanceType[$typeId];
    }

    /**
     * 充值状态
     * @param $state
     * @return mixed
     */
    public function userRechargeStatus($state)
    {
        $rechargeStatus = Common::payStatus($this->translator);

        return $rechargeStatus[$state];
    }

    /**
     * 余额提现状态
     * @param $state
     * @return mixed
     */
    public function getWithdrawState($state)
    {
        return Common::withdrawState($this->translator)[$state];
    }
}