<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

use Laminas\Mvc\Application;
use Laminas\Stdlib\ArrayUtils;

chdir(dirname(__DIR__));

//如果在开发状态时，注释下面语句；在生产环境下，不要注释
error_reporting(0);

if (!file_exists('data/install.lock')) {
    if (version_compare(PHP_VERSION, '7.2', '<') === true) exit('ERROR: Your PHP version is ' . PHP_VERSION . '. DBShop requires PHP 7.2 or newer.<br><br>错误：您的 PHP 版本是 ' . PHP_VERSION . '。DBShop系统支持 PHP7.2或者更高版本。');
    if (!in_array(basename($_SERVER['REQUEST_URI']), ['install', 'nextStep', 'installShop', 'installFinish'])) exit('<a href="'.rtrim(dirname($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']), '/').'/install">click Install DBShop</a>');
}

include './vendor/autoload.php';

$appConfig = require './config/application.config.php';

//shop版本信息
include "./data/shopVersion.php";

/**
 * 动态加载
 */
$moduleExtendConfig = require './data/moduleExtend.php';
if(!empty($moduleExtendConfig)) {
    $loader = new \Composer\Autoload\ClassLoader();
    array_map(function ($module) use($loader) {
        $loader->addPsr4($module['key'], $module['value']);
        }, $moduleExtendConfig);
    $loader->register();
}



Application::init($appConfig)->run();
