function closeWindow() {
    let userAgent = navigator.userAgent;
    if (userAgent.indexOf("Firefox") != -1 || userAgent.indexOf("Chrome") != -1) {
        location.href = "about:blank";
    } else {
        window.opener = null;
        window.open('', '_self');
    }
    window.close();
}

//通用获取列表方法
function dbshopAjaxList(listUrl,showDivDd) {
    $.get(listUrl, {}, function(html){
        $("#"+showDivDd).html(html);
    });
}

// 通用消息提示框
function showAlert(content) {
    layer.open({
        skin: 'layer-alert',
        content: content,
        btn: ['OK']
    });
}

function showMessage(content) {
    layer.msg(content);
}

function deleteNotConfirm(url, deleteId) {
    $.get(url, {}, function (data) {
        if(data.status == 'true') {
            if(deleteId.length >0) $('#'+deleteId).remove();
            else window.location.reload();
        }
        else {
            if(data.hasOwnProperty("message")) {
                layer.msg(data.message);
            }
        }
    }, 'json');
}

/**
 * 执行问询
 * @param msg
 * @param url
 * @param toUrlState
 */
function runConfirm(msg, url, toUrlState) {
    layer.confirm(msg, {}, function () {
        if(toUrlState == 'false') {
            $.get(url, {}, function (data) {
                if(data.status == 'true') window.location.reload();
                else {
                    if(data.hasOwnProperty("message")) {
                        layer.msg(data.message);
                    } else window.location.reload();
                }
            }, 'json');
        } else window.location.href = url;
    })
}

/* *
 * 截取小数位数
 */
function advFormatNumber(value, num) // 四舍五入
{
    var a_str = formatNumber(value, num);
    var a_int = parseFloat(a_str);
    if (value.toString().length > a_str.length) {
        var b_str = value.toString().substring(a_str.length, a_str.length + 1);
        var b_int = parseFloat(b_str);
        if (b_int < 5) {
            return a_str;
        } else {
            var bonus_str, bonus_int;
            if (num == 0) {
                bonus_int = 1;
            } else {
                bonus_str = "0."
                for (var i = 1; i < num; i++)
                    bonus_str += "0";
                bonus_str += "1";
                bonus_int = parseFloat(bonus_str);
            }
            a_str = formatNumber(a_int + bonus_int, num)
        }
    }
    return a_str;
}

function formatNumber(value, num) // 直接去尾
{
    var a, b, c, i;
    a = value.toString();
    b = a.indexOf('.');
    c = a.length;
    if (num == 0) {
        if (b != -1) {
            a = a.substring(0, b);
        }
    } else {
        if (b == -1) {
            a = a + ".";
            for (i = 1; i <= num; i++) {
                a = a + "0";
            }
        } else {
            a = a.substring(0, b + num + 1);
            for (i = c; i <= b + num; i++) {
                a = a + "0";
            }
        }
    }
    return a;
}
//加法函数
function accAdd(arg1, arg2) {
    var r1, r2, m;
    try {
        r1 = arg1.toString().split(".")[1].length;
    }
    catch (e) {
        r1 = 0;
    }
    try {
        r2 = arg2.toString().split(".")[1].length;
    }
    catch (e) {
        r2 = 0;
    }
    m = Math.pow(10, Math.max(r1, r2));

    return (arg1 * m + arg2 * m) / m;
    //return advFormatNumber((arg1 * m + arg2 * m) / m, 2);
}

//减法函数
function Subtr(arg1, arg2) {
    var r1, r2, m, n;
    try {
        r1 = arg1.toString().split(".")[1].length;
    }
    catch (e) {
        r1 = 0;
    }
    try {
        r2 = arg2.toString().split(".")[1].length;
    }
    catch (e) {
        r2 = 0;
    }
    m = Math.pow(10, Math.max(r1, r2));
    //last modify by deeka
    //动态控制精度长度
    n = (r1 >= r2) ? r1 : r2;
    return ((arg1 * m - arg2 * m) / m).toFixed(n);
    //return advFormatNumber(((arg1 * m - arg2 * m) / m).toFixed(n), 2);
}


//乘法函数
function accMul(arg1, arg2) {
    var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
    try {
        m += s1.split(".")[1].length;
    }
    catch (e) {
    }
    try {
        m += s2.split(".")[1].length;
    }
    catch (e) {
    }
    return Number(s1.replace(".", "")) * Number(s2.replace(".", "")) / Math.pow(10, m);
    //return advFormatNumber(Number(s1.replace(".", "")) * Number(s2.replace(".", "")) / Math.pow(10, m), 2);
}

//除法函数
function accDiv(arg1, arg2) {
    var t1 = 0, t2 = 0, r1, r2;
    try {
        t1 = arg1.toString().split(".")[1].length;
    }
    catch (e) {
    }
    try {
        t2 = arg2.toString().split(".")[1].length;
    }
    catch (e) {
    }
    with (Math) {
        r1 = Number(arg1.toString().replace(".", ""));
        r2 = Number(arg2.toString().replace(".", ""));
        return (r1 / r2) * pow(10, t2 - t1);
        //return advFormatNumber((r1 / r2) * pow(10, t2 - t1), 2);
    }
}

/* 地区选择函数 */
function regionInit(divId)
{
    $("#" + divId + " > select").change(regionChange); // select的onchange事件
}

function regionChange()
{
    // 删除后面的select
    $(this).nextAll("select").remove();
    // 计算当前选中到id和拼起来的name
    let selects = $(this).siblings("select").addBack();
    let id = 0;
    let i;
    let name;
    let names = new Array();
    for (i = 0; i < selects.length; i++)
    {
        sel = selects[i];
        if (sel.value > 0)
        {
            id = sel.value;
            name = sel.options[sel.selectedIndex].text;
            names.push(name);
        }
    }
    $(".region_ids").val(id);
    $(".region_names").val(names.join(" "));
    // ajax请求下级地区
    if (this.value > 0)
    {
        var _self = this;
        var url = SITE_REGION_URL;
        $.post(url, {'region_id':this.value}, function(data){
                if (data)
                {
                    if (data.length > 0)
                    {
                        $("<select class='form-control' style='display: inline;width: 15%;margin-left: 3px;'><option>"+AREA_SELECT_LANG+"</option></select>").change(regionChange).insertAfter(_self);
                        var data  = data;
                        for (i = 0; i < data.length; i++)
                        {
                            $(_self).next("select").append("<option value='" + data[i].region_id + "'>" + data[i].region_name + "</option>");
                        }
                    }
                }
            },
            'json');
    }
}

function regionEdit()
{
    $("#show_address_area").show();
    $("#show_address_area").css('display', 'inline');
    $(".show_region_value").hide();
}