<?php
require_once __DIR__.'/../../../vendor/autoload.php';
// 导入对应产品模块的client
use TencentCloud\Soe\V20180724\SoeClient;

// 导入要请求接口对应的Request类
use TencentCloud\Soe\V20180724\Models\TransmitOralProcessRequest;
use TencentCloud\Soe\V20180724\Models\TransmitOralProcessResponse;

use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

try {
    // 实例化一个证书对象，入参需要传入腾讯云账户secretId，secretKey
    $cred = new Credential("", "");
    //$cred = new Credential(getenv(""), getenv("");

    // 实例化一个http选项，可选的，没有特殊需求可以跳过
    $httpProfile = new HttpProfile();
    $httpProfile->setReqMethod("POST");  // post请求(默认为post请求)
    $httpProfile->setReqTimeout(30);    // 请求超时时间，单位为秒(默认60秒)
    $httpProfile->setEndpoint("soe.tencentcloudapi.com");  // 指定接入地域域名(默认就近接入)

    // 实例化一个client选项，可选的，没有特殊需求可以跳过
    $clientProfile = new ClientProfile();
    $clientProfile->setSignMethod("TC3-HMAC-SHA256");  // 指定签名算法(默认为HmacSHA256)
    $clientProfile->setHttpProfile($httpProfile);

    $client = new SoeClient($cred, "", $clientProfile);

    // 实例化一个ecc实例信息查询请求对象,每个接口都会对应一个request对象。
    $req = new TransmitOralProcessRequest();
    $req->SessionId = "stress_test_956938";
	$req->VoiceFileType = 2;
	$req->SeqId = 1;
	$req->VoiceEncodeType = 1;
	$req->IsEnd = 1;
    $req->UserVoiceData ="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";
    $resp = $client->TransmitOralProcess($req);

    // 输出json格式的字符串回包
    print_r($resp->toJsonString());

    // 也可以取出单个值。
    // 你可以通过官网接口文档或跳转到response对象的定义处查看返回字段的定义
    print_r($resp->TotalCount);
}
catch(TencentCloudSDKException $e) {
    echo $e;
}
