<?php
/**
 * Created by PhpStorm
 * User: song
 * Date: 2020/9/29/0029
 * Time: 16:45
 */

namespace crmeb\services\express\storage;
use crmeb\basic\BaseExpress;
use crmeb\exceptions\ApiException;
use crmeb\services\AccessTokenServeService;

/**
 * Class Express
 * @package crmeb\services\express\storage
 */

class Express extends BaseExpress
{
    /**
     * 注册服务
     */
    const EXPRESS_OPEN = 'expr/open';

    /**
     * 电子面单模版
     */
    const EXPRESS_TEMP = 'expr/temp';

    /**
     * 快递公司
     */
    const EXPRESS_LIST = 'expr/express';

    /**
     * 快递查询
     */
    const EXPRESS_QUERY = 'expr/query';

    /**
     * 面单打印
     */
    const EXPRESS_DUMP = 'expr/dump';
    /** 初始化
     * @param array $config
     * @return mixed|void
     */

    protected function initialize(array $config = [])
    {
        parent::initialize($config); // TODO: Change the autogenerated stub
    }

    /**
     * 开通物流服务
     * @return bool|mixed
     */
    public function open()
    {
        return $this->accessToken->httpRequest(self::EXPRESS_OPEN, []);
    }

    /**
     * 获取电子面单模版
     * @param $com 快递公司编号
     * @param int $page
     * @param int $limit
     * @return bool|mixed
     */
    public function temp($com, $page = 0, $limit = 10)
    {
        $param = [
            'com' => $com,
            'page' => $page,
            'limit' => $limit
        ];

        return $this->accessToken->httpRequest(self::EXPRESS_TEMP, $param);
    }

    /**
     * 获取物流公司列表
     * @param int $type 快递类型：1，国内运输商；2，国际运输商；3，国际邮政
     * @return bool|mixed
     */
    public function express(int $type = 1, int $page = 0, int $limit = 10)
    {
        $param = [
            'type' => $type,
            'page' => $page,
            'limit' => $limit
        ];
        return $this->accessToken->httpRequest(self::EXPRESS_LIST, $param);
    }
    /**
     * 查询物流信息
     * @param $com
     * @param $num
     * @return bool|mixed
     * @return 是否签收 ischeck
     * @return 物流状态：status 0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转单，10待清关，11清关中，12已清关，13清关异常，14收件人拒签
     * @return 物流详情 content
     */
    public function query($com, $num)
    {
        $param = [
            'com' => $com,
            'num' => $num
        ];
        return $this->accessToken->httpRequest(self::EXPRESS_QUERY, $param);
    }

    /**
     * 电子面单打印
     * @param array $data 必需参数: com(快递公司编码)、to_name(寄件人)、to_tel（寄件人电话）、to_addr（寄件人详细地址）、from_name（收件人）、from_tel（收件人电话)、from_addr（收件人地址）、temp_id（电子面单模板ID）、siid（云打印机编号）、count（商品数量）
     * @return bool|mixed
     */
    public function dump($data)
    {
        $param = $data;
        $param['com'] = $data['com'] ?? '';
        if (!$param['com']) throw new ApiException('快递公司编码缺失');
        $param['to_name'] = $data['to_name'] ?? '';
        $param['to_tel'] = $data['to_tel'] ?? '';
        $param['to_addr'] = $data['to_addr'] ?? '';
        if (!$param['to_addr'] || !$param['to_tel'] || !$param['to_name']) throw new ApiException('寄件人信息缺失');
        $param['from_name'] = $data['from_name'] ?? '';
        $param['from_tel'] = $data['from_tel'] ?? '';
        $param['from_addr'] = $data['from_addr'] ?? '';
        if (!$param['from_name'] || !$param['from_tel'] || !$param['from_addr']) throw new ApiException('收件人信息缺失');
        $param['temp_id'] = $data['temp_id'] ?? '';
        if (!$param['temp_id']) throw new ApiException('电子面单模板ID缺失');
        $param['siid'] = $data['siid'] ?? '';
        if (!$param['siid']) throw new ApiException('云打印机编号缺失');
        $param['count'] = $data['count'] ?? '';
        if (!$param['count']) throw new ApiException('商品数量缺失');
        $param['cargo'] = $data['cargo'] ?? '';
        $param['partner_id'] = $data['partner_id'] ?? 0;
        $param['partner_key'] = $data['partner_key'] ?? '';
        $param['net'] = $data['net'] ?? '';
        return $this->accessToken->httpRequest(self::EXPRESS_DUMP, $param);
    }

}
