DROP TABLE IF EXISTS `juan_admin`;
CREATE TABLE IF NOT EXISTS `juan_admin` (
  `userid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `truename` varchar(30) NOT NULL,
  `email` varchar(35) NOT NULL,
  `purview` text NOT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `lastip` varchar(15) NOT NULL,
  `lastlogin` int(11) unsigned NOT NULL,
  `msgnum` smallint(2) DEFAULT NULL,
  PRIMARY KEY (`userid`),
  KEY `username` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_admin_log`;
CREATE TABLE IF NOT EXISTS `juan_admin_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adminname` varchar(32) NOT NULL,
  `logdate` int(10) unsigned NOT NULL,
  `logtype` varchar(255) NOT NULL,
  `logip` varchar(15) NOT NULL,
  PRIMARY KEY (`logid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_com`;
CREATE TABLE IF NOT EXISTS `juan_com` (
  `comid` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `catid` smallint(5) unsigned NOT NULL,
  `comname` varchar(100) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `address` varchar(100) NOT NULL,
  `is_check` tinyint(1) unsigned NOT NULL,
  `click` int(11) NOT NULL,
  `postdate` int(11) unsigned NOT NULL,
  PRIMARY KEY (`comid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_com_cat`;
CREATE TABLE IF NOT EXISTS `juan_com_cat` (
  `catid` mediumint(6) NOT NULL AUTO_INCREMENT,
  `catname` varchar(32) NOT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `parentid` int(11) DEFAULT NULL,
  `catorder` smallint(6) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `parentid` (`parentid`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_config`;
CREATE TABLE IF NOT EXISTS `juan_config` (
  `setname` varchar(100) NOT NULL,
  `value` text,
  KEY `setname` (`setname`)
) ENGINE=MyISAM;

INSERT INTO `juan_config` (`setname`, `value`) VALUES
('webname', '乐得同城'),
('weburl', ''),
('keywords', '优惠券,优惠券网站,商家优惠券,折扣券,代金券,礼品券,抵购券,团购券,红包券,兑换券,特价券,同城优惠券'),
('copyright', '版权所有 乐得同城'),
('description', '乐得同城是一个发放领取商家优惠券,商家折扣券,商家代金券,商家礼品券,商家抵购券,商家团购券,商家红包券,商家兑换券,商家特价券的网站平台。'),
('post_check', '1'),
('postfile', 'post.php'),
('tplname', 'juan'),
('crypt', '');

DROP TABLE IF EXISTS `juan_juan`;
CREATE TABLE IF NOT EXISTS `juan_juan` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `userid` int(11) unsigned NOT NULL,
  `comid` int(10) NOT NULL,
  `catid` mediumint(6) unsigned NOT NULL,
  `thumb` varchar(100) NOT NULL,
  `jinfo` text NOT NULL,
  `postdate` int(11) NOT NULL,
  `enddate` int(11) unsigned NOT NULL,
  `userdate` smallint(3) NOT NULL,
  `nums` int(6) NOT NULL,
  `usernum` smallint(2) NOT NULL,
  `click` smallint(6) unsigned NOT NULL DEFAULT '0',
  `is_check` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `postdate` (`postdate`),
  KEY `click` (`click`,`postdate`),
  KEY `is_check` (`is_check`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_juan_cat`;
CREATE TABLE IF NOT EXISTS `juan_juan_cat` (
  `catid` mediumint(6) NOT NULL AUTO_INCREMENT,
  `catname` varchar(32) NOT NULL,
  `catorder` smallint(6) NOT NULL,
  PRIMARY KEY (`catid`),
  KEY `catname` (`catname`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_juan_user`;
CREATE TABLE IF NOT EXISTS `juan_juan_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `juanid` int(10) NOT NULL,
  `comid` int(11) NOT NULL,
  `userid` int(11) unsigned NOT NULL,
  `codeid` varchar(12) NOT NULL,
  `adddate` int(11) NOT NULL,
  `offdate` int(11) NOT NULL,
  `enddate` int(11) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `postdate` (`adddate`),
  KEY `click` (`adddate`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_member`;
CREATE TABLE IF NOT EXISTS `juan_member` (
  `userid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `gid` tinyint(1) NOT NULL,
  `username` varchar(32) NOT NULL,
  `face` varchar(200) DEFAULT NULL,
  `sex` tinyint(1) DEFAULT NULL,
  `shengri` int(11) NOT NULL,
  `email` varchar(60) NOT NULL,
  `password` varchar(32) NOT NULL,
  `registertime` int(11) unsigned NOT NULL,
  `registerip` varchar(15) NOT NULL,
  `lastlogintime` int(11) unsigned NOT NULL,
  `lastloginip` varchar(15) NOT NULL,
  `sendmailtime` int(11) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `lastposttime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `juan_nav`;
CREATE TABLE IF NOT EXISTS `juan_nav` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `navname` varchar(32) NOT NULL,
  `url` varchar(100) NOT NULL,
  `target` varchar(6) NOT NULL,
  `navorder` smallint(5) unsigned NOT NULL,
  `navwz` varchar(15) NOT NULL,
  `icon` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`navname`),
  KEY `url` (`url`),
  KEY `navorder` (`navorder`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `juan_nav` (`id`, `navname`, `url`, `target`, `navorder`, `navwz`, `icon`) VALUES
(1, '首页', 'index.php', '_self', 1, 'top', ''),
(2, '优惠券', 'list.php', '_self', 2, 'top', ''),
(3, '首页', 'index.php', '_self', 3, 'bottom', 'images/icon/5.png'),
(4, '优惠券', 'list.php', '_self', 4, 'bottom', 'images/icon/2.png'),
(6, '我', 'member.php?act=login', '_self', 99, 'bottom', 'images/icon/4.png');

