<?php
namespace app\common\controller;
use think\Controller;
use think\Db;

abstract class Base{
    /**
     * 视图实例对象
     * @var view
     * @access protected
     */
    protected $view = null;

    /**
     * $info = array(
     *  'name'=>'Editor',
     *  'title'=>'编辑器',
     *  'description'=>'用于增强整站长文本的输入和显示',
     *  'status'=>1,
     *  'author'=>'thinkphp',
     *  'version'=>'0.1'
     *  )
     */
    public $info                =   array();
    public $addon_path          =   '';
    public $config_file         =   '';
    public $custom_config       =   '';
    public $admin_list          =   array();
    public $custom_adminlist    =   '';
    public $access_url          =   array();

    /**
     * 基类构造函数
     * Base constructor.
     */
    public function __construct()
    {
        $this->view         =   new \think\View();
        $this->addon_path   =   ADDON_PATH . $this->getName() . '/';
        $TMPL_PARSE_STRING = config('parse_str');
        $TMPL_PARSE_STRING['__ADDONROOT__'] = $TMPL_PARSE_STRING['__ADDONS__'] . '/' . $this->getName();
        config('parse_str', $TMPL_PARSE_STRING);
        if(is_file($this->addon_path . 'config.php')){
            $this->config_file = $this->addon_path . 'config.php';
        }
    }

    /**
     * 模板主题设置
     * @access protected
     * @param string $theme 模版主题
     * @return Action
     */
    final protected function theme($theme)
    {
        $this->view->theme($theme);
        return $this;
    }

    /**
     * 模板变量赋值
     * @access protected
     * @param mixed $name 要显示的模板变量
     * @param mixed $value 变量的值
     * @return Action
     */
    final protected function assign($name, $value='')
    {
        $this->view->assign($name,$value);
        return $this;
    }


    //用于显示模板的方法
    final protected function fetch($templateFile = CONTROLLER_NAME)
    {
        if(!is_file($templateFile)){
            $templateFile = $this->addon_path . $templateFile . ".html";
            if(!is_file($templateFile)){
                die('_TEMPLATE_NOT_EXIST_') . ":$templateFile";
            }
        }
        return $this->view->fetch($templateFile);
    }

    /**
     * 获取插件名
     * @return string
     */
    final public function getName()
    {
        $class = get_class($this);
        list($space, $name, $class) = explode('\\', $class);

        return $name;
    }

    /**
     * 检查配置信息是否完整
     * @return bool
     */
    final public function checkInfo()
    {
        $info_check_keys = array('name','title','description','status','author','version');
        foreach ($info_check_keys as $value) {
            if(!array_key_exists($value, $this->info))
                return false;
        }
        return true;
    }

    /**
     * 获取插件的配置数组
     */
    final public function getConfig($name = '')
    {
        static $_config = [];
        if(empty($name)){
            $name = $this->getName();
        }
        if(isset($_config[$name])){
            return $_config[$name];
        }

        $map['name']    =   $name;
        $map['status']  =   1;
        $config  =  Db:name('Addons')->where($map)->getField('config');
        if($config){
            $config   =   json_decode($config, true);
        }else{
            $config =   [];
            $temp_arr = include $this->config_file;
            foreach ($temp_arr as $key => $value) {
                if($value['type'] == 'group'){
                    foreach ($value['options'] as $gkey => $gvalue) {
                        foreach ($gvalue['options'] as $ikey => $ivalue) {
                            $config[$ikey] = $ivalue['value'];
                        }
                    }
                }else{
                    $config[$key] = $temp_arr[$key]['value'];
                }
            }
        }
        $_config[$name]     =   $config;
        return $config;
    }

    /**
     * 必须实现安装
     * @return mixed
     */
    abstract public function install();

    /**
     * 必须卸载插件方法
     * @return mixed
     */
    abstract public function uninstall();
}
