<?php
namespace app\common\controller;
use think\Controller;
use think\Db;
use think\console\Command;
use think\console\Input;
use think\console\input\Argument;
use think\console\input\Option;
use think\console\Output;
class Task extends Command{
	  protected function configure()
    {
        $this->setName('task')
            ->addArgument('name', Argument::OPTIONAL, "your name")
            ->addOption('city', null, Option::VALUE_REQUIRED, 'city name')
            ->setDescription('Say Hello');
    }
//引入需要执行的文件
    protected function execute(Input $input, Output $output)
    {
    //调取事先写好的逻辑类--Addred中方法
	 //获取输入的参数
        $name = $input->getArgument('name');
        $this->add($name );
//在控制台输出
        $output->writeln("over");
    }
        /* 增加插件 */
	public function add($name){  
	   
		  $data = array(
            'name'=>$name,
            'title'=>$name.'插件',
            'description'=>'这是一个临时描述',
            'status'=>1,
            'author'=>'无名',
            'version'=>'0.1'
        );
		   
		
		  if(!$data['name']){
		    $this->error('插件标识必须');
		  }
        //检测插件名是否合法
        $plugins_dir             =  PLUGIN_PATH;
        if(file_exists("{$plugins_dir}{$data['name']}")){
            $this->error('插件已经存在了');
        }
		$class=ucfirst($data['name']);
			
		 $hook = '';
		if(input('hook')){ 
		 $hookarray=explode("|",input('hook'));	
        foreach ($hookarray as $value) {
			
			
			$hoo['name']=$value;
			if(db("hooks")->where($hoo)->select()){
				 $this->error('钩子'.$value.'已经存在了');		  
			}
			else{$hoo['addons']=$data['name'];
			$hoo['description']=$data['title'].'的钩子';
				 db("hooks")->insert($hoo);	
			}
			
			
            $hook .= <<<str
        //实现的{$value}钩子方法
        public function {$value}(\$param=[]){
           
        }

str;
        }
		}
        $str = <<<str
<?php
namespace plugin\\{$data['name']};
use app\index\behavior\Plugin;
/**
 * {$data['title']}插件
 * @author {$data['author']}
 */
    class {$class} extends Plugin{

        public \$info = array(
            'name'=>'{$data['name']}',
            'title'=>'{$data['title']}',
            'description'=>'{$data['description']}',
            'status'=>{$data['status']},
            'author'=>'{$data['author']}',
            'version'=>'{$data['version']}'
        );

        public function install(){
            return true;
        }

        public function uninstall(){
            return true;
        }

{$hook}
    }
str;
		
        
        $plugins_dir             = PLUGIN_PATH;
        //创建目录结构
        $files          =   array();
        $plugin_dir      =   "$plugins_dir{$data['name']}/";
        $files[]        =   $plugin_dir;
        $plugin_name     =   "{$class}.php";
        $files[]        =   "{$plugin_dir}{$plugin_name}";
        if(isset($data['has_config'])&&$data['has_config'] == 1);//如果有配置文件
		{   $files[]    =   $plugin_dir.'config.php';
		
		}
            $files[]    =   "{$plugin_dir}controller/";
            $files[]    =   "{$plugin_dir}controller/{$class}.php";
			$files[]    =   "{$plugin_dir}model/";
			$files[]    =   "{$plugin_dir}model/{$class}.php";
		    $files[]    =   "{$plugin_dir}".ucfirst($data['name']).".php";
			$files[]    =   "{$plugin_dir}view/";
			$files[]    =   "{$plugin_dir}view/images/";
			$files[]    =   "{$plugin_dir}view/css/";
			$files[]    =   "{$plugin_dir}view/js/";
            $files[]    =   "{$plugin_dir}view/css/style.css";
		
     
      foreach ($files as $key => $value) {
            if(substr($value, -1) == '/'){
               mkdir($value);
           }else{
               @file_put_contents($value, '');
	      }
	  }
      file_put_contents("{$plugin_dir}{$plugin_name}", $str); 
      $index="{$plugin_dir}view/index.html";	  
      $indexhtml= file_get_contents(ROOT_PATH . 'install\conf\plugin.conf');
	  file_put_contents($index, $indexhtml); 
      if(isset($data['has_config'])&&$data['has_config'] == 1){ 
   	      $conf= file_get_contents(ROOT_PATH . 'install\conf\config.conf');
		  file_put_contents("{$plugin_dir}config.php",$conf);
	   }
	      if($data){
			  addUserLog("add_plugin",session_uid());
		      $this->success("创建成功！",cookie("__forward__"));
		  }else{
			  $error=$Plugin->getError()?$Plugin->getError():"新增失败！";
			  $this->error($error);
		  } 
	}
    
	
}
