<?php
namespace app\index\behavior;
use think\facade\Request;
use think\facade\Config;
use think\Loader;
use think\Controller;
use think\Db;
/**
 * 插件基类控制器
 * Class Controller
 * @package think\addons
 */
class  Base extends Controller
{
    // 当前插件操作
    protected $addon = null;
    protected $controller = null;
    protected $action = null;
    // 当前template
    protected $template;
    // 模板配置信息
    protected $config = [
        'type' => 'Think',
        'view_path' => '',
        'view_suffix' => 'html',
        'strip_space' => true,
        'view_depr' => '',
        'tpl_begin' => '{',
        'tpl_end' => '}',
        'taglib_begin' => '{',
        'taglib_end' => '}',
    ];
	
    public $info                =   array();
    public $plugin_path          =   '';
    public $config_file         =   '';
    public $custom_config       =   '';
    public $admin_list          =   array();
    public $custom_adminlist    =   '';
    public $access_url          =   array();
    /**
     * 架构函数
     * @param Request $request Request对象
     * @access public
     */
    public function __construct(Request $request = null)
    {   
	      $this->view         =   new \think\View();
       
        $TMPL_PARSE_STRING = config('parse_str');
		 $this->plugin_path   =   PLUGIN_PATH . $this->getName() . '/';
        //$TMPL_PARSE_STRING['__ADDONROOT__'] = $TMPL_PARSE_STRING['__ADDONS__'] . '/' . $this->getName();
       /// config('parse_str', $TMPL_PARSE_STRING);
        if(is_file($this->plugin_path . 'config.php')){
            $this->config_file = $this->plugin_path . 'config.php';
        }
		
		  // 格式化路由的插件位置
        $this->action =input('_action') ;
        $this->controller = input('_controller') ;
       
        $this->addon=input('_plugin');
        // 生成request对象
        $this->request = is_null($request) ? Request::instance() : $request;
        // 初始化配置信息
        $this->config = Config::get('template') ?: $this->config;
        // 处理路由参数
        $route = $this->request->param('route', '');
        $param = explode('-', $route);
        // 是否自动转换控制器和操作名
        $convert = \Config::get('url_convert');
       
        // 生成view_path
        $view_path = $this->config['view_path'] ?: '';

        // 重置配置
        Config::set('template.view_path', PLUGIN_PATH .'/'. $this->addon  .'/'.$view_path);

        parent::__construct($request);
    }
	     
		 final protected function assign($name, $value='')
    {
        $this->view->assign($name,$value);
        return $this;
    }
	   
	   protected function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
        $controller = Loader::parseName($this->controller);
        if ('think' == strtolower($this->config['type']) && $controller && 0 !== strpos($template, '/')) {
            $depr = $this->config['view_depr'];
            $template = str_replace(['/', ':'], $depr, $template);
            if ('' == $template) {
                // 如果模板文件名为空 按照默认规则定位
                $template = str_replace('.', DS, $controller) . $depr . $this->action;
            } 
        }
        return parent::fetch($template, $vars, $replace, $config);
    }
 /**
     * 获取插件名
     * @return string
     */
   

  
    

}