<?php
namespace app\index\controller;
use think\Controller;
use think\Db;
/**
 * 收藏模型控制器
 * 收藏模型列表和详情
 */
class Account extends Home {
	public function index($type=null){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		if(!is_null($type)){
		$map[]=['type','=',$type];
		}else{
			$map[]=['type','>=',0];
		}
		 $map[]=['uid','=',is_login()]; 
		$this->meta_title = '我的账户明细';	
		$this->assign('meta_title',$this->meta_title);
       
		$res=getLists("account_log",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
      //增加收藏
    public function add(){
		if(!session_uid() ) {
			$this->error( "您还没有登陆",url("User/login") );
		}
		$id=input('id',0); // 用intval过滤$_POST['id']
		if(!($id && is_numeric($id))){
			$this->error('ID错误！');
		}   
		$data["goods_id"] = $id;
		$data["uid"]=session_uid();
		$info=db("collect")->where($data)->find();
		if($info){
		   $this->error( "已收藏过" ); 
		}
		else{	
		   $res=db("collect")->insert($data);
		   if($res){
                   $map["id"] = $id;
				   db("goods")->where($map)->setInc("collect");
				  $this->success("收藏成功");
		   }else{
			    $this->error("收藏失败");
		   } 
	   }   
   }
   public function delete(){
	   if(!session_uid() ) {
			$this->error( "您还没有登陆",url("User/login") );
	   }
	   $id=input('id'); // 用intval过滤$_POST['id']
	   $id=safe_replace($id);//过滤
	   $map["id"]=$id; 
	   $map["uid"]=session_uid();
	   $res=db("collect")->where($map)->delete();
	   if($res){
		  $this->success("删除成功");
	   }else{
		  $this->error("删除失败");
	   }
   }
}

