<?php
namespace app\index\controller;
use think\Controller;
use think\Db;
use plugin\im\controller\Base;
use GatewayClient\Gateway;
use plugin\im\Im;
//require_once(dirname(dirname(__FILE__))."/GatewayClient/Gateway.php");

/**
 * 后台Index控制器
 */
class Client extends Base{
	
     /* Index查询首页 */
	public function index(){     
        $im=new Im;
		$config=$im->getConfig();
		$this->assign('config', $config);
		
		if(!is_login()){
             $this->error("请先登录！",'index/user/login');
        }
		$user['id']='0';
		$user['cover']='0';
		$user['username']='0';
        if(is_login()){
		 $uid=is_login();
		 $user=db("user")->where('id',$uid)->find();
		 $user['cover']=get_cover_path($user['cover_id']);
		 $this->assign('user', $user);
		}
		$this->assign('user', $user);
		
	    return $this->fetch(ROOT_PATH."/plugin/im/view/client/index"); 
	}
 public function bind()
    {
       Gateway::$registerAddress = '127.0.0.1:1236';

    // 假设用户已经登录，用户uid和群组id在session中
    $uid      = $_SESSION['uid'];
     $group_id = $_SESSION['group'];
    // client_id与uid绑定
    Gateway::bindUid($client_id, $uid);
    // 加入某个群组（可调用多次加入多个群组）
     Gateway::joinGroup($client_id, $group_id);
    }
// mvc后端发消息 利用GatewayClient发送 Events.php
public function sendMessage()
{
    // stream_socket_client(): unable to connect to tcp://127.0.0.1:1236
    $uid = $this->userId;
    $group = $this->groupId;
    $message = json_encode([
      'type'=>'say',
      'msg'=>'Hello ThinkPHP5'
    ]);
    // 设置GatewayWorker服务的Register服务ip和端口，请根据实际情况改成实际值
    Gateway::$registerAddress = '127.0.0.1:1238';
    // 向任意uid的网站页面发送数据
    Gateway::sendToUid($uid, $message);
    // 向任意群组的网站页面发送数据，如果开启，则会向页面发送两条一样的消息
    //Gateway::sendToGroup($group, $message);
}
    /* 编辑Index */
	public function edit($id){   
	    if($_POST){
		   $Index = new \plugin\im\model\Index;
           $res=$Index->allowField(true)->validate(true)->save($_POST,['id' => $_POST['id']]);
	       if($res){
			   addUserLog("edit_index",session_uid());
		      $this->success("更新成功！",cookie("__forward__"));
		   }else{
			  $error=$Index->getError()?$Index->getError():"更新失败！";
			  $this->error($error);
		   } 
	   }
	   else{
		$map['id']=input("id");
		 $info=db("Index")->where($map)->find();
	     $this->assign('info', $info);
		
		   cookie("__forward__",input('server.HTTP_REFERER'));
		 $this->meta_title="编辑Index";
		 $this->assign('meta_title', $this->meta_title);
	     return $this->fetch("index/edit");
	   }
	}
	 /* 增加Index */
	public function add($id=""){  
	   if($_POST){
		  $Index = new \plugin\im\model\Index;
            // 过滤post数组中的非数据表字段数据
          $res=$Index->validate(true)->allowField(true)->save($_POST);
	      if($res){
			  addUserLog("add_index",session_uid());
		      $this->success("新增成功！",cookie("__forward__"));
		  }else{
			  $error=$Index->getError()?$Index->getError():"新增失败！";
			  $this->error($error);
		  } 
	 }
	  else{
		
		  $this->meta_title="新增Index";
		    cookie("__forward__",input('server.HTTP_REFERER'));
		  $this->assign('meta_title', $this->meta_title);
	      return $this->fetch("index/edit");
	  }
	}
	 /* 删除Index*/
	public function del(){   
	    $id=input("id");
	   $map[]=['id',"in",$id];
		if(!$map){
			 $this->error("未选择数据！");
		}
	
		$res=db("Index")->where($map)->delete();
		
		if($res){
		   addUserLog("del_index",session_uid());
		   $this->success("删除成功！");
		}else{
	           $this->error("删除失败！");
		}
	}
	
}
