<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Controller;
use think\Db;
/**
 * 收藏模型控制器
 * 收藏模型列表和详情
 */
class Coupon extends Home {
	public function index($type=null){
		
		if(!is_null($type)){
		$map[]=['status','=',$type];
		}else{
			$map[]=['status','>=',0];
		}
		
		$this->meta_title = '领优惠券';	
		$this->assign('meta_title',$this->meta_title);
       
		$res=getLists("coupon",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
	
	public function lists($type=0){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		if(!is_null($type)){
		  $map[]=['status','=',$type];
		 
		}else{
			$map[]=['status','>=',0];
		} 
		$map[]=['uid','=',is_login()]; 
		$this->meta_title = '我的优惠券';	
		$this->assign('meta_title',$this->meta_title);
		$res=getLists("user_coupon",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
      //增加收藏
    public function add(){
	   if(!is_login() ) {
			$this->error( "您还没有登陆",url("User/login") );
	   }
	   $id=input('id'); // 用intval过滤$_POST['id']
		if(!($id && is_numeric($id))){
			$this->error('ID错误！');
		}   
		$uid=session_uid();
		$data["coupon_id"] = $id;
		$data["uid"]=$uid;
		$user=db("user_coupon")->where($data)->find();
		if($user){
		   $this->error( "已领取过" ); 
		}
		$map["id"]=$id;	$map["status"]=1;
		$info=db("coupon")->where($map)->find();
		if($info['end_time']<time()){
			$this->error( "已过领取期限" );
		}
		if($info['num']==$info['total_num']){
			$this->error( "数量不足" );
		}
		$update['num']=$info['num']+1;
		
		db("coupon")->where($map)->setField("num",$update['num']);
	
		  $data["title"]=$info['title'];
		  $data["money"]=$info['money'];
		  $data["total"]=$info['total'];
		  $data["create_time"]=$info['create_time'];
		  $data["end_time"]=$info['end_time'];
		  $data["status"]=0;//未使用
		  $res=db("user_coupon")->insertGetId($data);
	   
	
		 if($res){
                 
				  $this->success("领取成功");
		 }else{
			    $this->error("领取失败");
		 } 
	      
   }
   public function delete(){
	   if(!session_uid() ) {
			$this->error( "您还没有登陆",url("User/login") );
	   }
	   $id=input('id'); // 用intval过滤$_POST['id']
	   $id=safe_replace($id);//过滤
	   $map["id"]=$id; 
	   $map["uid"]=session_uid();
	   $res=db("collect")->where($map)->delete();
	   if($res){
		  $this->success("删除成功");
	   }else{
		  $this->error("删除失败");
	   }
   }
}

