<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Db;
/**
 * 地址模型控制器
 */
class Forget extends Base {

	 /* 取消订单 */
	public function index(){
		if($_POST){
			
			 $username=isset($_POST["username"])?safe_replace($_POST["username"]):"";//过滤
             if(empty($username)){
		         $this->error('用户名不能为空');
	         }           
			 $data["username"]=$username;
             if(!Db::name("user")->where($data)->select())	{
				 $this->error("用户名不存在！");
               				 
			 }
             if(!isset($_POST["verify"])){
			      $this->error("验证码不能为空！");
		          
		     } 
			  $verify=isset($_POST["verify"])?safe_replace($_POST["verify"]):"";//过滤
			  if(!captcha_check($verify)){
				    $this->error("验证码输入错误！");  
				  
			  }
			session('username',$username);
			$url=url("forget/index");
		    $this->success("提交成功",$url); 
		}else{
		  if(empty(session('username'))){
			
			 $this->redirect("user/forget"); 
		  }
		
		   session("send_code",$this->random());
			
		   $this->assign('code',session("send_code"));
		   return $this->fetch();
		}
	}
	public function verify(){
		if($_POST){
			
			 $username=isset($_POST["username"])?safe_replace($_POST["username"]):"";//过滤
             if(empty($username)){
		         $this->error('用户名不能为空');
	         }           
			 $data["username"]=$username;
             if(!Db::name("user")->where($data)->select())	{
				 $this->error("用户名不存在！");             				 
			 }
			 
             $mobile=isset($_POST["mobile"])?safe_replace($_POST["mobile"]):"";//过滤
             if(empty($mobile)){
		         $this->error('手机号码不能为空');
	         } 
             if(!preg_match("/1[34578]{1}\d{9}$/",$mobile)){
			  	      $this->error("手机号格式不正确！");
			 }	
			 $data["mobile"]=$mobile;
             if(!Db::name("user")->where($data)->find())	{
				 $this->error("手机号不存在！");            				 
			 }	
			 
			 $send_code=isset($_POST["mobile_code"])?safe_replace($_POST["mobile_code"]):"";//过滤
			/* 检测验证码 */
			if(!$send_code){
				$this->error("验证码不能为空！");
			} 
            if(($mobile!==$_SESSION['mobile'])&&($send_code!==$_SESSION['mobile_code'])){
				$this->error("验证码输入错误！");
			}   
			session('mobile',$mobile);
			session('username',$username);
			session('step',2);
			$url=url("forget/update");
		    $this->success("提交成功",$url); 
		}
	
	}
     public function update(){
	      if(empty(session('username'))){
			
			 $this->redirect("user/forget"); 
		  }
	      if(empty(session('username'))&&empty(session('mobile'))){
			
			 $this->redirect("forget/index"); 
		   }
		  
		   return $this->fetch();
		
	
    }
	public function over(){
	
	       if(empty(session('end'))){
			
			 $this->redirect("user/forget"); 
		   }
		  
		   return $this->fetch();
		
	
    }
	public function submit(){
		if($_POST){
			
			 $username=session('username')?safe_replace(session('username')):"";//过滤
             if(empty($username)){
		         $this->error('用户名不能为空');
	         }           
			 $data["username"]=$username;
             if(!Db::name("user")->where($data)->select())	{
				 $this->error("用户名不存在！");             				 
			 }		 
             $mobile=session('mobile')?safe_replace(session('mobile')):"";//过滤
             if(empty($mobile)){
		         $this->error('手机号码不能为空');
	         } 
             if(!preg_match("/1[34578]{1}\d{9}$/",$mobile)){
			  	      $this->error("手机号格式不正确！");
			 }	
			 $data["mobile"]=$mobile;
             if(!Db::name("user")->where($data)->find())	{
				 $this->error("手机号不存在！");            				 
			 }	
			 
			$password =safe_replace($_POST["password"]);//过滤
			 if(!$password){
			    $this->error("密码不能为空！");
			 }
			 if(strlen($password)<6) {
              $this->error("密码必须包含至少含有6个字符！");
               
             } 
			 $repassword =input("repassword");//过滤
			 if($repassword){ 
			    $repassword =safe_replace($_POST["repassword"]);//过滤
			 } 
             if(!$repassword){
			    $this->error("确认密码不能为空！");
			 }
			 if($repassword!==$password) {
                 $this->error("密码与确认密码不符合！");
              
                 
			 }  
		
			 //$map['mobile']=safe_replace($mobile);
            $save['password']=encode($password);
            $res =db('user')->where($data)->field("password")->update($save);
            if($res){
				session('mobile',null);
			    session('username',null);
			    session('end',3);
                $this->success("修改密码成功！","forget/over");
            }else{
                $this->error("修改失败！");
            }
		}
		    
		    return $this->fetch();
	}
	
	
   public  function random($length = 6 , $numeric = 0) {
	PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
	if($numeric) {
		$hash = sprintf('%0'.$length.'d', mt_rand(0, pow(10, $length) - 1));
	} else {
		$hash = '';
		$chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789abcdefghjkmnpqrstuvwxyz';
		$max = strlen($chars) - 1;
		for($i = 0; $i < $length; $i++) {
			$hash .= $chars[mt_rand(0, $max)];
		}
	}
	return $hash;
}

  
   
}
