<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Db;
/**
 * 地址模型控制器
 */
class Shop extends Home {

 /**
 * 店铺首页
 * $id 店铺ID
 */
	public function index(){
	    $id=safe_replace(input('id'));
        if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		 }	
	
		$map[]=["id",'=',intval($id)];
		$map[]=["status",'=',4];
		//店铺信息
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
		    $this->error('店铺被封禁或审核未通过！');
		}	
		Db::name("shop")->where($map)->setInc("view");
		$this->assign('info',$info);  
		unset($map);
		$map["shop_id"]=$id;
		 //幻灯片
		$field = 'id,title,url,cover_id';
	    $slide_list=lists('ShopSlide',$map,5,"id desc",$field);
		$this->assign("slide_list",$slide_list);
        //销售top5
		unset($field);
		$field = 'id,title,price,cover_id,sales,comments';
	    $sales_list=lists('goods',$map,5,"sales desc",$field);
		$this->assign("sales_list",$sales_list);

		//人气top5 
		unset($field);
		$field = 'id,title,price,cover_id,view,comments,sales';
	    $view_list=lists('goods',$map,5,"view desc",$field);
		$this->assign("view_list",$view_list);
		unset($map);
		 $map["shop_id"]=(int)$id;
		//推荐商品
		$map["status"]=1;
		$field = 'id,title,price,cover_id,sales,comments';
	    $position_list=lists('goods',$map,10,"id desc",$field);
		$this->assign("position_list",$position_list);

		//新品 
		unset($field);
		$map["position"]=2;
		$field = 'id,title,price,cover_id,view,comments,sales';
	    $id_list=lists('goods',$map,6,"id desc",$field);
		$this->assign("id_list",$id_list);
		
         //商品分类
        unset($map);
		$map["pid"]=0; $map["shop_id"]=intval($id);
		$field = 'id,title';
	    $cate_list=lists('shopCategory',$map,20,"id desc",$field);
		$this->assign("cate_list",$cate_list);
        
		$this->meta_title = '店铺首页';
		$this->assign('meta_title',$this->meta_title);  
		 return $this->fetch();
		 
	}
 /**
 * 商品列表
 * $id 自定义商品分类ID
 */
   public function lists(){
	   $shopid=safe_replace(input('shopid'));
        if(!($shopid && is_numeric($shopid))){
		       $this->error('ID错误！');
		 }	
	    
		$map[]=["id",'=',intval($shopid)];
		$map[]=["status",'=',4];
		//店铺信息
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
		    $this->error('店铺被封禁或审核未通过！');
		}	
		Db::name("shop")->where($map)->setInc("view");
		$this->assign('info',$info);  
		
		unset($info);
	   unset($map);
        $id=safe_replace(input('id'));
        if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		 }	
		
		
		$map["id"]=$id;
		$info=Db::name("shopCategory")->where($map)->find();
		if(!$info){
		    $this->error('店铺分类不存在！');
		}
	
		unset($map);
		//关键字
	    $order="";$sort="";$listsort="";
        $order=safe_replace(input("order"));
        $sort=safe_replace(input("sort"));
		$order=$order?$order:"id";
        $sort=$sort?$sort:"desc";
        if($sort&&$sort=="asc"){
		  $rankType="desc";
		}
		if($sort&&$sort=="desc"){
		  $rankType="asc";
		}
        if($order&&$sort){
			$listsort="{$order} {$sort}";
		};
		$keyword= input('keyword');//获取搜索内容
		$keyword=safe_replace($keyword);//过滤
		$map[]=['title','like','%'.$keyword.'%'];
		$map[]=["cate_id",'=',$id];
		
        $listsort=$listsort?$listsort:"id desc";
	    $res=getLists('goods',$map,5,$listsort);
		$this->assign('res',$res);
		$this->meta_title = '商品列表';
		//关键字输出
		$this->assign('sort',$sort);
        $this->assign('order',$order);
		$this->assign('rankType',$rankType);
        //销售top5
		$field = 'id,title,price,cover_id,sales,comments';
	    $sales_list=lists('goods','',5,"sales desc",$field);
		$this->assign("sales_list",$sales_list);

		//人气top5 
		unset($field);
		$field = 'id,title,price,cover_id,view,comments,sales';
	    $view_list=lists('goods','',5,"view desc",$field);
		$this->assign("view_list",$view_list);
		
         //商品分类
        unset($map);
		$map["pid"]=0;
		$field = 'id,title';
	    $cate_list=lists('shopCategory',$map,20,"id desc",$field);
		$this->assign("cate_list",$cate_list);
         
		$this->assign('meta_title',$this->meta_title);  
	    return $this->fetch();
		 
	}
 /**
 * 所有商品
 * $id 店铺ID
 */
   public function whole($id=""){
        $id=safe_replace(intval($id));
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		}	
		
		$map["id"]=$id;
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
		    $this->error('ID错误！');
		}
		$this->assign('info',$info); 
		unset($map);
        $keyword= input('keyword');//获取搜索内容
		$keyword=safe_replace($keyword);//过滤
		if($keyword){
			$map[]=['title','like','%'.$keyword.'%'];
		}
		
		//关键字
	    $order="";$sort="";$listsort="";
        $order=safe_replace(input("order"));
        $sort=safe_replace(input("sort"));
		$order=$order?$order:"id";
        $sort=$sort?$sort:"desc";
        if($sort&&$sort=="asc"){
		  $rankType="desc";
		}
		if($sort&&$sort=="desc"){
		  $rankType="asc";
		}
        if($order&&$sort){
			$listsort="{$order} {$sort}";
		};
		$map[]=["shop_id",'=',$id];
        $listsort=$listsort?$listsort:"id desc";
	    $res=getLists('goods',$map,5,$listsort);
		$this->assign('res',$res);

		$this->meta_title = '商品列表';
		//关键字输出
		$this->assign('sort',$sort);
        $this->assign('order',$order);
		$this->assign('rankType',$rankType);
        //销售top5
		$field = 'id,title,price,cover_id,sales,comments';
	    $sales_list=lists('goods','',5,"sales desc",$field);
		$this->assign("sales_list",$sales_list);

		//人气top5 
		unset($field);
		$field = 'id,title,price,cover_id,view,comments,sales';
	    $view_list=lists('goods','',5,"view desc",$field);
		$this->assign("view_list",$view_list);
		
         //商品分类
        unset($map);
		$map["pid"]=0;
		$field = 'id,title';
	    $cate_list=lists('shopCategory',$map,20,"id desc",$field);
		$this->assign("cate_list",$cate_list);
         
		$this->assign('meta_title',$this->meta_title);  
	    return $this->fetch();
		 
	}
	public function step1($id=""){
		 if(!is_login()) {
		    $this->redirect("User/login");
		}
		$uid=is_login();	
		$map["uid"]=$uid;
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			   $this->meta_title = '申请开店';
		       $this->assign('meta_title',$this->meta_title);
			   $condition["pid"]=0;
               $list=Db::name("category")->where($condition)->select();
			   $this->assign('list',$list); 
			   
			    $array=["北京","上海","天津","重庆","河北","山西","内蒙古","辽宁","吉林","黑龙江","江苏","浙江","安徽","福建","江西","山东","河南","湖北","湖南","广东","广西","海南","四川","贵州","云南","西藏","陕西","甘肃","青海","宁夏","新疆","台湾","香港","澳门"];
   
        $this->assign("list2",$array);
			   
		       return $this->fetch();
		 }else{
			 $where["id"]=$info["id"];
			 if($info&$info["status"]==1){
				$this->redirect( "shop/step2",$where );
			 }
			 if($info["status"]==2){
				   $this->redirect( "shop/step3",$where );
			 }
			 if($info["status"]==3){
				 $this->redirect( "shop/step4",$where );
			 }if($info["status"]==4){
				 $this->redirect( "shop/step4",$where );
			 }
		
		 }
	}
  /* 取消订单 */
	public function step2($id=""){
		
		 if(!is_login()) {
		    $this->redirect("User/login");
		}$id=safe_replace(intval($id));
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		 }			
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;
		$map['status']=1;
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
		$this->assign('info', $info);
		$this->meta_title = '上传资料';
		$this->assign('meta_title',$this->meta_title);
		return $this->fetch();
	} 
	/* 取消订单 */
	public function step3($id=""){
		 if(!is_login()) {
		    $this->redirect("User/login");
		}$id=safe_replace(intval($id));
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		 }			
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;//用户id
		$map['status']=2;//用户id
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
		$where["id"]=$id;
		$where["step"]=4;
		  //去退货
		$info["url"]=url( "shop/step4",$where);

		$this->assign('info', $info);
		$this->meta_title = '上传资料';
		$this->assign('meta_title',$this->meta_title);
		return $this->fetch();
	}
	public function step4($id=""){
		 if(!is_login()) {
		    $this->redirect("User/login");
		}$id=safe_replace(intval($id));
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		}
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;//用户id
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
		$where["id"]=$id;
		  //去退货
		$info["url"]=url( "shop/modify",$where);
		$this->assign('info', $info);
		$this->meta_title = '已提交';
		$this->assign('meta_title',$this->meta_title);
		return $this->fetch();
	}
	public function modify($id=""){
		 if(!is_login()) {
		    $this->redirect("User/login");
		}$id=safe_replace(intval($id));
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		}
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;//用户id
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
		 $condition["pid"]=0;
               $list=Db::name("category")->where($condition)->select();
			   $this->assign('list',$list);
		$this->assign('info', $info);
		$this->meta_title = '修改资料';
		$this->assign('meta_title',$this->meta_title);
		return $this->fetch();
	}
	//申请注册
	 public function  add(){
	      if(!is_login()) {
		      $this->redirect("User/login");
		  }	
		  $uid=is_login();		
		  $data["title"]=safe_replace(input("title"));
		  //$cover_id=input("cover_id");
		  //if(!($cover_id && is_numeric($cover_id))){
		      // $this->error('店铺头像未上传！');
		   //}
		 // $data["cover_id"]=$cover_id;
          $category_id=safe_replace(input("category_id"));
		  if(!($category_id && is_numeric($category_id))){
		       $this->error('分类ID错误！');
		   }
		   if(db("shop")->where($data)->select()){
		      $this->error('店铺已存在！');
		   }
		   if(!input("location")){
		       $this->error('注册地错误！');
		   }
		  $data["category_id"]=intval($category_id);
		  $data["description"]=safe_replace(input("description"));
		  $data["status"]=1; 
		  $data["location"]=safe_replace(input("location"));
		  $data["uid"]=$uid;
		  $data["create_time"]=time();
		  $res=Db::name("shop")->insertGetId($data);
		  $where["id"]=$res;
		  $url=url( "shop/step2",$where);
    	  if($res){
		      $this->success("已保存！",$url);
		   }else{
			    $this->error("申请 失败！");
		   } 
		 
	 } 
	//填写资料
	 public function  update($id=""){
	     if(!is_login()) {
		    $this->redirect("User/login");
		}$id=safe_replace(intval($id));	
		if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		}
		 if(!input("username")){
		       $this->error('名称不能为空！');
		 }
		if(!input("card_num")){
		       $this->error('身份证号码不能为空！');
		 }   
		if(!input("card")){
		       $this->error('身份证照不能为空！');
		} 
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;//用户id
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
	    $Shop =new \app\index\model\Shop;
        // 过滤post数组中的非数据表字段数据
        $res=$Shop->allowField(true)->where($map)->update($_POST);
		$where["id"]=$info["id"];
		  //去退货
		$url=url( "shop/step3",$where);
    	 if($res){
		       $this->success("提交成功！",$url);
		  }else{
			    $this->error("申请 失败！");
		 } 
		 
	 } 

	//填写资料
	 public function set($id=""){
	     if(!is_login()) {
		    $this->redirect("User/login");
		}	
		if(!($id && is_numeric($id))){
		    $this->error('ID错误！');
		}
		
		$uid=is_login();	
		$map['id']=$id;//用户id
		$map['uid']=$uid;//用户id
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}
	    $Shop =new \app\index\model\Shop;
        // 过滤post数组中的非数据表字段数据
        $res=$Shop->allowField(true)->where($map)->update($_POST);
		$where["id"]=$id;
		  //去退货
		$url=url( "shop/step2",$where);
    	 if($res){
		       $this->success("上传成功！",$url);
		  }else{
			    $this->error("未更改！");
		 } 
		 
	 }
   	//申请注册
	 public function  save($id=""){
	     if(!is_login()) {
		      $this->redirect("User/login");
		  }	
		 if(!($id && is_numeric($id))){
		       $this->error('ID错误！');
		}
		$uid=is_login();	
		$map['id']=$id;
		$map['uid']=$uid;
		$info=Db::name("shop")->where($map)->find();
		if(!$info){
			$this->error( "无对应的店铺" );
		}	
	    if($_POST["agree"]){
			$data["agree"]=1;
			$data["status"]=3;
			$res=db("Shop")->where($map)->update($data);
			$where["id"]=$info["id"];
			 //去退货
			$url=url( "shop/step4",$where);
			if($res){
				  $this->success("上传成功！",$url);
			  }else{
				  $this->error("申请 失败！");
			} 
	   } 
	 }
}
