/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : mall

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2020-09-16 08:35:21
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for by_account_log
-- ----------------------------
DROP TABLE IF EXISTS `by_account_log`;
CREATE TABLE `by_account_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `content` varchar(225) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COMMENT='资金变化表';

-- ----------------------------
-- Records of by_account_log
-- ----------------------------

-- ----------------------------
-- Table structure for by_ad
-- ----------------------------
DROP TABLE IF EXISTS `by_ad`;
CREATE TABLE `by_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `place` varchar(225) NOT NULL DEFAULT '' COMMENT '位置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='广告表';

-- ----------------------------
-- Records of by_ad
-- ----------------------------
INSERT INTO `by_ad` VALUES ('1', '广告1', 'goods/lists?id=107', '1', '0', '0', '1', '218', '0', '0');
INSERT INTO `by_ad` VALUES ('2', '广告2', 'goods/lists?id=107', '2', '0', '0', '1', '220', '0', '0');
INSERT INTO `by_ad` VALUES ('3', '广告3', 'goods/lists?id=107', '6', '0', '0', '1', '221', '0', '0');
INSERT INTO `by_ad` VALUES ('4', '广告4', 'goods/lists?id=107', '4', '0', '0', '1', '222', '0', '0');
INSERT INTO `by_ad` VALUES ('6', '手机数码广告1', 'goods/lists?id=52', '1', '0', '0', '1', '234', '107', '0');
INSERT INTO `by_ad` VALUES ('7', '手机数码2', 'goods/lists?id=52', '2', '0', '0', '1', '235', '107', '0');
INSERT INTO `by_ad` VALUES ('8', '手机数码广告3', 'goods/lists?id=107', '2', '0', '0', '1', '446', '107', '0');
INSERT INTO `by_ad` VALUES ('9', '食品饮料', 'goods/lists?id=107', '33', '0', '0', '1', '237', '52', '0');
INSERT INTO `by_ad` VALUES ('10', '头部banner', 'goods/detail?id=177', '99', '0', '0', '1', '281', '0', '0');
INSERT INTO `by_ad` VALUES ('11', '手机端广告1', 'http://demo.yershop.com/wap/goods/detail/id/168.html', '9', '0', '0', '1', '365', '0', '0');
INSERT INTO `by_ad` VALUES ('12', '手机端广告2', 'http://demo.yershop.com/wap/goods/detail/id/203.html', '10', '0', '0', '1', '366', '0', '0');
INSERT INTO `by_ad` VALUES ('13', '手机端广告位1', 'goods/detail?id=203', '100', '0', '0', '1', '367', '0', '0');
INSERT INTO `by_ad` VALUES ('14', '手机端广告位2', 'goods/detail?id=166', '101', '0', '0', '1', '368', '0', '0');
INSERT INTO `by_ad` VALUES ('15', '手机端广告位3	', 'http://wx.bycms.cn/weixin/weixin/index/id/1.html', '1', '0', '0', '1', '369', '0', '0');
INSERT INTO `by_ad` VALUES ('17', '56', '56', '1', '0', '0', '1', '444', '0', '0');
INSERT INTO `by_ad` VALUES ('18', 'banner广告位1', 'goods/detail?id=166', '3', '0', '0', '1', '447', '0', '0');
INSERT INTO `by_ad` VALUES ('19', 'banner广告位2', 'goods/detail?id=203', '3', '0', '0', '1', '448', '0', '0');
INSERT INTO `by_ad` VALUES ('20', '魔方广告位1', 'goods/detail?id=225', '5', '0', '0', '1', '449', '0', '0');
INSERT INTO `by_ad` VALUES ('21', '魔方广告位2', 'goods/detail?id=204', '5', '0', '0', '1', '450', '0', '0');
INSERT INTO `by_ad` VALUES ('22', '魔方广告位3', 'goods/detail?id=205', '5', '0', '0', '1', '451', '0', '0');
INSERT INTO `by_ad` VALUES ('23', '魔方广告位4', 'goods/detail?id=206', '5', '0', '0', '1', '452', '0', '0');
INSERT INTO `by_ad` VALUES ('24', '魔方广告位5', 'goods/detail?id=208', '5', '0', '0', '1', '453', '0', '8');

-- ----------------------------
-- Table structure for by_address
-- ----------------------------
DROP TABLE IF EXISTS `by_address`;
CREATE TABLE `by_address` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(225) DEFAULT NULL,
  `mobile` varchar(225) DEFAULT NULL,
  `province` varchar(225) DEFAULT NULL,
  `city` varchar(225) DEFAULT NULL,
  `area` varchar(225) DEFAULT NULL,
  `address` varchar(225) DEFAULT NULL,
  `username` varchar(225) DEFAULT NULL,
  `phone` varchar(225) DEFAULT NULL,
  `zipcode` varchar(225) DEFAULT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8 COMMENT='收件人地址表';

-- ----------------------------
-- Records of by_address
-- ----------------------------
INSERT INTO `by_address` VALUES ('75', '', '6545664', '天津', '天津市', '河西区', '64', '644+46', '', '', '0', '0', '71');
INSERT INTO `by_address` VALUES ('74', '', '6545664', '天津', '天津市', '河西区', '64', '644+46', '', '', '0', '0', '71');
INSERT INTO `by_address` VALUES ('73', '', '6545664', '天津', '天津市', '河西区', '64', '644+46', '', '', '0', '0', '71');
INSERT INTO `by_address` VALUES ('72', '', '6545664', '天津', '天津市', '河西区', '64', '644+46', '', '', '0', '0', '71');
INSERT INTO `by_address` VALUES ('76', null, 'vbnn', '北京', '东城区', '', 'hjjjj', 'ghjjj', null, null, '0', '0', '75');
INSERT INTO `by_address` VALUES ('78', null, 'vhhjjjj', '广西', '南宁', '青秀区', 'chjjjj', '', null, null, '0', '0', '76');
INSERT INTO `by_address` VALUES ('79', null, '13254364576', '天津', '天津市', '河西区', '234536457', '3246574676', '', null, '0', '0', '77');
INSERT INTO `by_address` VALUES ('80', null, '18512831195', '北京', '东城区', '', '大理古城山水间三期', 'liuzhong', null, null, '0', '0', '78');
INSERT INTO `by_address` VALUES ('108', null, 'rytryrtytr', '浙江省', '杭州市', '西湖区', 'trrety', '123', null, null, '0', '0', '74');
INSERT INTO `by_address` VALUES ('109', null, 'rtyrt', '浙江省', '杭州市', '西湖区', 'rtyrt', 'ryrt', null, null, '0', '0', '74');
INSERT INTO `by_address` VALUES ('110', null, 'uiouioui', '浙江省', '杭州市', '西湖区', 'uiouioui', 'uyiyuiy', null, null, '0', '0', '79');
INSERT INTO `by_address` VALUES ('111', null, 'werwerw', '浙江省', '杭州市', '西湖区', 'werwe', 'werwer', null, null, '0', '0', '81');
INSERT INTO `by_address` VALUES ('112', null, '13212341234', '河北省', '石家庄市', '长安区', 'sdfsdfsdfsdf333336666', 'sdfsdfsdfsdf', null, null, '0', '0', '84');
INSERT INTO `by_address` VALUES ('113', null, '', '浙江省', '杭州市', '西湖区', '', '', null, null, '0', '0', '90');
INSERT INTO `by_address` VALUES ('114', null, '13212356321', '广东省', '广州市', '海珠区', 'safasfasfa', 'sdfs', null, null, '0', '0', '85');
INSERT INTO `by_address` VALUES ('115', null, '13245678536', '广东省', '广州市', '海珠区', 'chjkkkki', 'cghjjjj', null, null, '0', '0', '104');
INSERT INTO `by_address` VALUES ('116', null, '13621896206', '上海市', '上海市市辖区', '浦东新区', '光明路', '苟帅', null, null, '0', '0', '95');

-- ----------------------------
-- Table structure for by_answer
-- ----------------------------
DROP TABLE IF EXISTS `by_answer`;
CREATE TABLE `by_answer` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `keyword` varchar(225) NOT NULL DEFAULT '' COMMENT '关键词',
  `type` varchar(225) DEFAULT NULL COMMENT '回复类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='被动回复表';

-- ----------------------------
-- Records of by_answer
-- ----------------------------
INSERT INTO `by_answer` VALUES ('1', 'wx643f65392e6a5e8c', '1', 'text');
INSERT INTO `by_answer` VALUES ('2', 'wx643f65392e6a5e8c', '2', 'news');
INSERT INTO `by_answer` VALUES ('3', 'wx643f65392e6a5e8c', '3', 'images');
INSERT INTO `by_answer` VALUES ('4', 'wx643f65392e6a5e8c', '5', 'text');

-- ----------------------------
-- Table structure for by_attachment
-- ----------------------------
DROP TABLE IF EXISTS `by_attachment`;
CREATE TABLE `by_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `exts` varchar(225) DEFAULT NULL,
  `type` smallint(2) NOT NULL DEFAULT '0',
  `size` varchar(225) DEFAULT NULL,
  `oldname` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=748 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='附件表';

-- ----------------------------
-- Records of by_attachment
-- ----------------------------
INSERT INTO `by_attachment` VALUES ('1', '/public/uploads/picture/2014-09-02/5405e0f3b1705.png', '', '36d077267c76901835c07eb98f43647f', '0f7ce26261cb7a81dcfb14e057982ec60fa3a6e0', '1', '1409671411', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('118', '/public/uploads/picture/2015-09-18/55faf2ac353a5.png', '', '02273f1c88dd109270b8658aaa50adb7', '03072f5a6ad8edebed49f2a2aaab0946fee911dc', '1', '1442509483', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('119', '/public/uploads/picture/2015-09-18/55faf2b05d1f7.jpg', '', 'f19560a9dce4d5856f8bd94ec4f94f7c', 'df47fefa04680b0f94333f73538369ac1a02a705', '1', '1442509488', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('120', '/public/uploads/picture/2015-09-18/55fbea25cce43.png', '', 'db6d75524ce0adbe0aa392e89db2c967', 'd5c00b55590a673c72f32bfef5f248eea2541b48', '1', '1442572836', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('121', '/public/uploads/picture/2015-09-18/55fbed7b89833.jpg', '', '85e8b28767fb07b93c2f0325c885890d', '680153590e2abd8b0751758b0b10fe488d8a132a', '1', '1442573691', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('122', '/public/uploads/picture/2015-09-18/55fbfa12f0583.jpg', '', '165a1f4c326e02c467e56017eb31341e', 'a41ebd344dc020cd14d49b45d48b05c0b5a014ae', '1', '1442576914', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('123', '/public/uploads/picture/2015-09-18/55fbfb43e5845.jpg', '', '75e3a97a6bf974893c19b188d5952eca', '192bffee7bcb4ff8682a4ebf0bc97cf6f1cfcdc4', '1', '1442577219', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('124', '/public/uploads/picture/2015-09-18/55fbfba4b5a30.jpg', '', '29e0e481e4642156586f85de4a56f241', '077944d495a9e2a9106ae86a4bed7b36a3200183', '1', '1442577316', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('125', '/public/uploads/picture/2015-09-18/55fbfbd2a1254.png', '', 'ce4df64ea0cf6ea03b1814ba39c9ac14', 'd4ac154920c0c2ec9bc37735066a38baf9b35042', '1', '1442577362', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('126', '/public/uploads/picture/2015-09-18/55fbfbfea4cec.jpg', '', '5750a2e4be1eabb48c387c1701285c19', 'bc2fad2962e2ed53ef9c7fd1d54ea2f183e3744b', '1', '1442577406', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('127', '/public/uploads/picture/2015-09-18/55fbfca553025.jpg', '', 'e5897ab5d0968219417382de088c9b51', 'fe762a96ec7b66522a573397aef54dfac790efb4', '1', '1442577572', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('128', '/public/uploads/picture/2015-09-18/55fbfefe3b46c.jpg', '', '9d63a525c72228392bc9995a2dccb804', '1128a13c77f928305aa74250c73849e0fdb66baa', '1', '1442578173', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('129', '/public/uploads/picture/2015-09-18/55fc06d81d259.png', '', 'c74ead772a7ef411298074a2cfda3b00', 'f81103f81942d48c7a08da5a7b902ae73c0d032f', '1', '1442580183', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('130', '/public/uploads/picture/2015-09-18/55fc0db08a573.png', '', '74e827839f9878de5ee040f501d44e24', '64da8dfcdeb5c91f21ef8c8d4e28e16c0988ec99', '1', '1442581936', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('131', '/public/uploads/picture/2015-09-18/55fc14f557c2b.jpg', '', 'febb770b7148c2554c89dc8f2aad47ef', '58e1fff98127903f37d0034ad4bfb89e1b24220b', '1', '1442583797', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('132', '/public/uploads/picture/2015-09-18/55fc25884bc20.jpg', '', '7ffeea044ed576b6c399aea469013995', '2491a13692bffc0ba29dcac65d0a51cb81870ec3', '1', '1442588039', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('133', '/public/uploads/picture/2015-09-18/55fc268046052.jpg', '', '2c2884ec3ad9671595f2c8ba7ec83e61', '208e93d8b664ad2c6cb0ed6613b85cb17d15735c', '1', '1442588287', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('134', '/public/uploads/picture/2015-09-18/55fc26c302c6c.jpg', '', 'cd8289f0b5e2cce081e64cf728a3dad9', '77359403d19d2d7758a38816ffc25e92de6f5071', '1', '1442588354', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('135', '/public/uploads/picture/2015-09-19/55fd2ce92c34a.png', '', 'beee2b89375a6b029a82fa8ca5ba6a07', '96f52b0bdb148e5bc82c9a195a36a7592784ae7c', '1', '1442655464', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('136', '/public/uploads/picture/2015-09-19/55fd2d31abbfb.png', '', '54529b60a5b44ae3551a316c51c5c732', 'a9b4dd9e304d61b8b0af4eed2204899b360d3958', '1', '1442655537', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('137', '/public/uploads/picture/2015-09-19/55fd2d7a24d4d.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '1', '1442655609', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('138', '/public/uploads/picture/2015-09-19/55fd2da7b3e38.jpg', '', 'fc9680b79fdb0a6b4cef1973f2b3e975', '9ea0bdb5c85eb2bbf31a2ea68f40b11b1e1e9363', '1', '1442655655', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('139', '/public/uploads/picture/2015-09-19/55fd2e824761b.png', '', '460076b755fda8aeab55b154d878eb2b', 'e06d5861fa44e30f3f74f912bf43b45039a4c9a1', '1', '1442655873', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('140', '/public/uploads/picture/2015-09-19/55fd2ea40f9eb.jpg', '', 'd82b42da9052d7d0c9941607966bd68b', '89e4ce2c36bcd3fb0ba08675d6193ef49a7018cc', '1', '1442655907', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('141', '/public/uploads/picture/2015-09-19/55fd2ed346ca2.jpg', '', '325a5b1e756187740de7876ee8217624', 'edb5db598f9e88235113d1238d882572b01b99fc', '1', '1442655954', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('142', '/public/uploads/picture/2015-09-19/55fd2f09a9c17.png', '', 'a0be05f9d4637a9369f21ec2a350a3d8', '05428eced8ae43f41d59a3ed1d616473a1c35e39', '1', '1442656009', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('143', '/public/uploads/picture/2015-09-19/55fd2f35c4d1b.png', '', 'cb5e8cc8a5e7835b1ce44cfe070c10d7', '3ba85af092c0a04b70fe5625f7bae675158c3fc2', '1', '1442656047', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('144', '/public/uploads/picture/2015-09-19/55fd2f63de016.jpg', '', '46b06af357db9e001e210da953943cad', '69310227d7099372e31924f6d0405489e52eb492', '1', '1442656099', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('145', '/public/uploads/picture/2015-09-19/55fd30a01fb76.png', '', 'e18a8be03a63aaf98309caeebcbb3ff6', '7143023f23da57142f4b2129201d65d06a0320ed', '1', '1442656415', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('146', '/public/uploads/picture/2015-09-19/55fd3107afdb4.png', '', '5f0924eb289d82e72956f98d5782cf34', 'b64e99156213aba7cec70a52796cac7c535aaf46', '1', '1442656519', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('147', '/public/uploads/picture/2015-09-21/55fef291d180a.jpg', '', '6bfa43f557fd45417a7332a1c76b9d0c', '4f5fc0d9bb35b82c7ed3524eb94cb00b9f0efb80', '1', '1442771601', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('148', '/public/uploads/picture/2015-09-21/55ff9daf421da.jpg', '', '8aa0ca20041c70a3a7ed52439ad17e87', '2104acbddfb7896074262f06629cd531eb051f44', '1', '1442815398', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('149', '/public/uploads/picture/2015-10-01/560c353d68810.jpg', '', 'd368c2e6e97c5ef8d3c5a28f9ff86272', '2ea38906b4184f9f3040ae2ca4e46ec057aac4a1', '1', '1443640636', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('150', '/public/uploads/picture/2015-10-01/560c36d681ed7.png', '', '89f9dc5aba8d7c17e33b54f8820113c8', '6d16bcd39d6af6cbca714833dd003ade7753f196', '1', '1443641046', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('151', '/public/uploads/picture/2015-10-01/560c398857058.jpg', '', 'cf14018177659b6cebc315af384e557d', '0bc0eccb7a8c0e41ec199adf74f42ca29b9426f2', '1', '1443641735', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('152', '/public/uploads/picture/2015-10-01/560c482057eb2.jpg', '', '0b79878d6e22f05624dc67c924a1403f', '4001e0b6b42b7e643dce002ec5825a22322e1518', '1', '1443645472', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('153', '/public/uploads/picture/2015-10-01/560c497ba8fab.jpg', '', '3cb499f3f19b59a4f764f854ffda13fd', 'a9c334d0aa35040fbb6eb5c87055557cd22f3899', '1', '1443645819', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('154', '/public/uploads/picture/2015-10-01/560c4c6a574dd.jpg', '', 'dbaa89d809c1f11a6be878a901cc6ef3', 'ee8a749b0cfe74f315710d08293499c104ccebc6', '1', '1443646570', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('155', '/public/uploads/picture/2015-10-01/560c4fbe38b7e.jpg', '', '3f6be98ec909bd442df7f3bdec87837d', '2febfa649830eaa2347dc78f3dcb3fc9f1ab0b31', '1', '1443647422', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('156', '/public/uploads/picture/2017-03-18/1489833130.jpg', '', '', '', '1', '1489833130', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('157', '/public/uploads/picture/2017-03-18/1489833193.jpg', '', '', '', '1', '1489833193', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('158', '/public/uploads/picture/2017-03-18/1489833237.jpg', '', '', '', '1', '1489833237', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('159', '/public/uploads/picture/2017-04-10/58ea728da93d6.jpg', '', 'fbe492e4129c37da9108def74891ffd3', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('160', '/public/uploads/picture/2017-04-10/58ea72ad6b7b5.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('161', '/public/uploads/picture/2017-04-10/58ea7344ba5bb.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('162', '/public/uploads/picture/2017-04-10/58ea7373323c6.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('163', '/public/uploads/picture/2017-04-10/58ea739e5b426.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('164', '/public/uploads/picture/2017-04-10/58ea741c3c765.jpg', '', '3f2f102f8b1de130101378eb6e6f523c', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('165', '/public/uploads/picture/2017-04-10/58ea74c57144b.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('166', '/public/uploads/picture/2017-04-10/58ea750990423.jpg', '', '60be787ff19aacedca764129855f883d', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('167', '/public/uploads/picture/2017-04-10/58ea755252f92.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('168', '/public/uploads/picture/2017-04-10/58ea75e593ffa.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('169', '/public/uploads/picture/2017-04-10/58ea76457e34b.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('170', '/public/uploads/picture/2017-04-10/58ea76f647856.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('171', '/public/uploads/picture/2017-04-10/58ea77613b2e9.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('172', '/public/uploads/picture/2017-04-10/58ea7889a445b.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('173', '/public/uploads/picture/2017-04-10/58ea78f890081.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('174', '/public/uploads/picture/2017-04-10/58ea7bf470e88.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('175', '/public/uploads/picture/2017-04-27/59015a64a416f.png', '', 'aad4be71840752d8dbbc39e74c9acaef', '1533a5279b892edc075dd6413c7aa08ad2cd2978', '0', '1493260900', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('176', '/public/uploads/picture/2017-04-27/59015ab2ae242.png', '', '3c15c452b0634481b5ed31ece7fe8476', 'b941e181d8ac55a3229f9606f6b5589444bee74c', '0', '1493260978', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('177', '/public/uploads/picture/2017-04-27/59015ade4a915.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1493261022', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('178', '/public/uploads/picture/2017-04-27/59015b313731d.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1493261105', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('179', '/public/uploads/picture/2017-04-27/59015c4f2bbc7.png', '', 'e0f4a9ff4018d01a8ea9f372405426e7', 'e05fa3c0980421692ac72d712deb92e6f84b026a', '0', '1493261391', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('180', '/public/uploads/picture/2017-04-27/59015d2658d3a.jpg', '', '29e0e481e4642156586f85de4a56f241', '077944d495a9e2a9106ae86a4bed7b36a3200183', '0', '1493261606', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('181', '/public/uploads/picture/2017-04-27/590160abd4107.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493262507', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('182', '/public/uploads/picture/2017-04-27/5901af9262172.jpg', '', 'd82b42da9052d7d0c9941607966bd68b', '89e4ce2c36bcd3fb0ba08675d6193ef49a7018cc', '0', '1493282706', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('183', '/public/uploads/picture/2017-04-27/5901afa1842a0.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493282721', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('184', '/public/uploads/picture/2017-04-27/5901b05425217.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493282900', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('185', '/public/uploads/picture/2017-04-27/5901b0cc729e2.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493283020', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('186', '/public/uploads/picture/2017-04-27/5901b3c6051cc.jpg', '', '59895df03becec239632a8fa0c36b8d3', '90e3e6767eb9e6fa375fe4c0f6fc3fd62e4e5fc4', '0', '1493283782', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('187', '/public/uploads/picture/2017-06-03/593246bab5b4e.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496467130', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('188', '/public/uploads/picture/2017-06-03/593246f20b365.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496467186', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('189', '/public/uploads/picture/2017-06-03/59324718d315d.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496467224', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('190', '/public/uploads/picture/2017-06-03/5932473a94475.png', '', 'dba4ab759283ce84a2f3db1c38a0251a', '0c58990f7e2dd14d866d8aa71acd3ad8cca2a3cb', '0', '1496467258', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('191', '/public/uploads/picture/2017-06-03/59324765b3951.png', '', 'dba4ab759283ce84a2f3db1c38a0251a', '0c58990f7e2dd14d866d8aa71acd3ad8cca2a3cb', '0', '1496467301', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('192', '/public/uploads/picture/2017-06-03/5932476f2b323.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496467311', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('193', '/public/uploads/picture/2017-06-03/593247cf5672d.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496467407', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('194', '/public/uploads/picture/2017-06-03/593247d5aff74.png', '', 'a658f9e720b91e0ea69d99b978bed497', '8e8a697972a17ceebc85367230c4516eac977dc9', '0', '1496467413', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('195', '/public/uploads/picture/2017-06-03/5932481da3fc0.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496467485', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('196', '/public/uploads/picture/2017-06-03/593248237106d.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496467491', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('197', '/public/uploads/picture/2017-06-03/593251449e0b3.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496469828', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('198', '/public/uploads/picture/2017-06-03/5932514c5e670.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496469836', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('199', '/public/uploads/picture/2017-06-03/593252a70d3ca.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496470183', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('200', '/public/uploads/picture/2017-06-03/593252ab19939.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496470187', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('201', '/public/uploads/picture/2017-06-04/59339aaf30f7e.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496554159', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('202', '/public/uploads/picture/2017-06-04/59339ab4443fe.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496554164', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('203', '/public/uploads/picture/2017-06-04/59339abc39975.jpg', '', 'e91d7b93dd88d79eb1ab6029b9420e87', '4f15a3484196aabef7996f514ec9079ff815a4b3', '0', '1496554172', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('204', '/public/uploads/picture/2017-06-08/59382de1f0c4d.png', '', 'ade99d895ebc71b9a9e52a08a451c1f6', 'b363746196da6d7a37ae7bb6cc79157dc0118b40', '0', '1496853985', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('205', '/public/uploads/picture/2017-06-08/59382e6989c21.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496854121', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('206', '/public/uploads/picture/2017-06-08/5938321d1a0b8.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496855069', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('207', '/public/uploads/picture/2017-06-10/593af2721c9df.jpg', '', '5332d77768534c1863d87e4660ee207b', '3c21386aa1f23038b1240680b079bed2f2a12097', '0', '1497035378', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('208', '/public/uploads/picture/2017-06-10/593af2ab73069.jpg', '', '618f425810aaee83564b2d5384c43500', '176ed5bdbf544fe8a67a1c53480b0d3a546fdb4b', '0', '1497035435', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('209', '/public/uploads/picture/2017-06-10/593b473d21a8d.jpg', '', 'f40309d6e909e5475c063c8502c9776c', '38f96bd641cdf99db3b5ce3e9fe568c98439f517', '0', '1497057085', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('210', '/public/uploads/picture/2017-06-10/593b4858b844a.jpg', '', 'a57729b797ee17917c3e5436d6d31e6d', '432e8e755ae89588dfd074f2dddb7f9829cde2af', '0', '1497057368', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('211', '/public/uploads/picture/2017-06-10/593b48aa7b751.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057450', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('212', '/public/uploads/picture/2017-06-10/593b48c2917d3.jpg', '', '38affd4dcca613daba37db6a9f91b204', 'e6c87d94ad2051d2072dbfc3f3c5108fc8195a21', '0', '1497057474', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('213', '/public/uploads/picture/2017-06-10/593b48cf7a6a4.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057487', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('214', '/public/uploads/picture/2017-06-10/593b48dfd1488.jpg', '', '244b2e7c149af541900f5c9cb3c17e0a', '5ba16ece19ec85058ee5ee62d6bd153305d0afbd', '0', '1497057503', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('215', '/public/uploads/picture/2017-06-10/593b49029c41a.jpg', '', '83ca6fb33e1164d3e4699849237bff10', 'de3c7e6e0ed67243daafa611c4b15d97a90789be', '0', '1497057538', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('216', '/public/uploads/picture/2017-06-10/593b492a3f651.jpg', '', 'f3e60ab5a1c41f282080c306301cc354', '6df99acc50de9fa7e48d1d274a9a0b3d4da14e32', '0', '1497057578', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('217', '/public/uploads/picture/2017-06-10/593b49652e774.jpg', '', '9633a7a94a30bb85ee65feb7745fd074', '93974ac32e0aa464213b5429827101606f251158', '0', '1497057637', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('218', '/public/uploads/picture/2017-06-10/593b49da4be8a.png', '', '6a42de2dc1c015959b6876fd0091bd99', 'acb907a5ef5c6310b526dd6f999d59b73147b164', '0', '1497057754', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('219', '/public/uploads/picture/2017-06-10/593b4a23873de.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057827', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('220', '/public/uploads/picture/2017-06-10/593b4be76841c.png', '', '4b34ceeb1a62296ac07c69542fc60ccc', 'e05700fdb4425424464cdfb551e7351b7ec76dbd', '0', '1497058279', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('221', '/public/uploads/picture/2017-06-10/593b4ca5b86a6.jpg', '', '570c2bc96240f2868469caebaee43565', 'b0c7aefc53eed5851f2c535d6df315ecd450e791', '0', '1497058469', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('222', '/public/uploads/picture/2017-06-10/593b4cc8b89ee.jpg', '', '8895b46e241808531b52238a66261e34', '8a775a65ac498e52c1277d9fc7c5de2659b906f1', '0', '1497058504', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('223', '/public/uploads/picture/2017-06-10/593b4cf227b4e.jpg', '', '0af856cabcfb15c409defd5a90900494', 'f5e0c8518d74761f4284c7dc6438b996e7f33817', '0', '1497058546', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('224', '/public/uploads/picture/2017-06-10/593b4e639e660.jpg', '', 'ece3884ec7bf17a0580b8856dde247aa', 'd5f0ce295385e2c2e8b546ccd55d1ceb29e69507', '0', '1497058915', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('225', '/public/uploads/picture/2017-06-10/593b50055245a.jpg', '', '239769d731a5eb504f1183722cde4d09', 'f53c5cf8f1300a5a247fff354a111d7008c56a4b', '0', '1497059333', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('226', '/public/uploads/picture/2017-06-10/593b5029f0f5c.jpg', '', '8f6dee1b82487959a34961811d6871f6', 'eed689df64393a45ab645b7b1299fe4486fd53b9', '0', '1497059369', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('227', '/public/uploads/picture/2017-06-10/593b505453a4c.jpg', '', 'fc13447d9ea4269f9067c68e0fa86eef', 'd80d828010ed09799809ae2b7c37f7aea33cdac9', '0', '1497059412', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('228', '/public/uploads/picture/2017-06-10/593b508b77396.jpg', '', '50d4f43e24ad56331fc41f05cf51699c', '55da9adddc17420b24832675704806babd21fcf6', '0', '1497059467', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('229', '/public/uploads/picture/2017-06-10/593b533ad646a.jpg', '', '2f6d092829f2dbe171479fae26dc7e02', '4368a3051dd1c35f3c60deacc9490004a28320f9', '0', '1497060154', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('230', '/public/uploads/picture/2017-06-10/593b56975d266.jpg', '', 'ece3884ec7bf17a0580b8856dde247aa', 'd5f0ce295385e2c2e8b546ccd55d1ceb29e69507', '0', '1497061015', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('231', '/public/uploads/picture/2017-06-11/593c6f8d00bae.jpg', '', 'eacd46878b826fc8f377282eced38a5f', '350435aff3cf87b546781320f3c67de752d0a88e', '0', '1497132941', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('232', '/public/uploads/picture/2017-06-11/593c7095e1a73.jpg', '', '205670ac324cd1516da2928cb4dbdebe', '58b847589eeeab811402f2047458a63d38197f45', '0', '1497133205', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('233', '/public/uploads/picture/2017-06-11/593c71358b2f8.jpg', '', '1268ecb74cdb78e9a00c3a7bd9f07cbb', '36664122deddb0965ad78f2263b69f85c273cde4', '0', '1497133365', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('234', '/public/uploads/picture/2017-06-11/593c71d37866e.jpg', '', '24d12a976c2b0387ed6582dd87f5dfd9', '0795b56a9ad6cf91ad98cbde4ba78243c864921b', '0', '1497133523', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('235', '/public/uploads/picture/2017-06-11/593c71e910c8f.jpg', '', '85e921f8946870510435ebc9d9cb073b', '8511e201fca9fc8561373d1c63bfc57b45043438', '0', '1497133545', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('236', '/public/uploads/picture/2017-06-11/593c722b21ce0.jpg', '', '8f6c1ab8a368c4608ad88b6f2e3d990a', 'd6971cef2494d08a9e2374b23df8f03228061579', '0', '1497133611', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('237', '/public/uploads/picture/2017-06-11/593c73c59ba63.jpg', '', '2643aad1795d84a1ddd4651584888533', 'f5481198541d4facc063c113d19cb24256369139', '0', '1497134021', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('238', '/public/uploads/picture/2017-06-11/593d619bc1557.png', '', '8a0e828202dc55abb32d581a650a499b', '7b2d18fc2c9970997fd65d8bc8fef11973b108ba', '0', '1497194907', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('239', '/public/uploads/picture/2017-06-11/593d66418184d.jpg', '', 'cd8289f0b5e2cce081e64cf728a3dad9', '77359403d19d2d7758a38816ffc25e92de6f5071', '0', '1497196097', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('240', '/public/uploads/picture/2017-06-11/593d668a0b335.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1497196170', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('241', '/public/uploads/picture/2017-06-11/593d66b13441e.png', '', '642eb204ee46c475e3663ee66412a064', 'a065eca31d835a10ad0739990aef1833858ed57c', '0', '1497196209', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('252', '/public/uploads/picture/2017-11-04/1509764207.jpg', '', '', '', '1', '1509764207', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('253', '/public/uploads/picture/2017-11-04/1509764309.jpg', '', '', '', '1', '1509764309', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('243', '/public/uploads/picture/2017-06-12/593d720ba26b3.jpg', '', 'cc40bf13003b952c6cb8fe128522ec21', '21984feb63ba59495d667e2ed765e0e4d90dbd94', '0', '1497199115', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('244', '/public/uploads/picture/2017-06-18/594565c199a91.jpg', '', '685b1133c2fb45479218b2acd6a8b852', 'd8145cf3becdf9e0fdeb24b43cd0cee1518a4699', '0', '1497720257', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('245', '/public/uploads/picture/2017-06-18/5945725f48956.png', '', 'a16a431bbb61e642b18b940b1473dfd3', 'f4398e7803c4a9bf6430e44be134f335f46a0914', '0', '1497723487', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('260', '/public/uploads/picture/2017-11-04/1509767146.jpg', '', '', '', '1', '1509767146', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('261', '/public/uploads/picture/2017-11-04/1509767152.jpg', '', '', '', '1', '1509767152', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('258', '/public/uploads/picture/2017-11-04/1509766137.jpg', '', '', '', '1', '1509766137', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('259', '/public/uploads/picture/2017-11-04/1509767121.jpg', '', '', '', '1', '1509767121', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('256', '/public/uploads/picture/2017-11-04/1509764517.jpg', '', '', '', '1', '1509764517', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('257', '/public/uploads/picture/2017-11-04/1509764709.jpg', '', '', '', '1', '1509764709', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('254', '/public/uploads/picture/2017-11-04/1509764326.jpg', '', '', '', '1', '1509764326', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('255', '/public/uploads/picture/2017-11-04/1509764474.jpg', '', '', '', '1', '1509764474', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('250', '/public/uploads/picture/2017-10-04/59d49d19e995b.png', '', 'e52be7fe9f76f0b2d20440d01c75b51a', 'b9294fe039b5daedf352ef1c9d0a4dc269c4f423', '0', '1507106073', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('251', '/public/uploads/picture/2017-10-07/59d88b31c73ea.gif', '', '927d4a2ecfc5380f4b35efe256104c9f', '14644b7ff9b25cd5ec113e3ab7659290b7c81f6a', '0', '1507363633', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('262', '/public/uploads/picture/2017-11-04/1509767768.jpg', '', '', '', '1', '1509767768', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('263', '/public/uploads/picture/2017-11-04/1509767785.jpg', '', '', '', '1', '1509767785', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('264', '/public/uploads/picture/2017-11-04/1509767848.jpg', '', '', '', '1', '1509767848', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('265', '/public/uploads/picture/2017-11-04/1509767938.jpg', '', '', '', '1', '1509767938', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('266', '/public/uploads/picture/2017-11-04/1509768029.jpg', '', '', '', '1', '1509768029', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('267', '/public/uploads/picture/2017-11-04/1509768183.jpg', '', '', '', '1', '1509768183', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('268', '/public/uploads/picture/2017-11-04/1509768213.jpg', '', '', '', '1', '1509768213', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('269', '/public/uploads/picture/2017-11-04/1509768258.jpg', '', '', '', '1', '1509768258', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('270', '/public/uploads/picture/2017-11-04/1509768364.jpg', '', '', '', '1', '1509768364', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('271', '/public/uploads/picture/2017-11-04/1509768371.jpg', '', '', '', '1', '1509768371', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('272', '/public/uploads/picture/2017-11-04/1509768375.jpg', '', '', '', '1', '1509768375', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('273', '/public/uploads/picture/2017-11-04/1509768484.jpg', '', '', '', '1', '1509768484', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('274', '/public/uploads/picture/2017-11-04/1509768556.jpg', '', '', '', '1', '1509768556', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('275', '/public/uploads/picture/2017-11-04/1509768616.jpg', '', '', '', '1', '1509768616', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('276', '/public/uploads/picture/2017-11-04/1509768733.jpg', '', '', '', '1', '1509768733', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('277', '/public/uploads/picture/2017-11-04/1509768791.jpg', '', '', '', '1', '1509768791', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('278', '/public/uploads/picture/2017-11-04/1509768797.jpg', '', '', '', '1', '1509768797', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('279', '/public/uploads/picture/2017-11-04/1509768842.jpg', '', '', '', '1', '1509768842', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('280', '/public/uploads/picture/2017-11-04/1509768864.jpg', '', '', '', '1', '1509768864', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('281', '/public/uploads/picture/2017-11-04/1509768989.jpg', '', '', '', '1', '1509768989', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('282', '/public/uploads/picture/2017-11-04/1509774996.jpg', '', '', '', '1', '1509774996', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('283', '/public/uploads/picture/2017-11-04/1509775088.jpg', '', '', '', '1', '1509775088', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('284', '/public/uploads/picture/2017-11-04/1509775098.jpg', '', '', '', '1', '1509775098', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('285', '/public/uploads/picture/2017-11-04/1509776126.jpg', '', '', '', '1', '1509776126', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('286', '/public/uploads/picture/2017-11-04/1509776284.jpg', '', '', '', '1', '1509776284', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('287', '/public/uploads/picture/2017-11-04/1509776887.jpg', '', '', '', '1', '1509776887', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('288', '/public/uploads/picture/2017-11-04/1509776974.jpg', '', '', '', '1', '1509776974', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('289', '/public/uploads/picture/2017-11-04/1509776995.jpg', '', '', '', '1', '1509776995', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('290', '/public/uploads/picture/2017-11-04/1509777008.jpg', '', '', '', '1', '1509777008', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('291', '/public/uploads/picture/2017-11-04/1509777060.jpg', '', '', '', '1', '1509777060', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('292', '/public/uploads/picture/2017-11-04/1509777944.jpg', '', '', '', '1', '1509777944', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('293', '/public/uploads/picture/2017-11-04/1509778821.jpg', '', '', '', '1', '1509778821', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('294', '/public/uploads/picture/2017-11-04/1509778828.jpg', '', '', '', '1', '1509778828', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('295', '/public/uploads/picture/2017-11-04/1509788391.jpg', '', '', '', '1', '1509788391', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('296', '/public/uploads/picture/2017-11-04/1509788398.jpg', '', '', '', '1', '1509788398', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('297', '/public/uploads/picture/2017-11-04/1509788431.jpg', '', '', '', '1', '1509788431', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('298', '/public/uploads/picture/2017-11-04/1509788440.jpg', '', '', '', '1', '1509788440', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('299', '/public/uploads/picture/2017-11-04/1509788469.jpg', '', '', '', '1', '1509788469', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('300', '/public/uploads/picture/2017-11-04/1509788610.jpg', '', '', '', '1', '1509788610', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('301', '/public/uploads/picture/2017-11-04/1509788628.jpg', '', '', '', '1', '1509788628', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('302', '/public/uploads/picture/2017-11-04/1509788835.jpg', '', '', '', '1', '1509788835', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('303', '/public/uploads/picture/2017-11-04/1509788851.jpg', '', '', '', '1', '1509788851', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('304', '/public/uploads/picture/2017-11-04/1509788982.jpg', '', '', '', '1', '1509788982', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('305', '/public/uploads/picture/2017-11-04/1509789038.jpg', '', '', '', '1', '1509789038', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('306', '/public/uploads/picture/2017-11-04/1509789055.jpg', '', '', '', '1', '1509789055', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('307', '/public/uploads/picture/2017-11-04/1509789339.jpg', '', '', '', '1', '1509789339', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('308', '/public/uploads/picture/2017-11-04/1509789347.jpg', '', '', '', '1', '1509789347', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('309', '/public/uploads/picture/2017-11-04/1509789494.jpg', '', '', '', '1', '1509789494', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('310', '/public/uploads/picture/2017-11-04/1509790026.jpg', '', '', '', '1', '1509790026', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('311', '/public/uploads/picture/2017-11-04/1509790033.jpg', '', '', '', '1', '1509790033', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('312', '/public/uploads/picture/2017-11-04/1509790249.jpg', '', '', '', '1', '1509790249', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('313', '/public/uploads/picture/2017-11-04/1509790257.jpg', '', '', '', '1', '1509790257', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('314', '/public/uploads/picture/2017-11-04/1509793893.jpg', '', '', '', '1', '1509793893', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('315', '/public/uploads/picture/2017-11-04/1509793969.jpg', '', '', '', '1', '1509793969', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('316', '/public/uploads/picture/2017-11-04/1509794136.jpg', '', '', '', '1', '1509794136', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('317', '/public/uploads/picture/2017-11-04/1509794168.jpg', '', '', '', '1', '1509794168', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('318', '/public/uploads/picture/2017-11-04/1509794190.jpg', '', '', '', '1', '1509794190', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('319', '/public/uploads/picture/2017-11-04/1509794471.jpg', '', '', '', '1', '1509794471', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('320', '/public/uploads/picture/2017-11-04/1509794559.jpg', '', '', '', '1', '1509794559', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('321', '/public/uploads/picture/2017-11-04/1509794563.jpg', '', '', '', '1', '1509794563', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('322', '/public/uploads/picture/2017-11-04/1509794567.jpg', '', '', '', '1', '1509794567', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('323', '/public/uploads/picture/2017-11-04/1509794971.jpg', '', '', '', '1', '1509794971', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('324', '/public/uploads/picture/2017-11-04/1509794984.jpg', '', '', '', '1', '1509794984', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('325', '/public/uploads/picture/2017-11-04/1509795815.jpg', '', '', '', '1', '1509795815', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('326', '/public/uploads/picture/2017-11-04/1509796230.jpg', '', '', '', '1', '1509796230', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('327', '/public/uploads/picture/2017-11-04/1509796692.jpg', '', '', '', '1', '1509796692', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('328', '/public/uploads/picture/2017-11-06/1509907313.jpg', '', '', '', '1', '1509907313', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('329', '/public/uploads/picture/2017-11-06/1509907337.jpg', '', '', '', '1', '1509907337', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('330', '/public/uploads/picture/2017-11-06/1509907467.jpg', '', '', '', '1', '1509907467', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('331', '/public/uploads/picture/2017-11-06/1509907531.jpg', '', '', '', '1', '1509907531', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('332', '/public/uploads/picture/2017-11-06/1509907751.jpg', '', '', '', '1', '1509907751', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('333', '/public/uploads/picture/2017-11-06/1509907987.jpg', '', '', '', '1', '1509907987', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('334', '/public/uploads/picture/2017-11-06/1509908117.jpg', '', '', '', '1', '1509908117', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('335', '/public/uploads/picture/2017-11-06/1509908203.jpg', '', '', '', '1', '1509908203', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('336', '/public/uploads/picture/2017-11-06/1509908206.jpg', '', '', '', '1', '1509908206', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('337', '/public/uploads/picture/2017-11-06/1509908277.jpg', '', '', '', '1', '1509908277', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('338', '/public/uploads/picture/2017-11-06/1509909114.jpg', '', '', '', '1', '1509909114', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('339', '/public/uploads/picture/2017-11-06/1509909120.jpg', '', '', '', '1', '1509909120', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('340', '/public/uploads/picture/2017-11-06/1509909193.jpg', '', '', '', '1', '1509909193', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('341', '/public/uploads/picture/2017-11-06/1509909295.jpg', '', '', '', '1', '1509909295', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('342', '/public/uploads/picture/2017-11-06/1509909380.jpg', '', '', '', '1', '1509909380', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('343', '/public/uploads/picture/2017-11-06/1509909396.jpg', '', '', '', '1', '1509909396', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('344', '/public/uploads/picture/2017-11-06/1509909486.jpg', '', '', '', '1', '1509909486', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('345', '/public/uploads/picture/2017-11-06/1509909558.jpg', '', '', '', '1', '1509909558', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('346', '/public/uploads/picture/2017-11-06/1509909638.jpg', '', '', '', '1', '1509909638', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('347', '/public/uploads/picture/2017-11-06/1509909645.jpg', '', '', '', '1', '1509909645', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('348', '/public/uploads/picture/2017-11-06/1509909698.jpg', '', '', '', '1', '1509909698', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('349', '/public/uploads/picture/2017-11-06/1509910076.jpg', '', '', '', '1', '1509910076', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('350', '/public/uploads/picture/2017-11-06/1509936498.jpg', '', '', '', '1', '1509936498', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('351', '/public/uploads/picture/2017-11-06/1509936564.jpg', '', '', '', '1', '1509936564', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('352', '/public/uploads/picture/2017-11-06/1509936614.jpg', '', '', '', '1', '1509936614', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('353', '/public/uploads/picture/2017-11-06/1509936698.jpg', '', '', '', '1', '1509936698', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('354', '/public/uploads/picture/2017-11-06/1509936841.jpg', '', '', '', '1', '1509936841', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('355', '/public/uploads/picture/2017-11-06/1509937018.jpg', '', '', '', '1', '1509937018', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('356', '/public/uploads/picture/2017-11-06/1509937133.jpg', '', '', '', '1', '1509937133', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('357', '/public/uploads/picture/2017-11-06/1509937244.jpg', '', '', '', '1', '1509937244', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('358', '/public/uploads/picture/2017-11-19/1511030221.jpg', '', '', '', '1', '1511030221', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('359', '/public/uploads/picture/2017-11-27/1511717517.jpg', '', '', '', '1', '1511717517', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('360', '/public/uploads/picture/2017-11-27/1511717612.jpg', '', '', '', '1', '1511717612', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('361', '/public/uploads/picture/2017-11-27/1511717656.jpg', '', '', '', '1', '1511717656', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('362', '/public/uploads/picture/2017-11-27/1511722538.jpg', '', '', '', '1', '1511722538', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('363', '/public/uploads/picture/2017-11-27/1511722690.jpg', '', '', '', '1', '1511722690', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('364', '/public/uploads/picture/2017-11-27/1511723165.jpg', '', '', '', '1', '1511723165', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('365', '/public/uploads/picture/2017-11-27/1511724412.jpg', '', '', '', '1', '1511724412', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('366', '/public/uploads/picture/2017-11-27/1511724464.jpg', '', '', '', '1', '1511724464', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('367', '/public/uploads/picture/2017-12-05/1512476667.jpg', '', '', '', '1', '1512476667', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('368', '/public/uploads/picture/2017-12-05/1512476751.jpg', '', '', '', '1', '1512476751', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('369', '/public/uploads/picture/2017-12-05/1512476796.jpg', '', '', '', '1', '1512476796', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('370', '/public/uploads/picture/2017-12-13/1513112743.jpg', '', '', '', '1', '1513112743', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('371', '/public/uploads/picture/2017-12-13/1513113066.jpg', '', '', '', '1', '1513113066', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('372', '/public/uploads/picture/2017-12-13/1513113397.jpg', '', '', '', '1', '1513113397', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('373', '/public/uploads/picture/2017-12-13/1513113513.jpg', '', '', '', '1', '1513113513', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('374', '/public/uploads/picture/2017-12-13/1513113938.jpg', '', '', '', '1', '1513113938', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('375', '/public/uploads/picture/2017-12-13/1513113981.jpg', '', '', '', '1', '1513113981', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('376', '/public/uploads/picture/2017-12-13/1513114264.jpg', '', '', '', '1', '1513114264', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('377', '/public/uploads/picture/2017-12-13/1513114393.jpg', '', '', '', '1', '1513114393', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('378', '/public/uploads/picture/2017-12-13/1513114409.jpg', '', '', '', '1', '1513114409', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('379', '/public/uploads/picture/2017-12-13/1513114476.jpg', '', '', '', '1', '1513114476', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('380', '/public/uploads/picture/2017-12-13/1513120326.jpg', '', '', '', '1', '1513120326', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('381', '/public/uploads/picture/2017-12-13/1513120363.jpg', '', '', '', '1', '1513120363', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('382', '/public/uploads/picture/2017-12-13/1513120464.jpg', '', '', '', '1', '1513120464', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('383', '/public/uploads/picture/2017-12-13/1513120596.jpg', '', '', '', '1', '1513120596', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('384', '/public/uploads/picture/2017-12-13/1513120740.jpg', '', '', '', '1', '1513120740', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('385', '/public/uploads/picture/2017-12-13/1513120854.jpg', '', '', '', '1', '1513120854', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('386', '/public/uploads/picture/2017-12-13/1513121077.jpg', '', '', '', '1', '1513121077', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('387', '/public/uploads/picture/2017-12-31/1514712571.jpg', '', '', '', '1', '1514712571', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('388', '/public/uploads/picture/2017-12-31/1514712577.jpg', '', '', '', '1', '1514712577', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('389', '/public/uploads/picture/2017-12-31/1514712584.jpg', '', '', '', '1', '1514712584', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('390', '/public/uploads/picture/2017-12-31/1514712588.jpg', '', '', '', '1', '1514712588', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('391', '/public/uploads/picture/2017-12-31/1514713465.jpg', '', '', '', '1', '1514713465', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('392', '/public/uploads/picture/2017-12-31/1514713482.jpg', '', '', '', '1', '1514713482', '', '0', '', '');
INSERT INTO `by_attachment` VALUES ('393', '/public/uploads/picture/20180323/acbad249da651b0d33f71117873e8c9c.jpg', '', '', '', '1', '1521764062', 'jpg', '1', '15416', '5717a95ae4b0a3162509557b.230x230.jpg');
INSERT INTO `by_attachment` VALUES ('394', '/public/uploads/picture/20180323/47c63440b95cae2352fc4e49f0fcdedf.jpg', '', '', '', '1', '1521767405', 'jpg', '1', '15416', '5717a95ae4b0a3162509557b.230x230.jpg');
INSERT INTO `by_attachment` VALUES ('395', '/public/uploads/picture/20180413/91ff269f56e24c7039ce12e746997190.jpg', '', '', '', '1', '1523575865', 'jpg', '1', '41557', 'timg (1).jpg');
INSERT INTO `by_attachment` VALUES ('396', '/public/uploads/picture/20180413/9ff4f0f9c0c238d76fb5cc7baf9a8b84.jpg', '', '', '', '1', '1523575964', 'jpg', '1', '44074', 'timg.jpg');
INSERT INTO `by_attachment` VALUES ('397', '/public/uploads/picture/20180414/c8bb05d69bec5c7dcef6facb2e0e2fcb.jpg', '', '', '', '1', '1523682189', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `by_attachment` VALUES ('398', '/public/uploads/picture/20180414/6bbcbf2e0444b2c9d96011df7df0d30d.jpg', '', '', '', '1', '1523682372', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `by_attachment` VALUES ('399', '/public/uploads/picture/20180414/cb7a9f7734f2f74fe34353e4c9949391.jpg', '', '', '', '1', '1523682440', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `by_attachment` VALUES ('400', '/public/uploads/picture/20180414/dc874694ef85fd2418e0b9ccc82de88c.jpg', '', '', '', '1', '1523682838', 'jpg', '1', '54455', '100108492174748689picA_1.jpg');
INSERT INTO `by_attachment` VALUES ('401', '/public/uploads/picture/20180414/28fc25a63346acf9b5b8b970bda09e87.jpg', '', '', '', '1', '1523682969', 'jpg', '1', '204121', '0000000000-000000000174748689_1.jpg');
INSERT INTO `by_attachment` VALUES ('402', '/public/uploads/picture/20180414/50162a2561bc8f310d6b47019c26deca.jpg', '', '', '', '1', '1523683074', 'jpg', '1', '124454', '0000000000-000000000124818483_1.jpg');
INSERT INTO `by_attachment` VALUES ('403', '/public/uploads/picture/20180414/63d13d912e9ca954dd9d774b4700de58.jpg', '', '', '', '1', '1523683123', 'jpg', '1', '136282', '0000000000-000000000176305331_2.jpg');
INSERT INTO `by_attachment` VALUES ('404', '/public/uploads/picture/20180414/36130ca5c1f35c44d792a86e659752f8.jpg', '', '', '', '1', '1523683188', 'jpg', '1', '171305', '0000000000-000000000633296969_1.jpg');
INSERT INTO `by_attachment` VALUES ('405', '/public/uploads/picture/20180414/6488198bd60105ca810b51cd43ed65d4.jpg', '', '', '', '1', '1523683349', 'jpg', '1', '90456', '0000000000-000000000109802658_1.jpg');
INSERT INTO `by_attachment` VALUES ('406', '/public/uploads/picture/20180414/3b2748c6064c2a97df143d64b0d77a2a.jpg', '', '', '', '1', '1523683401', 'jpg', '1', '120063', '0000000000-000000000155520007_1.jpg');
INSERT INTO `by_attachment` VALUES ('407', '/public/uploads/picture/20180414/269e5ebbf26dc27ef736af73dbb30744.jpg', '', '', '', '1', '1523683526', 'jpg', '1', '185549', '0000000000-000000000149659011_2.jpg');
INSERT INTO `by_attachment` VALUES ('408', '/public/uploads/picture/20180414/9a9c6735441c4a55741e37dcfb0ced3c.jpg', '', '', '', '1', '1523683580', 'jpg', '1', '556689', '0000000000-000000000127191157_2.jpg');
INSERT INTO `by_attachment` VALUES ('409', '/public/uploads/picture/20180414/f1b42dc00a45f036d57c1769c9af5334.jpg', '', '', '', '1', '1523683669', 'jpg', '1', '144609', '0000000000-000000000626364062_2.jpg');
INSERT INTO `by_attachment` VALUES ('410', '/public/uploads/picture/20180414/cd648d4c0437eaaf4082b2e362968f16.jpg', '', '', '', '1', '1523683796', 'jpg', '1', '188295', '0000000000-000000000104243087_2.jpg');
INSERT INTO `by_attachment` VALUES ('411', '/public/uploads/picture/20180423/c077995da5cb03ad6170bf05fbe003a3.jpg', '', '', '', '1', '1524462010', 'jpg', '1', '97654', 'TB25JBbmXXXXXatXXXXXXXXXXXX_!!309886021.jpg_400x400.jpg_.webp (1).jpg');
INSERT INTO `by_attachment` VALUES ('412', '/public/uploads/picture/20180423/b16c11f1fec684da9d58c4701c599239.jpg', '', '', '', '1', '1524462630', 'jpg', '1', '135645', 'TB2bABzXbOJ.eBjy1XaXXbNupXa_!!309886021.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('413', '/public/uploads/picture/20180423/9246d4a68d11c896c3227b38f3774755.jpg', '', '', '', '1', '1524462791', 'jpg', '1', '58772', 'TB2dKdObbuWBuNjSszgXXb8jVXa_!!75859100.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('414', '/public/uploads/picture/20180423/97a92378147a5e0fa99f99d3ad469e66.jpg', '', '', '', '1', '1524462915', 'jpg', '1', '84375', 'TB2dKdObbuWBuNjSszgXXb8jVXa_!!75859100.jpg');
INSERT INTO `by_attachment` VALUES ('415', '/public/uploads/picture/20180423/88b1507e45e52f8e0bc25a852380a7f5.jpg', '', '', '', '1', '1524462920', 'jpg', '1', '194069', 'TB2MuhObbuWBuNjSszgXXb8jVXa_!!75859100.jpg');
INSERT INTO `by_attachment` VALUES ('416', '/public/uploads/picture/20180423/a59056150b392f96e171cc719c2aed95.jpg', '', '', '', '1', '1524462934', 'jpg', '1', '21027', 'TB2_B82bb9YBuNjy0FgXXcxcXXa_!!75859100.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('417', '/public/uploads/picture/20180423/70ae44fa50f463816ecf4b51dbb86b60.jpg', '', '', '', '1', '1524463104', 'jpg', '1', '41056', 'TB2AsS2eSBYBeNjy0FeXXbnmFXa_!!827873810-0-item_pic.jpg_430x430q90.jpg');
INSERT INTO `by_attachment` VALUES ('418', '/public/uploads/picture/20180423/9bd36425fd91b57699e3e57d9beb2f98.jpg', '', '', '', '1', '1524463180', 'jpg', '1', '47397', 'TB2NFBMeGmWBuNjy1XaXXXCbXXa_!!827873810.jpg_430x430q90.jpg');
INSERT INTO `by_attachment` VALUES ('419', '/public/uploads/picture/20180423/b26f1dfede86dd2b998f4a9bb38e947d.jpg', '', '', '', '1', '1524463186', 'jpg', '1', '40025', 'TB2IMdnXLNZWeJjSZFpXXXjBFXa_!!1796610007.jpg_430x430q90.jpg');
INSERT INTO `by_attachment` VALUES ('420', '/public/uploads/picture/20180423/3f48f2fc3131515cdaae34561e9b29e1.jpg', '', '', '', '1', '1524471089', 'jpg', '1', '40025', 'TB2IMdnXLNZWeJjSZFpXXXjBFXa_!!1796610007.jpg_430x430q90.jpg');
INSERT INTO `by_attachment` VALUES ('421', '/public/uploads/picture/20180424/f2e58cc3735a92aea1c876a9b5b554c8.jpg', '', '', '', '1', '1524511385', 'jpg', '1', '37958', '5a51eb79N3d872884.jpg');
INSERT INTO `by_attachment` VALUES ('422', '/public/uploads/picture/20180424/189c1b0cc4bed79a2ea91dfb8bbdc86b.jpg', '', '', '', '1', '1524512335', 'jpg', '1', '127441', '5981d8b4N829af261.jpg');
INSERT INTO `by_attachment` VALUES ('423', '/public/uploads/picture/20180424/249a75cb67f90577cd6c015a83801383.jpg', '', '', '', '1', '1524512529', 'jpg', '1', '12812', '5ac242f2N70412aed.jpg');
INSERT INTO `by_attachment` VALUES ('424', '/public/uploads/picture/20180424/db6a6d9da0c4f66b58b3f2b4839abecc.jpg', '', '', '', '1', '1524512674', 'jpg', '1', '12686', '55f269bdNaeeed77c.jpg');
INSERT INTO `by_attachment` VALUES ('425', '/public/uploads/picture/20180428/e3e64e42c4a98a3c909ebe4bc2a3fd42.jpg', '', '', '', '1', '1524853505', 'jpg', '1', '8418', '590067a1Nc27f04fe.jpg');
INSERT INTO `by_attachment` VALUES ('426', '/public/uploads/picture/20180428/4f188be9f224b1b7c16c5683fa19b7b4.jpg', '', '', '', '1', '1524853541', 'jpg', '1', '20954', '59bb6677N70278118.jpg!q80.webp.jpg');
INSERT INTO `by_attachment` VALUES ('427', '/public/uploads/picture/20180428/a8521e612dede5a4e7a267d3eff36793.jpg', '', '', '', '1', '1524853610', 'jpg', '1', '37818', '5a72dec6N3bd64d43.jpg');
INSERT INTO `by_attachment` VALUES ('428', '/public/uploads/picture/20180428/d2b85c3d9ce98c1660a058fb73ca643d.jpg', '', '', '', '1', '1524853686', 'jpg', '1', '14408', '5a431eb6N0db60e76.jpg!q80.webp.jpg');
INSERT INTO `by_attachment` VALUES ('429', '/public/uploads/picture/20180428/08869bbbcadb8f5e5b0ad03bc9a05bc7.jpg', '', '', '', '1', '1524853734', 'jpg', '1', '23511', '58573635Nff99b235.jpg');
INSERT INTO `by_attachment` VALUES ('430', '/public/uploads/picture/20180428/2c4a0e1a614279b423bb8fd1a7d1d995.jpg', '', '', '', '1', '1524853778', 'jpg', '1', '56471', '5a51d14eNa115e050.jpg');
INSERT INTO `by_attachment` VALUES ('431', '/public/uploads/picture/20180428/e3ae61b47599d39fffc663b0ea959c57.jpg', '', '', '', '1', '1524853832', 'jpg', '1', '5962', '58b6744aNb11a6cc3.jpg!q90.jpg');
INSERT INTO `by_attachment` VALUES ('432', '/public/uploads/picture/20180428/1a4290c2ce145e329cfd66b9148faeb0.jpg', '', '', '', '1', '1524853939', 'jpg', '1', '11782', '53faaa96N2afb4c64.jpg!q90.webp.jpg');
INSERT INTO `by_attachment` VALUES ('433', '/public/uploads/picture/20180428/bbbfab8f19c0666f0308e5d9939dfeef.jpg', '', '', '', '1', '1524853993', 'jpg', '1', '45810', '5ae14aa8N65d4d369.jpg');
INSERT INTO `by_attachment` VALUES ('434', '/public/uploads/picture/20180428/4fbb69f6448066b36edd2c9d1fd17e0c.jpg', '', '', '', '1', '1524854014', 'jpg', '1', '40496', '5aa5fa4cNbeb988c9.jpg');
INSERT INTO `by_attachment` VALUES ('435', '/public/uploads/picture/20180428/844ef1a9300b4b362038eeb1f8b99809.jpg', '', '', '', '1', '1524866995', 'jpg', '1', '81203', '5a31e7f2Nbbbdf3db.jpg');
INSERT INTO `by_attachment` VALUES ('436', '/public/uploads/picture/20180428/22374078076e21990e8fb59177339548.jpg', '', '', '', '1', '1524867042', 'jpg', '1', '40496', '5aa5fa4cNbeb988c9.jpg');
INSERT INTO `by_attachment` VALUES ('440', '/public/uploads/picture/20180629/7a6aa50e7a5d316b0635b406d42cc05c.jpg', '', '', '', '1', '1530219007', 'jpg', '1', '40496', '22374078076e21990e8fb59177339548.jpg');
INSERT INTO `by_attachment` VALUES ('445', '/public/uploads/picture/20180716/d480a92b04e50dee9cd0086df793f624.jpg', '', '', '', '1', '1531735599', 'jpg', '1', '192857', 'TB1vkDZEhWYBuNjy1zkSutGGpXa.jpg_q100.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('444', '/public/uploads/picture/20180716/21f1a68e916aba08dc13a9093de6c05a.jpg', '', '', '', '1', '1531735540', 'jpg', '1', '192857', 'TB1vkDZEhWYBuNjy1zkSutGGpXa.jpg_q100.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('443', '/public/uploads/picture/20180710/713d296bf90bb19783c722472720263b.gif', '', '', '', '1', '1531195909', 'gif', '1', '3521', 'logo_pic.gif');
INSERT INTO `by_attachment` VALUES ('446', '/public/uploads/picture/20180716/66ae51d4b03b507d9d7181e20dde2b25.jpg', '', '', '', '1', '1531740353', 'jpg', '1', '23550', 'TB1_ZV3yHSYBuNjSspiSutNzpXa.jpg');
INSERT INTO `by_attachment` VALUES ('447', '/public/uploads/picture/20180716/4572ddf9f80200b2e9268176ca11d0fe.png', '', '', '', '1', '1531742409', 'png', '1', '35144', 'TB2f8NVu5CYBuNkHFCcXXcHtVXa_!!151-2-luban.png_240x5000q100.png');
INSERT INTO `by_attachment` VALUES ('448', '/public/uploads/picture/20180716/f500e6bbf5fccea20494f010696ec556.png', '', '', '', '1', '1531742438', 'png', '1', '27645', '56.png');
INSERT INTO `by_attachment` VALUES ('449', '/public/uploads/picture/20180716/4edfda71749ff3ca393945d279a34264.jpg', '', '', '', '1', '1531749847', 'jpg', '1', '190362', '1.webp.jpg');
INSERT INTO `by_attachment` VALUES ('450', '/public/uploads/picture/20180716/c4df671ab2b2ec635b06560ba4cbc92c.jpg', '', '', '', '1', '1531749877', 'jpg', '1', '192441', '2.webp.jpg');
INSERT INTO `by_attachment` VALUES ('451', '/public/uploads/picture/20180716/3926450e22a9866a9f139c8124f1876c.jpg', '', '', '', '1', '1531749982', 'jpg', '1', '136234', 'TB1XbKEEnlYBeNjSszcXXbwhFXa-476-538.jpg_500x1000q75s0.jpg_.webp.jpg');
INSERT INTO `by_attachment` VALUES ('452', '/public/uploads/picture/20180716/2bebe011960bf654cc113c40b0f50a5d.jpg', '', '', '', '1', '1531750016', 'jpg', '1', '178220', '4.webp.jpg');
INSERT INTO `by_attachment` VALUES ('453', '/public/uploads/picture/20180716/443ff53c4ba53ec9b1c24e6280708c5d.jpg', '', '', '', '1', '1531750042', 'jpg', '1', '149883', '5.webp.jpg');
INSERT INTO `by_attachment` VALUES ('454', '/public/uploads/picture/20180720/9be3903cd4babe24692ae70ac3237542.jpg', '', '', '', '1', '1532094389', 'jpg', '1', '175496', 'TB1NIErwsuYBuNkSmRySuwA3pXa.jpg');
INSERT INTO `by_attachment` VALUES ('455', '/public/uploads/picture/20180720/09d7d1dd7ac0d1058773fdd04473ce92.jpg', '', '', '', '1', '1532094536', 'jpg', '1', '245824', 'TB2Yg.sw_dYBeNkSmLyXXXfnVXa-1714128138.jpg');
INSERT INTO `by_attachment` VALUES ('456', '/public/uploads/picture/20180720/6c6b8f4f94f0ef457164c4d0d352ec1c.jpg', '', '', '', '1', '1532094675', 'jpg', '1', '103552', 'TB1FNzxDgmTBuNjy1XbXXaMrVXa-468-1236.jpg');
INSERT INTO `by_attachment` VALUES ('457', '/public/uploads/picture/20180720/271b4a7e77b4d7aaa9aee33a8a27e52b.jpg', '', '', '', '1', '1532094724', 'jpg', '1', '181576', 'TB1HS58EYSYBuNjSspiSutNzpXa.jpg');
INSERT INTO `by_attachment` VALUES ('458', '/public/uploads/picture/20180720/f390d772d0a337ceeb260f909d63b017.jpg', '', '', '', '1', '1532094867', 'jpg', '1', '189444', 'TB18UKMbuySBuNjy1zdXXXPxFXa-468-1236.jpg');
INSERT INTO `by_attachment` VALUES ('459', '/public/uploads/picture/20180720/181c99382fe478c5e537defc99f7e4cf.jpg', '', '', '', '1', '1532094898', 'jpg', '1', '116683', 'TB1uDEvJFXXXXbAXVXXvMNvHpXX-460-780.jpg');
INSERT INTO `by_attachment` VALUES ('460', '/public/uploads/picture/20180724/554511767008e4dd00fe33efff24b7cf.jpg', '', '', '', '1', '1532371918', 'jpg', '1', '103552', 'TB1FNzxDgmTBuNjy1XbXXaMrVXa-468-1236.jpg');
INSERT INTO `by_attachment` VALUES ('461', '/public/uploads/picture/20180724/1d8fcb5fb87097732ae7de3e944c71b4.jpg', '', '', '', '1', '1532372010', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `by_attachment` VALUES ('462', '/public/uploads/picture/20180724/07806cdeb1ab661bb1d939eca1bf05e8.jpg', '', '', '', '1', '1532372094', 'jpg', '1', '136400', '5b519547Nbe5180fc.jpg');
INSERT INTO `by_attachment` VALUES ('463', '/public/uploads/picture/20180724/39c3e67450ac4562196e6126a0b38c6a.jpg', '', '', '', '1', '1532372111', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `by_attachment` VALUES ('464', '/public/uploads/picture/20180724/e116a4808adea53c1e7a7cd12bdbfd2e.jpg', '', '', '', '1', '1532372164', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `by_attachment` VALUES ('465', '/public/uploads/picture/20180724/e3ff286c9686528d93c451b8f44125bf.jpg', '', '', '', '1', '1532372176', 'jpg', '1', '13960', '5b557c8dN76763b67.jpg');
INSERT INTO `by_attachment` VALUES ('466', '/public/uploads/picture/20190122/64fbec70ef9a340f75631c0efaed15a7.png', '', '', '', '1', '1548154110', 'png', '1', '4229', '贝云4.png');
INSERT INTO `by_attachment` VALUES ('467', '/public/uploads/picture/20190206/a8de1682674bffc23ae7142af949b4fe.jpg', '', '', '', '1', '1549425899', 'jpg', '1', '25841', 'u=1500915263,1513583227&fm=26&gp=0.jpg');
INSERT INTO `by_attachment` VALUES ('468', '/public/uploads/picture/20190206/3482bd10cf1cf045a46f19d62fe3440e.jpg', '', '', '', '1', '1549427293', 'jpg', '1', '12134', 'gg.jpg');
INSERT INTO `by_attachment` VALUES ('469', '/public/uploads/picture/20190206/cc03559f31206fc40c52977bb9136dfc.jpg', '', '', '', '1', '1549457718', 'jpg', '1', '39896', '1121373789-1_e_3.jpg');
INSERT INTO `by_attachment` VALUES ('532', '/public/uploads/picture/20191209/3720dd698089bd3c83e8f190e9b81301.jpg', '', '', '', '1', '1575873035', 'jpg', '1', '94187', '1580139244-1_k_1.jpg');
INSERT INTO `by_attachment` VALUES ('531', '/public/uploads/picture/20191209/bf99b1a1f776190090cb604c6c1e0130.png', '', '', '', '1', '1575872606', 'png', '1', '281', 'icleft.png');
INSERT INTO `by_attachment` VALUES ('473', '/public/uploads/picture/20190708/3598866dabf7f83d89a3720b23ed0df7.jpg', '', '', '', '1', '1562585990', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `by_attachment` VALUES ('474', '/public/uploads/picture/20190708/3136ff201ba90981d4e5bac31a6047d7.jpg', '', '', '', '1', '1562586103', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `by_attachment` VALUES ('475', '/public/uploads/picture/20190708/07c22be68424c767bff1a2b9637c307a.jpg', '', '', '', '1', '1562586112', 'jpg', '1', '7084', '1528647169549.jpg');
INSERT INTO `by_attachment` VALUES ('476', '/public/uploads/picture/20190708/2387c2b68743e23e3a20c9e8b888b1c7.jpg', '', '', '', '1', '1562586171', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `by_attachment` VALUES ('477', '/public/uploads/picture/20190708/ed75960252a86c8a776a89daa46c6cba.png', '', '', '', '1', '1562586178', 'png', '1', '730798', '017ca458b780a5a801219c77e157e8.PNG@2o.png');
INSERT INTO `by_attachment` VALUES ('536', '/public/uploads/picture/20191209/24e4bf57f2427aba40a9a179155441bb.jpg', '', '', '', '1', '1575875118', 'jpg', '1', '96093', 'd846b840-3ac4-4bbb-8c73-0f7ef84e993e_420_420.jpg');
INSERT INTO `by_attachment` VALUES ('535', '/public/uploads/picture/20191209/76245ad6b0fe054fbc26e9acb0a2adf3.jpg', '', '', '', '1', '1575874907', 'jpg', '1', '229666', 'eda50015-010a-44f7-995d-a3c9d8dc64eb_420_420.jpg');
INSERT INTO `by_attachment` VALUES ('533', '/public/uploads/picture/20191209/c529703f51444c8d26f8f5667621b04e.jpg', '', '', '', '1', '1575873147', 'jpg', '1', '85402', '1419412325-1_k_3.jpg');
INSERT INTO `by_attachment` VALUES ('534', '/public/uploads/picture/20191209/dd7ee60339cfba2c043f7c7b19b5436b.jpg', '', '', '', '1', '1575873669', 'jpg', '1', '75682', 'f59e3594-e3ea-4568-875d-ca1a202bb738_420_420.jpg');
INSERT INTO `by_attachment` VALUES ('529', '/public/uploads/picture/20191204/2dd0d89d519cd19630f251ff386bfcfe.gif', '', '', '', '1', '1575423510', 'gif', '1', '3082', 'spxq_pic_02.gif');
INSERT INTO `by_attachment` VALUES ('530', '/public/uploads/picture/20191204/97c04f9905450e85922b40606ce808a0.png', '', '', '', '1', '1575423868', 'png', '1', '59105', 'index_banner_01.png');
INSERT INTO `by_attachment` VALUES ('528', '/public/uploads/picture/20191204/2a3190aca970819b8fe95ea5e4df443a.gif', '', '', '', '1', '1575423505', 'gif', '1', '6207', '73a488ca3a9f8a86dd9e53d809d4b615.gif');
INSERT INTO `by_attachment` VALUES ('537', '/public/uploads/picture/20200411/6deb4a73e9ff6985432b4b2490690658.jpg', '', '', '', '1', '1586579265', 'jpg', '1', '7319', '1557566529748.jpg');
INSERT INTO `by_attachment` VALUES ('538', '/public/uploads/picture/20200411/5c79612d2f3833948f1a93268218997f.jpg', '', '', '', '1', '1586579282', 'jpg', '1', '7328', '1557389277721.jpg');
INSERT INTO `by_attachment` VALUES ('539', '/public/uploads/picture/20200411/6920abcdaf75ef826e7c880d9e2fc3b4.jpg', '', '', '', '1', '1586579307', 'jpg', '1', '9313', '1557566579080.jpg');
INSERT INTO `by_attachment` VALUES ('540', '/public/uploads/picture/20200411/63dc1f2ea8c365a258b92a62d9cc754e.png', '', '', '', '1', '1586579406', 'png', '1', '54166', 'topic-2.png');
INSERT INTO `by_attachment` VALUES ('541', '/public/uploads/picture/20200413/f473c2e3f2152c34306f62885751c376.png', '', '', '', '1', '1586789848', 'png', '1', '5650', 'logo.png');
INSERT INTO `by_attachment` VALUES ('542', '/public/uploads/picture/20200428/ef0748fb3b0487e34e1a6168c09ba96f.jpg', '', '', '', '1', '1588047547', 'jpg', '1', '76050', '30d20353f6e75e5a.jpg');
INSERT INTO `by_attachment` VALUES ('543', '/public/uploads/picture/20200529/c4335c89e93dea1270529bd75814c70c.jpg', '', '', '', '1', '1590759042', 'jpg', '1', '31939', 'u=3753332979,1341785886&fm=26&gp=0.jpg');
INSERT INTO `by_attachment` VALUES ('544', '/public/uploads/picture/20200601/3c7be07de819c674187514dd26f765f8.jpg', '', '', '', '1', '1590979910', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.UPSKeDWkvqQY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('545', '/public/uploads/picture/20200601/78457006b4131448fc4745e45d5d2826.jpg', '', '', '', '1', '1590979987', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.U6V2FsC76WVY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('546', '/public/uploads/picture/20200601/f7825cc541af996b1b4ed1a45f7dfca3.jpg', '', '', '', '1', '1590980144', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.GdERzXObCYKn101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('547', '/public/uploads/picture/20200601/0dd8c4fdcd8a0f9caf77f52f5f7a5d20.jpg', '', '', '', '1', '1590980215', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.b6MlSiICaaML0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('548', '/public/uploads/picture/20200601/7a7ab0b2a2b103ea16f68990d12bc84e.png', '', '', '', '1', '1590980355', 'png', '1', '133535', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.QOQG0O8t1iKYda23f04aa4474878c2611c05bf136ded.png');
INSERT INTO `by_attachment` VALUES ('549', '/public/uploads/picture/20200601/cea954724f47f139f325d96be522ca6c.jpg', '', '', '', '1', '1590980395', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.itBnLIy9yDXr0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('550', '/public/uploads/picture/20200601/cfc7daa92e5b7bba6b72c3bf4be610f8.jpg', '', '', '', '1', '1590980471', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.uWuoGtRYilp4101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('551', '/public/uploads/picture/20200601/63922ab76459ecc370b092e3dc89617d.jpg', '', '', '', '1', '1590980555', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.dMUl6JUEv2bU0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('552', '/public/uploads/picture/20200601/9dcb4b6585b48fb7959638ac2085a1de.jpg', '', '', '', '1', '1590980606', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.GBZ5dl566SBv0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('553', '/public/uploads/picture/20200601/45e9ca49c4b20be52d1eb321c9b6d9f6.jpg', '', '', '', '1', '1590980671', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.aMLwLy7Siozl0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('554', '/public/uploads/picture/20200601/4112cc85b7d3a547c8165879d078afbc.jpg', '', '', '', '1', '1590980752', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.klpNgCTHJxe80fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('555', '/public/uploads/picture/20200601/999debf59397aff340d8f59da591a7a0.jpg', '', '', '', '1', '1590980885', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.QOEzf8rYfc7p0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('556', '/public/uploads/picture/20200601/064a045016377be626b6fac22fe727ec.jpg', '', '', '', '1', '1590980976', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.IThYFTpWkgtY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('557', '/public/uploads/picture/20200601/488efa8bfe06480425ce10dedb12a18c.jpg', '', '', '', '1', '1590981039', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.MPzYrlOjyr050fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('558', '/public/uploads/picture/20200601/aad698d89da6d5eba6386d3dc241e1fe.jpg', '', '', '', '1', '1590981319', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.6wiZdWwVrQcI0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('559', '/public/uploads/picture/20200601/8c28bb5e1b230c049398c0c25ebbe93e.jpg', '', '', '', '1', '1590981514', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.lyGBhIPCcmHg0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('560', '/public/uploads/picture/20200601/11e27d60e480e3a9c1c0d964297d25fe.jpg', '', '', '', '1', '1590981592', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Yt0QNJHeyQ6I0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('561', '/public/uploads/picture/20200601/cf1aaa7639398a3ce382f5b43ff48cc2.jpg', '', '', '', '1', '1590981690', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.579EteR4k87h0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('562', '/public/uploads/picture/20200601/5aa5b3de99b5f517f17ff67c32217074.jpg', '', '', '', '1', '1590981722', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.P0HcGU6V1aiH0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('563', '/public/uploads/picture/20200601/398918193e6914261c266d12aa222325.jpg', '', '', '', '1', '1590981768', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.rApSqTb9CSHJ0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('564', '/public/uploads/picture/20200601/213f8a11570b67ad18f12c43c27f8379.jpg', '', '', '', '1', '1591004501', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.evUouGmJwceo101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('565', '/public/uploads/picture/20200602/8d726284ea055c13d0f4b0c7f4908c17.jpg', '', '', '', '1', '1591062310', 'jpg', '1', '8176', 'u=3881948964,3937096216&fm=26&gp=0.jpg');
INSERT INTO `by_attachment` VALUES ('566', '/public/uploads/picture/20200602/fd8a49ea571381fa78b4a9a0e039b1fb.jpg', '', '', '', '1', '1591062390', 'jpg', '1', '108816', '下载.jpg');
INSERT INTO `by_attachment` VALUES ('567', '/public/uploads/attachment/20200602/9160e6628b40c5fb2f557913f44f0c58.jpg', '', '', '', '1', '1591101142', 'jpg', '3', '13885', 'tmp_c8e943894f7de1cef207765a60aacbd672047d84932bc47b.jpg');
INSERT INTO `by_attachment` VALUES ('568', '/public/uploads/picture/20200611/dc99da38eed37b1cd413c3f0e0f6b4b7.jpg', '', '', '', '1', '1591849850', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.YDU6SGMQA6TE0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('569', '/public/uploads/picture/20200611/7078281206f953258bd60878deb10765.jpg', '', '', '', '1', '1591849909', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.0PKfuz3Zvdmy0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('570', '/public/uploads/picture/20200611/978e22ad562808193ef953079c926273.jpg', '', '', '', '1', '1591849927', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.OlniJTnQ6C2b101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('571', '/public/uploads/picture/20200611/d9c736fd724c9e28b920b41975e09433.jpg', '', '', '', '1', '1591850240', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.vtuwAr1eFByv0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('572', '/public/uploads/picture/20200611/75a18794b79c20c820122fb5c367d97d.jpg', '', '', '', '1', '1591850318', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.eeod5Xm5dv7Z0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('573', '/public/uploads/picture/20200611/6bac70fdf5554bacd648d725ac0fd175.jpg', '', '', '', '1', '1591850325', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.IO2kyd4ACvAx0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('574', '/public/uploads/picture/20200611/686e9e11b3ee6a24902a521ba109c46b.jpg', '', '', '', '1', '1591853277', 'jpg', '1', '13885', 'tmp_102977cedc221b4996d1452a68cdc2b10155d753784d1eb8.jpg');
INSERT INTO `by_attachment` VALUES ('575', '/public/uploads/picture/20200611/a4f7fef8c78598b1437a5fea8639384a.jpg', '', '', '', '1', '1591861482', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.LESZmIOH8jbD0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('576', '/public/uploads/picture/20200611/d6eaa34fa8aeac57a9bfb2fb91bae87b.jpg', '', '', '', '1', '1591861503', 'jpg', '1', '1481', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.fdNsGhyMEEuQ3cc8b90dc59b95a304bb660d0afc52e7.jpg');
INSERT INTO `by_attachment` VALUES ('577', '/public/uploads/picture/20200611/3e7c8f127b1e98fdd8cfbebc1b09dbb9.jpg', '', '', '', '1', '1591861573', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.fWjlHrPjqLU40fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('578', '/public/uploads/picture/20200611/97767a7fe3080f7beecd1998196f1e5f.jpg', '', '', '', '1', '1591861792', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.d7DKtPW7Jk4s101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('579', '/public/uploads/picture/20200611/89e45bea4213cb50671bc08a383fc8f8.jpg', '', '', '', '1', '1591861826', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.LPEmKyRmrI5Q101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('580', '/public/uploads/picture/20200611/b7e63c25c22c1363362d47cf04c3cc98.jpg', '', '', '', '1', '1591862119', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.3WvURJrdBeeY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('581', '/public/uploads/picture/20200611/c4b31d8504fa359b6495499beff278c2.png', '', '', '', '1', '1591862126', 'png', '1', '50618', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.JRO5HBg51qFbf4d2ac70ce414264e6ade89b1087b828.png');
INSERT INTO `by_attachment` VALUES ('582', '/public/uploads/picture/20200611/fad70fd0f9be413b8ccf939eae0fd89e.jpg', '', '', '', '1', '1591862796', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.u2gVOPG2f1zu0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('583', '/public/uploads/picture/20200611/d375e3f8a1352a033fb39decaedc1711.jpg', '', '', '', '1', '1591862810', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Zw7O6NC7p6Ag101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('584', '/public/uploads/picture/20200611/d845d4ca0e45c22bf7ac44cb2ef6f04f.jpg', '', '', '', '1', '1591863180', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.iubtWfoQRycN0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('585', '/public/uploads/picture/20200611/7b34491779d13efad792f23a08fc5fbc.jpg', '', '', '', '1', '1591863190', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Amkb32irTjIY101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('586', '/public/uploads/picture/20200611/a09fc6d8a275bff4906b05e565cc3622.jpg', '', '', '', '1', '1591863478', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.YzcBhUg1eapo0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `by_attachment` VALUES ('587', '/public/uploads/picture/20200611/ab12b34e89ace3a5b8864a18aa54fa86.jpg', '', '', '', '1', '1591863484', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.XvSEnYR3oAV1101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('588', '/public/uploads/picture/20200612/a19b73decbcd7239b81a36e74c27de13.jpg', '', '', '', '1', '1591977331', 'jpg', '1', '81160', 'tmp_fdd5b9337009ef09447ba9aedab19ea1c4656d6a24ab2eef.jpg');
INSERT INTO `by_attachment` VALUES ('589', '/public/uploads/picture/20200614/0ab0271cf5218377fe3ae810c20c0716.jpg', '', '', '', '1', '1592066326', 'jpg', '1', '13885', 'tmp_59481455c931f8d928b6e61b2b2356423f7e358fef339cb4.jpg');
INSERT INTO `by_attachment` VALUES ('590', '/public/uploads/picture/20200617/cb62e565235e03bc9da058e77e0b589b.jpg', '', '', '', '1', '1592399033', 'jpg', '1', '1562', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.TzfkluidcTFc6627ab38f27e06577409c7201443e934.jpg');
INSERT INTO `by_attachment` VALUES ('591', '/public/uploads/picture/20200617/0fde3853490db68a36495a44948d06bb.jpg', '', '', '', '1', '1592399043', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Qqs0P9ONLyAl101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('592', '/public/uploads/picture/20200617/8044d8bb488e451a166d633a1deeb908.png', '', '', '', '1', '1592399176', 'png', '1', '50618', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.ysfXawnRGb2qf4d2ac70ce414264e6ade89b1087b828.png');
INSERT INTO `by_attachment` VALUES ('593', '/public/uploads/picture/20200617/adb2fa1f3f03fa18337b0312f10c82b7.jpg', '', '', '', '1', '1592399190', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.XvvifvHW4pOv101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('594', '/public/uploads/picture/20200617/f8ff9c42b759fdc8f1c3f46a867f8505.jpg', '', '', '', '1', '1592399369', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.0d7WQeMYMdae101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `by_attachment` VALUES ('595', '/public/uploads/picture/20200617/7a722add090ed65b1fb82a77f81968bb.jpg', '', '', '', '1', '1592399534', 'jpg', '1', '10410', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.wCKOE6i2xoQL508ae5c7ffe4d60193eeb1a0f8924e26.jpg');
INSERT INTO `by_attachment` VALUES ('596', '/public/uploads/picture/20200617/7fa271e052f8b17c29f925a2ba336afa.jpg', '', '', '', '1', '1592399570', 'jpg', '1', '18654', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.PcsKXpaa9Sev2dae826d32dad3564cdca5a923cc4b9c.jpg');
INSERT INTO `by_attachment` VALUES ('597', '/public/uploads/picture/20200618/a1e80b86503af1953a02a6e09da85c1b.jpg', '', '', '', '1', '1592447863', 'jpg', '1', '10410', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.xDxP7nYP9DHH508ae5c7ffe4d60193eeb1a0f8924e26.jpg');
INSERT INTO `by_attachment` VALUES ('598', '/public/uploads/picture/20200618/db2a1c476f358824844f7cfd9958fc03.jpg', '', '', '', '1', '1592452413', 'jpg', '1', '81160', 'tmp_866c355759bb13f4cce0b9a94ce20dae70f96c92f5c3620e.jpg');
INSERT INTO `by_attachment` VALUES ('599', '/public/uploads/picture/20200727/c9d97f74df808b7632e012e1665e817e.png', '', '', '', '1', '1595836214', 'png', '1', '22635', 'b5ca0562e795d504a9070fc1b3377ed1.png');
INSERT INTO `by_attachment` VALUES ('600', '/public/uploads/picture/20200727/f1193dda7b582fc975f20ce4179aae5b.png', '', '', '', '1', '1595836219', 'png', '1', '4697', '54cc729e1526bd2a88b85b747f190573.png');
INSERT INTO `by_attachment` VALUES ('601', '/public/uploads/picture/20200727/942e9cd630f0b7c1e71eab36b90e83d6.png', '', '', '', '1', '1595836235', 'png', '1', '1517', 'b0403c560a1f882829df075d36315fc7.png');
INSERT INTO `by_attachment` VALUES ('602', '/public/uploads/picture/20200727/65b495237967fa3eebf018d84fcd5c40.png', '', '', '', '1', '1595836262', 'png', '1', '21811', 'd547651183519f18cfd3584c3097d1e9.png');
INSERT INTO `by_attachment` VALUES ('603', '/public/uploads/picture/20200727/1b7253372a1e653d97444608b409a061.jpg', '', '', '', '1', '1595836360', 'jpg', '1', '76050', '9dae589dc3ccae0e57ec269966965ad0.jpg');
INSERT INTO `by_attachment` VALUES ('604', '/public/uploads/picture/20200805/f640ca07e5bcf54e0fc0dadf78e84cb4.png', '', '', '', '1', '1596630101', 'png', '1', '4697', '54cc729e1526bd2a88b85b747f190573.png');
INSERT INTO `by_attachment` VALUES ('605', '/public/uploads/picture/20200805/1df0ac100a93bcd8da62c681289da598.png', '', '', '', '1', '1596630114', 'png', '1', '4697', '54cc729e1526bd2a88b85b747f190573.png');
INSERT INTO `by_attachment` VALUES ('606', '/public/uploads/picture/20200805/d9f4225dc8b43ccab1a7b2ec8e06a6e9.jpg', '', '', '', '1', '1596630135', 'jpg', '1', '76050', '1b7253372a1e653d97444608b409a061.jpg');
INSERT INTO `by_attachment` VALUES ('607', '/public/uploads/picture/20200805/2aaa1fcec9aec7b551e59246bd601924.png', '', '', '', '1', '1596630152', 'png', '1', '21811', '65b495237967fa3eebf018d84fcd5c40.png');
INSERT INTO `by_attachment` VALUES ('608', '/public/uploads/picture/20200805/6d9afb0f76a28ecec7a4279fce6754e5.png', '', '', '', '1', '1596630207', 'png', '1', '22635', 'c9d97f74df808b7632e012e1665e817e.png');
INSERT INTO `by_attachment` VALUES ('609', '/public/uploads/picture/20200818/8e09fa3b4e19f4b2b3e4fed2d74e35d2.png', '', '', '', '1', '1597720305', 'png', '1', '295463', 'bg.png');
INSERT INTO `by_attachment` VALUES ('610', '/public/uploads/picture/20200822/e7619a7d677cc18c2bff319bf5b3d9c8.jpg', '', '', '', '1', '1598069098', 'jpg', '1', '117064', 'banner3.jpg');
INSERT INTO `by_attachment` VALUES ('611', '/public/uploads/picture/20200822/6069cdebc62eadb4236bf2ac11072d2c.jpg', '', '', '', '1', '1598070275', 'jpg', '1', '57217', '350 (1)sdfsd.jpg');
INSERT INTO `by_attachment` VALUES ('612', '/public/uploads/picture/20200824/28ad15125fe469eb0884451267716d72.jpg', '', '', '', '1', '1598246792', 'jpg', '1', '9618', '下载.jpg');
INSERT INTO `by_attachment` VALUES ('613', '/public/uploads/picture/20200826/e4831dbfd6d06cdd10dff3f3cbf04f9f.png', '', '', '', '1', '1598453255', 'png', '1', '41517', '661ef170a39dc851.png');
INSERT INTO `by_attachment` VALUES ('614', '/F:/wpf/WpfApp1/WpfApp1/bin/x64/Debug/web/im//public/uploads/picture/2020-09-03/1599130008.jpg', '', '', '', '1', '1599130008', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('615', '/F:/wpf/WpfApp1/WpfApp1/bin/x64/Debug/web/im//public/uploads/picture/2020-09-03/1599130031.jpg', '', '', '', '1', '1599130031', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('616', '/public/uploads/picture/2020-09-03/1599130326.jpg', '', '', '', '1', '1599130326', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('617', '/public/uploads/picture/2020-09-03/1599130371.jpg', '', '', '', '1', '1599130371', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('618', '/public/uploads/picture/2020-09-03/gilrnd15991305921599130592.jpg', '', '', '', '1', '1599130592', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('619', '/public/uploads/picture/2020-09-03/xhovej15991344531599134453.jpg', '', '', '', '1', '1599134453', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('620', '/public/uploads/picture/2020-09-03/mbrdqp15991359941599135994.jpg', '', '', '', '1', '1599135994', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('621', '/public/uploads/picture/2020-09-03/eykudk15991360441599136044.jpg', '', '', '', '1', '1599136044', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('622', '/public/uploads/picture/2020-09-03/xwkkma15991361361599136136.jpg', '', '', '', '1', '1599136136', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('623', '/public/uploads/picture/2020-09-03/ivfbas15991363121599136312.jpg', '', '', '', '1', '1599136312', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('624', '/public/uploads/picture/2020-09-03/pvhqmo15991363821599136382.jpg', '', '', '', '1', '1599136382', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('625', '/public/uploads/picture/2020-09-03/vgzedy15991364151599136415.jpg', '', '', '', '1', '1599136415', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('626', '/public/uploads/picture/2020-09-03/ktdaxb15991365211599136521.jpg', '', '', '', '1', '1599136521', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('627', '/public/uploads/picture/2020-09-03/ztqvmh15991366631599136663.jpg', '', '', '', '1', '1599136663', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('628', '/public/uploads/picture/2020-09-03/eyqols15991374211599137421.jpg', '', '', '', '1', '1599137421', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('629', '/public/uploads/picture/2020-09-03/kuxvvv15991375541599137554.jpg', '', '', '', '1', '1599137554', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('630', '/public/uploads/picture/2020-09-03/htcfxd15991375711599137571.jpg', '', '', '', '1', '1599137571', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('631', '/public/uploads/picture/20200903/784de0ebe335f59cf8600b89468bbcb9.jpg', '', '', '', '1', '1599141110', 'jpg', '1', '71519', '123.jpg');
INSERT INTO `by_attachment` VALUES ('632', '/public/uploads/picture/2020-09-04/ahaxvu15991492801599149280.jpg', '', '', '', '1', '1599149280', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('633', '/public/uploads/picture/2020-09-04/fqokhz15991496141599149614.jpg', '', '', '', '1', '1599149614', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('634', '/public/uploads/picture/2020-09-04/hllirc15991496451599149645.jpg', '', '', '', '1', '1599149645', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('635', '/public/uploads/picture/2020-09-04/elpqfy15991939651599193965.jpg', '', '', '', '1', '1599193965', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('636', '/public/uploads/picture/20200904/44bacfe989d2c3dba41a55d3fcdd5432.jpg', '', '', '', '1', '1599219333', 'jpg', '1', '10410', 'u=1327388017,2571269404&fm=26&gp=0.jpg');
INSERT INTO `by_attachment` VALUES ('637', '/public/uploads/picture/2020-09-05/wgumqr15992857991599285799.jpg', '', '', '', '1', '1599285799', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('638', '/public/uploads/picture/2020-09-05/aiwixr15992858611599285861.jpg', '', '', '', '1', '1599285861', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('639', '/public/uploads/picture/20200905/efe15eea7109b61304b7909eb9d9f161.png', '', '', '', '1', '1599287424', 'png', '1', '17987', 'file.png');
INSERT INTO `by_attachment` VALUES ('640', '/public/uploads/picture/20200905/fd76909e7f0ad12058d5dd31713c0bac.png', '', '', '', '1', '1599287616', 'png', '1', '17987', 'file.png');
INSERT INTO `by_attachment` VALUES ('641', '/public/uploads/picture/20200905/af9f9163a1912491e1977c8679d912e8.png', '', '', '', '1', '1599287799', 'png', '1', '17987', 'file.png');
INSERT INTO `by_attachment` VALUES ('642', '/public/uploads/picture/20200905/037235056d4ae6c979d871358d2d4557.png', '', '', '', '1', '1599287874', 'png', '1', '17987', 'file.png');
INSERT INTO `by_attachment` VALUES ('643', '/public/uploads/picture/20200906/3b9932f5a60cd46aa4488d451daeaddf.png', '', '', '', '1', '1599381453', 'png', '1', '17926', 'x.png');
INSERT INTO `by_attachment` VALUES ('644', '/public/uploads/picture/20200906/fe23d3dace93ba0ba3db206875b95897.png', '', '', '', '1', '1599384424', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('645', '/public/uploads/picture/20200906/bb3b663b662c14989efa3d62286cd86d.png', '', '', '', '1', '1599384536', 'png', '1', '17926', 'x.png');
INSERT INTO `by_attachment` VALUES ('646', '/public/uploads/picture/20200906/7dcadc7bad72fa78252840c19cce11a0.png', '', '', '', '1', '1599384576', 'png', '1', '17818', 'ar.png');
INSERT INTO `by_attachment` VALUES ('647', '/public/uploads/picture/20200906/0db8587a82022fc624cf9974e9eef02e.png', '', '', '', '1', '1599384832', 'png', '1', '17926', 'x.png');
INSERT INTO `by_attachment` VALUES ('648', '/public/uploads/picture/2020-09-06/efgqzs15993849151599384915.jpg', '', '', '', '1', '1599384915', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('649', '/public/uploads/picture/20200906/ac21eb4e9240dc84430551b582c7a9dc.png', '', '', '', '1', '1599384973', 'png', '1', '17926', 'x.png');
INSERT INTO `by_attachment` VALUES ('650', '/public/uploads/picture/20200906/043097e7d39167a7bc42037d43adc633.png', '', '', '', '1', '1599386382', 'png', '1', '17818', 'ar.png');
INSERT INTO `by_attachment` VALUES ('651', '/public/uploads/picture/20200906/4d706e4e2d0099296f978fa3967c6c87.png', '', '', '', '1', '1599386411', 'png', '1', '17926', 'x.png');
INSERT INTO `by_attachment` VALUES ('652', '/public/uploads/picture/20200906/976ea4ebe79601e488b21f26c9c89125.png', '', '', '', '1', '1599401081', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('653', '/public/uploads/picture/20200906/8267a4a5343fd47772783c834f9fd51d.png', '', '', '', '1', '1599401093', 'png', '1', '170234', '20191220175613964.png');
INSERT INTO `by_attachment` VALUES ('654', '/public/uploads/picture/2020-09-07/kosjnr15994591401599459140.jpg', '', '', '', '1', '1599459140', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('655', '/public/uploads/picture/20200907/c43fae22c9e43dbeba9a72d98be2fc59.png', '', '', '', '1', '1599459150', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('656', '/public/uploads/picture/20200907/7fcd9cd5a5ffb7e9f647f6808695e384.png', '', '', '', '1', '1599459163', 'png', '1', '170234', '20191220175613964.png');
INSERT INTO `by_attachment` VALUES ('657', '/public/uploads/picture/20200907/cc124445c91822c43a1c5ef1400e7844.png', '', '', '', '1', '1599459215', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('658', '/public/uploads/picture/20200907/d9a69e41d131184eda425d72afa16199.png', '', '', '', '1', '1599459469', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('659', '/public/uploads/picture/20200907/fc7a1b3b42ebd0bd640a3f8d7d626b93.png', '', '', '', '1', '1599459601', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('660', '/public/uploads/picture/2020-09-07/cjfgli15994665421599466542.jpg', '', '', '', '1', '1599466542', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('661', '/public/uploads/picture/2020-09-07/fohzei15994701141599470114.jpg', '', '', '', '1', '1599470114', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('662', '/public/uploads/picture/20200907/0b410377d1b991a7ffbac639733d899b.png', '', '', '', '1', '1599470120', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('663', '/public/uploads/picture/20200907/cc0b7b7ff42a5d629f791000316a53f2.png', '', '', '', '1', '1599470157', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('664', '/public/uploads/picture/2020-09-07/qerrhi15994704291599470429.jpg', '', '', '', '1', '1599470429', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('665', '/public/uploads/picture/2020-09-07/avszqb15994705111599470511.jpg', '', '', '', '1', '1599470511', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('666', '/public/uploads/picture/2020-09-07/vskldr15994706821599470682.jpg', '', '', '', '1', '1599470682', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('667', '/public/uploads/picture/2020-09-07/kiojvo15994707741599470774.jpg', '', '', '', '1', '1599470774', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('668', '/public/uploads/picture/2020-09-07/gtaytd15994773691599477369.jpg', '', '', '', '1', '1599477369', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('669', '/public/uploads/picture/20200907/a6f6675ce3bb2d687ef38491b9e14421.png', '', '', '', '1', '1599477377', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('670', '/public/uploads/picture/20200907/b60c6f00979f6516b742e2c22f23d08d.png', '', '', '', '1', '1599491522', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('671', '/public/uploads/picture/2020-09-08/emlrbo15995342601599534260.jpg', '', '', '', '1', '1599534260', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('672', '/public/uploads/picture/2020-09-08/bhwxli15995343241599534324.jpg', '', '', '', '1', '1599534324', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('673', '/public/uploads/picture/2020-09-08/fiunxx15995347301599534730.jpg', '', '', '', '1', '1599534730', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('674', '/public/uploads/picture/2020-09-08/dxzmgo15995349131599534913.jpg', '', '', '', '1', '1599534913', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('675', '/public/uploads/picture/2020-09-08/rhpwds15995349341599534934.jpg', '', '', '', '1', '1599534934', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('676', '/public/uploads/picture/2020-09-08/gdgbyp15995349561599534956.jpg', '', '', '', '1', '1599534956', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('677', '/public/uploads/picture/2020-09-08/wizujl15995350151599535015.jpg', '', '', '', '1', '1599535015', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('678', '/public/uploads/picture/2020-09-08/zjvljn15995350501599535050.jpg', '', '', '', '1', '1599535050', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('679', '/public/uploads/picture/2020-09-08/xatkga15995350841599535084.jpg', '', '', '', '1', '1599535084', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('680', '/public/uploads/picture/2020-09-08/bdglbb15995351401599535140.jpg', '', '', '', '1', '1599535140', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('681', '/public/uploads/picture/2020-09-08/bektse15995351941599535194.jpg', '', '', '', '1', '1599535194', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('682', '/public/uploads/picture/2020-09-08/pyvgxw15995352181599535218.jpg', '', '', '', '1', '1599535219', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('683', '/public/uploads/picture/2020-09-08/cizhdk15995352601599535260.jpg', '', '', '', '1', '1599535260', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('684', '/public/uploads/picture/2020-09-08/fyxngd15995353371599535337.jpg', '', '', '', '1', '1599535337', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('685', '/public/uploads/picture/2020-09-08/fpzekh15995353701599535370.jpg', '', '', '', '1', '1599535370', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('686', '/public/uploads/picture/2020-09-08/iirxqy15995354331599535433.jpg', '', '', '', '1', '1599535433', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('687', '/public/uploads/picture/2020-09-08/xqlxni15995358611599535861.jpg', '', '', '', '1', '1599535861', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('688', '/public/uploads/picture/2020-09-08/mxjvry15995359721599535972.jpg', '', '', '', '1', '1599535972', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('689', '/public/uploads/picture/2020-09-08/emiupb15995361691599536169.jpg', '', '', '', '1', '1599536169', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('690', '/public/uploads/picture/2020-09-08/wfqjec15995362591599536259.jpg', '', '', '', '1', '1599536259', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('691', '/public/uploads/picture/2020-09-08/jyrhnl15995367991599536799.jpg', '', '', '', '1', '1599536799', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('692', '/public/uploads/picture/2020-09-08/ovyygh15995368931599536893.jpg', '', '', '', '1', '1599536893', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('693', '/public/uploads/picture/2020-09-08/edyihk15995422241599542224.jpg', '', '', '', '1', '1599542224', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('694', '/public/uploads/picture/2020-09-09/cgwaob15996512551599651255.jpg', '', '', '', '1', '1599651255', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('695', '/public/uploads/picture/2020-09-09/qvzmjl15996536071599653607.jpg', '', '', '', '1', '1599653607', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('696', '/public/uploads/picture/2020-09-09/nahkvy15996565991599656599.jpg', '', '', '', '1', '1599656599', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('697', '/public/uploads/picture/2020-09-10/ozyfjv15997073181599707318.jpg', '', '', '', '1', '1599707318', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('698', '/public/uploads/picture/2020-09-10/mjlhtn15997172911599717291.jpg', '', '', '', '1', '1599717291', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('699', '/public/uploads/picture/2020-09-10/txtnnu15997173701599717370.jpg', '', '', '', '1', '1599717370', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('700', '/public/uploads/picture/20200910/ede70db0787887c546b7703f8e3ae3d3.png', '', '', '', '1', '1599717373', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('701', '/public/uploads/picture/20200910/43cac27ea562a90ee71e0383bef3b4e5.png', '', '', '', '1', '1599717405', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('702', '/public/uploads/picture/20200910/eb3998220125493d17b7901b01a53efd.png', '', '', '', '1', '1599717555', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('703', '/public/uploads/picture/2020-09-10/bgpxsc15997175681599717568.jpg', '', '', '', '1', '1599717568', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('704', '/public/uploads/picture/20200910/ba3934890e31b942f4eaa8f23266df2c.png', '', '', '', '1', '1599717766', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('705', '/public/uploads/picture/20200910/edb3e3faf2c66c9e098b60fb8d076bb4.png', '', '', '', '1', '1599717802', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('706', '/public/uploads/picture/20200910/8b99b8f8edcc24541886f56ec46d7281.png', '', '', '', '1', '1599717972', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('707', '/public/uploads/picture/20200910/9b72b4a26c03fee49f5002d6ddb7324b.png', '', '', '', '1', '1599718181', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('708', '/public/uploads/picture/20200910/78bf23c8fb96322da8b3fd2c5c385246.png', '', '', '', '1', '1599718328', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('709', '/public/uploads/picture/20200910/dae330c946e7e37b7e3e4d5c4507393c.png', '', '', '', '1', '1599718399', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('710', '/public/uploads/picture/20200910/51ce17deee6b15486892f8510700e3d8.png', '', '', '', '1', '1599718449', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('711', '/public/uploads/picture/20200910/9969b6ef121cf98209c659e780a17b35.png', '', '', '', '1', '1599718560', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('712', '/public/uploads/picture/20200910/f53cfaca1343165e8d7e276008d6a223.png', '', '', '', '1', '1599718771', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('713', '/public/uploads/picture/20200910/8fa4e370d3e09ee18ce10f760334c2ba.png', '', '', '', '1', '1599719017', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('714', '/public/uploads/picture/20200910/d43af4eeddc4d459dfcc3978b4296e92.png', '', '', '', '1', '1599719801', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('715', '/public/uploads/picture/20200910/a3d61e7cca19bba308d034bf2de8f49e.png', '', '', '', '1', '1599719999', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('716', '/public/uploads/picture/20200910/42e5d93aa49225b37e50871aeebffc8f.png', '', '', '', '1', '1599720037', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('717', '/public/uploads/picture/20200910/7909a84243002bfefd1b6c75418a0bb7.png', '', '', '', '1', '1599720075', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('718', '/public/uploads/picture/20200910/5cc98ca4573e7d6de51c3a1a386364f0.png', '', '', '', '1', '1599720093', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('719', '/public/uploads/picture/20200910/728f41f089c8a84f7fcd5e3ef6c36e3a.png', '', '', '', '1', '1599720118', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('720', '/public/uploads/picture/20200910/3058247660a61ffab7725861b8265d78.png', '', '', '', '1', '1599720139', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('721', '/public/uploads/picture/2020-09-10/ilnerd15997202481599720248.jpg', '', '', '', '1', '1599720248', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('722', '/public/uploads/picture/20200910/cc375842532b03e35572d788c58c7b37.png', '', '', '', '1', '1599738008', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('723', '/public/uploads/picture/2020-09-10/scgxxm15997385171599738517.jpg', '', '', '', '1', '1599738517', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('724', '/public/uploads/picture/20200910/2823dfc489c3112f7a6cb91946b57d03.png', '', '', '', '1', '1599738523', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('725', '/public/uploads/picture/2020-09-10/bzkkbw15997385601599738560.jpg', '', '', '', '1', '1599738560', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('726', '/public/uploads/picture/20200910/5f2c2b620e828eb110ba9645615cc33c.png', '', '', '', '1', '1599738574', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('727', '/public/uploads/picture/20200910/55fcb732957fd1d5cebfabe9dfaca1bf.png', '', '', '', '1', '1599738876', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('728', '/public/uploads/picture/20200910/cc90ab656dd90e44f06f4448310d02c1.png', '', '', '', '1', '1599738911', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('729', '/public/uploads/picture/20200910/b2982ce93da0e752b5e153a9cf72b78a.png', '', '', '', '1', '1599739009', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('730', '/public/uploads/picture/20200910/013c9b66d91c737db7fc6148f6767c99.png', '', '', '', '1', '1599739157', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('731', '/public/uploads/picture/2020-09-10/kxijwp15997391911599739191.jpg', '', '', '', '1', '1599739191', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('732', '/public/uploads/picture/20200910/f04083285f1ce74f795a00348ccb05ad.png', '', '', '', '1', '1599739241', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('733', '/public/uploads/picture/20200910/44ebc3a1d20fd494569708d821474dc0.png', '', '', '', '1', '1599739309', 'png', '1', '170234', '20191220175613964.png');
INSERT INTO `by_attachment` VALUES ('734', '/public/uploads/picture/20200910/6d826132545a5103918ca8e03ca78286.png', '', '', '', '1', '1599739331', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('735', '/public/uploads/picture/20200910/6c8247cf36f499355f8bb623e44d571f.png', '', '', '', '1', '1599739359', 'png', '1', '170234', '20191220175613964.png');
INSERT INTO `by_attachment` VALUES ('736', '/public/uploads/picture/20200910/42a83a8c584680a3789c912393a5ad55.png', '', '', '', '1', '1599739372', 'png', '1', '1297', 't.png');
INSERT INTO `by_attachment` VALUES ('737', '/public/uploads/picture/20200910/21987a7f024850b4e272e8cd0f33a6d6.png', '', '', '', '1', '1599739413', 'png', '1', '18397', '未标题-1.png');
INSERT INTO `by_attachment` VALUES ('738', '/public/uploads/picture/20200910/6ac6eff99f9c59b5d8d8daaf32c31b43.jpg', '', '', '', '1', '1599739433', 'jpg', '1', '23812', '0.jpg');
INSERT INTO `by_attachment` VALUES ('739', '/public/uploads/picture/20200910/b31cb1564d3c6f2ca763a183feb20bd5.jpg', '', '', '', '1', '1599739443', 'jpg', '1', '71519', '123.jpg');
INSERT INTO `by_attachment` VALUES ('740', '/public/uploads/picture/2020-09-10/ebumuc15997394531599739453.jpg', '', '', '', '1', '1599739453', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('741', '/public/uploads/picture/20200910/8d00c9c3aa419a4fbe4c08a8f3773f0a.jpg', '', '', '', '1', '1599739585', 'jpg', '1', '23812', '0.jpg');
INSERT INTO `by_attachment` VALUES ('742', '/public/uploads/picture/2020-09-10/ssliso15997438801599743880.jpg', '', '', '', '1', '1599743880', null, '0', null, null);
INSERT INTO `by_attachment` VALUES ('743', '/public/uploads/picture/20200913/b4913e5fa92ed0c80cc01eb0c560b1c1.png', '', '', '', '1', '1599996531', 'png', '1', '24133', 'QQ截图20200913173837.png');
INSERT INTO `by_attachment` VALUES ('744', '/public/uploads/picture/20200913/fa9abe0e33a33bfb1c87d20d1a270338.png', '', '', '', '1', '1599996542', 'png', '1', '24133', 'QQ截图20200913173837.png');
INSERT INTO `by_attachment` VALUES ('745', '/public/uploads/picture/20200913/4a4e7ea97f697973f9d466f7a2e6804a.png', '', '', '', '1', '1599996715', 'png', '1', '42139', 'QQ截图20200913173901.png');
INSERT INTO `by_attachment` VALUES ('746', '/public/uploads/picture/20200913/cdb62e4835f05fd4a124efa39060aeef.png', '', '', '', '1', '1599996872', 'png', '1', '24133', 'QQ截图20200913173837.png');
INSERT INTO `by_attachment` VALUES ('747', '/public/uploads/picture/20200913/6332aac7232cf45ca95c87023bc09feb.png', '', '', '', '1', '1599996921', 'png', '1', '180792', '5405e0f3b1705.png');

-- ----------------------------
-- Table structure for by_attributes
-- ----------------------------
DROP TABLE IF EXISTS `by_attributes`;
CREATE TABLE `by_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `sort` int(10) NOT NULL DEFAULT '0',
  `types_id` int(10) NOT NULL DEFAULT '0',
  `type` int(2) DEFAULT '0',
  `value` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `is_show` int(2) NOT NULL DEFAULT '1',
  `short_title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=270 DEFAULT CHARSET=latin1 COMMENT='属性表';

-- ----------------------------
-- Records of by_attributes
-- ----------------------------
INSERT INTO `by_attributes` VALUES ('24', '0', '笔记本定位', '1', '44', '0', ' 商务办公、高清游戏、学生', '1', '');
INSERT INTO `by_attributes` VALUES ('75', '24', '学生', '0', '44', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('72', '24', ' 商务办公', '0', '44', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('73', '24', '高清游戏', '0', '44', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('74', '24', 'kk', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('76', '0', '颜色', '0', '42', '0', '红色、白色、橙色、绿色', '1', '');
INSERT INTO `by_attributes` VALUES ('80', '76', '红色', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('81', '76', '白色', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('82', '76', '橙色', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('83', '76', '绿色', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('84', '0', '人群', '0', '42', '0', '青年、青少年、老年、情侣装、大码人群、中年', '1', '');
INSERT INTO `by_attributes` VALUES ('85', '84', '青年', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('86', '84', '青少年', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('87', '84', '老年', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('88', '84', '情侣装', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('89', '84', '大码人群', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('90', '84', '中年', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('91', '0', '版型', '0', '42', '0', '超修身、标准型、宽松型', '1', '');
INSERT INTO `by_attributes` VALUES ('92', '91', '超修身', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('93', '91', '标准型', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('94', '91', '宽松型', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('95', '0', '上市时间', '0', '42', '0', '2016春季、2016夏季、往季、2017冬季、2017夏季、2017春季', '1', '');
INSERT INTO `by_attributes` VALUES ('96', '95', '2016春季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('97', '95', '2016夏季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('98', '95', '往季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('99', '95', '2017冬季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('100', '95', '2017夏季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('101', '95', '2017春季', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('102', '0', '领型', '0', '42', '0', '扣领、尖领、撞色领、方领、礼服领、立领、翻领、连帽', '1', '');
INSERT INTO `by_attributes` VALUES ('103', '102', '扣领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('104', '102', '尖领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('105', '102', '撞色领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('106', '102', '方领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('107', '102', '礼服领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('108', '102', '立领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('109', '102', '翻领', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('110', '102', '连帽', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('111', '0', '风格', '0', '42', '0', '清新日系、欧美风格、青春休闲、运动休闲、英伦风格、精致韩风、嘻哈风格、商务正装、商务休闲、时尚休闲', '1', '');
INSERT INTO `by_attributes` VALUES ('112', '111', '清新日系', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('113', '111', '欧美风格', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('114', '111', '青春休闲', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('115', '111', '运动休闲', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('116', '111', '英伦风格', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('117', '111', '精致韩风', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('118', '111', '嘻哈风格', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('119', '111', '商务正装', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('120', '111', '商务休闲', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('121', '111', '时尚休闲', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('122', '0', '分类', '0', '41', '0', '每日坚果、长寿果/碧根果、夏威夷果、开心果、腰果、松子、巴西松子、杏仁/巴旦木、核桃', '1', '');
INSERT INTO `by_attributes` VALUES ('123', '122', '每日坚果', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('124', '122', '长寿果/碧根果', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('125', '122', '夏威夷果', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('126', '122', '开心果', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('127', '122', '腰果', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('128', '122', '松子', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('129', '122', '巴西松子', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('130', '122', '杏仁/巴旦木', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('131', '122', '核桃', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('132', '0', '产地', '0', '41', '0', '中国大陆、美国、马来西亚、泰国、港澳台、韩国、澳洲 、其它', '1', '');
INSERT INTO `by_attributes` VALUES ('133', '132', '中国大陆', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('134', '132', '美国', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('135', '132', '马来西亚', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('136', '132', '泰国', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('137', '132', '港澳台', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('138', '132', '韩国', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('139', '132', '澳洲 ', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('140', '132', '其它', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('141', '0', '口味', '0', '41', '0', '原味、炭烧、奶油味、五香味、麻辣味、椒盐味、盐焗味、蒜香味、芥末味、紫薯味', '1', '');
INSERT INTO `by_attributes` VALUES ('142', '141', '原味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('143', '141', '炭烧', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('144', '141', '奶油味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('145', '141', '五香味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('146', '141', '麻辣味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('147', '141', '椒盐味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('148', '141', '盐焗味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('149', '141', '蒜香味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('150', '141', '芥末味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('151', '141', '紫薯味', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('152', '0', '国产/进口', '0', '41', '0', '国产、进口', '1', '');
INSERT INTO `by_attributes` VALUES ('153', '152', '国产', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('154', '152', '进口', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('155', '0', '包装', '0', '41', '0', '礼盒装、组合装、独立小包装、袋装、罐装', '1', '');
INSERT INTO `by_attributes` VALUES ('156', '155', '礼盒装', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('157', '155', '组合装', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('158', '155', '独立小包装', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('159', '155', '袋装', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('160', '155', '罐装', '0', '41', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('161', '0', '特性', '0', '41', '0', '带皮、果仁', '1', '');
INSERT INTO `by_attributes` VALUES ('162', '161', '带皮', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('163', '161', '果仁', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('164', '0', '系统', '0', '43', '0', '安卓、苹果、微软、基础功能机', '1', '');
INSERT INTO `by_attributes` VALUES ('177', '164', '微软', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('176', '164', '苹果', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('175', '164', '安卓', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('169', '0', '屏幕尺寸', '0', '43', '0', '5.6英寸及以上、5.5-5.1英寸、5.0-4.6英寸、4.5-3.1英寸、3.0英寸及以下', '1', '');
INSERT INTO `by_attributes` VALUES ('170', '169', '5.6英寸及以上', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('171', '169', '5.5-5.1英寸', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('172', '169', '5.0-4.6英寸', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('173', '169', '4.5-3.1英寸', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('174', '169', '3.0英寸及以下', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('180', '0', '材质', '0', '43', '0', '塑料、合金、木制', '1', '');
INSERT INTO `by_attributes` VALUES ('179', '164', '基础功能机', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('181', '180', '塑料', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('182', '180', '合金', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('183', '180', '木制', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('184', '0', '热点', '0', '42', '0', '以旧换新、功能机、儿童手机、合约机、全面屏、直板键盘、翻盖、商务手机、安全手机', '1', '');
INSERT INTO `by_attributes` VALUES ('185', '184', '以旧换新', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('186', '184', '功能机', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('187', '184', '儿童手机', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('188', '184', '合约机', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('189', '184', '全面屏', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('190', '184', '直板键盘', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('191', '184', '翻盖', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('192', '184', '商务手机', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('193', '184', '安全手机', '0', '42', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('194', '0', '网络', '0', '43', '0', '移动4G/联通4G/电信4G、移动4G+、移动4G、联通4G、电信4G、双卡单4G、双卡双4G、双卡2G网络', '1', '');
INSERT INTO `by_attributes` VALUES ('195', '194', '移动4G/联通4G/电信4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('196', '194', '移动4G+', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('197', '194', '移动4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('198', '194', '联通4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('199', '194', '电信4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('200', '194', '双卡单4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('201', '194', '双卡双4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('202', '194', '双卡2G网络', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('203', '0', '运行内存', '0', '43', '0', '8GB、6GB、4GB、3GB、2GB、2GB以下', '1', '');
INSERT INTO `by_attributes` VALUES ('211', '0', '购买方式', '0', '43', '0', '移动合约、联通合约、电信合约', '1', '');
INSERT INTO `by_attributes` VALUES ('205', '203', '8GB', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('206', '203', '6GB', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('207', '203', '4GB', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('208', '203', '3GB', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('209', '203', '2GB', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('210', '203', '2GB以下', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('212', '211', '移动合约', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('213', '211', '联通合约', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('214', '211', '电信合约', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('215', '0', '前置摄像头像素', '0', '43', '0', '1600万及以上、800万-1599万、500万-799万、200万-499万120万-199万、120万以下', '1', '');
INSERT INTO `by_attributes` VALUES ('216', '215', '1600万及以上', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('217', '215', '800万-1599万', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('218', '215', '500万-799万', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('219', '215', '200万-499万120万-199万', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('220', '215', '120万以下', '0', '43', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('221', '0', '分类', '0', '45', '0', '微型车、小型车、紧凑型车、中型车、中大型车、豪华车、MPV', '1', '');
INSERT INTO `by_attributes` VALUES ('222', '221', '微型车', '0', '45', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('223', '221', '小型车', '0', '45', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('224', '221', '紧凑型车', '0', '45', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('225', '221', '中型车', '0', '45', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('226', '221', '中大型车', '0', '45', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('227', '221', '豪华车', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('228', '221', 'MPV', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('229', '0', '国别', '0', '45', '0', '不限、自主、合资', '1', '');
INSERT INTO `by_attributes` VALUES ('230', '229', '不限', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('231', '229', '自主', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('232', '229', '合资', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('233', '0', '级别', '0', '45', '0', '微型车、小型车、紧凑型车、中型车、中大型车、SUV、MPV 皮卡', '1', '');
INSERT INTO `by_attributes` VALUES ('234', '233', 'SUV', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('235', '233', 'MPV 皮卡', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('236', '0', '相关分类', '0', '46', '0', '市场营销、企业管理与培训、管理学、项目管理、经济计划与管理、管理/电子商务、参考工具书', '1', '');
INSERT INTO `by_attributes` VALUES ('237', '236', '市场营销', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('238', '236', '企业管理与培训', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('239', '236', '管理学', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('240', '236', '项目管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('241', '236', '经济计划与管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('242', '236', '管理/电子商务', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('243', '236', '参考工具书', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('244', '0', '出版社', '0', '46', '0', '电子工业出版社、机械工业出版社、人民邮电出版社、科学出版社、中国社会科学出版社、清华大学出版社、北京大学出版社、东南大学出版社、武汉大学出版社', '1', '');
INSERT INTO `by_attributes` VALUES ('245', '244', '电子工业出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('246', '244', '机械工业出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('247', '244', '人民邮电出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('248', '244', '科学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('249', '244', '中国社会科学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('250', '244', '清华大学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('251', '244', '北京大学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('252', '244', '东南大学出版社', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('253', '244', '武汉大学出版社', '0', '0', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('254', '0', '市场营销类型', '0', '46', '0', '销售管理、广告管理、品牌管理、产品管理、渠道管理、价格管理、客户服务、公共关系、国际市场、互联网', '1', '');
INSERT INTO `by_attributes` VALUES ('255', '254', '销售管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('256', '254', '广告管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('257', '254', '品牌管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('258', '254', '产品管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('259', '254', '渠道管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('260', '254', '价格管理', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('261', '254', '客户服务', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('262', '254', '公共关系', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('263', '254', '国际市场', '0', '46', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('265', '264', '876', '0', '47', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('266', '264', '7687', '0', '47', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('268', '264', '567', '0', '47', '0', '', '1', '');
INSERT INTO `by_attributes` VALUES ('269', '254', '互联网', '0', '46', '0', '', '1', '');

-- ----------------------------
-- Table structure for by_auth_extend
-- ----------------------------
DROP TABLE IF EXISTS `by_auth_extend`;
CREATE TABLE `by_auth_extend` (
  `group_id` mediumint(10) unsigned NOT NULL COMMENT '用户id',
  `extend_id` mediumint(8) unsigned NOT NULL COMMENT '扩展表中数据的id',
  `type` tinyint(1) unsigned NOT NULL COMMENT '扩展类型标识 1:栏目分类权限;2:模型权限',
  UNIQUE KEY `group_extend_type` (`group_id`,`extend_id`,`type`),
  KEY `uid` (`group_id`),
  KEY `group_id` (`extend_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户组与分类的对应关系表';

-- ----------------------------
-- Records of by_auth_extend
-- ----------------------------
INSERT INTO `by_auth_extend` VALUES ('1', '1', '1');
INSERT INTO `by_auth_extend` VALUES ('1', '1', '2');
INSERT INTO `by_auth_extend` VALUES ('1', '2', '1');
INSERT INTO `by_auth_extend` VALUES ('1', '2', '2');
INSERT INTO `by_auth_extend` VALUES ('1', '3', '1');
INSERT INTO `by_auth_extend` VALUES ('1', '3', '2');
INSERT INTO `by_auth_extend` VALUES ('1', '4', '1');
INSERT INTO `by_auth_extend` VALUES ('1', '37', '1');

-- ----------------------------
-- Table structure for by_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `by_auth_group`;
CREATE TABLE `by_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '用户组所属模块',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '组类型',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '用户组中文名称',
  `description` varchar(80) NOT NULL DEFAULT '' COMMENT '描述信息',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,-1为删除',
  `rules` varchar(500) NOT NULL DEFAULT '' COMMENT '用户组拥有的规则id，多个规则 , 隔开',
  `group_id` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_auth_group
-- ----------------------------
INSERT INTO `by_auth_group` VALUES ('6', 'admin', '1', '文员', '', '1', '74,77', '0');
INSERT INTO `by_auth_group` VALUES ('7', 'admin', '1', '美工', '', '1', '74,77,78,127,128,129,133', '0');
INSERT INTO `by_auth_group` VALUES ('8', 'admin', '1', '程序员', '', '1', '', '0');
INSERT INTO `by_auth_group` VALUES ('4', 'admin', '1', '客服', '', '1', '', '0');
INSERT INTO `by_auth_group` VALUES ('5', 'admin', '1', '售后', '', '1', '', '0');

-- ----------------------------
-- Table structure for by_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `by_auth_group_access`;
CREATE TABLE `by_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '用户组id',
  `id` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_auth_group_access
-- ----------------------------
INSERT INTO `by_auth_group_access` VALUES ('6', '3', '0');
INSERT INTO `by_auth_group_access` VALUES ('6', '2', '0');

-- ----------------------------
-- Table structure for by_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `by_auth_rule`;
CREATE TABLE `by_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '规则所属module',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1-url;2-主菜单',
  `name` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一英文标识',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '规则中文描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效(0:无效,1:有效)',
  `condition` varchar(300) NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`),
  KEY `module` (`module`,`status`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=259 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_auth_rule
-- ----------------------------
INSERT INTO `by_auth_rule` VALUES ('1', 'admin', '2', 'Admin/Index/index', '首页', '1', '');
INSERT INTO `by_auth_rule` VALUES ('2', 'admin', '2', 'Admin/Article/index', '文章', '1', '');
INSERT INTO `by_auth_rule` VALUES ('3', 'admin', '2', 'Admin/User/index', '用户', '1', '');
INSERT INTO `by_auth_rule` VALUES ('4', 'admin', '2', 'Admin/Addons/index', '扩展', '1', '');
INSERT INTO `by_auth_rule` VALUES ('5', 'admin', '2', 'Admin/Config/group', '系统', '1', '');
INSERT INTO `by_auth_rule` VALUES ('7', 'admin', '1', 'Admin/article/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('8', 'admin', '1', 'Admin/article/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('9', 'admin', '1', 'Admin/article/setStatus', '改变状态', '1', '');
INSERT INTO `by_auth_rule` VALUES ('10', 'admin', '1', 'Admin/article/update', '保存', '1', '');
INSERT INTO `by_auth_rule` VALUES ('11', 'admin', '1', 'Admin/article/autoSave', '保存草稿', '1', '');
INSERT INTO `by_auth_rule` VALUES ('12', 'admin', '1', 'Admin/article/move', '移动', '1', '');
INSERT INTO `by_auth_rule` VALUES ('13', 'admin', '1', 'Admin/article/copy', '复制', '1', '');
INSERT INTO `by_auth_rule` VALUES ('14', 'admin', '1', 'Admin/article/paste', '粘贴', '1', '');
INSERT INTO `by_auth_rule` VALUES ('15', 'admin', '1', 'Admin/article/permit', '还原', '1', '');
INSERT INTO `by_auth_rule` VALUES ('16', 'admin', '1', 'Admin/article/clear', '清空', '1', '');
INSERT INTO `by_auth_rule` VALUES ('17', 'admin', '1', 'Admin/Article/examine', '审核列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('18', 'admin', '1', 'Admin/article/recycle', '回收站', '1', '');
INSERT INTO `by_auth_rule` VALUES ('19', 'admin', '1', 'Admin/User/addaction', '新增用户行为', '1', '');
INSERT INTO `by_auth_rule` VALUES ('20', 'admin', '1', 'Admin/User/editaction', '编辑用户行为', '1', '');
INSERT INTO `by_auth_rule` VALUES ('21', 'admin', '1', 'Admin/User/saveAction', '保存用户行为', '1', '');
INSERT INTO `by_auth_rule` VALUES ('22', 'admin', '1', 'Admin/User/setStatus', '变更行为状态', '1', '');
INSERT INTO `by_auth_rule` VALUES ('23', 'admin', '1', 'Admin/User/changeStatus?method=forbidUser', '禁用会员', '1', '');
INSERT INTO `by_auth_rule` VALUES ('24', 'admin', '1', 'Admin/User/changeStatus?method=resumeUser', '启用会员', '1', '');
INSERT INTO `by_auth_rule` VALUES ('25', 'admin', '1', 'Admin/User/changeStatus?method=deleteUser', '删除会员', '1', '');
INSERT INTO `by_auth_rule` VALUES ('26', 'admin', '1', 'Admin/User/index', '用户信息', '1', '');
INSERT INTO `by_auth_rule` VALUES ('27', 'admin', '1', 'Admin/User/action', '用户行为', '1', '');
INSERT INTO `by_auth_rule` VALUES ('28', 'admin', '1', 'Admin/AuthManager/changeStatus?method=deleteGroup', '删除', '1', '');
INSERT INTO `by_auth_rule` VALUES ('29', 'admin', '1', 'Admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '1', '');
INSERT INTO `by_auth_rule` VALUES ('30', 'admin', '1', 'Admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '1', '');
INSERT INTO `by_auth_rule` VALUES ('31', 'admin', '1', 'Admin/AuthManager/createGroup', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('32', 'admin', '1', 'Admin/AuthManager/editGroup', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('33', 'admin', '1', 'Admin/AuthManager/writeGroup', '保存用户组', '1', '');
INSERT INTO `by_auth_rule` VALUES ('34', 'admin', '1', 'Admin/AuthManager/group', '授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('35', 'admin', '1', 'Admin/AuthManager/access', '访问授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('36', 'admin', '1', 'Admin/AuthManager/user', '成员授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('37', 'admin', '1', 'Admin/AuthManager/removeFromGroup', '解除授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('38', 'admin', '1', 'Admin/AuthManager/addToGroup', '保存成员授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('39', 'admin', '1', 'Admin/AuthManager/category', '分类授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('40', 'admin', '1', 'Admin/AuthManager/addToCategory', '保存分类授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('41', 'admin', '1', 'Admin/AuthManager/index', '权限管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('42', 'admin', '1', 'Admin/Addons/create', '创建', '1', '');
INSERT INTO `by_auth_rule` VALUES ('43', 'admin', '1', 'Admin/Addons/checkForm', '检测创建', '1', '');
INSERT INTO `by_auth_rule` VALUES ('44', 'admin', '1', 'Admin/Addons/preview', '预览', '1', '');
INSERT INTO `by_auth_rule` VALUES ('45', 'admin', '1', 'Admin/Addons/build', '快速生成插件', '1', '');
INSERT INTO `by_auth_rule` VALUES ('46', 'admin', '1', 'Admin/Addons/config', '设置', '1', '');
INSERT INTO `by_auth_rule` VALUES ('47', 'admin', '1', 'Admin/Addons/disable', '禁用', '1', '');
INSERT INTO `by_auth_rule` VALUES ('48', 'admin', '1', 'Admin/Addons/enable', '启用', '1', '');
INSERT INTO `by_auth_rule` VALUES ('49', 'admin', '1', 'Admin/Addons/install', '安装', '1', '');
INSERT INTO `by_auth_rule` VALUES ('50', 'admin', '1', 'Admin/Addons/uninstall', '卸载', '1', '');
INSERT INTO `by_auth_rule` VALUES ('51', 'admin', '1', 'Admin/Addons/saveconfig', '更新配置', '1', '');
INSERT INTO `by_auth_rule` VALUES ('52', 'admin', '1', 'Admin/Addons/adminList', '插件后台列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('53', 'admin', '1', 'Admin/Addons/execute', 'URL方式访问插件', '1', '');
INSERT INTO `by_auth_rule` VALUES ('54', 'admin', '1', 'Admin/Addons/index', '插件管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('55', 'admin', '1', 'Admin/Addons/hooks', '钩子管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('56', 'admin', '1', 'Admin/model/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('57', 'admin', '1', 'Admin/model/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('58', 'admin', '1', 'Admin/model/setStatus', '改变状态', '1', '');
INSERT INTO `by_auth_rule` VALUES ('59', 'admin', '1', 'Admin/model/update', '保存数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('60', 'admin', '1', 'Admin/Model/index', '模型管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('61', 'admin', '1', 'Admin/Config/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('62', 'admin', '1', 'Admin/Config/del', '删除', '1', '');
INSERT INTO `by_auth_rule` VALUES ('63', 'admin', '1', 'Admin/Config/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('64', 'admin', '1', 'Admin/Config/save', '保存', '1', '');
INSERT INTO `by_auth_rule` VALUES ('65', 'admin', '1', 'Admin/Config/group', '网站设置', '1', '');
INSERT INTO `by_auth_rule` VALUES ('66', 'admin', '1', 'Admin/Config/index', '配置管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('67', 'admin', '1', 'Admin/Channel/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('68', 'admin', '1', 'Admin/Channel/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('69', 'admin', '1', 'Admin/Channel/del', '删除', '1', '');
INSERT INTO `by_auth_rule` VALUES ('70', 'admin', '1', 'Admin/Channel/index', '导航管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('71', 'admin', '1', 'Admin/Category/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('72', 'admin', '1', 'Admin/Category/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('73', 'admin', '1', 'Admin/Category/remove', '删除', '1', '');
INSERT INTO `by_auth_rule` VALUES ('74', 'admin', '1', 'Admin/Category/index', '商品分类', '1', '');
INSERT INTO `by_auth_rule` VALUES ('75', 'admin', '1', 'Admin/file/upload', '上传控件', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('76', 'admin', '1', 'Admin/file/uploadPicture', '上传图片', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('77', 'admin', '1', 'Admin/file/download', '下载', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('94', 'admin', '1', 'Admin/AuthManager/modelauth', '模型授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('79', 'admin', '1', 'Admin/article/batchOperate', '导入', '1', '');
INSERT INTO `by_auth_rule` VALUES ('80', 'admin', '1', 'Admin/Database/index?type=export', '备份数据库', '1', '');
INSERT INTO `by_auth_rule` VALUES ('81', 'admin', '1', 'Admin/Database/index?type=import', '还原数据库', '1', '');
INSERT INTO `by_auth_rule` VALUES ('82', 'admin', '1', 'Admin/Database/export', '备份', '1', '');
INSERT INTO `by_auth_rule` VALUES ('83', 'admin', '1', 'Admin/Database/optimize', '优化表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('84', 'admin', '1', 'Admin/Database/repair', '修复表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('86', 'admin', '1', 'Admin/Database/import', '恢复', '1', '');
INSERT INTO `by_auth_rule` VALUES ('87', 'admin', '1', 'Admin/Database/del', '删除', '1', '');
INSERT INTO `by_auth_rule` VALUES ('88', 'admin', '1', 'Admin/User/add', '新增用户', '1', '');
INSERT INTO `by_auth_rule` VALUES ('89', 'admin', '1', 'Admin/Attribute/index', '属性管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('90', 'admin', '1', 'Admin/Attribute/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('91', 'admin', '1', 'Admin/Attribute/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('92', 'admin', '1', 'Admin/Attribute/setStatus', '改变状态', '1', '');
INSERT INTO `by_auth_rule` VALUES ('93', 'admin', '1', 'Admin/Attribute/update', '保存数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('95', 'admin', '1', 'Admin/AuthManager/addToModel', '保存模型授权', '1', '');
INSERT INTO `by_auth_rule` VALUES ('96', 'admin', '1', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('97', 'admin', '1', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('98', 'admin', '1', 'Admin/Config/menu', '后台菜单管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('99', 'admin', '1', 'Admin/Article/mydocument', '内容', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('100', 'admin', '1', 'Admin/Menu/index', '菜单管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('101', 'admin', '1', 'Admin/other', '其他', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('102', 'admin', '1', 'Admin/Menu/add', '新增', '1', '');
INSERT INTO `by_auth_rule` VALUES ('103', 'admin', '1', 'Admin/Menu/edit', '编辑', '1', '');
INSERT INTO `by_auth_rule` VALUES ('104', 'admin', '1', 'Admin/Think/lists?model=article', '文章管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('105', 'admin', '1', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('106', 'admin', '1', 'Admin/Think/lists?model=config', '配置管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('107', 'admin', '1', 'Admin/Action/actionlog', '行为日志', '1', '');
INSERT INTO `by_auth_rule` VALUES ('108', 'admin', '1', 'Admin/User/updatePassword', '修改密码', '1', '');
INSERT INTO `by_auth_rule` VALUES ('109', 'admin', '1', 'Admin/User/updateNickname', '修改昵称', '1', '');
INSERT INTO `by_auth_rule` VALUES ('110', 'admin', '1', 'Admin/action/edit', '查看行为日志', '1', '');
INSERT INTO `by_auth_rule` VALUES ('205', 'admin', '1', 'Admin/think/add', '新增数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('111', 'admin', '2', 'Admin/article/index', '文档列表', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('112', 'admin', '2', 'Admin/article/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('113', 'admin', '2', 'Admin/article/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('114', 'admin', '2', 'Admin/article/setStatus', '改变状态', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('115', 'admin', '2', 'Admin/article/update', '保存', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('116', 'admin', '2', 'Admin/article/autoSave', '保存草稿', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('117', 'admin', '2', 'Admin/article/move', '移动', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('118', 'admin', '2', 'Admin/article/copy', '复制', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('119', 'admin', '2', 'Admin/article/paste', '粘贴', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('120', 'admin', '2', 'Admin/article/batchOperate', '导入', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('121', 'admin', '2', 'Admin/article/recycle', '回收站', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('122', 'admin', '2', 'Admin/article/permit', '还原', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('123', 'admin', '2', 'Admin/article/clear', '清空', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('124', 'admin', '2', 'Admin/User/add', '新增用户', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('125', 'admin', '2', 'Admin/User/action', '用户行为', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('126', 'admin', '2', 'Admin/User/addAction', '新增用户行为', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('127', 'admin', '2', 'Admin/User/editAction', '编辑用户行为', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('128', 'admin', '2', 'Admin/User/saveAction', '保存用户行为', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('129', 'admin', '2', 'Admin/User/setStatus', '变更行为状态', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('130', 'admin', '2', 'Admin/User/changeStatus?method=forbidUser', '禁用会员', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('131', 'admin', '2', 'Admin/User/changeStatus?method=resumeUser', '启用会员', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('132', 'admin', '2', 'Admin/User/changeStatus?method=deleteUser', '删除会员', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('133', 'admin', '2', 'Admin/AuthManager/index', '权限管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('134', 'admin', '2', 'Admin/AuthManager/changeStatus?method=deleteGroup', '删除', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('135', 'admin', '2', 'Admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('136', 'admin', '2', 'Admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('137', 'admin', '2', 'Admin/AuthManager/createGroup', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('138', 'admin', '2', 'Admin/AuthManager/editGroup', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('139', 'admin', '2', 'Admin/AuthManager/writeGroup', '保存用户组', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('140', 'admin', '2', 'Admin/AuthManager/group', '授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('141', 'admin', '2', 'Admin/AuthManager/access', '访问授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('142', 'admin', '2', 'Admin/AuthManager/user', '成员授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('143', 'admin', '2', 'Admin/AuthManager/removeFromGroup', '解除授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('144', 'admin', '2', 'Admin/AuthManager/addToGroup', '保存成员授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('145', 'admin', '2', 'Admin/AuthManager/category', '分类授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('146', 'admin', '2', 'Admin/AuthManager/addToCategory', '保存分类授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('147', 'admin', '2', 'Admin/AuthManager/modelauth', '模型授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('148', 'admin', '2', 'Admin/AuthManager/addToModel', '保存模型授权', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('149', 'admin', '2', 'Admin/Addons/create', '创建', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('150', 'admin', '2', 'Admin/Addons/checkForm', '检测创建', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('151', 'admin', '2', 'Admin/Addons/preview', '预览', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('152', 'admin', '2', 'Admin/Addons/build', '快速生成插件', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('153', 'admin', '2', 'Admin/Addons/config', '设置', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('154', 'admin', '2', 'Admin/Addons/disable', '禁用', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('155', 'admin', '2', 'Admin/Addons/enable', '启用', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('156', 'admin', '2', 'Admin/Addons/install', '安装', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('157', 'admin', '2', 'Admin/Addons/uninstall', '卸载', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('158', 'admin', '2', 'Admin/Addons/saveconfig', '更新配置', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('159', 'admin', '2', 'Admin/Addons/adminList', '插件后台列表', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('160', 'admin', '2', 'Admin/Addons/execute', 'URL方式访问插件', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('161', 'admin', '2', 'Admin/Addons/hooks', '钩子管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('162', 'admin', '2', 'Admin/Model/index', '模型管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('163', 'admin', '2', 'Admin/model/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('164', 'admin', '2', 'Admin/model/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('165', 'admin', '2', 'Admin/model/setStatus', '改变状态', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('166', 'admin', '2', 'Admin/model/update', '保存数据', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('167', 'admin', '2', 'Admin/Attribute/index', '属性管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('168', 'admin', '2', 'Admin/Attribute/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('169', 'admin', '2', 'Admin/Attribute/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('170', 'admin', '2', 'Admin/Attribute/setStatus', '改变状态', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('171', 'admin', '2', 'Admin/Attribute/update', '保存数据', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('172', 'admin', '2', 'Admin/Config/index', '配置管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('173', 'admin', '2', 'Admin/Config/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('174', 'admin', '2', 'Admin/Config/del', '删除', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('175', 'admin', '2', 'Admin/Config/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('176', 'admin', '2', 'Admin/Config/save', '保存', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('177', 'admin', '2', 'Admin/Menu/index', '菜单管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('178', 'admin', '2', 'Admin/Channel/index', '导航管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('179', 'admin', '2', 'Admin/Channel/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('180', 'admin', '2', 'Admin/Channel/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('181', 'admin', '2', 'Admin/Channel/del', '删除', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('182', 'admin', '2', 'Admin/Category/index', '分类管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('183', 'admin', '2', 'Admin/Category/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('184', 'admin', '2', 'Admin/Category/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('185', 'admin', '2', 'Admin/Category/remove', '删除', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('186', 'admin', '2', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('187', 'admin', '2', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('188', 'admin', '2', 'Admin/Database/index?type=export', '备份数据库', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('189', 'admin', '2', 'Admin/Database/export', '备份', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('190', 'admin', '2', 'Admin/Database/optimize', '优化表', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('191', 'admin', '2', 'Admin/Database/repair', '修复表', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('192', 'admin', '2', 'Admin/Database/index?type=import', '还原数据库', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('193', 'admin', '2', 'Admin/Database/import', '恢复', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('194', 'admin', '2', 'Admin/Database/del', '删除', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('195', 'admin', '2', 'Admin/other', '其他', '1', '');
INSERT INTO `by_auth_rule` VALUES ('196', 'admin', '2', 'Admin/Menu/add', '新增', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('197', 'admin', '2', 'Admin/Menu/edit', '编辑', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('198', 'admin', '2', 'Admin/Think/lists?model=article', '应用', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('199', 'admin', '2', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('200', 'admin', '2', 'Admin/Think/lists?model=config', '应用', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('201', 'admin', '2', 'Admin/Action/actionlog', '行为日志', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('202', 'admin', '2', 'Admin/User/updatePassword', '修改密码', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('203', 'admin', '2', 'Admin/User/updateNickname', '修改昵称', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('204', 'admin', '2', 'Admin/action/edit', '查看行为日志', '-1', '');
INSERT INTO `by_auth_rule` VALUES ('206', 'admin', '1', 'Admin/think/edit', '编辑数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('207', 'admin', '1', 'Admin/Menu/import', '导入', '1', '');
INSERT INTO `by_auth_rule` VALUES ('208', 'admin', '1', 'Admin/Model/generate', '生成', '1', '');
INSERT INTO `by_auth_rule` VALUES ('209', 'admin', '1', 'Admin/Addons/addHook', '新增钩子', '1', '');
INSERT INTO `by_auth_rule` VALUES ('210', 'admin', '1', 'Admin/Addons/edithook', '编辑钩子', '1', '');
INSERT INTO `by_auth_rule` VALUES ('211', 'admin', '1', 'Admin/Article/sort', '文档排序', '1', '');
INSERT INTO `by_auth_rule` VALUES ('212', 'admin', '1', 'Admin/Config/sort', '排序', '1', '');
INSERT INTO `by_auth_rule` VALUES ('213', 'admin', '1', 'Admin/Menu/sort', '排序', '1', '');
INSERT INTO `by_auth_rule` VALUES ('214', 'admin', '1', 'Admin/Channel/sort', '排序', '1', '');
INSERT INTO `by_auth_rule` VALUES ('215', 'admin', '1', 'Admin/Category/operate/type/move', '移动', '1', '');
INSERT INTO `by_auth_rule` VALUES ('216', 'admin', '1', 'Admin/Category/operate/type/merge', '合并', '1', '');
INSERT INTO `by_auth_rule` VALUES ('217', 'admin', '1', 'Admin/article/index', '文档列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('218', 'admin', '1', 'Admin/think/lists', '数据列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('219', 'admin', '1', 'Admin/Attributes/index', '属性配置', '1', '');
INSERT INTO `by_auth_rule` VALUES ('220', 'admin', '1', 'Admin/Brand/index', '品牌管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('221', 'admin', '1', 'Admin/Slide/index', '幻灯片', '1', '');
INSERT INTO `by_auth_rule` VALUES ('222', 'admin', '1', 'Admin/Ad/index', '广告', '1', '');
INSERT INTO `by_auth_rule` VALUES ('223', 'admin', '1', 'Admin/Check/index', '商家审核', '1', '');
INSERT INTO `by_auth_rule` VALUES ('224', 'admin', '1', 'Admin/SellerMenu/index', '后台菜单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('225', 'admin', '1', 'Admin/Types/index', ' 商品类型', '1', '');
INSERT INTO `by_auth_rule` VALUES ('226', 'admin', '1', 'Admin/Order/index', '提交订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('227', 'admin', '1', 'Admin/GoodsAttributes/index', '商品属性', '1', '');
INSERT INTO `by_auth_rule` VALUES ('228', 'admin', '1', 'Admin/Cancel/index', '取消管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('229', 'admin', '1', 'Admin/Catearticle/index', '文章分类', '1', '');
INSERT INTO `by_auth_rule` VALUES ('230', 'admin', '1', 'Admin/Goods/index', '商品列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('231', 'admin', '1', 'Admin/Back/index', '正退货订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('232', 'admin', '1', 'Admin/Stock/index', '库存sku', '1', '');
INSERT INTO `by_auth_rule` VALUES ('233', 'admin', '1', 'Admin/Fcoupon/index', '优惠券', '1', '');
INSERT INTO `by_auth_rule` VALUES ('234', 'admin', '1', 'Admin/Change/index', '换货管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('235', 'admin', '2', 'Admin/Goods/index', '商品', '1', '');
INSERT INTO `by_auth_rule` VALUES ('236', 'admin', '1', 'Admin/Backrefuse/index', '拒绝退货订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('237', 'admin', '2', 'Admin/Order/index', '订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('238', 'admin', '1', 'Admin/UserLog/index', '日志管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('239', 'admin', '1', 'Admin/Backon/index', '退货中订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('240', 'admin', '1', 'Admin/Email/index', '邮件管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('241', 'admin', '1', 'Admin/Backagree/index', '同意退货订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('242', 'admin', '1', 'Admin/Sms/index', '短信管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('243', 'admin', '1', 'Admin/Reserve/index', '预约列表', '1', '');
INSERT INTO `by_auth_rule` VALUES ('244', 'admin', '1', 'Admin/Backover/index', '已退货订单', '1', '');
INSERT INTO `by_auth_rule` VALUES ('245', 'admin', '1', 'Admin/Pay/index', '支付管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('246', 'admin', '1', 'Admin/Envelope/index', '站内信管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('247', 'admin', '1', 'Admin/Express/index', ' 快递管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('248', 'admin', '2', 'Admin/Slide/index', '广告', '1', '');
INSERT INTO `by_auth_rule` VALUES ('249', 'admin', '1', 'Admin/Message/index', '留言管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('250', 'admin', '1', 'Admin/Reply/index', '回复管理', '1', '');
INSERT INTO `by_auth_rule` VALUES ('251', 'admin', '2', 'Admin/Check/index', '商家', '1', '');
INSERT INTO `by_auth_rule` VALUES ('252', 'admin', '1', 'Admin/Statistics/index', '今日销量统计', '1', '');
INSERT INTO `by_auth_rule` VALUES ('253', 'admin', '1', 'Admin/Statistics/week', '本周销量统计', '1', '');
INSERT INTO `by_auth_rule` VALUES ('254', 'admin', '1', 'Admin/Statistics/month', '本月销量统计', '1', '');
INSERT INTO `by_auth_rule` VALUES ('255', 'admin', '1', 'Admin/Report/index', '每日数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('256', 'admin', '1', 'Admin/Report/week', '每周数据', '1', '');
INSERT INTO `by_auth_rule` VALUES ('257', 'admin', '1', 'Admin/Report/month', '每月统计', '1', '');
INSERT INTO `by_auth_rule` VALUES ('258', 'admin', '1', 'Admin/Lookup/index', '流量统计', '1', '');

-- ----------------------------
-- Table structure for by_backup
-- ----------------------------
DROP TABLE IF EXISTS `by_backup`;
CREATE TABLE `by_backup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) DEFAULT NULL COMMENT '文件名',
  `type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=181 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='备份还原表';

-- ----------------------------
-- Records of by_backup
-- ----------------------------
INSERT INTO `by_backup` VALUES ('178', '20191210110537_all_v1.sql', '1', '1575947137');
INSERT INTO `by_backup` VALUES ('179', '20191210111128_all_v1.sql', '1', '1575947488');
INSERT INTO `by_backup` VALUES ('180', '20200214201505_all_v1.sql', '1', '1581682505');

-- ----------------------------
-- Table structure for by_bank
-- ----------------------------
DROP TABLE IF EXISTS `by_bank`;
CREATE TABLE `by_bank` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `username` varchar(255) DEFAULT NULL COMMENT '标题',
  `name` varchar(255) DEFAULT NULL COMMENT '链接',
  `account` varchar(255) DEFAULT NULL COMMENT '位置',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='银行卡';

-- ----------------------------
-- Records of by_bank
-- ----------------------------

-- ----------------------------
-- Table structure for by_bonus
-- ----------------------------
DROP TABLE IF EXISTS `by_bonus`;
CREATE TABLE `by_bonus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `title` varchar(225) DEFAULT NULL,
  `intro` varchar(225) DEFAULT NULL,
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='用户红包表';

-- ----------------------------
-- Records of by_bonus
-- ----------------------------
INSERT INTO `by_bonus` VALUES ('9', '5.00', '1', '1534984418', '1545870818', '1', '双十一专享红包', '仅限双十一在天猫平台使用', '40.00');

-- ----------------------------
-- Table structure for by_bonuses
-- ----------------------------
DROP TABLE IF EXISTS `by_bonuses`;
CREATE TABLE `by_bonuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `title` varchar(225) DEFAULT NULL,
  `intro` varchar(225) DEFAULT NULL,
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='系统红包表';

-- ----------------------------
-- Records of by_bonuses
-- ----------------------------

-- ----------------------------
-- Table structure for by_brand
-- ----------------------------
DROP TABLE IF EXISTS `by_brand`;
CREATE TABLE `by_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '标志',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `price` varchar(50) NOT NULL DEFAULT '' COMMENT '金额',
  `code` varchar(255) NOT NULL COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `meta_title` varchar(100) NOT NULL DEFAULT '',
  `allow_publish` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图标',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `goodid` varchar(225) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `uk_name` (`name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='品牌表';

-- ----------------------------
-- Records of by_brand
-- ----------------------------
INSERT INTO `by_brand` VALUES ('1', 'Maxwell', '麦斯威尔', '', '', '', '', '0', '1', '1442509490', '1442572614', '1', '119', '52', '');
INSERT INTO `by_brand` VALUES ('4', 'ylrh\'', '元朗荣华', '', '', '', '', '0', '1', '1442576731', '1442576731', '1', '120', '57', '');
INSERT INTO `by_brand` VALUES ('5', 'jrkj', '肌肉科技', '', '', '', '', '0', '1', '1442576899', '1442576899', '1', '121', '57', '');
INSERT INTO `by_brand` VALUES ('6', 'ychdzx', '阳澄湖大闸蟹', '', '', '', '', '0', '1', '1442576947', '1442576947', '1', '122', '52', '');
INSERT INTO `by_brand` VALUES ('7', 'hennessy', 'hennessy', '', '', '', '', '0', '1', '1442577280', '1442577280', '1', '123', '52', '');
INSERT INTO `by_brand` VALUES ('8', 'dxc', '稻香村', '', '', '', '', '0', '1', '1442577327', '1442577327', '1', '124', '57', '');
INSERT INTO `by_brand` VALUES ('9', 'gzmt', '贵州茅台', '', '', '', '', '0', '1', '1442577383', '1442577383', '1', '125', '52', '');
INSERT INTO `by_brand` VALUES ('10', 'lafei', '拉菲', '', '', '', '', '0', '1', '1442577421', '1442577421', '1', '126', '52', '');
INSERT INTO `by_brand` VALUES ('11', 'bsl', '博士伦', '', '', '', '', '0', '1', '1442577594', '1442577594', '1', '127', '57', '');
INSERT INTO `by_brand` VALUES ('12', 'qhsj', '奇华世家', '', '', '', '', '0', '1', '1442588150', '1442588150', '1', '132', '52', '');
INSERT INTO `by_brand` VALUES ('13', 'lppz', '良品铺子', '', '', '', '', '0', '1', '1442588302', '1442588302', '1', '133', '52', '');
INSERT INTO `by_brand` VALUES ('14', 'dzph', '德州扒鹤', '', '', '', '', '0', '1', '1442588386', '1442588386', '1', '134', '57', '');
INSERT INTO `by_brand` VALUES ('15', 'AOC', '冠捷', '', '', '', '', '0', '1', '1442655509', '1442655509', '1', '135', '107', '');
INSERT INTO `by_brand` VALUES ('16', 'lenovo', '联想', '', '', '', '', '0', '1', '1442655587', '1442655587', '1', '136', '107', '');
INSERT INTO `by_brand` VALUES ('17', 'hp', '惠普打印', '', '', '', '', '0', '1', '1442655629', '1442655629', '1', '137', '107', '');
INSERT INTO `by_brand` VALUES ('18', 'leishen', '雷神', '', '', '', '', '0', '1', '1442655789', '1442655789', '1', '138', '107', '');
INSERT INTO `by_brand` VALUES ('19', 'acer', '宏碁', '', '', '', '', '0', '1', '1442655887', '1442655887', '1', '139', '107', '');
INSERT INTO `by_brand` VALUES ('20', 'samsung', '三星', '', '', '', '', '0', '1', '1442655930', '1442655930', '1', '140', '107', '');
INSERT INTO `by_brand` VALUES ('21', 'midea', '美的', '', '', '', '', '0', '1', '1442655970', '1442655970', '1', '141', '107', '');
INSERT INTO `by_brand` VALUES ('22', 'apple', '苹果', '', '', '', '', '0', '1', '1442656023', '1442656023', '1', '142', '107', '');
INSERT INTO `by_brand` VALUES ('23', 'flyco', '飞科', '', '', '', '', '0', '1', '1442656073', '1442656073', '1', '143', '107', '');
INSERT INTO `by_brand` VALUES ('24', 'blueair', '布鲁雅尔', '', '', '', '', '0', '1', '1442656143', '1442656143', '1', '144', '107', '');
INSERT INTO `by_brand` VALUES ('25', 'LG', 'LG', '', '', '', '', '0', '1', '1442656437', '1442656437', '1', '145', '107', '');

-- ----------------------------
-- Table structure for by_cart
-- ----------------------------
DROP TABLE IF EXISTS `by_cart`;
CREATE TABLE `by_cart` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(50) DEFAULT NULL COMMENT '商品数量',
  `price` varchar(225) NOT NULL DEFAULT '' COMMENT '商品价格',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '商品名称',
  `sku_id` varchar(225) NOT NULL DEFAULT '' COMMENT '库存序号',
  `specifications` varchar(225) NOT NULL DEFAULT '' COMMENT '商品参数',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `path` varchar(225) DEFAULT NULL,
  `key` varchar(225) DEFAULT NULL,
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  `cart_shop_id` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=500 DEFAULT CHARSET=utf8 COMMENT='购物车表';

-- ----------------------------
-- Records of by_cart
-- ----------------------------
INSERT INTO `by_cart` VALUES ('387', '223', '79', '3', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '598', '0');
INSERT INTO `by_cart` VALUES ('388', '203', '79', '3', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0', '598', '0');
INSERT INTO `by_cart` VALUES ('389', '169', '79', '2', '77.00', '', '221', '&nbsp;', '0', '', null, '0', '598', '0');
INSERT INTO `by_cart` VALUES ('390', '175', '79', '1', '435.00', '', '250', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('391', '224', '80', '1', '0.10', '', '354', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('392', '169', '80', '1', '77.00', '', '221', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('393', '223', '80', '3', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('449', '167', '83', '1', '34.00', '', '219', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('448', '203', '83', '2', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('446', '223', '83', '8', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('447', '170', '83', '4', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('451', '167', '81', '2', '34.00', '', '219', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('452', '223', '81', '3', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('450', '224', '83', '1', '0.10', '', '354', '&nbsp;', '0', '', null, '0', '0', '1');
INSERT INTO `by_cart` VALUES ('471', '223', '87', '1', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('476', '224', '84', '28', '0.10', '', '354', '&nbsp;', '0', '', null, '0', '701', '1');
INSERT INTO `by_cart` VALUES ('477', '170', '84', '5', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('478', '175', '84', '8', '435.00', '', '250', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('479', '168', '84', '5', '99.00', '', '220', '&nbsp;', '0', '', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('480', '223', '84', '4', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('481', '225', '84', '3', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('482', '203', '84', '1', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('483', '227', '84', '2', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('484', '179', '84', '1', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0', '702', '0');
INSERT INTO `by_cart` VALUES ('485', '162', '84', '2', '0.10', '', '214', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('486', '194', '84', '1', '434.00', '', '304', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('487', '170', '84', '1', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('488', '166', '84', '1', '30.00', '', '218', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('489', '183', '84', '1', '234.00', '', '284', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('490', '168', '84', '2', '99.00', '', '220', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('491', '177', '84', '1', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('492', '175', '97', '3', '435.00', '', '250', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('493', '186', '97', '1', '234.00', '', '293', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('494', '170', '97', '3', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('495', '224', '97', '3', '0.10', '', '354', '&nbsp;', '0', '', null, '0', '0', '1');
INSERT INTO `by_cart` VALUES ('496', '170', '97', '2', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '10');
INSERT INTO `by_cart` VALUES ('497', '170', '84', '1', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('498', '223', '97', '1', '12.00', '', '353', '&nbsp;', '0', '', null, '0', '0', '0');
INSERT INTO `by_cart` VALUES ('499', '170', '84', '1', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0', '0', '10');

-- ----------------------------
-- Table structure for by_cart_shop
-- ----------------------------
DROP TABLE IF EXISTS `by_cart_shop`;
CREATE TABLE `by_cart_shop` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `shop_id` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `code` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=703 DEFAULT CHARSET=utf8 COMMENT='登录用户购物车拆分表';

-- ----------------------------
-- Records of by_cart_shop
-- ----------------------------
INSERT INTO `by_cart_shop` VALUES ('598', '79', '0', '0', '1584280028', '1', 'KTAfO6FFcZ');
INSERT INTO `by_cart_shop` VALUES ('602', '81', '0', '10', '1585633968', '1', 'Y6rrd1HOA7');
INSERT INTO `by_cart_shop` VALUES ('601', '81', '0', '0', '1585633968', '1', 'Y6rrd1HOA7');
INSERT INTO `by_cart_shop` VALUES ('603', '81', '0', '0', '1585633971', '1', 'c9fySTwLQV');
INSERT INTO `by_cart_shop` VALUES ('604', '81', '0', '10', '1585633971', '1', 'c9fySTwLQV');
INSERT INTO `by_cart_shop` VALUES ('605', '81', '0', '0', '1585633976', '1', 'TdVWAX4qpU');
INSERT INTO `by_cart_shop` VALUES ('606', '81', '0', '10', '1585633976', '1', 'TdVWAX4qpU');
INSERT INTO `by_cart_shop` VALUES ('607', '81', '0', '0', '1585633977', '1', '98m0bRq4j2');
INSERT INTO `by_cart_shop` VALUES ('608', '81', '0', '10', '1585633977', '1', '98m0bRq4j2');
INSERT INTO `by_cart_shop` VALUES ('609', '81', '0', '0', '1585633982', '1', 'TZ7ns4c3P9');
INSERT INTO `by_cart_shop` VALUES ('610', '81', '0', '10', '1585633982', '1', 'TZ7ns4c3P9');
INSERT INTO `by_cart_shop` VALUES ('611', '81', '0', '0', '1585633996', '1', 'PSWFCPRRfp');
INSERT INTO `by_cart_shop` VALUES ('612', '81', '0', '10', '1585633996', '1', 'PSWFCPRRfp');
INSERT INTO `by_cart_shop` VALUES ('613', '81', '0', '0', '1585634021', '1', '7mDXNA1boi');
INSERT INTO `by_cart_shop` VALUES ('614', '81', '0', '10', '1585634021', '1', '7mDXNA1boi');
INSERT INTO `by_cart_shop` VALUES ('615', '81', '0', '0', '1585634027', '1', 'fhukKzTlCa');
INSERT INTO `by_cart_shop` VALUES ('616', '81', '0', '10', '1585634027', '1', 'fhukKzTlCa');
INSERT INTO `by_cart_shop` VALUES ('617', '81', '0', '0', '1585634032', '1', 'BiC0zvg7fX');
INSERT INTO `by_cart_shop` VALUES ('618', '81', '0', '10', '1585634032', '1', 'BiC0zvg7fX');
INSERT INTO `by_cart_shop` VALUES ('619', '81', '0', '0', '1585634113', '1', '8n9xMgLMj5');
INSERT INTO `by_cart_shop` VALUES ('620', '81', '0', '10', '1585634113', '1', '8n9xMgLMj5');
INSERT INTO `by_cart_shop` VALUES ('621', '81', '0', '0', '1585634125', '1', 'YMTAqlqDWb');
INSERT INTO `by_cart_shop` VALUES ('622', '81', '0', '10', '1585634125', '1', 'YMTAqlqDWb');
INSERT INTO `by_cart_shop` VALUES ('623', '81', '0', '0', '1585634131', '1', '5bGaCQ4aPO');
INSERT INTO `by_cart_shop` VALUES ('624', '81', '0', '10', '1585634131', '1', '5bGaCQ4aPO');
INSERT INTO `by_cart_shop` VALUES ('625', '81', '0', '0', '1585634139', '1', 'c0dJF1OfWx');
INSERT INTO `by_cart_shop` VALUES ('626', '81', '0', '10', '1585634139', '1', 'c0dJF1OfWx');
INSERT INTO `by_cart_shop` VALUES ('627', '81', '0', '0', '1585634146', '1', '6udo81TWfH');
INSERT INTO `by_cart_shop` VALUES ('628', '81', '0', '10', '1585634146', '1', '6udo81TWfH');
INSERT INTO `by_cart_shop` VALUES ('629', '81', '0', '0', '1585634148', '1', 'u29Owppxrv');
INSERT INTO `by_cart_shop` VALUES ('630', '81', '0', '10', '1585634148', '1', 'u29Owppxrv');
INSERT INTO `by_cart_shop` VALUES ('631', '81', '0', '0', '1585634150', '1', 'zlKDzULVO6');
INSERT INTO `by_cart_shop` VALUES ('632', '81', '0', '10', '1585634150', '1', 'zlKDzULVO6');
INSERT INTO `by_cart_shop` VALUES ('633', '81', '0', '0', '1585634153', '1', 'NvFmvAoU8f');
INSERT INTO `by_cart_shop` VALUES ('634', '81', '0', '10', '1585634153', '1', 'NvFmvAoU8f');
INSERT INTO `by_cart_shop` VALUES ('635', '81', '0', '0', '1585634169', '1', 'VqyzMojGrJ');
INSERT INTO `by_cart_shop` VALUES ('636', '81', '0', '10', '1585634169', '1', 'VqyzMojGrJ');
INSERT INTO `by_cart_shop` VALUES ('637', '81', '0', '0', '1585634178', '1', 'qMWrASiKTu');
INSERT INTO `by_cart_shop` VALUES ('638', '81', '0', '10', '1585634178', '1', 'qMWrASiKTu');
INSERT INTO `by_cart_shop` VALUES ('639', '81', '0', '0', '1585634184', '1', 'kXfL4u689p');
INSERT INTO `by_cart_shop` VALUES ('640', '81', '0', '10', '1585634184', '1', 'kXfL4u689p');
INSERT INTO `by_cart_shop` VALUES ('641', '81', '0', '0', '1585634213', '1', '1JTuunrMbx');
INSERT INTO `by_cart_shop` VALUES ('642', '81', '0', '10', '1585634213', '1', '1JTuunrMbx');
INSERT INTO `by_cart_shop` VALUES ('643', '81', '0', '0', '1585634243', '1', 'e3Nbq6wsBm');
INSERT INTO `by_cart_shop` VALUES ('644', '81', '0', '10', '1585634243', '1', 'e3Nbq6wsBm');
INSERT INTO `by_cart_shop` VALUES ('645', '81', '0', '0', '1585634315', '1', 'jhXr5wrSpu');
INSERT INTO `by_cart_shop` VALUES ('646', '81', '0', '10', '1585634315', '1', 'jhXr5wrSpu');
INSERT INTO `by_cart_shop` VALUES ('652', '81', '0', '10', '1585645978', '1', 'DnFPcWPv7f');
INSERT INTO `by_cart_shop` VALUES ('653', '81', '0', '0', '1585645978', '1', 'DnFPcWPv7f');
INSERT INTO `by_cart_shop` VALUES ('654', '81', '0', '0', '1587646507', '1', 'P9JeHMxOZI');
INSERT INTO `by_cart_shop` VALUES ('655', '81', '0', '10', '1587646507', '1', 'P9JeHMxOZI');
INSERT INTO `by_cart_shop` VALUES ('656', '81', '0', '1', '1587646507', '1', 'P9JeHMxOZI');
INSERT INTO `by_cart_shop` VALUES ('661', '81', '0', '1', '1590293021', '1', 'GyakYq7g2Q');
INSERT INTO `by_cart_shop` VALUES ('665', '85', '0', '0', '1594633673', '1', '0Yh4uq6wVP');
INSERT INTO `by_cart_shop` VALUES ('666', '85', '0', '0', '1594633674', '1', 'NkH1TVnXx2');
INSERT INTO `by_cart_shop` VALUES ('667', '85', '0', '0', '1594633675', '1', 'wM0HBeWbOY');
INSERT INTO `by_cart_shop` VALUES ('668', '85', '0', '0', '1594633680', '1', 'pv82gNLpdv');
INSERT INTO `by_cart_shop` VALUES ('669', '85', '0', '0', '1594633681', '1', 'v1JmaYpuJU');
INSERT INTO `by_cart_shop` VALUES ('670', '85', '0', '0', '1594634274', '1', '5XjzIZYZkb');
INSERT INTO `by_cart_shop` VALUES ('671', '85', '0', '0', '1594634277', '1', 'ilZLAvkqxX');
INSERT INTO `by_cart_shop` VALUES ('672', '85', '0', '0', '1594637354', '1', 'KJvzi4Zmqb');
INSERT INTO `by_cart_shop` VALUES ('673', '85', '0', '0', '1594645883', '1', 'ImoNJNMMoi');
INSERT INTO `by_cart_shop` VALUES ('674', '85', '0', '0', '1594645884', '1', 'xZfQ3Vw6Da');
INSERT INTO `by_cart_shop` VALUES ('675', '85', '0', '0', '1594645904', '1', 'U7KZLEe2kf');
INSERT INTO `by_cart_shop` VALUES ('676', '85', '0', '0', '1594645908', '1', 'VPaFTM40PI');
INSERT INTO `by_cart_shop` VALUES ('682', '84', '0', '0', '1594972804', '1', '0t2PhZ3iz4');
INSERT INTO `by_cart_shop` VALUES ('681', '84', '0', '0', '1594972643', '1', '3cvzgAYcLO');
INSERT INTO `by_cart_shop` VALUES ('683', '84', '0', '0', '1594972821', '1', '0kzIH2WqJR');
INSERT INTO `by_cart_shop` VALUES ('686', '85', '0', '0', '1595307516', '1', 'JFC1N1XzWJ');
INSERT INTO `by_cart_shop` VALUES ('687', '85', '0', '0', '1595307516', '1', 'YyK2rDiTQy');
INSERT INTO `by_cart_shop` VALUES ('688', '85', '0', '0', '1595308733', '1', 'McjjrShoJ8');
INSERT INTO `by_cart_shop` VALUES ('689', '85', '0', '0', '1595308734', '1', '608KdSpfAd');
INSERT INTO `by_cart_shop` VALUES ('690', '85', '0', '0', '1595308736', '1', '1tv5A9VlVT');
INSERT INTO `by_cart_shop` VALUES ('692', '84', '0', '0', '1595475991', '1', 'XBfBgf3aGg');
INSERT INTO `by_cart_shop` VALUES ('693', '84', '0', '0', '1595475994', '1', 'z7GBQ1W0ON');
INSERT INTO `by_cart_shop` VALUES ('695', '104', '0', '0', '1595508717', '1', 'OfLSi8JGWL');
INSERT INTO `by_cart_shop` VALUES ('696', '104', '0', '0', '1595508728', '1', '7nOmTfz5EE');
INSERT INTO `by_cart_shop` VALUES ('697', '104', '0', '0', '1595508729', '1', 'LzmXyUYIvh');
INSERT INTO `by_cart_shop` VALUES ('699', '84', '0', '1', '1597924146', '1', 'lJh7gGvX2d');
INSERT INTO `by_cart_shop` VALUES ('700', '84', '0', '0', '1597924146', '1', 'lJh7gGvX2d');
INSERT INTO `by_cart_shop` VALUES ('701', '84', '0', '1', '1597924150', '1', '1uDat4rjYH');
INSERT INTO `by_cart_shop` VALUES ('702', '84', '0', '0', '1597924150', '1', '1uDat4rjYH');

-- ----------------------------
-- Table structure for by_cash
-- ----------------------------
DROP TABLE IF EXISTS `by_cash`;
CREATE TABLE `by_cash` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `content` varchar(225) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT '0',
  `bank` varchar(255) DEFAULT NULL,
  `account` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `percent` varchar(255) DEFAULT NULL,
  `arrive_money` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='现金表';

-- ----------------------------
-- Records of by_cash
-- ----------------------------
INSERT INTO `by_cash` VALUES ('47', '2.00', '82', '0', '1525644392', '0.00', '12344', '', '0', '        <view>建设银行（6200********0000）</view>\r\n建设银行', 'asdsd', '34534543', null, null);
INSERT INTO `by_cash` VALUES ('48', '2.00', '82', '0', '1525644395', '0.00', '12344', '', '2', '建设银行', 'asdsa546456', '34534534', null, null);
INSERT INTO `by_cash` VALUES ('49', '2.00', '82', '0', '1525644455', '0.00', '222', '1', '1', '建设银行', '76876785674564564545645635', '3453454354', null, null);
INSERT INTO `by_cash` VALUES ('50', '5.00', '0', '0', '1592118171', '0.00', null, null, '0', 'asdas', 'asdas', 'fasfa', '5%', '4.75');
INSERT INTO `by_cash` VALUES ('51', '5.00', '104', '0', '1592118263', '190.00', null, null, '0', 'asdas', 'asdas', 'fasfa', '5%', '4.75');
INSERT INTO `by_cash` VALUES ('52', '6.00', '104', '0', '1592118420', '184.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '5.7');
INSERT INTO `by_cash` VALUES ('53', '6.00', '104', '0', '1592118453', '178.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '5.7');
INSERT INTO `by_cash` VALUES ('54', '17.00', '104', '0', '1592140117', '161.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '16.15');
INSERT INTO `by_cash` VALUES ('55', '123.00', '104', '0', '1592199512', '38.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '116.85');
INSERT INTO `by_cash` VALUES ('56', '88.00', '104', '0', '1592393045', '3800.00', '申请提现', null, '0', '123456', '123456', '123456', '5%', '83.6');
INSERT INTO `by_cash` VALUES ('57', '10.00', '82', '0', '1593271715', '416.00', '申请提现', null, '0', 'fgfdfg', 'gh_29acb9247af4', 'sdfdsf', '5%', '9.5');
INSERT INTO `by_cash` VALUES ('58', '10.00', '82', '0', '1593271799', '406.00', '申请提现', null, '0', 'fgfdfg', 'gh_29acb9247af4', 'yershop', '5%', '9.5');

-- ----------------------------
-- Table structure for by_cash_log
-- ----------------------------
DROP TABLE IF EXISTS `by_cash_log`;
CREATE TABLE `by_cash_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `shop_id` varchar(255) DEFAULT NULL COMMENT '店铺编号',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `money` decimal(50,2) DEFAULT NULL COMMENT '金额',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '处理时间',
  `percent` varchar(225) DEFAULT NULL,
  `arrive_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) NOT NULL DEFAULT '0',
  `username` varchar(225) DEFAULT NULL,
  `account` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_cash_log
-- ----------------------------

-- ----------------------------
-- Table structure for by_cate
-- ----------------------------
DROP TABLE IF EXISTS `by_cate`;
CREATE TABLE `by_cate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `sort` int(1) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `name` varchar(225) DEFAULT NULL,
  `content` text NOT NULL COMMENT '内容',
  `type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章分类表';

-- ----------------------------
-- Records of by_cate
-- ----------------------------
INSERT INTO `by_cate` VALUES ('5', '0', '关于我们', '2', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('2', '1', '购物流程', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('6', '5', '关于我们', '0', '1', '', '<p>\r\n	<span style=\"font-size:16px;color:#000000;\"> </span>\r\n</p>\r\n<p>\r\n	<span style=\"font-size:16px;\">\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp;yershop商城（yershop.com）-是xx有限公司旗下专业的综合网上购物商城，在线销售家用电器、数码通讯、电脑、家居百货、服装服饰、母婴、图书、食品、在线旅游等数万个品牌千万种优质商品。&nbsp;\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 目前，yershop商城在线销售涵盖食品饮料、酒水、生鲜、进口食品、进口牛奶、美容化妆、个人护理、服饰鞋靴、厨卫清洁、母婴用品、手机数码、家居家纺、家用电器、保健用品、箱包珠宝、运动用品及礼品卡等商品。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 淘库商城以“诚信”为本，在供应商筛选、商品质量管理和商品入库、入驻商家引进及日常运营监管等环节上，由专业人员严格把关，保障商品和服务的高质量，并严格遵照国家有关“三包”的法律法规，让顾客放心购买。&nbsp; &nbsp;&nbsp;\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 与传统零售相比，yershop商城有3-5%的运营成本优势，同时，通过建立高效优化的供应链，节省采购、仓储、配送、售后服务等各个环节的成本并回馈给顾客，并通过科学的价格管理，保证淘库商城的价格优惠。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; yershop商城将在全国一百多城市成立分公司并建立自配送物流体系。提供当天达、次日达、隔日达以满足顾客快速收货的需求。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		<span style=\"font-family:&quot;\">淘库商城（yershop.com)-全球优选、正品低价、送货到家、简单网购！</span>&nbsp;网站公告:<span style=\"color:#337FE5;\"><a href=\"https://yershop.com\" target=\"_blank\">https:/yershop.com</a></span>&nbsp;\r\n	</p>\r\n</span>\r\n</p>\r\n<h3 style=\"vertical-align:baseline;text-align:center;\">\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span> \r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;color:#000000;\"></span> \r\n	</div>\r\n</span> \r\n</h3>\r\n<p style=\"color:#2F2F2F;font-family:&quot;font-size:0.3rem;><br />\r\n	</p>\r\n<span style=\" color:#777777;font-family:simsun,=\"\" arial,=\"\" helvetica,=\"\" clean,=\"\" sans-serif;background-color:#ffffff;font-size:16px;\"=\"\"><span style=\"color:#666666;font-family:微软雅黑;background-color:#F5F5F5;font-size:14px;\"></span> \r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('9', '5', '联系我们', '0', '1', '', '联系我们<br />\r\n欢迎来到xx商城。<br />\r\n<br />\r\n关于xx商城的使用问题、改进建议，或举报不良信息，请点击每个网页右下角：意见反馈。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n服务热线：<br />\r\n<br />\r\nxx商城客服：国内 4006-345-678 海外 +86-10-8341-6888<br />\r\n<br />\r\n服务邮箱：<br />\r\n<br />\r\nxx商城广告部：AD@mafengwo.com<br />\r\n<br />\r\nxx商城商城商务合作：sales-cooperation@mafengwo.com (如需申请入驻xx商城旅行商城,请在线提交申请:http://www.mafengwo.cn/sales/alliance.php)<br />\r\n<br />\r\nxx商城内容及流量合作：hezuo@mafengwo.com （邮件请注明“内容合作”或“流量合作”）<br />\r\n<br />\r\nxx商城品牌市场部：pr@mafengwo.com<br />\r\n<br />\r\n酒店及OTA合作：hotel@mafengwo.com（如需申请入驻xx商城酒店，请在线提交申请https://w.mafengwo.cn/hotel_open_platform/#/register/welcome）<br />\r\n<br />\r\n其他：<br />\r\n<br />\r\n创建新商户（餐厅、景点）： http://www.mafengwo.cn/poi/add.php<br />\r\n<br />\r\nxx商城（贵州公司）：贵州省贵阳市观山湖区毕节路58号联合广场A栋24层<br />\r\n<br />\r\nxx商城全球总部：北京市朝阳区酒仙桥北路9号院恒通国际创新园C9xx商城<br />', '1');
INSERT INTO `by_cate` VALUES ('10', '5', '用户协议', '0', '1', '', '<p>\r\n	<span style=\"font-size:16px;\">北京xx科技有限公司（以下简称“xx科技”）在此特别提醒您（用户）在注册成为用户之前，请认真阅读本《用户协议》（以下简称“协议”），确保您充分理解本协议中各条款。请您审慎阅读并选择接受或不接受本协议。除非您接受本协议所有条款，否则您无权注册、登录或使用本协议所涉服务。您的注册、登录、使用等行为将视为对本协议的接受，并同意接受本协议各项条款的约束。<br />\r\n<br />\r\n本协议约定xx科技与用户之间关于“xx”软件服务（以下简称“服务”）的权利义务。“用户”是指注册、登录、使用本服务的个人。本协议可由xx科技随时更新，更新后的协议条款一旦公布即代替原来的协议条款，恕不再另行通知，用户可在本网站查阅最新版协议条款。在xx科技修改协议条款后，如果用户不接受修改后的条款，请立即停止使用xx科技提供的服务，用户继续使用xx科技提供的服务将被视为接受修改后的协议。<br />\r\n<br />\r\n一、帐号注册<br />\r\n1、用户在使用本服务前需要注册一个“xx”帐号。“xx”帐号应当使用手机号码绑定注册，请用户使用尚未与“xx”帐号绑定的手机号码，以及未被xx科技根据本协议封禁的手机号码注册“xx”帐号。xx科技可以根据用户需求或产品需要对帐号注册和绑定的方式进行变更，而无须事先通知用户。<br />\r\n<br />\r\n2、“xx”系基于地理位置的移动社交产品，用户注册时应当授权xx科技公开及使用其地理位置信息方可成功注册“xx”帐号。故用户完成注册即表明用户同意xx科技提取、公开及使用用户的地理位置信息。如用户需要终止向其他用户公开其地理位置信息，可自行设置为隐身状态。<br />\r\n<br />\r\n3、鉴于“xx”帐号的绑定注册方式，您同意xx科技在注册时将使用您提供的手机号码及/或自动提取您的手机号码及自动提取您的手机设备识别码等信息用于注册。您同意给予运营商授权，授权运营商有权自动提取您的手机号码进行认证并用于“xx”账号注册，您保证遵守运营商的相关服务条款（点击查看服务条款），如运营商对您的手机号认证成功，则您的注册即完成。如您不同意对运营商的授权和/或服务条款或者是您的手机号认证失败，您可以手动修改运营商提取的手机号码，采取验证码方式进行注册登录。<br />\r\n<br />\r\n4、在用户注册及使用本服务时，xx科技需要搜集能识别用户身份的个人信息以便xx科技可以在必要时联系用户，或为用户提供更好的使用体验。xx科技搜集的信息包括但不限于用户的姓名、性别、年龄、出生日期、身份证号、地址、学校情况、公司情况、所属行业、兴趣爱好、常出没的地方、个人说明；xx科技同意对这些信息的使用将受限于第三条用户个人隐私信息保护的约束。<br />\r\n<br />\r\n二、服务内容<br />\r\n1、本服务的具体内容由xx科技根据实际情况提供，包括但不限于授权用户通过其帐号进行即时通讯、添加好友、加入群组、关注他人、发布留言。xx科技可以对其提供的服务予以变更，且xx科技提供的服务内容可能随时变更；用户将会收到xx科技关于服务变更的通知。<br />\r\n<br />\r\n2、xx科技提供的服务包含免费服务与收费服务。用户可以通过付费方式购买收费服务，具体方式为：用户通过网上银行、支付宝或其他“xx”平台提供的付费途径支付一定数额的人民币购买“xx”平台的虚拟货币——xx币，然后根据xx科技公布的资费标准以xx币购买用户欲使用的收费服务，从而获得收费服务使用权限。对于收费服务，xx科技会在用户使用之前给予用户明确的提示，只有用户根据提示确认其同意按照前述支付方式支付费用并完成了支付行为，用户才能使用该等收费服务。支付行为的完成以银行或第三方支付平台生成“支付已完成”的确认通知为准。<br />\r\n<br />\r\n三、用户个人信息保护<br />\r\n1、用户在注册帐号或使用本服务的过程中，可能需要填写或提交一些必要的个人信息，如法律法规、规章规范性文件（以下称“法律法规”）规定的需要填写的身份信息。如用户提交的信息不完整或不符合法律法规的规定，则用户可能无法使用本服务或在使用本服务的过程中受到限制。<br />\r\n<br />\r\n2、用户个人信息包括：1）用户自行提供的用户个人信息（如注册时填写的手机号码，电子邮件等个人信息，使用服务时提供的共享信息等）；2）其他方分享的用户个人信息；3）xx科技为提供服务而合法收集的用户必要个人信息（如使用服务时系统自动采集的设备或软件信息，浏览历史信息，通讯时间信息等技术信息，用户开启定位功能并使用服务时的地理位置信息等）。<br />\r\n<br />\r\n其中个人隐私信息是指涉及用户个人身份或个人隐私的信息，比如，用户真实姓名、身份证号、手机号码、手机设备识别码、IP地址、用户聊天记录。非个人隐私信息是指用户对本服务的操作状态以及使用习惯等明确且客观反映在xx科技服务器端的基本记录信息、个人隐私信息范围外的其它普通信息，以及用户同意公开的上述隐私信息。xx科技保证在取得用户书面同意的情况下收集、使用或公开用户的个人隐私信息，用户同意xx科技无需获得用户的另行确认与授权即可收集、使用或公开用户的非个人隐私信息。<br />\r\n<br />\r\n3、尊重用户个人信息的私有性是xx科技的一贯制度，xx科技将采取技术措施和其他必要措施，确保用户个人信息安全，防止在本服务中收集的用户个人信息泄露、毁损或丢失。在发生前述情形或者xx科技发现存在发生前述情形的可能时，xx科技将及时采取补救措施并告知用户，用户如发现存在前述情形亦需立即与xx科技联系。<br />\r\n<br />\r\n4、xx科技未经用户同意不向任何第三方公开、 透露用户个人隐私信息。但以下特定情形除外：<br />\r\n<br />\r\n(1) xx科技根据法律法规规定或有权机关的指示提供用户的个人隐私信息；<br />\r\n<br />\r\n(2) 由于用户将其用户密码告知他人或与他人共享注册帐户与密码，由此导致的任何个人信息的泄漏，或其他非因xx科技原因导致的个人隐私信息的泄露；<br />\r\n<br />\r\n(3) 用户自行向第三方公开其个人隐私信息；<br />\r\n<br />\r\n(4) 用户与xx科技及合作单位之间就用户个人隐私信息的使用公开达成约定，xx科技因此向合作单位公开用户个人隐私信息；<br />\r\n<br />\r\n(5) 任何由于黑客攻击、电脑病毒侵入及其他不可抗力事件导致用户个人隐私信息的泄露；<br />\r\n<br />\r\n(6) 用户个人信息已经经过处理无法识别特定个人且不能复原。<br />\r\n<br />\r\n5、用户同意xx科技可在以下事项中使用用户的个人隐私信息：<br />\r\n<br />\r\n(1) xx科技向用户及时发送重要通知，如软件更新、本协议条款的变更；<br />\r\n<br />\r\n(2) xx科技内部进行审计、数据分析和研究等，以改进xx科技的产品、服务和与用户之间的沟通；<br />\r\n<br />\r\n(3) 依本协议约定，xx科技管理、审查用户信息及进行处理措施；<br />\r\n<br />\r\n(4) 适用法律法规规定的其他事项。<br />\r\n<br />\r\n除上述事项外，如未取得用户事先同意，xx科技不会将用户个人隐私信息使用于任何其他用途。<br />\r\n<br />\r\n6、xx科技重视对未成年人的保护。xx科技将依赖用户提供的个人信息判断用户是否为未成年人。任何18岁以下的未成年人均不得注册帐号或使用本服务<br />\r\n<br />\r\n7、因xx科技提供的服务系基于地理位置提供的移动社交服务，用户确认，其地理位置信息为非个人隐私信息，用户成功注册“xx”帐号视为确认授权xx科技提取、公开及使用用户的地理位置信息。用户地理位置信息将作为用户公开资料之一，由xx科技向其他用户公开以便xx科技向用户提供基于地理位置的移动社交服务。如用户需要终止向其他用户公开其地理位置信息，可随时自行设置为隐身状态。<br />\r\n<br />\r\n8、为了改善xx科技的技术和服务，向用户提供更好的服务体验，xx科技或可会自行收集使用或向第三方提供用户的非个人隐私信息。<br />\r\n<br />\r\n9、xx科技保证在合法、正当与必要的原则下收集、使用或者公开用户个人信息且不会收集与提供的服务无关的用户个人信息。<br />\r\n<br />\r\n10、xx科技十分注重保护用户的个人隐私，并制定了《xx隐私权政策》（点击查看），用户亦可以通过“设置”页面里的“帮助”来进行具体查看，用户确认并同意使用xx科技提供的服务将被视为接受《xx隐私权政策》。<br />\r\n<br />\r\n四、内容规范<br />\r\n1、本条所述内容是指用户使用本服务过程中所制作、上载、复制、发布、传播的任何内容，包括但不限于帐号头像、名称、用户说明等注册信息及认证资料，或文字、语音、图片、视频、图文等发送、回复或自动回复消息和相关链接页面，以及其他使用帐号或本服务所产生的内容。<br />\r\n<br />\r\n2、用户不得利用“xx”帐号或本服务制作、上载、复制、发布、传播如下法律、法规和政策禁止的内容：<br />\r\n<br />\r\n(1) 反对宪法所确定的基本原则的；<br />\r\n<br />\r\n(2) 危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；<br />\r\n<br />\r\n(3) 损害国家荣誉和利益的；<br />\r\n<br />\r\n(4) 煽动民族仇恨、民族歧视，破坏民族团结的；<br />\r\n<br />\r\n(5) 破坏国家宗教政策，宣扬邪教和封建迷信的；<br />\r\n<br />\r\n(6) 散布谣言，扰乱社会秩序，破坏社会稳定的；<br />\r\n<br />\r\n(7) 散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；<br />\r\n<br />\r\n(8) 侮辱或者诽谤他人，侵害他人合法权益的；<br />\r\n<br />\r\n(9) 不遵守法律法规底线、社会主义制度底线、国家利益底线、公民合法权益底线、社会公共秩序底线、道德风尚底线和信息真实性底线的“七条底线”要求的；<br />\r\n<br />\r\n(10) 含有法律、行政法规禁止的其他内容的信息。<br />\r\n<br />\r\n3、用户不得利用“xx”帐号或本服务制作、上载、复制、发布、传播如下干扰“xx”正常运营，以及侵犯其他用户或第三方合法权益的内容：<br />\r\n<br />\r\n(1) 含有任何性或性暗示的；<br />\r\n<br />\r\n(2) 含有辱骂、恐吓、威胁内容的；<br />\r\n<br />\r\n(3) 含有骚扰、垃圾广告、恶意信息、诱骗信息的；<br />\r\n<br />\r\n(4) 涉及他人隐私、个人信息或资料的；<br />\r\n<br />\r\n(5) 侵害他人名誉权、肖像权、知识产权、商业秘密等合法权利的；<br />\r\n<br />\r\n(6) 含有其他干扰本服务正常运营和侵犯其他用户或第三方合法权益内容的信息。<br />\r\n<br />\r\n五、使用规则<br />\r\n1、用户在本服务中或通过本服务所传送、发布的任何内容并不反映或代表，也不得被视为反映或代表xx科技的观点、立场或政策，xx科技对此不承担任何责任。<br />\r\n<br />\r\n2、用户不得利用“xx”帐号或本服务进行如下行为：<br />\r\n<br />\r\n(1) 提交、发布虚假信息，或盗用他人头像或资料，冒充、利用他人名义的；<br />\r\n<br />\r\n(2) 强制、诱导其他用户关注、点击链接页面或分享信息的；<br />\r\n<br />\r\n(3) 虚构事实、隐瞒真相以误导、欺骗他人的；<br />\r\n<br />\r\n(4) 利用技术手段批量建立虚假帐号的；<br />\r\n<br />\r\n(5) 利用“xx”帐号或本服务从事任何违法犯罪活动的；<br />\r\n<br />\r\n(6) 制作、发布与以上行为相关的方法、工具，或对此类方法、工具进行运营或传播，无论这些行为是否为商业目的；<br />\r\n<br />\r\n(7) 其他违反法律法规规定、侵犯其他用户合法权益、干扰“xx”正常运营或xx科技未明示授权的行为。<br />\r\n<br />\r\n3、用户须对利用“xx”帐号或本服务传送信息的真实性、合法性、无害性、准确性、有效性等全权负责，与用户所传播的信息相关的任何法律责任由用户自行承担，与xx科技无关。如因此给xx科技或第三方造成损害的，用户应当依法予以赔偿。<br />\r\n<br />\r\n4、xx科技提供的服务中可能包括广告，用户同意在使用过程中显示xx科技和第三方供应商、合作伙伴提供的广告。除法律法规明确规定外，用户应自行对依该广告信息进行的交易负责，对用户因依该广告信息进行的交易或前述广告商提供的内容而遭受的损失或损害，xx科技不承担任何责任。<br />\r\n<br />\r\n5、除非xx科技书面许可，用户不得从事下列任一行为：<br />\r\n<br />\r\n(1) 删除软件及其副本上关于著作权的信息；<br />\r\n<br />\r\n(2) 对软件进行反向工程、反向汇编、反向编译，或者以其他方式尝试发现软件的源代码；<br />\r\n<br />\r\n(3) 对xx科技拥有知识产权的内容进行使用、出租、出借、复制、修改、链接、转载、汇编、发表、出版、建立镜像站点等；<br />\r\n<br />\r\n(4) 对软件或者软件运行过程中释放到任何终端内存中的数据、软件运行过程中客户端与服务器端的交互数据，以及软件运行所必需的系统数据，进行复制、修改、增加、删除、挂接运行或创作任何衍生作品，形式包括但不限于使用插件、外挂或非经xx科技授权的第三方工具/服务接入软件和相关系统；<br />\r\n<br />\r\n(5) 通过修改或伪造软件运行中的指令、数据，增加、删减、变动软件的功能或运行效果，或者将用于上述用途的软件、方法进行运营或向公众传播，无论这些行为是否为商业目的；<br />\r\n<br />\r\n(6) 通过非xx科技开发、授权的第三方软件、插件、外挂、系统，登录或使用xx科技软件及服务，或制作、发布、传播非xx科技开发、授权的第三方软件、插件、外挂、系统。<br />\r\n<br />\r\n六、虚拟货币<br />\r\n1、xx科技将在“xx”平台发行虚拟货币，即xx币。xx币可用于购买“xx”平台的增值服务，包括但不限于表情服务及会员服务，除此外，不得用于其他任何用途。该等增值服务的价格均以xx币为单位，具体价格信息将由xx科技自行决定并在相关服务页面上显示。<br />\r\n<br />\r\n2、xx币和人民币的兑换比例依用户购买渠道的不同而有不同的兑换比例，具体兑换比例以用户购买xx币相关渠道服务页面显示为准。xx科技有权根据运营情况随时变更上述兑换比例，并将在用户购买xx币相关渠道服务页面显示。<br />\r\n<br />\r\n3、用户默认已开通xx币账户，可进行xx币购买（下称“充值”）和消费。用户可在设置页面查询到xx币余额、购买记录和消费记录。xx币相关信息将不作为公开信息。<br />\r\n<br />\r\n4、用户可以通过网上银行、支付宝或其他“xx”平台提供的充值途径为xx币账户进行充值。用户使用xx币购买相关收费服务后，可将相关收费服务赠与其他用户。用户确认不会以非法方式或者使用非平台所指定的充值途径进行充值,如果用户违规使用非xx科技认可的充值途径非法充值/购买xx币，则xx科技不保证充值顺利或正确完成，若因此造成用户权益受损，xx科技将不会作出任何补偿或赔偿，xx科技同时保留随时终止用户xx账号资格及使用各项充值服务的权利，并进行相应惩罚。<br />\r\n<br />\r\n5、用户确认在进行充值前已经仔细确认过自己的账号并仔细选择了相关操作选项，若因用户自身输入账号错误、操作不当或不了解充值计费方式等因素造成充错账号、错选充值种类等情形而损害自身权益的，xx科技将不会作出任何补偿或赔偿。<br />\r\n<br />\r\n6、用户确认，xx币一经充值成功，除法律法规明确规定外，在任何情况下不能兑换为法定货币，不能转让他人。除法律法规明确规定外，xx币账户充值完成后，xx科技不予退款。<br />\r\n<br />\r\n7、用户确认，xx币只能用于购买“xx”平台上的各类增值服务，任何情况下不得与xx科技以外的第三方进行xx币交易，亦不得在除“xx”平台以外的第三方平台（如淘宝）上进行交易；如违反前述约定，造成用户或第三方任何损失，xx科技不负任何责任，且如xx科技有理由怀疑用户的xx币账户或使用情况有作弊或异常状况，xx科技将拒绝该用户使用xx币进行支付，直至按本协议约定采取相关封禁措施。<br />\r\n<br />\r\n8、xx科技有权基于交易安全等方面的考虑不时设定或修改涉及交易的相关事项，包括但不限于交易限额、交易次数等。用户了解并确认xx科技的前述设定或修改可能对用户的交易产生一定的不便，用户对此没有异议。<br />\r\n<br />\r\n9、用户确认，除法律法规明确规定或本协议另有约定外，用户已购买的任何收费服务不能以任何理由退购（即退换成xx币或法定货币）或调换成其他服务。<br />\r\n<br />\r\n10、因用户自身的原因导致xx科技无法提供xx币购买服务或提供xx币购买服务时发生任何错误而产生的任何损失或责任，由用户自行负责，xx科技不承担责任，包括但不限于：<br />\r\n<br />\r\n(1) 因用户的xx账号丢失、被封禁或冻结；<br />\r\n<br />\r\n(2) 用户将密码告知他人导致的财产损失；<br />\r\n<br />\r\n(3) 因用户绑定的第三方支付机构账户的原因导致的任何损失或责任；<br />\r\n<br />\r\n(4) 其他用户故意或者重大过失或者违反法律法规导致的财产损失。<br />\r\n<br />\r\n11、用户在使用xx科技提供的服务时，如出现违反国家法律法规、本协议约定或其他本平台对用户的管理规定的情形，xx科技有权暂时或永久封禁用户的账号。账号封禁后至解禁（如有）前，用户账户上的剩余xx币将被暂时冻结或全部扣除，不可继续用于购买平台上的虚拟产品或服务，同时不予返还用户购买xx币时的现金价值。<br />\r\n<br />\r\n12、用户确认并同意如用户主动注销账号，则用户已充值到账的xx币，购买的虚拟礼物，游戏币以及会员权益等视为自动放弃，xx科技不予返还相应的现金价值，也不会作出任何补偿。<br />\r\n<br />\r\n七、账户管理<br />\r\n1、 “xx”帐号的所有权归xx科技所有，用户完成申请注册手续后，获得“xx”帐号的使用权，该使用权仅属于初始申请注册人，禁止赠与、借用、租用、转让或售卖。xx科技因经营需要，有权回收用户的“xx”帐号。<br />\r\n<br />\r\n2、用户可以通过1）查看与编辑个人资料页，2）“设置”页面里的“账号与安全”页面来查询、更改、删除、注销“xx”帐户上的个人资料、注册信息及传送内容等，但需注意，删除有关信息的同时也会删除用户储存在系统中的文字和图片。用户需承担该风险。<br />\r\n<br />\r\n3、用户有责任妥善保管注册帐号信息及帐号密码的安全，因用户保管不善可能导致遭受盗号或密码失窃，责任由用户自行承担。用户需要对注册帐号以及密码下的行为承担法律责任。用户同意在任何情况下不使用其他用户的帐号或密码。在用户怀疑他人使用其帐号或密码时，用户同意立即通知xx科技。<br />\r\n<br />\r\n4、用户应遵守本协议的各项条款，正确、适当地使用本服务，如因用户违反本协议中的任何条款，xx科技在通知用户后有权依据协议中断或终止对违约用户“xx”帐号提供服务。同时，xx科技保留在任何时候收回“xx”帐号、用户名的权利。<br />\r\n<br />\r\n5、如用户注册“xx”帐号后一年不登录，通知用户后，xx科技可以收回该帐号，以免造成资源浪费，由此造成的不利后果由用户自行承担。<br />\r\n<br />\r\n6、用户可以通过“设置”页面里的“账号与安全”页面来进行账号注销服务，用户确认注销账号是不可恢复的操作，用户应自行备份与xx账号相关的信息和数据，用户确认操作之前与xx账号相关的所有服务均已进行妥善处理。用户确认并同意注销账号后并不代表本xx账号注销前的账号行为和相关责任得到豁免或减轻，如在注销期间，用户的账号被他人投诉、被国家机关调查或者正处于诉讼、仲裁程序中，xx科技有限自行终止用户的账号注销并无需另行得到用户的同意。<br />\r\n<br />\r\n八、数据储存<br />\r\n1、xx科技不对用户在本服务中相关数据的删除或储存失败负责。<br />\r\n<br />\r\n2、xx科技可以根据实际情况自行决定用户在本服务中数据的最长储存期限，并在服务器上为其分配数据最大存储空间等。用户可根据自己的需要自行备份本服务中的相关数据。<br />\r\n<br />\r\n3、如用户停止使用本服务或本服务终止，xx科技可以从服务器上永久地删除用户的数据。本服务停止、终止后，xx科技没有义务向用户返还任何数据。<br />\r\n<br />\r\n九、风险承担<br />\r\n1、用户理解并同意，“xx”仅为用户提供信息分享、传送及获取的平台，用户必须为自己注册帐号下的一切行为负责，包括用户所传送的任何内容以及由此产生的任何后果。用户应对“xx”及本服务中的内容自行加以判断，并承担因使用内容而引起的所有风险，包括因对内容的正确性、完整性或实用性的依赖而产生的风险。xx科技无法且不会对因用户行为而导致的任何损失或损害承担责任。<br />\r\n<br />\r\n如果用户发现任何人违反本协议约定或以其他不当的方式使用本服务，请立即向xx科技举报或投诉，举报或投诉电话为028-62836666，xx科技将依本协议约定进行处理。<br />\r\n<br />\r\n2、用户理解并同意，因业务发展需要，xx科技保留单方面对本服务的全部或部分服务内容变更、暂停、终止或撤销的权利，用户需承担此风险。<br />\r\n<br />\r\n十、知识产权声明<br />\r\n1、除本服务中涉及广告的知识产权由相应广告商享有外，xx科技在本服务中提供的内容（包括但不限于网页、文字、图片、音频、视频、图表等）的知识产权均归xx科技所有，但用户在使用本服务前对自己发布的内容已合法取得知识产权的除外。<br />\r\n<br />\r\n2、除另有特别声明外，xx科技提供本服务时所依托软件的著作权、专利权及其他知识产权均归xx科技所有。<br />\r\n<br />\r\n3、xx科技在本服务中所涉及的图形、文字或其组成，以及其他xx科技标志及产品、服务名称（以下统称“xx科技标识”），其著作权或商标权归xx科技所有。未经xx科技事先书面同意，用户不得将xx科技标识以任何方式展示或使用或作其他处理，也不得向他人表明用户有权展示、使用、或其他有权处理xx科技标识的行为。<br />\r\n<br />\r\n4、上述及其他任何xx科技或相关广告商依法拥有的知识产权均受到法律保护，未经xx科技或相关广告商书面许可，用户不得以任何形式进行使用或创造相关衍生作品。<br />\r\n<br />\r\n5、用户在使用xx服务时发表上传的文字、图片、视频、音频、软件以及表演等信息，此部分信息的知识产权归用户，责任由用户承担。但用户的发表、上传行为视为对xx科技的授权，用户理解并同意授予xx科技及其关联公司全球范围内完全免费、不可撤销、独家、永久、可转授权和可再许可的权利，包括但不限于：复制权、发行权、出租权、展览权、表演权、放映权、广播权、信息网络传播权、摄制权、改编权、翻译权、汇编权以及《著作权法》规定的由著作权人享有的其他著作财产权利及邻接权利。xx科技可自行选择是否使用以及使用方式，包括但不限于将前述信息在xx科技旗下的服务平台上使用与传播，将上述信息再次编辑后使用，以及由xx科技授权给合作方使用、编辑与传播等。<br />\r\n<br />\r\n十一、法律责任<br />\r\n1、如果xx科技发现或收到他人举报或投诉用户违反本协议约定的，xx科技有权不经通知随时对相关内容，包括但不限于用户资料、聊天记录进行审查、删除，并视情节轻重对违规帐号处以包括但不限于警告、帐号封禁 、设备封禁 、功能封禁 的处罚，且通知用户处理结果。<br />\r\n<br />\r\n2、因违反用户协议被封禁的用户，可以自行到 http://immomo.com/my 查询封禁期限，并在封禁期限届满后自助解封。其中，被实施功能封禁的用户会在封禁期届满后自动恢复被封禁功能。被封禁用户可向xx科技网站相关页面提交申诉，xx科技将对申诉进行审查，并自行合理判断决定是否变更处罚措施。<br />\r\n<br />\r\n3、用户理解并同意，xx科技有权依合理判断对违反有关法律法规或本协议规定的行为进行处罚，对违法违规的任何用户采取适当的法律行动，并依据法律法规保存有关信息向有关部门报告等，用户应承担由此而产生的一切法律责任。<br />\r\n<br />\r\n4、用户理解并同意，因用户违反本协议约定，导致或产生的任何第三方主张的任何索赔、要求或损失，包括合理的律师费，用户应当赔偿xx科技与合作公司、关联公司，并使之免受损害。<br />\r\n<br />\r\n十二、不可抗力及其他免责事由<br />\r\n1、用户理解并确认，在使用本服务的过程中，可能会遇到不可抗力等风险因素，使本服务发生中断。不可抗力是指不能预见、不能克服并不能避免且对一方或双方造成重大影响的客观事件，包括但不限于自然灾害如洪水、地震、瘟疫流行和风暴等以及社会事件如战争、动乱、政府行为等。出现上述情况时，xx科技将努力在第一时间与相关单位配合，及时进行修复，但是由此给用户或第三方造成的损失，xx科技及合作单位在法律允许的范围内免责。<br />\r\n<br />\r\n2、本服务同大多数互联网服务一样，受包括但不限于用户原因、网络服务质量、社会环境等因素的差异影响，可能受到各种安全问题的侵扰，如他人利用用户的资料，造成现实生活中的骚扰；用户下载安装的其它软件或访问的其他网站中含有“特洛伊木马”等病毒，威胁到用户的计算机信息和数据的安全，继而影响本服务的正常使用等等。用户应加强信息安全及使用者资料的保护意识，要注意加强密码保护，以免遭致损失和骚扰。<br />\r\n<br />\r\n3、用户理解并确认，本服务存在因不可抗力、计算机病毒或黑客攻击、系统不稳定、用户所在位置、用户关机以及其他任何技术、互联网络、通信线路原因等造成的服务中断或不能满足用户要求的风险，因此导致的用户或第三方任何损失，xx科技不承担任何责任。<br />\r\n<br />\r\n4、用户理解并确认，在使用本服务过程中存在来自任何他人的包括误导性的、欺骗性的、威胁性的、诽谤性的、令人反感的或非法的信息，或侵犯他人权利的匿名或冒名的信息，以及伴随该等信息的行为，因此导致的用户或第三方的任何损失，xx科技不承担任何责任。<br />\r\n<br />\r\n5、用户理解并确认，xx科技需要定期或不定期地对“xx”平台或相关的设备进行检修或者维护，如因此类情况而造成服务在合理时间内的中断，xx科技无需为此承担任何责任，但xx科技应事先进行通告。<br />\r\n<br />\r\n6、xx科技依据法律法规、本协议约定获得处理违法违规或违约内容的权利，该权利不构成xx科技的义务或承诺，xx科技不能保证及时发现违法违规或违约行为或进行相应处理。<br />\r\n<br />\r\n7、用户理解并确认，对于xx科技向用户提供的下列产品或者服务的质量缺陷及其引发的任何损失，xx科技无需承担任何责任：<br />\r\n<br />\r\n(1) xx科技向用户免费提供的服务；<br />\r\n<br />\r\n(2) xx科技向用户赠送的任何产品或者服务。<br />\r\n<br />\r\n8、在任何情况下，xx科技均不对任何间接性、后果性、惩罚性、偶然性、特殊性或刑罚性的损害，包括因用户使用“xx”或本服务而遭受的利润损失，承担责任（即使xx科技已被告知该等损失的可能性亦然）。尽管本协议中可能含有相悖的规定，xx科技对用户承担的全部责任，无论因何原因或何种行为方式，始终不超过用户因使用xx科技提供的服务而支付给xx科技的费用(如有)。<br />\r\n<br />\r\n十三、服务的变更、中断、终止<br />\r\n1、鉴于网络服务的特殊性，用户同意xx科技有权随时变更、中断或终止部分或全部的服务（包括收费服务）。xx科技变更、中断或终止的服务，xx科技应当在变更、中断或终止之前通知用户，并应向受影响的用户提供等值的替代性的服务；如用户不愿意接受替代性的服务，如果该用户已经向xx科技支付的xx币，xx科技应当按照该用户实际使用服务的情况扣除相应xx币之后将剩余的xx币退还用户的xx币账户中。<br />\r\n<br />\r\n2、如发生下列任何一种情形，xx科技有权变更、中断或终止向用户提供的免费服务或收费服务，而无需对用户或任何第三方承担任何责任：<br />\r\n<br />\r\n(1) 根据法律规定用户应提交真实信息，而用户提供的个人资料不真实、或与注册时信息不一致又未能提供合理证明；<br />\r\n<br />\r\n(2) 用户违反相关法律法规或本协议的约定；<br />\r\n<br />\r\n(3) 按照法律规定或有权机关的要求；<br />\r\n<br />\r\n(4) 出于安全的原因或其他必要的情形。<br />\r\n<br />\r\n十四、“附近活动”服务说明与免责条款<br />\r\n1、xx“附近活动”功能板块，是以地理位置为基础、发布用户周边文化活动信息的活动信息共享平台（下称“本平台”）。<br />\r\n<br />\r\n2、本平台发布之全部文化活动信息,包括但不限于活动地理位置信息，均直接或者间接来自于文化活动主办方。<br />\r\n<br />\r\n3、本平台发布文化活动信息，意在宣传文化活动、丰富用户文化生活。本平台用户于本平台“附近活动”功能板块发布的留言、评论等信息，均系用户自行发布。本平台不对上述信息的真实性、准确性，或及时性、完整性负责。<br />\r\n<br />\r\n4、如果相关文化活动主办方及/或相关权利主体，认为该等文化活动信息之发布，侵害其合法权益，可发邮件至mmsrc(at)immomo.com，本平台在核实其提供的证明材料后，将依法履行网络平台发布者的义务，维护其合法权益。<br />\r\n<br />\r\n十五、其他<br />\r\n1、xx科技郑重提醒用户注意本协议中免除xx科技责任和限制用户权利的条款，请用户仔细阅读，自主考虑风险<br />\r\n<br />\r\n2、本协议的效力、解释及纠纷的解决，适用于中华人民共和国法律。若用户和xx科技之间发生任何纠纷或争议，首先应友好协商解决，协商不成的，用户同意将纠纷或争议提交xx科技住所地有管辖权的人民法院管辖。<br />\r\n<br />\r\n3、本协议的任何条款无论因何种原因无效或不具可执行性，其余条款仍有效，对双方具有约束力。<br />\r\n<br />\r\n4、由于互联网高速发展，您与xx科技签署的本协议列明的条款可能并不能完整罗列并覆盖您与xx所有权利与义务，现有的约定也不能保证完全符合未来发展的需求。因此，xx隐私权政策、xx平台行为规范等均为本协议的补充协议，与本协议不可分割且具有同等法律效力。如您使用xx平台服务，视为您同意上述补充协议。<br />\r\n</span>\r\n</p>\r\n<h3 style=\"vertical-align:baseline;text-align:center;\">\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;\"></span> \r\n	</div>\r\n</h3>', '1');
INSERT INTO `by_cate` VALUES ('15', '0', '售后保障', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('16', '15', '退换货政策', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"color:#FF0000;\"><span style=\"font-size:small;\">退换货承诺：</span></span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;自您签收商品之日起7日内，为您提供退换货服务！</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n<span style=\"color:#FF0000;\">&nbsp; &nbsp; &nbsp; &nbsp;补充说明：</span></span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;符合以下情况的，不享受无理由退货服务：</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;1、	非商品质量问题不予办理退换货业务；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;2、	在保障商品质量的基础上，对无适当退换理由的（如误买、不喜欢等），不予办理退换货；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;3、	任何</span>xx商城<span style=\"font-size:small;\">商品都支持现场验货（请当场验收，如对产品数量和质量有异议，可以当场拒收，否则视为产品合格交付；且考虑商品性质价值较高且涉及食品安全，故对本产品不支持退换货服务）；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;4、	酒瓶已经开封，不予办理退换货；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;5、	参与特殊活动（注明不予退换货）的商品；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;6、	定制了个性化酒标的；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;7、	因顾客原因导致酒标损坏等影响二次销售；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;8、	双方关于退换货另有书面约定的。</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;感谢您对</span>xx商城<span style=\"font-size:small;\">的支持，</span>99米名酒直供商城<span style=\"font-size:small;\">将为您提供最优质的商品及服务，</span><span style=\"font-size:small;\">祝您生活愉快！</span> \r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('17', '0', '购物指南', '1', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('22', '15', '价格保证', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('23', '15', '服务保障承诺', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	1、在线响应\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; 请拨打全国统一客服专线&nbsp;<span style=\"font-size:x-small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span><span style=\"font-size:smaller;\">（周一至周日8:00-21:00）</span>，将您的问题告知我们，我们的工作人员会尽快审核确认并指导您进行后续处理。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; 2、解决方式\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp; &nbsp; &nbsp; 凡做换货、补发、补偿或者全额退款等处理的，我们会派出专业客服人员与您联系，就退换货处理方式与您做全面沟通，争取得到您满分的认可。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 3、365天*14小时服务热线\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp; 99米名酒直供商城针对所有会员客户，提供全年365天*14小时服务热线<span style=\"font-size:x-small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span>（<span style=\"font-size:10px;\">8:00-21:00</span>），为99米名酒直供商城会员随时解决产品问题及服务咨询。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 4、7天内无理由退换货\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 凡是从99米名酒直供商城成功购买商品的客户，在不影响二次销售的情况下，均可享受7天无理由退换货服务。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 5、维权中心无条件接受客户投诉\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 自接到客户投诉之时起，24小时内反馈客户问题，xx商城为了提升客户满意度，提升服务质量，郑重做出“维权中心24小时内反馈客户问题并及时跟进解决”的承诺。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 6、快递承诺\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;xx合作的高端物流送达，承诺一线城市最快24小时内送达，二线城市最快48小时内送达，偏远地区除外。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 7、会员价产品\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;99米名酒直供商城将不定期针对不同等级会员，开设特惠产品专区，等级越高，优惠越大。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 8、参加酒水品鉴会活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;99米名酒直供商城将不定期举办高端酒水品鉴会活动，对于三星及以上会员免费开放。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9、免费参观会所\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;99米名酒直供商城宣扬酒文化，建立酒文化体验馆，会馆针对99米名酒直供商城四星及以上会员客户免费开放，以供参观。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;10、、个性化定制\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 专门针对高级会员量身定制独一无二的产品。例如：定制瓶身上印有会员名字或者特殊语句的产品，以供五星及以上等级会员做纪念、送礼等特殊用途。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 11、参与节目录制\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 六星会员客户专属权益，可以有机会亲临节目录制现场，参与到99米名酒直供商城主办的电视节目之中。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 12、大师讲座\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 六星会员专属服务，有机会与酒水大师面对面，交流酒水文化以及养生知识。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 13、公益活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对五星及以上会员，可以参与到99米名酒直供商城发起的公益活动中。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 14、商务活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对五星及以上会员，可提供会员与会员间的商务活动共享。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 15、自选客服\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对六星级会员，客户可以综合评判，选择自己的专属客服。\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('29', '17', '购物指南', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('32', '0', '支付方式', '0', '0', '', '', '1');
INSERT INTO `by_cate` VALUES ('33', '17', '配送方式', '0', '0', '', '<p style=\"color:#757575;font-family:&quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:SimHei;font-size:14px;background-color:#FFFFFF;\"><span>xx商城自营物流-万茗堂配送中心，配送范围遍布全国各级城市；对于偏远地区采用第三方物流服务，所谓第三方指顺丰、申通、EMS、宅急送、圆通等物流公司。</span></span><span style=\"color:#404040;font-family:SimHei;font-size:14px;background-color:#FFFFFF;\">因酒类属特殊商品，国家规定只能陆运，不能空运。同时为保证货品安全，每瓶酒都采用酒类专用安全包装，以确保在运输途中不会因挤压、碰撞等因素造成破损；如出现破损，请与快递人员当面核实，并对破损进行拍照取证，请客户一定要当面验收，如有问题联系&nbsp;&nbsp;</span><span style=\"font-family:SimHei;color:#404040;background-color:#FFFFFF;font-size:small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span><span style=\"color:#404040;font-family:SimHei;font-size:14px;background-color:#FFFFFF;\">（周一至周日8:00-21:00）</span>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('35', '32', '在线支付', '0', '0', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\">&nbsp;1、在线支付平台</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;xx提供微信、支付宝等支付方式，覆盖率达98％。选择在线支付，即时到帐，准确快捷！</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n<br />\r\n</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\">&nbsp; &nbsp;2、到款时间</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n<span>&nbsp; &nbsp; &nbsp; &nbsp;网上支付均是支付成功即到账。若由于网络故障导致您已支付成功的订单未改变订单状态，请您联系我们的客服人员为您解决，客服热线：</span><span style=\"font-size:medium;\">&nbsp;<span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span>（周一至周日8:00-21:00）（仅收市话费）\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;温馨提示：在线支付付款等待期限为2小时。请您在订购成功后2小时内完成支付，否则我们将不会保留您的订单。</span>\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('36', '32', '货到付款', '0', '0', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\">货到付款是快递人员送货上门，客户收单验货后，直接将货款交给配送员的一种结算方式。</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n</span><span style=\"color:#FF0000;\"><span style=\"font-size:small;\">&nbsp; &nbsp; &nbsp; &nbsp;注：目前暂未开通POS机刷卡服务的地区，货到后需要现金支付。</span></span>\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('38', '0', '公告', '0', '1', '', '', '3');
INSERT INTO `by_cate` VALUES ('39', '38', '处罚公告', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('40', '38', '商城公告', '1', '1', '', '', '2');
INSERT INTO `by_cate` VALUES ('41', '0', '底部分类', '0', '1', '', '', '2');
INSERT INTO `by_cate` VALUES ('42', '41', '招聘信息', '0', '1', '', '<a href=\"http://hr.wanmei.com/\" target=\"_blank\">招聘信息</a>', '1');
INSERT INTO `by_cate` VALUES ('43', '41', '法律声明', '0', '1', '', '<p class=\"MsoNormal\" style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\">&nbsp;</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">凡本网标明“</span><span style=\"font-family:宋体;font-size:14pt;\">来源：www.yershop.com”</span><span style=\"font-family:宋体;font-size:14pt;\">或者未标明来源的作品，均为本网原创作品，本网依法享有著作权。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">原创作品版权所有，非经授权，禁止转载。如需使用，请与本站进行联系。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">凡本网标明“版权所有，欢迎转载”的作品，本网授权不特定多数人信息网络传播权，希望向更多人传播更多信息资源。转载请标明来源本网站。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">如因作品内容、版权、产品宣传或其它问题需要同本网站联系的，请拨打</span><span style=\"font-size:medium;\"><span>&nbsp;</span></span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);font-size:medium;\">9</span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span style=\"font-size:medium;\">4007-222-222</span><span><span style=\"font-size:18.6667px;\">（周一至周日8:00-21:00）</span></span><span style=\"font-family:宋体;font-size:14pt;\">与本站联系</span>\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('44', '5', '隐私政策', '0', '1', '', '<p style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;font-size:14px;background-color:#F2F2F2;\">\r\n	<span style=\"font-size:16px;\">xx商城个人信息保护政策&nbsp;</span>\r\n</p>\r\n<p style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;font-size:14px;background-color:#F2F2F2;\">\r\n	<span style=\"font-size:16px;\">为切实保护xx商城用户隐私权，优化用户体验，xx商城根据现行法规及政策，制定本《个人信息保护政策》。本《个人信息保护政策》将详细说明xx商城在获取、管理及保护用户个人信息方面的政策及措施。本《个人信息保护政策》适用于xx商城向你提供的所有服务，无论你是通过计算机设备、移动终端或其他设备获得的xx商城服务。</span>\r\n</p>\r\n<h3 style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;background-color:#F2F2F2;vertical-align:baseline;text-align:center;\">\r\n	<div style=\"margin:0px;padding:0px;color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">本个人信息保护政策是你使用xx商城服务及各项功能的基础性法律文件，我们希望你在使用xx商城服务前仔细阅读并明确你已经充分理解、接受本政策的内容，希望你可以根据自己的理解做出合适的选择。在我们更新本个人信息保护政策后，你继续使用我们的产品与/或服务，即意味着你同意本个人信息保护政策(含更新版本)内容，并且同意我们按照本个人信息保护政策收集、使用、保存和共享你的相关信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">本个人信息保护政策涉及的个人信息包括：基本信息（包括个人姓名、生日、性别、住址、个人电话号码、电子邮箱）；个人位置信息；网络身份标识信息（包括系统账号、IP地址、邮箱地址及与前述有关的密码、密保）；个人上网记录（包括搜索记录、使用记录、点击记录）；个人常用设备信息（包括硬件型号、设备MAC地址、操作系统类型）；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">一、个人信息的收集</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你已知悉且同意，在你注册xx商城账号或使用xx商城提供的服务时，xx商城将记录你提供的相关个人信息，如：密码、手机号码等，上述个人信息是你获得xx商城提供服务的基础。同时，基于优化用户体验之目的，xx商城会获取与提升xx商城服务有关的其他信息，例如当你访问xx商城时，我们可能会收集哪些服务的受欢迎程度、浏览器软件信息等以便优化我们的服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城前，我们会引导你阅读本协议，并在你接受本协议的基础上，获得你的相关个人信息。如果你不同意提供个人信息，你将无法使用xx商城的全部或部分功能和服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城仅会在出现下列情况时收集你的个人信息：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你注册xx商城账号时，我们至少会收集你的账户昵称、性别、密码、密码保护选项、电子邮箱、手机号码等信息。若你以其他方式关联登陆xx商城，我们会向关联第三方请求你的个人信息，对于我们要求但第三方无法提供的个人信息，我们仍可以要求你提供。如果你拒绝提供这些信息，将影响你使用xx商城或xx商城的相关功能。在您注册使用xx商城时，我们会对你进行实名验证，如果你拒绝提供有关信息，xx商城将拒绝向你提供服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城提供的搜索服务时，我们会收集你的查询关键字信息、设备信息等，为了提供高效的搜索服务，这些信息有部分会暂时存储在你的本地存储设备之中。在此，你需要注意的是，你的关键词信息无法单独识别你的个人身份，其不属于你的个人信息，因此我们有权以其他的目的对其进行使用；只有当你的搜索关键词信息与你的其他信息互有联系并可以识别你的个人身份时，则在结合使用期间，我们会将你的搜索关键词信息作为你的个人信息，与你的搜索历史记录一同按照本个人信息保护政策对其进行处理与保护。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城提供的身份认证服务时，我们会收集你的姓名、身份证号、职业、有关身份证明等信息，xx商城对你的这些隐私信息会加以最大程度的保护，如果你不提供这些信息，我们将无法提供相关服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你参加xx商城的有关营销活动时，我们会收集你的姓名、学校名称、通讯地址、联系方式、银行账号等信息。这些信息是你收到转账或礼品的基础，如果你拒绝提供这些信息，我们将无法向你转账或发放礼品。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当涉及国家安全与利益、社会公共利益、与犯罪侦查有关的相关活动、你或他人生命财产安全但在特殊情况下无法获得你的及时授权、能够从其他合法公开的渠道、法律法规规定的其他情形下，xx商城可能在不经过你的同意或授权的前提下，收集你的个人信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">另，如在上述场景之外获得你的个人信息，将重新征得你的明示同意，并在获得你明示同意前向你充分说明应用场景与获取你相关信息的内容与范围。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">二、对Cookie及web beacon的使用</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">Cookie可以帮助网站辨认注册用户，计算用户数量，通常被各网站用来判定完成注册的用户是否已经实现登录。xx商城承诺，对cookie信息的研究仅用于提升服务/产品质量及优化用户体验之目的。同时，如不希望个人信息保留在cookie中，你可以对浏览器进行配置：选择\"拒绝cookie\"或\"当网站发送cookie时通知你\"，你知道，鉴于xx商城的服务是通过支持cookie来是实现的，完成关闭cookie的操作后，可能影响到你访问xx商城或不能充分取得xx商城的服务。你不禁用cookie时，可能会得到提示，是否在下一次进入此网站时保留用户信息以便简化登录手续（如一键登录）。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城使用web beacon的方法和目的与cookie是相同的。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">三、个人信息的保护和安全措施</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1、xx商城将尽一切合理努力保护其获得的用户个人信息，并由专门的数据安全部门对个人信息进行保护。为防止用户个人信息在意外的、未经授权的情况下被非法访问、复制、修改、传送、遗失、破坏、处理或使用，xx商城已经并将继续采取以下措施保护你的个人信息：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）通过采取加密技术对用户个人信息进行加密保存，并通过隔离技术进行隔离。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）在个人信息使用时，例如个人信息展示、个人信息关联计算，我们会采用包括内容替换、加密脱敏等多种数据脱敏技术增强个人信息在使用中安全性。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3）设立严格的数据使用和访问制度，采用严格的数据访问权限控制和多重身份认证技术保护个人信息，避免数据被违规使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2、保护个人信息采取的其他安全措施</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）通过建立数据分类分级制度、数据安全管理规范、数据安全开发规范来管理规范个人信息的存储和使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）建立数据安全专项部门，负责安全应急响应组织来推进和保障个人信息安全。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3、个人信息安全事件的通知</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）如发生个人信息引发的安全事件，xx商城将第一事件向相应主管机关报备，并即时进行问题排查，开展应急措施。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）通过与全量用户发送通知提醒更改密码。还可能通过电话、短信等各种方式触达用户知晓，在xx商城公共运营平台运营宣传，制止数据泄露。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">尽管已经采取了上述合理有效措施，并已经遵守了相关法律规定要求的标准，但xx商城仍然无法保证你的个人信息通过不安全途径进行交流时的安全性。因此，用户个人应采取积极措施保证个人信息的安全，如：定期修改账号密码，不将自己的账号密码等个人信息透露给他人。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你知悉：xx商城提供的个人信息保护措施仅适用于xx商城平台，一旦你离开xx商城，浏览或使用其他网站、服务及内容资源，xx商城即没有能力及义务保护你在xx商城以外的网站提交的任何个人信息，无论你登录或浏览上述网站是否基于xx商城的链接或引导。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">网络环境中始终存在各种信息泄漏的风险，当出现意外事件、不可抗力等情形导致你的信息出现泄漏时，xx商城将极力控制局面，及时告知你事件起因、xx商城采取的安全措施、你可以主动采取的安全措施等相关情况。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">四、个人信息的存储</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城会采取合适的安全措施和技术手段存储及保护你的个人信息，以防止丢失、被误用、受到未授权访问或泄漏、被篡改或毁坏。你的个人信息存放在有密码控制的位于中国境内的服务器中，访问均是受到限制的。当你需要跨境信息传输服务时，xx商城会默认你继续使用中国境内的服务器。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城会依照个人信息的不同等级存储不同期限，存储期限严格按照法律及相关法规规定，最低期限不少于6个月。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">根据本条款的规定，我们仅允许有必要知晓这些信息的xx商城员工等第三方访问个人信息，并要求他们履行相应的保密义务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">五、个人信息的使用和对外提供</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">未经你本人允许，xx商城不会向任何第三方公开（包括共享、转让、公开披露等方式）你的个人信息，下列情形除外：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1、xx商城已经取得你或你监护人的授权或同意；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2、司法机关或行政机关基于法定程序要求xx商城披露的；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3、xx商城为维护自身合法权益而向用户提起诉讼或仲裁时；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">4、根据你与xx商城相关服务条款、应用许可使用协议的约定；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">5、在法律允许的范围内，为保障xx商城、xx商城用户以及社会公共利益免受损害时；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">6、符合你与其他第三人之间有关约定的；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你可以向特定的对象发送你的照片、身份信息、位置信息等，也可以基于xx商城的服务向不特定人共享自己的照片、位置信息、身份信息等。当你因为你的共享行为导致你的信息发生泄漏等严重情况时，xx商城不承担相关法律责任。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">7、在不透露单个用户隐私资料的前提下，xx商城有权对整个用户数据库进行分析并对用户数据库进行适当的使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">六、个人信息的管理</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你完成xx商城的账号注册并进行合理和必要的身份验证后，你可以查阅、修改、删除你提交给xx商城的个人信息。一般情况下，你可随时浏览、修改、删除自己提交的信息，但出于安全性和身份识别（如号码申诉服务）的考虑，你可能无法修改注册时提供的某些初始注册信息及验证信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你有权自主更新或更正你的个人信息，或授权xx商城客服进行信息更新、更正。在你进行信息更新更正之前，我们会首先验证你的身份，其次才能进行信息的更正与更新。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你可以自主注销xx商城账号，注销后xx商城不再收集你的个人信息。在你注销你的账号之前，xx商城将验证你的个人身份、安全状态、账户密码等信息。你注销账号的行为是不可逆的行为，一旦你注销你的账号，xx商城将即刻删除有关你账户的一切信息，并保证这些信息不会泄露，同时，你也无法通过已注销的账户获得xx商城的服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">七、对未成年人个人信息的特别保护</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城非常重视对未成年人个人信息的保护。若你是14周岁以下的未成年人，在使用xx商城的服务前，应确保事先取得监护人的同意，如果你是已满14不满18岁的未成年人，在使用xx商城服务前，应确保事先取得本人或监护人的同意。如你在xx商城上申请注册账号，xx商城将默认为你已得到前述同意。xx商城将根据国家相关法律法规及本《个人信息保护政策》的规定保护未成年人的个人信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">八、争议解决</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你因为本政策的实施与xx商城产生任何纠纷时，双方应首先协商友好解决；若不能协商解决，双方有权依照注册协议向有管辖权的法院提起诉讼。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;\">如果你对本个人信息保护政策有任何疑问，请你联系xx商城客服咨询，我们会及时解决你的问题。</span>\r\n	</div>\r\n</h3>\r\n<br />', '1');
INSERT INTO `by_cate` VALUES ('45', '41', 'Cookie政策', '0', '1', '', '<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	<b>Cookies</b>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们使用Cookies来保持我们网站的可靠性，安全性和个性化。当您接受Cookies时，这有助于通过识别用户身份、记住您的偏好、或提供个性化用户体验来帮助我们改善网站。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	此Cookie政策适用于链接到此政策并由完美集团发布的所有网站、移动APP及其他网络应用程序（“完美网站”）。完美集团指完美世界(北京)数字科技有限公司、其下属各分支机构以及其合并报表范围内的下属公司或合伙企业。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	本政策应与我们的隐私政策一起阅读，该隐私政策解释了我们如何使用个人信息。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如果您对我们使用您的个人信息或Cookies的方式有任何疑问，请通过<a href=\"mailto:privacy@pwrd.com\">privacy@pwrd.com</a>与我们联系。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如果您想管理您的Cookies，请按照下面“如何管理Cookies”部分中的说明进行操作。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	什么是Cookies？\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies是一种小型文本文件，当您访问网站时，网站可能会将这些文件放在您的计算机或设备上。Cookies会帮助网站或其他网站在您下次访问时识别您的设备。网站信标、像素或其他类似文件也可以做同样的事情。我们在此政策中使用术语“Cookies”来指代以这种方式收集信息的所有文件。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies提供许多功能。例如，他们可以帮助我们记住您的用户名和偏好，分析我们网站的效果，或者允许我们推荐我们认为与您最相关的内容。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	大多数网站使用Cookies来收集和保留有关其访问者的个人信息。大多数Cookies收集一般信息，例如访问者如何到达和使用我们的网站，他们使用的设备，他们的互联网协议地址（IP地址），他们正在查看的页面及其大致位置（例如，我们将能够认识到您正在从北京访问我们的网站）。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies的目的\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们将Cookies分为以下类别:\r\n</p>\r\n<table class=\"result_table\" style=\"margin:auto;padding:0px;border:1px solid #EAEAEA;color:#666666;font-family:&quot;font-size:16px;\">\r\n	<tbody>\r\n		<tr>\r\n			<th width=\"20%\" style=\"text-align:center;background:#F7F8FD;color:#333333;\">\r\n				用途\r\n			</th>\r\n			<th style=\"text-align:center;background:#F7F8FD;color:#333333;\">\r\n				说明\r\n			</th>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				授权\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				您登录完美网站时，我们可通过 Cookie 提供正确信息，为您打造个性化的体验。例如：Cookie有助于我们辨认您作为我们的注册用户的身份。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				安全措施\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们通过 Cookie 启用及支持安全功能，监控和防止可疑活动、欺诈性流量和违反完美用户协议的行为。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				偏好、功能和服务\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用功能性Cookies来让我们记住您的偏好，或保存您向我们提供的有关您的喜好或其他信息。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				广告\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用Cookies为您提供我们认为与您和您的兴趣相关的广告。您可能会在我们的网站和您访问的其他网站上看到这些广告。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				网站性能、分析和研究\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用这些cookie来监控网站性能。这使我们能够通过快速识别和解决出现的任何问题来提供高质量的体验。\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们网站上的第三方Cookies\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们还在我们的网站上使用属于上述类别的第三方Cookies，用于以下目的：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·帮助我们监控网站上的流量；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·识别欺诈或非人为性流量；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·协助市场调研；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·改善网站功能；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·监督我们的注册协议和隐私政策的遵守情况。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如何管理Cookies？\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	在将Cookie放置在您的计算机或设备上之前，系统会显示一个弹出窗口，要求您同意设置这些Cookie。通过同意放置Cookies，您可以让我们为您提供最佳的体验和服务。如果您愿意，您可以拒绝同意放置Cookies（除非这些Cookie是绝对必要的）； 但是，我们网站的某些功能可能无法完全或按预期运行。您最初将有机会允许和/或拒绝使用Cookie。您可以通过访问浏览器设置随时返回到您的Cookie偏好设置以查看和/或删除它们。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	除了我们提供的控件之外，您还可以选择在Internet浏览器中启用或禁用Cookie。大多数互联网浏览器还允许您选择是要禁用所有Cookie还是仅禁用第三方Cookie。默认情况下，大多数互联网浏览器都接受Cookie，但这可以更改。有关详细信息，请参阅Internet浏览器中的帮助菜单或设备随附的文档。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	以下链接提供了有关如何在所有主流浏览器中控制Cookie的说明：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.google.com/chrome/answer/95647?hl=en\" target=\"_blank\">Google Chrome</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.microsoft.com/en-us/help/260971/description-of-Cookies\" target=\"_blank\">IE</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.apple.com/kb/PH5042?locale=en_US\" target=\"_blank\">Safari（桌面版）</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.apple.com/en-us/HT201265\" target=\"_blank\">Safari（移动版）</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.mozilla.org/en-US/kb/Cookies-information-websites-store-on-your-computer\" target=\"_blank\">火狐浏览器</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"http://support.google.com/ics/nexus/bin/answer.py?hl=en&amp;answer=2425067\" target=\"_blank\">Android浏览器</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如您使用其他浏览器，请参阅浏览器制造商提供的文档。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	有关Cookies以及如何管理Cookies的更多信息，请访问：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	wikipedia.org、www.allaboutCookies.org或www.aboutCookies.org\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	更多信息\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	有关我们数据处理的更多信息，请参阅我们的隐私政策。如果您对此Cookie政策有任何疑问，请通过<a href=\"mailto:privacy@pwrd.com\">privacy@pwrd.com</a>与我们联系。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	对此Cookie政策的更改\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	此政策自2018年【11】月【15】日起生效。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们可能对此Cookie政策所做的任何更改都将发布在此页面上。如果更改很重要，我们可能会选择通过电子邮件通知您，或在我们的主页上明确指出该政策已更新。\r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('46', '41', '企业资质', '0', '1', '', '', '1');
INSERT INTO `by_cate` VALUES ('47', '17', '配送范围', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;background-color:#FFFFFF;\">\r\n	<span>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		xx商城支持全国所有地区的免费配送业务（港、澳、台海外除外），xx商城自营物流万茗堂配送中心，配送范围遍布全国各级城市；对于偏远地区采用第三方物流服务，包括顺丰、申通、EMS、宅急送、圆通等物流公司。&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		以下为xx商城支持免费专人配送的城市：\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;text-align:center;\">\r\n		<a href=\"http://www.99mi.com/images/upload/File/111.png\"><img alt=\"\" src=\"http://www.99mi.com/images/upload/File/111.png\" /></a>&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		<strong>服务说明：</strong>\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		①、 由万茗堂配送中心配送且是整箱的商品（偏远区域除外），享受货到付款服务。\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		②、 由于业务发展变化、行政区域更名等因素，货到付款区域可能会不时有扩大、变更或调整，具体区域请以99米名酒直供商城最新确认为准。\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		③、以上地址仅限市区，特别偏远地区将不支持货到付款。\r\n	</p>\r\n</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"color:#FF0000;\"><span style=\"font-size:small;\"></span></span> \r\n</p>', '1');
INSERT INTO `by_cate` VALUES ('48', '17', '订单查询', '0', '1', '', '&nbsp;登陆会员中心即可查询订单', '1');
INSERT INTO `by_cate` VALUES ('49', '0', '商家帮助中心', '0', '1', null, '', '3');
INSERT INTO `by_cate` VALUES ('50', '49', '入驻指南', '0', '1', null, '', '2');
INSERT INTO `by_cate` VALUES ('51', '38', '积分公告', '0', '1', null, '', '3');

-- ----------------------------
-- Table structure for by_category
-- ----------------------------
DROP TABLE IF EXISTS `by_category`;
CREATE TABLE `by_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(30) NOT NULL COMMENT '标志',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `list_row` tinyint(3) unsigned NOT NULL DEFAULT '10' COMMENT '列表每页行数',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `template_index` varchar(100) NOT NULL COMMENT '频道页模板',
  `template_lists` varchar(100) NOT NULL COMMENT '列表页模板',
  `template_detail` varchar(100) NOT NULL COMMENT '详情页模板',
  `template_edit` varchar(100) NOT NULL COMMENT '编辑页模板',
  `type` varchar(100) NOT NULL DEFAULT '' COMMENT '允许发布的内容类型',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `extend` text NOT NULL COMMENT '扩展设置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `types_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=184 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of by_category
-- ----------------------------
INSERT INTO `by_category` VALUES ('52', 'fruit', '食品饮料', '0', '7', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '\"\"', '1411925214', '1489562378', '1', '454', '41');
INSERT INTO `by_category` VALUES ('58', 'j_fruit', '进口水果', '52', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1411935041', '1421425884', '1', '430', '42');
INSERT INTO `by_category` VALUES ('57', 'c_fruit', '国内水果', '52', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1411934874', '1422719396', '1', '429', '42');
INSERT INTO `by_category` VALUES ('71', 'tushu', '图书音像', '0', '4', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '0', '1', '', '1414344085', '1420956824', '1', '459', '46');
INSERT INTO `by_category` VALUES ('72', 'xie', '珠宝钟表', '0', '0', '10', '', '', '', '', '', '', '', '0', '1', '', '1414674812', '1421415890', '1', '211', '40');
INSERT INTO `by_category` VALUES ('73', 'car', '汽车用品', '0', '0', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '0', '1', '', '1414674847', '1421388297', '1', '458', '45');
INSERT INTO `by_category` VALUES ('75', 'fushi', '服装鞋包', '0', '5', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1414674964', '1421391978', '1', '456', '42');
INSERT INTO `by_category` VALUES ('76', 'jiaju', '玩具乐器', '0', '0', '10', '', '', '', '', '', '', '', '0', '1', '\"\"', '1414675003', '1438934343', '1', '214', '40');
INSERT INTO `by_category` VALUES ('126', 'apple', '苹果', '57', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1421502954', '1421502954', '1', '0', '40');
INSERT INTO `by_category` VALUES ('81', 'ebook', '电子书', '71', '0', '10', '', '', '', '', '', '', '', '', '1', '', '1420956858', '1420956858', '1', '0', '39');
INSERT INTO `by_category` VALUES ('82', 'mianfei', '免费', '81', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420956901', '1420956901', '1', '0', '38');
INSERT INTO `by_category` VALUES ('83', 'emusic', '数字音乐', '81', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420959330', '1420960517', '1', '0', '46');
INSERT INTO `by_category` VALUES ('86', 'renwensheke', '人文社科', '71', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960622', '1420960622', '1', '0', '40');
INSERT INTO `by_category` VALUES ('87', 'history', '历史', '86', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960661', '1420960661', '1', '0', '40');
INSERT INTO `by_category` VALUES ('88', 'xinli', '心理学', '86', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960700', '1420960711', '1', '0', '40');
INSERT INTO `by_category` VALUES ('108', 'qingjie', '清洁', '106', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963449', '1420963449', '1', '0', '40');
INSERT INTO `by_category` VALUES ('92', 'nvxie', '女鞋', '72', '0', '10', '', '', '', '', '', '', 'goods/edit', '1', '1', '', '1420961778', '1420961778', '1', '0', '42');
INSERT INTO `by_category` VALUES ('90', 'gex', '个护化妆', '0', '0', '10', '', '', '', '', '', '', '', '2,1,3', '1', '', '1420961431', '1421388355', '1', '216', '40');
INSERT INTO `by_category` VALUES ('93', 'nvxue', '女靴', '92', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420961856', '1420961856', '1', '0', '40');
INSERT INTO `by_category` VALUES ('94', 'nanxie', '男鞋', '72', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420961909', '1420961909', '1', '0', '40');
INSERT INTO `by_category` VALUES ('96', 'yundongxie', '运动鞋', '94', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962056', '1420962056', '1', '0', '40');
INSERT INTO `by_category` VALUES ('97', 'quanbuche', '全部整车', '73', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962156', '1420962156', '1', '0', '40');
INSERT INTO `by_category` VALUES ('98', 'xiaoxingche', '小型车', '97', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962208', '1420962208', '1', '0', '40');
INSERT INTO `by_category` VALUES ('99', 'nvbao', '女包', '72', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962320', '1420962320', '1', '0', '40');
INSERT INTO `by_category` VALUES ('100', 'danjianbao', '单肩包', '99', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962475', '1420962475', '1', '0', '40');
INSERT INTO `by_category` VALUES ('101', 'shoutibao', '手提包', '99', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962560', '1420962560', '1', '0', '40');
INSERT INTO `by_category` VALUES ('102', 'weixiubaoyang', '维修保养', '73', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962736', '1420962736', '1', '0', '40');
INSERT INTO `by_category` VALUES ('103', 'yunhuayou', '润滑油', '102', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962815', '1420962815', '1', '213', '40');
INSERT INTO `by_category` VALUES ('109', 'dianchi', '电池', '105', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963534', '1421426883', '1', '0', '40');
INSERT INTO `by_category` VALUES ('104', 'shoujitx', '手机通信', '107', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963032', '1420963107', '1', '0', '38');
INSERT INTO `by_category` VALUES ('105', 'shoujipj', '手机配件', '107', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963151', '1420963151', '1', '0', '40');
INSERT INTO `by_category` VALUES ('106', 'mbhli', '面部护肤', '90', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963200', '1420963200', '1', '0', '40');
INSERT INTO `by_category` VALUES ('107', 'sjsmtx', '手机数码', '0', '6', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1420963286', '1421388202', '1', '455', '43');
INSERT INTO `by_category` VALUES ('110', 'mobilephone', '手机', '104', '0', '10', '', '', '', '', '', '', '', '2', '1', '\"\"', '1420963589', '1428684577', '1', '0', '43');
INSERT INTO `by_category` VALUES ('111', 'jiajujiaz', '家具家装', '0', '0', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1420963642', '1421388233', '1', '457', '40');
INSERT INTO `by_category` VALUES ('112', 'chuju', '厨具', '111', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963698', '1420963698', '1', '0', '40');
INSERT INTO `by_category` VALUES ('114', 'daojiancb', '刀剪菜板', '112', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963850', '1420963850', '1', '0', '40');
INSERT INTO `by_category` VALUES ('115', 'nanzhuang', '男装', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964463', '1420964463', '1', '0', '40');
INSERT INTO `by_category` VALUES ('116', 'chenshan', '衬衫', '115', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964510', '1420964510', '1', '0', '40');
INSERT INTO `by_category` VALUES ('117', 'nvzhuang', '女装', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964548', '1420964548', '1', '0', '39');
INSERT INTO `by_category` VALUES ('118', 'fushipj', '服饰配件', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964671', '1420964671', '1', '0', '40');
INSERT INTO `by_category` VALUES ('119', 'zbss', '珠宝首饰', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964736', '1420964736', '1', '0', '40');
INSERT INTO `by_category` VALUES ('120', 'milk', '奶粉', '76', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965368', '1420965391', '1', '0', '40');
INSERT INTO `by_category` VALUES ('121', 'yyfs', '营养辅食', '76', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965451', '1420965451', '1', '0', '40');
INSERT INTO `by_category` VALUES ('123', 'tyj', '太阳镜', '118', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965553', '1420965553', '1', '0', '40');
INSERT INTO `by_category` VALUES ('124', 'clz', '车厘子', '58', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1420965600', '1420965600', '1', '0', '40');
INSERT INTO `by_category` VALUES ('129', 'yurf', '羽绒服', '115', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1421591035', '1421591035', '1', '0', '42');
INSERT INTO `by_category` VALUES ('150', 'lysx', '粮油生鲜', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442675312', '1442675312', '1', '428', '40');
INSERT INTO `by_category` VALUES ('151', 'ylnn', '饮料牛奶', '52', '0', '30', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '\"\"', '1442675533', '1442675533', '1', '427', '47');
INSERT INTO `by_category` VALUES ('152', 'xxsp', '休闲食品', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442675864', '1442675864', '1', '426', '41');
INSERT INTO `by_category` VALUES ('153', 'djmj', '鼎极名酒', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442742276', '1442946577', '1', '425', '40');
INSERT INTO `by_category` VALUES ('154', 'clyy', '潮流影音', '107', '0', '30', '', '', '', '', '', '', '', '2', '1', '\"\"', '1442754697', '1442754697', '1', '0', '40');
INSERT INTO `by_category` VALUES ('155', 'divyj', 'DIV硬件', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754780', '1442754780', '1', '434', '40');
INSERT INTO `by_category` VALUES ('156', 'djyx', '电竞游戏', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754842', '1442754842', '1', '432', '44');
INSERT INTO `by_category` VALUES ('157', 'bgwl', '办公网络', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754922', '1442754922', '1', '431', '44');
INSERT INTO `by_category` VALUES ('158', 'ejem', '耳机耳麦', '154', '0', '30', '', '', '', '', '', '', '', '2', '1', '\"\"', '1442771388', '1442771388', '1', '0', '40');
INSERT INTO `by_category` VALUES ('159', '', '长袖', '117', '0', '10', '', '', '', '', '', '', '', '', '0', '', '0', '0', '0', '0', '39');
INSERT INTO `by_category` VALUES ('160', '', '笔记本', '157', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '44');
INSERT INTO `by_category` VALUES ('161', '', '坚果', '152', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('162', '', '糖果', '152', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('163', '', '下装', '115', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '42');
INSERT INTO `by_category` VALUES ('164', '', '闪购', '0', '0', '0', '', '', '', '', '', 'goods/time_detail', 'goods/time', '0', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('165', '', '手机端', '164', '0', '0', '', '', '', '', '', '', 'goods/time', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('167', '', '10点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('168', '', '15点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('169', '', '20点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('170', '', '22点场', '165', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('172', '', '积分', '0', '0', '0', '', '', '', '', 'goods/score_lists', 'goods/score_detail', 'goods/score', '0', '0', '', '0', '0', '1', '0', '50');
INSERT INTO `by_category` VALUES ('173', '', '手机积分购', '172', '0', '0', '', '', '', '', 'goods/score_lists', 'goods/score_detail', 'goods/score', '1', '0', '', '0', '0', '1', '0', '50');
INSERT INTO `by_category` VALUES ('174', '', '通用', '165', '0', '0', '', '', '', '', 'goods/time_lists', 'goods/time_detail', 'goods/time', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `by_category` VALUES ('175', '', '上衣', '115', '0', '0', '', '', '', '', '', '', 'goods/edit', '1', '0', '', '0', '0', '1', '0', '42');
INSERT INTO `by_category` VALUES ('176', '', '手机专享', '0', '0', '0', '', '', '', '', '', '', '', '0', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('177', '', '医药保健', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('178', '', '机票酒店', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('179', '', '安装维修', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('180', '', '理财保险', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `by_category` VALUES ('182', '', '预约', '0', '0', '0', '', '', '', '', 'goods/yuyue_lists', 'goods/yuyue_detail', 'goods/edit', '0', '0', '', '0', '0', '1', '0', '51');
INSERT INTO `by_category` VALUES ('183', '', '电脑', '75', '0', '0', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '', '0', '', '0', '0', '1', '0', '40');

-- ----------------------------
-- Table structure for by_change
-- ----------------------------
DROP TABLE IF EXISTS `by_change`;
CREATE TABLE `by_change` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goodid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `tool` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `toolid` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `info` varchar(225) NOT NULL DEFAULT '',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `backinfo` varchar(225) NOT NULL DEFAULT '',
  `shopid` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `assistant` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) NOT NULL DEFAULT '',
  `reason` varchar(225) NOT NULL DEFAULT '',
  `changetool` varchar(225) NOT NULL DEFAULT '',
  `changetoolid` varchar(225) NOT NULL DEFAULT '',
  `address` varchar(225) NOT NULL DEFAULT '',
  `contact` varchar(225) NOT NULL DEFAULT '',
  `parameters` varchar(225) NOT NULL DEFAULT '',
  `backname` varchar(225) NOT NULL DEFAULT '',
  `acceptname` varchar(255) NOT NULL DEFAULT '',
  `acceptphone` varchar(225) NOT NULL DEFAULT '',
  `acceptaddress` varchar(225) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '' COMMENT '联系人',
  `userphone` varchar(225) NOT NULL DEFAULT '' COMMENT '联系方式',
  `useraddress` varchar(225) NOT NULL DEFAULT '' COMMENT '联系地址',
  `partnerid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表';

-- ----------------------------
-- Records of by_change
-- ----------------------------

-- ----------------------------
-- Table structure for by_channel
-- ----------------------------
DROP TABLE IF EXISTS `by_channel`;
CREATE TABLE `by_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '新窗口打开',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='频道表';

-- ----------------------------
-- Records of by_channel
-- ----------------------------
INSERT INTO `by_channel` VALUES ('1', '0', '首页', 'Index/index', '1', '1379475111', '1379923177', '1', '0', '0');
INSERT INTO `by_channel` VALUES ('12', '0', '秒杀', 'index/shan', '0', '1594280649', '1594280649', '1', '0', '84');
INSERT INTO `by_channel` VALUES ('16', '0', '店铺街', 'index/shop', '0', '1585106910', '1585106910', '1', '0', '79');
INSERT INTO `by_channel` VALUES ('17', '0', '优惠券', 'coupon/index', '0', '1594001076', '1594001076', '1', '0', '84');
INSERT INTO `by_channel` VALUES ('18', '0', '积分商城', 'index/score', '0', '1594001093', '1594001093', '1', '0', '84');

-- ----------------------------
-- Table structure for by_collect
-- ----------------------------
DROP TABLE IF EXISTS `by_collect`;
CREATE TABLE `by_collect` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-可见 -1-无效',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COMMENT='收藏表';

-- ----------------------------
-- Records of by_collect
-- ----------------------------
INSERT INTO `by_collect` VALUES ('27', '1', '223', '0', '0');
INSERT INTO `by_collect` VALUES ('28', '1', '164', '0', '0');
INSERT INTO `by_collect` VALUES ('29', '17', '227', '0', '0');
INSERT INTO `by_collect` VALUES ('30', '17', '219', '0', '0');
INSERT INTO `by_collect` VALUES ('31', '18', '378', '0', '0');
INSERT INTO `by_collect` VALUES ('32', '18', '215', '0', '0');
INSERT INTO `by_collect` VALUES ('33', '18', '373', '0', '0');
INSERT INTO `by_collect` VALUES ('34', '18', '214', '0', '0');
INSERT INTO `by_collect` VALUES ('35', '1', '227', '0', '0');
INSERT INTO `by_collect` VALUES ('36', '1', '225', '0', '0');
INSERT INTO `by_collect` VALUES ('37', '23', '224', '0', '0');
INSERT INTO `by_collect` VALUES ('43', '74', '225', '1581842439', '1');
INSERT INTO `by_collect` VALUES ('42', '74', '225', '1581842418', '1');
INSERT INTO `by_collect` VALUES ('48', '79', '233', '0', '0');
INSERT INTO `by_collect` VALUES ('49', '84', '224', '0', '0');
INSERT INTO `by_collect` VALUES ('51', '84', '223', '0', '0');

-- ----------------------------
-- Table structure for by_collect_shop
-- ----------------------------
DROP TABLE IF EXISTS `by_collect_shop`;
CREATE TABLE `by_collect_shop` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `shop_id` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-可见 -1-无效',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COMMENT='收藏表';

-- ----------------------------
-- Records of by_collect_shop
-- ----------------------------
INSERT INTO `by_collect_shop` VALUES ('38', '23', '10', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('39', '71', '10', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('40', '74', '1', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('41', '74', '10', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('42', '85', '0', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('45', '84', '10', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('44', '104', '0', '0', '0');
INSERT INTO `by_collect_shop` VALUES ('46', '97', '10', '0', '0');

-- ----------------------------
-- Table structure for by_comment
-- ----------------------------
DROP TABLE IF EXISTS `by_comment`;
CREATE TABLE `by_comment` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goods_id` int(100) unsigned NOT NULL DEFAULT '0',
  `sales_id` int(100) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `score` varchar(225) DEFAULT NULL,
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `des` int(5) unsigned NOT NULL DEFAULT '0',
  `service` int(5) unsigned NOT NULL DEFAULT '0',
  `delivery` int(5) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL,
  `tag` varchar(225) DEFAULT NULL,
  `is_over` int(2) DEFAULT '0',
  `cover_id` varchar(225) DEFAULT NULL COMMENT '图片',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-可见 -1-无效',
  `uid` int(10) DEFAULT '0',
  `is_picture` int(2) NOT NULL DEFAULT '0',
  `not_empty` int(2) NOT NULL DEFAULT '1',
  `hide` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品表';

-- ----------------------------
-- Records of by_comment
-- ----------------------------
INSERT INTO `by_comment` VALUES ('1', '207', '0', '0', null, '0', '0', '0', '0', '66666', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('2', '207', '0', '0', null, '0', '0', '0', '0', '好评', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('28', '207', '355', '1591862289', null, '0', '0', '0', '0', 'SDFSDFSDF', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('29', '207', '355', '1591862290', null, '0', '0', '0', '0', 'SDFSDFSDF', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('30', '207', '354', '1591862813', null, '0', '0', '0', '0', '', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('31', '199', '351', '1591863286', null, '0', '2', '2', '3', '6666', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('32', '225', '350', '1591863486', null, '0', '3', '4', '5', 'safafasf', null, '0', '588,589', '0', '82', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('33', '225', '372', '1592448003', null, '0', '2', '3', '4', '好评...6666', null, '0', '593,597', '0', '84', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('34', '225', '372', '1592399198', null, '0', '2', '3', '4', '好评', null, '0', '592,593', '0', '84', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('35', '225', '372', '1592399236', null, '0', '2', '3', '4', '好评', null, '0', '592,593', '0', '85', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('36', '207', '371', '1592464215', null, '0', '2', '3', '4', '好评.....', null, '0', '594', '0', '85', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('37', '227', '370', '1592399543', null, '0', '2', '2', '2', '好评', null, '0', '595', '0', '104', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('38', '227', '370', '1592399544', null, '0', '2', '2', '2', '好评', null, '0', '595', '0', '104', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('39', '225', '369', '1592399576', null, '0', '1', '1', '1', '好评', null, '0', '596,588,589', '0', '84', '0', '1', '1');
INSERT INTO `by_comment` VALUES ('40', '207', '371', '1592452415', null, '0', '3', '3', '3', '好评', null, '0', '598', '0', '104', '0', '1', '1');

-- ----------------------------
-- Table structure for by_comments
-- ----------------------------
DROP TABLE IF EXISTS `by_comments`;
CREATE TABLE `by_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `message` text CHARACTER SET utf8 NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `reply` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `pictures` varchar(225) CHARACTER SET utf8 DEFAULT NULL COMMENT '图片回复',
  `is_picture` int(1) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `is_hide` int(10) NOT NULL DEFAULT '0',
  `is_over` int(10) NOT NULL DEFAULT '0',
  `not_empty` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of by_comments
-- ----------------------------
INSERT INTO `by_comments` VALUES ('1', '2147483647', '很好！', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('2', '2147483647', '嗯嗯，不错！', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('3', '2147483647', '我也评论一下，嘿嘿~', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('4', '2147483647', '产品2的评论1.', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('5', '2147483647', '啊啊啊啊', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('6', '2147483647', '产品3评论', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('7', '2147483647', '再加评论！', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('8', '2147483647', '写一条很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长的测试评论。', '0', '127.0.0.1', '', '0', '0', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('9', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('10', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('11', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('12', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('13', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('14', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('15', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('16', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('17', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('18', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('19', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('20', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('21', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('22', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('23', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('24', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('25', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('26', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('27', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('28', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('29', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('30', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('31', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('32', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('33', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('34', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('35', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('36', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('37', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('38', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('39', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('40', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('41', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('42', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('43', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('44', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('45', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('46', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('47', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('48', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');
INSERT INTO `by_comments` VALUES ('49', '1421503470', '比我想象中的要好很多，实惠实用，组装特别简单，值得入手', '1', '感谢亲的好评，授人玫瑰手有余香，您的好评是对我们最大的支持与鼓励，也将是我们不断前进的动力！有您的支持和肯定，我们会更加努力做到更好，如果亲有不满意的地方请一定及时联系我们哦，不周到的地方还请亲们多多谅解哈。!期待您的再次光临！', '1,2,3,4', '1', '66', '0', '0', '0');

-- ----------------------------
-- Table structure for by_comments_tag
-- ----------------------------
DROP TABLE IF EXISTS `by_comments_tag`;
CREATE TABLE `by_comments_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attr_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) NOT NULL,
  `category_id` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_comments_tag
-- ----------------------------

-- ----------------------------
-- Table structure for by_comment_tag
-- ----------------------------
DROP TABLE IF EXISTS `by_comment_tag`;
CREATE TABLE `by_comment_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attr_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) NOT NULL,
  `category_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_comment_tag
-- ----------------------------

-- ----------------------------
-- Table structure for by_config
-- ----------------------------
DROP TABLE IF EXISTS `by_config`;
CREATE TABLE `by_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` varchar(225) NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `group` varchar(225) DEFAULT '0' COMMENT '配置分组',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '配置值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '配置说明',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `value` text COMMENT '配置值',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=167 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_config
-- ----------------------------
INSERT INTO `by_config` VALUES ('1', 'WEB_SITE_TITLE', 'text', '网站标题', '0', '', '网站标题前台显示标题', '1378898976', '1379235274', '1', 'bymall多用户分销商城系统', '0');
INSERT INTO `by_config` VALUES ('2', 'DESCRIPTION', 'textarea', '网站描述', '0', '', '网站搜索引擎描述', '1378898976', '1379235841', '1', 'bymall商城系统,567575', '1');
INSERT INTO `by_config` VALUES ('3', 'KEYWORD', 'textarea', '网站关键字', '1', '', '网站搜索引擎关键字', '1378898976', '1381390100', '1', 'yershop,OneThink商城，thinkphp商城系统', '8');
INSERT INTO `by_config` VALUES ('4', 'WEB_SITE_CLOSE', 'select', '关闭站点', '0', '0:关闭,1:开启', '站点关闭后其他用户不能访问，管理员可以正常访问', '1378898976', '1379235296', '1', '1', '1');
INSERT INTO `by_config` VALUES ('92', 'logo', 'picture', '网站logo', '0', '', '网站logo', '0', '0', '0', '608', '0');
INSERT INTO `by_config` VALUES ('116', 'BTN', 'color', '按钮背景色', '1', '', '', '0', '0', '0', '#0082df', '0');
INSERT INTO `by_config` VALUES ('91', 'GROUP', 'text', '配置分组', '-1', '', '', '0', '0', '0', '基本|高级|接口|参数|商城|客服|上传|小程序|分销', '0');
INSERT INTO `by_config` VALUES ('102', 'DIALOG_STYLE', 'select', '提示框弹窗类型', '1', '0:旧式风格,\r\n1:改进型easyDialog风格\r\n2:layer风格', '处理成功后弹出类型', '0', '0', '0', '2', '0');
INSERT INTO `by_config` VALUES ('106', 'USER_ALLOW_REGISTER', 'select', '是否开启会员注册', '1', '0:关闭,1:开启', '0:关闭,1:开启', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('166', 'kefu', 'select', '客服类型', '5', '1:qq客服\r\n2:qq客服、内置客服', '客服种类选择', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('110', 'PHONE', 'text', '联系方式', '4', '', '', '0', '0', '0', '027-88125684', '0');
INSERT INTO `by_config` VALUES ('111', 'ALI', 'text', '阿里旺旺号', '4', '', '', '0', '0', '0', '234234', '0');
INSERT INTO `by_config` VALUES ('112', 'STAR', 'textarea', '星座配置', '3', '', '', '0', '0', '0', '巨蟹座|狮子座|双鱼座|处女座|双子座|天蝎座 |射手座|水瓶座', '0');
INSERT INTO `by_config` VALUES ('122', 'SINAAPPID', 'text', '新浪微博appid', '2', '', '申请后获得，申请地址http://open.weibo.com/', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('123', 'SINASECRET', 'text', '新浪微博secret', '2', '', '申请后获得，申请地址http://open.weibo.com/', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('126', 'REKEWORD', 'text', '热门搜索', '0', '', '', '0', '0', '0', '手机|电脑|笔记本|yershop|苹果|梨|启赋4', '0');
INSERT INTO `by_config` VALUES ('127', 'upload_type', 'select', '上传驱动', '6', '0:本地上传\r\n1:阿里云oss\r\n2:七牛云', '默认使用本地上传', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('128', 'ACCESSID', 'text', '阿里云AccessId', '6', '', '阿里云OSS AccessId', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('129', 'ACCESSKEY', 'text', '阿里云AccessKey', '6', '', '阿里云AccessKey', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('130', 'SERVERURL', 'text', '阿里云服务器地址', '6', '', '以\"/\"结尾', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('131', 'SITE_NAME', 'text', '网站名称', '0', '', '', '0', '0', '0', 'bymall', '0');
INSERT INTO `by_config` VALUES ('132', 'API_USER', 'text', 'SendCloud用户名API_USER', '7', '', '您需要登录SendCloud创建API_USER，使用API_USER和API_KEY才可以进行邮件的发送', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('133', 'API_KEY', 'text', 'SendCloud密钥API_KEY', '7', '', '您需要登录SendCloud创建API_USER，使用API_USER和API_KEY才可以进行邮件的发送', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('134', 'IS_MANG', 'select', '是否开启满减优惠', '3', '0:关闭,1:开启', '开启后计算满减优惠，默认开启', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('135', 'pin', 'select', '是否开启拼团', '3', '0:关闭,1:开启', '0:关闭,1:开启', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('136', 'fenxiao', 'select', '是否开启分销', '8', '0:关闭,1:开启', '0:关闭,1:开启，开启后将加大运算负荷，请使用更高配置的服务器', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('137', 'l1', 'text', '一级提成比例', '8', '', '', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('138', 'l2', 'text', '二级提成比例', '8', '', '', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('139', 'l3', 'text', '三级提成比例', '8', '', '', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('140', 'l4', 'text', '四级提成比例', '8', '', '', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('141', 'l5', 'text', '五级提成比例', '8', '', '', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('142', 'ishttps', 'select', '开启https', '4', '0:关闭\r\n1:开启', '使用https方法 1.服务器配置安全证书 2.开启https开关', '0', '0', '0', '0', '0');
INSERT INTO `by_config` VALUES ('143', 'PERCENT', 'text', '提现手续费', '4', '', '平台商家每次提现抽成', '0', '0', '0', '5%', '0');
INSERT INTO `by_config` VALUES ('144', 'money', 'text', '最低提现金额', '4', '', '平台商家最低提现金额', '0', '0', '0', '100', '0');
INSERT INTO `by_config` VALUES ('145', 'notin', 'text', '商家不显示的商品分类id', '4', '', '商家不显示的商品分类id列表，如拼团，预约', '0', '0', '0', '172,181,182,164', '0');
INSERT INTO `by_config` VALUES ('146', 'qq', 'text', 'qq客服', '4', '', '', '0', '0', '0', '1010422715', '0');
INSERT INTO `by_config` VALUES ('147', 'wxcode', 'picture', '微信商城二维码', '0', '', '', '0', '0', '0', '604', '0');
INSERT INTO `by_config` VALUES ('148', 'gzh', 'picture', '公众号二维码', '0', '', '', '0', '0', '0', '605', '0');
INSERT INTO `by_config` VALUES ('149', 'QACCESSKEY', 'text', '七牛云accessKey', '6', '', '七牛云accessKey', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('150', 'QSECRETKEY', 'text', '七牛云secretKey', '6', '', '七牛云secretKey', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('151', ' QDOMAIN', 'text', '七牛云空间绑定的域名', '6', '', '七牛云空间绑定的域名', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('152', 'QBUCKET ', 'text', '七牛云上传的空间名称  ', '6', '', '七牛云上传的空间名称', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('153', 'isp', 'text', '备案号', '0', '', '备案号', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('154', 'dl', 'picture', '登陆页背景图片', '0', '', '登陆页背景', '0', '0', '0', '606', '0');
INSERT INTO `by_config` VALUES ('155', 'home_logo', 'picture', '会员中心logo', '0', '', '会员中心logo', '0', '0', '0', '607', '0');
INSERT INTO `by_config` VALUES ('156', 'PERCENT', 'text', '提现手续费率', '4', '', '百分比', '0', '0', '0', '5%', '0');
INSERT INTO `by_config` VALUES ('158', 'wxkey', 'text', '微信支付密钥', '7', '', '微信支付key', '0', '0', '0', '', '0');
INSERT INTO `by_config` VALUES ('159', 'isTest', 'checkbox', '是否开启小测试模式', '7', '', '使用测试类目申请上线，审核通过使用正式类目\r\n', '0', '0', '0', '0', '0');
INSERT INTO `by_config` VALUES ('160', 'retail_type', 'select', '分红模式', '8', '1:分级模式\r\n2:固定分红金额\r\n', '分销模式，1-订单金额分级计算，2-根据商品佣金只计算上一级', '0', '0', '0', '2', '0');
INSERT INTO `by_config` VALUES ('161', 'add_score', 'text', '登录每次赠送积分', '4', '', '会员登录每次赠送多少积分', '0', '0', '0', '2', '0');
INSERT INTO `by_config` VALUES ('162', 'is_pc', 'select', '二维码扫码后进入pc端还是wap端', '8', '1:pc端\r\n2:wap端', '二维码扫码结果', '0', '0', '0', '1', '0');
INSERT INTO `by_config` VALUES ('163', 'zhouqi', 'text', '结算周期', '8', '', '订单确认收货多少天后返佣', '0', '0', '0', '15', '0');
INSERT INTO `by_config` VALUES ('165', 'signScore', 'text', '签到赠送积分', '4', '', '签到赠送积分数量', '0', '0', '0', '3', '0');

-- ----------------------------
-- Table structure for by_consult
-- ----------------------------
DROP TABLE IF EXISTS `by_consult`;
CREATE TABLE `by_consult` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `reply` varchar(225) DEFAULT NULL,
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `is_hide` int(10) NOT NULL DEFAULT '0',
  `type` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=283 DEFAULT CHARSET=utf8 COMMENT='咨询表';

-- ----------------------------
-- Records of by_consult
-- ----------------------------
INSERT INTO `by_consult` VALUES ('1', '1491292996', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('2', '1491293239', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('3', '1491293310', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('4', '1491293734', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('5', '1491293746', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('6', '1491293752', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('7', '1491293754', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('8', '1491293756', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('9', '1491293756', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('10', '1491293757', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('11', '1491293806', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('12', '1491293808', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('13', '1491293823', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('14', '1491293825', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('15', '1491293827', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('16', '1491294160', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('17', '1491294172', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('18', '1491294173', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('19', '1491294187', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('20', '1491294189', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('21', '1491294361', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('22', '1491294379', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('23', '1491294419', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('24', '1491294428', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('25', '1491294434', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('26', '1491304325', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('27', '1491304372', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('28', '1491304415', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('29', '1491304863', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('30', '1491304894', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('31', '1491304939', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('32', '1491305002', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('33', '1491305080', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('34', '1491305131', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('35', '1491305148', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('36', '1491305179', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('37', '1491305277', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('38', '1491305303', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('39', '1491306295', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('40', '1491306318', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('41', '1491306401', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('42', '1491306413', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('43', '1491306525', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('44', '1491306557', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('45', '1491306596', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('46', '1491306637', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('47', '1491306702', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('48', '1491306727', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('49', '1491306762', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('50', '1491306977', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('51', '1491306980', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('52', '1491307001', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('53', '1491307169', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('54', '1491307180', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('55', '1491307190', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('56', '1491308467', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('57', '1491308534', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('58', '1491308568', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('59', '1491308803', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('60', '1491308847', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('61', '1491308871', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('62', '1491308909', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('63', '1491308930', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('64', '1491308947', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('65', '1491308975', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('66', '1491309030', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('67', '1491309091', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('68', '1491309092', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('69', '1491309093', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('70', '1491309093', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('71', '1491309094', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('72', '1491309094', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('73', '1491309095', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('74', '1491309095', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('75', '1491309096', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('76', '1491309096', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('77', '1491309097', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('78', '1491309097', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('79', '1491309098', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('80', '1491309098', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('81', '1491309099', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('82', '1491309099', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('83', '1491309100', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('84', '1491309100', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('85', '1491309101', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('86', '1491309101', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('87', '1491309102', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('88', '1491309138', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('89', '1491309169', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('90', '1491309173', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('91', '1491309174', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('92', '1491309174', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('93', '1491309175', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('94', '1491309175', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('95', '1491309176', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('96', '1491309176', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('97', '1491309177', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('98', '1491309177', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('99', '1491309178', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('100', '1491309178', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('101', '1491309179', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('102', '1491309179', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('103', '1491309180', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('104', '1491309180', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('105', '1491309181', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('106', '1491309181', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('107', '1491309182', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('108', '1491309182', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('109', '1491309183', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('110', '1491310064', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('111', '1491310065', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('112', '1491310066', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('113', '1491310066', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('114', '1491310067', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('115', '1491310067', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('116', '1491310068', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('117', '1491310068', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('118', '1491310069', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('119', '1491310069', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('120', '1491310070', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('121', '1491310070', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('122', '1491310071', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('123', '1491310071', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('124', '1491310072', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('125', '1491310072', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('126', '1491310073', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('127', '1491310073', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('128', '1491310074', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('129', '1491310074', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('130', '1491310076', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('131', '1491310076', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('132', '1491310132', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('133', '1491310297', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('134', '1491310656', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('135', '1491310730', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('136', '1491310731', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('137', '1491310731', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('138', '1491310736', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('139', '1491310736', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('140', '1491310737', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('141', '1491310737', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('142', '1491310738', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('143', '1491310738', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('144', '1491310739', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('145', '1491310739', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('146', '1491310740', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('147', '1491310740', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('148', '1491310741', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('149', '1491310741', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('150', '1491310742', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('151', '1491310742', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('152', '1491310743', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('153', '1491310743', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('154', '1491310744', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('155', '1491310744', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('156', '1491310753', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('157', '1491310772', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('158', '1491310773', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('159', '1491310773', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('160', '1491310774', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('161', '1491310775', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('162', '1491310775', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('163', '1491310776', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('164', '1491310776', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('165', '1491310777', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('166', '1491310777', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('167', '1491310778', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('168', '1491310778', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('169', '1491310779', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('170', '1491310779', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('171', '1491310780', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('172', '1491310781', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('173', '1491310781', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('174', '1491310782', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('175', '1491310782', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('176', '1491310782', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('177', '1491310783', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('178', '1491310810', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('179', '1491310995', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('180', '1491311004', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('181', '1491311028', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('182', '1491313343', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('183', '1491323726', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('184', '1491323764', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('185', '1491323868', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('186', '1491324006', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('187', '1491325901', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('188', '1491329529', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('189', '1491329740', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('190', '1491329868', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('191', '1491330800', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('192', '1491331388', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('193', '1491331447', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('194', '1491331455', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('195', '1491331894', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('196', '1491331917', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('197', '1491331963', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('198', '1491373985', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('199', '1491373994', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('200', '1491373996', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('201', '1491374097', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('202', '1491374101', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('203', '1491374115', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('204', '1491374138', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('205', '1491374155', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('206', '1491374161', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('207', '1491374924', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('208', '1491374994', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('209', '1491375006', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('210', '1491375012', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('211', '1491375128', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('212', '1491375814', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('213', '1491377436', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('214', '1491388277', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('215', '1491388311', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('216', '1491388327', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('217', '1491388332', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('218', '1491388731', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('219', '1491388750', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('220', '1491388756', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('221', '1491420959', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('222', '1491421059', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('223', '1491421107', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('224', '1491421122', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('225', '1491423565', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('226', '1491423917', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('227', '1491423941', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('228', '1491423961', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('229', '1491424233', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('230', '1491424622', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('231', '1491424706', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('232', '1491424707', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('233', '1491424708', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('234', '1491424710', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('235', '1491424712', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('236', '1491489834', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('237', '1491493967', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('238', '1491494007', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('239', '1491563982', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('240', '1491564012', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('241', '1491564057', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('242', '1491620468', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('243', '1491620529', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('244', '1491620627', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('245', '1491620687', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('246', '1491648796', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('247', '1491648807', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('248', '1491648820', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('249', '1491649214', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('250', '1491655005', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('251', '1491673388', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('252', '1491673623', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('253', '1491673819', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('254', '1491676980', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('255', '1491677479', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('256', '1491677489', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('257', '1491681428', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('258', '1491686180', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('259', '1491686563', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('260', '1491724406', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('261', '1491724510', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('262', '1491725750', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('263', '1491725765', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('264', '1491732126', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('265', '1491732223', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('266', '1491734249', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('267', '1491734402', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('268', '1491734647', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('269', '1491734721', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('270', '1491736059', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('271', '1491736653', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('272', '1491736991', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('273', '1491738736', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('274', '1491740969', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('275', '1491742060', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('276', '1491742091', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('277', '1491742244', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('278', '1491742276', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('279', '1491742295', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('280', '1491742638', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('281', '1491742807', '22', '3', '', '2', '0', '2');
INSERT INTO `by_consult` VALUES ('282', '1491746601', '22', '3', '', '2', '0', '2');

-- ----------------------------
-- Table structure for by_count
-- ----------------------------
DROP TABLE IF EXISTS `by_count`;
CREATE TABLE `by_count` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `mark` text NOT NULL COMMENT '名称',
  `num` tinyint(11) NOT NULL DEFAULT '1' COMMENT '数量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `model` varchar(225) DEFAULT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_count
-- ----------------------------
INSERT INTO `by_count` VALUES ('3', '访客数+1', '67', '1495735475', '0', 'visitor', '20170526');
INSERT INTO `by_count` VALUES ('2', '访客数+1', '39', '1495650488', '0', 'visitor', '20170525');
INSERT INTO `by_count` VALUES ('4', '访客数+1', '40', '1495816863', '0', 'visitor', '20170527');
INSERT INTO `by_count` VALUES ('5', '访客数+1', '127', '1495904307', '0', 'visitor', '20170528');
INSERT INTO `by_count` VALUES ('6', '访客数+1', '127', '1495989967', '0', 'visitor', '20170529');
INSERT INTO `by_count` VALUES ('7', '访客数+1', '68', '1496075914', '0', 'visitor', '20170530');
INSERT INTO `by_count` VALUES ('8', '访客数+1', '3', '1496243612', '0', 'visitor', '20170531');

-- ----------------------------
-- Table structure for by_coupon
-- ----------------------------
DROP TABLE IF EXISTS `by_coupon`;
CREATE TABLE `by_coupon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `money` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `total` varchar(225) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '数量',
  `total_num` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='优惠券表';

-- ----------------------------
-- Records of by_coupon
-- ----------------------------
INSERT INTO `by_coupon` VALUES ('9', '新用户首单优惠券', '2', '100', '1588076328', '1608812328', '1', '0', '0', '0', '0');
INSERT INTO `by_coupon` VALUES ('10', '五一劳动节优惠券', '10', '100', '1588077910', '1626007510', '1', '0', '0', '0', '0');
INSERT INTO `by_coupon` VALUES ('11', '六一儿童节', '50', '1000', '1590940800', '1601222400', '1', '0', '0', '0', '0');
INSERT INTO `by_coupon` VALUES ('12', '10元优惠券', '10', '200', '1588176000', '1602691200', '1', '0', '0', '0', '0');
INSERT INTO `by_coupon` VALUES ('13', '店铺优惠券', '12', '500', '1594567065', '1657552665', '1', '10', '84', '2', '10');

-- ----------------------------
-- Table structure for by_document
-- ----------------------------
DROP TABLE IF EXISTS `by_document`;
CREATE TABLE `by_document` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '标题',
  `category_id` int(10) unsigned NOT NULL COMMENT '所属分类',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `content` text NOT NULL,
  `sort` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_category_status` (`category_id`,`status`) USING BTREE,
  KEY `idx_status_type_pid` (`status`,`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8 COMMENT='文档模型基础表';

-- ----------------------------
-- Records of by_document
-- ----------------------------
INSERT INTO `by_document` VALUES ('92', '74', '入驻流程', '50', '0', '0', '1582277025', '1582277025', '1', '<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n	<strong>yershop商城商家入驻流程<br />\r\n<br />\r\n工作时间<br />\r\n<br />\r\nAM 09:00 - PM 18:00 （推荐使用邮件进行业务对接）或使用平台客服&gt;&gt;&gt;<br />\r\n<br />\r\n账户安全必选项：修改密码、邮箱绑定、电话绑定、支付密码设置。账户安全&gt;&gt;&gt;<br />\r\n<br />\r\nyershop招商<br />\r\n<br />\r\n联系电话：0592-3202333或拨打18506950008（微信同号，备注：商家入驻、企业名称）<br />\r\n<br />\r\n2020年度，因特殊时期yershop商城平台将对自1月1日-12月31日时间内所有商家入驻的店铺实行免保证金、免年费及免佣金等全免最新招商政策。（只收取第三方支付交易手续费1%）<br />\r\n<br />\r\n1.注册会员&nbsp;<br />\r\n“免费注册”会员账号后并登录；<br />\r\n然后进入“招商入驻”首页，点击“我要入驻”；<br />\r\n<br />\r\n2.提交资料<br />\r\n“确认协议”后，填写公司及联系人信息、开户银行信息、店铺经营信息、提交申请；<br />\r\n<br />\r\n3.等待审核<br />\r\nyershop商城会在1-3个工作日内，通过短信和邮件通知反馈审核结果；<br />\r\n<br />\r\n4.商家缴纳<br />\r\n&nbsp;店铺审核通过后进入“招商入驻”首页，点击\"查看入驻进度\"使用“在线充值”并用账户余额缴纳开店保证金；账户安全&gt;&gt;&gt;<br />\r\n<br />\r\nyershop商城确认缴纳保证金后，使用\"店主卖家账号”登录“商家管理中心” 先进行“店铺续约”再进行其他店铺管理操作。<br />\r\n<br />\r\n5.服务邮箱: zhaoshang@taokubuy.com 更多&gt;&gt;&gt;<br />\r\n<br />\r\n6.廉洁监督&nbsp;&nbsp;<br />\r\n电子邮箱: icac@taokubuy.com<br />\r\n<br />\r\n温馨提醒：请您在投诉中提供部门及相关人员、投诉原因，以便我们核实处理，谢谢！<br />\r\n</strong>\r\n</p>\r\n<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('93', '74', '开店协议', '8', '0', '0', '1582277202', '1582277202', '1', '<strong><span style=\"color:#E56600;\">1.协议前言</span></strong><span style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\"></span>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<p>\r\n		为了更好地开拓市场，更好地为客户服务，甲乙双方本着互惠互利的双赢策略，根据乙方商家入驻条件，甲方申请入驻乙方商家，并完全接受乙方的规范，经友好协商，甲乙双方签署以下入驻协议。\r\n	</p>\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help2\"></a><strong><span style=\"color:#E56600;\">2.入驻商家基本条件</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	1、&nbsp;有良好的合作意愿，能提供优质的商品，保证合作的顺利进行，并保证提供良好的售后服务；<br />\r\n2、&nbsp;甲方必须满足以下条件之一（符合其中一项即可）：<br />\r\n⑴授权商，获得国际或者国内知名品牌开发商的授权；<br />\r\n⑵拥有自己注册商标的开发商；<br />\r\n⑶专业从事原创ppt设计的个人或团队；<br />\r\n⑷专业品牌ppt专卖店。<br />\r\n3、&nbsp;甲方应在签订本协议时向乙方提供（经乙方认可的）包括但不限于以下证明材料复印件：<br />\r\n⑴个人身份证；<br />\r\n⑵拥有注册商标或者品牌，或者拥有正规的品牌授权书。<br />\r\n4、&nbsp;甲方承诺：<br />\r\n⑴所有商品一口价销售（参与打折、促销、秒杀、团购等活动除外）；<br />\r\n⑵ 参加乙方全网积分购物活动；<br />\r\n⑶所有资源保证能正常使用，且不侵害他人版权，保障资源质量、承诺售后服务，必要时能提供销售发票。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help3\"></a><strong><span style=\"color:#E56600;\">3.入驻商铺类型</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	1、&nbsp;普通型商家；<br />\r\n2、&nbsp;等待开发。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help4\"></a><strong><span style=\"color:#E56600;\">4.商家入驻开通流程</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	1、&nbsp;甲乙双方签署本协议；<br />\r\n2、&nbsp;甲方根据所选择商铺类型，提交相应的证明材料复印件；<br />\r\n3、&nbsp;在乙方pptvzaixian交易平台注册，会员中心点“我要开店”；<br />\r\n4、&nbsp;乙方审核通过后，甲方即可发布商品并展示经营活动。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help5\"></a><strong><span style=\"color:#E56600;\">5.双方权利义务</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<strong>甲方权利义务：<br />\r\n</strong>1、&nbsp;在本协议第一条规定范围内，甲方自行开拓市场与发展业务，不得以欺诈、胁迫等不正当手段损害客户或甲方的利益与声誉；<br />\r\n2、&nbsp;甲方妥善保管商铺管理员账号，如因甲方保管、设置或使用不当造成的经济损失，由甲方自行承担责任；<br />\r\n3、&nbsp;甲方在使用过程中如发现任何非法盗用乙方账号出现安全漏洞等情况，应立即通知乙方；<br />\r\n4、&nbsp;甲方保证其所有经营活动完全符合中国有关法律、法规、行政规章等的规定。如因甲方违反上述规定给乙方带来任何损害，甲方应承担所有法律责任并赔偿由此给甲方造成的损失；<br />\r\n5、&nbsp;在协议有效期内，甲方不得向与乙方构成商业竞争关系的企业、商业机构或者组织提供有关乙方相关信息或者资料，否则对乙方造成损失的，由甲方负责赔偿。<br />\r\n<strong>乙方权利义务：<br />\r\n</strong>1、&nbsp;乙方对甲方提供必要的开店技术咨询，并保证交易系统平台能正常稳定运行；<br />\r\n2、&nbsp;如甲方是托管商铺，乙方应及时为甲方进行店铺更新并实时进行日常管理；<br />\r\n3、&nbsp;在本协议有效期限内，乙方有权根据市场情况对各种商铺入驻条件进行调整。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help6\"></a><strong><span style=\"color:#E56600;\">6.协议期限</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	本协议有效期为一年，自签订之日起生效。有效期满后，双方可视合作情况续约。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help7\"></a><strong><span style=\"color:#E56600;\">7.协议变更、终止及违约责任</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	1、&nbsp;甲乙双方应本着诚实信用的原则履行本协议。任何一方在履约过程中采用欺诈、胁迫或者暴力的手段，另一方均可以解除本协议并要求对方赔偿由此造成的损失；<br />\r\n2、&nbsp;在协议执行期间，如果双方或一方认为需要终止，应提前一个月通知对方，双方在财务结算完毕、各自责任明确履行之后，方可终止协议。某方擅自终止本协议，给对方造成损失的，应赔偿对方损失；<br />\r\n3、&nbsp;经双方协商达成一致，可以对本协议有关条款进行变更，但应当以书面形式确认；<br />\r\n4、&nbsp;一方变更通讯地址或其它联系方式，应自变更之日起十日内，将变更后的地址、联系方式通知另一方，否则变更方应对此造成的一切后果承担责任；<br />\r\n5、&nbsp;如因客观情况发生重大变化，致使本协议无继续法履行的，经甲乙双方协商同意，可以变更或者终止协议的履行。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help8\"></a><strong><span style=\"color:#E56600;\">8.保密条款</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	1、甲、乙双方所提供给对方的一切资料、技术和对项目的策划设计要严格保密，并只能在合作双方的业务范围内使用；<br />\r\n2、甲、乙双方均应对在合作过程中所知悉的对方的商业和技术秘密承担保密义务。保密条款不受本协议期限的限制。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help9\"></a><strong><span style=\"color:#E56600;\">9.争议解决</span></strong>\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	在本协议执行期间如果双方发生争议，双方应友好协商解决。如果协商不成，双方同意提交给仲裁委员会进行仲裁，接受其仲裁规则，并服从该仲裁裁决，仲裁费由败诉方承担。争议的解决适用中华人民共和国法律、法规、条例和计算机行业惯例。\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help10\"></a><strong><span style=\"color:#E56600;\">10.pptv在线网\"引导线下交易\"和“刷小号”规则</span></strong>\r\n</div>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	<strong>适用范围：</strong>\r\n</p>\r\n<p style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	为了维护平台健康有序的市场秩序，制止引导线下交易和刷小号的行为，特制订本规则。\r\n</p>\r\n<p style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	<strong>定义：</strong>\r\n</p>\r\n<p style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	平台所有交易都要求买卖双方使用本站担保服务，但商家以各种方式引导买家使用其它的支付、交易方式进行支付和交易的，属于引导线下交易的行为。\r\n</p>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	同一个人身份证或者用身边人身份证开设注册2个以上的店铺的行为视为刷小号行为，此行为严重占用本站的刷新点、推荐点广告资源。\r\n</p>\r\n<p style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n</p>\r\n<p style=\"color:#333333;background-color:#FFFFFF;font-family:tahoma, sans-serif;\">\r\n	<strong>处罚：</strong>\r\n</p>\r\n<p style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	一经发现，立即封号，收入永久没收。\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('94', '74', '发布条款', '50', '0', '0', '1582277267', '1582277267', '1', '<div class=\"rtit\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	禁售产品及发布规则相关问题\r\n</div>\r\n<ul class=\"ru1\" style=\"color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<li class=\"l1\">\r\n		1.国家禁止买卖交易的产品\r\n	</li>\r\n	<li class=\"l1\">\r\n		2.本交易平台禁售产品\r\n	</li>\r\n	<li class=\"l1\">\r\n		3.商品发布管理条例\r\n	</li>\r\n</ul>\r\n<div class=\"rtit\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	禁售产品及发布规则相关解释\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help1\"></a>1.国家禁止买卖交易的产品\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<h3>\r\n		国家禁止买卖交易的产品\r\n	</h3>\r\n	<table align=\"center\" width=\"720\" cellspacing=\"1\" cellpadding=\"1\" border=\"1\">\r\n		<tbody>\r\n			<tr class=\"firstRow\">\r\n				<td>\r\n					<p style=\"text-align:center;\">\r\n						<strong>禁售条目</strong>\r\n					</p>\r\n				</td>\r\n				<td>\r\n					<p style=\"text-align:center;\">\r\n						<strong>法律相关规定与举例</strong>\r\n					</p>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					文物、文献作品\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国文物保护法》第五十五条规定： 除经批准的文物商店、经营文物拍卖的拍卖企业外，其他单位或者个人不得从事文物的商业经营活动。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					禁止出口的物品\r\n				</td>\r\n				<td>\r\n					根 据《全国人代会常委会关于惩治走私罪的补充规定》第2条走私国家禁止出口的文物、珍贵动物及其制品、黄金、白银或者其他贵重金属的，处5年以上有期徒刑， 并处罚金或者没收财产；情节特别严重的，处无期徒刑或者死刑，并处没收财产；情节较轻的，处5年以下有期徒刑，并处罚金。和＜中国文物保护法（修正本）＞ 第25条 私人收藏的文物，严禁倒卖牟利，严禁私自卖给外国人。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					网民Email地址\r\n				</td>\r\n				<td>\r\n					中国公安部公共信息网络安全监察局表示：买卖E-mail地址属违法行为，依照《中华人民共和国刑法》、计算机信息系统安全保护条例和民法通则，对出售人进行处理。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					无线电台（站）等\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国无线电管理条例》第十一条规定： 设置、使用无线电台（站）的单位和个人，必须提出书面申请，办理设台（站）审批手续，领取电台执照。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					危险化学品\r\n				</td>\r\n				<td>\r\n					根据《危险化学品安全管理条例》第二十七条规定：国家对危险化学品经营销售实行许可制度。未经许可，任何单位和个人都不得经营销售危险化学品。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					音乐影像制品\r\n				</td>\r\n				<td>\r\n					根 据《音像制品管理条例》第三条规定： 音像制品的经营活动应当遵守宪法和有关法律、法规，坚持为人民服务和为社会主义服务的方向，传播有益于经济发展和社会进步的思想、道德、科学技术和文化知 识。禁止经营有下列内容的音像制品：（一）反对宪法确定的基本原则的； （二）危害国家统一、主权和领土完整的； （三）泄露国家秘密、危害国家安全或者损害国家荣誉和利益的； （四）煽动民族仇恨、民族歧视，破坏民族团结，或者侵害民族风俗、习惯的； （五）宣扬邪教、迷信的；（六）扰乱社会秩序，破坏社会稳定的；（七）宣扬淫秽、赌博、暴力或者教唆犯罪的；（八）侮辱或者诽谤他人，侵害他人合法权益 的；（九）危害社会公德或者民族优秀文化传统的；（十）有法律、行政法规和国家规定禁止的其他内容的。<br />\r\n第三十六条规定： 音像制品批发单位和从事音像制品零售、出租等业务的单位或者个人，不得经营非音像出版单位出版的音像制品或者非音像复制单位复制的音像制品，不得经营未经国务院文化行政部门批准进口的音像制品，不得经营侵犯他人著作权的音像制品。<br />\r\n根据《音像制品管理条例》中的第14条 任何单位和个人不得购买、伪造音像出版单位的名称或者版号，不得从事非法音像制品出版活动。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					计算机、软件等相关物品\r\n				</td>\r\n				<td>\r\n					如：无注册号的磁带或光盘等，共享软件。<br />\r\nBeta级或未公布的软件。（未经授权的软件）<br />\r\n未同设备捆绑出售的OEM软件。<br />\r\n解密软件（为破解正版软件密码）<br />\r\n根据《计算机软件保护条例》规定，未经软件著作权人许可，不得向公众发行、出租、通过信息网络传播著作权人的软件，也不得转让或者许可他人行使著作权人的软件著作权。<br />\r\n如：科研用软件——某银行的操作系统、某网络公司的数据库程序、某导弹发射程序。（未经授权的软件）\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					伪造、买卖各类证件、印章\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国刑法》第六章第一节明确规定此类行为构成妨害社会管理秩序罪，处三年以下有期徒刑、拘役、管制或者剥夺政治权利；情节严重的，处三年以上十年以下有期徒刑。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					酒类\r\n				</td>\r\n				<td>\r\n					国酒不能卖，洋酒收藏数量1~3瓶可以卖，大于此数量不能卖。拥有出售酒精饮料的执照者除外。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					烟草专卖品\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国烟草专卖法实施条例》 第六条规定：从事烟草专卖品的生产、批发、零售业务，以及经营烟草专卖品进出口业务和经营外国烟草制品购销业务的，必须依照《烟草专卖法》和本条例的规定，申请领取烟草专卖许可证。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					股票、债券和其它公开发行的证券\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国证券法》　第十条　公开发行证券，必须符合法律、行政法规规定的条件，并依法报经国 务院证券监督管理机构或者国务院授权的部门核准或者审批；未经依法核准或者审 批，任何单位和个人不得向社会公开发行证券。<br />\r\n第三十二条规定： 经依法核准的上市交易的股票、公司债券及其他证券，应当在证券交易所挂牌交易。<br />\r\n如：证券、股票、债券、彩票、流通的认购证。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					集邮票品\r\n				</td>\r\n				<td>\r\n					<p>\r\n						根据《集邮市场管理办法》第二十一条规定： 集邮票品经营者不得从事下列活动：<br />\r\n（一）经营伪造、变造的邮资凭证；<br />\r\n（二）经营国家禁止流通的集邮票品；<br />\r\n（三）经营1949年10月1日以后发行的带有“中华民国”字样的集邮票品；<br />\r\n（四）先于发行日期出售邮资凭证；<br />\r\n（五）经营未经邮政行业管理部门批准制作的集邮品；<br />\r\n（六）走私或经营走私进口的其他国家（地区）发行的邮票及其制品；<br />\r\n（七）其他违反国家有关规定的经营活动。\r\n					</p>\r\n					<p>\r\n						第二十六条<br />\r\n违反本办法规定，经营者有下列行为之一的，由邮政行业管理部门予以警告或者处30000元以下罚款：<br />\r\n（一）先于发行日期出售邮资凭证；<br />\r\n（二）未经邮政行业管理部门批准，擅自制作经营集邮品；<br />\r\n（三）未经批准擅自从事集邮票品进出口业务；<br />\r\n（四）非邮政通信企业未经邮政通信企业委托经营现行通信使用的普通邮票。\r\n					</p>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					枪支、弹药、刀具\r\n				</td>\r\n				<td>\r\n					<p>\r\n						根 据《中华人民共和国枪支管理法》第三条规定：国家严格管制枪支。禁止任何单位或者个人违 反法律规定持有、制造（包括变造、装配）、买卖、运输 、出租、出借枪支。第二十二条规定：禁止制造、销售仿真枪。《中华人民共和国刑法》第一百二十五条规定：非法制造、买卖、运输、邮寄、储存枪支、弹药、爆 炸物的，处三年以上十年以下有期徒刑；情节严重的，处十年以上有期徒刑、无期徒刑或者死刑。非法买卖、运输核材料的，依照前款的规定处罚。\r\n					</p>\r\n					<p>\r\n						《公安部对部分刀具实行管制的暂行规定》第二条规定：<br />\r\n本规定所管制的刀具是：匕首、三棱刀（包括机械加工用的三棱刮刀）、带有自锁装置的弹簧刀（跳刀）以及其它相类似的单刃、双刃、三棱尖刀。<br />\r\n第九条规定：<br />\r\n严禁任何单位和个人非法制造、销售和贩卖匕首、三棱刀、弹簧刀等属于管制范围内的各种刀具。\r\n					</p>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					警用和军用物品、设备\r\n				</td>\r\n				<td>\r\n					《人民警察制式服装及其标志管理规定》第八条规定：严禁任何单位和个人非法生产、穿着和佩带人民警察制式服装及其标志。严禁买卖人民警察制式服装及其标志。<br />\r\n第九条规定：严禁任何单位和个人生产、销售、购买、穿着和佩带与人民警察制式服装及其标志式样、颜色、图案相仿并足以造成混淆的服装和标志。<br />\r\n《中华人民共和国刑法》第二百八十一条　非法生产、买卖人民警察制式服装、车辆号牌等专用标志、警械，情节严重的，处三年以下有期徒刑、拘役或者管制，并处或者单处罚金。<br />\r\n第二百八十三条规定：非法生产、销售窃听、窃照等专用间谍器材的，处三年以下有期徒刑、拘役或者管制。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					野生动物\r\n				</td>\r\n				<td>\r\n					根据《中华人民共和国野生动物保护法》第三十五条规定： 违反本法规定，出售、收购、运输、携带国家或者地方重点保护野生动物或者其产品的，由工商行政管理部门没收实物和违法所得，可以并处罚款。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					钱币\r\n				</td>\r\n				<td>\r\n					《中华人民共和国人民币管理条例》第二十五条规定：禁止非法买卖流通人民币。　第三十一条规定：禁止伪造、变造人民币。禁止出售、购买伪造、变造的人民币。<br />\r\n《中华人民共和国人民币管理条例》第二十五条规定：禁止非法买卖流通人民币。　第三十一条规定：禁止伪造、变造人民币。禁止出售、购买伪造、变造的人民币。<br />\r\n《中华人民共和国外汇管理条例》第七条规定：在中华人民共和国境内，禁止外币流通，并不得以外币计价结算。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					饲料\r\n				</td>\r\n				<td>\r\n					根据《饲料和饲料添加剂管理条例》中15,16,17,18,19条等规定。\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					不提供实质性物品的虚拟服务\r\n				</td>\r\n				<td>\r\n					保险服务及契约\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td>\r\n					其它国家法律、法规禁止出售的物品以及任何与交易宗旨不符的物品\r\n				</td>\r\n				<td>\r\n					涉及新闻、出版、教育、医疗保健、药品和医疗器械信息的<br />\r\n被禁止的著作、文献、资料等<br />\r\n需有国家或政府有关部门授权如：有线电视或碟型人造卫星天线等<br />\r\n人体器官、遗体等<br />\r\n侵犯他人知识产权和其他合法权益的<br />\r\n未经有关部门批准或属于禁止生产、销售及持有的报警器<br />\r\n危险物品，包括但不限于斧头，弓驽，吹箭，有放血槽的刀具，用于人身防卫的电击器<br />\r\n可能对人体造成伤害的喷雾器、喷液器等防身设备、设施、器材<br />\r\n福利彩票、体育彩票和各类彩票<br />\r\n盗版及仿制品<br />\r\n烟花爆竹<br />\r\n助动车（50CC以下或无牌照）<br />\r\n黄色、淫秽物品，色情广告和性服务<br />\r\n反宗教信仰物品<br />\r\n犯罪工具<br />\r\n带有攻击性的种族主义物品<br />\r\n终身免服务费（信息费）的寻呼机（含股票机、数字机、中文机）<br />\r\n赃物，走私品<br />\r\n不属于您的物品<br />\r\n所有以上未列出的凡中国法律、法规或条例严禁交易的物品以及互站网认为不适合在互站网上交易的物品 。\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help2\"></a>2.本交易平台禁售产品\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<p>\r\n		本交易平台服务于广大需要ppt模板的朋友，禁止出售以下产品：（如有发现，删除处理，多次违规不停劝阻者永久停封ID账号处理）\r\n	</p>\r\n	<p>\r\n		1.包含有关网络赌博的ppt；\r\n	</p>\r\n	<p>\r\n		2.包含有关成人影视、成人小说、成人图片等；\r\n	</p>\r\n	<p>\r\n		3.<span style=\"color:#FF0000;\"><strong>盗卖其他商家或者其他作者的ppt模板，一旦发现，立即下线盗版商品并且扣除所有收入，封停帐号</strong></span>；<span style=\"color:#E53333;\"><span style=\"color:#000000;\"><br />\r\n</span></span>\r\n	</p>\r\n	<p>\r\n		<span style=\"color:#E53333;\"><span style=\"color:#000000;\"></span></span>4.禁止注册2个和2个以上的小号同时在本站开店，严重占用广告资源，一经过发现，立即封停所有账号，并且没收所有收入；\r\n	</p>\r\n	<p>\r\n		5.其他与法律法规明文规定相抵触的；\r\n	</p>\r\n	<p>\r\n		其他禁售产品等待进一步完善，如果您有更多的<strong>建议</strong>请<strong>反馈</strong>给我们。\r\n	</p>\r\n</div>\r\n<div class=\"tit1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<a name=\"help3\"></a>3.商品发布管理条例\r\n</div>\r\n<div class=\"txt1\" style=\"margin:0px auto;padding:0px;color:#333333;font-family:tahoma, arial, &quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<p>\r\n		<span style=\"font-family:宋体;\"><strong>1.1 商品发布管理的目的<br />\r\n</strong>为了给所有类目商品提供一个高效、公平和安全的交易环境，同时给买家展示更多更高质量的商品；本站制定本网站商品发布管理条例。对于违反“商品发布管理条 例”的行为，本站将根据用户违规的情节和程度对违规用户做出：撤销所有发布单，限制交易权限甚至冻结用户帐号的处理。如由于用户违规行为导致本网站遭受损失，本网站保留追究该用户法律责任的权利。管理条例具体内容如下：<br />\r\n<strong>1.2 商品重复铺货管理规则<br />\r\n</strong>1、同一卖家不得出售相同商品（即：一个用户名可发布多个商品，但不能一个用户名发布多个重复的商品）。<br />\r\n2、不得使用多个用户名发布相同商品。<br />\r\n如用户违反以上任何一条规则，即可判定为重复铺货，一律进行撤销商品处理，并视情节轻重，施以相关处理。<br />\r\n违规类别：<br />\r\nA、一级违规：<br />\r\n1）、判断依据：用户第一次违反以上任意一条发布规则；<br />\r\n2）、违规类型：重复铺货；<br />\r\n3）、管理措施：给予该用户警告，并撤销其所有发布单。<br />\r\nB、二级违规：<br />\r\n1）、判断依据：用户第二次违反以上任意一条发布规则；<br />\r\n2）、违规类型：重复铺货；<br />\r\n3）、管理措施：锁定该用户的本网站用户名1-3天，并撤销其所有发布单。<br />\r\nC、三级违规：<br />\r\n1）、判断依据：用户第三次违反以上任意一条发布规则；<br />\r\n2）、违规类型：重复铺货；<br />\r\n3）、管理措施：锁定该用户的本网站用户名7天，并撤销其所有发布单。<br />\r\nD、四级违规：<br />\r\n1）、判断依据：用户第四次违反以上任意一条发布规则；<br />\r\n2）、违规类型：重复铺货；<br />\r\n3）、管理措施：锁定该用户的本网站用户名1个月，并撤销其所有发布单。<br />\r\nE、五级违规：<br />\r\n1）、判断依据：用户第五次违反以上任意一条发布规则；<br />\r\n2）、违规类型：重复铺货；<br />\r\n3）、管理措施：锁定该用户的本网站用户名365天，并撤销其所有发布单。<br />\r\n锁定帐号后将不得提现。<br />\r\n<strong>1.3 发布正确的商品类型规则<br />\r\n</strong>1）、发布出售的商品必须发布在相对应的栏目中。<br />\r\n2）、发布出售的商品必须发布在相对应的子类项中，未开通的子类项统一发布至“其它”子类项。<br />\r\n<strong>1.4 发布内容符合规定规则<br />\r\n</strong>所发布的商品标题、图片、描述等信息缺乏或者多种信息相互不一致的情况，本网站不允许发布。其中具体形式包括但不仅限于以下情况：<br />\r\n1）、发布出售的商品种类属性与商品实际属性不一致。<br />\r\n2）、发布商品的定价不符合市场规律或所属行业标准。<br />\r\n3）、发布商品信息中包含诽谤、谩骂、色情、暴力威胁等攻击性言语以及其它非商品信息内容（包含但不仅限于如下情况：在商品标题或描述中私自公布联系方式、他人ID、聊天记录、交易纠纷、使用不文明语言等）。<br />\r\n违反以上任一规则，即可判定为恶意发布，一律进行撤销处理，并视情节轻重，施以相关处理。<br />\r\n违规类别：分成五个等级进行（处理）（违反判断依据中任意一条都判定为违规发布）。<br />\r\nA、一级违规：<br />\r\n1）、判断依据：用户第一次违反以上任意一条发布规则；<br />\r\n2）、违规类型：恶意发布；<br />\r\n3）、管理措施：给予该用户警告，并撤销其所有发布单。<br />\r\nB、二级违规：1）、判断依据：用户第二次违反以上任意一条发布规则；<br />\r\n2）、违规类型：恶意发布；<br />\r\n3）、管理措施：锁定该用户的本网站用户名1-3天，并撤销其所有发布单。<br />\r\nC、三级违规：1）、判断依据：用户第三次违反以上任意一条发布规则；<br />\r\n2）、违规类型：恶意发布；<br />\r\n3）、管理措施：锁定该用户的本网站用户名7天，并撤销其所有发布单。<br />\r\nD、四级违规：1）、判断依据：用户第四次违反以上任意一条发布规则；<br />\r\n2）、违规类型：恶意发布；<br />\r\n3）、管理措施：锁定该用户的本网站用户名一个月，并撤销其所有发布单。<br />\r\nE、五级违规：1）、判断依据：用户第五次违反以上任意一条发布规则；<br />\r\n2）、违规类型：恶意发布；<br />\r\n3）、管理措施：锁定该用户的本网站用户名365天，并撤销其所有发布单。<br />\r\n锁定帐号后将不得提现。<br />\r\n<strong>附录<br />\r\n</strong>1、不得使用任何不正当方式使自身发布单排名靠前。<br />\r\n2、不得影响本网站正常运营秩序。</span>\r\n	</p>\r\n	<p>\r\n		<span style=\"font-family:宋体;\">以上管理条例视情节严重性加重处理，最终解释权归本网站所有。<br />\r\n请各用户自觉遵守，相互监督，谢谢配合！</span>\r\n	</p>\r\n</div>', '0');
INSERT INTO `by_document` VALUES ('95', '74', '正品保障服务规范', '50', '0', '0', '1582277809', '1582277809', '1', '<div class=\"J_rule_node clause clause-1 -end\" id=\"lear672\" style=\"margin:0px;padding:30px 0px 12px 78px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	定义\r\n	<p class=\"inner-break\">\r\n		“正品保障”服务是指天猫商家承诺消费者在天猫平台购买商品，在收到货后若确认该商品非“正品”，则除交易退款外，还需向消费者增加赔偿。\r\n	</p>\r\n	<p class=\"inner-break\">\r\n		“正品”，是指非“假冒（包括盗版）品牌”的商品、非“未经报关”的进口商品、非“假冒材质成份”的商品。其中“假冒（包括盗版）品牌”、 “未经报关”、 “假冒材质成份”的定义以《天猫规则》的规定为准。\r\n	</p>\r\n</div>\r\n<div class=\"J_rule_node clause clause-1\" id=\"lear673\" style=\"margin:0px;padding:0px 0px 12px 78px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\" style=\"font-weight:700;\">第二条</span>服务保障\r\n	<p class=\"inner-break\">\r\n		商家未履行正品保障服务的，需按以下标准向消费者进行赔偿：\r\n	</p>\r\n</div>\r\n<div class=\"J_rule_node entry clause-end\" id=\"lear674\" style=\"margin:-10px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">1、</span>商家需向消费者退还商品的实际成交金额；\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear675\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">2、</span>商家需向消费者支付商品实际成交金额的四倍作为赔偿：该赔付义务将由商家（以商家账户保证金可用余额为限）进行承担。\r\n</div>\r\n<div class=\"J_rule_node clause clause-1 entry-end\" id=\"lear676\" style=\"margin:10px 0px 0px;padding:0px 0px 12px 78px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\" style=\"font-weight:700;\">第三条</span>消费者投诉\r\n</div>\r\n<div class=\"J_rule_node entry clause-end\" id=\"lear677\" style=\"margin:-10px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">1、</span>商家未履行正品保障服务承诺的，可通过“我的淘宝”-“已买到的宝贝”进行投诉，或通过天猫客服渠道（电话：4008608608）进行投诉。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear678\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">2、</span>消费者投诉商品非“正品”的，应向天猫提供有效凭证，该凭证包括但不限于具备相关检测资质的质检机构出具的材质鉴定报告、品牌方出具的假冒（包括盗版）品牌鉴定报告等。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear679\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">3、</span>商家未履行“正品保障”服务且该商品同时符合特殊品类管理规范中的赔付情形的，消费者可选择适用“正品保障”服务赔付或特殊品类管理规范中的赔付办法。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear680\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">4、</span>商家履行“正品保障”赔偿义务后，并不免除商家依照国家有关法律法规依法应当承担的赔偿责任。如国家相关法律法规规定的赔付标准高于平台规则赔付标准的，消费者就赔偿不足部分可通过法律途径继续向商家追偿。\r\n</div>\r\n<div class=\"J_rule_node clause clause-1 entry-end\" id=\"lear681\" style=\"margin:10px 0px 0px;padding:0px 0px 12px 78px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\" style=\"font-weight:700;\">第四条</span>特殊说明\r\n	<p class=\"inner-break\">\r\n		正品保障服务以保障消费者权益为核心，天猫将依靠有限的技术手段和普通人的认知作出判断。为保障交易双方权益，下述情形天猫不支持消费者的四倍赔付申请并无权强制划扣商家保证金，由消费者与商家自行沟通处理，具体如下：\r\n	</p>\r\n</div>\r\n<div class=\"J_rule_node entry clause-end\" id=\"lear682\" style=\"margin:-10px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">1、</span>服务申请方为品牌权利人或疑似为品牌权利人的。\r\n	<p class=\"inner-break\">\r\n		注：品牌权利人的权益维护行为可通过“阿里巴巴知识产权保护平台”发起主张。\r\n	</p>\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear683\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">2、</span>消费者要求商家制假、售假的。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear684\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">3、</span>非以生活消费为目的生成的订单。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear685\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">4、</span>交易标的疑被消费者调换的。\r\n</div>\r\n<div class=\"J_rule_node entry\" id=\"lear686\" style=\"margin:0px 0px 0px 125px;padding:0px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span class=\"type-hader\" id=\"\">5、</span>依据当前证据，天猫难以判断及认定商家未履行“正品保障”承诺的。\r\n</div>', '0');
INSERT INTO `by_document` VALUES ('96', '74', '新增提供虚假凭证规则公示通知', '40', '0', '0', '1582279171', '1582279171', '1', '<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">尊敬的各位平台用户：</span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">为促进平台经营秩序持续健康发展，更好地保障消费者合法权益，我们拟对《天猫市场管理规范》进行部分修订，新增提供虚假凭证规则。</span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">本次规则变更于</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">2020</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">年</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">2</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">月</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">21</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">日进行公示通知，将于</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">2020</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">年</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">2</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">月</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">28</span></span><span style=\"font-family:simsun;font-weight:700;\"><span style=\"color:red;\">日正式生效。</span></span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">本次规则变更核心点如下：</span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">1、新增“提供虚假凭证”处罚类型，范围包含原“提供虚假资质证明”、“虚假交易申诉场景下提供虚假凭证”场景，同时适用其他新的业务场景。</span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">2、原“虚假交易申诉场景下提供虚假凭证”场景的扣分，从扣一般违规6分变更为扣一般违规12分。</span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:simsun;\">具体修订内容如下：</span> \r\n</p>\r\n<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:14px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;background-color:#FFFFFF;border:none;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"border:1pt solid windowtext;background:yellow;vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">原规则</span></span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"background:yellow;vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">现规则</span></span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:top;\">\r\n				<p align=\"left\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">第二十九条</span>&nbsp;<span style=\"font-weight:700;\">提供虚假资质证明</span></span></span> \r\n				</p>\r\n				<p align=\"left\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">【适用情形】提供虚假资质，指商家为达到某种目的或牟取利益向天猫提供不真实的资质证明的行为。</span></span> \r\n				</p>\r\n				<p align=\"left\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">【处理措施】扣分（严重违规）</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">第二十九条 提供虚假凭证</span></span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">【适用情形】提供虚假凭证，指会员违背法律法规或者平台规则等的规定，向天猫提供不真实的证明材料的行为。</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">【处理措施】扣分（严重违规）、扣分（一般违规）、经营权限管控、违规商品或信息处置、关联影响</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"background:yellow;vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">原规则解读</span></span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"background:yellow;vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">现规则解读</span></span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:top;\">\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">【具体处理措施】</span></span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">商家向天猫提供虚假资质证明的，以严重违规行为扣严重违规48分。</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">【规则解读】</span></span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、“不真实”的证明材料如何认定？</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（1）经天猫核实证明材料系伪造、变造的。</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（2）基于对证明材料的合理怀疑，天猫将通知会员进一步对该证明材料的真实性、合法性补充自证或作出合理解释，商家未在天猫规定的合理时间内予以提供证明或作出合理解释的，该证明材料将被认定为“不真实”。</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、虚假资质证明包含哪些？</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">包括但不限于：</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（1）品牌授权书造假（如：公章造假、授权内容造假）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（2）品牌商标注册证造假（如：商标注册号、商标核定范围造假）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（3）一般纳税人资质造假</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（4）特殊行业经营许可证造假（如：食品经营许可证、图书经营许可证）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（5）企业资质造假（如：企业营业资质）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（6）其他入驻资质造假</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（7）其他商品资料</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">一、违规处理</span></span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">情节一般的，每次扣一般违规12分；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">情节严重的，每次扣严重违规48分；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">同时，天猫视情节严重程度可采取删除商品、延长交易账期、监管账户、查封账户等措施 。</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">二、情形</span></span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">情节严重是指提供虚假凭证手段隐蔽、行为及影响面特别恶劣的，包括但不限于：</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（一）招商入驻及经营过程中提供虚假资质证明的，包括但不限于：</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、企业资质造假（如：企业营业资质造假、一般纳税人资质造假）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、品牌资质造假（如：品牌授权书造假、品牌商标注册证造假）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">3、特殊行业经营许可资质造假（如：食品经营许可证造假、图书经营许可证造假）</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">4、其他商品资质造假</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（二）“出售假冒商品”的申诉过程中，提供虚假凭证的；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（三）在“不当使用他人权利”的申诉过程中，提供虚假凭证的；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">注：此处的“不当使用他人权利”投诉仅指来源于能提供国家机关颁发的知识产权证明的权利人发起的投诉。“知识产权证明”包括但不限于：商标权证明、著作权证明、专利权证明等。</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（四）提供虚假凭证致使大量消费者受到损失或者引发相关风险的；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（五）提供虚假凭证致使出现大面积或重大负面监管风险、舆情事件的；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（六）提供虚假凭证致使平台受到重大损失或者引发相关风险的。</span></span> \r\n				</p>\r\n				<p>\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">三、常见问题</span></span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（一）“不真实”的证明材料的认定方式：</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、经天猫核实证明材料系伪造、变造的；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、通过购买证明材料作出虚假证明的，如购买发票虚假证明进货事实；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">3、基于对证明材料的合理怀疑，天猫将通知会员进一步对该证明材料的准确性、真实性、合法性补充自证或作出合理解释，会员未在天猫规定的合理时间内予以提供证明或作出合理解释的，该证明材料将被认定为“不真实”。</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">（二）会员向天猫提供的证明材料包括但不限于：</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、入驻需要提供的资质证明，例如品牌授权书、品牌商标注册证、特殊行业经营许可证、一般纳税人资质等；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、物流凭证；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">3、进货凭证；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">4、鉴定证明；</span></span> \r\n				</p>\r\n				<p style=\"text-indent:21pt;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">5、其他依照法律法规或者平台要求等需要提交的各类证明材料。</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;text-indent:21pt;\">\r\n	<span style=\"font-family:simsun;\"><span><span style=\"color:black;\">特此通知，敬请知悉，感谢您对天猫的支持与关注！</span></span></span> \r\n</p>\r\n<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;text-indent:21pt;\">\r\n	&nbsp;\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('97', '74', '发布广告信息的规则变更通知', '40', '0', '0', '1582279160', '1582279160', '1', '<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	<span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">各位亲爱的商家：</span> \r\n</p>\r\n<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;text-indent:21pt;\">\r\n	<span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">为了规范天猫平台的市场管理秩序，为消费者营造安全安心的网购环境，提升消费者的购买信心和满意度，天猫将依据国家相关法律法规，对《</span>滥发信息的规则及实施细则<span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\"><span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\"><span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">》</span><span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">规则及解读的相关条款进行变更。</span></span></span> \r\n</p>\r\n<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	<span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\"><span style=\"line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\"><span style=\"color:red;line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">此次规则变更于2020年</span><span style=\"color:#FF0000;line-height:inherit;font-style:inherit;font-weight:inherit;vertical-align:baseline;\">2月20日进行公示通知，将于2020年2月27日正式生效。</span></span></span> \r\n</p>\r\n<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"font-size:14px;color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;background-color:#FFFFFF;width:887px;border:none;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"border:1pt solid windowtext;background:yellow;vertical-align:bottom;\">\r\n				<p>\r\n					<span style=\"color:black;\"><span style=\"font-family:&quot;\">变更前</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"background:yellow;vertical-align:bottom;\">\r\n				<p>\r\n					<span style=\"color:black;\"><span style=\"font-family:&quot;\">变更后</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:bottom;\">\r\n				<p>\r\n					<span style=\"color:black;\"><span style=\"font-family:&quot;\">（一）发布广告信息</span></span><br />\r\n<span style=\"color:black;\"><span style=\"font-family:&quot;\">发布以下任一商品或信息的，删除该信息，在商品类页面发布的</span></span><span style=\"color:black;\">,&nbsp;</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">每件扣一般违规行为</span></span><span style=\"color:black;\">1</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分（但三天内累计扣分不超过</span></span><span style=\"color:black;\">7</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分）；若在店铺装修区等其他页面发布的，每次扣一般违规行为</span></span><span style=\"color:black;\">4</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分：</span></span><br />\r\n<span style=\"color:black;\">1</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、发布心情故事、店铺介绍、淘宝客链接等非实际交易信息；</span></span><br />\r\n<span style=\"color:black;\">2</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、发布非天猫购物链接、非阿里旺旺联系方式、实体店信息、银行账号及个人支付宝账户等信息，特殊情形除外；</span></span><br />\r\n<span style=\"color:black;\">3</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、在淘宝分销平台外发布批发、代理、招商类商品；</span></span><br />\r\n<span style=\"color:black;\">4</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、利用阿里旺旺等群发重复的或未经请求的淘宝商家店铺消息、产品或服务消息等广告消息；</span></span><br />\r\n<span style=\"color:black;\">5</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、在商品标题、商品详情、店铺、阿里旺旺等中使用导购、团购、促销类网站的名称、</span></span><span style=\"color:black;\">LOGO</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">等信息。</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:bottom;\">\r\n				<p>\r\n					<span style=\"color:black;\"><span style=\"font-family:&quot;\">（一）发布广告信息</span></span><br />\r\n<span style=\"color:black;\"><span style=\"font-family:&quot;\">发布以下任一商品或信息的，删除该信息，在商品类页面发布的</span></span><span style=\"color:black;\">,&nbsp;</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">每件扣一般违规行为</span></span><span style=\"color:black;\">1</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分（但三天内累计扣分不超过</span></span><span style=\"color:black;\">7</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分）；若在店铺装修区等其他页面发布的，每次扣一般违规行为</span></span><span style=\"color:black;\">4</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">分：</span></span><br />\r\n<span style=\"color:black;\">1</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、发布心情故事、店铺介绍、淘宝客链接等非实际交易信息；</span></span><br />\r\n<span style=\"color:black;\">2</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、发布非天猫购物链接、非阿里旺旺联系方式、实体店信息、银行账号及个人支付宝账户等信息，特殊情形除外；</span></span><br />\r\n<span style=\"color:red;\">3</span><span style=\"color:red;\"><span style=\"font-family:&quot;\">、使用代表党和国家形象的元素进行宣传的商品或信息；</span></span><br />\r\n<span style=\"color:red;\">4</span><span style=\"color:red;\"><span style=\"font-family:&quot;\">、利用国家重大活动、纪念日、国家机关及其工作人员名义等进行宣传的商品或信息；</span></span><br />\r\n<span style=\"color:black;\">5</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、在淘宝分销平台外发布批发、代理、招商类商品；</span></span><br />\r\n<span style=\"color:black;\">6</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、利用阿里旺旺等群发重复的或未经请求的淘宝商家店铺消息、产品或服务消息等广告消息；</span></span><br />\r\n<span style=\"color:black;\">7</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">、在商品标题、商品详情、店铺、阿里旺旺等中使用导购、团购、促销类网站的名称、</span></span><span style=\"color:black;\">LOGO</span><span style=\"color:black;\"><span style=\"font-family:&quot;\">等。</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>', '0');
INSERT INTO `by_document` VALUES ('98', '74', '2020年春节商家物流变更通知', '40', '0', '0', '1582279096', '1582279096', '1', '<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">各位亲爱的商家：</span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;text-indent:28pt;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#333333;\">新冠肺炎疫情仍在发展，为持续给予疫情期间仍在为消费者提供优质发货服务的商家以支持，天猫拟进一步升级对积极发货的商家及订单的激励政策。</span></span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;text-indent:28pt;\">\r\n	<span style=\"color:#FF0000;\"><span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"font-weight:700;\">本次变更于2020年2月9日进行公示，即时生效。</span></span></span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#333333;\">主要变更点：</span></span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#333333;\">1</span><span style=\"color:#333333;\">、激励力度加大：</span>自<span style=\"color:#111F2C;\">2020年2月</span><span style=\"color:#111F2C;\">10</span><span style=\"color:#111F2C;\">日</span><span style=\"color:#111F2C;\">00:00:00</span><span style=\"color:#111F2C;\">起完成发货并有揽收记录的订单，符合激励要求的，将获得</span><span style=\"color:#111F2C;\">3</span><span style=\"color:#111F2C;\">元激励金额（</span>激励金额将按照1:1:1的分配比例以阿里妈妈满折券发放到受激励商家的直通车、超级推荐、钻石展位账户内）。</span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、新增激励政策：<span style=\"color:#111F2C;\">商家发货立即收款！&nbsp;2020</span>年3月31日之前可免服务费享受提前收款服务；（路径：卖家中心-提前收款/支付宝-我的-网商贷-提前收款，填写收款金额后选择“抗疫情-提前收款0费用”活动优惠）</span></span> \r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	&nbsp;\r\n</p>\r\n<p style=\"background-color:#FFFFFF;text-align:justify;font-size:medium;font-family:Cambria;\">\r\n	<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">详细变更点：</span></span> \r\n</p>\r\n<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:14px;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;background-color:#FFFFFF;color:#000000;border:none;\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"border:1pt solid windowtext;vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">变更前</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p align=\"center\" style=\"text-align:center;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">变更后</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:top;\">\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#353535;\">一、激励要求</span></span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#353535;\">1</span><span style=\"color:#353535;\">、发货时间要求：</span></span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#0F1721;\">1)</span><span style=\"color:#0F1721;\">订单付款时间在2020年1月20</span>日至2020年2月2日(年初九)期间的订单，于2月9日（年十六）23：59：59前完成发货并有揽收记录；</span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#0F1721;\">2)</span><span style=\"color:#0F1721;\">订单付款时间在2020年2月3</span>日(年初十)至2020年2月14日(年二十一)期间的订单，于订单付款后的72小时内完成发货并有揽收记录。</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#353535;\">一、激励要求</span></span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#353535;\">1</span><span style=\"color:#353535;\">、发货时间要求：</span></span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#0F1721;\">1)</span><span style=\"color:#0F1721;\">订单付款时间在2020年1月20</span>日至<span style=\"color:red;\">2020</span><span style=\"color:red;\">年2月6日</span><span style=\"color:#0F1721;\">(</span><span style=\"color:#0F1721;\">年十三)期间的订单，于</span><span style=\"color:red;\">2</span><span style=\"color:red;\">月11日（年十八）23：59</span>：59前完成发货并有揽收记录；</span></span> \r\n				</p>\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#0F1721;\">2)</span><span style=\"color:#0F1721;\">订单付款时间在</span><span style=\"color:red;\">2020</span><span style=\"color:red;\">年2月7日</span>(年十四)<span style=\"color:#0F1721;\">至2020年2月14</span>日(年二十一)期间的订单，于订单付款后的72小时内完成发货并有揽收记录。</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:top;\">\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">二、具体激励政策&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">商家订单符合前述激励要求的，经天猫评估确认后，每一笔真实妥投并符合激励要求的订单商家将获得阿里妈妈满折券的激励，每个订单编号最多仅可获得1</span>次激励。详细激励规则如下：</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">1</span><span style=\"color:#111F2C;\">、于2020</span>年2月5日23:59:59前完成发货并有揽收记录的订单，符合激励要求的，将获得1元激励金额。</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">2</span><span style=\"color:#111F2C;\">、于2020</span>年2月6日00:00:00起完成发货并有揽收记录的订单，符合激励要求的，将获得2.5元激励金额。</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">二、具体激励政策&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">1</span><span style=\"color:#111F2C;\">、商家订单符合前述激励要求的，经天猫评估确认后，每一笔真实妥投并符合激励要求的订单商家将获得阿里妈妈满折券的激励，每个订单编号最多仅可获得1</span>次激励。详细激励规则如下：</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">1</span><span style=\"color:#111F2C;\">）</span><span style=\"color:#111F2C;\">、于2020</span>年2月5日23:59:59前完成发货并有揽收记录的订单，符合激励要求的，将获得1元激励金额。</span></span> \r\n				</p>\r\n				<p style=\"font-size:10pt;font-family:宋体;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\"><span style=\"color:#111F2C;\">2</span><span style=\"color:#111F2C;\">）</span><span style=\"color:#111F2C;\">、于2020年2</span>月6日00:00:00起完成发货并有揽收记录的订单，符合激励要求的，将获得2.5元激励金额。</span></span> \r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-weight:700;\"><span style=\"color:#FF0000;\"><span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">3）、自2020年2月10日00:00:00起完成发货并有揽收记录的订单，符合激励要求的，将获得3元激励金额。</span></span></span></span> \r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					&nbsp;\r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-weight:700;\"><span style=\"color:#FF0000;\"><span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">2、享受免费“提前收款”服务</span></span></span></span> \r\n				</p>\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-weight:700;\"><span style=\"color:#FF0000;\"><span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">自2020年2月10日起，天猫商家经申请并成功开通后即可免费使用“提前收款”服务至2020年3月31日。网商银行在确认已发货订单实际存在且无套现、欺诈、洗钱等风险后，商家将收到部分交易订单的交易款项，实现发货后即收款</span></span><span style=\"font-family:simsun;font-size:14px;\">（路径：卖家中心-提前收款/支付宝-我的-网商贷-提前收款，填写收款金额后选择“抗疫情-提前收款0费用”活动优惠）</span></span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align:top;\">\r\n				<p align=\"left\" style=\"font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、激励金额将按照40%:40%:20%的分配比例以阿里妈妈满折券发放到受激励商家的直通车、超级推荐、钻石展位账户内，该满折券仅可用于天猫商家在其开通的天猫直通车、超级推荐、钻石展位产品上抵扣推广消耗使用，抵扣比例为消耗金额的99%，例如：商家在直通车消耗100元，可用满折券抵扣99元，商家实际花费1元。该满折券不能跨营销产品使用；</span></span> \r\n				</p>\r\n			</td>\r\n			<td style=\"vertical-align:top;\">\r\n				<p style=\"text-align:justify;font-size:12pt;font-family:Cambria;\">\r\n					<span style=\"font-size:14px;\"><span style=\"font-family:simsun;\">1、<span style=\"color:red;\">激励金额将按照1:1:1的分配方式</span>以阿里妈妈满折券发放到受激励商家的直通车、超级推荐、钻石展位账户内，该满折券仅可用于天猫商家在其开通的天猫直通车、超级推荐、钻石展位产品上抵扣推广消耗使用，抵扣比例为消耗金额的99%，例如：商家在直通车消耗100元，可用满折券抵扣99元，商家实际花费1元。该满折券不能跨营销产品使用；</span></span> \r\n				</p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>', '0');
INSERT INTO `by_document` VALUES ('99', '74', '2020年春节放假通知', '40', '0', '0', '1582279399', '1582279399', '1', '<p style=\"color:#404040;font-family:Tahoma, Helvetica, Arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;\">\r\n	<span><span style=\"color:black;\"><span style=\"font-family:微软雅黑, sans-serif;\"> </span></span></span>\r\n</p>\r\n<p style=\"font-family:微软雅黑, &quot;\">\r\n	<strong>尊敬的用户：</strong><br />\r\n<br />\r\n	<p style=\"font-size:16px;font-family:&quot;\">\r\n		　2020年春节假期即将来临，公司近期将开始年底收尾工作，进行盘点结算等相关事宜，现将此期间平台相关工作安排事宜公告如下：\r\n	</p>\r\n	<p style=\"font-size:16px;font-family:&quot;\">\r\n		　　自2020年1月24日至2020年2月25日，将暂停商家货款提现服务，其他功能照常进行。自2020年2月26日（正月初十）起，商城恢复正常运营，商家提现申请处理时间顺延。\r\n	</p>\r\n	<p style=\"font-size:16px;font-family:&quot;\">\r\n		　　春节假日期间，公司将不安排技术支持等相关事宜（紧急处理电话：400-178-0098）。请广大用户和商家朋友根据公司安排及各大物流快递公司放假情况，提前做好您的下单和接单规划，以免影响您的收货或收款，由此给您带来的不便，敬请谅解！\r\n	</p>\r\n	<p style=\"font-size:16px;font-family:&quot;\">\r\n		　　在这里蛮划算全体员工提前给大家拜年啦，祝大家在新的一年里，心想事成、身体健康、万事如意！\r\n	</p>\r\n</p>\r\n<p style=\"font-family:微软雅黑, &quot;\">\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('100', '74', '平台争议处理规则', '50', '0', '0', '1582279622', '1582279622', '1', '<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	<span style=\"font-style:inherit;font-weight:inherit;font-size:inherit;line-height:inherit;font-family:simsun;vertical-align:baseline;\"><span style=\"font-style:inherit;font-weight:700;font-size:inherit;line-height:inherit;font-family:inherit;vertical-align:baseline;\">第一章 总则<br />\r\n<br />\r\n第一节 概述<br />\r\n<br />\r\n第一条 买卖双方在xx平台交易发生争议，适用本规则。<br />\r\n<br />\r\n第二条 买家向卖家发起维权或任一方向xx投诉的，xx将根据本规则进行处理，xx平台其他规则有特别规定的，优先根据特别规定处理。当卖家店铺因自身系统、管理、人力、仓储等原因出现异常大量维权或舆情事件，且卖家不具备及时处理能力的，为保障买卖双方交易安全，xx可主动介入处理。部分买卖双方的争议，买家有权选择或xx视争议内容交由大众评审进行判断，xx将根据大众评审的判断结果对该等争议作出处理。<br />\r\n<br />\r\n第三条 xx通过xx平台系统、阿里旺旺、电子邮件、短信或电话等方式向买卖双方发送的与争议处理相关的提示或通知，构成争议处理依据及结论的有效组成部分。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第二章 争议受理<br />\r\n<br />\r\n第一节 受理期限<br />\r\n<br />\r\n第四条 买家应在xx规定的时限内在线发起维权。&nbsp;&nbsp;<br />\r\n<br />\r\n第五条 以下几种情形不受受理期限限制：<br />\r\n<br />\r\n（一）行政机关认定为假冒或违禁商品；<br />\r\n<br />\r\n（二）买家提供司法机关出具的生效法律文书；<br />\r\n<br />\r\n（三）买家未在xx规定的时限内在线发起维权，但能够提供凭证证实商品存在品质等相关问题；<br />\r\n<br />\r\n（四）卖家承诺或双方另行约定售后服务期限。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第二节 受理范围<br />\r\n<br />\r\n第六条 xx受理买卖双方在xx平台上产生的交易争议处理申请，但出现以下情形的，xx可不予受理，买卖任一方有权自行通过司法机关等途径向相对方主张权利：<br />\r\n<br />\r\n（一）买家未在本规则规定的受理期限内发起维权；<br />\r\n<br />\r\n（二）交易订单显示的商品或服务与买卖双方约定的实际交易商品或服务不一致，导致交易事实无法查清；<br />\r\n<br />\r\n（三）买卖双方经自行协商达成退款或退货退款协议并履行完毕，一方或双方反悔产生争议；<br />\r\n<br />\r\n（四）买卖双方进行虚假交易或利用信用卡、花呗等实施套现且交易成功；<br />\r\n<br />\r\n（五）交易做退款处理后，因卖家需要取回商品产生争议；<br />\r\n<br />\r\n（六）除xx平台规则规定的情形外，买家主张交易引发的额外损失或法定赔偿事宜。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第三章 争议处理<br />\r\n<br />\r\n第一节 通用规则<br />\r\n<br />\r\n第七条 买卖双方就交易商品或服务有约定的，优先从约定；未约定或约定不明的，双方可协议补充；无法达成补充协议的，xx将按照本规则进行处理，本规则有特别规定的优先从特别规定。若仍无法确定争议责任归属的，xx将按照交易习惯处理或支持退货退款。支持退货退款的，发货运费由卖家承担，退货运费由买家承担。<br />\r\n<br />\r\n第八条 争议过程中，买卖双方应按本规则规定进行举证。本规则未有规定或xx发现双方的交易或一方账号异常的，xx将视双方实际情形作出举证责任分配。<br />\r\n<br />\r\n第九条 买卖双方应自行对证据的真实性、关联性、完整性、准确性和及时性负责，xx将基于普通人的认知，根据该等证据作出纠纷责任的归属认定及纠纷调处的结论。&nbsp;<br />\r\n<br />\r\n第十条 卖家将发货商品交付承运人后买家签收前，商品风险由卖家承担。<br />\r\n<br />\r\n第十一条 除特殊规定外，交易做退货退款处理的，或卖家同意退货协议但无确切证据证明卖家有责的，买家将退货商品交付承运人后，商品的破损风险由卖家承担；商品的损毁、灭失风险由买家承担，买家有权向承运人求偿。<br />\r\n<br />\r\n卖家在同意退货协议时附有合理条件的，买家退货应符合该条件。<br />\r\n<br />\r\n第十二条 卖家应对出售临近保质期的食品事先予以显著明示或征得买家同意，未显著明示或征得买家同意的，买家有权拒签或要求退货。<br />\r\n<br />\r\n买家将退货商品交付承运人后，若商品损毁或灭失时已过期，风险仍由卖家承担。<br />\r\n<br />\r\n第十三条 买卖双方达成补充协议但一方否认的，主张协议无效的一方应提供有效证据予以证明，否则应承担相关不利后果。<br />\r\n<br />\r\n第十四条 卖家表述的对买家有重大利害关系的格式条款内容应显著，且不得低于xx平台规则要求，同时不存在免除卖家自身应承担的责任、加重买家责任、排除买家主要权利等内容，否则该条款无效。<br />\r\n<br />\r\n第十五条 定金类交易，适用定金罚则。&nbsp;&nbsp;<br />\r\n<br />\r\n第十六条 卖家就特定的违约行为向买家承诺赔付违约金的，当卖家发生该违约行为，应向买家赔付。若该违约行为的违约金数额与xx平台规则规定的数额不一致，则采取就高原则。&nbsp;&nbsp;<br />\r\n<br />\r\n第十七条 xx应买卖双方需求及查明事实需要，必要时将向第三方核实争议问题，并据此作为交易调处的参考依据。<br />\r\n<br />\r\n第十八条 买卖双方进行虚假交易或利用信用卡、花呗等实施套现的，在交易未成功前，做退款处理。<br />\r\n<br />\r\n第十九条 卖家交付买家的商品存在大量严重劣质、大量货不对板情形的，经xx综合判断，有理由认为卖家无履行合同之意图的，视为卖家拒绝履约，交易支持退款。<br />\r\n<br />\r\n第二十条 卖家出售的商品被新闻媒体曝光、国家质监部门等行政管理部门通报，或经阿里平台抽检或排查确认系描述不当、质量不合格应召回的，卖家需主动并及时发起召回，交易支持退货退款。卖家对商品批次提出异议的，应提供相关证据予以证明。<br />\r\n<br />\r\n第二十一条 买家退货前若商品性质已不适宜退货，则作退款处理。&nbsp;&nbsp;<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第二节 发货规范<br />\r\n<br />\r\n第二十二条 本规则所称的“发货”，具体按如下情形认定：&nbsp;<br />\r\n<br />\r\n（一）承运人官网系统内有记录时间的，以该时间为准；<br />\r\n<br />\r\n（二）尚不具有系统记录条件的承运人，按其提供承运面单上填写的日期和卖家“点击发货”的日期相较，取晚者。<br />\r\n<br />\r\n第二十三条 卖家对每个独立生成并付款的交易订单（非购物车合并付款的订单）应予单独发货，除特殊情形外，若未征得买家同意，不得合并成一个包裹发货。否则，买家签收后主张商品少件的，由卖家负举证责任。&nbsp;&nbsp;<br />\r\n<br />\r\n第二十四条 卖家超过约定的发货时间或买家申请退款时尚未发货的，卖家应在征得买家同意后再发货。<br />\r\n<br />\r\n第二十五条 卖家应将商品送达至买家订单收货地址并交由收件人本人签收，需买家至指定地点提取的，应事先予以显著明示或征得买家同意。<br />\r\n<br />\r\n第二十六条 卖家承诺或买卖双方约定采用特定的承运人运送商品的，卖家应按照承诺或约定履行。否则，非包邮订单且买家已签收商品的，可要求卖家退还买家已支付的运费。&nbsp;&nbsp;<br />\r\n<br />\r\n第二十七条 卖家使用运费到付方式发货的，应事先明确承运人和运费事宜，并征得买家同意。买家要求卖家采取到付方式发货的，应自行和卖家明确承运人及运费事宜。&nbsp;<br />\r\n<br />\r\n第二十八条 卖家违反发货规范导致买家未收到商品或拒收商品的，由此产生的相关费用及商品损毁或灭失风险，由卖家自行承担，交易作退款处理。<br />\r\n<br />\r\n第二十九条 卖家违反“发货规范”，支持买家退货退款。<br />\r\n<br />\r\n第三十条 卖家违反“发货规范”但买家已实际使用商品或点击“确认收货”的，买家以卖家违反发货规范为由而主张退货退款的，应和卖家协商一致，否则xx将不予支持。因卖家的不正当行为诱使买家确认收货的情形除外。&nbsp;&nbsp;<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第三节 签收规范<br />\r\n<br />\r\n第三十一条 买家需确保订单中填写的收件信息真实、详细、准确、有效。买家提供的收件信息错误导致未收到商品的，由买家承担该责任限度内的不利后果。&nbsp;<br />\r\n<br />\r\n第三十二条 买家需变更收件信息中任一要素的，应征得卖家同意。卖家同意后实际未变更成功，商品仍按变更前的收件信息被签收，买家主张未收到商品的，经xx判断若变更前和变更后的收件信息和买家无显著关联的，交易支持退款买家，由卖家承担商品相应风险。&nbsp;&nbsp;<br />\r\n<br />\r\n第三十三条 卖家发货或买家退货后，收件人应亲自签收商品。收件人委托他人签收商品或承运人已按收件人的指示将商品置于指定地点的，视为收件人本人签收。<br />\r\n<br />\r\n第三十四条 收件人应在承运人交付商品时，当场检视商品表面是否一致。若发现商品表面不一致，可予以拍照并拒签，若系卖家发货则支持退款买家；若系买家原因退货，则支持打款商家，商品相关风险由相对方承担。<br />\r\n<br />\r\n第三十五条 买家主张未收到商品或卖家主张未收到买家退货的，由相对方承担举证责任，举证无效的，支持退款买家或打款卖家。<br />\r\n<br />\r\n第三十六条 买家无正当理由拒绝签收不支持七天无理由退货且性质不适宜拒签的商品，商品返回后卖家予以拒签的，交易支持打款卖家，由买家负责召回商品并承担商品毁损、灭失的风险。若卖家已签收商品，卖家可选择退款或将商品再次发回买家，发回后商品的破损风险由买家承担，若商品性质已不适宜发回的，则交易支持打款卖家。卖家发回商品的运费由买家承担。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第四节 退货、换货规范<br />\r\n<br />\r\n第三十七条 卖家应对自行填写的默认退货地址确保正确，交易达成退货协议后，若需要指定退货地址或多地址退货的，应征得买家同意。否则，买家可选择按xx平台系统给出的退货地址进行退货，退货后商品无法送达的风险由卖家承担，交易支持退款买家。<br />\r\n<br />\r\n第三十八条 除代购交易和境外交易（包括官方物流及直邮海外）外，卖家提供的退货地址未经买家同意不得为中国大陆以外地区，同时需和商品页面中“运费”或“配送”版块显示的发货地一致。&nbsp;&nbsp;<br />\r\n<br />\r\n第三十九条 买卖双方线下达成退货协议的，买家应在系统规定的退货时间内进行退货。买家因超时未退货，对同一问题或维权原因再次主张要求退货的，应自行和卖家协商一致，否则，xx有权不予处理。<br />\r\n<br />\r\n第四十条 买家退货时应采用与卖家发货时相同类型的承运人进行退货。<br />\r\n<br />\r\n第四十一条 买家根据本规则退货后，应及时在xx平台系统内填写承运单号或告知卖家，若卖家签收商品时买家仍未获知该承运单号，卖家主张表面不一致情形的，将由xx根据实际情况分配举证责任。&nbsp;&nbsp;<br />\r\n<br />\r\n第四十二条 买家使用到付方式退货或卖家要求买家使用到付方式退货的，应事先征得对方同意，并自行和对方明确承运人和运费事宜。买家申请七天无理由退、换货的，根据xx公示的七天无理由退、换货相关规则执行。&nbsp;&nbsp;<br />\r\n<br />\r\n第四十三条 卖家违反“退货、换货规范”致使买家无法完成退换货或商品已不适宜退货，交易支持退款。<br />\r\n<br />\r\n第四十四条 买家违反“退货、换货规范”致使卖家未收到退货或拒签的，交易支持打款，由买家承担商品损毁或灭失的风险。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第五节 运费规范<br />\r\n<br />\r\n第四十五条 买卖双方在xx介入前自行达成退换货或维修协议但未就运费事宜进行说明或约定的，则由卖家承担运费。xx介入后，买卖双方的运费争议将根据“谁过错、谁承担”的原则处理；双方各有过错的，由先有过错的一方承担。<br />\r\n<br />\r\n第四十六条 卖家未经买家同意采取到付方式发货的，买家可选择拒签或签收后要求卖家承担到付产生的运费。<br />\r\n<br />\r\n第四十七条 买家未经卖家同意采取到付方式退货且卖家予以签收商品的，若退货运费本由买家承担的，则该到付产生的运费由买家承担。<br />\r\n<br />\r\n第四十八条 交易由买家承担退货运费时，若卖家提供的退货地址和商品页面中“运费”或“配送”版块显示的发货地不一致，导致买家退货的运费高于按该发货地进行退货的运费，其差额由卖家承担。&nbsp;&nbsp;<br />\r\n<br />\r\n第四十九条 支持七天无理由退货的商品，买家七天无理由退货或无理由拒签的：<br />\r\n<br />\r\n若为非包邮商品，或买家部分退货致使无法满足包邮条件的，所有运费均由买家承担；<br />\r\n<br />\r\n若为包邮商品，买家仅承担退回运费，买家滥用会员权利的，所有运费均由买家承担。&nbsp;<br />\r\n<br />\r\n第五十条 支持七天无理由换货的商品，买家七天无理由换货的，由买家承担换货所产生的所有运费。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第六节 质量问题、假冒商品情形举证责任分配及争议处理<br />\r\n<br />\r\n第五十一条 买家主张商品存在质量问题系肉眼可识别的，应提供初步凭证予以证明。<br />\r\n<br />\r\n买家未提供初步凭证的，交易支持打款。<br />\r\n<br />\r\n买家已提供凭证且xx初步认定的，卖家应针对买家给出的初步凭证作出xx认可的合理解释或提供证据证明不存在质量问题。卖家已提供有效凭证的，买家应按xx要求及时提供有效的质检凭证或其他有效凭证。买家无法提供的，交易支持打款；卖家未提供的，xx将认定质量问题属实。<br />\r\n<br />\r\n第五十二条 买家主张商品存在质量问题系肉眼不可识别的或系假冒商品的，卖家应按照xx的要求，提供厂家的经销凭证、报关单据（进口商品）、产品合格证、商业发票、执行标准等相关凭证以证明商品来源或出厂合规。<br />\r\n<br />\r\n卖家无法提供的，交易支持退货退款。<br />\r\n<br />\r\n卖家已提供有效凭证的，买家应按xx要求及时提供有效的质检凭证或其他有效凭证。买家无法提供的，交易支持打款；买家提供相应凭证的，xx将认定商品质量问题或假冒属实。<br />\r\n<br />\r\n第五十三条 xx认定卖家出售的商品质量问题属实的，卖家应按照法律规定或xx平台相关规则承担退货、更换、维修等义务。若无相关规定，交易支持退货退款。<br />\r\n<br />\r\n第五十四条 商品因质量问题致使买家合同目的不能实现的，买家将退货商品交付承运人后，商品破损、损毁、灭失的风险由卖家承担，交易支持退款。<br />\r\n<br />\r\n第五十五条 卖家出售假冒商品，买家基于生活消费所需购买的，交易支持退款。<br />\r\n<br />\r\n第五十六条 商品存在一定瑕疵但尚未影响买家合同目的实现的，买家将退货商品交付承运人后，商品破损的风险由卖家承担，交易支持退款；若商品出现损毁、灭失情形的，交易支持打款，买家有权向承运人求偿。&nbsp;<br />\r\n<br />\r\n第五十七条 应xx要求，商品经买家送检后证实为质量问题的，检测费用由卖家承担，若被检商品因检测而被物理破坏导致无法退货或无退货价值的，交易支持退款。<br />\r\n<br />\r\n第五十八条 非应xx要求，买家仍将商品送检的，检测费用由双方自行协商处理。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第七节 描述不当、表面不一致情形举证责任分配及争议处置<br />\r\n<br />\r\n第五十九条 买家主张商品存在描述不当系肉眼可识别的，应当提供初步凭证予以证明，xx有权根据买家提供的凭证初步认定存在描述不当，卖家应对买家提供的凭证作出xx认可的合理解释或提供证据证明不存在描述不当，否则xx将认定描述不当属实。<br />\r\n<br />\r\n第六十条 买家主张商品描述不当系肉眼不可识别的，xx将参照本规则“商品质量问题”条款进行举证责任分配。<br />\r\n<br />\r\n第六十一条 买家主张商品存在表面不一致的，卖家应就收件人已按本规则“签收规范”之规定签收商品承担举证责任；卖家举证有效的，则由买家举证证明商品签收时即存在表面不一致情形。<br />\r\n<br />\r\n第六十二条 买家主张商品存在表面不一致但已点击“确认收货”的，买家对主张商品存在表面不一致情形负举证责任。因卖家的不正当行为诱使买家确认收货的情形除外。<br />\r\n<br />\r\n第六十三条 商品的描述不当系无需使用，肉眼即可显著识别的，若商品完好，交易支持退货退款；若买家已经使用且影响商品完好的，交易支持打款。<br />\r\n<br />\r\n第六十四条 卖家对商品或服务的描述存在违反广告法情形，或买家需使用商品后方能察觉该商品描述不当的，交易支持退货退款。若描述不当导致买家无法使用商品核心功能或完全无法使用商品的，买家将退货商品交付承运人后，商品的破损、损毁、灭失风险由卖家承担。<br />\r\n<br />\r\n第六十五条 买家已证明商品签收时存在表面不一致的，买家可视商品性质及损失大小合理选择要求卖家承担补寄、换货、退货等违约责任。卖家拒绝承担该等违约责任的，交易支持退货退款。<br />\r\n<br />\r\n第六十六条 卖家已证明买家签收商品时不存在表面不一致的，交易支持打款。<br />\r\n<br />\r\n第六十七条 商品因签收时存在破损，致使交易作退货退款处理的，买家将退货商品交付承运人后产生的商品损毁、灭失风险由卖家承担，交易支持退款。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第四章 撤销和中止<br />\r\n<br />\r\n第六十八条 xx处理争议期间，出现以下任一情形的，xx将中止争议处理程序：<br />\r\n<br />\r\n（一）买卖双方一致要求中止，并约定期限自行协商处理争议；<br />\r\n<br />\r\n（二）任何一方通知xx要求将争议提交司法机关或拟向公安机关报案。<br />\r\n<br />\r\n第六十九条 出现以下任一情形的，xx将恢复争议处理程序：<br />\r\n<br />\r\n（一）买卖双方自行协商处理争议的，应在程序中止后30日内自行操作交易款项，或向xx提供协商结果，由xx代为操作，逾期买卖双方既未操作交易款项也未告知协商结果。<br />\r\n<br />\r\n（二）一方通知xx要求通过司法机关解决争议或拟向公安机关报案的，未在通知xx后的7个工作日内向xx平台提供司法机关或公安机关的案件受理凭证。<br />\r\n<br />\r\n（三）争议被司法机关撤诉。<br />\r\n<br />\r\n（四）司法机关对争议作出判决且生效。<br />\r\n<br />\r\n（五）公安机关受理案件后的六个月后仍未对案件给出调查结论或处理建议。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第五章 执行<br />\r\n<br />\r\n第七十条 xx处理争议期间，买卖双方协商一致达成和解协议，但无法自行操作的，xx有权根据双方达成的和解协议内容，通知支付宝公司操作相应的交易款项和(或)保证金。<br />\r\n<br />\r\n第七十一条 xx对争议做出处理后，或行政机关及消协、人民调解委员会组织调解，买卖双方认可调解结果的，有权按照处理结果通知支付宝公司将交易款项和（或）保证金的全部或部分支付给买家和(或)卖家，或协助卖家(或买家)按照处理结果将相关款项支付给买家(或卖家)。<br />\r\n<br />\r\n第七十二条 除交易款项外，根据争议处理结果仍需卖家承担赔偿责任的，xx有权通知支付宝公司划拨卖家根据xx平台相关协议缴纳的保证金或其他款项支付给买家。<br />\r\n<br />\r\n第七十三条 卖家账户余额不足致使无法退款或赔付的，由买卖双方自行协商或通过其他途径解决。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n第六章 附则<br />\r\n<br />\r\n第七十四条 对于特殊商品或交易的争议，按照《xx平台特殊商品/交易争议处理规则》进行处理。<br />\r\n<br />\r\n第七十五条 xx活动对买卖双方争议处理有特殊要求的，按照特殊要求处理。<br />\r\n<br />\r\n第七十六条 本规则生效或变更后尚未处理完结的交易，适用生效或变更后的规则。<br />\r\n<br />\r\n第七十七条 xx对争议做出处理并通知支付宝公司支付争议款项后，买家或(和)卖家对xx的处理有异议的，可向人民法院起诉。<br />\r\n<br />\r\n第七十八条 本规则于2012年1月1日首次生效，于2019年5月6日最新修订。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n--------------------------------------------------------------------------------------<br />\r\n<br />\r\n附录定义<br />\r\n<br />\r\n1.运费，指发货/退货所产生的必要费用，如商品拆卸、打包、加固、搬运等相关费用以及运输费用等。<br />\r\n<br />\r\n2.退货退款，指在卖家签收买家退货后，交易款项支付给买家。<br />\r\n<br />\r\n3.部分退款，指交易款项部分支付给买家，余款打款给卖家。<br />\r\n<br />\r\n4.退款，指交易款项支付给买家，商品由卖家自行和买家协商处理。<br />\r\n<br />\r\n5.打款，指交易款项支付给卖家。<br />\r\n<br />\r\n6.破损，指商品的一般性损伤，经简单修复后仍可恢复全部使用功能或不影响核心功能使用。<br />\r\n<br />\r\n7.损毁，指商品严重受损，无法予以修复或修复后其核心功能已不具有使用价值。修复成本接近商品价值的，视为损毁。<br />\r\n<br />\r\n8.交易成功，指订单状态显示“交易成功”。<br />\r\n<br />\r\n9.质量问题，指卖家出售的商品违反《中华人民共和国产品质量法》等法律规定或xx平台品质类相关规则要求。&nbsp;&nbsp;<br />\r\n<br />\r\n10.表面不一致，指凭肉眼即可判断交易商品存在破损、少件、空包等情形。<br />\r\n<br />\r\n11.描述不当，指买家收到的商品或接受的服务，或经xx抽检、排查到的商品或服务存在与卖家描述不相符，或卖家未对商品瑕疵等信息进行披露等情形，妨害买家权益的行为。<br />\r\n<br />\r\n12.承运人，指负责商品运输的快递或物流一方。<br />\r\n<br />\r\n13.三包，指卖家根据国家或浙江省颁布的相关法律法规，或xx公示的相关规则履行商品修理、更换、退货的责任与义务。<br />\r\n</span></span>\r\n</p>\r\n<p style=\"font-size:14px;font-family:tahoma, arial, &quot;vertical-align:baseline;background-color:#FFFFFF;\">\r\n	<span style=\"font-style:inherit;font-weight:inherit;font-size:inherit;line-height:inherit;font-family:simsun;vertical-align:baseline;\"><span style=\"font-style:inherit;font-weight:inherit;font-size:10.5pt;line-height:inherit;font-family:inherit;vertical-align:baseline;\"></span><span style=\"font-style:inherit;font-weight:inherit;font-size:10.5pt;line-height:inherit;font-family:inherit;vertical-align:baseline;\"></span></span><a href=\"https://rule.taobao.com/detail-6304.htm?spm=a2177.7231193.0.0.359217eavFzaiX&amp;tag=self\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/tfs/TB1Oa9jtQomBKNjSZFqXXXtqVXa-19-18.png\" style=\"width:16px;height:15px;\" /></a>\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('101', '84', '【消息】官方QQ群获取更多赚积分方式', '51', '0', '0', '1594561190', '1594561190', '1', '【消息】官方QQ群获取更多赚积分方式', '0');
INSERT INTO `by_document` VALUES ('102', '84', '【通知】积分商城上线公告', '51', '0', '0', '1594561438', '1594561438', '1', '<span>【通知】积分商城上线公告</span>', '0');
INSERT INTO `by_document` VALUES ('103', '84', '关于积分商城国庆期间物流服务调整的公告', '51', '0', '0', '1594564992', '1594564992', '1', '<p align=\"left\" style=\"text-indent:24px;color:#333333;font-family:瀹嬩綋;background-color:#FFFFFF;\">\r\n	尊敬的客户：\r\n</p>\r\n<p align=\"left\" style=\"text-indent:24px;color:#333333;font-family:瀹嬩綋;background-color:#FFFFFF;\">\r\n	&nbsp; 国庆假期期间，由于受到物流配送的影响，积分商城兑换申请照常受理，但配送时间将进行调整。北京地区自9月29日、其余地区自9月30日起将暂停商品配送、充值及兑换码发送服务，10月8号起恢复正常，给您带来的不便之处敬请谅解。\r\n</p>', '0');
INSERT INTO `by_document` VALUES ('104', '84', '关于物流延长派送期限的公告', '51', '0', '0', '1594565312', '1594565312', '1', '<p style=\"font-size:14px;font-family:Calibri, sans-serif;\">\r\n	<span style=\"font-size:16px;font-family:宋体;\">【爱儿俱乐部公告】</span>\r\n</p>\r\n<p style=\"font-size:14px;font-family:Calibri, sans-serif;text-indent:30px;\">\r\n	<span style=\"font-size:16px;font-family:宋体;background-color:white;\"></span>【紧急】关于北京新发地新冠疫情积分礼品物流延长派送期限的公告\r\n</p>\r\n<p style=\"font-size:14px;font-family:Calibri, sans-serif;text-indent:30px;\">\r\n	<span style=\"font-size:16px;font-family:宋体;background-color:white;\">宝妈宝爸们好：</span>\r\n</p>\r\n<p style=\"font-size:14px;font-family:Calibri, sans-serif;text-indent:32px;\">\r\n	<span style=\"font-size:16px;font-family:宋体;background-color:white;\">由于北京新发地批发市场的新冠疫情影响，北京丰台区、大兴区周边地区及武汉市青山区暂停揽件派件，积分商城礼品物流运输及派件时效受到影响，具体恢复时间未知，给您带来的不便敬请谅解。请大家合理安排兑换时间哦！</span>\r\n</p>\r\n<p style=\"font-size:14px;font-family:Calibri, sans-serif;\">\r\n	<span style=\"font-size:16px;font-family:Arial, sans-serif;background-color:white;\">&nbsp; &nbsp; &nbsp; &nbsp;</span>\r\n</p>', '0');

-- ----------------------------
-- Table structure for by_download
-- ----------------------------
DROP TABLE IF EXISTS `by_download`;
CREATE TABLE `by_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `exts` varchar(225) DEFAULT NULL,
  `type` smallint(2) NOT NULL DEFAULT '0',
  `size` varchar(225) DEFAULT NULL,
  `oldname` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='订单生成表';

-- ----------------------------
-- Records of by_download
-- ----------------------------

-- ----------------------------
-- Table structure for by_drawback
-- ----------------------------
DROP TABLE IF EXISTS `by_drawback`;
CREATE TABLE `by_drawback` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sales_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sku_id` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned DEFAULT '0',
  `express` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `express_code` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态0-已取消1-申请2-同意3-拒绝4-退货5-退款6-完成',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `complete_time` int(10) unsigned NOT NULL DEFAULT '0',
  `info` varchar(225) NOT NULL DEFAULT '',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `description` varchar(225) NOT NULL DEFAULT '',
  `address` varchar(225) NOT NULL DEFAULT '',
  `specifications` varchar(225) DEFAULT NULL,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) NOT NULL DEFAULT '',
  `cover_id` varchar(225) DEFAULT NULL,
  `reason` varchar(225) DEFAULT NULL,
  `style` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='退货表';

-- ----------------------------
-- Records of by_drawback
-- ----------------------------
INSERT INTO `by_drawback` VALUES ('10', '222', '1', '12', '1', '1', '', '', '1', '123135325', '1341', '0', '', '10.00', '', '', '', '1', '', '', '12312', '0');
INSERT INTO `by_drawback` VALUES ('11', '221', '0', '0', '1', '1', '顺丰速递', '5464', '4', '0', '0', '0', '', '101.00', '', '', '', '2', '', '', '', '0');

-- ----------------------------
-- Table structure for by_email
-- ----------------------------
DROP TABLE IF EXISTS `by_email`;
CREATE TABLE `by_email` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `api_user` varchar(225) DEFAULT NULL COMMENT '邮箱',
  `content` varchar(225) DEFAULT NULL COMMENT '回复内容',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1已发送 -1禁用',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  `to` varchar(225) DEFAULT NULL,
  `hash` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='发送邮件记录表';

-- ----------------------------
-- Records of by_email
-- ----------------------------

-- ----------------------------
-- Table structure for by_envelope
-- ----------------------------
DROP TABLE IF EXISTS `by_envelope`;
CREATE TABLE `by_envelope` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(225) DEFAULT NULL COMMENT '用户名',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发件人',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '发送内容',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-未读2-已读',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '阅读数量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='站内信表';

-- ----------------------------
-- Records of by_envelope
-- ----------------------------
INSERT INTO `by_envelope` VALUES ('4', null, '85', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590374736', '0', '2');
INSERT INTO `by_envelope` VALUES ('5', null, '86', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1594713311', '0', '2');
INSERT INTO `by_envelope` VALUES ('6', null, '87', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1594713333', '0', '2');
INSERT INTO `by_envelope` VALUES ('7', null, '88', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595048084', '0', '2');
INSERT INTO `by_envelope` VALUES ('8', null, '89', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595063721', '0', '2');
INSERT INTO `by_envelope` VALUES ('9', null, '90', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595070524', '0', '2');
INSERT INTO `by_envelope` VALUES ('10', null, '91', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595230791', '0', '2');
INSERT INTO `by_envelope` VALUES ('11', null, '92', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595254592', '0', '2');
INSERT INTO `by_envelope` VALUES ('12', null, '93', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595423410', '0', '2');
INSERT INTO `by_envelope` VALUES ('13', null, '94', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595848142', '0', '2');
INSERT INTO `by_envelope` VALUES ('14', null, '95', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1595908754', '0', '2');
INSERT INTO `by_envelope` VALUES ('15', null, '96', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1596028562', '0', '2');
INSERT INTO `by_envelope` VALUES ('16', null, '97', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1599018064', '0', '2');
INSERT INTO `by_envelope` VALUES ('17', null, '98', '84', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1599033984', '0', '2');

-- ----------------------------
-- Table structure for by_express
-- ----------------------------
DROP TABLE IF EXISTS `by_express`;
CREATE TABLE `by_express` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `code` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='快递表';

-- ----------------------------
-- Records of by_express
-- ----------------------------
INSERT INTO `by_express` VALUES ('1', '2', '332', '0', '0', '1');

-- ----------------------------
-- Table structure for by_file
-- ----------------------------
DROP TABLE IF EXISTS `by_file`;
CREATE TABLE `by_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '原始文件名',
  `savename` char(20) NOT NULL DEFAULT '' COMMENT '保存名称',
  `savepath` char(30) NOT NULL DEFAULT '' COMMENT '文件保存路径',
  `ext` char(5) NOT NULL DEFAULT '' COMMENT '文件后缀',
  `mime` char(40) NOT NULL DEFAULT '' COMMENT '文件mime类型',
  `size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `location` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '文件保存位置',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '远程地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_md5` (`md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文件表';

-- ----------------------------
-- Records of by_file
-- ----------------------------

-- ----------------------------
-- Table structure for by_flow
-- ----------------------------
DROP TABLE IF EXISTS `by_flow`;
CREATE TABLE `by_flow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `ip` varchar(225) DEFAULT NULL COMMENT 'ip地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `url` text NOT NULL COMMENT '网址',
  `time` varchar(255) DEFAULT NULL COMMENT '时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3555 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='流量表';

-- ----------------------------
-- Records of by_flow
-- ----------------------------
INSERT INTO `by_flow` VALUES ('1607', '::1', '1594560593', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1608', '::1', '1594560599', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1609', '::1', '1594560797', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1610', '::1', '1594560833', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1611', '::1', '1594560834', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1612', '::1', '1594560848', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1613', '::1', '1594561623', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('1614', '::1', '1594561625', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1615', '::1', '1594561629', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1616', '::1', '1594561631', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1617', '::1', '1594561637', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1618', '::1', '1594561654', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1619', '::1', '1594561667', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('1620', '::1', '1594561669', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1621', '::1', '1594561671', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1622', '::1', '1594561728', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1623', '::1', '1594561739', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1624', '::1', '1594561749', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1625', '::1', '1594561761', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1626', '::1', '1594561796', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1627', '::1', '1594561800', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1628', '::1', '1594561812', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('1629', '::1', '1594561814', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1630', '::1', '1594561835', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1631', '::1', '1594561851', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1632', '::1', '1594561870', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1633', '::1', '1594563085', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1634', '::1', '1594563090', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1635', '::1', '1594563099', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1636', '::1', '1594563167', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1637', '::1', '1594564927', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1638', '::1', '1594564934', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1639', '::1', '1594564999', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1640', '::1', '1594565003', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1641', '::1', '1594565398', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1642', '::1', '1594565403', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1643', '::1', '1594565404', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1644', '::1', '1594566077', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('1645', '::1', '1594566081', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1646', '::1', '1594566084', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1647', '::1', '1594566086', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1648', '::1', '1594566089', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1649', '::1', '1594566112', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1650', '::1', '1594566618', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1651', '::1', '1594566693', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1652', '::1', '1594599117', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1653', '::1', '1594599411', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1654', '::1', '1594601105', 'http://localhost/by3/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1655', '::1', '1594601111', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1656', '::1', '1594601694', 'http://localhost/by3/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1657', '::1', '1594601698', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1658', '::1', '1594601706', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1659', '::1', '1594602425', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1660', '::1', '1594602430', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1661', '::1', '1594602703', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1662', '::1', '1594602705', 'http://localhost/by3/index.php/index/user/avatar/type/1.html', null);
INSERT INTO `by_flow` VALUES ('1663', '::1', '1594602707', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1664', '::1', '1594602737', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1665', '::1', '1594602742', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1666', '::1', '1594602744', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1667', '::1', '1594602754', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1668', '::1', '1594602781', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1669', '::1', '1594602792', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1670', '::1', '1594602811', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1671', '::1', '1594602811', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1672', '113.57.245.82', '1594608384', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1673', '113.57.245.82', '1594609212', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1674', '113.57.245.82', '1594609218', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1675', '113.57.245.82', '1594609221', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1676', '113.57.245.82', '1594609227', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1677', '113.57.245.82', '1594610280', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1678', '18.234.207.41', '1594615975', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1679', '18.234.207.41', '1594617027', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1680', '18.234.207.41', '1594617269', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1681', '18.234.207.41', '1594617353', 'http://mall.bycms.cn/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('1682', '216.244.66.226', '1594617443', 'http://mall.yershop.com/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1683', '18.234.207.41', '1594618329', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1684', '18.234.207.41', '1594618492', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1685', '18.234.207.41', '1594618706', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1686', '18.234.207.41', '1594618744', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1687', '18.234.207.41', '1594618776', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1688', '119.123.132.181', '1594618882', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1689', '119.123.132.181', '1594618886', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1690', '18.234.207.41', '1594619301', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1691', '18.234.207.41', '1594620417', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1692', '18.234.207.41', '1594621102', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1693', '18.234.207.41', '1594622281', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1694', '18.234.207.41', '1594622506', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1695', '113.57.245.82', '1594625125', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1696', '113.57.245.82', '1594625527', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1697', '113.57.245.82', '1594625814', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1698', '113.57.245.82', '1594626029', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1699', '113.57.245.82', '1594626048', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1700', '113.57.245.82', '1594626063', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1701', '113.57.245.82', '1594629598', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1702', '113.57.245.82', '1594629606', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1703', '113.57.245.82', '1594629801', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1704', '113.57.245.82', '1594629812', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1705', '113.57.245.82', '1594629844', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1706', '113.57.245.82', '1594629970', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1707', '113.57.245.82', '1594629981', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1708', '113.57.245.82', '1594630001', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1709', '113.57.245.82', '1594630178', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1710', '113.57.245.82', '1594630193', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1711', '113.57.245.82', '1594630268', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1712', '113.57.245.82', '1594631218', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1713', '113.57.245.82', '1594631854', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1714', '113.57.245.82', '1594631887', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1715', '113.57.245.82', '1594632953', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1716', '113.57.245.82', '1594633558', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1717', '113.57.245.82', '1594634294', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1718', '42.236.10.114', '1594634392', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1719', '113.57.245.82', '1594634733', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1720', '113.57.245.82', '1594634744', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1721', '113.57.245.82', '1594644607', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1722', '113.57.245.82', '1594645132', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1723', '113.57.245.82', '1594645600', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1724', '113.57.245.82', '1594645615', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1725', '113.57.245.82', '1594645623', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1726', '113.57.245.82', '1594645640', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1727', '113.57.245.82', '1594645648', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1728', '113.57.245.82', '1594645654', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1729', '113.57.245.82', '1594645663', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1730', '113.57.245.82', '1594645671', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1731', '113.57.245.82', '1594645679', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1732', '113.57.245.82', '1594645711', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1733', '113.57.245.82', '1594645734', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1734', '113.57.245.82', '1594645749', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1735', '113.57.245.82', '1594646849', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1736', '34.229.119.29', '1594661886', 'http://mall.bycms.cn/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('1737', '106.11.158.141', '1594682227', 'http://mall.yershop.com/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1738', '106.11.159.114', '1594692372', 'http://mall.yershop.com/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1739', '39.188.23.120', '1594697039', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1740', '213.180.203.176', '1594702002', 'http://mall.yershop.com/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1741', '157.55.39.240', '1594704833', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1742', '183.92.250.160', '1594706272', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1743', '42.236.10.114', '1594706311', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1744', '183.92.250.160', '1594707055', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1745', '49.86.178.35', '1594709805', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1746', '175.43.103.244', '1594709931', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1747', '36.47.160.35', '1594710282', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1748', '36.47.160.35', '1594710283', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1749', '183.92.250.160', '1594711142', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1750', '183.92.250.160', '1594711149', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1751', '1.80.145.112', '1594711211', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1752', '1.80.145.112', '1594711214', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1753', '175.43.103.244', '1594712268', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1754', '175.43.103.244', '1594712283', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1755', '175.43.103.244', '1594712286', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1756', '36.47.160.35', '1594712843', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1757', '36.47.160.35', '1594713228', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1758', '36.47.160.35', '1594713231', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1759', '36.47.160.35', '1594713241', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1760', '36.47.160.35', '1594713311', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1761', '36.47.160.35', '1594713315', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1762', '36.47.160.35', '1594713316', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1763', '36.47.160.35', '1594713318', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1764', '36.47.160.35', '1594713319', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1765', '36.47.160.35', '1594713319', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1766', '36.47.160.35', '1594713320', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1767', '36.47.160.35', '1594713320', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1768', '36.47.160.35', '1594713321', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1769', '36.47.160.35', '1594713321', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1770', '36.47.160.35', '1594713321', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1771', '36.47.160.35', '1594713321', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1772', '36.47.160.35', '1594713327', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1773', '36.47.160.35', '1594713328', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1774', '36.47.160.35', '1594713330', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1775', '36.47.160.35', '1594713330', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1776', '36.47.160.35', '1594713333', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1777', '36.47.160.35', '1594713337', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1778', '36.47.160.35', '1594713389', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1779', '1.80.145.112', '1594713448', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1780', '183.92.250.160', '1594714402', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1781', '183.92.250.160', '1594716408', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1782', '183.92.250.160', '1594719040', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1783', '183.92.250.160', '1594719052', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1784', '222.169.176.250', '1594723438', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1785', '183.92.250.160', '1594729972', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1786', '114.239.23.95', '1594736443', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1787', '183.182.123.100', '1594749812', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1788', '40.77.167.14', '1594761149', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1789', '216.244.66.226', '1594763442', 'http://mall.yershop.com/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('1790', '113.57.244.116', '1594781499', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1791', '113.57.244.116', '1594781506', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1792', '113.57.244.116', '1594781634', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1793', '113.57.244.116', '1594781649', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1794', '113.57.244.116', '1594781665', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1795', '113.57.244.116', '1594781684', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1796', '113.57.244.116', '1594781766', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1797', '113.57.244.116', '1594782191', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1798', '113.57.244.116', '1594782193', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1799', '113.57.244.116', '1594782211', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1800', '113.57.244.116', '1594782288', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1801', '113.57.244.116', '1594782345', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1802', '113.57.244.116', '1594782380', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1803', '113.57.244.116', '1594782652', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1804', '113.57.244.116', '1594783478', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1805', '113.57.244.116', '1594783976', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1806', '113.57.244.116', '1594784102', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1807', '113.57.244.116', '1594784210', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1808', '113.57.244.116', '1594784262', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1809', '113.57.244.116', '1594784289', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1810', '113.57.244.116', '1594784293', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1811', '113.57.244.116', '1594784331', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1812', '220.181.108.163', '1594794409', 'http://mall.yershop.com/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1813', '113.57.245.164', '1594807313', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1814', '113.57.245.164', '1594807317', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1815', '113.57.245.164', '1594807382', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1816', '113.57.245.164', '1594807385', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1817', '113.57.245.164', '1594807444', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1818', '113.57.245.164', '1594808644', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1819', '113.57.245.164', '1594808648', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1820', '113.57.245.164', '1594808696', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1821', '113.57.245.164', '1594808699', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1822', '113.57.245.164', '1594808700', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1823', '113.57.245.164', '1594808709', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1824', '113.57.245.164', '1594809073', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1825', '36.47.160.35', '1594811486', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1826', '36.47.160.35', '1594811490', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1827', '1.80.145.112', '1594811516', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1828', '1.80.145.112', '1594811545', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1829', '36.47.160.35', '1594811554', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1830', '36.47.160.35', '1594811556', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1831', '36.47.160.35', '1594811557', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1832', '36.47.160.35', '1594811558', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1833', '36.47.160.35', '1594811559', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1834', '36.47.160.35', '1594811560', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1835', '36.47.160.35', '1594811561', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1836', '36.47.160.35', '1594811562', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1837', '36.47.160.35', '1594811563', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1838', '36.47.160.35', '1594811564', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1839', '36.47.160.35', '1594811565', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1840', '36.47.160.35', '1594811566', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1841', '36.47.160.35', '1594811567', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1842', '36.47.160.35', '1594811567', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1843', '36.47.160.35', '1594811568', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1844', '36.47.160.35', '1594811569', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1845', '36.47.160.35', '1594811569', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1846', '36.47.160.35', '1594811572', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1847', '1.80.145.112', '1594811595', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1848', '36.47.160.35', '1594811607', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1849', '1.80.145.112', '1594811664', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1850', '1.80.145.112', '1594811702', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1851', '1.80.145.112', '1594811704', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1852', '1.80.145.112', '1594811705', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1853', '1.80.145.112', '1594811708', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1854', '1.80.145.112', '1594811711', 'http://mall.bycms.cn/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('1855', '1.80.145.112', '1594812712', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1856', '1.80.145.112', '1594812712', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1857', '1.80.145.112', '1594812722', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1858', '36.47.160.35', '1594812744', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1859', '1.80.145.112', '1594812795', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1860', '36.47.160.35', '1594812995', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1861', '36.47.160.35', '1594813006', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1862', '1.80.145.112', '1594813027', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1863', '36.47.160.35', '1594813428', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1864', '36.47.160.35', '1594813432', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1865', '36.47.160.35', '1594813443', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1866', '36.47.160.35', '1594813447', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1867', '36.47.160.35', '1594813450', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1868', '36.47.160.35', '1594813451', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1869', '36.47.160.35', '1594813539', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1870', '36.47.160.35', '1594813542', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1871', '1.80.145.112', '1594813678', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1872', '1.80.145.112', '1594813706', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1873', '113.57.245.164', '1594816720', 'http://mall.bycms.cn/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('1874', '113.57.245.164', '1594816726', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1875', '113.57.245.164', '1594816751', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1876', '113.57.245.164', '1594816756', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1877', '113.57.245.164', '1594816765', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1878', '113.57.245.164', '1594816782', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1879', '113.57.245.164', '1594816902', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1880', '113.57.245.164', '1594826257', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1881', '34.229.119.29', '1594831423', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1882', '34.229.119.29', '1594831583', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1883', '34.229.119.29', '1594833753', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1884', '34.229.119.29', '1594837956', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1885', '34.229.119.29', '1594840145', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1886', '183.92.251.28', '1594881940', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1887', '183.92.251.28', '1594881948', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1888', '27.154.185.191', '1594892991', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1889', '27.154.185.191', '1594893398', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1890', '27.154.185.191', '1594893413', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1891', '157.55.39.45', '1594900577', 'http://mall.yershop.com/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('1892', '112.12.123.39', '1594900686', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1893', '157.55.39.137', '1594902370', 'http://mall.yershop.com/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1894', '175.43.103.244', '1594911286', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1895', '101.89.19.140', '1594920174', 'http://mall.bycms.cnhttp://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1896', '157.55.39.8', '1594925043', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1897', '183.95.248.61', '1594970163', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1898', '183.95.248.61', '1594970326', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1899', '183.95.248.61', '1594970334', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1900', '183.95.248.61', '1594970349', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1901', '183.95.248.61', '1594970357', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1902', '183.95.248.61', '1594971366', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1903', '183.95.248.61', '1594971741', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1904', '183.95.248.61', '1594971759', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1905', '183.95.248.61', '1594972255', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1906', '183.95.248.61', '1594973249', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1907', '183.95.248.61', '1594979162', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1908', '183.95.248.61', '1594979218', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1909', '183.95.248.61', '1594979247', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1910', '183.95.248.61', '1594979269', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1911', '183.95.248.61', '1594979474', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1912', '183.95.248.61', '1594979480', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1913', '183.95.248.61', '1594979484', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1914', '183.95.248.61', '1594979487', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1915', '183.95.248.61', '1594982272', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1916', '183.95.248.61', '1594982444', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1917', '183.95.248.61', '1594982474', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1918', '183.95.248.61', '1594982488', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1919', '183.95.248.61', '1594983035', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1920', '183.95.248.61', '1594983166', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1921', '183.95.248.61', '1594983187', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1922', '182.254.52.17', '1595012817', 'http://mall.bycms.cnhttp://mall.bycms.cn/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1923', '14.18.182.223', '1595028220', 'http://mall.bycms.cnhttp://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1924', '183.95.248.61', '1595038225', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1925', '183.95.248.61', '1595038234', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1926', '183.95.248.61', '1595038318', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1927', '183.95.248.61', '1595038343', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1928', '219.144.189.38', '1595048027', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1929', '219.144.189.38', '1595048031', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1930', '219.144.189.38', '1595048042', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1931', '219.144.189.38', '1595048046', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1932', '219.144.189.38', '1595048058', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1933', '219.144.189.38', '1595048060', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1934', '219.144.189.38', '1595048061', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1935', '219.144.189.38', '1595048067', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1936', '219.144.189.38', '1595048067', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1937', '219.144.189.38', '1595048072', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1938', '219.144.189.38', '1595048083', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1939', '219.144.189.38', '1595048084', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1940', '219.144.189.38', '1595048090', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1941', '36.47.163.178', '1595052030', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1942', '113.140.249.202', '1595052049', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1943', '54.36.148.1', '1595054866', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1944', '223.149.203.250', '1595063673', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1945', '223.149.203.250', '1595063694', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1946', '223.149.203.250', '1595063700', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1947', '223.149.203.250', '1595063721', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1948', '223.149.203.250', '1595063722', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1949', '223.104.130.32', '1595067215', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1950', '223.104.130.32', '1595067221', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1951', '223.104.130.32', '1595067224', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1952', '223.104.130.32', '1595067426', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1953', '223.104.130.32', '1595067460', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1954', '223.104.130.32', '1595067461', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1955', '223.104.130.32', '1595067463', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1956', '223.104.130.32', '1595067472', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1957', '223.104.130.32', '1595067713', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1958', '223.104.130.32', '1595067717', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1959', '223.104.130.32', '1595067729', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1960', '36.47.163.178', '1595070357', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1961', '36.47.163.178', '1595070386', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1962', '113.140.249.202', '1595070427', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1963', '36.47.163.178', '1595070461', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1964', '36.47.163.178', '1595070489', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1965', '113.140.249.202', '1595070524', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1966', '36.47.163.178', '1595070551', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1967', '36.47.163.178', '1595070591', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1968', '113.140.249.202', '1595070622', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1969', '54.36.149.45', '1595075083', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1970', '183.92.250.163', '1595080292', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1971', '116.179.32.133', '1595098219', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1972', '183.95.251.183', '1595127458', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1973', '183.95.251.183', '1595127462', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1974', '183.95.251.183', '1595127475', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1975', '183.95.251.183', '1595127478', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1976', '122.192.228.206', '1595127536', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1977', '1.80.2.214', '1595130854', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1978', '1.80.144.68', '1595130869', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1979', '1.80.144.68', '1595130874', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1980', '1.80.144.68', '1595130886', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1981', '1.80.144.68', '1595130893', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1982', '1.80.144.68', '1595130895', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1983', '220.181.108.149', '1595130928', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1984', '220.181.108.115', '1595130928', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1985', '183.95.251.183', '1595135105', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1986', '183.95.251.183', '1595135186', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1987', '183.95.251.183', '1595135206', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1988', '183.95.251.183', '1595135208', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1989', '183.95.251.183', '1595135238', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1990', '183.95.251.183', '1595135239', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1991', '183.95.251.183', '1595135252', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1992', '183.95.251.183', '1595135268', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('1993', '183.95.251.183', '1595135269', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('1994', '111.58.84.86', '1595136819', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1995', '111.58.84.86', '1595136821', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1996', '42.236.10.125', '1595136826', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('1997', '54.36.149.45', '1595147240', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('1998', '111.58.84.86', '1595147515', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('1999', '111.58.84.86', '1595147547', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2000', '113.57.247.14', '1595162111', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2001', '113.57.247.14', '1595164366', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2002', '113.57.247.14', '1595164376', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2003', '113.57.247.14', '1595164382', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2004', '113.57.247.14', '1595165832', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2005', '113.57.247.14', '1595165840', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2006', '113.57.247.14', '1595165865', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2007', '113.57.247.14', '1595165878', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2008', '113.57.247.14', '1595165885', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2009', '113.57.247.14', '1595165904', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2010', '113.57.247.14', '1595165916', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2011', '220.181.108.145', '1595180559', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2012', '220.181.108.185', '1595180560', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2013', '106.11.155.100', '1595197798', 'http://mall.yershop.com/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2014', '27.154.24.181', '1595214304', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2015', '27.154.24.181', '1595214314', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2016', '42.156.139.120', '1595218985', 'http://mall.yershop.com/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2017', '222.64.153.180', '1595225536', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2018', '222.64.153.180', '1595225539', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2019', '183.95.251.44', '1595226091', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2020', '183.95.251.44', '1595227008', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2021', '183.95.251.44', '1595227280', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2022', '183.95.251.44', '1595227309', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2023', '183.95.251.44', '1595227323', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2024', '183.95.251.44', '1595227334', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2025', '183.95.251.44', '1595227343', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2026', '183.95.251.44', '1595227357', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2027', '183.95.251.44', '1595227365', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2028', '183.95.251.44', '1595227382', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2029', '183.95.251.44', '1595230379', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2030', '183.95.251.44', '1595230579', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2031', '183.95.251.44', '1595230593', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2032', '183.95.251.44', '1595230613', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2033', '183.95.251.44', '1595230653', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2034', '183.95.251.44', '1595230677', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2035', '183.95.251.44', '1595230684', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2036', '183.95.251.44', '1595230691', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2037', '183.95.251.44', '1595230704', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2038', '183.95.251.44', '1595230719', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2039', '223.11.39.31', '1595230746', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2040', '223.11.39.31', '1595230760', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2041', '223.11.39.31', '1595230786', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2042', '223.11.39.31', '1595230791', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2043', '223.11.39.31', '1595230830', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2044', '183.95.251.44', '1595232888', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2045', '183.95.251.44', '1595232949', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2046', '183.95.251.44', '1595234847', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2047', '183.95.251.44', '1595235553', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2048', '183.95.251.44', '1595235561', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2049', '183.95.251.44', '1595236026', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2050', '183.95.251.44', '1595236063', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2051', '183.95.251.44', '1595236071', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2052', '183.95.251.44', '1595236086', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2053', '183.95.251.44', '1595236190', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2054', '183.95.251.44', '1595236193', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2055', '183.95.251.44', '1595236201', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2056', '183.95.251.44', '1595236202', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2057', '183.95.251.44', '1595236205', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2058', '183.95.251.44', '1595236265', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2059', '183.95.251.44', '1595236282', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2060', '183.95.251.44', '1595236283', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2061', '183.95.251.44', '1595236316', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2062', '183.95.251.44', '1595236317', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2063', '183.95.251.44', '1595236318', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2064', '106.11.154.110', '1595239206', 'http://mall.yershop.com/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2065', '101.26.202.211', '1595239264', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2066', '183.95.251.89', '1595239766', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2067', '183.95.251.89', '1595239767', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2068', '183.95.251.89', '1595241407', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2069', '183.95.251.89', '1595241414', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2070', '183.95.251.89', '1595241624', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2071', '183.95.251.89', '1595241639', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2072', '183.95.251.89', '1595241639', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2073', '223.91.137.59', '1595254202', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2074', '148.251.195.14', '1595264542', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2075', '106.11.157.71', '1595285549', 'http://mall.yershop.com/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2076', '221.201.116.152', '1595289951', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2077', '221.201.116.152', '1595289955', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2078', '221.201.116.152', '1595289960', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2079', '211.91.139.158', '1595298451', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2080', '211.91.139.158', '1595298830', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2081', '211.91.139.158', '1595298838', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2082', '211.91.139.158', '1595298859', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2083', '183.92.250.216', '1595309334', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2084', '183.92.250.216', '1595309344', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2085', '183.92.250.216', '1595309374', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2086', '183.92.250.216', '1595309435', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2087', '183.92.250.216', '1595309457', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2088', '183.92.250.216', '1595310783', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2089', '183.92.250.216', '1595310803', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2090', '183.92.250.216', '1595310821', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2091', '183.92.250.216', '1595324806', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2092', '183.92.250.216', '1595324873', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2093', '183.92.250.216', '1595325091', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2094', '183.92.250.216', '1595325100', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2095', '183.92.250.216', '1595325110', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2096', '183.92.250.216', '1595325136', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2097', '183.92.250.216', '1595325147', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2098', '183.92.250.216', '1595325289', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2099', '183.92.250.216', '1595325366', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2100', '183.92.250.216', '1595325388', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2101', '183.92.250.216', '1595325392', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2102', '183.92.250.216', '1595325449', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2103', '183.92.250.216', '1595325451', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2104', '183.92.250.216', '1595325476', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2105', '183.92.250.216', '1595325744', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2106', '183.92.250.216', '1595325782', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2107', '36.47.160.71', '1595326390', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2108', '36.47.160.71', '1595326394', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2109', '36.47.160.71', '1595326404', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2110', '36.47.160.71', '1595326414', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2111', '36.47.160.71', '1595326480', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2112', '183.92.250.216', '1595329574', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2113', '183.92.250.216', '1595329575', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2114', '183.92.250.216', '1595330226', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2115', '183.92.250.216', '1595330228', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2116', '183.92.250.216', '1595330375', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2117', '183.92.250.216', '1595330389', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2118', '183.92.250.216', '1595335633', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2119', '183.92.250.216', '1595335641', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2120', '183.92.250.216', '1595335642', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2121', '183.92.250.216', '1595339409', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2122', '183.92.250.216', '1595339412', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2123', '183.92.250.216', '1595339442', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2124', '183.92.250.216', '1595339442', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2125', '183.92.250.216', '1595339444', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2126', '183.92.250.216', '1595339447', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2127', '183.92.250.216', '1595384584', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2128', '183.92.250.216', '1595384844', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2129', '183.92.250.216', '1595384851', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2130', '183.92.250.216', '1595384973', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2131', '183.92.250.216', '1595385234', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2132', '183.92.250.216', '1595385242', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2133', '183.92.250.216', '1595385875', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2134', '183.92.250.216', '1595385939', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2135', '183.92.250.216', '1595385944', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2136', '183.92.250.216', '1595385948', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2137', '183.92.250.216', '1595385961', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2138', '183.92.250.216', '1595386104', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2139', '183.92.250.216', '1595386460', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2140', '183.92.250.216', '1595386466', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2141', '183.92.250.216', '1595386499', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2142', '183.92.250.216', '1595386527', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2143', '183.92.250.216', '1595387007', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2144', '117.148.109.116', '1595388071', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2145', '183.92.250.216', '1595388609', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2146', '183.92.250.216', '1595388718', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2147', '183.92.250.216', '1595388804', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2148', '180.118.179.26', '1595390418', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2149', '123.7.30.250', '1595392785', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2150', '183.92.250.216', '1595396275', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2151', '183.92.250.216', '1595396284', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2152', '183.92.250.216', '1595397733', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2153', '36.57.138.242', '1595408921', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2154', '36.57.138.242', '1595408961', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2155', '36.57.138.242', '1595408972', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2156', '36.57.138.242', '1595408974', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2157', '36.57.138.242', '1595408975', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2158', '36.57.138.242', '1595408975', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2159', '36.57.138.242', '1595408975', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2160', '36.57.138.242', '1595408978', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2161', '36.57.138.242', '1595408982', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2162', '36.57.138.242', '1595409027', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2163', '36.57.138.242', '1595409031', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2164', '36.57.138.242', '1595409031', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2165', '183.95.249.14', '1595409769', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2166', '223.88.199.31', '1595411479', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2167', '183.95.249.14', '1595414050', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2168', '183.95.249.14', '1595414059', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2169', '183.95.249.14', '1595414205', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2170', '183.95.249.14', '1595414386', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2171', '121.207.111.147', '1595415373', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2172', '183.95.249.14', '1595415689', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2173', '183.95.249.14', '1595416192', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2174', '183.95.249.14', '1595416220', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2175', '183.95.249.14', '1595416226', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2176', '183.95.249.14', '1595417154', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2177', '220.181.108.139', '1595418217', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2178', '220.181.108.179', '1595418218', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2179', '183.95.249.14', '1595420461', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2180', '183.95.249.14', '1595421498', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2181', '183.95.249.14', '1595421663', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2182', '61.184.161.71', '1595423342', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2183', '61.184.161.71', '1595423389', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2184', '61.184.161.71', '1595423410', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2185', '61.184.161.71', '1595423410', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2186', '61.184.161.71', '1595423430', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2187', '119.79.158.180', '1595439861', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2188', '119.79.158.180', '1595439896', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2189', '119.79.158.180', '1595439904', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2190', '119.79.158.180', '1595439909', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2191', '119.79.158.180', '1595439913', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2192', '182.254.52.17', '1595464019', 'http://mall.bycms.cnhttp://mall.bycms.cn/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2193', '182.254.52.17', '1595472295', 'http://mall.bycms.cnhttp://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2194', '182.254.52.17', '1595476634', 'http://mall.bycms.cnhttp://mall.bycms.cn/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2195', '113.57.245.198', '1595481250', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2196', '113.57.245.198', '1595481625', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2197', '113.57.245.198', '1595481640', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2198', '113.57.245.198', '1595481649', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2199', '113.57.245.198', '1595481659', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2200', '113.57.245.198', '1595481664', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2201', '125.71.99.85', '1595482558', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2202', '113.57.245.198', '1595482635', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2203', '113.57.245.198', '1595482705', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2204', '113.57.245.198', '1595482925', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2205', '113.57.245.198', '1595483123', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2206', '111.58.84.174', '1595486215', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2207', '111.58.84.174', '1595486219', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2208', '111.58.84.174', '1595486260', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2209', '113.57.245.198', '1595487881', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2210', '113.57.245.198', '1595487925', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2211', '113.57.245.198', '1595487930', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2212', '113.57.245.198', '1595488010', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2213', '113.57.245.198', '1595488031', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2214', '113.57.245.198', '1595488046', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2215', '113.57.245.198', '1595488245', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2216', '113.57.245.198', '1595488666', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2217', '113.57.245.198', '1595488674', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2218', '113.57.245.198', '1595488728', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2219', '113.57.245.198', '1595488895', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2220', '113.57.245.198', '1595489735', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2221', '113.57.245.198', '1595489742', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2222', '113.57.245.198', '1595505055', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2223', '113.57.245.198', '1595506049', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2224', '113.57.245.198', '1595507125', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2225', '113.57.245.198', '1595507134', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2226', '113.57.245.198', '1595507153', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2227', '113.57.245.198', '1595507222', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2228', '113.57.245.198', '1595507235', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2229', '113.57.245.198', '1595507697', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2230', '113.57.245.198', '1595508045', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2231', '27.115.124.6', '1595509838', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2232', '113.57.245.198', '1595510631', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2233', '113.57.245.198', '1595510701', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2234', '113.57.245.198', '1595512089', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2235', '113.57.245.198', '1595512262', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2236', '113.57.245.198', '1595515750', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2237', '113.57.245.198', '1595515759', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2238', '113.57.245.198', '1595515771', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2239', '113.57.245.198', '1595515778', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2240', '113.57.245.198', '1595515783', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2241', '113.57.245.198', '1595516024', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2242', '113.57.245.198', '1595516034', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2243', '113.57.245.198', '1595516042', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2244', '113.57.245.198', '1595516076', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2245', '113.57.245.198', '1595516083', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2246', '113.57.245.198', '1595516199', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2247', '113.57.245.198', '1595516212', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2248', '113.57.245.198', '1595516280', 'http://mall.bycms.cn/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('2249', '113.57.245.198', '1595516397', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2250', '113.57.245.198', '1595516485', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2251', '113.57.245.198', '1595516517', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2252', '113.57.245.198', '1595516918', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2253', '113.57.245.198', '1595517033', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2254', '113.57.245.198', '1595517101', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2255', '113.57.245.198', '1595517350', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2256', '113.57.245.198', '1595517925', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2257', '113.57.245.198', '1595518186', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2258', '113.57.245.198', '1595518258', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2259', '113.57.245.198', '1595518379', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2260', '113.57.245.198', '1595518400', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2261', '113.57.245.198', '1595518412', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2262', '113.57.245.198', '1595518424', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2263', '183.92.251.113', '1595570720', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2264', '183.92.251.113', '1595570951', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2265', '183.92.251.113', '1595571159', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2266', '183.92.251.113', '1595571323', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2267', '183.92.251.113', '1595571332', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2268', '183.92.251.113', '1595571349', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2269', '183.92.251.113', '1595571514', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2270', '183.92.251.113', '1595571598', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2271', '183.92.251.113', '1595571734', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2272', '183.92.251.113', '1595571878', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2273', '183.92.251.113', '1595571885', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2274', '183.92.251.113', '1595571953', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2275', '183.92.251.113', '1595571964', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2276', '183.92.251.113', '1595574088', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2277', '183.92.251.113', '1595577031', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2278', '183.92.251.113', '1595582151', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2279', '113.57.244.191', '1595589505', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2280', '157.55.39.55', '1595627120', 'http://mall.bycms.cn/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('2281', '54.36.148.1', '1595643001', 'http://mall.bycms.cn/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('2282', '40.77.167.5', '1595648398', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2283', '113.57.183.20', '1595663029', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2284', '113.57.183.20', '1595664016', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2285', '113.57.183.20', '1595664157', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2286', '113.57.183.20', '1595672183', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2287', '54.36.149.97', '1595726803', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2288', '101.83.137.0', '1595751250', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2289', '101.83.137.0', '1595751254', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2290', '101.83.137.0', '1595751282', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2291', '101.83.137.0', '1595751298', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2292', '101.83.137.0', '1595751310', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2293', '101.83.137.0', '1595751404', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2294', '116.249.107.247', '1595834550', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2295', '183.95.249.142', '1595836246', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2296', '183.95.249.142', '1595836247', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2297', '183.95.249.142', '1595836327', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2298', '183.95.249.142', '1595836328', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2299', '183.95.249.142', '1595836334', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2300', '183.95.249.142', '1595836335', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2301', '183.95.249.142', '1595836388', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2302', '183.95.249.142', '1595836525', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2303', '183.95.249.142', '1595836575', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2304', '183.95.249.142', '1595836631', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2305', '183.95.249.142', '1595843256', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2306', '183.95.249.142', '1595843433', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2307', '183.95.249.142', '1595843598', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2308', '183.95.249.142', '1595843859', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2309', '183.95.249.142', '1595844176', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2310', '183.95.249.142', '1595844445', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2311', '183.95.249.142', '1595844464', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2312', '183.95.249.142', '1595844471', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2313', '183.95.249.142', '1595844543', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2314', '183.95.249.142', '1595844931', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2315', '183.95.249.142', '1595845302', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2316', '183.95.249.142', '1595845332', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2317', '113.245.211.212', '1595846909', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2318', '113.245.211.212', '1595848090', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2319', '113.245.211.212', '1595848117', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2320', '113.245.211.212', '1595848122', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2321', '113.245.211.212', '1595848137', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2322', '113.245.211.212', '1595848139', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2323', '113.245.211.212', '1595848142', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2324', '113.245.211.212', '1595848143', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2325', '183.95.249.142', '1595852250', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2326', '183.95.249.142', '1595852676', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2327', '183.95.249.142', '1595852698', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2328', '183.95.249.142', '1595908028', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2329', '183.195.6.152', '1595908738', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2330', '183.195.6.152', '1595908753', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2331', '183.195.6.152', '1595909434', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2332', '183.195.6.152', '1595909440', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2333', '183.195.6.152', '1595909525', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2334', '183.95.249.142', '1595910982', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2335', '183.95.249.142', '1595910995', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2336', '183.95.249.142', '1595911733', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2337', '183.95.249.142', '1595912070', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2338', '183.95.249.142', '1595912099', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2339', '183.95.249.142', '1595912292', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2340', '183.95.249.142', '1595914272', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2341', '183.95.249.142', '1595914295', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2342', '183.95.249.142', '1595914309', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2343', '183.95.249.142', '1595915283', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2344', '183.95.249.142', '1595915771', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2345', '183.95.249.142', '1595915895', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2346', '183.95.249.142', '1595916011', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2347', '183.95.249.142', '1595916023', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2348', '183.95.249.142', '1595916105', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2349', '183.95.249.142', '1595918298', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2350', '183.95.249.142', '1595918347', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2351', '183.95.249.142', '1595918456', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2352', '183.95.249.142', '1595918490', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2353', '183.95.249.142', '1595921701', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2354', '183.95.249.142', '1595921712', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2355', '183.95.249.142', '1595922288', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2356', '183.95.249.142', '1595922305', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2357', '183.95.249.142', '1595922330', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2358', '183.95.249.142', '1595926064', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2359', '183.95.249.142', '1595927584', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2360', '183.95.249.142', '1595929316', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2361', '183.95.249.142', '1595929931', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2362', '183.95.249.142', '1595930154', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2363', '183.95.249.142', '1595930203', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2364', '183.95.249.142', '1595930315', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2365', '113.140.251.144', '1595935212', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2366', '113.140.251.144', '1595935216', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2367', '113.140.251.144', '1595935222', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2368', '113.140.251.144', '1595935235', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2369', '113.140.251.144', '1595935235', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2370', '1.80.146.201', '1595935259', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2371', '1.80.146.201', '1595935261', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2372', '113.57.247.129', '1595944825', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2373', '113.57.247.129', '1595945640', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2374', '113.57.247.129', '1595945657', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2375', '183.92.251.123', '1595979515', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2376', '183.92.251.123', '1595979533', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2377', '183.92.251.123', '1595979546', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2378', '183.92.251.123', '1595979554', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2379', '183.92.251.123', '1595979560', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2380', '183.92.251.123', '1595979970', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2381', '183.92.251.123', '1595979988', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2382', '183.92.251.123', '1595979997', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2383', '183.92.251.123', '1595980011', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2384', '183.92.251.123', '1595980029', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2385', '183.92.251.123', '1595980040', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2386', '183.92.251.123', '1595980064', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2387', '183.92.251.123', '1595980072', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2388', '183.92.251.123', '1595980115', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2389', '183.92.251.123', '1595980126', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2390', '183.92.251.123', '1595980247', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2391', '183.92.251.123', '1595980535', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2392', '183.92.251.123', '1595981401', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2393', '183.92.251.123', '1595981409', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2394', '183.92.251.123', '1595981415', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2395', '183.92.251.123', '1595981428', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2396', '183.92.251.123', '1595982746', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2397', '183.92.251.123', '1595982765', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2398', '183.92.251.123', '1595982780', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2399', '183.92.251.123', '1595982792', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2400', '183.92.251.123', '1595982802', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2401', '183.92.251.123', '1595982811', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2402', '183.92.251.123', '1595982821', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2403', '183.92.251.123', '1595984112', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2404', '183.92.251.123', '1595984154', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2405', '183.92.251.123', '1595984162', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2406', '183.92.251.123', '1595984175', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2407', '183.92.251.123', '1595988256', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2408', '54.36.149.45', '1595996294', 'http://mall.bycms.cn/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2409', '183.92.251.123', '1596008166', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2410', '116.128.128.41', '1596014536', 'http://mall.bycms.cnhttp://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2411', '183.92.251.123', '1596017291', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2412', '183.92.251.123', '1596018205', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2413', '183.92.251.123', '1596018222', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2414', '183.92.251.123', '1596018226', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2415', '1.170.0.191', '1596025254', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2416', '183.92.251.123', '1596028148', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2417', '120.230.95.244', '1596028474', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2418', '120.230.95.244', '1596028541', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2419', '120.230.95.244', '1596028542', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2420', '120.230.95.244', '1596028546', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2421', '120.230.95.244', '1596028555', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2422', '120.230.95.244', '1596028562', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2423', '120.230.95.244', '1596028562', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2424', '120.230.95.244', '1596028566', 'http://mall.bycms.cn/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2425', '120.230.95.244', '1596028573', 'http://mall.bycms.cn/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2426', '120.230.95.244', '1596028723', 'http://mall.bycms.cn/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('2427', '120.230.95.244', '1596028725', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2428', '120.230.95.244', '1596028726', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2429', '183.92.251.123', '1596029359', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2430', '183.92.251.123', '1596029390', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2431', '183.92.251.123', '1596030153', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2432', '183.92.251.123', '1596030388', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2433', '183.92.251.123', '1596030394', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2434', '183.92.251.123', '1596030403', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2435', '183.92.251.123', '1596030417', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2436', '183.92.251.123', '1596030454', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2437', '183.92.251.123', '1596030492', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2438', '183.92.251.123', '1596030510', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2439', '183.92.251.123', '1596030518', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2440', '183.92.251.123', '1596030527', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2441', '183.92.251.123', '1596030593', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2442', '183.92.251.123', '1596030609', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2443', '183.92.251.123', '1596030969', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2444', '183.92.251.123', '1596030978', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2445', '183.92.251.123', '1596030989', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2446', '183.95.251.101', '1596066176', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2447', '183.95.251.101', '1596066192', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2448', '183.95.251.101', '1596066228', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2449', '183.95.251.101', '1596066339', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2450', '183.95.251.101', '1596066388', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2451', '183.95.251.101', '1596066463', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2452', '183.95.251.101', '1596066951', 'http://mall.bycms.cn/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2453', '::1', '1596078158', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2454', '::1', '1596078204', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2455', '::1', '1596093442', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2456', '::1', '1596093590', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2457', '::1', '1596094549', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2458', '::1', '1596094557', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2459', '::1', '1596095097', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2460', '::1', '1596095111', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2461', '::1', '1596095125', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2462', '::1', '1596095147', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2463', '::1', '1596096355', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2464', '::1', '1596096363', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2465', '::1', '1596096487', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2466', '::1', '1596096934', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2467', '::1', '1596096942', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2468', '::1', '1596096957', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2469', '::1', '1596097193', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2470', '::1', '1596098199', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2471', '::1', '1596098881', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2472', '::1', '1596103628', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2473', '::1', '1596103638', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2474', '::1', '1596109759', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2475', '::1', '1596109768', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2476', '::1', '1596203373', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2477', '::1', '1596246276', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2478', '::1', '1596246286', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2479', '::1', '1596246310', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2480', '::1', '1596247212', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2481', '::1', '1596247240', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2482', '::1', '1596273247', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2483', '::1', '1596273718', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2484', '::1', '1596273846', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2485', '::1', '1596273920', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2486', '::1', '1596286702', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2487', '::1', '1596286712', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2488', '::1', '1596287201', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2489', '::1', '1596289071', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2490', '::1', '1596291224', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2491', '::1', '1596291240', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2492', '::1', '1596292173', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2493', '::1', '1596292819', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2494', '::1', '1596292822', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2495', '::1', '1596292856', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2496', '::1', '1596294632', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2497', '::1', '1596294666', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2498', '::1', '1596294673', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2499', '::1', '1596294798', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2500', '::1', '1596295263', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2501', '::1', '1596295297', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2502', '::1', '1596295424', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2503', '::1', '1596295449', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2504', '::1', '1596295456', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2505', '::1', '1596295497', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2506', '::1', '1596295535', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2507', '::1', '1596295558', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2508', '::1', '1596295581', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2509', '::1', '1596295765', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2510', '::1', '1596295826', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2511', '::1', '1596295828', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2512', '::1', '1596295833', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2513', '::1', '1596295905', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2514', '::1', '1596295938', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2515', '::1', '1596295964', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2516', '::1', '1596296024', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2517', '::1', '1596296040', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2518', '::1', '1596296097', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2519', '::1', '1596296175', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2520', '::1', '1596296191', 'http://localhost/by3/index.php/index/user/F:/wpf/WpfApp1/WpfApp1/bin/x64/Debug/web/by3/plugin/wechat/images/wechat.png', null);
INSERT INTO `by_flow` VALUES ('2521', '::1', '1596296271', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2522', '::1', '1596296284', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2523', '::1', '1596296296', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2524', '::1', '1596296306', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2525', '::1', '1596296323', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2526', '::1', '1596296338', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2527', '::1', '1596296407', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2528', '::1', '1596296564', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2529', '::1', '1596296575', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2530', '::1', '1596296597', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2531', '::1', '1596296622', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2532', '::1', '1596296640', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2533', '::1', '1596296696', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2534', '::1', '1596296710', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2535', '::1', '1596297025', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2536', '::1', '1596297060', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2537', '::1', '1596297065', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2538', '::1', '1596297109', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2539', '::1', '1596297124', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2540', '::1', '1596297216', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2541', '::1', '1596297287', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2542', '::1', '1596297314', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2543', '::1', '1596297339', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2544', '::1', '1596297389', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2545', '::1', '1596297394', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2546', '::1', '1596297402', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2547', '::1', '1596297411', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2548', '::1', '1596297411', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2549', '::1', '1596297463', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2550', '::1', '1596297513', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2551', '::1', '1596297566', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2552', '::1', '1596297579', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2553', '::1', '1596297592', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2554', '::1', '1596297597', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2555', '::1', '1596297656', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2556', '::1', '1596355588', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2557', '::1', '1596356846', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2558', '::1', '1596375489', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2559', '::1', '1596375576', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2560', '::1', '1596375847', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2561', '::1', '1596375903', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2562', '::1', '1596412016', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2563', '::1', '1596412157', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2564', '::1', '1596421282', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2565', '::1', '1596421879', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2566', '::1', '1596421885', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2567', '::1', '1596422010', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2568', '::1', '1596422059', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2569', '::1', '1596422214', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2570', '::1', '1596422338', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2571', '::1', '1596422415', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2572', '::1', '1596422425', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2573', '::1', '1596422440', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2574', '::1', '1596422449', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2575', '::1', '1596422800', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2576', '::1', '1596422818', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2577', '::1', '1596449887', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2578', '::1', '1596514485', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2579', '::1', '1596514750', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2580', '::1', '1596522385', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2581', '::1', '1596522411', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2582', '::1', '1596522422', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2583', '::1', '1596522431', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2584', '::1', '1596522466', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2585', '::1', '1596522495', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2586', '::1', '1596544596', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2587', '::1', '1596544612', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2588', '::1', '1596545063', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2589', '::1', '1596545100', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2590', '::1', '1596546775', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2591', '::1', '1596546819', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2592', '::1', '1596548170', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2593', '::1', '1596548176', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2594', '::1', '1596549845', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('2595', '::1', '1596549847', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2596', '::1', '1596549862', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2597', '::1', '1596549866', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2598', '::1', '1596550008', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2599', '::1', '1596550019', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2600', '::1', '1596550020', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2601', '::1', '1596550020', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2602', '::1', '1596550028', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2603', '::1', '1596550108', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2604', '::1', '1596550146', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2605', '::1', '1596550205', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2606', '::1', '1596550223', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2607', '::1', '1596550317', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2608', '::1', '1596550350', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2609', '::1', '1596550370', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2610', '::1', '1596597398', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2611', '::1', '1596597403', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2612', '::1', '1596597411', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('2613', '::1', '1596597414', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2614', '::1', '1596597435', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2615', '::1', '1596597454', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2616', '::1', '1596604433', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2617', '::1', '1596604445', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2618', '::1', '1596604462', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2619', '::1', '1596604467', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2620', '::1', '1596604468', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2621', '::1', '1596604477', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2622', '::1', '1596604480', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2623', '::1', '1596604487', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2624', '::1', '1596604496', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2625', '::1', '1596604510', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2626', '::1', '1596604514', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2627', '::1', '1596604519', 'http://localhost/by3/index.php/index/user/sendsms.html', null);
INSERT INTO `by_flow` VALUES ('2628', '::1', '1596604603', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2629', '::1', '1596611534', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2630', '::1', '1596611808', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2631', '::1', '1596627919', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2632', '::1', '1596627934', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2633', '::1', '1596630709', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2634', '::1', '1596630719', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2635', '::1', '1596630723', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2636', '::1', '1596632777', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2637', '::1', '1596633059', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2638', '::1', '1596633068', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2639', '::1', '1596633317', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2640', '::1', '1596633334', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2641', '::1', '1596633346', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2642', '::1', '1596635494', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2643', '::1', '1596635534', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2644', '::1', '1596635590', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2645', '::1', '1596635842', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2646', '::1', '1596640713', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2647', '::1', '1596690938', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2648', '::1', '1596690947', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2649', '::1', '1596691455', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2650', '::1', '1596691462', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2651', '::1', '1596698023', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2652', '::1', '1596698060', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2653', '::1', '1596698076', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2654', '::1', '1596698115', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2655', '::1', '1596700016', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2656', '::1', '1596700032', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2657', '::1', '1596700202', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2658', '::1', '1596700213', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2659', '::1', '1596700331', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2660', '::1', '1596703615', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2661', '::1', '1596703625', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2662', '::1', '1596703642', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2663', '::1', '1596703652', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2664', '::1', '1596707588', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2665', '::1', '1596707631', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2666', '::1', '1596707646', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2667', '::1', '1596708262', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2668', '::1', '1596708274', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2669', '::1', '1596708284', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2670', '::1', '1596708301', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2671', '::1', '1596793023', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2672', '::1', '1596793207', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2673', '::1', '1596793216', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2674', '::1', '1596793233', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2675', '::1', '1596793708', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2676', '::1', '1596805115', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2677', '::1', '1596805143', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2678', '::1', '1596805158', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2679', '::1', '1596808549', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2680', '::1', '1596808569', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2681', '::1', '1597064026', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2682', '::1', '1597064111', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2683', '::1', '1597064676', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2684', '::1', '1597064691', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2685', '::1', '1597064747', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2686', '::1', '1597064764', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2687', '::1', '1597067558', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2688', '::1', '1597070647', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2689', '::1', '1597071427', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2690', '::1', '1597288545', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2691', '::1', '1597288557', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2692', '::1', '1597288661', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2693', '::1', '1597288665', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2694', '::1', '1597289562', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2695', '::1', '1597289569', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2696', '::1', '1597289658', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2697', '::1', '1597289919', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2698', '::1', '1597291041', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2699', '::1', '1597291052', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2700', '::1', '1597291180', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2701', '::1', '1597291625', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2702', '::1', '1597291634', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2703', '::1', '1597291651', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2704', '::1', '1597291662', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2705', '::1', '1597291674', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2706', '::1', '1597291688', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2707', '::1', '1597291696', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2708', '::1', '1597293104', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2709', '::1', '1597293115', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2710', '::1', '1597293266', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2711', '::1', '1597303168', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2712', '::1', '1597303179', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2713', '::1', '1597303190', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2714', '::1', '1597303197', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2715', '::1', '1597303202', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2716', '::1', '1597303586', 'http://localhost/by3/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('2717', '::1', '1597303598', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2718', '::1', '1597303835', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2719', '::1', '1597304117', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2720', '::1', '1597376483', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2721', '::1', '1597376554', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2722', '::1', '1597376586', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2723', '::1', '1597379222', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2724', '::1', '1597379236', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2725', '::1', '1597379248', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2726', '::1', '1597379293', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2727', '::1', '1597380889', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2728', '::1', '1597380908', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2729', '::1', '1597380912', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2730', '::1', '1597386952', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2731', '::1', '1597387161', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2732', '::1', '1597387180', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2733', '::1', '1597395515', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2734', '::1', '1597395631', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2735', '::1', '1597397278', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2736', '::1', '1597397357', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2737', '::1', '1597401372', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2738', '::1', '1597401438', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2739', '::1', '1597401452', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2740', '::1', '1597401566', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2741', '::1', '1597401636', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2742', '::1', '1597401700', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2743', '::1', '1597401719', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2744', '::1', '1597401751', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2745', '::1', '1597401768', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2746', '::1', '1597402338', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2747', '::1', '1597402369', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2748', '::1', '1597402394', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2749', '::1', '1597402991', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2750', '::1', '1597402995', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2751', '::1', '1597403608', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2752', '::1', '1597404546', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2753', '::1', '1597411340', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2754', '::1', '1597411356', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2755', '::1', '1597412581', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2756', '::1', '1597412815', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2757', '::1', '1597412829', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2758', '::1', '1597457498', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2759', '::1', '1597457503', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2760', '::1', '1597457510', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2761', '::1', '1597457512', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2762', '::1', '1597459883', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2763', '::1', '1597460351', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2764', '::1', '1597460351', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2765', '::1', '1597460380', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2766', '::1', '1597461665', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2767', '::1', '1597461682', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2768', '::1', '1597461777', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2769', '::1', '1597468732', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2770', '::1', '1597468733', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2771', '::1', '1597468736', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2772', '::1', '1597468739', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2773', '::1', '1597469213', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2774', '::1', '1597489126', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2775', '::1', '1597489134', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2776', '::1', '1597489142', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2777', '::1', '1597489158', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2778', '::1', '1597489175', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2779', '::1', '1597489201', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2780', '::1', '1597489208', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2781', '::1', '1597489235', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2782', '::1', '1597489243', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2783', '::1', '1597489252', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2784', '::1', '1597489298', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2785', '::1', '1597489307', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2786', '::1', '1597489316', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2787', '::1', '1597489330', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2788', '::1', '1597489345', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2789', '::1', '1597489360', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2790', '::1', '1597489363', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2791', '::1', '1597489373', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2792', '::1', '1597489404', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2793', '::1', '1597489417', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2794', '::1', '1597489449', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2795', '::1', '1597489470', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2796', '::1', '1597489481', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2797', '::1', '1597490302', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2798', '::1', '1597490318', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2799', '::1', '1597490342', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2800', '::1', '1597491954', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2801', '::1', '1597495438', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2802', '::1', '1597495455', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2803', '::1', '1597495500', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2804', '::1', '1597495562', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2805', '::1', '1597497891', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2806', '::1', '1597500064', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2807', '::1', '1597500079', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2808', '::1', '1597500084', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2809', '::1', '1597561969', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2810', '::1', '1597561977', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2811', '::1', '1597562002', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2812', '::1', '1597562022', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2813', '::1', '1597562211', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2814', '::1', '1597562490', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2815', '::1', '1597562527', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2816', '::1', '1597562559', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2817', '::1', '1597562565', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2818', '::1', '1597562596', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2819', '::1', '1597562748', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2820', '::1', '1597564638', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2821', '::1', '1597564653', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2822', '::1', '1597564670', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2823', '::1', '1597564750', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2824', '::1', '1597570233', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2825', '::1', '1597571336', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2826', '::1', '1597571542', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2827', '::1', '1597571974', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2828', '::1', '1597572117', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2829', '::1', '1597641136', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2830', '::1', '1597641143', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2831', '::1', '1597641149', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2832', '::1', '1597641160', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2833', '::1', '1597641176', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2834', '::1', '1597641186', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2835', '::1', '1597641190', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2836', '::1', '1597641196', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2837', '::1', '1597642377', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2838', '::1', '1597643642', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2839', '::1', '1597643962', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2840', '::1', '1597644007', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2841', '::1', '1597647114', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2842', '::1', '1597647213', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2843', '::1', '1597647280', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2844', '::1', '1597647301', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2845', '::1', '1597647329', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2846', '::1', '1597647766', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2847', '::1', '1597647814', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2848', '::1', '1597647847', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2849', '::1', '1597647869', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2850', '::1', '1597647883', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2851', '::1', '1597647895', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2852', '::1', '1597647948', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2853', '::1', '1597647973', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2854', '::1', '1597647985', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2855', '::1', '1597648087', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2856', '::1', '1597648093', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2857', '::1', '1597650072', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2858', '::1', '1597654698', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2859', '::1', '1597654709', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2860', '::1', '1597654731', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2861', '::1', '1597654739', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2862', '::1', '1597654748', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2863', '::1', '1597654797', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2864', '::1', '1597655520', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2865', '::1', '1597656319', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2866', '::1', '1597657692', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2867', '::1', '1597718073', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2868', '::1', '1597718294', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2869', '::1', '1597718327', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2870', '::1', '1597718349', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2871', '::1', '1597718389', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2872', '::1', '1597718524', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2873', '::1', '1597718541', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2874', '::1', '1597718552', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2875', '::1', '1597718564', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2876', '::1', '1597718607', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2877', '::1', '1597720361', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2878', '::1', '1597720834', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2879', '::1', '1597721873', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2880', '::1', '1597721927', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2881', '::1', '1597722701', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2882', '::1', '1597722747', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2883', '::1', '1597724223', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2884', '::1', '1597744453', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2885', '::1', '1597744483', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2886', '::1', '1597744503', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2887', '::1', '1597744513', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2888', '::1', '1597744527', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2889', '::1', '1597744533', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2890', '::1', '1597744553', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2891', '::1', '1597744990', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2892', '::1', '1597747987', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2893', '::1', '1597747994', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2894', '::1', '1597748945', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2895', '::1', '1597749231', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2896', '::1', '1597749275', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2897', '::1', '1597756048', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2898', '::1', '1597756071', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2899', '::1', '1597756111', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2900', '::1', '1597757590', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2901', '::1', '1597757604', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2902', '::1', '1597757615', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2903', '::1', '1597757637', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2904', '::1', '1597757654', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2905', '::1', '1597757675', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2906', '::1', '1597757690', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2907', '::1', '1597757726', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2908', '::1', '1597761421', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2909', '::1', '1597762932', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2910', '::1', '1597817019', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2911', '::1', '1597817056', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2912', '::1', '1597817073', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2913', '::1', '1597819762', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2914', '::1', '1597819818', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2915', '::1', '1597819903', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2916', '::1', '1597823932', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2917', '::1', '1597823948', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2918', '::1', '1597823959', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2919', '::1', '1597823965', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2920', '::1', '1597823972', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2921', '::1', '1597823997', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2922', '::1', '1597824021', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2923', '::1', '1597824030', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2924', '::1', '1597824044', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2925', '::1', '1597824058', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2926', '::1', '1597824064', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2927', '::1', '1597824074', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2928', '::1', '1597824079', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2929', '::1', '1597824083', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2930', '::1', '1597824100', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2931', '::1', '1597824105', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2932', '::1', '1597824124', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2933', '::1', '1597824132', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2934', '::1', '1597824142', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2935', '::1', '1597824145', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2936', '::1', '1597824147', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2937', '::1', '1597824150', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2938', '::1', '1597824154', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2939', '::1', '1597824166', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2940', '::1', '1597824171', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2941', '::1', '1597824178', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2942', '::1', '1597824185', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2943', '::1', '1597824192', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2944', '::1', '1597824196', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2945', '::1', '1597824211', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2946', '::1', '1597824222', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2947', '::1', '1597824227', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2948', '::1', '1597824236', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2949', '::1', '1597824263', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2950', '::1', '1597824270', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2951', '::1', '1597824893', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2952', '::1', '1597824901', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2953', '::1', '1597824908', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2954', '::1', '1597824916', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2955', '::1', '1597824925', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2956', '::1', '1597824933', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2957', '::1', '1597824940', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2958', '::1', '1597824957', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2959', '::1', '1597824968', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2960', '::1', '1597824977', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2961', '::1', '1597828869', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2962', '::1', '1597830778', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2963', '::1', '1597835684', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2964', '::1', '1597889360', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2965', '::1', '1597889363', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('2966', '::1', '1597906645', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2967', '::1', '1597906856', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2968', '::1', '1597906857', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2969', '::1', '1597906888', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2970', '::1', '1597906890', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2971', '::1', '1597906912', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2972', '::1', '1597906914', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2973', '::1', '1597906964', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2974', '::1', '1597909605', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2975', '::1', '1597909607', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2976', '::1', '1597909631', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2977', '::1', '1597909634', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2978', '::1', '1597909636', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2979', '::1', '1597909637', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2980', '::1', '1597909694', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2981', '::1', '1597909695', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2982', '::1', '1597909733', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2983', '::1', '1597909736', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2984', '::1', '1597909969', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2985', '::1', '1597910105', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2986', '::1', '1597910107', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2987', '::1', '1597910110', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2988', '::1', '1597910114', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2989', '::1', '1597910115', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2990', '::1', '1597911544', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2991', '::1', '1597911545', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2992', '::1', '1597912347', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2993', '::1', '1597912350', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2994', '::1', '1597912418', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2995', '::1', '1597913832', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2996', '::1', '1597913833', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('2997', '::1', '1597913848', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('2998', '::1', '1597913913', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('2999', '::1', '1597913913', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3000', '::1', '1597913933', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3001', '::1', '1597914015', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3002', '::1', '1597915158', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3003', '::1', '1597916879', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3004', '::1', '1597916880', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3005', '::1', '1597918628', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3006', '::1', '1597918629', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3007', '::1', '1597925823', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3008', '::1', '1597927245', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3009', '::1', '1597927254', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3010', '::1', '1597927256', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3011', '::1', '1597927259', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3012', '::1', '1597927261', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3013', '::1', '1597927330', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3014', '::1', '1597927330', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3015', '::1', '1598007622', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3016', '::1', '1598018604', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3017', '::1', '1598019221', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3018', '::1', '1598019236', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3019', '::1', '1598020375', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3020', '::1', '1598020430', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3021', '::1', '1598022079', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3022', '::1', '1598022091', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3023', '::1', '1598022106', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3024', '::1', '1598067469', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3025', '::1', '1598068033', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3026', '::1', '1598068186', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3027', '::1', '1598068847', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3028', '::1', '1598068860', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3029', '::1', '1598070724', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3030', '::1', '1598091720', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3031', '::1', '1598091727', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3032', '::1', '1598091772', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3033', '::1', '1598091828', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3034', '::1', '1598091832', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3035', '::1', '1598091906', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3036', '::1', '1598092370', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3037', '::1', '1598094114', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3038', '::1', '1598094197', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3039', '::1', '1598094211', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3040', '::1', '1598098756', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3041', '::1', '1598098828', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3042', '::1', '1598098838', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3043', '::1', '1598100103', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3044', '::1', '1598100143', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3045', '::1', '1598151880', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3046', '::1', '1598152128', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3047', '::1', '1598152138', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3048', '::1', '1598152157', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3049', '::1', '1598152181', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3050', '::1', '1598152194', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3051', '::1', '1598152206', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3052', '::1', '1598153683', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3053', '::1', '1598153778', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3054', '::1', '1598154141', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3055', '::1', '1598155497', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3056', '::1', '1598155511', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3057', '::1', '1598155612', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3058', '::1', '1598155615', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3059', '::1', '1598155644', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3060', '::1', '1598157284', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3061', '::1', '1598157319', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3062', '::1', '1598157319', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3063', '::1', '1598157321', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3064', '::1', '1598157810', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3065', '::1', '1598157811', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3066', '::1', '1598158402', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3067', '::1', '1598160165', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3068', '::1', '1598160167', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3069', '::1', '1598164195', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3070', '::1', '1598164195', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3071', '::1', '1598164216', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3072', '::1', '1598170002', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3073', '::1', '1598170010', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3074', '::1', '1598170201', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3075', '::1', '1598170202', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3076', '::1', '1598170225', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3077', '::1', '1598170252', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3078', '::1', '1598173232', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3079', '::1', '1598173564', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3080', '::1', '1598173565', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3081', '::1', '1598239679', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3082', '::1', '1598242645', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3083', '::1', '1598242648', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3084', '::1', '1598242651', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3085', '::1', '1598245203', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3086', '::1', '1598245276', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3087', '::1', '1598245427', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3088', '::1', '1598246255', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3089', '::1', '1598246278', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3090', '::1', '1598246348', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3091', '::1', '1598246568', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3092', '::1', '1598247737', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3093', '::1', '1598265397', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3094', '::1', '1598271442', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3095', '::1', '1598271446', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3096', '::1', '1598275833', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3097', '::1', '1598279617', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3098', '::1', '1598342163', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3099', '::1', '1598344117', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3100', '::1', '1598344413', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3101', '::1', '1598345500', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3102', '::1', '1598346144', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3103', '::1', '1598346159', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3104', '::1', '1598351795', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3105', '::1', '1598352536', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3106', '::1', '1598352582', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3107', '::1', '1598352589', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3108', '::1', '1598352682', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3109', '::1', '1598357152', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3110', '::1', '1598357167', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3111', '::1', '1598357233', 'http://localhost/by3/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3112', '::1', '1598360035', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3113', '::1', '1598365920', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3114', '::1', '1598418072', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3115', '::1', '1598421002', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3116', '::1', '1598421010', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3117', '::1', '1598421020', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3118', '::1', '1598427237', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3119', '::1', '1598427312', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3120', '::1', '1598427393', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3121', '::1', '1598427408', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3122', '::1', '1598427439', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3123', '::1', '1598427486', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3124', '::1', '1598427496', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3125', '::1', '1598427554', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3126', '::1', '1598427567', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3127', '::1', '1598427594', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3128', '::1', '1598427607', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3129', '::1', '1598427726', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3130', '::1', '1598427789', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3131', '::1', '1598427858', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3132', '::1', '1598427928', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3133', '::1', '1598427951', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3134', '::1', '1598428038', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3135', '::1', '1598428095', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3136', '::1', '1598428119', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3137', '::1', '1598428190', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3138', '::1', '1598428203', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3139', '::1', '1598428235', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3140', '::1', '1598428257', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3141', '::1', '1598428266', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3142', '::1', '1598428288', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3143', '::1', '1598428330', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3144', '::1', '1598428339', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3145', '::1', '1598428368', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3146', '::1', '1598428377', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3147', '::1', '1598428385', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3148', '::1', '1598428438', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3149', '::1', '1598428450', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3150', '::1', '1598428465', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3151', '::1', '1598428483', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3152', '::1', '1598428526', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3153', '::1', '1598428538', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3154', '::1', '1598428545', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3155', '::1', '1598428563', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3156', '::1', '1598428576', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3157', '::1', '1598428583', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3158', '::1', '1598428611', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3159', '::1', '1598428669', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3160', '::1', '1598428834', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3161', '::1', '1598428854', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3162', '::1', '1598428869', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3163', '::1', '1598428946', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3164', '::1', '1598428994', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3165', '::1', '1598429031', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3166', '::1', '1598429072', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3167', '::1', '1598429073', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3168', '::1', '1598429078', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3169', '::1', '1598429238', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3170', '::1', '1598429280', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3171', '::1', '1598429315', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3172', '::1', '1598429567', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3173', '::1', '1598429775', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3174', '::1', '1598429823', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3175', '::1', '1598429827', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3176', '::1', '1598429830', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3177', '::1', '1598430495', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3178', '::1', '1598430500', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3179', '::1', '1598430519', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3180', '::1', '1598430553', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3181', '::1', '1598430790', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3182', '::1', '1598440986', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3183', '::1', '1598440994', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3184', '::1', '1598441049', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3185', '::1', '1598441066', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3186', '::1', '1598441136', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3187', '::1', '1598441271', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3188', '::1', '1598441320', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3189', '::1', '1598441354', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3190', '::1', '1598441385', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3191', '::1', '1598441415', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3192', '::1', '1598441429', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3193', '::1', '1598441484', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3194', '::1', '1598441672', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3195', '::1', '1598441694', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3196', '::1', '1598441708', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3197', '::1', '1598441740', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3198', '::1', '1598441751', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3199', '::1', '1598442987', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3200', '::1', '1598442996', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3201', '::1', '1598443629', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3202', '::1', '1598443633', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3203', '::1', '1598445507', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3204', '::1', '1598445525', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3205', '::1', '1598454294', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3206', '::1', '1598454305', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3207', '::1', '1598500187', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3208', '::1', '1598500631', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3209', '::1', '1598501240', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3210', '::1', '1598501280', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3211', '::1', '1598501511', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3212', '::1', '1598502656', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3213', '::1', '1598502672', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3214', '::1', '1598503673', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3215', '::1', '1598505727', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3216', '::1', '1598507450', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3217', '::1', '1598507499', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3218', '::1', '1598507509', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3219', '::1', '1598524696', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3220', '::1', '1598524698', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3221', '::1', '1598524854', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3222', '::1', '1598526002', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3223', '::1', '1598526981', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3224', '::1', '1598527292', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3225', '::1', '1598527328', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3226', '::1', '1598528278', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3227', '::1', '1598529598', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3228', '::1', '1598530535', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3229', '::1', '1598530545', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3230', '::1', '1598537540', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3231', '::1', '1598537590', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3232', '::1', '1598537933', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3233', '::1', '1598611224', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3234', '::1', '1598614841', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3235', '::1', '1598614865', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3236', '::1', '1598616799', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3237', '::1', '1598616816', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3238', '::1', '1598616940', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3239', '::1', '1598617377', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3240', '::1', '1598619672', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3241', '::1', '1598671073', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3242', '::1', '1598671082', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3243', '::1', '1598672315', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3244', '::1', '1598672337', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3245', '::1', '1598672339', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3246', '::1', '1598674181', 'http://localhost/by3/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3247', '::1', '1598674250', 'http://localhost/by3/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3248', '::1', '1598674260', 'http://localhost/by3/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3249', '::1', '1598674267', 'http://localhost/by3/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3250', '::1', '1598677541', 'http://localhost/by3/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3251', '::1', '1598677545', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3252', '::1', '1598695356', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3253', '::1', '1598697380', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3254', '::1', '1598698764', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3255', '::1', '1598698812', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3256', '::1', '1598698887', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3257', '::1', '1598698917', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3258', '::1', '1598698922', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3259', '::1', '1598698968', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3260', '::1', '1598698970', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3261', '::1', '1598698971', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3262', '::1', '1598698973', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3263', '::1', '1598698974', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3264', '::1', '1598698975', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3265', '::1', '1598698986', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3266', '::1', '1598698987', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3267', '::1', '1598698994', 'http://localhost/by3/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3268', '::1', '1598698995', 'http://localhost/by3/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3269', '::1', '1598755428', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3270', '::1', '1598755438', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3271', '::1', '1598755756', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3272', '::1', '1598755759', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3273', '::1', '1598773703', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3274', '::1', '1598781490', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3275', '::1', '1598785320', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3276', '::1', '1598785348', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3277', '::1', '1598785390', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3278', '::1', '1598785401', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3279', '::1', '1598785495', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3280', '::1', '1598851374', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3281', '::1', '1598851376', 'http://localhost/by3/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3282', '::1', '1598853174', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3283', '::1', '1598853179', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3284', '::1', '1598863408', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3285', '::1', '1598863412', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3286', '::1', '1598868837', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3287', '::1', '1598868840', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3288', '::1', '1598868842', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3289', '::1', '1598868911', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3290', '::1', '1598868927', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3291', '::1', '1598869155', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3292', '::1', '1598869222', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3293', '::1', '1598869222', 'http://localhost/im/index.php/index/user/%3Cpre%3Estring(32)', null);
INSERT INTO `by_flow` VALUES ('3294', '::1', '1598869236', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3295', '::1', '1598869437', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3296', '::1', '1598869466', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3297', '::1', '1598869514', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3298', '::1', '1598869562', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3299', '::1', '1598869562', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDlPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BDieu%EF%BF%BD%D6%9F%EF%BF%BD%EF%BF%BD%D0%B2%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CD%A6%EF%BF%BD%EF%BF%BD%D4%A0%EF%BF%BD%EF%BF%BD%D7%AB%EF%BF%BD%EF%BF%BD%DC%AD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EC%9C%9D%EF%BF%BDzw%EF%BF%BD%EF%BF%BD%EF%BF%BD%DB%8B%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CA%80%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7Fwszz%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDno~%EF%BF%BD%EF%BF%BD%EF%BF%BD%7B%7D%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%C6%9A%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CD%A4%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDw%7F%EF%BF%BD%EF%BF%BD%EF%BF%BD[%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%07YIDATh%EF%BF%BD%C5%9A%EF%BF%BD%EF%BF%BD%EF%BF%BD8%0C%EF%BF%BD%EF%BF%BDI%EF%BF%BDd%12%EF%BF%BD=g%EF%BF%BD%EF%BF%BD%7D%EF%BF%BDw/[%EF%BF%BD$Y%06C%EF%BF%BD%EF%BF%BD%7FuQi%EF%BF%BDF%1F:l%0CJQ]%EF%BF%BD%EF%BF%BD%EF%BF%BDl%EF%BF%BD%EF%BF%BD%EF%BF%BDh%EF%BF%BD%EF%BF%BD%0F%EF%BF%BD%3E', null);
INSERT INTO `by_flow` VALUES ('3300', '::1', '1598869591', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3301', '::1', '1598869591', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7BPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BDN%01z%CD%AB%CF%B1%EF%BF%BD%EF%BF%BD%C9%AB%EF%BF%BD%D2%B0%EF%BF%BD%DB%A5%EF%BF%BD%EF%BF%BD%D0%B7%E0%AC%BC%EF%BF%BD%D7%AD%EF%BF%BD%EF%BF%BD%DF%9B%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDb%EF%BF%BD%EF%BF%BD%EF%BF%BD%CC%A0~%EF%BF%BDw?%EF%BF%BD%C9%BC%DD%8B^%EF%BF%BD%EF%BF%BDh%EF%BF%BDf%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDs%3E%EF%BF%BDZ%15%EF%BF%BDZ%19%EF%BF%BDsI%EF%BF%BD%EF%BF%BDb%EF%BF%BD^%16%EF%BF%BD%7FS%EF%BF%BD%EF%BF%BDX%EF%BF%BD%7FB%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDg%EF%BF%BD%EF%BF%BDS%EF%BF%BD%EF%BF%BD%3E%EF%BF%BDq%EF%BF%BD_%15%EF%BF%BD|%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDg1%EF%BF%BD%EF%BF%BDz%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%07%1FIDATh%EF%BF%BD%D5%9B%0B%EF%BF%BD%EF%BF%BD(%10%C7%9D%C4%9B4%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%EF%BF%BD%EF%BF%BDm%EF%BF%BD%EF%BF%BD%EF%BF%BD%19%1E%EF%BF%BD%EF%BF%BD%06%EF%BF%BD%EF%BF%BD%EF%BF%BDmzo$%EF%BF%BD%EF%BF%BDy0%EF%BF%BDi%EF%BF%BD%EF%BF%BD%EF%BF%BDF%EF%BF%BDG%EF%BF%BDP?%EF%BF%BD%EF%BF%BD\\%EF%BF%BDGt%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%1E%7F%EF%BF%BD%03]\\%EF%BF%BD%EF%BF%BDkT-%EF%BF%BD%EF%BF%BD%EF%BF%BD,%EF%BF%BD%C3%B2%EF%BF%BD%03%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7F%EF%BF%BDr%EF%BF%BD%EF%BF%BD%EF%BF%BD:%EF%BF%BDk%EF%BF%BDG%3E%EF%BF%BDp%EF%BF%BD%EF%BF%BD4%EF%BF%BD\\%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD]S%1F`%CF%A0%13y%03%1E%EF%BF%BD%EF%BF%BD%EF%BF%BD%05%EF%BF%BD9%EF%BF%BD%EF%BF%BD%EF%BF%BDo%EF%BF%BD@%EF%BF%BD%CB%BE:%14cw%EF%BF%BD%EF%BF%BDS%05%EF%BF%BDY%EF%BF%BD%EF%BF%BDQ%EF%BF%BDQpu4|7%EF%BF%BD^%EF%BF%BD%07^C%EF%BF%BD\\%EF%BF%BD%EF%BF%BD%EF%BF%BDa%19%EF%BF%BD8%EF%BF%BDj%EF%BF%BD%3E%EF%BF%BD%EF%BF%BDC%EF%BF%BD%EF%BF%BDf%EF%BF%BDDG%EF%BF%BDW%%D4%99I%7F%EF%BF%BD%EF%BF%BD:C%EF%BF%BDXY%EF%BF%BDRv%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD]w%EF%BF%BDs%3Ez%EF%BF%BD%EF%BF%BDMp)r%EF%BF%BD!g%EF%BF%BD7%EF%BF%BDFC%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD\\.K%EF%BF%BD[=%1EN%EF%BF%BD', null);
INSERT INTO `by_flow` VALUES ('3302', '::1', '1598869689', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7BPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BDN%01z%CD%AB%CF%B1%EF%BF%BD%EF%BF%BD%C9%AB%EF%BF%BD%D2%B0%EF%BF%BD%DB%A5%EF%BF%BD%EF%BF%BD%D0%B7%E0%AC%BC%EF%BF%BD%D7%AD%EF%BF%BD%EF%BF%BD%DF%9B%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDb%EF%BF%BD%EF%BF%BD%EF%BF%BD%CC%A0~%EF%BF%BDw?%EF%BF%BD%C9%BC%DD%8B^%EF%BF%BD%EF%BF%BDh%EF%BF%BDf%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDs%3E%EF%BF%BDZ%15%EF%BF%BDZ%19%EF%BF%BDsI%EF%BF%BD%EF%BF%BDb%EF%BF%BD^%16%EF%BF%BD%7FS%EF%BF%BD%EF%BF%BDX%EF%BF%BD%7FB%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDg%EF%BF%BD%EF%BF%BDS%EF%BF%BD%EF%BF%BD%3E%EF%BF%BDq%EF%BF%BD_%15%EF%BF%BD|%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDg1%EF%BF%BD%EF%BF%BDz%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%07%1FIDATh%EF%BF%BD%D5%9B%0B%EF%BF%BD%EF%BF%BD(%10%C7%9D%C4%9B4%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%EF%BF%BD%EF%BF%BDm%EF%BF%BD%EF%BF%BD%EF%BF%BD%19%1E%EF%BF%BD%EF%BF%BD%06%EF%BF%BD%EF%BF%BD%EF%BF%BDmzo$%EF%BF%BD%EF%BF%BDy0%EF%BF%BDi%EF%BF%BD%EF%BF%BD%EF%BF%BDF%EF%BF%BDG%EF%BF%BDP?%EF%BF%BD%EF%BF%BD\\%EF%BF%BDGt%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%1E%7F%EF%BF%BD%03]\\%EF%BF%BD%EF%BF%BDkT-%EF%BF%BD%EF%BF%BD%EF%BF%BD,%EF%BF%BD%C3%B2%EF%BF%BD%03%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7F%EF%BF%BDr%EF%BF%BD%EF%BF%BD%EF%BF%BD:%EF%BF%BDk%EF%BF%BDG%3E%EF%BF%BDp%EF%BF%BD%EF%BF%BD4%EF%BF%BD\\%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD]S%1F`%CF%A0%13y%03%1E%EF%BF%BD%EF%BF%BD%EF%BF%BD%05%EF%BF%BD9%EF%BF%BD%EF%BF%BD%EF%BF%BDo%EF%BF%BD@%EF%BF%BD%CB%BE:%14cw%EF%BF%BD%EF%BF%BDS%05%EF%BF%BDY%EF%BF%BD%EF%BF%BDQ%EF%BF%BDQpu4|7%EF%BF%BD^%EF%BF%BD%07^C%EF%BF%BD\\%EF%BF%BD%EF%BF%BD%EF%BF%BDa%19%EF%BF%BD8%EF%BF%BDj%EF%BF%BD%3E%EF%BF%BD%EF%BF%BDC%EF%BF%BD%EF%BF%BDf%EF%BF%BDDG%EF%BF%BDW%%D4%99I%7F%EF%BF%BD%EF%BF%BD:C%EF%BF%BDXY%EF%BF%BDRv%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD]w%EF%BF%BDs%3Ez%EF%BF%BD%EF%BF%BDMp)r%EF%BF%BD!g%EF%BF%BD7%EF%BF%BDFC%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD\\.K%EF%BF%BD[=%1EN%EF%BF%BD', null);
INSERT INTO `by_flow` VALUES ('3303', '::1', '1598869709', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3304', '::1', '1598869709', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BD%03%1F%10%D5%97%EF%BF%BD%EF%BF%BD%C5%A1%EF%BF%BD%EF%BF%BD%CC%9F%EF%BF%BD%C3%B1%EF%BF%BD%EF%BF%BD%D5%B3%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CE%B6%EF%BF%BD%D3%BB%EF%BF%BD%C9%A6%D9%B7%EF%BF%BD%C2%99%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%E0%B4%A3%EF%BF%BD%7B%EF%BF%BD%EF%BF%BD]qi?VK!:-OWChjU7=74@Bl[_%EF%BF%BD%EF%BF%BD%EF%BF%BDMQ[%EF%BF%BDy%EF%BF%BD%EF%BF%BD%EF%BF%BDw5D2%EF%BF%BDf%1C1!%1B/)fbtQyid%EF%BF%BD%7FL%3C%EF%BF%BD%EF%BF%BD%EF%BF%BDo~%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDDX\\%182)Zkv.ECTea%170$+B8%EF%BF%BD%EF%BF%BD%EF%BF%BDhvu-S%EF%BF%BD[%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%07%EF%BF%BDIDATh%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD6%10%EF%BF%BD=%EF%BF%BD&amp%EF%BF%BDM$', null);
INSERT INTO `by_flow` VALUES ('3305', '::1', '1598869743', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3306', '::1', '1598869743', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDWPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BDU%EF%BF%BD8%EF%BF%BD%C5%B1%EF%BF%BD%EF%BF%BD%D6%9D%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%C9%BE%EF%BF%BD%EF%BF%BD%D9%B8%C8%A2%D1%9A%E1%A5%B7%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CC%AB%EF%BF%BD%EF%BF%BD%EF%BF%BD%CD%B3%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%7C%EF%BF%BDih%EF%BF%BDP%EF%BF%BD%EF%BF%BD%EF%BF%BDc%EF%BF%BDKq%EF%BF%BD%5E%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDh%EF%BF%BD%EF%BF%BDqy%EF%BF%BDkp%EF%BF%BD%5E%EF%BF%BD%EF%BF%BD%EF%BF%BD9v%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%06hIDATh%EF%BF%BD%CD%9B%EF%BF%BDv%EF%BF%BD(%10E%EF%BF%BDIFHq%EF%BF%BDt%EF%BF%BD%EF%BF%BD%EF%BF%BDw%0E%14%14%EF%BF%BDa%EF%BF%BD8%3E%EF%BF%BD%EF%BF%BD%10%EF%BF%BDJ%EF%BF%BD%12B%EF%BF%BD%EF%BF%BDw%EF%BF%BD%5E%EF%BF%BD+%EF%BF%BD%EF%BF%BD%EF%BF%BD%E1%B0%8B%EF%BF%BD%EF%BF%BDF%EF%BF%BD%EF%BF%BDr%EF%BF%BD%EF%BF%BD%EF%BF%BD~O%EF%BF%BD%EF%BF%BDY%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%02%EF%BF%BDx%EC%A2%9D%EF%BF%BD%EF%BF%BD?%EF%BF%BDd%EF%BF%BDu%EF%BF%BD%04%EF%BF%BD%D4%9B%EF%BF%BDo%3E%039p%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BDX%EF%BF%BD%EF%BF%BD7%EF%BF%BDB]%D0%AD?%D6%A0%1Bv%EF%BF%BD%DA%87N%DC%AAb%EF%BF%BD%1Dd%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%07%EF%BF%BDs%EF%BF%BD%EF%BF%BD%EF%BF%BD', null);
INSERT INTO `by_flow` VALUES ('3307', '::1', '1598869911', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3308', '::1', '1598869911', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3309', '::1', '1598869926', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3310', '::1', '1598869926', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3311', '::1', '1598869930', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3312', '::1', '1598869956', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3313', '::1', '1598870062', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3314', '::1', '1598870063', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3315', '::1', '1598870076', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3316', '::1', '1598870077', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3317', '::1', '1598870078', 'http://localhost/im/index.php/index/user/verify.html?0.2428644326369438', null);
INSERT INTO `by_flow` VALUES ('3318', '::1', '1598870111', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3319', '::1', '1598870112', 'http://localhost/im/index.php/index/user/%EF%BF%BDPNG%1A%EF%BF%BD%EF%BF%BD%EF%BF%BDIHDR%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%3E%08%03%EF%BF%BD%EF%BF%BD%EF%BF%BD5K%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDxPLTE%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDX0%EF%BF%BD%DB%96%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%D8%B2%D9%A9%CD%A5%EF%BF%BD%EF%BF%BD%DD%BC%D7%9E%EF%BF%BD%C3%AE%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%DF%9F%EF%BF%BD%EF%BF%BD%EF%BF%BD%CB%BD%EF%BF%BD%EF%BF%BDlI%EF%BF%BD%EF%BF%BDc%EF%BF%BD%EF%BF%BD%E4%BE%A9%EF%BF%BD%EF%BF%BD%EF%BF%BD%7D%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDoX%EF%BF%BD%EF%BF%BDY%EF%BF%BD%EF%BF%BDu%EF%BF%BDyK%EF%BF%BD%CE%91%EF%BF%BDh=%EF%BF%BD%EF%BF%BD%EF%BF%BD%CB%9C%EF%BF%BD%EF%BF%BDzo%EF%BF%BDbB%EF%BF%BD%EF%BF%BDx%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%CC%AA%EF%BF%BDhA%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BDxN%EF%BF%BDcD%EF%BF%BDh?%EF%BF%BD%EF%BF%BDlq%EF%BF%BDQ4%EF%BF%BD%EF%BF%BD%EF%BF%BDpHYs%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%EF%BF%BD%EF%BF%BD%0E%EF%BF%BD%01%EF%BF%BD+%0E%1B%EF%BF%BD%EF%BF%BD%077IDATh%EF%BF%BD%CD%9B%EF%BF%BD%EF%BF%BD%EF%BF%BD&amp%10F%%EF%BF%BD%EF%BF%BD%EF%BF%BDz%11%02%EF%BF%BD6%EF%BF%BD_%EF%BF%BD6y%EF%BF%BD7,%EF%BF%BDp%19`$!%EF%BF%BDM%EF%BF%BD%EF%BF%BD%1C%C7%B6$%EF%BF%BDa%EF%BF%BDa@%EF%BF%BD0%EF%BF%BD_]%EF%BF%BD%EF%BF%BD%D5%A6%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD8_%EF%BF%BDI]%EF%BF%BD%1AOG%EF%BF%BD%0E%EF%BF%BD,%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%EF%BF%BD%E5%A8%9B%C9%8F%EF%BF%BD', null);
INSERT INTO `by_flow` VALUES ('3320', '::1', '1598870161', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3321', '::1', '1598870162', 'http://localhost/im/index.php/index/user/verify.html', null);
INSERT INTO `by_flow` VALUES ('3322', '::1', '1598870271', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3323', '::1', '1598870317', 'http://localhost/im/index.php/index/user/forget.html', null);
INSERT INTO `by_flow` VALUES ('3324', '::1', '1598952811', 'http://localhost/by3/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3325', '::1', '1599015768', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3326', '::1', '1599015774', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3327', '::1', '1599018030', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3328', '::1', '1599018048', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3329', '::1', '1599018051', 'http://localhost/im/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('3330', '::1', '1599018064', 'http://localhost/im/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('3331', '::1', '1599018329', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3332', '::1', '1599018332', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3333', '::1', '1599018521', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3334', '::1', '1599018530', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3335', '127.0.0.1', '1599018876', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3336', '127.0.0.1', '1599018900', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3337', '127.0.0.1', '1599018902', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3338', '127.0.0.1', '1599018919', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3339', '::1', '1599021742', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3340', '::1', '1599021769', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3341', '::1', '1599021778', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3342', '::1', '1599033893', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3343', '::1', '1599033897', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3344', '::1', '1599033952', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3345', '::1', '1599033956', 'http://localhost/im/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('3346', '::1', '1599033966', 'http://localhost/im/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('3347', '::1', '1599033984', 'http://localhost/im/index.php/index/user/register.html', null);
INSERT INTO `by_flow` VALUES ('3348', '::1', '1599033984', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3349', '::1', '1599045748', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3350', '::1', '1599045752', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3351', '::1', '1599045829', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3352', '::1', '1599045848', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3353', '::1', '1599098759', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3354', '::1', '1599098852', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3355', '::1', '1599101378', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3356', '::1', '1599101385', 'http://localhost/im/index.php/index/user/login.htmlhttp://localhost/im/index.php/plugin/execute/im/_p/im/_c/client/_a/index.html', null);
INSERT INTO `by_flow` VALUES ('3357', '::1', '1599101403', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3358', '::1', '1599101410', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3359', '::1', '1599127921', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3360', '::1', '1599127927', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3361', '::1', '1599128392', 'http://localhost/im/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3362', '::1', '1599128394', 'http://localhost/im/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3363', '::1', '1599131594', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3364', '::1', '1599131597', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3365', '::1', '1599135593', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3366', '::1', '1599135602', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3367', '::1', '1599135607', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3368', '::1', '1599135613', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3369', '::1', '1599149882', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3370', '::1', '1599149894', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3371', '::1', '1599150027', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3372', '::1', '1599150041', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3373', '::1', '1599181891', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3374', '::1', '1599181896', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3375', '::1', '1599181909', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3376', '::1', '1599181918', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3377', '127.0.0.1', '1599182457', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3378', '127.0.0.1', '1599182500', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3379', '::1', '1599183484', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3380', '::1', '1599183490', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3381', '::1', '1599183494', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3382', '::1', '1599185454', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3383', '::1', '1599185455', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3384', '::1', '1599185455', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3385', '::1', '1599185491', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3386', '::1', '1599185941', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3387', '::1', '1599185949', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3388', '::1', '1599185972', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3389', '::1', '1599185984', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3390', '127.0.0.1', '1599186069', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3391', '127.0.0.1', '1599186077', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3392', '127.0.0.1', '1599186410', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3393', '127.0.0.1', '1599186413', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3394', '127.0.0.1', '1599186418', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3395', '127.0.0.1', '1599186433', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3396', '::1', '1599186527', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3397', '::1', '1599186536', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3398', '::1', '1599186542', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3399', '::1', '1599187487', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3400', '::1', '1599187493', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3401', '::1', '1599187501', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3402', '::1', '1599187590', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3403', '127.0.0.1', '1599187594', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3404', '::1', '1599187629', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3405', '::1', '1599187648', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3406', '::1', '1599187659', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3407', '::1', '1599187797', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3408', '::1', '1599187809', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3409', '127.0.0.1', '1599187821', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3410', '127.0.0.1', '1599187864', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3411', '127.0.0.1', '1599199048', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3412', '127.0.0.1', '1599199057', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3413', '127.0.0.1', '1599199096', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3414', '127.0.0.1', '1599200683', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3415', '::1', '1599202075', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3416', '::1', '1599202079', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3417', '::1', '1599214256', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3418', '::1', '1599214262', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3419', '::1', '1599214266', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3420', '::1', '1599228444', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3421', '::1', '1599228448', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3422', '::1', '1599228830', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3423', '::1', '1599228839', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3424', '::1', '1599228856', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3425', '::1', '1599270039', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3426', '::1', '1599270054', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3427', '::1', '1599275390', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3428', '::1', '1599284643', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3429', '::1', '1599284655', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3430', '::1', '1599310535', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3431', '::1', '1599315147', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3432', '::1', '1599315156', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3433', '::1', '1599315839', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3434', '::1', '1599315847', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3435', '::1', '1599316952', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3436', '::1', '1599316960', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3437', '::1', '1599355677', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3438', '::1', '1599355687', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3439', '::1', '1599365183', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3440', '::1', '1599365193', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3441', '::1', '1599365204', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3442', '::1', '1599365222', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3443', '::1', '1599368787', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3444', '::1', '1599368995', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3445', '::1', '1599368999', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3446', '::1', '1599447938', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3447', '::1', '1599452356', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3448', '::1', '1599460539', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3449', '::1', '1599460560', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3450', '::1', '1599536026', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3451', '::1', '1599536044', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3452', '::1', '1599536053', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3453', '::1', '1599536064', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3454', '::1', '1599536067', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3455', '::1', '1599536070', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3456', '::1', '1599536092', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3457', '::1', '1599536110', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3458', '::1', '1599536126', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3459', '::1', '1599536430', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3460', '::1', '1599536434', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3461', '::1', '1599536602', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3462', '::1', '1599536604', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3463', '::1', '1599536612', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3464', '::1', '1599574550', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3465', '::1', '1599575954', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3466', '::1', '1599575955', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3467', '::1', '1599576008', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3468', '::1', '1599576008', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3469', '::1', '1599576065', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3470', '::1', '1599576065', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3471', '::1', '1599610708', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3472', '::1', '1599610708', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3473', '::1', '1599610885', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3474', '::1', '1599610885', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3475', '::1', '1599610929', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3476', '::1', '1599611134', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3477', '::1', '1599611135', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3478', '::1', '1599611402', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3479', '::1', '1599611402', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3480', '::1', '1599611786', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3481', '::1', '1599611787', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3482', '::1', '1599611787', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3483', '::1', '1599611787', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3484', '::1', '1599611787', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3485', '::1', '1599611788', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3486', '::1', '1599611821', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3487', '::1', '1599611821', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3488', '::1', '1599611870', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3489', '::1', '1599611870', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3490', '::1', '1599612612', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3491', '::1', '1599612613', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3492', '::1', '1599612968', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3493', '::1', '1599612968', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3494', '::1', '1599616853', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3495', '::1', '1599623269', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3496', '::1', '1599623272', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3497', '::1', '1599623860', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3498', '::1', '1599624008', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3499', '::1', '1599625522', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3500', '::1', '1599633068', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3501', '::1', '1599633073', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3502', '::1', '1599634229', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3503', '::1', '1599634249', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3504', '::1', '1599641582', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3505', '::1', '1599641588', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3506', '::1', '1599650551', 'http://localhost/im/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3507', '::1', '1599650552', 'http://localhost/im/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3508', '::1', '1599650553', 'http://localhost/im/index.php/index/user/edit.html', null);
INSERT INTO `by_flow` VALUES ('3509', '::1', '1599650559', 'http://localhost/im/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3510', '::1', '1599651029', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3511', '::1', '1599651032', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3512', '::1', '1599651036', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3513', '::1', '1599651135', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3514', '::1', '1599651153', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3515', '::1', '1599651162', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3516', '::1', '1599652307', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3517', '::1', '1599652321', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3518', '::1', '1599652677', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3519', '::1', '1599652680', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3520', '::1', '1599652686', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3521', '::1', '1599659306', 'http://localhost/im/index.php/index/user/index.html', null);
INSERT INTO `by_flow` VALUES ('3522', '::1', '1599705759', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3523', '::1', '1599705775', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3524', '::1', '1599705779', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3525', '::1', '1599705783', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3526', '::1', '1599705788', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3527', '::1', '1599705796', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3528', '::1', '1599720327', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3529', '::1', '1599720333', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3530', '::1', '1599720961', 'http://localhost/im/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3531', '::1', '1599721036', 'http://localhost/im/index.php/index/user/index/id/6.html', null);
INSERT INTO `by_flow` VALUES ('3532', '::1', '1599721118', 'http://localhost/im/index.php/index/user/logout.html', null);
INSERT INTO `by_flow` VALUES ('3533', '::1', '1599721119', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3534', '::1', '1599721121', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3535', '::1', '1599797204', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3536', '::1', '1599815825', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3537', '::1', '1599817722', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3538', '::1', '1599885647', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3539', '::1', '1599885675', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3540', '::1', '1599923085', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3541', '::1', '1600003923', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3542', '::1', '1600003927', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3543', '::1', '1600092185', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3544', '::1', '1600167288', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3545', '::1', '1600167299', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3546', '::1', '1600167311', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3547', '::1', '1600167348', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3548', '::1', '1600171479', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3549', '::1', '1600171489', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3550', '::1', '1600173443', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3551', '::1', '1600173451', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3552', '::1', '1600176255', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3553', '::1', '1600179515', 'http://localhost/im/index.php/index/user/login.html', null);
INSERT INTO `by_flow` VALUES ('3554', '::1', '1600179521', 'http://localhost/im/index.php/index/user/login.html', null);

-- ----------------------------
-- Table structure for by_follow
-- ----------------------------
DROP TABLE IF EXISTS `by_follow`;
CREATE TABLE `by_follow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `appid` varchar(255) NOT NULL DEFAULT '' COMMENT '公众号appid',
  `openid` varchar(255) NOT NULL DEFAULT '' COMMENT '用户OpenId',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `sex` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '性别',
  `city` varchar(255) NOT NULL DEFAULT '' COMMENT '城市',
  `province` varchar(255) NOT NULL DEFAULT '' COMMENT '省份',
  `country` varchar(255) NOT NULL DEFAULT '' COMMENT '国家',
  `language` varchar(50) NOT NULL DEFAULT 'zh_CN' COMMENT '语言',
  `headimgurl` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `subscribe_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '关注时间',
  `mobile` varchar(255) NOT NULL DEFAULT '' COMMENT '手机号',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '用户状态',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户uid',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='公众号粉丝表';

-- ----------------------------
-- Records of by_follow
-- ----------------------------

-- ----------------------------
-- Table structure for by_goods
-- ----------------------------
DROP TABLE IF EXISTS `by_goods`;
CREATE TABLE `by_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) CHARACTER SET utf8 DEFAULT NULL,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `is_specs` tinyint(2) NOT NULL DEFAULT '0',
  `num` int(10) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '1',
  `content` text CHARACTER SET utf8 NOT NULL,
  `category_id` int(10) NOT NULL DEFAULT '110',
  `brand_id` int(10) NOT NULL DEFAULT '0',
  `cover_id` int(10) NOT NULL DEFAULT '1',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `sales` int(10) NOT NULL DEFAULT '0',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00',
  `j_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `attributes` varchar(225) DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  `comments` int(10) NOT NULL DEFAULT '0',
  `baoyou` tinyint(2) NOT NULL DEFAULT '0',
  `has` tinyint(2) NOT NULL DEFAULT '1',
  `attrs` varchar(255) DEFAULT NULL,
  `spress` int(10) DEFAULT '0',
  `collect` int(10) NOT NULL DEFAULT '0',
  `covers` varchar(225) DEFAULT NULL,
  `specs` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `update_time` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `start_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  `is_time` tinyint(2) NOT NULL DEFAULT '0',
  `score` int(10) NOT NULL DEFAULT '0',
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  `pin_max_num` int(10) NOT NULL DEFAULT '0',
  `pin_price` varchar(225) DEFAULT NULL,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `cate_id` int(10) NOT NULL DEFAULT '0',
  `position` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=236 DEFAULT CHARSET=latin1 COMMENT='商品表';

-- ----------------------------
-- Records of by_goods
-- ----------------------------
INSERT INTO `by_goods` VALUES ('163', '陕西精品红富士1kg 80-85mm 苹果 水果', '0', '0', '666', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2CB72sl8lpuFjSspaXXXJKpXa_!!1910146537.jpg\" />', '126', '0', '285', '23.80', '0', '0.00', '0.00', '', '958', '0', '0', '1', '', '0', '0', '286,287,290,291', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '1', '0', '0');
INSERT INTO `by_goods` VALUES ('162', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '1522714009', '0', '100', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB26vh4afNNTKJjSspcXXb4KVXa_!!1910146537.jpg\" />', '58', '0', '282', '0.10', '0', '0.00', '0.00', '', '1102', '0', '0', '1', '', '0', '1', '283,284', '', '1522714009', '1', '1522714009', '1522714009', '0', '0', '0', '0', '', '10', '0', '1');
INSERT INTO `by_goods` VALUES ('164', '泰国龙眼1kg 热带桂圆 进口水果', '0', '0', '122', '1', '<div class=\"col-main tm-clear clearfix\" style=\"margin:0px;padding:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;\">\r\n	<div id=\"mainwrap\" class=\"main-wrap\" style=\"margin:0px 0px 0px 200px;padding:0px;\">\r\n		<div id=\"attributes\" class=\"attributes\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"j-mdv tm-detail-slide\" style=\"margin:0px 0px 10px;padding:0px;\">\r\n				<ol class=\"ks-switchable-content\">\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/dhua?pos=2&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509619719966_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/tfs/TB1xYG8XS_I8KJjy0FoXXaFnVXa-750-291.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/jpde?pos=3&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1508089941480_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i4/1752136151/TB2vvxSa9_I8KJjy0FoXXaFnVXa_!!1752136151.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/shuang11tiqianhaidi2?pos=4&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1510671412227_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i1/2102356460/TB2t4eqXkfb_uJkSnb4XXXCrXXa_!!2102356460.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://chaoshi.tmall.com/activity/hubV2.do?activityKey=6618812d23976bd49e3a5b4a25a6069a&amp;pos=5&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509092263691_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://gw.alicdn.com/tfs/TB1nvrtXLDH8KJjy1XcXXcpdXXa-750-291.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://chaoshi.tmall.com/activity/hubV2.do?activityKey=3250542978ea34ce3ff0a332ad2ae657&amp;pos=6&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509497270317_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2aJeqXgvD8KJjSsplXXaIEFXa_!!1910146537.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n				</ol>\r\n				<ul class=\"ks-switchable-nav\">\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						1\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580 ks-active\" style=\"font-size:14px;background:#B91919;text-align:center;color:#FFFFFF;\">\r\n						2\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						3\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						4\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						5\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						6\r\n					</li>\r\n				</ul>\r\n			</div>\r\n		</div>\r\n		<div id=\"mall-banner\" style=\"margin:0px;padding:0px;\">\r\n		</div>\r\n		<div id=\"J_DcTopRightWrap\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n		</div>\r\n		<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"content ke-post\" style=\"margin:10px 0px 0px;padding:0px;font-size:14px;font-family:tahoma, arial, 宋体, sans-serif;\">\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"maijsoft_s1_145813_start\"></a>\r\n				</div>\r\n				<p>\r\n					<a target=\"_blank\" href=\"https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=1910146537&amp;activityId=04f6b0278d824691924bd57eaaa44e71\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2w026aS_I8KJjy0FoXXaFnVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /></a>\r\n				</p>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"maijsoft_s1_145813_end\"></a>\r\n				</div>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2dpfvXxbxQeBjy1XdXXXVBFXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2w7ZLsbBkpuFjy1zkXXbSpFXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2GA0QsB0kpuFjSsppXXcGTXXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/1910146537/TB24KI8sbXlpuFjSszfXXcSGXXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2dFVbsB0kpuFjy1zdXXXuUVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2MD38sl0kpuFjSsziXXa.oVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB28x4GsrVkpuFjSspcXXbSMVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/1910146537/TB2z2wsaVXXXXaJXpXXXXXXXXXX_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_5_17546621_start\"></a>\r\n				</div>\r\n				<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"margin:0px auto;padding:0px;border-collapse:separate;\" class=\"ke-zeroborder\">\r\n					<tbody>\r\n						<tr>\r\n							<td>\r\n								<div style=\"margin:0px;padding:0px;\">\r\n									<div style=\"margin:0px;padding:0px;\">\r\n										<img alt=\"自定义 20171025\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB28Gn8m6uhSKJjSspdXXc11XXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n									</div>\r\n								</div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_5_17546621_end\"></a>\r\n				</div>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_6_17546631_start\"></a>\r\n				</div>\r\n				<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"margin:0px auto;padding:0px;border-collapse:separate;\" class=\"ke-zeroborder\">\r\n					<tbody>\r\n						<tr>\r\n							<td>\r\n								<div style=\"margin:0px;padding:0px;\">\r\n									<div style=\"margin:0px;padding:0px;\">\r\n										<img alt=\"自定义 20171025\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2GV53rgoQMeJjy0FoXXcShVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n									</div>\r\n								</div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_6_17546631_end\"></a>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div id=\"J_DcBottomRightWrap\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_DcBottomRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n			<div id=\"J_ZebraPriceDesc\" class=\"j-mdv\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n		</div>\r\n		<div id=\"J_Detail\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_Reviews\" class=\"J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n				<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					累计评价\r\n				</h4>\r\n			</div>\r\n			<div id=\"J_SellerInfo\" class=\"J_DetailSection tb-sellerinfo\" style=\"margin:0px;padding:0px;\">\r\n				<h5 class=\"hd\" style=\"font-size:12px;font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					店铺30天服务情况\r\n				</h5>\r\n			</div>\r\n			<div id=\"J_chaoshiService\" class=\"j-mdv J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n				<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					售后服务\r\n				</h4>\r\n			</div>\r\n			<div id=\"official-remind\" class=\"j-mdv\" style=\"margin:20px 0px 0px;padding:10px;background-color:#FFFFE5;border:1px solid #FFCC7F;\">\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"col-sub\" style=\"margin:0px 0px 0px -1190px;padding:0px;background:0px 0px #FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n	<div class=\"j-mdv tm-detail-chaoshibanner\" style=\"margin:0px;padding:0px;\">\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://pages.tmall.com/wow/chaoshi/act/miyou?spm=a312d.7832034.0.0.6bbc9edbVDoCjX&amp;pos=1&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1509048545563_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i3/771510470/TB2kiHYdbglyKJjSZFuXXaE6FXa-771510470.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://content.tmall.com/wow/pegasus/subject/1/725677994/8599322?site=ALL&amp;pos=2&amp;channel=chaoshi&amp;acm=201505271.1003.2.2452353&amp;id=8599322&amp;scm=1003.2.201505271.OTHER_1511483250704_2452353&amp;gccpm=0.815.2.subject-chaoshi-2004.709074&amp;wh_channel=chaoshi4\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i2/52660971/TB2D6RdrwoQMeJjy0FoXXcShVXa_!!52660971.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://pages.tmall.com/wow/chaoshi/act/jiunuanxaingrong?spm=a312d.7832034.0.0.3106884fxCrxi0&amp;pos=3&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1510582082862_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/tfs/TB1aPAaXL2H8KJjy0FcXXaDlFXa-188-170.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div>\r\n			<br />\r\n		</div>\r\n	</div>\r\n	<div class=\"tm-chaoshi-hot J_CSRecommend\" style=\"margin:33px 0px 0px;padding:0px;\">\r\n	</div>\r\n</div>', '58', '0', '292', '19.90', '0', '0.00', '0.00', '', '280', '0', '0', '1', '', '0', '1', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('165', '新农哥五香花生136g 坚果炒货小吃', '1522089611', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2htJEmHVkpuFjSspcXXbSMVXa_!!725677994.jpg\" />', '161', '0', '293', '8.90', '0', '0.00', '0.00', '', '266', '0', '0', '1', '', '0', '0', '294', '', '1522089611', '1', '1522089611', '1522089611', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('166', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '0', '0', '23', '1', '<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i2/725677994/TB2XBSkXr5K.eBjy0FfXXbApVXa_!!725677994.jpg\" />\r\n</p>\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2LB13gsPRfKJjSZFOXXbKEVXa_!!725677994.jpg\" />\r\n</p>', '162', '0', '295', '30.00', '0', '0.00', '0.00', '', '397', '0', '0', '1', '', '0', '4', '296,297,298,299', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('167', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '0', '0', '333', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2i3kzbvBNTKJjy0FdXXcPpVXa_!!725677994.jpg\" />', '161', '0', '300', '34.00', '0', '0.00', '0.00', '', '509', '0', '0', '1', '', '0', '0', '301', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '10', '0', '0');
INSERT INTO `by_goods` VALUES ('168', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '0', '0', '10', '1', '<div class=\"tm-chaoshi-nav nav-float\" style=\"margin:0px;padding:0px;background-color:#FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n	<div class=\"layout\" style=\"margin:0px auto;padding:0px;\">\r\n		<div id=\"nav-bar\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"nav-cont\" style=\"margin:0px;padding:0px;\">\r\n				<ul>\r\n					<li class=\"qc\">\r\n						<div class=\"col-main tm-clear clearfix\" style=\"margin:0px;padding:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;\">\r\n							<div id=\"mainwrap\" class=\"main-wrap\" style=\"margin:0px 0px 0px 200px;padding:0px;\">\r\n								<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\" style=\"margin:0px;padding:0px;\">\r\n									<div class=\"content ke-post\" style=\"margin:10px 0px 0px;padding:0px;font-size:14px;font-family:tahoma, arial, 宋体, sans-serif;\">\r\n										<p>\r\n											<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/725677994/TB2gluhXraI.eBjSszdXXaB6XXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2ptqkXB9J.eBjy0FoXXXyvpXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/725677994/TB2sXGZXxaK.eBjSZFBXXagMXXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/725677994/TB23XaiXr1J.eBjSspnXXbUeXXa_!!725677994.jpg\" class=\"img-ks-lazyload\" />\r\n										</p>\r\n									</div>\r\n								</div>\r\n								<div id=\"J_DcBottomRightWrap\" style=\"margin:0px;padding:0px;\">\r\n									<div id=\"J_DcBottomRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n									</div>\r\n									<div id=\"J_ZebraPriceDesc\" class=\"j-mdv\" style=\"margin:0px;padding:0px;\">\r\n										<img width=\"790\" src=\"https://img.alicdn.com/tfs/TB1H9BARpXXXXc1XpXXXXXXXXXX-1420-274.png\" />\r\n									</div>\r\n								</div>\r\n								<div id=\"J_Detail\" style=\"margin:0px;padding:0px;\">\r\n									<div id=\"J_Reviews\" class=\"J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n										<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											累计评价&nbsp;<span class=\"J_ReviewsCount\">9932</span>\r\n										</h4>\r\n										<div class=\"tm-rate\" style=\"margin:0px;padding:0px;\">\r\n											<div class=\"rate-header rate-header-tags\" style=\"margin:0px;padding:10px 0px;border:1px solid #C8C8C8;\">\r\n												<div class=\"rate-score\" style=\"margin:0px;padding:0px 20px;vertical-align:top;text-align:center;\">\r\n													<h4 style=\"font-weight:100;\">\r\n														与描述相符\r\n													</h4>\r\n<span style=\"color:#FF6600;font-family:arial;font-size:32px;line-height:32px;\">4.8</span>\r\n													<p style=\"text-align:left;\">\r\n														<span class=\"score-value-no score-value-4d8\" style=\"background:url(&quot;\"><span style=\"background:url(&quot;\"></span></span>\r\n													</p>\r\n												</div>\r\n												<div class=\"rate-tag-box\" style=\"margin:0px;padding:0px;vertical-align:top;\">\r\n													<div class=\"rate-tag-label\" style=\"margin:4px 0px 0px;padding:0px 12px 0px 25px;vertical-align:top;color:#CCCCCC;font-size:11px;background:url(&quot;\">\r\n														<span>大家都写到</span>\r\n													</div>\r\n													<div class=\"rate-tag-list\" style=\"margin:0px;padding:0px;vertical-align:top;\">\r\n														<div class=\"rate-tag-inner\" style=\"margin:0px;padding:0px;\">\r\n															<span class=\"tag-posi\"><a id=\"ratetag807_420a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">物流快(8)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_620a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">质量好(4)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_520a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">便宜(3)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_10420a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">发货快(3)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_637a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">保质期(3)<s></s></a></span>\r\n														</div>\r\n													</div>\r\n<span class=\"rate-tag-toggle\" style=\"vertical-align:top;background:url(&quot;\"></span>\r\n												</div>\r\n											</div>\r\n											<div class=\"rate-compose\" style=\"margin:0px;padding:0px;\">\r\n											</div>\r\n											<div class=\"rate-charts\" style=\"margin:0px;padding:0px;background:#F4F4F4;\">\r\n											</div>\r\n											<div class=\"rate-toolbar\" style=\"margin:0px;padding:5px 10px;background:#EFEFEF;border:1px solid #C8C8C8;text-align:right;\">\r\n												<span class=\"rate-filter\">全部追评 (15)图片 (136)</span><span class=\"tm-toolbar-lft\"><span class=\"tm-rate-addin\"></span>有内容\r\n												<div class=\"rate-sort \" style=\"margin:0px;padding:0px;\">\r\n													<div class=\"tm-selectbtn tm-rate-sort\" style=\"margin:0px;padding:0px 5px;text-align:center;\">\r\n														<span class=\"tm-current\" style=\"background:url(&quot;line-height:20px;\">按默认</span>\r\n													</div>\r\n												</div>\r\n</span>\r\n											</div>\r\n											<div class=\"rate-grid\" style=\"margin:0px;padding:0px;\">\r\n												<table style=\"margin:0px;padding:0px;width:790px;\">\r\n													<tbody>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		家中常备巧克力，快递给力，满意\r\n																	</div>\r\n																	<div class=\"tm-m-photos\" style=\"margin:0px;padding:0px;\">\r\n																		<ul class=\"tm-m-photos-thumb\">\r\n																			<li>\r\n																				<img src=\"https://img.alicdn.com/bao/uploaded/i1/0/TB29YYYXSfD8KJjSszhXXbIJFXa_!!0-rate.jpg_40x40.jpg\" style=\"width:40px;height:40px;\" /><b class=\"tm-photos-arrow\"></b>\r\n																			</li>\r\n																		</ul>\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.30\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	n***n（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		九月份生产的，挺新鲜的。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.31\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	老***0（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很快，不错，跟超市价格一样\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.29\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	武***7（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		巧克力很好吃，日期是最近的新日期，店家很用心包装裹了厚厚的泡沫塑料来保护盒子。感谢老板。祝你生意兴隆。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	t***3（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很不错哦，买给朋友的小礼物\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	11.02\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	1***c（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		口感不错 发货速度快\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.30\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	小***怀（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		包裹包装的很好 东西送人的 量也比较足 很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	高***1（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		送女朋友的。看着很不错的\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.26\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	赵***4（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		送人不知道礼盒坏没有\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	11.01\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	j***v（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		今天去家乐福超市看到了相同的巧克力，没有特价和任何活动卖105，天猫卖115还不参加满减活动，原来价格比超市贵那么多啊～真是长经验了\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	生***彩（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		口味不错，送给我爱的她！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.26\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	脱***光（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		中秋节当天，上午9点多才下单，下午4点就收到了，买了很多东西正好赶上能送人，不耽误事，太好了。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.17\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	m***6（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		天猫超市太方便啦\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.21\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	c***y（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		天猫超市几乎每个月都必须买点东西，快捷方便，适合现在的生活，超市没有啥竞争力了，感谢天猫给我们带来的便捷。东西都很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.09\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	s***公（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很好……一会儿吃没了\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	t***6（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		不错，很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	j***9（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		日期比较新鲜\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.15\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	高***9（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		给别人买的，具体不详，应该还不错\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.11\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	a***f（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		还是那个味道！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	调***苗（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		味道很好！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.10\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	亲***9（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n													</tbody>\r\n												</table>\r\n											</div>\r\n											<div class=\"rate-page\" style=\"margin:0px;padding:0px;\">\r\n												<div class=\"rate-paginator\" style=\"margin:20px 30px 0px 0px;padding:20px 0px 10px;text-align:right;background:url(&quot;\">\r\n													<span class=\"rate-page-prev\" style=\"vertical-align:top;line-height:27px;color:#999999;font-size:14px;\">&lt;&lt;上一页</span><span style=\"vertical-align:top;line-height:27px;color:#999999;font-size:14px;\">1</span><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=2\">2</a><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=3\">3</a><span class=\"rate-page-break\" style=\"vertical-align:top;line-height:20px;color:#999999;font-size:14px;\">...</span><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=2\">下一页&gt;&gt;</a>\r\n												</div>\r\n											</div>\r\n											<div class=\"rate-tryreport\" style=\"margin:0px;padding:0px;\">\r\n												<div class=\"tm-trygrid\" style=\"margin:0px;padding:0px;\">\r\n												</div>\r\n												<div class=\"tm-trypage\" style=\"margin:0px;padding:0px;\">\r\n												</div>\r\n											</div>\r\n										</div>\r\n									</div>\r\n									<div id=\"J_SellerInfo\" class=\"J_DetailSection tb-sellerinfo\" style=\"margin:0px;padding:0px;\">\r\n										<h5 class=\"hd\" style=\"font-size:12px;font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											店铺30天服务情况\r\n										</h5>\r\n									</div>\r\n									<div id=\"J_chaoshiService\" class=\"j-mdv J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n										<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											售后服务\r\n										</h4>\r\n									</div>\r\n									<div id=\"official-remind\" class=\"j-mdv\" style=\"margin:20px 0px 0px;padding:10px;background-color:#FFFFE5;border:1px solid #FFCC7F;\">\r\n									</div>\r\n								</div>\r\n							</div>\r\n						</div>\r\n						<div class=\"col-sub\" style=\"margin:0px 0px 0px -1190px;padding:0px;background:0px 0px #FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n							<div class=\"j-mdv tm-detail-chaoshibanner\" style=\"margin:0px;padding:0px;\">\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://pages.tmall.com/wow/chaoshi/act/miyou?spm=a312d.7832034.0.0.6bbc9edbVDoCjX&amp;pos=1&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1509048545563_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i3/771510470/TB2kiHYdbglyKJjSZFuXXaE6FXa-771510470.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://content.tmall.com/wow/pegasus/subject/1/725677994/8599322?site=ALL&amp;pos=2&amp;channel=chaoshi&amp;acm=201505271.1003.2.2452353&amp;id=8599322&amp;scm=1003.2.201505271.OTHER_1511483250704_2452353&amp;gccpm=0.815.2.subject-chaoshi-2004.709074&amp;wh_channel=chaoshi4\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i2/52660971/TB2D6RdrwoQMeJjy0FoXXcShVXa_!!52660971.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://pages.tmall.com/wow/chaoshi/act/jiunuanxaingrong?spm=a312d.7832034.0.0.3106884fxCrxi0&amp;pos=3&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1510582082862_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/tfs/TB1aPAaXL2H8KJjy0FcXXaDlFXa-188-170.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div>\r\n									<br />\r\n								</div>\r\n							</div>\r\n							<div class=\"tm-chaoshi-hot J_CSRecommend\" style=\"margin:33px 0px 0px;padding:0px;\">\r\n							</div>\r\n						</div>\r\n<br />\r\n					</li>\r\n				</ul>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>', '162', '0', '302', '99.00', '0', '0.00', '0.00', '', '718', '0', '0', '1', '', '0', '0', '303', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '10', '0', '0');
INSERT INTO `by_goods` VALUES ('169', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '0', '0', '77', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/725677994/TB2zoRnXwL8F1JjSspjXXbZgpXa_!!725677994.jpg\" /><br />\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2Zfb9XC69F1JjSZFOXXXK.VXa_!!725677994.jpg\" />\r\n</p>', '161', '0', '304', '77.00', '0', '0.00', '0.00', '', '571', '0', '0', '1', '', '0', '1', '305,306', '', '0', '0', '0', '0', '0', '0', '0', '0', '', '10', '0', '0');
INSERT INTO `by_goods` VALUES ('170', '【低至5488元】Apple/苹果iPhone 8 Plus ', '1522089719', '0', '5675', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2616970884/TB2giEVgU3IL1JjSZFMXXajrFXa-2616970884.jpg\" />', '110', '0', '307', '5488.00', '0', '0.00', '0.00', '176,171', '1168', '0', '0', '1', '164,169', '0', '0', '309', '2G,3G,4G,6G,16G,32G,64G', '1522089719', '1', '1522089719', '1522089719', '0', '0', '0', '0', '', '10', '0', '0');
INSERT INTO `by_goods` VALUES ('171', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', '0', '0', '5677', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/1114511827/TB2sogiXTnI8KJjSszbXXb4KFXa_!!1114511827.jpg\" />', '110', '0', '310', '5676.00', '0', '0.00', '0.00', '', '163', '0', '0', '1', '', '0', '0', '311', '2G,4G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('172', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '0', '0', '343', '1', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '110', '0', '313', '34.00', '0', '0.00', '0.00', '175,171,182,195,208', '192', '0', '0', '1', '164,169,180,194,203', '0', '0', '312', '2G,3G,4G,6G,16G', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('173', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '0', '0', '345', '1', '<img src=\"https://gdp.alicdn.com/imgextra/i2/2838892713/TB2wSW3hO0TMKJjSZFNXXa_1FXa_!!2838892713.jpg\" alt=\"\" class=\"img-ks-lazyload\" border=\"0\" />', '110', '0', '314', '345.00', '0', '0.00', '0.00', '', '204', '0', '0', '1', '', '0', '0', '315', '4G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('174', 'OPPO R11S全面屏拍照4G手机oppor11s', '0', '0', '56', '1', '<img alt=\"\" src=\"https://img.alicdn.com/imgextra/i2/901409638/TB2yUIiaDnI8KJjSszbXXb4KFXa_!!901409638.jpg\" class=\"img-ks-lazyload\" />', '110', '0', '316', '345.00', '0', '0.00', '0.00', '175,171', '203', '0', '0', '1', '164,169', '0', '0', '317,318', '2G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('175', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '0', '0', '345', '1', '<h1>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/454291526/TB2TMxQXx685uJjSZFHXXc49pXa-454291526.jpg\" class=\"img-ks-lazyload\" />\r\n</h1>', '129', '0', '320', '34.00', '0', '0.00', '0.00', '', '755', '0', '0', '1', '', '0', '0', '321,322', '红色,蓝色,x,xl,xxl', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('176', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '0', '0', '1232', '1', '<img alt=\"217309501_G01.jpg\" src=\"https://img.alicdn.com/imgextra/i1/305358018/TB2fHPhXtLO8KJjSZFxXXaGEVXa-305358018.jpg\" class=\"img-ks-lazyload\" />', '129', '0', '323', '21.00', '0', '0.00', '0.00', '85', '100', '0', '0', '1', '84', '0', '0', '324', '红色,白色,xl,xxl', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('177', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '0', '0', '345', '1', '<h1>\r\n	<br />\r\n</h1>\r\n<h1>\r\n	<table width=\"876\" class=\"ke-zeroborder\" style=\"border-collapse:collapse;font-size:12.0px;font-family:微软雅黑;text-align:center;color:#ff0000;width:790.0px;font-weight:bold;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n		<tbody>\r\n			<tr>\r\n				<td width=\"79\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>套餐</strong></span></span> \r\n				</td>\r\n				<td width=\"92\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\">处理器</span></span> \r\n				</td>\r\n				<td width=\"54\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>内存</strong></span></span> \r\n				</td>\r\n				<td width=\"97\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>硬盘</strong></span></span> \r\n				</td>\r\n				<td width=\"167\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>显卡</strong></span></span> \r\n				</td>\r\n				<td width=\"108\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"font-size:14.0px;\">分辨率</span> \r\n				</td>\r\n				<td width=\"90\" style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"font-size:14.0px;\">银色/金色<br />\r\n新品价</span> \r\n				</td>\r\n				<td width=\"102\" bgcolor=\"#ffffff\">\r\n					<p>\r\n						<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">粉色<br />\r\n<span style=\"color:#ff0000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">新品</span>价</span></span>\r\n					</p>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">官方标配</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">500G机械</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"> \r\n					<div>\r\n						&nbsp;GeForce&nbsp;940MX\r\n					</div>\r\n</span></span></span><span style=\"color:#000000;\"><strong><span style=\"font-size:14.0px;\"><span style=\"font-size:16.0px;\">2G独显</span></span></strong></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span></span> \r\n				</td>\r\n				<td bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥4799</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>￥5099</strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">标准套餐</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">128G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"> \r\n					<div>\r\n						&nbsp;GeForce&nbsp;940MX\r\n					</div>\r\n</span></span></span><span style=\"color:#000000;\"><strong><span style=\"font-size:14.0px;\"><span style=\"font-size:16.0px;\">2G独显</span></span></strong></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">14英寸</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">1920*1080</span></strong><strong><br />\r\n</strong></span></span> \r\n				</td>\r\n				<td bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5099</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>￥5399</strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐一</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">256G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">特惠</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">￥5349</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><strong><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">特惠</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">￥5649</span></strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐二</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"color:#000000;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">128G固态</span></span>\r\n					</p>\r\n					<p style=\"color:#000000;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械<br />\r\n</span>\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-weight:bold;line-height:20.0px;\">￥5349</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5649</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐三</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">256G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5549</span></span> \r\n				</td>\r\n				<td style=\"color:#0000ff;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5849</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐四</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"color:#0000ff;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#0000ff;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">128G固态</span></span>\r\n					</p>\r\n					<p style=\"color:#0000ff;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#0000ff;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械<br />\r\n</span>\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">玩家推荐</span><span style=\"font-size:14.0px;\"><span style=\"font-weight:bold;line-height:20.0px;\"><br />\r\n￥5549</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">玩家推荐<br />\r\n￥5849</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐五</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"font-size:14.0px;\">\r\n						<span style=\"color:#333333;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">240G固态</span>\r\n					</p>\r\n					<p style=\"font-size:14.0px;\">\r\n						<span style=\"color:#333333;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5749</span></span> \r\n				</td>\r\n				<td style=\"color:#0000ff;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥6049</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;text-align:left;\" bgcolor=\"#ffffff\" colspan=\"8\">\r\n					<ul style=\"color:#ff0000;\">\r\n						<li>\r\n							注：1.（升级内存/硬盘为买家个人定制需求，升级后可能与原标识配置不一样）~~~~~【详情请咨询客服】<br />\r\n2.网页链接默认为官方标配，根据买家购买配置不同，实际发货以套餐为准，敬请谅解！\r\n						</li>\r\n					</ul>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</h1>\r\n<h1>\r\n	<br />\r\n</h1>\r\n<h1>\r\n	<img align=\"absmiddle\" class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i2/133668489/TB2Xn2Ybyb_F1JjSZFzXXc6KXXa_!!133668489.jpg\" />\r\n</h1>', '160', '0', '325', '34.00', '0', '0.00', '0.00', '', '258', '0', '0', '1', '', '0', '0', '', '黑,白,金,官方标配,套餐1,套餐2', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('178', 'OPPO耳机原装正品全球限量版', '1509832095', '0', '100', '1', '567', '158', '0', '326', '39.90', '0', '0.00', '0.00', '', '276', '0', '0', '1', '', '0', '0', '', '', '1509832095', '1', '1523618826', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('179', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '1521765481', '0', '657', '1', '<img align=\"absmiddle\" class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i4/2736964691/TB2PLy_tmBjpuFjSsplXXa5MVXa_!!2736964691.jpg\" />', '156', '0', '327', '5399.00', '0', '0.00', '0.00', '', '1246', '0', '0', '1', '', '0', '0', '', '黑,白,官方标配,套餐1,1g,2g', '1521765481', '1', '1521765481', '1521765481', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('180', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '1509907402', '0', '122', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2228361831/TB2wBjGboF7MKJjSZFLXXcMBVXa_!!2228361831.jpg\" />', '118', '0', '329', '34.00', '0', '0.00', '0.00', '', '101', '0', '0', '1', '', '0', '0', '', '', '1509907402', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('181', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '1509907480', '0', '23', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2228361831/TB2SZHaqlUSMeJjy1zkXXaWmpXa_!!2228361831.jpg\" />', '118', '0', '330', '223.00', '0', '0.00', '0.00', '', '101', '0', '0', '1', '', '0', '1', '', '', '1509907480', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('182', 'ZARA 男装 绒面质感裤子 06706310707', '1509907548', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/2228361831/TB2Iy1_XPqhSKJjSspnXXc79XXa_!!2228361831.jpg\" />', '118', '0', '331', '233.00', '0', '0.00', '0.00', '', '215', '0', '0', '1', '', '0', '0', '', '', '1509907548', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('183', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '1509907754', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB2BHApdbVkpuFjSspcXXbSMVXa_!!133227658.gif\" />', '118', '0', '332', '234.00', '0', '0.00', '0.00', '', '136', '0', '0', '1', '', '0', '0', '', '', '1509907754', '1', '1523618788', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('184', '阿迪达斯男裤2017冬季小脚运动裤保暖', '1509908052', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB250MNmbwTMeJjSszfXXXbtFXa_!!133227658.jpg\" /><img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB250MNmbwTMeJjSszfXXXbtFXa_!!133227658.jpg\" /><img src=\"https://img.alicdn.com/imgextra/i1/133227658/TB2vgBrmrsTMeJjSszhXXcGCFXa_!!133227658.jpg\" />', '163', '0', '333', '123.00', '0', '0.00', '0.00', '', '145', '0', '0', '1', '', '0', '0', '', '蓝色,白色,x,xl,xxl', '1509908052', '1', '1523618799', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('185', '阿迪达斯长裤男 2017秋季新款运动裤针织', '1509908153', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/1993730769/TB2R2ZaXz2lJKJjSszcXXaopVXa_!!1993730769.gif\" />', '163', '0', '334', '234.00', '0', '0.00', '0.00', '', '861', '0', '0', '1', '', '0', '0', '335,336', '红色,蓝色,x,xl', '1509908153', '1', '1523618778', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('186', '正版书籍包邮 龙应台人生三书', '1509909138', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/750751837/TB21C._krtlpuFjSspoXXbcDpXa_!!750751837.jpg\" />', '88', '0', '338', '234.00', '0', '0.00', '0.00', '', '445', '0', '0', '1', '', '0', '0', '339', '', '1509909138', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('187', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '1509909317', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/1049653664/TB2CpM4kXXXXXbjXpXXXXXXXXXX_!!1049653664.jpg\" />', '88', '0', '341', '234.00', '0', '0.00', '0.00', '', '123', '0', '0', '1', '', '0', '0', '', '', '1509909317', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('188', '国家图书奖朱自清散文集徐志摩经典大全集', '1509909415', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2374668160/TB2dsI4lr_0UKFjy1XaXXbKfXXa_!!2374668160.jpg\" />', '88', '0', '343', '234.00', '0', '0.00', '0.00', '', '118', '0', '0', '1', '', '0', '0', '', '', '1509909415', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('189', '罗辑思维官方 今天故事书', '1509909506', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2760223904/TB2pUYZbZtnpuFjSZFKXXalFFXa-2760223904.png\" />', '88', '0', '344', '234.00', '0', '0.00', '0.00', '', '296', '0', '0', '1', '', '0', '0', '', '', '1509909506', '1', '1523618734', '0', '0', '0', '0', '0', '', '10', '0', '2');
INSERT INTO `by_goods` VALUES ('190', '【亚马逊图书】王小波文集：黄金时代+青铜时代+', '1509909593', '0', '324', '1', '<img src=\"https://img.alicdn.com/bao/uploaded/TB1NZwQorsTMeJjSszhXXcGCFXa_!!0-item_pic.jpg_250x250.jpg\" />', '88', '0', '345', '34.00', '0', '0.00', '0.00', '', '122', '0', '0', '1', '', '0', '0', '', '', '1509909593', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('191', '布鲁克林有棵树正版包邮(美)史密斯著', '1509909668', '0', '123', '1', '<span style=\"color:#666666;font-family:tahoma, arial, 宋体, sans-serif;background-color:#FFFFFF;\">第一章 宁静这个词用于纽约布鲁克林恰如其分。尤其是在1912年的夏天。沉静这个词大概更好些，只是对布鲁克林的威廉斯堡不大合适。大草原的可爱，雪兰多的悦耳，用于布鲁克林都不合适。只能用宁静这个词，特别是夏日的一个星期六下午。 下午的斜阳照在弗兰西·诺兰家爬满苔藓的院子里，把破旧的木篱笆晒得暖暖的。看着斜射下来的一缕缕阳光，弗兰西心头涌出一种美好的感觉来。这样的感觉，她回忆起一首诗歌时也有过。这诗她在学校里背诵过，是这样的： 这里是原始森林 松树和铁杉，低语阵阵 苔藓如须，翠绿满身 黄昏中伫立，依稀朦胧 如一个个德鲁伊老僧 弗兰西院子里的树既不是松树，也不是铁杉。树上的绿色枝条从树干向四周发散，枝条上长满了尖尖的叶子，整棵树看起来如同无数撑开的绿伞。有人称之为天堂树。不管它的种子落到什么地方，都会长出一棵树来，向着天空，努力生长。这树长在四周围满木篱的空场子里，或是从无人留意的垃圾堆里钻出来；它也是唯一能在水泥地里长出来的树。它长得很茂盛，而且只在居民区长。 星期天下午，你去散散步，走到一个不错的居民区，挺高档的居民区。你会从通往人家院子的铁门中看见这样一棵小树，这时候你就知道，布鲁克林这一带会变成居民区了。树懂。树会打前站。到了后来，渐渐会有些贫穷的外国人跑过来，把破旧的褐砂石房子修理成平房。他们把羽毛褥垫从窗户里推出来晒。天堂树长得郁郁葱葱。这种树就这习性。它喜欢穷人。 弗兰西院子里长的就是这种树。在她的三楼太平梯附近，树上的小“伞”一个个蜷曲过来。一个坐在太平梯上的十一岁女孩会觉得自己住在树上。夏天的每个星期六下午，弗兰西都是这么想象的。 啊，布鲁克林的星期六多么美好。啊，到处都是那么美好！人们星期六照样能领薪水。星期六是个周末假日，却又不要守星期天那些清规戒律。人们有钱出去买东西。他们这一天会好好吃上一顿饭，喝醉，约会，做爱，熬夜，唱歌，放音乐，打架，跳舞，因为次日会有自由自在的一天，可以睡个懒觉，至少可以睡到晚场的弥撒。 星期天，大部分人会挤着去参加十一点钟的弥撒。怎么说呢，也有一些人，很少一些，会去参加六点钟的那一场。人们夸他们赶得早，其实他们不配这样的夸奖，因为他们本来是在外头呆得太久，回到家的时候，都是早晨了。他们于是去这场弥撒，应付过去，把罪给洗了，然后回家安安心心睡一天大觉。 弗兰西的星期六，是从去垃圾回收站开始的。和其他布鲁克林小孩一样，她和弟弟尼雷会在外头捡些布头、纸张、金属、橡胶等破烂，藏在地下室的箱子里，上着锁，或是藏在床底下。从星期一到星期五，每天放学回家的路上，弗兰西会慢慢走，边走边看排水沟，希望找到烟盒的锡纸，或是口香糖的包装纸。回头她会将这些放在一个小罐子的盖子里头熔化。垃圾站不收没有熔化的锡球，因为很多孩子会将铁垫圈放在中间抵重量。有时候，尼雷会找到一个苏打水壶。弗兰西会帮他把壶嘴弄下来，熔化出其中的铅来。垃圾站的人怕苏打水公司的人找麻烦，不敢回收完整的壶嘴。壶嘴是好货。化掉后，能卖五分钱。 弗兰西和尼雷每天晚上都到地下室，把升降机架子上当日收的破烂全倒出来。弗兰西和尼雷的妈妈是清洁工，所以两个孩子享有这项特权，能下到地下室去。他们会把架子上的纸张、布头和能回收的瓶子全都拿走。纸张不值什么钱，十磅才能卖一分钱。布头一磅两分钱，铁是一磅四分钱。铜是好货，一磅能卖一毛钱。有时候，弗兰西会撞上大运，找到废弃的煮衣锅锅底。她会用开罐器将它掰下来，折起，捶打，再折，再捶打。 星期六早晨九点一过，孩子们就从大街小巷钻出来，纷纷涌到主干道曼哈顿大道上。他们沿着曼哈顿大道，慢慢走到斯科尔斯街。有的孩子把破烂直接拿在手上。有的拖着木头做的肥皂包装盒，盒子下头装有很稳当的木头轮子。还有几个推着童车，里面装得满满的。 弗兰西和尼雷两个人把破烂装进一只麻袋里，一人拎一只角，在街上拖着走，沿着曼啥顿大道，路过茂吉街、滕·艾耶克街、斯塔格街，最后来到斯科尔斯街。这都是些丑陋的街道，名字倒是很漂亮。每条偏街陋巷里都会有衣衫褴褛的小孩子钻出来，汇入破烂大军，前往卡尼的垃圾站。他们去的路上，会遇到空手而归的孩子们。这些孩子已经把破烂卖掉，钱也都花得一个子儿都不剩了。现在，他们大摇大摆走回来，还嘲笑起其他小孩来。 “捡破烂的！捡破烂的！” 听到这种骂声，弗兰西的脸立刻就涨红了。她知道这些骂人的人自己也捡破烂，可是这也无济于事。其实过一会儿弟弟也会和他的小伙伴们一起，空着手，大摇大摆走回来，同样嘲笑着后来的人，可是这也安慰不了她。她就是害臊得慌。 卡尼在一个摇摇欲坠的马棚里，经营起垃圾回收的生意来。转过街角，弗兰西就看到那两扇大门被钩子钩住，友善地敞开着；那个样子平淡的指针式磅秤的指针晃了一下，弗兰西想象那是欢迎的手势。她看到了卡尼，铁锈色的头发，铁锈色的胡须，铁锈色的眼睛，守在磅秤边。卡尼对女孩子更喜欢些。他伸手去捏女孩子脸蛋的时候，要是对方不退缩，他会多给一分钱。 鉴于有可能拿到这额外好处，尼雷就闪到一边，让弗兰西把麻袋拖进马棚。卡尼跳上前，把袋子里的东西倒在地上，然后先在弗兰西脸上捏了一把。当他将破烂堆上磅秤的时候，弗兰西的眼睛不习惯这里头的黑暗，眨了一眨，想适应过来。她能闻到空气中的苔藓味和湿布头的臭味。卡尼眼睛朝磅秤指针瞟了一眼，然后说了两个字，也就是他的出价。弗兰西知道讨价还价他是不允许的，只好点头称是。卡尼把磅秤上的破烂掀了下去，叫她等着。他自己把废纸码到一个角落，布头扔往另外一个角落，然后把金属分拣出来。这一切都弄完了，他才把手伸进口袋，扯出一个用蜡线拴着的旧皮袋子，掏出一枚枚分币来。分币都发绿了，本身就像破烂似的。她低声说了句：“谢谢您。”这时候卡尼贱贱地看了她一眼，然后伸手狠狠捏了她的脸蛋一把。她坚持着没作什么反应。他笑了，又多给了她一分钱。然后他的举止陡然一变，嘴上咋咋呼呼，手脚敏捷麻利。 “过来，”他冲排队的下一个男孩叫道，“把铅拿出来！”他等着孩子们发笑。“我可不是说破烂啊！”孩子们十分配合地笑了起来。这笑声听来如同迷失羔羊的咩咩叫唤，不过卡尼似乎心满意足了。 弗兰西走了出去，向弟弟汇报情况。“他给了我一毛六，还有捏脸给的一分钱。” “那一分钱归你。”他说。这都是二人之间很早就有的协定了。 她把这一分钱放进衣服口袋，把余下的交给弟弟。尼雷才十岁，比弗兰西小一岁。不过他是男孩，钱的事情归他管。他将这些分币小心翼翼地分好。 “八分钱放进储蓄罐。”这是规定。他们不管在哪里挣到的钱，都将一半存入储蓄罐里。这个储蓄罐是个锡罐子，钉在衣橱间最阴暗的角落里。“四分钱归你，四分钱归我。” 弗兰西把归储蓄罐的钱用手帕包好，打上结。她看着自己的五分钱，很高兴这钱能换成一个五分硬币。 尼雷把麻袋卷起来，用胳膊夹着，冲进查理便宜店里，弗兰西就跟在他身后。查理便宜店是一家廉价糖果店，紧挨着卡尼的垃圾回收站，也是专门为了垃圾站这边的生意而开的。星期六结束后，糖果店的钱柜里会装满发绿的分币。根据某个不成文的规定，这店只有男孩才能进去。所以弗兰西并没有进去，而是靠在门口。 男孩子们的年龄从八岁到十四岁不等，看上去都差不多，都穿着松松垮垮的灯笼裤，戴着鸭舌帽，帽檐都是破破烂烂的。他们到处站着，手插在口袋里，瘦瘦的肩膀用力朝前弓着。他们长大后也会是这样，也会在各样扎堆的地方这么站着。唯一不同的是，长大后，他们嘴边总叼着香烟，就像是永远粘在嘴上一般。他们带着口音说起话来，嘴角的烟就跟着一起一伏。 孩子们惴惴不安地在那里呆着，瘦瘦的脸一会儿面向查理，</span>', '88', '0', '347', '123.00', '0', '0.00', '0.00', '', '94', '0', '0', '1', '', '0', '0', '', '', '1509909668', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('192', '【国家图书奖】鲁迅散文选集', '1509909712', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2374668160/TB2._4wkUUIL1JjSZFrXXb3xFXa_!!2374668160.jpg\" />', '88', '0', '439', '213.00', '0', '0.00', '0.00', '', '140', '0', '0', '1', '', '0', '0', '', '', '1509909712', '3', '1525190256', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('193', '初等英语3-6级词汇速记手册', '1509910093', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2378431138/TB2jo9RXiGfF1Jjy0FjXXXZdVXa_!!2378431138.jpg\" />', '83', '0', '349', '43.00', '0', '0.00', '0.00', '', '368', '0', '0', '1', '', '0', '0', '', '普装,精装,16开,32开', '1509910093', '1', '1523618750', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('194', '欧神诺瓷砖 特权订金10元抵500元', '1509936513', '0', '324', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/651798426/TB2wEwJcR8lpuFjSspaXXXJKpXa-651798426.jpg\" />', '114', '0', '350', '434.00', '0', '0.00', '0.00', '', '177', '0', '0', '1', '', '0', '0', '', '', '1509936513', '1', '1523618761', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('195', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '1509936578', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/414749207/TB2E2cIbxwlyKJjSZFsXXar3XXa_!!414749207.jpg\" />', '114', '0', '351', '324.00', '0', '0.00', '0.00', '', '147', '0', '0', '1', '', '0', '0', '', '', '1509936578', '3', '1525190164', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('196', '百安居 699精致全包装修套餐', '1509936626', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/2670771506/TB25jVhbKkJL1JjSZFmXXcw0XXa_!!2670771506.jpg\" />', '114', '0', '352', '324.00', '0', '0.00', '0.00', '', '160', '0', '0', '1', '', '0', '0', '', '', '1509936626', '1', '1523618723', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('197', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '1509936714', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2712564245/TB2YdWzXJzJ8KJjSspkXXbF7VXa_!!2712564245.jpg\" />', '114', '0', '353', '234.00', '0', '0.00', '0.00', '', '234', '0', '0', '1', '', '0', '0', '', '', '1509936714', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('198', 'TATA木门 简约静音门室内门', '1509936856', '0', '435', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/826813153/TB2mIw3lV9gSKJjSspbXXbeNXXa_!!826813153.jpg\" />', '114', '0', '354', '345.00', '0', '0.00', '0.00', '', '180', '0', '0', '1', '', '0', '0', '', '', '1509936856', '1', '1523618710', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('199', '简约转角书桌实木书架书柜组合一体', '1509937022', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/1657682766/TB2fieyzctnpuFjSZFKXXalFFXa_!!1657682766.jpg\" />', '114', '0', '355', '3245.00', '0', '0.00', '0.00', '', '260', '0', '0', '1', '', '0', '0', '', '', '1509937022', '1', '1523618678', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('200', '厨房置物架 壁挂 304不锈钢刀架厨具', '1509937154', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/1692257579/TB2x6boaMnH8KJjSspcXXb3QFXa_!!1692257579.jpg\" />', '114', '0', '356', '234.00', '0', '0.00', '0.00', '', '391', '0', '0', '1', '', '0', '0', '', '', '1509937154', '1', '1523618646', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('201', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '1509937256', '0', '345', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/2818590914/TB2jnwnhuALL1JjSZFjXXasqXXa_!!2818590914.jpg_q90.jpg\" />', '114', '0', '357', '34554.00', '0', '0.00', '0.00', '', '657', '0', '0', '1', '', '0', '0', '', '', '1509937256', '1', '1509937256', '1509937256', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('203', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '1511030273', '0', '121', '1', '<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i3/700459267/TB2MEntayqAXuNjy1XdXXaYcVXa_!!700459267.jpg\" /> \r\n</p>\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/299244686/TB2pKXYcMFkpuFjSspnXXb4qFXa-299244686.jpg\" /> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '151', '0', '358', '12.00', '0', '0.00', '0.00', '', '2223', '0', '0', '1', '', '0', '0', '', '1kg,2kg,优惠套装1,优惠套装2', '1511030273', '1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('204', '套餐】Apple iPad 32G银+intermail', '1594165965', '0', '123', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/881497240158799213071490_x.jpg\" />', '174', '0', '359', '7213.00', '0', '0.00', '0.00', null, '498', '0', '0', '1', null, '0', '0', '', null, '1594165965', '84', '1594165965', '1661270400', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('205', 'Apple iPad mini 4 7.9英寸平板电脑', '1511717623', '0', '23', '1', '<img src=\"https://image.suning.cn/uimg/BTC/PDI/134162973_20150910095419.jpg\" />', '174', '0', '360', '2342.00', '10', '0.00', '0.00', '', '3000', '0', '0', '1', '', '0', '0', '', '', '1511717623', '1', '1511719000', '1511744200', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('206', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '1523686225', '0', '23432', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/156254755313200260630300_x.jpg\" />', '174', '0', '361', '234.00', '0', '0.00', '0.00', '', '629', '0', '0', '1', '', '0', '0', '', '', '1523686225', '1', '1523686225', '1528738477', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('207', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '1594165937', '0', '344', '1', '<img class=\"err-product\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/187782841565914587180800_x.jpg\" />', '174', '0', '362', '599.00', '0', '0.00', '0.00', null, '2998', '0', '0', '1', null, '0', '1', '', null, '1594165937', '84', '1594165937', '1664304960', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('208', '永赢一路发一苏宁银车挂 银色', '1594165921', '0', '234', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/849064331912942412454000_x.jpg\" />', '174', '0', '363', '0.01', '0', '0.00', '0.00', null, '1116', '0', '0', '1', null, '0', '0', '', null, '1594165921', '84', '1594165921', '1637002710', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('209', 'Xiaomi/小米 小米手机Note3 ', '1594165249', '0', '234', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/659360312923674112540000_x.jpg\" />', '174', '0', '364', '0.01', '0', '0.00', '0.00', null, '1239', '0', '0', '1', null, '0', '1', '', null, '1594165249', '84', '1594165249', '1665936000', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('212', '九阳(Joyoung) K15-F23 电水壶', '1523682452', '0', '10', '1', '九阳(Joyoung) K15-F23 电水壶', '173', '0', '399', '100.00', '0', '0.00', '0.00', '', '192', '0', '0', '1', '', '0', '0', '', '', '1523682452', '1', '1523682452', '0', '1', '60000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('213', '伊利 安慕希希腊风味酸牛奶原味', '1523682971', '0', '20', '1', '伊利 安慕希希腊风味酸牛奶原味205g*16盒 浓浓安慕希 &nbsp;', '173', '0', '401', '66.00', '0', '0.00', '0.00', '', '66', '0', '0', '1', '', '0', '0', '', '', '1523682971', '1', '1523682971', '0', '1', '66660', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('214', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶 ', '1523683091', '0', '10', '1', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶&nbsp;', '173', '0', '402', '30.00', '0', '0.00', '0.00', '', '125', '0', '0', '1', '', '0', '1', '', '', '1523683091', '1', '1523683091', '0', '1', '30000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('215', '容声（Ronshen）BCD-218D11N 218升', '1523683149', '0', '60', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	容声（Ronshen）BCD-218D11N 218升\r\n</h1>', '173', '0', '403', '1200.00', '0', '0.00', '0.00', '', '203', '0', '0', '1', '', '0', '1', '', '', '1523683149', '1', '1523683149', '0', '1', '1200000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('216', '水井坊 井台瓶 52度 500ml 单瓶装', '1523683209', '0', '66', '1', '水井坊 井台瓶 52度 500ml 单瓶装', '173', '0', '404', '120.00', '0', '0.00', '0.00', '', '205', '0', '0', '1', '', '0', '0', '', '', '1523683209', '1', '1523683209', '0', '1', '12000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('217', 'walch/威露士衣物家居消毒液 3L 消毒除菌液', '1523683361', '0', '10', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	walch/威露士衣物家居消毒液 3L 消毒除菌液\r\n</h1>', '173', '0', '405', '100.00', '0', '0.00', '0.00', '', '63', '0', '0', '1', '', '0', '0', '', '', '1523683361', '1', '1523683361', '0', '1', '60000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('218', '安佳（Anchor）全脂纯牛奶1L*12盒整箱', '1523683423', '0', '10', '1', '安佳（Anchor）全脂纯牛奶1L*12盒整箱', '173', '0', '406', '100.00', '0', '0.00', '0.00', '', '123', '0', '0', '1', '', '0', '0', '', '', '1523683423', '1', '1523683423', '0', '1', '10000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('219', 'Mixx炼奶起士味饼干500g (袋装)', '1525156332', '0', '10', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	Mixx炼奶起士味饼干500g&nbsp;\r\n</h1>', '173', '0', '407', '6.00', '0', '0.00', '0.00', '', '209', '0', '0', '1', '', '0', '1', '', '', '1525156332', '3', '1525156332', '0', '1', '600', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('220', '佳能(Canon) EOS 750D单反数码相机', '1523683614', '0', '6', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	佳能(Canon) EOS 750D 入门级单反数码相机\r\n</h1>', '173', '0', '408', '500.00', '0', '0.00', '0.00', '', '238', '0', '0', '1', '', '0', '0', '', '', '1523683614', '1', '1523683614', '0', '1', '50000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('221', '华硕(ASUS)轻薄本笔记本电脑', '1523683729', '0', '1', '1', '&nbsp;14.0英寸轻薄本笔记本电脑', '173', '0', '409', '5600.00', '0', '0.00', '0.00', '', '429', '0', '0', '1', '', '0', '0', '', '', '1523683729', '1', '1523683729', '0', '1', '5600000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('222', '福临门苏软香米5kg/袋 中粮出品 粳米', '1523683797', '0', '1', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	福临门苏软香米5kg/袋 中粮出品 粳米\r\n</h1>', '173', '0', '410', '20.00', '0', '0.00', '0.00', '', '330', '0', '0', '1', '', '0', '0', '', '', '1523683797', '1', '1523683797', '0', '1', '1000', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('223', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '1524462575', '0', '100', '1', '1000<img src=\"https://img.alicdn.com/imgextra/i1/309886021/TB2gPmGcNXkpuFjy0FiXXbUfFXa_!!309886021.jpg\" />', '151', '0', '411', '12.00', '0', '0.00', '0.00', '', '4159', '0', '0', '1', '', '0', '1', '', '', '1524462575', '1', '1524462575', '0', '0', '0', '0', '2', '55', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('224', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '1524462649', '0', '11', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/309886021/TB2Rlk.cB0lpuFjSszdXXcdxFXa_!!309886021.jpg\" />', '151', '0', '412', '0.10', '0', '0.00', '0.00', '', '2328', '0', '0', '1', '', '0', '2', '', '', '1524462649', '1', '1524462649', '0', '0', '0', '0', '10', '15', '1', '0', '0');
INSERT INTO `by_goods` VALUES ('225', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '1524462852', '0', '0', '1', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机<br />', '110', '0', '413', '19000.00', '0', '0.00', '0.00', '', '4687', '0', '0', '1', '', '0', '3', '414,415,416', '3G,6G,16G,32G', '1524462852', '1', '1524462852', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('228', 'HLA海澜之家短袖T恤男基础款简约圆领', '1524511415', '0', '44', '1', 'HLA海澜之家短袖T恤男基础款简约圆领HNTBJ2E', '116', '0', '421', '44.00', '0', '0.00', '0.00', '', '1158', '0', '0', '1', '', '0', '0', '', '', '1524511415', '3', '1524511415', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('227', '联想 小新 潮7000-13 (i7 8550u)', '1524471123', '0', '10', '1', '联想 小新 潮7000-13 (i7 8550u)', '160', '16', '420', '4664.00', '0', '0.00', '0.00', '', '1898', '0', '0', '1', '', '0', '2', '', '黑,官方标配,套餐1,1g,2g,3g', '1524471123', '3', '1524471123', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('229', '卡宾Cabbeen 短袖T恤男装黑色', '1524512363', '0', '11', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:\" color:#333333;\"=\"\">\r\n	卡宾Cabbeen 短袖T恤男装黑色\r\n	</h1>', '175', '0', '422', '33.00', '0', '0.00', '0.00', '', '896', '0', '0', '1', '', '0', '0', '', '红色,蓝色,x,xl', '1524512363', '1', '1524512363', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('230', '2018年注册会计师全国统一考试辅导教材 ', '1524512536', '0', '11', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:&quot;color:#333333;\">\r\n	2018年注册会计师全国统一考试辅导教材&nbsp;\r\n</h1>', '86', '0', '423', '11.00', '0', '0.00', '0.00', '', '548', '0', '0', '1', '', '0', '0', '', '', '1524512536', '1', '1524512536', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('231', '浮生六记（汪涵推荐，全译本，畅销150万册）', '1524512682', '0', '33', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:&quot;color:#333333;\">\r\n	浮生六记（汪涵推荐，全译本，畅销150万册）\r\n</h1>', '86', '0', '424', '23.00', '0', '0.00', '0.00', '', '713', '0', '0', '1', '', '0', '0', '', '', '1524512682', '1', '1524512682', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('232', '汪汪队立大功儿童毛绒玩具狗狗毛绒公仔', '1524867002', '0', '45', '1', '狗年吉祥物3只礼盒装 天天毛毛路马', '176', '0', '435', '454.00', '0', '0.00', '0.00', '', '405', '0', '1', '1', '', '0', '0', '', '', '1524867002', '3', '1524867002', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('233', '一品国度 绝地求生游戏台式吃鸡电脑主机', '1524867064', '0', '6', '1', '<span style=\"color:#666666;font-family:Arial, \" font-size:16px;font-weight:bold;background-color:#ffffff;\"=\"\">游戏台式吃鸡电脑主机</span>', '176', '0', '440', '6767.00', '0', '0.00', '0.00', '', '718', '0', '1', '1', '', '0', '1', '', '', '1524867064', '1', '1524867064', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('234', '美国进口 健安喜（GNC）三倍浓缩鱼', '1532372074', '0', '100', '1', '', '182', '0', '461', '169.00', '0', '0.00', '0.00', '', '64', '0', '1', '1', '', '0', '0', '', '', '1532372074', '22', '1532372074', '0', '0', '0', '0', '0', '', '0', '0', '0');
INSERT INTO `by_goods` VALUES ('235', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '1577796005', '0', '121', '1', '', '182', '0', '465', '189.00', '0', '0.00', '0.00', '', '303', '0', '1', '1', '', '0', '0', '', '', '1577796005', '72', '0', '0', '0', '0', '0', '0', '', '10', '2', '1');

-- ----------------------------
-- Table structure for by_group
-- ----------------------------
DROP TABLE IF EXISTS `by_group`;
CREATE TABLE `by_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `module` varchar(225) DEFAULT NULL,
  `icon` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='分组表';

-- ----------------------------
-- Records of by_group
-- ----------------------------
INSERT INTO `by_group` VALUES ('1', '系统', '0', '1', 'systems/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('7', '文章', '40', '3', 'document/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('15', '订单', '0', '3', 'order/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('16', '用户', '0', '4', 'user/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('19', '广告', '0', '5', 'ad/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('21', '商品', '0', '2', 'goods/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('24', '店铺', '0', '8', 'shop/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('25', '首页', '0', '0', 'index/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('26', '营销', '0', '3', 'ScoreOrder/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('27', '微信', '0', '6', 'weixin/index', '0', '1', '', '');
INSERT INTO `by_group` VALUES ('28', '插件', '0', '9', 'plugin/index', '0', '1', null, null);

-- ----------------------------
-- Table structure for by_history
-- ----------------------------
DROP TABLE IF EXISTS `by_history`;
CREATE TABLE `by_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `time` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=878 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_history
-- ----------------------------
INSERT INTO `by_history` VALUES ('374', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '::1', '1594560762', '2020-07-12 21:32:42');
INSERT INTO `by_history` VALUES ('376', '【国家图书奖】鲁迅散文选集', '192', '54.36.148.34', '1594608122', '2020-07-13 10:42:02');
INSERT INTO `by_history` VALUES ('377', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '116.179.32.82', '1594610599', '2020-07-13 11:23:19');
INSERT INTO `by_history` VALUES ('378', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '116.179.32.200', '1594611509', '2020-07-13 11:38:29');
INSERT INTO `by_history` VALUES ('379', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '54.36.148.1', '1594611719', '2020-07-13 11:41:59');
INSERT INTO `by_history` VALUES ('380', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '216.244.66.226', '1594614282', '2020-07-13 12:24:42');
INSERT INTO `by_history` VALUES ('381', 'OPPO耳机原装正品全球限量版', '178', '116.179.32.46', '1594615653', '2020-07-13 12:47:33');
INSERT INTO `by_history` VALUES ('382', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '183', '18.234.207.41', '1594616118', '2020-07-13 12:55:18');
INSERT INTO `by_history` VALUES ('383', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '18.234.207.41', '1594616136', '2020-07-13 12:55:36');
INSERT INTO `by_history` VALUES ('384', '欧神诺瓷砖 特权订金10元抵500元', '194', '18.234.207.41', '1594616252', '2020-07-13 12:57:32');
INSERT INTO `by_history` VALUES ('385', '卡宾Cabbeen 短袖T恤男装黑色', '229', '18.234.207.41', '1594616296', '2020-07-13 12:58:16');
INSERT INTO `by_history` VALUES ('386', 'TATA木门 简约静音门室内门', '198', '18.234.207.41', '1594616320', '2020-07-13 12:58:40');
INSERT INTO `by_history` VALUES ('387', '百安居 699精致全包装修套餐', '196', '18.234.207.41', '1594616358', '2020-07-13 12:59:18');
INSERT INTO `by_history` VALUES ('388', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '18.234.207.41', '1594616600', '2020-07-13 13:03:20');
INSERT INTO `by_history` VALUES ('389', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '18.234.207.41', '1594616676', '2020-07-13 13:04:36');
INSERT INTO `by_history` VALUES ('390', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '18.234.207.41', '1594616695', '2020-07-13 13:04:55');
INSERT INTO `by_history` VALUES ('391', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '180', '18.234.207.41', '1594616745', '2020-07-13 13:05:45');
INSERT INTO `by_history` VALUES ('392', '新农哥五香花生136g 坚果炒货小吃', '165', '18.234.207.41', '1594616861', '2020-07-13 13:07:41');
INSERT INTO `by_history` VALUES ('393', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '18.234.207.41', '1594616909', '2020-07-13 13:08:29');
INSERT INTO `by_history` VALUES ('394', '【亚马逊图书】王小波文集：黄金时代+青铜时代+', '190', '18.234.207.41', '1594617131', '2020-07-13 13:12:11');
INSERT INTO `by_history` VALUES ('395', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '18.234.207.41', '1594617202', '2020-07-13 13:13:22');
INSERT INTO `by_history` VALUES ('396', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '18.234.207.41', '1594617380', '2020-07-13 13:16:20');
INSERT INTO `by_history` VALUES ('397', 'OPPO耳机原装正品全球限量版', '178', '18.234.207.41', '1594617424', '2020-07-13 13:17:04');
INSERT INTO `by_history` VALUES ('398', '联想 小新 潮7000-13 (i7 8550u)', '227', '18.234.207.41', '1594617526', '2020-07-13 13:18:46');
INSERT INTO `by_history` VALUES ('399', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '18.234.207.41', '1594617589', '2020-07-13 13:19:49');
INSERT INTO `by_history` VALUES ('400', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '18.234.207.41', '1594617778', '2020-07-13 13:22:58');
INSERT INTO `by_history` VALUES ('401', '厨房置物架 壁挂 304不锈钢刀架厨具', '200', '18.234.207.41', '1594617951', '2020-07-13 13:25:51');
INSERT INTO `by_history` VALUES ('402', '泰国龙眼1kg 热带桂圆 进口水果', '164', '18.234.207.41', '1594618040', '2020-07-13 13:27:20');
INSERT INTO `by_history` VALUES ('403', '简约转角书桌实木书架书柜组合一体', '199', '18.234.207.41', '1594618089', '2020-07-13 13:28:09');
INSERT INTO `by_history` VALUES ('404', '国家图书奖朱自清散文集徐志摩经典大全集', '188', '18.234.207.41', '1594618153', '2020-07-13 13:29:13');
INSERT INTO `by_history` VALUES ('405', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '216.244.66.226', '1594618274', '2020-07-13 13:31:14');
INSERT INTO `by_history` VALUES ('406', '罗辑思维官方 今天故事书', '189', '18.234.207.41', '1594618691', '2020-07-13 13:38:11');
INSERT INTO `by_history` VALUES ('407', '正版书籍包邮 龙应台人生三书', '186', '18.234.207.41', '1594618867', '2020-07-13 13:41:07');
INSERT INTO `by_history` VALUES ('408', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '181', '18.234.207.41', '1594619216', '2020-07-13 13:46:56');
INSERT INTO `by_history` VALUES ('409', '2018年注册会计师全国统一考试辅导教材 ', '230', '18.234.207.41', '1594619487', '2020-07-13 13:51:27');
INSERT INTO `by_history` VALUES ('410', '套餐】Apple iPad 32G银+intermail', '204', '18.234.207.41', '1594619498', '2020-07-13 13:51:38');
INSERT INTO `by_history` VALUES ('411', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '18.234.207.41', '1594619690', '2020-07-13 13:54:50');
INSERT INTO `by_history` VALUES ('412', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '18.234.207.41', '1594619723', '2020-07-13 13:55:23');
INSERT INTO `by_history` VALUES ('413', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '18.234.207.41', '1594620233', '2020-07-13 14:03:53');
INSERT INTO `by_history` VALUES ('414', '【国家图书奖】鲁迅散文选集', '192', '18.234.207.41', '1594620261', '2020-07-13 14:04:21');
INSERT INTO `by_history` VALUES ('415', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '18.234.207.41', '1594620269', '2020-07-13 14:04:29');
INSERT INTO `by_history` VALUES ('416', 'Xiaomi/小米 小米手机Note3 ', '209', '18.234.207.41', '1594620292', '2020-07-13 14:04:52');
INSERT INTO `by_history` VALUES ('417', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '18.234.207.41', '1594620312', '2020-07-13 14:05:12');
INSERT INTO `by_history` VALUES ('418', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '18.234.207.41', '1594620558', '2020-07-13 14:09:18');
INSERT INTO `by_history` VALUES ('419', '永赢一路发一苏宁银车挂 银色', '208', '18.234.207.41', '1594620689', '2020-07-13 14:11:29');
INSERT INTO `by_history` VALUES ('420', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '18.234.207.41', '1594620762', '2020-07-13 14:12:42');
INSERT INTO `by_history` VALUES ('421', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '18.234.207.41', '1594621164', '2020-07-13 14:19:24');
INSERT INTO `by_history` VALUES ('422', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '18.234.207.41', '1594621246', '2020-07-13 14:20:46');
INSERT INTO `by_history` VALUES ('423', 'ZARA 男装 绒面质感裤子 06706310707', '182', '216.244.66.226', '1594621345', '2020-07-13 14:22:25');
INSERT INTO `by_history` VALUES ('424', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '18.234.207.41', '1594621692', '2020-07-13 14:28:12');
INSERT INTO `by_history` VALUES ('425', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '157.55.39.69', '1594621925', '2020-07-13 14:32:05');
INSERT INTO `by_history` VALUES ('426', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '157.55.39.69', '1594621927', '2020-07-13 14:32:07');
INSERT INTO `by_history` VALUES ('427', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '18.234.207.41', '1594621930', '2020-07-13 14:32:10');
INSERT INTO `by_history` VALUES ('428', '布鲁克林有棵树正版包邮(美)史密斯著', '191', '18.234.207.41', '1594622457', '2020-07-13 14:40:57');
INSERT INTO `by_history` VALUES ('429', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '18.234.207.41', '1594622471', '2020-07-13 14:41:11');
INSERT INTO `by_history` VALUES ('430', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '187', '18.234.207.41', '1594622817', '2020-07-13 14:46:57');
INSERT INTO `by_history` VALUES ('431', '初等英语3-6级词汇速记手册', '193', '18.234.207.41', '1594622942', '2020-07-13 14:49:02');
INSERT INTO `by_history` VALUES ('432', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', '171', '18.234.207.41', '1594623200', '2020-07-13 14:53:20');
INSERT INTO `by_history` VALUES ('433', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '18.234.207.41', '1594623234', '2020-07-13 14:53:54');
INSERT INTO `by_history` VALUES ('434', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '172', '18.234.207.41', '1594623338', '2020-07-13 14:55:38');
INSERT INTO `by_history` VALUES ('435', 'ZARA 男装 绒面质感裤子 06706310707', '182', '18.234.207.41', '1594623363', '2020-07-13 14:56:03');
INSERT INTO `by_history` VALUES ('436', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '18.234.207.41', '1594623378', '2020-07-13 14:56:18');
INSERT INTO `by_history` VALUES ('437', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '18.234.207.41', '1594623405', '2020-07-13 14:56:45');
INSERT INTO `by_history` VALUES ('438', '浮生六记（汪涵推荐，全译本，畅销150万册）', '231', '18.234.207.41', '1594623418', '2020-07-13 14:56:58');
INSERT INTO `by_history` VALUES ('439', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '176', '18.234.207.41', '1594623466', '2020-07-13 14:57:46');
INSERT INTO `by_history` VALUES ('440', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '18.234.207.41', '1594623479', '2020-07-13 14:57:59');
INSERT INTO `by_history` VALUES ('441', 'TATA木门 简约静音门室内门', '198', '216.244.66.226', '1594628391', '2020-07-13 16:19:51');
INSERT INTO `by_history` VALUES ('442', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.245.82', '1594629590', '2020-07-13 16:39:50');
INSERT INTO `by_history` VALUES ('443', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '113.57.245.82', '1594629908', '2020-07-13 16:45:08');
INSERT INTO `by_history` VALUES ('444', '套餐】Apple iPad 32G银+intermail', '204', '113.57.245.82', '1594631865', '2020-07-13 17:17:45');
INSERT INTO `by_history` VALUES ('445', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '113.57.245.82', '1594631870', '2020-07-13 17:17:50');
INSERT INTO `by_history` VALUES ('446', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '54.36.148.239', '1594632971', '2020-07-13 17:36:11');
INSERT INTO `by_history` VALUES ('447', '卡宾Cabbeen 短袖T恤男装黑色', '229', '116.179.32.18', '1594636512', '2020-07-13 18:35:12');
INSERT INTO `by_history` VALUES ('448', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '36.47.163.184', '1594639656', '2020-07-13 19:27:36');
INSERT INTO `by_history` VALUES ('449', 'ZARA 男装 绒面质感裤子 06706310707', '182', '42.120.160.102', '1594642507', '2020-07-13 20:15:07');
INSERT INTO `by_history` VALUES ('450', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '113.57.245.82', '1594645696', '2020-07-13 21:08:16');
INSERT INTO `by_history` VALUES ('451', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '216.244.66.226', '1594648340', '2020-07-13 21:52:20');
INSERT INTO `by_history` VALUES ('452', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '220.181.108.114', '1594648700', '2020-07-13 21:58:20');
INSERT INTO `by_history` VALUES ('453', '欧神诺瓷砖 特权订金10元抵500元', '194', '216.244.66.226', '1594648865', '2020-07-13 22:01:05');
INSERT INTO `by_history` VALUES ('454', '厨房置物架 壁挂 304不锈钢刀架厨具', '200', '220.181.108.155', '1594655374', '2020-07-13 23:49:34');
INSERT INTO `by_history` VALUES ('455', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '216.244.66.226', '1594655438', '2020-07-13 23:50:38');
INSERT INTO `by_history` VALUES ('456', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '216.244.66.226', '1594655454', '2020-07-13 23:50:54');
INSERT INTO `by_history` VALUES ('457', '卡宾Cabbeen 短袖T恤男装黑色', '229', '216.244.66.226', '1594658728', '2020-07-14 00:45:28');
INSERT INTO `by_history` VALUES ('458', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '216.244.66.226', '1594658929', '2020-07-14 00:48:49');
INSERT INTO `by_history` VALUES ('459', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '216.244.66.226', '1594661790', '2020-07-14 01:36:30');
INSERT INTO `by_history` VALUES ('460', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '216.244.66.226', '1594661857', '2020-07-14 01:37:37');
INSERT INTO `by_history` VALUES ('461', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '187', '216.244.66.226', '1594661934', '2020-07-14 01:38:54');
INSERT INTO `by_history` VALUES ('462', '初等英语3-6级词汇速记手册', '193', '42.156.136.55', '1594663413', '2020-07-14 02:03:33');
INSERT INTO `by_history` VALUES ('463', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '216.244.66.226', '1594669206', '2020-07-14 03:40:06');
INSERT INTO `by_history` VALUES ('464', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '116.179.32.162', '1594669615', '2020-07-14 03:46:55');
INSERT INTO `by_history` VALUES ('465', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '116.179.32.178', '1594677516', '2020-07-14 05:58:36');
INSERT INTO `by_history` VALUES ('466', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '116.179.32.211', '1594680217', '2020-07-14 06:43:37');
INSERT INTO `by_history` VALUES ('467', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '216.244.66.226', '1594681428', '2020-07-14 07:03:48');
INSERT INTO `by_history` VALUES ('468', 'TATA木门 简约静音门室内门', '198', '116.179.32.195', '1594687418', '2020-07-14 08:43:38');
INSERT INTO `by_history` VALUES ('469', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '220.181.108.88', '1594693357', '2020-07-14 10:22:37');
INSERT INTO `by_history` VALUES ('470', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '116.179.32.35', '1594698757', '2020-07-14 11:52:37');
INSERT INTO `by_history` VALUES ('471', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '1.198.208.129', '1594698995', '2020-07-14 11:56:35');
INSERT INTO `by_history` VALUES ('472', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '42.156.136.29', '1594699247', '2020-07-14 12:00:47');
INSERT INTO `by_history` VALUES ('473', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '42.236.10.75', '1594702938', '2020-07-14 13:02:18');
INSERT INTO `by_history` VALUES ('474', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '175.43.103.244', '1594709768', '2020-07-14 14:56:08');
INSERT INTO `by_history` VALUES ('475', '联想 小新 潮7000-13 (i7 8550u)', '227', '49.86.178.35', '1594709802', '2020-07-14 14:56:42');
INSERT INTO `by_history` VALUES ('476', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '183.92.250.160', '1594711106', '2020-07-14 15:18:26');
INSERT INTO `by_history` VALUES ('477', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '183.92.250.160', '1594711126', '2020-07-14 15:18:46');
INSERT INTO `by_history` VALUES ('478', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '121.32.192.210', '1594712007', '2020-07-14 15:33:27');
INSERT INTO `by_history` VALUES ('479', '容声（Ronshen）BCD-218D11N 218升', '215', '157.55.39.209', '1594712204', '2020-07-14 15:36:44');
INSERT INTO `by_history` VALUES ('480', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '175.43.103.244', '1594712263', '2020-07-14 15:37:43');
INSERT INTO `by_history` VALUES ('481', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '153.34.111.170', '1594722179', '2020-07-14 18:22:59');
INSERT INTO `by_history` VALUES ('482', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '116.179.32.44', '1594722768', '2020-07-14 18:32:48');
INSERT INTO `by_history` VALUES ('483', '百安居 699精致全包装修套餐', '196', '116.179.32.241', '1594724319', '2020-07-14 18:58:39');
INSERT INTO `by_history` VALUES ('484', '百安居 699精致全包装修套餐', '196', '111.37.152.14', '1594724577', '2020-07-14 19:02:57');
INSERT INTO `by_history` VALUES ('485', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.92.250.160', '1594729983', '2020-07-14 20:33:03');
INSERT INTO `by_history` VALUES ('486', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '180', '116.179.32.204', '1594733077', '2020-07-14 21:24:37');
INSERT INTO `by_history` VALUES ('487', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '111.14.41.237', '1594733976', '2020-07-14 21:39:36');
INSERT INTO `by_history` VALUES ('488', '联想 小新 潮7000-13 (i7 8550u)', '227', '27.210.92.22', '1594736389', '2020-07-14 22:19:49');
INSERT INTO `by_history` VALUES ('489', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '27.210.92.22', '1594736391', '2020-07-14 22:19:51');
INSERT INTO `by_history` VALUES ('490', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '114.239.23.95', '1594736436', '2020-07-14 22:20:36');
INSERT INTO `by_history` VALUES ('491', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '220.181.108.117', '1594737217', '2020-07-14 22:33:37');
INSERT INTO `by_history` VALUES ('492', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '106.11.154.38', '1594737858', '2020-07-14 22:44:18');
INSERT INTO `by_history` VALUES ('493', '套餐】Apple iPad 32G银+intermail', '204', '54.36.148.41', '1594740424', '2020-07-14 23:27:04');
INSERT INTO `by_history` VALUES ('494', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '183.92.250.160', '1594744806', '2020-07-15 00:40:06');
INSERT INTO `by_history` VALUES ('495', '2018年注册会计师全国统一考试辅导教材 ', '230', '54.36.148.1', '1594746496', '2020-07-15 01:08:16');
INSERT INTO `by_history` VALUES ('496', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '116.179.32.103', '1594748019', '2020-07-15 01:33:39');
INSERT INTO `by_history` VALUES ('497', '永赢一路发一苏宁银车挂 银色', '208', '216.244.66.226', '1594755852', '2020-07-15 03:44:12');
INSERT INTO `by_history` VALUES ('498', '卡宾Cabbeen 短袖T恤男装黑色', '229', '61.241.50.63', '1594756881', '2020-07-15 04:01:21');
INSERT INTO `by_history` VALUES ('499', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '42.156.139.83', '1594759095', '2020-07-15 04:38:15');
INSERT INTO `by_history` VALUES ('500', '2018年注册会计师全国统一考试辅导教材 ', '230', '54.36.149.45', '1594759564', '2020-07-15 04:46:04');
INSERT INTO `by_history` VALUES ('501', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '106.11.152.37', '1594762822', '2020-07-15 05:40:22');
INSERT INTO `by_history` VALUES ('502', '永赢一路发一苏宁银车挂 银色', '208', '106.11.152.104', '1594773211', '2020-07-15 08:33:31');
INSERT INTO `by_history` VALUES ('503', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '216.244.66.226', '1594773542', '2020-07-15 08:39:02');
INSERT INTO `by_history` VALUES ('504', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '115.60.178.223', '1594774226', '2020-07-15 08:50:26');
INSERT INTO `by_history` VALUES ('505', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '187', '183.192.179.16', '1594775505', '2020-07-15 09:11:45');
INSERT INTO `by_history` VALUES ('506', '简约转角书桌实木书架书柜组合一体', '199', '216.244.66.226', '1594778845', '2020-07-15 10:07:25');
INSERT INTO `by_history` VALUES ('507', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.244.116', '1594781529', '2020-07-15 10:52:09');
INSERT INTO `by_history` VALUES ('508', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.57.244.116', '1594781738', '2020-07-15 10:55:38');
INSERT INTO `by_history` VALUES ('509', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '113.57.244.116', '1594781773', '2020-07-15 10:56:13');
INSERT INTO `by_history` VALUES ('510', '正版书籍包邮 龙应台人生三书', '186', '113.57.244.116', '1594781783', '2020-07-15 10:56:23');
INSERT INTO `by_history` VALUES ('511', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '113.57.244.116', '1594784184', '2020-07-15 11:36:24');
INSERT INTO `by_history` VALUES ('512', '套餐】Apple iPad 32G银+intermail', '204', '113.57.244.116', '1594784274', '2020-07-15 11:37:54');
INSERT INTO `by_history` VALUES ('513', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '220.181.108.187', '1594788025', '2020-07-15 12:40:25');
INSERT INTO `by_history` VALUES ('514', '新农哥五香花生136g 坚果炒货小吃', '165', '116.179.32.72', '1594789689', '2020-07-15 13:08:09');
INSERT INTO `by_history` VALUES ('515', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '220.181.108.158', '1594793017', '2020-07-15 14:03:37');
INSERT INTO `by_history` VALUES ('516', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '61.157.55.187', '1594793453', '2020-07-15 14:10:53');
INSERT INTO `by_history` VALUES ('517', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '116.179.32.69', '1594794682', '2020-07-15 14:31:22');
INSERT INTO `by_history` VALUES ('518', '套餐】Apple iPad 32G银+intermail', '204', '54.36.148.177', '1594796447', '2020-07-15 15:00:47');
INSERT INTO `by_history` VALUES ('519', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '106.11.154.77', '1594797302', '2020-07-15 15:15:02');
INSERT INTO `by_history` VALUES ('520', '套餐】Apple iPad 32G银+intermail', '204', '42.156.139.49', '1594801503', '2020-07-15 16:25:03');
INSERT INTO `by_history` VALUES ('521', '联想 小新 潮7000-13 (i7 8550u)', '227', '216.244.66.226', '1594802535', '2020-07-15 16:42:15');
INSERT INTO `by_history` VALUES ('522', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '106.11.158.94', '1594803148', '2020-07-15 16:52:28');
INSERT INTO `by_history` VALUES ('523', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '216.244.66.226', '1594805604', '2020-07-15 17:33:24');
INSERT INTO `by_history` VALUES ('524', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.57.245.164', '1594807323', '2020-07-15 18:02:03');
INSERT INTO `by_history` VALUES ('525', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '113.57.245.164', '1594807716', '2020-07-15 18:08:36');
INSERT INTO `by_history` VALUES ('526', '正版书籍包邮 龙应台人生三书', '186', '113.57.245.164', '1594808449', '2020-07-15 18:20:49');
INSERT INTO `by_history` VALUES ('527', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '113.57.245.164', '1594808630', '2020-07-15 18:23:50');
INSERT INTO `by_history` VALUES ('528', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.245.164', '1594808691', '2020-07-15 18:24:51');
INSERT INTO `by_history` VALUES ('529', '美国进口 健安喜（GNC）三倍浓缩鱼', '234', '113.57.245.164', '1594809026', '2020-07-15 18:30:26');
INSERT INTO `by_history` VALUES ('530', '汪汪队立大功儿童毛绒玩具狗狗毛绒公仔', '232', '113.57.245.164', '1594809034', '2020-07-15 18:30:34');
INSERT INTO `by_history` VALUES ('531', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '216.244.66.226', '1594810081', '2020-07-15 18:48:01');
INSERT INTO `by_history` VALUES ('532', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '36.47.160.35', '1594813094', '2020-07-15 19:38:14');
INSERT INTO `by_history` VALUES ('534', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '113.57.245.164', '1594815765', '2020-07-15 20:22:45');
INSERT INTO `by_history` VALUES ('535', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '216.244.66.226', '1594816413', '2020-07-15 20:33:33');
INSERT INTO `by_history` VALUES ('536', '浮生六记（汪涵推荐，全译本，畅销150万册）', '231', '54.36.148.1', '1594816775', '2020-07-15 20:39:35');
INSERT INTO `by_history` VALUES ('537', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '54.36.149.45', '1594818767', '2020-07-15 21:12:47');
INSERT INTO `by_history` VALUES ('538', '永赢一路发一苏宁银车挂 银色', '208', '54.36.148.210', '1594822524', '2020-07-15 22:15:24');
INSERT INTO `by_history` VALUES ('539', 'Xiaomi/小米 小米手机Note3 ', '209', '54.36.149.45', '1594824422', '2020-07-15 22:47:02');
INSERT INTO `by_history` VALUES ('540', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '54.36.148.1', '1594826307', '2020-07-15 23:18:27');
INSERT INTO `by_history` VALUES ('541', 'ZARA 男装 绒面质感裤子 06706310707', '182', '54.36.149.45', '1594828169', '2020-07-15 23:49:29');
INSERT INTO `by_history` VALUES ('542', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '116.179.32.105', '1594829192', '2020-07-16 00:06:32');
INSERT INTO `by_history` VALUES ('543', '新农哥五香花生136g 坚果炒货小吃', '165', '34.229.119.29', '1594835754', '2020-07-16 01:55:54');
INSERT INTO `by_history` VALUES ('544', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '34.229.119.29', '1594835809', '2020-07-16 01:56:49');
INSERT INTO `by_history` VALUES ('545', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '34.229.119.29', '1594835866', '2020-07-16 01:57:46');
INSERT INTO `by_history` VALUES ('546', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '34.229.119.29', '1594835922', '2020-07-16 01:58:42');
INSERT INTO `by_history` VALUES ('547', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '34.229.119.29', '1594835975', '2020-07-16 01:59:35');
INSERT INTO `by_history` VALUES ('548', '厨房置物架 壁挂 304不锈钢刀架厨具', '200', '34.229.119.29', '1594836871', '2020-07-16 02:14:31');
INSERT INTO `by_history` VALUES ('549', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '34.229.119.29', '1594836909', '2020-07-16 02:15:09');
INSERT INTO `by_history` VALUES ('550', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '34.229.119.29', '1594837033', '2020-07-16 02:17:13');
INSERT INTO `by_history` VALUES ('551', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '172', '34.229.119.29', '1594837245', '2020-07-16 02:20:45');
INSERT INTO `by_history` VALUES ('552', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '34.229.119.29', '1594837314', '2020-07-16 02:21:54');
INSERT INTO `by_history` VALUES ('553', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '34.229.119.29', '1594837347', '2020-07-16 02:22:27');
INSERT INTO `by_history` VALUES ('554', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '34.229.119.29', '1594837510', '2020-07-16 02:25:10');
INSERT INTO `by_history` VALUES ('555', 'OPPO耳机原装正品全球限量版', '178', '34.229.119.29', '1594837543', '2020-07-16 02:25:43');
INSERT INTO `by_history` VALUES ('556', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '34.229.119.29', '1594837598', '2020-07-16 02:26:38');
INSERT INTO `by_history` VALUES ('557', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '180', '34.229.119.29', '1594838765', '2020-07-16 02:46:05');
INSERT INTO `by_history` VALUES ('558', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '181', '34.229.119.29', '1594838821', '2020-07-16 02:47:01');
INSERT INTO `by_history` VALUES ('559', 'ZARA 男装 绒面质感裤子 06706310707', '182', '34.229.119.29', '1594838874', '2020-07-16 02:47:54');
INSERT INTO `by_history` VALUES ('560', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '183', '34.229.119.29', '1594838903', '2020-07-16 02:48:23');
INSERT INTO `by_history` VALUES ('561', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '34.229.119.29', '1594838961', '2020-07-16 02:49:21');
INSERT INTO `by_history` VALUES ('562', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '34.229.119.29', '1594839015', '2020-07-16 02:50:15');
INSERT INTO `by_history` VALUES ('563', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '34.229.119.29', '1594840249', '2020-07-16 03:10:49');
INSERT INTO `by_history` VALUES ('564', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '34.229.119.29', '1594840297', '2020-07-16 03:11:37');
INSERT INTO `by_history` VALUES ('565', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '34.229.119.29', '1594840345', '2020-07-16 03:12:25');
INSERT INTO `by_history` VALUES ('566', '联想 小新 潮7000-13 (i7 8550u)', '227', '34.229.119.29', '1594840436', '2020-07-16 03:13:56');
INSERT INTO `by_history` VALUES ('567', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '34.229.119.29', '1594840486', '2020-07-16 03:14:46');
INSERT INTO `by_history` VALUES ('568', '卡宾Cabbeen 短袖T恤男装黑色', '229', '34.229.119.29', '1594840547', '2020-07-16 03:15:47');
INSERT INTO `by_history` VALUES ('569', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '220.181.108.174', '1594840558', '2020-07-16 03:15:58');
INSERT INTO `by_history` VALUES ('570', '欧神诺瓷砖 特权订金10元抵500元', '194', '34.229.119.29', '1594840591', '2020-07-16 03:16:31');
INSERT INTO `by_history` VALUES ('571', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '34.229.119.29', '1594840616', '2020-07-16 03:16:56');
INSERT INTO `by_history` VALUES ('572', '百安居 699精致全包装修套餐', '196', '34.229.119.29', '1594840677', '2020-07-16 03:17:57');
INSERT INTO `by_history` VALUES ('573', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '34.229.119.29', '1594840732', '2020-07-16 03:18:52');
INSERT INTO `by_history` VALUES ('574', 'TATA木门 简约静音门室内门', '198', '34.229.119.29', '1594840779', '2020-07-16 03:19:39');
INSERT INTO `by_history` VALUES ('575', '简约转角书桌实木书架书柜组合一体', '199', '34.229.119.29', '1594840837', '2020-07-16 03:20:37');
INSERT INTO `by_history` VALUES ('576', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '157.55.39.97', '1594861651', '2020-07-16 09:07:31');
INSERT INTO `by_history` VALUES ('577', 'OPPO耳机原装正品全球限量版', '178', '207.46.13.212', '1594862794', '2020-07-16 09:26:34');
INSERT INTO `by_history` VALUES ('578', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '157.55.39.216', '1594872116', '2020-07-16 12:01:56');
INSERT INTO `by_history` VALUES ('579', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '172', '220.181.108.172', '1594889538', '2020-07-16 16:52:18');
INSERT INTO `by_history` VALUES ('580', 'OPPO耳机原装正品全球限量版', '178', '183.92.251.28', '1594890344', '2020-07-16 17:05:44');
INSERT INTO `by_history` VALUES ('581', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '183.92.251.28', '1594890366', '2020-07-16 17:06:06');
INSERT INTO `by_history` VALUES ('582', '卡宾Cabbeen 短袖T恤男装黑色', '229', '40.77.167.20', '1594892730', '2020-07-16 17:45:30');
INSERT INTO `by_history` VALUES ('583', '美国进口 健安喜（GNC）三倍浓缩鱼', '234', '46.4.122.146', '1594894344', '2020-07-16 18:12:24');
INSERT INTO `by_history` VALUES ('584', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '42.156.138.115', '1594894664', '2020-07-16 18:17:44');
INSERT INTO `by_history` VALUES ('585', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '172', '116.179.32.142', '1594896527', '2020-07-16 18:48:47');
INSERT INTO `by_history` VALUES ('586', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '112.12.123.39', '1594900693', '2020-07-16 19:58:13');
INSERT INTO `by_history` VALUES ('587', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '175.43.103.244', '1594911277', '2020-07-16 22:54:37');
INSERT INTO `by_history` VALUES ('588', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '116.179.32.69', '1594918304', '2020-07-17 00:51:44');
INSERT INTO `by_history` VALUES ('589', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '220.181.108.109', '1594920573', '2020-07-17 01:29:33');
INSERT INTO `by_history` VALUES ('590', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '183', '220.181.108.123', '1594922841', '2020-07-17 02:07:21');
INSERT INTO `by_history` VALUES ('591', '泰国龙眼1kg 热带桂圆 进口水果', '164', '220.181.108.167', '1594923408', '2020-07-17 02:16:48');
INSERT INTO `by_history` VALUES ('592', '简约转角书桌实木书架书柜组合一体', '199', '116.179.32.94', '1594936278', '2020-07-17 05:51:18');
INSERT INTO `by_history` VALUES ('593', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '207.46.13.22', '1594938293', '2020-07-17 06:24:53');
INSERT INTO `by_history` VALUES ('594', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '182.254.52.17', '1594941415', '2020-07-17 07:16:55');
INSERT INTO `by_history` VALUES ('595', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '116.179.32.26', '1594947079', '2020-07-17 08:51:19');
INSERT INTO `by_history` VALUES ('596', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '116.179.32.225', '1594951399', '2020-07-17 10:03:19');
INSERT INTO `by_history` VALUES ('597', '永赢一路发一苏宁银车挂 银色', '208', '119.123.0.251', '1594955958', '2020-07-17 11:19:18');
INSERT INTO `by_history` VALUES ('598', '联想 小新 潮7000-13 (i7 8550u)', '227', '220.181.108.87', '1594957159', '2020-07-17 11:39:19');
INSERT INTO `by_history` VALUES ('599', '正版书籍包邮 龙应台人生三书', '186', '42.156.138.30', '1594959237', '2020-07-17 12:13:57');
INSERT INTO `by_history` VALUES ('600', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '183.95.248.61', '1594973245', '2020-07-17 16:07:25');
INSERT INTO `by_history` VALUES ('601', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.95.248.61', '1594973248', '2020-07-17 16:07:28');
INSERT INTO `by_history` VALUES ('602', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '213.180.203.176', '1594974348', '2020-07-17 16:25:48');
INSERT INTO `by_history` VALUES ('603', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '106.11.153.41', '1594979051', '2020-07-17 17:44:11');
INSERT INTO `by_history` VALUES ('604', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '183.95.248.61', '1594979259', '2020-07-17 17:47:39');
INSERT INTO `by_history` VALUES ('605', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '183.95.248.61', '1594982314', '2020-07-17 18:38:34');
INSERT INTO `by_history` VALUES ('606', '卡宾Cabbeen 短袖T恤男装黑色', '229', '220.181.108.185', '1594997572', '2020-07-17 22:52:52');
INSERT INTO `by_history` VALUES ('607', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '106.11.154.82', '1595003927', '2020-07-18 00:38:47');
INSERT INTO `by_history` VALUES ('608', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '54.36.148.1', '1595006643', '2020-07-18 01:24:03');
INSERT INTO `by_history` VALUES ('609', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '54.36.149.45', '1595009107', '2020-07-18 02:05:07');
INSERT INTO `by_history` VALUES ('610', '卡宾Cabbeen 短袖T恤男装黑色', '229', '54.36.149.45', '1595011581', '2020-07-18 02:46:21');
INSERT INTO `by_history` VALUES ('611', 'ZARA 男装 绒面质感裤子 06706310707', '182', '220.181.108.158', '1595014672', '2020-07-18 03:37:52');
INSERT INTO `by_history` VALUES ('612', '厨房置物架 壁挂 304不锈钢刀架厨具', '200', '54.36.148.1', '1595017408', '2020-07-18 04:23:28');
INSERT INTO `by_history` VALUES ('613', 'TATA木门 简约静音门室内门', '198', '54.36.149.45', '1595023740', '2020-07-18 06:09:00');
INSERT INTO `by_history` VALUES ('614', '欧神诺瓷砖 特权订金10元抵500元', '194', '116.179.32.209', '1595025790', '2020-07-18 06:43:10');
INSERT INTO `by_history` VALUES ('615', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '54.36.149.45', '1595026741', '2020-07-18 06:59:01');
INSERT INTO `by_history` VALUES ('616', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '54.36.149.45', '1595027725', '2020-07-18 07:15:25');
INSERT INTO `by_history` VALUES ('617', '泰国龙眼1kg 热带桂圆 进口水果', '164', '54.36.148.1', '1595029761', '2020-07-18 07:49:21');
INSERT INTO `by_history` VALUES ('618', '简约转角书桌实木书架书柜组合一体', '199', '54.36.148.1', '1595033978', '2020-07-18 08:59:38');
INSERT INTO `by_history` VALUES ('619', '新农哥五香花生136g 坚果炒货小吃', '165', '54.36.148.91', '1595035183', '2020-07-18 09:19:43');
INSERT INTO `by_history` VALUES ('620', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '183.95.248.61', '1595038243', '2020-07-18 10:10:43');
INSERT INTO `by_history` VALUES ('621', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '183.95.248.61', '1595038354', '2020-07-18 10:12:34');
INSERT INTO `by_history` VALUES ('622', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '54.36.149.74', '1595043751', '2020-07-18 11:42:31');
INSERT INTO `by_history` VALUES ('623', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '54.36.149.45', '1595044934', '2020-07-18 12:02:14');
INSERT INTO `by_history` VALUES ('624', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '54.36.149.45', '1595046155', '2020-07-18 12:22:35');
INSERT INTO `by_history` VALUES ('625', '百安居 699精致全包装修套餐', '196', '27.18.17.149', '1595048447', '2020-07-18 13:00:47');
INSERT INTO `by_history` VALUES ('626', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '54.36.148.1', '1595053430', '2020-07-18 14:23:50');
INSERT INTO `by_history` VALUES ('627', '欧神诺瓷砖 特权订金10元抵500元', '194', '54.36.149.45', '1595059202', '2020-07-18 16:00:02');
INSERT INTO `by_history` VALUES ('628', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '111.226.232.29', '1595059789', '2020-07-18 16:09:49');
INSERT INTO `by_history` VALUES ('629', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '54.36.148.1', '1595062002', '2020-07-18 16:46:42');
INSERT INTO `by_history` VALUES ('630', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '223.149.203.250', '1595063685', '2020-07-18 17:14:45');
INSERT INTO `by_history` VALUES ('631', '联想 小新 潮7000-13 (i7 8550u)', '227', '54.36.149.45', '1595064765', '2020-07-18 17:32:45');
INSERT INTO `by_history` VALUES ('632', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '223.104.130.32', '1595067182', '2020-07-18 18:13:02');
INSERT INTO `by_history` VALUES ('633', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '40.77.167.134', '1595067852', '2020-07-18 18:24:12');
INSERT INTO `by_history` VALUES ('634', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '113.140.249.202', '1595070645', '2020-07-18 19:10:45');
INSERT INTO `by_history` VALUES ('635', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.140.249.202', '1595070670', '2020-07-18 19:11:10');
INSERT INTO `by_history` VALUES ('636', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '54.36.148.192', '1595071094', '2020-07-18 19:18:14');
INSERT INTO `by_history` VALUES ('637', '阿迪达斯男裤2017冬季小脚运动裤保暖', '184', '182.254.52.17', '1595071754', '2020-07-18 19:29:14');
INSERT INTO `by_history` VALUES ('638', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '111.197.247.104', '1595086682', '2020-07-18 23:38:02');
INSERT INTO `by_history` VALUES ('639', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '210.22.245.219', '1595086746', '2020-07-18 23:39:06');
INSERT INTO `by_history` VALUES ('640', '联想 小新 潮7000-13 (i7 8550u)', '227', '157.55.39.8', '1595091017', '2020-07-19 00:50:17');
INSERT INTO `by_history` VALUES ('641', '百安居 699精致全包装修套餐', '196', '54.36.149.45', '1595096511', '2020-07-19 02:21:51');
INSERT INTO `by_history` VALUES ('642', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '54.36.149.45', '1595102609', '2020-07-19 04:03:29');
INSERT INTO `by_history` VALUES ('643', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '54.36.148.1', '1595107365', '2020-07-19 05:22:45');
INSERT INTO `by_history` VALUES ('644', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '54.36.148.1', '1595118108', '2020-07-19 08:21:48');
INSERT INTO `by_history` VALUES ('645', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '220.181.108.93', '1595118199', '2020-07-19 08:23:19');
INSERT INTO `by_history` VALUES ('646', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '116.179.32.29', '1595125365', '2020-07-19 10:22:45');
INSERT INTO `by_history` VALUES ('647', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '1.80.2.214', '1595126489', '2020-07-19 10:41:29');
INSERT INTO `by_history` VALUES ('648', 'Xiaomi/小米 小米手机Note3 ', '209', '1.80.144.68', '1595126529', '2020-07-19 10:42:09');
INSERT INTO `by_history` VALUES ('649', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '1.80.2.214', '1595126563', '2020-07-19 10:42:43');
INSERT INTO `by_history` VALUES ('650', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '122.192.228.206', '1595127559', '2020-07-19 10:59:19');
INSERT INTO `by_history` VALUES ('651', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '54.36.149.2', '1595128026', '2020-07-19 11:07:06');
INSERT INTO `by_history` VALUES ('652', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '172', '54.36.149.54', '1595133948', '2020-07-19 12:45:48');
INSERT INTO `by_history` VALUES ('653', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.95.251.183', '1595134590', '2020-07-19 12:56:30');
INSERT INTO `by_history` VALUES ('654', '正版书籍包邮 龙应台人生三书', '186', '183.95.251.183', '1595135089', '2020-07-19 13:04:49');
INSERT INTO `by_history` VALUES ('655', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.95.251.183', '1595135093', '2020-07-19 13:04:53');
INSERT INTO `by_history` VALUES ('656', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '183.95.251.183', '1595135097', '2020-07-19 13:04:57');
INSERT INTO `by_history` VALUES ('657', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '54.36.148.1', '1595136902', '2020-07-19 13:35:02');
INSERT INTO `by_history` VALUES ('658', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '54.36.148.1', '1595142707', '2020-07-19 15:11:47');
INSERT INTO `by_history` VALUES ('659', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '111.58.84.86', '1595147544', '2020-07-19 16:32:24');
INSERT INTO `by_history` VALUES ('660', '简约转角书桌实木书架书柜组合一体', '199', '117.82.253.167', '1595149945', '2020-07-19 17:12:25');
INSERT INTO `by_history` VALUES ('661', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '42.156.138.63', '1595160119', '2020-07-19 20:01:59');
INSERT INTO `by_history` VALUES ('662', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.247.14', '1595164363', '2020-07-19 21:12:43');
INSERT INTO `by_history` VALUES ('663', '欧神诺瓷砖 特权订金10元抵500元', '194', '113.57.247.14', '1595164373', '2020-07-19 21:12:53');
INSERT INTO `by_history` VALUES ('664', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '113.57.247.14', '1595164380', '2020-07-19 21:13:00');
INSERT INTO `by_history` VALUES ('665', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '180', '54.36.149.73', '1595165581', '2020-07-19 21:33:01');
INSERT INTO `by_history` VALUES ('666', '正版书籍包邮 龙应台人生三书', '186', '113.57.247.14', '1595165828', '2020-07-19 21:37:08');
INSERT INTO `by_history` VALUES ('667', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '197', '207.46.13.86', '1595167134', '2020-07-19 21:58:54');
INSERT INTO `by_history` VALUES ('668', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '54.36.148.16', '1595171041', '2020-07-19 23:04:01');
INSERT INTO `by_history` VALUES ('669', '【国家图书奖】鲁迅散文选集', '192', '220.181.108.165', '1595175159', '2020-07-20 00:12:39');
INSERT INTO `by_history` VALUES ('670', '正版书籍包邮 龙应台人生三书', '186', '220.181.108.146', '1595177859', '2020-07-20 00:57:39');
INSERT INTO `by_history` VALUES ('671', '【亚马逊图书】王小波文集：黄金时代+青铜时代+', '190', '220.181.108.90', '1595179209', '2020-07-20 01:20:09');
INSERT INTO `by_history` VALUES ('672', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '220.181.108.180', '1595202714', '2020-07-20 07:51:54');
INSERT INTO `by_history` VALUES ('673', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '223.11.39.31', '1595211721', '2020-07-20 10:22:01');
INSERT INTO `by_history` VALUES ('674', '正版书籍包邮 龙应台人生三书', '186', '223.11.39.31', '1595213551', '2020-07-20 10:52:31');
INSERT INTO `by_history` VALUES ('675', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.95.251.44', '1595226283', '2020-07-20 14:24:43');
INSERT INTO `by_history` VALUES ('676', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '183.95.251.44', '1595227339', '2020-07-20 14:42:19');
INSERT INTO `by_history` VALUES ('677', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.95.251.44', '1595230391', '2020-07-20 15:33:11');
INSERT INTO `by_history` VALUES ('678', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '183.95.251.44', '1595230713', '2020-07-20 15:38:33');
INSERT INTO `by_history` VALUES ('679', '欧神诺瓷砖 特权订金10元抵500元', '194', '183.95.251.44', '1595232946', '2020-07-20 16:15:46');
INSERT INTO `by_history` VALUES ('680', 'ZARA 男装 绒面质感裤子 06706310707', '182', '222.64.153.180', '1595234030', '2020-07-20 16:33:50');
INSERT INTO `by_history` VALUES ('681', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '183.95.251.44', '1595235579', '2020-07-20 16:59:39');
INSERT INTO `by_history` VALUES ('682', '套餐】Apple iPad 32G银+intermail', '204', '101.26.202.211', '1595239239', '2020-07-20 18:00:39');
INSERT INTO `by_history` VALUES ('683', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '183.95.251.89', '1595239822', '2020-07-20 18:10:22');
INSERT INTO `by_history` VALUES ('684', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '181', '116.179.32.30', '1595261092', '2020-07-21 00:04:52');
INSERT INTO `by_history` VALUES ('685', '正版书籍包邮 龙应台人生三书', '186', '211.91.139.158', '1595298857', '2020-07-21 10:34:17');
INSERT INTO `by_history` VALUES ('686', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.92.250.216', '1595309327', '2020-07-21 13:28:47');
INSERT INTO `by_history` VALUES ('687', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.92.250.216', '1595309341', '2020-07-21 13:29:01');
INSERT INTO `by_history` VALUES ('688', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '183.92.250.216', '1595309359', '2020-07-21 13:29:19');
INSERT INTO `by_history` VALUES ('689', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '122.96.47.64', '1595313166', '2020-07-21 14:32:46');
INSERT INTO `by_history` VALUES ('690', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '180.163.220.4', '1595319529', '2020-07-21 16:18:49');
INSERT INTO `by_history` VALUES ('691', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '180.163.220.66', '1595319547', '2020-07-21 16:19:07');
INSERT INTO `by_history` VALUES ('692', '套餐】Apple iPad 32G银+intermail', '204', '183.92.250.216', '1595324972', '2020-07-21 17:49:32');
INSERT INTO `by_history` VALUES ('693', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '183.92.250.216', '1595325031', '2020-07-21 17:50:31');
INSERT INTO `by_history` VALUES ('694', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '183.92.250.216', '1595325511', '2020-07-21 17:58:31');
INSERT INTO `by_history` VALUES ('695', '永赢一路发一苏宁银车挂 银色', '208', '113.140.249.230', '1595328046', '2020-07-21 18:40:46');
INSERT INTO `by_history` VALUES ('696', '套餐】Apple iPad 32G银+intermail', '204', '220.181.108.117', '1595337468', '2020-07-21 21:17:48');
INSERT INTO `by_history` VALUES ('697', '浮生六记（汪涵推荐，全译本，畅销150万册）', '231', '116.179.32.98', '1595338348', '2020-07-21 21:32:28');
INSERT INTO `by_history` VALUES ('698', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '187', '116.179.32.146', '1595339229', '2020-07-21 21:47:09');
INSERT INTO `by_history` VALUES ('699', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '58.16.109.242', '1595339249', '2020-07-21 21:47:29');
INSERT INTO `by_history` VALUES ('700', '正版书籍包邮 龙应台人生三书', '186', '183.92.250.216', '1595339393', '2020-07-21 21:49:53');
INSERT INTO `by_history` VALUES ('701', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '42.156.139.42', '1595342428', '2020-07-21 22:40:28');
INSERT INTO `by_history` VALUES ('702', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '40.77.167.5', '1595350175', '2020-07-22 00:49:35');
INSERT INTO `by_history` VALUES ('703', '百安居 699精致全包装修套餐', '196', '42.120.161.23', '1595367153', '2020-07-22 05:32:33');
INSERT INTO `by_history` VALUES ('704', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '181', '13.66.139.0', '1595371902', '2020-07-22 06:51:42');
INSERT INTO `by_history` VALUES ('705', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '206', '220.181.108.185', '1595375773', '2020-07-22 07:56:13');
INSERT INTO `by_history` VALUES ('706', '卡宾Cabbeen 短袖T恤男装黑色', '229', '42.156.136.40', '1595382696', '2020-07-22 09:51:36');
INSERT INTO `by_history` VALUES ('707', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '27.38.49.132', '1595385845', '2020-07-22 10:44:05');
INSERT INTO `by_history` VALUES ('708', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '117.148.109.116', '1595388078', '2020-07-22 11:21:18');
INSERT INTO `by_history` VALUES ('709', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '117.148.109.116', '1595388099', '2020-07-22 11:21:39');
INSERT INTO `by_history` VALUES ('710', '2018年注册会计师全国统一考试辅导教材 ', '230', '220.181.108.147', '1595392617', '2020-07-22 12:36:57');
INSERT INTO `by_history` VALUES ('711', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '115.60.179.222', '1595392886', '2020-07-22 12:41:26');
INSERT INTO `by_history` VALUES ('712', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '120.231.178.104', '1595399672', '2020-07-22 14:34:32');
INSERT INTO `by_history` VALUES ('713', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '181', '106.11.159.117', '1595399888', '2020-07-22 14:38:08');
INSERT INTO `by_history` VALUES ('714', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '36.57.138.242', '1595408912', '2020-07-22 17:08:32');
INSERT INTO `by_history` VALUES ('715', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '223.88.199.31', '1595411471', '2020-07-22 17:51:11');
INSERT INTO `by_history` VALUES ('716', '套餐】Apple iPad 32G银+intermail', '204', '183.95.249.14', '1595415678', '2020-07-22 19:01:18');
INSERT INTO `by_history` VALUES ('717', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '183.95.249.14', '1595416202', '2020-07-22 19:10:02');
INSERT INTO `by_history` VALUES ('718', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '61.184.161.71', '1595423538', '2020-07-22 21:12:18');
INSERT INTO `by_history` VALUES ('719', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '61.184.161.71', '1595423543', '2020-07-22 21:12:23');
INSERT INTO `by_history` VALUES ('720', '套餐】Apple iPad 32G银+intermail', '204', '61.184.161.71', '1595423559', '2020-07-22 21:12:39');
INSERT INTO `by_history` VALUES ('721', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '61.184.161.71', '1595423590', '2020-07-22 21:13:10');
INSERT INTO `by_history` VALUES ('722', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '58.20.149.165', '1595429849', '2020-07-22 22:57:29');
INSERT INTO `by_history` VALUES ('723', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '61.142.233.161', '1595432338', '2020-07-22 23:38:58');
INSERT INTO `by_history` VALUES ('724', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '14.116.221.79', '1595436293', '2020-07-23 00:44:53');
INSERT INTO `by_history` VALUES ('725', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '220.181.108.153', '1595450617', '2020-07-23 04:43:37');
INSERT INTO `by_history` VALUES ('726', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '182.254.52.17', '1595453553', '2020-07-23 05:32:33');
INSERT INTO `by_history` VALUES ('727', '罗辑思维官方 今天故事书', '189', '116.179.32.225', '1595472217', '2020-07-23 10:43:37');
INSERT INTO `by_history` VALUES ('728', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '36.106.137.129', '1595473250', '2020-07-23 11:00:50');
INSERT INTO `by_history` VALUES ('729', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '36.106.137.129', '1595473358', '2020-07-23 11:02:38');
INSERT INTO `by_history` VALUES ('730', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '36.106.137.129', '1595473368', '2020-07-23 11:02:48');
INSERT INTO `by_history` VALUES ('731', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '36.106.137.129', '1595473381', '2020-07-23 11:03:01');
INSERT INTO `by_history` VALUES ('732', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '121.69.131.178', '1595479804', '2020-07-23 12:50:04');
INSERT INTO `by_history` VALUES ('733', 'ZARA 男装 绒面质感裤子 06706310707', '182', '125.71.99.85', '1595482551', '2020-07-23 13:35:51');
INSERT INTO `by_history` VALUES ('734', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.57.245.198', '1595483015', '2020-07-23 13:43:35');
INSERT INTO `by_history` VALUES ('735', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '157.55.39.55', '1595484979', '2020-07-23 14:16:19');
INSERT INTO `by_history` VALUES ('736', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '113.57.245.198', '1595487504', '2020-07-23 14:58:24');
INSERT INTO `by_history` VALUES ('737', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.245.198', '1595488890', '2020-07-23 15:21:30');
INSERT INTO `by_history` VALUES ('738', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '113.57.245.198', '1595488893', '2020-07-23 15:21:33');
INSERT INTO `by_history` VALUES ('739', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', '171', '117.30.116.220', '1595493332', '2020-07-23 16:35:32');
INSERT INTO `by_history` VALUES ('740', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '117.30.116.220', '1595493344', '2020-07-23 16:35:44');
INSERT INTO `by_history` VALUES ('741', '套餐】Apple iPad 32G银+intermail', '204', '117.30.116.220', '1595493348', '2020-07-23 16:35:48');
INSERT INTO `by_history` VALUES ('742', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '220.181.108.184', '1595501017', '2020-07-23 18:43:37');
INSERT INTO `by_history` VALUES ('743', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '27.68.179.140', '1595504605', '2020-07-23 19:43:25');
INSERT INTO `by_history` VALUES ('744', '正版书籍包邮 龙应台人生三书', '186', '113.57.245.198', '1595505053', '2020-07-23 19:50:53');
INSERT INTO `by_history` VALUES ('745', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '36.42.252.50', '1595506398', '2020-07-23 20:13:18');
INSERT INTO `by_history` VALUES ('746', '套餐】Apple iPad 32G银+intermail', '204', '113.57.245.198', '1595507173', '2020-07-23 20:26:13');
INSERT INTO `by_history` VALUES ('747', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '113.57.245.198', '1595507186', '2020-07-23 20:26:26');
INSERT INTO `by_history` VALUES ('748', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '113.57.245.198', '1595507191', '2020-07-23 20:26:31');
INSERT INTO `by_history` VALUES ('749', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '112.99.19.167', '1595508165', '2020-07-23 20:42:45');
INSERT INTO `by_history` VALUES ('750', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '113.57.245.198', '1595516207', '2020-07-23 22:56:47');
INSERT INTO `by_history` VALUES ('751', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '113.57.245.198', '1595516410', '2020-07-23 23:00:10');
INSERT INTO `by_history` VALUES ('752', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '113.57.245.198', '1595516429', '2020-07-23 23:00:29');
INSERT INTO `by_history` VALUES ('753', '欧神诺瓷砖 特权订金10元抵500元', '194', '113.57.245.198', '1595516491', '2020-07-23 23:01:31');
INSERT INTO `by_history` VALUES ('754', '永赢一路发一苏宁银车挂 银色', '208', '207.46.13.7', '1595526347', '2020-07-24 01:45:47');
INSERT INTO `by_history` VALUES ('755', '套餐】Apple iPad 32G银+intermail', '204', '207.46.13.7', '1595526348', '2020-07-24 01:45:48');
INSERT INTO `by_history` VALUES ('756', '国家图书奖朱自清散文集徐志摩经典大全集', '188', '207.46.13.188', '1595526688', '2020-07-24 01:51:28');
INSERT INTO `by_history` VALUES ('757', '国家图书奖朱自清散文集徐志摩经典大全集', '188', '116.179.32.204', '1595565501', '2020-07-24 12:38:21');
INSERT INTO `by_history` VALUES ('758', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '176', '116.179.32.227', '1595569502', '2020-07-24 13:45:02');
INSERT INTO `by_history` VALUES ('759', '正版书籍包邮 龙应台人生三书', '186', '183.92.251.113', '1595571329', '2020-07-24 14:15:29');
INSERT INTO `by_history` VALUES ('760', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.92.251.113', '1595571522', '2020-07-24 14:18:42');
INSERT INTO `by_history` VALUES ('761', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.92.251.113', '1595574098', '2020-07-24 15:01:38');
INSERT INTO `by_history` VALUES ('762', '罗辑思维官方 今天故事书', '189', '182.254.52.17', '1595581485', '2020-07-24 17:04:45');
INSERT INTO `by_history` VALUES ('763', '永赢一路发一苏宁银车挂 银色', '208', '116.179.32.176', '1595586774', '2020-07-24 18:32:54');
INSERT INTO `by_history` VALUES ('764', 'Xiaomi/小米 小米手机Note3 ', '209', '220.181.108.150', '1595587314', '2020-07-24 18:41:54');
INSERT INTO `by_history` VALUES ('765', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.244.191', '1595589829', '2020-07-24 19:23:49');
INSERT INTO `by_history` VALUES ('766', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '187', '182.142.134.28', '1595610824', '2020-07-25 01:13:44');
INSERT INTO `by_history` VALUES ('767', '欧神诺瓷砖 特权订金10元抵500元', '194', '157.55.39.55', '1595612682', '2020-07-25 01:44:42');
INSERT INTO `by_history` VALUES ('768', '国家图书奖朱自清散文集徐志摩经典大全集', '188', '182.254.52.17', '1595616526', '2020-07-25 02:48:46');
INSERT INTO `by_history` VALUES ('769', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '176', '183.192.179.16', '1595633113', '2020-07-25 07:25:13');
INSERT INTO `by_history` VALUES ('770', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '120.36.53.178', '1595661062', '2020-07-25 15:11:02');
INSERT INTO `by_history` VALUES ('771', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '113.57.183.20', '1595664179', '2020-07-25 16:02:59');
INSERT INTO `by_history` VALUES ('772', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '54.36.148.179', '1595685957', '2020-07-25 22:05:57');
INSERT INTO `by_history` VALUES ('773', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '40.77.167.5', '1595697043', '2020-07-26 01:10:43');
INSERT INTO `by_history` VALUES ('774', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', '171', '116.179.32.164', '1595699086', '2020-07-26 01:44:46');
INSERT INTO `by_history` VALUES ('775', '罗辑思维官方 今天故事书', '189', '54.36.148.1', '1595712087', '2020-07-26 05:21:27');
INSERT INTO `by_history` VALUES ('776', '国家图书奖朱自清散文集徐志摩经典大全集', '188', '40.77.167.217', '1595714903', '2020-07-26 06:08:23');
INSERT INTO `by_history` VALUES ('777', '联想 小新 潮7000-13 (i7 8550u)', '227', '112.99.19.167', '1595722932', '2020-07-26 08:22:12');
INSERT INTO `by_history` VALUES ('778', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '112.99.19.167', '1595722941', '2020-07-26 08:22:21');
INSERT INTO `by_history` VALUES ('779', '欧神诺瓷砖 特权订金10元抵500元', '194', '182.254.52.17', '1595724967', '2020-07-26 08:56:07');
INSERT INTO `by_history` VALUES ('780', 'OPPO耳机原装正品全球限量版', '178', '54.36.149.45', '1595728010', '2020-07-26 09:46:50');
INSERT INTO `by_history` VALUES ('781', 'ZARA 男装 绒面质感裤子 06706310707', '182', '54.36.148.1', '1595731559', '2020-07-26 10:45:59');
INSERT INTO `by_history` VALUES ('782', '布鲁克林有棵树正版包邮(美)史密斯著', '191', '220.181.108.88', '1595741234', '2020-07-26 13:27:14');
INSERT INTO `by_history` VALUES ('783', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '101.83.137.0', '1595751218', '2020-07-26 16:13:38');
INSERT INTO `by_history` VALUES ('784', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '106.121.131.31', '1595751383', '2020-07-26 16:16:23');
INSERT INTO `by_history` VALUES ('785', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '106.121.131.31', '1595751414', '2020-07-26 16:16:54');
INSERT INTO `by_history` VALUES ('786', 'HLA海澜之家短袖T恤男基础款简约圆领', '228', '54.36.148.1', '1595761108', '2020-07-26 18:58:28');
INSERT INTO `by_history` VALUES ('787', '新农哥五香花生136g 坚果炒货小吃', '165', '54.36.148.1', '1595761968', '2020-07-26 19:12:48');
INSERT INTO `by_history` VALUES ('788', '初等英语3-6级词汇速记手册', '193', '116.179.32.202', '1595763733', '2020-07-26 19:42:13');
INSERT INTO `by_history` VALUES ('789', '简约转角书桌实木书架书柜组合一体', '199', '54.36.149.45', '1595764494', '2020-07-26 19:54:54');
INSERT INTO `by_history` VALUES ('790', '厨房置物架 壁挂 304不锈钢刀架厨具', '200', '54.36.148.74', '1595766182', '2020-07-26 20:23:02');
INSERT INTO `by_history` VALUES ('791', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '220.181.108.186', '1595772744', '2020-07-26 22:12:24');
INSERT INTO `by_history` VALUES ('792', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '54.36.148.1', '1595773868', '2020-07-26 22:31:08');
INSERT INTO `by_history` VALUES ('793', '罗辑思维官方 今天故事书', '189', '116.179.32.83', '1595780345', '2020-07-27 00:19:05');
INSERT INTO `by_history` VALUES ('794', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '54.36.149.45', '1595780492', '2020-07-27 00:21:32');
INSERT INTO `by_history` VALUES ('795', '欧神诺瓷砖 特权订金10元抵500元', '194', '54.36.148.1', '1595797177', '2020-07-27 04:59:37');
INSERT INTO `by_history` VALUES ('796', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '195', '54.36.148.17', '1595803794', '2020-07-27 06:49:54');
INSERT INTO `by_history` VALUES ('797', '联想 小新 潮7000-13 (i7 8550u)', '227', '54.36.148.1', '1595805953', '2020-07-27 07:25:53');
INSERT INTO `by_history` VALUES ('798', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '54.36.149.45', '1595813536', '2020-07-27 09:32:16');
INSERT INTO `by_history` VALUES ('799', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '176', '117.89.241.233', '1595819431', '2020-07-27 11:10:31');
INSERT INTO `by_history` VALUES ('800', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '111.226.232.210', '1595822646', '2020-07-27 12:04:06');
INSERT INTO `by_history` VALUES ('801', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '54.36.149.45', '1595832346', '2020-07-27 14:45:46');
INSERT INTO `by_history` VALUES ('802', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '116.249.107.247', '1595834546', '2020-07-27 15:22:26');
INSERT INTO `by_history` VALUES ('803', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '183.95.249.142', '1595836148', '2020-07-27 15:49:08');
INSERT INTO `by_history` VALUES ('804', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.95.249.142', '1595842789', '2020-07-27 17:39:49');
INSERT INTO `by_history` VALUES ('805', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.95.249.142', '1595843585', '2020-07-27 17:53:05');
INSERT INTO `by_history` VALUES ('806', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '183.95.249.142', '1595843651', '2020-07-27 17:54:11');
INSERT INTO `by_history` VALUES ('807', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '113.245.211.212', '1595848114', '2020-07-27 19:08:34');
INSERT INTO `by_history` VALUES ('808', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '118.249.21.245', '1595855320', '2020-07-27 21:08:40');
INSERT INTO `by_history` VALUES ('809', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '54.36.149.45', '1595860407', '2020-07-27 22:33:27');
INSERT INTO `by_history` VALUES ('810', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '173', '54.36.149.45', '1595861260', '2020-07-27 22:47:40');
INSERT INTO `by_history` VALUES ('811', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '54.36.149.45', '1595865211', '2020-07-27 23:53:31');
INSERT INTO `by_history` VALUES ('812', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '54.36.149.21', '1595870337', '2020-07-28 01:18:57');
INSERT INTO `by_history` VALUES ('813', '罗辑思维官方 今天故事书', '189', '14.18.182.223', '1595873894', '2020-07-28 02:18:14');
INSERT INTO `by_history` VALUES ('814', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '54.36.148.117', '1595875270', '2020-07-28 02:41:10');
INSERT INTO `by_history` VALUES ('815', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '54.36.148.188', '1595894294', '2020-07-28 07:58:14');
INSERT INTO `by_history` VALUES ('816', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '180', '54.36.148.236', '1595897379', '2020-07-28 08:49:39');
INSERT INTO `by_history` VALUES ('817', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '169', '54.36.149.45', '1595901999', '2020-07-28 10:06:39');
INSERT INTO `by_history` VALUES ('818', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '183.195.6.152', '1595908789', '2020-07-28 11:59:49');
INSERT INTO `by_history` VALUES ('819', '阿迪达斯长裤男 2017秋季新款运动裤针织', '185', '183.195.6.152', '1595908850', '2020-07-28 12:00:50');
INSERT INTO `by_history` VALUES ('820', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '183.195.6.152', '1595909512', '2020-07-28 12:11:52');
INSERT INTO `by_history` VALUES ('821', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.195.6.152', '1595910272', '2020-07-28 12:24:32');
INSERT INTO `by_history` VALUES ('822', '欧神诺瓷砖 特权订金10元抵500元', '194', '183.95.249.142', '1595914278', '2020-07-28 13:31:18');
INSERT INTO `by_history` VALUES ('823', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '183.95.249.142', '1595914303', '2020-07-28 13:31:43');
INSERT INTO `by_history` VALUES ('824', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '157.55.39.58', '1595919171', '2020-07-28 14:52:51');
INSERT INTO `by_history` VALUES ('825', '正版书籍包邮 龙应台人生三书', '186', '183.95.249.142', '1595922286', '2020-07-28 15:44:46');
INSERT INTO `by_history` VALUES ('826', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '40.77.167.97', '1595923067', '2020-07-28 15:57:47');
INSERT INTO `by_history` VALUES ('827', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.17.48.47', '1595940259', '2020-07-28 20:44:19');
INSERT INTO `by_history` VALUES ('828', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '113.57.247.129', '1595944739', '2020-07-28 21:58:59');
INSERT INTO `by_history` VALUES ('829', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '113.57.247.129', '1595945654', '2020-07-28 22:14:14');
INSERT INTO `by_history` VALUES ('830', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '113.57.247.129', '1595947316', '2020-07-28 22:41:56');
INSERT INTO `by_history` VALUES ('831', '联想 小新 潮7000-13 (i7 8550u)', '227', '113.57.247.129', '1595947340', '2020-07-28 22:42:20');
INSERT INTO `by_history` VALUES ('832', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '113.57.247.129', '1595947362', '2020-07-28 22:42:42');
INSERT INTO `by_history` VALUES ('833', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '207', '113.57.247.129', '1595947411', '2020-07-28 22:43:31');
INSERT INTO `by_history` VALUES ('834', '美国进口 健安喜（GNC）三倍浓缩鱼', '234', '54.36.149.45', '1595949464', '2020-07-28 23:17:44');
INSERT INTO `by_history` VALUES ('835', '陕西精品红富士1kg 80-85mm 苹果 水果', '163', '54.36.148.242', '1595959129', '2020-07-29 01:58:49');
INSERT INTO `by_history` VALUES ('836', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '183.92.251.123', '1595979965', '2020-07-29 07:46:05');
INSERT INTO `by_history` VALUES ('837', '【低至5488元】Apple/苹果iPhone 8 Plus ', '170', '183.92.251.123', '1595979977', '2020-07-29 07:46:17');
INSERT INTO `by_history` VALUES ('838', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.92.251.123', '1595980005', '2020-07-29 07:46:45');
INSERT INTO `by_history` VALUES ('839', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '183.92.251.123', '1595980009', '2020-07-29 07:46:49');
INSERT INTO `by_history` VALUES ('840', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '183.92.251.123', '1595981423', '2020-07-29 08:10:23');
INSERT INTO `by_history` VALUES ('841', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '123.169.43.61', '1595995600', '2020-07-29 12:06:40');
INSERT INTO `by_history` VALUES ('842', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '123.169.43.61', '1595995608', '2020-07-29 12:06:48');
INSERT INTO `by_history` VALUES ('843', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '207.46.13.243', '1595996543', '2020-07-29 12:22:23');
INSERT INTO `by_history` VALUES ('844', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '183.92.251.123', '1596010851', '2020-07-29 16:20:51');
INSERT INTO `by_history` VALUES ('845', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '1.170.0.191', '1596025258', '2020-07-29 20:20:58');
INSERT INTO `by_history` VALUES ('846', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '120.230.95.244', '1596028475', '2020-07-29 21:14:35');
INSERT INTO `by_history` VALUES ('847', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '120.230.95.244', '1596028494', '2020-07-29 21:14:54');
INSERT INTO `by_history` VALUES ('848', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '120.230.95.244', '1596028499', '2020-07-29 21:14:59');
INSERT INTO `by_history` VALUES ('849', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '120.230.95.244', '1596028595', '2020-07-29 21:16:35');
INSERT INTO `by_history` VALUES ('850', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '120.230.95.244', '1596028750', '2020-07-29 21:19:10');
INSERT INTO `by_history` VALUES ('851', '卡宾Cabbeen 短袖T恤男装黑色', '229', '120.230.95.244', '1596029279', '2020-07-29 21:27:59');
INSERT INTO `by_history` VALUES ('852', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '54.36.149.45', '1596047396', '2020-07-30 02:29:56');
INSERT INTO `by_history` VALUES ('853', 'OPPO R11S全面屏拍照4G手机oppor11s', '174', '182.254.52.17', '1596048208', '2020-07-30 02:43:28');
INSERT INTO `by_history` VALUES ('854', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '182.254.52.17', '1596050406', '2020-07-30 03:20:06');
INSERT INTO `by_history` VALUES ('855', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '61.241.50.63', '1596053964', '2020-07-30 04:19:24');
INSERT INTO `by_history` VALUES ('856', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '183.95.251.101', '1596066223', '2020-07-30 07:43:43');
INSERT INTO `by_history` VALUES ('857', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '203', '::1', '1596094008', '2020-07-30 15:26:48');
INSERT INTO `by_history` VALUES ('858', 'Apple iPad mini 4 7.9英寸平板电脑', '205', '::1', '1596097183', '2020-07-30 16:19:43');
INSERT INTO `by_history` VALUES ('859', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '223', '::1', '1596097200', '2020-07-30 16:20:00');
INSERT INTO `by_history` VALUES ('860', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '224', '::1', '1596273854', '2020-08-01 17:24:14');
INSERT INTO `by_history` VALUES ('861', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '167', '::1', '1596284997', '2020-08-01 20:29:57');
INSERT INTO `by_history` VALUES ('862', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '225', '::1', '1596372186', '2020-08-02 20:43:06');
INSERT INTO `by_history` VALUES ('863', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '235', '::1', '1596631534', '2020-08-05 20:45:34');
INSERT INTO `by_history` VALUES ('864', '联想 小新 潮7000-13 (i7 8550u)', '227', '::1', '1596633075', '2020-08-05 21:11:15');
INSERT INTO `by_history` VALUES ('865', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '201', '::1', '1596700218', '2020-08-06 15:50:18');
INSERT INTO `by_history` VALUES ('866', '简约转角书桌实木书架书柜组合一体', '199', '::1', '1596700222', '2020-08-06 15:50:22');
INSERT INTO `by_history` VALUES ('867', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '175', '::1', '1596793031', '2020-08-07 17:37:11');
INSERT INTO `by_history` VALUES ('868', '欧神诺瓷砖 特权订金10元抵500元', '194', '::1', '1596805126', '2020-08-07 20:58:46');
INSERT INTO `by_history` VALUES ('869', '正版书籍包邮 龙应台人生三书', '186', '::1', '1597070645', '2020-08-10 22:44:05');
INSERT INTO `by_history` VALUES ('870', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '168', '::1', '1597641171', '2020-08-17 13:12:51');
INSERT INTO `by_history` VALUES ('871', '罗辑思维官方 今天故事书', '189', '::1', '1597744954', '2020-08-18 18:02:34');
INSERT INTO `by_history` VALUES ('872', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '162', '::1', '1597749215', '2020-08-18 19:13:35');
INSERT INTO `by_history` VALUES ('873', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '179', '::1', '1597909680', '2020-08-20 15:48:00');
INSERT INTO `by_history` VALUES ('874', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '166', '::1', '1598671088', '2020-08-29 11:18:08');
INSERT INTO `by_history` VALUES ('875', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '183', '::1', '1598672120', '2020-08-29 11:35:20');
INSERT INTO `by_history` VALUES ('876', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '177', '::1', '1598764269', '2020-08-30 13:11:09');
INSERT INTO `by_history` VALUES ('877', 'ZARA 男装 绒面质感裤子 06706310707', '182', '::1', '1599729313', '2020-09-10 17:15:13');

-- ----------------------------
-- Table structure for by_hooks
-- ----------------------------
DROP TABLE IF EXISTS `by_hooks`;
CREATE TABLE `by_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `addons` varchar(255) NOT NULL DEFAULT '' COMMENT '钩子挂载的插件 ''，''分割',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_hooks
-- ----------------------------
INSERT INTO `by_hooks` VALUES ('22', 'send', 'send钩子', '1', '1384481614', 'sms', '1');
INSERT INTO `by_hooks` VALUES ('59', 'qq', 'qq登录插件', '1', '0', 'qq', '1');
INSERT INTO `by_hooks` VALUES ('30', 'wechat', 'wechat登录', '1', '1596295289', 'wechat', '1');
INSERT INTO `by_hooks` VALUES ('58', 'alipay', '支付宝pc支付插件', '1', '0', 'alipay', '1');

-- ----------------------------
-- Table structure for by_images
-- ----------------------------
DROP TABLE IF EXISTS `by_images`;
CREATE TABLE `by_images` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '单图文id列表，如1,2,3',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信多图文回复表';

-- ----------------------------
-- Records of by_images
-- ----------------------------

-- ----------------------------
-- Table structure for by_keyword
-- ----------------------------
DROP TABLE IF EXISTS `by_keyword`;
CREATE TABLE `by_keyword` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `uid` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `remark` varchar(225) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `key` varchar(225) DEFAULT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='搜索表';

-- ----------------------------
-- Records of by_keyword
-- ----------------------------

-- ----------------------------
-- Table structure for by_menu
-- ----------------------------
DROP TABLE IF EXISTS `by_menu`;
CREATE TABLE `by_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `group` varchar(50) DEFAULT '' COMMENT '分组',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=188 DEFAULT CHARSET=utf8 COMMENT='微信自定义菜单表';

-- ----------------------------
-- Records of by_menu
-- ----------------------------
INSERT INTO `by_menu` VALUES ('1', '首页', '0', '1', 'Index/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('2', '文章', '0', '5', 'Article/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('3', '文档列表', '2', '0', 'article/index', '1', '', '内容', '0', '1');
INSERT INTO `by_menu` VALUES ('4', '新增', '3', '0', 'article/add', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('5', '编辑', '3', '0', 'article/edit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('6', '改变状态', '3', '0', 'article/setStatus', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('7', '保存', '3', '0', 'article/update', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('8', '保存草稿', '3', '0', 'article/autoSave', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('9', '移动', '3', '0', 'article/move', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('10', '复制', '3', '0', 'article/copy', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('11', '粘贴', '3', '0', 'article/paste', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('12', '导入', '3', '0', 'article/batchOperate', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('13', '回收站', '2', '0', 'article/recycle', '1', '', '内容', '0', '1');
INSERT INTO `by_menu` VALUES ('14', '还原', '13', '0', 'article/permit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('15', '清空', '13', '0', 'article/clear', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('16', '用户', '0', '8', 'User/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('17', '用户信息', '16', '0', 'User/index', '0', '', '用户管理', '0', '1');
INSERT INTO `by_menu` VALUES ('18', '新增用户', '17', '0', 'User/add', '0', '添加新用户', '', '0', '1');
INSERT INTO `by_menu` VALUES ('19', '用户行为', '16', '0', 'User/action', '0', '', '行为管理', '0', '1');
INSERT INTO `by_menu` VALUES ('20', '新增用户行为', '19', '0', 'User/addaction', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('21', '编辑用户行为', '19', '0', 'User/editaction', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('22', '保存用户行为', '19', '0', 'User/saveAction', '0', '\"用户->用户行为\"保存编辑和新增的用户行为', '', '0', '1');
INSERT INTO `by_menu` VALUES ('23', '变更行为状态', '19', '0', 'User/setStatus', '0', '\"用户->用户行为\"中的启用,禁用和删除权限', '', '0', '1');
INSERT INTO `by_menu` VALUES ('24', '禁用会员', '19', '0', 'User/changeStatus?method=forbidUser', '0', '\"用户->用户信息\"中的禁用', '', '0', '1');
INSERT INTO `by_menu` VALUES ('25', '启用会员', '19', '0', 'User/changeStatus?method=resumeUser', '0', '\"用户->用户信息\"中的启用', '', '0', '1');
INSERT INTO `by_menu` VALUES ('26', '删除会员', '19', '0', 'User/changeStatus?method=deleteUser', '0', '\"用户->用户信息\"中的删除', '', '0', '1');
INSERT INTO `by_menu` VALUES ('27', '权限管理', '16', '0', 'AuthManager/index', '0', '', '用户管理', '0', '1');
INSERT INTO `by_menu` VALUES ('28', '删除', '27', '0', 'AuthManager/changeStatus?method=deleteGroup', '0', '删除用户组', '', '0', '1');
INSERT INTO `by_menu` VALUES ('29', '禁用', '27', '0', 'AuthManager/changeStatus?method=forbidGroup', '0', '禁用用户组', '', '0', '1');
INSERT INTO `by_menu` VALUES ('30', '恢复', '27', '0', 'AuthManager/changeStatus?method=resumeGroup', '0', '恢复已禁用的用户组', '', '0', '1');
INSERT INTO `by_menu` VALUES ('31', '新增', '27', '0', 'AuthManager/createGroup', '0', '创建新的用户组', '', '0', '1');
INSERT INTO `by_menu` VALUES ('32', '编辑', '27', '0', 'AuthManager/editGroup', '0', '编辑用户组名称和描述', '', '0', '1');
INSERT INTO `by_menu` VALUES ('33', '保存用户组', '27', '0', 'AuthManager/writeGroup', '0', '新增和编辑用户组的\"保存\"按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('34', '授权', '27', '0', 'AuthManager/group', '0', '\"后台 \\ 用户 \\ 用户信息\"列表页的\"授权\"操作按钮,用于设置用户所属用户组', '', '0', '1');
INSERT INTO `by_menu` VALUES ('35', '访问授权', '27', '0', 'AuthManager/access', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"访问授权\"操作按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('36', '成员授权', '27', '0', 'AuthManager/user', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"成员授权\"操作按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('37', '解除授权', '27', '0', 'AuthManager/removeFromGroup', '0', '\"成员授权\"列表页内的解除授权操作按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('38', '保存成员授权', '27', '0', 'AuthManager/addToGroup', '0', '\"用户信息\"列表页\"授权\"时的\"保存\"按钮和\"成员授权\"里右上角的\"添加\"按钮)', '', '0', '1');
INSERT INTO `by_menu` VALUES ('39', '分类授权', '27', '0', 'AuthManager/category', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"分类授权\"操作按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('40', '保存分类授权', '27', '0', 'AuthManager/addToCategory', '0', '\"分类授权\"页面的\"保存\"按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('41', '模型授权', '27', '0', 'AuthManager/modelauth', '0', '\"后台 \\ 用户 \\ 权限管理\"列表页的\"模型授权\"操作按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('42', '保存模型授权', '27', '0', 'AuthManager/addToModel', '0', '\"分类授权\"页面的\"保存\"按钮', '', '0', '1');
INSERT INTO `by_menu` VALUES ('43', '扩展', '0', '11', 'Addons/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('44', '插件管理', '43', '1', 'Addons/index', '0', '', '扩展', '0', '1');
INSERT INTO `by_menu` VALUES ('45', '创建', '44', '0', 'Addons/create', '0', '服务器上创建插件结构向导', '', '0', '1');
INSERT INTO `by_menu` VALUES ('46', '检测创建', '44', '0', 'Addons/checkForm', '0', '检测插件是否可以创建', '', '0', '1');
INSERT INTO `by_menu` VALUES ('47', '预览', '44', '0', 'Addons/preview', '0', '预览插件定义类文件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('48', '快速生成插件', '44', '0', 'Addons/build', '0', '开始生成插件结构', '', '0', '1');
INSERT INTO `by_menu` VALUES ('49', '设置', '44', '0', 'Addons/config', '0', '设置插件配置', '', '0', '1');
INSERT INTO `by_menu` VALUES ('50', '禁用', '44', '0', 'Addons/disable', '0', '禁用插件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('51', '启用', '44', '0', 'Addons/enable', '0', '启用插件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('52', '安装', '44', '0', 'Addons/install', '0', '安装插件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('53', '卸载', '44', '0', 'Addons/uninstall', '0', '卸载插件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('54', '更新配置', '44', '0', 'Addons/saveconfig', '0', '更新插件配置处理', '', '0', '1');
INSERT INTO `by_menu` VALUES ('55', '插件后台列表', '44', '0', 'Addons/adminList', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('56', 'URL方式访问插件', '44', '0', 'Addons/execute', '0', '控制是否有权限通过url访问插件控制器方法', '', '0', '1');
INSERT INTO `by_menu` VALUES ('57', '钩子管理', '43', '2', 'Addons/hooks', '0', '', '扩展', '0', '1');
INSERT INTO `by_menu` VALUES ('58', '模型管理', '68', '3', 'Model/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('59', '新增', '58', '0', 'model/add', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('60', '编辑', '58', '0', 'model/edit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('61', '改变状态', '58', '0', 'model/setStatus', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('62', '保存数据', '58', '0', 'model/update', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('63', '属性管理', '68', '0', 'Attribute/index', '1', '网站属性配置。', '', '0', '1');
INSERT INTO `by_menu` VALUES ('64', '新增', '63', '0', 'Attribute/add', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('65', '编辑', '63', '0', 'Attribute/edit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('66', '改变状态', '63', '0', 'Attribute/setStatus', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('67', '保存数据', '63', '0', 'Attribute/update', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('68', '系统', '0', '2', 'Config/group', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('69', '网站设置', '68', '1', 'Config/group', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('70', '配置管理', '68', '4', 'Config/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('71', '编辑', '70', '0', 'Config/edit', '0', '新增编辑和保存配置', '', '0', '1');
INSERT INTO `by_menu` VALUES ('72', '删除', '70', '0', 'Config/del', '0', '删除配置', '', '0', '1');
INSERT INTO `by_menu` VALUES ('73', '新增', '70', '0', 'Config/add', '0', '新增配置', '', '0', '1');
INSERT INTO `by_menu` VALUES ('74', '保存', '70', '0', 'Config/save', '0', '保存配置', '', '0', '1');
INSERT INTO `by_menu` VALUES ('75', '菜单管理', '68', '5', 'Menu/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('76', '导航管理', '68', '6', 'Channel/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('77', '新增', '76', '0', 'Channel/add', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('78', '编辑', '76', '0', 'Channel/edit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('79', '删除', '76', '0', 'Channel/del', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('80', '商品分类', '166', '0', 'Category/index', '0', '', '商品管理', '0', '1');
INSERT INTO `by_menu` VALUES ('81', '编辑', '80', '0', 'Category/edit', '0', '编辑和保存栏目分类', '', '0', '1');
INSERT INTO `by_menu` VALUES ('82', '新增', '80', '0', 'Category/add', '0', '新增栏目分类', '', '0', '1');
INSERT INTO `by_menu` VALUES ('83', '删除', '80', '0', 'Category/remove', '0', '删除栏目分类', '', '0', '1');
INSERT INTO `by_menu` VALUES ('84', '移动', '80', '0', 'Category/operate/type/move', '0', '移动栏目分类', '', '0', '1');
INSERT INTO `by_menu` VALUES ('85', '合并', '80', '0', 'Category/operate/type/merge', '0', '合并栏目分类', '', '0', '1');
INSERT INTO `by_menu` VALUES ('86', '备份数据库', '68', '9', 'Database/index?type=export', '0', '', '数据备份', '0', '1');
INSERT INTO `by_menu` VALUES ('87', '备份', '86', '0', 'Database/export', '0', '备份数据库', '', '0', '1');
INSERT INTO `by_menu` VALUES ('88', '优化表', '86', '0', 'Database/optimize', '0', '优化数据表', '', '0', '1');
INSERT INTO `by_menu` VALUES ('89', '修复表', '86', '0', 'Database/repair', '0', '修复数据表', '', '0', '1');
INSERT INTO `by_menu` VALUES ('90', '还原数据库', '68', '8', 'Database/index?type=import', '0', '', '数据备份', '0', '1');
INSERT INTO `by_menu` VALUES ('91', '恢复', '90', '0', 'Database/import', '0', '数据库恢复', '', '0', '1');
INSERT INTO `by_menu` VALUES ('92', '删除', '90', '0', 'Database/del', '0', '删除备份文件', '', '0', '1');
INSERT INTO `by_menu` VALUES ('93', '其他', '0', '13', 'other', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('96', '新增', '75', '0', 'Menu/add', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('98', '编辑', '75', '0', 'Menu/edit', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('106', '行为日志', '16', '0', 'Action/actionlog', '0', '', '行为管理', '0', '1');
INSERT INTO `by_menu` VALUES ('108', '修改密码', '16', '0', 'User/updatePassword', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('109', '修改昵称', '16', '0', 'User/updateNickname', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('110', '查看行为日志', '106', '0', 'action/edit', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('112', '新增数据', '58', '0', 'think/add', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('113', '编辑数据', '58', '0', 'think/edit', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('114', '导入', '75', '0', 'Menu/import', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('115', '生成', '58', '0', 'Model/generate', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('116', '新增钩子', '57', '0', 'Addons/addHook', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('117', '编辑钩子', '57', '0', 'Addons/edithook', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('118', '文档排序', '3', '0', 'Article/sort', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('119', '排序', '70', '0', 'Config/sort', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('120', '排序', '75', '0', 'Menu/sort', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('121', '排序', '76', '0', 'Channel/sort', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('122', '数据列表', '58', '0', 'think/lists', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('123', '审核列表', '3', '0', 'Article/examine', '1', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('177', ' 快递管理', '131', '9', 'Express/index', '0', '', '订单相关', '0', '1');
INSERT INTO `by_menu` VALUES ('134', '优惠券', '158', '4', 'Fcoupon/index', '0', '', '优惠券管理', '0', '1');
INSERT INTO `by_menu` VALUES ('131', '订单', '0', '6', 'Order/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('132', '提交订单', '131', '1', 'Order/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_menu` VALUES ('178', '日志管理', '146', '6', 'UserLog/index', '0', '', '数据管理', '0', '1');
INSERT INTO `by_menu` VALUES ('137', '正退货订单', '173', '4', 'Back/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_menu` VALUES ('138', '同意退货订单', '173', '7', 'Backagree/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_menu` VALUES ('139', '已退货订单', '173', '8', 'Backover/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_menu` VALUES ('140', '换货管理', '131', '4', 'Change/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_menu` VALUES ('143', '今日销量统计', '146', '13', 'Statistics/index', '0', '', '数据统计', '0', '1');
INSERT INTO `by_menu` VALUES ('144', '本周销量统计', '146', '14', 'Statistics/week', '0', '', '数据统计', '0', '1');
INSERT INTO `by_menu` VALUES ('145', '本月销量统计', '146', '15', 'Statistics/month', '0', '', '数据统计', '0', '1');
INSERT INTO `by_menu` VALUES ('183', '属性配置', '166', '0', 'Attributes/index', '0', '', '商品管理', '0', '1');
INSERT INTO `by_menu` VALUES ('147', '每日数据', '146', '16', 'Report/index', '0', '', '报表统计', '0', '1');
INSERT INTO `by_menu` VALUES ('148', '每周数据', '146', '17', 'Report/week', '0', '', '报表统计', '0', '1');
INSERT INTO `by_menu` VALUES ('149', '每月统计', '146', '18', 'Report/month', '0', '', '报表统计', '0', '1');
INSERT INTO `by_menu` VALUES ('150', '流量统计', '146', '20', 'Lookup/index', '0', '', '数据管理', '0', '1');
INSERT INTO `by_menu` VALUES ('179', '支付管理', '131', '8', 'Pay/index', '0', '', '订单相关', '0', '1');
INSERT INTO `by_menu` VALUES ('153', '取消管理', '131', '2', 'Cancel/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_menu` VALUES ('157', '品牌管理', '158', '0', 'Brand/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_menu` VALUES ('158', '广告', '0', '9', 'Slide/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('160', '幻灯片', '158', '0', 'Slide/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_menu` VALUES ('159', '广告', '158', '0', 'Ad/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_menu` VALUES ('162', '拒绝退货订单', '173', '5', 'Backrefuse/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_menu` VALUES ('163', '退货中订单', '173', '6', 'Backon/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_menu` VALUES ('166', '商品', '0', '4', 'Goods/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('168', '邮件管理', '16', '6', 'Email/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_menu` VALUES ('169', '短信管理', '16', '7', 'Sms/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_menu` VALUES ('170', '站内信管理', '16', '8', 'Envelope/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_menu` VALUES ('171', '留言管理', '16', '9', 'Message/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_menu` VALUES ('172', '回复管理', '16', '10', 'Reply/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_menu` VALUES ('176', '退货管理', '131', '3', 'Back/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_menu` VALUES ('174', '文章分类', '68', '2', 'Catearticle/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_menu` VALUES ('175', '预约列表', '68', '7', 'Reserve/index', '0', '', '预约管理', '0', '1');
INSERT INTO `by_menu` VALUES ('180', '商家审核', '181', '0', 'Check/index', '0', '', '用户管理', '0', '1');
INSERT INTO `by_menu` VALUES ('181', '商家', '0', '12', 'Check/index', '0', '', '', '0', '1');
INSERT INTO `by_menu` VALUES ('182', '后台菜单', '181', '0', 'SellerMenu/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_menu` VALUES ('184', '商品属性', '166', '1', 'GoodsAttributes/index', '0', '', '商品管理', '0', '1');
INSERT INTO `by_menu` VALUES ('185', '商品列表', '166', '2', 'Goods/index', '0', '', '商品管理', '0', '1');
INSERT INTO `by_menu` VALUES ('186', ' 商品类型', '166', '0', 'Types/index', '0', '', '商品管理', '0', '1');
INSERT INTO `by_menu` VALUES ('187', '库存sku', '166', '3', 'Stock/index', '0', '', '商品管理', '0', '1');

-- ----------------------------
-- Table structure for by_message
-- ----------------------------
DROP TABLE IF EXISTS `by_message`;
CREATE TABLE `by_message` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `goodid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `content` varchar(225) DEFAULT NULL COMMENT '留言内容',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '默认null-未提交订单1-未读2-已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表';

-- ----------------------------
-- Records of by_message
-- ----------------------------

-- ----------------------------
-- Table structure for by_mini
-- ----------------------------
DROP TABLE IF EXISTS `by_mini`;
CREATE TABLE `by_mini` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `nickName` varchar(255) DEFAULT NULL COMMENT '昵称',
  `country` varchar(255) DEFAULT NULL COMMENT '国家',
  `province` varchar(255) DEFAULT NULL COMMENT '省份',
  `city` varchar(255) DEFAULT NULL COMMENT '城市',
  `language` varchar(255) DEFAULT NULL COMMENT '语言',
  `gender` varchar(255) DEFAULT NULL COMMENT '性别',
  `avatarUrl` varchar(255) DEFAULT NULL COMMENT '头像',
  `appid` varchar(255) DEFAULT NULL COMMENT 'appid',
  `openid` varchar(255) DEFAULT NULL COMMENT 'opnid',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'uid',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='小程序用户表';

-- ----------------------------
-- Records of by_mini
-- ----------------------------

-- ----------------------------
-- Table structure for by_model
-- ----------------------------
DROP TABLE IF EXISTS `by_model`;
CREATE TABLE `by_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模型ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '模型标识',
  `title` char(30) NOT NULL DEFAULT '' COMMENT '模型名称',
  `extend` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '继承的模型',
  `relation` varchar(30) NOT NULL DEFAULT '' COMMENT '继承与被继承模型的关联字段',
  `need_pk` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '新建表时是否需要主键字段',
  `field_sort` text COMMENT '表单字段排序',
  `field_group` varchar(255) NOT NULL DEFAULT '1:基础' COMMENT '字段分组',
  `attribute_list` text COMMENT '属性列表（表的字段）',
  `attribute_alias` varchar(255) NOT NULL DEFAULT '' COMMENT '属性别名定义',
  `template_list` varchar(100) NOT NULL DEFAULT '' COMMENT '列表模板',
  `template_add` varchar(100) NOT NULL DEFAULT '' COMMENT '新增模板',
  `template_edit` varchar(100) NOT NULL DEFAULT '' COMMENT '编辑模板',
  `list_grid` text COMMENT '列表定义',
  `list_row` smallint(2) unsigned NOT NULL DEFAULT '10' COMMENT '列表数据长度',
  `search_key` varchar(50) NOT NULL DEFAULT '' COMMENT '默认搜索字段',
  `search_list` varchar(255) NOT NULL DEFAULT '' COMMENT '高级搜索的字段',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `engine_type` varchar(25) NOT NULL DEFAULT 'MyISAM' COMMENT '数据库引擎',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='文档模型表';

-- ----------------------------
-- Records of by_model
-- ----------------------------
INSERT INTO `by_model` VALUES ('1', 'document', '基础文档', '0', '', '1', '{\"1\":[\"56\",\"55\",\"49\",\"2\",\"3\",\"5\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"16\",\"17\",\"19\",\"20\",\"51\"]}', '1:基础', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891233', '1438957493', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('2', 'article', '文章', '1', '', '1', '{\"1\":[\"56\",\"55\",\"51\",\"49\",\"3\",\"24\",\"2\",\"5\"],\"2\":[\"9\",\"13\",\"19\",\"10\",\"12\",\"16\",\"17\",\"26\",\"20\",\"14\",\"11\",\"25\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891243', '1438955531', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('3', 'download', '下载', '1', '', '1', '{\"1\":[\"3\",\"28\",\"30\",\"32\",\"2\",\"5\",\"31\"],\"2\":[\"13\",\"10\",\"27\",\"9\",\"12\",\"16\",\"17\",\"19\",\"11\",\"20\",\"14\",\"29\"]}', '1:基础,2:扩展', '', '', '', '', '', '', '0', '', '', '1383891252', '1387260449', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('5', 'product', '商品', '1', '', '1', '{\"1\":[\"3\",\"36\",\"51\",\"12\",\"55\",\"46\",\"39\"],\"2\":[\"37\",\"102\",\"42\",\"10\",\"56\",\"47\",\"50\",\"5\",\"49\",\"14\",\"44\",\"58\",\"9\",\"20\",\"11\",\"2\",\"13\",\"17\",\"35\",\"16\",\"19\",\"43\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891252', '1439279017', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('6', 'phone', '手机', '1', '', '1', '{\"1\":[\"3\",\"60\",\"12\",\"55\",\"51\",\"62\",\"80\",\"68\",\"66\",\"64\",\"63\",\"61\",\"59\"],\"2\":[\"103\",\"104\",\"105\",\"5\",\"56\",\"10\",\"65\",\"81\",\"70\",\"71\",\"67\",\"72\",\"69\",\"73\",\"74\",\"75\",\"76\",\"78\",\"77\",\"79\",\"49\",\"14\",\"9\",\"20\",\"11\",\"2\",\"13\",\"17\",\"16\",\"19\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891252', '1439279030', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('7', 'book', '图书', '1', '', '1', '{\"1\":[\"3\",\"93\",\"12\",\"51\",\"82\",\"101\",\"83\",\"92\",\"84\",\"5\"],\"2\":[\"106\",\"107\",\"108\",\"91\",\"90\",\"89\",\"88\",\"87\",\"86\",\"85\",\"10\",\"49\",\"14\",\"9\",\"20\",\"55\",\"56\",\"11\",\"2\",\"13\",\"17\",\"16\",\"19\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891252', '1439279042', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('8', 'clothe', '服装鞋包', '1', '', '1', '{\"1\":[\"3\",\"96\",\"12\",\"55\",\"51\",\"56\",\"94\",\"95\",\"99\",\"97\"],\"2\":[\"109\",\"110\",\"111\",\"49\",\"98\",\"10\",\"100\",\"14\",\"5\",\"9\",\"20\",\"11\",\"2\",\"13\",\"17\",\"16\",\"19\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '0', '', '', '1383891252', '1439279054', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('9', 'groupbuying', '团购', '1', '', '1', '{\"1\":[\"3\",\"12\",\"113\",\"51\",\"117\",\"14\",\"55\",\"56\",\"16\"],\"2\":[\"9\",\"2\",\"5\",\"17\",\"10\",\"20\",\"11\",\"13\",\"49\",\"19\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '10', '', '', '1438711051', '1443986143', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('10', 'limitbuying', '限时抢购', '1', '', '1', '{\"1\":[\"3\",\"12\",\"114\",\"51\",\"118\",\"14\",\"55\",\"56\",\"10\"],\"2\":[\"49\",\"2\",\"20\",\"5\",\"19\",\"9\",\"11\",\"13\",\"17\",\"16\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '10', '', '', '1438712763', '1443986150', '1', 'MyISAM');
INSERT INTO `by_model` VALUES ('11', 'reserve', '预约', '1', '', '1', '{\"1\":[\"3\",\"115\",\"12\",\"51\",\"119\",\"14\",\"120\",\"5\",\"55\",\"56\"],\"2\":[\"49\",\"2\",\"13\",\"9\",\"20\",\"11\",\"10\",\"17\",\"19\",\"16\"]}', '1:基础,2:扩展', '', '', '', '', '', 'id:编号\r\ntitle:标题:[EDIT]\r\ntype:类型\r\nupdate_time:最后更新\r\nstatus:状态\r\nview:浏览\r\nid:操作:[EDIT]|编辑,[DELETE]|删除,[SEE]|预览', '10', '', '', '1438750712', '1439279094', '1', 'MyISAM');

-- ----------------------------
-- Table structure for by_module
-- ----------------------------
DROP TABLE IF EXISTS `by_module`;
CREATE TABLE `by_module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `group_id` int(2) DEFAULT '0',
  `name` varchar(225) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `font` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=utf8 COMMENT='菜单表';

-- ----------------------------
-- Records of by_module
-- ----------------------------
INSERT INTO `by_module` VALUES ('1', '系统管理', '0', '2', '', '1', '', '1', 'icon-setting1');
INSERT INTO `by_module` VALUES ('3', '菜单管理', '1', '0', 'module/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('7', '商品分类', '40', '1', 'category/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('8', '文章分类', '1', '0', 'cate/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('9', '文章管理', '43', '0', 'document/index', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('143', '增加', '142', '0', 'slide/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('135', '用户组授权', '74', '0', 'auth/group', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('134', '删除', '74', '0', 'auth/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('14', '商品属性', '40', '0', 'attributes/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('141', '删除', '9', '0', 'document/del', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('16', '自营订单', '41', '0', 'order/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('140', '编辑', '9', '0', 'document/edit', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('18', '商品类型', '40', '0', 'types/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('139', '增加', '9', '0', 'document/add', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('138', '删除', '8', '0', 'cate/del', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('22', '支付管理', '41', '0', 'pay/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('137', '编辑', '8', '0', 'cate/edit', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('151', '规格属性', '40', '0', 'specs/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('136', '增加', '8', '0', 'cate/add', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('68', '配置管理', '1', '2', 'config/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('40', '商品管理', '0', '1', '', '1', '', '1', 'icon-shangpin');
INSERT INTO `by_module` VALUES ('41', '订单管理', '0', '0', '', '15', '', '1', 'icon-order');
INSERT INTO `by_module` VALUES ('43', '文章管理', '0', '0', '', '7', '', '1', null);
INSERT INTO `by_module` VALUES ('133', '写入用户组', '74', '0', 'auth/writeGrou', '0', '', '1', null);
INSERT INTO `by_module` VALUES ('132', '访问授权', '74', '0', 'auth/access', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('131', '编辑', '74', '0', 'auth/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('130', '增加', '74', '0', 'auth/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('129', '删除', '78', '0', 'ucenter/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('128', '编辑', '78', '0', 'ucenter/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('127', '增加', '78', '0', 'ucenter/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('60', '奖品管理', '58', '0', 'ScratchPrize/index', '0', '', '1', null);
INSERT INTO `by_module` VALUES ('73', '分组管理', '1', '0', 'group/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('72', 'sku管理', '40', '0', 'sku/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('65', '奖品管理', '63', '0', 'SmashingPrize/index', '0', '', '1', null);
INSERT INTO `by_module` VALUES ('70', '系统设置', '1', '3', 'systems/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('74', '角色管理', '77', '0', 'auth/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('75', '增加', '3', '0', 'module/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('76', '编辑', '3', '2', 'module/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('77', '用户管理', '0', '2', '', '16', '', '1', 'icon-person');
INSERT INTO `by_module` VALUES ('78', '用户列表', '77', '1', 'user/index', '16', '', '1', '');
INSERT INTO `by_module` VALUES ('79', '广告管理', '148', '0', 'ad/index', '19', '', '1', null);
INSERT INTO `by_module` VALUES ('152', '增加', '151', '0', 'specs/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('81', '删除', '3', '0', 'module/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('82', '增加', '68', '0', 'config/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('83', '编辑', '68', '0', 'config/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('84', '删除', '68', '0', 'config/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('85', '增加', '73', '0', 'group/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('86', '编辑', '73', '0', 'group/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('87', '删除', '73', '0', 'group/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('88', '增加', '79', '0', 'ad/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('89', '编辑', '79', '0', 'ad/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('90', '删除', '79', '0', 'ad/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('91', '增加', '7', '0', 'category/add', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('92', '编辑', '7', '0', 'category/edit', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('93', '删除', '7', '0', 'category/del', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('94', '增加', '14', '0', 'attributes/add', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('95', '编辑', '14', '0', 'attributes/edit', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('96', '删除', '14', '0', 'attributes/del', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('97', '增加', '18', '0', 'types/add', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('98', '编辑', '18', '0', '	types/edit', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('99', '删除', '18', '0', '	types/del', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('154', '删除', '151', '0', 'specs/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('153', '编辑', '151', '0', 'specs/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('102', '增加', '71', '0', 'goods/add', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('103', '创建sku', '71', '0', 'goods/add_stock', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('104', '更新sku', '71', '0', 'goods/update_stock', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('105', '增加排列组合', '71', '0', 'goods/ addsu', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('106', '更新排列组合', '71', '0', 'goods/updatesu', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('107', '获取规格属性', '71', '0', 'goods/getalltypes', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('108', '编辑', '71', '0', 'goods/edit', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('109', '切换分类', '71', '0', 'goods/change', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('110', '删除', '71', '0', 'goods/del', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('111', '增加', '72', '0', 'sku/add', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('112', '编辑', '72', '0', 'sku/edit', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('113', '删除', '72', '0', 'sku/del', '3', '', '1', null);
INSERT INTO `by_module` VALUES ('114', '增加', '16', '0', 'order/add', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('115', '编辑', '16', '0', 'order/edit', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('116', '导出订单', '16', '0', 'order/out', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('117', '删除', '16', '0', 'order/del', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('118', '增加', '21', '0', 'drawback/add', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('119', '编辑', '21', '0', 'drawback/edit', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('120', '删除', '21', '0', 'drawback/del', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('121', '增加', '22', '0', 'pay/add', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('122', '编辑', '22', '0', 'pay/edit', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('123', '删除', '22', '0', 'rank/del', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('142', '幻灯片管理', '148', '0', 'slide/index', '19', '', '1', null);
INSERT INTO `by_module` VALUES ('144', '编辑', '142', '0', 'slide/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('145', '删除', '142', '0', 'slide/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('146', '切换分类', '142', '0', 'slide/change', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('147', '导航管理', '1', '0', 'channel/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('148', '图片管理', '0', '0', '', '19', '', '1', 'icon-tupian');
INSERT INTO `by_module` VALUES ('149', '资源管理', '148', '0', 'Attachment/index', '19', '', '1', null);
INSERT INTO `by_module` VALUES ('155', '增加', '147', '0', 'channel/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('156', '编辑', '147', '0', 'channel/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('157', '删除', '147', '0', 'channel/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('158', '评价管理', '41', '0', 'comment/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('159', '增加', '158', '0', 'comment/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('160', '编辑', '158', '0', 'comment/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('161', '删除', '158', '0', 'comment/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('162', '商品品牌', '40', '0', 'brand/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('163', '增加', '162', '0', 'brand/add', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('164', '编辑', '162', '0', 'brand/edit', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('165', '删除', '162', '0', 'brand/del', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('202', '商品管理', '0', '0', '', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('167', '用户行为', '0', '0', '', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('168', '操作日志', '167', '0', 'log/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('169', '增加', '168', '0', 'log/add', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('170', '编辑', '168', '0', 'log/edit', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('171', '删除', '168', '0', 'log/del', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('173', '快递管理', '41', '0', 'Express/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('174', '销售记录', '41', '0', 'sales/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('175', '菜单生成器', '176', '0', 'Code/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('176', '快捷工具', '0', '0', '', '1', '', '1', 'icon-gongju');
INSERT INTO `by_module` VALUES ('177', 'Sql执行', '176', '0', 'Sql/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('178', '新增', '172', '0', 'goods/add', '20', '', '1', null);
INSERT INTO `by_module` VALUES ('179', '资金管理', '77', '0', 'AccountLog/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('180', '提现管理', '77', '0', 'cash/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('181', '客服服务', '77', '0', 'service/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('182', '邮件管理', '77', '0', 'email/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('183', '促销管理', '0', '0', '', '20', '', '1', null);
INSERT INTO `by_module` VALUES ('184', '满减优惠', '183', '0', 'reduction/index', '20', '', '1', null);
INSERT INTO `by_module` VALUES ('189', '分销结构图', '77', '0', 'Tree/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('194', '积分订单', '41', '0', 'score/index', '15', '', '1', null);
INSERT INTO `by_module` VALUES ('193', '浏览记录', '77', '0', 'history/index', '16', '', '1', null);
INSERT INTO `by_module` VALUES ('195', '店铺管理', '0', '0', '', '24', '', '1', 'icon-shop');
INSERT INTO `by_module` VALUES ('196', '商铺管理', '195', '0', 'shop/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('197', '商品分类', '202', '0', 'ShopCategory/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('198', '提现管理', '195', '0', 'money/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('199', '商家订单', '195', '0', 'ShopOrder/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('200', '商品审核', '202', '0', 'ShopGoods/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('201', '店铺快递', '195', '0', 'ShopExpress/index', '24', '', '1', null);
INSERT INTO `by_module` VALUES ('203', '首页', '1', '0', 'index/index', '1', '', '0', null);
INSERT INTO `by_module` VALUES ('204', '数据库管理', '0', '0', '', '1', '', '1', 'icon-jurassic_data');
INSERT INTO `by_module` VALUES ('205', '数据备份', '204', '0', 'table/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('206', '数据还原', '204', '0', 'backup/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('207', '积分管理', '0', '0', '', '26', '', '1', 'icon-jifen');
INSERT INTO `by_module` VALUES ('208', '积分类型', '207', '0', 'ScoreType/index', '26', '', '1', null);
INSERT INTO `by_module` VALUES ('209', '积分商品', '207', '0', 'ScoreGoods/index', '26', '', '1', null);
INSERT INTO `by_module` VALUES ('210', '兑换管理', '207', '0', 'ScoreOrder/index', '26', '', '1', null);
INSERT INTO `by_module` VALUES ('211', '消费明细', '207', '0', 'ScoreLog/index', '26', '', '1', null);
INSERT INTO `by_module` VALUES ('212', '兑换码管理', '207', '0', 'ScoreCode/index', '26', '', '1', null);
INSERT INTO `by_module` VALUES ('213', '公众号管理', '0', '0', '', '27', '', '1', 'icon-weixin2');
INSERT INTO `by_module` VALUES ('214', '关注回复', '213', '0', 'focus/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('215', '被动回复管理', '213', '0', 'answer/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('216', '文本回复', '213', '0', 'text/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('217', '单图文管理', '213', '0', 'news/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('218', '多图文管理', '213', '0', 'images/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('219', '自定义菜单管理', '213', '0', 'menu/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('220', '粉丝管理', '213', '0', 'follow/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('221', '公众号管理', '213', '0', 'weixin/index', '27', '', '1', null);
INSERT INTO `by_module` VALUES ('224', '模板生成器', '176', '0', 'template/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('225', '计划任务', '204', '0', 'download/index', '1', '', '1', null);
INSERT INTO `by_module` VALUES ('226', '优惠券', '0', '0', '', '26', '', '1', '');
INSERT INTO `by_module` VALUES ('227', '优惠券', '226', '0', 'coupon/index', '26', '', '1', '');
INSERT INTO `by_module` VALUES ('228', '用户优惠券管理', '226', '0', 'userCoupon/index', '26', '', '1', '');
INSERT INTO `by_module` VALUES ('229', '插件管理', '0', '0', '', '28', '', '1', '');
INSERT INTO `by_module` VALUES ('233', '钩子管理', '229', '0', 'hooks/index', '28', '', '1', null);
INSERT INTO `by_module` VALUES ('231', '插件列表', '229', '0', 'plugin/index', '28', '', '1', null);

-- ----------------------------
-- Table structure for by_money
-- ----------------------------
DROP TABLE IF EXISTS `by_money`;
CREATE TABLE `by_money` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `shop_id` varchar(255) DEFAULT NULL COMMENT '店铺编号',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `total_money` decimal(50,2) DEFAULT NULL COMMENT '金额',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '处理时间',
  `percent` varchar(225) DEFAULT NULL,
  `arrive_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) NOT NULL DEFAULT '0',
  `username` varchar(225) DEFAULT NULL,
  `account` varchar(225) DEFAULT NULL,
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `alipay` varchar(225) DEFAULT NULL,
  `bank` varchar(225) DEFAULT NULL,
  `bank_username` varchar(225) DEFAULT NULL,
  `bank_account` varchar(225) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_money
-- ----------------------------
INSERT INTO `by_money` VALUES ('8', '10', '', '300.00', '2', '1533428524', '0', '5%', '285.00', '0', '', '', '1', '', '', '', '', '支付宝账户为空');
INSERT INTO `by_money` VALUES ('9', '10', '', '1000.00', '0', '1577791421', '0', '5%', '950.00', '0', '', '123123', '1', '23312', '', '', '', '');
INSERT INTO `by_money` VALUES ('10', '10', '', '1000.00', '0', '1577791547', '0', '5%', '950.00', '0', '', '', '1', '', '', '', '', '');
INSERT INTO `by_money` VALUES ('11', '10', null, '80.00', '0', '1583742980', '0', '5%', '76.00', '0', null, '123123', '1', '23312', null, null, null, null);

-- ----------------------------
-- Table structure for by_money_log
-- ----------------------------
DROP TABLE IF EXISTS `by_money_log`;
CREATE TABLE `by_money_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `shop_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT '店铺id',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `content` varchar(225) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_money_log
-- ----------------------------

-- ----------------------------
-- Table structure for by_news
-- ----------------------------
DROP TABLE IF EXISTS `by_news`;
CREATE TABLE `by_news` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `title` varchar(225) DEFAULT NULL COMMENT '关键词',
  `content` text NOT NULL COMMENT '内容',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  `media_id` varchar(255) DEFAULT NULL COMMENT '缩略图id',
  `des` varchar(255) DEFAULT NULL COMMENT '描述',
  `author` varchar(255) DEFAULT NULL COMMENT '作者',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面id',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '发布时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信单一图文回复表';

-- ----------------------------
-- Records of by_news
-- ----------------------------
INSERT INTO `by_news` VALUES ('1', 'wx643f65392e6a5e8c', '从“点题”到“破题” 习近平引领“中国之治”开辟新境', '<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495060705.jpg\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　6年前，党的十八届三中全会提出“全面深化改革的总目标是完善和发展中国特色社会主义制度，推进国家治理体系和治理能力现代化”，开启了全面深化改革新征程。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　今年，党的十九届四中全会审议通过了重磅文件《中共中央关于坚持和完善中国特色社会主义制度、推进国家治理体系和治理能力现代化若干重大问题的决定》。《决定》对党的十八届三中全会提出的总目标进行深化和展开，为我们推动各方面制度更加成熟更加定型明确了时间表、路线图。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　从“点题”到“破题”，中国共产党人如何把改革蓝图转化成全方位治理中的改革实践？让我们从习近平关于全面深化改革的重要论述中寻找答案。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　经济体制改革取得重大突破\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　我们是在中国共产党领导和社会主义制度的大前提下发展市场经济，什么时候都不能忘了“社会主义”这个定语。之所以说是社会主义市场经济，就是要坚持我们的制度优越性，有效防范资本主义市场经济的弊端。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2015年11月23日，在十八届中央政治局第二十八次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　公有制经济、非公有制经济应该相辅相成、相得益彰，而不是相互排斥、相互抵消。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2016年3月4日，在参加全国政协十二届四次会议民建、工商联界委员联组会时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　经济体制改革必须以完善产权制度和要素市场化配置为重点，实现产权有效激励、要素自由流动、价格反应灵活、竞争公平有序、企业优胜劣汰。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年10月18日，在中国共产党第十九次全国代表大会上的报告\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495138825.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　<strong>政治体制改革稳步推进</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　在全面深化改革进程中，我们要积极稳妥推进政治体制改革，以保证人民当家作主为根本，以增强党和国家活力、调动人民积极性为目标，不断建设社会主义政治文明。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2014年9月5日，在庆祝全国人民代表大会成立六十周年大会上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　发展社会主义民主政治就是要体现人民意志、保障人民权益、激发人民创造活力，用制度体系保证人民当家作主。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年10月18日，在中国共产党第十九次全国代表大会上的报告\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　深化国家监察体制改革，目的是加强党对反腐败工作的统一领导，实现对所有行使公权力的公职人员监察全覆盖。国家监察委员会就是中国特色的国家反腐败机构。国家监察委员会同中央纪委合署办公，履行纪检、监察两项职责，实行一套工作机构、两个机关名称。不再保留监察部、国家预防腐败局。这项改革是事关全局的重大政治体制改革，具有鲜明的中国特色，展现了我们党自我革命的勇气和担当，意义重大而深远。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2018年2月26日至28日，在党的十九届三中全会上关于深化党和国家机构改革方案的说明\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495989740.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　<strong>文化体制改革不断创新发展</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　一个国家选择什么样的治理体系，是由这个国家的历史传承、文化传统、经济社会发展水平决定的，是由这个国家的人民决定的。我国今天的国家治理体系，是在我国历史传承、文化传统、经济社会发展的基础上长期发展、渐进改进、内生性演化的结果。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2014年2月17日，在省部级主要领导干部学习贯彻十八届三中全会精神全面深化改革专题研讨班开班式上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要增强文化自信，在传承中华优秀传统文化基础上发展社会主义先进文化，加快建设社会主义文化强国。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年4月19日，在广西考察时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　文学艺术创造、哲学社会科学研究首先要搞清楚为谁创作、为谁立言的问题，这是一个根本问题。人民是创作的源头活水，只有扎根人民，创作才能获得取之不尽、用之不竭的源泉。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2019年3月4日，在看望参加全国政协十三届二次会议的文化艺术界、社会科学界委员时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683496753248.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　<strong>　社会体制改革全面推进</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要通过社会体制改革创新，充分调动各方面积极性，最大限度增强社会发展活力，充分发挥人民群众首创精神，使全社会创造能量充分释放、创业活动蓬勃开展。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2013年7月23日，在湖北省武汉市主持召开部分省市负责人座谈会时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　社会建设要以共建共享为基本原则，在体制机制、制度政策上系统谋划，从保障和改善民生做起，坚持群众想什么、我们就干什么，既尽力而为又量力而行，多一些雪中送炭，使各项工作都做到愿望和效果相统一。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2015年5月25日至27日，在浙江调研时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要继续加强和创新社会治理，完善中国特色社会主义社会治理体系，努力建设更高水平的平安中国，进一步增强人民群众安全感。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2016年10月，就加强和创新社会治理作出的指示\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683497736312.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　生态文明体制改革加快推进\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　保护生态环境必须依靠制度、依靠法治。只有实行最严格的制度、最严密的法治，才能为生态文明建设提供可靠保障。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2013年5月24日，在十八届中央政治局第六次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　生态环境问题，归根到底是资源过度开发、粗放利用、奢侈消费造成的。资源开发利用既要支撑当代人过上幸福生活，也要为子孙后代留下生存根基。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年5月26日，在十八届中央政治局第四十一次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　生态文明体制改革是全面深化改革的重要领域，要以解决生态环境领域突出问题为导向，抓好已出台改革举措的落地，及时制定新的改革方案。对涉及生态文明体制改革的一些重要举措要尽快到位、发挥作用。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2018年5月18日，在全国生态环境保护大会上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683498597854.gif\" /> \r\n</p>', '2', 'Gleo07uFEjKR6IlZV8DsC0MGtIxsZVz2pvAdc-tHshrM3fSRusmPLx44GhfXDYsW', 'asda', 'asdsa', '523', '0');
INSERT INTO `by_news` VALUES ('2', 'wx643f65392e6a5e8c', 'Quarkus 1.0 发布，Java 云原生、容器优先框架', '<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	<img src=\"https://static.oschina.net/uploads/space/2019/0326/084503_pNcF_3820517.png\" class=\"zoom-in-cursor\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	Quarkus 是 Kubernetes 原生的 Java 技术栈，它由同类中最佳的 Java 库和标准精制而成，并针对容器和云部署量身定制。Quarkus 的总体目标是将 Java 带入云原生的应用开发，并使它成为 Serverless、云和 Kubernetes 环境的领先平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	Quarkus 代表了现代应用开发人员的根本性转变，旨在解决 Java 在云原生应用架构（如容器、微服务和 Serverless）方面面临的一些缺陷。Java 开发人员能够使用 Quarkus 构建具有比传统的基于 Java 的微服务框架更快的启动时间并占用更少内存的应用。它包括灵活、易于使用的 API，这些 API 使开发人员能够构建云原生应用，同时还包含大多数开发人员已经熟悉的同类最佳框架，比如 Eclipse MicroProfile、Apache Kafka、RESTEasy（JAX-RS）、Hibernate ORM（JPA）、CDI、Spring 相关、Infinispan 与 Camel 等。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	此外 Quarkus 还统一了响应式和命令式编程模型，开发人员可以选择最适合其用例的模型，并更轻松地将其代码与其它组件集成到响应式系统中，例如带有 Vert.x 和 Kafka 的响应式流、响应式数据库 API 等。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1.0 版本主要更新包括：\r\n</p>\r\n<ul style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	<li>\r\n		基于 Vert.x 的响应式内核，使响应式编程成为 Quarkus 的一级特性\r\n	</li>\r\n	<li>\r\n		一个新的非阻塞安全层，它可以进行响应式身份验证和授权，还可以使响应式安全操作与 Vert.x 集成\r\n	</li>\r\n	<li>\r\n		改进的 Spring API 兼容性，包括 Spring Web 和 Spring Data JPA 以及 Spring DI\r\n	</li>\r\n</ul>', '5', '1x9Zd-FdttOBgWMg9BcSwgBB34gwkQDXC1CjvexDKPbny9BkFxfg8LnIdlg97qe-', '12312', '123', '524', '0');

-- ----------------------------
-- Table structure for by_order
-- ----------------------------
DROP TABLE IF EXISTS `by_order`;
CREATE TABLE `by_order` (
  `id` int(225) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `orderId` varchar(225) DEFAULT NULL COMMENT '交易号',
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '总金额',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-系统生成完成1-用户已提交订单2-3系统处理进入物流配送',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `ship_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `ispay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1在线支付未完成2在线支付完成3-货到付款',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `express` varchar(225) DEFAULT NULL COMMENT '是否默认地址',
  `address_id` int(10) unsigned NOT NULL DEFAULT '0',
  `shipway` varchar(225) DEFAULT NULL COMMENT '送货方式',
  `invoice_header` varchar(225) DEFAULT NULL COMMENT '发票抬头',
  `message` varchar(225) DEFAULT NULL COMMENT '留言',
  `score` int(10) unsigned NOT NULL DEFAULT '0',
  `coupon_id` int(10) NOT NULL DEFAULT '0',
  `coupon_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `username` varchar(225) DEFAULT NULL,
  `mobile` varchar(225) DEFAULT NULL,
  `address` varchar(225) DEFAULT NULL,
  `express_code` varchar(225) DEFAULT NULL,
  `arrive_time` decimal(50,2) DEFAULT '0.00',
  `isdao` int(10) NOT NULL DEFAULT '0',
  `saleslist` text NOT NULL,
  `invoice_content` varchar(225) DEFAULT NULL COMMENT '发票内容',
  `invoice_type` varchar(225) DEFAULT NULL,
  `is_invoice` varchar(225) DEFAULT NULL,
  `is_mobile` tinyint(2) NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `paytype` int(2) NOT NULL DEFAULT '0',
  `send_time` int(10) NOT NULL DEFAULT '0',
  `confirm_time` int(10) NOT NULL DEFAULT '0',
  `spress_type` tinyint(2) NOT NULL DEFAULT '0',
  `order_type` int(10) NOT NULL DEFAULT '0',
  `reduction` decimal(50,2) NOT NULL DEFAULT '0.00',
  `wait_pay_money` decimal(50,2) DEFAULT '0.00',
  `pay_money` decimal(50,2) DEFAULT '0.00',
  `num` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `pin_status` tinyint(2) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `order_code` varchar(225) DEFAULT NULL COMMENT '订单号',
  `expire_time` int(10) NOT NULL DEFAULT '0',
  `pay_time` varchar(255) DEFAULT NULL,
  `submit_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=259 DEFAULT CHARSET=utf8 COMMENT='订单表';

-- ----------------------------
-- Records of by_order
-- ----------------------------
INSERT INTO `by_order` VALUES ('241', 'J7221883276768872566', '1987.00', '1595418832', '0', '0', '85', '0.00', '0', '1999.00', null, '0', null, '', '', '0', '29', '12.00', 'sdfs', '13212356321', '广东省广州市海珠区', null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J72218840128839770880', '1595426040', null, '1595418840');
INSERT INTO `by_order` VALUES ('242', 'J7221961028964712143', '1997.00', '1595419610', '1', '1595419672', '85', '0.00', '0', '1999.00', null, '0', null, '', '', '0', '30', '2.00', 'sdfs', '13212356321', '广东省广州市海珠区', null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', '', '', '', '0', '0', '5', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J72219613819177547070', '1595426813', '1595419672', '1595419613');
INSERT INTO `by_order` VALUES ('243', 'J7222167895612949764', '1999.00', '1595421679', '-1', '0', '85', '0.00', '0', '1999.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7222167895612949764', '0', null, '0');
INSERT INTO `by_order` VALUES ('244', 'J7237601828706993319', '60.00', '1595476018', '5', '0', '84', '0.00', '0', '60.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒 &nbsp;1kg&nbsp;优惠套装1 数量5 单价12.00 小计60</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', null, '0', null, '0');
INSERT INTO `by_order` VALUES ('245', 'J7237768719714236720', '599.00', '1595477687', '-1', '0', '84', '0.00', '0', '599.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '无 &nbsp; 数量1 单价599.00 小计599</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7237768719714236720', '0', null, '0');
INSERT INTO `by_order` VALUES ('246', 'J7237785530862833927', '1949.00', '1595477855', '5', '1595479522', '84', '0.00', '0', '1999.00', null, '0', null, '', '', '0', '19', '50.00', 'sdfsdfsdfsdf', '13212341234', '浙江省杭州市西湖区', null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', '', '', '', '0', '0', '5', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J72377858647531547970', '1595485058', '1595479522', '1595477858');
INSERT INTO `by_order` VALUES ('247', 'J7238106503435275636', '1999.00', '1595481065', '-1', '0', '84', '0.00', '0', '1999.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7238106503435275636', '0', null, '0');
INSERT INTO `by_order` VALUES ('248', 'J7230854435696102770', '1999.00', '1595508544', '1', '1595508578', '104', '0.00', '0', '1999.00', null, '0', null, '', '', '0', '0', '0.00', 'cghjjjj', '13245678536', '广东省广州市海珠区', null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', '', '', '', '0', '0', '5', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J72308568938583159680', '1595515768', '1595508578', '1595508568');
INSERT INTO `by_order` VALUES ('249', 'J7230873252070539925', '12.00', '1595508732', '5', '0', '104', '0.00', '0', '12.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶   数量1 单价12.00 小计12</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', null, '0', null, '0');
INSERT INTO `by_order` VALUES ('250', 'J7251683459761634361', '1999.00', '1595616834', '-1', '0', '104', '0.00', '0', '1999.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7251683459761634361', '0', null, '0');
INSERT INTO `by_order` VALUES ('251', '20200728159590944395', '124.00', '1595909443', '0', '0', '95', '0.00', '0', '124.00', '', '0', null, '', '', '0', '0', '0.00', '苟帅', '13621896206', '上海市上海市市辖区浦东新区光明路', null, '0.00', '0', '阿迪达斯长裤男 2017秋季新款运动裤针织&nbsp;红色&nbsp;x数量1单价124.00 小计124</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '0', '202007281595909469950', '1595916669', null, '1595909469');
INSERT INTO `by_order` VALUES ('252', 'J7293435407425521571', '1999.00', '1596034354', '-1', '0', '104', '0.00', '0', '1999.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '3G、16G &nbsp;3G&nbsp;16G 数量1 单价1999.00 小计1999</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7293435407425521571', '0', null, '0');
INSERT INTO `by_order` VALUES ('253', 'J7293445200970401041', '3997.00', '1596034452', '-1', '0', '104', '0.00', '0', '3997.00', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '3G、32G &nbsp;3G&nbsp;32G 数量1 单价3997.00 小计3997</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '0', '0', '0', '0', 'J7293445200970401041', '0', null, '0');
INSERT INTO `by_order` VALUES ('254', '20200804159654817984', '0.10', '1596548179', '5', '0', '84', '0.00', '0', '0.10', '', '0', null, '', '', '0', '0', '0.00', 'sdfsdfsdfsdf', '13212341234', '浙江省杭州市西湖区sdfsdfsdfsdf333336666', null, '0.00', '0', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉&nbsp;数量1单价0.10 小计0.1</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '1', '202008041596548182841', '1596555382', null, '1596548182');
INSERT INTO `by_order` VALUES ('255', '20200804159654851584', '0.10', '1596548515', '5', '0', '84', '0.00', '0', '0.10', '', '0', null, '', '', '0', '0', '0.00', 'sdfsdfsdfsdf', '13212341234', '浙江省杭州市西湖区sdfsdfsdfsdf333336666', null, '0.00', '0', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉&nbsp;数量1单价0.10 小计0.1</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '1', '202008041596548517841', '1596555717', null, '1596548517');
INSERT INTO `by_order` VALUES ('256', '20200823159815569484', '0.10', '1598155694', '5', '0', '84', '0.00', '0', '0.10', '', '0', null, '', '', '0', '0', '0.00', 'sdfsdfsdfsdf', '13212341234', '浙江省杭州市西湖区sdfsdfsdfsdf333336666', null, '0.00', '0', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉&nbsp;数量1单价0.10 小计0.1</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '1', '202008231598155698841', '1598162898', null, '1598155698');
INSERT INTO `by_order` VALUES ('257', '20200823159815579684', '423.00', '1598155796', '5', '0', '84', '0.00', '0', '435.00', '', '0', null, '', '', '0', '28', '12.00', 'sdfsdfsdfsdf', '13212341234', '浙江省杭州市西湖区sdfsdfsdfsdf333336666', null, '0.00', '0', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 &nbsp;红色&nbsp;x数量1单价435.00 小计435</br>', '', '', '', '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '0', '202008231598155798840', '1598162998', null, '1598155798');
INSERT INTO `by_order` VALUES ('258', '20200823159816017484', '0.10', '1598160174', '5', '0', '84', '0.00', '0', '0.10', null, '0', null, null, null, '0', '0', '0.00', null, null, null, null, '0.00', '0', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉&nbsp;数量1单价0.10 小计0.1</br>', null, null, null, '0', '0', '0', '0', '0', '0', '0', '0.00', '0.00', '0.00', '1', '0', '0', '1', null, '0', null, '0');

-- ----------------------------
-- Table structure for by_pay
-- ----------------------------
DROP TABLE IF EXISTS `by_pay`;
CREATE TABLE `by_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `out_trade_no` varchar(225) DEFAULT NULL,
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '优惠后的总金额',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '付款类型1-货到付款2-在线支付',
  `uid` int(10) NOT NULL DEFAULT '0',
  `partnerid` int(10) NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `model` varchar(225) DEFAULT NULL,
  `trade_no` varchar(225) DEFAULT NULL,
  `trade_status` varchar(225) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL,
  `order_id` int(10) NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '1',
  `score` int(10) NOT NULL DEFAULT '0',
  `score_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `coupon_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=575 DEFAULT CHARSET=utf8 COMMENT='在线支付表';

-- ----------------------------
-- Records of by_pay
-- ----------------------------
INSERT INTO `by_pay` VALUES ('563', 'J7221883276768872566', '1987.00', '0', '0', '85', '0', '1595426040', '0', 'order', null, null, null, '0', '2', '0', '0.00', '12.00');
INSERT INTO `by_pay` VALUES ('564', 'J7221961028964712143', '1997.00', '1', '5', '85', '0', '1595426813', '1595419672', 'order', null, null, null, '0', '2', '0', '0.00', '2.00');
INSERT INTO `by_pay` VALUES ('565', '15954234562393', '50.00', '0', '0', '93', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('566', 'J7237785530862833927', '1949.00', '0', '0', '84', '0', '1595485058', '0', 'order', null, null, null, '0', '2', '0', '0.00', '50.00');
INSERT INTO `by_pay` VALUES ('567', 'J72377858647531547970', '1949.00', '1', '5', '84', '0', '0', '1595479522', 'order', null, null, null, '0', '3', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('568', 'J7230854435696102770', '1999.00', '1', '5', '104', '0', '1595515768', '1595508578', 'order', null, null, null, '0', '2', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('569', null, '12.00', '0', '0', '104', '0', '0', '0', 'order', null, null, null, '0', '3', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('570', '20200728159590944395', '124.00', '0', '0', '95', '0', '1595916669', '0', 'order', null, null, null, '0', '2', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('571', '20200804159654817984', '0.10', '0', '0', '84', '0', '1596555382', '0', 'order', null, null, null, '0', '2', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('572', '20200804159654851584', '0.10', '0', '0', '84', '0', '1596555718', '0', 'order', null, null, null, '0', '2', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('573', '20200823159815569484', '0.10', '0', '0', '84', '0', '1598162898', '0', 'order', null, null, null, '0', '2', '0', '0.00', '0.00');
INSERT INTO `by_pay` VALUES ('574', '20200823159815579684', '423.00', '0', '0', '84', '0', '1598162998', '0', 'order', null, null, null, '0', '2', '0', '0.00', '12.00');

-- ----------------------------
-- Table structure for by_plugin
-- ----------------------------
DROP TABLE IF EXISTS `by_plugin`;
CREATE TABLE `by_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL COMMENT '插件名或标识',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '中文名',
  `description` text COMMENT '插件描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `config` text COMMENT '配置',
  `author` varchar(40) DEFAULT '' COMMENT '作者',
  `version` varchar(20) DEFAULT '' COMMENT '版本号',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `admin` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有后台列表',
  `index` tinyint(1) NOT NULL DEFAULT '0',
  `ids` varchar(225) DEFAULT NULL COMMENT '权限id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COMMENT='插件表';

-- ----------------------------
-- Records of by_plugin
-- ----------------------------
INSERT INTO `by_plugin` VALUES ('44', 'wechat', '微信登录插件', '统计站点的基础信息', '1', '{\"appid\":\"xx666\",\"appSecret\":\"\"}', 'bymall', '0.1', '1598368429', '0', '0', null);
INSERT INTO `by_plugin` VALUES ('29', 'sms', '短信插件', '统计sms的基础信息', '1', '{\"appid\":\"xx666\",\"appSecret\":\"asdas\",\"length\":\"6\"}', 'bymall', '0.1', '1598445457', '1', '0', '');
INSERT INTO `by_plugin` VALUES ('60', 'qq', 'qq登录插件', 'qq登录插件', '1', null, 'bymall', '0.1', '0', '0', '0', '');
INSERT INTO `by_plugin` VALUES ('41', 'test', 'test插件', 'test', '1', '[]', 'bymall', '1.0', '0', '1', '0', '6774|999');
INSERT INTO `by_plugin` VALUES ('47', 'alipay', '支付宝pc支付插件', '这是一个临时描述', '1', '{\"appid\":\"\",\"appSecret\":\"\"}', 'bymall', '0.1', '0', '0', '0', null);

-- ----------------------------
-- Table structure for by_records
-- ----------------------------
DROP TABLE IF EXISTS `by_records`;
CREATE TABLE `by_records` (
  `id` int(225) NOT NULL AUTO_INCREMENT,
  `ip` varchar(225) DEFAULT NULL,
  `url` varchar(225) DEFAULT NULL,
  `country` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `info` varchar(225) DEFAULT NULL,
  `province` varchar(225) DEFAULT NULL,
  `city` varchar(225) DEFAULT NULL,
  `isp` varchar(225) DEFAULT NULL,
  `referer` text COMMENT '访问来源',
  `status` int(10) unsigned NOT NULL DEFAULT '0',
  `page` varchar(225) DEFAULT NULL,
  `partnerid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=416 DEFAULT CHARSET=utf8 COMMENT='ip访问记录表';

-- ----------------------------
-- Records of by_records
-- ----------------------------

-- ----------------------------
-- Table structure for by_reduction
-- ----------------------------
DROP TABLE IF EXISTS `by_reduction`;
CREATE TABLE `by_reduction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `goods` varchar(225) DEFAULT '' COMMENT '标志',
  `title` varchar(225) DEFAULT NULL,
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `start_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='满减优惠';

-- ----------------------------
-- Records of by_reduction
-- ----------------------------
INSERT INTO `by_reduction` VALUES ('9', '', '满2000减50', '395', '2000.00', '50.00', '1524673332', '1524846132');
INSERT INTO `by_reduction` VALUES ('10', '201,202,203', '满68减50', '396', '68.00', '5.00', '1524672000', '1545926400');

-- ----------------------------
-- Table structure for by_reply
-- ----------------------------
DROP TABLE IF EXISTS `by_reply`;
CREATE TABLE `by_reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `messageid` int(10) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL COMMENT '回复内容',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '默认null-未提交订单1-未读2-已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='回复表';

-- ----------------------------
-- Records of by_reply
-- ----------------------------

-- ----------------------------
-- Table structure for by_sales
-- ----------------------------
DROP TABLE IF EXISTS `by_sales`;
CREATE TABLE `by_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `specifications` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `orderId` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `is_hide` int(10) NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `num` int(10) NOT NULL DEFAULT '0',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `sku_id` int(10) NOT NULL DEFAULT '0',
  `is_picture` int(10) NOT NULL DEFAULT '0',
  `path` varchar(225) DEFAULT NULL,
  `comment_status` int(10) NOT NULL DEFAULT '0',
  `ship_price` varchar(255) DEFAULT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `type` int(10) NOT NULL DEFAULT '0',
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `order_code` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=559 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of by_sales
-- ----------------------------
INSERT INTO `by_sales` VALUES ('541', '0', '3G、16G', '85', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7221883276768872566', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', 'J72218840128839770880');
INSERT INTO `by_sales` VALUES ('542', '0', '3G、16G', '85', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7221961028964712143', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', 'J72219613819177547070');
INSERT INTO `by_sales` VALUES ('543', '0', '3G、16G', '85', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7222167895612949764', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('544', '0', '&nbsp;1kg&nbsp;优惠套装1', '84', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', 'J7237601828706993319', '203', '0', '60.00', '5', '12.00', '474', '0', null, '0', '0', '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('545', '0', null, '84', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', 'J7237768719714236720', '207', '0', '599.00', '1', '599.00', '320', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('546', '0', '3G、16G', '84', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7237785530862833927', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', 'J72377858647531547970');
INSERT INTO `by_sales` VALUES ('547', '0', '3G、16G', '84', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7238106503435275636', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('548', '0', '3G、16G', '104', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7230854435696102770', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', 'J72308568938583159680');
INSERT INTO `by_sales` VALUES ('549', '0', ' ', '104', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', 'J7230873252070539925', '223', '0', '12.00', '1', '12.00', '475', '0', null, '0', '0', '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('550', '0', '3G、16G', '104', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7251683459761634361', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('551', '0', null, '95', '阿迪达斯长裤男 2017秋季新款运动裤针织', '20200728159590944395', '185', '0', '124.00', '1', '124.00', '289', '0', null, '0', null, '0', '0', '0', '0', '202007281595909469950');
INSERT INTO `by_sales` VALUES ('552', '0', '3G、16G', '104', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7293435407425521571', '225', '0', '1999.00', '1', '1999.00', '355', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('553', '0', '3G、32G', '104', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', 'J7293445200970401041', '225', '0', '3997.00', '1', '3997.00', '356', '0', null, '0', null, '0', '0', '0', '0', null);
INSERT INTO `by_sales` VALUES ('554', '0', null, '84', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '20200804159654817984', '224', '0', '0.10', '1', '0.10', '354', '0', null, '0', null, '0', '0', '0', '1', '202008041596548182841');
INSERT INTO `by_sales` VALUES ('555', '0', null, '84', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '20200804159654851584', '224', '0', '0.10', '1', '0.10', '354', '0', null, '0', null, '0', '0', '0', '1', '202008041596548517841');
INSERT INTO `by_sales` VALUES ('556', '0', null, '84', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '20200823159815569484', '224', '0', '0.10', '1', '0.10', '354', '0', null, '0', null, '0', '0', '0', '1', '202008231598155698841');
INSERT INTO `by_sales` VALUES ('557', '0', null, '84', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '20200823159815579684', '175', '0', '435.00', '1', '435.00', '250', '0', null, '0', null, '0', '0', '0', '0', '202008231598155798840');
INSERT INTO `by_sales` VALUES ('558', '0', null, '84', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '20200823159816017484', '224', '0', '0.10', '1', '0.10', '354', '0', null, '0', null, '0', '0', '0', '1', null);

-- ----------------------------
-- Table structure for by_score_code
-- ----------------------------
DROP TABLE IF EXISTS `by_score_code`;
CREATE TABLE `by_score_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `code` varchar(255) DEFAULT NULL COMMENT '兑换码',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `orderId` varchar(255) DEFAULT NULL COMMENT '订单号',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分类型',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分兑换码表';

-- ----------------------------
-- Records of by_score_code
-- ----------------------------
INSERT INTO `by_score_code` VALUES ('1', 'xdkjkkjksdfr324342', '2', '', '1575880833', '0', '3');

-- ----------------------------
-- Table structure for by_score_goods
-- ----------------------------
DROP TABLE IF EXISTS `by_score_goods`;
CREATE TABLE `by_score_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `num` varchar(255) DEFAULT NULL COMMENT '积分数量',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `tpl` varchar(255) DEFAULT NULL COMMENT '模板名称',
  `type` tinyint(2) DEFAULT '0' COMMENT '商品类型',
  `type_id` tinyint(2) DEFAULT '0' COMMENT '积分类型id',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面图片',
  `content` text NOT NULL COMMENT '详情',
  `sku` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分商品表';

-- ----------------------------
-- Records of by_score_goods
-- ----------------------------
INSERT INTO `by_score_goods` VALUES ('1', '洁柔Face百花香味135抽3层抽取式纸面巾JR069-01(3包装)', '30000', '1', '', '0', '1', '480', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/ed55af40-213f-44b3-8d38-6e7ec1eff635.jpg\" />', '1000');
INSERT INTO `by_score_goods` VALUES ('2', '小马宝莉48粒拼图-丰收的喜悦', '4200', '1', 'add', '0', '1', '481', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/cc4293a2-d227-4721-aa7c-d40783ec614f.jpg\" />', '1000');
INSERT INTO `by_score_goods` VALUES ('3', '腾讯视频VIP会员月卡', '1800', '1', 'film', '0', '1', '482', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/bfbf6d36-37da-408f-b7a6-551d422db98d.jpg\" />', '1000');

-- ----------------------------
-- Table structure for by_score_log
-- ----------------------------
DROP TABLE IF EXISTS `by_score_log`;
CREATE TABLE `by_score_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `score` text COMMENT '积分值',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` int(10) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=99 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_score_log
-- ----------------------------
INSERT INTO `by_score_log` VALUES ('47', '4200', '70', '0', '1575876861', '874580', '积分兑换商品');
INSERT INTO `by_score_log` VALUES ('48', '4200', '70', '0', '1575877071', '870380', '积分兑换商品');
INSERT INTO `by_score_log` VALUES ('49', '1800', '70', '0', '1575880413', '868580', '积分兑换商品');
INSERT INTO `by_score_log` VALUES ('50', '3', '84', '2', '1594268166', '3', '签到赠送');
INSERT INTO `by_score_log` VALUES ('51', '2', '84', '1', '1594452122', '5', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('52', '3', '84', '2', '1594561503', '8', '签到赠送');
INSERT INTO `by_score_log` VALUES ('53', '2', '84', '1', '1594561655', '10', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('54', '2', '84', '1', '1594602430', '12', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('55', '3', '84', '2', '1594808854', '15', '签到赠送');
INSERT INTO `by_score_log` VALUES ('56', '2', '87', '1', '1594813006', '2', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('57', '2', '84', '1', '1594971804', '17', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('58', '2', '87', '1', '1595052049', '4', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('59', '2', '84', '1', '1595127462', '19', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('60', '2', '87', '1', '1595130869', '6', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('61', '3', '84', '2', '1595135291', '22', '签到赠送');
INSERT INTO `by_score_log` VALUES ('62', '2', '84', '1', '1595236193', '24', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('63', '2', '84', '1', '1595325393', '26', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('64', '3', '94', '2', '1595848355', '3', '签到赠送');
INSERT INTO `by_score_log` VALUES ('65', '2', '95', '1', '1595909440', '2', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('66', '3', '95', '2', '1595909538', '5', '签到赠送');
INSERT INTO `by_score_log` VALUES ('67', '2', '87', '1', '1595935235', '8', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('68', '2', '84', '1', '1596548176', '28', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('69', '2', '84', '1', '1596597403', '30', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('70', '2', '84', '1', '1597303202', '32', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('71', '2', '84', '1', '1597457503', '34', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('72', '2', '84', '1', '1597889363', '36', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('73', '2', '84', '1', '1598155616', '38', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('74', '2', '84', '1', '1598677545', '40', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('75', '2', '84', '1', '1598853179', '42', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('76', '2', '84', '1', '1599015774', '44', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('77', '2', '97', '1', '1599018919', '2', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('78', '2', '98', '1', '1599045848', '2', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('79', '2', '84', '1', '1599098852', '46', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('80', '2', '98', '1', '1599101410', '4', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('81', '2', '84', '1', '1599149894', '48', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('82', '2', '98', '1', '1599150041', '6', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('83', '2', '97', '1', '1599182500', '4', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('84', '2', '98', '1', '1599270054', '8', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('85', '2', '97', '1', '1599284655', '6', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('86', '2', '97', '1', '1599355688', '8', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('87', '2', '99', '1', '1599365222', '2', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('88', '2', '97', '1', '1599460560', '10', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('89', '2', '84', '1', '1599536434', '50', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('90', '2', '97', '1', '1599536612', '12', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('91', '2', '84', '1', '1599623272', '52', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('92', '2', '97', '1', '1599633074', '14', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('93', '2', '98', '1', '1599641588', '10', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('94', '2', '84', '1', '1599705779', '54', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('95', '2', '97', '1', '1599705796', '16', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('96', '2', '98', '1', '1599720333', '12', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('97', '2', '84', '1', '1600003927', '56', '登录赠送积分');
INSERT INTO `by_score_log` VALUES ('98', '2', '98', '1', '1600179521', '14', '登录赠送积分');

-- ----------------------------
-- Table structure for by_score_order
-- ----------------------------
DROP TABLE IF EXISTS `by_score_order`;
CREATE TABLE `by_score_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `orderId` varchar(255) DEFAULT NULL COMMENT '订单号',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `express` varchar(225) DEFAULT NULL COMMENT '快递名称',
  `express_code` varchar(225) DEFAULT NULL COMMENT '快递单号',
  `username` varchar(225) DEFAULT NULL COMMENT '用户名',
  `mobile` varchar(225) DEFAULT NULL COMMENT '联系方式',
  `address` varchar(225) DEFAULT NULL COMMENT '地址',
  `code` varchar(225) DEFAULT NULL COMMENT '兑换码',
  `type_id` varchar(225) DEFAULT NULL COMMENT '积分类型id',
  `title` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `goods_id` int(10) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分兑换表';

-- ----------------------------
-- Records of by_score_order
-- ----------------------------
INSERT INTO `by_score_order` VALUES ('1', '20191209157587686170', '4200', '1575876861', '0', '0', '70', '顺丰速递', '', 'e5345', '34534', '3453453', '', '1', '小马宝莉48粒拼图-丰收的喜悦', '0');
INSERT INTO `by_score_order` VALUES ('2', '20191209157587707170', '4200', '1575877071', '0', '0', '70', '顺丰速递', '', 'e5345', '34534', '3453453', '', '1', '小马宝莉48粒拼图-丰收的喜悦', '0');
INSERT INTO `by_score_order` VALUES ('3', '20191209157588041370', '1800', '1575880413', '1', '1575880833', '70', '', 'xdkjkkjksdfr324342', '', '', '', 'xdkjkkjksdfr324342', '3', '腾讯视频VIP会员月卡', '0');

-- ----------------------------
-- Table structure for by_score_type
-- ----------------------------
DROP TABLE IF EXISTS `by_score_type`;
CREATE TABLE `by_score_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '供应商名称',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `tpl` varchar(255) DEFAULT NULL COMMENT '模板名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分类型表';

-- ----------------------------
-- Records of by_score_type
-- ----------------------------
INSERT INTO `by_score_type` VALUES ('1', '实物商品', '1', 'scoregoods/edit');
INSERT INTO `by_score_type` VALUES ('3', 'vip会员', '1', '');
INSERT INTO `by_score_type` VALUES ('4', '购物卡', '1', '');
INSERT INTO `by_score_type` VALUES ('5', '话费卡', '1', '');

-- ----------------------------
-- Table structure for by_seller_category
-- ----------------------------
DROP TABLE IF EXISTS `by_seller_category`;
CREATE TABLE `by_seller_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `uid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `list_row` tinyint(3) unsigned NOT NULL DEFAULT '10' COMMENT '列表每页行数',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `model` varchar(100) NOT NULL DEFAULT '' COMMENT '列表绑定模型',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `check` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '发布的文章是否需要审核',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `icon` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `ismenu` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类是否调用',
  `partnerid` int(10) NOT NULL DEFAULT '0',
  `type` int(2) NOT NULL DEFAULT '2',
  `name` varchar(225) DEFAULT NULL,
  `allow_publish` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of by_seller_category
-- ----------------------------
INSERT INTO `by_seller_category` VALUES ('160', '1', ' 服装鞋帽', '0', '0', '30', '', '', '', '5', '1', '0', '1443935744', '1443955366', '1', '0', '1', '1', '2', 'lppz', '1');
INSERT INTO `by_seller_category` VALUES ('161', '1', '男装', '160', '0', '30', '', '', '', '5', '1', '0', '1443935897', '1443935897', '1', '0', '1', '1', '2', '', '1');
INSERT INTO `by_seller_category` VALUES ('162', '1', '女装', '160', '0', '30', '', '', '', '8', '1', '0', '1443935945', '1443935945', '1', '0', '1', '1', '2', '', '1');

-- ----------------------------
-- Table structure for by_seller_channel
-- ----------------------------
DROP TABLE IF EXISTS `by_seller_channel`;
CREATE TABLE `by_seller_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `shopid` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '新窗口打开',
  `partnerid` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_seller_channel
-- ----------------------------
INSERT INTO `by_seller_channel` VALUES ('6', '0', '手机秒杀', 'Category/index', '0', '0', '1443902437', '1443902437', '1', '0', '1', '1');

-- ----------------------------
-- Table structure for by_seller_menu
-- ----------------------------
DROP TABLE IF EXISTS `by_seller_menu`;
CREATE TABLE `by_seller_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `group` varchar(50) DEFAULT '' COMMENT '分组',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=193 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_seller_menu
-- ----------------------------
INSERT INTO `by_seller_menu` VALUES ('191', '评论管理', '131', '9', 'Comment/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('190', '回复管理', '131', '8', 'Reply/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('189', '留言管理', '131', '7', 'Message/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('188', '导航管理', '183', '2', 'SellerChannel/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('185', '商品分类', '183', '3', 'Category/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('184', '店铺管理', '183', '1', 'Shop/edit', '0', '', '基本管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('183', '后台', '0', '0', 'Category/index', '0', '', '', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('177', ' 快递管理', '183', '6', 'Express/index', '0', '', '应用管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('134', '优惠券', '158', '4', 'Fcoupon/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('131', '订单', '0', '6', 'Order/index', '0', '', '', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('132', '提交订单', '131', '1', 'Order/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('137', '正退货订单', '173', '4', 'Back/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('138', '同意退货订单', '173', '7', 'Backagree/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('139', '已退货订单', '173', '8', 'Backover/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('140', '换货管理', '131', '4', 'Change/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('143', '今日销量统计', '146', '13', 'Statistics/index', '0', '', '数据统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('144', '本周销量统计', '146', '14', 'Statistics/week', '0', '', '数据统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('145', '本月销量统计', '146', '15', 'Statistics/month', '0', '', '数据统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('146', '数据', '0', '7', 'Statistics/index', '0', '', '数据统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('147', '每日数据', '146', '16', 'Report/index', '0', '', '报表统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('148', '每周数据', '146', '17', 'Report/week', '0', '', '报表统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('149', '每月统计', '146', '18', 'Report/month', '0', '', '报表统计', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('192', '流量统计', '183', '7', 'Records/index', '0', '', '应用管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('179', '收入管理', '183', '5', 'Pay/index', '0', '', '财务管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('153', '取消管理', '131', '2', 'Cancel/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('158', '广告', '0', '9', 'Slide/index', '0', '', '', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('160', '幻灯片', '158', '0', 'Slide/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('186', '站内信', '183', '4', 'Personenvelope/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('162', '拒绝退货订单', '173', '5', 'Backrefuse/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('163', '退货中订单', '173', '6', 'Backon/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('166', '商品', '0', '4', 'Goods/index', '0', '', '', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('168', '邮件管理', '16', '6', 'Email/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('169', '短信管理', '16', '7', 'Sms/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('170', '站内信管理', '16', '8', 'Envelope/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('171', '留言管理', '16', '9', 'Message/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('172', '回复管理', '16', '10', 'Reply/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('176', '退货管理', '131', '3', 'Back/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('174', '文章分类', '68', '2', 'Catearticle/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('175', '预约列表', '68', '0', 'Reserve/index', '0', '', '预约管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('180', '商家审核', '181', '0', 'Check/index', '0', '', '用户管理', '0', '1');
INSERT INTO `by_seller_menu` VALUES ('182', '后台菜单', '181', '0', 'SellerMenu/index', '0', '', '基本管理', '0', '1');

-- ----------------------------
-- Table structure for by_service
-- ----------------------------
DROP TABLE IF EXISTS `by_service`;
CREATE TABLE `by_service` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) DEFAULT NULL,
  `content` varchar(225) DEFAULT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `assistant` int(10) unsigned NOT NULL DEFAULT '0',
  `reply` varchar(225) DEFAULT NULL,
  `type` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='售后服务表';

-- ----------------------------
-- Records of by_service
-- ----------------------------

-- ----------------------------
-- Table structure for by_shop
-- ----------------------------
DROP TABLE IF EXISTS `by_shop`;
CREATE TABLE `by_shop` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '链接唯一标识',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户uid',
  `qq` varchar(100) DEFAULT NULL COMMENT 'qq',
  `aliwangwang` char(100) DEFAULT NULL COMMENT '阿里旺旺',
  `title` char(100) DEFAULT NULL COMMENT '店铺名',
  `username` char(100) DEFAULT NULL COMMENT '用户名',
  `country` char(100) DEFAULT NULL COMMENT '国家',
  `province` char(100) DEFAULT NULL COMMENT '省份',
  `city` char(100) DEFAULT NULL COMMENT '市',
  `area` char(100) DEFAULT NULL COMMENT '地区',
  `address` char(100) DEFAULT NULL COMMENT '详细地址',
  `worktime` char(100) DEFAULT NULL COMMENT '工作时间',
  `notice` char(100) DEFAULT NULL COMMENT '公告',
  `mobile` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '手机',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '店铺logo',
  `banner` int(10) unsigned NOT NULL DEFAULT '2' COMMENT '店铺logo',
  `card_num` char(100) NOT NULL DEFAULT '' COMMENT '审核提示信息',
  `bank` char(100) NOT NULL DEFAULT '' COMMENT '银行账户',
  `card` char(100) NOT NULL DEFAULT '' COMMENT '身份证',
  `level` tinyint(10) NOT NULL DEFAULT '1' COMMENT '商家等级',
  `status` tinyint(10) NOT NULL DEFAULT '2' COMMENT '0-未通过1-通过2-待审核',
  `menu_num` int(10) unsigned NOT NULL DEFAULT '7' COMMENT '自定义菜单数量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `description` varchar(225) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `email` varchar(225) DEFAULT NULL,
  `is_agree` int(2) NOT NULL DEFAULT '0',
  `money` varchar(225) DEFAULT NULL,
  `agree` tinyint(10) NOT NULL DEFAULT '0',
  `bank_number` varchar(225) DEFAULT NULL,
  `bank_username` varchar(225) DEFAULT NULL,
  `s1` varchar(225) DEFAULT NULL,
  `s2` varchar(225) DEFAULT NULL,
  `s3` varchar(225) DEFAULT NULL,
  `view` int(10) NOT NULL DEFAULT '0',
  `sale` int(10) NOT NULL DEFAULT '0',
  `location` varchar(255) DEFAULT NULL COMMENT '注册地',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='店铺表';

-- ----------------------------
-- Records of by_shop
-- ----------------------------
INSERT INTO `by_shop` VALUES ('1', '81', '', '', '1号店', '12331355', '', '', '', '', '1333', '周一至周日：8:00-22:00', '', '0', '1', '0', '13366666', '', '468', '1', '4', '7', '1532901696', '0', '', '72', '133', '0', '', '0', '', '', '5', '5', '5', '103', '0', null);
INSERT INTO `by_shop` VALUES ('10', '84', '1010422715', '', '天天果园', '浏览', '', '', '', '', '1123232', '8:00-24:00 周一至周六', '', '4294967295', '1', '613', '421243345', '', '470', '1', '4', '7', '1533187565', '0', '', '52', '3453', '0', '2000', '1', '', '', '5', '5', '5', '934', '0', '');
INSERT INTO `by_shop` VALUES ('12', '81', '', null, '文档管理', '', null, null, null, null, null, '', null, '0', '1', '2', '', '', '', '1', '1', '7', '1584537518', '0', '', '72', null, '0', '', '0', null, null, '5', '5', '5', '2', '0', '海南');
INSERT INTO `by_shop` VALUES ('13', '89', '', null, '大大', '', null, null, null, null, null, '', null, '0', '1', '2', '', '', '', '1', '4', '7', '1595063731', '0', '', '52', null, '0', '', '0', null, null, '5', '5', '5', '6', '0', '北京');

-- ----------------------------
-- Table structure for by_shop_category
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_category`;
CREATE TABLE `by_shop_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `uid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `category_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of by_shop_category
-- ----------------------------
INSERT INTO `by_shop_category` VALUES ('1', '1', '手机', '0', '0', '0', '0', '1', '1', '0');
INSERT INTO `by_shop_category` VALUES ('2', '23', '4543', '0', '0', '1533194055', '1533194055', '1', '10', '179');

-- ----------------------------
-- Table structure for by_shop_channel
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_channel`;
CREATE TABLE `by_shop_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `shop_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` varchar(225) DEFAULT NULL COMMENT '新窗口打开',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_shop_channel
-- ----------------------------

-- ----------------------------
-- Table structure for by_shop_express
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_express`;
CREATE TABLE `by_shop_express` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `code` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `shop_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='快递表';

-- ----------------------------
-- Records of by_shop_express
-- ----------------------------

-- ----------------------------
-- Table structure for by_shop_group
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_group`;
CREATE TABLE `by_shop_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `module` varchar(225) DEFAULT NULL,
  `icon` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_shop_group
-- ----------------------------
INSERT INTO `by_shop_group` VALUES ('1', '系统', '0', '1', 'shopCategory/index', '0', '1', '', '');
INSERT INTO `by_shop_group` VALUES ('3', '商品', '1', '2', 'goods/index', '0', '1', '', '');
INSERT INTO `by_shop_group` VALUES ('7', '文章', '40', '3', 'document/index', '0', '1', '', '');
INSERT INTO `by_shop_group` VALUES ('18', '首页', '0', '0', 'index/index', '0', '1', '', '');

-- ----------------------------
-- Table structure for by_shop_menu
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_menu`;
CREATE TABLE `by_shop_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `group_id` varchar(50) DEFAULT NULL COMMENT '分组',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=193 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_shop_menu
-- ----------------------------
INSERT INTO `by_shop_menu` VALUES ('191', '评论管理', '131', '9', 'Comment/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('190', '回复管理', '131', '8', 'Reply/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('189', '留言管理', '131', '7', 'Message/index', '0', '', '咨询回复', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('188', '导航管理', '183', '2', 'SellerChannel/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('185', '商品分类', '183', '3', 'Category/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('184', '店铺管理', '183', '1', 'Shop/edit', '0', '', '基本管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('183', '后台', '0', '0', 'Category/index', '0', '', '', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('177', ' 快递管理', '183', '6', 'Express/index', '0', '', '应用管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('134', '优惠券', '158', '4', 'Fcoupon/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('131', '订单', '0', '6', 'Order/index', '0', '', '', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('132', '提交订单', '131', '1', 'Order/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('137', '正退货订单', '173', '4', 'Back/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('138', '同意退货订单', '173', '7', 'Backagree/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('139', '已退货订单', '173', '8', 'Backover/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('140', '换货管理', '131', '4', 'Change/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('143', '今日销量统计', '146', '13', 'Statistics/index', '0', '', '数据统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('144', '本周销量统计', '146', '14', 'Statistics/week', '0', '', '数据统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('145', '本月销量统计', '146', '15', 'Statistics/month', '0', '', '数据统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('146', '数据', '0', '7', 'Statistics/index', '0', '', '数据统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('147', '每日数据', '146', '16', 'Report/index', '0', '', '报表统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('148', '每周数据', '146', '17', 'Report/week', '0', '', '报表统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('149', '每月统计', '146', '18', 'Report/month', '0', '', '报表统计', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('192', '流量统计', '183', '7', 'Records/index', '0', '', '应用管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('179', '收入管理', '183', '5', 'Pay/index', '0', '', '财务管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('153', '取消管理', '131', '2', 'Cancel/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('158', '广告', '0', '9', 'Slide/index', '0', '', '', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('160', '幻灯片', '158', '0', 'Slide/index', '0', '', '广告管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('186', '站内信', '183', '4', 'Personenvelope/index', '0', '', '基本管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('162', '拒绝退货订单', '173', '5', 'Backrefuse/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('163', '退货中订单', '173', '6', 'Backon/index', '0', '', '退货管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('166', '商品', '0', '4', 'Goods/index', '0', '', '', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('168', '邮件管理', '16', '6', 'Email/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('169', '短信管理', '16', '7', 'Sms/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('170', '站内信管理', '16', '8', 'Envelope/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('171', '留言管理', '16', '9', 'Message/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('172', '回复管理', '16', '10', 'Reply/index', '0', '', '信息管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('176', '退货管理', '131', '3', 'Back/index', '0', '', '订单管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('174', '文章分类', '68', '2', 'Catearticle/index', '0', '', '系统设置', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('175', '预约列表', '68', '0', 'Reserve/index', '0', '', '预约管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('180', '商家审核', '181', '0', 'Check/index', '0', '', '用户管理', '0', '1');
INSERT INTO `by_shop_menu` VALUES ('182', '后台菜单', '181', '0', 'SellerMenu/index', '0', '', '基本管理', '0', '1');

-- ----------------------------
-- Table structure for by_shop_module
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_module`;
CREATE TABLE `by_shop_module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `group_id` int(2) DEFAULT '0',
  `icon` varchar(225) DEFAULT NULL,
  `name` varchar(225) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=181 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_shop_module
-- ----------------------------
INSERT INTO `by_shop_module` VALUES ('1', '店铺管理', '0', '1', '', '0', '1', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('7', '商品分类', '1', '0', 'SC/index', '0', '1', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('143', '增加', '142', '0', 'slide/add', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('16', '订单管理', '1', '0', 'order/index', '0', '1', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('21', '退款管理', '166', '0', 'drawback/index', '0', '1', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('22', '支付管理', '1', '0', 'pay/index', '0', '1', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('40', '商品管理', '0', '1', '', '0', '1', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('60', '奖品管理', '58', '0', 'ScratchPrize/index', '0', '1', '0', '', '');
INSERT INTO `by_shop_module` VALUES ('72', 'sku管理', '40', '0', 'sku/index', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('65', '奖品管理', '63', '0', 'SmashingPrize/index', '0', '1', '0', '', '');
INSERT INTO `by_shop_module` VALUES ('70', '系统设置', '1', '3', 'shop/systems', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('71', '商品列表', '40', '0', 'goods/index', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('91', '增加', '7', '0', 'category/add', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('92', '编辑', '7', '0', 'category/edit', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('93', '删除', '7', '0', 'category/del', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('102', '增加', '71', '0', 'goods/add', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('108', '编辑', '71', '0', 'goods/edit', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('110', '删除', '71', '0', 'goods/del', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('111', '增加', '72', '0', 'sku/add', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('112', '编辑', '72', '0', 'sku/edit', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('113', '删除', '72', '0', 'sku/del', '0', '0', '3', '', '');
INSERT INTO `by_shop_module` VALUES ('114', '增加', '16', '0', 'order/add', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('115', '编辑', '16', '0', 'order/edit', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('116', '导出订单', '16', '0', 'order/out', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('117', '删除', '16', '0', 'order/del', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('118', '增加', '21', '0', 'drawback/add', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('119', '编辑', '21', '0', 'drawback/edit', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('120', '删除', '21', '0', 'drawback/del', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('121', '增加', '22', '0', 'pay/add', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('122', '编辑', '22', '0', 'pay/edit', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('123', '删除', '22', '0', 'rank/del', '0', '0', '15', '', '');
INSERT INTO `by_shop_module` VALUES ('142', '幻灯片管理', '148', '0', 'ShopSlide/index', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('144', '编辑', '142', '0', 'slide/edit', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('145', '删除', '142', '0', 'slide/del', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('146', '切换分类', '142', '0', 'slide/change', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('148', '广告管理', '0', '0', '', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('179', '提现申请', '178', '0', 'cash/index', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('180', '提现记录', '178', '0', 'cashLog/index', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('158', '商品评价', '40', '0', 'comment/index', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('159', '增加', '158', '0', 'comment/add', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('160', '编辑', '158', '0', 'comment/edit', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('161', '删除', '158', '0', 'comment/del', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('166', '售后管理', '0', '0', '', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('178', '提现管理', '0', '0', '', '0', '0', '1', '', '');
INSERT INTO `by_shop_module` VALUES ('172', '商家管理', '0', '0', '', '0', '0', '19', '', '');
INSERT INTO `by_shop_module` VALUES ('176', '菜单管理', '172', '0', 'shopMenu/index', '0', '0', '19', '', '');
INSERT INTO `by_shop_module` VALUES ('177', '分组管理', '172', '0', 'shopGroup/index', '0', '0', '19', '', '');

-- ----------------------------
-- Table structure for by_shop_slide
-- ----------------------------
DROP TABLE IF EXISTS `by_shop_slide`;
CREATE TABLE `by_shop_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `title` varchar(225) DEFAULT '' COMMENT '标题',
  `url` varchar(225) DEFAULT '' COMMENT '链接',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `place` tinyint(30) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='幻灯片图片储存表';

-- ----------------------------
-- Records of by_shop_slide
-- ----------------------------

-- ----------------------------
-- Table structure for by_sign
-- ----------------------------
DROP TABLE IF EXISTS `by_sign`;
CREATE TABLE `by_sign` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1-正常',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='签到表';

-- ----------------------------
-- Records of by_sign
-- ----------------------------
INSERT INTO `by_sign` VALUES ('5', '1', '1445228991', '1');
INSERT INTO `by_sign` VALUES ('6', '5', '1445307839', '1');

-- ----------------------------
-- Table structure for by_sku
-- ----------------------------
DROP TABLE IF EXISTS `by_sku`;
CREATE TABLE `by_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(225) DEFAULT NULL COMMENT '规格名称',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品id',
  `cost` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '销售价',
  `create_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sales` int(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `hits` int(11) NOT NULL DEFAULT '0',
  `path` varchar(64) DEFAULT '',
  `attributes` text,
  `num` int(10) NOT NULL DEFAULT '999999',
  `cover_id` int(10) NOT NULL DEFAULT '0',
  `mprice` int(10) NOT NULL DEFAULT '0',
  `j_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '利润',
  `number` int(10) NOT NULL DEFAULT '0' COMMENT '库存编号',
  `upc` varchar(225) DEFAULT NULL,
  `code` varchar(225) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=384 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_sku
-- ----------------------------
INSERT INTO `by_sku` VALUES ('220', '无', '168', '18.00', '99.00', '0000-00-00 00:00:00', '0', '1', '0', '168', '', '10', '0', '0', '0.00', '102.00', '0', '', '', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味');
INSERT INTO `by_sku` VALUES ('218', '无', '166', '6.00', '30.00', '0000-00-00 00:00:00', '0', '1', '0', '166', '', '23', '0', '0', '0.00', '191.00', '0', '', '', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味');
INSERT INTO `by_sku` VALUES ('219', '无', '167', '12.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '167', '', '333', '0', '0', '0.00', '195.00', '0', '', '', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货');
INSERT INTO `by_sku` VALUES ('217', '无', '165', '24.00', '8.90', '0000-00-00 00:00:00', '0', '1', '0', '165', '', '234', '0', '0', '0.00', '159.00', '0', '', '', '新农哥五香花生136g 坚果炒货小吃');
INSERT INTO `by_sku` VALUES ('216', '无', '164', '15.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '164', '', '122', '0', '0', '0.00', '107.00', '0', '', '', '泰国龙眼1kg 热带桂圆 进口水果');
INSERT INTO `by_sku` VALUES ('215', '无', '163', '11.00', '24.00', '0000-00-00 00:00:00', '0', '1', '0', '163', '', '665', '0', '0', '0.00', '192.00', '0', '', '', '陕西精品红富士1kg 80-85mm 苹果 水果');
INSERT INTO `by_sku` VALUES ('214', '无', '162', '25.00', '0.10', '0000-00-00 00:00:00', '0', '1', '0', '162', '', '100', '0', '0', '0.00', '158.00', '0', '', '', '澳大利亚晚季脐橙10个140g以上/个橙子水果');
INSERT INTO `by_sku` VALUES ('221', '无', '169', '42.00', '77.00', '0000-00-00 00:00:00', '0', '1', '0', '169', '', '77', '0', '0', '0.00', '124.00', '0', '', '', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品');
INSERT INTO `by_sku` VALUES ('233', '3G、64G', '170', '46.00', '7464.00', '0000-00-00 00:00:00', '0', '1', '0', '75,89', '', '76', '0', '0', '0.00', '137.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('232', '3G、32G', '170', '49.00', '6479.00', '0000-00-00 00:00:00', '0', '1', '0', '75,88', '', '47', '0', '0', '0.00', '128.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('231', '3G、16G', '170', '45.00', '6456.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '56', '0', '0', '0.00', '114.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('230', '2G、64G', '170', '26.00', '5654.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '34', '0', '0', '0.00', '108.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('229', '2G、32G', '170', '32.00', '5654.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '98', '0', '0', '0.00', '159.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('228', '2G、16G', '170', '49.00', '5488.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '10', '0', '0', '0.00', '180.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('234', '2G、16G', '171', '10.00', '5675.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '5638', '0', '0', '0.00', '121.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('235', '2G、32G', '171', '28.00', '65567.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '5676', '0', '0', '0.00', '170.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('236', '2G、64G', '171', '30.00', '5467.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '56765', '0', '0', '0.00', '131.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('237', '4G、16G', '171', '18.00', '56765.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '5675', '0', '0', '0.00', '142.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('238', '4G、32G', '171', '21.00', '56765.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '56765', '0', '0', '0.00', '131.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('239', '4G、64G', '171', '32.00', '567657.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '56765', '0', '0', '0.00', '161.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机');
INSERT INTO `by_sku` VALUES ('240', '2G、16G', '172', '15.00', '5460.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '50', '0', '0', '0.00', '101.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机');
INSERT INTO `by_sku` VALUES ('241', '3G、16G', '172', '42.00', '4560.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '40', '0', '0', '0.00', '118.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机');
INSERT INTO `by_sku` VALUES ('242', '4G、16G', '172', '47.00', '4560.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '50', '0', '0', '0.00', '158.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机');
INSERT INTO `by_sku` VALUES ('243', '6G、16G', '172', '28.00', '5564.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '45', '0', '0', '0.00', '121.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机');
INSERT INTO `by_sku` VALUES ('244', '4G、16G', '173', '39.00', '3056.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '345', '0', '0', '0.00', '175.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机');
INSERT INTO `by_sku` VALUES ('245', '4G、32G', '173', '47.00', '3453.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '345', '0', '0', '0.00', '121.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机');
INSERT INTO `by_sku` VALUES ('246', '4G、64G', '173', '47.00', '5475.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '4564', '0', '0', '0.00', '124.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机');
INSERT INTO `by_sku` VALUES ('247', '2G、16G', '174', '41.00', '3455.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '345', '0', '0', '0.00', '194.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s');
INSERT INTO `by_sku` VALUES ('248', '2G、32G', '174', '40.00', '3454.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '34535', '0', '0', '0.00', '154.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s');
INSERT INTO `by_sku` VALUES ('249', '2G、64G', '174', '33.00', '34543.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '3', '0', '0', '0.00', '117.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s');
INSERT INTO `by_sku` VALUES ('250', '红色、x', '175', '38.00', '435.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '546', '0', '0', '0.00', '136.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('251', '红色、xl', '175', '41.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '456', '0', '0', '0.00', '174.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('252', '红色、xxl', '175', '23.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '63,68', '', '456', '0', '0', '0.00', '132.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('253', '蓝色、x', '175', '9.00', '546.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '546', '0', '0', '0.00', '160.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('254', '蓝色、xl', '175', '33.00', '5465.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '546', '0', '0', '0.00', '143.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('255', '蓝色、xxl', '175', '29.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '64,68', '', '4565', '0', '0', '0.00', '138.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ');
INSERT INTO `by_sku` VALUES ('256', '红色、xl', '176', '36.00', '567.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '678', '0', '0', '0.00', '144.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ');
INSERT INTO `by_sku` VALUES ('257', '红色、xxl', '176', '35.00', '6576.00', '0000-00-00 00:00:00', '0', '1', '0', '63,68', '', '7897', '0', '0', '0.00', '111.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ');
INSERT INTO `by_sku` VALUES ('258', '白色、xl', '176', '19.00', '78987.00', '0000-00-00 00:00:00', '0', '1', '0', '69,67', '', '789', '0', '0', '0.00', '144.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ');
INSERT INTO `by_sku` VALUES ('259', '白色、xxl', '176', '37.00', '7897.00', '0000-00-00 00:00:00', '0', '1', '0', '69,68', '', '7897', '0', '0', '0.00', '166.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ');
INSERT INTO `by_sku` VALUES ('260', '黑、官方标配', '177', '41.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95', '', '456', '0', '0', '0.00', '102.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('261', '黑、套餐1', '177', '27.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96', '', '456', '0', '0', '0.00', '198.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('262', '黑、套餐2', '177', '31.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,97', '', '456', '0', '0', '0.00', '180.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('263', '白、官方标配', '177', '43.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95', '', '456', '0', '0', '0.00', '121.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('264', '白、套餐1', '177', '45.00', '4565.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96', '', '456', '0', '0', '0.00', '117.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('265', '白、套餐2', '177', '26.00', '45645.00', '0000-00-00 00:00:00', '0', '1', '0', '92,97', '', '45654', '0', '0', '0.00', '153.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('266', '金、官方标配', '177', '49.00', '45654.00', '0000-00-00 00:00:00', '0', '1', '0', '93,95', '', '456', '0', '0', '0.00', '118.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('267', '金、套餐1', '177', '11.00', '45654.00', '0000-00-00 00:00:00', '0', '1', '0', '93,96', '', '456', '0', '0', '0.00', '170.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('268', '金、套餐2', '177', '35.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '93,97', '', '4565', '0', '0', '0.00', '175.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公');
INSERT INTO `by_sku` VALUES ('269', '无', '178', '15.00', '39.90', '0000-00-00 00:00:00', '0', '1', '0', '178', '', '100', '0', '0', '0.00', '143.00', '0', '', '', 'OPPO耳机原装正品全球限量版');
INSERT INTO `by_sku` VALUES ('274', '黑、官方标配、2g', '179', '8.00', '3456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,102', '', '654', '0', '0', '0.00', '164.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('273', '黑、官方标配、1g', '179', '31.00', '5465.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,101', '', '546', '0', '0', '0.00', '176.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('275', '黑、套餐1、1g', '179', '24.00', '5456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,101', '', '645', '0', '0', '0.00', '135.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('276', '黑、套餐1、2g', '179', '49.00', '4456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,102', '', '645', '0', '0', '0.00', '154.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('277', '白、官方标配、1g', '179', '16.00', '4456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95,101', '', '645', '0', '0', '0.00', '163.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('278', '白、官方标配、2g', '179', '29.00', '6456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95,102', '', '54', '0', '0', '0.00', '121.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('279', '白、套餐1、1g', '179', '35.00', '7456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96,101', '', '456', '0', '0', '0.00', '139.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('280', '白、套餐1、2g', '179', '42.00', '84564.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96,102', '', '456', '0', '0', '0.00', '151.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本');
INSERT INTO `by_sku` VALUES ('281', '无', '180', '32.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '180', '', '122', '0', '0', '0.00', '164.00', '0', '', '', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800');
INSERT INTO `by_sku` VALUES ('282', '无', '181', '38.00', '223.00', '0000-00-00 00:00:00', '0', '1', '0', '181', '', '23', '0', '0', '0.00', '124.00', '0', '', '', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500');
INSERT INTO `by_sku` VALUES ('283', '无', '182', '35.00', '233.00', '0000-00-00 00:00:00', '0', '1', '0', '182', '', '123', '0', '0', '0.00', '133.00', '0', '', '', 'ZARA 男装 绒面质感裤子 06706310707');
INSERT INTO `by_sku` VALUES ('284', '无', '183', '12.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '183', '', '234', '0', '0', '0.00', '150.00', '0', '', '', 'PUMA彪马男鞋女鞋2017秋季SUEDE');
INSERT INTO `by_sku` VALUES ('285', '蓝色、xl', '184', '38.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '32', '0', '0', '0.00', '100.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('286', '蓝色、xxl', '184', '12.00', '342.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '23', '0', '0', '0.00', '148.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('287', '白色、xl', '184', '5.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '324', '0', '0', '0.00', '156.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('288', '白色、xxl', '184', '20.00', '343.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '32324', '0', '0', '0.00', '154.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('289', '红色、x', '185', '6.00', '124.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '567', '0', '0', '0.00', '111.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织');
INSERT INTO `by_sku` VALUES ('290', '红色、xl', '185', '33.00', '235.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '567', '0', '0', '0.00', '147.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织');
INSERT INTO `by_sku` VALUES ('291', '蓝色、x', '185', '12.00', '534.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '675', '0', '0', '0.00', '197.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织');
INSERT INTO `by_sku` VALUES ('292', '蓝色、xl', '185', '42.00', '765.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '567', '337', '0', '0.00', '174.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织');
INSERT INTO `by_sku` VALUES ('293', '无', '186', '17.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '186', '', '234', '0', '0', '0.00', '127.00', '0', '', '', '正版书籍包邮 龙应台人生三书');
INSERT INTO `by_sku` VALUES ('294', '无', '187', '16.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '187', '', '234', '0', '0', '0.00', '153.00', '0', '', '', '正版现货 白夜行(精装典藏版)东野圭吾小说集');
INSERT INTO `by_sku` VALUES ('295', '无', '188', '41.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '188', '', '234', '0', '0', '0.00', '129.00', '0', '', '', '国家图书奖朱自清散文集徐志摩经典大全集');
INSERT INTO `by_sku` VALUES ('296', '无', '189', '5.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '189', '', '234', '0', '0', '0.00', '183.00', '0', '', '', '罗辑思维官方 今天故事书');
INSERT INTO `by_sku` VALUES ('297', '无', '190', '35.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '190', '', '324', '0', '0', '0.00', '113.00', '0', '', '', '【亚马逊图书】王小波文集：黄金时代+青铜时代+');
INSERT INTO `by_sku` VALUES ('298', '无', '191', '16.00', '123.00', '0000-00-00 00:00:00', '0', '1', '0', '191', '', '123', '0', '0', '0.00', '124.00', '0', '', '', '布鲁克林有棵树正版包邮(美)史密斯著');
INSERT INTO `by_sku` VALUES ('299', '无', '192', '22.00', '213.00', '0000-00-00 00:00:00', '0', '1', '0', '192', '', '123', '0', '0', '0.00', '150.00', '0', '', '', '【国家图书奖】鲁迅散文选集');
INSERT INTO `by_sku` VALUES ('300', '普装、16开', '193', '12.00', '454.00', '0000-00-00 00:00:00', '0', '1', '0', '113,116', '', '345', '0', '0', '0.00', '159.00', '0', '', '', '初等英语3-6级词汇速记手册');
INSERT INTO `by_sku` VALUES ('301', '普装、32开', '193', '38.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '113,117', '', '345', '0', '0', '0.00', '177.00', '0', '', '', '初等英语3-6级词汇速记手册');
INSERT INTO `by_sku` VALUES ('302', '精装、16开', '193', '49.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '114,116', '', '345', '0', '0', '0.00', '158.00', '0', '', '', '初等英语3-6级词汇速记手册');
INSERT INTO `by_sku` VALUES ('303', '精装、32开', '193', '18.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '114,117', '', '345', '0', '0', '0.00', '103.00', '0', '', '', '初等英语3-6级词汇速记手册');
INSERT INTO `by_sku` VALUES ('304', '无', '194', '40.00', '434.00', '0000-00-00 00:00:00', '0', '1', '0', '194', '', '324', '0', '0', '0.00', '129.00', '0', '', '', '欧神诺瓷砖 特权订金10元抵500元');
INSERT INTO `by_sku` VALUES ('305', '无', '195', '19.00', '324.00', '0000-00-00 00:00:00', '0', '1', '0', '195', '', '234', '0', '0', '0.00', '120.00', '0', '', '', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室');
INSERT INTO `by_sku` VALUES ('306', '无', '196', '45.00', '324.00', '0000-00-00 00:00:00', '0', '1', '0', '196', '', '234', '0', '0', '0.00', '127.00', '0', '', '', '百安居 699精致全包装修套餐');
INSERT INTO `by_sku` VALUES ('307', '无', '197', '39.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '197', '', '234', '0', '0', '0.00', '149.00', '0', '', '', '捷阳 电动晾衣架 遥控升降智能自动晾衣机');
INSERT INTO `by_sku` VALUES ('308', '无', '198', '8.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '198', '', '433', '0', '0', '0.00', '147.00', '0', '', '', 'TATA木门 简约静音门室内门');
INSERT INTO `by_sku` VALUES ('309', '无', '199', '42.00', '3245.00', '0000-00-00 00:00:00', '0', '1', '0', '199', '', '234', '0', '0', '0.00', '148.00', '0', '', '', '简约转角书桌实木书架书柜组合一体');
INSERT INTO `by_sku` VALUES ('310', '无', '200', '17.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '200', '', '234', '0', '0', '0.00', '141.00', '0', '', '', '厨房置物架 壁挂 304不锈钢刀架厨具');
INSERT INTO `by_sku` VALUES ('311', '无', '201', '7.00', '34554.00', '0000-00-00 00:00:00', '0', '1', '0', '201', '', '345', '0', '0', '0.00', '143.00', '0', '', '', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用');
INSERT INTO `by_sku` VALUES ('312', '无', '202', '26.00', '34554.00', '0000-00-00 00:00:00', '0', '1', '0', '202', '', '345', '0', '0', '0.00', '180.00', '0', '', '', '');
INSERT INTO `by_sku` VALUES ('313', '1kg、优惠套装1', '203', '15.00', '12.00', '0000-00-00 00:00:00', '0', '1', '0', '80,83', '', '56765', '0', '0', '0.00', '113.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒');
INSERT INTO `by_sku` VALUES ('314', '1kg、优惠套装2', '203', '14.00', '18.00', '0000-00-00 00:00:00', '0', '1', '0', '80,84', '', '567', '0', '0', '0.00', '102.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒');
INSERT INTO `by_sku` VALUES ('315', '2kg、优惠套装1', '203', '30.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '81,83', '', '567', '0', '0', '0.00', '103.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒');
INSERT INTO `by_sku` VALUES ('316', '2kg、优惠套装2', '203', '41.00', '26.00', '0000-00-00 00:00:00', '0', '1', '0', '81,84', '', '5675', '0', '0', '0.00', '127.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒');
INSERT INTO `by_sku` VALUES ('317', '无', '204', '44.00', '7213.00', '0000-00-00 00:00:00', '0', '1', '0', '204', '', '123', '0', '0', '0.00', '111.00', '0', '', '', '套餐】Apple iPad 32G银+intermail');
INSERT INTO `by_sku` VALUES ('318', '无', '205', '14.00', '2342.00', '0000-00-00 00:00:00', '0', '1', '0', '205', '', '23', '0', '0', '0.00', '120.00', '0', '', '', 'Apple iPad mini 4 7.9英寸平板电脑');
INSERT INTO `by_sku` VALUES ('319', '无', '206', '36.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '206', '', '23432', '0', '0', '0.00', '127.00', '0', '', '', '惠普（HP）ENVY 13-ad109TU笔记本电脑');
INSERT INTO `by_sku` VALUES ('320', '无', '207', '14.00', '599.00', '0000-00-00 00:00:00', '0', '1', '0', '207', '', '344', '0', '0', '0.00', '110.00', '0', '', '', '美的（Midea）M3-L253C 智能微波炉 光波烧烤');
INSERT INTO `by_sku` VALUES ('321', '无', '208', '22.00', '0.01', '0000-00-00 00:00:00', '0', '1', '0', '208', '', '234', '0', '0', '0.00', '175.00', '0', '', '', '永赢一路发一苏宁银车挂 银色');
INSERT INTO `by_sku` VALUES ('322', '无', '209', '28.00', '0.01', '0000-00-00 00:00:00', '0', '1', '0', '209', '', '234', '0', '0', '0.00', '125.00', '0', '', '', 'Xiaomi/小米 小米手机Note3 ');
INSERT INTO `by_sku` VALUES ('334', '4G、16G', '170', '24.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '0', '0', '0', '0.00', '105.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('335', '4G、32G', '170', '21.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '0', '0', '0', '0.00', '107.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('336', '4G、64G', '170', '36.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '0', '0', '0', '0.00', '194.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('337', '6G、16G', '170', '31.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '0', '0', '0', '0.00', '109.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('338', '6G、32G', '170', '27.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,88', '', '0', '0', '0', '0.00', '193.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('339', '6G、64G', '170', '48.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,89', '', '0', '0', '0', '0.00', '162.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ');
INSERT INTO `by_sku` VALUES ('340', '蓝色、x', '184', '30.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '0', '0', '0', '0.00', '116.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('341', '白色、x', '184', '8.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '0', '0', '0', '0.00', '109.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖');
INSERT INTO `by_sku` VALUES ('342', '无', '212', '40.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '212', '', '10', '0', '0', '0.00', '126.00', '0', '', '', '九阳(Joyoung) K15-F23 电水壶');
INSERT INTO `by_sku` VALUES ('343', '无', '213', '49.00', '66.00', '0000-00-00 00:00:00', '0', '1', '0', '213', '', '20', '0', '0', '0.00', '143.00', '0', '', '', '伊利 安慕希希腊风味酸牛奶原味');
INSERT INTO `by_sku` VALUES ('344', '无', '214', '25.00', '30.00', '0000-00-00 00:00:00', '0', '1', '0', '214', '', '10', '0', '0', '0.00', '129.00', '0', '', '', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶 ');
INSERT INTO `by_sku` VALUES ('345', '无', '215', '38.00', '1200.00', '0000-00-00 00:00:00', '0', '1', '0', '215', '', '60', '0', '0', '0.00', '171.00', '0', '', '', '容声（Ronshen）BCD-218D11N 218升');
INSERT INTO `by_sku` VALUES ('346', '无', '216', '49.00', '120.00', '0000-00-00 00:00:00', '0', '1', '0', '216', '', '66', '0', '0', '0.00', '180.00', '0', '', '', '水井坊 井台瓶 52度 500ml 单瓶装');
INSERT INTO `by_sku` VALUES ('347', '无', '217', '6.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '217', '', '10', '0', '0', '0.00', '104.00', '0', '', '', 'walch/威露士衣物家居消毒液 3L 消毒除菌液');
INSERT INTO `by_sku` VALUES ('348', '无', '218', '10.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '218', '', '10', '0', '0', '0.00', '100.00', '0', '', '', '安佳（Anchor）全脂纯牛奶1L*12盒整箱');
INSERT INTO `by_sku` VALUES ('349', '无', '219', '26.00', '6.00', '0000-00-00 00:00:00', '0', '1', '0', '219', '', '10', '0', '0', '0.00', '116.00', '0', '', '', 'Mixx炼奶起士味饼干500g (袋装)');
INSERT INTO `by_sku` VALUES ('350', '无', '220', '40.00', '500.00', '0000-00-00 00:00:00', '0', '1', '0', '220', '', '6', '0', '0', '0.00', '108.00', '0', '', '', '佳能(Canon) EOS 750D单反数码相机');
INSERT INTO `by_sku` VALUES ('351', '无', '221', '16.00', '5600.00', '0000-00-00 00:00:00', '0', '1', '0', '221', '', '1', '0', '0', '0.00', '139.00', '0', '', '', '华硕(ASUS)轻薄本笔记本电脑');
INSERT INTO `by_sku` VALUES ('352', '无', '222', '48.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '222', '', '1', '0', '0', '0.00', '188.00', '0', '', '', '福临门苏软香米5kg/袋 中粮出品 粳米');
INSERT INTO `by_sku` VALUES ('353', '无', '223', '22.00', '12.00', '0000-00-00 00:00:00', '0', '1', '0', '223', '', '100', '0', '0', '0.00', '180.00', '0', '', '', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶');
INSERT INTO `by_sku` VALUES ('354', '无', '224', '9.00', '0.10', '0000-00-00 00:00:00', '0', '1', '0', '224', '', '11', '0', '0', '0.00', '110.00', '0', '', '', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉');
INSERT INTO `by_sku` VALUES ('355', '3G、16G', '225', '50.00', '1999.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '10210', '0', '0', '0.00', '174.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机');
INSERT INTO `by_sku` VALUES ('356', '3G、32G', '225', '14.00', '3997.00', '0000-00-00 00:00:00', '0', '1', '0', '75,88', '', '1012321', '0', '0', '0.00', '122.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机');
INSERT INTO `by_sku` VALUES ('357', '6G、16G', '225', '15.00', '4999.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '101231', '0', '0', '0.00', '159.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机');
INSERT INTO `by_sku` VALUES ('358', '6G、32G', '225', '23.00', '5254.00', '0000-00-00 00:00:00', '0', '1', '0', '77,88', '', '1212321', '0', '0', '0.00', '113.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机');
INSERT INTO `by_sku` VALUES ('373', '无', '228', '35.00', '44.00', '0000-00-00 00:00:00', '0', '1', '0', '228', '', '44', '0', '0', '0.00', '137.00', '0', '', '', 'HLA海澜之家短袖T恤男基础款简约圆领');
INSERT INTO `by_sku` VALUES ('372', '黑、套餐1、3g', '227', '24.00', '12321.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,109', '', '10', '0', '0', '0.00', '111.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('371', '黑、套餐1、2g', '227', '17.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,102', '', '12', '0', '0', '0.00', '135.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('370', '黑、套餐1、1g', '227', '10.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,101', '', '12', '0', '0', '0.00', '156.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('369', '黑、官方标配、3g', '227', '48.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,109', '', '12', '0', '0', '0.00', '127.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('368', '黑、官方标配、2g', '227', '13.00', '1212.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,102', '', '12', '0', '0', '0.00', '199.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('367', '黑、官方标配、1g', '227', '13.00', '101231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,101', '', '6', '0', '0', '0.00', '111.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)');
INSERT INTO `by_sku` VALUES ('374', '红色、x', '229', '25.00', '23.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '22', '0', '0', '0.00', '151.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色');
INSERT INTO `by_sku` VALUES ('375', '红色、xl', '229', '34.00', '24.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '22', '0', '0', '0.00', '187.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色');
INSERT INTO `by_sku` VALUES ('376', '蓝色、x', '229', '49.00', '25.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '22', '0', '0', '0.00', '139.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色');
INSERT INTO `by_sku` VALUES ('377', '蓝色、xl', '229', '32.00', '22.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '22', '0', '0', '0.00', '195.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色');
INSERT INTO `by_sku` VALUES ('378', '无', '230', '24.00', '11.00', '0000-00-00 00:00:00', '0', '1', '0', '230', '', '11', '0', '0', '0.00', '104.00', '0', '', '', '2018年注册会计师全国统一考试辅导教材 ');
INSERT INTO `by_sku` VALUES ('379', '无', '231', '41.00', '23.00', '0000-00-00 00:00:00', '0', '1', '0', '231', '', '33', '0', '0', '0.00', '178.00', '0', '', '', '浮生六记（汪涵推荐，全译本，畅销150万册）');
INSERT INTO `by_sku` VALUES ('380', '无', '232', '47.00', '454.00', '0000-00-00 00:00:00', '0', '1', '0', '232', '', '45', '0', '0', '0.00', '145.00', '0', '', '', '汪汪队立大功儿童毛绒玩具狗狗毛绒公仔');
INSERT INTO `by_sku` VALUES ('381', '无', '233', '43.00', '6767.00', '0000-00-00 00:00:00', '0', '1', '0', '233', '', '6', '0', '0', '0.00', '165.00', '0', '', '', '一品国度 绝地求生游戏台式吃鸡电脑主机');
INSERT INTO `by_sku` VALUES ('382', '无', '234', '32.00', '169.00', '0000-00-00 00:00:00', '0', '1', '0', '234', '', '100', '0', '0', '0.00', '137.00', '0', '', '', '美国进口 健安喜（GNC）三倍浓缩鱼');
INSERT INTO `by_sku` VALUES ('383', '无', '235', '20.00', '189.00', '0000-00-00 00:00:00', '0', '1', '0', '235', '', '121', '0', '0', '0.00', '164.00', '0', '', '', '爱他美（Aptamil） 【旗舰店】德国奶粉 ');

-- ----------------------------
-- Table structure for by_slide
-- ----------------------------
DROP TABLE IF EXISTS `by_slide`;
CREATE TABLE `by_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `title` varchar(225) DEFAULT '' COMMENT '标题',
  `url` varchar(225) DEFAULT '' COMMENT '链接',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `place` tinyint(30) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `sort` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='幻灯片图片储存表';

-- ----------------------------
-- Records of by_slide
-- ----------------------------
INSERT INTO `by_slide` VALUES ('16', 'linin', 'goods/lists?id=52', '0', '0', '0', '0', '1', '207', '0', '229');
INSERT INTO `by_slide` VALUES ('17', '43534', 'goods/lists?id=52', '0', '0', '0', '0', '1', '208', '0', '232');
INSERT INTO `by_slide` VALUES ('18', '11', 'goods/detail?id=225', '0', '1', '0', '0', '1', '445', '1', '0');

-- ----------------------------
-- Table structure for by_sms
-- ----------------------------
DROP TABLE IF EXISTS `by_sms`;
CREATE TABLE `by_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `mobile` varchar(225) NOT NULL DEFAULT '' COMMENT '手机号码',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '短信内容',
  `extcode` varchar(225) NOT NULL DEFAULT '' COMMENT '扩展子号',
  `signtag` varchar(225) NOT NULL DEFAULT '' COMMENT '签名',
  `uid` varchar(225) NOT NULL DEFAULT '' COMMENT '用户id',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `tempid` varchar(255) NOT NULL DEFAULT '' COMMENT '模板编号',
  `group` tinyint(2) NOT NULL DEFAULT '0' COMMENT '分组1-验证2-通知',
  `other` tinyint(2) NOT NULL DEFAULT '0' COMMENT '备用',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态1-有效2-过期3-验证',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='短信记录表';

-- ----------------------------
-- Records of by_sms
-- ----------------------------

-- ----------------------------
-- Table structure for by_specs
-- ----------------------------
DROP TABLE IF EXISTS `by_specs`;
CREATE TABLE `by_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) CHARACTER SET utf8 NOT NULL,
  `sort` int(10) NOT NULL DEFAULT '0',
  `types_id` int(10) NOT NULL DEFAULT '0',
  `type` int(2) DEFAULT '0',
  `value` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `is_show` int(2) NOT NULL DEFAULT '1',
  `short_title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=135 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of by_specs
-- ----------------------------
INSERT INTO `by_specs` VALUES ('62', '0', '颜色', '0', '42', '0', '红色、蓝色、白色', '1', '');
INSERT INTO `by_specs` VALUES ('63', '62', '红色', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('64', '62', '蓝色', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('65', '0', '尺码', '0', '42', '0', 'x、xl、xxl', '1', '');
INSERT INTO `by_specs` VALUES ('66', '65', 'x', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('67', '65', 'xl', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('68', '65', 'xxl', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('69', '62', '白色', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('90', '0', '颜色', '0', '44', '0', '黑、白、金', '1', '');
INSERT INTO `by_specs` VALUES ('71', '70', '黑色', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('72', '70', '银色', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('73', '0', '内存', '0', '43', '0', '3G、4G、6G、8G', '1', '');
INSERT INTO `by_specs` VALUES ('75', '73', '3G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('76', '73', '4G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('77', '73', '6G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('78', '73', '8G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('79', '0', '克重', '0', '47', '0', '1kg、2kg', '1', '');
INSERT INTO `by_specs` VALUES ('80', '79', '1kg', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('81', '79', '2kg', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('82', '0', '优惠套装', '0', '47', '0', '优惠套装1、优惠套装2、优惠套装3', '1', '');
INSERT INTO `by_specs` VALUES ('83', '82', '优惠套装1', '0', '47', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('84', '82', '优惠套装2', '0', '47', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('85', '82', '优惠套装3', '0', '47', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('86', '0', '存储容量', '0', '43', '0', '16G、32G、64G', '1', '');
INSERT INTO `by_specs` VALUES ('87', '86', '16G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('88', '86', '32G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('89', '86', '64G', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('91', '90', '黑', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('92', '90', '白', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('93', '90', '金', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('94', '0', '套餐类型', '0', '44', '0', '官方标配、套餐1、套餐2', '1', '');
INSERT INTO `by_specs` VALUES ('95', '94', '官方标配', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('96', '94', '套餐1', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('97', '94', '套餐2', '0', '0', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('98', '0', '显卡容量', '0', '44', '0', '1g、2g、3g、4g、6g', '1', '');
INSERT INTO `by_specs` VALUES ('101', '98', '1g', '0', '44', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('102', '98', '2g', '0', '44', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('109', '98', '3g', '0', '44', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('106', '105', '54646', '0', '41', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('107', '105', '676', '0', '41', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('108', '105', '而', '0', '41', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('110', '98', '4g', '0', '44', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('111', '98', '6g', '0', '44', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('112', '0', '包装', '0', '46', '0', '普装、精装', '1', '');
INSERT INTO `by_specs` VALUES ('113', '112', '普装', '0', '46', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('114', '112', '精装', '0', '46', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('115', '0', '开数', '0', '46', '0', '16开、32开', '1', '');
INSERT INTO `by_specs` VALUES ('116', '115', '16开', '0', '46', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('117', '115', '32开', '0', '46', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('121', '120', '红色', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('122', '120', '白色', '0', '42', '0', '', '1', '');
INSERT INTO `by_specs` VALUES ('123', '120', '黑色', '0', '42', '0', '', '1', '');

-- ----------------------------
-- Table structure for by_sync_login
-- ----------------------------
DROP TABLE IF EXISTS `by_sync_login`;
CREATE TABLE `by_sync_login` (
  `uid` int(11) NOT NULL,
  `openid` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `access_token` varchar(255) NOT NULL,
  `refresh_token` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of by_sync_login
-- ----------------------------

-- ----------------------------
-- Table structure for by_tags
-- ----------------------------
DROP TABLE IF EXISTS `by_tags`;
CREATE TABLE `by_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(225) CHARACTER SET utf8 NOT NULL,
  `num` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of by_tags
-- ----------------------------

-- ----------------------------
-- Table structure for by_text
-- ----------------------------
DROP TABLE IF EXISTS `by_text`;
CREATE TABLE `by_text` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '内容',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信文本回复表';

-- ----------------------------
-- Records of by_text
-- ----------------------------
INSERT INTO `by_text` VALUES ('1', 'wx643f65392e6a5e8c', '', '32432', '1');

-- ----------------------------
-- Table structure for by_third_login
-- ----------------------------
DROP TABLE IF EXISTS `by_third_login`;
CREATE TABLE `by_third_login` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `openid` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `access_token` varchar(255) NOT NULL,
  `refresh_token` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `appid` varchar(225) DEFAULT NULL,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `figureurl` varchar(226) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='第三方登陆表';

-- ----------------------------
-- Records of by_third_login
-- ----------------------------

-- ----------------------------
-- Table structure for by_types
-- ----------------------------
DROP TABLE IF EXISTS `by_types`;
CREATE TABLE `by_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) CHARACTER SET utf8 NOT NULL,
  `sort` int(1) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `tags` varchar(226) CHARACTER SET utf8 DEFAULT NULL,
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `template_add` varchar(225) NOT NULL DEFAULT 'goods/add',
  `template_edit` varchar(225) NOT NULL DEFAULT 'goods/edit',
  `template_detail` varchar(225) NOT NULL DEFAULT 'goods/goods_detail',
  `template_lists` varchar(225) NOT NULL DEFAULT 'goods/goods_lists',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of by_types
-- ----------------------------
INSERT INTO `by_types` VALUES ('42', '服装', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('41', '零食', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('40', '普通商品', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('43', '手机', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('44', '笔记本', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('45', '汽车', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('46', '图书', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('47', '牛奶', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `by_types` VALUES ('48', '闪购', '0', '1', '', '0', 'goods/time', 'goods/time', 'goods/time_detail', 'goods/time_lists');
INSERT INTO `by_types` VALUES ('49', '拼团', '0', '1', '', '0', 'goods/tuan', 'goods/tuan', 'goods/tuan_detail', 'goods/tuan_lists');
INSERT INTO `by_types` VALUES ('50', '积分', '0', '1', '', '0', 'goods/score', 'goods/score', 'goods/goods_score', 'goods/score_lists');
INSERT INTO `by_types` VALUES ('51', '预约', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');

-- ----------------------------
-- Table struct