<?php
namespace plugin;
use think\facade\Hook;
use app\index\behavior\Plugin;
use think\facade\Request;
use think\facade\Config;
use think\Loader;
use think\facade\Session;
use think\facade\Cookie;
use \think\facade\Lang;
class Run extends  \think\Controller{
 // 当前插件操作
    protected $addon = null;
    protected $controller = null;
    protected $action = null;
    // 当前template
    protected $template;
    // 模板配置信息
    protected $config = [
        'type' => 'Think',
        'view_path' => '',
        'view_suffix' => 'html',
        'strip_space' => true,
	
        'view_depr' => '',
        'tpl_begin' => '{',
        'tpl_end' => '}',
        'taglib_begin' => '{',
        'taglib_end' => '}',
    ];

    public function __construct()
    {
        // 生成request对象

        // 初始化配置信息
        $this->config = Config::get('template') ?: $this->config;
        // 处理路由参数
       
        // 是否自动转换控制器和操作名
        $convert = Config::get('url_convert');
        // 格式化路由的插件位置
        $this->action =input('_a') ;
        $this->controller = input('_c') ;
       
        $this->addon=input('_p');
		$conf['prefix']='';$conf['type']='';$conf['auto_start']=true;
        if(file_exists(PLUGIN_PATH . $this->addon  ."/config/session.php"))
         {
            $conf=include( PLUGIN_PATH . $this->addon  ."/config/session.php");
        }
         if(file_exists(PLUGIN_PATH . $this->addon  ."/common.php"))
         {
            include( PLUGIN_PATH . $this->addon  ."/common.php");
        }		
        Session::init([
          'prefix'         => $conf['prefix'],
          'type'           => $conf['type'],
          'auto_start'     => $conf['auto_start'],
        ]);
		$conf['prefix']='';$conf['expire']='';$conf['path']='/';
        if(file_exists(PLUGIN_PATH . $this->addon  ."/config/cookie.php"))
         {
            $conf=include( PLUGIN_PATH . $this->addon  ."/config/cookie.php");
        }		
        Cookie::init([
          'prefix'         => $conf['prefix'],
          'expire'           => $conf['expire'],
          'path'     => $conf['path'],
        ]);
        
        $view_path = $this->config['view_path'] ?: 'view/';
        $this->view_path = $this->config['view_path'] ?: 'view/';
        
        Config::set('template.view_path', PLUGIN_PATH . $this->addon  .'/'.$view_path);

        parent::__construct();
    }

    /**
     * 加载模板输出
     * @access protected
     * @param string $template 模板文件名
     * @param array $vars 模板输出变量
     * @param array $replace 模板替换
     * @param array $config 模板参数
     * @return mixed
     */
    protected function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
        $controller = Loader::parseName($this->controller);
        if ('think' == strtolower($this->config['type']) && $controller && 0 !== strpos($template, '/')) {
            $depr = $this->config['view_depr'];
            $template = str_replace(['/', ':'], $depr, $template);
           
        }
        return parent::fetch($template, $vars, $replace, $config);
    }
/**
     * 获取插件名
     * @return string
     */
    final public function getName()
    {
       

        return $this->addon;
    }
	
function http()
{
    $http_type = ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') || (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) ? 'https://' : 'http://';
    return $http_type;
}

 public function init()
    {         //$this->addon=input('_plugin');
	          //$this->controller=input('_controller');
	           //$this->action=input('_action');
	    $this->assign( "common",INSTALL_PATH.'public/common');
		$this->assign( "img", http().input("server.HTTP_HOST").INSTALL_PATH.'plugin/'. $this->getName(). '/'.$this->view_path.'static/images');
		$this->assign( "css",INSTALL_PATH.'plugin/'. $this->getName(). '/'.$this->view_path.'static/css');
		$this->assign( "js",INSTALL_PATH.'plugin/'. $this->getName(). '/'.$this->view_path.'static/js');
		$this->assign( "root",INSTALL_PATH);
		$this->assign( "plugin",INSTALL_PATH.'plugin/'. $this->getName());
        if (!empty($this->addon) && !empty($this->controller) && !empty($this->action)) {
            $class = get_plugin_class($this->addon, 'controller', $this->controller);
			
            if (class_exists($class)) {
                $model = new $class();
                if ($model === false) {
                    abort(500, lang('addon init fail'));
                }
			
                // 调用操作
                if (!method_exists($model, $this->action)) {
                    abort(500, lang('method not exists'));
                }
                // 监听addons_init
                \Hook::listen('addons_init', $this);
                return call_user_func_array([$model, $this->action], [$_REQUEST]);
            } else {
                abort(500, lang('controller not exists'));
            }
        }
        abort(500, lang('addon cannot name or action'));
    }
   
}
