<?php
namespace app\common\command;
use think\Controller;
use think\Db;
use think\console\Command;
use think\console\Input;
use think\console\input\Argument;
use think\console\input\Option;
use think\console\Output;
class Plugin extends Command{
	  protected function configure()
    {
		 $this->setName('add')              		//定义命令的名字
        ->setDescription('This is my command')     //定义命令的描述
        ->addArgument('name')                      //增加一个名字参数
        ->addArgument('model');
        //$this->setName('create')
           // ->addArgument('name', Argument::OPTIONAL, "your name")
			//->addArgument('hook', Argument::OPTIONAL, "your name")        
           // ->setDescription('This is my command');
    }
//引入需要执行的文件
    protected function execute(Input $input, Output $output)
    {
    //调取事先写好的逻辑类--Addred中方法
	 //获取输入的参数
        $name = $input->getArgument('name');
		$model= $input->getArgument('model');
        $this->add($name,$model);
//在控制台输出
       $output->writeln("module {$model} id created ");
     
    }
        /* 增加插件 */
	public function add($name,$model){  
	    $data = array(
            'name'=>$name,
            'title'=>$model,
            'description'=>'这是一个临时描述',
            'status'=>1,
            'author'=>'无名',
            'version'=>'0.1',
			'has_config'=>'1',
			'admin'=>'0'
        );	
		$INSTALL_PATH = str_replace('\\','/',dirname($_SERVER['SCRIPT_NAME']));
        if($INSTALL_PATH==="/"){
            $INSTALL_PATH="/";		
       }else{
               $INSTALL_PATH= '/'. trim($INSTALL_PATH,'/').'/';
        }
		$PLUGIN_PATH= $_SERVER['DOCUMENT_ROOT'].$INSTALL_PATH.'plugin/';
		$PLUGIN_PATH= str_replace("application","plugin",env('app_path'));
		  $plugins_dir             = $PLUGIN_PATH;
		 
        //创建目录结构
		$space=strtolower($name);
		$model=strtolower($model); 
		
        $files          =   array();
        $prefix=config('database.prefix');
		$model=str_replace($prefix,"",$model);
		$model=ucfirst($model);	 
		 if(strpos($model,'_') !== false){ 
                    $list=explode('_', $model);
					$str0=ucfirst($list[0]);
					$str1=ucfirst($list[1]);
					$model=$str0.$str1;
            }
		 $title=$model;
		 $ROOT_PATH= str_replace("application","",env('app_path')); 
		 $file = file_get_contents($ROOT_PATH . 'install\conf\controllers.conf');
		 $file = str_replace('[MODEL]', $model, $file);
		 $file = str_replace('[model]', strtolower($model), $file); 
		 $file = str_replace('[TITLE]', $title, $file); 
		 $file = str_replace('[SPACE]', strtolower($space), $file); 	
		 file_put_contents($ROOT_PATH . 'plugin\\'.strtolower($space).'\controller\\'.$model.'.php', $file);
		 
		  $file = file_get_contents($ROOT_PATH . 'install\conf\models.conf');
		  $file = str_replace('[MODEL]', $model, $file); 
		  $file = str_replace('[TITLE]', $title, $file); 
		  $file = str_replace('[SPACE]', strtolower($space), $file); 
		    file_put_contents($ROOT_PATH . 'plugin\\'.strtolower($space).'\model\\'.$model.'.php', $file);
		 
		  $file = file_get_contents($ROOT_PATH . 'install\conf\validates.conf');
		  $file = str_replace('[MODEL]', $model, $file); 
		  $file = str_replace('[TITLE]', $title, $file); 
		  $file = str_replace('[SPACE]', strtolower($space), $file); 
		    file_put_contents($ROOT_PATH . 'plugin\\'.strtolower($space).'\validate\\'.$model.'.php', $file);
			
			$dir      =   "$plugins_dir{$data['name']}\\view\\".strtolower($model).'\\';
		    mkdir ($dir,0777,true);
			
		   $file = file_get_contents($ROOT_PATH . 'install\conf\indexs.conf');
		  $file = str_replace('[model]', strtolower($model), $file); 
		  $file = str_replace('[space]', strtolower($space), $file); 
		  file_put_contents($ROOT_PATH . 'plugin\\'.strtolower($space).'\view\\'.strtolower($model).'\index.html', $file);
		  
		  $file = file_get_contents($ROOT_PATH . 'install\conf\edit.conf');
		  file_put_contents($ROOT_PATH . 'plugin\\'.strtolower($space).'\view\\'.strtolower($model).'\edit.html', $file);
		 
	}
    
	
}
