-- MySQL dump 10.13  Distrib 5.7.28, for macos10.14 (x86_64)
--
-- Host: localhost    Database: shopxo
-- ------------------------------------------------------
-- Server version	5.7.28

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `sxo_admin`
--

DROP TABLE IF EXISTS `sxo_admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员id',
  `username` char(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `login_pwd` char(32) NOT NULL DEFAULT '' COMMENT '登录密码',
  `login_salt` char(6) NOT NULL DEFAULT '' COMMENT '登录密码配合加密字符串',
  `mobile` char(11) NOT NULL DEFAULT '' COMMENT '手机号码',
  `email` char(60) NOT NULL DEFAULT '' COMMENT '邮箱',
  `gender` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '性别（0保密，1女，2男）',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态（0正常, 1无效）',
  `login_total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `login_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `role_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '所属角色组',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_admin`
--

LOCK TABLES `sxo_admin` WRITE;
/*!40000 ALTER TABLE `sxo_admin` DISABLE KEYS */;
INSERT INTO `sxo_admin` VALUES (1,'admin','a4aabb0b3caa7a1291f79975f4fdcb5a','760971','','xxx@shopxo.net',0,0,705,1619436708,1,1481350313,1618153758),(4,'shopxo','03700501fada1cdd3d5a6393ac5c11b1','393338','','',0,0,10,1619435664,13,1580807200,1616047308);
/*!40000 ALTER TABLE `sxo_admin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_answer`
--

DROP TABLE IF EXISTS `sxo_answer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_answer` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '联系人',
  `tel` char(20) NOT NULL DEFAULT '' COMMENT '联系电话',
  `title` char(60) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text COMMENT '详细内容',
  `reply` text COMMENT '回复内容',
  `is_reply` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已回复（0否, 1是）',
  `reply_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示（0不显示, 1显示）',
  `access_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '访问次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`name`),
  KEY `is_show` (`is_show`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户留言/问答';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_answer`
--

LOCK TABLES `sxo_answer` WRITE;
/*!40000 ALTER TABLE `sxo_answer` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_answer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_app_center_nav`
--

DROP TABLE IF EXISTS `sxo_app_center_nav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_app_center_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `platform` char(30) NOT NULL DEFAULT 'pc' COMMENT '所属平台（pc PC网站, h5 H5手机网站, ios 苹果APP, android 安卓APP, alipay 支付宝小程序, weixin 微信小程序, baidu 百度小程序, toutiao 头条小程序, qq QQ小程序）',
  `event_type` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '事件类型（0 WEB页面, 1 内部页面(小程序或APP内部地址), 2 外部小程序(同一个主体下的小程序appid), 3 打开地图, 4 拨打电话）',
  `event_value` char(255) NOT NULL DEFAULT '' COMMENT '事件值',
  `images_url` char(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` char(18) NOT NULL DEFAULT '' COMMENT '描述',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `is_need_login` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否需要登录（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `platform` (`platform`),
  KEY `is_enable` (`is_enable`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='手机 - 用户中心导航';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_app_center_nav`
--

LOCK TABLES `sxo_app_center_nav` WRITE;
/*!40000 ALTER TABLE `sxo_app_center_nav` DISABLE KEYS */;
INSERT INTO `sxo_app_center_nav` VALUES (1,'weixin',1,'/pages/user-order/user-order','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','我的订单','',1,0,0,1562159178,1592661446),(2,'weixin',1,'/pages/user-faovr/user-faovr','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','我的收藏','',1,1,0,1562155833,1562157399),(3,'weixin',1,'/pages/user-address/user-address','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','我的地址','',1,1,0,1562155871,1562157408),(4,'weixin',1,'/pages/plugins/distribution/user/user','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','我的分销','分享赚取佣金',1,1,0,1562155901,1572416957),(5,'weixin',1,'/pages/plugins/membershiplevelvip/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','我的会员','',1,1,0,1562159178,1592661221),(6,'weixin',1,'/pages/plugins/wallet/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','我的钱包','',1,1,0,1562159178,1580558500),(7,'weixin',1,'/pages/plugins/coupon/user/user','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','我的卡券','',1,1,0,1562159178,1562157435),(8,'weixin',1,'/pages/user-answer-list/user-answer-list','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','我的留言','',1,1,0,1562156178,1562157435),(9,'alipay',1,'/pages/user-order/user-order','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','我的订单','',1,1,0,1562159178,1572932155),(10,'alipay',1,'/pages/user-faovr/user-faovr','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','我的收藏','',1,1,0,1562155833,1562157399),(11,'alipay',1,'/pages/user-address/user-address','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','我的地址','',1,1,0,1562155871,1562157408),(12,'alipay',1,'/pages/plugins/distribution/user/user','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','我的分销','分享赚取佣金',1,1,0,1562155901,1572416957),(13,'alipay',1,'/pages/plugins/membershiplevelvip/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','我的会员','',1,1,0,1562159178,1580558518),(14,'alipay',1,'/pages/plugins/wallet/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','我的钱包','',1,1,0,1562159178,1580558500),(15,'alipay',1,'/pages/plugins/coupon/user/user','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','我的卡券','',1,1,0,1562159178,1562157435),(16,'alipay',1,'/pages/user-answer-list/user-answer-list','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','我的留言','',1,1,0,1562156178,1562157435),(17,'toutiao',1,'/pages/user-order/user-order','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','我的订单','',1,1,0,1562159178,1572932155),(18,'toutiao',1,'/pages/user-faovr/user-faovr','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','我的收藏','',1,1,0,1562155833,1562157399),(19,'toutiao',1,'/pages/user-address/user-address','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','我的地址','',1,1,0,1562155871,1562157408),(20,'toutiao',1,'/pages/plugins/distribution/user/user','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','我的分销','分享赚取佣金',1,1,0,1562155901,1572416957),(21,'toutiao',1,'/pages/plugins/membershiplevelvip/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','我的会员','',1,1,0,1562159178,1580558518),(22,'toutiao',1,'/pages/plugins/wallet/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','我的钱包','',1,1,0,1562159178,1580558500),(23,'toutiao',1,'/pages/plugins/coupon/user/user','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','我的卡券','',1,1,0,1562159178,1562157435),(24,'toutiao',1,'/pages/user-answer-list/user-answer-list','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','我的留言','',1,1,0,1562156178,1562157435),(25,'baidu',1,'/pages/user-order/user-order','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','我的订单','',1,1,0,1562159178,1572932155),(26,'baidu',1,'/pages/user-faovr/user-faovr','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','我的收藏','',1,1,0,1562155833,1562157399),(27,'baidu',1,'/pages/user-address/user-address','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','我的地址','',1,1,0,1562155871,1562157408),(28,'baidu',1,'/pages/plugins/distribution/user/user','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','我的分销','分享赚取佣金',1,1,0,1562155901,1572416957),(29,'baidu',1,'/pages/plugins/membershiplevelvip/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','我的会员','',0,1,0,1562159178,1580558518),(30,'baidu',1,'/pages/plugins/wallet/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','我的钱包','',0,1,0,1562159178,1580558500),(31,'baidu',1,'/pages/plugins/coupon/user/user','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','我的卡券','',1,1,0,1562159178,1562157435),(32,'baidu',1,'/pages/user-answer-list/user-answer-list','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','我的留言','',1,1,0,1562156178,1562157435),(33,'qq',1,'/pages/user-order/user-order','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','我的订单','',1,1,0,1562159178,1572932155),(34,'qq',1,'/pages/user-faovr/user-faovr','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','我的收藏','',1,1,0,1562155833,1562157399),(35,'qq',1,'/pages/user-address/user-address','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','我的地址','',1,1,0,1562155871,1562157408),(36,'qq',1,'/pages/plugins/distribution/user/user','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','我的分销','分享赚取佣金',0,1,0,1562155901,1572416957),(37,'qq',1,'/pages/plugins/membershiplevelvip/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','我的会员','',0,1,0,1562159178,1580558518),(38,'qq',1,'/pages/plugins/wallet/user/user','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','我的钱包','',1,1,0,1562159178,1580558500),(39,'qq',1,'/pages/plugins/coupon/user/user','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','我的卡券','',1,1,0,1562159178,1562157435),(40,'qq',1,'/pages/user-answer-list/user-answer-list','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','我的留言','',1,1,0,1562156178,1562157435),(41,'weixin',1,'/pages/plugins/excellentbuyreturntocash/profit/profit','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','优购返现','',1,0,0,1583745264,0),(42,'weixin',1,'/pages/plugins/invoice/user/user','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','我的发票','',1,0,0,1607398368,0),(43,'alipay',1,'/pages/plugins/invoice/user/user','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','我的发票','',1,0,0,1607398368,0),(44,'baidu',1,'/pages/plugins/invoice/user/user','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','我的发票','',1,0,0,1607398368,0),(45,'toutiao',1,'/pages/plugins/invoice/user/user','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','我的发票','',1,0,0,1607398368,0),(46,'qq',1,'/pages/plugins/invoice/user/user','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','我的发票','',1,0,0,1607398368,0),(47,'weixin',1,'/pages/plugins/signin/user/user','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','我的签到','',1,0,0,1607398368,1608608501),(48,'alipay',1,'/pages/plugins/signin/user/user','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','我的签到','',1,0,0,1607398368,0),(49,'baidu',1,'/pages/plugins/signin/user/user','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','我的签到','',1,0,0,1607398368,0),(50,'toutiao',1,'/pages/plugins/signin/user/user','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','我的签到','',1,0,0,1607398368,0),(51,'qq',1,'/pages/plugins/signin/user/user','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','我的签到','',1,0,0,1607398368,0);
/*!40000 ALTER TABLE `sxo_app_center_nav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_app_home_nav`
--

DROP TABLE IF EXISTS `sxo_app_home_nav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_app_home_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `platform` char(30) NOT NULL DEFAULT 'pc' COMMENT '所属平台（pc PC网站, h5 H5手机网站, ios 苹果APP, android 安卓APP, alipay 支付宝小程序, weixin 微信小程序, baidu 百度小程序, toutiao 头条小程序, qq QQ小程序）',
  `event_type` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '事件类型（0 WEB页面, 1 内部页面(小程序或APP内部地址), 2 外部小程序(同一个主体下的小程序appid), 3 打开地图, 4 拨打电话）',
  `event_value` char(255) NOT NULL DEFAULT '' COMMENT '事件值',
  `images_url` char(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `is_need_login` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否需要登录（0否，1是）',
  `bg_color` char(30) NOT NULL DEFAULT '' COMMENT 'css背景色值',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `platform` (`platform`),
  KEY `is_enable` (`is_enable`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='手机 - 首页导航';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_app_home_nav`
--

LOCK TABLES `sxo_app_home_nav` WRITE;
/*!40000 ALTER TABLE `sxo_app_home_nav` DISABLE KEYS */;
INSERT INTO `sxo_app_home_nav` VALUES (1,'weixin',1,'/pages/goods-category/goods-category','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','分类',1,0,'#48CFAE',0,1542563498,1592659437),(2,'weixin',1,'/pages/plugins/coupon/index/index','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1542613659,1592659444),(3,'weixin',1,'/pages/user-order/user-order','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','订单',1,0,'#CC6633',0,1542613706,1572417702),(4,'weixin',1,'/pages/plugins/weixinliveplayer/index/index','/static/upload/images/app_nav/2020/04/19/1587304154495133.png','我的',1,0,'#FF00CC',0,1542613752,1587363007),(5,'h5',4,'17600000000','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','拨打电话',1,0,'#FB6E52',0,1555913238,1609165650),(6,'h5',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.626444|31.20843','/static/upload/images/app_nav/2018/11/19/2018111915473948001.png','地图测试',1,0,'#48CFAE',0,1555913479,1609165802),(7,'h5',0,'index.php?s=/index/plugins/index/pluginsname/coupon/pluginscontrol/index/pluginsaction/index.html','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1555914517,1572401676),(8,'h5',0,'index.php?s=/index/user/index.html','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','我的',1,1,'#49acfa',0,1555914623,1555914935),(9,'alipay',1,'/pages/goods-category/goods-category','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','分类',1,0,'#48CFAE',0,1542563498,1571231781),(10,'alipay',1,'/pages/plugins/coupon/index/index','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1542613659,1571231802),(11,'alipay',1,'/pages/user-order/user-order','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','订单',1,0,'#CC6633',0,1542613706,1573648088),(12,'alipay',1,'/pages/user/user','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','我的',1,0,'#49acfa',0,1542613752,1555913113),(13,'baidu',1,'/pages/goods-category/goods-category','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','分类',1,0,'#48CFAE',0,1542563498,1571231781),(14,'baidu',1,'/pages/plugins/coupon/index/index','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1542613659,1571231802),(15,'baidu',1,'/pages/user-order/user-order','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','订单',1,0,'#CC6633',0,1542613706,1563363613),(16,'baidu',1,'/pages/user/user','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','我的',1,0,'#49acfa',0,1542613752,1555913113),(17,'toutiao',1,'/pages/goods-category/goods-category','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','分类',1,0,'#48CFAE',0,1542563498,1571231781),(18,'toutiao',1,'/pages/plugins/coupon/index/index','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1542613659,1571231802),(19,'toutiao',1,'/pages/user-order/user-order','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','订单',1,0,'#CC6633',0,1542613706,1563363613),(20,'toutiao',1,'/pages/user/user','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','我的',1,0,'#49acfa',0,1542613752,1555913113),(21,'qq',1,'/pages/goods-category/goods-category','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','分类',1,0,'#48CFAE',0,1542563498,1571231781),(22,'qq',1,'/pages/plugins/coupon/index/index','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','优惠券',1,0,'#FF0066',0,1542613659,1571231802),(23,'qq',1,'/pages/user-order/user-order','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','订单',1,0,'#CC6633',0,1542613706,1563363613),(24,'qq',1,'/pages/user/user','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','我的',1,0,'#49acfa',0,1542613752,1592659845);
/*!40000 ALTER TABLE `sxo_app_home_nav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_article`
--

DROP TABLE IF EXISTS `sxo_article`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `title` char(60) NOT NULL DEFAULT '' COMMENT '标题',
  `article_category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '文章分类',
  `title_color` char(7) NOT NULL DEFAULT '' COMMENT '标题颜色',
  `jump_url` char(255) NOT NULL DEFAULT '' COMMENT '跳转url地址',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `content` longtext COMMENT '内容',
  `images` text COMMENT '图片数据（一维数组json）',
  `images_count` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '图片数量',
  `access_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '访问次数',
  `is_home_recommended` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '是否首页推荐（0否, 1是）',
  `seo_title` char(100) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` char(130) NOT NULL DEFAULT '' COMMENT 'SEO关键字',
  `seo_desc` char(230) NOT NULL DEFAULT '' COMMENT 'SEO描述',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `is_enable` (`is_enable`),
  KEY `access_count` (`access_count`),
  KEY `image_count` (`images_count`),
  KEY `article_category_id` (`article_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_article`
--

LOCK TABLES `sxo_article` WRITE;
/*!40000 ALTER TABLE `sxo_article` DISABLE KEYS */;
INSERT INTO `sxo_article` VALUES (1,'如何注册成为会员',7,'','',1,'<p>如何注册成为会员</p><p>如何注册成为会员</p><p>如何注册成为会员</p><p>如何注册成为会员</p>','[]',0,223,1,'','','',1484965691,1534228456),(3,'积分细则',7,'#FF0000','',1,'<p>积分细则</p><p>积分细则</p><p>积分细则</p><p>积分细则</p><p>积分细则</p><p>积分细则</p><p>积分细则</p>','[]',0,54,1,'','','',1484985139,1534228496),(4,'积分兑换说明',17,'','',1,'<p>积分兑换说明</p><p>积分兑换说明</p><p>积分兑换说明</p><p>积分兑换说明</p><p>积分兑换说明</p><p>积分兑换说明</p>','[]',0,46,1,'','','',1484989903,1534228520),(5,'如何搜索',7,'','',1,'<p>如何搜索</p><p>如何搜索</p><p>如何搜索</p><p>如何搜索</p><p>如何搜索</p><p>如何搜索</p><p>如何搜索</p>','[]',0,41,1,'','','',1485064767,1534228544),(6,'忘记密码',17,'','',1,'<p>忘记密码</p><p>忘记密码</p><p>忘记密码</p><p>忘记密码</p><p>忘记密码</p>','[]',0,24,1,'','','',1485073500,1534228567),(7,'如何管理店铺',10,'','',1,'<p>如何管理店铺</p><p>如何管理店铺</p><p>如何管理店铺</p><p>如何管理店铺</p><p>如何管理店铺</p><p>如何管理店铺</p>','[]',0,60,1,'','','',1487819252,1534228589),(8,'查看售出商品',10,'','',1,'<p>查看售出商品</p><p>查看售出商品</p><p>查看售出商品</p><p>查看售出商品</p><p>查看售出商品</p>','[]',0,59,1,'','','',1487819408,1534228614),(9,'如何发货',10,'#CC0066','',1,'<p>如何发货</p><p>如何发货</p><p>如何发货</p><p>如何发货</p><p>如何发货</p>','',0,44,1,'','','',1487920130,1545500851),(10,'商城商品推荐',10,'','',1,'<p>商城商品推荐</p><p>商城商品推荐</p><p>商城商品推荐</p><p>商城商品推荐</p><p>商城商品推荐</p>','[]',0,14,1,'','','',1534228650,1534228650),(11,'如何申请开店',10,'','',1,'<p>如何申请开店</p><p>如何申请开店</p><p>如何申请开店</p><p>如何申请开店</p>','[]',0,8,1,'','','',1534228676,1534228676),(12,'分期付款',16,'','',1,'<p>分期付款</p><p>分期付款</p><p>分期付款</p><p>分期付款</p><p>分期付款</p>','[]',0,36,1,'','','',1534228694,1534228694),(13,'邮局汇款',16,'','',1,'<p>邮局汇款</p><p>邮局汇款</p><p>邮局汇款</p><p>邮局汇款</p><p>邮局汇款</p>','[]',0,33,1,'','','',1534228710,1534228710),(14,'公司转账',16,'','',1,'<p>公司转账</p><p>公司转账</p><p>公司转账</p><p>公司转账</p><p>公司转账</p>','[]',0,41,1,'','','',1534228732,1534228732),(15,'如何注册支付宝',16,'','',1,'<p>如何注册支付宝</p><p>如何注册支付宝</p><p>如何注册支付宝</p><p>如何注册支付宝</p><p>如何注册支付宝</p>','[]',0,29,1,'','','',1534228748,1534228748),(16,'在线支付',16,'','',1,'<p>在线支付</p><p>在线支付</p><p>在线支付</p><p>在线支付</p><p>在线支付</p>','[]',0,37,1,'','','',1534228764,1534228764),(17,'联系卖家',17,'','',1,'<p>联系卖家</p><p>联系卖家</p><p>联系卖家</p><p>联系卖家</p><p>联系卖家</p><p>联系卖家</p>','[]',0,10,1,'','','',1534228781,1534228781),(18,'退换货政策',17,'','',1,'<p>退换货政策</p><p>退换货政策</p><p>退换货政策</p><p>退换货政策</p><p>退换货政策</p>','[]',0,5,1,'','','',1534228802,1534228802),(19,'退换货流程',17,'','',1,'<p>退换货流程</p><p>退换货流程</p><p>退换货流程</p><p>退换货流程</p><p>退换货流程</p>','[]',0,0,1,'','','',1534228850,1534228850),(20,'返修/退换货',17,'','',1,'<p>返修/退换货</p><p>返修/退换货</p><p>返修/退换货</p><p>返修/退换货</p><p>返修/退换货</p>','[]',0,4,1,'','','',1534228867,1534228867),(21,'退款申请',17,'','',1,'<p>退款申请</p><p>退款申请</p><p>退款申请</p><p>退款申请</p><p>退款申请</p>','[]',0,56,1,'','','',1534228885,1534228885),(22,'会员修改密码',18,'','',1,'<p>会员修改密码</p><p>会员修改密码</p><p>会员修改密码</p><p>会员修改密码</p>','[]',0,69,1,'','','',1534228900,1534228900),(23,'会员修改个人资料',18,'','',1,'<p>会员修改个人资料</p><p>会员修改个人资料</p><p>会员修改个人资料</p><p>会员修改个人资料</p><p>会员修改个人资料</p>','[]',0,62,1,'','','',1534228916,1534228916),(24,'商品发布',18,'','',1,'<p>商品发布</p><p>商品发布</p><p>商品发布</p><p>商品发布</p><p>商品发布</p>','[]',0,60,1,'','','',1534228931,1534228931),(25,'修改收货地址',18,'','',1,'<p>修改收货地址</p><p>修改收货地址</p><p>修改收货地址</p><p>修改收货地址</p><p>修改收货地址</p>','[]',0,55,1,'','','',1534228948,1534228948),(26,'合作及洽谈',24,'','',1,'<p>合作及洽谈</p><p>合作及洽谈</p><p>合作及洽谈</p><p>合作及洽谈</p><p>合作及洽谈</p>','[]',0,109,1,'','','',1534228968,1534228968),(27,'招聘英才',24,'','',1,'<h2>PHP工程师</h2><p>岗位描述：</p><p>1.负责项目后端系统的研发和维护工作。</p><p>2.负责跟进平台的运营监控和数据分析工作。</p><p>3.按时保质保量完成项目开发,研究新兴技术，持续优化系统架构，完善基础服务。<br/></p><p>4.思维敏捷,责任心强,能承受工作压力。</p><p><br/></p><p>任职资格：</p><p>1、本科及以上学历，计算机相关专业，3年以上相关开发工作经验。</p><p>2、精通基于LNMP的Web开发技术, 熟悉yii, yaf, ThinkPHP, zend等框架的是用及实现原理。</p><p>3、熟悉mysql、redis等应用开发，精通SQL调优和数据结构设计。</p><p>4、熟悉使用Javascript、Ajax，Html，Div+CSS，Vue等技术。</p><p>5、有大型项目开发经验，系统调优经验者优先。</p><p>6、对LNMP/LAMP架构的部署、搭建、优化、排错等方面有经验者优先。</p><p>7、事业心强，勤奋好学，有团队精神。</p><p><br/></p><h2>前端工程师</h2><p>岗位描述：</p><p>1.配合项目经理和设计师快速实现一流的前端界面，优化代码并保持良好的兼容性，改善用户体验。</p><p>2.根据业务和项目需求，进行技术创新，分析并给出最优的前台技术实现方案。</p><p>3.对前端开发的新技术有敏锐嗅觉，推进前端技术演进。</p><p>4.进行新技术调研，持续对产品前端进行维护和升级。</p><p><br/></p><p>任职资格：</p><p>1、了解Web 标准，熟悉 HTML、CSS、JavaScript 各种前端技术。</p><p>2、熟悉 HTTP 协议。</p><p>3、认真负责，积极主动，有良好的团队合作意识。</p><p>4、了解 Angularjs，前端工程化或者 Node.js 等技术有研究。</p><p>5、有Vue开发经验者优先。</p><p>6、事业心强，勤奋好学，有团队精神。</p><p><br/></p>','[]',0,176,1,'','','',1534228987,1534229359),(28,'联系我们',24,'','',1,'<p style=\"padding: 5px; margin-top: 0px; margin-bottom: 0px; clear: both; color: rgb(102, 102, 102); font-family: &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, arial, 宋体, &quot;Helvetica Neue&quot;, Helvetica, STHeiTi, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">欢迎您对我们的站点、工作、产品和服务提出自己宝贵的意见或建议。我们将给予您及时答复。同时也欢迎您到我们公司来洽商业务。</p><p style=\"padding: 5px; margin-top: 0px; margin-bottom: 0px; clear: both; color: rgb(102, 102, 102); font-family: &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, arial, 宋体, &quot;Helvetica Neue&quot;, Helvetica, STHeiTi, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/><strong style=\"font-size: 1em;\">公司名称</strong>： ShopXO</p><p style=\"padding: 5px; margin-top: 0px; margin-bottom: 0px; clear: both; color: rgb(102, 102, 102); font-family: &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, arial, 宋体, &quot;Helvetica Neue&quot;, Helvetica, STHeiTi, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong style=\"font-size: 1em;\">通信地址</strong>： 上海市浦东新区上海市浦东新区盛夏路</p><p style=\"padding: 5px; margin-top: 0px; margin-bottom: 0px; clear: both; color: rgb(102, 102, 102); font-family: &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, arial, 宋体, &quot;Helvetica Neue&quot;, Helvetica, STHeiTi, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong style=\"font-size: 1em;\">商务洽谈</strong>： 176-8888-8888</p><table class=\"am-table am-table-bordered\"><tbody><tr class=\"firstRow\"><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\"><strong>标题</strong></td><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\"><strong>价格(元)</strong></td><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\"><strong>状态</strong></td></tr><tr><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\">商品名称</td><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\"><span style=\"color: rgb(227, 108, 9);\">￥100.00</span></td><td width=\"301\" valign=\"top\" style=\"word-break: break-all;\"><span style=\"color: rgb(0, 176, 80);\">有效</span></td></tr></tbody></table><p style=\"padding: 5px; margin-top: 0px; margin-bottom: 0px; clear: both; color: rgb(102, 102, 102); font-family: &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, arial, 宋体, &quot;Helvetica Neue&quot;, Helvetica, STHeiTi, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><img src=\"/static/upload/images/article/2020/08/29/1598708276130441.jpg\" title=\"1598708276130441.jpg\" alt=\"714x350.jpg\"/></p>','[\"\\/static\\/upload\\/images\\/article\\/2020\\/08\\/29\\/1598708276130441.jpg\"]',1,214,1,'联系我们文章详情ShopXO','联系我们,ShopXO开源商城','国内领先企业级B2C开源电商系统！',1534229110,1598709804),(29,'关于ShopXO',24,'#FF0000','https://shopxo.net/',1,'<p>ShopXO位于上海市浦东新区，是专业从事生产管理信息化领域技术咨询和软件开发的高新技术企业。公司拥有多名技术人才和资深的行业解决方案专家。</p><p><br/></p><p>公司拥有一支勇于开拓、具有战略眼光和敏锐市场判断力的市场营销队伍，一批求实敬业，追求卓越的行政管理人才，一个能征善战，技术优秀，经验丰富的开发团队。公司坚持按现代企业制度和市场规律办事，在扩大经营规模的同时，注重企业经济运行质量，在自主产品研发及承接软件项目方面获得了很强的竞争力。 我公司也积极参与国内传统企业的信息化改造，引进国际化产品开发的标准，规范软件开发流程，通过提升各层面的软件开发人才的技术素质，打造国产软件精品，目前已经开发出具有自主知识产权的网络商城软件，还在积极开发基于电子商务平台高效能、高效益的管理系统。为今后进一步开拓国内市场打下坚实的基础。公司致力于构造一个开放、发展的人才平台，积极营造追求卓越、积极奉献的工作氛围，把“以人为本”的理念落实到每一项具体工作中，为那些锋芒内敛，激情无限的业界精英提供充分的发展空间，优雅自信、从容自得的工作环境，事业雄心与生活情趣两相兼顾的生活方式。并通过每个员工不断提升自我，以自己的独特价值观对工作与生活作最准确的判断，使我们每一个员工彰显出他们出色的自我品位，独有的工作个性和卓越的创新风格，让他们时刻保持振奋、不断鼓舞内心深处的梦想，永远走在时代潮流前端。公司发展趋势 励精图治，展望未来。公司把发展产业策略与发掘人才策略紧密结合，广纳社会精英，挖掘创新潜能，以人为本，凝聚人气，努力营造和谐宽松的工作氛围，为优秀人才的脱颖而出提供机遇。公司将在深入发展软件产业的同时，通过不懈的努力，来塑造大型软件公司的辉煌形象。</p>','',0,43,1,'','','',1534229221,1594132235);
/*!40000 ALTER TABLE `sxo_article` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_article_category`
--

DROP TABLE IF EXISTS `sxo_article_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_article_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `name` char(30) CHARACTER SET utf8 NOT NULL COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_article_category`
--

LOCK TABLES `sxo_article_category` WRITE;
/*!40000 ALTER TABLE `sxo_article_category` DISABLE KEYS */;
INSERT INTO `sxo_article_category` VALUES (7,0,'帮助中心',1,0,0,1545501262),(10,0,'店主之家',1,0,0,1607494981),(16,0,'支付方式',1,0,1482840545,1534228311),(17,0,'售后服务',1,0,1482840557,1605774851),(18,0,'客服中心',1,0,1482840577,1605775056),(24,0,'关于我们',1,0,1483951541,1605775135);
/*!40000 ALTER TABLE `sxo_article_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_attachment`
--

DROP TABLE IF EXISTS `sxo_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_attachment` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `title` char(160) NOT NULL DEFAULT '' COMMENT '名称',
  `original` char(160) NOT NULL DEFAULT '' COMMENT '原始名称',
  `path_type` char(80) NOT NULL DEFAULT '' COMMENT '路径标记',
  `size` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '大小（单位kb）',
  `ext` char(30) NOT NULL DEFAULT '' COMMENT '类型（后缀名）',
  `type` char(30) NOT NULL DEFAULT '' COMMENT '类型（file文件, image图片, scrawl涂鸦, video视频, remote远程抓取文件）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT 'url路径',
  `hash` text COMMENT 'hash值',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `path_type` (`path_type`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=619 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='附件';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_attachment`
--

LOCK TABLES `sxo_attachment` WRITE;
/*!40000 ALTER TABLE `sxo_attachment` DISABLE KEYS */;
INSERT INTO `sxo_attachment` VALUES (1,'1547458876723311.mp4','1547458876723311.mp4','goods',5212749,'.mp4','video','/static/upload/video/goods/2019/01/14/1547458876723311.mp4','7a926ee38e8c53b128b6ea9559ae0af95324dbbb4e8b8bff55c8020b72a8261e',1561538565),(2,'2018111915461980516.png','2018111915461980516.png','app_nav',730,'.png','image','/static/upload/images/app_nav/2018/11/19/2018111915461980516.png','7b7c3e3b0dcad495d0929f3c7b868aa08e753d7ed32e69c680479a31b8530ac4',1561538565),(3,'2018111915473948001.png','2018111915473948001.png','app_nav',894,'.png','image','/static/upload/images/app_nav/2018/11/19/2018111915473948001.png','bb122d0a92cc8472561ded9febb86704777541b0cc5f2582a2a78b51fb9c96f4',1561538565),(4,'2018111915482687655.png','2018111915482687655.png','app_nav',1430,'.png','image','/static/upload/images/app_nav/2018/11/19/2018111915482687655.png','6ff6f72142d89359a57d63c7684e40f06f4a76f71648a745b8c9607b0b04e486',1561538565),(5,'2018111915491258361.png','2018111915491258361.png','app_nav',879,'.png','image','/static/upload/images/app_nav/2018/11/19/2018111915491258361.png','d76f8244968847868b66cd055f03a29afc3476e5385cef6b27351df7f54f98de',1561538565),(6,'1551064260180298.jpeg','1551064260180298.jpeg','brand',2393,'.jpeg','image','/static/upload/images/brand/2019/02/25/1551064260180298.jpeg','858f2f5aa01d2cecdc907b93a99765b8dccc6a8d1015a0ab048ad2a46c96e65e',1561538565),(7,'1551064277207182.jpeg','1551064277207182.jpeg','brand',3063,'.jpeg','image','/static/upload/images/brand/2019/02/25/1551064277207182.jpeg','b1a4f186af72f1a2bb6cb425c5eff59c10fe11289a91944f016b0156021e55e6',1561538565),(8,'1547448705165706.png','1547448705165706.png','common',8725,'.png','image','/static/upload/images/common/2019/01/14/1547448705165706.png','3e4a6cf6ea3ed26836a59275cdbe58d441109717dd9b961bd912cbc5f336c556',1561538565),(9,'1547448728921121.jpg','1547448728921121.jpg','common',43556,'.jpg','image','/static/upload/images/common/2019/01/14/1547448728921121.jpg','829a7f9988db882fbd643ffdbd9a646e169b31f89641b3d4904338758016c2b4',1561538565),(10,'1547448748316693.png','1547448748316693.png','common',21102,'.png','image','/static/upload/images/common/2019/01/14/1547448748316693.png','2db8ea9424e63d4a2affcd0ac52f8f0e89c417f5725833a97d5afd534809d9b4',1561538565),(11,'1554805439263794.jpeg','1554805439263794.jpeg','common',19885,'.jpeg','image','/static/upload/images/common/2019/04/09/1554805439263794.jpeg','f4b731035bac0627508caa101e1f537d25592c5201455647d2f1d1c5b7c3e3c4',1561538565),(12,'1558025141249118.png','1558025141249118.png','common',146965,'.png','image','/static/upload/images/common/2019/05/17/1558025141249118.png','316b56dec84b3c8dcc01b7672c6dad6eff88a518495f6cf81ccf45e58306bf58',1561538565),(13,'1558062481107570.jpg','1558062481107570.jpg','common',67729,'.jpg','image','/static/upload/images/common/2019/05/17/1558062481107570.jpg','66feea05a2fb10cb5983f4df2deeec6a35b5453876c14b7fabe62dbb3528d93c',1561538565),(14,'1558072588843696.jpg','1558072588843696.jpg','common',61648,'.jpg','image','/static/upload/images/common/2019/05/17/1558072588843696.jpg','18739da62d47b0062eef55bff5464809ac18bbcf500c18e5e130661ff40ad223',1561538565),(15,'1558073623385520.jpg','1558073623385520.jpg','common',83272,'.jpg','image','/static/upload/images/common/2019/05/17/1558073623385520.jpg','49acf5646f5ea6d7daf439fbea4cc9421d2d40f5979203a554e36a1da462ce7f',1561538565),(16,'1558073623641199.jpg','1558073623641199.jpg','common',76591,'.jpg','image','/static/upload/images/common/2019/05/17/1558073623641199.jpg','ffdf93c767c65745d2e0cd1694548f689f6f0b9108c5b6d19f499f2bbe7e6417',1561538565),(17,'1533779966550231.jpeg','1533779966550231.jpeg','customview',23584,'.jpeg','image','/static/upload/images/customview/image/2018/08/09/1533779966550231.jpeg','2aa35a2f5037edba292bee25bc693c30422e969a13ce9d2228224efa7cfc9175',1561538565),(18,'20180917104528_logo.png','20180917104528_logo.png','express',1769,'.png','image','/static/upload/images/express/images/20180917104528_logo.png','c3d6d1a36d5f330f94c6135621ccb6d6f9b88ccb5f051aa3b6afc8142e3675b2',1561538565),(19,'20180917104538_logo.png','20180917104538_logo.png','express',2169,'.png','image','/static/upload/images/express/images/20180917104538_logo.png','e4ec0945e81303dd2a4da37c355e27d93bd3f1d182f3aedb8fcd806072b2351c',1561538565),(20,'20180917104550_logo.png','20180917104550_logo.png','express',3658,'.png','image','/static/upload/images/express/images/20180917104550_logo.png','6fa6d28c69cf0a9c6d9c1534746927b2e0d9e474bdcf3f3c1abca90e3cb36972',1561538565),(21,'20180917104559_logo.png','20180917104559_logo.png','express',2250,'.png','image','/static/upload/images/express/images/20180917104559_logo.png','d3c077bfe057759182dc820f537a1e119141de61eaf8d2f3caa3830d18868278',1561538565),(22,'20180917104616_logo.png','20180917104616_logo.png','express',2880,'.png','image','/static/upload/images/express/images/20180917104616_logo.png','cfa30c53c4f756c48867c0259832ac614aa2f7185c222c4aafc30501c3e6fd1c',1561538565),(23,'20180917104631_logo.png','20180917104631_logo.png','express',2570,'.png','image','/static/upload/images/express/images/20180917104631_logo.png','a19bdf1d82804272e70a4203327fc8be94ca95b057e4f08cae0a595629c12164',1561538565),(24,'20180917104650_logo.png','20180917104650_logo.png','express',2919,'.png','image','/static/upload/images/express/images/20180917104650_logo.png','3ffdacaef8dd508ea1f6638a31fe5cd29312797560bd10fea189bb762255fcb2',1561538565),(25,'20180917104707_logo.png','20180917104707_logo.png','express',1933,'.png','image','/static/upload/images/express/images/20180917104707_logo.png','af8093064a780329b3e40e07de199910cd7faa956534b5a897f0bf59b94f4db2',1561538565),(26,'20180917104722_logo.png','20180917104722_logo.png','express',1355,'.png','image','/static/upload/images/express/images/20180917104722_logo.png','577a12272983bf1d3a951466f9cd431da8f97f0663d668ac5976e15cf0d06130',1561538565),(27,'20180917104750_logo.png','20180917104750_logo.png','express',2232,'.png','image','/static/upload/images/express/images/20180917104750_logo.png','1f5ed908b5d8b906886503929c0fa718cc963e5ffa90a4efefa5942c5d208f32',1561538565),(28,'20180917104757_logo.png','20180917104757_logo.png','express',1459,'.png','image','/static/upload/images/express/images/20180917104757_logo.png','c6379303232e7a785aa5d936235e1332d9f855dc96bf7e4c5fd7303f383a91fe',1561538565),(29,'20180917104816_logo.png','20180917104816_logo.png','express',3380,'.png','image','/static/upload/images/express/images/20180917104816_logo.png','6eed95dfa6bfa4c5df63674377375f87461c7b89a6e20de6485d4eb810990905',1561538565),(30,'20180917104839_logo.png','20180917104839_logo.png','express',2881,'.png','image','/static/upload/images/express/images/20180917104839_logo.png','73819350d051a9b0954f46e4d110f5a4f071a34d7c3e3a90117e8e233b756cee',1561538565),(31,'20180917104848_logo.png','20180917104848_logo.png','express',1582,'.png','image','/static/upload/images/express/images/20180917104848_logo.png','f937af6d4fbba40a4ec0ac51ec43573cb8271da6e708f71fa3d4fd6de9b0d82e',1561538565),(32,'1547450781101144.jpg','1547450781101144.jpg','goods',14901,'.jpg','image','/static/upload/images/goods/2019/01/14/1547450781101144.jpg','548014a470048f943087ba0ddaae7945a2f2903e011403e4dc6c3d95f11f0bb3',1561538565),(33,'1547450818141662.jpg','1547450818141662.jpg','goods',5155,'.jpg','image','/static/upload/images/goods/2019/01/14/1547450818141662.jpg','e3fe682515a38f482e400270c6836ab22d79e0f82bf786653635b7120e635c62',1561538565),(34,'1547450880620837.png','1547450880620837.png','goods',144191,'.png','image','/static/upload/images/goods/2019/01/14/1547450880620837.png','79700495a967766808095ddbdf6f708d952ee203b62281846cc8a5a079abaf14',1561538565),(35,'1547450880750687.png','1547450880750687.png','goods',118286,'.png','image','/static/upload/images/goods/2019/01/14/1547450880750687.png','903a054e636a21234954fdfb8a1bb0e9288e1bc9c214a621fc1742e4c8628738',1561538565),(36,'1547450880917418.png','1547450880917418.png','goods',132895,'.png','image','/static/upload/images/goods/2019/01/14/1547450880917418.png','53f9fc26b0aaf49e5315d12d0d0307b683a48075e32c36f2d62e313e8e02507b',1561538565),(37,'1547451274847894.jpg','1547451274847894.jpg','goods',18956,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451274847894.jpg','e097db5e1506246fb9b984ec8b8b97d71bc8a5c205f5f06b0012bd1348f6a4a7',1561538565),(38,'1547451576558478.jpg','1547451576558478.jpg','goods',17371,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451576558478.jpg','fc11e1d41975dd8f721d272a41e909b9d5f1ce3dc6b67aa88deed0e9e2d9d2e6',1561538565),(39,'1547451595528800.jpg','1547451595528800.jpg','goods',111955,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451595528800.jpg','b5e076adebfc454c2abccab56d7d738ae959600cab37af767da0f822938b73bb',1561538565),(40,'1547451595616298.jpg','1547451595616298.jpg','goods',67610,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451595616298.jpg','96fa7081f31d372189efb4f7058747e3182e8f054f0de78bdc1051335cca292c',1561538565),(41,'1547451595700972.jpg','1547451595700972.jpg','goods',194801,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451595700972.jpg','af3f8d3a4c2ae124539a465d9026732fdad60959b37180a257b0163fe9515045',1561538565),(42,'1547451909951171.jpg','1547451909951171.jpg','goods',11112,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451909951171.jpg','b987362a8d3ac7fb38cd7f6bdc576fc89de9446e5eb149eacc2f1f6263f9fdb9',1561538565),(43,'1547451936230948.jpg','1547451936230948.jpg','goods',7128,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451936230948.jpg','37bd853c2c785734adaae00047674d33d825f56a7dfc6bbff282254d857ecb97',1561538565),(44,'1547451947383902.jpg','1547451947383902.jpg','goods',121885,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451947383902.jpg','5f3a7f8a470de35bc44f64a2fb3366fa24458f6fbe4e5dffbcfd726279f8d59f',1561538565),(45,'1547451947676180.jpg','1547451947676180.jpg','goods',84716,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451947676180.jpg','785f3b3231715489560d2a36afdb8a4a8051e301c177e13b07faec616fe533df',1561538565),(46,'1547451947686990.jpg','1547451947686990.jpg','goods',140597,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451947686990.jpg','8ea862a6b2a1fa077bec4d732cb81a64245d165ff407335b715e4c352d34d686',1561538565),(47,'1547451947791154.jpg','1547451947791154.jpg','goods',172983,'.jpg','image','/static/upload/images/goods/2019/01/14/1547451947791154.jpg','5a0f20c9318bd56c54bc5360aeacca46438e3fb23800350043f4939a7a6d0fe7',1561538565),(48,'1547452474332334.jpg','1547452474332334.jpg','goods',15870,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452474332334.jpg','e73e50f6fdf1d623f73a745487d9ef1eb336e195fb868560ba7efa2b1f3d372e',1561538565),(49,'1547452496713777.jpg','1547452496713777.jpg','goods',8334,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452496713777.jpg','55adc8631fd2b16d1a1f53040396512b1ec5e125cd7a4eed7bde260b7e590662',1561538565),(50,'1547452505184884.jpg','1547452505184884.jpg','goods',113172,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452505184884.jpg','38ec49e622520bb5aabf2176deeb3b8aa50d9e504f6fbebc9864d56017429e5b',1561538565),(51,'1547452505349986.jpg','1547452505349986.jpg','goods',169395,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452505349986.jpg','c877804c890c596aa3ba505f11d086c8d02657a8df3149933ccf057c328876d5',1561538565),(52,'1547452505568604.jpg','1547452505568604.jpg','goods',129041,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452505568604.jpg','e62a8e2e5b8edaa0525a4e26c8d46ba525ca8bc1731eda40a0d0787cb1da7c68',1561538565),(53,'1547452714324599.jpg','1547452714324599.jpg','goods',12257,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452714324599.jpg','ecfdc8df0fd507ea1c8a2132f96e6cd272c50fbef307ef0de78d4555ffcc6c01',1561538565),(54,'1547452752648264.jpg','1547452752648264.jpg','goods',6709,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452752648264.jpg','04aded3d43bdccb7511b9e191078a438d4c814017fc899b11a0b138ea3d572ce',1561538565),(55,'1547452760417982.jpg','1547452760417982.jpg','goods',174658,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452760417982.jpg','c1b69d6d2edc862eb30dd491a9174c16bf8890b677872d04e7b83a205a5ba72a',1561538565),(56,'1547452760659259.jpg','1547452760659259.jpg','goods',45372,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452760659259.jpg','4e8ef5e733558a54007a7bbead41b0ec322dc94fccb1b5b451eb4c4931d9a709',1561538565),(57,'1547452760984656.jpg','1547452760984656.jpg','goods',151927,'.jpg','image','/static/upload/images/goods/2019/01/14/1547452760984656.jpg','e09e88888925234da3a0cb68f5c1dfb5f98faa7e8c821bfd228a1d6a5f3d5804',1561538565),(58,'1547453000703308.jpg','1547453000703308.jpg','goods',13542,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453000703308.jpg','93d47b704048dffac4a2348cf1295c839dca870ff4895a41af12170e713976fd',1561538565),(59,'1547453032949003.jpg','1547453032949003.jpg','goods',25414,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453032949003.jpg','bd497615d2a034cf6b8a68484cb0ac06fe99db5788906a121c88d77f156e794e',1561538565),(60,'1547453042405182.jpg','1547453042405182.jpg','goods',55003,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453042405182.jpg','b40fcfbbd601ef3154d775228230b95d3496b563323eeb91e59898939433923e',1561538565),(61,'1547453042614480.jpg','1547453042614480.jpg','goods',68898,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453042614480.jpg','821fde779e4cf4a480d325f460ef24a4de69cb1e0bbdba3390714255fcfe00a7',1561538565),(62,'1547453042816509.jpg','1547453042816509.jpg','goods',66675,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453042816509.jpg','1fe6a552ea8a9be76860e75cfc21e65a4453eae42026eb3e45817a252c537e90',1561538565),(63,'1547453895416529.jpg','1547453895416529.jpg','goods',33365,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453895416529.jpg','e358c92060fadda7bc5752599423cb4efd714036568d9e90c8c7d2a4cfdaa624',1561538565),(64,'1547453895864876.jpg','1547453895864876.jpg','goods',32578,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453895864876.jpg','6f98f4b3c97d8f9d49a9b3fde340dcdcd1b52f6074995289f41d87650f8a9ae8',1561538565),(65,'1547453910353340.jpg','1547453910353340.jpg','goods',244831,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453910353340.jpg','3a2e801a92ec2ed54f71a7f235a94c501e623b47fe3ea2a307c173e93b4b49c2',1561538565),(66,'1547453910394886.jpg','1547453910394886.jpg','goods',183330,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453910394886.jpg','2a11688dcf7d26bf5977e83838ee1d125957825f8fb9210cae83ed59d46a644b',1561538565),(67,'1547453910505349.jpg','1547453910505349.jpg','goods',290173,'.jpg','image','/static/upload/images/goods/2019/01/14/1547453910505349.jpg','ab71719764253af77474aacae2a56120d92ffa109b16b5d94664b728abd12129',1561538565),(68,'1547454145355962.jpg','1547454145355962.jpg','goods',16127,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454145355962.jpg','9adb321e82f4b216f4474eb773bb1c183129281e92415c137c4da0a34bdbb568',1561538565),(69,'1547454172213779.jpg','1547454172213779.jpg','goods',65777,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454172213779.jpg','43cb42e0ba7b9492f7ca21f9a7129eee5ffab84c66d219c4932f12c049cd3bde',1561538565),(70,'1547454192301566.jpg','1547454192301566.jpg','goods',111478,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454192301566.jpg','48118482c536e5491541e6ec229b5f67cb4d19c962d1165cad8fa1c426b93bc4',1561538565),(71,'1547454192448116.jpg','1547454192448116.jpg','goods',145509,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454192448116.jpg','63ae4245e94a23482ca92ca2679d775dcadf007dae19d4a74795e47c1f9dd34f',1561538565),(72,'1547454192474638.jpg','1547454192474638.jpg','goods',123242,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454192474638.jpg','24dd26d031c679910a01c9057979f5d9e3815179344308d7250c00aa7b6b5858',1561538565),(73,'1547454567172116.jpg','1547454567172116.jpg','goods',30336,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454567172116.jpg','9421fa1c61a5b70794bdfb22ae973803e62291006ffb875eb3eb724afd1e1ad4',1561538565),(74,'1547454702272215.jpg','1547454702272215.jpg','goods',52594,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454702272215.jpg','cfa2a20d625a8d20bdd01ce4a17a90d145e924969ddf51d9ddccafcbe886c67e',1561538565),(75,'1547454702543219.jpg','1547454702543219.jpg','goods',49939,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454702543219.jpg','f42a37ca673c0e4314cdf3405cee981c1c8a99e6b31ef65b791032daa0e843b2',1561538565),(76,'1547454702814719.jpg','1547454702814719.jpg','goods',36336,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454702814719.jpg','23ba085ed7e3ce9c15bb457a44a68d3cc27d607037933174f0456a9303c4f1e0',1561538565),(77,'1547454712270511.jpg','1547454712270511.jpg','goods',204762,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454712270511.jpg','8d1478eec21e62a6ad0fac2c7068396f9324689de5b461b781cdc692dc430147',1561538565),(78,'1547454713456602.jpg','1547454713456602.jpg','goods',182430,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454713456602.jpg','3552d483918fa4161ed2245d50dadbcf302f49846e57cbc36d07e9dba3e907f1',1561538565),(79,'1547454713556301.jpg','1547454713556301.jpg','goods',282930,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454713556301.jpg','4ff8fe8a136a4fd2473847203326358de4ae3facc9670c608985c9d112bad639',1561538565),(80,'1547454713800333.jpg','1547454713800333.jpg','goods',153996,'.jpg','image','/static/upload/images/goods/2019/01/14/1547454713800333.jpg','5cab81d88d323d066fecb8adf2595edacc4ac56f5c0915cd94077004364ab6a0',1561538565),(81,'1547455222990904.jpg','1547455222990904.jpg','goods',60408,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455222990904.jpg','13e0b105048d1ea9190036270bafc72ca8993c3dfb6202fb1b51eba48d1143fb',1561538565),(82,'1547455240700820.jpg','1547455240700820.jpg','goods',57485,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455240700820.jpg','2ac111110be169cb2bb0624fc27f0d5fe6e776ecc20f9de18e3960434fc51627',1561538565),(83,'1547455240794230.jpg','1547455240794230.jpg','goods',33401,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455240794230.jpg','796fca8f28c0b5719c9ef514fd66eed2887f4280111c4c7e385c40b4d9eafb78',1561538565),(84,'1547455266234658.jpg','1547455266234658.jpg','goods',87445,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455266234658.jpg','19071cf0dd8cbbcd75f0be15085d842b319962eb0f5831cd120e8358834ff9f8',1561538565),(85,'1547455266527628.jpg','1547455266527628.jpg','goods',172989,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455266527628.jpg','06c6d4d7ede7059a0ab56f6e25df1488cfad994a5238ead93faed78645ef8dfc',1561538565),(86,'1547455566118614.jpg','1547455566118614.jpg','goods',34569,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455566118614.jpg','df56e92c8bf8d32ea469ac71716513e1e6f9354ee97e899bbda92e2fb7d401a5',1561538565),(87,'1547455601168384.jpg','1547455601168384.jpg','goods',102302,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455601168384.jpg','7b4a3af87e91c5dd1e49c0bc47c713aec8f48576959d8440907c26ff63aaf63d',1561538565),(88,'1547455601314107.jpg','1547455601314107.jpg','goods',27581,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455601314107.jpg','4ae84136adc0536c1bff8bd79d8f8377a60721928885695140ec6e8f0c8eea37',1561538565),(89,'1547455601528614.jpg','1547455601528614.jpg','goods',188533,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455601528614.jpg','44f734923517749cc0f96e335f7b8e5ffb5fa1a03f091b1f7db342095fc2fb4c',1561538565),(90,'1547455601898622.jpg','1547455601898622.jpg','goods',114878,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455601898622.jpg','99edb386546ea791e058ea984a1081bdca82a097cf5a42c1ff3c082f5fc7b674',1561538565),(91,'1547455890402147.jpg','1547455890402147.jpg','goods',8748,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455890402147.jpg','6e0fa754907bd333e41056a08d0168ecf1e1125f3bf22f6baba2599de99e15fd',1561538565),(92,'1547455907256518.jpg','1547455907256518.jpg','goods',235240,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455907256518.jpg','5210b4a18457f4e8f15ddda94756098aea31703575f98d620679b065bb67874d',1561538565),(93,'1547455907486857.jpg','1547455907486857.jpg','goods',22077,'.jpg','image','/static/upload/images/goods/2019/01/14/1547455907486857.jpg','01447696b3ef51ba08d5b025a85d7f0414dd237b11a7e6b95b8f265355c46a9c',1561538565),(94,'1547456214155362.jpg','1547456214155362.jpg','goods',11118,'.jpg','image','/static/upload/images/goods/2019/01/14/1547456214155362.jpg','a402374fefab509a6569a87e47829952510fb03ba2981cb774ebd958ff2ad931',1561538565),(95,'1547456228913731.jpg','1547456228913731.jpg','goods',140415,'.jpg','image','/static/upload/images/goods/2019/01/14/1547456228913731.jpg','7ef00d40d8ecfd4cd3bbd8ec16699785ca9d050bae58a11022d1761fd866c095',1561538565),(96,'1547540603500383.jpg','1547540603500383.jpg','goods',27527,'.jpg','image','/static/upload/images/goods/2019/01/15/1547540603500383.jpg','4898d06aa026c0453395e6ff624ed2a7b79c83124f21ca10b7ac6d21af12b4e7',1561538565),(97,'20180814174251211789.png','20180814174251211789.png','goods_category',2209,'.png','image','/static/upload/images/goods_category/2018/08/20180814174251211789.png','c500e9507a07664224be0e51100f1577427d205a7333f64754464f2f606dba98',1561538565),(98,'20180814174311166703.png','20180814174311166703.png','goods_category',1829,'.png','image','/static/upload/images/goods_category/2018/08/20180814174311166703.png','d8328277cca096ed83237f922db7d5719df92b4e02d5f089a8add4931ba1e3ee',1561538565),(99,'20180814174638213368.png','20180814174638213368.png','goods_category',1975,'.png','image','/static/upload/images/goods_category/2018/08/20180814174638213368.png','f1fe15025d48dd62f3a76448dd313d354fc7a7d6c87ecb6059f129303af4006b',1561538565),(100,'20180814174649846358.png','20180814174649846358.png','goods_category',3622,'.png','image','/static/upload/images/goods_category/2018/08/20180814174649846358.png','e9f0af2c0fcb2a920e0c42d031b5edf3205b601a0d6ca4d3243ee028259ba280',1561538565),(101,'20180814174659916405.png','20180814174659916405.png','goods_category',3089,'.png','image','/static/upload/images/goods_category/2018/08/20180814174659916405.png','ac54e4e4bfa639f2d8350b15d9ebcee12d2aea38533c326c920f32dd5d5d408d',1561538565),(102,'20180814174708327545.png','20180814174708327545.png','goods_category',2770,'.png','image','/static/upload/images/goods_category/2018/08/20180814174708327545.png','b90c3be2223b09deb331d9e03a201e9d193dbdacb54b7bf1b144140bd393ecf3',1561538565),(103,'20180814174722490490.png','20180814174722490490.png','goods_category',2938,'.png','image','/static/upload/images/goods_category/2018/08/20180814174722490490.png','ddf5d194ff87438ccb7325235a2f392414aef8634dcadbc4e9bc14ce3b6cdd48',1561538565),(104,'20180814174732569726.png','20180814174732569726.png','goods_category',4546,'.png','image','/static/upload/images/goods_category/2018/08/20180814174732569726.png','20ba9a93d8e4a826ac62293f4103dfd170d319c973accb956e864fd7d2ddde81',1561538565),(105,'20180814174748738821.png','20180814174748738821.png','goods_category',1893,'.png','image','/static/upload/images/goods_category/2018/08/20180814174748738821.png','7c9e83c3405d040528fde44f972c3563e1c3b8c4320324d06bdf52a1a2cf97b5',1561538565),(106,'20180814174757134754.png','20180814174757134754.png','goods_category',2352,'.png','image','/static/upload/images/goods_category/2018/08/20180814174757134754.png','777bc18045a9b3937f2a91faefd3053f772b7f7d9b0512079628042c6c578ab1',1561538565),(107,'20180814180843848554.png','20180814180843848554.png','goods_category',82438,'.png','image','/static/upload/images/goods_category/2018/08/20180814180843848554.png','986a4b4c84fd1d201db31192840ec4a767bd3b8b850e900048bae0df469f12c4',1561538565),(108,'20180815182045222850.png','20180815182045222850.png','goods_category',78877,'.png','image','/static/upload/images/goods_category/2018/08/20180815182045222850.png','6ce5e3eefe7aae134405cdcaa2c7cfaf58edba778545de0254c64f5fa078ead5',1561538565),(109,'2018112015245128143.jpeg','2018112015245128143.jpeg','goods_category',31282,'.jpeg','image','/static/upload/images/goods_category/2018/11/20/2018112015245128143.jpeg','12caf7a29697c489af832d1083120cca3d7266cd3859709836c5034db0c48143',1561538565),(110,'2018112015252193663.jpeg','2018112015252193663.jpeg','goods_category',24188,'.jpeg','image','/static/upload/images/goods_category/2018/11/20/2018112015252193663.jpeg','a11205863c0246630200dc4a4170370a1e715c18c4dbdd20090e12586d78c288',1561538565),(111,'2018112015255390903.jpeg','2018112015255390903.jpeg','goods_category',28249,'.jpeg','image','/static/upload/images/goods_category/2018/11/20/2018112015255390903.jpeg','df72b0fabda2e3e957c563a375489deb7958fb449dc2b5cb41d1400ad50d6c94',1561538565),(112,'2018112015273175122.jpeg','2018112015273175122.jpeg','goods_category',15581,'.jpeg','image','/static/upload/images/goods_category/2018/11/20/2018112015273175122.jpeg','83381549505c2af2b2d5a5b16226823203a8f7fc309f4efd6c631fa56f4baed4',1561538565),(113,'2018112015441996472.jpeg','2018112015441996472.jpeg','goods_category',23870,'.jpeg','image','/static/upload/images/goods_category/2018/11/20/2018112015441996472.jpeg','9ee98d2fcdc54627346522f8ec04f95adb4f93792bea8132f2cf8574ed0bcea7',1561538565),(114,'20180810094402044087.jpeg','20180810094402044087.jpeg','slide',231768,'.jpeg','image','/static/upload/images/slide/2018/08/20180810094402044087.jpeg','52532cd66bc5249287e83c64e1e87b22e2dd079ad09a294c3e307b99d6d60c4d',1561538565),(115,'20180810095910423687.jpeg','20180810095910423687.jpeg','slide',165464,'.jpeg','image','/static/upload/images/slide/2018/08/20180810095910423687.jpeg','37767d1e538e88529e31f8903ba3be76ee4a86b83431578901e3ca81b796ebef',1561538565),(116,'20180810100811853567.jpeg','20180810100811853567.jpeg','slide',181952,'.jpeg','image','/static/upload/images/slide/2018/08/20180810100811853567.jpeg','d91794e11f3af96546b83fe495671f128daf2785f1078c37b4a522a8a6c99a7c',1561538565),(117,'20180810101045451156.jpeg','20180810101045451156.jpeg','slide',208674,'.jpeg','image','/static/upload/images/slide/2018/08/20180810101045451156.jpeg','4082eb4720e7b8a2023bde66a1392774a52ca95f73469504c9e37ff866590a39',1561538565),(118,'20180810101106984022.jpeg','20180810101106984022.jpeg','slide',98192,'.jpeg','image','/static/upload/images/slide/2018/08/20180810101106984022.jpeg','830adcae5b9bf36b6454c5e18d1db4b2b7a2e92f08cd3d280856139026f38f4d',1561538565),(119,'20180810101154662873.jpeg','20180810101154662873.jpeg','slide',126780,'.jpeg','image','/static/upload/images/slide/2018/08/20180810101154662873.jpeg','46dc694b4e529e3a2eaec3cde9f7e936ec1ca4c3b45d07dff18430f2fa8c97e3',1561538565),(120,'20180810101224227323.jpeg','20180810101224227323.jpeg','slide',99619,'.jpeg','image','/static/upload/images/slide/2018/08/20180810101224227323.jpeg','e6e19ac0ed61b97a5353cc99839504b48a3318422a8dd1ec205d00bfa74c3a9c',1561538565),(121,'20180810101305611263.jpeg','20180810101305611263.jpeg','slide',177630,'.jpeg','image','/static/upload/images/slide/2018/08/20180810101305611263.jpeg','552385fc97af0852266b7c1197a9f20d61f676fa8c7d3e248325e973974a4175',1561538565),(123,'1562157390405145.png','-收藏.png','app_center_nav',4485,'.png','image','/static/upload/images/app_center_nav/2019/07/03/1562157390405145.png','f2c623efc421e9a0a68edc118b57ec73108273677dfd469e93b77a8ca33070b8',1562157390),(124,'1562157391428293.png','问答-蓝.png','app_center_nav',2033,'.png','image','/static/upload/images/app_center_nav/2019/07/03/1562157391428293.png','e31e67a0765688899e4dcd75f446220091f766fdd65d4ba744aa38f1094ddf16',1562157391),(125,'1562157391533252.png','我的地址.png','app_center_nav',4557,'.png','image','/static/upload/images/app_center_nav/2019/07/03/1562157391533252.png','bf7baeff6f58676ae31afc579b1b904ed6f747101c84d883134789369a94db59',1562157391),(127,'1562157391517979.png','小折-分销.png','app_center_nav',3468,'.png','image','/static/upload/images/app_center_nav/2019/07/03/1562157391517979.png','2811fe5fe831b8d65b9c3741c8ea1fffbfc4b2d80810abbba27fc3b42b4c75fb',1562157391),(246,'1571231187362091.png','优惠劵.png','app_center_nav',3472,'.png','image','/static/upload/images/app_center_nav/2019/10/16/1571231187362091.png','775b2ebf349a94fddb90fd6b7f9b9bc5ed4a7099d5e676bef71c2f9aa3e03178',1571231187),(247,'1571231655606153.png','优惠劵 (1).png','app_nav',1952,'.png','image','/static/upload/images/app_nav/2019/10/16/1571231655606153.png','ff059091c4d7749f10d05905f6691ec79140474e187c64dc63b3ddbfb7bd7f8a',1571231655),(249,'1572932149956815.png','我的订单.png','app_center_nav',3097,'.png','image','/static/upload/images/app_center_nav/2019/11/05/1572932149956815.png','c671163407ddc9bcf04d7ead288aa319f16a92b0e9f486b8072d8f3213da33b5',1572932150),(299,'1580558490671574.png','钱包.png','app_center_nav',2953,'.png','image','/static/upload/images/app_center_nav/2020/02/01/1580558490671574.png','c13566205e8a1fe0472abd150f84507b45b01fc3e7cc58a6c30d1782cc642c2e',1580558490),(300,'1580558516351420.png','会员.png','app_center_nav',3002,'.png','image','/static/upload/images/app_center_nav/2020/02/01/1580558516351420.png','b04cc8fad2bd975c824e3392cc1c022051fdcfef3a41286ff145735e068cb7cc',1580558516),(470,'1587304154495133.png','直播 (1).png','app_nav',1546,'.png','image','/static/upload/images/app_nav/2020/04/19/1587304154495133.png','d791343787f2bb54e6e66d29eb4d256bec37f18b0a2ac9c9ab8246af73723304',1587304154),(510,'1598708276130441.jpg','714x350.jpg','article',83827,'.jpg','image','/static/upload/images/article/2020/08/29/1598708276130441.jpg','99ef58e5fcd2545b0e7828881a87b1beb187bc97037b71c44d9383dc899038ee',1598708276),(512,'1599806728463641.png','2018111915461980516.png','quick_nav',730,'.png','image','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','52eff07577a7e548179b431713510293e84f28a7de1730f77a6b1bdec3732813',1599806728),(514,'1599808001838784.png','2018111915482687655.png','quick_nav',1430,'.png','image','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','86a1e78258600f4bdb822c993025e38daf1bcf06552e4d48a9c93350cbf2a4d8',1599808001),(518,'1600321639662998.png','位置.png','quick_nav',3573,'.png','image','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','a64df8d480c7d0bc47dd5cc0dd59ebf4cd09e833ce80802d857f51c857b76686',1600321639),(519,'1600322667732829.png','电话.png','quick_nav',3842,'.png','image','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','a1038b6b9a2b2a1fee13d306b07f6d44a897911f5f314f1259aa9dba5090c3c7',1600322667),(595,'1607398361522502.png','发票100x100.png','app_center_nav',4645,'.png','image','/static/upload/images/app_center_nav/2020/12/08/1607398361522502.png','a3e6a81b9982d32595cef9094d71ea14ae38fff34a8e71ae535d567b635c239b',1607398361),(598,'1608608498784252.png','签到 (1).png','app_center_nav',5724,'.png','image','/static/upload/images/app_center_nav/2020/12/22/1608608498784252.png','cbf6976b0a54761334c97f0c46dc21f391bd7cf2862aaa2b1acd4c0d4116e6a8',1608608498),(617,'1618280826480265.jpg','版权.jpg','plugins_copyright',47236,'.jpg','image','/static/upload/images/plugins_copyright/2021/04/13/1618280826480265.jpg','624db3b139f67be8074126d074281237ae256bd7c5315ed2a682bc3bd4f6c8d9',1618280826),(618,'1618465039532118.jpg','1593862101704965.jpg','plugins_shop-user_shop-1',5611,'.jpg','image','/static/upload/images/plugins_shop/user_shop/1/2021/04/15/1618465039532118.jpg','d03bf56572416713d82356b9267cde607fde48ab5e882d76d1cba73473971346',1618465039);
/*!40000 ALTER TABLE `sxo_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_brand`
--

DROP TABLE IF EXISTS `sxo_brand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_brand` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `logo` char(255) NOT NULL DEFAULT '' COMMENT 'logo图标',
  `name` char(30) NOT NULL COMMENT '名称',
  `describe` char(255) NOT NULL DEFAULT '' COMMENT '描述',
  `website_url` char(255) NOT NULL DEFAULT '' COMMENT '官网地址',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '顺序',
  `seo_title` char(100) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` char(130) NOT NULL DEFAULT '' COMMENT 'SEO关键字',
  `seo_desc` char(230) NOT NULL DEFAULT '' COMMENT 'SEO描述',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='品牌';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_brand`
--

LOCK TABLES `sxo_brand` WRITE;
/*!40000 ALTER TABLE `sxo_brand` DISABLE KEYS */;
INSERT INTO `sxo_brand` VALUES (1,'/static/upload/images/brand/2019/02/25/1551064260180298.jpeg','强生','强生公司一直注重在中国的发展,强生(中国)有限公司1992年1月在上海闵行经济技术开发区注册成立,注册资本超过一亿美元,是强生公司在中国大陆设立的首家独资企业。','https://www.johnsonsbaby.com.cn/',1,0,'','','',1551064263,1610346871),(2,'/static/upload/images/brand/2019/02/25/1551064277207182.jpeg','佳洁士','佳洁士是享誉全球的口腔护理品牌,旗下有牙膏,牙刷,牙贴和漱口水等多种产品。上佳洁士官网,了解更多佳洁士产品和口腔保健的资讯。','https://www.crest.com.cn/',1,0,'','','',1551064299,1610346851),(3,'','阿迪达斯','阿迪达斯一般指adidas。adidas（阿迪达斯）创办于1949年，是德国运动用品制造商阿迪达斯AG成员公司。以其创办人阿道夫·阿迪·达斯勒（Adolf Adi Dassler）。','https://www.adidas.com.cn/',1,0,'','','',1610019864,1610351690),(7,'/static/upload/images/plugins_store/user_store/1/2021/02/09/1612864738940468.png','ShopXO官方','租房子佛挡杀佛','',1,0,'','','',1612764752,1613407547),(8,'/static/upload/images/plugins_store/user_store/1/2021/02/09/1612864738940468.png','ShopXO官方','我们专注提供专业的软件产品和技术。为合作伙伴提供安全可靠的软件产品与解决方案，共同帮助终端用户实现业务创新、快速发展。','',1,0,'','','',1616225671,0),(9,'/static/upload/images/common/2019/01/14/1547448705165706.png','ShopXO官方测试店铺','师德师风师父的师父','',1,0,'','','',1618972240,0);
/*!40000 ALTER TABLE `sxo_brand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_brand_category`
--

DROP TABLE IF EXISTS `sxo_brand_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_brand_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` char(30) CHARACTER SET utf8 NOT NULL COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='品牌分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_brand_category`
--

LOCK TABLES `sxo_brand_category` WRITE;
/*!40000 ALTER TABLE `sxo_brand_category` DISABLE KEYS */;
INSERT INTO `sxo_brand_category` VALUES (7,'母婴用品',1,0,0,1606397242),(10,'运动健康',1,0,0,1610281945),(16,'食品饮料',1,0,1482840545,1535684635),(17,'珠宝手表',1,0,1482840557,1610281948),(18,'个护化妆',1,0,1482840577,1605775417),(24,'家用电器',1,0,1483951541,1535684669),(25,'数码办公',1,0,1535684676,0),(26,'服装鞋帽',1,0,1535684688,1605775408),(27,'家居家装',1,0,1535684701,1605775405),(28,'厨房餐饮',1,0,1535684707,1535684722),(29,'汽车用品',1,0,1535684729,0),(30,'虚拟充值',1,0,1535684745,1605775402),(31,'其他',1,0,1535684797,1605775399);
/*!40000 ALTER TABLE `sxo_brand_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_brand_category_join`
--

DROP TABLE IF EXISTS `sxo_brand_category_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_brand_category_join` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `brand_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '品牌id',
  `brand_category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `brand_id` (`brand_id`),
  KEY `brand_category_id` (`brand_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='品牌分类关联';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_brand_category_join`
--

LOCK TABLES `sxo_brand_category_join` WRITE;
/*!40000 ALTER TABLE `sxo_brand_category_join` DISABLE KEYS */;
INSERT INTO `sxo_brand_category_join` VALUES (19,4,16,1598276011),(29,5,10,1598276166),(51,2,18,1610346851),(52,1,7,1610346871),(53,1,18,1610346871),(54,1,27,1610346871),(55,3,10,1610351690);
/*!40000 ALTER TABLE `sxo_brand_category_join` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_cart`
--

DROP TABLE IF EXISTS `sxo_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_cart` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned DEFAULT '0' COMMENT '用户id',
  `goods_id` int(11) unsigned DEFAULT '0' COMMENT '商品id',
  `title` char(160) NOT NULL DEFAULT '' COMMENT '标题',
  `images` char(255) NOT NULL DEFAULT '' COMMENT '封面图片',
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买数量',
  `spec` text COMMENT '规格',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`goods_id`),
  KEY `title` (`title`),
  KEY `stock` (`stock`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='购物车';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_cart`
--

LOCK TABLES `sxo_cart` WRITE;
/*!40000 ALTER TABLE `sxo_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_config`
--

DROP TABLE IF EXISTS `sxo_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '基本设置id',
  `value` text COMMENT '值',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `describe` char(255) NOT NULL DEFAULT '' COMMENT '描述',
  `error_tips` char(150) NOT NULL DEFAULT '' COMMENT '错误提示',
  `type` char(30) NOT NULL DEFAULT '' COMMENT '类型（admin后台, home前台）',
  `only_tag` char(60) NOT NULL DEFAULT '' COMMENT '唯一的标记',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `only_tag` (`only_tag`)
) ENGINE=MyISAM AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='基本配置参数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_config`
--

LOCK TABLES `sxo_config` WRITE;
/*!40000 ALTER TABLE `sxo_config` DISABLE KEYS */;
INSERT INTO `sxo_config` VALUES (15,'15','分页数量','分页显示数量','分页不能超过3位数','admin','common_page_size',1619436717),(59,'1','扣减库存规则','需扣减库存开启方可有效，默认订单支付成功','','common','common_deduction_inventory_rules',1617521790),(60,'1','是否扣减库存','建议不要随意修改，以免造成库存数据错乱，关闭不影响库存回滚','','common','common_is_deduction_inventory',1617521790),(11,'0','Excel编码','excel模块编码选择','请选择编码','admin','admin_excel_charset',1619436717),(16,'ShopXO企业级B2C电商系统提供商 - 演示站点','站点标题','浏览器标题，一般不超过80个字符','站点标题不能为空','home','home_seo_site_title',1618153712),(17,'商城系统,开源电商系统,免费电商系统,PHP电商系统,商城系统,B2C电商系统,B2B2C电商系统','站点关键字','一般不超过100个字符，多个关键字以半圆角逗号 [ , ] 隔开','站点关键字不能为空','home','home_seo_site_keywords',1618153712),(18,'ShopXO是国内领先的商城系统提供商，为企业提供php商城系统、微信商城、小程序。','站点描述','站点描述，一般不超过200个字符','站点描述不能为空','home','home_seo_site_description',1618153712),(19,'沪ICP备xxx号','ICP证书号','ICP域名备案号','','home','home_site_icp',1618153522),(20,'','底部统计代码','支持html，可用于添加流量统计代码','','home','home_statistics_code',0),(21,'1','站点状态','可暂时将站点关闭，其他人无法访问，但不影响管理员访问后台','请选择站点状态','home','home_site_state',1618153522),(22,'升级中...','关闭原因','支持html，当网站处于关闭状态时，关闭原因将显示在前台','','home','home_site_close_reason',1618153522),(23,'Asia/Shanghai','默认时区','默认 亚洲/上海 [标准时+8]','请选择默认时区','common','common_timezone',1618153522),(24,'','底部代码','支持html，可用于添加流量统计代码','','home','home_footer_info',1618153522),(28,'ShopXO','站点名称','','站点名称不能为空','home','home_site_name',1618153522),(29,'0','链接模式','非兼容模式请确保配置好伪静态规则','请选择url模式','home','home_seo_url_model',1618153712),(25,'20480000','图片最大限制','单位B [上传图片还受到服务器空间PHP配置最大上传 20M 限制]','请填写图片上传最大限制','home','home_max_limit_image',1617866089),(26,'51200000','文件最大限制','单位B [上传文件还受到服务器空间PHP配置最大上传 20M 限制]','请填写文件上传最大限制','home','home_max_limit_file',1617866089),(27,'102400000','视频最大限制','单位B [上传视频还受到服务器空间PHP配置最大上传 20M 限制]','请填写视频上传最大限制','home','home_max_limit_video',1617866089),(30,'html','伪静态后缀','链接后面的后缀别名，默认 [ html ]','小写字母，不能超过8个字符','home','home_seo_url_html_suffix',1618153712),(31,'0','用户注册开启审核','默认关闭，开启后用户注册需要审核通过方可登录','请选择用户注册开启审核','common','common_register_is_enable_audit',1614871153),(32,'/static/upload/images/common/2019/01/14/1547448748316693.png','手机端logo','支持 [jpg, png, gif]，建议220x66px','请上传手机端网站logo','home','home_site_logo_wap',1618153522),(33,'/static/upload/images/common/2019/01/14/1547448705165706.png','电脑端logo','支持 [jpg, png, gif]，建议220x60px','请上传电脑端网站logo','home','home_site_logo',1618153522),(34,'1200','页面最大宽度','页面最大宽度，单位px，0则100%','请填写页面宽度值','home','home_content_max_width',1600008688),(35,'/static/upload/images/common/2019/01/14/1547448728921121.jpg','桌面图标','建议使用png格式，建议300x300px','请上传做面图标','common','home_site_desktop_icon',1618153522),(36,'sms,email,username','注册方式','未选择、前端站点将无法注册，可选择 [ 短信, 邮箱, 用户名 ]','请选择注册方式','home','home_user_reg_type',1614871153),(37,'username,email,sms','登录方式','默认帐号密码，可选择 [ 帐号密码, 邮箱验证码, 手机验证码 ]','请选择登录方式','home','home_user_login_type',1614865609),(38,'1','获取验证码-开启图片验证码','防止短信轰炸','请选择是否开启强制图片验证码','common','common_img_verify_state',1614779408),(39,'60','获取验证码时间间隔','防止频繁获取验证码，一般在 30~120 秒之间，单位 [秒]','请填写获取验证码时间间隔','home','common_verify_interval_time',1614779408),(40,'','用户注册-短信模板ID','验证码code','请填写用户注册短信模板内容','home','home_sms_user_reg',1614864139),(41,'','短信签名','发送短信包含的签名','短信签名 3~8 个的中英文字符','common','common_sms_sign',1618153692),(42,'','短信KeyID','Access Key ID','请填写Access Key ID','common','common_sms_apikey',1618153692),(43,'','密码找回-短信模板ID','验证码code','请填写密码找回短信模板内容','home','home_sms_user_forget_pwd',1614864139),(44,'600','验证码有效时间','验证码过期时间，一般10分钟左右，单位 [秒]','请填写验证码有效时间','home','common_verify_expire_time',1614779408),(45,'','SMTP服务器','设置SMTP服务器的地址，如 smtp.163.com','请填写SMTP服务器','common','common_email_smtp_host',1616226857),(46,'','SMTP端口','设置SMTP服务器的端口，默认为 25','请填写SMTP端口号','common','common_email_smtp_port',1616226857),(47,'','发信人邮件地址','发信人邮件地址，使用SMTP协议发送的邮件地址，如 shopxo@163.com','请填写发信人邮件地址','common','common_email_smtp_account',1616226857),(48,'','SMTP身份验证用户名','如 shopxo@163.com','请填写SMTP身份验证用户名','common','common_email_smtp_name',1616226857),(49,'','SMTP身份验证密码','shopxo@163.com邮件的密码或授权码','请填写SMTP身份验证密码','common','common_email_smtp_pwd',1616226857),(50,'','发件人显示名称','如 ShopXO','','common','common_email_smtp_send_name',1616226857),(51,'','通用-短信模板ID','验证码code','请填写通用短信模板内容','common','common_sms_currency_template',1614864139),(58,'','短信KeySecret','Access Key Secret','请填写Access Key Secret','common','common_sms_apisecret',1618153692),(53,'021-88888888','商店电话','空则不显示','','common','common_customer_store_tel',1615861913),(56,'<p>通用模板，你的验证码是&nbsp;&nbsp;#code#</p>','通用-邮件模板','验证码变量标识符 [ #code# ]','','common','common_email_currency_template',1614775674),(57,'default','默认模板','前台默认模板','请选择默认模板','common','common_default_theme',1619166802),(62,'','百度地图api密钥','百度地图2.0起必须配置AK密钥','请填写百度地图api密钥','common','common_baidu_map_ak',1619436717),(63,'<p>用户注册，你的验证码是&nbsp;&nbsp;#code#</p>','用户注册-邮件模板','验证码变量标识符 [ #code# ]','','home','home_email_user_reg',1614775674),(64,'<p>密码找回，你的验证码是&nbsp;&nbsp;#code#</p>','密码找回-邮件模板','验证码变量标识符 [ #code# ]','','home','home_email_user_forget_pwd',1614775674),(65,'<p style=\"white-space: normal;\">邮箱绑定，你的验证码是&nbsp;&nbsp;#code#</p>','邮箱绑定-邮件模板','验证码变量标识符 [ #code# ]','','home','home_email_user_email_binding',1614775674),(66,'20200202','css/js版本标记','用于css/js浏览器缓存版本识别','','home','home_static_cache_version',1618153522),(67,'','手机号码绑定-短信模板ID','验证码code','请填写手机号码绑定短信模板内容','home','home_sms_user_mobile_binding',1614864139),(68,'连衣裙,帐篷,iphone,包包','搜索关键字','搜索框下热门关键字（输入回车）','请填写关键字','home','home_search_keywords',1618153567),(69,'2','搜索关键字类型','自定义需要配置以下关键字','请选择关键字类型','home','home_search_keywords_type',1618153567),(70,'0','订单预约模式','开启后用户提交订单需要管理员确认','请选择是否开启预约模式','common','common_order_is_booking',1617521790),(71,'ShopXO','名称','','请填写名称','common','common_app_mini_alipay_title',1597483646),(72,'国内领先企业级B2C开源电商系统！','描述','','请填写描述','common','common_app_mini_alipay_describe',1597483646),(73,'021-88888888','客服电话','空则不显示','请填写客服电话','common','common_app_customer_service_tel',1597483581),(74,'','AppID','小程序ID','请填写AppID','common','common_app_mini_alipay_appid',1597483646),(75,'','应用公钥','','请填写应用公钥','common','common_app_mini_alipay_rsa_public',1597483646),(180,'','密码','默认无密码','请填写密码','common','common_cache_session_redis_password',1605443205),(181,'','有效时间','默认3600秒','请填写有效时间','common','common_cache_session_redis_expire',1605443205),(182,'','前缀','默认 shopxo','请填写前缀','common','common_cache_session_redis_prefix',1605443205),(76,'','应用私钥','','请填写应用私钥','common','common_app_mini_alipay_rsa_private',1597483646),(171,'4','首页楼层商品排序类型','默认综合','请选择首页楼层商品排序类型','home','home_index_floor_goods_order_by_type',1610258181),(173,'百宝箱','快捷导航名称','默认 百宝箱','请填写快捷导航名称','home','home_navigation_main_quick_name',1618153594),(172,'0','首页楼层商品排序规则','默认降序(desc)','请选择首页楼层商品排序规则','home','home_index_floor_goods_order_by_rule',1610258181),(188,'default','默认主题','微信小程序默认主题','请选择微信小程序默认主题','common','common_app_mini_weixin_default_theme',1619166448),(174,'0','获取账户手机一键登录','默认否','请选择获取账户手机一键登录','common','common_user_is_onekey_bind_mobile',1607494842),(175,'0','启用订单批量支付','默认否','请选择获启用订单批量支付','home','home_is_enable_order_bulk_pay',1617521790),(176,'0','Session使用缓存','默认否','请选择Session使用缓存','common','common_session_is_use_cache',1605443205),(177,'0','数据使用缓存','默认否','请选择数据使用缓存','common','common_data_is_use_cache',1605443205),(178,'','连接地址','默认 127.0.0.1','请填写连接地址','common','common_cache_session_redis_host',1605443205),(179,'','端口号','默认 6379','请填写端口号','common','common_cache_session_redis_port',1605443205),(78,'0','是否启用搜索','默认否','','common','common_app_is_enable_search',1607494842),(77,'','支付宝公钥','','请填写支付宝公钥','common','common_app_mini_alipay_out_rsa_public',1597483646),(167,'','css/js静态文件cdn域名','css/js静态文件','请填写css/js静态文件cdn域名','common','common_cdn_public_host',1607494461),(168,'8','首页楼层商品数量','默认8个','请填写首页楼层商品数量','home','home_index_floor_goods_max_count',1610258181),(170,'{\"1\":\"手机,iphone,小米\",\"2\":\"包包,夏装,连衣裙,短袖\"}','首页楼层顶部右侧关键字','楼层下关键字（输入回车）','请填写首页楼层顶部右侧关键字','home','home_index_floor_top_right_keywords',1610258181),(79,'0','是否启用留言','默认否','','common','common_app_is_enable_answer',1607494842),(80,'3','商品可添加规格最大数量','建议不超过3个规格','请填写谷歌最大数','common','common_spec_add_max_number',1619436717),(81,'-','路由分隔符','建议填写 [ - ]  默认 [ - ] ，仅PATHINFO模式+短地址模式下有效','请填写路由分隔符','common','common_route_separator',1618153712),(82,'','AppID','小程序ID','请填写appid','common','common_app_mini_weixin_appid',1615738087),(83,'','AppSecret	','小程序密钥','请填写appsecret','common','common_app_mini_weixin_appsecret',1615738087),(84,'ShopXO','名称','','请填写名称','common','common_app_mini_weixin_title',1615738087),(85,'国内领先企业级B2C开源电商系统！','描述','','请填写描述','common','common_app_mini_weixin_describe',1615738087),(61,'用户中心公告文字，后台配置修改。','用户中心公告','空则不显示公告','','common','common_user_center_notice',1597483581),(8,'公告内容','商城公告','空则不显示公告','','common','common_shop_notice',1597483581),(86,'test@qq.com','商店邮箱','空则不显示','客服邮箱格式有误','common','common_customer_store_email',1615861913),(87,'/static/upload/images/common/2019/04/09/1554805439263794.jpeg','商店二维码','空则不展示','','common','common_customer_store_qrcode',1615861913),(152,'[{\"alias\":\"总部\",\"name\":\"devil\",\"tel\":\"13222333333\",\"lng\":\"121.594278\",\"lat\":\"31.207917\",\"address\":\"张江高科\",\"province\":\"9\",\"city\":\"155\",\"county\":\"1937\",\"province_name\":\"上海市\",\"city_name\":\"浦东新区\",\"county_name\":\"张江镇\",\"id\":0,\"logo\":\"\"},{\"logo\":\"\\/static\\/upload\\/images\\/common\\/2019\\/01\\/14\\/1547448728921121.jpg\",\"alias\":\"\",\"name\":\"sky\",\"tel\":\"021-88888888\",\"lng\":\"121.515632\",\"lat\":\"31.102277\",\"address\":\"浦江科技广场\",\"province\":\"9\",\"city\":\"152\",\"county\":\"1896\",\"province_name\":\"上海市\",\"city_name\":\"闵行区\",\"county_name\":\"浦江镇\",\"id\":1}]','自提点地址','','请填写自提点地址','common','common_self_extraction_address',1618153642),(88,'上海市 浦东新区','商店地址','空则不展示','','common','common_customer_store_address',1615861913),(89,'<p>用户注册协议</p><p><br/></p>','用户注册协议','最多 105000 个字符','用户注册协议最多 105000 个字符','common','common_agreement_userregister',1600052861),(90,'/static/upload/images/common/2019/05/17/1558025141249118.png','用户注册背景图片','','请上传用户注册背景图片','home','home_site_user_register_bg_images',1614871153),(91,'/static/upload/images/common/2019/05/17/1558062481107570.jpg','图片','图片1 [ 建议使用 450X350 像数 ]','','home','home_site_user_login_ad1_images',1614865609),(92,'/static/upload/images/common/2019/05/17/1558072588843696.jpg','图片','图片2 [ 建议使用 450X350 像数 ]','','home','home_site_user_login_ad2_images',1614865609),(93,'/static/upload/images/common/2019/05/17/1558073623385520.jpg','图片','图片2 [ 建议使用 450X350 像数 ]','','home','home_site_user_login_ad3_images',1614865609),(94,'https://shopxo.net/','url地址','地址1 [ 带http://或https:// ]','','home','home_site_user_login_ad1_url',1614865609),(95,'https://ask.shopxo.net/','url地址','地址2 [ 带http://或https:// ]','','home','home_site_user_login_ad2_url',1614865609),(96,'https://shopxo.net/vip.html','url地址','地址3 [ 带http://或https:// ]','','home','home_site_user_login_ad3_url',1614865609),(97,'','背景色','背景色1','','home','home_site_user_login_ad1_bg_color',1614865609),(98,'#FAFAFA','背景色','背景色2','','home','home_site_user_login_ad2_bg_color',1614865609),(99,'#FAFAFA','背景色','背景色3','','home','home_site_user_login_ad3_bg_color',1614865609),(100,'0','登录图片验证码','默认关闭，可以防止非法登录','请选择是否开启登录图片验证码','home','home_user_login_img_verify_state',1614865609),(101,'/static/upload/images/common/2019/05/17/1558072588843696.jpg','图片','图片1 [ 建议使用 450X350 像数 ]','','home','home_site_user_forgetpwd_ad1_images',1558084915),(102,'/static/upload/images/common/2019/05/17/1558073623641199.jpg','图片','图片2 [ 建议使用 450X350 像数 ]','','home','home_site_user_forgetpwd_ad2_images',1558084915),(103,'','图片','图片2 [ 建议使用 450X350 像数 ]','','home','home_site_user_forgetpwd_ad3_images',1558084915),(104,'https://shopxo.net/','url地址','地址1 [ 带http://或https:// ]','','home','home_site_user_forgetpwd_ad1_url',1558084915),(105,'','url地址','地址2 [ 带http://或https:// ]','','home','home_site_user_forgetpwd_ad2_url',1558084915),(106,'','url地址','地址3 [ 带http://或https:// ]','','home','home_site_user_forgetpwd_ad3_url',1558084915),(107,'#FAFAFA','背景色','背景色1','','home','home_site_user_forgetpwd_ad1_bg_color',1558084915),(108,'#FAFAFA','背景色','背景色2','','home','home_site_user_forgetpwd_ad2_bg_color',1558084915),(109,'','背景色','背景色3','','home','home_site_user_forgetpwd_ad3_bg_color',1558084915),(110,'0','用户注册图片验证码','默认关闭，可以防止非法注册','请选择是否开启用户注册图片验证码','home','home_user_register_img_verify_state',1614871153),(111,'','图片验证码规则','默认白底黑字，可根据需求i加大验证码识别难度','','common','common_images_verify_rules',1614779408),(112,'0','SSL方式加密','','请选择是否使用SSL方式加密','common','common_email_is_use_ssl',1616226857),(113,'活动/优惠未生效\n空包裹\n包裹丢失\n配送超时\n未按约定时间发货\n未送货上门\n物流显示签收但实际未收到货\n不喜欢/不想要','仅退款原因','可换行，一行一个','请填写仅退款原因','home','home_order_aftersale_return_only_money_reason',1570193301),(114,'7天无理由退换货\n配送超时\n未按约定时间发货\n未送货上门\n卖家发错货\n少件/漏发\n包装/商品破损/污渍\n商品信息描述不符\n使用后过敏\n已过/临近保质期\n无法溶解/结块/有异物','退货退款原因','可换行，一行一个','请填写退货退款原因','home','home_order_aftersale_return_money_goods_reason',1570193301),(115,'0','用户注册协议','默认关闭，开启后用户注册需要同意协议才可以注册','请选择是否启用用户注册协议','home','home_is_enable_userregister_agreement',1614871153),(116,'上海市 浦东新区','退货地址','用户退货货物收货地址','请填写退货地址','home','home_order_aftersale_return_goods_address',1570193301),(117,'0','使用独立手机详情','默认使用web详情','请选择使用独立手机详情','common','common_app_is_use_mobile_detail',1607494842),(118,'0','强制绑定手机','默认否','请选择是否强制绑定手机','common','common_user_is_mandatory_bind_mobile',1607494842),(121,'0','固定顶部导航','默认否','请选择是否固定顶部导航','common','common_app_is_header_nav_fixed',1607494842),(122,'0','开启在线客服','默认否','请选择是否开启在线客服','common','common_app_is_online_service',1607494842),(169,'10','首页楼层左侧二级商品分类数量','默认6个','请填写首页楼层左侧二级商品分类数量','home','home_index_floor_left_goods_category_max_count',1606316065),(163,'30','订单完成可发起售后时限','单位 天，默认30天','请填写订单完成可发起售后时限','common','home_order_aftersale_return_launch_day',1572350417),(124,'0','启用好物推荐','默认否，需重新生成小程序包（启用则需到微信小程序后台申请权限）','请选择是否启用好物推荐','common','common_app_is_good_thing',1615738087),(125,'','AppID','智能小程序ID','请填写AppID','common','common_app_mini_baidu_appid',1604069165),(126,'','AppKey','智能小程序KEY','请填写AppKey','common','common_app_mini_baidu_appkey',1604069165),(127,'','AppSecret','智能小程序密匙','请填写AppSecret','common','common_app_mini_baidu_appsecret',1604069165),(128,'ShopXO','名称','','请填写名称','common','common_app_mini_baidu_title',1604069165),(129,'国内领先企业级B2C开源电商系统！','描述','','请填写描述','common','common_app_mini_baidu_describe',1604069165),(130,'0','留言需要登录','默认否','请选择是否留言需要登录','common','common_is_login_answer',1607494461),(131,'0','启用海报分享','默认否\n','请选择是否启用海报分享\n','common','common_app_is_poster_share',1615738087),(132,'30','订单关闭脚本时长','单位 分钟，默认30分钟','请填写订单关闭脚本时长','common','common_order_close_limit_time',1607494461),(133,'21600','订单自动收货脚本时长','单位 分钟，默认21600分钟/15天','请填写订单自动收货脚本时长','common','common_order_success_limit_time',1607494461),(134,'','AppID','小程序ID','请填写AppID','common','common_app_mini_toutiao_appid',1607494933),(135,'','AppSecret','小程序Secret','请填写AppSecret','common','common_app_mini_toutiao_appsecret',1607494933),(136,'','PayMerchantID','支付商户号','请填写支付商户号','common','common_app_mini_toutiao_pay_merchant_id',1607494934),(137,'','PayAppID','支付AppID','请填写AppID','common','common_app_mini_toutiao_pay_appid',1607494934),(138,'','PaySecret','支付Secret','请填写支付Secret','common','common_app_mini_toutiao_pay_secret',1607494934),(139,'ShopXO','名称','','请填写名称','common','common_app_mini_toutiao_title',1607494934),(140,'国内领先企业级B2C开源电商系统！','描述','','请填写描述','common','common_app_mini_toutiao_describe',1607494934),(141,'京公网安备xxx号','公安备案号','如：京公网安备xxx号','请填写公安备案号','home','home_site_security_record_name',1618153522),(142,'','公安备案地址','备案展示页面的url地址','请填写公安备案地址','home','home_site_security_record_url',1618153522),(143,'','AppID','小程序ID','请填写AppID','common','common_app_mini_qq_appid',1604069175),(144,'','AppSecret','小程序Secret','请填写AppSecret','common','common_app_mini_qq_appsecret',1604069175),(145,'','AppToken','小程序Token','请填写AppToken','common','common_app_mini_qq_apptoken',1604069175),(146,'ShopXO','名称','','请填写名称','common','common_app_mini_qq_title',1604069175),(147,'国内领先企业级B2C开源电商系统！','描述','','请填写描述','common','common_app_mini_qq_describe',1604069175),(148,'0','是否启用用户中心头部小导航','默认否','请选择是否启用用户中心头部小导航','common','common_app_is_head_vice_nav',1607494842),(151,'4','站点类型','默认销售型','请选择站点类型','common','common_site_type',1618153642),(150,'','展示型操作名称','默认 立即咨询','请填写展示型操作名称','common','common_is_exhibition_mode_btn_text',1618153642),(153,'','虚拟信息标题','默认密钥信息','请填写虚拟信息标题','common','common_site_fictitious_return_title',1618153642),(154,'','提示信息','','请填写提示信息','common','common_site_fictitious_return_tips',1618153642),(155,'','在线客服-企业编码','空则不显示在线客服','请填写在线客服-企业编码','common','common_app_mini_alipay_tnt_inst_id',1597483646),(156,'','在线客服-聊天窗编码','空则不显示在线客服','请填写在线客服-聊天窗编码','common','common_app_mini_alipay_scene',1597483646),(157,'0','商品详情页展示相册','默认否','请选择是否商品详情页展示相册','common','common_is_goods_detail_show_photo',1606379334),(158,'0','手机简洁模式','默认否','请选择是否手机简洁模式','common','common_is_mobile_concise_model',1597483581),(159,'0','启用直播','默认否，需重新生成小程序包（启用则需到微信小程序后台申请权限）','请选择是否启用直播','common','common_app_weixin_liveplayer',1615738087),(160,'4.0.1','好物推荐组件版本号','','请填写好物推荐组件版本号','common','common_app_is_good_thing_ver',1615738087),(161,'1.2.10','直播组件版本号','','请填写直播组件版本号','common','common_app_weixin_liveplayer_ver',1615738087),(162,'1','后台登录页随机背景图','默认启用','请选择后台登录页随机背景图','common','admin_login_info_bg_images_rand',1619436717),(164,'30','支付日志订单关闭脚本时长','单位 分钟，默认30分钟','请填写支付日志订单关闭脚本时长','common','common_pay_log_order_close_limit_time',1607494461),(165,'3','分类展示层级','默认3级','请填写分类展示层级','common','common_show_goods_category_level',1606379334),(166,'','附件cdn域名','图片/视频/文件','请填写附件cdn域名','common','common_cdn_attachment_host',1607494461),(183,'','连接地址','默认 127.0.0.1','请填写连接地址','common','common_cache_data_redis_host',1605443205),(184,'','端口号','默认 6379','请填写端口号','common','common_cache_data_redis_port',1605443205),(185,'','密码','默认无密码','请填写密码','common','common_cache_data_redis_password',1605443205),(186,'','有效时间','默认0表示永久','请填写有效时间','common','common_cache_data_redis_expire',1605443205),(187,'','前缀','默认 shopxo','请填写前缀','common','common_cache_data_redis_prefix',1605443205),(189,'default','默认主题','支付宝小程序默认主题','请选择支付宝小程序默认主题','common','common_app_mini_alipay_default_theme',1572350417),(190,'default','默认主题','百度小程序默认主题','请选择百度小程序默认主题','common','common_app_mini_baidu_default_theme',1605944646),(191,'default','默认主题','头条小程序默认主题','请选择头条小程序默认主题','common','common_app_mini_toutiao_default_theme',1605945236),(192,'default','默认主题','QQ小程序默认主题','请选择QQ小程序默认主题','common','common_app_mini_qq_default_theme',1605947370),(193,'0','首页楼层数据模式类型','默认自动模式','请选择首页楼层数据模式类型','home','home_index_floor_data_type',1610258181),(194,'{\"1\":[\"7\",\"8\",\"3\",\"2\",\"1\",\"6\",\"5\",\"4\",\"11\",\"12\",\"10\",\"9\"]}','首页楼层商品配置','自定义添加商品','请选择首页楼层商品配置','home','home_index_floor_manual_mode_goods',1610258181),(195,'{\"1\":\"58,59,60,61,62,63\",\"2\":\"304,305,306,307,308,309\"}','首页楼层左侧二级商品分类','楼层下分类（下拉多选）','请填写首页楼层左侧二级商品分类','home','home_index_floor_left_top_category',1610258181),(196,'0','快捷导航状态','默认关闭','请选择快捷导航状态','home','home_navigation_main_quick_status',1618153594),(197,'0','用户地址地图','默认关闭','请选择用户地址地图','home','home_user_address_map_status',1618153594),(198,'0','用户地址身份证','默认关闭','请选择用户地址身份证','home','home_user_address_idcard_status',1618153594),(199,'1','首页轮播左侧商品分类','默认开启','请选择首页轮播左侧商品分类','home','home_index_banner_left_status',1610258181),(200,'1','首页轮播右侧聚合内容','默认开启','请选择首页轮播右侧聚合内容','home','home_index_banner_right_status',1610258181),(202,'20','搜索展示数据条数','默认20','请填写搜索展示数据条数','home','home_search_limit_number',1618153567),(201,'0','手机模式下友情链接状态','默认关闭','请选择手机模式下友情链接状态','home','home_index_friendship_link_status',1618153594),(203,'1','订单支付状态改变支付金额必须大于等于','默认开启','请选择订单支付状态改变支付金额必须大于等于','common','common_is_pay_price_must_max_equal',1618153594),(204,'1','搜索页开启规格','默认开启','请选择搜索页开启规格','home','home_search_is_spec',1618153567),(205,'1','搜索页开启参数','默认开启','请选择搜索页开启参数','home','home_search_is_params',1618153567),(206,'1','搜索页开启价格','默认开启','请选择搜索页开启价格','home','home_search_is_price',1618153567),(207,'1','顶部小导航非首页入口','默认开启','请选择顶部小导航非首页入口','home','home_header_top_is_home',1618153594),(208,'1','搜索页开启品牌','默认开启','请选择搜索页开启品牌','home','home_search_is_brand',1618153567),(209,'1','搜索页开启分类','默认开启','请选择搜索页开启分类','home','home_search_is_category',1618153567),(210,'username,email,sms','登录方式','默认帐号密码，可选择 [ 帐号密码, 邮箱验证码, 手机验证码 ]','请至少选择一种登录方式','admin','admin_login_type',1619436717),(211,'0','登录图片验证码','默认关闭，可以防止非法登录','请选择是否开启登录图片验证码','admin','admin_login_img_verify_state',1619436717),(212,'','后台登录-短信模板ID','验证码code','请填写后台登录短信模板内容','admin','admin_sms_login_template',1614864139),(213,'<p>后台登录模板，你的验证码是&nbsp;&nbsp;#code#</p>','后台登录-邮件模板','验证码变量标识符 [ #code# ]','','admin','admin_email_login_template',1614775674),(214,'','用户登录-短信模板ID','验证码code','请填写用户登录短信模板内容','home','home_sms_login_template',1614864139),(215,'登录模板，你的验证码是  #code#','用户登录-邮件模板','验证码变量标识符 [ #code# ]','','home','home_email_login_template',1557728601),(216,'0','自提选择地理位置','默认关闭','请选择自提选择地理位置','home','home_extraction_address_position',1618153594),(217,'0','搜索多个关键字并且关系','默认否、或关系','请选择搜索多个关键字并且关系','home','home_search_is_keywords_where_and',1618153567),(218,'0','上传图片重新绘制','默认否','请选择上传图片重新绘制','common','is_upload_images_redraw',1617866089),(219,'1','关闭商品优惠重叠','默认否','请选择关闭商品优惠重叠','common','is_close_goods_discount_overlap',1617959628),(221,'Powered by <a href=\"http://shopxo.net/\" title=\"ShopXO电商系统\" target=\"_blank\"><span class=\"b\">Shop</span><span class=\"o\">XO</span></a>','web端底部版权信息','','请填写web端底部版权信息','home','home_theme_footer_bottom_powered',1618304831),(224,'','应用商店帐号','','请填写应用商店帐号','common','common_store_accounts',1619354316),(222,'ShopXO','后端站点名称','','请填写后端站点名称','admin','admin_theme_site_name',1618304831),(223,'2','搜索参数类型','默认基础','请选择搜索参数类型','home','home_search_params_type',1618153567),(225,'','应用商店密码','','请填写应用商店密码','common','common_store_password',1619354316),(226,'0','搜索关键字包含SEO字段','默认否','请选择搜索关键字包含SEO字段','home','home_search_is_keywords_seo_fields',1572350417);
/*!40000 ALTER TABLE `sxo_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_custom_view`
--

DROP TABLE IF EXISTS `sxo_custom_view`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_custom_view` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `title` char(60) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '标题',
  `content` longtext COMMENT '内容',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `is_header` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否包含头部（0否, 1是）',
  `is_footer` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否包含尾部（0否, 1是）',
  `is_full_screen` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否满屏（0否, 1是）',
  `images` text COMMENT '图片数据（一维数组json）',
  `images_count` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '图片数量',
  `access_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '访问次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `is_enable` (`is_enable`),
  KEY `access_count` (`access_count`),
  KEY `image_count` (`images_count`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义页面';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_custom_view`
--

LOCK TABLES `sxo_custom_view` WRITE;
/*!40000 ALTER TABLE `sxo_custom_view` DISABLE KEYS */;
INSERT INTO `sxo_custom_view` VALUES (1,'测试自定义页面22沙发上冬瓜豆腐东方红甘肃光合谷 vV 币 vv 小白菜 v 吧俄国人搞活动个人风格 VC 不超过吧都是','<p><img src=\"/static/upload/images/customview/image/2018/08/09/1533779966550231.jpeg\" title=\"1533779966550231.jpeg\" alt=\"1.jpeg\"/></p><p><span style=\"color: rgb(255, 0, 0);\">ShopXO</span></p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \">秀，身材苗条！</span></p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">在欧美的排版业界中，使用 Arial 的作品意即是「不使用 Helvetica 的作品」，会被认為是设计师对字体的使用没有概念或是太容易妥协，基本上我大致也是同意。</p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \"><br/></p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">因為 Helvetica 只有 Mac 上才有內建，Windows 用戶除非花錢買，不然是沒有 Helvetica 能用，所以使用 Arial 的設計師往往被看成是不願意對 Typography 花錢，專業素養不到家的人。除了在確保網頁相容性等絕對必需的情況外，幾乎可以說是不應該使用的字體。</p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"><br/></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">在欧美的排版业界中，使用 Arial 的作品意即是「不使用 Helvetica 的作品」，会被认為是设计师对字体的使用没有概念或是太容易妥协，基本上我大致也是同意。</p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">因為 Helvetica 只有 Mac 上才有內建，Windows 用戶除非花錢買，不然是沒有 Helvetica 能用，所以使用 Arial 的設計師往往被看成是不願意對 Typography 花錢，專業素養不到家的人。除了在確保網頁相容性等絕對必需的情況外，幾乎可以說是不應該使用的字體。</p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"><br/></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">在欧美的排版业界中，使用 Arial 的作品意即是「不使用 Helvetica 的作品」，会被认為是设计师对字体的使用没有概念或是太容易妥协，基本上我大致也是同意。</p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">因為 Helvetica 只有 Mac 上才有內建，Windows 用戶除非花錢買，不然是沒有 Helvetica 能用，所以使用 Arial 的設計師往往被看成是不願意對 Typography 花錢，專業素養不到家的人。除了在確保網頁相容性等絕對必需的情況外，幾乎可以說是不應該使用的字體。</p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"><br/></span></p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"><br/></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">在欧美的排版业界中，使用 Arial 的作品意即是「不使用 Helvetica 的作品」，会被认為是设计师对字体的使用没有概念或是太容易妥协，基本上我大致也是同意。</p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">因為 Helvetica 只有 Mac 上才有內建，Windows 用戶除非花錢買，不然是沒有 Helvetica 能用，所以使用 Arial 的設計師往往被看成是不願意對 Typography 花錢，專業素養不到家的人。除了在確保網頁相容性等絕對必需的情況外，幾乎可以說是不應該使用的字體。</p><p><span style=\"color: rgb(38, 38, 38); font-family: 微软雅黑, \"><br/></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">在欧美的排版业界中，使用 Arial 的作品意即是「不使用 Helvetica 的作品」，会被认為是设计师对字体的使用没有概念或是太容易妥协，基本上我大致也是同意。</p><p style=\"box-sizing: border-box; margin-top: 1.6rem; margin-bottom: 1.6rem; color: rgb(51, 51, 51); font-family: \">因為 Helvetica 只有 Mac 上才有內建，Windows 用戶除非花錢買，不然是沒有 Helvetica 能用，所以使用 Arial 的設計師往往被看成是不願意對 Typography 花錢，專業素養不到家的人。除了在確保網頁相容性等絕對必需的情況外，幾乎可以說是不應該使用的字體。</p><p><br/></p>',1,1,1,0,'[\"/static/upload/images/customview/image/2018/08/09/1533779966550231.jpeg\",\"/static/upload/images/customview/image/2018/08/09/1533779966550231.jpeg\",\"/static/upload/images/customview/image/2018/08/09/1533779966550231.jpeg\"]',1,932,1484965691,1592300274);
/*!40000 ALTER TABLE `sxo_custom_view` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_express`
--

DROP TABLE IF EXISTS `sxo_express`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_express` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `icon` char(255) NOT NULL DEFAULT '' COMMENT 'icon图标',
  `name` char(30) NOT NULL COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='快递公司';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_express`
--

LOCK TABLES `sxo_express` WRITE;
/*!40000 ALTER TABLE `sxo_express` DISABLE KEYS */;
INSERT INTO `sxo_express` VALUES (1,0,'/static/upload/images/express/images/20180917104528_logo.png','顺丰快递',1,0,1526350443,1613626001),(2,0,'/static/upload/images/express/images/20180917104538_logo.png','圆通快递',1,0,1526350453,1613626234),(3,0,'/static/upload/images/express/images/20180917104550_logo.png','申通快递',1,0,1526350461,1583070213),(4,0,'/static/upload/images/express/images/20180917104559_logo.png','中通快递',1,0,1526350469,1537152359),(5,0,'/static/upload/images/express/images/20180917104839_logo.png','EMS速递',1,0,1530429633,1537152519),(6,0,'/static/upload/images/express/images/20180917104631_logo.png','韵达快递',1,0,1530429687,1537152391),(7,0,'/static/upload/images/express/images/20180917104848_logo.png','邮政包裹',1,0,1530429743,1537152528),(8,0,'/static/upload/images/express/images/20180917104816_logo.png','百世汇通',1,0,1530429765,1537152496),(9,0,'/static/upload/images/express/images/20180917104616_logo.png','国通快递',1,0,1530429794,1537152376),(10,0,'/static/upload/images/express/images/20180917104650_logo.png','天天快递',1,0,1530429830,1537152410),(11,0,'/static/upload/images/express/images/20180917104707_logo.png','优速快递',1,0,1530429855,1537152427),(12,0,'/static/upload/images/express/images/20180917104722_logo.png','全峰快递',1,0,1530429873,1537152442),(13,0,'/static/upload/images/express/images/20180917104750_logo.png','宅急送',1,0,1530429907,1537152470),(14,0,'/static/upload/images/express/images/20180917104757_logo.png','京东快递',1,0,1530429926,1605775704);
/*!40000 ALTER TABLE `sxo_express` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_form_table_user_fields`
--

DROP TABLE IF EXISTS `sxo_form_table_user_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_form_table_user_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '管理员id或用户id',
  `user_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '用户类型（0后台管理员, 1用户端）',
  `md5_key` char(32) NOT NULL DEFAULT '' COMMENT 'form表格数据唯一key',
  `fields` text COMMENT '字段数据（json格式存储）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_type` (`user_type`),
  KEY `md5_key` (`md5_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='动态表格用户自定义字段';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_form_table_user_fields`
--

LOCK TABLES `sxo_form_table_user_fields` WRITE;
/*!40000 ALTER TABLE `sxo_form_table_user_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_form_table_user_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods`
--

DROP TABLE IF EXISTS `sxo_goods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `brand_id` int(11) unsigned DEFAULT '0' COMMENT '品牌id',
  `site_type` tinyint(1) NOT NULL DEFAULT '-1' COMMENT '商品类型（跟随站点类型一致[0销售, 1展示, 2自提, 3虚拟销售, 4销售+自提]）',
  `title` char(160) NOT NULL DEFAULT '' COMMENT '标题',
  `title_color` char(7) NOT NULL DEFAULT '' COMMENT '标题颜色',
  `simple_desc` char(230) NOT NULL DEFAULT '' COMMENT '简述',
  `model` char(30) NOT NULL DEFAULT '' COMMENT '型号',
  `place_origin` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产地（地区省id）',
  `inventory` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存（所有规格库存总和）',
  `inventory_unit` char(15) NOT NULL DEFAULT '' COMMENT '库存单位',
  `images` char(255) NOT NULL DEFAULT '' COMMENT '封面图片',
  `original_price` char(60) NOT NULL DEFAULT '' COMMENT '原价（单值:10, 区间:10.00-20.00）一般用于展示使用',
  `min_original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低原价',
  `max_original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最大原价',
  `price` char(60) NOT NULL DEFAULT '' COMMENT '销售价格（单值:10, 区间:10.00-20.00）一般用于展示使用',
  `min_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最低价格',
  `max_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '最高价格',
  `give_integral` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '购买赠送积分比例',
  `buy_min_number` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '最低起购数量 （默认1）',
  `buy_max_number` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '最大购买数量（最大数值 100000000, 小于等于0或空则不限）',
  `is_deduction_inventory` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '是否扣减库存（0否, 1是）',
  `is_shelves` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '是否上架（下架后用户不可见, 0否, 1是）',
  `content_web` mediumtext COMMENT '电脑端详情内容',
  `photo_count` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '相册图片数量',
  `sales_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `access_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '访问次数',
  `video` char(255) NOT NULL DEFAULT '' COMMENT '短视频',
  `is_exist_many_spec` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否存在多个规格（0否, 1是）',
  `spec_base` text COMMENT '规格基础数据',
  `fictitious_goods_value` text COMMENT '虚拟商品展示数据',
  `seo_title` char(100) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` char(130) NOT NULL DEFAULT '' COMMENT 'SEO关键字',
  `seo_desc` char(230) NOT NULL DEFAULT '' COMMENT 'SEO描述',
  `is_delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0 未删除, 大于0则是删除时间）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `title` (`title`),
  KEY `access_count` (`access_count`),
  KEY `photo_count` (`photo_count`),
  KEY `is_shelves` (`is_shelves`),
  KEY `brand_id` (`brand_id`),
  KEY `sales_count` (`sales_count`),
  KEY `is_delete_time` (`is_delete_time`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods`
--

LOCK TABLES `sxo_goods` WRITE;
/*!40000 ALTER TABLE `sxo_goods` DISABLE KEYS */;
INSERT INTO `sxo_goods` VALUES (1,1,-1,'MIUI/小米 小米手机4 小米4代 MI4智能4G手机包邮 黑色 D-LTE（4G）/TD-SCD','','','',0,888888,'步','/static/upload/images/goods/2019/01/14/1547450781101144.jpg','3200.00',3200.00,3200.00,'2100.00',2100.00,2100.00,10,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547450880620837.png\" title=\"1547450880620837.png\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547450880750687.png\" title=\"1547450880750687.png\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547450880917418.png\" title=\"1547450880917418.png\"/></p><p><br/></p>',2,10,820,'',0,'','<p><a href=\"https://pan.baidu.com/s/18xyUNruvohr5JCdorvaz5w\" target=\"_blank\" style=\"box-sizing: border-box; background-color: rgb(255, 255, 255); color: rgb(0, 154, 97); text-decoration-line: none; font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, &quot;Microsoft Yahei&quot;, sans-serif; font-size: 14px; white-space: normal;\">https://pan.baidu.com/s/18xyUNruvohr5JCdorvaz5w</a><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, &quot;Microsoft Yahei&quot;, sans-serif; font-size: 14px;\">&nbsp; &nbsp; &nbsp;提取码&nbsp;</span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, &quot;Microsoft Yahei&quot;, sans-serif; font-size: 14px;\">v3y4</span></p>','','','',0,1547450921,1619434982),(2,2,-1,'苹果（Apple）iPhone 6 Plus (A1524)移动联通电信4G手机 金色 16G','','','iPhone 6 Plus',0,7999992,'步','/static/upload/images/goods/2019/01/14/1547451274847894.jpg','6000.00-7600.00',6000.00,7600.00,'4500.00-6800.00',4500.00,6800.00,30,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547451595700972.jpg\" title=\"1547451595700972.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547451595528800.jpg\" title=\"1547451595528800.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547451595616298.jpg\" title=\"1547451595616298.jpg\"/></p><p><br/></p>',2,38,1949,'/static/upload/video/goods/2019/01/14/1547458876723311.mp4',1,'','','','','',0,1547451624,1619434982),(3,2,-1,'Samsung/三星 SM-G8508S GALAXY Alpha四核智能手机 新品 闪耀白','','','',0,888888,'步','/static/upload/images/goods/2019/01/14/1547451909951171.jpg','6866.00',6866.00,6866.00,'3888.00',3888.00,3888.00,20,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547451947383902.jpg\" title=\"1547451947383902.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547451947686990.jpg\" title=\"1547451947686990.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547451947676180.jpg\" title=\"1547451947676180.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547451947791154.jpg\" title=\"1547451947791154.jpg\"/></p><p><br/></p>',2,5,331,'',0,'','','','','',0,1547452007,1619434982),(4,1,-1,'Huawei/华为 H60-L01 荣耀6 移动4G版智能手机 安卓','','','',0,888888,'步','/static/upload/images/goods/2019/01/14/1547452474332334.jpg','2300.00',2300.00,2300.00,'1999.00',1999.00,1999.00,19,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547452505568604.jpg\" title=\"1547452505568604.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547452505349986.jpg\" title=\"1547452505349986.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547452505184884.jpg\" title=\"1547452505184884.jpg\"/></p><p><br/></p>',2,5,314,'',0,'','','','','',0,1547452553,1619434982),(5,2,-1,'Meizu/魅族 MX4 Pro移动版 八核大屏智能手机 黑色 16G','','','',0,888888,'步','/static/upload/images/goods/2019/01/14/1547452714324599.jpg','3200.00',3200.00,3200.00,'2499.00',2499.00,2499.00,56,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547452760417982.jpg\" title=\"1547452760417982.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547452760659259.jpg\" title=\"1547452760659259.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547452760984656.jpg\" title=\"1547452760984656.jpg\"/></p><p><br/></p>',2,10,585,'',0,NULL,NULL,'','','',0,1547452798,1619434944),(6,1,-1,'vivo X5MAX L 移动4G 八核超薄大屏5.5吋双卡手机vivoX5max','','','',0,888888,'步','/static/upload/images/goods/2019/01/14/1547453000703308.jpg','3200.00',3200.00,3200.00,'2998.90',2998.90,2998.90,65,1,0,1,1,'<p><span style=\"color: rgb(255, 0, 0); font-size: 18px;\">&nbsp;X5L/SL/V/M (5.0寸)&nbsp; X5max钢化膜(5.5寸)&nbsp; X5pro钢化膜(5.2寸)&nbsp;</span></p><p><span style=\"color: rgb(255, 0, 0); font-size: 18px;\"><br/></span></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547453042405182.jpg\" title=\"1547453042405182.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547453042614480.jpg\" title=\"1547453042614480.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547453042816509.jpg\" title=\"1547453042816509.jpg\"/></p><p><br/></p>',2,4,421,'',0,'','','','','',0,1547453135,1619434944),(7,1,-1,'纽芝兰包包女士2018新款潮百搭韩版时尚单肩斜挎包少女小挎包链条','','','',0,888888,'件','/static/upload/images/goods/2019/01/15/1547540603500383.jpg','760.00',760.00,760.00,'168.00',168.00,168.00,11,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547453910353340.jpg\" title=\"1547453910353340.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547453910505349.jpg\" title=\"1547453910505349.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547453910394886.jpg\" title=\"1547453910394886.jpg\"/></p><p><br/></p>',2,12,1271,'',0,NULL,NULL,'','','',0,1547453967,1619435027),(8,1,-1,'MARNI Trunk 女士 中号拼色十字纹小牛皮 斜挎风琴包','','','',0,888884,'件','/static/upload/images/goods/2019/01/14/1547454145355962.jpg','0.00',0.00,0.00,'356.00',356.00,356.00,8,1,6,1,1,'<p><iframe src=\"http://player.youku.com/embed/XNDU0MDk5MTQ4OA==\" width=\"600\" height=\"400\" scrolling=\"no\" frameborder=\"0\" align=\"\"></iframe></p><p><br/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454192301566.jpg\" title=\"1547454192301566.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454192448116.jpg\" title=\"1547454192448116.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454192474638.jpg\" title=\"1547454192474638.jpg\"/></p><p><br/></p>',2,8,1064,'',0,'','','','','',0,1547454269,1619435027),(9,2,2,'睡衣女长袖春秋季纯棉韩版女士大码薄款春夏季全棉家居服两件套装','','','',0,7999992,'件','/static/upload/images/goods/2019/01/14/1547454567172116.jpg','160.00-216.00',160.00,216.00,'120.00-158.00',120.00,158.00,2,1,0,1,1,'<p><img src=\"/static/upload/images/goods/2019/01/14/1547454712270511.jpg\" title=\"1547454712270511.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454713556301.jpg\" title=\"1547454713556301.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454713800333.jpg\" title=\"1547454713800333.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547454713456602.jpg\" title=\"1547454713456602.jpg\"/></p><p><br/></p>',3,30,1059,'',1,'','','','','',0,1547454786,1619434982),(10,0,1,'夏装女装古力娜扎明星同款一字领露肩蓝色蕾丝修身显瘦连衣裙礼服','','','',0,888888,'件','/static/upload/images/goods/2019/01/14/1547455222990904.jpg','568.00',568.00,568.00,'228.00',228.00,228.00,28,1,1,1,1,'<p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><strong><span style=\"color: rgb(153, 51, 255);\">【品牌】欧单 学媛风 猫咪良品</span></strong></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><strong>【吊牌】xueyuanfeng&nbsp;</strong></strong></span></strong></span><strong style=\"font-size: 18px; line-height: 27px;\"><strong><span style=\"color: rgb(153, 51, 255);\">猫咪良品</span></strong></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><strong><strong>【面料质地】涤棉</strong></strong></strong></span><span style=\"font-size: 18px;\"><strong><strong><strong>拼接蕾丝&nbsp;</strong></strong></strong></span><span style=\"font-size: 18px;\"><strong><strong><strong>&nbsp;</strong></strong></strong></span><strong style=\"font-size: 18px; line-height: 1.5;\"><strong><strong>后中拉链 有内衬</strong></strong></strong><strong style=\"font-size: 18px;\"><strong><strong><span style=\"font-family: 微软雅黑;\"><strong>（非专业机构鉴定，介意请慎拍）</strong></span></strong></strong></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong><span style=\"font-size: 18px;\"><span style=\"color: rgb(153, 51, 255);\"></span><span style=\"color: rgb(153, 51, 255);\"></span><span style=\"color: rgb(153, 51, 255);\"><span style=\"background-color: rgb(255, 255, 0);\"><strong style=\"color: rgb(0, 0, 0);\"><span style=\"color: rgb(153, 51, 255);\">好的衣服需要好好呵护，务必请冷水手洗(切记别浸泡)拧干就晾晒或则干洗哦~</span></strong></span></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"><strong>【商品颜色】实物拍摄 蓝色 颜色很难拍有小色差属正常现象哦</strong></span></strong></span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"></span></strong></span></strong></span><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"></span><strong>【商品尺寸】XS/S/M/L 小高腰设计 胸口纽扣是装饰的哦</strong></strong></span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"></span></strong></span></p><p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0); font-family: 微软雅黑;\"><span style=\"font-size: 18px; line-height: 27px;\"></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(64, 64, 64);\"><strong><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">XS码尺寸: 悬挂衣长81CM.胸围80</span></span></strong></span><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">内合适</span></span></strong><span style=\"color: rgb(64, 64, 64);\"><strong><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">.腰围63CM</span></span></strong></span><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">.臀围86CM</span></span></strong></strong></strong></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">S码尺寸: 悬挂衣长82CM.胸围84</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围67CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围90CM</span></strong></strong></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">M码尺寸: 悬挂衣长83CM.胸围88</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围71CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围94CM</span></strong></strong></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">L码尺寸: 悬挂衣长84CM.胸围92</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围75CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围98CM</span></strong></strong></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong style=\"font-size: 18px; line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\"><strong><strong style=\"color: rgb(0, 0, 0);\"><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(0, 0, 255);\"><strong><span style=\"color: rgb(255, 0, 0); font-family: 新宋体;\">（测量单位是CM，每个人的测量方式不一样，测量的尺寸数据可能会有1~3厘米的差异，请MM们谅解哦）</span></strong></span></strong></span></strong></strong></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"><span style=\"color: rgb(0, 0, 255);\"><span style=\"color: rgb(255, 0, 0); font-family: 新宋体;\"></span></span></span></strong></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">PS：常规码数，可按平时号选择哦。修身</span></span></span></strong><strong style=\"line-height: 1.5; color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">版型~如果上身偏大可以适当考虑大1号~下摆蕾丝拼接不会很平整的哦~</span></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong>蕾丝花是手工修剪出来的，每件都有不同和不规则的哦，有小线头和节点是正常现象哦~请亲们谅解哦~</strong></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455266234658.jpg\" title=\"1547455266234658.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455266527628.jpg\" title=\"1547455266527628.jpg\"/></p><p><br/></p>',2,8,714,'',0,'','<p><a href=\"https://pan.baidu.com/s/1XTSM-EJZwEgLmGx3ZyFMGQ\" target=\"_blank\">https://pan.baidu.com/s/1XTSM-EJZwEgLmGx3ZyFMGQ</a>&nbsp; &nbsp;<span style=\"font-size: 16px;\"><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &quot;Segoe UI&quot;, &quot;Lucida Grande&quot;, Helvetica, Arial, &quot;Microsoft YaHei&quot;, FreeSans, Arimo, &quot;Droid Sans&quot;, &quot;wenquanyi micro hei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Hiragino Sans GB W3&quot;, FontAwesome, sans-serif; background-color: rgb(255, 255, 255);\">提取码：</span><span class=\"am-text-success\" style=\"box-sizing: border-box; color: rgb(94, 185, 94); font-family: &quot;Segoe UI&quot;, &quot;Lucida Grande&quot;, Helvetica, Arial, &quot;Microsoft YaHei&quot;, FreeSans, Arimo, &quot;Droid Sans&quot;, &quot;wenquanyi micro hei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Hiragino Sans GB W3&quot;, FontAwesome, sans-serif; background-color: rgb(255, 255, 255);\">dcs4</span></span></p>','','','',0,1547455375,1619434982),(11,3,3,'夏季复古ins风格网红SP同款 短袖大圆领香槟色蕾丝绣花钉珠连衣裙','','','',0,2666664,'件','/static/upload/images/goods/2019/01/14/1547455566118614.jpg','268.00-422.00',268.00,422.00,'160.00-258.00',160.00,258.00,0,1,0,1,1,'<p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><strong><span style=\"color: rgb(153, 51, 255);\">【品牌】欧单 学媛风 猫咪良品</span></strong></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><strong>【吊牌】xueyuanfeng&nbsp;</strong></strong></span></strong></span><strong style=\"font-size: 18px; line-height: 27px;\"><strong><span style=\"color: rgb(153, 51, 255);\">猫咪良品</span></strong></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><strong><strong>【面料质地】网纱绣花钉珠拼接蕾丝</strong></strong></strong></span><span style=\"font-size: 18px;\"><strong><strong><strong>&nbsp;</strong></strong></strong></span><span style=\"font-size: 18px;\"><strong><strong><strong>有</strong></strong></strong></span><strong style=\"font-size: 18px; line-height: 1.5;\"><strong><strong>拉链有内衬</strong></strong></strong><strong style=\"font-size: 18px;\"><strong><strong><span style=\"font-family: 微软雅黑;\"><strong>（非专业机构鉴定，介意请慎拍）</strong></span></strong></strong></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong><span style=\"font-size: 18px;\"><span style=\"color: rgb(153, 51, 255);\"></span><span style=\"color: rgb(153, 51, 255);\"></span><span style=\"color: rgb(153, 51, 255);\"><span style=\"background-color: rgb(255, 255, 0);\"><strong style=\"color: rgb(0, 0, 0);\"><span style=\"color: rgb(153, 51, 255);\">好的衣服需要好好呵护，务必请冷水手洗(切记别浸泡)拧干就晾晒或则干洗哦~</span></strong></span></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"><strong>【商品颜色】实物拍摄 香槟色 颜色很难拍有小色差属正常现象哦</strong></span></strong></span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"></span></strong></span></strong></span><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"></span></strong></span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><strong>【商品尺寸】XS/S/M/L<strong style=\"color: rgb(0, 0, 0);\"><span style=\"color: rgb(153, 51, 255);\"><strong><strong>&nbsp;小高腰设计 胸那考虑撑开因素哦 微弹的哦</strong></strong></span></strong><br/></strong></strong></span></strong></span></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><span style=\"font-size: 18px;\"><strong><span style=\"color: rgb(153, 51, 255);\"></span></strong></span></p><p style=\"white-space: normal; text-align: center;\"><span style=\"color: rgb(255, 0, 0); font-family: 微软雅黑;\"><span style=\"font-size: 18px; line-height: 27px;\"></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(64, 64, 64);\"><strong><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">XS码尺寸: 衣长82CM.胸围80</span></span></strong></span><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">内合适</span></span></strong><span style=\"color: rgb(64, 64, 64);\"><strong><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">.腰围63CM</span></span></strong></span><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\">.臀围86CM</span></span></strong></strong></strong></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">S码尺寸: 衣长83CM.胸围84</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围67CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围90CM</span></strong></strong></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">M码尺寸: 衣长84CM.胸围88</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围71CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围94CM</span></strong></strong></p><p style=\"white-space: normal; text-align: center;\"><strong><strong><span style=\"color: rgb(255, 0, 0);\">L码尺寸: 衣长85CM.胸围92</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">内合适</span></strong><strong><span style=\"color: rgb(255, 0, 0);\">.腰围75CM</span></strong><strong style=\"line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\">.臀围98CM</span></strong></strong></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal; text-align: center;\"><strong style=\"font-size: 18px; line-height: 27px;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-family: 微软雅黑;\"><strong><strong style=\"color: rgb(0, 0, 0);\"><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(0, 0, 255);\"><strong><span style=\"color: rgb(255, 0, 0); font-family: 新宋体;\">（测量单位是CM，每个人的测量方式不一样，测量的尺寸数据可能会有1~3厘米的差异，请MM们谅解哦）</span></strong></span></strong></span></strong></strong></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong><span style=\"color: rgb(153, 51, 255);\"><strong><span style=\"color: rgb(153, 51, 153);\"><span style=\"color: rgb(0, 0, 255);\"><span style=\"color: rgb(255, 0, 0); font-family: 新宋体;\"></span></span></span></strong></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong style=\"color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">PS：常规码数，可按平时号选择哦。修身</span></span></span></strong><strong style=\"line-height: 1.5; color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">版型，如果腰粗可以适当考虑大1号哦~</span></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong style=\"line-height: 1.5; color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">大圆领，每个人的身材曲线不同，领口不会很平的哦，请谅解~</span></span></span></strong></p><p style=\"margin-top: 1.12em; margin-bottom: 1.12em; white-space: normal; padding: 0px; font-family: tahoma, arial, 宋体, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255); text-align: center;\"><strong style=\"line-height: 1.5; color: rgb(64, 64, 64);\"><span style=\"color: rgb(68, 68, 68);\"><span style=\"background-color: rgb(92, 81, 80);\"><span style=\"background-color: rgb(255, 255, 255);\">肩膀那有暗扣哦，可以很好的隐藏了内衣的肩带哦~袖子那略硬哦~</span></span></span></strong></p><p><br/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455601898622.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455601528614.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455601314107.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455601168384.jpg\"/></p><p><br/></p>',4,4,533,'',1,'','','','','',0,1547455700,1619434982),(12,2,4,'ZK星星绣花雪纺连衣裙中长款sukol裙少女心温柔超仙女chic裙子夏','','轻奢醋酸面料，高标准的生产要求,品质保证','hello',2,3555552,'箱','/static/upload/images/goods/2019/01/14/1547455890402147.jpg','0.00',0.00,0.00,'0.10-12000.00',0.10,12000.00,100,1,0,1,1,'<p><br/></p><table class=\"am-table am-table-bordered\"><tbody><tr class=\"firstRow\"><td><span style=\"background-color: rgb(255, 0, 0);\"><strong>11</strong></span></td><td><strong>22</strong></td><td><strong>33</strong></td><td><strong>44</strong></td><td><strong>55</strong></td><td><strong>66</strong></td></tr><tr><td>q</td><td>w</td><td>e</td><td>r</td><td>t</td><td>y</td></tr><tr><td>a</td><td>s</td><td>d</td><td>f</td><td>g</td><td>h</td></tr><tr><td>z</td><td>x</td><td>c</td><td>v</td><td>b</td><td>n</td></tr></tbody></table><p><br/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547456214155362.jpg\" title=\"1547456214155362.jpg\" alt=\"d-1.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455907486857.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547455907256518.jpg\"/></p><p><img src=\"/static/upload/images/goods/2019/01/14/1547456228913731.jpg\" title=\"1547456228913731.jpg\" alt=\"d-2.jpg\"/></p>',3,18,1789,'',1,'[{\"title\":\"颜色\",\"value\":[\"粉色\",\"白色\"]},{\"title\":\"尺码\",\"value\":[\"S+S\",\"M+M\"]}]','','ZK爆款连衣裙','连衣裙,裙子','夏季连衣裙，瘦身裙子',0,1547456230,1618455784);
/*!40000 ALTER TABLE `sxo_goods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_browse`
--

DROP TABLE IF EXISTS `sxo_goods_browse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_browse` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户商品浏览';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_browse`
--

LOCK TABLES `sxo_goods_browse` WRITE;
/*!40000 ALTER TABLE `sxo_goods_browse` DISABLE KEYS */;
INSERT INTO `sxo_goods_browse` VALUES (1,1,1,1619434953,0),(2,8,1,1619435008,1619435037),(3,7,1,1619435012,0);
/*!40000 ALTER TABLE `sxo_goods_browse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_category`
--

DROP TABLE IF EXISTS `sxo_goods_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `icon` char(255) NOT NULL DEFAULT '' COMMENT 'icon图标',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `vice_name` char(80) NOT NULL DEFAULT '' COMMENT '副标题',
  `describe` char(255) NOT NULL DEFAULT '' COMMENT '描述',
  `bg_color` char(30) NOT NULL DEFAULT '' COMMENT 'css背景色值',
  `big_images` char(255) NOT NULL DEFAULT '' COMMENT '大图片',
  `is_home_recommended` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '是否首页推荐（0否, 1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `seo_title` char(100) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` char(130) NOT NULL DEFAULT '' COMMENT 'SEO关键字',
  `seo_desc` char(230) NOT NULL DEFAULT '' COMMENT 'SEO描述',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `is_enable` (`is_enable`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=893 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_category`
--

LOCK TABLES `sxo_goods_category` WRITE;
/*!40000 ALTER TABLE `sxo_goods_category` DISABLE KEYS */;
INSERT INTO `sxo_goods_category` VALUES (1,0,'/static/upload/images/goods_category/2018/08/20180814174251211789.png','数码办公','天天新品，科技带来快乐！','iphoneX新品发布了','#23acff','/static/upload/images/goods_category/2018/08/20180814180843848554.png',1,0,1,'数码办公标题','数码办公,笔记本,手机','数码办公周边产品',1529042764,1613625376),(2,0,'/static/upload/images/goods_category/2018/08/20180814174311166703.png','服饰鞋包','因为美丽、所以神秘！','追求美、你值得拥有','#9761f7','/static/upload/images/goods_category/2018/08/20180815182045222850.png',1,0,1,'','','',1529042764,1557131490),(3,0,'/static/upload/images/goods_category/2018/08/20180814174638213368.png','食品饮料','每一道甜品都有一个故事','美食天下之美','#ff9229','',0,0,1,'','','',1529042764,1547456413),(7,0,'/static/upload/images/goods_category/2018/08/20180814174649846358.png','个护化妆','','','','',0,0,1,'','','',1529042764,1534240009),(52,0,'/static/upload/images/goods_category/2018/08/20180814174659916405.png','珠宝手表','','','','',0,0,1,'','','',1529042764,1606372820),(53,0,'/static/upload/images/goods_category/2018/08/20180814174708327545.png','运动健康','','户外装备，应有尽有','#53c0f3','',0,0,1,'','','',1529042764,1547456464),(54,0,'/static/upload/images/goods_category/2018/08/20180814174722490490.png','汽车用品','','','','',0,0,1,'','','',1529042764,1534240042),(55,0,'/static/upload/images/goods_category/2018/08/20180814174732569726.png','玩具乐器','','','','',0,0,1,'','','',1529042764,1534240052),(56,0,'/static/upload/images/goods_category/2018/08/20180814174748738821.png','母婴用品','','','','',0,0,1,'','','',1529042764,1566129608),(57,0,'/static/upload/images/goods_category/2018/08/20180814174757134754.png','生活服务','','','','',0,0,1,'','','',1529042764,1534240077),(58,1,'/static/upload/images/goods_category/2018/11/20/2018112015245128143.jpeg','手机通讯','','','','',1,0,1,'','','',1529042764,1605687744),(59,1,'/static/upload/images/goods_category/2018/11/20/2018112015273175122.jpeg','手机配件','','','','',1,0,1,'','','',1529042764,1542698851),(60,1,'/static/upload/images/goods_category/2018/11/20/2018112015252193663.jpeg','摄影摄像','','','','',1,0,1,'','','',1529042764,1542698721),(61,1,'/static/upload/images/goods_category/2018/11/20/2018112015441996472.jpeg','时尚影音','','','','',1,0,1,'','','',1529042764,1542699859),(62,1,'/static/upload/images/goods_category/2018/11/20/2018112015255390903.jpeg','电脑整机','','','','',1,0,1,'','','',1529042764,1542698753),(63,1,'','电脑配件','','','','',1,0,1,'','','',1529042764,1534240077),(64,1,'','外设产品','','','','',1,0,1,'','','',1529042764,1534240077),(65,1,'','网络产品','','','','',1,0,1,'','','',1529042764,1534240077),(66,1,'','办公打印','','','','',1,0,1,'','','',1529042764,1534240077),(67,1,'','办公文仪','','','','',1,0,1,'','','',1529042764,1534240077),(68,58,'/static/upload/images/goods_category/2018/11/20/2018112015245128143.jpeg','手机','','','','',1,0,1,'','','',1529042764,1596730214),(69,58,'/static/upload/images/goods_category/2018/11/20/2018112015252193663.jpeg','合约机','','','','',1,0,1,'','','',1529042764,1596730232),(70,58,'/static/upload/images/goods_category/2018/11/20/2018112015273175122.jpeg','对讲机','','','','',1,0,1,'','','',1529042764,1596730248),(71,59,'','手机电池','','','','',1,0,1,'','','',1529042764,0),(72,59,'','蓝牙耳机','','','','',1,0,1,'','','',1529042764,0),(73,59,'','充电器/数据线','','','','',1,0,1,'','','',1529042764,0),(74,59,'','手机耳机','','','','',1,0,1,'','','',1529042764,0),(75,59,'','手机贴膜','','','','',1,0,1,'','','',1529042764,0),(76,59,'','手机存储卡','','','','',1,0,1,'','','',1529042764,0),(77,59,'','手机保护套','','','','',1,0,1,'','','',1529042764,0),(78,59,'','车载配件','','','','',1,0,1,'','','',1529042764,0),(79,59,'','iPhone','','','','',1,0,1,'','','',1529042764,0),(80,59,'','配件','','','','',1,0,1,'','','',1529042764,0),(81,59,'','创意配件','','','','',1,0,1,'','','',1529042764,0),(82,59,'','便携/无线音响','','','','',1,0,1,'','','',1529042764,0),(83,59,'','手机饰品','','','','',1,0,1,'','','',1529042764,0),(84,60,'','数码相机','','','','',1,0,1,'','','',1529042764,0),(85,60,'','单电/微单相机','','','','',1,0,1,'','','',1529042764,0),(86,60,'','单反相机','','','','',1,0,1,'','','',1529042764,0),(87,60,'','摄像机','','','','',1,0,1,'','','',1529042764,0),(88,60,'','拍立得','','','','',1,0,1,'','','',1529042764,0),(89,60,'','镜头','','','','',1,0,1,'','','',1529042764,0),(90,102,'','存储卡','','','','',1,0,1,'','','',1529042764,0),(91,102,'','读卡器','','','','',1,0,1,'','','',1529042764,0),(92,102,'','滤镜','','','','',1,0,1,'','','',1529042764,0),(93,102,'','闪光灯/手柄','','','','',1,0,1,'','','',1529042764,0),(94,102,'','相机包','','','','',1,0,1,'','','',1529042764,0),(95,102,'','三脚架/云台','','','','',1,0,1,'','','',1529042764,0),(96,102,'','相机清洁','','','','',1,0,1,'','','',1529042764,0),(97,102,'','相机贴膜','','','','',1,0,1,'','','',1529042764,0),(98,102,'','机身附件','','','','',1,0,1,'','','',1529042764,0),(99,102,'','镜头附件','','','','',1,0,1,'','','',1529042764,0),(100,102,'','电池/充电器','','','','',1,0,1,'','','',1529042764,0),(101,102,'','移动电源','','','','',1,0,1,'','','',1529042764,0),(102,1,'','数码配件','','','','',1,0,1,'','','',1529042764,0),(103,61,'','MP3/MP4','','','','',1,0,1,'','','',1529042764,0),(104,61,'','智能设备','','','','',1,0,1,'','','',1529042764,0),(105,61,'','耳机/耳麦','','','','',1,0,1,'','','',1529042764,0),(106,61,'','音箱','','','','',1,0,1,'','','',1529042764,0),(107,61,'','高清播放器','','','','',1,0,1,'','','',1529042764,0),(108,61,'','电子书','','','','',1,0,1,'','','',1529042764,0),(109,61,'','电子词典','','','','',1,0,1,'','','',1529042764,0),(110,61,'','MP3/MP4配件','','','','',1,0,1,'','','',1529042764,0),(111,61,'','录音笔','','','','',1,0,1,'','','',1529042764,0),(112,61,'','麦克风','','','','',1,0,1,'','','',1529042764,0),(113,61,'','专业音频','','','','',1,0,1,'','','',1529042764,0),(114,61,'','电子教育','','','','',1,0,1,'','','',1529042764,0),(115,61,'','数码相框','','','','',1,0,1,'','','',1529042764,0),(116,62,'','笔记本','','','','',1,0,1,'','','',1529042764,0),(117,62,'','超极本','','','','',1,0,1,'','','',1529042764,0),(118,62,'','游戏本','','','','',1,0,1,'','','',1529042764,0),(119,62,'','平板电脑','','','','',1,0,1,'','','',1529042764,0),(120,62,'','平板电脑配件','','','','',1,0,1,'','','',1529042764,0),(121,62,'','台式机','','','','',1,0,1,'','','',1529042764,0),(122,62,'','服务器','','','','',1,0,1,'','','',1529042764,0),(123,62,'','笔记本配件','','','','',1,0,1,'','','',1529042764,0),(124,63,'','CPU','','','','',1,0,1,'','','',1529042764,0),(125,63,'','主板','','','','',1,0,1,'','','',1529042764,0),(126,63,'','显卡','','','','',1,0,1,'','','',1529042764,0),(127,63,'','硬盘','','','','',1,0,1,'','','',1529042764,0),(128,63,'','SSD固态硬盘','','','','',1,0,1,'','','',1529042764,0),(129,63,'','内存','','','','',1,0,1,'','','',1529042764,0),(130,63,'','机箱','','','','',1,0,1,'','','',1529042764,0),(131,63,'','电源','','','','',1,0,1,'','','',1529042764,0),(132,63,'','显示器','','','','',1,0,1,'','','',1529042764,0),(133,63,'','刻录机/光驱','','','','',1,0,1,'','','',1529042764,0),(134,63,'','散热器','','','','',1,0,1,'','','',1529042764,0),(135,63,'','声卡/扩展卡','','','','',1,0,1,'','','',1529042764,0),(136,63,'','装机配件','','','','',1,0,1,'','','',1529042764,0),(137,64,'','鼠标','','','','',1,0,1,'','','',1529042764,0),(138,64,'','键盘','','','','',1,0,1,'','','',1529042764,0),(139,64,'','移动硬盘','','','','',1,0,1,'','','',1529042764,0),(140,64,'','U盘','','','','',1,0,1,'','','',1529042764,0),(141,64,'','摄像头','','','','',1,0,1,'','','',1529042764,0),(142,64,'','外置盒','','','','',1,0,1,'','','',1529042764,0),(143,64,'','游戏设备','','','','',1,0,1,'','','',1529042764,0),(144,64,'','电视盒','','','','',1,0,1,'','','',1529042764,0),(145,64,'','手写板','','','','',1,0,1,'','','',1529042764,0),(146,64,'','鼠标垫','','','','',1,0,1,'','','',1529042764,0),(147,64,'','插座','','','','',1,0,1,'','','',1529042764,0),(148,64,'','UPS电源','','','','',1,0,1,'','','',1529042764,0),(149,64,'','线缆','','','','',1,0,1,'','','',1529042764,0),(150,64,'','电脑工具','','','','',1,0,1,'','','',1529042764,0),(151,64,'','电脑清洁','','','','',1,0,1,'','','',1529042764,0),(152,65,'','路由器','','','','',1,0,1,'','','',1529042764,0),(153,65,'','网卡','','','','',1,0,1,'','','',1529042764,0),(154,65,'','交换机','','','','',1,0,1,'','','',1529042764,0),(155,65,'','网络存储','','','','',1,0,1,'','','',1529042764,0),(156,65,'','3G上网','','','','',1,0,1,'','','',1529042764,0),(157,65,'','网络盒子','','','','',1,0,1,'','','',1529042764,0),(158,66,'','打印机','','','','',1,0,1,'','','',1529042764,0),(159,66,'','一体机','','','','',1,0,1,'','','',1529042764,0),(160,66,'','投影机','','','','',1,0,1,'','','',1529042764,0),(161,66,'','投影配件','','','','',1,0,1,'','','',1529042764,0),(162,66,'','传真机','','','','',1,0,1,'','','',1529042764,0),(163,66,'','复合机','','','','',1,0,1,'','','',1529042764,0),(164,66,'','碎纸机','','','','',1,0,1,'','','',1529042764,0),(165,66,'','扫描仪','','','','',1,0,1,'','','',1529042764,0),(166,66,'','墨盒','','','','',1,0,1,'','','',1529042764,0),(167,66,'','硒鼓','','','','',1,0,1,'','','',1529042764,0),(168,66,'','墨粉','','','','',1,0,1,'','','',1529042764,0),(169,66,'','色带','','','','',1,0,1,'','','',1529042764,0),(170,67,'','办公文具','','','','',1,0,1,'','','',1529042764,0),(171,67,'','文件管理','','','','',1,0,1,'','','',1529042764,0),(172,67,'','笔类','','','','',1,0,1,'','','',1529042764,0),(173,67,'','纸类','','','','',1,0,1,'','','',1529042764,0),(174,67,'','本册/便签','','','','',1,0,1,'','','',1529042764,0),(175,67,'','学生文具','','','','',1,0,1,'','','',1529042764,0),(176,67,'','财务用品','','','','',1,0,1,'','','',1529042764,0),(177,67,'','计算器','','','','',1,0,1,'','','',1529042764,0),(178,67,'','激光笔','','','','',1,0,1,'','','',1529042764,0),(179,67,'','白板/封装','','','','',1,0,1,'','','',1529042764,0),(180,67,'','考勤机','','','','',1,0,1,'','','',1529042764,0),(181,67,'','刻录碟片/附件','','','','',1,0,1,'','','',1529042764,0),(182,67,'','点钞机','','','','',1,0,1,'','','',1529042764,0),(183,67,'','支付设备','','','','',1,0,1,'','','',1529042764,1606379152),(184,67,'','安防监控','','','','',1,0,1,'','','',1529042764,0),(185,67,'','呼叫/会议设备','','','','',1,0,1,'','','',1529042764,0),(186,67,'','保险柜','','','','',1,0,1,'','','',1529042764,0),(187,67,'','办公家具','','','','',1,0,1,'','','',1529042764,0),(188,2,'','潮流女包','','','','',1,0,1,'','','',1529042764,0),(189,2,'','时尚男包','','','','',1,0,1,'','','',1529042764,0),(190,2,'','功能箱包','','','','',1,0,1,'','','',1529042764,0),(191,2,'','礼品','','','','',1,0,1,'','','',1529042764,0),(192,2,'','奢侈品','','','','',1,0,1,'','','',1529042764,0),(193,188,'','钱包/卡包','','','','',1,0,1,'','','',1529042764,0),(194,188,'','手拿包','','','','',1,0,1,'','','',1529042764,0),(195,188,'','单肩包','','','','',1,0,1,'','','',1529042764,0),(196,188,'','双肩包','','','','',1,0,1,'','','',1529042764,0),(197,188,'','手提包','','','','',1,0,1,'','','',1529042764,0),(198,188,'','斜挎包','','','','',1,0,1,'','','',1529042764,0),(199,189,'','钱包/卡包','','','','',1,0,1,'','','',1529042764,0),(200,189,'','男士手包','','','','',1,0,1,'','','',1529042764,0),(201,189,'','腰带／礼盒','','','','',1,0,1,'','','',1529042764,0),(202,189,'','商务公文包','','','','',1,0,1,'','','',1529042764,0),(203,190,'','电脑数码包','','','','',1,0,1,'','','',1529042764,0),(204,190,'','拉杆箱','','','','',1,0,1,'','','',1529042764,0),(205,190,'','旅行包','','','','',1,0,1,'','','',1529042764,0),(206,190,'','旅行配件','','','','',1,0,1,'','','',1529042764,0),(207,190,'','休闲运动包','','','','',1,0,1,'','','',1529042764,0),(208,190,'','登山包','','','','',1,0,1,'','','',1529042764,0),(209,190,'','妈咪包','','','','',1,0,1,'','','',1529042764,0),(210,190,'','书包','','','','',1,0,1,'','','',1529042764,0),(211,191,'','火机烟具','','','','',1,0,1,'','','',1529042764,0),(212,191,'','礼品文具','','','','',1,0,1,'','','',1529042764,0),(213,191,'','瑞士军刀','','','','',1,0,1,'','','',1529042764,0),(214,191,'','收藏品','','','','',1,0,1,'','','',1529042764,0),(215,191,'','工艺礼品','','','','',1,0,1,'','','',1529042764,0),(216,191,'','创意礼品','','','','',1,0,1,'','','',1529042764,0),(217,191,'','礼卡礼卷','','','','',1,0,1,'','','',1529042764,0),(218,191,'','鲜花速递','','','','',1,0,1,'','','',1529042764,0),(219,191,'','婚庆用品','','','','',1,0,1,'','','',1529042764,0),(220,192,'','奢侈品箱包','','','','',1,0,1,'','','',1529042764,0),(221,192,'','钱包','','','','',1,0,1,'','','',1529042764,0),(222,192,'','服饰','','','','',1,0,1,'','','',1529042764,0),(223,192,'','腰带','','','','',1,0,1,'','','',1529042764,0),(224,192,'','太阳镜眼镜','','','','',1,0,1,'','','',1529042764,0),(225,192,'','配件','','','','',1,0,1,'','','',1529042764,0),(226,192,'','GUCCI','','','','',1,0,1,'','','',1529042764,0),(227,192,'','PRADA','','','','',1,0,1,'','','',1529042764,0),(228,192,'','FENDI','','','','',1,0,1,'','','',1529042764,0),(229,192,'','BURBERRY','','','','',1,0,1,'','','',1529042764,0),(230,192,'','MONTBLANC','','','','',1,0,1,'','','',1529042764,0),(231,192,'','ARMANI','','','','',1,0,1,'','','',1529042764,0),(232,192,'','RIMOWA','','','','',1,0,1,'','','',1529042764,0),(233,192,'','RAY-BAN','','','','',1,0,1,'','','',1529042764,0),(234,192,'','COACH','','','','',1,0,1,'','','',1529042764,0),(235,192,'','其它品牌','','','','',1,0,1,'','','',1529042764,0),(236,3,'','进口食品','','','','',1,0,1,'','','',1529042764,0),(237,3,'','地方特产','','','','',1,0,1,'','','',1529042764,0),(238,3,'','休闲食品','','','','',1,0,1,'','','',1529042764,0),(239,3,'','粮油调味','','','','',1,0,1,'','','',1529042764,0),(240,3,'','中外名酒','','','','',1,0,1,'','','',1529042764,0),(241,3,'','饮料冲调','','','','',1,0,1,'','','',1529042764,0),(242,3,'','营养健康','','','','',1,0,1,'','','',1529042764,0),(243,3,'','亚健康调理','','','','',1,0,1,'','','',1529042764,0),(244,3,'','健康礼品','','','','',1,0,1,'','','',1529042764,0),(245,3,'','生鲜食品','','','','',1,0,1,'','','',1529042764,0),(246,236,'','饼干蛋糕','','','','',1,0,1,'','','',1529042764,0),(247,236,'','糖果巧克力','','','','',1,0,1,'','','',1529042764,0),(248,236,'','休闲零食','','','','',1,0,1,'','','',1529042764,0),(249,236,'','冲调饮品','','','','',1,0,1,'','','',1529042764,0),(250,236,'','粮油调味','','','','',1,0,1,'','','',1529042764,0),(251,237,'','华北','','','','',1,0,1,'','','',1529042764,0),(252,237,'','西北','','','','',1,0,1,'','','',1529042764,0),(253,237,'','西南','','','','',1,0,1,'','','',1529042764,0),(254,237,'','东北','','','','',1,0,1,'','','',1529042764,0),(255,237,'','华南','','','','',1,0,1,'','','',1529042764,0),(256,237,'','华东','','','','',1,0,1,'','','',1529042764,0),(257,237,'','华中','','','','',1,0,1,'','','',1529042764,0),(258,238,'','休闲零食','','','','',1,0,1,'','','',1529042764,0),(259,238,'','坚果炒货','','','','',1,0,1,'','','',1529042764,0),(260,238,'','肉干肉松','','','','',1,0,1,'','','',1529042764,0),(261,238,'','蜜饯果脯','','','','',1,0,1,'','','',1529042764,0),(262,238,'','糖果/巧克力','','','','',1,0,1,'','','',1529042764,0),(263,238,'','饼干蛋糕','','','','',1,0,1,'','','',1529042764,0),(264,239,'','米面杂粮','','','','',1,0,1,'','','',1529042764,0),(265,239,'','食用油','','','','',1,0,1,'','','',1529042764,0),(266,239,'','调味品','','','','',1,0,1,'','','',1529042764,0),(267,239,'','南北干货','','','','',1,0,1,'','','',1529042764,0),(268,239,'','方便食品','','','','',1,0,1,'','','',1529042764,0),(269,239,'','有机食品','','','','',1,0,1,'','','',1529042764,0),(270,240,'','白酒','','','','',1,0,1,'','','',1529042764,0),(271,240,'','洋酒','','','','',1,0,1,'','','',1529042764,0),(272,240,'','葡萄酒','','','','',1,0,1,'','','',1529042764,0),(273,240,'','啤酒','','','','',1,0,1,'','','',1529042764,0),(274,240,'','黄酒','','','','',1,0,1,'','','',1529042764,0),(275,241,'','水','','','','',1,0,1,'','','',1529042764,0),(276,241,'','饮料','','','','',1,0,1,'','','',1529042764,0),(277,241,'','牛奶','','','','',1,0,1,'','','',1529042764,0),(278,241,'','茶叶','','','','',1,0,1,'','','',1529042764,0),(279,241,'','咖啡/奶茶','','','','',1,0,1,'','','',1529042764,0),(280,241,'','冲饮谷物','','','','',1,0,1,'','','',1529042764,0),(281,242,'','基础营养','','','','',1,0,1,'','','',1529042764,0),(282,242,'','美体养颜','','','','',1,0,1,'','','',1529042764,0),(283,242,'','滋补调养','','','','',1,0,1,'','','',1529042764,0),(284,242,'','骨骼健康','','','','',1,0,1,'','','',1529042764,0),(285,242,'','保健茶饮','','','','',1,0,1,'','','',1529042764,0),(286,242,'','成分保健','','','','',1,0,1,'','','',1529042764,0),(287,242,'','无糖食品','','','','',1,0,1,'','','',1529042764,0),(288,243,'','调节三高','','','','',1,0,1,'','','',1529042764,0),(289,243,'','心脑养护','','','','',1,0,1,'','','',1529042764,0),(290,243,'','改善睡眠','','','','',1,0,1,'','','',1529042764,0),(291,243,'','肝肾养护','','','','',1,0,1,'','','',1529042764,0),(292,243,'','免疫调节','','','','',1,0,1,'','','',1529042764,0),(293,243,'','更多调理','','','','',1,0,1,'','','',1529042764,0),(294,244,'','参茸礼品','','','','',1,0,1,'','','',1529042764,0),(295,244,'','其它礼品','','','','',1,0,1,'','','',1529042764,0),(296,245,'','水果','','','','',1,0,1,'','','',1529042764,0),(297,245,'','蔬菜','','','','',1,0,1,'','','',1529042764,0),(298,245,'','海鲜水产','','','','',1,0,1,'','','',1529042764,0),(299,245,'','禽蛋','','','','',1,0,1,'','','',1529042764,0),(300,245,'','鲜肉','','','','',1,0,1,'','','',1529042764,0),(301,245,'','加工类肉食','','','','',1,0,1,'','','',1529042764,0),(302,245,'','冻品','','','','',1,0,1,'','','',1529042764,0),(303,245,'','半成品','','','','',1,0,1,'','','',1529042764,0),(304,2,'','女装','','','','',1,0,1,'','','',1529042764,0),(305,2,'','男装','','','','',1,0,1,'','','',1529042764,0),(306,2,'','内衣','','','','',1,0,1,'','','',1529042764,0),(307,2,'','运动','','','','',1,0,1,'','','',1529042764,0),(308,2,'','女鞋','','','','',1,0,1,'','','',1529042764,0),(309,2,'','男鞋','','','','',1,0,1,'','','',1529042764,0),(310,2,'','配饰','','','','',1,0,1,'','','',1529042764,0),(311,2,'','童装','','','','',1,0,1,'','','',1529042764,0),(312,304,'','T恤','','','','',1,0,1,'','','',1529042764,0),(313,304,'','衬衫','','','','',1,0,1,'','','',1529042764,0),(314,304,'','针织衫','','','','',1,0,1,'','','',1529042764,0),(315,304,'','雪纺衫','','','','',1,0,1,'','','',1529042764,0),(316,304,'','卫衣','','','','',1,0,1,'','','',1529042764,0),(317,304,'','马甲','','','','',1,0,1,'','','',1529042764,0),(318,304,'','连衣裙','','','','',1,0,1,'','','',1529042764,0),(319,304,'','半身裙','','','','',1,0,1,'','','',1529042764,0),(320,304,'','牛仔裤','','','','',1,0,1,'','','',1529042764,0),(321,304,'','休闲裤','','','','',1,0,1,'','','',1529042764,0),(322,304,'','打底裤','','','','',1,0,1,'','','',1529042764,0),(323,304,'','正装裤','','','','',1,0,1,'','','',1529042764,0),(324,304,'','西服','','','','',1,0,1,'','','',1529042764,0),(325,304,'','短外套','','','','',1,0,1,'','','',1529042764,0),(326,304,'','风衣','','','','',1,0,1,'','','',1529042764,0),(327,304,'','大衣','','','','',1,0,1,'','','',1529042764,0),(328,304,'','皮衣皮草','','','','',1,0,1,'','','',1529042764,0),(329,304,'','棉服','','','','',1,0,1,'','','',1529042764,0),(330,304,'','羽绒服','','','','',1,0,1,'','','',1529042764,0),(331,304,'','孕妇装','','','','',1,0,1,'','','',1529042764,0),(332,304,'','大码装','','','','',1,0,1,'','','',1529042764,0),(333,304,'','中老年装','','','','',1,0,1,'','','',1529042764,0),(334,304,'','婚纱礼服','','','','',1,0,1,'','','',1529042764,0),(335,304,'','其它','','','','',1,0,1,'','','',1529042764,0),(336,305,'','衬衫','','','','',1,0,1,'','','',1529042764,0),(337,305,'','T恤','','','','',1,0,1,'','','',1529042764,0),(338,305,'','POLO衫','','','','',1,0,1,'','','',1529042764,0),(339,305,'','针织衫','','','','',1,0,1,'','','',1529042764,0),(340,305,'','羊绒衫','','','','',1,0,1,'','','',1529042764,0),(341,305,'','卫衣','','','','',1,0,1,'','','',1529042764,0),(342,305,'','马甲／背心','','','','',1,0,1,'','','',1529042764,0),(343,305,'','夹克','','','','',1,0,1,'','','',1529042764,0),(344,305,'','风衣','','','','',1,0,1,'','','',1529042764,0),(345,305,'','大衣','','','','',1,0,1,'','','',1529042764,0),(346,305,'','皮衣','','','','',1,0,1,'','','',1529042764,0),(347,305,'','外套','','','','',1,0,1,'','','',1529042764,0),(348,305,'','西服','','','','',1,0,1,'','','',1529042764,0),(349,305,'','棉服','','','','',1,0,1,'','','',1529042764,0),(350,305,'','羽绒服','','','','',1,0,1,'','','',1529042764,0),(351,305,'','牛仔裤','','','','',1,0,1,'','','',1529042764,0),(352,305,'','休闲裤','','','','',1,0,1,'','','',1529042764,0),(353,305,'','西裤','','','','',1,0,1,'','','',1529042764,0),(354,305,'','西服套装','','','','',1,0,1,'','','',1529042764,0),(355,305,'','大码装','','','','',1,0,1,'','','',1529042764,0),(356,305,'','中老年装','','','','',1,0,1,'','','',1529042764,0),(357,305,'','唐装','','','','',1,0,1,'','','',1529042764,0),(358,305,'','工装','','','','',1,0,1,'','','',1529042764,0),(359,306,'','文胸','','','','',1,0,1,'','','',1529042764,0),(360,306,'','女式内裤','','','','',1,0,1,'','','',1529042764,0),(361,306,'','男式内裤','','','','',1,0,1,'','','',1529042764,0),(362,306,'','家居','','','','',1,0,1,'','','',1529042764,0),(363,306,'','睡衣','','','','',1,0,1,'','','',1529042764,0),(364,306,'','塑身衣','','','','',1,0,1,'','','',1529042764,0),(365,306,'','睡袍／浴袍','','','','',1,0,1,'','','',1529042764,0),(366,306,'','泳衣','','','','',1,0,1,'','','',1529042764,0),(367,306,'','背心','','','','',1,0,1,'','','',1529042764,0),(368,306,'','抹胸','','','','',1,0,1,'','','',1529042764,0),(369,306,'','连裤袜','','','','',1,0,1,'','','',1529042764,0),(370,306,'','美腿袜','','','','',1,0,1,'','','',1529042764,0),(371,306,'','男袜','','','','',1,0,1,'','','',1529042764,0),(372,306,'','女袜','','','','',1,0,1,'','','',1529042764,0),(373,306,'','情趣内衣','','','','',1,0,1,'','','',1529042764,0),(374,306,'','保暖内衣','','','','',1,0,1,'','','',1529042764,0),(375,307,'','休闲鞋','','','','',1,0,1,'','','',1529042764,0),(376,307,'','帆布鞋','','','','',1,0,1,'','','',1529042764,0),(377,307,'','跑步鞋','','','','',1,0,1,'','','',1529042764,0),(378,307,'','篮球鞋','','','','',1,0,1,'','','',1529042764,0),(379,307,'','足球鞋','','','','',1,0,1,'','','',1529042764,0),(380,307,'','训练鞋','','','','',1,0,1,'','','',1529042764,0),(381,307,'','乒羽鞋','','','','',1,0,1,'','','',1529042764,0),(382,307,'','拖鞋','','','','',1,0,1,'','','',1529042764,0),(383,307,'','卫衣','','','','',1,0,1,'','','',1529042764,0),(384,307,'','夹克','','','','',1,0,1,'','','',1529042764,0),(385,307,'','T恤','','','','',1,0,1,'','','',1529042764,0),(386,307,'','棉服／羽绒服','','','','',1,0,1,'','','',1529042764,0),(387,307,'','运动裤','','','','',1,0,1,'','','',1529042764,0),(388,307,'','套装','','','','',1,0,1,'','','',1529042764,0),(389,307,'','运动包','','','','',1,0,1,'','','',1529042764,0),(390,307,'','运动配件','','','','',1,0,1,'','','',1529042764,0),(391,308,'','平底鞋','','','','',1,0,1,'','','',1529042764,0),(392,308,'','高跟鞋','','','','',1,0,1,'','','',1529042764,0),(393,308,'','单鞋','','','','',1,0,1,'','','',1529042764,0),(394,308,'','休闲鞋','','','','',1,0,1,'','','',1529042764,0),(395,308,'','凉鞋','','','','',1,0,1,'','','',1529042764,0),(396,308,'','女靴','','','','',1,0,1,'','','',1529042764,0),(397,308,'','雪地靴','','','','',1,0,1,'','','',1529042764,0),(398,308,'','拖鞋','','','','',1,0,1,'','','',1529042764,0),(399,308,'','裸靴','','','','',1,0,1,'','','',1529042764,0),(400,308,'','筒靴','','','','',1,0,1,'','','',1529042764,0),(401,308,'','帆布鞋','','','','',1,0,1,'','','',1529042764,0),(402,308,'','雨鞋／雨靴','','','','',1,0,1,'','','',1529042764,0),(403,308,'','妈妈鞋','','','','',1,0,1,'','','',1529042764,0),(404,308,'','鞋配件','','','','',1,0,1,'','','',1529042764,0),(405,308,'','特色鞋','','','','',1,0,1,'','','',1529042764,0),(406,308,'','鱼嘴鞋','','','','',1,0,1,'','','',1529042764,0),(407,308,'','布鞋／绣花鞋','','','','',1,0,1,'','','',1529042764,0),(408,309,'','商务休闲鞋','','','','',1,0,1,'','','',1529042764,0),(409,309,'','正装鞋','','','','',1,0,1,'','','',1529042764,0),(410,309,'','休闲鞋','','','','',1,0,1,'','','',1529042764,0),(411,309,'','凉鞋／沙滩鞋','','','','',1,0,1,'','','',1529042764,0),(412,309,'','男靴','','','','',1,0,1,'','','',1529042764,0),(413,309,'','功能鞋','','','','',1,0,1,'','','',1529042764,0),(414,309,'','拖鞋','','','','',1,0,1,'','','',1529042764,0),(415,309,'','传统布鞋','','','','',1,0,1,'','','',1529042764,0),(416,309,'','鞋配件','','','','',1,0,1,'','','',1529042764,0),(417,309,'','帆布鞋','','','','',1,0,1,'','','',1529042764,0),(418,309,'','豆豆鞋','','','','',1,0,1,'','','',1529042764,0),(419,309,'','驾车鞋','','','','',1,0,1,'','','',1529042764,0),(420,310,'','太阳镜','','','','',1,0,1,'','','',1529042764,0),(421,310,'','框镜','','','','',1,0,1,'','','',1529042764,0),(422,310,'','皮带','','','','',1,0,1,'','','',1529042764,0),(423,310,'','围巾','','','','',1,0,1,'','','',1529042764,0),(424,310,'','手套','','','','',1,0,1,'','','',1529042764,0),(425,310,'','帽子','','','','',1,0,1,'','','',1529042764,0),(426,310,'','领带','','','','',1,0,1,'','','',1529042764,0),(427,310,'','袖扣','','','','',1,0,1,'','','',1529042764,0),(428,310,'','其他配件','','','','',1,0,1,'','','',1529042764,0),(429,310,'','丝巾','','','','',1,0,1,'','','',1529042764,0),(430,310,'','披肩','','','','',1,0,1,'','','',1529042764,0),(431,310,'','腰带','','','','',1,0,1,'','','',1529042764,0),(432,310,'','腰链／腰封','','','','',1,0,1,'','','',1529042764,0),(433,310,'','棒球帽','','','','',1,0,1,'','','',1529042764,0),(434,310,'','毛线','','','','',1,0,1,'','','',1529042764,0),(435,310,'','遮阳帽','','','','',1,0,1,'','','',1529042764,0),(436,310,'','防紫外线手套','','','','',1,0,1,'','','',1529042764,0),(437,310,'','草帽','','','','',1,0,1,'','','',1529042764,0),(438,311,'','套装','','','','',1,0,1,'','','',1529042764,0),(439,311,'','上衣','','','','',1,0,1,'','','',1529042764,0),(440,311,'','裤子','','','','',1,0,1,'','','',1529042764,0),(441,311,'','裙子','','','','',1,0,1,'','','',1529042764,0),(442,311,'','内衣／家居服','','','','',1,0,1,'','','',1529042764,0),(443,311,'','羽绒服／棉服','','','','',1,0,1,'','','',1529042764,0),(444,311,'','亲子装','','','','',1,0,1,'','','',1529042764,0),(445,311,'','儿童配饰','','','','',1,0,1,'','','',1529042764,0),(446,311,'','礼服／演出服','','','','',1,0,1,'','','',1529042764,0),(447,311,'','运动鞋','','','','',1,0,1,'','','',1529042764,0),(448,311,'','单鞋','','','','',1,0,1,'','','',1529042764,0),(449,311,'','靴子','','','','',1,0,1,'','','',1529042764,0),(450,311,'','凉鞋','','','','',1,0,1,'','','',1529042764,0),(451,311,'','功能鞋','','','','',1,0,1,'','','',1529042764,0),(452,7,'','面部护理','','','','',1,0,1,'','','',1529042764,0),(453,7,'','身体护理','','','','',1,0,1,'','','',1529042764,0),(454,7,'','口腔护理','','','','',1,0,1,'','','',1529042764,0),(455,7,'','女性护理','','','','',1,0,1,'','','',1529042764,0),(456,7,'','男士护理','','','','',1,0,1,'','','',1529042764,0),(457,7,'','魅力彩妆','','','','',1,0,1,'','','',1529042764,0),(458,7,'','香水SPA','','','','',1,0,1,'','','',1529042764,0),(459,452,'','洁面乳','','','','',1,0,1,'','','',1529042764,0),(460,452,'','爽肤水','','','','',1,0,1,'','','',1529042764,0),(461,452,'','精华露','','','','',1,0,1,'','','',1529042764,0),(462,452,'','乳液面霜','','','','',1,0,1,'','','',1529042764,0),(463,452,'','面膜面贴','','','','',1,0,1,'','','',1529042764,0),(464,452,'','眼部护理','','','','',1,0,1,'','','',1529042764,0),(465,452,'','颈部护理','','','','',1,0,1,'','','',1529042764,0),(466,452,'','T区护理','','','','',1,0,1,'','','',1529042764,0),(467,452,'','护肤套装','','','','',1,0,1,'','','',1529042764,0),(468,452,'','防晒隔离','','','','',1,0,1,'','','',1529042764,0),(469,453,'','洗发护发','','','','',1,0,1,'','','',1529042764,0),(470,453,'','染发/造型','','','','',1,0,1,'','','',1529042764,0),(471,453,'','沐浴','','','','',1,0,1,'','','',1529042764,0),(472,453,'','磨砂/浴盐','','','','',1,0,1,'','','',1529042764,0),(473,453,'','身体乳','','','','',1,0,1,'','','',1529042764,0),(474,453,'','手工/香皂','','','','',1,0,1,'','','',1529042764,0),(475,453,'','香薰精油','','','','',1,0,1,'','','',1529042764,0),(476,453,'','纤体瘦身','','','','',1,0,1,'','','',1529042764,0),(477,453,'','脱毛膏','','','','',1,0,1,'','','',1529042764,0),(478,453,'','手足护理','','','','',1,0,1,'','','',1529042764,0),(479,453,'','洗护套装','','','','',1,0,1,'','','',1529042764,0),(480,454,'','牙膏/牙粉','','','','',1,0,1,'','','',1529042764,0),(481,454,'','牙刷/牙线','','','','',1,0,1,'','','',1529042764,0),(482,454,'','漱口水','','','','',1,0,1,'','','',1529042764,0),(483,455,'','卫生巾','','','','',1,0,1,'','','',1529042764,0),(484,455,'','卫生护垫','','','','',1,0,1,'','','',1529042764,0),(485,455,'','洗液','','','','',1,0,1,'','','',1529042764,0),(486,455,'','美容食品','','','','',1,0,1,'','','',1529042764,0),(487,455,'','其他','','','','',1,0,1,'','','',1529042764,0),(488,456,'','脸部护理','','','','',1,0,1,'','','',1529042764,0),(489,456,'','眼部护理','','','','',1,0,1,'','','',1529042764,0),(490,456,'','身体护理','','','','',1,0,1,'','','',1529042764,0),(491,456,'','男士香水','','','','',1,0,1,'','','',1529042764,0),(492,456,'','剃须护理','','','','',1,0,1,'','','',1529042764,0),(493,456,'','防脱洗护','','','','',1,0,1,'','','',1529042764,0),(494,456,'','男士唇膏','','','','',1,0,1,'','','',1529042764,0),(495,457,'','粉底/遮瑕','','','','',1,0,1,'','','',1529042764,0),(496,457,'','腮红','','','','',1,0,1,'','','',1529042764,0),(497,457,'','眼影/眼线','','','','',1,0,1,'','','',1529042764,0),(498,457,'','眉笔','','','','',1,0,1,'','','',1529042764,0),(499,457,'','睫毛膏','','','','',1,0,1,'','','',1529042764,0),(500,457,'','唇膏唇彩','','','','',1,0,1,'','','',1529042764,0),(501,457,'','彩妆组合','','','','',1,0,1,'','','',1529042764,0),(502,457,'','卸妆','','','','',1,0,1,'','','',1529042764,0),(503,457,'','美甲','','','','',1,0,1,'','','',1529042764,0),(504,457,'','彩妆工具','','','','',1,0,1,'','','',1529042764,0),(505,457,'','假发','','','','',1,0,1,'','','',1529042764,0),(506,458,'','女士香水','','','','',1,0,1,'','','',1529042764,0),(507,458,'','男士香水','','','','',1,0,1,'','','',1529042764,0),(508,458,'','组合套装','','','','',1,0,1,'','','',1529042764,0),(509,458,'','迷你香水','','','','',1,0,1,'','','',1529042764,0),(510,458,'','香体走珠','','','','',1,0,1,'','','',1529042764,0),(511,52,'','时尚饰品','','','','',1,0,1,'','','',1529042764,0),(512,52,'','纯金K金饰品','','','','',1,0,1,'','','',1529042764,0),(513,52,'','金银投资','','','','',1,0,1,'','','',1529042764,0),(514,52,'','银饰','','','','',1,0,1,'','','',1529042764,0),(515,52,'','钻石饰品','','','','',1,0,1,'','','',1529042764,0),(516,52,'','翡翠玉石','','','','',1,0,1,'','','',1529042764,0),(517,52,'','水晶玛瑙','','','','',1,0,1,'','','',1529042764,0),(518,52,'','宝石珍珠','','','','',1,0,1,'','','',1529042764,0),(519,52,'','婚庆','','','','',1,0,1,'','','',1529042764,0),(520,52,'','钟表手表','','','','',1,0,1,'','','',1529042764,0),(521,511,'','项链','','','','',1,0,1,'','','',1529042764,0),(522,511,'','手链/脚链','','','','',1,0,1,'','','',1529042764,0),(523,511,'','戒指','','','','',1,0,1,'','','',1529042764,0),(524,511,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(525,511,'','头饰','','','','',1,0,1,'','','',1529042764,0),(526,511,'','胸针','','','','',1,0,1,'','','',1529042764,0),(527,511,'','婚庆饰品','','','','',1,0,1,'','','',1529042764,0),(528,511,'','饰品配件','','','','',1,0,1,'','','',1529042764,0),(529,512,'','吊坠/项链','','','','',1,0,1,'','','',1529042764,0),(530,512,'','手镯/手链/脚链','','','','',1,0,1,'','','',1529042764,0),(531,512,'','戒指','','','','',1,0,1,'','','',1529042764,0),(532,512,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(533,513,'','工艺金','','','','',1,0,1,'','','',1529042764,0),(534,513,'','工艺银','','','','',1,0,1,'','','',1529042764,0),(535,514,'','吊坠/项链','','','','',1,0,1,'','','',1529042764,0),(536,514,'','手镯/手链/脚链','','','','',1,0,1,'','','',1529042764,0),(537,514,'','戒指/耳饰','','','','',1,0,1,'','','',1529042764,0),(538,514,'','宝宝金银','','','','',1,0,1,'','','',1529042764,0),(539,514,'','千足银','','','','',1,0,1,'','','',1529042764,0),(540,515,'','裸钻','','','','',1,0,1,'','','',1529042764,0),(541,515,'','戒指','','','','',1,0,1,'','','',1529042764,0),(542,515,'','项链/吊坠','','','','',1,0,1,'','','',1529042764,0),(543,515,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(544,515,'','手镯/手链','','','','',1,0,1,'','','',1529042764,0),(545,516,'','项链/吊坠','','','','',1,0,1,'','','',1529042764,0),(546,516,'','手镯/手串','','','','',1,0,1,'','','',1529042764,0),(547,516,'','戒指','','','','',1,0,1,'','','',1529042764,0),(548,516,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(549,516,'','挂件/摆件/把件','','','','',1,0,1,'','','',1529042764,0),(550,516,'','高值收藏','','','','',1,0,1,'','','',1529042764,0),(551,517,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(552,517,'','手镯/手链/脚链','','','','',1,0,1,'','','',1529042764,0),(553,517,'','戒指','','','','',1,0,1,'','','',1529042764,0),(554,517,'','头饰/胸针','','','','',1,0,1,'','','',1529042764,0),(555,517,'','摆件/挂件','','','','',1,0,1,'','','',1529042764,0),(556,518,'','项链/吊坠','','','','',1,0,1,'','','',1529042764,0),(557,518,'','耳饰','','','','',1,0,1,'','','',1529042764,0),(558,518,'','手镯/手链','','','','',1,0,1,'','','',1529042764,0),(559,518,'','戒指','','','','',1,0,1,'','','',1529042764,0),(560,519,'','婚嫁首饰','','','','',1,0,1,'','','',1529042764,0),(561,519,'','婚纱摄影','','','','',1,0,1,'','','',1529042764,0),(562,519,'','婚纱礼服','','','','',1,0,1,'','','',1529042764,0),(563,519,'','婚庆服务','','','','',1,0,1,'','','',1529042764,0),(564,519,'','婚庆礼品/用品','','','','',1,0,1,'','','',1529042764,0),(565,519,'','婚宴','','','','',1,0,1,'','','',1529042764,0),(566,520,'','瑞士品牌','','','','',1,0,1,'','','',1529042764,0),(567,520,'','国产品牌','','','','',1,0,1,'','','',1529042764,0),(568,520,'','日本品牌','','','','',1,0,1,'','','',1529042764,0),(569,520,'','时尚品牌','','','','',1,0,1,'','','',1529042764,0),(570,520,'','闹钟挂钟','','','','',1,0,1,'','','',1529042764,0),(571,520,'','儿童手表','','','','',1,0,1,'','','',1529042764,0),(572,53,'','户外鞋服','','','','',1,0,1,'','','',1529042764,0),(573,53,'','户外装备','','','','',1,0,1,'','','',1529042764,0),(574,53,'','运动器械','','','','',1,0,1,'','','',1529042764,0),(575,53,'','纤体瑜伽','','','','',1,0,1,'','','',1529042764,0),(576,53,'','体育娱乐','','','','',1,0,1,'','','',1529042764,0),(577,53,'','成人用品','','','','',1,0,1,'','','',1529042764,0),(578,53,'','保健器械','','','','',1,0,1,'','','',1529042764,0),(579,53,'','急救卫生','','','','',1,0,1,'','','',1529042764,0),(580,572,'','户外服装','','','','',1,0,1,'','','',1529042764,0),(581,572,'','户外鞋袜','','','','',1,0,1,'','','',1529042764,0),(582,572,'','户外配饰','','','','',1,0,1,'','','',1529042764,0),(583,573,'','帐篷','','','','',1,0,1,'','','',1529042764,0),(584,573,'','睡袋','','','','',1,0,1,'','','',1529042764,0),(585,573,'','登山攀岩','','','','',1,0,1,'','','',1529042764,0),(586,573,'','户外背包','','','','',1,0,1,'','','',1529042764,0),(587,573,'','户外照明','','','','',1,0,1,'','','',1529042764,0),(588,573,'','户外垫子','','','','',1,0,1,'','','',1529042764,0),(589,573,'','户外仪表','','','','',1,0,1,'','','',1529042764,0),(590,573,'','户外工具','','','','',1,0,1,'','','',1529042764,0),(591,573,'','望远镜','','','','',1,0,1,'','','',1529042764,0),(592,573,'','垂钓用品','','','','',1,0,1,'','','',1529042764,0),(593,573,'','旅游用品','','','','',1,0,1,'','','',1529042764,0),(594,573,'','便携桌椅床','','','','',1,0,1,'','','',1529042764,0),(595,573,'','烧烤用品','','','','',1,0,1,'','','',1529042764,0),(596,573,'','野餐炊具','','','','',1,0,1,'','','',1529042764,0),(597,573,'','军迷用品','','','','',1,0,1,'','','',1529042764,0),(598,573,'','游泳用具','','','','',1,0,1,'','','',1529042764,0),(599,573,'','泳衣','','','','',1,0,1,'','','',1529042764,0),(600,574,'','健身器械','','','','',1,0,1,'','','',1529042764,0),(601,574,'','运动器材','','','','',1,0,1,'','','',1529042764,0),(602,574,'','极限轮滑','','','','',1,0,1,'','','',1529042764,0),(603,574,'','骑行运动','','','','',1,0,1,'','','',1529042764,0),(604,574,'','运动护具','','','','',1,0,1,'','','',1529042764,0),(605,574,'','武术搏击','','','','',1,0,1,'','','',1529042764,0),(606,575,'','瑜伽垫','','','','',1,0,1,'','','',1529042764,0),(607,575,'','瑜伽服','','','','',1,0,1,'','','',1529042764,0),(608,575,'','瑜伽配件','','','','',1,0,1,'','','',1529042764,0),(609,575,'','瑜伽套装','','','','',1,0,1,'','','',1529042764,0),(610,575,'','舞蹈鞋服','','','','',1,0,1,'','','',1529042764,0),(611,576,'','羽毛球','','','','',1,0,1,'','','',1529042764,0),(612,576,'','乒乓球','','','','',1,0,1,'','','',1529042764,0),(613,576,'','篮球','','','','',1,0,1,'','','',1529042764,0),(614,576,'','足球','','','','',1,0,1,'','','',1529042764,0),(615,576,'','网球','','','','',1,0,1,'','','',1529042764,0),(616,576,'','排球','','','','',1,0,1,'','','',1529042764,0),(617,576,'','高尔夫球','','','','',1,0,1,'','','',1529042764,0),(618,576,'','棋牌麻将','','','','',1,0,1,'','','',1529042764,0),(619,576,'','其他','','','','',1,0,1,'','','',1529042764,0),(620,577,'','安全避孕','','','','',1,0,1,'','','',1529042764,0),(621,577,'','验孕测孕','','','','',1,0,1,'','','',1529042764,0),(622,577,'','人体润滑','','','','',1,0,1,'','','',1529042764,0),(623,577,'','情爱玩具','','','','',1,0,1,'','','',1529042764,0),(624,577,'','情趣内衣','','','','',1,0,1,'','','',1529042764,0),(625,577,'','组合套装','','','','',1,0,1,'','','',1529042764,0),(626,578,'','养生器械','','','','',1,0,1,'','','',1529042764,0),(627,578,'','保健用品','','','','',1,0,1,'','','',1529042764,0),(628,578,'','康复辅助','','','','',1,0,1,'','','',1529042764,0),(629,578,'','家庭护理','','','','',1,0,1,'','','',1529042764,0),(630,579,'','跌打损伤','','','','',1,0,1,'','','',1529042764,0),(631,579,'','烫伤止痒','','','','',1,0,1,'','','',1529042764,0),(632,579,'','防裂抗冻','','','','',1,0,1,'','','',1529042764,0),(633,579,'','口腔咽部','','','','',1,0,1,'','','',1529042764,0),(634,579,'','眼部保健','','','','',1,0,1,'','','',1529042764,0),(635,579,'','鼻炎健康','','','','',1,0,1,'','','',1529042764,0),(636,579,'','风湿骨痛','','','','',1,0,1,'','','',1529042764,0),(637,579,'','生殖泌尿','','','','',1,0,1,'','','',1529042764,0),(638,579,'','美体塑身','','','','',1,0,1,'','','',1529042764,0),(639,54,'','电子电器','','','','',1,0,1,'','','',1529042764,0),(640,54,'','系统养护','','','','',1,0,1,'','','',1529042764,0),(641,54,'','改装配件','','','','',1,0,1,'','','',1529042764,0),(642,54,'','汽车美容','','','','',1,0,1,'','','',1529042764,0),(643,54,'','座垫脚垫','','','','',1,0,1,'','','',1529042764,0),(644,54,'','内饰精品','','','','',1,0,1,'','','',1529042764,0),(645,54,'','安全自驾','','','','',1,0,1,'','','',1529042764,0),(646,54,'','整车','','','','',1,0,1,'','','',1529042764,0),(647,639,'','便携GPS导航','','','','',1,0,1,'','','',1529042764,0),(648,639,'','嵌入式导航','','','','',1,0,1,'','','',1529042764,0),(649,639,'','安全预警仪','','','','',1,0,1,'','','',1529042764,0),(650,639,'','行车记录仪','','','','',1,0,1,'','','',1529042764,0),(651,639,'','跟踪防盗器','','','','',1,0,1,'','','',1529042764,0),(652,639,'','倒车雷达','','','','',1,0,1,'','','',1529042764,0),(653,639,'','车载电源','','','','',1,0,1,'','','',1529042764,0),(654,639,'','车载蓝牙','','','','',1,0,1,'','','',1529042764,0),(655,639,'','车载影音','','','','',1,0,1,'','','',1529042764,0),(656,639,'','车载净化器','','','','',1,0,1,'','','',1529042764,0),(657,639,'','车载冰箱','','','','',1,0,1,'','','',1529042764,0),(658,639,'','车载吸尘器','','','','',1,0,1,'','','',1529042764,0),(659,639,'','充气泵','','','','',1,0,1,'','','',1529042764,0),(660,639,'','胎压监测','','','','',1,0,1,'','','',1529042764,0),(661,639,'','车载生活电器','','','','',1,0,1,'','','',1529042764,0),(662,640,'','机油','','','','',1,0,1,'','','',1529042764,0),(663,640,'','添加剂','','','','',1,0,1,'','','',1529042764,0),(664,640,'','防冻冷却液','','','','',1,0,1,'','','',1529042764,0),(665,640,'','附属油','','','','',1,0,1,'','','',1529042764,0),(666,640,'','底盘装甲','','','','',1,0,1,'','','',1529042764,0),(667,640,'','空调清洗剂','','','','',1,0,1,'','','',1529042764,0),(668,640,'','金属养护','','','','',1,0,1,'','','',1529042764,0),(669,641,'','雨刷','','','','',1,0,1,'','','',1529042764,0),(670,641,'','车灯','','','','',1,0,1,'','','',1529042764,0),(671,641,'','轮胎','','','','',1,0,1,'','','',1529042764,0),(672,641,'','贴膜','','','','',1,0,1,'','','',1529042764,0),(673,641,'','装饰贴','','','','',1,0,1,'','','',1529042764,0),(674,641,'','后视镜','','','','',1,0,1,'','','',1529042764,0),(675,641,'','机油滤','','','','',1,0,1,'','','',1529042764,0),(676,641,'','空气滤','','','','',1,0,1,'','','',1529042764,0),(677,641,'','空调滤','','','','',1,0,1,'','','',1529042764,0),(678,641,'','燃油滤','','','','',1,0,1,'','','',1529042764,0),(679,641,'','火花塞','','','','',1,0,1,'','','',1529042764,0),(680,641,'','喇叭','','','','',1,0,1,'','','',1529042764,0),(681,641,'','刹车片','','','','',1,0,1,'','','',1529042764,0),(682,641,'','刹车盘','','','','',1,0,1,'','','',1529042764,0),(683,641,'','减震器','','','','',1,0,1,'','','',1529042764,0),(684,641,'','车身装饰','','','','',1,0,1,'','','',1529042764,0),(685,641,'','尾喉/排气管','','','','',1,0,1,'','','',1529042764,0),(686,641,'','踏板','','','','',1,0,1,'','','',1529042764,0),(687,641,'','蓄电池','','','','',1,0,1,'','','',1529042764,0),(688,641,'','其他配件','','','','',1,0,1,'','','',1529042764,0),(689,642,'','漆面美容','','','','',1,0,1,'','','',1529042764,0),(690,642,'','漆面修复','','','','',1,0,1,'','','',1529042764,0),(691,642,'','内饰清洁','','','','',1,0,1,'','','',1529042764,0),(692,642,'','玻璃美容','','','','',1,0,1,'','','',1529042764,0),(693,642,'','补漆笔','','','','',1,0,1,'','','',1529042764,0),(694,642,'','轮胎轮毂清洗','','','','',1,0,1,'','','',1529042764,0),(695,642,'','洗车器','','','','',1,0,1,'','','',1529042764,0),(696,642,'','洗车水枪','','','','',1,0,1,'','','',1529042764,0),(697,642,'','洗车配件','','','','',1,0,1,'','','',1529042764,0),(698,642,'','洗车液','','','','',1,0,1,'','','',1529042764,0),(699,642,'','车掸','','','','',1,0,1,'','','',1529042764,0),(700,642,'','擦车巾/海绵','','','','',1,0,1,'','','',1529042764,0),(701,643,'','凉垫','','','','',1,0,1,'','','',1529042764,0),(702,643,'','四季垫','','','','',1,0,1,'','','',1529042764,0),(703,643,'','毛垫','','','','',1,0,1,'','','',1529042764,0),(704,643,'','专车专用座垫','','','','',1,0,1,'','','',1529042764,0),(705,643,'','专车专用座套','','','','',1,0,1,'','','',1529042764,0),(706,643,'','通用座套','','','','',1,0,1,'','','',1529042764,0),(707,643,'','多功能垫','','','','',1,0,1,'','','',1529042764,0),(708,643,'','专车专用脚垫','','','','',1,0,1,'','','',1529042764,0),(709,643,'','通用脚垫','','','','',1,0,1,'','','',1529042764,0),(710,643,'','后备箱垫','','','','',1,0,1,'','','',1529042764,0),(711,644,'','车用香水','','','','',1,0,1,'','','',1529042764,0),(712,644,'','车用炭包','','','','',1,0,1,'','','',1529042764,0),(713,644,'','空气净化','','','','',1,0,1,'','','',1529042764,0),(714,644,'','颈枕/头枕','','','','',1,0,1,'','','',1529042764,0),(715,644,'','抱枕/腰靠','','','','',1,0,1,'','','',1529042764,0),(716,644,'','方向盘套','','','','',1,0,1,'','','',1529042764,0),(717,644,'','挂件','','','','',1,0,1,'','','',1529042764,0),(718,644,'','摆件','','','','',1,0,1,'','','',1529042764,0),(719,644,'','布艺软饰','','','','',1,0,1,'','','',1529042764,0),(720,644,'','功能用品','','','','',1,0,1,'','','',1529042764,0),(721,644,'','整理收纳','','','','',1,0,1,'','','',1529042764,0),(722,644,'','CD夹','','','','',1,0,1,'','','',1529042764,0),(723,645,'','儿童安全座椅','','','','',1,0,1,'','','',1529042764,0),(724,645,'','应急救援','','','','',1,0,1,'','','',1529042764,0),(725,645,'','汽修工具','','','','',1,0,1,'','','',1529042764,0),(726,645,'','自驾野营','','','','',1,0,1,'','','',1529042764,0),(727,645,'','自驾照明','','','','',1,0,1,'','','',1529042764,0),(728,645,'','保温箱','','','','',1,0,1,'','','',1529042764,0),(729,645,'','置物箱','','','','',1,0,1,'','','',1529042764,0),(730,645,'','车衣','','','','',1,0,1,'','','',1529042764,0),(731,645,'','遮阳挡雪挡','','','','',1,0,1,'','','',1529042764,0),(732,645,'','车锁地锁','','','','',1,0,1,'','','',1529042764,0),(733,645,'','摩托车装备','','','','',1,0,1,'','','',1529042764,0),(734,646,'','新车','','','','',1,0,1,'','','',1529042764,0),(735,646,'','二手车','','','','',1,0,1,'','','',1529042764,0),(736,55,'','适用年龄','','','','',1,0,1,'','','',1529042764,0),(737,55,'','遥控/电动','','','','',1,0,1,'','','',1529042764,0),(738,55,'','毛绒布艺','','','','',1,0,1,'','','',1529042764,0),(739,55,'','娃娃玩具','','','','',1,0,1,'','','',1529042764,0),(740,55,'','模型玩具','','','','',1,0,1,'','','',1529042764,0),(741,55,'','健身玩具','','','','',1,0,1,'','','',1529042764,0),(742,55,'','动漫玩具','','','','',1,0,1,'','','',1529042764,0),(743,55,'','益智玩具','','','','',1,0,1,'','','',1529042764,0),(744,55,'','积木拼插','','','','',1,0,1,'','','',1529042764,0),(745,55,'','DIY玩具','','','','',1,0,1,'','','',1529042764,0),(746,55,'','创意减压','','','','',1,0,1,'','','',1529042764,0),(747,55,'','乐器相关','','','','',1,0,1,'','','',1529042764,0),(748,736,'','0-6个月','','','','',1,0,1,'','','',1529042764,0),(749,736,'','6-12个月','','','','',1,0,1,'','','',1529042764,0),(750,736,'','1-3岁','','','','',1,0,1,'','','',1529042764,0),(751,736,'','3-6岁','','','','',1,0,1,'','','',1529042764,0),(752,736,'','6-14岁','','','','',1,0,1,'','','',1529042764,0),(753,736,'','14岁以上','','','','',1,0,1,'','','',1529042764,0),(754,737,'','遥控车','','','','',1,0,1,'','','',1529042764,0),(755,737,'','遥控飞机','','','','',1,0,1,'','','',1529042764,0),(756,737,'','遥控船','','','','',1,0,1,'','','',1529042764,0),(757,737,'','机器人/电动','','','','',1,0,1,'','','',1529042764,0),(758,737,'','轨道/助力','','','','',1,0,1,'','','',1529042764,0),(759,738,'','毛绒/布艺','','','','',1,0,1,'','','',1529042764,0),(760,738,'','靠垫/抱枕','','','','',1,0,1,'','','',1529042764,0),(761,739,'','芭比娃娃','','','','',1,0,1,'','','',1529042764,0),(762,739,'','卡通娃娃','','','','',1,0,1,'','','',1529042764,0),(763,739,'','智能娃娃','','','','',1,0,1,'','','',1529042764,0),(764,740,'','仿真模型','','','','',1,0,1,'','','',1529042764,0),(765,740,'','拼插模型','','','','',1,0,1,'','','',1529042764,0),(766,740,'','收藏爱好','','','','',1,0,1,'','','',1529042764,0),(767,741,'','炫舞毯','','','','',1,0,1,'','','',1529042764,0),(768,741,'','爬行垫/毯','','','','',1,0,1,'','','',1529042764,0),(769,741,'','户外玩具','','','','',1,0,1,'','','',1529042764,0),(770,741,'','戏水玩具','','','','',1,0,1,'','','',1529042764,0),(771,742,'','电影周边','','','','',1,0,1,'','','',1529042764,0),(772,742,'','卡通周边','','','','',1,0,1,'','','',1529042764,0),(773,742,'','网游周边','','','','',1,0,1,'','','',1529042764,0),(774,743,'','摇铃/床铃','','','','',1,0,1,'','','',1529042764,0),(775,743,'','健身架','','','','',1,0,1,'','','',1529042764,0),(776,743,'','早教启智','','','','',1,0,1,'','','',1529042764,0),(777,743,'','拖拉玩具','','','','',1,0,1,'','','',1529042764,0),(778,744,'','积木','','','','',1,0,1,'','','',1529042764,0),(779,744,'','拼图','','','','',1,0,1,'','','',1529042764,0),(780,744,'','磁力棒','','','','',1,0,1,'','','',1529042764,0),(781,744,'','立体拼插','','','','',1,0,1,'','','',1529042764,0),(782,745,'','手工彩泥','','','','',1,0,1,'','','',1529042764,0),(783,745,'','绘画工具','','','','',1,0,1,'','','',1529042764,0),(784,745,'','情景玩具','','','','',1,0,1,'','','',1529042764,0),(785,746,'','减压玩具','','','','',1,0,1,'','','',1529042764,0),(786,746,'','创意玩具','','','','',1,0,1,'','','',1529042764,0),(787,747,'','钢琴','','','','',1,0,1,'','','',1529042764,0),(788,747,'','电子琴','','','','',1,0,1,'','','',1529042764,0),(789,747,'','手风琴','','','','',1,0,1,'','','',1529042764,0),(790,747,'','吉他/贝斯','','','','',1,0,1,'','','',1529042764,0),(791,747,'','民族管弦乐器','','','','',1,0,1,'','','',1529042764,0),(792,747,'','西洋管弦乐','','','','',1,0,1,'','','',1529042764,0),(793,747,'','口琴/口风琴/竖笛','','','','',1,0,1,'','','',1529042764,0),(794,747,'','西洋打击乐器','','','','',1,0,1,'','','',1529042764,0),(795,747,'','各式乐器配件','','','','',1,0,1,'','','',1529042764,0),(796,747,'','电脑音乐','','','','',1,0,1,'','','',1529042764,0),(797,747,'','工艺礼品乐器','','','','',1,0,1,'','','',1529042764,0),(798,56,'','奶粉','','','','',1,0,1,'','','',1529042764,0),(799,56,'','营养辅食','','','','',1,0,1,'','','',1529042764,0),(800,56,'','尿裤湿巾','','','','',1,0,1,'','','',1529042764,0),(801,56,'','喂养用品','','','','',1,0,1,'','','',1529042764,0),(802,56,'','洗护用品','','','','',1,0,1,'','','',1529042764,0),(803,56,'','童车童床','','','','',1,0,1,'','','',1529042764,0),(804,56,'','服饰寝居','','','','',1,0,1,'','','',1529042764,0),(805,56,'','妈妈专区','','','','',1,0,1,'','','',1529042764,0),(806,798,'','品牌奶粉','','','','',1,0,1,'','','',1529042764,0),(807,798,'','妈妈奶粉','','','','',1,0,1,'','','',1529042764,0),(808,798,'','1段奶粉','','','','',1,0,1,'','','',1529042764,0),(809,798,'','2段奶粉','','','','',1,0,1,'','','',1529042764,0),(810,798,'','3段奶粉','','','','',1,0,1,'','','',1529042764,0),(811,798,'','4段奶粉','','','','',1,0,1,'','','',1529042764,0),(812,798,'','羊奶粉','','','','',1,0,1,'','','',1529042764,0),(813,798,'','特殊配方','','','','',1,0,1,'','','',1529042764,0),(814,798,'','成人奶粉','','','','',1,0,1,'','','',1529042764,0),(815,799,'','婴幼营养','','','','',1,0,1,'','','',1529042764,0),(816,799,'','初乳','','','','',1,0,1,'','','',1529042764,0),(817,799,'','米粉/菜粉','','','','',1,0,1,'','','',1529042764,0),(818,799,'','果泥/果汁','','','','',1,0,1,'','','',1529042764,0),(819,799,'','肉松/饼干','','','','',1,0,1,'','','',1529042764,0),(820,799,'','辅食','','','','',1,0,1,'','','',1529042764,0),(821,799,'','孕期营养','','','','',1,0,1,'','','',1529042764,0),(822,799,'','清火/开胃','','','','',1,0,1,'','','',1529042764,0),(823,799,'','面条/粥','','','','',1,0,1,'','','',1529042764,0),(824,800,'','品牌尿裤','','','','',1,0,1,'','','',1529042764,0),(825,800,'','新生儿','','','','',1,0,1,'','','',1529042764,0),(826,800,'','S号','','','','',1,0,1,'','','',1529042764,0),(827,800,'','M号','','','','',1,0,1,'','','',1529042764,0),(828,800,'','L号','','','','',1,0,1,'','','',1529042764,0),(829,800,'','XL/XXL号','','','','',1,0,1,'','','',1529042764,0),(830,800,'','裤型尿裤','','','','',1,0,1,'','','',1529042764,0),(831,800,'','湿巾','','','','',1,0,1,'','','',1529042764,0),(832,800,'','尿布/尿垫','','','','',1,0,1,'','','',1529042764,0),(833,800,'','成人尿裤','','','','',1,0,1,'','','',1529042764,0),(834,801,'','奶瓶','','','','',1,0,1,'','','',1529042764,0),(835,801,'','奶嘴','','','','',1,0,1,'','','',1529042764,0),(836,801,'','吸奶器','','','','',1,0,1,'','','',1529042764,0),(837,801,'','暖奶/消毒','','','','',1,0,1,'','','',1529042764,0),(838,801,'','餐具','','','','',1,0,1,'','','',1529042764,0),(839,801,'','水具','','','','',1,0,1,'','','',1529042764,0),(840,801,'','牙胶/安抚','','','','',1,0,1,'','','',1529042764,0),(841,801,'','辅助用品','','','','',1,0,1,'','','',1529042764,0),(842,802,'','宝宝护肤','','','','',1,0,1,'','','',1529042764,0),(843,802,'','洗浴用品','','','','',1,0,1,'','','',1529042764,0),(844,802,'','洗发沐浴','','','','',1,0,1,'','','',1529042764,0),(845,802,'','清洁用品','','','','',1,0,1,'','','',1529042764,0),(846,802,'','护理用品','','','','',1,0,1,'','','',1529042764,0),(847,802,'','妈妈护肤','','','','',1,0,1,'','','',1529042764,0),(848,803,'','婴儿推车','','','','',1,0,1,'','','',1529042764,0),(849,803,'','餐椅摇椅','','','','',1,0,1,'','','',1529042764,0),(850,803,'','婴儿床','','','','',1,0,1,'','','',1529042764,0),(851,803,'','学步车','','','','',1,0,1,'','','',1529042764,0),(852,803,'','三轮车','','','','',1,0,1,'','','',1529042764,0),(853,803,'','自行车','','','','',1,0,1,'','','',1529042764,0),(854,803,'','电动车','','','','',1,0,1,'','','',1529042764,0),(855,803,'','健身车','','','','',1,0,1,'','','',1529042764,0),(856,803,'','安全座椅','','','','',1,0,1,'','','',1529042764,0),(857,804,'','婴儿外出服','','','','',1,0,1,'','','',1529042764,0),(858,804,'','婴儿内衣','','','','',1,0,1,'','','',1529042764,0),(859,804,'','婴儿礼盒','','','','',1,0,1,'','','',1529042764,0),(860,804,'','婴儿鞋帽袜','','','','',1,0,1,'','','',1529042764,0),(861,804,'','安全防护','','','','',1,0,1,'','','',1529042764,0),(862,804,'','家居床品','','','','',1,0,1,'','','',1529042764,0),(863,804,'','其他','','','','',1,0,1,'','','',1529042764,0),(864,805,'','包/背婴带','','','','',1,0,1,'','','',1529042764,0),(865,805,'','妈妈护理','','','','',1,0,1,'','','',1529042764,0),(866,805,'','产后塑身','','','','',1,0,1,'','','',1529042764,0),(867,805,'','孕妇内衣','','','','',1,0,1,'','','',1529042764,0),(868,805,'','防辐射服','','','','',1,0,1,'','','',1529042764,0),(869,805,'','孕妇装','','','','',1,0,1,'','','',1529042764,0),(870,805,'','孕妇食品','','','','',1,0,1,'','','',1529042764,0),(871,805,'','妈妈美容','','','','',1,0,1,'','','',1529042764,0),(872,57,'','餐饮娱乐','','','','',1,0,1,'','','',1529042764,0),(873,57,'','婚纱旅游','','','','',1,0,1,'','','',1529042764,0),(874,57,'','便民充值','','','','',1,0,1,'','','',1529042764,0),(875,57,'','游戏充值','','','','',1,0,1,'','','',1529042764,0),(876,57,'','票务服务','','','','',1,0,1,'','','',1529042764,0),(877,872,'','美食','','','','',1,0,1,'','','',1529042764,0),(878,872,'','电影票','','','','',1,0,1,'','','',1529042764,0),(879,872,'','自助餐','','','','',1,0,1,'','','',1529042764,0),(880,872,'','火锅','','','','',1,0,1,'','','',1529042764,0),(881,873,'','浪漫婚纱','','','','',1,0,1,'','','',1529042764,0),(882,873,'','旅游踏青','','','','',1,0,1,'','','',1529042764,0),(883,874,'','礼品卡','','','','',1,0,1,'','','',1529042764,0),(884,874,'','手机充值','','','','',1,0,1,'','','',1529042764,0),(885,875,'','游戏点卡','','','','',1,0,1,'','','',1529042764,0),(886,875,'','QQ充值','','','','',1,0,1,'','','',1529042764,0),(887,876,'','代金券','','','','',1,0,1,'','','',1529042764,0),(888,876,'','演唱会','','','','',1,0,1,'','','',1529042764,0),(889,876,'','话剧/歌剧/音乐剧','','','','',1,0,1,'','','',1529042764,0),(890,876,'','体育赛事','','','','',1,0,1,'','','',1529042764,0),(891,876,'','舞蹈芭蕾','','','','',1,0,1,'','','',1529042764,0),(892,876,'','戏曲综艺','','','','',1,0,1,'','','',1529042764,0);
/*!40000 ALTER TABLE `sxo_goods_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_category_join`
--

DROP TABLE IF EXISTS `sxo_goods_category_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_category_join` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1084 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品分类关联';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_category_join`
--

LOCK TABLES `sxo_goods_category_join` WRITE;
/*!40000 ALTER TABLE `sxo_goods_category_join` DISABLE KEYS */;
INSERT INTO `sxo_goods_category_join` VALUES (10,5,68,1547452798),(11,5,69,1547452798),(299,1,68,1574168666),(300,1,304,1574168666),(479,6,1,1594957734),(581,9,363,1599803472),(582,3,68,1600151429),(583,3,69,1600151429),(584,3,305,1600151429),(585,4,68,1600151450),(586,4,69,1600151450),(587,4,318,1600151450),(726,10,304,1606792889),(727,10,318,1606792889),(728,10,446,1606792889),(765,2,68,1609742103),(766,2,69,1609742103),(767,2,304,1609742103),(774,11,304,1610109196),(775,11,318,1610109196),(889,30,68,1611575535),(890,30,69,1611575535),(891,30,70,1611575535),(892,30,59,1611575535),(893,30,74,1611575535),(970,31,69,1611715921),(971,31,70,1611715921),(979,16,58,1611731836),(980,17,68,1612336141),(1013,20,69,1613830281),(1023,18,58,1614961172),(1024,18,70,1614961172),(1026,19,58,1614961233),(1044,15,894,1617348307),(1065,14,894,1617793553),(1066,13,1,1617863644),(1073,12,53,1618455784),(1074,12,611,1618455784),(1075,12,612,1618455784),(1082,8,706,1618474163),(1083,7,706,1618474163);
/*!40000 ALTER TABLE `sxo_goods_category_join` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_comments`
--

DROP TABLE IF EXISTS `sxo_goods_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '业务订单id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `business_type` char(30) NOT NULL DEFAULT '' COMMENT '业务类型名称（如订单 order）',
  `content` char(255) NOT NULL DEFAULT '' COMMENT '评价内容',
  `images` text COMMENT '图片数据（一维数组json）',
  `reply` char(255) NOT NULL DEFAULT '' COMMENT '回复内容',
  `rating` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '评价级别（默认0 1~5）',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示（0否, 1是）',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名（0否，1是）',
  `is_reply` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否回复（0否，1是）',
  `reply_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品评论';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_comments`
--

LOCK TABLES `sxo_goods_comments` WRITE;
/*!40000 ALTER TABLE `sxo_goods_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_goods_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_content_app`
--

DROP TABLE IF EXISTS `sxo_goods_content_app`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_content_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `images` char(255) NOT NULL DEFAULT '' COMMENT '图片',
  `content` text COMMENT '内容',
  `sort` tinyint(3) unsigned DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=1113 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品手机详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_content_app`
--

LOCK TABLES `sxo_goods_content_app` WRITE;
/*!40000 ALTER TABLE `sxo_goods_content_app` DISABLE KEYS */;
INSERT INTO `sxo_goods_content_app` VALUES (17,5,'/static/upload/images/goods/2019/01/14/1547452760417982.jpg','',0,1547452798),(18,5,'/static/upload/images/goods/2019/01/14/1547452760984656.jpg','',1,1547452798),(19,5,'/static/upload/images/goods/2019/01/14/1547452760659259.jpg','',2,1547452798),(135,7,'/static/upload/images/goods/2019/01/14/1547453910353340.jpg','',0,1554485498),(136,7,'/static/upload/images/goods/2019/01/14/1547453910505349.jpg','',1,1554485498),(137,7,'/static/upload/images/goods/2019/01/14/1547453910394886.jpg','',2,1554485498),(507,1,'/static/upload/images/goods/2019/01/14/1547450880620837.png','',0,1574168666),(508,1,'/static/upload/images/goods/2019/01/14/1547450880750687.png','',1,1574168666),(509,1,'/static/upload/images/goods/2019/01/14/1547450880917418.png','',2,1574168666),(737,6,'/static/upload/images/goods/2019/01/14/1547453042405182.jpg','X5L/SL/V/M (5.0寸)  X5max钢化膜(5.5寸)  X5pro钢化膜(5.2寸)',0,1594957734),(738,6,'/static/upload/images/goods/2019/01/14/1547453042614480.jpg','',1,1594957734),(739,6,'/static/upload/images/goods/2019/01/14/1547453042816509.jpg','',2,1594957734),(843,9,'/static/upload/images/goods/2019/01/14/1547454712270511.jpg','',0,1599803472),(844,9,'/static/upload/images/goods/2019/01/14/1547454713556301.jpg','',1,1599803472),(845,9,'/static/upload/images/goods/2019/01/14/1547454713800333.jpg','',2,1599803472),(846,9,'/static/upload/images/goods/2019/01/14/1547454713456602.jpg','',3,1599803472),(847,3,'/static/upload/images/goods/2019/01/14/1547451947383902.jpg','',0,1600151429),(848,3,'/static/upload/images/goods/2019/01/14/1547451947686990.jpg','',1,1600151429),(849,3,'/static/upload/images/goods/2019/01/14/1547451947676180.jpg','',2,1600151429),(850,3,'/static/upload/images/goods/2019/01/14/1547451947791154.jpg','',3,1600151429),(851,4,'/static/upload/images/goods/2019/01/14/1547452505568604.jpg','',0,1600151450),(852,4,'/static/upload/images/goods/2019/01/14/1547452505349986.jpg','',1,1600151450),(853,4,'/static/upload/images/goods/2019/01/14/1547452505184884.jpg','',2,1600151450),(1023,10,'/static/upload/images/goods/2019/01/14/1547455266527628.jpg','【品牌】欧单 学媛风 猫咪良品\n\n【吊牌】xueyuanfeng 猫咪良品\n\n【面料质地】涤棉拼接蕾丝  后中拉链 有内衬（非专业机构鉴定，介意请慎拍）\n\n好的衣服需要好好呵护，务必请冷水手洗(切记别浸泡)拧干就晾晒或则干洗哦~\n\n【商品颜色】实物拍摄 蓝色 颜色很难拍有小色差属正常现象哦\n\n【商品尺寸】XS/S/M/L 小高腰设计 胸口纽扣是装饰的哦\n\n\nXS码尺寸: 悬挂衣长81CM.胸围80内合适.腰围63CM.臀围86CM\n\nS码尺寸: 悬挂衣长82CM.胸围84内合适.腰围67CM.臀围90CM\n\nM码尺寸: 悬挂衣长83CM.胸围88内合适.腰围71CM.臀围94CM\n\nL码尺寸: 悬挂衣长84CM.胸围92内合适.腰围75CM.臀围98CM\n\n\n（测量单位是CM，每个人的测量方式不一样，测量的尺寸数据可能会有1~3厘米的差异，请MM们谅解哦）\n\n\nPS：常规码数，可按平时号选择哦。修身版型~如果上身偏大可以适当考虑大1号~下摆蕾丝拼接不会很平整的哦~\n\n蕾丝花是手工修剪出来的，每件都有不同和不规则的哦，有小线头和节点是正常现象哦~请亲们谅解哦~',0,1606792889),(1024,10,'/static/upload/images/goods/2019/01/14/1547455266234658.jpg','',1,1606792889),(1073,2,'/static/upload/images/goods/2019/01/14/1547451595700972.jpg','',0,1609742104),(1074,2,'/static/upload/images/goods/2019/01/14/1547451595528800.jpg','',1,1609742104),(1075,2,'/static/upload/images/goods/2019/01/14/1547451595616298.jpg','',2,1609742104),(1079,11,'/static/upload/images/goods/2019/01/14/1547455601314107.jpg','【品牌】欧单 学媛风 猫咪良品\n\n【吊牌】xueyuanfeng 猫咪良品\n\n【面料质地】网纱绣花钉珠拼接蕾丝 有拉链有内衬（非专业机构鉴定，介意请慎拍）\n\n好的衣服需要好好呵护，务必请冷水手洗(切记别浸泡)拧干就晾晒或则干洗哦~\n\n【商品颜色】实物拍摄 香槟色 颜色很难拍有小色差属正常现象哦\n\n【商品尺寸】XS/S/M/L 小高腰设计 胸那考虑撑开因素哦 微弹的哦\n\n\nXS码尺寸: 衣长82CM.胸围80内合适.腰围63CM.臀围86CM\n\nS码尺寸: 衣长83CM.胸围84内合适.腰围67CM.臀围90CM\n\nM码尺寸: 衣长84CM.胸围88内合适.腰围71CM.臀围94CM\n\nL码尺寸: 衣长85CM.胸围92内合适.腰围75CM.臀围98CM\n\n\n（测量单位是CM，每个人的测量方式不一样，测量的尺寸数据可能会有1~3厘米的差异，请MM们谅解哦）\n\n\nPS：常规码数，可按平时号选择哦。修身版型，如果腰粗可以适当考虑大1号哦~\n\n大圆领，每个人的身材曲线不同，领口不会很平的哦，请谅解~\n\n肩膀那有暗扣哦，可以很好的隐藏了内衣的肩带哦~袖子那略硬哦~',0,1610109196),(1080,11,'/static/upload/images/goods/2019/01/14/1547455601168384.jpg','',1,1610109196),(1081,11,'/static/upload/images/goods/2019/01/14/1547455601898622.jpg','',2,1610109196),(1082,11,'/static/upload/images/goods/2019/01/14/1547455601528614.jpg','',3,1610109196),(1103,12,'/static/upload/images/goods/2019/01/14/1547456214155362.jpg','每个人都有一个死角， 自己走不出来，别人也闯不进去。\n我把最深沉的秘密放在那里。\n你不懂我，我不怪你。\n每个人都有一道伤口， 或深或浅，盖上布，以为不存在。',0,1618455784),(1104,12,'/static/upload/images/goods/2019/01/14/1547455907486857.jpg','',1,1618455784),(1105,12,'/static/upload/images/goods/2019/01/14/1547455907256518.jpg','',2,1618455784),(1106,12,'/static/upload/images/goods/2019/01/14/1547456228913731.jpg','',3,1618455784),(1110,8,'/static/upload/images/goods/2019/01/14/1547454192301566.jpg','',0,1618468361),(1111,8,'/static/upload/images/goods/2019/01/14/1547454192448116.jpg','',1,1618468361),(1112,8,'/static/upload/images/goods/2019/01/14/1547454192474638.jpg','',2,1618468361);
/*!40000 ALTER TABLE `sxo_goods_content_app` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_favor`
--

DROP TABLE IF EXISTS `sxo_goods_favor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_favor` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户商品收藏';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_favor`
--

LOCK TABLES `sxo_goods_favor` WRITE;
/*!40000 ALTER TABLE `sxo_goods_favor` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_goods_favor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_params`
--

DROP TABLE IF EXISTS `sxo_goods_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_params` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `type` tinyint(1) unsigned DEFAULT '1' COMMENT '展示范围（0全部, 1详情, 2基础）默认1详情',
  `name` char(180) NOT NULL DEFAULT '' COMMENT '参数名称',
  `value` char(230) NOT NULL DEFAULT '' COMMENT '参数值',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `type` (`type`),
  KEY `name` (`name`),
  KEY `value` (`value`)
) ENGINE=InnoDB AUTO_INCREMENT=673 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品参数';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_params`
--

LOCK TABLES `sxo_goods_params` WRITE;
/*!40000 ALTER TABLE `sxo_goods_params` DISABLE KEYS */;
INSERT INTO `sxo_goods_params` VALUES (663,12,0,'流行元素/工艺','树脂固色',1618455784),(664,12,2,'款式','长款连衣裙',1618455784),(665,12,2,'适用年龄','30-34周岁',1618455784),(666,12,1,'图案','纯色',1618455784),(667,12,1,'袖长','短袖',1618455784),(668,12,1,'风格','复古风',1618455784),(669,12,1,'衣门襟','套头',1618455784),(670,12,1,'裙型','大摆型',1618455784),(671,12,1,'组合形式','单件',1618455784),(672,12,0,'款式类别','图案花纹',1618455784);
/*!40000 ALTER TABLE `sxo_goods_params` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_params_template`
--

DROP TABLE IF EXISTS `sxo_goods_params_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_params_template` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `config_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数配置数量',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `config_count` (`config_count`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品参数模板';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_params_template`
--

LOCK TABLES `sxo_goods_params_template` WRITE;
/*!40000 ALTER TABLE `sxo_goods_params_template` DISABLE KEYS */;
INSERT INTO `sxo_goods_params_template` VALUES (1,'测试一下',1,10,1606554077,1606569364);
/*!40000 ALTER TABLE `sxo_goods_params_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_params_template_config`
--

DROP TABLE IF EXISTS `sxo_goods_params_template_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_params_template_config` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `template_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '模板id',
  `type` tinyint(1) unsigned DEFAULT '1' COMMENT '展示范围（0全部, 1详情, 2基础）默认1详情',
  `name` char(180) NOT NULL DEFAULT '' COMMENT '参数名称',
  `value` char(230) NOT NULL DEFAULT '' COMMENT '参数值',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `template_id` (`template_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品参数模板值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_params_template_config`
--

LOCK TABLES `sxo_goods_params_template_config` WRITE;
/*!40000 ALTER TABLE `sxo_goods_params_template_config` DISABLE KEYS */;
INSERT INTO `sxo_goods_params_template_config` VALUES (24,1,2,'款式','长款连衣裙',1606555034),(25,1,0,'流行元素/工艺','树脂固色',1606555034),(26,1,2,'适用年龄','30-34周岁',1606555034),(27,1,1,'图案','纯色',1606555034),(28,1,1,'袖长','短袖',1606555034),(29,1,1,'风格','复古风',1606555034),(30,1,1,'衣门襟','套头',1606555034),(31,1,1,'裙型','大摆型',1606555034),(32,1,1,'组合形式','单件',1606555034),(33,1,0,'款式类别','图案花纹',1606555034);
/*!40000 ALTER TABLE `sxo_goods_params_template_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_photo`
--

DROP TABLE IF EXISTS `sxo_goods_photo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_photo` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `images` char(255) NOT NULL DEFAULT '' COMMENT '图片',
  `is_show` tinyint(3) unsigned DEFAULT '1' COMMENT '是否显示（0否, 1是）',
  `sort` tinyint(3) unsigned DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `is_show` (`is_show`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=865 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品相册图片';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_photo`
--

LOCK TABLES `sxo_goods_photo` WRITE;
/*!40000 ALTER TABLE `sxo_goods_photo` DISABLE KEYS */;
INSERT INTO `sxo_goods_photo` VALUES (11,5,'/static/upload/images/goods/2019/01/14/1547452714324599.jpg',1,0,1547452798),(12,5,'/static/upload/images/goods/2019/01/14/1547452752648264.jpg',1,1,1547452798),(105,7,'/static/upload/images/goods/2019/01/14/1547453895416529.jpg',1,0,1554485498),(106,7,'/static/upload/images/goods/2019/01/14/1547453895864876.jpg',1,1,1554485498),(399,1,'/static/upload/images/goods/2019/01/14/1547450781101144.jpg',1,0,1574168666),(400,1,'/static/upload/images/goods/2019/01/14/1547450818141662.jpg',1,1,1574168666),(581,6,'/static/upload/images/goods/2019/01/14/1547453000703308.jpg',1,0,1594957734),(582,6,'/static/upload/images/goods/2019/01/14/1547453032949003.jpg',1,1,1594957734),(660,9,'/static/upload/images/goods/2019/01/14/1547454702543219.jpg',1,0,1599803472),(661,9,'/static/upload/images/goods/2019/01/14/1547454702272215.jpg',1,1,1599803472),(662,9,'/static/upload/images/goods/2019/01/14/1547454702814719.jpg',1,2,1599803472),(663,3,'/static/upload/images/goods/2019/01/14/1547451909951171.jpg',1,0,1600151429),(664,3,'/static/upload/images/goods/2019/01/14/1547451936230948.jpg',1,1,1600151429),(665,4,'/static/upload/images/goods/2019/01/14/1547452474332334.jpg',1,0,1600151450),(666,4,'/static/upload/images/goods/2019/01/14/1547452496713777.jpg',1,1,1600151450),(797,10,'/static/upload/images/goods/2019/01/14/1547455240794230.jpg',1,0,1606792889),(798,10,'/static/upload/images/goods/2019/01/14/1547455240700820.jpg',1,1,1606792889),(835,2,'/static/upload/images/goods/2019/01/14/1547451274847894.jpg',1,0,1609742104),(836,2,'/static/upload/images/goods/2019/01/14/1547451576558478.jpg',1,1,1609742104),(839,11,'/static/upload/images/goods/2019/01/14/1547455601314107.jpg',1,0,1610109196),(840,11,'/static/upload/images/goods/2019/01/14/1547455601168384.jpg',1,1,1610109196),(841,11,'/static/upload/images/goods/2019/01/14/1547455601898622.jpg',1,2,1610109196),(842,11,'/static/upload/images/goods/2019/01/14/1547455601528614.jpg',1,3,1610109196),(858,12,'/static/upload/images/goods/2019/01/14/1547455890402147.jpg',1,0,1618455784),(859,12,'/static/upload/images/goods/2019/01/14/1547455907256518.jpg',1,1,1618455784),(860,12,'/static/upload/images/goods/2019/01/14/1547455907486857.jpg',1,2,1618455784),(863,8,'/static/upload/images/goods/2019/01/14/1547454145355962.jpg',1,0,1618468361),(864,8,'/static/upload/images/goods/2019/01/14/1547454172213779.jpg',1,1,1618468361);
/*!40000 ALTER TABLE `sxo_goods_photo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_spec_base`
--

DROP TABLE IF EXISTS `sxo_goods_spec_base`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_spec_base` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `inventory` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `weight` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '重量（kg） ',
  `coding` char(80) NOT NULL DEFAULT '' COMMENT '编码',
  `barcode` char(80) NOT NULL DEFAULT '' COMMENT '条形码',
  `original_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '原价',
  `extends` longtext COMMENT '扩展数据(json格式存储)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1432 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品规格基础';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_spec_base`
--

LOCK TABLES `sxo_goods_spec_base` WRITE;
/*!40000 ALTER TABLE `sxo_goods_spec_base` DISABLE KEYS */;
INSERT INTO `sxo_goods_spec_base` VALUES (23,5,2499.00,888888,0.00,'','',3200.00,NULL,1547452798),(155,7,168.00,888888,0.00,'','',760.00,NULL,1554485498),(626,1,2100.00,888888,0.00,'','',3200.00,NULL,1574168666),(909,6,2998.90,888888,0.00,'','',3200.00,'{\"plugins_distribution_rules_1\":\"r|10\\nr|10\\nr|10\",\"plugins_distribution_down_rules_1\":\"\"}',1594957734),(1072,9,120.00,888888,17.00,'','',160.00,'{\"plugins_distribution_rules_1\":\"r|5\",\"plugins_distribution_down_rules_1\":\"\"}',1599803472),(1073,9,120.00,888888,17.00,'','',160.00,NULL,1599803472),(1074,9,120.00,888888,17.00,'','',160.00,NULL,1599803472),(1075,9,120.00,888888,17.00,'','',160.00,NULL,1599803472),(1076,9,136.00,888888,17.00,'','',188.00,NULL,1599803472),(1077,9,136.00,888888,17.00,'','',188.00,NULL,1599803472),(1078,9,136.00,888888,17.00,'','',188.00,NULL,1599803472),(1079,9,158.00,888888,17.00,'','',216.00,NULL,1599803472),(1080,9,158.00,888888,17.00,'','',216.00,NULL,1599803472),(1081,3,3888.00,888888,0.00,'','',6866.00,NULL,1600151429),(1082,4,1999.00,888888,0.00,'','',2300.00,NULL,1600151450),(1320,10,228.00,888888,0.00,'','',568.00,NULL,1606792889),(1393,2,6050.00,888888,12.00,'','',6800.00,'{\"plugins_distribution_rules_1\":\"r|5\",\"plugins_distribution_down_rules_1\":\"\"}',1609742103),(1394,2,6600.00,888888,21.00,'','',7200.00,NULL,1609742104),(1395,2,6800.00,888888,22.00,'','',7600.00,NULL,1609742104),(1396,2,6050.00,888888,23.00,'','',6800.00,NULL,1609742104),(1397,2,6600.00,888888,12.00,'','',7200.00,NULL,1609742104),(1398,2,6800.00,888888,32.00,'','',7600.00,NULL,1609742104),(1399,2,4500.00,888888,23.00,'','',6800.00,NULL,1609742104),(1400,2,4800.00,888888,32.00,'','',6600.00,NULL,1609742104),(1401,2,5500.00,888888,11.00,'','',6000.00,NULL,1609742104),(1403,11,258.00,888888,0.00,'','',268.00,'{\"plugins_distribution_rules_1\":\"r|5\\nr|3\\ns|2\",\"plugins_distribution_down_rules_1\":\"r|10\"}',1610109196),(1404,11,238.00,888888,0.00,'','',343.00,'{\"plugins_distribution_rules_1\":\"r|5\\nr|3\\ns|2\",\"plugins_distribution_down_rules_1\":\"r|1\"}',1610109196),(1405,11,160.00,888888,0.00,'','',422.00,'{\"plugins_distribution_rules_20191202164330784159\":\"r|8\",\"plugins_distribution_rules_20191204113948916981\":\"\"}',1610109196),(1426,12,0.10,888888,0.00,'','',0.00,'{\"plugins_membershiplevelvip_price_1\":\"11\",\"plugins_membershiplevelvip_price_2\":\"22\"}',1618455784),(1427,12,0.10,888888,0.00,'','',0.00,NULL,1618455784),(1428,12,0.10,888888,0.00,'','',0.00,NULL,1618455784),(1429,12,12000.00,888888,0.00,'','',0.00,NULL,1618455784),(1431,8,356.00,888884,0.00,'','',0.00,'{\"plugins_membershiplevelvip_price_1\":\"100\"}',1618468361);
/*!40000 ALTER TABLE `sxo_goods_spec_base` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_spec_type`
--

DROP TABLE IF EXISTS `sxo_goods_spec_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_spec_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `value` text NOT NULL COMMENT '类型值（json字符串存储）',
  `name` char(230) NOT NULL DEFAULT '' COMMENT '类型名称',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=468 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品规格类型';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_spec_type`
--

LOCK TABLES `sxo_goods_spec_type` WRITE;
/*!40000 ALTER TABLE `sxo_goods_spec_type` DISABLE KEYS */;
INSERT INTO `sxo_goods_spec_type` VALUES (354,9,'[{\"name\":\"白色\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547454702543219.jpg\"},{\"name\":\"粉色\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547454702272215.jpg\"},{\"name\":\"黑色\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547454702814719.jpg\"}]','颜色',1599803472),(355,9,'[{\"name\":\"S\",\"images\":\"\"},{\"name\":\"M\",\"images\":\"\"},{\"name\":\"L\",\"images\":\"\"},{\"name\":\"XL\",\"images\":\"\"}]','尺码',1599803472),(452,2,'[{\"name\":\"套餐一\",\"images\":\"\"},{\"name\":\"套餐二\",\"images\":\"\"}]','套餐',1609742103),(453,2,'[{\"name\":\"金色\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547451274847894.jpg\"},{\"name\":\"银色\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547451576558478.jpg\"}]','颜色',1609742103),(454,2,'[{\"name\":\"32G\",\"images\":\"\"},{\"name\":\"64G\",\"images\":\"\"},{\"name\":\"128G\",\"images\":\"\"}]','容量',1609742103),(455,11,'[{\"name\":\"M\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547455907486857.jpg\"},{\"name\":\"L\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547455907256518.jpg\"},{\"name\":\"XL\",\"images\":\"\\/static\\/upload\\/images\\/goods\\/2019\\/01\\/14\\/1547455601528614.jpg\"}]','尺码',1610109196),(466,12,'[{\"name\":\"粉色\",\"images\":\"\"},{\"name\":\"白色\",\"images\":\"\"}]','颜色',1618455784),(467,12,'[{\"name\":\"S+S\",\"images\":\"\"},{\"name\":\"M+M\",\"images\":\"\"}]','尺码',1618455784);
/*!40000 ALTER TABLE `sxo_goods_spec_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_goods_spec_value`
--

DROP TABLE IF EXISTS `sxo_goods_spec_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_goods_spec_value` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `goods_spec_base_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品规格基础id',
  `value` char(230) NOT NULL DEFAULT '' COMMENT '规格值',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `goods_id` (`goods_id`),
  KEY `goods_spec_base_id` (`goods_spec_base_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2801 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='商品规格值';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_goods_spec_value`
--

LOCK TABLES `sxo_goods_spec_value` WRITE;
/*!40000 ALTER TABLE `sxo_goods_spec_value` DISABLE KEYS */;
INSERT INTO `sxo_goods_spec_value` VALUES (2105,9,1072,'白色',1599803472),(2106,9,1072,'S',1599803472),(2107,9,1073,'白色',1599803472),(2108,9,1073,'M',1599803472),(2109,9,1074,'白色',1599803472),(2110,9,1074,'L',1599803472),(2111,9,1075,'白色',1599803472),(2112,9,1075,'XL',1599803472),(2113,9,1076,'粉色',1599803472),(2114,9,1076,'S',1599803472),(2115,9,1077,'粉色',1599803472),(2116,9,1077,'M',1599803472),(2117,9,1078,'粉色',1599803472),(2118,9,1078,'L',1599803472),(2119,9,1079,'黑色',1599803472),(2120,9,1079,'S',1599803472),(2121,9,1080,'黑色',1599803472),(2122,9,1080,'XL',1599803472),(2723,2,1393,'套餐一',1609742103),(2724,2,1393,'金色',1609742103),(2725,2,1393,'32G',1609742103),(2726,2,1394,'套餐一',1609742104),(2727,2,1394,'金色',1609742104),(2728,2,1394,'64G',1609742104),(2729,2,1395,'套餐一',1609742104),(2730,2,1395,'金色',1609742104),(2731,2,1395,'128G',1609742104),(2732,2,1396,'套餐一',1609742104),(2733,2,1396,'银色',1609742104),(2734,2,1396,'32G',1609742104),(2735,2,1397,'套餐一',1609742104),(2736,2,1397,'银色',1609742104),(2737,2,1397,'64G',1609742104),(2738,2,1398,'套餐一',1609742104),(2739,2,1398,'银色',1609742104),(2740,2,1398,'128G',1609742104),(2741,2,1399,'套餐二',1609742104),(2742,2,1399,'金色',1609742104),(2743,2,1399,'32G',1609742104),(2744,2,1400,'套餐二',1609742104),(2745,2,1400,'金色',1609742104),(2746,2,1400,'128G',1609742104),(2747,2,1401,'套餐二',1609742104),(2748,2,1401,'银色',1609742104),(2749,2,1401,'64G',1609742104),(2750,11,1403,'M',1610109196),(2751,11,1404,'L',1610109196),(2752,11,1405,'XL',1610109196),(2793,12,1426,'粉色',1618455784),(2794,12,1426,'S+S',1618455784),(2795,12,1427,'粉色',1618455784),(2796,12,1427,'M+M',1618455784),(2797,12,1428,'白色',1618455784),(2798,12,1428,'S+S',1618455784),(2799,12,1429,'白色',1618455784),(2800,12,1429,'M+M',1618455784);
/*!40000 ALTER TABLE `sxo_goods_spec_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_link`
--

DROP TABLE IF EXISTS `sxo_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_link` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `name` char(30) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '导航名称',
  `url` char(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT 'url地址',
  `describe` char(60) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '描述',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `is_new_window_open` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新窗口打开（0否，1是）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `sort` (`sort`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_link`
--

LOCK TABLES `sxo_link` WRITE;
/*!40000 ALTER TABLE `sxo_link` DISABLE KEYS */;
INSERT INTO `sxo_link` VALUES (1,'SchoolCMS','https://gitee.com/zongzhige/schoolcms','SchoolCMS学校教务管理系统',1,1,1,1486292373,1594273510),(12,'AmazeUI','http://amazeui.shopxo.net/','AmazeUI国内首个HTML5框架',4,1,1,1486353476,1563088005),(13,'龚哥哥的博客','http://gong.gg/','龚哥哥的博客',2,1,1,1486353528,1592320862),(14,'ThinkPHP','http://www.thinkphp.cn/','ThinkPHP',3,1,1,1487919160,0),(15,'ShopXO','http://shopxo.net','ShopXO企业级B2C免费开源电商系统',0,1,1,1533711881,1592320866),(16,'码云','https://gitee.com/zongzhige/shopxo','代码托管平台',0,1,1,1547450105,1594273488),(17,'GitHub','https://github.com/gongfuxiang/shopxo','代码托管平台',0,1,1,1547450145,1563088069),(18,'ShopXO应用商店','http://store.shopxo.net/','ShopXO应用商店',0,1,1,1563088117,1563088129),(20,'宝塔面板','https://www.bt.cn/?invite_code=MV9kZHh6b2Y=','宝塔服务器控制面板',5,1,1,1566531114,0),(21,'西部数码','https://www.west.cn/active/freetc/?ReferenceID=934057','西部数码国内知名服务器提供商',6,1,1,1566531132,0),(22,'纵之格科技','https://www.zongzhige.com/','纵之格科技',0,1,1,1594273577,0);
/*!40000 ALTER TABLE `sxo_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_message`
--

DROP TABLE IF EXISTS `sxo_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` char(60) NOT NULL DEFAULT '' COMMENT '标题',
  `detail` char(255) NOT NULL DEFAULT '' COMMENT '详情',
  `business_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '业务id',
  `business_type` char(180) NOT NULL DEFAULT '' COMMENT '业务类型，字符串（如：订单、充值、提现、等...）',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '消息类型（0普通通知, ...）',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否已读（0否, 1是）',
  `is_delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0否, 大于0删除时间）',
  `user_is_delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户是否已删除（0否, 大于0删除时间）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='消息';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_message`
--

LOCK TABLES `sxo_message` WRITE;
/*!40000 ALTER TABLE `sxo_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_navigation`
--

DROP TABLE IF EXISTS `sxo_navigation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_navigation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '导航名称',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '自定义url地址',
  `value` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '数据 id',
  `data_type` char(30) NOT NULL DEFAULT '' COMMENT '数据类型（custom:自定义导航, article_class:文章分类, customview:自定义页面）',
  `nav_type` char(30) NOT NULL DEFAULT '' COMMENT '导航类型（header:顶部导航, footer:底部导航）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示（0否，1是）',
  `is_new_window_open` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新窗口打开（0否，1是）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `is_show` (`is_show`),
  KEY `sort` (`sort`),
  KEY `nav_type` (`nav_type`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='导航';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_navigation`
--

LOCK TABLES `sxo_navigation` WRITE;
/*!40000 ALTER TABLE `sxo_navigation` DISABLE KEYS */;
INSERT INTO `sxo_navigation` VALUES (8,0,'自定义页面test','',1,'customview','header',0,0,0,1486352254,1613625451),(17,0,'ShopXO','http://shopxo.net/',0,'custom','header',10,1,1,1487923617,1533873171),(24,54,'服饰鞋包','',2,'goods_category','header',0,1,0,1539150026,1592230670),(34,0,'信息咨询','http://shopxo.net/',0,'custom','footer',0,1,1,1554795563,1592232213),(35,0,'客户服务','http://shopxo.net/',0,'custom','footer',0,1,0,1554795788,0),(36,0,'支付方式','http://shopxo.net/',0,'custom','footer',0,1,0,1554796068,0),(37,0,'会员中心','http://shopxo.net/',0,'custom','footer',0,1,0,1554796082,0),(38,34,'关于ShopXO','',29,'article','footer',0,1,0,1554796171,0),(39,34,'联系我们','',28,'article','footer',0,1,0,1554796188,0),(40,34,'招聘英才','',27,'article','footer',0,1,0,1554796202,0),(41,34,'合作及洽谈','',26,'article','footer',0,1,0,1554796211,0),(42,35,'如何注册成为会员','',1,'article','footer',0,1,0,1554796239,0),(43,35,'积分细则','',3,'article','footer',0,1,0,1554796245,0),(44,35,'如何搜索','',5,'article','footer',0,1,0,1554796253,0),(45,36,'分期付款','',12,'article','footer',0,1,0,1554796281,0),(46,36,'邮局汇款','',13,'article','footer',0,1,0,1554796296,0),(47,36,'在线支付','',16,'article','footer',0,1,0,1554796312,0),(48,36,'公司转账','',14,'article','footer',0,1,0,1554796327,0),(49,36,'如何注册支付宝','',15,'article','footer',0,1,0,1554796339,0),(50,37,'会员修改密码','',22,'article','footer',0,1,0,1554796367,0),(51,37,'会员修改个人资料','',23,'article','footer',0,1,0,1554796375,0),(52,37,'修改收货地址','',25,'article','footer',0,1,0,1554796386,0),(53,37,'如何管理店铺','',7,'article','footer',0,1,0,1554796399,0),(54,0,'商品分类','http://shopxo.net/',0,'custom','header',0,1,0,1556015784,0),(55,0,'如何注册成为会员','',1,'article','footer',0,1,0,1616685505,0);
/*!40000 ALTER TABLE `sxo_navigation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order`
--

DROP TABLE IF EXISTS `sxo_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_no` char(60) NOT NULL DEFAULT '' COMMENT '订单号',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `warehouse_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '仓库id',
  `user_note` char(255) NOT NULL DEFAULT '' COMMENT '用户备注',
  `express_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '快递id',
  `express_number` char(60) NOT NULL DEFAULT '' COMMENT '快递单号',
  `payment_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付方式id',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '订单状态（0待确认, 1已确认/待支付, 2已支付/待发货, 3已发货/待收货, 4已完成, 5已取消, 6已关闭）',
  `pay_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态（0未支付, 1已支付, 2已退款, 3部分退款）',
  `extension_data` longtext COMMENT '扩展展示数据',
  `buy_number_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买商品总数量',
  `increase_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '增加的金额',
  `preferential_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠金额',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单单价',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价(订单最终价格)',
  `pay_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '已支付金额',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `returned_quantity` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退货数量',
  `client_type` char(30) NOT NULL DEFAULT '' COMMENT '客户端类型（pc, h5, ios, android, alipay, weixin, baidu）取APPLICATION_CLIENT_TYPE常量值',
  `order_model` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单模式（0销售型, 1展示型, 2自提点, 3虚拟销售）',
  `is_under_line` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否线下支付（0否，1是）',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `confirm_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '确认时间',
  `delivery_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发货时间',
  `cancel_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '取消时间',
  `collect_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收货时间',
  `close_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关闭时间',
  `comments_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评论时间',
  `is_comments` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商家是否已评论（0否, 大于0评论时间）',
  `user_is_comments` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户是否已评论（0否, 大于0评论时间）',
  `is_delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商家是否已删除（0否, 大于0删除时间）',
  `user_is_delete_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户是否已删除（0否, 大于0删除时间）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_no` (`order_no`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  KEY `pay_status` (`pay_status`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order`
--

LOCK TABLES `sxo_order` WRITE;
/*!40000 ALTER TABLE `sxo_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_address`
--

DROP TABLE IF EXISTS `sxo_order_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_address` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `address_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收件地址id',
  `alias` char(60) NOT NULL DEFAULT '' COMMENT '别名',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '收件人-姓名',
  `tel` char(15) NOT NULL DEFAULT '' COMMENT '收件人-电话',
  `province` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收件人-省',
  `city` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收件人-市',
  `county` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收件人-县/区',
  `address` char(200) NOT NULL DEFAULT '' COMMENT '收件人-详细地址',
  `province_name` char(30) NOT NULL DEFAULT '' COMMENT '收件人-省-名称',
  `city_name` char(30) NOT NULL DEFAULT '' COMMENT '收件人-市-名称',
  `county_name` char(30) NOT NULL DEFAULT '' COMMENT '收件人-县/区-名称',
  `lng` decimal(13,10) NOT NULL DEFAULT '0.0000000000' COMMENT '收货地址-经度',
  `lat` decimal(13,10) NOT NULL DEFAULT '0.0000000000' COMMENT '收货地址-纬度',
  `idcard_name` char(60) NOT NULL DEFAULT '' COMMENT '身份证姓名',
  `idcard_number` char(30) NOT NULL DEFAULT '' COMMENT '身份证号码',
  `idcard_front` char(255) NOT NULL DEFAULT '' COMMENT '身份证人像面图片',
  `idcard_back` char(255) NOT NULL DEFAULT '' COMMENT '身份证国微面图片',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单地址';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_address`
--

LOCK TABLES `sxo_order_address` WRITE;
/*!40000 ALTER TABLE `sxo_order_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_aftersale`
--

DROP TABLE IF EXISTS `sxo_order_aftersale`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_aftersale` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_no` char(60) NOT NULL DEFAULT '' COMMENT '订单号',
  `order_detail_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单详情id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '状态（0待确认, 1待退货, 2待审核, 3已完成, 4已拒绝, 5已取消）',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '业务类型（0仅退款, 1退货退款）',
  `refundment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '退款类型（0原路退回, 1退至钱包, 2手动处理）',
  `reason` char(180) NOT NULL DEFAULT '' COMMENT '申请原因',
  `number` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退货数量',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `msg` char(230) NOT NULL DEFAULT '' COMMENT '退款说明',
  `images` text COMMENT '凭证图片（一维数组json存储）',
  `refuse_reason` char(230) NOT NULL DEFAULT '' COMMENT '拒绝原因',
  `express_name` char(60) NOT NULL DEFAULT '' COMMENT '快递名称',
  `express_number` char(60) NOT NULL DEFAULT '' COMMENT '快递单号',
  `apply_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `confirm_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '确认时间',
  `delivery_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退货时间',
  `audit_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `cancel_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '取消时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单售后';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_aftersale`
--

LOCK TABLES `sxo_order_aftersale` WRITE;
/*!40000 ALTER TABLE `sxo_order_aftersale` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_aftersale` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_currency`
--

DROP TABLE IF EXISTS `sxo_order_currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_currency` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `currency_name` char(80) NOT NULL DEFAULT '' COMMENT '货币名称',
  `currency_code` char(60) NOT NULL DEFAULT '' COMMENT '货币代码',
  `currency_symbol` char(60) NOT NULL DEFAULT '' COMMENT '货币符号',
  `currency_rate` decimal(7,6) unsigned NOT NULL DEFAULT '0.000000' COMMENT '货币汇率',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`),
  KEY `currency_name` (`currency_name`),
  KEY `currency_code` (`currency_code`),
  KEY `currency_rate` (`currency_rate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单货币';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_currency`
--

LOCK TABLES `sxo_order_currency` WRITE;
/*!40000 ALTER TABLE `sxo_order_currency` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_detail`
--

DROP TABLE IF EXISTS `sxo_order_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `title` char(160) NOT NULL DEFAULT '' COMMENT '标题',
  `images` char(255) NOT NULL DEFAULT '' COMMENT '封面图片',
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `total_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '当前总价(单价*数量)',
  `spec` text COMMENT '规格',
  `buy_number` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '购买数量',
  `model` char(30) NOT NULL DEFAULT '' COMMENT '型号',
  `spec_weight` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '重量（kg）',
  `spec_coding` char(80) NOT NULL DEFAULT '' COMMENT '编码',
  `spec_barcode` char(80) NOT NULL DEFAULT '' COMMENT '条形码',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `returned_quantity` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '退货数量',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单详情';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_detail`
--

LOCK TABLES `sxo_order_detail` WRITE;
/*!40000 ALTER TABLE `sxo_order_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_extraction_code`
--

DROP TABLE IF EXISTS `sxo_order_extraction_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_extraction_code` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `code` char(30) NOT NULL DEFAULT '' COMMENT '取货码',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单自提取货码关联';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_extraction_code`
--

LOCK TABLES `sxo_order_extraction_code` WRITE;
/*!40000 ALTER TABLE `sxo_order_extraction_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_extraction_code` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_fictitious_value`
--

DROP TABLE IF EXISTS `sxo_order_fictitious_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_fictitious_value` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `order_detail_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单详情id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `value` text COMMENT '虚拟商品展示数据',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `order_detail_id` (`order_detail_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单虚拟销售数据关联';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_fictitious_value`
--

LOCK TABLES `sxo_order_fictitious_value` WRITE;
/*!40000 ALTER TABLE `sxo_order_fictitious_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_fictitious_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_goods_inventory_log`
--

DROP TABLE IF EXISTS `sxo_order_goods_inventory_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_goods_inventory_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `order_detail_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单详情id',
  `goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `order_status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '订单状态（0待确认, 1已确认/待支付, 2已支付/待发货, 3已发货/待收货, 4已完成, 5已取消, 6已关闭）',
  `original_inventory` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '原库存',
  `new_inventory` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '最新库存',
  `is_rollback` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否回滚（0否, 1是）',
  `rollback_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回滚时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`),
  KEY `order_status` (`order_status`),
  KEY `order_detail_id` (`order_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单商品库存变更日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_goods_inventory_log`
--

LOCK TABLES `sxo_order_goods_inventory_log` WRITE;
/*!40000 ALTER TABLE `sxo_order_goods_inventory_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_goods_inventory_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_order_status_history`
--

DROP TABLE IF EXISTS `sxo_order_status_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_order_status_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `original_status` varchar(60) NOT NULL DEFAULT '' COMMENT '原始状态',
  `new_status` varchar(60) NOT NULL DEFAULT '' COMMENT '最新状态',
  `msg` varchar(255) NOT NULL DEFAULT '' COMMENT '操作描述',
  `creator` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建-用户id',
  `creator_name` varchar(60) NOT NULL DEFAULT '' COMMENT '创建人-姓名',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `original_status` (`original_status`),
  KEY `new_status` (`new_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='订单状态历史纪录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_order_status_history`
--

LOCK TABLES `sxo_order_status_history` WRITE;
/*!40000 ALTER TABLE `sxo_order_status_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_order_status_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_pay_log`
--

DROP TABLE IF EXISTS `sxo_pay_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_pay_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付日志id',
  `log_no` char(60) NOT NULL DEFAULT '' COMMENT '支付日志订单号',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `business_type` char(180) NOT NULL DEFAULT '' COMMENT '业务类型，字符串（如：订单、钱包充值、会员购买、等...）',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '状态（0待支付, 1已支付, 2已关闭）正常30分钟内未支付将关闭',
  `payment` char(60) NOT NULL DEFAULT '' COMMENT '支付方式标记',
  `payment_name` char(60) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `subject` char(255) NOT NULL DEFAULT '' COMMENT '订单名称',
  `total_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '业务订单金额',
  `pay_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '支付金额',
  `trade_no` char(100) NOT NULL DEFAULT '' COMMENT '支付平台交易号',
  `buyer_user` char(60) NOT NULL DEFAULT '' COMMENT '支付平台用户帐号',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `close_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '关闭时间',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `payment` (`payment`),
  KEY `status` (`status`),
  KEY `business_type` (`business_type`),
  KEY `total_price` (`total_price`),
  KEY `pay_price` (`pay_price`),
  KEY `add_time` (`add_time`),
  KEY `pay_time` (`pay_time`),
  KEY `close_time` (`close_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_pay_log`
--

LOCK TABLES `sxo_pay_log` WRITE;
/*!40000 ALTER TABLE `sxo_pay_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_pay_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_pay_log_value`
--

DROP TABLE IF EXISTS `sxo_pay_log_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_pay_log_value` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `pay_log_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付日志id',
  `business_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '业务订单id',
  `business_no` char(60) NOT NULL DEFAULT '' COMMENT '业务订单号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `pay_log_id` (`pay_log_id`),
  KEY `business_id` (`business_id`),
  KEY `add_time` (`add_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付日志关联业务数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_pay_log_value`
--

LOCK TABLES `sxo_pay_log_value` WRITE;
/*!40000 ALTER TABLE `sxo_pay_log_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_pay_log_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_pay_request_log`
--

DROP TABLE IF EXISTS `sxo_pay_request_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_pay_request_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `business_type` char(180) NOT NULL DEFAULT '' COMMENT '业务类型，字符串（如：订单、钱包充值、会员购买、等...）',
  `request_params` mediumtext COMMENT '请求参数（数组则json字符串存储）',
  `response_data` mediumtext COMMENT '响应参数（数组则json字符串存储）',
  `business_handle` text COMMENT '业务处理结果（数组则json字符串存储）',
  `request_url` text COMMENT '请求url地址',
  `server_port` char(10) NOT NULL DEFAULT '' COMMENT '端口号',
  `server_ip` char(15) NOT NULL DEFAULT '' COMMENT '服务器ip',
  `client_ip` char(15) NOT NULL DEFAULT '' COMMENT '客户端ip',
  `os` char(20) NOT NULL DEFAULT '' COMMENT '操作系统',
  `browser` char(20) NOT NULL DEFAULT '' COMMENT '浏览器',
  `method` char(4) NOT NULL DEFAULT '' COMMENT '请求类型',
  `scheme` char(5) NOT NULL DEFAULT '' COMMENT 'http类型',
  `version` char(5) NOT NULL DEFAULT '' COMMENT 'http版本',
  `client` char(255) NOT NULL DEFAULT '' COMMENT '客户端详情信息',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `business_type` (`business_type`),
  KEY `add_time` (`add_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付请求日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_pay_request_log`
--

LOCK TABLES `sxo_pay_request_log` WRITE;
/*!40000 ALTER TABLE `sxo_pay_request_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_pay_request_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_payment`
--

DROP TABLE IF EXISTS `sxo_payment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_payment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `name` char(30) NOT NULL COMMENT '名称',
  `payment` char(60) NOT NULL DEFAULT '' COMMENT '唯一标记',
  `logo` char(255) NOT NULL DEFAULT '' COMMENT 'logo',
  `version` char(255) NOT NULL DEFAULT '' COMMENT '插件版本',
  `apply_version` char(255) NOT NULL DEFAULT '' COMMENT '适用系统版本',
  `desc` char(255) NOT NULL DEFAULT '' COMMENT '插件描述',
  `author` char(255) NOT NULL DEFAULT '' COMMENT '作者',
  `author_url` char(255) NOT NULL DEFAULT '' COMMENT '作者主页',
  `element` text COMMENT '配置项规则',
  `config` text COMMENT '配置数据',
  `apply_terminal` char(255) NOT NULL COMMENT '适用终端 php一维数组json字符串存储（pc, h5, ios, android, alipay, weixin, baidu, toutiao, qq）',
  `apply_terminal_old` char(255) NOT NULL COMMENT '原始适用终端 php一维数组json字符串存储（pc, h5, ios, android, alipay, weixin, baidu, toutiao, qq）',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `is_open_user` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否对用户开放',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '顺序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `payment` (`payment`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='支付方式';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_payment`
--

LOCK TABLES `sxo_payment` WRITE;
/*!40000 ALTER TABLE `sxo_payment` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_payment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_plugins`
--

DROP TABLE IF EXISTS `sxo_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_plugins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '插件名称',
  `plugins` char(60) NOT NULL DEFAULT '' COMMENT '唯一标记',
  `data` longtext COMMENT '应用数据',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `plugins` (`plugins`),
  KEY `is_enable` (`is_enable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='应用';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_plugins`
--

LOCK TABLES `sxo_plugins` WRITE;
/*!40000 ALTER TABLE `sxo_plugins` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_power`
--

DROP TABLE IF EXISTS `sxo_power`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_power` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限父级id',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '权限名称',
  `control` char(30) NOT NULL DEFAULT '' COMMENT '控制器名称',
  `action` char(30) NOT NULL DEFAULT '' COMMENT '方法名称',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '自定义url地址',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示（0否，1是）',
  `icon` char(60) NOT NULL DEFAULT '' COMMENT '图标class',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=476 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='权限';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_power`
--

LOCK TABLES `sxo_power` WRITE;
/*!40000 ALTER TABLE `sxo_power` DISABLE KEYS */;
INSERT INTO `sxo_power` VALUES (1,0,'权限控制','Power','Index','',3,1,'icon-quanxian',1481612301),(4,1,'角色管理','Role','Index','',20,1,'',1481639037),(13,1,'权限分配','Power','Index','',30,1,'',1482156143),(15,1,'权限添加/编辑','Power','Save','',31,0,'',1482243750),(16,1,'权限删除','Power','Delete','',32,0,'',1482243797),(17,1,'角色组添加/编辑页面','Role','SaveInfo','',21,0,'',1482243855),(18,1,'角色组添加/编辑','Role','Save','',22,0,'',1482243888),(19,1,'管理员添加/编辑页面','Admin','SaveInfo','',2,0,'',1482244637),(20,1,'管理员添加/编辑','Admin','Save','',3,0,'',1482244666),(21,1,'管理员删除','Admin','Delete','',4,0,'',1482244688),(22,1,'管理员列表','Admin','Index','',1,1,'',1482568868),(23,1,'角色删除','Role','Delete','',23,0,'',1482569155),(38,0,'商品管理','Goods','Index','',5,1,'icon-shangpin',1483283430),(39,38,'商品管理','Goods','Index','',1,1,'',1483283546),(41,0,'系统设置','Config','Index','',1,1,'icon-peizhi',1483362358),(42,41,'配置保存','Config','Save','',10,0,'',1483432335),(57,38,'商品添加/编辑页面','Goods','SaveInfo','',2,0,'',1483616439),(58,38,'商品添加/编辑','Goods','Save','',3,0,'',1483616492),(59,38,'商品删除','Goods','Delete','',4,0,'',1483616569),(81,0,'站点配置','Site','Index','',2,1,'icon-zhandianpeizhi',1486182943),(103,81,'站点设置','Site','Index','',0,1,'',1486561470),(104,81,'短信设置','Sms','Index','',10,1,'',1486561615),(105,81,'站点设置编辑','Site','Save','',1,0,'',1486561780),(107,81,'短信设置编辑','Sms','Save','',11,0,'',1486562011),(118,0,'工具','Tool','Index','',50,1,'icon-tools',1488108044),(119,118,'缓存管理','Cache','Index','',1,1,'',1488108107),(120,118,'站点缓存更新','Cache','StatusUpdate','',2,0,'',1488108235),(121,118,'模板缓存更新','Cache','TemplateUpdate','',2,0,'',1488108390),(122,118,'模块缓存更新','Cache','ModuleUpdate','',3,0,'',1488108436),(126,0,'用户管理','User','Index','',4,1,'icon-yonghuguanli',1490794162),(127,126,'用户列表','User','Index','',0,1,'',1490794316),(128,126,'用户编辑/添加页面','User','SaveInfo','',1,0,'',1490794458),(129,126,'用户添加/编辑','User','Save','',2,0,'',1490794510),(130,126,'用户删除','User','Delete','',3,0,'',1490794585),(146,126,'Excel导出','User','ExcelExport','',6,0,'',1522223773),(153,222,'地区管理','Region','Index','',60,1,'',1526304473),(154,222,'地区添加/编辑','Region','Save','',61,0,'',1526304503),(155,222,'地区删除','Region','Delete','',62,0,'',1526304531),(156,222,'快递管理','Express','Index','',70,1,'',1526304473),(157,222,'快递添加/编辑','Express','Save','',71,0,'',1526304473),(158,222,'快递删除','Express','Delete','',72,0,'',1526304473),(172,222,'首页轮播','Slide','Index','',40,1,'',1527149117),(173,222,'轮播添加/编辑页面','Slide','SaveInfo','',41,0,'',1527149152),(174,222,'轮播添加/编辑','Slide','Save','',42,0,'',1527149186),(175,222,'轮播状态更新','Slide','StatusUpdate','',43,0,'',1527156980),(176,222,'轮播删除','Slide','Delete','',44,0,'',1527157260),(177,0,'订单管理','Order','Index','',6,1,'icon-dingdan',1522229870),(178,177,'订单管理','Order','Index','',1,1,'',1522317898),(179,177,'订单删除','Order','Delete','',2,0,'',1522317917),(180,177,'订单取消','Order','Cancel','',3,0,'',1527497803),(181,38,'商品状态更新','Goods','StatusUpdate','',5,0,'',1528080200),(182,0,'数据管理','Data','Index','',22,1,'icon-shuju',1528096661),(183,182,'消息管理','Message','Index','',10,1,'',1528080200),(184,182,'消息删除','Message','Delete','',11,0,'',1528080200),(185,182,'支付日志','PayLog','Index','',20,1,'',1528080200),(186,182,'积分日志','IntegralLog','Index','',40,1,'',1528103067),(193,222,'筛选价格','ScreeningPrice','Index','',50,1,'',1528708578),(194,222,'筛选价格添加/编辑','ScreeningPrice','Save','',51,0,'',1528708609),(199,81,'SEO设置','Seo','Index','',30,1,'',1528771081),(200,81,'SEO设置编辑','Seo','Save','',31,0,'',1528771105),(201,38,'商品分类','GoodsCategory','Index','',10,1,'',1529041901),(202,38,'商品分类添加/编辑','GoodsCategory','Save','',11,0,'',1529041928),(203,38,'商品分类删除','GoodsCategory','Delete','',12,0,'',1529041949),(204,0,'文章管理','Article','Index','',21,1,'icon-wenzhang',1530360560),(205,204,'文章管理','Article','Index','',0,1,'',1530360593),(206,204,'文章添加/编辑页面','Article','SaveInfo','',1,0,'',1530360625),(207,204,'文章添加/编辑','Article','Save','',2,0,'',1530360663),(208,204,'文章删除','Article','Delete','',3,0,'',1530360692),(209,204,'文章状态更新','Article','StatusUpdate','',4,0,'',1530360730),(210,204,'文章分类','ArticleCategory','Index','',10,1,'',1530361071),(211,204,'文章分类编辑/添加','ArticleCategory','Save','',11,0,'',1530361101),(212,204,'文章分类删除','ArticleCategory','Delete','',12,0,'',1530361126),(214,182,'问答留言','Answer','Index','',0,1,'',1533112443),(215,182,'问答留言回复','Answer','Reply','',1,0,'',1533119660),(216,182,'问答留言删除','Answer','Delete','',2,0,'',1533119680),(217,182,'问答留言状态更新','Answer','StatusUpdate','',3,0,'',1533119704),(219,81,'邮箱设置','Email','Index','',20,1,'',1533636067),(220,81,'邮箱设置/编辑','Email','Save','',21,0,'',1533636109),(221,81,'邮件发送测试','Email','EmailTest','',22,0,'',1533636157),(222,0,'网站管理','Navigation','Index','',7,1,'icon-wangzhanguanli',1533692051),(223,222,'导航管理','Navigation','Index','',0,1,'',1486183114),(226,222,'导航添加/编辑','Navigation','Save','',2,0,'',1486183367),(227,222,'导航删除','Navigation','Delete','',3,0,'',1486183410),(228,222,'导航状态更新','Navigation','StatusUpdate','',4,0,'',1486183462),(234,222,'自定义页面','CustomView','Index','',11,1,'',1486193400),(235,222,'自定义页面添加/编辑页面','CustomView','SaveInfo','',12,0,'',1486193449),(236,222,'自定义页面添加/编辑','CustomView','Save','',13,0,'',1486193473),(237,222,'自定义页面删除','CustomView','Delete','',14,0,'',1486193516),(238,222,'自定义页面状态更新','CustomView','StatusUpdate','',15,0,'',1486193582),(239,222,'友情链接','Link','Index','',21,1,'',1486194358),(240,222,'友情链接添加/编辑页面','Link','SaveInfo','',22,0,'',1486194392),(241,222,'友情链接添加/编辑','Link','Save','',23,0,'',1486194413),(242,222,'友情链接删除','Link','Delete','',24,0,'',1486194435),(243,222,'友情链接状态更新','Link','StatusUpdate','',25,0,'',1486194479),(244,222,'主题管理','Theme','Index','',30,1,'',1494381693),(245,222,'主题管理添加/编辑','Theme','Save','',31,0,'',1494398194),(246,222,'主题上传安装','Theme','Upload','',32,0,'',1494405096),(247,222,'主题删除','Theme','Delete','',33,0,'',1494410655),(248,204,'文章详情','Article','Detail','',5,0,'',1534156400),(249,252,'品牌管理','Brand','Index','',0,1,'',1535683271),(250,252,'品牌添加/编辑','Brand','Save','',2,0,'',1535683310),(251,252,'品牌删除','Brand','Delete','',4,0,'',1535683351),(252,0,'品牌管理','Brand','Index','',8,1,'icon-ico-pinpaiguanli',1535684308),(253,252,'品牌分类','BrandCategory','Index','',10,1,'',1535684401),(254,252,'品牌分类添加/编辑','BrandCategory','Save','',11,0,'',1535684424),(255,252,'品牌分类删除','BrandCategory','Delete','',12,0,'',1535684444),(256,252,'品牌添加/编辑页面','Brand','SaveInfo','',1,0,'',1535694837),(257,252,'品牌状态更新','Brand','StatusUpdate','',3,0,'',1535694880),(258,222,'筛选价格删除','ScreeningPrice','Delete','',52,0,'',1536227071),(259,222,'支付方式','Payment','Index','',80,1,'',1537156351),(260,222,'支付方式安装/编辑页面','Payment','SaveInfo','',81,0,'',1537156423),(261,222,'支付方式安装/编辑','Payment','Save','',82,0,'',1537156463),(262,222,'支付方式删除','Payment','Delete','',83,0,'',1537156502),(263,222,'支付方式安装','Payment','Install','',84,0,'',1537166090),(264,222,'支付方式状态更新','Payment','StatusUpdate','',85,0,'',1537166149),(265,222,'支付方式卸载','Payment','Uninstall','',86,0,'',1537167814),(266,222,'支付方式上传','Payment','Upload','',87,0,'',1537173653),(267,177,'订单发货','Order','Delivery','',4,0,'',1538413499),(268,177,'订单收货','Order','Collect','',5,0,'',1538414034),(269,177,'订单支付','Order','Pay','',6,0,'',1538757043),(310,177,'订单确认','Order','Confirm','',7,0,'',1542011799),(311,1,'角色状态更新','Role','StatusUpdate','',24,0,'',1542102071),(314,319,'首页导航','AppHomeNav','Index','',10,1,'',1542558318),(315,319,'首页导航添加/编辑页面','AppHomeNav','SaveInfo','',11,0,'',1542558686),(316,319,'首页导航添加/编辑','AppHomeNav','Save','',12,0,'',1542558706),(317,319,'首页导航状态更新','AppHomeNav','StatusUpdate','',13,0,'',1542558747),(318,319,'首页导航删除','AppHomeNav','Delete','',14,0,'',1542558767),(319,0,'手机管理','App','Index','',20,1,'icon-shouji',1483362358),(326,319,'基础配置','AppConfig','Index','',0,1,'',1543206359),(327,319,'基础配置保存','AppConfig','Save','',1,0,'',1543206402),(331,118,'日志删除','Cache','LogDelete','',4,0,'',1545642163),(332,319,'小程序列表','AppMini','Index','',30,1,'',1546935020),(333,319,'小程序配置','AppMini','Config','',40,1,'',1546935090),(334,319,'小程序配置保存','AppMini','Save','',41,0,'',1546935118),(336,319,'小程序包生成','AppMini','Created','',31,0,'',1546935187),(337,319,'小程序包删除','AppMini','Delete','',32,0,'',1546935212),(339,41,'后台配置','Config','Index','',0,1,'',1549419752),(340,0,'应用中心','Store','Index','',30,1,'icon-application',1549496703),(341,340,'应用管理','Pluginsadmin','Index','',1,1,'',1549497306),(342,340,'应用状态更新','Pluginsadmin','StatusUpdate','',3,0,'',1549694138),(343,340,'应用调用管理','Plugins','Index','',0,0,'',1549958187),(345,340,'应用添加/编辑页面','Pluginsadmin','SaveInfo','',1,0,'',1549977925),(346,340,'应用添加/编辑','Pluginsadmin','Save','',2,0,'',1549977958),(347,340,'应用删除','Pluginsadmin','Delete','',4,0,'',1549977993),(348,340,'应用上传','Pluginsadmin','Upload','',5,0,'',1550110821),(349,118,'SQL控制台','Sqlconsole','Index','',10,1,'',1550476002),(350,118,'SQL执行','Sqlconsole','Implement','',11,0,'',1550476023),(351,340,'应用打包','Pluginsadmin','Download','',6,0,'',1553248727),(352,182,'问答添加/编辑页面','Answer','SaveInfo','',4,0,'',1553964318),(353,182,'问答添加/编辑','Answer','Save','',5,0,'',1553964354),(354,41,'商店信息','Config','Store','',0,1,'',1554803430),(356,38,'商品评论','Goodscomments','Index','',30,1,'',1533112443),(357,38,'商品评论回复','Goodscomments','Reply','',31,0,'',1533119660),(358,38,'商品评论删除','Goodscomments','Delete','',32,0,'',1533119680),(359,38,'商品评论状态更新','Goodscomments','StatusUpdate','',33,0,'',1533119704),(360,38,'商品评论添加/编辑页面','Goodscomments','SaveInfo','',34,0,'',1553964318),(361,38,'商品评论添加/编辑','Goodscomments','Save','',35,0,'',1553964354),(362,81,'协议管理','Agreement','Index','',40,1,'',1486561615),(363,81,'协议设置编辑','Agreement','Save','',41,0,'',1486562011),(364,177,'订单售后','Orderaftersale','Index','',10,1,'',1522317898),(365,177,'订单售后删除','Orderaftersale','Delete','',11,0,'',1522317917),(366,177,'订单售后取消','Orderaftersale','Cancel','',12,0,'',1527497803),(367,177,'订单售后审核','Orderaftersale','Audit','',13,0,'',1538413499),(368,177,'订单售后确认','Orderaftersale','Confirm','',14,0,'',1538414034),(369,177,'订单售后拒绝','Orderaftersale','Refuse','',15,0,'',1538757043),(372,182,'退款日志','RefundLog','Index','',30,1,'',1528080200),(373,340,'应用商店','Store','Index','',10,1,'',1553248727),(374,340,'应用安装','Pluginsadmin','Install','',6,0,'',1561369950),(375,340,'应用卸载','Pluginsadmin','Uninstall','',7,0,'',1561370063),(376,319,'用户中心导航','AppCenterNav','Index','',20,1,'',1542558318),(377,319,'用户中心导航添加/编辑页面','AppCenterNav','SaveInfo','',21,0,'',1542558686),(378,319,'用户中心导航添加/编辑','AppCenterNav','Save','',22,0,'',1542558706),(379,319,'用户中心导航状态更新','AppCenterNav','StatusUpdate','',23,0,'',1542558747),(380,319,'用户中心导航删除','AppCenterNav','Delete','',24,0,'',1542558767),(387,222,'主题下载','Theme','Download','',34,0,'',1494410699),(400,177,'订单详情','Order','Detail','',8,0,'',1589534580),(401,177,'订单售后详情','Orderaftersale','Detail','',16,0,'',1589538361),(402,38,'商品详情','Goods','Detail','',6,0,'',1589539780),(403,38,'商品评论详情','Goodscomments','Detail','',36,0,'',1591609904),(404,126,'用户详情','User','Detail','',7,0,'',1591621569),(405,1,'管理员详情','Admin','Detail','',5,0,'',1591951422),(406,1,'角色详情','Role','Detail','',25,0,'',1542102071),(407,222,'自定义页面详情','CustomView','Detail','',16,0,'',1592287822),(408,222,'轮播详情','Slide','Detail','',45,0,'',1592413297),(409,252,'品牌详情','Brand','Detail','',6,0,'',1592563170),(410,319,'首页导航详情','AppHomeNav','Detail','',15,0,'',1592652323),(411,319,'用户中心导航详情','AppCenterNav','Detail','',25,0,'',1592661364),(412,182,'问答留言详情','Answer','Detail','',6,0,'',1592840031),(413,182,'消息详情','Message','Detail','',12,0,'',1593181414),(414,222,'友情链接详情','Link','Detail','',26,0,'',1593181677),(415,182,'支付日志详情','PayLog','Detail','',21,0,'',1593355200),(416,182,'退款日志详情','RefundLog','Detail','',31,0,'',1593355237),(417,182,'积分日志详情','IntegralLog','Detail','',41,0,'',1593355265),(418,38,'商品浏览','GoodsBrowse','Index','',40,1,'',1591609904),(419,38,'商品浏览删除','GoodsBrowse','Delete','',41,0,'',1591609904),(420,38,'商品浏览详情','GoodsBrowse','Detail','',42,0,'',1591609904),(421,38,'商品收藏','GoodsFavor','Index','',50,1,'',1591609904),(422,38,'商品收藏删除','GoodsFavor','Delete','',51,0,'',1591609904),(423,38,'商品收藏详情','GoodsFavor','Detail','',52,0,'',1591609904),(425,438,'仓库管理','Warehouse','Index','',0,1,'',1488108044),(426,438,'仓库添加/编辑页面','Warehouse','SaveInfo','',1,0,'',1530360625),(427,438,'仓库添加/编辑','Warehouse','Save','',2,0,'',1530360663),(428,438,'仓库删除','Warehouse','Delete','',3,0,'',1530360692),(429,438,'仓库状态更新','Warehouse','StatusUpdate','',4,0,'',1530360730),(430,438,'仓库详情','Warehouse','Detail','',5,0,'',1534156400),(431,438,'仓库商品管理','WarehouseGoods','Index','',10,1,'',1488108044),(432,438,'仓库商品删除','WarehouseGoods','Delete','',12,0,'',1530360625),(433,438,'仓库商品搜索添加','WarehouseGoods','GoodsAdd','',15,0,'',1530360663),(434,438,'仓库商品搜索删除','WarehouseGoods','GoodsDel','',16,0,'',1530360692),(435,438,'仓库商品状态更新','WarehouseGoods','StatusUpdate','',13,0,'',1530360730),(436,438,'仓库商品详情','WarehouseGoods','Detail','',11,0,'',1534156400),(438,0,'仓库管理','Warehouse','Index','',9,1,'icon-cangku',1483362358),(439,438,'仓库商品搜索','WarehouseGoods','GoodsSearch','',14,0,'',1534156400),(440,438,'仓库商品库存编辑页面','WarehouseGoods','InventoryInfo','',17,0,'',1534156400),(441,438,'仓库商品库存编辑','WarehouseGoods','InventorySave','',18,0,'',0),(442,182,'支付日志关闭','PayLog','Close','',22,0,'',1593355200),(443,222,'快捷导航','QuickNav','Index','',90,1,'',1542558318),(444,222,'快捷导航添加/编辑页面','QuickNav','SaveInfo','',91,0,'',1542558686),(445,222,'快捷导航添加/编辑','QuickNav','Save','',92,0,'',1542558706),(446,222,'快捷导航状态更新','QuickNav','StatusUpdate','',93,0,'',1542558747),(447,222,'快捷导航删除','QuickNav','Delete','',94,0,'',1542558767),(448,222,'快捷导航详情','QuickNav','Detail','',95,0,'',1592652323),(449,182,'支付请求日志列表','PayRequestLog','Index','',25,0,'',1593355200),(450,182,'支付请求日志详情','PayRequestLog','Detail','',26,0,'',1593355200),(451,126,'用户地址','UserAddress','Index','',10,1,'',1490794316),(452,126,'用户地址编辑页面','UserAddress','SaveInfo','',11,0,'',1490794510),(453,126,'用户地址编辑','UserAddress','Save','',12,0,'',1490794510),(454,126,'用户地址删除','UserAddress','Delete','',13,0,'',1591621569),(455,126,'用户地址详情','UserAddress','Detail','',14,0,'',0),(457,319,'小程序主题上传','AppMini','ThemeUpload','',33,0,'',1605872721),(458,319,'小程序主题切换','AppMini','ThemeSave','',34,0,'',1605872721),(459,319,'小程序主题切换','AppMini','ThemeDelete','',35,0,'',1605872721),(460,319,'小程序主题下载','AppMini','ThemeDownload','',36,0,'',1605872721),(461,81,'站点设置商品搜索','Site','GoodsSearch','',1,0,'',1486561780),(462,38,'商品参数','GoodsParamsTemplate','Index','',20,1,'',1533112443),(463,38,'商品参数删除','GoodsParamsTemplate','Delete','',21,0,'',1533119680),(464,38,'商品参数状态更新','GoodsParamsTemplate','StatusUpdate','',22,0,'',1533119704),(465,38,'商品参数添加/编辑页面','GoodsParamsTemplate','SaveInfo','',23,0,'',1553964318),(466,38,'商品参数添加/编辑','GoodsParamsTemplate','Save','',24,0,'',1553964354),(467,38,'商品参数详情','GoodsParamsTemplate','Detail','',25,0,'',1591609904),(468,340,'应用排序保存','Pluginsadmin','SortSave','',8,0,'',1609820501),(469,340,'软件包安装页面','PackageInstall','Index','',11,0,'',1613967513),(471,340,'软件包安装','PackageInstall','Install','',12,0,'',1613976708),(472,340,'软件包更新','PackageUpgrade','Upgrade','',13,0,'',1619068484),(473,41,'应用商店帐号绑定','Index','StoreAccountsBind','',60,0,'',1619435558),(474,41,'系统更新检查','Index','InspectUpgrade','',61,0,'',1619435587),(475,41,'系统更新确认','Index','InspectUpgradeConfirm','',62,0,'',1619435611);
/*!40000 ALTER TABLE `sxo_power` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_quick_nav`
--

DROP TABLE IF EXISTS `sxo_quick_nav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_quick_nav` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `platform` char(30) NOT NULL DEFAULT 'pc' COMMENT '所属平台（pc PC网站, h5 H5手机网站, ios 苹果APP, android 安卓APP, alipay 支付宝小程序, weixin 微信小程序, baidu 百度小程序, toutiao 头条小程序, qq QQ小程序）',
  `event_type` tinyint(2) NOT NULL DEFAULT '-1' COMMENT '事件类型（0 WEB页面, 1 内部页面(小程序或APP内部地址), 2 外部小程序(同一个主体下的小程序appid), 3 打开地图, 4 拨打电话）',
  `event_value` char(255) NOT NULL DEFAULT '' COMMENT '事件值',
  `images_url` char(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `name` char(60) NOT NULL DEFAULT '' COMMENT '名称',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `bg_color` char(30) NOT NULL DEFAULT '' COMMENT 'css背景色值',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `platform` (`platform`),
  KEY `is_enable` (`is_enable`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='快捷导航';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_quick_nav`
--

LOCK TABLES `sxo_quick_nav` WRITE;
/*!40000 ALTER TABLE `sxo_quick_nav` DISABLE KEYS */;
INSERT INTO `sxo_quick_nav` VALUES (1,'pc',0,'index.php?s=/index/category/index.html','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1600078209),(2,'pc',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600322701),(3,'pc',0,'index.php?s=/index/order/index.html','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599902921),(4,'pc',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1599902922),(5,'h5',0,'index.php?s=/index/category/index.html','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(6,'h5',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,0),(7,'h5',0,'index.php?s=/index/order/index.html','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(8,'h5',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,0),(9,'weixin',1,'/pages/goods-category/goods-category','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(10,'weixin',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600076541),(11,'weixin',1,'/pages/user-order/user-order','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(12,'weixin',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1600321670),(13,'alipay',1,'/pages/goods-category/goods-category','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(14,'alipay',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600076541),(15,'alipay',1,'/pages/user-order/user-order','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(16,'alipay',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1600321670),(17,'baidu',1,'/pages/goods-category/goods-category','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(18,'baidu',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600323589),(19,'baidu',1,'/pages/user-order/user-order','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(20,'baidu',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1600321670),(21,'qq',1,'/pages/goods-category/goods-category','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(22,'qq',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600076541),(23,'qq',1,'/pages/user-order/user-order','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(24,'qq',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1600321670),(25,'toutiao',1,'/pages/goods-category/goods-category','/static/upload/images/quick_nav/2020/09/11/1599806728463641.png','分类',1,'#FF9933',0,1599806738,1599810379),(26,'toutiao',4,'17688888888','/static/upload/images/quick_nav/2020/09/17/1600322667732829.png','电话',1,'#FF00CC',0,1599807003,1600076541),(27,'toutiao',1,'/pages/user-order/user-order','/static/upload/images/quick_nav/2020/09/11/1599808001838784.png','订单',1,'#996633',0,1599808005,1599808064),(28,'toutiao',3,'ShopXO|上海浦东新区张江高科技园区XXX号|121.633055|31.21412','/static/upload/images/quick_nav/2020/09/17/1600321639662998.png','地图',1,'#0066FF',0,1599808052,1600321670);
/*!40000 ALTER TABLE `sxo_quick_nav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_refund_log`
--

DROP TABLE IF EXISTS `sxo_refund_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_refund_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '退款日志id',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `business_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '业务订单id',
  `business_type` char(180) NOT NULL DEFAULT '' COMMENT '业务类型，字符串（如：订单、钱包充值、会员购买、等...）',
  `trade_no` char(100) NOT NULL DEFAULT '' COMMENT '支付平台交易号',
  `buyer_user` char(60) NOT NULL DEFAULT '' COMMENT '支付平台用户帐号',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `pay_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单实际支付金额',
  `msg` char(255) NOT NULL DEFAULT '' COMMENT '描述',
  `payment` char(60) NOT NULL DEFAULT '' COMMENT '支付方式标记',
  `payment_name` char(60) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `refundment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '退款类型（0原路退回, 1退至钱包, 2手动处理）',
  `return_params` text COMMENT '支付平台返回参数（以json存储）',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`),
  KEY `payment` (`payment`),
  KEY `business_id` (`business_id`),
  KEY `business_type` (`business_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='退款日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_refund_log`
--

LOCK TABLES `sxo_refund_log` WRITE;
/*!40000 ALTER TABLE `sxo_refund_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sxo_refund_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sxo_region`
--

DROP TABLE IF EXISTS `sxo_region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sxo_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `level` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '级别类型（1:一级[所有省], 2：二级[所有市], 3:三级[所有区县], 4:街道[所有街道]）',
  `letters` char(3) NOT NULL DEFAULT '' COMMENT '城市首字母',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否启用（0否，1是）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `upd_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `is_enable` (`is_enable`),
  KEY `sort` (`sort`)
) ENGINE=MyISAM AUTO_INCREMENT=45065 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='地区';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sxo_region`
--

LOCK TABLES `sxo_region` WRITE;
/*!40000 ALTER TABLE `sxo_region` DISABLE KEYS */;
INSERT INTO `sxo_region` VALUES (1,0,'北京市',1,'',0,1,0,1575617128),(2,0,'天津市',1,'',0,1,0,0),(3,0,'河北省',1,'',0,1,0,0),(4,0,'山西省',1,'',0,1,0,1530347988),(5,0,'内蒙古自治区',1,'',0,1,0,0),(6,0,'辽宁省',1,'',0,1,0,0),(7,0,'吉林省',1,'',0,1,0,0),(8,0,'黑龙江省',1,'',0,1,0,0),(9,0,'上海市',1,'',0,1,0,0),(10,0,'江苏省',1,'',0,1,0,0),(11,0,'浙江省',1,'',0,1,0,0),(12,0,'安徽省',1,'',0,1,0,0),(13,0,'福建省',1,'',0,1,0,0),(14,0,'江西省',1,'',0,1,0,0),(15,0,'山东省',1,'',0,1,0,0),(16,0,'河南省',1,'',0,1,0,0),(17,0,'湖北省',1,'',0,1,0,0),(18,0,'湖南省',1,'',0,1,0,0),(19,0,'广东省',1,'',0,1,0,0),(20,0,'广西壮族自治区',1,'',0,1,0,0),(21,0,'海南省',1,'',0,1,0,0),(22,0,'重庆市',1,'',0,1,0,0),(23,0,'四川省',1,'',0,1,0,0),(24,0,'贵州省',1,'',0,1,0,0),(25,0,'云南省',1,'',0,1,0,0),(26,0,'西藏自治区',1,'',0,1,0,0),(27,0,'陕西省',1,'',0,1,0,0),(28,0,'甘肃省',1,'',0,1,0,0),(29,0,'青海省',1,'',0,1,0,0),(30,0,'宁夏回族自治区',1,'',0,1,0,0),(31,0,'新疆维吾尔自治区',1,'',0,1,0,0),(32,0,'台湾省',1,'',0,1,0,0),(33,0,'香港特别行政区',1,'',0,1,0,0),(34,0,'澳门特别行政区',1,'',0,1,0,0),(35,0,'海外',1,'',0,1,0,0),(36,0,'其它',1,'',0,1,0,1605776395),(37,1,'东城区',2,'',0,1,0,0),(38,1,'西城区',2,'',0,1,0,0),(39,1,'崇文区',2,'',0,1,0,0),(40,1,'宣武区',2,'',0,1,0,0),(41,1,'朝阳区',2,'',0,1,0,0),(42,1,'丰台区',2,'',0,1,0,0),(43,1,'石景山区',2,'',0,1,0,0),(44,1,'海淀区',2,'',0,1,0,0),(45,1,'门头沟区',2,'',0,1,0,0),(46,1,'房山区',2,'',0,1,0,0),(47,1,'通州区',2,'',0,1,0,0),(48,1,'顺义区',2,'',0,1,0,0),(49,1,'昌平区',2,'',0,1,0,0),(50,1,'大兴区',2,'',0,1,0,0),(51,1,'怀柔区',2,'',0,1,0,0),(52,1,'平谷区',2,'',0,1,0,0),(53,1,'密云县',2,'',0,1,0,0),(54,1,'延庆县',2,'',0,1,0,0),(55,2,'和平区',2,'',0,1,0,0),(56,2,'河东区',2,'',0,1,0,0),(57,2,'河西区',2,'',0,1,0,0),(58,2,'南开区',2,'',0,1,0,0),(59,2,'河北区',2,'',0,1,0,0),(60,2,'红桥区',2,'',0,1,0,0),(61,2,'塘沽区',2,'',0,1,0,0),(62,2,'汉沽区',2,'',0,1,0,0),(63,2,'大港区',2,'',0,1,0,0),(64,2,'东丽区',2,'',0,1,0,0),(65,2,'西青区',2,'',0,1,0,0),(66,2,'津南区',2,'',0,1,0,0),(67,2,'北辰区',2,'',0,1,0,0),(68,2,'武清区',2,'',0,1,0,0),(69,2,'宝坻区',2,'',0,1,0,0),(70,2,'宁河县',2,'',0,1,0,0),(71,2,'静海县',2,'',0,1,0,0),(72,2,'蓟县',2,'',0,1,0,0),(73,3,'石家庄市',2,'',0,1,0,0),(74,3,'唐山市',2,'',0,1,0,0),(75,3,'秦皇岛市',2,'',0,1,0,0),(76,3,'邯郸市',2,'',0,1,0,0),(77,3,'邢台市',2,'',0,1,0,0),(78,3,'保定市',2,'',0,1,0,0),(79,3,'张家口市',2,'',0,1,0,0),(80,3,'承德市',2,'',0,1,0,0),(81,3,'衡水市',2,'',0,1,0,0),(82,3,'廊坊市',2,'',0,1,0,0),(83,3,'沧州市',2,'',0,1,0,0),(84,4,'太原市',2,'',0,1,0,0),(85,4,'大同市',2,'',0,1,0,0),(86,4,'阳泉市',2,'',0,1,0,0),(87,4,'长治市',2,'',0,1,0,0),(88,4,'晋城市',2,'',0,1,0,0),(89,4,'朔州市',2,'',0,1,0,0),(90,4,'晋中市',2,'',0,1,0,0),(91,4,'运城市',2,'',0,1,0,0),(92,4,'忻州市',2,'',0,1,0,0),(93,4,'临汾市',2,'',0,1,0,0),(94,4,'吕梁市',2,'',0,1,0,0),(95,5,'呼和浩特市',2,'',0,1,0,0),(96,5,'包头市',2,'',0,1,0,0),(97,5,'乌海市',2,'',0,1,0,0),(98,5,'赤峰市',2,'',0,1,0,0),(99,5,'通辽市',2,'',0,1,0,0),(100,5,'鄂尔多斯市',2,'',0,1,0,0),(101,5,'呼伦贝尔市',2,'',0,1,0,0),(102,5,'巴彦淖尔市',2,'',0,1,0,0),(103,5,'乌兰察布市',2,'',0,1,0,0),(104,5,'兴安盟',2,'',0,1,0,0),(105,5,'锡林郭勒盟',2,'',0,1,0,0),(106,5,'阿拉善盟',2,'',0,1,0,0),(107,6,'沈阳市',2,'',0,1,0,0),(108,6,'大连市',2,'',0,1,0,0),(109,6,'鞍山市',2,'',0,1,0,0),(110,6,'抚顺市',2,'',0,1,0,0),(111,6,'本溪市',2,'',0,1,0,0),(112,6,'丹东市',2,'',0,1,0,0),(113,6,'锦州市',2,'',0,1,0,0),(114,6,'营口市',2,'',0,1,0,0),(115,6,'阜新市',2,'',0,1,0,0),(116,6,'辽阳市',2,'',0,1,0,0),(117,6,'盘锦市',2,'',0,1,0,0),(118,6,'铁岭市',2,'',0,1,0,0),(119,6,'朝阳市',2,'',0,1,0,0),(120,6,'葫芦岛市',2,'',0,1,0,0),(121,7,'长春市',2,'',0,1,0,0),(122,7,'吉林市',2,'',0,1,0,0),(123,7,'四平市',2,'',0,1,0,0),(124,7,'辽源市',2,'',0,1,0,0),(125,7,'通化市',2,'',0,1,0,0),(126,7,'白山市',2,'',0,1,0,0),(127,7,'松原市',2,'',0,1,0,0),(128,7,'白城市',2,'',0,1,0,0),(129,7,'延边朝鲜族自治州',2,'',0,1,0,0),(130,8,'哈尔滨市',2,'',0,1,0,0),(131,8,'齐齐哈尔市',2,'',0,1,0,0),(132,8,'鸡西市',2,'',0,1,0,0),(133,8,'鹤岗市',2,'',0,1,0,0),(134,8,'双鸭山市',2,'',0,1,0,0),(135,8,'大庆市',2,'',0,1,0,0),(136,8,'伊春市',2,'',0,1,0,0),(137,8,'佳木斯市',2,'',0,1,0,0),(138,8,'七台河市',2,'',0,1,0,0),(139,8,'牡丹江市',2,'',0,1,0,0),(140,8,'黑河市',2,'',0,1,0,0),(141,8,'绥化市',2,'',0,1,0,0),(142,8,'大兴安岭地区',2,'',0,1,0,0),(143,9,'黄浦区',2,'',0,1,0,0),(144,9,'卢湾区',2,'',0,1,0,0),(145,9,'徐汇区',2,'',0,1,0,0),(146,9,'长宁区',2,'',0,1,0,0),(147,9,'静安区',2,'',0,1,0,0),(148,9,'普陀区',2,'',0,1,0,0),(149,9,'闸北区',2,'',0,1,0,0),(150,9,'虹口区',2,'',0,1,0,0),(151,9,'杨浦区',2,'',0,1,0,0),(152,9,'闵行区',2,'',0,1,0,0),(153,9,'宝山区',2,'',0,1,0,0),(154,9,'嘉定区',2,'',0,1,0,0),(155,9,'浦东新区',2,'',0,1,0,0),(156,9,'金山区',2,'',0,1,0,0),(157,9,'松江区',2,'',0,1,0,0),(158,9,'青浦区',2,'',0,1,0,0),(159,9,'南汇区',2,'',0,1,0,0),(160,9,'奉贤区',2,'',0,1,0,0),(161,9,'崇明县',2,'',0,1,0,0),(162,10,'南京市',2,'',0,1,0,0),(163,10,'无锡市',2,'',0,1,0,0),(164,10,'徐州市',2,'',0,1,0,0),(165,10,'常州市',2,'',0,1,0,0),(166,10,'苏州市',2,'',0,1,0,0),(167,10,'南通市',2,'',0,1,0,0),(168,10,'连云港市',2,'',0,1,0,0),(169,10,'淮安市',2,'',0,1,0,0),(170,10,'盐城市',2,'',0,1,0,0),(171,10,'扬州市',2,'',0,1,0,0),(172,10,'镇江市',2,'',0,1,0,0),(173,10,'泰州市',2,'',0,1,0,0),(174,10,'宿迁市',2,'',0,1,0,0),(175,11,'杭州市',2,'',0,1,0,0),(176,11,'宁波市',2,'',0,1,0,0),(177,11,'温州市',2,'',0,1,0,0),(178,11,'嘉兴市',2,'',0,1,0,0),(179,11,'湖州市',2,'',0,1,0,0),(180,11,'绍兴市',2,'',0,1,0,0),(181,11,'舟山市',2,'',0,1,0,0),(182,11,'衢州市',2,'',0,1,0,0),(183,11,'金华市',2,'',0,1,0,0),(184,11,'台州市',2,'',0,1,0,0),(185,11,'丽水市',2,'',0,1,0,0),(186,12,'合肥市',2,'',0,1,0,0),(187,12,'芜湖市',2,'',0,1,0,0),(188,12,'蚌埠市',2,'',0,1,0,0),(189,12,'淮南市',2,'',0,1,0,0),(190,12,'马鞍山市',2,'',0,1,0,0),(191,12,'淮北市',2,'',0,1,0,0),(192,12,'铜陵市',2,'',0,1,0,0),(193,12,'安庆市',2,'',0,1,0,0),(194,12,'黄山市',2,'',0,1,0,0),(195,12,'滁州市',2,'',0,1,0,0),(196,12,'阜阳市',2,'',0,1,0,0),(197,12,'宿州市',2,'',0,1,0,0),(198,12,'巢湖市',2,'',0,1,0,0),(199,12,'六安市',2,'',0,1,0,0),(200,12,'亳州市',2,'',0,1,0,0),(201,12,'池州市',2,'',0,1,0,0),(202,12,'宣城市',2,'',0,1,0,0),(203,13,'福州市',2,'',0,1,0,0),(204,13,'厦门市',2,'',0,1,0,0),(205,13,'莆田市',2,'',0,1,0,0),(206,13,'三明市',2,'',0,1,0,0),(207,13,'泉州市',2,'',0,1,0,0),(208,13,'漳州市',2,'',0,1,0,0),(209,13,'南平市',2,'',0,1,0,0),(210,13,'龙岩市',2,'',0,1,0,0),(211,13,'宁德市',2,'',0,1,0,0),(212,14,'南昌市',2,'',0,1,0,0),(213,14,'景德镇市',2,'',0,1,0,0),(214,14,'萍乡市',2,'',0,1,0,0),(215,14,'九江市',2,'',0,1,0,0),(216,14,'新余市',2,'',0,1,0,0),(217,14,'鹰潭市',2,'',0,1,0,0),(218,14,'赣州市',2,'',0,1,0,0),(219,14,'吉安市',2,'',0,1,0,0),(220,14,'宜春市',2,'',0,1,0,0),(221,14,'抚州市',2,'',0,1,0,0),(222,14,'上饶市',2,'',0,1,0,0),(223,15,'济南市',2,'',0,1,0,0),(224,15,'青岛市',2,'',0,1,0,0),(225,15,'淄博市',2,'',0,1,0,0),(226,15,'枣庄市',2,'',0,1,0,0),(227,15,'东营市',2,'',0,1,0,0),(228,15,'烟台市',2,'',0,1,0,0),(229,15,'潍坊市',2,'',0,1,0,0),(230,15,'济宁市',2,'',0,1,0,0),(231,15,'泰安市',2,'',0,1,0,0),(232,15,'威海市',2,'',0,1,0,0),(233,15,'日照市',2,'',0,1,0,0),(234,15,'莱芜市',2,'',0,1,0,0),(235,15,'临沂市',2,'',0,1,0,0),(236,15,'德州市',2,'',0,1,0,0),(237,15,'聊城市',2,'',0,1,0,0),(238,15,'滨州市',2,'',0,1,0,0),(239,15,'菏泽市',2,'',0,1,0,0),(240,16,'郑州市',2,'',0,1,0,0),(241,16,'开封市',2,'',0,1,0,0),(242,16,'洛阳市',2,'',0,1,0,0),(243,16,'平顶山市',2,'',0,1,0,0),(244,16,'安阳市',2,'',0,1,0,0),(245,16,'鹤壁市',2,'',0,1,0,0),(246,16,'新乡市',2,'',0,1,0,0),(247,16,'焦作市',2,'',0,1,0,0),(248,16,'濮阳市',2,'',0,1,0,0),(249,16,'许昌市',2,'',0,1,0,0),(250,16,'漯河市',2,'',0,1,0,0),(251,16,'三门峡市',2,'',0,1,0,0),(252,16,'南阳市',2,'',0,1,0,0),(253,16,'商丘市',2,'',0,1,0,0),(254,16,'信阳市',2,'',0,1,0,0),(255,16,'周口市',2,'',0,1,0,0),(256,16,'驻马店市',2,'',0,1,0,0),(257,16,'济源市',2,'',0,1,0,0),(258,17,'武汉市',2,'',0,1,0,0),(259,17,'黄石市',2,'',0,1,0,0),(260,17,'十堰市',2,'',0,1,0,0),(261,17,'宜昌市',2,'',0,1,0,0),(262,17,'襄樊市',2,'',0,1,0,0),(263,17,'鄂州市',2,'',0,1,0,0),(264,17,'荆门市',2,'',0,1,0,0),(265,17,'孝感市',2,'',0,1,0,0),(266,17,'荆州市',2,'',0,1,0,0),(267,17,'黄冈市',2,'',0,1,0,0),(268,17,'咸宁市',2,'',0,1,0,0),(269,17,'随州市',2,'',0,1,0,0),(270,17,'恩施土家族苗族自治州',2,'',0,1,0,0),(271,17,'仙桃市',2,'',0,1,0,0),(272,17,'潜江市',2,'',0,1,0,0),(273,17,'天门市',2,'',0,1,0,0),(274,17,'神农架林区',2,'',0,1,0,0),(275,18,'长沙市',2,'',0,1,0,0),(276,18,'株洲市',2,'',0,1,0,0),(277,18,'湘潭市',2,'',0,1,0,0),(278,18,'衡阳市',2,'',0,1,0,0),(279,18,'邵阳市',2,'',0,1,0,0),(280,18,'岳阳市',2,'',0,1,0,0),(281,18,'常德市',2,'',0,1,0,0),(282,18,'张家界市',2,'',0,1,0,0),(283,18,'益阳市',2,'',0,1,0,0),(284,18,'郴州市',2,'',0,1,0,0),(285,18,'永州市',2,'',0,1,0,0),(286,18,'怀化市',2,'',0,1,0,0),(287,18,'娄底市',2,'',0,1,0,0),(288,18,'湘西土家族苗族自治州',2,'',0,1,0,0),(289,19,'广州市',2,'',0,1,0,0),(290,19,'韶关市',2,'',0,1,0,0),(291,19,'深圳市',2,'',0,1,0,0),(292,19,'珠海市',2,'',0,1,0,0),(293,19,'汕头市',2,'',0,1,0,0),(294,19,'佛山市',2,'',0,1,0,0),(295,19,'江门市',2,'',0,1,0,0),(296,19,'湛江市',2,'',0,1,0,0),(297,19,'茂名市',2,'',0,1,0,0),(298,19,'肇庆市',2,'',0,1,0,0),(299,19,'惠州市',2,'',0,1,0,0),(300,19,'梅州市',2,'',0,1,0,0),(301,19,'汕尾市',2,'',0,1,0,0),(302,19,'河源市',2,'',0,1,0,0),(303,19,'阳江市',2,'',0,1,0,0),(304,19,'清远市',2,'',0,1,0,0),(305,19,'东莞市',2,'',0,1,0,0),(306,19,'中山市',2,'',0,1,0,0),(307,19,'潮州市',2,'',0,1,0,0),(308,19,'揭阳市',2,'',0,1,0,0),(309,19,'云浮市',2,'',0,1,0,0),(310,20,'南宁市',2,'',0,1,0,0),(311,20,'柳州市',2,'',0,1,0,0),(312,20,'桂林市',2,'',0,1,0,0),(313,20,'梧州市',2,'',0,1,0,0),(314,20,'北海市',2,'',0,1,0,0),(315,20,'防城港市',2,'',0,1,0,0),(316,20,'钦州市',2,'',0,1,0,0),(317,20,'贵港市',2,'',0,1,0,0),(318,20,'玉林市',2,'',0,1,0,0),(319,20,'百色市',2,'',0,1,0,0),(320,20,'贺州市',2,'',0,1,0,0),(321,20,'河池市',2,'',0,1,0,0),(322,20,'来宾市',2,'',0,1,0,0),(323,20,'崇左市',2,'',0,1,0,0),(324,21,'海口市',2,'',0,1,0,0),(325,21,'三亚市',2,'',0,1,0,0),(326,21,'五指山市',2,'',0,1,0,0),(327,21,'琼海市',2,'',0,1,0,0),(328,21,'儋州市',2,'',0,1,0,0),(329,21,'文昌市',2,'',0,1,0,0),(330,21,'万宁市',2,'',0,1,0,0),(331,21,'东方市',2,'',0,1,0,0),(332,21,'定安县',2,'',0,1,0,0),(333,21,'屯昌县',2,'',0,1,0,0),(334,21,'澄迈县',2,'',0,1,0,0),(335,21,'临高县',2,'',0,1,0,0),(336,21,'白沙黎族自治县',2,'',0,1,0,0),(337,21,'昌江黎族自治县',2,'',0,1,0,0),(338,21,'乐东黎族自治县',2,'',0,1,0,0),(339,21,'陵水黎族自治县',2,'',0,1,0,0),(340,21,'保亭黎族苗族自治县',2,'',0,1,0,0),(341,21,'琼中黎族苗族自治县',2,'',0,1,0,0),(342,21,'西沙群岛',2,'',0,1,0,0),(343,21,'南沙群岛',2,'',0,1,0,0),(344,21,'中沙群岛的岛礁及其海域',2,'',0,1,0,0),(345,22,'万州区',2,'',0,1,0,0),(346,22,'涪陵区',2,'',0,1,0,0),(347,22,'渝中区',2,'',0,1,0,0),(348,22,'大渡口区',2,'',0,1,0,0),(349,22,'江北区',2,'',0,1,0,0),(350,22,'沙坪坝区',2,'',0,1,0,0),(351,22,'九龙坡区',2,'',0,1,0,0),(352,22,'南岸区',2,'',0,1,0,0),(353,22,'北碚区',2,'',0,1,0,0),(354,22,'双桥区',2,'',0,1,0,0),(355,22,'万盛区',2,'',0,1,0,0),(356,22,'渝北区',2,'',0,1,0,0),(357,22,'巴南区',2,'',0,1,0,0),(358,22,'黔江区',2,'',0,1,0,0),(359,22,'长寿区',2,'',0,1,0,0),(360,22,'綦江县',2,'',0,1,0,0),(361,22,'潼南县',2,'',0,1,0,0),(362,22,'铜梁县',2,'',0,1,0,0),(363,22,'大足县',2,'',0,1,0,0),(364,22,'荣昌县',2,'',0,1,0,0),(365,22,'璧山县',2,'',0,1,0,0),(366,22,'梁平县',2,'',0,1,0,0),(367,22,'城口县',2,'',0,1,0,0),(368,22,'丰都县',2,'',0,1,0,0),(369,22,'垫江县',2,'',0,1,0,0),(370,22,'武隆县',2,'',0,1,0,0),(371,22,'忠县',2,'',0,1,0,0),(372,22,'开县',2,'',0,1,0,0),(373,22,'云阳县',2,'',0,1,0,0),(374,22,'奉节县',2,'',0,1,0,0),(375,22,'巫山县',2,'',0,1,0,0),(376,22,'巫溪县',2,'',0,1,0,0),(377,22,'石柱土家族自治县',2,'',0,1,0,0),(378,22,'秀山土家族苗族自治县',2,'',0,1,0,0),(379,22,'酉阳土家族苗族自治县',2,'',0,1,0,0),(380,22,'彭水苗族土家族自治县',2,'',0,1,0,0),(381,22,'江津市',2,'',0,1,0,0),(382,22,'合川市',2,'',0,1,0,0),(383,22,'永川市',2,'',0,1,0,0),(384,22,'南川市',2,'',0,1,0,0),(385,23,'成都市',2,'',0,1,0,0),(386,23,'自贡市',2,'',0,1,0,0),(387,23,'攀枝花市',2,'',0,1,0,0),(388,23,'泸州市',2,'',0,1,0,0),(389,23,'德阳市',2,'',0,1,0,0),(390,23,'绵阳市',2,'',0,1,0,0),(391,23,'广元市',2,'',0,1,0,0),(392,23,'遂宁市',2,'',0,1,0,0),(393,23,'内江市',2,'',0,1,0,0),(394,23,'乐山市',2,'',0,1,0,0),(395,23,'南充市',2,'',0,1,0,0),(396,23,'眉山市',2,'',0,1,0,0),(397,23,'宜宾市',2,'',0,1,0,0),(398,23,'广安市',2,'',0,1,0,0),(399,23,'达州市',2,'',0,1,0,0),(400,23,'雅安市',2,'',0,1,0,0),(401,23,'巴中市',2,'',0,1,0,0),(402,23,'资阳市',2,'',0,1,0,0),(403,23,'阿坝藏族羌族自治州',2,'',0,1,0,0),(404,23,'甘孜藏族自治州',2,'',0,1,0,0),(405,23,'凉山彝族自治州',2,'',0,1,0,0),(406,24,'贵阳市',2,'',0,1,0,0),(407,24,'六盘水市',2,'',0,1,0,0),(408,24,'遵义市',2,'',0,1,0,0),(409,24,'安顺市',2,'',0,1,0,0),(410,24,'铜仁地区',2,'',0,1,0,0),(411,24,'黔西南布依族苗族自治州',2,'',0,1,0,0),(412,24,'毕节地区',2,'',0,1,0,0),(413,24,'黔东南苗族侗族自治州',2,'',0,1,0,0),(414,24,'黔南布依族苗族自治州',2,'',0,1,0,0),(415,25,'昆明市',2,'',0,1,0,0),(416,25,'曲靖市',2,'',0,1,0,0),(417,25,'玉溪市',2,'',0,1,0,0),(418,25,'保山市',2,'',0,1,0,0),(419,25,'昭通市',2,'',0,1,0,0),(420,25,'丽江市',2,'',0,1,0,0),(421,25,'思茅市',2,'',0,1,0,0),(422,25,'临沧市',2,'',0,1,0,0),(423,25,'楚雄彝族自治州',2,'',0,1,0,0),(424,25,'红河哈尼族彝族自治州',2,'',0,1,0,0),(425,25,'文山壮族苗族自治州',2,'',0,1,0,0),(426,25,'西双版纳傣族自治州',2,'',0,1,0,0),(427,25,'大理白族自治州',2,'',0,1,0,0),(428,25,'德宏傣族景颇族自治州',2,'',0,1,0,0),(429,25,'怒江傈僳族自治州',2,'',0,1,0,0),(430,25,'迪庆藏族自治州',2,'',0,1,0,0),(431,26,'拉萨市',2,'',0,1,0,0),(432,26,'昌都地区',2,'',0,1,0,0),(433,26,'山南地区',2,'',0,1,0,0),(434,26,'日喀则地区',2,'',0,1,0,0),(435,26,'那曲地区',2,'',0,1,0,0),(436,26,'阿里地区',2,'',0,1,0,0),(437,26,'林芝地区',2,'',0,1,0,0),(438,27,'西安市',2,'',0,1,0,0),(439,27,'铜川市',2,'',0,1,0,0),(440,27,'宝鸡市',2,'',0,1,0,0),(441,27,'咸阳市',2,'',0,1,0,0),(442,27,'渭南市',2,'',0,1,0,0),(443,27,'延安市',2,'',0,1,0,0),(444,27,'汉中市',2,'',0,1,0,0),(445,27,'榆林市',2,'',0,1,0,0),(446,27,'安康市',2,'',0,1,0,0),(447,27,'商洛市',2,'',0,1,0,0),(448,28,'兰州市',2,'',0,1,0,0),(449,28,'嘉峪关市',2,'',0,1,0,0),(450,28,'金昌市',2,'',0,1,0,0),(451,28,'白银市',2,'',0,1,0,0),(452,28,'天水市',2,'',0,1,0,0),(453,28,'武威市',2,'',0,1,0,0),(454,28,'张掖市',2,'',0,1,0,0),(455,28,'平凉市',2,'',0,1,0,0),(456,28,'酒泉市',2,'',0,1,0,0),(457,28,'庆阳市',2,'',0,1,0,0),(458,28,'定西市',2,'',0,1,0,0),(459,28,'陇南市',2,'',0,1,0,0),(460,28,'临夏回族自治州',2,'',0,1,0,0),(461,28,'甘南藏族自治州',2,'',0,1,0,0),(462,29,'西宁市',2,'',0,1,0,0),(463,29,'海东地区',2,'',0,1,0,0),(464,29,'海北藏族自治州',2,'',0,1,0,0),(465,29,'黄南藏族自治州',2,'',0,1,0,0),(466,29,'海南藏族自治州',2,'',0,1,0,0),(467,29,'果洛藏族自治州',2,'',0,1,0,0),(468,29,'玉树藏族自治州',2,'',0,1,0,0),(469,29,'海西蒙古族藏族自治州',2,'',0,1,0,0),(470,30,'银川市',2,'',0,1,0,0),(471,30,'石嘴山市',2,'',0,1,0,0),(472,30,'吴忠市',2,'',0,1,0,0),(473,30,'固原市',2,'',0,1,0,0),(474,30,'中卫市',2,'',0,1,0,0),(475,31,'乌鲁木齐市',2,'',0,1,0,0),(476,31,'克拉玛依市',2,'',0,1,0,0),(477,31,'吐鲁番地区',2,'',0,1,0,0),(478,31,'哈密地区',2,'',0,1,0,0),(479,31,'昌吉回族自治州',2,'',0,1,0,0),(480,31,'博尔塔拉蒙古自治州',2,'',0,1,0,0),(481,31,'巴音郭楞蒙古自治州',2,'',0,1,0,0),(482,31,'阿克苏地区',2,'',0,1,0,0),(483,31,'克孜勒苏柯尔克孜自治州',2,'',0,1,0,0),(484,31,'喀什地区',2,'',0,1,0,0),(485,31,'和田地区',2,'',0,1,0,0),(486,31,'伊犁哈萨克自治州',2,'',0,1,0,0),(487,31,'塔城地区',2,'',0,1,0,0),(488,31,'阿勒泰地区',2,'',0,1,0,0),(489,31,'石河子市',2,'',0,1,0,0),(490,31,'阿拉尔市',2,'',0,1,0,0),(491,31,'图木舒克市',2,'',0,1,0,0),(492,31,'五家渠市',2,'',0,1,0,0),(493,32,'台北市',2,'',0,1,0,0),(494,32,'高雄市',2,'',0,1,0,0),(495,32,'基隆市',2,'',0,1,0,0),(496,32,'台中市',2,'',0,1,0,0),(497,32,'台南市',2,'',0,1,0,0),(498,32,'新竹市',2,'',0,1,0,0),(499,32,'嘉义市',2,'',0,1,0,0),(500,32,'台北县',2,'',0,1,0,0),(501,32,'宜兰县',2,'',0,1,0,0),(502,32,'桃园县',2,'',0,1,0,0),(503,32,'新竹县',2,'',0,1,0,0),(504,32,'苗栗县',2,'',0,1,0,0),(505,32,'台中县',2,'',0,1,0,0),(506,32,'彰化县',2,'',0,1,0,0),(507,32,'南投县',2,'',0,1,0,0),(508,32,'云林县',2,'',0,1,0,0),(509,32,'嘉义县',2,'',0,1,0,0),(510,32,'台南县',2,'',0,1,0,0),(511,32,'高雄县',2,'',0,1,0,0),(512,32,'屏东县',2,'',0,1,0,0),(513,32,'澎湖县',2,'',0,1,0,0),(514,32,'台东县',2,'',0,1,0,0),(515,32,'花莲县',2,'',0,1,0,0),(516,33,'中西区',2,'',0,1,0,0),(517,33,'东区',2,'',0,1,0,0),(518,33,'九龙城区',2,'',0,1,0,0),(519,33,'观塘区',2,'',0,1,0,0),(520,33,'南区',2,'',0,1,0,0),(521,33,'深水埗区',2,'',0,1,0,0),(522,33,'黄大仙区',2,'',0,1,0,0),(523,33,'湾仔区',2,'',0,1,0,0),(524,33,'油尖旺区',2,'',0,1,0,0),(525,33,'离岛区',2,'',0,1,0,0),(526,33,'葵青区',2,'',0,1,0,0),(527,33,'北区',2,'',0,1,0,0),(528,33,'西贡区',2,'',0,1,0,0),(529,33,'沙田区',2,'',0,1,0,0),(530,33,'屯门区',2,'',0,1,0,0),(531,33,'大埔区',2,'',0,1,0,0),(532,33,'荃湾区',2,'',0,1,0,0),(533,33,'元朗区',2,'',0,1,0,0),(534,34,'澳门特别行政区',2,'',0,1,0,0),(535,35,'美国',2,'',0,1,0,0),(536,35,'加拿大',2,'',0,1,0,0),(537,35,'澳大利亚',2,'',0,1,0,0),(538,35,'新西兰',2,'',0,1,0,0),(539,35,'英国',2,'',0,1,0,0),(540,35,'法国',2,'',0,1,0,0),(541,35,'德国',2,'',0,1,0,0),(542,35,'捷克',2,'',0,1,0,0),(543,35,'荷兰',2,'',0,1,0,0),(544,35,'瑞士',2,'',0,1,0,0),(545,35,'希腊',2,'',0,1,0,0),(546,35,'挪威',2,'',0,1,0,0),(547,35,'瑞典',2,'',0,1,0,0),(548,35,'丹麦',2,'',0,1,0,0),(549,35,'芬兰',2,'',0,1,0,0),(550,35,'爱尔兰',2,'',0,1,0,0),(551,35,'奥地利',2,'',0,1,0,0),(552,35,'意大利',2,'',0,1,0,0),(553,35,'乌克兰',2,'',0,1,0,0),(554,35,'俄罗斯',2,'',0,1,0,0),(555,35,'西班牙',2,'',0,1,0,0),(556,35,'韩国',2,'',0,1,0,0),(557,35,'新加坡',2,'',0,1,0,0),(558,35,'马来西亚',2,'',0,1,0,0),(559,35,'印度',2,'',0,1,0,0),(560,35,'泰国',2,'',0,1,0,0),(561,35,'日本',2,'',0,1,0,0),(562,35,'巴西',2,'',0,1,0,0),(563,35,'阿根廷',2,'',0,1,0,0),(564,35,'南非',2,'',0,1,0,0),(565,35,'埃及',2,'',0,1,0,0),(566,36,'其它',2,'',0,1,0,0),(567,37,'东华门街道',3,'',0,1,0,0),(568,37,'东四街道',3,'',0,1,0,0),(569,37,'东直门街道',3,'',0,1,0,0),(570,37,'交道口街道',3,'',0,1,0,0),(571,37,'北新桥街道',3,'',0,1,0,0),(572,37,'和平里街道',3,'',0,1,0,0),(573,37,'安定门街道',3,'',0,1,0,0),(574,37,'建国门街道',3,'',0,1,0,0),(575,37,'景山街道',3,'',0,1,0,0),(576,37,'朝阳门街道',3,'',0,1,0,0),(577,38,'什刹海街道',3,'',0,1,0,0),(578,38,'展览路街道',3,'',0,1,0,0),(579,38,'德胜街道',3,'',0,1,0,0),(580,38,'新街口街道',3,'',0,1,0,0),(581,38,'月坛街道',3,'',0,1,0,0),(582,38,'西长安街街道',3,'',0,1,0,0),(583,38,'金融街街道',3,'',0,1,0,0),(584,39,'东花市街道',3,'',0,1,0,0),(585,39,'体育馆路街道',3,'',0,1,0,0),(586,39,'前门街道',3,'',0,1,0,0),(587,39,'天坛街道',3,'',0,1,0,0),(588,39,'崇文门外街道',3,'',0,1,0,0),(589,39,'永定门外街道',3,'',0,1,0,0),(590,39,'龙潭街道',3,'',0,1,0,0),(591,40,'大栅栏街道',3,'',0,1,0,0),(592,40,'天桥街道',3,'',0,1,0,0),(593,40,'广安门内街道',3,'',0,1,0,0),(594,40,'广安门外街道',3,'',0,1,0,0),(595,40,'椿树街道',3,'',0,1,0,0),(596,40,'牛街街道',3,'',0,1,0,0),(597,40,'白纸坊街道',3,'',0,1,0,0),(598,40,'陶然亭街道',3,'',0,1,0,0),(599,41,'三里屯街道',3,'',0,1,0,0),(600,41,'三间房地区（三间房乡）',3,'',0,1,0,0),(601,41,'东坝地区（东坝乡）',3,'',0,1,0,0),(602,41,'东风地区（东风乡）',3,'',0,1,0,0),(603,41,'亚运村街道',3,'',0,1,0,0),(604,41,'八里庄街道',3,'',0,1,0,0),(605,41,'六里屯街道',3,'',0,1,0,0),(606,41,'劲松街道',3,'',0,1,0,0),(607,41,'十八里店地区（十八里店乡）',3,'',0,1,0,0),(608,41,'南磨房地区（南磨房乡）',3,'',0,1,0,0),(609,41,'双井街道',3,'',0,1,0,0),(610,41,'呼家楼街道',3,'',0,1,0,0),(611,41,'和平街街道',3,'',0,1,0,0),(612,41,'团结湖街道',3,'',0,1,0,0),(613,41,'垡头街道',3,'',0,1,0,0),(614,41,'大屯街道',3,'',0,1,0,0),(615,41,'太阳宫地区（太阳宫乡）',3,'',0,1,0,0),(616,41,'奥运村地区（奥运村乡）',3,'',0,1,0,0),(617,41,'孙河地区（孙河乡）',3,'',0,1,0,0),(618,41,'安贞街道',3,'',0,1,0,0),(619,41,'将台地区（将台乡）',3,'',0,1,0,0),(620,41,'小关街道',3,'',0,1,0,0),(621,41,'小红门地区（小红门乡）',3,'',0,1,0,0),(622,41,'崔各庄地区（崔各庄乡）',3,'',0,1,0,0),(623,41,'左家庄街道',3,'',0,1,0,0),(624,41,'常营回族地区（常营回族乡）',3,'',0,1,0,0),(625,41,'平房地区（平房乡）',3,'',0,1,0,0),(626,41,'建国门外街道',3,'',0,1,0,0),(627,41,'望京开发街道',3,'',0,1,0,0),(628,41,'望京街道',3,'',0,1,0,0),(629,41,'朝阳门外街道',3,'',0,1,0,0),(630,41,'来广营地区（来广营乡）',3,'',0,1,0,0),(631,41,'潘家园街道',3,'',0,1,0,0),(632,41,'王四营地区（王四营乡）',3,'',0,1,0,0),(633,41,'管庄地区（管庄乡）',3,'',0,1,0,0),(634,41,'豆各庄地区（豆各庄乡）',3,'',0,1,0,0),(635,41,'酒仙桥街道',3,'',0,1,0,0),(636,41,'金盏地区（金盏乡）',3,'',0,1,0,0),(637,41,'首都机场街道',3,'',0,1,0,0),(638,41,'香河园街道',3,'',0,1,0,0),(639,41,'高碑店地区（高碑店乡）',3,'',0,1,0,0),(640,41,'麦子店街道',3,'',0,1,0,0),(641,41,'黑庄户地区（黑庄户乡）',3,'',0,1,0,0),(642,42,'东铁匠营街道',3,'',0,1,0,0),(643,42,'东高地街道',3,'',0,1,0,0),(644,42,'丰台街道',3,'',0,1,0,0),(645,42,'云岗街道',3,'',0,1,0,0),(646,42,'南苑乡',3,'',0,1,0,0),(647,42,'南苑街道',3,'',0,1,0,0),(648,42,'卢沟桥乡',3,'',0,1,0,0),(649,42,'卢沟桥街道',3,'',0,1,0,0),(650,42,'右安门街道',3,'',0,1,0,0),(651,42,'和义街道',3,'',0,1,0,0),(652,42,'大红门街道',3,'',0,1,0,0),(653,42,'太平桥街道',3,'',0,1,0,0),(654,42,'宛平城地区',3,'',0,1,0,0),(655,42,'新村街道',3,'',0,1,0,0),(656,42,'方庄地区',3,'',0,1,0,0),(657,42,'王佐镇',3,'',0,1,0,0),(658,42,'花乡乡',3,'',0,1,0,0),(659,42,'西罗园街道',3,'',0,1,0,0),(660,42,'长辛店街道',3,'',0,1,0,0),(661,42,'长辛店镇',3,'',0,1,0,0),(662,42,'马家堡街道',3,'',0,1,0,0),(663,43,'五里坨街道',3,'',0,1,0,0),(664,43,'八宝山街道',3,'',0,1,0,0),(665,43,'八角街道',3,'',0,1,0,0),(666,43,'北辛安街道',3,'',0,1,0,0),(667,43,'古城街道',3,'',0,1,0,0),(668,43,'广宁街道',3,'',0,1,0,0),(669,43,'老山街道',3,'',0,1,0,0),(670,43,'苹果园街道',3,'',0,1,0,0),(671,43,'金顶街街道',3,'',0,1,0,0),(672,43,'鲁谷街道',3,'',0,1,0,0),(673,44,'万寿路街道',3,'',0,1,0,0),(674,44,'万柳地区（海淀乡）',3,'',0,1,0,0),(675,44,'上地街道',3,'',0,1,0,0),(676,44,'上庄镇',3,'',0,1,0,0),(677,44,'东升地区（东升乡）',3,'',0,1,0,0),(678,44,'中关村街道',3,'',0,1,0,0),(679,44,'八里庄街道',3,'',0,1,0,0),(680,44,'北下关街道',3,'',0,1,0,0),(681,44,'北太平庄街道',3,'',0,1,0,0),(682,44,'四季青镇',3,'',0,1,0,0),(683,44,'学院路街道',3,'',0,1,0,0),(684,44,'曙光街道',3,'',0,1,0,0),(685,44,'永定路街道',3,'',0,1,0,0),(686,44,'海淀街道',3,'',0,1,0,0),(687,44,'清华园街道',3,'',0,1,0,0),(688,44,'清河街道',3,'',0,1,0,0),(689,44,'温泉镇',3,'',0,1,0,0),(690,44,'燕园街道',3,'',0,1,0,0),(691,44,'甘家口街道',3,'',0,1,0,0),(692,44,'田村路街道',3,'',0,1,0,0),(693,44,'紫竹院街道',3,'',0,1,0,0),(694,44,'羊坊店街道',3,'',0,1,0,0),(695,44,'花园路街道',3,'',0,1,0,0),(696,44,'苏家坨镇',3,'',0,1,0,0),(697,44,'西三旗街道',3,'',0,1,0,0),(698,44,'西北旺镇',3,'',0,1,0,0),(699,44,'青龙桥街道',3,'',0,1,0,0),(700,44,'香山街道',3,'',0,1,0,0),(701,44,'马连洼街道',3,'',0,1,0,0),(702,45,'东辛房街道',3,'',0,1,0,0),(703,45,'军庄镇',3,'',0,1,0,0),(704,45,'城子街道',3,'',0,1,0,0),(705,45,'大台街道',3,'',0,1,0,0),(706,45,'大峪街道',3,'',0,1,0,0),(707,45,'妙峰山镇',3,'',0,1,0,0),(708,45,'斋堂镇',3,'',0,1,0,0),(709,45,'永定镇',3,'',0,1,0,0),(710,45,'清水镇',3,'',0,1,0,0),(711,45,'潭柘寺镇',3,'',0,1,0,0),(712,45,'王平地区',3,'',0,1,0,0),(713,45,'雁翅镇',3,'',0,1,0,0),(714,45,'龙泉镇',3,'',0,1,0,0),(715,46,'东风街道',3,'',0,1,0,0),(716,46,'佛子庄乡',3,'',0,1,0,0),(717,46,'十渡镇',3,'',0,1,0,0),(718,46,'南窖乡',3,'',0,1,0,0),(719,46,'史家营乡',3,'',0,1,0,0),(720,46,'向阳街道',3,'',0,1,0,0),(721,46,'周口店地区',3,'',0,1,0,0),(722,46,'城关街道',3,'',0,1,0,0),(723,46,'大安山乡',3,'',0,1,0,0),(724,46,'大石窝镇',3,'',0,1,0,0),(725,46,'张坊镇',3,'',0,1,0,0),(726,46,'拱辰街道',3,'',0,1,0,0),(727,46,'新镇街道',3,'',0,1,0,0),(728,46,'星城街道',3,'',0,1,0,0),(729,46,'河北镇',3,'',0,1,0,0),(730,46,'琉璃河地区',3,'',0,1,0,0),(731,46,'石楼镇',3,'',0,1,0,0),(732,46,'窦店镇',3,'',0,1,0,0),(733,46,'良乡地区',3,'',0,1,0,0),(734,46,'蒲洼乡',3,'',0,1,0,0),(735,46,'西潞街道',3,'',0,1,0,0),(736,46,'迎风街道',3,'',0,1,0,0),(737,46,'长沟镇',3,'',0,1,0,0),(738,46,'长阳镇',3,'',0,1,0,0),(739,46,'阎村镇',3,'',0,1,0,0),(740,46,'霞云岭乡',3,'',0,1,0,0),(741,46,'青龙湖镇',3,'',0,1,0,0),(742,46,'韩村河镇',3,'',0,1,0,0),(743,47,'中仓街道',3,'',0,1,0,0),(744,47,'于家务回族乡',3,'',0,1,0,0),(745,47,'北苑街道',3,'',0,1,0,0),(746,47,'台湖镇',3,'',0,1,0,0),(747,47,'宋庄镇',3,'',0,1,0,0),(748,47,'张家湾镇',3,'',0,1,0,0),(749,47,'新华街道',3,'',0,1,0,0),(750,47,'梨园地区',3,'',0,1,0,0),(751,47,'永乐店镇',3,'',0,1,0,0),(752,47,'永顺地区',3,'',0,1,0,0),(753,47,'漷县镇',3,'',0,1,0,0),(754,47,'潞城镇',3,'',0,1,0,0),(755,47,'玉桥街道',3,'',0,1,0,0),(756,47,'西集镇',3,'',0,1,0,0),(757,47,'马驹桥镇',3,'',0,1,0,0),(758,48,'仁和地区',3,'',0,1,0,0),(759,48,'光明街道',3,'',0,1,0,0),(760,48,'北务镇',3,'',0,1,0,0),(761,48,'北小营镇',3,'',0,1,0,0),(762,48,'北石槽镇',3,'',0,1,0,0),(763,48,'南彩镇',3,'',0,1,0,0),(764,48,'南法信地区',3,'',0,1,0,0),(765,48,'后沙峪地区',3,'',0,1,0,0),(766,48,'大孙各庄镇',3,'',0,1,0,0),(767,48,'天竺地区',3,'',0,1,0,0),(768,48,'张镇',3,'',0,1,0,0),(769,48,'木林镇',3,'',0,1,0,0),(770,48,'李桥镇',3,'',0,1,0,0),(771,48,'李遂镇',3,'',0,1,0,0),(772,48,'杨镇地区',3,'',0,1,0,0),(773,48,'牛栏山地区',3,'',0,1,0,0),(774,48,'石园街道',3,'',0,1,0,0),(775,48,'胜利街道',3,'',0,1,0,0),(776,48,'赵全营镇',3,'',0,1,0,0),(777,48,'马坡地区',3,'',0,1,0,0),(778,48,'高丽营镇',3,'',0,1,0,0),(779,48,'龙湾屯镇',3,'',0,1,0,0),(780,49,'东小口地区',3,'',0,1,0,0),(781,49,'兴寿镇',3,'',0,1,0,0),(782,49,'北七家镇',3,'',0,1,0,0),(783,49,'十三陵镇',3,'',0,1,0,0),(784,49,'南口地区',3,'',0,1,0,0),(785,49,'南邵镇',3,'',0,1,0,0),(786,49,'回龙观地区',3,'',0,1,0,0),(787,49,'城北街道',3,'',0,1,0,0),(788,49,'城南街道',3,'',0,1,0,0),(789,49,'小汤山镇',3,'',0,1,0,0),(790,49,'崔村镇',3,'',0,1,0,0),(791,49,'沙河地区',3,'',0,1,0,0),(792,49,'流村镇',3,'',0,1,0,0),(793,49,'百善镇',3,'',0,1,0,0),(794,49,'长陵镇',3,'',0,1,0,0),(795,49,'阳坊镇',3,'',0,1,0,0),(796,49,'马池口地区',3,'',0,1,0,0),(797,50,'亦庄地区（亦庄镇）',3,'',0,1,0,0),(798,50,'兴丰街道',3,'',0,1,0,0),(799,50,'北臧村镇',3,'',0,1,0,0),(800,50,'安定镇',3,'',0,1,0,0),(801,50,'庞各庄镇',3,'',0,1,0,0),(802,50,'旧宫地区（旧宫镇）',3,'',0,1,0,0),(803,50,'林校路街道',3,'',0,1,0,0),(804,50,'榆垡镇',3,'',0,1,0,0),(805,50,'清源街道',3,'',0,1,0,0),(806,50,'瀛海镇',3,'',0,1,0,0),(807,50,'礼贤镇',3,'',0,1,0,0),(808,50,'西红门地区（西红门镇）',3,'',0,1,0,0),(809,50,'采育镇',3,'',0,1,0,0),(810,50,'长子营镇',3,'',0,1,0,0),(811,50,'青云店镇',3,'',0,1,0,0),(812,50,'魏善庄镇',3,'',0,1,0,0),(813,50,'黄村地区（黄村镇）',3,'',0,1,0,0),(814,51,'九渡河镇',3,'',0,1,0,0),(815,51,'北房镇',3,'',0,1,0,0),(816,51,'喇叭沟门满族乡',3,'',0,1,0,0),(817,51,'宝山镇',3,'',0,1,0,0),(818,51,'庙城地区',3,'',0,1,0,0),(819,51,'怀北镇',3,'',0,1,0,0),(820,51,'怀柔地区',3,'',0,1,0,0),(821,51,'杨宋镇',3,'',0,1,0,0),(822,51,'桥梓镇',3,'',0,1,0,0),(823,51,'汤河口镇',3,'',0,1,0,0),(824,51,'泉河街道',3,'',0,1,0,0),(825,51,'渤海镇',3,'',0,1,0,0),(826,51,'琉璃庙镇',3,'',0,1,0,0),(827,51,'长哨营满族乡',3,'',0,1,0,0),(828,51,'雁栖地区',3,'',0,1,0,0),(829,51,'龙山街道',3,'',0,1,0,0),(830,52,'东高村镇',3,'',0,1,0,0),(831,52,'兴谷街道',3,'',0,1,0,0),(832,52,'刘家店镇',3,'',0,1,0,0),(833,52,'南独乐河镇',3,'',0,1,0,0),(834,52,'夏各庄镇',3,'',0,1,0,0),(835,52,'大兴庄镇',3,'',0,1,0,0),(836,52,'大华山镇',3,'',0,1,0,0),(837,52,'山东庄镇',3,'',0,1,0,0),(838,52,'峪口地区',3,'',0,1,0,0),(839,52,'渔阳地区',3,'',0,1,0,0),(840,52,'滨河街道',3,'',0,1,0,0),(841,52,'熊儿寨乡',3,'',0,1,0,0),(842,52,'王辛庄镇',3,'',0,1,0,0),(843,52,'金海湖地区',3,'',0,1,0,0),(844,52,'镇罗营镇',3,'',0,1,0,0),(845,52,'马坊地区',3,'',0,1,0,0),(846,52,'马昌营镇',3,'',0,1,0,0),(847,52,'黄松峪乡',3,'',0,1,0,0),(848,53,'不老屯镇',3,'',0,1,0,0),(849,53,'东邵渠镇',3,'',0,1,0,0),(850,53,'冯家峪镇',3,'',0,1,0,0),(851,53,'北庄镇',3,'',0,1,0,0),(852,53,'十里堡镇',3,'',0,1,0,0),(853,53,'古北口镇',3,'',0,1,0,0),(854,53,'大城子镇',3,'',0,1,0,0),(855,53,'太师屯镇',3,'',0,1,0,0),(856,53,'密云镇',3,'',0,1,0,0),(857,53,'巨各庄镇',3,'',0,1,0,0),(858,53,'新城子镇',3,'',0,1,0,0),(859,53,'果园街道',3,'',0,1,0,0),(860,53,'檀营地区（檀营满族蒙古族乡）',3,'',0,1,0,0),(861,53,'河南寨镇',3,'',0,1,0,0),(862,53,'溪翁庄镇',3,'',0,1,0,0),(863,53,'石城镇',3,'',0,1,0,0),(864,53,'穆家峪镇',3,'',0,1,0,0),(865,53,'西田各庄镇',3,'',0,1,0,0),(866,53,'高岭镇',3,'',0,1,0,0),(867,53,'鼓楼街道',3,'',0,1,0,0),(868,54,'井庄镇',3,'',0,1,0,0),(869,54,'八达岭镇',3,'',0,1,0,0),(870,54,'刘斌堡乡',3,'',0,1,0,0),(871,54,'千家店镇',3,'',0,1,0,0),(872,54,'四海镇',3,'',0,1,0,0),(873,54,'大庄科乡',3,'',0,1,0,0),(874,54,'大榆树镇',3,'',0,1,0,0),(875,54,'康庄镇',3,'',0,1,0,0),(876,54,'延庆镇',3,'',0,1,0,0),(877,54,'张山营镇',3,'',0,1,0,0),(878,54,'旧县镇',3,'',0,1,0,0),(879,54,'永宁镇',3,'',0,1,0,0),(880,54,'沈家营镇',3,'',0,1,0,0),(881,54,'珍珠泉乡',3,'',0,1,0,0),(882,54,'香营乡',3,'',0,1,0,0),(883,55,'体育馆街道',3,'',0,1,0,0),(884,55,'劝业场街道',3,'',0,1,0,0),(885,55,'南市街道',3,'',0,1,0,0),(886,55,'南营门街道',3,'',0,1,0,0),(887,55,'小白楼街道',3,'',0,1,0,0),(888,55,'新兴街道',3,'',0,1,0,0),(889,56,'上杭路街道',3,'',0,1,0,0),(890,56,'东新街道',3,'',0,1,0,0),(891,56,'中山门街道',3,'',0,1,0,0),(892,56,'二号桥街道',3,'',0,1,0,0),(893,56,'向阳楼街道',3,'',0,1,0,0),(894,56,'唐家口街道',3,'',0,1,0,0),(895,56,'大王庄街道',3,'',0,1,0,0),(896,56,'大直沽街道',3,'',0,1,0,0),(897,56,'天津铁厂街道',3,'',0,1,0,0),(898,56,'富民路街道',3,'',0,1,0,0),(899,56,'常州道街道',3,'',0,1,0,0),(900,56,'春华街道',3,'',0,1,0,0),(901,56,'鲁山道街道',3,'',0,1,0,0),(902,57,'下瓦房街道',3,'',0,1,0,0),(903,57,'东海街道',3,'',0,1,0,0),(904,57,'友谊路街道',3,'',0,1,0,0),(905,57,'大营门街道',3,'',0,1,0,0),(906,57,'天塔街道',3,'',0,1,0,0),(907,57,'尖山街道',3,'',0,1,0,0),(908,57,'挂甲寺街道',3,'',0,1,0,0),(909,57,'柳林街道',3,'',0,1,0,0),(910,57,'桃园街道',3,'',0,1,0,0),(911,57,'梅江街道',3,'',0,1,0,0),(912,57,'越秀路街道',3,'',0,1,0,0),(913,57,'陈塘庄街道',3,'',0,1,0,0),(914,57,'马场街道',3,'',0,1,0,0),(915,58,'万兴街道',3,'',0,1,0,0),(916,58,'体育中心街道',3,'',0,1,0,0),(917,58,'八里台街道',3,'',0,1,0,0),(918,58,'兴南街道',3,'',0,1,0,0),(919,58,'华苑街道',3,'',0,1,0,0),(920,58,'向阳路街道',3,'',0,1,0,0),(921,58,'嘉陵道街道',3,'',0,1,0,0),(922,58,'学府街道',3,'',0,1,0,0),(923,58,'广开街道',3,'',0,1,0,0),(924,58,'王顶堤街道',3,'',0,1,0,0),(925,58,'长虹街道',3,'',0,1,0,0),(926,58,'鼓楼街道',3,'',0,1,0,0),(927,59,'光复道街道',3,'',0,1,0,0),(928,59,'宁园街道',3,'',0,1,0,0),(929,59,'建昌道街道',3,'',0,1,0,0),(930,59,'新开河街道',3,'',0,1,0,0),(931,59,'月牙河街道',3,'',0,1,0,0),(932,59,'望海楼街道',3,'',0,1,0,0),(933,59,'江都路街道',3,'',0,1,0,0),(934,59,'王串场街道',3,'',0,1,0,0),(935,59,'铁东路街道',3,'',0,1,0,0),(936,59,'鸿顺里街道',3,'',0,1,0,0),(937,60,'丁字沽街道',3,'',0,1,0,0),(938,60,'三条石街道',3,'',0,1,0,0),(939,60,'双环村街道',3,'',0,1,0,0),(940,60,'咸阳北路街道',3,'',0,1,0,0),(941,60,'大胡同街道',3,'',0,1,0,0),(942,60,'芥园道街道',3,'',0,1,0,0),(943,60,'西于庄街道',3,'',0,1,0,0),(944,60,'西沽街道',3,'',0,1,0,0),(945,60,'邵公庄街道',3,'',0,1,0,0),(946,60,'铃铛阁街道',3,'',0,1,0,0),(947,61,'三槐路街道',3,'',0,1,0,0),(948,61,'北塘街道',3,'',0,1,0,0),(949,61,'向阳街道',3,'',0,1,0,0),(950,61,'大沽街道',3,'',0,1,0,0),(951,61,'新城镇',3,'',0,1,0,0),(952,61,'新村街道',3,'',0,1,0,0),(953,61,'新河街道',3,'',0,1,0,0),(954,61,'新港街道',3,'',0,1,0,0),(955,61,'杭州道街道',3,'',0,1,0,0),(956,61,'渤海石油街道',3,'',0,1,0,0),(957,61,'胡家园街道',3,'',0,1,0,0),(958,61,'解放路街道',3,'',0,1,0,0),(959,62,'大田镇',3,'',0,1,0,0),(960,62,'天化街道',3,'',0,1,0,0),(961,62,'寨上街道',3,'',0,1,0,0),(962,62,'杨家泊镇',3,'',0,1,0,0),(963,62,'汉沽街道',3,'',0,1,0,0),(964,62,'河西街道',3,'',0,1,0,0),(965,62,'盐场街道',3,'',0,1,0,0),(966,62,'茶淀镇',3,'',0,1,0,0),(967,62,'营城镇',3,'',0,1,0,0),(968,63,'中塘镇',3,'',0,1,0,0),(969,63,'古林街道',3,'',0,1,0,0),(970,63,'太平镇',3,'',0,1,0,0),(971,63,'小王庄镇',3,'',0,1,0,0),(972,63,'海滨街道',3,'',0,1,0,0),(973,63,'港西街道',3,'',0,1,0,0),(974,63,'胜利街道',3,'',0,1,0,0),(975,63,'迎宾街道',3,'',0,1,0,0),(976,64,'万新街道',3,'',0,1,0,0),(977,64,'丰年村街道',3,'',0,1,0,0),(978,64,'么六桥乡',3,'',0,1,0,0),(979,64,'军粮城镇',3,'',0,1,0,0),(980,64,'华明镇',3,'',0,1,0,0),(981,64,'大毕庄镇',3,'',0,1,0,0),(982,64,'张贵庄街道',3,'',0,1,0,0),(983,64,'新立街道',3,'',0,1,0,0),(984,64,'无瑕街道',3,'',0,1,0,0),(985,65,'中北镇',3,'',0,1,0,0),(986,65,'南河镇',3,'',0,1,0,0),(987,65,'大寺镇',3,'',0,1,0,0),(988,65,'张家窝镇',3,'',0,1,0,0),(989,65,'李七庄街道',3,'',0,1,0,0),(990,65,'杨柳青镇',3,'',0,1,0,0),(991,65,'王稳庄镇',3,'',0,1,0,0),(992,65,'西营门街道',3,'',0,1,0,0),(993,65,'辛口镇',3,'',0,1,0,0),(994,66,'八里台镇',3,'',0,1,0,0),(995,66,'北闸口镇',3,'',0,1,0,0),(996,66,'双桥河镇',3,'',0,1,0,0),(997,66,'双港镇',3,'',0,1,0,0),(998,66,'咸水沽镇',3,'',0,1,0,0),(999,66,'小站镇',3,'',0,1,0,0),(1000,66,'葛沽镇',3,'',0,1,0,0),(1001,66,'辛庄镇',3,'',0,1,0,0),(1002,66,'长青办事处',3,'',0,1,0,0),(1003,67,'北仓镇',3,'',0,1,0,0),(1004,67,'双口镇',3,'',0,1,0,0),(1005,67,'双街镇',3,'',0,1,0,0),(1006,67,'大张庄镇',3,'',0,1,0,0),(1007,67,'天穆镇',3,'',0,1,0,0),(1008,67,'宜兴埠镇',3,'',0,1,0,0),(1009,67,'小淀镇',3,'',0,1,0,0),(1010,67,'普东街道',3,'',0,1,0,0),(1011,67,'果园新村街道',3,'',0,1,0,0),(1012,67,'西堤头镇',3,'',0,1,0,0),(1013,67,'集贤里街道',3,'',0,1,0,0),(1014,67,'青光镇',3,'',0,1,0,0),(1015,68,'上马台镇',3,'',0,1,0,0),(1016,68,'下伍旗镇',3,'',0,1,0,0),(1017,68,'下朱庄街道',3,'',0,1,0,0),(1018,68,'东蒲洼街道',3,'',0,1,0,0),(1019,68,'东马圈镇',3,'',0,1,0,0),(1020,68,'南蔡村镇',3,'',0,1,0,0),(1021,68,'城关镇',3,'',0,1,0,0),(1022,68,'大孟庄镇',3,'',0,1,0,0),(1023,68,'大王古庄镇',3,'',0,1,0,0),(1024,68,'大碱厂镇',3,'',0,1,0,0),(1025,68,'大良镇',3,'',0,1,0,0),(1026,68,'大黄堡乡',3,'',0,1,0,0),(1027,68,'崔黄口镇',3,'',0,1,0,0),(1028,68,'徐官屯街道',3,'',0,1,0,0),(1029,68,'曹子里乡',3,'',0,1,0,0),(1030,68,'杨村街道',3,'',0,1,0,0),(1031,68,'梅厂镇',3,'',0,1,0,0),(1032,68,'汊沽港镇',3,'',0,1,0,0),(1033,68,'河北屯镇',3,'',0,1,0,0),(1034,68,'河西务镇',3,'',0,1,0,0),(1035,68,'泗村店镇',3,'',0,1,0,0),(1036,68,'王庆坨镇',3,'',0,1,0,0),(1037,68,'白古屯乡',3,'',0,1,0,0),(1038,68,'石各庄镇',3,'',0,1,0,0),(1039,68,'豆张庄乡',3,'',0,1,0,0),(1040,68,'运河西街道',3,'',0,1,0,0),(1041,68,'陈咀镇',3,'',0,1,0,0),(1042,68,'高村乡',3,'',0,1,0,0),(1043,68,'黄庄街道',3,'',0,1,0,0),(1044,68,'黄花店镇',3,'',0,1,0,0),(1045,69,'八门城镇',3,'',0,1,0,0),(1046,69,'口东镇',3,'',0,1,0,0),(1047,69,'史各庄镇',3,'',0,1,0,0),(1048,69,'周良庄镇',3,'',0,1,0,0),(1049,69,'城关镇',3,'',0,1,0,0),(1050,69,'大口屯镇',3,'',0,1,0,0),(1051,69,'大唐庄镇',3,'',0,1,0,0),(1052,69,'大白庄镇',3,'',0,1,0,0),(1053,69,'大钟庄镇',3,'',0,1,0,0),(1054,69,'尔王庄乡',3,'',0,1,0,0),(1055,69,'新安镇',3,'',0,1,0,0),(1056,69,'新开口镇',3,'',0,1,0,0),(1057,69,'方家庄镇',3,'',0,1,0,0),(1058,69,'林亭口镇',3,'',0,1,0,0),(1059,69,'牛家牌乡',3,'',0,1,0,0),(1060,69,'牛道口镇',3,'',0,1,0,0),(1061,69,'王卜庄镇',3,'',0,1,0,0),(1062,69,'郝各庄镇',3,'',0,1,0,0),(1063,69,'霍各庄镇',3,'',0,1,0,0),(1064,69,'马家店镇',3,'',0,1,0,0),(1065,69,'高家庄镇',3,'',0,1,0,0),(1066,69,'黄庄乡',3,'',0,1,0,0),(1067,70,'七里海镇',3,'',0,1,0,0),(1068,70,'东棘坨镇',3,'',0,1,0,0),(1069,70,'丰台镇',3,'',0,1,0,0),(1070,70,'俵口乡',3,'',0,1,0,0),(1071,70,'北淮淀乡',3,'',0,1,0,0),(1072,70,'大北涧沽镇',3,'',0,1,0,0),(1073,70,'宁河镇',3,'',0,1,0,0),(1074,70,'岳龙镇',3,'',0,1,0,0),(1075,70,'廉庄子乡',3,'',0,1,0,0),(1076,70,'板桥镇',3,'',0,1,0,0),(1077,70,'潘庄镇',3,'',0,1,0,0),(1078,70,'芦台镇',3,'',0,1,0,0),(1079,70,'苗庄镇',3,'',0,1,0,0),(1080,70,'造甲城镇',3,'',0,1,0,0),(1081,71,'中旺镇',3,'',0,1,0,0),(1082,71,'双塘镇',3,'',0,1,0,0),(1083,71,'台头镇',3,'',0,1,0,0),(1084,71,'唐官屯镇',3,'',0,1,0,0),(1085,71,'团泊镇',3,'',0,1,0,0),(1086,71,'大丰堆镇',3,'',0,1,0,0),(1087,71,'大邱庄镇',3,'',0,1,0,0),(1088,71,'子牙镇',3,'',0,1,0,0),(1089,71,'杨成庄乡',3,'',0,1,0,0),(1090,71,'梁头镇',3,'',0,1,0,0),(1091,71,'沿庄镇',3,'',0,1,0,0),(1092,71,'独流镇',3,'',0,1,0,0),(1093,71,'王口镇',3,'',0,1,0,0),(1094,71,'良王庄乡',3,'',0,1,0,0),(1095,71,'蔡公庄镇',3,'',0,1,0,0),(1096,71,'西翟庄镇',3,'',0,1,0,0),(1097,71,'陈官屯镇',3,'',0,1,0,0),(1098,71,'静海镇',3,'',0,1,0,0),(1099,72,'上仓镇',3,'',0,1,0,0),(1100,72,'下仓镇',3,'',0,1,0,0),(1101,72,'下窝头镇',3,'',0,1,0,0),(1102,72,'下营镇',3,'',0,1,0,0),(1103,72,'东二营乡',3,'',0,1,0,0),(1104,72,'东施古镇',3,'',0,1,0,0),(1105,72,'东赵各庄乡',3,'',0,1,0,0),(1106,72,'五百户镇',3,'',0,1,0,0),(1107,72,'侯家营镇',3,'',0,1,0,0),(1108,72,'出头岭镇',3,'',0,1,0,0),(1109,72,'别山镇',3,'',0,1,0,0),(1110,72,'城关镇',3,'',0,1,0,0),(1111,72,'孙各庄满族乡',3,'',0,1,0,0),(1112,72,'官庄镇',3,'',0,1,0,0),(1113,72,'尤古庄镇',3,'',0,1,0,0),(1114,72,'文昌街道',3,'',0,1,0,0),(1115,72,'杨津庄镇',3,'',0,1,0,0),(1116,72,'桑梓镇',3,'',0,1,0,0),(1117,72,'洇溜镇',3,'',0,1,0,0),(1118,72,'白涧镇',3,'',0,1,0,0),(1119,72,'礼明庄乡',3,'',0,1,0,0),(1120,72,'穿芳峪乡',3,'',0,1,0,0),(1121,72,'罗庄子镇',3,'',0,1,0,0),(1122,72,'西龙虎峪镇',3,'',0,1,0,0),(1123,72,'许家台乡',3,'',0,1,0,0),(1124,72,'邦均镇',3,'',0,1,0,0),(1125,72,'马伸桥镇',3,'',0,1,0,0),(1126,73,'井陉县',3,'',0,1,0,0),(1127,73,'井陉矿区',3,'',0,1,0,0),(1128,73,'元氏县',3,'',0,1,0,0),(1129,73,'平山县',3,'',0,1,0,0),(1130,73,'新乐市',3,'',0,1,0,0),(1131,73,'新华区',3,'',0,1,0,0),(1132,73,'无极县',3,'',0,1,0,0),(1133,73,'晋州市',3,'',0,1,0,0),(1134,73,'栾城县',3,'',0,1,0,0),(1135,73,'桥东区',3,'',0,1,0,0),(1136,73,'桥西区',3,'',0,1,0,0),(1137,73,'正定县',3,'',0,1,0,0),(1138,73,'深泽县',3,'',0,1,0,0),(1139,73,'灵寿县',3,'',0,1,0,0),(1140,73,'藁城市',3,'',0,1,0,0),(1141,73,'行唐县',3,'',0,1,0,0),(1142,73,'裕华区',3,'',0,1,0,0),(1143,73,'赞皇县',3,'',0,1,0,0),(1144,73,'赵县',3,'',0,1,0,0),(1145,73,'辛集市',3,'',0,1,0,0),(1146,73,'长安区',3,'',0,1,0,0),(1147,73,'高邑县',3,'',0,1,0,0),(1148,73,'鹿泉市',3,'',0,1,0,0),(1149,74,'丰南区',3,'',0,1,0,0),(1150,74,'丰润区',3,'',0,1,0,0),(1151,74,'乐亭县',3,'',0,1,0,0),(1152,74,'古冶区',3,'',0,1,0,0),(1153,74,'唐海县',3,'',0,1,0,0),(1154,74,'开平区',3,'',0,1,0,0),(1155,74,'滦南县',3,'',0,1,0,0),(1156,74,'滦县',3,'',0,1,0,0),(1157,74,'玉田县',3,'',0,1,0,0),(1158,74,'路北区',3,'',0,1,0,0),(1159,74,'路南区',3,'',0,1,0,0),(1160,74,'迁安市',3,'',0,1,0,0),(1161,74,'迁西县',3,'',0,1,0,0),(1162,74,'遵化市',3,'',0,1,0,0),(1163,75,'北戴河区',3,'',0,1,0,0),(1164,75,'卢龙县',3,'',0,1,0,0),(1165,75,'山海关区',3,'',0,1,0,0),(1166,75,'抚宁县',3,'',0,1,0,0),(1167,75,'昌黎县',3,'',0,1,0,0),(1168,75,'海港区',3,'',0,1,0,0),(1169,75,'青龙满族自治县',3,'',0,1,0,0),(1170,76,'丛台区',3,'',0,1,0,0),(1171,76,'临漳县',3,'',0,1,0,0),(1172,76,'复兴区',3,'',0,1,0,0),(1173,76,'大名县',3,'',0,1,0,0),(1174,76,'峰峰矿区',3,'',0,1,0,0),(1175,76,'广平县',3,'',0,1,0,0),(1176,76,'成安县',3,'',0,1,0,0),(1177,76,'曲周县',3,'',0,1,0,0),(1178,76,'武安市',3,'',0,1,0,0),(1179,76,'永年县',3,'',0,1,0,0),(1180,76,'涉县',3,'',0,1,0,0),(1181,76,'磁县',3,'',0,1,0,0),(1182,76,'肥乡县',3,'',0,1,0,0),(1183,76,'邯山区',3,'',0,1,0,0),(1184,76,'邯郸县',3,'',0,1,0,0),(1185,76,'邱县',3,'',0,1,0,0),(1186,76,'馆陶县',3,'',0,1,0,0),(1187,76,'魏县',3,'',0,1,0,0),(1188,76,'鸡泽县',3,'',0,1,0,0),(1189,77,'临城县',3,'',0,1,0,0),(1190,77,'临西县',3,'',0,1,0,0),(1191,77,'任县',3,'',0,1,0,0),(1192,77,'内丘县',3,'',0,1,0,0),(1193,77,'南和县',3,'',0,1,0,0),(1194,77,'南宫市',3,'',0,1,0,0),(1195,77,'威县',3,'',0,1,0,0),(1196,77,'宁晋县',3,'',0,1,0,0),(1197,77,'巨鹿县',3,'',0,1,0,0),(1198,77,'平乡县',3,'',0,1,0,0),(1199,77,'广宗县',3,'',0,1,0,0),(1200,77,'新河县',3,'',0,1,0,0),(1201,77,'柏乡县',3,'',0,1,0,0),(1202,77,'桥东区',3,'',0,1,0,0),(1203,77,'桥西区',3,'',0,1,0,0),(1204,77,'沙河市',3,'',0,1,0,0),(1205,77,'清河县',3,'',0,1,0,0),(1206,77,'邢台县',3,'',0,1,0,0),(1207,77,'隆尧县',3,'',0,1,0,0),(1208,78,'北市区',3,'',0,1,0,0),(1209,78,'南市区',3,'',0,1,0,0),(1210,78,'博野县',3,'',0,1,0,0),(1211,78,'唐县',3,'',0,1,0,0),(1212,78,'安国市',3,'',0,1,0,0),(1213,78,'安新县',3,'',0,1,0,0),(1214,78,'定兴县',3,'',0,1,0,0),(1215,78,'定州市',3,'',0,1,0,0),(1216,78,'容城县',3,'',0,1,0,0),(1217,78,'徐水县',3,'',0,1,0,0),(1218,78,'新市区',3,'',0,1,0,0),(1219,78,'易县',3,'',0,1,0,0),(1220,78,'曲阳县',3,'',0,1,0,0),(1221,78,'望都县',3,'',0,1,0,0),(1222,78,'涞水县',3,'',0,1,0,0),(1223,78,'涞源县',3,'',0,1,0,0),(1224,78,'涿州市',3,'',0,1,0,0),(1225,78,'清苑县',3,'',0,1,0,0),(1226,78,'满城县',3,'',0,1,0,0),(1227,78,'蠡县',3,'',0,1,0,0),(1228,78,'阜平县',3,'',0,1,0,0),(1229,78,'雄县',3,'',0,1,0,0),(1230,78,'顺平县',3,'',0,1,0,0),(1231,78,'高碑店市',3,'',0,1,0,0),(1232,78,'高阳县',3,'',0,1,0,0),(1233,79,'万全县',3,'',0,1,0,0),(1234,79,'下花园区',3,'',0,1,0,0),(1235,79,'宣化区',3,'',0,1,0,0),(1236,79,'宣化县',3,'',0,1,0,0),(1237,79,'尚义县',3,'',0,1,0,0),(1238,79,'崇礼县',3,'',0,1,0,0),(1239,79,'康保县',3,'',0,1,0,0),(1240,79,'张北县',3,'',0,1,0,0),(1241,79,'怀安县',3,'',0,1,0,0),(1242,79,'怀来县',3,'',0,1,0,0),(1243,79,'桥东区',3,'',0,1,0,0),(1244,79,'桥西区',3,'',0,1,0,0),(1245,79,'沽源县',3,'',0,1,0,0),(1246,79,'涿鹿县',3,'',0,1,0,0),(1247,79,'蔚县',3,'',0,1,0,0),(1248,79,'赤城县',3,'',0,1,0,0),(1249,79,'阳原县',3,'',0,1,0,0),(1250,80,'丰宁满族自治县',3,'',0,1,0,0),(1251,80,'兴隆县',3,'',0,1,0,0),(1252,80,'双桥区',3,'',0,1,0,0),(1253,80,'双滦区',3,'',0,1,0,0),(1254,80,'围场满族蒙古族自治县',3,'',0,1,0,0),(1255,80,'宽城满族自治县',3,'',0,1,0,0),(1256,80,'平泉县',3,'',0,1,0,0),(1257,80,'承德县',3,'',0,1,0,0),(1258,80,'滦平县',3,'',0,1,0,0),(1259,80,'隆化县',3,'',0,1,0,0),(1260,80,'鹰手营子矿区',3,'',0,1,0,0),(1261,81,'冀州市',3,'',0,1,0,0),(1262,81,'安平县',3,'',0,1,0,0),(1263,81,'故城县',3,'',0,1,0,0),(1264,81,'景县',3,'',0,1,0,0),(1265,81,'枣强县',3,'',0,1,0,0),(1266,81,'桃城区',3,'',0,1,0,0),(1267,81,'武强县',3,'',0,1,0,0),(1268,81,'武邑县',3,'',0,1,0,0),(1269,81,'深州市',3,'',0,1,0,0),(1270,81,'阜城县',3,'',0,1,0,0),(1271,81,'饶阳县',3,'',0,1,0,0),(1272,82,'三河市',3,'',0,1,0,0),(1273,82,'固安县',3,'',0,1,0,0),(1274,82,'大厂回族自治县',3,'',0,1,0,0),(1275,82,'大城县',3,'',0,1,0,0),(1276,82,'安次区',3,'',0,1,0,0),(1277,82,'广阳区',3,'',0,1,0,0),(1278,82,'文安县',3,'',0,1,0,0),(1279,82,'永清县',3,'',0,1,0,0),(1280,82,'霸州市',3,'',0,1,0,0),(1281,82,'香河县',3,'',0,1,0,0),(1282,83,'东光县',3,'',0,1,0,0),(1283,83,'任丘市',3,'',0,1,0,0),(1284,83,'南皮县',3,'',0,1,0,0),(1285,83,'吴桥县',3,'',0,1,0,0),(1286,83,'孟村回族自治县',3,'',0,1,0,0),(1287,83,'新华区',3,'',0,1,0,0),(1288,83,'沧县',3,'',0,1,0,0),(1289,83,'河间市',3,'',0,1,0,0),(1290,83,'泊头市',3,'',0,1,0,0),(1291,83,'海兴县',3,'',0,1,0,0),(1292,83,'献县',3,'',0,1,0,0),(1293,83,'盐山县',3,'',0,1,0,0),(1294,83,'肃宁县',3,'',0,1,0,0),(1295,83,'运河区',3,'',0,1,0,0),(1296,83,'青县',3,'',0,1,0,0),(1297,83,'黄骅市',3,'',0,1,0,0),(1298,84,'万柏林区',3,'',0,1,0,0),(1299,84,'古交市',3,'',0,1,0,0),(1300,84,'娄烦县',3,'',0,1,0,0),(1301,84,'小店区',3,'',0,1,0,0),(1302,84,'尖草坪区',3,'',0,1,0,0),(1303,84,'晋源区',3,'',0,1,0,0),(1304,84,'杏花岭区',3,'',0,1,0,0),(1305,84,'清徐县',3,'',0,1,0,0),(1306,84,'迎泽区',3,'',0,1,0,0),(1307,84,'阳曲县',3,'',0,1,0,0),(1308,85,'南郊区',3,'',0,1,0,0),(1309,85,'城区',3,'',0,1,0,0),(1310,85,'大同县',3,'',0,1,0,0),(1311,85,'天镇县',3,'',0,1,0,0),(1312,85,'左云县',3,'',0,1,0,0),(1313,85,'广灵县',3,'',0,1,0,0),(1314,85,'新荣区',3,'',0,1,0,0),(1315,85,'浑源县',3,'',0,1,0,0),(1316,85,'灵丘县',3,'',0,1,0,0),(1317,85,'矿区',3,'',0,1,0,0),(1318,85,'阳高县',3,'',0,1,0,0),(1319,86,'城区',3,'',0,1,0,0),(1320,86,'平定县',3,'',0,1,0,0),(1321,86,'盂县',3,'',0,1,0,0),(1322,86,'矿区',3,'',0,1,0,0),(1323,86,'郊区',3,'',0,1,0,0),(1324,87,'城区',3,'',0,1,0,0),(1325,87,'壶关县',3,'',0,1,0,0),(1326,87,'屯留县',3,'',0,1,0,0),(1327,87,'平顺县',3,'',0,1,0,0),(1328,87,'武乡县',3,'',0,1,0,0),(1329,87,'沁县',3,'',0,1,0,0),(1330,87,'沁源县',3,'',0,1,0,0),(1331,87,'潞城市',3,'',0,1,0,0),(1332,87,'襄垣县',3,'',0,1,0,0),(1333,87,'郊区',3,'',0,1,0,0),(1334,87,'长子县',3,'',0,1,0,0),(1335,87,'长治县',3,'',0,1,0,0),(1336,87,'黎城县',3,'',0,1,0,0),(1337,88,'城区',3,'',0,1,0,0),(1338,88,'沁水县',3,'',0,1,0,0),(1339,88,'泽州县',3,'',0,1,0,0),(1340,88,'阳城县',3,'',0,1,0,0),(1341,88,'陵川县',3,'',0,1,0,0),(1342,88,'高平市',3,'',0,1,0,0),(1343,89,'右玉县',3,'',0,1,0,0),(1344,89,'山阴县',3,'',0,1,0,0),(1345,89,'平鲁区',3,'',0,1,0,0),(1346,89,'应县',3,'',0,1,0,0),(1347,89,'怀仁县',3,'',0,1,0,0),(1348,89,'朔城区',3,'',0,1,0,0),(1349,90,'介休市',3,'',0,1,0,0),(1350,90,'和顺县',3,'',0,1,0,0),(1351,90,'太谷县',3,'',0,1,0,0),(1352,90,'寿阳县',3,'',0,1,0,0),(1353,90,'左权县',3,'',0,1,0,0),(1354,90,'平遥县',3,'',0,1,0,0),(1355,90,'昔阳县',3,'',0,1,0,0),(1356,90,'榆次区',3,'',0,1,0,0),(1357,90,'榆社县',3,'',0,1,0,0),(1358,90,'灵石县',3,'',0,1,0,0),(1359,90,'祁县',3,'',0,1,0,0),(1360,91,'万荣县',3,'',0,1,0,0),(1361,91,'临猗县',3,'',0,1,0,0),(1362,91,'垣曲县',3,'',0,1,0,0),(1363,91,'夏县',3,'',0,1,0,0),(1364,91,'平陆县',3,'',0,1,0,0),(1365,91,'新绛县',3,'',0,1,0,0),(1366,91,'永济市',3,'',0,1,0,0),(1367,91,'河津市',3,'',0,1,0,0),(1368,91,'盐湖区',3,'',0,1,0,0),(1369,91,'稷山县',3,'',0,1,0,0),(1370,91,'绛县',3,'',0,1,0,0),(1371,91,'芮城县',3,'',0,1,0,0),(1372,91,'闻喜县',3,'',0,1,0,0),(1373,92,'五台县',3,'',0,1,0,0),(1374,92,'五寨县',3,'',0,1,0,0),(1375,92,'代县',3,'',0,1,0,0),(1376,92,'保德县',3,'',0,1,0,0),(1377,92,'偏关县',3,'',0,1,0,0),(1378,92,'原平市',3,'',0,1,0,0),(1379,92,'宁武县',3,'',0,1,0,0),(1380,92,'定襄县',3,'',0,1,0,0),(1381,92,'岢岚县',3,'',0,1,0,0),(1382,92,'忻府区',3,'',0,1,0,0),(1383,92,'河曲县',3,'',0,1,0,0),(1384,92,'神池县',3,'',0,1,0,0),(1385,92,'繁峙县',3,'',0,1,0,0),(1386,92,'静乐县',3,'',0,1,0,0),(1387,93,'乡宁县',3,'',0,1,0,0),(1388,93,'侯马市',3,'',0,1,0,0),(1389,93,'古县',3,'',0,1,0,0),(1390,93,'吉县',3,'',0,1,0,0),(1391,93,'大宁县',3,'',0,1,0,0),(1392,93,'安泽县',3,'',0,1,0,0),(1393,93,'尧都区',3,'',0,1,0,0),(1394,93,'曲沃县',3,'',0,1,0,0),(1395,93,'永和县',3,'',0,1,0,0),(1396,93,'汾西县',3,'',0,1,0,0),(1397,93,'洪洞县',3,'',0,1,0,0),(1398,93,'浮山县',3,'',0,1,0,0),(1399,93,'翼城县',3,'',0,1,0,0),(1400,93,'蒲县',3,'',0,1,0,0),(1401,93,'襄汾县',3,'',0,1,0,0),(1402,93,'隰县',3,'',0,1,0,0),(1403,93,'霍州市',3,'',0,1,0,0),(1404,94,'中阳县',3,'',0,1,0,0),(1405,94,'临县',3,'',0,1,0,0),(1406,94,'交口县',3,'',0,1,0,0),(1407,94,'交城县',3,'',0,1,0,0),(1408,94,'兴县',3,'',0,1,0,0),(1409,94,'孝义市',3,'',0,1,0,0),(1410,94,'岚县',3,'',0,1,0,0),(1411,94,'文水县',3,'',0,1,0,0),(1412,94,'方山县',3,'',0,1,0,0),(1413,94,'柳林县',3,'',0,1,0,0),(1414,94,'汾阳市',3,'',0,1,0,0),(1415,94,'石楼县',3,'',0,1,0,0),(1416,94,'离石区',3,'',0,1,0,0),(1417,95,'和林格尔县',3,'',0,1,0,0),(1418,95,'回民区',3,'',0,1,0,0),(1419,95,'土默特左旗',3,'',0,1,0,0),(1420,95,'托克托县',3,'',0,1,0,0),(1421,95,'新城区',3,'',0,1,0,0),(1422,95,'武川县',3,'',0,1,0,0),(1423,95,'清水河县',3,'',0,1,0,0),(1424,95,'玉泉区',3,'',0,1,0,0),(1425,95,'赛罕区',3,'',0,1,0,0),(1426,96,'东河区',3,'',0,1,0,0),(1427,96,'九原区',3,'',0,1,0,0),(1428,96,'固阳县',3,'',0,1,0,0),(1429,96,'土默特右旗',3,'',0,1,0,0),(1430,96,'昆都仑区',3,'',0,1,0,0),(1431,96,'白云矿区',3,'',0,1,0,0),(1432,96,'石拐区',3,'',0,1,0,0),(1433,96,'达尔罕茂明安联合旗',3,'',0,1,0,0),(1434,96,'青山区',3,'',0,1,0,0),(1435,97,'乌达区',3,'',0,1,0,0),(1436,97,'海勃湾区',3,'',0,1,0,0),(1437,97,'海南区',3,'',0,1,0,0),(1438,98,'元宝山区',3,'',0,1,0,0),(1439,98,'克什克腾旗',3,'',0,1,0,0),(1440,98,'喀喇沁旗',3,'',0,1,0,0),(1441,98,'宁城县',3,'',0,1,0,0),(1442,98,'巴林右旗',3,'',0,1,0,0),(1443,98,'巴林左旗',3,'',0,1,0,0),(1444,98,'敖汉旗',3,'',0,1,0,0),(1445,98,'松山区',3,'',0,1,0,0),(1446,98,'林西县',3,'',0,1,0,0),(1447,98,'红山区',3,'',0,1,0,0),(1448,98,'翁牛特旗',3,'',0,1,0,0),(1449,98,'阿鲁科尔沁旗',3,'',0,1,0,0),(1450,99,'奈曼旗',3,'',0,1,0,0),(1451,99,'库伦旗',3,'',0,1,0,0),(1452,99,'开鲁县',3,'',0,1,0,0),(1453,99,'扎鲁特旗',3,'',0,1,0,0),(1454,99,'科尔沁区',3,'',0,1,0,0),(1455,99,'科尔沁左翼中旗',3,'',0,1,0,0),(1456,99,'科尔沁左翼后旗',3,'',0,1,0,0),(1457,99,'霍林郭勒市',3,'',0,1,0,0),(1458,100,'东胜区',3,'',0,1,0,0),(1459,100,'乌审旗',3,'',0,1,0,0),(1460,100,'伊金霍洛旗',3,'',0,1,0,0),(1461,100,'准格尔旗',3,'',0,1,0,0),(1462,100,'杭锦旗',3,'',0,1,0,0),(1463,100,'达拉特旗',3,'',0,1,0,0),(1464,100,'鄂东胜区',3,'',0,1,0,0),(1465,100,'鄂托克前旗',3,'',0,1,0,0),(1466,100,'鄂托克旗',3,'',0,1,0,0),(1467,101,'扎兰屯市',3,'',0,1,0,0),(1468,101,'新巴尔虎右旗',3,'',0,1,0,0),(1469,101,'新巴尔虎左旗',3,'',0,1,0,0),(1470,101,'根河市',3,'',0,1,0,0),(1471,101,'海拉尔区',3,'',0,1,0,0),(1472,101,'满洲里市',3,'',0,1,0,0),(1473,101,'牙克石市',3,'',0,1,0,0),(1474,101,'莫力达瓦达斡尔族自治旗',3,'',0,1,0,0),(1475,101,'鄂伦春自治旗',3,'',0,1,0,0),(1476,101,'鄂温克族自治旗',3,'',0,1,0,0),(1477,101,'阿荣旗',3,'',0,1,0,0),(1478,101,'陈巴尔虎旗',3,'',0,1,0,0),(1479,101,'额尔古纳市',3,'',0,1,0,0),(1480,102,'临河区',3,'',0,1,0,0),(1481,102,'乌拉特中旗',3,'',0,1,0,0),(1482,102,'乌拉特前旗',3,'',0,1,0,0),(1483,102,'乌拉特后旗',3,'',0,1,0,0),(1484,102,'五原县',3,'',0,1,0,0),(1485,102,'杭锦后旗',3,'',0,1,0,0),(1486,102,'磴口县',3,'',0,1,0,0),(1487,103,'丰镇市',3,'',0,1,0,0),(1488,103,'兴和县',3,'',0,1,0,0),(1489,103,'凉城县',3,'',0,1,0,0),(1490,103,'化德县',3,'',0,1,0,0),(1491,103,'卓资县',3,'',0,1,0,0),(1492,103,'商都县',3,'',0,1,0,0),(1493,103,'四子王旗',3,'',0,1,0,0),(1494,103,'察哈尔右翼中旗',3,'',0,1,0,0),(1495,103,'察哈尔右翼前旗',3,'',0,1,0,0),(1496,103,'察哈尔右翼后旗',3,'',0,1,0,0),(1497,103,'集宁区',3,'',0,1,0,0),(1498,104,'乌兰浩特市',3,'',0,1,0,0),(1499,104,'扎赉特旗',3,'',0,1,0,0),(1500,104,'科尔沁右翼中旗',3,'',0,1,0,0),(1501,104,'科尔沁右翼前旗',3,'',0,1,0,0),(1502,104,'突泉县',3,'',0,1,0,0),(1503,104,'阿尔山市',3,'',0,1,0,0),(1504,105,'东乌珠穆沁旗',3,'',0,1,0,0),(1505,105,'二连浩特市',3,'',0,1,0,0),(1506,105,'多伦县',3,'',0,1,0,0),(1507,105,'太仆寺旗',3,'',0,1,0,0),(1508,105,'正蓝旗',3,'',0,1,0,0),(1509,105,'正镶白旗',3,'',0,1,0,0),(1510,105,'苏尼特右旗',3,'',0,1,0,0),(1511,105,'苏尼特左旗',3,'',0,1,0,0),(1512,105,'西乌珠穆沁旗',3,'',0,1,0,0),(1513,105,'锡林浩特市',3,'',0,1,0,0),(1514,105,'镶黄旗',3,'',0,1,0,0),(1515,105,'阿巴嘎旗',3,'',0,1,0,0),(1516,106,'阿拉善右旗',3,'',0,1,0,0),(1517,106,'阿拉善左旗',3,'',0,1,0,0),(1518,106,'额济纳旗',3,'',0,1,0,0),(1519,107,'东陵区',3,'',0,1,0,0),(1520,107,'于洪区',3,'',0,1,0,0),(1521,107,'和平区',3,'',0,1,0,0),(1522,107,'大东区',3,'',0,1,0,0),(1523,107,'康平县',3,'',0,1,0,0),(1524,107,'新民市',3,'',0,1,0,0),(1525,107,'沈北新区',3,'',0,1,0,0),(1526,107,'沈河区',3,'',0,1,0,0),(1527,107,'法库县',3,'',0,1,0,0),(1528,107,'皇姑区',3,'',0,1,0,0),(1529,107,'苏家屯区',3,'',0,1,0,0),(1530,107,'辽中县',3,'',0,1,0,0),(1531,107,'铁西区',3,'',0,1,0,0),(1532,108,'中山区',3,'',0,1,0,0),(1533,108,'庄河市',3,'',0,1,0,0),(1534,108,'旅顺口区',3,'',0,1,0,0),(1535,108,'普兰店市',3,'',0,1,0,0),(1536,108,'沙河口区',3,'',0,1,0,0),(1537,108,'瓦房店市',3,'',0,1,0,0),(1538,108,'甘井子区',3,'',0,1,0,0),(1539,108,'西岗区',3,'',0,1,0,0),(1540,108,'金州区',3,'',0,1,0,0),(1541,108,'长海县',3,'',0,1,0,0),(1542,109,'千山区',3,'',0,1,0,0),(1543,109,'台安县',3,'',0,1,0,0),(1544,109,'岫岩满族自治县',3,'',0,1,0,0),(1545,109,'海城市',3,'',0,1,0,0),(1546,109,'立山区',3,'',0,1,0,0),(1547,109,'铁东区',3,'',0,1,0,0),(1548,109,'铁西区',3,'',0,1,0,0),(1549,110,'东洲区',3,'',0,1,0,0),(1550,110,'抚顺县',3,'',0,1,0,0),(1551,110,'新宾满族自治县',3,'',0,1,0,0),(1552,110,'新抚区',3,'',0,1,0,0),(1553,110,'望花区',3,'',0,1,0,0),(1554,110,'清原满族自治县',3,'',0,1,0,0),(1555,110,'顺城区',3,'',0,1,0,0),(1556,111,'南芬区',3,'',0,1,0,0),(1557,111,'平山区',3,'',0,1,0,0),(1558,111,'明山区',3,'',0,1,0,0),(1559,111,'本溪满族自治县',3,'',0,1,0,0),(1560,111,'桓仁满族自治县',3,'',0,1,0,0),(1561,111,'溪湖区',3,'',0,1,0,0),(1562,112,'东港市',3,'',0,1,0,0),(1563,112,'元宝区',3,'',0,1,0,0),(1564,112,'凤城市',3,'',0,1,0,0),(1565,112,'宽甸满族自治县',3,'',0,1,0,0),(1566,112,'振兴区',3,'',0,1,0,0),(1567,112,'振安区',3,'',0,1,0,0),(1568,113,'义县',3,'',0,1,0,0),(1569,113,'凌河区',3,'',0,1,0,0),(1570,113,'凌海市',3,'',0,1,0,0),(1571,113,'北镇市',3,'',0,1,0,0),(1572,113,'古塔区',3,'',0,1,0,0),(1573,113,'太和区',3,'',0,1,0,0),(1574,113,'黑山县',3,'',0,1,0,0),(1575,114,'大石桥市',3,'',0,1,0,0),(1576,114,'盖州市',3,'',0,1,0,0),(1577,114,'站前区',3,'',0,1,0,0),(1578,114,'老边区',3,'',0,1,0,0),(1579,114,'西市区',3,'',0,1,0,0),(1580,114,'鲅鱼圈区',3,'',0,1,0,0),(1581,115,'太平区',3,'',0,1,0,0),(1582,115,'彰武县',3,'',0,1,0,0),(1583,115,'新邱区',3,'',0,1,0,0),(1584,115,'海州区',3,'',0,1,0,0),(1585,115,'清河门区',3,'',0,1,0,0),(1586,115,'细河区',3,'',0,1,0,0),(1587,115,'蒙古族自治县',3,'',0,1,0,0),(1588,116,'太子河区',3,'',0,1,0,0),(1589,116,'宏伟区',3,'',0,1,0,0),(1590,116,'弓长岭区',3,'',0,1,0,0),(1591,116,'文圣区',3,'',0,1,0,0),(1592,116,'灯塔市',3,'',0,1,0,0),(1593,116,'白塔区',3,'',0,1,0,0),(1594,116,'辽阳县',3,'',0,1,0,0),(1595,117,'兴隆台区',3,'',0,1,0,0),(1596,117,'双台子区',3,'',0,1,0,0),(1597,117,'大洼县',3,'',0,1,0,0),(1598,117,'盘山县',3,'',0,1,0,0),(1599,118,'开原市',3,'',0,1,0,0),(1600,118,'昌图县',3,'',0,1,0,0),(1601,118,'清河区',3,'',0,1,0,0),(1602,118,'西丰县',3,'',0,1,0,0),(1603,118,'调兵山市',3,'',0,1,0,0),(1604,118,'铁岭县',3,'',0,1,0,0),(1605,118,'银州区',3,'',0,1,0,0),(1606,119,'凌源市',3,'',0,1,0,0),(1607,119,'北票市',3,'',0,1,0,0),(1608,119,'双塔区',3,'',0,1,0,0),(1609,119,'喀喇沁左翼蒙古族自治县',3,'',0,1,0,0),(1610,119,'建平县',3,'',0,1,0,0),(1611,119,'朝阳县',3,'',0,1,0,0),(1612,119,'龙城区',3,'',0,1,0,0),(1613,120,'兴城市',3,'',0,1,0,0),(1614,120,'南票区',3,'',0,1,0,0),(1615,120,'建昌县',3,'',0,1,0,0),(1616,120,'绥中县',3,'',0,1,0,0),(1617,120,'连山区',3,'',0,1,0,0),(1618,120,'龙港区',3,'',0,1,0,0),(1619,121,'九台市',3,'',0,1,0,0),(1620,121,'二道区',3,'',0,1,0,0),(1621,121,'农安县',3,'',0,1,0,0),(1622,121,'南关区',3,'',0,1,0,0),(1623,121,'双阳区',3,'',0,1,0,0),(1624,121,'宽城区',3,'',0,1,0,0),(1625,121,'德惠市',3,'',0,1,0,0),(1626,121,'朝阳区',3,'',0,1,0,0),(1627,121,'榆树市',3,'',0,1,0,0),(1628,121,'绿园区',3,'',0,1,0,0),(1629,122,'丰满区',3,'',0,1,0,0),(1630,122,'昌邑区',3,'',0,1,0,0),(1631,122,'桦甸市',3,'',0,1,0,0),(1632,122,'永吉县',3,'',0,1,0,0),(1633,122,'磐石市',3,'',0,1,0,0),(1634,122,'舒兰市',3,'',0,1,0,0),(1635,122,'船营区',3,'',0,1,0,0),(1636,122,'蛟河市',3,'',0,1,0,0),(1637,122,'龙潭区',3,'',0,1,0,0),(1638,123,'伊通满族自治县',3,'',0,1,0,0),(1639,123,'公主岭市',3,'',0,1,0,0),(1640,123,'双辽市',3,'',0,1,0,0),(1641,123,'梨树县',3,'',0,1,0,0),(1642,123,'铁东区',3,'',0,1,0,0),(1643,123,'铁西区',3,'',0,1,0,0),(1644,124,'东丰县',3,'',0,1,0,0),(1645,124,'东辽县',3,'',0,1,0,0),(1646,124,'西安区',3,'',0,1,0,0),(1647,124,'龙山区',3,'',0,1,0,0),(1648,125,'东昌区',3,'',0,1,0,0),(1649,125,'二道江区',3,'',0,1,0,0),(1650,125,'柳河县',3,'',0,1,0,0),(1651,125,'梅河口市',3,'',0,1,0,0),(1652,125,'辉南县',3,'',0,1,0,0),(1653,125,'通化县',3,'',0,1,0,0),(1654,125,'集安市',3,'',0,1,0,0),(1655,126,'临江市',3,'',0,1,0,0),(1656,126,'八道江区',3,'',0,1,0,0),(1657,126,'抚松县',3,'',0,1,0,0),(1658,126,'江源区',3,'',0,1,0,0),(1659,126,'长白朝鲜族自治县',3,'',0,1,0,0),(1660,126,'靖宇县',3,'',0,1,0,0),(1661,127,'干安县',3,'',0,1,0,0),(1662,127,'前郭尔罗斯蒙古族自治县',3,'',0,1,0,0),(1663,127,'宁江区',3,'',0,1,0,0),(1664,127,'扶余县',3,'',0,1,0,0),(1665,127,'长岭县',3,'',0,1,0,0),(1666,128,'大安市',3,'',0,1,0,0),(1667,128,'洮北区',3,'',0,1,0,0),(1668,128,'洮南市',3,'',0,1,0,0),(1669,128,'通榆县',3,'',0,1,0,0),(1670,128,'镇赉县',3,'',0,1,0,0),(1671,129,'和龙市',3,'',0,1,0,0),(1672,129,'图们市',3,'',0,1,0,0),(1673,129,'安图县',3,'',0,1,0,0),(1674,129,'延吉市',3,'',0,1,0,0),(1675,129,'敦化市',3,'',0,1,0,0),(1676,129,'汪清县',3,'',0,1,0,0),(1677,129,'珲春市',3,'',0,1,0,0),(1678,129,'龙井市',3,'',0,1,0,0),(1679,130,'五常市',3,'',0,1,0,0),(1680,130,'依兰县',3,'',0,1,0,0),(1681,130,'南岗区',3,'',0,1,0,0),(1682,130,'双城市',3,'',0,1,0,0),(1683,130,'呼兰区',3,'',0,1,0,0),(1684,130,'哈尔滨市道里区',3,'',0,1,0,0),(1685,130,'宾县',3,'',0,1,0,0),(1686,130,'尚志市',3,'',0,1,0,0),(1687,130,'巴彦县',3,'',0,1,0,0),(1688,130,'平房区',3,'',0,1,0,0),(1689,130,'延寿县',3,'',0,1,0,0),(1690,130,'方正县',3,'',0,1,0,0),(1691,130,'木兰县',3,'',0,1,0,0),(1692,130,'松北区',3,'',0,1,0,0),(1693,130,'通河县',3,'',0,1,0,0),(1694,130,'道外区',3,'',0,1,0,0),(1695,130,'阿城区',3,'',0,1,0,0),(1696,130,'香坊区',3,'',0,1,0,0),(1697,131,'依安县',3,'',0,1,0,0),(1698,131,'克东县',3,'',0,1,0,0),(1699,131,'克山县',3,'',0,1,0,0),(1700,131,'富拉尔基区',3,'',0,1,0,0),(1701,131,'富裕县',3,'',0,1,0,0),(1702,131,'建华区',3,'',0,1,0,0),(1703,131,'拜泉县',3,'',0,1,0,0),(1704,131,'昂昂溪区',3,'',0,1,0,0),(1705,131,'梅里斯达斡尔族区',3,'',0,1,0,0),(1706,131,'泰来县',3,'',0,1,0,0),(1707,131,'甘南县',3,'',0,1,0,0),(1708,131,'碾子山区',3,'',0,1,0,0),(1709,131,'讷河市',3,'',0,1,0,0),(1710,131,'铁锋区',3,'',0,1,0,0),(1711,131,'龙江县',3,'',0,1,0,0),(1712,131,'龙沙区',3,'',0,1,0,0),(1713,132,'城子河区',3,'',0,1,0,0),(1714,132,'密山市',3,'',0,1,0,0),(1715,132,'恒山区',3,'',0,1,0,0),(1716,132,'梨树区',3,'',0,1,0,0),(1717,132,'滴道区',3,'',0,1,0,0),(1718,132,'虎林市',3,'',0,1,0,0),(1719,132,'鸡东县',3,'',0,1,0,0),(1720,132,'鸡冠区',3,'',0,1,0,0),(1721,132,'麻山区',3,'',0,1,0,0),(1722,133,'东山区',3,'',0,1,0,0),(1723,133,'兴安区',3,'',0,1,0,0),(1724,133,'兴山区',3,'',0,1,0,0),(1725,133,'南山区',3,'',0,1,0,0),(1726,133,'向阳区',3,'',0,1,0,0),(1727,133,'工农区',3,'',0,1,0,0),(1728,133,'绥滨县',3,'',0,1,0,0),(1729,133,'萝北县',3,'',0,1,0,0),(1730,134,'友谊县',3,'',0,1,0,0),(1731,134,'四方台区',3,'',0,1,0,0),(1732,134,'宝山区',3,'',0,1,0,0),(1733,134,'宝清县',3,'',0,1,0,0),(1734,134,'尖山区',3,'',0,1,0,0),(1735,134,'岭东区',3,'',0,1,0,0),(1736,134,'集贤县',3,'',0,1,0,0),(1737,134,'饶河县',3,'',0,1,0,0),(1738,135,'大同区',3,'',0,1,0,0),(1739,135,'杜尔伯特蒙古族自治县',3,'',0,1,0,0),(1740,135,'林甸县',3,'',0,1,0,0),(1741,135,'红岗区',3,'',0,1,0,0),(1742,135,'肇州县',3,'',0,1,0,0),(1743,135,'肇源县',3,'',0,1,0,0),(1744,135,'胡路区',3,'',0,1,0,0),(1745,135,'萨尔图区',3,'',0,1,0,0),(1746,135,'龙凤区',3,'',0,1,0,0),(1747,136,'上甘岭区',3,'',0,1,0,0),(1748,136,'乌伊岭区',3,'',0,1,0,0),(1749,136,'乌马河区',3,'',0,1,0,0),(1750,136,'五营区',3,'',0,1,0,0),(1751,136,'伊春区',3,'',0,1,0,0),(1752,136,'南岔区',3,'',0,1,0,0),(1753,136,'友好区',3,'',0,1,0,0),(1754,136,'嘉荫县',3,'',0,1,0,0),(1755,136,'带岭区',3,'',0,1,0,0),(1756,136,'新青区',3,'',0,1,0,0),(1757,136,'汤旺河区',3,'',0,1,0,0),(1758,136,'红星区',3,'',0,1,0,0),(1759,136,'美溪区',3,'',0,1,0,0),(1760,136,'翠峦区',3,'',0,1,0,0),(1761,136,'西林区',3,'',0,1,0,0),(1762,136,'金山屯区',3,'',0,1,0,0),(1763,136,'铁力市',3,'',0,1,0,0),(1764,137,'东风区',3,'',0,1,0,0),(1765,137,'前进区',3,'',0,1,0,0),(1766,137,'同江市',3,'',0,1,0,0),(1767,137,'向阳区',3,'',0,1,0,0),(1768,137,'富锦市',3,'',0,1,0,0),(1769,137,'抚远县',3,'',0,1,0,0),(1770,137,'桦南县',3,'',0,1,0,0),(1771,137,'桦川县',3,'',0,1,0,0),(1772,137,'汤原县',3,'',0,1,0,0),(1773,137,'郊区',3,'',0,1,0,0),(1774,138,'勃利县',3,'',0,1,0,0),(1775,138,'新兴区',3,'',0,1,0,0),(1776,138,'桃山区',3,'',0,1,0,0),(1777,138,'茄子河区',3,'',0,1,0,0),(1778,139,'东宁县',3,'',0,1,0,0),(1779,139,'东安区',3,'',0,1,0,0),(1780,139,'宁安市',3,'',0,1,0,0),(1781,139,'林口县',3,'',0,1,0,0),(1782,139,'海林市',3,'',0,1,0,0),(1783,139,'爱民区',3,'',0,1,0,0),(1784,139,'穆棱市',3,'',0,1,0,0),(1785,139,'绥芬河市',3,'',0,1,0,0),(1786,139,'西安区',3,'',0,1,0,0),(1787,139,'阳明区',3,'',0,1,0,0),(1788,140,'五大连池市',3,'',0,1,0,0),(1789,140,'北安市',3,'',0,1,0,0),(1790,140,'嫩江县',3,'',0,1,0,0),(1791,140,'孙吴县',3,'',0,1,0,0),(1792,140,'爱辉区',3,'',0,1,0,0),(1793,140,'车逊克县',3,'',0,1,0,0),(1794,140,'逊克县',3,'',0,1,0,0),(1795,141,'兰西县',3,'',0,1,0,0),(1796,141,'安达市',3,'',0,1,0,0),(1797,141,'庆安县',3,'',0,1,0,0),(1798,141,'明水县',3,'',0,1,0,0),(1799,141,'望奎县',3,'',0,1,0,0),(1800,141,'海伦市',3,'',0,1,0,0),(1801,141,'绥化市北林区',3,'',0,1,0,0),(1802,141,'绥棱县',3,'',0,1,0,0),(1803,141,'肇东市',3,'',0,1,0,0),(1804,141,'青冈县',3,'',0,1,0,0),(1805,142,'呼玛县',3,'',0,1,0,0),(1806,142,'塔河县',3,'',0,1,0,0),(1807,142,'大兴安岭地区加格达奇区',3,'',0,1,0,0),(1808,142,'大兴安岭地区呼中区',3,'',0,1,0,0),(1809,142,'大兴安岭地区新林区',3,'',0,1,0,0),(1810,142,'大兴安岭地区松岭区',3,'',0,1,0,0),(1811,142,'漠河县',3,'',0,1,0,0),(1812,143,'半淞园路街道',3,'',0,1,0,0),(1813,143,'南京东路街道',3,'',0,1,0,0),(1814,143,'外滩街道',3,'',0,1,0,0),(1815,143,'小东门街道',3,'',0,1,0,0),(1816,143,'老西门街道',3,'',0,1,0,0),(1817,143,'豫园街道',3,'',0,1,0,0),(1818,144,'五里桥街道',3,'',0,1,0,0),(1819,144,'打浦桥街道',3,'',0,1,0,0),(1820,144,'淮海中路街道',3,'',0,1,0,0),(1821,144,'瑞金二路街道',3,'',0,1,0,0),(1822,145,'凌云路街道',3,'',0,1,0,0),(1823,145,'华泾镇',3,'',0,1,0,0),(1824,145,'天平路街道',3,'',0,1,0,0),(1825,145,'康健新村街道',3,'',0,1,0,0),(1826,145,'徐家汇街道',3,'',0,1,0,0),(1827,145,'斜土路街道',3,'',0,1,0,0),(1828,145,'枫林路街道',3,'',0,1,0,0),(1829,145,'湖南路街道',3,'',0,1,0,0),(1830,145,'漕河泾街道',3,'',0,1,0,0),(1831,145,'田林街道',3,'',0,1,0,0),(1832,145,'虹梅路街道',3,'',0,1,0,0),(1833,145,'长桥街道',3,'',0,1,0,0),(1834,145,'龙华街道',3,'',0,1,0,0),(1835,146,'仙霞新村街道',3,'',0,1,0,0),(1836,146,'北新泾街道',3,'',0,1,0,0),(1837,146,'华阳路街道',3,'',0,1,0,0),(1838,146,'周家桥街道',3,'',0,1,0,0),(1839,146,'天山路街道',3,'',0,1,0,0),(1840,146,'新华路街道',3,'',0,1,0,0),(1841,146,'新泾镇',3,'',0,1,0,0),(1842,146,'江苏路街道',3,'',0,1,0,0),(1843,146,'程家桥街道',3,'',0,1,0,0),(1844,146,'虹桥街道',3,'',0,1,0,0),(1845,147,'南京西路街道',3,'',0,1,0,0),(1846,147,'曹家渡街道',3,'',0,1,0,0),(1847,147,'江宁路街道',3,'',0,1,0,0),(1848,147,'石门二路街道',3,'',0,1,0,0),(1849,147,'静安寺街道',3,'',0,1,0,0),(1850,148,'宜川路街道',3,'',0,1,0,0),(1851,148,'曹杨新村街道',3,'',0,1,0,0),(1852,148,'桃浦镇',3,'',0,1,0,0),(1853,148,'甘泉路街道',3,'',0,1,0,0),(1854,148,'真如镇',3,'',0,1,0,0),(1855,148,'石泉路街道',3,'',0,1,0,0),(1856,148,'长寿路街道',3,'',0,1,0,0),(1857,148,'长征镇',3,'',0,1,0,0),(1858,148,'长风新村街道',3,'',0,1,0,0),(1859,149,'临汾路街道',3,'',0,1,0,0),(1860,149,'共和新路街道',3,'',0,1,0,0),(1861,149,'北站街道',3,'',0,1,0,0),(1862,149,'大宁路街道',3,'',0,1,0,0),(1863,149,'天目西路街道',3,'',0,1,0,0),(1864,149,'宝山路街道',3,'',0,1,0,0),(1865,149,'彭浦新村街道',3,'',0,1,0,0),(1866,149,'彭浦镇',3,'',0,1,0,0),(1867,149,'芷江西路街道',3,'',0,1,0,0),(1868,150,'乍浦路街道',3,'',0,1,0,0),(1869,150,'凉城新村街道',3,'',0,1,0,0),(1870,150,'嘉兴路街道',3,'',0,1,0,0),(1871,150,'四川北路街道',3,'',0,1,0,0),(1872,150,'广中路街道',3,'',0,1,0,0),(1873,150,'提篮桥街道',3,'',0,1,0,0),(1874,150,'新港路街道',3,'',0,1,0,0),(1875,150,'曲阳路街道',3,'',0,1,0,0),(1876,150,'欧阳路街道',3,'',0,1,0,0),(1877,150,'江湾镇街道',3,'',0,1,0,0),(1878,151,'五角场街道',3,'',0,1,0,0),(1879,151,'五角场镇',3,'',0,1,0,0),(1880,151,'四平路街道',3,'',0,1,0,0),(1881,151,'大桥街道',3,'',0,1,0,0),(1882,151,'定海路街道',3,'',0,1,0,0),(1883,151,'平凉路街道',3,'',0,1,0,0),(1884,151,'延吉新村街道',3,'',0,1,0,0),(1885,151,'控江路街道',3,'',0,1,0,0),(1886,151,'新江湾城街道',3,'',0,1,0,0),(1887,151,'殷行街道',3,'',0,1,0,0),(1888,151,'江浦路街道',3,'',0,1,0,0),(1889,151,'长白新村街道',3,'',0,1,0,0),(1890,152,'七宝镇',3,'',0,1,0,0),(1891,152,'华漕镇',3,'',0,1,0,0),(1892,152,'古美街道',3,'',0,1,0,0),(1893,152,'吴泾镇',3,'',0,1,0,0),(1894,152,'梅陇镇',3,'',0,1,0,0),(1895,152,'江川路街道',3,'',0,1,0,0),(1896,152,'浦江镇',3,'',0,1,0,0),(1897,152,'莘庄镇',3,'',0,1,0,0),(1898,152,'虹桥镇',3,'',0,1,0,0),(1899,152,'颛桥镇',3,'',0,1,0,0),(1900,152,'马桥镇',3,'',0,1,0,0),(1901,152,'龙柏街道',3,'',0,1,0,0),(1902,153,'友谊路街道',3,'',0,1,0,0),(1903,153,'吴淞街道',3,'',0,1,0,0),(1904,153,'大场镇',3,'',0,1,0,0),(1905,153,'庙行镇',3,'',0,1,0,0),(1906,153,'张庙街道',3,'',0,1,0,0),(1907,153,'月浦镇',3,'',0,1,0,0),(1908,153,'杨行镇',3,'',0,1,0,0),(1909,153,'淞南镇',3,'',0,1,0,0),(1910,153,'罗店镇',3,'',0,1,0,0),(1911,153,'罗泾镇',3,'',0,1,0,0),(1912,153,'顾村镇',3,'',0,1,0,0),(1913,153,'高境镇',3,'',0,1,0,0),(1914,154,'华亭镇',3,'',0,1,0,0),(1915,154,'南翔镇',3,'',0,1,0,0),(1916,154,'嘉定工业区',3,'',0,1,0,0),(1917,154,'嘉定镇街道',3,'',0,1,0,0),(1918,154,'外冈镇',3,'',0,1,0,0),(1919,154,'安亭镇',3,'',0,1,0,0),(1920,154,'徐行镇',3,'',0,1,0,0),(1921,154,'新成路街道',3,'',0,1,0,0),(1922,154,'江桥镇',3,'',0,1,0,0),(1923,154,'真新新村街道',3,'',0,1,0,0),(1924,154,'菊园新区',3,'',0,1,0,0),(1925,154,'马陆镇',3,'',0,1,0,0),(1926,154,'黄渡镇',3,'',0,1,0,0),(1927,155,'三林镇',3,'',0,1,0,0),(1928,155,'上钢新村街道',3,'',0,1,0,0),(1929,155,'东明路街道',3,'',0,1,0,0),(1930,155,'北蔡镇',3,'',0,1,0,0),(1931,155,'南码头路街道',3,'',0,1,0,0),(1932,155,'合庆镇',3,'',0,1,0,0),(1933,155,'周家渡街道',3,'',0,1,0,0),(1934,155,'唐镇',3,'',0,1,0,0),(1935,155,'塘桥街道',3,'',0,1,0,0),(1936,155,'川沙新镇',3,'',0,1,0,0),(1937,155,'张江镇',3,'',0,1,0,0),(1938,155,'曹路镇',3,'',0,1,0,0),(1939,155,'沪东新村街道',3,'',0,1,0,0),(1940,155,'洋泾街道',3,'',0,1,0,0),(1941,155,'浦兴路街道',3,'',0,1,0,0),(1942,155,'潍坊新村街道',3,'',0,1,0,0),(1943,155,'花木街道',3,'',0,1,0,0),(1944,155,'金杨新村街道',3,'',0,1,0,0),(1945,155,'金桥镇',3,'',0,1,0,0),(1946,155,'陆家嘴街道',3,'',0,1,0,0),(1947,155,'高东镇',3,'',0,1,0,0),(1948,155,'高桥镇',3,'',0,1,0,0),(1949,155,'高行镇',3,'',0,1,0,0),(1950,156,'亭林镇',3,'',0,1,0,0),(1951,156,'吕巷镇',3,'',0,1,0,0),(1952,156,'山阳镇',3,'',0,1,0,0),(1953,156,'廊下镇',3,'',0,1,0,0),(1954,156,'张堰镇',3,'',0,1,0,0),(1955,156,'朱泾镇',3,'',0,1,0,0),(1956,156,'枫泾镇',3,'',0,1,0,0),(1957,156,'漕泾镇',3,'',0,1,0,0),(1958,156,'石化街道',3,'',0,1,0,0),(1959,156,'金山卫镇',3,'',0,1,0,0),(1960,157,'上海松江科技园区',3,'',0,1,0,0),(1961,157,'中山街道',3,'',0,1,0,0),(1962,157,'九亭镇',3,'',0,1,0,0),(1963,157,'五厍农业园区',3,'',0,1,0,0),(1964,157,'佘山度假区',3,'',0,1,0,0),(1965,157,'佘山镇',3,'',0,1,0,0),(1966,157,'叶榭镇',3,'',0,1,0,0),(1967,157,'岳阳街道',3,'',0,1,0,0),(1968,157,'新桥镇',3,'',0,1,0,0),(1969,157,'新浜镇',3,'',0,1,0,0),(1970,157,'方松街道',3,'',0,1,0,0),(1971,157,'松江工业区',3,'',0,1,0,0),(1972,157,'永丰街道',3,'',0,1,0,0),(1973,157,'泖港镇',3,'',0,1,0,0),(1974,157,'泗泾镇',3,'',0,1,0,0),(1975,157,'洞泾镇',3,'',0,1,0,0),(1976,157,'石湖荡镇',3,'',0,1,0,0),(1977,157,'车墩镇',3,'',0,1,0,0),(1978,158,'华新镇',3,'',0,1,0,0),(1979,158,'夏阳街道',3,'',0,1,0,0),(1980,158,'徐泾镇',3,'',0,1,0,0),(1981,158,'朱家角镇',3,'',0,1,0,0),(1982,158,'白鹤镇',3,'',0,1,0,0),(1983,158,'盈浦街道',3,'',0,1,0,0),(1984,158,'练塘镇',3,'',0,1,0,0),(1985,158,'赵巷镇',3,'',0,1,0,0),(1986,158,'重固镇',3,'',0,1,0,0),(1987,158,'金泽镇',3,'',0,1,0,0),(1988,158,'香花桥街道',3,'',0,1,0,0),(1989,159,'万祥镇',3,'',0,1,0,0),(1990,159,'书院镇',3,'',0,1,0,0),(1991,159,'六灶镇',3,'',0,1,0,0),(1992,159,'周浦镇',3,'',0,1,0,0),(1993,159,'大团镇',3,'',0,1,0,0),(1994,159,'宣桥镇',3,'',0,1,0,0),(1995,159,'康桥镇',3,'',0,1,0,0),(1996,159,'惠南镇',3,'',0,1,0,0),(1997,159,'新场镇',3,'',0,1,0,0),(1998,159,'泥城镇',3,'',0,1,0,0),(1999,159,'祝桥镇',3,'',0,1,0,0),(2000,159,'老港镇',3,'',0,1,0,0),(2001,159,'航头镇',3,'',0,1,0,0),(2002,159,'芦潮港镇',3,'',0,1,0,0),(2003,160,'南桥镇',3,'',0,1,0,0),(2004,160,'四团镇',3,'',0,1,0,0),(2005,160,'奉城镇',3,'',0,1,0,0),(2006,160,'庄行镇',3,'',0,1,0,0),(2007,160,'柘林镇',3,'',0,1,0,0),(2008,160,'海湾镇',3,'',0,1,0,0),(2009,160,'金汇镇',3,'',0,1,0,0),(2010,160,'青村镇',3,'',0,1,0,0),(2011,161,'三星镇',3,'',0,1,0,0),(2012,161,'中兴镇',3,'',0,1,0,0),(2013,161,'向化镇',3,'',0,1,0,0),(2014,161,'城桥镇',3,'',0,1,0,0),(2015,161,'堡镇',3,'',0,1,0,0),(2016,161,'庙镇',3,'',0,1,0,0),(2017,161,'建设镇',3,'',0,1,0,0),(2018,161,'新村乡',3,'',0,1,0,0),(2019,161,'新河镇',3,'',0,1,0,0),(2020,161,'横沙乡',3,'',0,1,0,0),(2021,161,'港沿镇',3,'',0,1,0,0),(2022,161,'港西镇',3,'',0,1,0,0),(2023,161,'竖新镇',3,'',0,1,0,0),(2024,161,'绿华镇',3,'',0,1,0,0),(2025,161,'长兴乡',3,'',0,1,0,0),(2026,161,'陈家镇',3,'',0,1,0,0),(2027,162,'下关区',3,'',0,1,0,0),(2028,162,'六合区',3,'',0,1,0,0),(2029,162,'建邺区',3,'',0,1,0,0),(2030,162,'栖霞区',3,'',0,1,0,0),(2031,162,'江宁区',3,'',0,1,0,0),(2032,162,'浦口区',3,'',0,1,0,0),(2033,162,'溧水县',3,'',0,1,0,0),(2034,162,'玄武区',3,'',0,1,0,0),(2035,162,'白下区',3,'',0,1,0,0),(2036,162,'秦淮区',3,'',0,1,0,0),(2037,162,'雨花台区',3,'',0,1,0,0),(2038,162,'高淳县',3,'',0,1,0,0),(2039,162,'鼓楼区',3,'',0,1,0,0),(2040,163,'北塘区',3,'',0,1,0,0),(2041,163,'南长区',3,'',0,1,0,0),(2042,163,'宜兴市',3,'',0,1,0,0),(2043,163,'崇安区',3,'',0,1,0,0),(2044,163,'惠山区',3,'',0,1,0,0),(2045,163,'江阴市',3,'',0,1,0,0),(2046,163,'滨湖区',3,'',0,1,0,0),(2047,163,'锡山区',3,'',0,1,0,0),(2048,164,'丰县',3,'',0,1,0,0),(2049,164,'九里区',3,'',0,1,0,0),(2050,164,'云龙区',3,'',0,1,0,0),(2051,164,'新沂市',3,'',0,1,0,0),(2052,164,'沛县',3,'',0,1,0,0),(2053,164,'泉山区',3,'',0,1,0,0),(2054,164,'睢宁县',3,'',0,1,0,0),(2055,164,'贾汪区',3,'',0,1,0,0),(2056,164,'邳州市',3,'',0,1,0,0),(2057,164,'铜山县',3,'',0,1,0,0),(2058,164,'鼓楼区',3,'',0,1,0,0),(2059,165,'天宁区',3,'',0,1,0,0),(2060,165,'戚墅堰区',3,'',0,1,0,0),(2061,165,'新北区',3,'',0,1,0,0),(2062,165,'武进区',3,'',0,1,0,0),(2063,165,'溧阳市',3,'',0,1,0,0),(2064,165,'金坛市',3,'',0,1,0,0),(2065,165,'钟楼区',3,'',0,1,0,0),(2066,166,'吴中区',3,'',0,1,0,0),(2067,166,'吴江市',3,'',0,1,0,0),(2068,166,'太仓市',3,'',0,1,0,0),(2069,166,'常熟市',3,'',0,1,0,0),(2070,166,'平江区',3,'',0,1,0,0),(2071,166,'张家港市',3,'',0,1,0,0),(2072,166,'昆山市',3,'',0,1,0,0),(2073,166,'沧浪区',3,'',0,1,0,0),(2074,166,'相城区',3,'',0,1,0,0),(2075,166,'苏州工业园区',3,'',0,1,0,0),(2076,166,'虎丘区',3,'',0,1,0,0),(2077,166,'金阊区',3,'',0,1,0,0),(2078,167,'启东市',3,'',0,1,0,0),(2079,167,'如东县',3,'',0,1,0,0),(2080,167,'如皋市',3,'',0,1,0,0),(2081,167,'崇川区',3,'',0,1,0,0),(2082,167,'海安县',3,'',0,1,0,0),(2083,167,'海门市',3,'',0,1,0,0),(2084,167,'港闸区',3,'',0,1,0,0),(2085,167,'通州市',3,'',0,1,0,0),(2086,168,'东海县',3,'',0,1,0,0),(2087,168,'新浦区',3,'',0,1,0,0),(2088,168,'海州区',3,'',0,1,0,0),(2089,168,'灌云县',3,'',0,1,0,0),(2090,168,'灌南县',3,'',0,1,0,0),(2091,168,'赣榆县',3,'',0,1,0,0),(2092,168,'连云区',3,'',0,1,0,0),(2093,169,'楚州区',3,'',0,1,0,0),(2094,169,'洪泽县',3,'',0,1,0,0),(2095,169,'涟水县',3,'',0,1,0,0),(2096,169,'淮阴区',3,'',0,1,0,0),(2097,169,'清河区',3,'',0,1,0,0),(2098,169,'清浦区',3,'',0,1,0,0),(2099,169,'盱眙县',3,'',0,1,0,0),(2100,169,'金湖县',3,'',0,1,0,0),(2101,170,'东台市',3,'',0,1,0,0),(2102,170,'亭湖区',3,'',0,1,0,0),(2103,170,'响水县',3,'',0,1,0,0),(2104,170,'大丰市',3,'',0,1,0,0),(2105,170,'射阳县',3,'',0,1,0,0),(2106,170,'建湖县',3,'',0,1,0,0),(2107,170,'滨海县',3,'',0,1,0,0),(2108,170,'盐都区',3,'',0,1,0,0),(2109,170,'阜宁县',3,'',0,1,0,0),(2110,171,'仪征市',3,'',0,1,0,0),(2111,171,'宝应县',3,'',0,1,0,0),(2112,171,'广陵区',3,'',0,1,0,0),(2113,171,'江都市',3,'',0,1,0,0),(2114,171,'维扬区',3,'',0,1,0,0),(2115,171,'邗江区',3,'',0,1,0,0),(2116,171,'高邮市',3,'',0,1,0,0),(2117,172,'丹徒区',3,'',0,1,0,0),(2118,172,'丹阳市',3,'',0,1,0,0),(2119,172,'京口区',3,'',0,1,0,0),(2120,172,'句容市',3,'',0,1,0,0),(2121,172,'扬中市',3,'',0,1,0,0),(2122,172,'润州区',3,'',0,1,0,0),(2123,173,'兴化市',3,'',0,1,0,0),(2124,173,'姜堰市',3,'',0,1,0,0),(2125,173,'泰兴市',3,'',0,1,0,0),(2126,173,'海陵区',3,'',0,1,0,0),(2127,173,'靖江市',3,'',0,1,0,0),(2128,173,'高港区',3,'',0,1,0,0),(2129,174,'宿城区',3,'',0,1,0,0),(2130,174,'宿豫区',3,'',0,1,0,0),(2131,174,'沭阳县',3,'',0,1,0,0),(2132,174,'泗洪县',3,'',0,1,0,0),(2133,174,'泗阳县',3,'',0,1,0,0),(2134,175,'上城区',3,'',0,1,0,0),(2135,175,'下城区',3,'',0,1,0,0),(2136,175,'临安市',3,'',0,1,0,0),(2137,175,'余杭区',3,'',0,1,0,0),(2138,175,'富阳市',3,'',0,1,0,0),(2139,175,'建德市',3,'',0,1,0,0),(2140,175,'拱墅区',3,'',0,1,0,0),(2141,175,'桐庐县',3,'',0,1,0,0),(2142,175,'江干区',3,'',0,1,0,0),(2143,175,'淳安县',3,'',0,1,0,0),(2144,175,'滨江区',3,'',0,1,0,0),(2145,175,'萧山区',3,'',0,1,0,0),(2146,175,'西湖区',3,'',0,1,0,0),(2147,176,'余姚市',3,'',0,1,0,0),(2148,176,'北仑区',3,'',0,1,0,0),(2149,176,'奉化市',3,'',0,1,0,0),(2150,176,'宁海县',3,'',0,1,0,0),(2151,176,'慈溪市',3,'',0,1,0,0),(2152,176,'江东区',3,'',0,1,0,0),(2153,176,'江北区',3,'',0,1,0,0),(2154,176,'海曙区',3,'',0,1,0,0),(2155,176,'象山县',3,'',0,1,0,0),(2156,176,'鄞州区',3,'',0,1,0,0),(2157,176,'镇海区',3,'',0,1,0,0),(2158,177,'乐清市',3,'',0,1,0,0),(2159,177,'平阳县',3,'',0,1,0,0),(2160,177,'文成县',3,'',0,1,0,0),(2161,177,'永嘉县',3,'',0,1,0,0),(2162,177,'泰顺县',3,'',0,1,0,0),(2163,177,'洞头县',3,'',0,1,0,0),(2164,177,'瑞安市',3,'',0,1,0,0),(2165,177,'瓯海区',3,'',0,1,0,0),(2166,177,'苍南县',3,'',0,1,0,0),(2167,177,'鹿城区',3,'',0,1,0,0),(2168,177,'龙湾区',3,'',0,1,0,0),(2169,178,'南湖区',3,'',0,1,0,0),(2170,178,'嘉善县',3,'',0,1,0,0),(2171,178,'平湖市',3,'',0,1,0,0),(2172,178,'桐乡市',3,'',0,1,0,0),(2173,178,'海宁市',3,'',0,1,0,0),(2174,178,'海盐县',3,'',0,1,0,0),(2175,178,'秀洲区',3,'',0,1,0,0),(2176,179,'南浔区',3,'',0,1,0,0),(2177,179,'吴兴区',3,'',0,1,0,0),(2178,179,'安吉县',3,'',0,1,0,0),(2179,179,'德清县',3,'',0,1,0,0),(2180,179,'长兴县',3,'',0,1,0,0),(2181,180,'上虞市',3,'',0,1,0,0),(2182,180,'嵊州市',3,'',0,1,0,0),(2183,180,'新昌县',3,'',0,1,0,0),(2184,180,'绍兴县',3,'',0,1,0,0),(2185,180,'诸暨市',3,'',0,1,0,0),(2186,180,'越城区',3,'',0,1,0,0),(2187,181,'定海区',3,'',0,1,0,0),(2188,181,'岱山县',3,'',0,1,0,0),(2189,181,'嵊泗县',3,'',0,1,0,0),(2190,181,'普陀区',3,'',0,1,0,0),(2191,182,'常山县',3,'',0,1,0,0),(2192,182,'开化县',3,'',0,1,0,0),(2193,182,'柯城区',3,'',0,1,0,0),(2194,182,'江山市',3,'',0,1,0,0),(2195,182,'衢江区',3,'',0,1,0,0),(2196,182,'龙游县',3,'',0,1,0,0),(2197,183,'东阳市',3,'',0,1,0,0),(2198,183,'义乌市',3,'',0,1,0,0),(2199,183,'兰溪市',3,'',0,1,0,0),(2200,183,'婺城区',3,'',0,1,0,0),(2201,183,'武义县',3,'',0,1,0,0),(2202,183,'永康市',3,'',0,1,0,0),(2203,183,'浦江县',3,'',0,1,0,0),(2204,183,'磐安县',3,'',0,1,0,0),(2205,183,'金东区',3,'',0,1,0,0),(2206,184,'三门县',3,'',0,1,0,0),(2207,184,'临海市',3,'',0,1,0,0),(2208,184,'仙居县',3,'',0,1,0,0),(2209,184,'天台县',3,'',0,1,0,0),(2210,184,'椒江区',3,'',0,1,0,0),(2211,184,'温岭市',3,'',0,1,0,0),(2212,184,'玉环县',3,'',0,1,0,0),(2213,184,'路桥区',3,'',0,1,0,0),(2214,184,'黄岩区',3,'',0,1,0,0),(2215,185,'云和县',3,'',0,1,0,0),(2216,185,'庆元县',3,'',0,1,0,0),(2217,185,'景宁畲族自治县',3,'',0,1,0,0),(2218,185,'松阳县',3,'',0,1,0,0),(2219,185,'缙云县',3,'',0,1,0,0),(2220,185,'莲都区',3,'',0,1,0,0),(2221,185,'遂昌县',3,'',0,1,0,0),(2222,185,'青田县',3,'',0,1,0,0),(2223,185,'龙泉市',3,'',0,1,0,0),(2224,186,'包河区',3,'',0,1,0,0),(2225,186,'庐阳区',3,'',0,1,0,0),(2226,186,'瑶海区',3,'',0,1,0,0),(2227,186,'肥东县',3,'',0,1,0,0),(2228,186,'肥西县',3,'',0,1,0,0),(2229,186,'蜀山区',3,'',0,1,0,0),(2230,186,'长丰县',3,'',0,1,0,0),(2231,187,'三山区',3,'',0,1,0,0),(2232,187,'南陵县',3,'',0,1,0,0),(2233,187,'弋江区',3,'',0,1,0,0),(2234,187,'繁昌县',3,'',0,1,0,0),(2235,187,'芜湖县',3,'',0,1,0,0),(2236,187,'镜湖区',3,'',0,1,0,0),(2237,187,'鸠江区',3,'',0,1,0,0),(2238,188,'五河县',3,'',0,1,0,0),(2239,188,'固镇县',3,'',0,1,0,0),(2240,188,'怀远县',3,'',0,1,0,0),(2241,188,'淮上区',3,'',0,1,0,0),(2242,188,'禹会区',3,'',0,1,0,0),(2243,188,'蚌山区',3,'',0,1,0,0),(2244,188,'龙子湖区',3,'',0,1,0,0),(2245,189,'八公山区',3,'',0,1,0,0),(2246,189,'凤台县',3,'',0,1,0,0),(2247,189,'大通区',3,'',0,1,0,0),(2248,189,'潘集区',3,'',0,1,0,0),(2249,189,'田家庵区',3,'',0,1,0,0),(2250,189,'谢家集区',3,'',0,1,0,0),(2251,190,'当涂县',3,'',0,1,0,0),(2252,190,'花山区',3,'',0,1,0,0),(2253,190,'金家庄区',3,'',0,1,0,0),(2254,190,'雨山区',3,'',0,1,0,0),(2255,191,'杜集区',3,'',0,1,0,0),(2256,191,'濉溪县',3,'',0,1,0,0),(2257,191,'烈山区',3,'',0,1,0,0),(2258,191,'相山区',3,'',0,1,0,0),(2259,192,'狮子山区',3,'',0,1,0,0),(2260,192,'郊区',3,'',0,1,0,0),(2261,192,'铜官山区',3,'',0,1,0,0),(2262,192,'铜陵县',3,'',0,1,0,0),(2263,193,'大观区',3,'',0,1,0,0),(2264,193,'太湖县',3,'',0,1,0,0),(2265,193,'宜秀区',3,'',0,1,0,0),(2266,193,'宿松县',3,'',0,1,0,0),(2267,193,'岳西县',3,'',0,1,0,0),(2268,193,'怀宁县',3,'',0,1,0,0),(2269,193,'望江县',3,'',0,1,0,0),(2270,193,'枞阳县',3,'',0,1,0,0),(2271,193,'桐城市',3,'',0,1,0,0),(2272,193,'潜山县',3,'',0,1,0,0),(2273,193,'迎江区',3,'',0,1,0,0),(2274,194,'休宁县',3,'',0,1,0,0),(2275,194,'屯溪区',3,'',0,1,0,0),(2276,194,'徽州区',3,'',0,1,0,0),(2277,194,'歙县',3,'',0,1,0,0),(2278,194,'祁门县',3,'',0,1,0,0),(2279,194,'黄山区',3,'',0,1,0,0),(2280,194,'黟县',3,'',0,1,0,0),(2281,195,'全椒县',3,'',0,1,0,0),(2282,195,'凤阳县',3,'',0,1,0,0),(2283,195,'南谯区',3,'',0,1,0,0),(2284,195,'天长市',3,'',0,1,0,0),(2285,195,'定远县',3,'',0,1,0,0),(2286,195,'明光市',3,'',0,1,0,0),(2287,195,'来安县',3,'',0,1,0,0),(2288,195,'琅玡区',3,'',0,1,0,0),(2289,196,'临泉县',3,'',0,1,0,0),(2290,196,'太和县',3,'',0,1,0,0),(2291,196,'界首市',3,'',0,1,0,0),(2292,196,'阜南县',3,'',0,1,0,0),(2293,196,'颍东区',3,'',0,1,0,0),(2294,196,'颍州区',3,'',0,1,0,0),(2295,196,'颍泉区',3,'',0,1,0,0),(2296,196,'颖上县',3,'',0,1,0,0),(2297,197,'埇桥区',3,'',0,1,0,0),(2298,197,'泗县辖',3,'',0,1,0,0),(2299,197,'灵璧县',3,'',0,1,0,0),(2300,197,'砀山县',3,'',0,1,0,0),(2301,197,'萧县',3,'',0,1,0,0),(2302,198,'含山县',3,'',0,1,0,0),(2303,198,'和县',3,'',0,1,0,0),(2304,198,'居巢区',3,'',0,1,0,0),(2305,198,'庐江县',3,'',0,1,0,0),(2306,198,'无为县',3,'',0,1,0,0),(2307,199,'寿县',3,'',0,1,0,0),(2308,199,'舒城县',3,'',0,1,0,0),(2309,199,'裕安区',3,'',0,1,0,0),(2310,199,'金安区',3,'',0,1,0,0),(2311,199,'金寨县',3,'',0,1,0,0),(2312,199,'霍山县',3,'',0,1,0,0),(2313,199,'霍邱县',3,'',0,1,0,0),(2314,200,'利辛县',3,'',0,1,0,0),(2315,200,'涡阳县',3,'',0,1,0,0),(2316,200,'蒙城县',3,'',0,1,0,0),(2317,200,'谯城区',3,'',0,1,0,0),(2318,201,'东至县',3,'',0,1,0,0),(2319,201,'石台县',3,'',0,1,0,0),(2320,201,'贵池区',3,'',0,1,0,0),(2321,201,'青阳县',3,'',0,1,0,0),(2322,202,'宁国市',3,'',0,1,0,0),(2323,202,'宣州区',3,'',0,1,0,0),(2324,202,'广德县',3,'',0,1,0,0),(2325,202,'旌德县',3,'',0,1,0,0),(2326,202,'泾县',3,'',0,1,0,0),(2327,202,'绩溪县',3,'',0,1,0,0),(2328,202,'郎溪县',3,'',0,1,0,0),(2329,203,'仓山区',3,'',0,1,0,0),(2330,203,'台江区',3,'',0,1,0,0),(2331,203,'平潭县',3,'',0,1,0,0),(2332,203,'晋安区',3,'',0,1,0,0),(2333,203,'永泰县',3,'',0,1,0,0),(2334,203,'福清市',3,'',0,1,0,0),(2335,203,'罗源县',3,'',0,1,0,0),(2336,203,'连江县',3,'',0,1,0,0),(2337,203,'长乐市',3,'',0,1,0,0),(2338,203,'闽侯县',3,'',0,1,0,0),(2339,203,'闽清县',3,'',0,1,0,0),(2340,203,'马尾区',3,'',0,1,0,0),(2341,203,'鼓楼区',3,'',0,1,0,0),(2342,204,'同安区',3,'',0,1,0,0),(2343,204,'思明区',3,'',0,1,0,0),(2344,204,'海沧区',3,'',0,1,0,0),(2345,204,'湖里区',3,'',0,1,0,0),(2346,204,'翔安区',3,'',0,1,0,0),(2347,204,'集美区',3,'',0,1,0,0),(2348,205,'仙游县',3,'',0,1,0,0),(2349,205,'城厢区',3,'',0,1,0,0),(2350,205,'涵江区',3,'',0,1,0,0),(2351,205,'秀屿区',3,'',0,1,0,0),(2352,205,'荔城区',3,'',0,1,0,0),(2353,206,'三元区',3,'',0,1,0,0),(2354,206,'大田县',3,'',0,1,0,0),(2355,206,'宁化县',3,'',0,1,0,0),(2356,206,'将乐县',3,'',0,1,0,0),(2357,206,'尤溪县',3,'',0,1,0,0),(2358,206,'建宁县',3,'',0,1,0,0),(2359,206,'明溪县',3,'',0,1,0,0),(2360,206,'梅列区',3,'',0,1,0,0),(2361,206,'永安市',3,'',0,1,0,0),(2362,206,'沙县',3,'',0,1,0,0),(2363,206,'泰宁县',3,'',0,1,0,0),(2364,206,'清流县',3,'',0,1,0,0),(2365,207,'丰泽区',3,'',0,1,0,0),(2366,207,'南安市',3,'',0,1,0,0),(2367,207,'安溪县',3,'',0,1,0,0),(2368,207,'德化县',3,'',0,1,0,0),(2369,207,'惠安县',3,'',0,1,0,0),(2370,207,'晋江市',3,'',0,1,0,0),(2371,207,'永春县',3,'',0,1,0,0),(2372,207,'泉港区',3,'',0,1,0,0),(2373,207,'洛江区',3,'',0,1,0,0),(2374,207,'石狮市',3,'',0,1,0,0),(2375,207,'金门县',3,'',0,1,0,0),(2376,207,'鲤城区',3,'',0,1,0,0),(2377,208,'东山县',3,'',0,1,0,0),(2378,208,'云霄县',3,'',0,1,0,0),(2379,208,'华安县',3,'',0,1,0,0),(2380,208,'南靖县',3,'',0,1,0,0),(2381,208,'平和县',3,'',0,1,0,0),(2382,208,'漳浦县',3,'',0,1,0,0),(2383,208,'芗城区',3,'',0,1,0,0),(2384,208,'诏安县',3,'',0,1,0,0),(2385,208,'长泰县',3,'',0,1,0,0),(2386,208,'龙文区',3,'',0,1,0,0),(2387,208,'龙海市',3,'',0,1,0,0),(2388,209,'光泽县',3,'',0,1,0,0),(2389,209,'延平区',3,'',0,1,0,0),(2390,209,'建瓯市',3,'',0,1,0,0),(2391,209,'建阳市',3,'',0,1,0,0),(2392,209,'政和县',3,'',0,1,0,0),(2393,209,'松溪县',3,'',0,1,0,0),(2394,209,'武夷山市',3,'',0,1,0,0),(2395,209,'浦城县',3,'',0,1,0,0),(2396,209,'邵武市',3,'',0,1,0,0),(2397,209,'顺昌县',3,'',0,1,0,0),(2398,210,'上杭县',3,'',0,1,0,0),(2399,210,'新罗区',3,'',0,1,0,0),(2400,210,'武平县',3,'',0,1,0,0),(2401,210,'永定县',3,'',0,1,0,0),(2402,210,'漳平市',3,'',0,1,0,0),(2403,210,'连城县',3,'',0,1,0,0),(2404,210,'长汀县',3,'',0,1,0,0),(2405,211,'古田县',3,'',0,1,0,0),(2406,211,'周宁县',3,'',0,1,0,0),(2407,211,'寿宁县',3,'',0,1,0,0),(2408,211,'屏南县',3,'',0,1,0,0),(2409,211,'柘荣县',3,'',0,1,0,0),(2410,211,'福安市',3,'',0,1,0,0),(2411,211,'福鼎市',3,'',0,1,0,0),(2412,211,'蕉城区',3,'',0,1,0,0),(2413,211,'霞浦县',3,'',0,1,0,0),(2414,212,'东湖区',3,'',0,1,0,0),(2415,212,'南昌县',3,'',0,1,0,0),(2416,212,'安义县',3,'',0,1,0,0),(2417,212,'新建县',3,'',0,1,0,0),(2418,212,'湾里区',3,'',0,1,0,0),(2419,212,'西湖区',3,'',0,1,0,0),(2420,212,'进贤县',3,'',0,1,0,0),(2421,212,'青云谱区',3,'',0,1,0,0),(2422,212,'青山湖区',3,'',0,1,0,0),(2423,213,'乐平市',3,'',0,1,0,0),(2424,213,'昌江区',3,'',0,1,0,0),(2425,213,'浮梁县',3,'',0,1,0,0),(2426,213,'珠山区',3,'',0,1,0,0),(2427,214,'上栗县',3,'',0,1,0,0),(2428,214,'安源区',3,'',0,1,0,0),(2429,214,'湘东区',3,'',0,1,0,0),(2430,214,'芦溪县',3,'',0,1,0,0),(2431,214,'莲花县',3,'',0,1,0,0),(2432,215,'九江县',3,'',0,1,0,0),(2433,215,'修水县',3,'',0,1,0,0),(2434,215,'庐山区',3,'',0,1,0,0),(2435,215,'彭泽县',3,'',0,1,0,0),(2436,215,'德安县',3,'',0,1,0,0),(2437,215,'星子县',3,'',0,1,0,0),(2438,215,'武宁县',3,'',0,1,0,0),(2439,215,'永修县',3,'',0,1,0,0),(2440,215,'浔阳区',3,'',0,1,0,0),(2441,215,'湖口县',3,'',0,1,0,0),(2442,215,'瑞昌市',3,'',0,1,0,0),(2443,215,'都昌县',3,'',0,1,0,0),(2444,216,'分宜县',3,'',0,1,0,0),(2445,216,'渝水区',3,'',0,1,0,0),(2446,217,'余江县',3,'',0,1,0,0),(2447,217,'月湖区',3,'',0,1,0,0),(2448,217,'贵溪市',3,'',0,1,0,0),(2449,218,'上犹县',3,'',0,1,0,0),(2450,218,'于都县',3,'',0,1,0,0),(2451,218,'会昌县',3,'',0,1,0,0),(2452,218,'信丰县',3,'',0,1,0,0),(2453,218,'全南县',3,'',0,1,0,0),(2454,218,'兴国县',3,'',0,1,0,0),(2455,218,'南康市',3,'',0,1,0,0),(2456,218,'大余县',3,'',0,1,0,0),(2457,218,'宁都县',3,'',0,1,0,0),(2458,218,'安远县',3,'',0,1,0,0),(2459,218,'定南县',3,'',0,1,0,0),(2460,218,'寻乌县',3,'',0,1,0,0),(2461,218,'崇义县',3,'',0,1,0,0),(2462,218,'瑞金市',3,'',0,1,0,0),(2463,218,'石城县',3,'',0,1,0,0),(2464,218,'章贡区',3,'',0,1,0,0),(2465,218,'赣县',3,'',0,1,0,0),(2466,218,'龙南县',3,'',0,1,0,0),(2467,219,'万安县',3,'',0,1,0,0),(2468,219,'井冈山市',3,'',0,1,0,0),(2469,219,'吉安县',3,'',0,1,0,0),(2470,219,'吉州区',3,'',0,1,0,0),(2471,219,'吉水县',3,'',0,1,0,0),(2472,219,'安福县',3,'',0,1,0,0),(2473,219,'峡江县',3,'',0,1,0,0),(2474,219,'新干县',3,'',0,1,0,0),(2475,219,'永丰县',3,'',0,1,0,0),(2476,219,'永新县',3,'',0,1,0,0),(2477,219,'泰和县',3,'',0,1,0,0),(2478,219,'遂川县',3,'',0,1,0,0),(2479,219,'青原区',3,'',0,1,0,0),(2480,220,'万载县',3,'',0,1,0,0),(2481,220,'上高县',3,'',0,1,0,0),(2482,220,'丰城市',3,'',0,1,0,0),(2483,220,'奉新县',3,'',0,1,0,0),(2484,220,'宜丰县',3,'',0,1,0,0),(2485,220,'樟树市',3,'',0,1,0,0),(2486,220,'袁州区',3,'',0,1,0,0),(2487,220,'铜鼓县',3,'',0,1,0,0),(2488,220,'靖安县',3,'',0,1,0,0),(2489,220,'高安市',3,'',0,1,0,0),(2490,221,'东乡县',3,'',0,1,0,0),(2491,221,'临川区',3,'',0,1,0,0),(2492,221,'乐安县',3,'',0,1,0,0),(2493,221,'南丰县',3,'',0,1,0,0),(2494,221,'南城县',3,'',0,1,0,0),(2495,221,'宜黄县',3,'',0,1,0,0),(2496,221,'崇仁县',3,'',0,1,0,0),(2497,221,'广昌县',3,'',0,1,0,0),(2498,221,'资溪县',3,'',0,1,0,0),(2499,221,'金溪县',3,'',0,1,0,0),(2500,221,'黎川县',3,'',0,1,0,0),(2501,222,'万年县',3,'',0,1,0,0),(2502,222,'上饶县',3,'',0,1,0,0),(2503,222,'余干县',3,'',0,1,0,0),(2504,222,'信州区',3,'',0,1,0,0),(2505,222,'婺源县',3,'',0,1,0,0),(2506,222,'广丰县',3,'',0,1,0,0),(2507,222,'弋阳县',3,'',0,1,0,0),(2508,222,'德兴市',3,'',0,1,0,0),(2509,222,'横峰县',3,'',0,1,0,0),(2510,222,'玉山县',3,'',0,1,0,0),(2511,222,'鄱阳县',3,'',0,1,0,0),(2512,222,'铅山县',3,'',0,1,0,0),(2513,223,'历下区',3,'',0,1,0,0),(2514,223,'历城区',3,'',0,1,0,0),(2515,223,'商河县',3,'',0,1,0,0),(2516,223,'天桥区',3,'',0,1,0,0),(2517,223,'市中区',3,'',0,1,0,0),(2518,223,'平阴县',3,'',0,1,0,0),(2519,223,'槐荫区',3,'',0,1,0,0),(2520,223,'济阳县',3,'',0,1,0,0),(2521,223,'章丘市',3,'',0,1,0,0),(2522,223,'长清区',3,'',0,1,0,0),(2523,224,'即墨市',3,'',0,1,0,0),(2524,224,'四方区',3,'',0,1,0,0),(2525,224,'城阳区',3,'',0,1,0,0),(2526,224,'崂山区',3,'',0,1,0,0),(2527,224,'市北区',3,'',0,1,0,0),(2528,224,'市南区',3,'',0,1,0,0),(2529,224,'平度市',3,'',0,1,0,0),(2530,224,'李沧区',3,'',0,1,0,0),(2531,224,'胶南市',3,'',0,1,0,0),(2532,224,'胶州市',3,'',0,1,0,0),(2533,224,'莱西市',3,'',0,1,0,0),(2534,224,'黄岛区',3,'',0,1,0,0),(2535,225,'临淄区',3,'',0,1,0,0),(2536,225,'博山区',3,'',0,1,0,0),(2537,225,'周村区',3,'',0,1,0,0),(2538,225,'张店区',3,'',0,1,0,0),(2539,225,'桓台县',3,'',0,1,0,0),(2540,225,'沂源县',3,'',0,1,0,0),(2541,225,'淄川区',3,'',0,1,0,0),(2542,225,'高青县',3,'',0,1,0,0),(2543,226,'台儿庄区',3,'',0,1,0,0),(2544,226,'山亭区',3,'',0,1,0,0),(2545,226,'峄城区',3,'',0,1,0,0),(2546,226,'市中区',3,'',0,1,0,0),(2547,226,'滕州市',3,'',0,1,0,0),(2548,226,'薛城区',3,'',0,1,0,0),(2549,227,'东营区',3,'',0,1,0,0),(2550,227,'利津县',3,'',0,1,0,0),(2551,227,'垦利县',3,'',0,1,0,0),(2552,227,'广饶县',3,'',0,1,0,0),(2553,227,'河口区',3,'',0,1,0,0),(2554,228,'招远市',3,'',0,1,0,0),(2555,228,'栖霞市',3,'',0,1,0,0),(2556,228,'海阳市',3,'',0,1,0,0),(2557,228,'牟平区',3,'',0,1,0,0),(2558,228,'福山区',3,'',0,1,0,0),(2559,228,'芝罘区',3,'',0,1,0,0),(2560,228,'莱山区',3,'',0,1,0,0),(2561,228,'莱州市',3,'',0,1,0,0),(2562,228,'莱阳市',3,'',0,1,0,0),(2563,228,'蓬莱市',3,'',0,1,0,0),(2564,228,'长岛县',3,'',0,1,0,0),(2565,228,'龙口市',3,'',0,1,0,0),(2566,229,'临朐县',3,'',0,1,0,0),(2567,229,'坊子区',3,'',0,1,0,0),(2568,229,'奎文区',3,'',0,1,0,0),(2569,229,'安丘市',3,'',0,1,0,0),(2570,229,'寒亭区',3,'',0,1,0,0),(2571,229,'寿光市',3,'',0,1,0,0),(2572,229,'昌乐县',3,'',0,1,0,0),(2573,229,'昌邑市',3,'',0,1,0,0),(2574,229,'潍城区',3,'',0,1,0,0),(2575,229,'诸城市',3,'',0,1,0,0),(2576,229,'青州市',3,'',0,1,0,0),(2577,229,'高密市',3,'',0,1,0,0),(2578,230,'任城区',3,'',0,1,0,0),(2579,230,'兖州市',3,'',0,1,0,0),(2580,230,'嘉祥县',3,'',0,1,0,0),(2581,230,'市中区',3,'',0,1,0,0),(2582,230,'微山县',3,'',0,1,0,0),(2583,230,'曲阜市',3,'',0,1,0,0),(2584,230,'梁山县',3,'',0,1,0,0),(2585,230,'汶上县',3,'',0,1,0,0),(2586,230,'泗水县',3,'',0,1,0,0),(2587,230,'邹城市',3,'',0,1,0,0),(2588,230,'金乡县',3,'',0,1,0,0),(2589,230,'鱼台县',3,'',0,1,0,0),(2590,231,'东平县',3,'',0,1,0,0),(2591,231,'宁阳县',3,'',0,1,0,0),(2592,231,'岱岳区',3,'',0,1,0,0),(2593,231,'新泰市',3,'',0,1,0,0),(2594,231,'泰山区',3,'',0,1,0,0),(2595,231,'肥城市',3,'',0,1,0,0),(2596,232,'乳山市',3,'',0,1,0,0),(2597,232,'文登市',3,'',0,1,0,0),(2598,232,'环翠区',3,'',0,1,0,0),(2599,232,'荣成市',3,'',0,1,0,0),(2600,233,'东港区',3,'',0,1,0,0),(2601,233,'五莲县',3,'',0,1,0,0),(2602,233,'岚山区',3,'',0,1,0,0),(2603,233,'莒县',3,'',0,1,0,0),(2604,234,'莱城区',3,'',0,1,0,0),(2605,234,'钢城区',3,'',0,1,0,0),(2606,235,'临沭县',3,'',0,1,0,0),(2607,235,'兰山区',3,'',0,1,0,0),(2608,235,'平邑县',3,'',0,1,0,0),(2609,235,'沂南县',3,'',0,1,0,0),(2610,235,'沂水县',3,'',0,1,0,0),(2611,235,'河东区',3,'',0,1,0,0),(2612,235,'罗庄区',3,'',0,1,0,0),(2613,235,'苍山县',3,'',0,1,0,0),(2614,235,'莒南县',3,'',0,1,0,0),(2615,235,'蒙阴县',3,'',0,1,0,0),(2616,235,'费县',3,'',0,1,0,0),(2617,235,'郯城县',3,'',0,1,0,0),(2618,236,'临邑县',3,'',0,1,0,0),(2619,236,'乐陵市',3,'',0,1,0,0),(2620,236,'夏津县',3,'',0,1,0,0),(2621,236,'宁津县',3,'',0,1,0,0),(2622,236,'平原县',3,'',0,1,0,0),(2623,236,'庆云县',3,'',0,1,0,0),(2624,236,'德城区',3,'',0,1,0,0),(2625,236,'武城县',3,'',0,1,0,0),(2626,236,'禹城市',3,'',0,1,0,0),(2627,236,'陵县',3,'',0,1,0,0),(2628,236,'齐河县',3,'',0,1,0,0),(2629,237,'东昌府区',3,'',0,1,0,0),(2630,237,'东阿县',3,'',0,1,0,0),(2631,237,'临清市',3,'',0,1,0,0),(2632,237,'冠县',3,'',0,1,0,0),(2633,237,'茌平县',3,'',0,1,0,0),(2634,237,'莘县',3,'',0,1,0,0),(2635,237,'阳谷县',3,'',0,1,0,0),(2636,237,'高唐县',3,'',0,1,0,0),(2637,238,'博兴县',3,'',0,1,0,0),(2638,238,'惠民县',3,'',0,1,0,0),(2639,238,'无棣县',3,'',0,1,0,0),(2640,238,'沾化县',3,'',0,1,0,0),(2641,238,'滨城区',3,'',0,1,0,0),(2642,238,'邹平县',3,'',0,1,0,0),(2643,238,'阳信县',3,'',0,1,0,0),(2644,239,'东明县',3,'',0,1,0,0),(2645,239,'单县',3,'',0,1,0,0),(2646,239,'定陶县',3,'',0,1,0,0),(2647,239,'巨野县',3,'',0,1,0,0),(2648,239,'成武县',3,'',0,1,0,0),(2649,239,'曹县',3,'',0,1,0,0),(2650,239,'牡丹区',3,'',0,1,0,0),(2651,239,'郓城县',3,'',0,1,0,0),(2652,239,'鄄城县',3,'',0,1,0,0),(2653,240,'上街区',3,'',0,1,0,0),(2654,240,'中原区',3,'',0,1,0,0),(2655,240,'中牟县',3,'',0,1,0,0),(2656,240,'二七区',3,'',0,1,0,0),(2657,240,'巩义市',3,'',0,1,0,0),(2658,240,'惠济区',3,'',0,1,0,0),(2659,240,'新密市',3,'',0,1,0,0),(2660,240,'新郑市',3,'',0,1,0,0),(2661,240,'登封市',3,'',0,1,0,0),(2662,240,'管城回族区',3,'',0,1,0,0),(2663,240,'荥阳市',3,'',0,1,0,0),(2664,240,'金水区',3,'',0,1,0,0),(2665,241,'兰考县',3,'',0,1,0,0),(2666,241,'尉氏县',3,'',0,1,0,0),(2667,241,'开封县',3,'',0,1,0,0),(2668,241,'杞县',3,'',0,1,0,0),(2669,241,'禹王台区',3,'',0,1,0,0),(2670,241,'通许县',3,'',0,1,0,0),(2671,241,'金明区',3,'',0,1,0,0),(2672,241,'顺河回族区',3,'',0,1,0,0),(2673,241,'鼓楼区',3,'',0,1,0,0),(2674,241,'龙亭区',3,'',0,1,0,0),(2675,242,'伊川县',3,'',0,1,0,0),(2676,242,'偃师市',3,'',0,1,0,0),(2677,242,'吉利区',3,'',0,1,0,0),(2678,242,'孟津县',3,'',0,1,0,0),(2679,242,'宜阳县',3,'',0,1,0,0),(2680,242,'嵩县',3,'',0,1,0,0),(2681,242,'新安县',3,'',0,1,0,0),(2682,242,'栾川县',3,'',0,1,0,0),(2683,242,'汝阳县',3,'',0,1,0,0),(2684,242,'洛宁县',3,'',0,1,0,0),(2685,242,'洛龙区',3,'',0,1,0,0),(2686,242,'涧西区',3,'',0,1,0,0),(2687,242,'瀍河回族区',3,'',0,1,0,0),(2688,242,'老城区',3,'',0,1,0,0),(2689,242,'西工区',3,'',0,1,0,0),(2690,243,'卫东区',3,'',0,1,0,0),(2691,243,'叶县',3,'',0,1,0,0),(2692,243,'宝丰县',3,'',0,1,0,0),(2693,243,'新华区',3,'',0,1,0,0),(2694,243,'汝州市',3,'',0,1,0,0),(2695,243,'湛河区',3,'',0,1,0,0),(2696,243,'石龙区',3,'',0,1,0,0),(2697,243,'舞钢市',3,'',0,1,0,0),(2698,243,'郏县',3,'',0,1,0,0),(2699,243,'鲁山县',3,'',0,1,0,0),(2700,244,'内黄县',3,'',0,1,0,0),(2701,244,'北关区',3,'',0,1,0,0),(2702,244,'安阳县',3,'',0,1,0,0),(2703,244,'文峰区',3,'',0,1,0,0),(2704,244,'林州市',3,'',0,1,0,0),(2705,244,'殷都区',3,'',0,1,0,0),(2706,244,'汤阴县',3,'',0,1,0,0),(2707,244,'滑县',3,'',0,1,0,0),(2708,244,'龙安区',3,'',0,1,0,0),(2709,245,'山城区',3,'',0,1,0,0),(2710,245,'浚县',3,'',0,1,0,0),(2711,245,'淇县',3,'',0,1,0,0),(2712,245,'淇滨区',3,'',0,1,0,0),(2713,245,'鹤山区',3,'',0,1,0,0),(2714,246,'凤泉区',3,'',0,1,0,0),(2715,246,'卫滨区',3,'',0,1,0,0),(2716,246,'卫辉市',3,'',0,1,0,0),(2717,246,'原阳县',3,'',0,1,0,0),(2718,246,'封丘县',3,'',0,1,0,0),(2719,246,'延津县',3,'',0,1,0,0),(2720,246,'新乡县',3,'',0,1,0,0),(2721,246,'牧野区',3,'',0,1,0,0),(2722,246,'红旗区',3,'',0,1,0,0),(2723,246,'获嘉县',3,'',0,1,0,0),(2724,246,'辉县市',3,'',0,1,0,0),(2725,246,'长垣县',3,'',0,1,0,0),(2726,247,'中站区',3,'',0,1,0,0),(2727,247,'修武县',3,'',0,1,0,0),(2728,247,'博爱县',3,'',0,1,0,0),(2729,247,'孟州市',3,'',0,1,0,0),(2730,247,'山阳区',3,'',0,1,0,0),(2731,247,'武陟县',3,'',0,1,0,0),(2732,247,'沁阳市',3,'',0,1,0,0),(2733,247,'温县',3,'',0,1,0,0),(2734,247,'解放区',3,'',0,1,0,0),(2735,247,'马村区',3,'',0,1,0,0),(2736,248,'华龙区',3,'',0,1,0,0),(2737,248,'南乐县',3,'',0,1,0,0),(2738,248,'台前县',3,'',0,1,0,0),(2739,248,'清丰县',3,'',0,1,0,0),(2740,248,'濮阳县',3,'',0,1,0,0),(2741,248,'范县',3,'',0,1,0,0),(2742,249,'禹州市',3,'',0,1,0,0),(2743,249,'襄城县',3,'',0,1,0,0),(2744,249,'许昌县',3,'',0,1,0,0),(2745,249,'鄢陵县',3,'',0,1,0,0),(2746,249,'长葛市',3,'',0,1,0,0),(2747,249,'魏都区',3,'',0,1,0,0),(2748,250,'临颍县',3,'',0,1,0,0),(2749,250,'召陵区',3,'',0,1,0,0),(2750,250,'源汇区',3,'',0,1,0,0),(2751,250,'舞阳县',3,'',0,1,0,0),(2752,250,'郾城区',3,'',0,1,0,0),(2753,251,'义马市',3,'',0,1,0,0),(2754,251,'卢氏县',3,'',0,1,0,0),(2755,251,'渑池县',3,'',0,1,0,0),(2756,251,'湖滨区',3,'',0,1,0,0),(2757,251,'灵宝市',3,'',0,1,0,0),(2758,251,'陕县',3,'',0,1,0,0),(2759,252,'内乡县',3,'',0,1,0,0),(2760,252,'南召县',3,'',0,1,0,0),(2761,252,'卧龙区',3,'',0,1,0,0),(2762,252,'唐河县',3,'',0,1,0,0),(2763,252,'宛城区',3,'',0,1,0,0),(2764,252,'新野县',3,'',0,1,0,0),(2765,252,'方城县',3,'',0,1,0,0),(2766,252,'桐柏县',3,'',0,1,0,0),(2767,252,'淅川县',3,'',0,1,0,0),(2768,252,'社旗县',3,'',0,1,0,0),(2769,252,'西峡县',3,'',0,1,0,0),(2770,252,'邓州市',3,'',0,1,0,0),(2771,252,'镇平县',3,'',0,1,0,0),(2772,253,'夏邑县',3,'',0,1,0,0),(2773,253,'宁陵县',3,'',0,1,0,0),(2774,253,'柘城县',3,'',0,1,0,0),(2775,253,'民权县',3,'',0,1,0,0),(2776,253,'永城市',3,'',0,1,0,0),(2777,253,'睢县',3,'',0,1,0,0),(2778,253,'睢阳区',3,'',0,1,0,0),(2779,253,'粱园区',3,'',0,1,0,0),(2780,253,'虞城县',3,'',0,1,0,0),(2781,254,'光山县',3,'',0,1,0,0),(2782,254,'商城县',3,'',0,1,0,0),(2783,254,'固始县',3,'',0,1,0,0),(2784,254,'平桥区',3,'',0,1,0,0),(2785,254,'息县',3,'',0,1,0,0),(2786,254,'新县',3,'',0,1,0,0),(2787,254,'浉河区',3,'',0,1,0,0),(2788,254,'淮滨县',3,'',0,1,0,0),(2789,254,'潢川县',3,'',0,1,0,0),(2790,254,'罗山县',3,'',0,1,0,0),(2791,255,'商水县',3,'',0,1,0,0),(2792,255,'太康县',3,'',0,1,0,0),(2793,255,'川汇区',3,'',0,1,0,0),(2794,255,'扶沟县',3,'',0,1,0,0),(2795,255,'沈丘县',3,'',0,1,0,0),(2796,255,'淮阳县',3,'',0,1,0,0),(2797,255,'西华县',3,'',0,1,0,0),(2798,255,'郸城县',3,'',0,1,0,0),(2799,255,'项城市',3,'',0,1,0,0),(2800,255,'鹿邑县',3,'',0,1,0,0),(2801,256,'上蔡县',3,'',0,1,0,0),(2802,256,'平舆县',3,'',0,1,0,0),(2803,256,'新蔡县',3,'',0,1,0,0),(2804,256,'正阳县',3,'',0,1,0,0),(2805,256,'汝南县',3,'',0,1,0,0),(2806,256,'泌阳县',3,'',0,1,0,0),(2807,256,'确山县',3,'',0,1,0,0),(2808,256,'西平县',3,'',0,1,0,0),(2809,256,'遂平县',3,'',0,1,0,0),(2810,256,'驿城区',3,'',0,1,0,0),(2811,257,'济源市',3,'',0,1,0,0),(2812,258,'东西湖区',3,'',0,1,0,0),(2813,258,'新洲区',3,'',0,1,0,0),(2814,258,'武昌区',3,'',0,1,0,0),(2815,258,'汉南区',3,'',0,1,0,0),(2816,258,'汉阳区',3,'',0,1,0,0),(2817,258,'江夏区',3,'',0,1,0,0),(2818,258,'江岸区',3,'',0,1,0,0),(2819,258,'江汉区',3,'',0,1,0,0),(2820,258,'洪山区',3,'',0,1,0,0),(2821,258,'硚口区',3,'',0,1,0,0),(2822,258,'蔡甸区',3,'',0,1,0,0),(2823,258,'青山区',3,'',0,1,0,0),(2824,258,'黄陂区',3,'',0,1,0,0),(2825,259,'下陆区',3,'',0,1,0,0),(2826,259,'大冶市',3,'',0,1,0,0),(2827,259,'西塞山区',3,'',0,1,0,0),(2828,259,'铁山区',3,'',0,1,0,0),(2829,259,'阳新县',3,'',0,1,0,0),(2830,259,'黄石港区',3,'',0,1,0,0),(2831,260,'丹江口市',3,'',0,1,0,0),(2832,260,'张湾区',3,'',0,1,0,0),(2833,260,'房县',3,'',0,1,0,0),(2834,260,'竹山县',3,'',0,1,0,0),(2835,260,'竹溪县',3,'',0,1,0,0),(2836,260,'茅箭区',3,'',0,1,0,0),(2837,260,'郧县',3,'',0,1,0,0),(2838,260,'郧西县',3,'',0,1,0,0),(2839,261,'五峰土家族自治县',3,'',0,1,0,0),(2840,261,'伍家岗区',3,'',0,1,0,0),(2841,261,'兴山县',3,'',0,1,0,0),(2842,261,'夷陵区',3,'',0,1,0,0),(2843,261,'宜都市',3,'',0,1,0,0),(2844,261,'当阳市',3,'',0,1,0,0),(2845,261,'枝江市',3,'',0,1,0,0),(2846,261,'点军区',3,'',0,1,0,0),(2847,261,'秭归县',3,'',0,1,0,0),(2848,261,'虢亭区',3,'',0,1,0,0),(2849,261,'西陵区',3,'',0,1,0,0),(2850,261,'远安县',3,'',0,1,0,0),(2851,261,'长阳土家族自治县',3,'',0,1,0,0),(2852,262,'保康县',3,'',0,1,0,0),(2853,262,'南漳县',3,'',0,1,0,0),(2854,262,'宜城市',3,'',0,1,0,0),(2855,262,'枣阳市',3,'',0,1,0,0),(2856,262,'樊城区',3,'',0,1,0,0),(2857,262,'老河口市',3,'',0,1,0,0),(2858,262,'襄城区',3,'',0,1,0,0),(2859,262,'襄阳区',3,'',0,1,0,0),(2860,262,'谷城县',3,'',0,1,0,0),(2861,263,'华容区',3,'',0,1,0,0),(2862,263,'粱子湖',3,'',0,1,0,0),(2863,263,'鄂城区',3,'',0,1,0,0),(2864,264,'东宝区',3,'',0,1,0,0),(2865,264,'京山县',3,'',0,1,0,0),(2866,264,'掇刀区',3,'',0,1,0,0),(2867,264,'沙洋县',3,'',0,1,0,0),(2868,264,'钟祥市',3,'',0,1,0,0),(2869,265,'云梦县',3,'',0,1,0,0),(2870,265,'大悟县',3,'',0,1,0,0),(2871,265,'孝南区',3,'',0,1,0,0),(2872,265,'孝昌县',3,'',0,1,0,0),(2873,265,'安陆市',3,'',0,1,0,0),(2874,265,'应城市',3,'',0,1,0,0),(2875,265,'汉川市',3,'',0,1,0,0),(2876,266,'公安县',3,'',0,1,0,0),(2877,266,'松滋市',3,'',0,1,0,0),(2878,266,'江陵县',3,'',0,1,0,0),(2879,266,'沙市区',3,'',0,1,0,0),(2880,266,'洪湖市',3,'',0,1,0,0),(2881,266,'监利县',3,'',0,1,0,0),(2882,266,'石首市',3,'',0,1,0,0),(2883,266,'荆州区',3,'',0,1,0,0),(2884,267,'团风县',3,'',0,1,0,0),(2885,267,'武穴市',3,'',0,1,0,0),(2886,267,'浠水县',3,'',0,1,0,0),(2887,267,'红安县',3,'',0,1,0,0),(2888,267,'罗田县',3,'',0,1,0,0),(2889,267,'英山县',3,'',0,1,0,0),(2890,267,'蕲春县',3,'',0,1,0,0),(2891,267,'麻城市',3,'',0,1,0,0),(2892,267,'黄州区',3,'',0,1,0,0),(2893,267,'黄梅县',3,'',0,1,0,0),(2894,268,'咸安区',3,'',0,1,0,0),(2895,268,'嘉鱼县',3,'',0,1,0,0),(2896,268,'崇阳县',3,'',0,1,0,0),(2897,268,'赤壁市',3,'',0,1,0,0),(2898,268,'通城县',3,'',0,1,0,0),(2899,268,'通山县',3,'',0,1,0,0),(2900,269,'广水市',3,'',0,1,0,0),(2901,269,'曾都区',3,'',0,1,0,0),(2902,270,'利川市',3,'',0,1,0,0),(2903,270,'咸丰县',3,'',0,1,0,0),(2904,270,'宣恩县',3,'',0,1,0,0),(2905,270,'巴东县',3,'',0,1,0,0),(2906,270,'建始县',3,'',0,1,0,0),(2907,270,'恩施市',3,'',0,1,0,0),(2908,270,'来凤县',3,'',0,1,0,0),(2909,270,'鹤峰县',3,'',0,1,0,0),(2910,271,'仙桃市',3,'',0,1,0,0),(2911,272,'潜江市',3,'',0,1,0,0),(2912,273,'天门市',3,'',0,1,0,0),(2913,274,'神农架林区',3,'',0,1,0,0),(2914,275,'天心区',3,'',0,1,0,0),(2915,275,'宁乡县',3,'',0,1,0,0),(2916,275,'岳麓区',3,'',0,1,0,0),(2917,275,'开福区',3,'',0,1,0,0),(2918,275,'望城县',3,'',0,1,0,0),(2919,275,'浏阳市',3,'',0,1,0,0),(2920,275,'芙蓉区',3,'',0,1,0,0),(2921,275,'长沙县',3,'',0,1,0,0),(2922,275,'雨花区',3,'',0,1,0,0),(2923,276,'天元区',3,'',0,1,0,0),(2924,276,'攸县',3,'',0,1,0,0),(2925,276,'株洲县',3,'',0,1,0,0),(2926,276,'炎陵县',3,'',0,1,0,0),(2927,276,'石峰区',3,'',0,1,0,0),(2928,276,'芦淞区',3,'',0,1,0,0),(2929,276,'茶陵县',3,'',0,1,0,0),(2930,276,'荷塘区',3,'',0,1,0,0),(2931,276,'醴陵市',3,'',0,1,0,0),(2932,277,'岳塘区',3,'',0,1,0,0),(2933,277,'湘乡市',3,'',0,1,0,0),(2934,277,'湘潭县',3,'',0,1,0,0),(2935,277,'雨湖区',3,'',0,1,0,0),(2936,277,'韶山市',3,'',0,1,0,0),(2937,278,'南岳区',3,'',0,1,0,0),(2938,278,'常宁市',3,'',0,1,0,0),(2939,278,'珠晖区',3,'',0,1,0,0),(2940,278,'石鼓区',3,'',0,1,0,0),(2941,278,'祁东县',3,'',0,1,0,0),(2942,278,'耒阳市',3,'',0,1,0,0),(2943,278,'蒸湘区',3,'',0,1,0,0),(2944,278,'衡东县',3,'',0,1,0,0),(2945,278,'衡南县',3,'',0,1,0,0),(2946,278,'衡山县',3,'',0,1,0,0),(2947,278,'衡阳县',3,'',0,1,0,0),(2948,278,'雁峰区',3,'',0,1,0,0),(2949,279,'北塔区',3,'',0,1,0,0),(2950,279,'双清区',3,'',0,1,0,0),(2951,279,'城步苗族自治县',3,'',0,1,0,0),(2952,279,'大祥区',3,'',0,1,0,0),(2953,279,'新宁县',3,'',0,1,0,0),(2954,279,'新邵县',3,'',0,1,0,0),(2955,279,'武冈市',3,'',0,1,0,0),(2956,279,'洞口县',3,'',0,1,0,0),(2957,279,'绥宁县',3,'',0,1,0,0),(2958,279,'邵东县',3,'',0,1,0,0),(2959,279,'邵阳县',3,'',0,1,0,0),(2960,279,'隆回县',3,'',0,1,0,0),(2961,280,'临湘市',3,'',0,1,0,0),(2962,280,'云溪区',3,'',0,1,0,0),(2963,280,'华容县',3,'',0,1,0,0),(2964,280,'君山区',3,'',0,1,0,0),(2965,280,'岳阳县',3,'',0,1,0,0),(2966,280,'岳阳楼区',3,'',0,1,0,0),(2967,280,'平江县',3,'',0,1,0,0),(2968,280,'汨罗市',3,'',0,1,0,0),(2969,280,'湘阴县',3,'',0,1,0,0),(2970,281,'临澧县',3,'',0,1,0,0),(2971,281,'安乡县',3,'',0,1,0,0),(2972,281,'桃源县',3,'',0,1,0,0),(2973,281,'武陵区',3,'',0,1,0,0),(2974,281,'汉寿县',3,'',0,1,0,0),(2975,281,'津市市',3,'',0,1,0,0),(2976,281,'澧县',3,'',0,1,0,0),(2977,281,'石门县',3,'',0,1,0,0),(2978,281,'鼎城区',3,'',0,1,0,0),(2979,282,'慈利县',3,'',0,1,0,0),(2980,282,'桑植县',3,'',0,1,0,0),(2981,282,'武陵源区',3,'',0,1,0,0),(2982,282,'永定区',3,'',0,1,0,0),(2983,283,'南县',3,'',0,1,0,0),(2984,283,'安化县',3,'',0,1,0,0),(2985,283,'桃江县',3,'',0,1,0,0),(2986,283,'沅江市',3,'',0,1,0,0),(2987,283,'资阳区',3,'',0,1,0,0),(2988,283,'赫山区',3,'',0,1,0,0),(2989,284,'临武县',3,'',0,1,0,0),(2990,284,'北湖区',3,'',0,1,0,0),(2991,284,'嘉禾县',3,'',0,1,0,0),(2992,284,'安仁县',3,'',0,1,0,0),(2993,284,'宜章县',3,'',0,1,0,0),(2994,284,'桂东县',3,'',0,1,0,0),(2995,284,'桂阳县',3,'',0,1,0,0),(2996,284,'永兴县',3,'',0,1,0,0),(2997,284,'汝城县',3,'',0,1,0,0),(2998,284,'苏仙区',3,'',0,1,0,0),(2999,284,'资兴市',3,'',0,1,0,0),(3000,285,'东安县',3,'',0,1,0,0),(3001,285,'冷水滩区',3,'',0,1,0,0),(3002,285,'双牌县',3,'',0,1,0,0),(3003,285,'宁远县',3,'',0,1,0,0),(3004,285,'新田县',3,'',0,1,0,0),(3005,285,'江华瑶族自治县',3,'',0,1,0,0),(3006,285,'江永县',3,'',0,1,0,0),(3007,285,'祁阳县',3,'',0,1,0,0),(3008,285,'蓝山县',3,'',0,1,0,0),(3009,285,'道县',3,'',0,1,0,0),(3010,285,'零陵区',3,'',0,1,0,0),(3011,286,'中方县',3,'',0,1,0,0),(3012,286,'会同县',3,'',0,1,0,0),(3013,286,'新晃侗族自治县',3,'',0,1,0,0),(3014,286,'沅陵县',3,'',0,1,0,0),(3015,286,'洪江市/洪江区',3,'',0,1,0,0),(3016,286,'溆浦县',3,'',0,1,0,0),(3017,286,'芷江侗族自治县',3,'',0,1,0,0),(3018,286,'辰溪县',3,'',0,1,0,0),(3019,286,'通道侗族自治县',3,'',0,1,0,0),(3020,286,'靖州苗族侗族自治县',3,'',0,1,0,0),(3021,286,'鹤城区',3,'',0,1,0,0),(3022,286,'麻阳苗族自治县',3,'',0,1,0,0),(3023,287,'冷水江市',3,'',0,1,0,0),(3024,287,'双峰县',3,'',0,1,0,0),(3025,287,'娄星区',3,'',0,1,0,0),(3026,287,'新化县',3,'',0,1,0,0),(3027,287,'涟源市',3,'',0,1,0,0),(3028,288,'保靖县',3,'',0,1,0,0),(3029,288,'凤凰县',3,'',0,1,0,0),(3030,288,'古丈县',3,'',0,1,0,0),(3031,288,'吉首市',3,'',0,1,0,0),(3032,288,'永顺县',3,'',0,1,0,0),(3033,288,'泸溪县',3,'',0,1,0,0),(3034,288,'花垣县',3,'',0,1,0,0),(3035,288,'龙山县',3,'',0,1,0,0),(3036,289,'萝岗区',3,'',0,1,0,0),(3037,289,'南沙区',3,'',0,1,0,0),(3038,289,'从化市',3,'',0,1,0,0),(3039,289,'增城市',3,'',0,1,0,0),(3040,289,'天河区',3,'',0,1,0,0),(3041,289,'海珠区',3,'',0,1,0,0),(3042,289,'番禺区',3,'',0,1,0,0),(3043,289,'白云区',3,'',0,1,0,0),(3044,289,'花都区',3,'',0,1,0,0),(3045,289,'荔湾区',3,'',0,1,0,0),(3046,289,'越秀区',3,'',0,1,0,0),(3047,289,'黄埔区',3,'',0,1,0,0),(3048,290,'乐昌市',3,'',0,1,0,0),(3049,290,'乳源瑶族自治县',3,'',0,1,0,0),(3050,290,'仁化县',3,'',0,1,0,0),(3051,290,'南雄市',3,'',0,1,0,0),(3052,290,'始兴县',3,'',0,1,0,0),(3053,290,'新丰县',3,'',0,1,0,0),(3054,290,'曲江区',3,'',0,1,0,0),(3055,290,'武江区',3,'',0,1,0,0),(3056,290,'浈江区',3,'',0,1,0,0),(3057,290,'翁源县',3,'',0,1,0,0),(3058,291,'南山区',3,'',0,1,0,0),(3059,291,'宝安区',3,'',0,1,0,0),(3060,291,'盐田区',3,'',0,1,0,0),(3061,291,'福田区',3,'',0,1,0,0),(3062,291,'罗湖区',3,'',0,1,0,0),(3063,291,'龙岗区',3,'',0,1,0,0),(3064,292,'斗门区',3,'',0,1,0,0),(3065,292,'金湾区',3,'',0,1,0,0),(3066,292,'香洲区',3,'',0,1,0,0),(3067,293,'南澳县',3,'',0,1,0,0),(3068,293,'潮南区',3,'',0,1,0,0),(3069,293,'潮阳区',3,'',0,1,0,0),(3070,293,'澄海区',3,'',0,1,0,0),(3071,293,'濠江区',3,'',0,1,0,0),(3072,293,'金平区',3,'',0,1,0,0),(3073,293,'龙湖区',3,'',0,1,0,0),(3074,294,'三水区',3,'',0,1,0,0),(3075,294,'南海区',3,'',0,1,0,0),(3076,294,'禅城区',3,'',0,1,0,0),(3077,294,'顺德区',3,'',0,1,0,0),(3078,294,'高明区',3,'',0,1,0,0),(3079,295,'台山市',3,'',0,1,0,0),(3080,295,'开平市',3,'',0,1,0,0),(3081,295,'恩平市',3,'',0,1,0,0),(3082,295,'新会区',3,'',0,1,0,0),(3083,295,'江海区',3,'',0,1,0,0),(3084,295,'蓬江区',3,'',0,1,0,0),(3085,295,'鹤山市',3,'',0,1,0,0),(3086,296,'吴川市',3,'',0,1,0,0),(3087,296,'坡头区',3,'',0,1,0,0),(3088,296,'廉江市',3,'',0,1,0,0),(3089,296,'徐闻县',3,'',0,1,0,0),(3090,296,'赤坎区',3,'',0,1,0,0),(3091,296,'遂溪县',3,'',0,1,0,0),(3092,296,'雷州市',3,'',0,1,0,0),(3093,296,'霞山区',3,'',0,1,0,0),(3094,296,'麻章区',3,'',0,1,0,0),(3095,297,'信宜市',3,'',0,1,0,0),(3096,297,'化州市',3,'',0,1,0,0),(3097,297,'电白县',3,'',0,1,0,0),(3098,297,'茂南区',3,'',0,1,0,0),(3099,297,'茂港区',3,'',0,1,0,0),(3100,297,'高州市',3,'',0,1,0,0),(3101,298,'四会市',3,'',0,1,0,0),(3102,298,'封开县',3,'',0,1,0,0),(3103,298,'广宁县',3,'',0,1,0,0),(3104,298,'德庆县',3,'',0,1,0,0),(3105,298,'怀集县',3,'',0,1,0,0),(3106,298,'端州区',3,'',0,1,0,0),(3107,298,'高要市',3,'',0,1,0,0),(3108,298,'鼎湖区',3,'',0,1,0,0),(3109,299,'博罗县',3,'',0,1,0,0),(3110,299,'惠东县',3,'',0,1,0,0),(3111,299,'惠城区',3,'',0,1,0,0),(3112,299,'惠阳区',3,'',0,1,0,0),(3113,299,'龙门县',3,'',0,1,0,0),(3114,300,'丰顺县',3,'',0,1,0,0),(3115,300,'五华县',3,'',0,1,0,0),(3116,300,'兴宁市',3,'',0,1,0,0),(3117,300,'大埔县',3,'',0,1,0,0),(3118,300,'平远县',3,'',0,1,0,0),(3119,300,'梅县',3,'',0,1,0,0),(3120,300,'梅江区',3,'',0,1,0,0),(3121,300,'蕉岭县',3,'',0,1,0,0),(3122,301,'城区',3,'',0,1,0,0),(3123,301,'海丰县',3,'',0,1,0,0),(3124,301,'陆丰市',3,'',0,1,0,0),(3125,301,'陆河县',3,'',0,1,0,0),(3126,302,'东源县',3,'',0,1,0,0),(3127,302,'和平县',3,'',0,1,0,0),(3128,302,'源城区',3,'',0,1,0,0),(3129,302,'紫金县',3,'',0,1,0,0),(3130,302,'连平县',3,'',0,1,0,0),(3131,302,'龙川县',3,'',0,1,0,0),(3132,303,'江城区',3,'',0,1,0,0),(3133,303,'阳东县',3,'',0,1,0,0),(3134,303,'阳春市',3,'',0,1,0,0),(3135,303,'阳西县',3,'',0,1,0,0),(3136,304,'佛冈县',3,'',0,1,0,0),(3137,304,'清城区',3,'',0,1,0,0),(3138,304,'清新县',3,'',0,1,0,0),(3139,304,'英德市',3,'',0,1,0,0),(3140,304,'连南瑶族自治县',3,'',0,1,0,0),(3141,304,'连山壮族瑶族自治县',3,'',0,1,0,0),(3142,304,'连州市',3,'',0,1,0,0),(3143,304,'阳山县',3,'',0,1,0,0),(3144,305,'东莞市',3,'',0,1,0,0),(3145,306,'中山市',3,'',0,1,0,0),(3146,307,'湘桥区',3,'',0,1,0,0),(3147,307,'潮安县',3,'',0,1,0,0),(3148,307,'饶平县',3,'',0,1,0,0),(3149,308,'惠来县',3,'',0,1,0,0),(3150,308,'揭东县',3,'',0,1,0,0),(3151,308,'揭西县',3,'',0,1,0,0),(3152,308,'普宁市',3,'',0,1,0,0),(3153,308,'榕城区',3,'',0,1,0,0),(3154,309,'云城区',3,'',0,1,0,0),(3155,309,'云安县',3,'',0,1,0,0),(3156,309,'新兴县',3,'',0,1,0,0),(3157,309,'罗定市',3,'',0,1,0,0),(3158,309,'郁南县',3,'',0,1,0,0),(3159,310,'上林县',3,'',0,1,0,0),(3160,310,'兴宁区',3,'',0,1,0,0),(3161,310,'宾阳县',3,'',0,1,0,0),(3162,310,'横县',3,'',0,1,0,0),(3163,310,'武鸣县',3,'',0,1,0,0),(3164,310,'江南区',3,'',0,1,0,0),(3165,310,'良庆区',3,'',0,1,0,0),(3166,310,'西乡塘区',3,'',0,1,0,0),(3167,310,'邕宁区',3,'',0,1,0,0),(3168,310,'隆安县',3,'',0,1,0,0),(3169,310,'青秀区',3,'',0,1,0,0),(3170,310,'马山县',3,'',0,1,0,0),(3171,311,'三江侗族自治县',3,'',0,1,0,0),(3172,311,'城中区',3,'',0,1,0,0),(3173,311,'柳北区',3,'',0,1,0,0),(3174,311,'柳南区',3,'',0,1,0,0),(3175,311,'柳城县',3,'',0,1,0,0),(3176,311,'柳江县',3,'',0,1,0,0),(3177,311,'融安县',3,'',0,1,0,0),(3178,311,'融水苗族自治县',3,'',0,1,0,0),(3179,311,'鱼峰区',3,'',0,1,0,0),(3180,311,'鹿寨县',3,'',0,1,0,0),(3181,312,'七星区',3,'',0,1,0,0),(3182,312,'临桂县',3,'',0,1,0,0),(3183,312,'全州县',3,'',0,1,0,0),(3184,312,'兴安县',3,'',0,1,0,0),(3185,312,'叠彩区',3,'',0,1,0,0),(3186,312,'平乐县',3,'',0,1,0,0),(3187,312,'恭城瑶族自治县',3,'',0,1,0,0),(3188,312,'永福县',3,'',0,1,0,0),(3189,312,'灌阳县',3,'',0,1,0,0),(3190,312,'灵川县',3,'',0,1,0,0),(3191,312,'秀峰区',3,'',0,1,0,0),(3192,312,'荔浦县',3,'',0,1,0,0),(3193,312,'象山区',3,'',0,1,0,0),(3194,312,'资源县',3,'',0,1,0,0),(3195,312,'阳朔县',3,'',0,1,0,0),(3196,312,'雁山区',3,'',0,1,0,0),(3197,312,'龙胜各族自治县',3,'',0,1,0,0),(3198,313,'万秀区',3,'',0,1,0,0),(3199,313,'岑溪市',3,'',0,1,0,0),(3200,313,'苍梧县',3,'',0,1,0,0),(3201,313,'蒙山县',3,'',0,1,0,0),(3202,313,'藤县',3,'',0,1,0,0),(3203,313,'蝶山区',3,'',0,1,0,0),(3204,313,'长洲区',3,'',0,1,0,0),(3205,314,'合浦县',3,'',0,1,0,0),(3206,314,'海城区',3,'',0,1,0,0),(3207,314,'铁山港区',3,'',0,1,0,0),(3208,314,'银海区',3,'',0,1,0,0),(3209,315,'上思县',3,'',0,1,0,0),(3210,315,'东兴市',3,'',0,1,0,0),(3211,315,'港口区',3,'',0,1,0,0),(3212,315,'防城区',3,'',0,1,0,0),(3213,316,'浦北县',3,'',0,1,0,0),(3214,316,'灵山县',3,'',0,1,0,0),(3215,316,'钦北区',3,'',0,1,0,0),(3216,316,'钦南区',3,'',0,1,0,0),(3217,317,'平南县',3,'',0,1,0,0),(3218,317,'桂平市',3,'',0,1,0,0),(3219,317,'港北区',3,'',0,1,0,0),(3220,317,'港南区',3,'',0,1,0,0),(3221,317,'覃塘区',3,'',0,1,0,0),(3222,318,'兴业县',3,'',0,1,0,0),(3223,318,'北流市',3,'',0,1,0,0),(3224,318,'博白县',3,'',0,1,0,0),(3225,318,'容县',3,'',0,1,0,0),(3226,318,'玉州区',3,'',0,1,0,0),(3227,318,'陆川县',3,'',0,1,0,0),(3228,319,'乐业县',3,'',0,1,0,0),(3229,319,'凌云县',3,'',0,1,0,0),(3230,319,'右江区',3,'',0,1,0,0),(3231,319,'平果县',3,'',0,1,0,0),(3232,319,'德保县',3,'',0,1,0,0),(3233,319,'田东县',3,'',0,1,0,0),(3234,319,'田林县',3,'',0,1,0,0),(3235,319,'田阳县',3,'',0,1,0,0),(3236,319,'西林县',3,'',0,1,0,0),(3237,319,'那坡县',3,'',0,1,0,0),(3238,319,'隆林各族自治县',3,'',0,1,0,0),(3239,319,'靖西县',3,'',0,1,0,0),(3240,320,'八步区',3,'',0,1,0,0),(3241,320,'富川瑶族自治县',3,'',0,1,0,0),(3242,320,'昭平县',3,'',0,1,0,0),(3243,320,'钟山县',3,'',0,1,0,0),(3244,321,'东兰县',3,'',0,1,0,0),(3245,321,'凤山县',3,'',0,1,0,0),(3246,321,'南丹县',3,'',0,1,0,0),(3247,321,'大化瑶族自治县',3,'',0,1,0,0),(3248,321,'天峨县',3,'',0,1,0,0),(3249,321,'宜州市',3,'',0,1,0,0),(3250,321,'巴马瑶族自治县',3,'',0,1,0,0),(3251,321,'环江毛南族自治县',3,'',0,1,0,0),(3252,321,'罗城仫佬族自治县',3,'',0,1,0,0),(3253,321,'都安瑶族自治县',3,'',0,1,0,0),(3254,321,'金城江区',3,'',0,1,0,0),(3255,322,'兴宾区',3,'',0,1,0,0),(3256,322,'合山市',3,'',0,1,0,0),(3257,322,'忻城县',3,'',0,1,0,0),(3258,322,'武宣县',3,'',0,1,0,0),(3259,322,'象州县',3,'',0,1,0,0),(3260,322,'金秀瑶族自治县',3,'',0,1,0,0),(3261,323,'凭祥市',3,'',0,1,0,0),(3262,323,'大新县',3,'',0,1,0,0),(3263,323,'天等县',3,'',0,1,0,0),(3264,323,'宁明县',3,'',0,1,0,0),(3265,323,'扶绥县',3,'',0,1,0,0),(3266,323,'江州区',3,'',0,1,0,0),(3267,323,'龙州县',3,'',0,1,0,0),(3268,324,'琼山区',3,'',0,1,0,0),(3269,324,'秀英区',3,'',0,1,0,0),(3270,324,'美兰区',3,'',0,1,0,0),(3271,324,'龙华区',3,'',0,1,0,0),(3272,325,'三亚市',3,'',0,1,0,0),(3273,326,'五指山市',3,'',0,1,0,0),(3274,327,'琼海市',3,'',0,1,0,0),(3275,328,'儋州市',3,'',0,1,0,0),(3276,329,'文昌市',3,'',0,1,0,0),(3277,330,'万宁市',3,'',0,1,0,0),(3278,331,'东方市',3,'',0,1,0,0),(3279,332,'定安县',3,'',0,1,0,0),(3280,333,'屯昌县',3,'',0,1,0,0),(3281,334,'澄迈县',3,'',0,1,0,0),(3282,335,'临高县',3,'',0,1,0,0),(3283,336,'白沙黎族自治县',3,'',0,1,0,0),(3284,337,'昌江黎族自治县',3,'',0,1,0,0),(3285,338,'乐东黎族自治县',3,'',0,1,0,0),(3286,339,'陵水黎族自治县',3,'',0,1,0,0),(3287,340,'保亭黎族苗族自治县',3,'',0,1,0,0),(3288,341,'琼中黎族苗族自治县',3,'',0,1,0,0),(3289,345,'九池乡',3,'',0,1,0,0),(3290,345,'五桥街道',3,'',0,1,0,0),(3291,345,'余家镇',3,'',0,1,0,0),(3292,345,'分水镇',3,'',0,1,0,0),(3293,345,'双河口街道',3,'',0,1,0,0),(3294,345,'后山镇',3,'',0,1,0,0),(3295,345,'周家坝街道',3,'',0,1,0,0),(3296,345,'响水镇',3,'',0,1,0,0),(3297,345,'地宝乡',3,'',0,1,0,0),(3298,345,'大周镇',3,'',0,1,0,0),(3299,345,'天城镇',3,'',0,1,0,0),(3300,345,'太安镇',3,'',0,1,0,0),(3301,345,'太白街道',3,'',0,1,0,0),(3302,345,'太龙镇',3,'',0,1,0,0),(3303,345,'孙家镇',3,'',0,1,0,0),(3304,345,'小周镇',3,'',0,1,0,0),(3305,345,'弹子镇',3,'',0,1,0,0),(3306,345,'恒合土家族乡',3,'',0,1,0,0),(3307,345,'新乡镇',3,'',0,1,0,0),(3308,345,'新田镇',3,'',0,1,0,0),(3309,345,'普子乡',3,'',0,1,0,0),(3310,345,'李河镇',3,'',0,1,0,0),(3311,345,'柱山乡',3,'',0,1,0,0),(3312,345,'梨树乡',3,'',0,1,0,0),(3313,345,'武陵镇',3,'',0,1,0,0),(3314,345,'沙河街道',3,'',0,1,0,0),(3315,345,'溪口乡',3,'',0,1,0,0),(3316,345,'瀼渡镇',3,'',0,1,0,0),(3317,345,'熊家镇',3,'',0,1,0,0),(3318,345,'燕山乡',3,'',0,1,0,0),(3319,345,'牌楼街道',3,'',0,1,0,0),(3320,345,'甘宁镇',3,'',0,1,0,0),(3321,345,'白土镇',3,'',0,1,0,0),(3322,345,'白羊镇',3,'',0,1,0,0),(3323,345,'百安坝街道',3,'',0,1,0,0),(3324,345,'罗田镇',3,'',0,1,0,0),(3325,345,'茨竹乡',3,'',0,1,0,0),(3326,345,'走马镇',3,'',0,1,0,0),(3327,345,'郭村乡',3,'',0,1,0,0),(3328,345,'钟鼓楼街道',3,'',0,1,0,0),(3329,345,'铁峰乡',3,'',0,1,0,0),(3330,345,'长坪乡',3,'',0,1,0,0),(3331,345,'长岭镇',3,'',0,1,0,0),(3332,345,'长滩镇',3,'',0,1,0,0),(3333,345,'陈家坝街道',3,'',0,1,0,0),(3334,345,'高峰镇',3,'',0,1,0,0),(3335,345,'高梁镇',3,'',0,1,0,0),(3336,345,'高笋塘街道',3,'',0,1,0,0),(3337,345,'黄柏乡',3,'',0,1,0,0),(3338,345,'龙沙镇',3,'',0,1,0,0),(3339,345,'龙都街道',3,'',0,1,0,0),(3340,345,'龙驹镇',3,'',0,1,0,0),(3341,346,'丛林乡',3,'',0,1,0,0),(3342,346,'两汇乡',3,'',0,1,0,0),(3343,346,'中峰乡',3,'',0,1,0,0),(3344,346,'义和镇',3,'',0,1,0,0),(3345,346,'仁义乡',3,'',0,1,0,0),(3346,346,'南沱镇',3,'',0,1,0,0),(3347,346,'卷洞乡',3,'',0,1,0,0),(3348,346,'同乐乡',3,'',0,1,0,0),(3349,346,'土地坡乡',3,'',0,1,0,0),(3350,346,'堡子镇',3,'',0,1,0,0),(3351,346,'增福乡',3,'',0,1,0,0),(3352,346,'大木乡',3,'',0,1,0,0),(3353,346,'天台乡',3,'',0,1,0,0),(3354,346,'太和乡',3,'',0,1,0,0),(3355,346,'山窝乡',3,'',0,1,0,0),(3356,346,'崇义街道',3,'',0,1,0,0),(3357,346,'惠民乡',3,'',0,1,0,0),(3358,346,'敦仁街道',3,'',0,1,0,0),(3359,346,'新妙镇',3,'',0,1,0,0),(3360,346,'新村乡',3,'',0,1,0,0),(3361,346,'明家乡',3,'',0,1,0,0),(3362,346,'李渡镇',3,'',0,1,0,0),(3363,346,'梓里乡',3,'',0,1,0,0),(3364,346,'武陵山乡',3,'',0,1,0,0),(3365,346,'江东街道',3,'',0,1,0,0),(3366,346,'江北街道',3,'',0,1,0,0),(3367,346,'清溪镇',3,'',0,1,0,0),(3368,346,'焦石镇',3,'',0,1,0,0),(3369,346,'珍溪镇',3,'',0,1,0,0),(3370,346,'白涛镇',3,'',0,1,0,0),(3371,346,'百胜镇',3,'',0,1,0,0),(3372,346,'石和乡',3,'',0,1,0,0),(3373,346,'石沱镇',3,'',0,1,0,0),(3374,346,'石龙乡',3,'',0,1,0,0),(3375,346,'罗云乡',3,'',0,1,0,0),(3376,346,'聚宝乡',3,'',0,1,0,0),(3377,346,'致韩镇',3,'',0,1,0,0),(3378,346,'荔枝街道',3,'',0,1,0,0),(3379,346,'蔺市镇',3,'',0,1,0,0),(3380,346,'酒店乡',3,'',0,1,0,0),(3381,346,'镇安镇',3,'',0,1,0,0),(3382,346,'青羊镇',3,'',0,1,0,0),(3383,346,'马武镇',3,'',0,1,0,0),(3384,346,'龙桥镇',3,'',0,1,0,0),(3385,346,'龙潭镇',3,'',0,1,0,0),(3386,347,'七星岗街道',3,'',0,1,0,0),(3387,347,'上清寺街道',3,'',0,1,0,0),(3388,347,'两路口街道',3,'',0,1,0,0),(3389,347,'化龙桥街道',3,'',0,1,0,0),(3390,347,'南纪门街道',3,'',0,1,0,0),(3391,347,'大坪街道',3,'',0,1,0,0),(3392,347,'大溪沟街道',3,'',0,1,0,0),(3393,347,'望龙门街道',3,'',0,1,0,0),(3394,347,'朝天门街道',3,'',0,1,0,0),(3395,347,'石油路街道',3,'',0,1,0,0),(3396,347,'菜园坝街道',3,'',0,1,0,0),(3397,347,'解放碑街道',3,'',0,1,0,0),(3398,348,'九宫庙街道',3,'',0,1,0,0),(3399,348,'八桥镇',3,'',0,1,0,0),(3400,348,'建胜镇',3,'',0,1,0,0),(3401,348,'新山村街道',3,'',0,1,0,0),(3402,348,'春晖路街道',3,'',0,1,0,0),(3403,348,'茄子溪街道',3,'',0,1,0,0),(3404,348,'跃进村街道',3,'',0,1,0,0),(3405,348,'跳磴镇',3,'',0,1,0,0),(3406,349,'五宝镇',3,'',0,1,0,0),(3407,349,'五里店街道',3,'',0,1,0,0),(3408,349,'华新街街道',3,'',0,1,0,0),(3409,349,'复盛镇',3,'',0,1,0,0),(3410,349,'大石坝街道',3,'',0,1,0,0),(3411,349,'寸滩街道',3,'',0,1,0,0),(3412,349,'江北城街道',3,'',0,1,0,0),(3413,349,'石马河街道',3,'',0,1,0,0),(3414,349,'观音桥街道',3,'',0,1,0,0),(3415,349,'郭家沱街道',3,'',0,1,0,0),(3416,349,'铁山坪街道',3,'',0,1,0,0),(3417,349,'鱼嘴镇',3,'',0,1,0,0),(3418,350,'中梁镇',3,'',0,1,0,0),(3419,350,'井口街道',3,'',0,1,0,0),(3420,350,'井口镇',3,'',0,1,0,0),(3421,350,'凤凰镇',3,'',0,1,0,0),(3422,350,'回龙坝镇',3,'',0,1,0,0),(3423,350,'土主镇',3,'',0,1,0,0),(3424,350,'土湾街道',3,'',0,1,0,0),(3425,350,'天星桥街道',3,'',0,1,0,0),(3426,350,'小龙坎街道',3,'',0,1,0,0),(3427,350,'山洞街道',3,'',0,1,0,0),(3428,350,'新桥街道',3,'',0,1,0,0),(3429,350,'曾家镇',3,'',0,1,0,0),(3430,350,'歌乐山街道',3,'',0,1,0,0),(3431,350,'歌乐山镇',3,'',0,1,0,0),(3432,350,'沙坪坝街道',3,'',0,1,0,0),(3433,350,'渝碚路街道',3,'',0,1,0,0),(3434,350,'石井坡街道',3,'',0,1,0,0),(3435,350,'磁器口街道',3,'',0,1,0,0),(3436,350,'童家桥街道',3,'',0,1,0,0),(3437,350,'虎溪镇',3,'',0,1,0,0),(3438,350,'西永镇',3,'',0,1,0,0),(3439,350,'覃家岗镇',3,'',0,1,0,0),(3440,350,'詹家溪街道',3,'',0,1,0,0),(3441,350,'陈家桥镇',3,'',0,1,0,0),(3442,350,'青木关镇',3,'',0,1,0,0),(3443,351,'中梁山街道',3,'',0,1,0,0),(3444,351,'九龙镇',3,'',0,1,0,0),(3445,351,'华岩镇',3,'',0,1,0,0),(3446,351,'含谷镇',3,'',0,1,0,0),(3447,351,'巴福镇',3,'',0,1,0,0),(3448,351,'杨家坪街道',3,'',0,1,0,0),(3449,351,'渝州路街道',3,'',0,1,0,0),(3450,351,'白市驿镇',3,'',0,1,0,0),(3451,351,'石坪桥街道',3,'',0,1,0,0),(3452,351,'石板镇',3,'',0,1,0,0),(3453,351,'石桥铺街道',3,'',0,1,0,0),(3454,351,'西彭镇',3,'',0,1,0,0),(3455,351,'谢家湾街道',3,'',0,1,0,0),(3456,351,'走马镇',3,'',0,1,0,0),(3457,351,'金凤镇',3,'',0,1,0,0),(3458,351,'铜罐驿镇',3,'',0,1,0,0),(3459,351,'陶家镇',3,'',0,1,0,0),(3460,351,'黄桷坪街道',3,'',0,1,0,0),(3461,352,'南坪街道',3,'',0,1,0,0),(3462,352,'南坪镇',3,'',0,1,0,0),(3463,352,'南山街道',3,'',0,1,0,0),(3464,352,'峡口镇',3,'',0,1,0,0),(3465,352,'广阳镇',3,'',0,1,0,0),(3466,352,'弹子石街道',3,'',0,1,0,0),(3467,352,'海棠溪街道',3,'',0,1,0,0),(3468,352,'涂山镇',3,'',0,1,0,0),(3469,352,'花园路街道',3,'',0,1,0,0),(3470,352,'迎龙镇',3,'',0,1,0,0),(3471,352,'铜元局街道',3,'',0,1,0,0),(3472,352,'长生桥镇',3,'',0,1,0,0),(3473,352,'鸡冠石镇',3,'',0,1,0,0),(3474,352,'龙门浩街道',3,'',0,1,0,0),(3475,353,'三圣镇',3,'',0,1,0,0),(3476,353,'东阳街道',3,'',0,1,0,0),(3477,353,'北温泉街道',3,'',0,1,0,0),(3478,353,'复兴镇',3,'',0,1,0,0),(3479,353,'天府镇',3,'',0,1,0,0),(3480,353,'天生街道',3,'',0,1,0,0),(3481,353,'施家梁镇',3,'',0,1,0,0),(3482,353,'朝阳街道',3,'',0,1,0,0),(3483,353,'柳荫镇',3,'',0,1,0,0),(3484,353,'歇马镇',3,'',0,1,0,0),(3485,353,'水土镇',3,'',0,1,0,0),(3486,353,'澄江镇',3,'',0,1,0,0),(3487,353,'童家溪镇',3,'',0,1,0,0),(3488,353,'蔡家岗镇',3,'',0,1,0,0),(3489,353,'金刀峡镇',3,'',0,1,0,0),(3490,353,'静观镇',3,'',0,1,0,0),(3491,353,'龙凤桥街道',3,'',0,1,0,0),(3492,354,'双路镇',3,'',0,1,0,0),(3493,354,'通桥镇',3,'',0,1,0,0),(3494,354,'龙滩子街道',3,'',0,1,0,0),(3495,355,'万东镇',3,'',0,1,0,0),(3496,355,'万盛街道',3,'',0,1,0,0),(3497,355,'丛林镇',3,'',0,1,0,0),(3498,355,'东林街道',3,'',0,1,0,0),(3499,355,'关坝镇',3,'',0,1,0,0),(3500,355,'南桐镇',3,'',0,1,0,0),(3501,355,'石林镇',3,'',0,1,0,0),(3502,355,'金桥镇',3,'',0,1,0,0),(3503,355,'青年镇',3,'',0,1,0,0),(3504,355,'黑山镇',3,'',0,1,0,0),(3505,356,'人和街道',3,'',0,1,0,0),(3506,356,'兴隆镇',3,'',0,1,0,0),(3507,356,'华蓥山镇',3,'',0,1,0,0),(3508,356,'双凤桥街道',3,'',0,1,0,0),(3509,356,'双龙湖街道',3,'',0,1,0,0),(3510,356,'古路镇',3,'',0,1,0,0),(3511,356,'回兴街道',3,'',0,1,0,0),(3512,356,'大塆镇',3,'',0,1,0,0),(3513,356,'大盛镇',3,'',0,1,0,0),(3514,356,'大竹林街道',3,'',0,1,0,0),(3515,356,'天宫殿街道',3,'',0,1,0,0),(3516,356,'张关镇',3,'',0,1,0,0),(3517,356,'御临镇',3,'',0,1,0,0),(3518,356,'悦来镇',3,'',0,1,0,0),(3519,356,'明月镇',3,'',0,1,0,0),(3520,356,'木耳镇',3,'',0,1,0,0),(3521,356,'洛碛镇',3,'',0,1,0,0),(3522,356,'玉峰山镇',3,'',0,1,0,0),(3523,356,'王家镇',3,'',0,1,0,0),(3524,356,'石坪镇',3,'',0,1,0,0),(3525,356,'石船镇',3,'',0,1,0,0),(3526,356,'礼嘉镇',3,'',0,1,0,0),(3527,356,'统景镇',3,'',0,1,0,0),(3528,356,'翠云街道',3,'',0,1,0,0),(3529,356,'茨竹',3,'',0,1,0,0),(3530,356,'高嘴镇',3,'',0,1,0,0),(3531,356,'鸳鸯街道',3,'',0,1,0,0),(3532,356,'麻柳沱镇',3,'',0,1,0,0),(3533,356,'龙兴镇',3,'',0,1,0,0),(3534,356,'龙塔街道',3,'',0,1,0,0),(3535,356,'龙山街道',3,'',0,1,0,0),(3536,356,'龙溪街道',3,'',0,1,0,0),(3537,357,'一品镇',3,'',0,1,0,0),(3538,357,'东泉镇',3,'',0,1,0,0),(3539,357,'丰盛镇',3,'',0,1,0,0),(3540,357,'二圣镇',3,'',0,1,0,0),(3541,357,'南彭镇',3,'',0,1,0,0),(3542,357,'南泉镇',3,'',0,1,0,0),(3543,357,'双河口镇',3,'',0,1,0,0),(3544,357,'天星寺镇',3,'',0,1,0,0),(3545,357,'姜家镇',3,'',0,1,0,0),(3546,357,'安澜镇',3,'',0,1,0,0),(3547,357,'惠民镇',3,'',0,1,0,0),(3548,357,'接龙镇',3,'',0,1,0,0),(3549,357,'木洞镇',3,'',0,1,0,0),(3550,357,'李家沱街道',3,'',0,1,0,0),(3551,357,'界石镇',3,'',0,1,0,0),(3552,357,'石滩镇',3,'',0,1,0,0),(3553,357,'石龙镇',3,'',0,1,0,0),(3554,357,'花溪镇',3,'',0,1,0,0),(3555,357,'跳石镇',3,'',0,1,0,0),(3556,357,'鱼洞街道',3,'',0,1,0,0),(3557,357,'麻柳嘴镇',3,'',0,1,0,0),(3558,358,'两河镇',3,'',0,1,0,0),(3559,358,'中塘乡',3,'',0,1,0,0),(3560,358,'五里乡',3,'',0,1,0,0),(3561,358,'冯家镇',3,'',0,1,0,0),(3562,358,'城东街道',3,'',0,1,0,0),(3563,358,'城南街道',3,'',0,1,0,0),(3564,358,'城西街道',3,'',0,1,0,0),(3565,358,'太极乡',3,'',0,1,0,0),(3566,358,'小南海镇',3,'',0,1,0,0),(3567,358,'新华乡',3,'',0,1,0,0),(3568,358,'杉岭乡',3,'',0,1,0,0),(3569,358,'正阳镇',3,'',0,1,0,0),(3570,358,'水市乡',3,'',0,1,0,0),(3571,358,'水田乡',3,'',0,1,0,0),(3572,358,'沙坝乡',3,'',0,1,0,0),(3573,358,'濯水镇',3,'',0,1,0,0),(3574,358,'白土乡',3,'',0,1,0,0),(3575,358,'白石乡',3,'',0,1,0,0),(3576,358,'石会镇',3,'',0,1,0,0),(3577,358,'石家镇',3,'',0,1,0,0),(3578,358,'舟白镇',3,'',0,1,0,0),(3579,358,'蓬东乡',3,'',0,1,0,0),(3580,358,'邻鄂镇',3,'',0,1,0,0),(3581,358,'金洞乡',3,'',0,1,0,0),(3582,358,'金溪镇',3,'',0,1,0,0),(3583,358,'马喇镇',3,'',0,1,0,0),(3584,358,'鹅池镇',3,'',0,1,0,0),(3585,358,'黄溪镇',3,'',0,1,0,0),(3586,358,'黎水镇',3,'',0,1,0,0),(3587,358,'黑溪镇',3,'',0,1,0,0),(3588,359,'万顺镇',3,'',0,1,0,0),(3589,359,'云台镇',3,'',0,1,0,0),(3590,359,'云集镇',3,'',0,1,0,0),(3591,359,'但渡镇',3,'',0,1,0,0),(3592,359,'八颗镇',3,'',0,1,0,0),(3593,359,'凤城街道',3,'',0,1,0,0),(3594,359,'双龙镇',3,'',0,1,0,0),(3595,359,'新市镇',3,'',0,1,0,0),(3596,359,'晏家街道',3,'',0,1,0,0),(3597,359,'江南镇',3,'',0,1,0,0),(3598,359,'洪湖镇',3,'',0,1,0,0),(3599,359,'海棠镇',3,'',0,1,0,0),(3600,359,'渡舟镇',3,'',0,1,0,0),(3601,359,'石堰镇',3,'',0,1,0,0),(3602,359,'葛兰镇',3,'',0,1,0,0),(3603,359,'邻封镇',3,'',0,1,0,0),(3604,359,'长寿湖镇',3,'',0,1,0,0),(3605,359,'龙河镇',3,'',0,1,0,0),(3606,360,'丁山镇',3,'',0,1,0,0),(3607,360,'三江镇',3,'',0,1,0,0),(3608,360,'三角镇',3,'',0,1,0,0),(3609,360,'东溪镇',3,'',0,1,0,0),(3610,360,'中峰镇',3,'',0,1,0,0),(3611,360,'古南镇',3,'',0,1,0,0),(3612,360,'安稳镇',3,'',0,1,0,0),(3613,360,'打通镇',3,'',0,1,0,0),(3614,360,'扶欢镇',3,'',0,1,0,0),(3615,360,'新盛镇',3,'',0,1,0,0),(3616,360,'横山镇',3,'',0,1,0,0),(3617,360,'永城镇',3,'',0,1,0,0),(3618,360,'永新镇',3,'',0,1,0,0),(3619,360,'石壕镇',3,'',0,1,0,0),(3620,360,'石角镇',3,'',0,1,0,0),(3621,360,'篆塘镇',3,'',0,1,0,0),(3622,360,'赶水镇',3,'',0,1,0,0),(3623,360,'郭扶镇',3,'',0,1,0,0),(3624,360,'隆盛镇',3,'',0,1,0,0),(3625,361,'上和镇',3,'',0,1,0,0),(3626,361,'五桂镇',3,'',0,1,0,0),(3627,361,'别口乡',3,'',0,1,0,0),(3628,361,'卧佛镇',3,'',0,1,0,0),(3629,361,'双江镇',3,'',0,1,0,0),(3630,361,'古溪镇',3,'',0,1,0,0),(3631,361,'塘坝镇',3,'',0,1,0,0),(3632,361,'太安镇',3,'',0,1,0,0),(3633,361,'宝龙镇',3,'',0,1,0,0),(3634,361,'寿桥乡',3,'',0,1,0,0),(3635,361,'小渡镇',3,'',0,1,0,0),(3636,361,'崇龛镇',3,'',0,1,0,0),(3637,361,'新胜镇',3,'',0,1,0,0),(3638,361,'柏梓镇',3,'',0,1,0,0),(3639,361,'桂林街道',3,'',0,1,0,0),(3640,361,'梓潼街道',3,'',0,1,0,0),(3641,361,'玉溪镇',3,'',0,1,0,0),(3642,361,'田家乡',3,'',0,1,0,0),(3643,361,'米心镇',3,'',0,1,0,0),(3644,361,'群力镇',3,'',0,1,0,0),(3645,361,'花岩镇',3,'',0,1,0,0),(3646,361,'龙形镇',3,'',0,1,0,0),(3647,362,'东城街道',3,'',0,1,0,0),(3648,362,'二坪镇',3,'',0,1,0,0),(3649,362,'侣俸镇',3,'',0,1,0,0),(3650,362,'华兴镇',3,'',0,1,0,0),(3651,362,'南城街道',3,'',0,1,0,0),(3652,362,'双山乡',3,'',0,1,0,0),(3653,362,'围龙镇',3,'',0,1,0,0),(3654,362,'土桥镇',3,'',0,1,0,0),(3655,362,'大庙镇',3,'',0,1,0,0),(3656,362,'太平镇',3,'',0,1,0,0),(3657,362,'安居镇',3,'',0,1,0,0),(3658,362,'安溪镇',3,'',0,1,0,0),(3659,362,'小林乡',3,'',0,1,0,0),(3660,362,'少云镇',3,'',0,1,0,0),(3661,362,'巴川街道',3,'',0,1,0,0),(3662,362,'平滩镇',3,'',0,1,0,0),(3663,362,'庆隆乡',3,'',0,1,0,0),(3664,362,'旧县镇',3,'',0,1,0,0),(3665,362,'水口镇',3,'',0,1,0,0),(3666,362,'永嘉镇',3,'',0,1,0,0),(3667,362,'白羊镇',3,'',0,1,0,0),(3668,362,'石鱼镇',3,'',0,1,0,0),(3669,362,'福果镇',3,'',0,1,0,0),(3670,362,'维新镇',3,'',0,1,0,0),(3671,362,'蒲吕镇',3,'',0,1,0,0),(3672,362,'虎峰镇',3,'',0,1,0,0),(3673,362,'西河镇',3,'',0,1,0,0),(3674,362,'高楼镇',3,'',0,1,0,0),(3675,363,'万古镇',3,'',0,1,0,0),(3676,363,'三驱镇',3,'',0,1,0,0),(3677,363,'中敖镇',3,'',0,1,0,0),(3678,363,'古龙乡',3,'',0,1,0,0),(3679,363,'回龙镇',3,'',0,1,0,0),(3680,363,'国梁镇',3,'',0,1,0,0),(3681,363,'季家镇',3,'',0,1,0,0),(3682,363,'宝兴镇',3,'',0,1,0,0),(3683,363,'宝顶镇',3,'',0,1,0,0),(3684,363,'拾万镇',3,'',0,1,0,0),(3685,363,'智凤镇',3,'',0,1,0,0),(3686,363,'棠香街道',3,'',0,1,0,0),(3687,363,'玉龙镇',3,'',0,1,0,0),(3688,363,'珠溪镇',3,'',0,1,0,0),(3689,363,'石马镇',3,'',0,1,0,0),(3690,363,'邮亭镇',3,'',0,1,0,0),(3691,363,'金山镇',3,'',0,1,0,0),(3692,363,'铁山镇',3,'',0,1,0,0),(3693,363,'雍溪镇',3,'',0,1,0,0),(3694,363,'高升场镇',3,'',0,1,0,0),(3695,363,'高坪乡',3,'',0,1,0,0),(3696,363,'龙岗街道',3,'',0,1,0,0),(3697,363,'龙水镇',3,'',0,1,0,0),(3698,363,'龙石镇',3,'',0,1,0,0),(3699,364,'仁义镇',3,'',0,1,0,0),(3700,364,'双河镇',3,'',0,1,0,0),(3701,364,'古昌镇',3,'',0,1,0,0),(3702,364,'吴家镇',3,'',0,1,0,0),(3703,364,'安富镇',3,'',0,1,0,0),(3704,364,'峰高镇',3,'',0,1,0,0),(3705,364,'广顺镇',3,'',0,1,0,0),(3706,364,'昌元镇',3,'',0,1,0,0),(3707,364,'河包镇',3,'',0,1,0,0),(3708,364,'清升镇',3,'',0,1,0,0),(3709,364,'清江镇',3,'',0,1,0,0),(3710,364,'清流镇',3,'',0,1,0,0),(3711,364,'盘龙镇',3,'',0,1,0,0),(3712,364,'直升镇',3,'',0,1,0,0),(3713,364,'荣隆镇',3,'',0,1,0,0),(3714,364,'观胜镇',3,'',0,1,0,0),(3715,364,'路孔镇',3,'',0,1,0,0),(3716,364,'远觉镇',3,'',0,1,0,0),(3717,364,'铜鼓镇',3,'',0,1,0,0),(3718,364,'龙集镇',3,'',0,1,0,0),(3719,365,'丁家镇',3,'',0,1,0,0),(3720,365,'七塘镇',3,'',0,1,0,0),(3721,365,'三合镇',3,'',0,1,0,0),(3722,365,'健龙乡',3,'',0,1,0,0),(3723,365,'八塘镇',3,'',0,1,0,0),(3724,365,'大兴镇',3,'',0,1,0,0),(3725,365,'大路镇',3,'',0,1,0,0),(3726,365,'广普镇',3,'',0,1,0,0),(3727,365,'正兴镇',3,'',0,1,0,0),(3728,365,'河边镇',3,'',0,1,0,0),(3729,365,'璧城街道',3,'',0,1,0,0),(3730,365,'福禄镇',3,'',0,1,0,0),(3731,365,'青杠街道',3,'',0,1,0,0),(3732,366,'七星镇',3,'',0,1,0,0),(3733,366,'云龙镇',3,'',0,1,0,0),(3734,366,'仁贤镇',3,'',0,1,0,0),(3735,366,'合兴镇',3,'',0,1,0,0),(3736,366,'和林镇',3,'',0,1,0,0),(3737,366,'回龙镇',3,'',0,1,0,0),(3738,366,'城东乡',3,'',0,1,0,0),(3739,366,'城北乡',3,'',0,1,0,0),(3740,366,'复平乡',3,'',0,1,0,0),(3741,366,'大观镇',3,'',0,1,0,0),(3742,366,'安胜乡',3,'',0,1,0,0),(3743,366,'屏锦镇',3,'',0,1,0,0),(3744,366,'文化镇',3,'',0,1,0,0),(3745,366,'新盛镇',3,'',0,1,0,0),(3746,366,'明达镇',3,'',0,1,0,0),(3747,366,'曲水乡',3,'',0,1,0,0),(3748,366,'柏家镇',3,'',0,1,0,0),(3749,366,'梁山镇',3,'',0,1,0,0),(3750,366,'石安镇',3,'',0,1,0,0),(3751,366,'碧山镇',3,'',0,1,0,0),(3752,366,'礼让镇',3,'',0,1,0,0),(3753,366,'福禄镇',3,'',0,1,0,0),(3754,366,'竹山镇',3,'',0,1,0,0),(3755,366,'紫照乡',3,'',0,1,0,0),(3756,366,'聚奎镇',3,'',0,1,0,0),(3757,366,'荫平镇',3,'',0,1,0,0),(3758,366,'虎城镇',3,'',0,1,0,0),(3759,366,'蟠龙镇',3,'',0,1,0,0),(3760,366,'袁驿镇',3,'',0,1,0,0),(3761,366,'金带镇',3,'',0,1,0,0),(3762,366,'铁门乡',3,'',0,1,0,0),(3763,366,'龙胜乡',3,'',0,1,0,0),(3764,366,'龙门镇',3,'',0,1,0,0),(3765,367,'东安乡',3,'',0,1,0,0),(3766,367,'修齐镇',3,'',0,1,0,0),(3767,367,'北屏乡',3,'',0,1,0,0),(3768,367,'厚坪乡',3,'',0,1,0,0),(3769,367,'双河乡',3,'',0,1,0,0),(3770,367,'周溪乡',3,'',0,1,0,0),(3771,367,'咸宜乡',3,'',0,1,0,0),(3772,367,'坪坝镇',3,'',0,1,0,0),(3773,367,'岚天乡',3,'',0,1,0,0),(3774,367,'左岚乡',3,'',0,1,0,0),(3775,367,'巴山镇',3,'',0,1,0,0),(3776,367,'庙坝镇',3,'',0,1,0,0),(3777,367,'明中乡',3,'',0,1,0,0),(3778,367,'明通镇',3,'',0,1,0,0),(3779,367,'河鱼乡',3,'',0,1,0,0),(3780,367,'治平乡',3,'',0,1,0,0),(3781,367,'沿河乡',3,'',0,1,0,0),(3782,367,'葛城镇',3,'',0,1,0,0),(3783,367,'蓼子乡',3,'',0,1,0,0),(3784,367,'高楠乡',3,'',0,1,0,0),(3785,367,'高燕乡',3,'',0,1,0,0),(3786,367,'高观镇',3,'',0,1,0,0),(3787,367,'鸡鸣乡',3,'',0,1,0,0),(3788,367,'龙田乡',3,'',0,1,0,0),(3789,368,'三元镇',3,'',0,1,0,0),(3790,368,'三合镇',3,'',0,1,0,0),(3791,368,'三坝乡',3,'',0,1,0,0),(3792,368,'三建乡',3,'',0,1,0,0),(3793,368,'仁沙乡',3,'',0,1,0,0),(3794,368,'保合乡',3,'',0,1,0,0),(3795,368,'兴义镇',3,'',0,1,0,0),(3796,368,'包鸾镇',3,'',0,1,0,0),(3797,368,'十直镇',3,'',0,1,0,0),(3798,368,'南天湖镇',3,'',0,1,0,0),(3799,368,'双路镇',3,'',0,1,0,0),(3800,368,'双龙场乡',3,'',0,1,0,0),(3801,368,'名山镇',3,'',0,1,0,0),(3802,368,'太平坝乡',3,'',0,1,0,0),(3803,368,'崇兴乡',3,'',0,1,0,0),(3804,368,'暨龙乡',3,'',0,1,0,0),(3805,368,'树人镇',3,'',0,1,0,0),(3806,368,'栗子乡',3,'',0,1,0,0),(3807,368,'武平镇',3,'',0,1,0,0),(3808,368,'江池镇',3,'',0,1,0,0),(3809,368,'湛普镇',3,'',0,1,0,0),(3810,368,'社坛镇',3,'',0,1,0,0),(3811,368,'董家镇',3,'',0,1,0,0),(3812,368,'虎威镇',3,'',0,1,0,0),(3813,368,'许明寺镇',3,'',0,1,0,0),(3814,368,'都督乡',3,'',0,1,0,0),(3815,368,'镇江镇',3,'',0,1,0,0),(3816,368,'青龙乡',3,'',0,1,0,0),(3817,368,'高家镇',3,'',0,1,0,0),(3818,368,'龙孔乡',3,'',0,1,0,0),(3819,368,'龙河镇',3,'',0,1,0,0),(3820,369,'三溪乡',3,'',0,1,0,0),(3821,369,'五洞镇',3,'',0,1,0,0),(3822,369,'包家乡',3,'',0,1,0,0),(3823,369,'周嘉镇',3,'',0,1,0,0),(3824,369,'坪山镇',3,'',0,1,0,0),(3825,369,'大石乡',3,'',0,1,0,0),(3826,369,'太平镇',3,'',0,1,0,0),(3827,369,'新民镇',3,'',0,1,0,0),(3828,369,'普顺镇',3,'',0,1,0,0),(3829,369,'曹回乡',3,'',0,1,0,0),(3830,369,'杠家乡',3,'',0,1,0,0),(3831,369,'桂溪镇',3,'',0,1,0,0),(3832,369,'永安镇',3,'',0,1,0,0),(3833,369,'永平乡',3,'',0,1,0,0),(3834,369,'沙坪镇',3,'',0,1,0,0),(3835,369,'沙河乡',3,'',0,1,0,0),(3836,369,'澄溪镇',3,'',0,1,0,0),(3837,369,'白家乡',3,'',0,1,0,0),(3838,369,'砚台镇',3,'',0,1,0,0),(3839,369,'裴兴乡',3,'',0,1,0,0),(3840,369,'长龙乡',3,'',0,1,0,0),(3841,369,'高安镇',3,'',0,1,0,0),(3842,369,'高峰镇',3,'',0,1,0,0),(3843,369,'鹤游镇',3,'',0,1,0,0),(3844,369,'黄沙乡',3,'',0,1,0,0),(3845,370,'仙女山镇',3,'',0,1,0,0),(3846,370,'凤来乡',3,'',0,1,0,0),(3847,370,'双河乡',3,'',0,1,0,0),(3848,370,'后坪乡',3,'',0,1,0,0),(3849,370,'和顺乡',3,'',0,1,0,0),(3850,370,'土地乡',3,'',0,1,0,0),(3851,370,'土坎镇',3,'',0,1,0,0),(3852,370,'巷口镇',3,'',0,1,0,0),(3853,370,'平桥镇',3,'',0,1,0,0),(3854,370,'庙垭乡',3,'',0,1,0,0),(3855,370,'接龙乡',3,'',0,1,0,0),(3856,370,'文复乡',3,'',0,1,0,0),(3857,370,'桐梓镇',3,'',0,1,0,0),(3858,370,'江口镇',3,'',0,1,0,0),(3859,370,'沧沟乡',3,'',0,1,0,0),(3860,370,'浩口乡',3,'',0,1,0,0),(3861,370,'火炉镇',3,'',0,1,0,0),(3862,370,'白云乡',3,'',0,1,0,0),(3863,370,'白马镇',3,'',0,1,0,0),(3864,370,'石桥乡',3,'',0,1,0,0),(3865,370,'羊角镇',3,'',0,1,0,0),(3866,370,'赵家乡',3,'',0,1,0,0),(3867,370,'铁矿乡',3,'',0,1,0,0),(3868,370,'长坝镇',3,'',0,1,0,0),(3869,370,'鸭江镇',3,'',0,1,0,0),(3870,370,'黄莺乡',3,'',0,1,0,0),(3871,371,'三汇镇',3,'',0,1,0,0),(3872,371,'东溪镇',3,'',0,1,0,0),(3873,371,'乌杨镇',3,'',0,1,0,0),(3874,371,'任家镇',3,'',0,1,0,0),(3875,371,'兴峰乡',3,'',0,1,0,0),(3876,371,'双桂镇',3,'',0,1,0,0),(3877,371,'善广乡',3,'',0,1,0,0),(3878,371,'复兴镇',3,'',0,1,0,0),(3879,371,'官坝镇',3,'',0,1,0,0),(3880,371,'忠州镇',3,'',0,1,0,0),(3881,371,'拔山镇',3,'',0,1,0,0),(3882,371,'新生镇',3,'',0,1,0,0),(3883,371,'新立镇',3,'',0,1,0,0),(3884,371,'永丰镇',3,'',0,1,0,0),(3885,371,'汝溪镇',3,'',0,1,0,0),(3886,371,'洋渡镇',3,'',0,1,0,0),(3887,371,'涂井乡',3,'',0,1,0,0),(3888,371,'白石镇',3,'',0,1,0,0),(3889,371,'石子乡',3,'',0,1,0,0),(3890,371,'石宝镇',3,'',0,1,0,0),(3891,371,'石黄镇',3,'',0,1,0,0),(3892,371,'磨子土家族乡',3,'',0,1,0,0),(3893,371,'花桥镇',3,'',0,1,0,0),(3894,371,'野鹤镇',3,'',0,1,0,0),(3895,371,'金声乡',3,'',0,1,0,0),(3896,371,'金鸡镇',3,'',0,1,0,0),(3897,371,'马灌镇',3,'',0,1,0,0),(3898,371,'黄金镇',3,'',0,1,0,0),(3899,372,'三汇口乡',3,'',0,1,0,0),(3900,372,'中和镇',3,'',0,1,0,0),(3901,372,'丰乐街道',3,'',0,1,0,0),(3902,372,'临江镇',3,'',0,1,0,0),(3903,372,'义和镇',3,'',0,1,0,0),(3904,372,'九龙山镇',3,'',0,1,0,0),(3905,372,'五通乡',3,'',0,1,0,0),(3906,372,'关面乡',3,'',0,1,0,0),(3907,372,'南门镇',3,'',0,1,0,0),(3908,372,'南雅镇',3,'',0,1,0,0),(3909,372,'厚坝镇',3,'',0,1,0,0),(3910,372,'和谦镇',3,'',0,1,0,0),(3911,372,'大德乡',3,'',0,1,0,0),(3912,372,'大进镇',3,'',0,1,0,0),(3913,372,'天和乡',3,'',0,1,0,0),(3914,372,'岳溪镇',3,'',0,1,0,0),(3915,372,'巫山乡',3,'',0,1,0,0),(3916,372,'敦好镇',3,'',0,1,0,0),(3917,372,'汉丰街道',3,'',0,1,0,0),(3918,372,'河堰镇',3,'',0,1,0,0),(3919,372,'渠口镇',3,'',0,1,0,0),(3920,372,'温泉镇',3,'',0,1,0,0),(3921,372,'满月乡',3,'',0,1,0,0),(3922,372,'白桥乡',3,'',0,1,0,0),(3923,372,'白泉乡',3,'',0,1,0,0),(3924,372,'白鹤街道',3,'',0,1,0,0),(3925,372,'竹溪镇',3,'',0,1,0,0),(3926,372,'紫水乡',3,'',0,1,0,0),(3927,372,'谭家乡',3,'',0,1,0,0),(3928,372,'赵家镇',3,'',0,1,0,0),(3929,372,'郭家镇',3,'',0,1,0,0),(3930,372,'金峰乡',3,'',0,1,0,0),(3931,372,'铁桥镇',3,'',0,1,0,0),(3932,372,'镇东街道',3,'',0,1,0,0),(3933,372,'镇安镇',3,'',0,1,0,0),(3934,372,'长沙镇',3,'',0,1,0,0),(3935,372,'高桥镇',3,'',0,1,0,0),(3936,372,'麻柳乡',3,'',0,1,0,0),(3937,373,'上坝乡',3,'',0,1,0,0),(3938,373,'云安镇',3,'',0,1,0,0),(3939,373,'云硐乡',3,'',0,1,0,0),(3940,373,'云阳镇',3,'',0,1,0,0),(3941,373,'人和镇',3,'',0,1,0,0),(3942,373,'养鹿乡',3,'',0,1,0,0),(3943,373,'农坝镇',3,'',0,1,0,0),(3944,373,'凤鸣镇',3,'',0,1,0,0),(3945,373,'南溪镇',3,'',0,1,0,0),(3946,373,'双土镇',3,'',0,1,0,0),(3947,373,'双江街道',3,'',0,1,0,0),(3948,373,'双龙乡',3,'',0,1,0,0),(3949,373,'后叶乡',3,'',0,1,0,0),(3950,373,'堰坪乡',3,'',0,1,0,0),(3951,373,'外郎乡',3,'',0,1,0,0),(3952,373,'大阳乡',3,'',0,1,0,0),(3953,373,'宝坪镇',3,'',0,1,0,0),(3954,373,'巴阳镇',3,'',0,1,0,0),(3955,373,'平安镇',3,'',0,1,0,0),(3956,373,'故陵镇',3,'',0,1,0,0),(3957,373,'新津乡',3,'',0,1,0,0),(3958,373,'普安乡',3,'',0,1,0,0),(3959,373,'栖霞乡',3,'',0,1,0,0),(3960,373,'桑坪镇',3,'',0,1,0,0),(3961,373,'毛坝乡',3,'',0,1,0,0),(3962,373,'水口乡',3,'',0,1,0,0),(3963,373,'江口镇',3,'',0,1,0,0),(3964,373,'沙市镇',3,'',0,1,0,0),(3965,373,'泥溪乡',3,'',0,1,0,0),(3966,373,'洞鹿乡',3,'',0,1,0,0),(3967,373,'清水土家族乡',3,'',0,1,0,0),(3968,373,'渠马镇',3,'',0,1,0,0),(3969,373,'盘龙镇',3,'',0,1,0,0),(3970,373,'石门乡',3,'',0,1,0,0),(3971,373,'票草乡',3,'',0,1,0,0),(3972,373,'红狮镇',3,'',0,1,0,0),(3973,373,'耀灵乡',3,'',0,1,0,0),(3974,373,'路阳镇',3,'',0,1,0,0),(3975,373,'青龙街道',3,'',0,1,0,0),(3976,373,'高阳镇',3,'',0,1,0,0),(3977,373,'鱼泉镇',3,'',0,1,0,0),(3978,373,'黄石镇',3,'',0,1,0,0),(3979,373,'龙洞乡',3,'',0,1,0,0),(3980,373,'龙角镇',3,'',0,1,0,0),(3981,374,'云雾土家族乡',3,'',0,1,0,0),(3982,374,'五马乡',3,'',0,1,0,0),(3983,374,'公平镇',3,'',0,1,0,0),(3984,374,'兴隆镇',3,'',0,1,0,0),(3985,374,'冯坪乡',3,'',0,1,0,0),(3986,374,'吐祥镇',3,'',0,1,0,0),(3987,374,'大树镇',3,'',0,1,0,0),(3988,374,'太和乡',3,'',0,1,0,0),(3989,374,'安坪乡',3,'',0,1,0,0),(3990,374,'岩湾乡',3,'',0,1,0,0),(3991,374,'平安乡',3,'',0,1,0,0),(3992,374,'康乐镇',3,'',0,1,0,0),(3993,374,'康坪乡',3,'',0,1,0,0),(3994,374,'新政乡',3,'',0,1,0,0),(3995,374,'新民镇',3,'',0,1,0,0),(3996,374,'朱衣镇',3,'',0,1,0,0),(3997,374,'永乐镇',3,'',0,1,0,0),(3998,374,'永安镇',3,'',0,1,0,0),(3999,374,'汾河镇',3,'',0,1,0,0),(4000,374,'甲高镇',3,'',0,1,0,0),(4001,374,'白帝镇',3,'',0,1,0,0),(4002,374,'石岗乡',3,'',0,1,0,0),(4003,374,'竹园镇',3,'',0,1,0,0),(4004,374,'红土乡',3,'',0,1,0,0),(4005,374,'羊市镇',3,'',0,1,0,0),(4006,374,'草堂镇',3,'',0,1,0,0),(4007,374,'长安土家族乡',3,'',0,1,0,0),(4008,374,'青龙镇',3,'',0,1,0,0),(4009,374,'鹤峰乡',3,'',0,1,0,0),(4010,374,'龙桥土家族乡',3,'',0,1,0,0),(4011,375,'三溪乡',3,'',0,1,0,0),(4012,375,'两坪乡',3,'',0,1,0,0),(4013,375,'双龙镇',3,'',0,1,0,0),(4014,375,'培石乡',3,'',0,1,0,0),(4015,375,'大昌镇',3,'',0,1,0,0),(4016,375,'大溪乡',3,'',0,1,0,0),(4017,375,'官渡镇',3,'',0,1,0,0),(4018,375,'官阳镇',3,'',0,1,0,0),(4019,375,'巫峡镇',3,'',0,1,0,0),(4020,375,'平河乡',3,'',0,1,0,0),(4021,375,'庙堂乡',3,'',0,1,0,0),(4022,375,'庙宇镇',3,'',0,1,0,0),(4023,375,'建平乡',3,'',0,1,0,0),(4024,375,'当阳乡',3,'',0,1,0,0),(4025,375,'抱龙镇',3,'',0,1,0,0),(4026,375,'曲尺乡',3,'',0,1,0,0),(4027,375,'福田镇',3,'',0,1,0,0),(4028,375,'竹贤乡',3,'',0,1,0,0),(4029,375,'笃坪乡',3,'',0,1,0,0),(4030,375,'红椿土家族乡',3,'',0,1,0,0),(4031,375,'邓家土家族乡',3,'',0,1,0,0),(4032,375,'金坪乡',3,'',0,1,0,0),(4033,375,'铜鼓镇',3,'',0,1,0,0),(4034,375,'骡坪镇',3,'',0,1,0,0),(4035,375,'龙井乡',3,'',0,1,0,0),(4036,375,'龙溪镇',3,'',0,1,0,0),(4037,376,'上磺镇',3,'',0,1,0,0),(4038,376,'下堡镇',3,'',0,1,0,0),(4039,376,'中岗乡',3,'',0,1,0,0),(4040,376,'中梁乡',3,'',0,1,0,0),(4041,376,'乌龙乡',3,'',0,1,0,0),(4042,376,'兰英乡',3,'',0,1,0,0),(4043,376,'凤凰镇',3,'',0,1,0,0),(4044,376,'双阳乡',3,'',0,1,0,0),(4045,376,'古路镇',3,'',0,1,0,0),(4046,376,'土城乡',3,'',0,1,0,0),(4047,376,'城厢镇',3,'',0,1,0,0),(4048,376,'塘坊乡',3,'',0,1,0,0),(4049,376,'大河乡',3,'',0,1,0,0),(4050,376,'天元乡',3,'',0,1,0,0),(4051,376,'天星乡',3,'',0,1,0,0),(4052,376,'宁厂镇',3,'',0,1,0,0),(4053,376,'尖山镇',3,'',0,1,0,0),(4054,376,'峰灵乡',3,'',0,1,0,0),(4055,376,'徐家镇',3,'',0,1,0,0),(4056,376,'文峰镇',3,'',0,1,0,0),(4057,376,'朝阳洞乡',3,'',0,1,0,0),(4058,376,'田坝乡',3,'',0,1,0,0),(4059,376,'白鹿镇',3,'',0,1,0,0),(4060,376,'胜利乡',3,'',0,1,0,0),(4061,376,'花台乡',3,'',0,1,0,0),(4062,376,'菱角乡',3,'',0,1,0,0),(4063,376,'蒲莲乡',3,'',0,1,0,0),(4064,376,'通城乡',3,'',0,1,0,0),(4065,376,'长桂乡',3,'',0,1,0,0),(4066,376,'鱼鳞乡',3,'',0,1,0,0),(4067,377,'万朝乡',3,'',0,1,0,0),(4068,377,'三星乡',3,'',0,1,0,0),(4069,377,'三河乡',3,'',0,1,0,0),(4070,377,'三益乡',3,'',0,1,0,0),(4071,377,'下路镇',3,'',0,1,0,0),(4072,377,'中益乡',3,'',0,1,0,0),(4073,377,'临溪镇',3,'',0,1,0,0),(4074,377,'六塘乡',3,'',0,1,0,0),(4075,377,'冷水乡',3,'',0,1,0,0),(4076,377,'南宾镇',3,'',0,1,0,0),(4077,377,'大歇乡',3,'',0,1,0,0),(4078,377,'悦崃镇',3,'',0,1,0,0),(4079,377,'新乐乡',3,'',0,1,0,0),(4080,377,'枫木乡',3,'',0,1,0,0),(4081,377,'桥头乡',3,'',0,1,0,0),(4082,377,'沙子镇',3,'',0,1,0,0),(4083,377,'河嘴乡',3,'',0,1,0,0),(4084,377,'沿溪镇',3,'',0,1,0,0),(4085,377,'洗新乡',3,'',0,1,0,0),(4086,377,'渔池镇',3,'',0,1,0,0),(4087,377,'王场镇',3,'',0,1,0,0),(4088,377,'王家乡',3,'',0,1,0,0),(4089,377,'石家乡',3,'',0,1,0,0),(4090,377,'西沱镇',3,'',0,1,0,0),(4091,377,'金竹乡',3,'',0,1,0,0),(4092,377,'金铃乡',3,'',0,1,0,0),(4093,377,'马武镇',3,'',0,1,0,0),(4094,377,'黄水镇',3,'',0,1,0,0),(4095,377,'黄鹤乡',3,'',0,1,0,0),(4096,377,'黎场乡',3,'',0,1,0,0),(4097,377,'龙沙镇',3,'',0,1,0,0),(4098,377,'龙潭乡',3,'',0,1,0,0),(4099,378,'中和镇',3,'',0,1,0,0),(4100,378,'中平乡',3,'',0,1,0,0),(4101,378,'保安乡',3,'',0,1,0,0),(4102,378,'兰桥镇',3,'',0,1,0,0),(4103,378,'塘坳乡',3,'',0,1,0,0),(4104,378,'大溪乡',3,'',0,1,0,0),(4105,378,'妙泉乡',3,'',0,1,0,0),(4106,378,'孝溪乡',3,'',0,1,0,0),(4107,378,'宋农乡',3,'',0,1,0,0),(4108,378,'官庄镇',3,'',0,1,0,0),(4109,378,'官舟乡',3,'',0,1,0,0),(4110,378,'岑溪乡',3,'',0,1,0,0),(4111,378,'峨溶镇',3,'',0,1,0,0),(4112,378,'巴家乡',3,'',0,1,0,0),(4113,378,'干川乡',3,'',0,1,0,0),(4114,378,'平凯镇',3,'',0,1,0,0),(4115,378,'平马乡',3,'',0,1,0,0),(4116,378,'梅江镇',3,'',0,1,0,0),(4117,378,'洪安镇',3,'',0,1,0,0),(4118,378,'海洋乡',3,'',0,1,0,0),(4119,378,'涌洞乡',3,'',0,1,0,0),(4120,378,'清溪场镇',3,'',0,1,0,0),(4121,378,'溪口乡',3,'',0,1,0,0),(4122,378,'溶溪镇',3,'',0,1,0,0),(4123,378,'石堤镇',3,'',0,1,0,0),(4124,378,'石耶镇',3,'',0,1,0,0),(4125,378,'膏田乡',3,'',0,1,0,0),(4126,378,'里仁乡',3,'',0,1,0,0),(4127,378,'钟灵乡',3,'',0,1,0,0),(4128,378,'隘口镇',3,'',0,1,0,0),(4129,378,'雅江镇',3,'',0,1,0,0),(4130,378,'龙池镇',3,'',0,1,0,0),(4131,379,'丁市镇',3,'',0,1,0,0),(4132,379,'万木乡',3,'',0,1,0,0),(4133,379,'两罾乡',3,'',0,1,0,0),(4134,379,'五福乡',3,'',0,1,0,0),(4135,379,'偏柏乡',3,'',0,1,0,0),(4136,379,'兴隆镇',3,'',0,1,0,0),(4137,379,'南腰界乡',3,'',0,1,0,0),(4138,379,'双泉乡',3,'',0,1,0,0),(4139,379,'可大乡',3,'',0,1,0,0),(4140,379,'后坪坝乡',3,'',0,1,0,0),(4141,379,'后溪镇',3,'',0,1,0,0),(4142,379,'大溪镇',3,'',0,1,0,0),(4143,379,'天馆乡',3,'',0,1,0,0),(4144,379,'官清乡',3,'',0,1,0,0),(4145,379,'宜居乡',3,'',0,1,0,0),(4146,379,'小河镇',3,'',0,1,0,0),(4147,379,'庙溪乡',3,'',0,1,0,0),(4148,379,'木叶乡',3,'',0,1,0,0),(4149,379,'李溪镇',3,'',0,1,0,0),(4150,379,'板桥乡',3,'',0,1,0,0),(4151,379,'板溪乡',3,'',0,1,0,0),(4152,379,'楠木乡',3,'',0,1,0,0),(4153,379,'毛坝乡',3,'',0,1,0,0),(4154,379,'江丰乡',3,'',0,1,0,0),(4155,379,'泔溪镇',3,'',0,1,0,0),(4156,379,'浪坪乡',3,'',0,1,0,0),(4157,379,'涂市乡',3,'',0,1,0,0),(4158,379,'清泉乡',3,'',0,1,0,0),(4159,379,'腴地乡',3,'',0,1,0,0),(4160,379,'花田乡',3,'',0,1,0,0),(4161,379,'苍岭镇',3,'',0,1,0,0),(4162,379,'车田乡',3,'',0,1,0,0),(4163,379,'酉酬镇',3,'',0,1,0,0),(4164,379,'钟多镇',3,'',0,1,0,0),(4165,379,'铜鼓乡',3,'',0,1,0,0),(4166,379,'麻旺镇',3,'',0,1,0,0),(4167,379,'黑水镇',3,'',0,1,0,0),(4168,379,'龙潭镇',3,'',0,1,0,0),(4169,379,'龚滩镇',3,'',0,1,0,0),(4170,380,'万足乡',3,'',0,1,0,0),(4171,380,'三义乡',3,'',0,1,0,0),(4172,380,'乔梓乡',3,'',0,1,0,0),(4173,380,'保家镇',3,'',0,1,0,0),(4174,380,'双龙乡',3,'',0,1,0,0),(4175,380,'善感乡',3,'',0,1,0,0),(4176,380,'大垭乡',3,'',0,1,0,0),(4177,380,'太原乡',3,'',0,1,0,0),(4178,380,'小厂乡',3,'',0,1,0,0),(4179,380,'岩东乡',3,'',0,1,0,0),(4180,380,'平安乡',3,'',0,1,0,0),(4181,380,'新田乡',3,'',0,1,0,0),(4182,380,'普子镇',3,'',0,1,0,0),(4183,380,'朗溪乡',3,'',0,1,0,0),(4184,380,'桐楼乡',3,'',0,1,0,0),(4185,380,'桑柘镇',3,'',0,1,0,0),(4186,380,'梅子垭乡',3,'',0,1,0,0),(4187,380,'棣棠乡',3,'',0,1,0,0),(4188,380,'汉葭镇',3,'',0,1,0,0),(4189,380,'润溪乡',3,'',0,1,0,0),(4190,380,'石柳乡',3,'',0,1,0,0),(4191,380,'石盘乡',3,'',0,1,0,0),(4192,380,'联合乡',3,'',0,1,0,0),(4193,380,'芦塘乡',3,'',0,1,0,0),(4194,380,'诸佛乡',3,'',0,1,0,0),(4195,380,'走马乡',3,'',0,1,0,0),(4196,380,'迁乔乡',3,'',0,1,0,0),(4197,380,'连湖镇',3,'',0,1,0,0),(4198,380,'郁山镇',3,'',0,1,0,0),(4199,380,'长滩乡',3,'',0,1,0,0),(4200,380,'靛水乡',3,'',0,1,0,0),(4201,380,'鞍子乡',3,'',0,1,0,0),(4202,380,'高谷镇',3,'',0,1,0,0),(4203,380,'鹿角镇',3,'',0,1,0,0),(4204,380,'鹿鸣乡',3,'',0,1,0,0),(4205,380,'黄家镇',3,'',0,1,0,0),(4206,380,'龙塘乡',3,'',0,1,0,0),(4207,380,'龙射镇',3,'',0,1,0,0),(4208,380,'龙溪乡',3,'',0,1,0,0),(4209,385,'双流县',3,'',0,1,0,0),(4210,385,'大邑县',3,'',0,1,0,0),(4211,385,'崇州市',3,'',0,1,0,0),(4212,385,'彭州市',3,'',0,1,0,0),(4213,385,'成华区',3,'',0,1,0,0),(4214,385,'新津县',3,'',0,1,0,0),(4215,385,'新都区',3,'',0,1,0,0),(4216,385,'武侯区',3,'',0,1,0,0),(4217,385,'温江区',3,'',0,1,0,0),(4218,385,'蒲江县',3,'',0,1,0,0),(4219,385,'邛崃市',3,'',0,1,0,0),(4220,385,'郫县',3,'',0,1,0,0),(4221,385,'都江堰市',3,'',0,1,0,0),(4222,385,'金堂县',3,'',0,1,0,0),(4223,385,'金牛区',3,'',0,1,0,0),(4224,385,'锦江区',3,'',0,1,0,0),(4225,385,'青白江区',3,'',0,1,0,0),(4226,385,'青羊区',3,'',0,1,0,0),(4227,385,'龙泉驿区',3,'',0,1,0,0),(4228,386,'大安区',3,'',0,1,0,0),(4229,386,'富顺县',3,'',0,1,0,0),(4230,386,'沿滩区',3,'',0,1,0,0),(4231,386,'自流井区',3,'',0,1,0,0),(4232,386,'荣县',3,'',0,1,0,0),(4233,386,'贡井区',3,'',0,1,0,0),(4234,387,'东区',3,'',0,1,0,0),(4235,387,'仁和区',3,'',0,1,0,0),(4236,387,'盐边县',3,'',0,1,0,0),(4237,387,'米易县',3,'',0,1,0,0),(4238,387,'西区',3,'',0,1,0,0),(4239,388,'叙永县',3,'',0,1,0,0),(4240,388,'古蔺县',3,'',0,1,0,0),(4241,388,'合江县',3,'',0,1,0,0),(4242,388,'江阳区',3,'',0,1,0,0),(4243,388,'泸县',3,'',0,1,0,0),(4244,388,'纳溪区',3,'',0,1,0,0),(4245,388,'龙马潭区',3,'',0,1,0,0),(4246,389,'中江县',3,'',0,1,0,0),(4247,389,'什邡市',3,'',0,1,0,0),(4248,389,'广汉市',3,'',0,1,0,0),(4249,389,'旌阳区',3,'',0,1,0,0),(4250,389,'绵竹市',3,'',0,1,0,0),(4251,389,'罗江县',3,'',0,1,0,0),(4252,390,'三台县',3,'',0,1,0,0),(4253,390,'北川羌族自治县',3,'',0,1,0,0),(4254,390,'安县',3,'',0,1,0,0),(4255,390,'平武县',3,'',0,1,0,0),(4256,390,'梓潼县',3,'',0,1,0,0),(4257,390,'江油市',3,'',0,1,0,0),(4258,390,'涪城区',3,'',0,1,0,0),(4259,390,'游仙区',3,'',0,1,0,0),(4260,390,'盐亭县',3,'',0,1,0,0),(4261,391,'元坝区',3,'',0,1,0,0),(4262,391,'利州区',3,'',0,1,0,0),(4263,391,'剑阁县',3,'',0,1,0,0),(4264,391,'旺苍县',3,'',0,1,0,0),(4265,391,'朝天区',3,'',0,1,0,0),(4266,391,'苍溪县',3,'',0,1,0,0),(4267,391,'青川县',3,'',0,1,0,0),(4268,392,'大英县',3,'',0,1,0,0),(4269,392,'安居区',3,'',0,1,0,0),(4270,392,'射洪县',3,'',0,1,0,0),(4271,392,'船山区',3,'',0,1,0,0),(4272,392,'蓬溪县',3,'',0,1,0,0),(4273,393,'东兴区',3,'',0,1,0,0),(4274,393,'威远县',3,'',0,1,0,0),(4275,393,'市中区',3,'',0,1,0,0),(4276,393,'资中县',3,'',0,1,0,0),(4277,393,'隆昌县',3,'',0,1,0,0),(4278,394,'五通桥区',3,'',0,1,0,0),(4279,394,'井研县',3,'',0,1,0,0),(4280,394,'夹江县',3,'',0,1,0,0),(4281,394,'峨眉山市',3,'',0,1,0,0),(4282,394,'峨边彝族自治县',3,'',0,1,0,0),(4283,394,'市中区',3,'',0,1,0,0),(4284,394,'沐川县',3,'',0,1,0,0),(4285,394,'沙湾区',3,'',0,1,0,0),(4286,394,'犍为县',3,'',0,1,0,0),(4287,394,'金口河区',3,'',0,1,0,0),(4288,394,'马边彝族自治县',3,'',0,1,0,0),(4289,395,'仪陇县',3,'',0,1,0,0),(4290,395,'南充市嘉陵区',3,'',0,1,0,0),(4291,395,'南部县',3,'',0,1,0,0),(4292,395,'嘉陵区',3,'',0,1,0,0),(4293,395,'营山县',3,'',0,1,0,0),(4294,395,'蓬安县',3,'',0,1,0,0),(4295,395,'西充县',3,'',0,1,0,0),(4296,395,'阆中市',3,'',0,1,0,0),(4297,395,'顺庆区',3,'',0,1,0,0),(4298,395,'高坪区',3,'',0,1,0,0),(4299,396,'东坡区',3,'',0,1,0,0),(4300,396,'丹棱县',3,'',0,1,0,0),(4301,396,'仁寿县',3,'',0,1,0,0),(4302,396,'彭山县',3,'',0,1,0,0),(4303,396,'洪雅县',3,'',0,1,0,0),(4304,396,'青神县',3,'',0,1,0,0),(4305,397,'兴文县',3,'',0,1,0,0),(4306,397,'南溪县',3,'',0,1,0,0),(4307,397,'宜宾县',3,'',0,1,0,0),(4308,397,'屏山县',3,'',0,1,0,0),(4309,397,'江安县',3,'',0,1,0,0),(4310,397,'珙县',3,'',0,1,0,0),(4311,397,'筠连县',3,'',0,1,0,0),(4312,397,'翠屏区',3,'',0,1,0,0),(4313,397,'长宁县',3,'',0,1,0,0),(4314,397,'高县',3,'',0,1,0,0),(4315,398,'华蓥市',3,'',0,1,0,0),(4316,398,'岳池县',3,'',0,1,0,0),(4317,398,'广安区',3,'',0,1,0,0),(4318,398,'武胜县',3,'',0,1,0,0),(4319,398,'邻水县',3,'',0,1,0,0),(4320,399,'万源市',3,'',0,1,0,0),(4321,399,'大竹县',3,'',0,1,0,0),(4322,399,'宣汉县',3,'',0,1,0,0),(4323,399,'开江县',3,'',0,1,0,0),(4324,399,'渠县',3,'',0,1,0,0),(4325,399,'达县',3,'',0,1,0,0),(4326,399,'通川区',3,'',0,1,0,0),(4327,400,'名山县',3,'',0,1,0,0),(4328,400,'天全县',3,'',0,1,0,0),(4329,400,'宝兴县',3,'',0,1,0,0),(4330,400,'汉源县',3,'',0,1,0,0),(4331,400,'石棉县',3,'',0,1,0,0),(4332,400,'芦山县',3,'',0,1,0,0),(4333,400,'荥经县',3,'',0,1,0,0),(4334,400,'雨城区',3,'',0,1,0,0),(4335,401,'南江县',3,'',0,1,0,0),(4336,401,'巴州区',3,'',0,1,0,0),(4337,401,'平昌县',3,'',0,1,0,0),(4338,401,'通江县',3,'',0,1,0,0),(4339,402,'乐至县',3,'',0,1,0,0),(4340,402,'安岳县',3,'',0,1,0,0),(4341,402,'简阳市',3,'',0,1,0,0),(4342,402,'雁江区',3,'',0,1,0,0),(4343,403,'九寨沟县',3,'',0,1,0,0),(4344,403,'壤塘县',3,'',0,1,0,0),(4345,403,'小金县',3,'',0,1,0,0),(4346,403,'松潘县',3,'',0,1,0,0),(4347,403,'汶川县',3,'',0,1,0,0),(4348,403,'理县',3,'',0,1,0,0),(4349,403,'红原县',3,'',0,1,0,0),(4350,403,'若尔盖县',3,'',0,1,0,0),(4351,403,'茂县',3,'',0,1,0,0),(4352,403,'金川县',3,'',0,1,0,0),(4353,403,'阿坝县',3,'',0,1,0,0),(4354,403,'马尔康县',3,'',0,1,0,0),(4355,403,'黑水县',3,'',0,1,0,0),(4356,404,'丹巴县',3,'',0,1,0,0),(4357,404,'乡城县',3,'',0,1,0,0),(4358,404,'巴塘县',3,'',0,1,0,0),(4359,404,'康定县',3,'',0,1,0,0),(4360,404,'得荣县',3,'',0,1,0,0),(4361,404,'德格县',3,'',0,1,0,0),(4362,404,'新龙县',3,'',0,1,0,0),(4363,404,'泸定县',3,'',0,1,0,0),(4364,404,'炉霍县',3,'',0,1,0,0),(4365,404,'理塘县',3,'',0,1,0,0),(4366,404,'甘孜县',3,'',0,1,0,0),(4367,404,'白玉县',3,'',0,1,0,0),(4368,404,'石渠县',3,'',0,1,0,0),(4369,404,'稻城县',3,'',0,1,0,0),(4370,404,'色达县',3,'',0,1,0,0),(4371,404,'道孚县',3,'',0,1,0,0),(4372,404,'雅江县',3,'',0,1,0,0),(4373,405,'会东县',3,'',0,1,0,0),(4374,405,'会理县',3,'',0,1,0,0),(4375,405,'冕宁县',3,'',0,1,0,0),(4376,405,'喜德县',3,'',0,1,0,0),(4377,405,'宁南县',3,'',0,1,0,0),(4378,405,'布拖县',3,'',0,1,0,0),(4379,405,'德昌县',3,'',0,1,0,0),(4380,405,'昭觉县',3,'',0,1,0,0),(4381,405,'普格县',3,'',0,1,0,0),(4382,405,'木里藏族自治县',3,'',0,1,0,0),(4383,405,'甘洛县',3,'',0,1,0,0),(4384,405,'盐源县',3,'',0,1,0,0),(4385,405,'美姑县',3,'',0,1,0,0),(4386,405,'西昌',3,'',0,1,0,0),(4387,405,'越西县',3,'',0,1,0,0),(4388,405,'金阳县',3,'',0,1,0,0),(4389,405,'雷波县',3,'',0,1,0,0),(4390,406,'乌当区',3,'',0,1,0,0),(4391,406,'云岩区',3,'',0,1,0,0),(4392,406,'修文县',3,'',0,1,0,0),(4393,406,'南明区',3,'',0,1,0,0),(4394,406,'小河区',3,'',0,1,0,0),(4395,406,'开阳县',3,'',0,1,0,0),(4396,406,'息烽县',3,'',0,1,0,0),(4397,406,'清镇市',3,'',0,1,0,0),(4398,406,'白云区',3,'',0,1,0,0),(4399,406,'花溪区',3,'',0,1,0,0),(4400,407,'六枝特区',3,'',0,1,0,0),(4401,407,'水城县',3,'',0,1,0,0),(4402,407,'盘县',3,'',0,1,0,0),(4403,407,'钟山区',3,'',0,1,0,0),(4404,408,'习水县',3,'',0,1,0,0),(4405,408,'仁怀市',3,'',0,1,0,0),(4406,408,'余庆县',3,'',0,1,0,0),(4407,408,'凤冈县',3,'',0,1,0,0),(4408,408,'务川仡佬族苗族自治县',3,'',0,1,0,0),(4409,408,'桐梓县',3,'',0,1,0,0),(4410,408,'正安县',3,'',0,1,0,0),(4411,408,'汇川区',3,'',0,1,0,0),(4412,408,'湄潭县',3,'',0,1,0,0),(4413,408,'红花岗区',3,'',0,1,0,0),(4414,408,'绥阳县',3,'',0,1,0,0),(4415,408,'赤水市',3,'',0,1,0,0),(4416,408,'道真仡佬族苗族自治县',3,'',0,1,0,0),(4417,408,'遵义县',3,'',0,1,0,0),(4418,409,'关岭布依族苗族自治县',3,'',0,1,0,0),(4419,409,'平坝县',3,'',0,1,0,0),(4420,409,'普定县',3,'',0,1,0,0),(4421,409,'紫云苗族布依族自治县',3,'',0,1,0,0),(4422,409,'西秀区',3,'',0,1,0,0),(4423,409,'镇宁布依族苗族自治县',3,'',0,1,0,0),(4424,410,'万山特区',3,'',0,1,0,0),(4425,410,'印江土家族苗族自治县',3,'',0,1,0,0),(4426,410,'德江县',3,'',0,1,0,0),(4427,410,'思南县',3,'',0,1,0,0),(4428,410,'松桃苗族自治县',3,'',0,1,0,0),(4429,410,'江口县',3,'',0,1,0,0),(4430,410,'沿河土家族自治县',3,'',0,1,0,0),(4431,410,'玉屏侗族自治县',3,'',0,1,0,0),(4432,410,'石阡县',3,'',0,1,0,0),(4433,410,'铜仁市',3,'',0,1,0,0),(4434,411,'兴义市',3,'',0,1,0,0),(4435,411,'兴仁县',3,'',0,1,0,0),(4436,411,'册亨县',3,'',0,1,0,0),(4437,411,'安龙县',3,'',0,1,0,0),(4438,411,'普安县',3,'',0,1,0,0),(4439,411,'晴隆县',3,'',0,1,0,0),(4440,411,'望谟县',3,'',0,1,0,0),(4441,411,'贞丰县',3,'',0,1,0,0),(4442,412,'大方县',3,'',0,1,0,0),(4443,412,'威宁彝族回族苗族自治县',3,'',0,1,0,0),(4444,412,'毕节市',3,'',0,1,0,0),(4445,412,'纳雍县',3,'',0,1,0,0),(4446,412,'织金县',3,'',0,1,0,0),(4447,412,'赫章县',3,'',0,1,0,0),(4448,412,'金沙县',3,'',0,1,0,0),(4449,412,'黔西县',3,'',0,1,0,0),(4450,413,'三穗县',3,'',0,1,0,0),(4451,413,'丹寨县',3,'',0,1,0,0),(4452,413,'从江县',3,'',0,1,0,0),(4453,413,'凯里市',3,'',0,1,0,0),(4454,413,'剑河县',3,'',0,1,0,0),(4455,413,'台江县',3,'',0,1,0,0),(4456,413,'天柱县',3,'',0,1,0,0),(4457,413,'岑巩县',3,'',0,1,0,0),(4458,413,'施秉县',3,'',0,1,0,0),(4459,413,'榕江县',3,'',0,1,0,0),(4460,413,'锦屏县',3,'',0,1,0,0),(4461,413,'镇远县',3,'',0,1,0,0),(4462,413,'雷山县',3,'',0,1,0,0),(4463,413,'麻江县',3,'',0,1,0,0),(4464,413,'黄平县',3,'',0,1,0,0),(4465,413,'黎平县',3,'',0,1,0,0),(4466,414,'三都水族自治县',3,'',0,1,0,0),(4467,414,'平塘县',3,'',0,1,0,0),(4468,414,'惠水县',3,'',0,1,0,0),(4469,414,'独山县',3,'',0,1,0,0),(4470,414,'瓮安县',3,'',0,1,0,0),(4471,414,'福泉市',3,'',0,1,0,0),(4472,414,'罗甸县',3,'',0,1,0,0),(4473,414,'荔波县',3,'',0,1,0,0),(4474,414,'贵定县',3,'',0,1,0,0),(4475,414,'都匀市',3,'',0,1,0,0),(4476,414,'长顺县',3,'',0,1,0,0),(4477,414,'龙里县',3,'',0,1,0,0),(4478,415,'东川区',3,'',0,1,0,0),(4479,415,'五华区',3,'',0,1,0,0),(4480,415,'呈贡县',3,'',0,1,0,0),(4481,415,'安宁市',3,'',0,1,0,0),(4482,415,'官渡区',3,'',0,1,0,0),(4483,415,'宜良县',3,'',0,1,0,0),(4484,415,'富民县',3,'',0,1,0,0),(4485,415,'寻甸回族彝族自治县',3,'',0,1,0,0),(4486,415,'嵩明县',3,'',0,1,0,0),(4487,415,'晋宁县',3,'',0,1,0,0),(4488,415,'盘龙区',3,'',0,1,0,0),(4489,415,'石林彝族自治县',3,'',0,1,0,0),(4490,415,'禄劝彝族苗族自治县',3,'',0,1,0,0),(4491,415,'西山区',3,'',0,1,0,0),(4492,416,'会泽县',3,'',0,1,0,0),(4493,416,'宣威市',3,'',0,1,0,0),(4494,416,'富源县',3,'',0,1,0,0),(4495,416,'师宗县',3,'',0,1,0,0),(4496,416,'沾益县',3,'',0,1,0,0),(4497,416,'罗平县',3,'',0,1,0,0),(4498,416,'陆良县',3,'',0,1,0,0),(4499,416,'马龙县',3,'',0,1,0,0),(4500,416,'麒麟区',3,'',0,1,0,0),(4501,417,'元江哈尼族彝族傣族自治县',3,'',0,1,0,0),(4502,417,'华宁县',3,'',0,1,0,0),(4503,417,'峨山彝族自治县',3,'',0,1,0,0),(4504,417,'新平彝族傣族自治县',3,'',0,1,0,0),(4505,417,'易门县',3,'',0,1,0,0),(4506,417,'江川县',3,'',0,1,0,0),(4507,417,'澄江县',3,'',0,1,0,0),(4508,417,'红塔区',3,'',0,1,0,0),(4509,417,'通海县',3,'',0,1,0,0),(4510,418,'施甸县',3,'',0,1,0,0),(4511,418,'昌宁县',3,'',0,1,0,0),(4512,418,'腾冲县',3,'',0,1,0,0),(4513,418,'隆阳区',3,'',0,1,0,0),(4514,418,'龙陵县',3,'',0,1,0,0),(4515,419,'大关县',3,'',0,1,0,0),(4516,419,'威信县',3,'',0,1,0,0),(4517,419,'巧家县',3,'',0,1,0,0),(4518,419,'彝良县',3,'',0,1,0,0),(4519,419,'昭阳区',3,'',0,1,0,0),(4520,419,'水富县',3,'',0,1,0,0),(4521,419,'永善县',3,'',0,1,0,0),(4522,419,'盐津县',3,'',0,1,0,0),(4523,419,'绥江县',3,'',0,1,0,0),(4524,419,'镇雄县',3,'',0,1,0,0),(4525,419,'鲁甸县',3,'',0,1,0,0),(4526,420,'华坪县',3,'',0,1,0,0),(4527,420,'古城区',3,'',0,1,0,0),(4528,420,'宁蒗彝族自治县',3,'',0,1,0,0),(4529,420,'永胜县',3,'',0,1,0,0),(4530,420,'玉龙纳西族自治县',3,'',0,1,0,0),(4531,422,'临翔区',3,'',0,1,0,0),(4532,422,'云县',3,'',0,1,0,0),(4533,422,'凤庆县',3,'',0,1,0,0),(4534,422,'双江拉祜族佤族布朗族傣族自治县',3,'',0,1,0,0),(4535,422,'永德县',3,'',0,1,0,0),(4536,422,'沧源佤族自治县',3,'',0,1,0,0),(4537,422,'耿马傣族佤族自治县',3,'',0,1,0,0),(4538,422,'镇康县',3,'',0,1,0,0),(4539,423,'元谋县',3,'',0,1,0,0),(4540,423,'南华县',3,'',0,1,0,0),(4541,423,'双柏县',3,'',0,1,0,0),(4542,423,'大姚县',3,'',0,1,0,0),(4543,423,'姚安县',3,'',0,1,0,0),(4544,423,'楚雄市',3,'',0,1,0,0),(4545,423,'武定县',3,'',0,1,0,0),(4546,423,'永仁县',3,'',0,1,0,0),(4547,423,'牟定县',3,'',0,1,0,0),(4548,423,'禄丰县',3,'',0,1,0,0),(4549,424,'个旧市',3,'',0,1,0,0),(4550,424,'元阳县',3,'',0,1,0,0),(4551,424,'屏边苗族自治县',3,'',0,1,0,0),(4552,424,'建水县',3,'',0,1,0,0),(4553,424,'开远市',3,'',0,1,0,0),(4554,424,'弥勒县',3,'',0,1,0,0),(4555,424,'河口瑶族自治县',3,'',0,1,0,0),(4556,424,'泸西县',3,'',0,1,0,0),(4557,424,'石屏县',3,'',0,1,0,0),(4558,424,'红河县',3,'',0,1,0,0),(4559,424,'绿春县',3,'',0,1,0,0),(4560,424,'蒙自县',3,'',0,1,0,0),(4561,424,'金平苗族瑶族傣族自治县',3,'',0,1,0,0),(4562,425,'丘北县',3,'',0,1,0,0),(4563,425,'富宁县',3,'',0,1,0,0),(4564,425,'广南县',3,'',0,1,0,0),(4565,425,'文山县',3,'',0,1,0,0),(4566,425,'砚山县',3,'',0,1,0,0),(4567,425,'西畴县',3,'',0,1,0,0),(4568,425,'马关县',3,'',0,1,0,0),(4569,425,'麻栗坡县',3,'',0,1,0,0),(4570,426,'勐海县',3,'',0,1,0,0),(4571,426,'勐腊县',3,'',0,1,0,0),(4572,426,'景洪市',3,'',0,1,0,0),(4573,427,'云龙县',3,'',0,1,0,0),(4574,427,'剑川县',3,'',0,1,0,0),(4575,427,'南涧彝族自治县',3,'',0,1,0,0),(4576,427,'大理市',3,'',0,1,0,0),(4577,427,'宾川县',3,'',0,1,0,0),(4578,427,'巍山彝族回族自治县',3,'',0,1,0,0),(4579,427,'弥渡县',3,'',0,1,0,0),(4580,427,'永平县',3,'',0,1,0,0),(4581,427,'洱源县',3,'',0,1,0,0),(4582,427,'漾濞彝族自治县',3,'',0,1,0,0),(4583,427,'祥云县',3,'',0,1,0,0),(4584,427,'鹤庆县',3,'',0,1,0,0),(4585,428,'梁河县',3,'',0,1,0,0),(4586,428,'潞西市',3,'',0,1,0,0),(4587,428,'瑞丽市',3,'',0,1,0,0),(4588,428,'盈江县',3,'',0,1,0,0),(4589,428,'陇川县',3,'',0,1,0,0),(4590,430,'德钦县',3,'',0,1,0,0),(4591,430,'维西傈僳族自治县',3,'',0,1,0,0),(4592,430,'香格里拉县',3,'',0,1,0,0),(4593,431,'城关区',3,'',0,1,0,0),(4594,431,'堆龙德庆县',3,'',0,1,0,0),(4595,431,'墨竹工卡县',3,'',0,1,0,0),(4596,431,'尼木县',3,'',0,1,0,0),(4597,431,'当雄县',3,'',0,1,0,0),(4598,431,'曲水县',3,'',0,1,0,0),(4599,431,'林周县',3,'',0,1,0,0),(4600,431,'达孜县',3,'',0,1,0,0),(4601,432,'丁青县',3,'',0,1,0,0),(4602,432,'八宿县',3,'',0,1,0,0),(4603,432,'察雅县',3,'',0,1,0,0),(4604,432,'左贡县',3,'',0,1,0,0),(4605,432,'昌都县',3,'',0,1,0,0),(4606,432,'江达县',3,'',0,1,0,0),(4607,432,'洛隆县',3,'',0,1,0,0),(4608,432,'类乌齐县',3,'',0,1,0,0),(4609,432,'芒康县',3,'',0,1,0,0),(4610,432,'贡觉县',3,'',0,1,0,0),(4611,432,'边坝县',3,'',0,1,0,0),(4612,433,'乃东县',3,'',0,1,0,0),(4613,433,'加查县',3,'',0,1,0,0),(4614,433,'扎囊县',3,'',0,1,0,0),(4615,433,'措美县',3,'',0,1,0,0),(4616,433,'曲松县',3,'',0,1,0,0),(4617,433,'桑日县',3,'',0,1,0,0),(4618,433,'洛扎县',3,'',0,1,0,0),(4619,433,'浪卡子县',3,'',0,1,0,0),(4620,433,'琼结县',3,'',0,1,0,0),(4621,433,'贡嘎县',3,'',0,1,0,0),(4622,433,'错那县',3,'',0,1,0,0),(4623,433,'隆子县',3,'',0,1,0,0),(4624,434,'亚东县',3,'',0,1,0,0),(4625,434,'仁布县',3,'',0,1,0,0),(4626,434,'仲巴县',3,'',0,1,0,0),(4627,434,'南木林县',3,'',0,1,0,0),(4628,434,'吉隆县',3,'',0,1,0,0),(4629,434,'定日县',3,'',0,1,0,0),(4630,434,'定结县',3,'',0,1,0,0),(4631,434,'岗巴县',3,'',0,1,0,0),(4632,434,'康马县',3,'',0,1,0,0),(4633,434,'拉孜县',3,'',0,1,0,0),(4634,434,'日喀则市',3,'',0,1,0,0),(4635,434,'昂仁县',3,'',0,1,0,0),(4636,434,'江孜县',3,'',0,1,0,0),(4637,434,'白朗县',3,'',0,1,0,0),(4638,434,'聂拉木县',3,'',0,1,0,0),(4639,434,'萨嘎县',3,'',0,1,0,0),(4640,434,'萨迦县',3,'',0,1,0,0),(4641,434,'谢通门县',3,'',0,1,0,0),(4642,435,'嘉黎县',3,'',0,1,0,0),(4643,435,'安多县',3,'',0,1,0,0),(4644,435,'尼玛县',3,'',0,1,0,0),(4645,435,'巴青县',3,'',0,1,0,0),(4646,435,'比如县',3,'',0,1,0,0),(4647,435,'班戈县',3,'',0,1,0,0),(4648,435,'申扎县',3,'',0,1,0,0),(4649,435,'索县',3,'',0,1,0,0),(4650,435,'聂荣县',3,'',0,1,0,0),(4651,435,'那曲县',3,'',0,1,0,0),(4652,436,'噶尔县',3,'',0,1,0,0),(4653,436,'措勤县',3,'',0,1,0,0),(4654,436,'改则县',3,'',0,1,0,0),(4655,436,'日土县',3,'',0,1,0,0),(4656,436,'普兰县',3,'',0,1,0,0),(4657,436,'札达县',3,'',0,1,0,0),(4658,436,'革吉县',3,'',0,1,0,0),(4659,437,'墨脱县',3,'',0,1,0,0),(4660,437,'察隅县',3,'',0,1,0,0),(4661,437,'工布江达县',3,'',0,1,0,0),(4662,437,'朗县',3,'',0,1,0,0),(4663,437,'林芝县',3,'',0,1,0,0),(4664,437,'波密县',3,'',0,1,0,0),(4665,437,'米林县',3,'',0,1,0,0),(4666,438,'临潼区',3,'',0,1,0,0),(4667,438,'周至县',3,'',0,1,0,0),(4668,438,'户县',3,'',0,1,0,0),(4669,438,'新城区',3,'',0,1,0,0),(4670,438,'未央区',3,'',0,1,0,0),(4671,438,'灞桥区',3,'',0,1,0,0),(4672,438,'碑林区',3,'',0,1,0,0),(4673,438,'莲湖区',3,'',0,1,0,0),(4674,438,'蓝田县',3,'',0,1,0,0),(4675,438,'长安区',3,'',0,1,0,0),(4676,438,'阎良区',3,'',0,1,0,0),(4677,438,'雁塔区',3,'',0,1,0,0),(4678,438,'高陵县',3,'',0,1,0,0),(4679,439,'印台区',3,'',0,1,0,0),(4680,439,'宜君县',3,'',0,1,0,0),(4681,439,'王益区',3,'',0,1,0,0),(4682,439,'耀州区',3,'',0,1,0,0),(4683,440,'凤县',3,'',0,1,0,0),(4684,440,'凤翔县',3,'',0,1,0,0),(4685,440,'千阳县',3,'',0,1,0,0),(4686,440,'太白县',3,'',0,1,0,0),(4687,440,'岐山县',3,'',0,1,0,0),(4688,440,'扶风县',3,'',0,1,0,0),(4689,440,'渭滨区',3,'',0,1,0,0),(4690,440,'眉县',3,'',0,1,0,0),(4691,440,'金台区',3,'',0,1,0,0),(4692,440,'陇县',3,'',0,1,0,0),(4693,440,'陈仓区',3,'',0,1,0,0),(4694,440,'麟游县',3,'',0,1,0,0),(4695,441,'三原县',3,'',0,1,0,0),(4696,441,'干县',3,'',0,1,0,0),(4697,441,'兴平市',3,'',0,1,0,0),(4698,441,'彬县',3,'',0,1,0,0),(4699,441,'旬邑县',3,'',0,1,0,0),(4700,441,'杨陵区',3,'',0,1,0,0),(4701,441,'武功县',3,'',0,1,0,0),(4702,441,'永寿县',3,'',0,1,0,0),(4703,441,'泾阳县',3,'',0,1,0,0),(4704,441,'淳化县',3,'',0,1,0,0),(4705,441,'渭城区',3,'',0,1,0,0),(4706,441,'礼泉县',3,'',0,1,0,0),(4707,441,'秦都区',3,'',0,1,0,0),(4708,441,'长武县',3,'',0,1,0,0),(4709,442,'临渭区',3,'',0,1,0,0),(4710,442,'华县',3,'',0,1,0,0),(4711,442,'华阴市',3,'',0,1,0,0),(4712,442,'合阳县',3,'',0,1,0,0),(4713,442,'大荔县',3,'',0,1,0,0),(4714,442,'富平县',3,'',0,1,0,0),(4715,442,'潼关县',3,'',0,1,0,0),(4716,442,'澄城县',3,'',0,1,0,0),(4717,442,'白水县',3,'',0,1,0,0),(4718,442,'蒲城县',3,'',0,1,0,0),(4719,442,'韩城市',3,'',0,1,0,0),(4720,443,'吴起县',3,'',0,1,0,0),(4721,443,'子长县',3,'',0,1,0,0),(4722,443,'安塞县',3,'',0,1,0,0),(4723,443,'宜川县',3,'',0,1,0,0),(4724,443,'宝塔区',3,'',0,1,0,0),(4725,443,'富县',3,'',0,1,0,0),(4726,443,'延川县',3,'',0,1,0,0),(4727,443,'延长县',3,'',0,1,0,0),(4728,443,'志丹县',3,'',0,1,0,0),(4729,443,'洛川县',3,'',0,1,0,0),(4730,443,'甘泉县',3,'',0,1,0,0),(4731,443,'黄陵县',3,'',0,1,0,0),(4732,443,'黄龙县',3,'',0,1,0,0),(4733,444,'佛坪县',3,'',0,1,0,0),(4734,444,'勉县',3,'',0,1,0,0),(4735,444,'南郑县',3,'',0,1,0,0),(4736,444,'城固县',3,'',0,1,0,0),(4737,444,'宁强县',3,'',0,1,0,0),(4738,444,'汉台区',3,'',0,1,0,0),(4739,444,'洋县',3,'',0,1,0,0),(4740,444,'留坝县',3,'',0,1,0,0),(4741,444,'略阳县',3,'',0,1,0,0),(4742,444,'西乡县',3,'',0,1,0,0),(4743,444,'镇巴县',3,'',0,1,0,0),(4744,445,'佳县',3,'',0,1,0,0),(4745,445,'吴堡县',3,'',0,1,0,0),(4746,445,'子洲县',3,'',0,1,0,0),(4747,445,'定边县',3,'',0,1,0,0),(4748,445,'府谷县',3,'',0,1,0,0),(4749,445,'榆林市榆阳区',3,'',0,1,0,0),(4750,445,'横山县',3,'',0,1,0,0),(4751,445,'清涧县',3,'',0,1,0,0),(4752,445,'神木县',3,'',0,1,0,0),(4753,445,'米脂县',3,'',0,1,0,0),(4754,445,'绥德县',3,'',0,1,0,0),(4755,445,'靖边县',3,'',0,1,0,0),(4756,446,'宁陕县',3,'',0,1,0,0),(4757,446,'岚皋县',3,'',0,1,0,0),(4758,446,'平利县',3,'',0,1,0,0),(4759,446,'旬阳县',3,'',0,1,0,0),(4760,446,'汉滨区',3,'',0,1,0,0),(4761,446,'汉阴县',3,'',0,1,0,0),(4762,446,'白河县',3,'',0,1,0,0),(4763,446,'石泉县',3,'',0,1,0,0),(4764,446,'紫阳县',3,'',0,1,0,0),(4765,446,'镇坪县',3,'',0,1,0,0),(4766,447,'丹凤县',3,'',0,1,0,0),(4767,447,'商南县',3,'',0,1,0,0),(4768,447,'商州区',3,'',0,1,0,0),(4769,447,'山阳县',3,'',0,1,0,0),(4770,447,'柞水县',3,'',0,1,0,0),(4771,447,'洛南县',3,'',0,1,0,0),(4772,447,'镇安县',3,'',0,1,0,0),(4773,448,'七里河区',3,'',0,1,0,0),(4774,448,'城关区',3,'',0,1,0,0),(4775,448,'安宁区',3,'',0,1,0,0),(4776,448,'榆中县',3,'',0,1,0,0),(4777,448,'永登县',3,'',0,1,0,0),(4778,448,'皋兰县',3,'',0,1,0,0),(4779,448,'红古区',3,'',0,1,0,0),(4780,448,'西固区',3,'',0,1,0,0),(4781,449,'嘉峪关市',3,'',0,1,0,0),(4782,450,'永昌县',3,'',0,1,0,0),(4783,450,'金川区',3,'',0,1,0,0),(4784,451,'会宁县',3,'',0,1,0,0),(4785,451,'平川区',3,'',0,1,0,0),(4786,451,'景泰县',3,'',0,1,0,0),(4787,451,'白银区',3,'',0,1,0,0),(4788,451,'靖远县',3,'',0,1,0,0),(4789,452,'张家川回族自治县',3,'',0,1,0,0),(4790,452,'武山县',3,'',0,1,0,0),(4791,452,'清水县',3,'',0,1,0,0),(4792,452,'甘谷县',3,'',0,1,0,0),(4793,452,'秦安县',3,'',0,1,0,0),(4794,452,'秦州区',3,'',0,1,0,0),(4795,452,'麦积区',3,'',0,1,0,0),(4796,453,'凉州区',3,'',0,1,0,0),(4797,453,'古浪县',3,'',0,1,0,0),(4798,453,'天祝藏族自治县',3,'',0,1,0,0),(4799,453,'民勤县',3,'',0,1,0,0),(4800,454,'临泽县',3,'',0,1,0,0),(4801,454,'山丹县',3,'',0,1,0,0),(4802,454,'民乐县',3,'',0,1,0,0),(4803,454,'甘州区',3,'',0,1,0,0),(4804,454,'肃南裕固族自治县',3,'',0,1,0,0),(4805,454,'高台县',3,'',0,1,0,0),(4806,455,'华亭县',3,'',0,1,0,0),(4807,455,'崆峒区',3,'',0,1,0,0),(4808,455,'崇信县',3,'',0,1,0,0),(4809,455,'庄浪县',3,'',0,1,0,0),(4810,455,'泾川县',3,'',0,1,0,0),(4811,455,'灵台县',3,'',0,1,0,0),(4812,455,'静宁县',3,'',0,1,0,0),(4813,456,'敦煌市',3,'',0,1,0,0),(4814,456,'玉门市',3,'',0,1,0,0),(4815,456,'瓜州县（原安西县）',3,'',0,1,0,0),(4816,456,'肃北蒙古族自治县',3,'',0,1,0,0),(4817,456,'肃州区',3,'',0,1,0,0),(4818,456,'金塔县',3,'',0,1,0,0),(4819,456,'阿克塞哈萨克族自治县',3,'',0,1,0,0),(4820,457,'华池县',3,'',0,1,0,0),(4821,457,'合水县',3,'',0,1,0,0),(4822,457,'宁县',3,'',0,1,0,0),(4823,457,'庆城县',3,'',0,1,0,0),(4824,457,'正宁县',3,'',0,1,0,0),(4825,457,'环县',3,'',0,1,0,0),(4826,457,'西峰区',3,'',0,1,0,0),(4827,457,'镇原县',3,'',0,1,0,0),(4828,458,'临洮县',3,'',0,1,0,0),(4829,458,'安定区',3,'',0,1,0,0),(4830,458,'岷县',3,'',0,1,0,0),(4831,458,'渭源县',3,'',0,1,0,0),(4832,458,'漳县',3,'',0,1,0,0),(4833,458,'通渭县',3,'',0,1,0,0),(4834,458,'陇西县',3,'',0,1,0,0),(4835,459,'两当县',3,'',0,1,0,0),(4836,459,'宕昌县',3,'',0,1,0,0),(4837,459,'康县',3,'',0,1,0,0),(4838,459,'徽县',3,'',0,1,0,0),(4839,459,'成县',3,'',0,1,0,0),(4840,459,'文县',3,'',0,1,0,0),(4841,459,'武都区',3,'',0,1,0,0),(4842,459,'礼县',3,'',0,1,0,0),(4843,459,'西和县',3,'',0,1,0,0),(4844,460,'东乡族自治县',3,'',0,1,0,0),(4845,460,'临夏县',3,'',0,1,0,0),(4846,460,'临夏市',3,'',0,1,0,0),(4847,460,'和政县',3,'',0,1,0,0),(4848,460,'广河县',3,'',0,1,0,0),(4849,460,'康乐县',3,'',0,1,0,0),(4850,460,'永靖县',3,'',0,1,0,0),(4851,460,'积石山保安族东乡族撒拉族自治县',3,'',0,1,0,0),(4852,461,'临潭县',3,'',0,1,0,0),(4853,461,'卓尼县',3,'',0,1,0,0),(4854,461,'合作市',3,'',0,1,0,0),(4855,461,'夏河县',3,'',0,1,0,0),(4856,461,'玛曲县',3,'',0,1,0,0),(4857,461,'碌曲县',3,'',0,1,0,0),(4858,461,'舟曲县',3,'',0,1,0,0),(4859,461,'迭部县',3,'',0,1,0,0),(4860,462,'城东区',3,'',0,1,0,0),(4861,462,'城中区',3,'',0,1,0,0),(4862,462,'城北区',3,'',0,1,0,0),(4863,462,'城西区',3,'',0,1,0,0),(4864,462,'大通回族土族自治县',3,'',0,1,0,0),(4865,462,'湟中县',3,'',0,1,0,0),(4866,462,'湟源县',3,'',0,1,0,0),(4867,463,'乐都县',3,'',0,1,0,0),(4868,463,'互助土族自治县',3,'',0,1,0,0),(4869,463,'化隆回族自治县',3,'',0,1,0,0),(4870,463,'平安县',3,'',0,1,0,0),(4871,463,'循化撒拉族自治县',3,'',0,1,0,0),(4872,463,'民和回族土族自治县',3,'',0,1,0,0),(4873,464,'刚察县',3,'',0,1,0,0),(4874,464,'海晏县',3,'',0,1,0,0),(4875,464,'祁连县',3,'',0,1,0,0),(4876,464,'门源回族自治县',3,'',0,1,0,0),(4877,465,'同仁县',3,'',0,1,0,0),(4878,465,'尖扎县',3,'',0,1,0,0),(4879,465,'河南蒙古族自治县',3,'',0,1,0,0),(4880,465,'泽库县',3,'',0,1,0,0),(4881,466,'共和县',3,'',0,1,0,0),(4882,466,'兴海县',3,'',0,1,0,0),(4883,466,'同德县',3,'',0,1,0,0),(4884,466,'贵南县',3,'',0,1,0,0),(4885,466,'贵德县',3,'',0,1,0,0),(4886,467,'久治县',3,'',0,1,0,0),(4887,467,'玛多县',3,'',0,1,0,0),(4888,467,'玛沁县',3,'',0,1,0,0),(4889,467,'班玛县',3,'',0,1,0,0),(4890,467,'甘德县',3,'',0,1,0,0),(4891,467,'达日县',3,'',0,1,0,0),(4892,468,'囊谦县',3,'',0,1,0,0),(4893,468,'曲麻莱县',3,'',0,1,0,0),(4894,468,'杂多县',3,'',0,1,0,0),(4895,468,'治多县',3,'',0,1,0,0),(4896,468,'玉树县',3,'',0,1,0,0),(4897,468,'称多县',3,'',0,1,0,0),(4898,469,'乌兰县',3,'',0,1,0,0),(4899,469,'冷湖行委',3,'',0,1,0,0),(4900,469,'大柴旦行委',3,'',0,1,0,0),(4901,469,'天峻县',3,'',0,1,0,0),(4902,469,'德令哈市',3,'',0,1,0,0),(4903,469,'格尔木市',3,'',0,1,0,0),(4904,469,'茫崖行委',3,'',0,1,0,0),(4905,469,'都兰县',3,'',0,1,0,0),(4906,470,'兴庆区',3,'',0,1,0,0),(4907,470,'永宁县',3,'',0,1,0,0),(4908,470,'灵武市',3,'',0,1,0,0),(4909,470,'西夏区',3,'',0,1,0,0),(4910,470,'贺兰县',3,'',0,1,0,0),(4911,470,'金凤区',3,'',0,1,0,0),(4912,471,'大武口区',3,'',0,1,0,0),(4913,471,'平罗县',3,'',0,1,0,0),(4914,471,'惠农区',3,'',0,1,0,0),(4915,472,'利通区',3,'',0,1,0,0),(4916,472,'同心县',3,'',0,1,0,0),(4917,472,'盐池县',3,'',0,1,0,0),(4918,472,'青铜峡市',3,'',0,1,0,0),(4919,473,'原州区',3,'',0,1,0,0),(4920,473,'彭阳县',3,'',0,1,0,0),(4921,473,'泾源县',3,'',0,1,0,0),(4922,473,'西吉县',3,'',0,1,0,0),(4923,473,'隆德县',3,'',0,1,0,0),(4924,474,'中宁县',3,'',0,1,0,0),(4925,474,'沙坡头区',3,'',0,1,0,0),(4926,474,'海原县',3,'',0,1,0,0),(4927,475,'东山区',3,'',0,1,0,0),(4928,475,'乌鲁木齐县',3,'',0,1,0,0),(4929,475,'天山区',3,'',0,1,0,0),(4930,475,'头屯河区',3,'',0,1,0,0),(4931,475,'新市区',3,'',0,1,0,0),(4932,475,'水磨沟区',3,'',0,1,0,0),(4933,475,'沙依巴克区',3,'',0,1,0,0),(4934,475,'达坂城区',3,'',0,1,0,0),(4935,476,'乌尔禾区',3,'',0,1,0,0),(4936,476,'克拉玛依区',3,'',0,1,0,0),(4937,476,'独山子区',3,'',0,1,0,0),(4938,476,'白碱滩区',3,'',0,1,0,0),(4939,477,'吐鲁番市',3,'',0,1,0,0),(4940,477,'托克逊县',3,'',0,1,0,0),(4941,477,'鄯善县',3,'',0,1,0,0),(4942,478,'伊吾县',3,'',0,1,0,0),(4943,478,'哈密市',3,'',0,1,0,0),(4944,478,'巴里坤哈萨克自治县',3,'',0,1,0,0),(4945,479,'吉木萨尔县',3,'',0,1,0,0),(4946,479,'呼图壁县',3,'',0,1,0,0),(4947,479,'奇台县',3,'',0,1,0,0),(4948,479,'昌吉市',3,'',0,1,0,0),(4949,479,'木垒哈萨克自治县',3,'',0,1,0,0),(4950,479,'玛纳斯县',3,'',0,1,0,0),(4951,479,'米泉市',3,'',0,1,0,0),(4952,479,'阜康市',3,'',0,1,0,0),(4953,480,'博乐市',3,'',0,1,0,0),(4954,480,'温泉县',3,'',0,1,0,0),(4955,480,'精河县',3,'',0,1,0,0),(4956,481,'博湖县',3,'',0,1,0,0),(4957,481,'和硕县',3,'',0,1,0,0),(4958,481,'和静县',3,'',0,1,0,0),(4959,481,'尉犁县',3,'',0,1,0,0),(4960,481,'库尔勒市',3,'',0,1,0,0),(4961,481,'焉耆回族自治县',3,'',0,1,0,0),(4962,481,'若羌县',3,'',0,1,0,0),(4963,481,'轮台县',3,'',0,1,0,0),(4964,482,'乌什县',3,'',0,1,0,0),(4965,482,'库车县',3,'',0,1,0,0),(4966,482,'拜城县',3,'',0,1,0,0),(4967,482,'新和县',3,'',0,1,0,0),(4968,482,'柯坪县',3,'',0,1,0,0),(4969,482,'沙雅县',3,'',0,1,0,0),(4970,482,'温宿县',3,'',0,1,0,0),(4971,482,'阿克苏市',3,'',0,1,0,0),(4972,482,'阿瓦提县',3,'',0,1,0,0),(4973,483,'乌恰县',3,'',0,1,0,0),(4974,483,'阿克陶县',3,'',0,1,0,0),(4975,483,'阿合奇县',3,'',0,1,0,0),(4976,483,'阿图什市',3,'',0,1,0,0),(4977,484,'伽师县',3,'',0,1,0,0),(4978,484,'叶城县',3,'',0,1,0,0),(4979,484,'喀什市',3,'',0,1,0,0),(4980,484,'塔什库尔干塔吉克自治县',3,'',0,1,0,0),(4981,484,'岳普湖县',3,'',0,1,0,0),(4982,484,'巴楚县',3,'',0,1,0,0),(4983,484,'泽普县',3,'',0,1,0,0),(4984,484,'疏勒县',3,'',0,1,0,0),(4985,484,'疏附县',3,'',0,1,0,0),(4986,484,'英吉沙县',3,'',0,1,0,0),(4987,484,'莎车县',3,'',0,1,0,0),(4988,484,'麦盖提县',3,'',0,1,0,0),(4989,485,'于田县',3,'',0,1,0,0),(4990,485,'和田县',3,'',0,1,0,0),(4991,485,'和田市',3,'',0,1,0,0),(4992,485,'墨玉县',3,'',0,1,0,0),(4993,485,'民丰县',3,'',0,1,0,0),(4994,485,'洛浦县',3,'',0,1,0,0),(4995,485,'皮山县',3,'',0,1,0,0),(4996,485,'策勒县',3,'',0,1,0,0),(4997,486,'伊宁县',3,'',0,1,0,0),(4998,486,'伊宁市',3,'',0,1,0,0),(4999,486,'奎屯市',3,'',0,1,0,0),(5000,486,'察布查尔锡伯自治县',3,'',0,1,0,0),(5001,486,'尼勒克县',3,'',0,1,0,0),(5002,486,'巩留县',3,'',0,1,0,0),(5003,486,'新源县',3,'',0,1,0,0),(5004,486,'昭苏县',3,'',0,1,0,0),(5005,486,'特克斯县',3,'',0,1,0,0),(5006,486,'霍城县',3,'',0,1,0,0),(5007,487,'乌苏市',3,'',0,1,0,0),(5008,487,'和布克赛尔蒙古自治县',3,'',0,1,0,0),(5009,487,'塔城市',3,'',0,1,0,0),(5010,487,'托里县',3,'',0,1,0,0),(5011,487,'沙湾县',3,'',0,1,0,0),(5012,487,'裕民县',3,'',0,1,0,0),(5013,487,'额敏县',3,'',0,1,0,0),(5014,488,'吉木乃县',3,'',0,1,0,0),(5015,488,'哈巴河县',3,'',0,1,0,0),(5016,488,'富蕴县',3,'',0,1,0,0),(5017,488,'布尔津县',3,'',0,1,0,0),(5018,488,'福海县',3,'',0,1,0,0),(5019,488,'阿勒泰市',3,'',0,1,0,0),(5020,488,'青河县',3,'',0,1,0,0),(5021,489,'石河子市',3,'',0,1,0,0),(5022,490,'阿拉尔市',3,'',0,1,0,0),(5023,491,'图木舒克市',3,'',0,1,0,0),(5024,492,'五家渠市',3,'',0,1,0,0),(5025,1126,'上安镇',4,'',0,1,0,0),(5026,1126,'于家乡',4,'',0,1,0,0),(5027,1126,'北正乡',4,'',0,1,0,0),(5028,1126,'南峪镇',4,'',0,1,0,0),(5029,1126,'南王庄乡',4,'',0,1,0,0),(5030,1126,'南陉乡',4,'',0,1,0,0),(5031,1126,'南障城镇',4,'',0,1,0,0),(5032,1126,'吴家窑乡',4,'',0,1,0,0),(5033,1126,'天长镇',4,'',0,1,0,0),(5034,1126,'威州镇',4,'',0,1,0,0),(5035,1126,'孙庄乡',4,'',0,1,0,0),(5036,1126,'小作镇',4,'',0,1,0,0),(5037,1126,'微水镇',4,'',0,1,0,0),(5038,1126,'测鱼镇',4,'',0,1,0,0),(5039,1126,'秀林镇',4,'',0,1,0,0),(5040,1126,'苍岩山镇',4,'',0,1,0,0),(5041,1126,'辛庄乡',4,'',0,1,0,0),(5042,1127,'凤山镇',4,'',0,1,0,0),(5043,1127,'四微街道',4,'',0,1,0,0),(5044,1127,'横涧乡',4,'',0,1,0,0),(5045,1127,'矿市街道',4,'',0,1,0,0),(5046,1127,'贾庄镇',4,'',0,1,0,0),(5047,1128,'东张乡',4,'',0,1,0,0),(5048,1128,'前仙乡',4,'',0,1,0,0),(5049,1128,'北正乡',4,'',0,1,0,0),(5050,1128,'北褚乡',4,'',0,1,0,0),(5051,1128,'南佐镇',4,'',0,1,0,0),(5052,1128,'南因镇',4,'',0,1,0,0),(5053,1128,'姬村镇',4,'',0,1,0,0),(5054,1128,'宋曹镇',4,'',0,1,0,0),(5055,1128,'槐阳镇',4,'',0,1,0,0),(5056,1128,'殷村镇',4,'',0,1,0,0),(5057,1128,'苏村乡',4,'',0,1,0,0),(5058,1128,'苏阳乡',4,'',0,1,0,0),(5059,1128,'赵同乡',4,'',0,1,0,0),(5060,1128,'马村乡',4,'',0,1,0,0),(5061,1128,'黑水河乡',4,'',0,1,0,0),(5062,1129,'上三汲乡',4,'',0,1,0,0),(5063,1129,'上观音堂乡',4,'',0,1,0,0),(5064,1129,'下口镇',4,'',0,1,0,0),(5065,1129,'下槐镇',4,'',0,1,0,0),(5066,1129,'东回舍镇',4,'',0,1,0,0),(5067,1129,'东王坡乡',4,'',0,1,0,0),(5068,1129,'两河乡',4,'',0,1,0,0),(5069,1129,'北冶乡',4,'',0,1,0,0),(5070,1129,'南甸镇',4,'',0,1,0,0),(5071,1129,'古月镇',4,'',0,1,0,0),(5072,1129,'合河口乡',4,'',0,1,0,0),(5073,1129,'孟家庄镇',4,'',0,1,0,0),(5074,1129,'宅北乡',4,'',0,1,0,0),(5075,1129,'小觉镇',4,'',0,1,0,0),(5076,1129,'岗南镇',4,'',0,1,0,0),(5077,1129,'平山镇',4,'',0,1,0,0),(5078,1129,'杨家桥乡',4,'',0,1,0,0),(5079,1129,'温塘镇',4,'',0,1,0,0),(5080,1129,'苏家庄乡',4,'',0,1,0,0),(5081,1129,'营里乡',4,'',0,1,0,0),(5082,1129,'蛟潭庄镇',4,'',0,1,0,0),(5083,1129,'西大吾乡',4,'',0,1,0,0),(5084,1129,'西柏坡镇',4,'',0,1,0,0),(5085,1130,'东王镇',4,'',0,1,0,0),(5086,1130,'化皮镇',4,'',0,1,0,0),(5087,1130,'协神乡',4,'',0,1,0,0),(5088,1130,'南大岳镇',4,'',0,1,0,0),(5089,1130,'彭家庄回族乡',4,'',0,1,0,0),(5090,1130,'承安镇',4,'',0,1,0,0),(5091,1130,'木村乡',4,'',0,1,0,0),(5092,1130,'杜固镇',4,'',0,1,0,0),(5093,1130,'正莫镇',4,'',0,1,0,0),(5094,1130,'邯邰镇',4,'',0,1,0,0),(5095,1130,'长寿街道',4,'',0,1,0,0),(5096,1130,'马头铺镇',4,'',0,1,0,0),(5097,1131,'东焦街道',4,'',0,1,0,0),(5098,1131,'五七街道',4,'',0,1,0,0),(5099,1131,'北苑街道',4,'',0,1,0,0),(5100,1131,'合作路街道',4,'',0,1,0,0),(5101,1131,'大郭镇',4,'',0,1,0,0),(5102,1131,'天苑街道',4,'',0,1,0,0),(5103,1131,'宁安街道',4,'',0,1,0,0),(5104,1131,'新华路街道',4,'',0,1,0,0),(5105,1131,'杜北乡',4,'',0,1,0,0),(5106,1131,'石岗街道',4,'',0,1,0,0),(5107,1131,'联盟街道',4,'',0,1,0,0),(5108,1131,'西三庄乡',4,'',0,1,0,0),(5109,1131,'西苑街道',4,'',0,1,0,0),(5110,1131,'赵陵铺镇',4,'',0,1,0,0),(5111,1131,'革新街道',4,'',0,1,0,0),(5112,1132,'七汲镇',4,'',0,1,0,0),(5113,1132,'东侯坊乡',4,'',0,1,0,0),(5114,1132,'北苏镇',4,'',0,1,0,0),(5115,1132,'南流乡',4,'',0,1,0,0),(5116,1132,'大陈镇',4,'',0,1,0,0),(5117,1132,'张段固镇',4,'',0,1,0,0),(5118,1132,'无极镇',4,'',0,1,0,0),(5119,1132,'郝庄乡',4,'',0,1,0,0),(5120,1132,'郭庄镇',4,'',0,1,0,0),(5121,1132,'里城道乡',4,'',0,1,0,0),(5122,1132,'高头回族乡',4,'',0,1,0,0),(5123,1133,'东卓宿镇',4,'',0,1,0,0),(5124,1133,'东里庄乡',4,'',0,1,0,0),(5125,1133,'周家庄乡',4,'',0,1,0,0),(5126,1133,'小樵镇',4,'',0,1,0,0),(5127,1133,'总十庄镇',4,'',0,1,0,0),(5128,1133,'晋州镇',4,'',0,1,0,0),(5129,1133,'桃园镇',4,'',0,1,0,0),(5130,1133,'槐树镇',4,'',0,1,0,0),(5131,1133,'营里镇',4,'',0,1,0,0),(5132,1133,'马于镇',4,'',0,1,0,0),(5133,1134,'冶河镇',4,'',0,1,0,0),(5134,1134,'南高乡',4,'',0,1,0,0),(5135,1134,'柳林屯乡',4,'',0,1,0,0),(5136,1134,'栾城镇',4,'',0,1,0,0),(5137,1134,'楼底镇',4,'',0,1,0,0),(5138,1134,'窦妪镇',4,'',0,1,0,0),(5139,1134,'西营乡',4,'',0,1,0,0),(5140,1134,'郄马镇',4,'',0,1,0,0),(5141,1135,'东华街道',4,'',0,1,0,0),(5142,1135,'东风街道',4,'',0,1,0,0),(5143,1135,'中山东路街道',4,'',0,1,0,0),(5144,1135,'休门街道',4,'',0,1,0,0),(5145,1135,'建安街道',4,'',0,1,0,0),(5146,1135,'彭后街道',4,'',0,1,0,0),(5147,1135,'桃园镇',4,'',0,1,0,0),(5148,1135,'胜利北街道',4,'',0,1,0,0),(5149,1135,'胜利南街道',4,'',0,1,0,0),(5150,1135,'阜康街道',4,'',0,1,0,0),(5151,1136,'东里街道',4,'',0,1,0,0),(5152,1136,'中山路街道',4,'',0,1,0,0),(5153,1136,'南长街道',4,'',0,1,0,0),(5154,1136,'友谊街道',4,'',0,1,0,0),(5155,1136,'振头街道',4,'',0,1,0,0),(5156,1136,'新石街道',4,'',0,1,0,0),(5157,1136,'留营乡',4,'',0,1,0,0),(5158,1136,'红旗街道',4,'',0,1,0,0),(5159,1136,'维明街道',4,'',0,1,0,0),(5160,1136,'苑东街道',4,'',0,1,0,0),(5161,1136,'裕西街道',4,'',0,1,0,0),(5162,1136,'西里街道',4,'',0,1,0,0),(5163,1137,'北早现乡',4,'',0,1,0,0),(5164,1137,'南楼乡',4,'',0,1,0,0),(5165,1137,'南牛乡',4,'',0,1,0,0),(5166,1137,'城区街道',4,'',0,1,0,0),(5167,1137,'新城铺镇',4,'',0,1,0,0),(5168,1137,'新安镇',4,'',0,1,0,0),(5169,1137,'曲阳桥乡',4,'',0,1,0,0),(5170,1137,'正定镇',4,'',0,1,0,0),(5171,1137,'西平乐乡',4,'',0,1,0,0),(5172,1137,'诸福屯镇',4,'',0,1,0,0),(5173,1138,'桥头乡',4,'',0,1,0,0),(5174,1138,'深泽镇',4,'',0,1,0,0),(5175,1138,'留村乡',4,'',0,1,0,0),(5176,1138,'白庄乡',4,'',0,1,0,0),(5177,1138,'赵八乡',4,'',0,1,0,0),(5178,1138,'铁杆镇',4,'',0,1,0,0),(5179,1139,'三圣院乡',4,'',0,1,0,0),(5180,1139,'北洼乡',4,'',0,1,0,0),(5181,1139,'北谭庄乡',4,'',0,1,0,0),(5182,1139,'南寨乡',4,'',0,1,0,0),(5183,1139,'南燕川乡',4,'',0,1,0,0),(5184,1139,'南营乡',4,'',0,1,0,0),(5185,1139,'塔上镇',4,'',0,1,0,0),(5186,1139,'寨头乡',4,'',0,1,0,0),(5187,1139,'岔头镇',4,'',0,1,0,0),(5188,1139,'慈峪镇',4,'',0,1,0,0),(5189,1139,'灵寿镇',4,'',0,1,0,0),(5190,1139,'牛城乡',4,'',0,1,0,0),(5191,1139,'狗台乡',4,'',0,1,0,0),(5192,1139,'陈庄镇',4,'',0,1,0,0),(5193,1139,'青同镇',4,'',0,1,0,0),(5194,1140,'九门回族乡',4,'',0,1,0,0),(5195,1140,'兴安镇',4,'',0,1,0,0),(5196,1140,'前西关镇',4,'',0,1,0,0),(5197,1140,'南孟镇',4,'',0,1,0,0),(5198,1140,'南营镇',4,'',0,1,0,0),(5199,1140,'南董镇',4,'',0,1,0,0),(5200,1140,'增村镇',4,'',0,1,0,0),(5201,1140,'小常安镇',4,'',0,1,0,0),(5202,1140,'岗上镇',4,'',0,1,0,0),(5203,1140,'廉州镇',4,'',0,1,0,0),(5204,1140,'张家庄镇',4,'',0,1,0,0),(5205,1140,'梅花镇',4,'',0,1,0,0),(5206,1140,'贾市庄镇',4,'',0,1,0,0),(5207,1140,'邱头镇',4,'',0,1,0,0),(5208,1141,'上方乡',4,'',0,1,0,0),(5209,1141,'上碑镇',4,'',0,1,0,0),(5210,1141,'上阎庄乡',4,'',0,1,0,0),(5211,1141,'九口子乡',4,'',0,1,0,0),(5212,1141,'北河乡',4,'',0,1,0,0),(5213,1141,'南桥镇',4,'',0,1,0,0),(5214,1141,'口头镇',4,'',0,1,0,0),(5215,1141,'只里乡',4,'',0,1,0,0),(5216,1141,'城寨乡',4,'',0,1,0,0),(5217,1141,'安香乡',4,'',0,1,0,0),(5218,1141,'市同乡',4,'',0,1,0,0),(5219,1141,'独羊岗乡',4,'',0,1,0,0),(5220,1141,'玉亭乡',4,'',0,1,0,0),(5221,1141,'翟营乡',4,'',0,1,0,0),(5222,1141,'龙州镇',4,'',0,1,0,0),(5223,1142,'东苑街道',4,'',0,1,0,0),(5224,1142,'宋营镇',4,'',0,1,0,0),(5225,1142,'建通街道',4,'',0,1,0,0),(5226,1142,'方村镇',4,'',0,1,0,0),(5227,1142,'槐底街道',4,'',0,1,0,0),(5228,1142,'裕东街道',4,'',0,1,0,0),(5229,1142,'裕兴街道',4,'',0,1,0,0),(5230,1142,'裕华路街道',4,'',0,1,0,0),(5231,1142,'裕强街道',4,'',0,1,0,0),(5232,1142,'长江街道',4,'',0,1,0,0),(5233,1143,'南清河乡',4,'',0,1,0,0),(5234,1143,'南邢郭乡',4,'',0,1,0,0),(5235,1143,'土门乡',4,'',0,1,0,0),(5236,1143,'嶂石岩乡',4,'',0,1,0,0),(5237,1143,'张楞乡',4,'',0,1,0,0),(5238,1143,'西阳泽乡',4,'',0,1,0,0),(5239,1143,'西龙门乡',4,'',0,1,0,0),(5240,1143,'许亭乡',4,'',0,1,0,0),(5241,1143,'赞皇镇',4,'',0,1,0,0),(5242,1143,'院头镇',4,'',0,1,0,0),(5243,1143,'黄北坪乡',4,'',0,1,0,0),(5244,1144,'前大章乡',4,'',0,1,0,0),(5245,1144,'北王里镇',4,'',0,1,0,0),(5246,1144,'南柏舍镇',4,'',0,1,0,0),(5247,1144,'新寨店镇',4,'',0,1,0,0),(5248,1144,'沙河店镇',4,'',0,1,0,0),(5249,1144,'王西章乡',4,'',0,1,0,0),(5250,1144,'范庄镇',4,'',0,1,0,0),(5251,1144,'谢庄乡',4,'',0,1,0,0),(5252,1144,'赵州镇',4,'',0,1,0,0),(5253,1144,'韩村镇',4,'',0,1,0,0),(5254,1144,'高村乡',4,'',0,1,0,0),(5255,1145,'中里厢乡',4,'',0,1,0,0),(5256,1145,'位伯镇',4,'',0,1,0,0),(5257,1145,'前营乡',4,'',0,1,0,0),(5258,1145,'南智丘镇',4,'',0,1,0,0),(5259,1145,'和睦井乡',4,'',0,1,0,0),(5260,1145,'天宫营乡',4,'',0,1,0,0),(5261,1145,'小辛庄乡',4,'',0,1,0,0),(5262,1145,'张古庄镇',4,'',0,1,0,0),(5263,1145,'新垒头镇',4,'',0,1,0,0),(5264,1145,'新城镇',4,'',0,1,0,0),(5265,1145,'旧城镇',4,'',0,1,0,0),(5266,1145,'王口镇',4,'',0,1,0,0),(5267,1145,'田家庄乡',4,'',0,1,0,0),(5268,1145,'辛集镇',4,'',0,1,0,0),(5269,1145,'马庄乡',4,'',0,1,0,0),(5270,1146,'南村镇',4,'',0,1,0,0),(5271,1146,'广安街道',4,'',0,1,0,0),(5272,1146,'建北街道',4,'',0,1,0,0),(5273,1146,'河东街道',4,'',0,1,0,0),(5274,1146,'育才街道',4,'',0,1,0,0),(5275,1146,'西兆通镇',4,'',0,1,0,0),(5276,1146,'谈固街道',4,'',0,1,0,0),(5277,1146,'跃进街道',4,'',0,1,0,0),(5278,1146,'长丰街道',4,'',0,1,0,0),(5279,1146,'青园街道',4,'',0,1,0,0),(5280,1146,'高营镇',4,'',0,1,0,0),(5281,1147,'万城乡',4,'',0,1,0,0),(5282,1147,'中韩乡',4,'',0,1,0,0),(5283,1147,'大营乡',4,'',0,1,0,0),(5284,1147,'西富村乡',4,'',0,1,0,0),(5285,1147,'高邑镇',4,'',0,1,0,0),(5286,1148,'上寨乡',4,'',0,1,0,0),(5287,1148,'上庄镇',4,'',0,1,0,0),(5288,1148,'大河镇',4,'',0,1,0,0),(5289,1148,'宜安镇',4,'',0,1,0,0),(5290,1148,'寺家庄镇',4,'',0,1,0,0),(5291,1148,'山尹村乡',4,'',0,1,0,0),(5292,1148,'李村镇',4,'',0,1,0,0),(5293,1148,'白鹿泉乡',4,'',0,1,0,0),(5294,1148,'石井乡',4,'',0,1,0,0),(5295,1148,'获鹿镇',4,'',0,1,0,0),(5296,1148,'铜冶镇',4,'',0,1,0,0),(5297,1148,'黄壁庄镇',4,'',0,1,0,0),(5298,1149,'东田庄乡',4,'',0,1,0,0),(5299,1149,'丰南镇',4,'',0,1,0,0),(5300,1149,'南堡开发区',4,'',0,1,0,0),(5301,1149,'南孙庄乡',4,'',0,1,0,0),(5302,1149,'唐坊镇',4,'',0,1,0,0),(5303,1149,'大新庄镇',4,'',0,1,0,0),(5304,1149,'大齐各庄乡',4,'',0,1,0,0),(5305,1149,'小集镇',4,'',0,1,0,0),(5306,1149,'尖字沽乡',4,'',0,1,0,0),(5307,1149,'柳树酄镇',4,'',0,1,0,0),(5308,1149,'滨海镇',4,'',0,1,0,0),(5309,1149,'王兰庄镇',4,'',0,1,0,0),(5310,1149,'稻地镇',4,'',0,1,0,0),(5311,1149,'胥各庄街道',4,'',0,1,0,0),(5312,1149,'西葛镇',4,'',0,1,0,0),(5313,1149,'钱营镇',4,'',0,1,0,0),(5314,1149,'黄各庄镇',4,'',0,1,0,0),(5315,1149,'黑沿子镇',4,'',0,1,0,0),(5316,1150,'七树庄镇',4,'',0,1,0,0),(5317,1150,'丰润镇',4,'',0,1,0,0),(5318,1150,'丰登坞镇',4,'',0,1,0,0),(5319,1150,'任各庄镇',4,'',0,1,0,0),(5320,1150,'刘家营乡',4,'',0,1,0,0),(5321,1150,'太平路街道',4,'',0,1,0,0),(5322,1150,'姜家营乡',4,'',0,1,0,0),(5323,1150,'小张各庄镇',4,'',0,1,0,0),(5324,1150,'岔河镇',4,'',0,1,0,0),(5325,1150,'左家坞镇',4,'',0,1,0,0),(5326,1150,'常庄乡',4,'',0,1,0,0),(5327,1150,'新军屯镇',4,'',0,1,0,0),(5328,1150,'李钊庄镇',4,'',0,1,0,0),(5329,1150,'杨官林镇',4,'',0,1,0,0),(5330,1150,'欢喜庄乡',4,'',0,1,0,0),(5331,1150,'沙流河镇',4,'',0,1,0,0),(5332,1150,'泉河头镇',4,'',0,1,0,0),(5333,1150,'浭阳街道',4,'',0,1,0,0),(5334,1150,'火石营镇',4,'',0,1,0,0),(5335,1150,'燕山路街道',4,'',0,1,0,0),(5336,1150,'王官营镇',4,'',0,1,0,0),(5337,1150,'白官屯镇',4,'',0,1,0,0),(5338,1150,'石各庄镇',4,'',0,1,0,0),(5339,1150,'老庄子镇',4,'',0,1,0,0),(5340,1150,'银城铺乡',4,'',0,1,0,0),(5341,1150,'韩城镇',4,'',0,1,0,0),(5342,1151,'中堡王庄乡',4,'',0,1,0,0),(5343,1151,'乐亭镇',4,'',0,1,0,0),(5344,1151,'乐安街道',4,'',0,1,0,0),(5345,1151,'古河乡',4,'',0,1,0,0),(5346,1151,'大相各庄乡',4,'',0,1,0,0),(5347,1151,'姜各庄镇',4,'',0,1,0,0),(5348,1151,'庞各庄乡',4,'',0,1,0,0),(5349,1151,'新寨镇',4,'',0,1,0,0),(5350,1151,'毛庄乡',4,'',0,1,0,0),(5351,1151,'汀流河镇',4,'',0,1,0,0),(5352,1151,'汤家河镇',4,'',0,1,0,0),(5353,1151,'王滩镇',4,'',0,1,0,0),(5354,1151,'胡家坨镇',4,'',0,1,0,0),(5355,1151,'闫各庄镇',4,'',0,1,0,0),(5356,1151,'马头营镇',4,'',0,1,0,0),(5357,1152,'习家套乡',4,'',0,1,0,0),(5358,1152,'卑家店乡',4,'',0,1,0,0),(5359,1152,'南范各庄街道',4,'',0,1,0,0),(5360,1152,'古冶街道',4,'',0,1,0,0),(5361,1152,'吕家坨街道',4,'',0,1,0,0),(5362,1152,'唐家庄街道',4,'',0,1,0,0),(5363,1152,'大庄坨乡',4,'',0,1,0,0),(5364,1152,'林西街道',4,'',0,1,0,0),(5365,1152,'王辇庄乡',4,'',0,1,0,0),(5366,1152,'范各庄乡',4,'',0,1,0,0),(5367,1152,'赵各庄街道',4,'',0,1,0,0),(5368,1153,'一农场',4,'',0,1,0,0),(5369,1153,'七农场',4,'',0,1,0,0),(5370,1153,'三农场',4,'',0,1,0,0),(5371,1153,'九农场',4,'',0,1,0,0),(5372,1153,'二农场',4,'',0,1,0,0),(5373,1153,'五农场',4,'',0,1,0,0),(5374,1153,'八农场',4,'',0,1,0,0),(5375,1153,'六农场',4,'',0,1,0,0),(5376,1153,'十一农场',4,'',0,1,0,0),(5377,1153,'十农场',4,'',0,1,0,0),(5378,1153,'唐海镇',4,'',0,1,0,0),(5379,1153,'四农场',4,'',0,1,0,0),(5380,1154,'双桥乡',4,'',0,1,0,0),(5381,1154,'开平街道',4,'',0,1,0,0),(5382,1154,'开平镇',4,'',0,1,0,0),(5383,1154,'栗园镇',4,'',0,1,0,0),(5384,1154,'洼里乡',4,'',0,1,0,0),(5385,1154,'税务庄街道',4,'',0,1,0,0),(5386,1154,'荆各庄矿区街道',4,'',0,1,0,0),(5387,1154,'越河乡',4,'',0,1,0,0),(5388,1154,'郑庄子乡',4,'',0,1,0,0),(5389,1154,'陡电街道',4,'',0,1,0,0),(5390,1154,'马家沟街道',4,'',0,1,0,0),(5391,1155,'东黄坨镇',4,'',0,1,0,0),(5392,1155,'倴城镇',4,'',0,1,0,0),(5393,1155,'南堡镇',4,'',0,1,0,0),(5394,1155,'司各庄镇',4,'',0,1,0,0),(5395,1155,'坨里镇',4,'',0,1,0,0),(5396,1155,'姚王庄镇',4,'',0,1,0,0),(5397,1155,'安各庄镇',4,'',0,1,0,0),(5398,1155,'宋道口镇',4,'',0,1,0,0),(5399,1155,'扒齿港镇',4,'',0,1,0,0),(5400,1155,'方各庄镇',4,'',0,1,0,0),(5401,1155,'柏各庄镇',4,'',0,1,0,0),(5402,1155,'柳赞镇',4,'',0,1,0,0),(5403,1155,'程庄镇',4,'',0,1,0,0),(5404,1155,'胡各庄镇',4,'',0,1,0,0),(5405,1155,'长凝镇',4,'',0,1,0,0),(5406,1155,'青坨营镇',4,'',0,1,0,0),(5407,1155,'马城镇',4,'',0,1,0,0),(5408,1156,'东安各庄镇',4,'',0,1,0,0),(5409,1156,'九百户镇',4,'',0,1,0,0),(5410,1156,'古马镇',4,'',0,1,0,0),(5411,1156,'响堂镇',4,'',0,1,0,0),(5412,1156,'小马庄镇',4,'',0,1,0,0),(5413,1156,'杨柳庄镇',4,'',0,1,0,0),(5414,1156,'榛子镇',4,'',0,1,0,0),(5415,1156,'油榨镇',4,'',0,1,0,0),(5416,1156,'滦州镇',4,'',0,1,0,0),(5417,1156,'王店子镇',4,'',0,1,0,0),(5418,1156,'茨榆坨镇',4,'',0,1,0,0),(5419,1156,'雷庄镇',4,'',0,1,0,0),(5420,1157,'亮甲店镇',4,'',0,1,0,0),(5421,1157,'唐自头镇',4,'',0,1,0,0),(5422,1157,'大安镇',4,'',0,1,0,0),(5423,1157,'孤树镇',4,'',0,1,0,0),(5424,1157,'彩亭桥镇',4,'',0,1,0,0),(5425,1157,'散水头镇',4,'',0,1,0,0),(5426,1157,'杨家套乡',4,'',0,1,0,0),(5427,1157,'杨家板桥镇',4,'',0,1,0,0),(5428,1157,'林南仓镇',4,'',0,1,0,0),(5429,1157,'林头屯乡',4,'',0,1,0,0),(5430,1157,'林西镇',4,'',0,1,0,0),(5431,1157,'潮洛窝乡',4,'',0,1,0,0),(5432,1157,'玉田镇',4,'',0,1,0,0),(5433,1157,'石臼窝镇',4,'',0,1,0,0),(5434,1157,'窝洛沽镇',4,'',0,1,0,0),(5435,1157,'虹桥镇',4,'',0,1,0,0),(5436,1157,'郭家屯乡',4,'',0,1,0,0),(5437,1157,'郭家桥乡',4,'',0,1,0,0),(5438,1157,'陈家铺乡',4,'',0,1,0,0),(5439,1157,'鸦鸿桥镇',4,'',0,1,0,0),(5440,1158,'东新村街道',4,'',0,1,0,0),(5441,1158,'乔屯街道',4,'',0,1,0,0),(5442,1158,'光明街道',4,'',0,1,0,0),(5443,1158,'大里街道',4,'',0,1,0,0),(5444,1158,'文化路街道',4,'',0,1,0,0),(5445,1158,'机场路街道',4,'',0,1,0,0),(5446,1158,'果园乡',4,'',0,1,0,0),(5447,1158,'河北路街道',4,'',0,1,0,0),(5448,1158,'缸窑街道',4,'',0,1,0,0),(5449,1158,'钓鱼台街道',4,'',0,1,0,0),(5450,1158,'高新技术开发区街道',4,'',0,1,0,0),(5451,1158,'龙东街道',4,'',0,1,0,0),(5452,1159,'友谊里街道',4,'',0,1,0,0),(5453,1159,'女织寨乡',4,'',0,1,0,0),(5454,1159,'学院南路街道',4,'',0,1,0,0),(5455,1159,'小山街道',4,'',0,1,0,0),(5456,1159,'广场街道',4,'',0,1,0,0),(5457,1159,'文化北后街街道',4,'',0,1,0,0),(5458,1159,'永红桥街道',4,'',0,1,0,0),(5459,1159,'钱家营矿区街道',4,'',0,1,0,0),(5460,1160,'上庄乡',4,'',0,1,0,0),(5461,1160,'五重安乡',4,'',0,1,0,0),(5462,1160,'兴安街道',4,'',0,1,0,0),(5463,1160,'夏官营镇',4,'',0,1,0,0),(5464,1160,'大五里乡',4,'',0,1,0,0),(5465,1160,'大崔庄镇',4,'',0,1,0,0),(5466,1160,'太平庄乡',4,'',0,1,0,0),(5467,1160,'建昌营镇',4,'',0,1,0,0),(5468,1160,'彭店子乡',4,'',0,1,0,0),(5469,1160,'扣庄乡',4,'',0,1,0,0),(5470,1160,'木厂口镇',4,'',0,1,0,0),(5471,1160,'杨子店街道',4,'',0,1,0,0),(5472,1160,'永顺街道',4,'',0,1,0,0),(5473,1160,'沙河驿镇',4,'',0,1,0,0),(5474,1160,'滨河街道',4,'',0,1,0,0),(5475,1160,'蔡园镇',4,'',0,1,0,0),(5476,1160,'赵店子镇',4,'',0,1,0,0),(5477,1160,'野鸡坨镇',4,'',0,1,0,0),(5478,1160,'闫家店乡',4,'',0,1,0,0),(5479,1160,'马兰庄镇',4,'',0,1,0,0),(5480,1161,'三屯营镇',4,'',0,1,0,0),(5481,1161,'上营乡',4,'',0,1,0,0),(5482,1161,'东荒峪镇',4,'',0,1,0,0),(5483,1161,'东莲花院乡',4,'',0,1,0,0),(5484,1161,'兴城镇',4,'',0,1,0,0),(5485,1161,'太平寨镇',4,'',0,1,0,0),(5486,1161,'尹庄乡',4,'',0,1,0,0),(5487,1161,'新庄子乡',4,'',0,1,0,0),(5488,1161,'新集镇',4,'',0,1,0,0),(5489,1161,'旧城乡',4,'',0,1,0,0),(5490,1161,'栗乡街道',4,'',0,1,0,0),(5491,1161,'汉儿庄乡',4,'',0,1,0,0),(5492,1161,'洒河桥镇',4,'',0,1,0,0),(5493,1161,'渔户寨乡',4,'',0,1,0,0),(5494,1161,'滦阳镇',4,'',0,1,0,0),(5495,1161,'白庙子乡',4,'',0,1,0,0),(5496,1161,'罗家屯镇',4,'',0,1,0,0),(5497,1161,'金厂峪镇',4,'',0,1,0,0),(5498,1162,'东新庄镇',4,'',0,1,0,0),(5499,1162,'东旧寨镇',4,'',0,1,0,0),(5500,1162,'东陵满族乡',4,'',0,1,0,0),(5501,1162,'候家寨乡',4,'',0,1,0,0),(5502,1162,'党峪镇',4,'',0,1,0,0),(5503,1162,'兴旺寨乡',4,'',0,1,0,0),(5504,1162,'刘备寨乡',4,'',0,1,0,0),(5505,1162,'团瓢庄乡',4,'',0,1,0,0),(5506,1162,'地北头镇',4,'',0,1,0,0),(5507,1162,'堡子店镇',4,'',0,1,0,0),(5508,1162,'娘娘庄乡',4,'',0,1,0,0),(5509,1162,'小厂乡',4,'',0,1,0,0),(5510,1162,'崔家庄乡',4,'',0,1,0,0),(5511,1162,'平安城镇',4,'',0,1,0,0),(5512,1162,'建明镇',4,'',0,1,0,0),(5513,1162,'新店子镇',4,'',0,1,0,0),(5514,1162,'汤泉满族乡',4,'',0,1,0,0),(5515,1162,'石门镇',4,'',0,1,0,0),(5516,1162,'苏家洼镇',4,'',0,1,0,0),(5517,1162,'西三里乡',4,'',0,1,0,0),(5518,1162,'西下营满族乡',4,'',0,1,0,0),(5519,1162,'西留村乡',4,'',0,1,0,0),(5520,1162,'遵化镇',4,'',0,1,0,0),(5521,1162,'铁厂镇',4,'',0,1,0,0),(5522,1162,'马兰峪镇',4,'',0,1,0,0),(5523,1163,'东山街道',4,'',0,1,0,0),(5524,1163,'戴河镇',4,'',0,1,0,0),(5525,1163,'海滨镇',4,'',0,1,0,0),(5526,1163,'西山街道',4,'',0,1,0,0),(5527,1164,'下寨乡',4,'',0,1,0,0),(5528,1164,'刘家营乡',4,'',0,1,0,0),(5529,1164,'刘田各庄镇',4,'',0,1,0,0),(5530,1164,'卢龙镇',4,'',0,1,0,0),(5531,1164,'印庄乡',4,'',0,1,0,0),(5532,1164,'双望镇',4,'',0,1,0,0),(5533,1164,'木井乡',4,'',0,1,0,0),(5534,1164,'潘庄镇',4,'',0,1,0,0),(5535,1164,'燕河营镇',4,'',0,1,0,0),(5536,1164,'石门镇',4,'',0,1,0,0),(5537,1164,'蛤泊乡',4,'',0,1,0,0),(5538,1164,'陈官屯乡',4,'',0,1,0,0),(5539,1165,'东街街道',4,'',0,1,0,0),(5540,1165,'南关街道',4,'',0,1,0,0),(5541,1165,'孟姜镇',4,'',0,1,0,0),(5542,1165,'渤海乡',4,'',0,1,0,0),(5543,1165,'石河镇',4,'',0,1,0,0),(5544,1165,'第一关镇',4,'',0,1,0,0),(5545,1165,'船厂路街道',4,'',0,1,0,0),(5546,1165,'西街街道',4,'',0,1,0,0),(5547,1165,'路南街道',4,'',0,1,0,0),(5548,1166,'台营镇',4,'',0,1,0,0),(5549,1166,'大新寨镇',4,'',0,1,0,0),(5550,1166,'抚宁镇',4,'',0,1,0,0),(5551,1166,'杜庄乡',4,'',0,1,0,0),(5552,1166,'榆关镇',4,'',0,1,0,0),(5553,1166,'深河乡',4,'',0,1,0,0),(5554,1166,'牛头崖镇',4,'',0,1,0,0),(5555,1166,'留守营镇',4,'',0,1,0,0),(5556,1166,'石门寨镇',4,'',0,1,0,0),(5557,1166,'茶棚乡',4,'',0,1,0,0),(5558,1166,'驻操营镇',4,'',0,1,0,0),(5559,1167,'两山乡',4,'',0,1,0,0),(5560,1167,'刘台庄镇',4,'',0,1,0,0),(5561,1167,'十里铺乡',4,'',0,1,0,0),(5562,1167,'团林乡',4,'',0,1,0,0),(5563,1167,'大蒲河镇',4,'',0,1,0,0),(5564,1167,'安山镇',4,'',0,1,0,0),(5565,1167,'新集镇',4,'',0,1,0,0),(5566,1167,'昌黎镇',4,'',0,1,0,0),(5567,1167,'朱各庄镇',4,'',0,1,0,0),(5568,1167,'泥井镇',4,'',0,1,0,0),(5569,1167,'茹荷镇',4,'',0,1,0,0),(5570,1167,'荒佃庄乡',4,'',0,1,0,0),(5571,1167,'葛条港乡',4,'',0,1,0,0),(5572,1167,'靖安镇',4,'',0,1,0,0),(5573,1167,'马坨店乡',4,'',0,1,0,0),(5574,1167,'龙家店镇',4,'',0,1,0,0),(5575,1168,'东港镇',4,'',0,1,0,0),(5576,1168,'东环路街道',4,'',0,1,0,0),(5577,1168,'北港镇',4,'',0,1,0,0),(5578,1168,'北环路街道',4,'',0,1,0,0),(5579,1168,'建设大街街道',4,'',0,1,0,0),(5580,1168,'文化路街道',4,'',0,1,0,0),(5581,1168,'河东街道',4,'',0,1,0,0),(5582,1168,'海港镇',4,'',0,1,0,0),(5583,1168,'海滨路街道',4,'',0,1,0,0),(5584,1168,'海阳镇',4,'',0,1,0,0),(5585,1168,'港城大街街道',4,'',0,1,0,0),(5586,1168,'燕山大街街道',4,'',0,1,0,0),(5587,1168,'珠江道街道',4,'',0,1,0,0),(5588,1168,'白塔岭街道',4,'',0,1,0,0),(5589,1168,'西港路街道',4,'',0,1,0,0),(5590,1168,'西港镇',4,'',0,1,0,0),(5591,1169,'七道河乡',4,'',0,1,0,0),(5592,1169,'三拨子乡',4,'',0,1,0,0),(5593,1169,'三星口乡',4,'',0,1,0,0),(5594,1169,'八道河乡',4,'',0,1,0,0),(5595,1169,'凉水河乡',4,'',0,1,0,0),(5596,1169,'凤凰山乡',4,'',0,1,0,0),(5597,1169,'双山子镇',4,'',0,1,0,0),(5598,1169,'土门子乡',4,'',0,1,0,0),(5599,1169,'大巫岚乡',4,'',0,1,0,0),(5600,1169,'大石岭乡',4,'',0,1,0,0),(5601,1169,'娄仗子乡',4,'',0,1,0,0),(5602,1169,'安子岭乡',4,'',0,1,0,0),(5603,1169,'官场乡',4,'',0,1,0,0),(5604,1169,'干沟乡',4,'',0,1,0,0),(5605,1169,'平方子乡',4,'',0,1,0,0),(5606,1169,'木头凳镇',4,'',0,1,0,0),(5607,1169,'朱仗子乡',4,'',0,1,0,0),(5608,1169,'祖山镇',4,'',0,1,0,0),(5609,1169,'肖营子镇',4,'',0,1,0,0),(5610,1169,'茨榆山乡',4,'',0,1,0,0),(5611,1169,'草碾乡',4,'',0,1,0,0),(5612,1169,'隔河头乡',4,'',0,1,0,0),(5613,1169,'青龙镇',4,'',0,1,0,0),(5614,1169,'马圈子镇',4,'',0,1,0,0),(5615,1169,'龙王庙乡',4,'',0,1,0,0),(5616,1170,'丛台东街道',4,'',0,1,0,0),(5617,1170,'丛台西街道',4,'',0,1,0,0),(5618,1170,'中华街道',4,'',0,1,0,0),(5619,1170,'人民路街道',4,'',0,1,0,0),(5620,1170,'光明桥街道',4,'',0,1,0,0),(5621,1170,'和平街道',4,'',0,1,0,0),(5622,1170,'四季青街道',4,'',0,1,0,0),(5623,1170,'柳林桥街道',4,'',0,1,0,0),(5624,1170,'联纺东街道',4,'',0,1,0,0),(5625,1170,'联纺西街道',4,'',0,1,0,0),(5626,1170,'苏曹乡',4,'',0,1,0,0),(5627,1171,'临漳镇',4,'',0,1,0,0),(5628,1171,'习文乡',4,'',0,1,0,0),(5629,1171,'南东坊镇',4,'',0,1,0,0),(5630,1171,'孙陶集镇',4,'',0,1,0,0),(5631,1171,'张村集乡',4,'',0,1,0,0),(5632,1171,'杜村集乡',4,'',0,1,0,0),(5633,1171,'柏鹤集乡',4,'',0,1,0,0),(5634,1171,'柳园镇',4,'',0,1,0,0),(5635,1171,'狄邱乡',4,'',0,1,0,0),(5636,1171,'砖寨营乡',4,'',0,1,0,0),(5637,1171,'称勾集镇',4,'',0,1,0,0),(5638,1171,'章里集乡',4,'',0,1,0,0),(5639,1171,'西羊羔乡',4,'',0,1,0,0),(5640,1171,'香菜营乡',4,'',0,1,0,0),(5641,1172,'二六七二街道',4,'',0,1,0,0),(5642,1172,'化林路街道',4,'',0,1,0,0),(5643,1172,'庞村街道',4,'',0,1,0,0),(5644,1172,'彭家寨乡',4,'',0,1,0,0),(5645,1172,'百家村街道',4,'',0,1,0,0),(5646,1172,'石化街道',4,'',0,1,0,0),(5647,1172,'胜利桥街道',4,'',0,1,0,0),(5648,1172,'铁路大院街道',4,'',0,1,0,0),(5649,1173,'万堤镇',4,'',0,1,0,0),(5650,1173,'北峰乡',4,'',0,1,0,0),(5651,1173,'埝头乡',4,'',0,1,0,0),(5652,1173,'大名镇',4,'',0,1,0,0),(5653,1173,'大街乡',4,'',0,1,0,0),(5654,1173,'孙甘店乡',4,'',0,1,0,0),(5655,1173,'张集乡',4,'',0,1,0,0),(5656,1173,'旧治乡',4,'',0,1,0,0),(5657,1173,'束馆镇',4,'',0,1,0,0),(5658,1173,'杨桥镇',4,'',0,1,0,0),(5659,1173,'沙圪塔乡',4,'',0,1,0,0),(5660,1173,'王村乡',4,'',0,1,0,0),(5661,1173,'红庙乡',4,'',0,1,0,0),(5662,1173,'营镇回族乡',4,'',0,1,0,0),(5663,1173,'西付集乡',4,'',0,1,0,0),(5664,1173,'西未庄乡',4,'',0,1,0,0),(5665,1173,'金滩镇',4,'',0,1,0,0),(5666,1173,'铺上乡',4,'',0,1,0,0),(5667,1173,'黄金堤乡',4,'',0,1,0,0),(5668,1173,'龙王庙镇',4,'',0,1,0,0),(5669,1174,'临水镇',4,'',0,1,0,0),(5670,1174,'义井镇',4,'',0,1,0,0),(5671,1174,'和村镇',4,'',0,1,0,0),(5672,1174,'大峪镇',4,'',0,1,0,0),(5673,1174,'大社镇',4,'',0,1,0,0),(5674,1174,'峰峰镇',4,'',0,1,0,0),(5675,1174,'彭城镇',4,'',0,1,0,0),(5676,1174,'新坡镇',4,'',0,1,0,0),(5677,1174,'界城镇',4,'',0,1,0,0),(5678,1175,'东张孟乡',4,'',0,1,0,0),(5679,1175,'十里铺乡',4,'',0,1,0,0),(5680,1175,'南阳堡乡',4,'',0,1,0,0),(5681,1175,'南韩村乡',4,'',0,1,0,0),(5682,1175,'双庙乡',4,'',0,1,0,0),(5683,1175,'平固店镇',4,'',0,1,0,0),(5684,1175,'广平镇',4,'',0,1,0,0),(5685,1176,'北乡义乡',4,'',0,1,0,0),(5686,1176,'商城镇',4,'',0,1,0,0),(5687,1176,'成安镇',4,'',0,1,0,0),(5688,1176,'李家疃镇',4,'',0,1,0,0),(5689,1176,'柏寺营乡',4,'',0,1,0,0),(5690,1176,'漳河店镇',4,'',0,1,0,0),(5691,1176,'辛义乡',4,'',0,1,0,0),(5692,1176,'道东堡乡',4,'',0,1,0,0),(5693,1176,'长巷乡',4,'',0,1,0,0),(5694,1177,'依庄乡',4,'',0,1,0,0),(5695,1177,'侯村镇',4,'',0,1,0,0),(5696,1177,'南里岳乡',4,'',0,1,0,0),(5697,1177,'大河道乡',4,'',0,1,0,0),(5698,1177,'安寨镇',4,'',0,1,0,0),(5699,1177,'曲周镇',4,'',0,1,0,0),(5700,1177,'槐桥乡',4,'',0,1,0,0),(5701,1177,'河南疃镇',4,'',0,1,0,0),(5702,1177,'白寨乡',4,'',0,1,0,0),(5703,1177,'第四疃乡',4,'',0,1,0,0),(5704,1178,'上团城乡',4,'',0,1,0,0),(5705,1178,'伯延镇',4,'',0,1,0,0),(5706,1178,'冶陶镇',4,'',0,1,0,0),(5707,1178,'北安乐乡',4,'',0,1,0,0),(5708,1178,'北安庄乡',4,'',0,1,0,0),(5709,1178,'午汲镇',4,'',0,1,0,0),(5710,1178,'大同镇',4,'',0,1,0,0),(5711,1178,'康二城镇',4,'',0,1,0,0),(5712,1178,'徘徊镇',4,'',0,1,0,0),(5713,1178,'武安镇',4,'',0,1,0,0),(5714,1178,'活水乡',4,'',0,1,0,0),(5715,1178,'淑村镇',4,'',0,1,0,0),(5716,1178,'石洞乡',4,'',0,1,0,0),(5717,1178,'矿山镇',4,'',0,1,0,0),(5718,1178,'磁山镇',4,'',0,1,0,0),(5719,1178,'管陶乡',4,'',0,1,0,0),(5720,1178,'西土山乡',4,'',0,1,0,0),(5721,1178,'西寺庄乡',4,'',0,1,0,0),(5722,1178,'贺进镇',4,'',0,1,0,0),(5723,1178,'邑城镇',4,'',0,1,0,0),(5724,1178,'阳邑镇',4,'',0,1,0,0),(5725,1178,'马家庄乡',4,'',0,1,0,0),(5726,1179,'东杨庄乡',4,'',0,1,0,0),(5727,1179,'临洺关镇',4,'',0,1,0,0),(5728,1179,'刘汉乡',4,'',0,1,0,0),(5729,1179,'刘营乡',4,'',0,1,0,0),(5730,1179,'南永合会镇',4,'',0,1,0,0),(5731,1179,'南沿村镇',4,'',0,1,0,0),(5732,1179,'南西苏乡',4,'',0,1,0,0),(5733,1179,'大北汪镇',4,'',0,1,0,0),(5734,1179,'姚寨乡',4,'',0,1,0,0),(5735,1179,'小西堡乡',4,'',0,1,0,0),(5736,1179,'小龙马乡',4,'',0,1,0,0),(5737,1179,'广府镇',4,'',0,1,0,0),(5738,1179,'张西堡镇',4,'',0,1,0,0),(5739,1179,'曲陌乡',4,'',0,1,0,0),(5740,1179,'正西乡',4,'',0,1,0,0),(5741,1179,'界河店乡',4,'',0,1,0,0),(5742,1179,'西河庄乡',4,'',0,1,0,0),(5743,1179,'西阳城乡',4,'',0,1,0,0),(5744,1179,'讲武乡',4,'',0,1,0,0),(5745,1179,'辛庄堡乡',4,'',0,1,0,0),(5746,1180,'井店镇',4,'',0,1,0,0),(5747,1180,'偏城镇',4,'',0,1,0,0),(5748,1180,'偏店乡',4,'',0,1,0,0),(5749,1180,'关防乡',4,'',0,1,0,0),(5750,1180,'合漳乡',4,'',0,1,0,0),(5751,1180,'固新镇',4,'',0,1,0,0),(5752,1180,'更乐镇',4,'',0,1,0,0),(5753,1180,'木井乡',4,'',0,1,0,0),(5754,1180,'河南店镇',4,'',0,1,0,0),(5755,1180,'涉城镇',4,'',0,1,0,0),(5756,1180,'神头乡',4,'',0,1,0,0),(5757,1180,'索堡镇',4,'',0,1,0,0),(5758,1180,'西戌镇',4,'',0,1,0,0),(5759,1180,'西达镇',4,'',0,1,0,0),(5760,1180,'辽城乡',4,'',0,1,0,0),(5761,1180,'鹿头乡',4,'',0,1,0,0),(5762,1180,'龙虎乡',4,'',0,1,0,0),(5763,1181,'北贾壁乡',4,'',0,1,0,0),(5764,1181,'南城乡',4,'',0,1,0,0),(5765,1181,'台城乡',4,'',0,1,0,0),(5766,1181,'岳城镇',4,'',0,1,0,0),(5767,1181,'时村营乡',4,'',0,1,0,0),(5768,1181,'林坦镇',4,'',0,1,0,0),(5769,1181,'白土镇',4,'',0,1,0,0),(5770,1181,'磁州镇',4,'',0,1,0,0),(5771,1181,'花官营乡',4,'',0,1,0,0),(5772,1181,'西光禄镇',4,'',0,1,0,0),(5773,1181,'西固义乡',4,'',0,1,0,0),(5774,1181,'观台镇',4,'',0,1,0,0),(5775,1181,'讲武城镇',4,'',0,1,0,0),(5776,1181,'路村营乡',4,'',0,1,0,0),(5777,1181,'辛庄营乡',4,'',0,1,0,0),(5778,1181,'都党乡',4,'',0,1,0,0),(5779,1181,'陶泉乡',4,'',0,1,0,0),(5780,1181,'高臾镇',4,'',0,1,0,0),(5781,1181,'黄沙镇',4,'',0,1,0,0),(5782,1182,'东漳堡乡',4,'',0,1,0,0),(5783,1182,'元固乡',4,'',0,1,0,0),(5784,1182,'大西韩乡',4,'',0,1,0,0),(5785,1182,'天台山镇',4,'',0,1,0,0),(5786,1182,'屯庄营乡',4,'',0,1,0,0),(5787,1182,'旧店乡',4,'',0,1,0,0),(5788,1182,'毛演堡乡',4,'',0,1,0,0),(5789,1182,'肥乡镇',4,'',0,1,0,0),(5790,1182,'辛安镇乡',4,'',0,1,0,0),(5791,1183,'光明路街道',4,'',0,1,0,0),(5792,1183,'农林路街道',4,'',0,1,0,0),(5793,1183,'浴新南街道',4,'',0,1,0,0),(5794,1183,'渚河路街道',4,'',0,1,0,0),(5795,1183,'滏东街道',4,'',0,1,0,0),(5796,1183,'火磨街道',4,'',0,1,0,0),(5797,1183,'罗城头街道',4,'',0,1,0,0),(5798,1183,'贸东街道',4,'',0,1,0,0),(5799,1183,'贸西街道',4,'',0,1,0,0),(5800,1183,'陵园路街道',4,'',0,1,0,0),(5801,1183,'马头镇',4,'',0,1,0,0),(5802,1183,'马庄乡',4,'',0,1,0,0),(5803,1184,'三陵乡',4,'',0,1,0,0),(5804,1184,'代召乡',4,'',0,1,0,0),(5805,1184,'兼庄乡',4,'',0,1,0,0),(5806,1184,'北张庄镇',4,'',0,1,0,0),(5807,1184,'南吕固乡',4,'',0,1,0,0),(5808,1184,'南堡乡',4,'',0,1,0,0),(5809,1184,'尚璧镇',4,'',0,1,0,0),(5810,1184,'康庄乡',4,'',0,1,0,0),(5811,1184,'户村镇',4,'',0,1,0,0),(5812,1184,'河沙镇镇',4,'',0,1,0,0),(5813,1184,'黄粱梦镇',4,'',0,1,0,0),(5814,1185,'南辛店乡',4,'',0,1,0,0),(5815,1185,'新马头镇',4,'',0,1,0,0),(5816,1185,'旦寨乡',4,'',0,1,0,0),(5817,1185,'梁二庄乡',4,'',0,1,0,0),(5818,1185,'邱城镇',4,'',0,1,0,0),(5819,1185,'陈村回族乡',4,'',0,1,0,0),(5820,1185,'香城固乡',4,'',0,1,0,0),(5821,1186,'南徐村乡',4,'',0,1,0,0),(5822,1186,'寿山寺乡',4,'',0,1,0,0),(5823,1186,'房寨镇',4,'',0,1,0,0),(5824,1186,'柴堡镇',4,'',0,1,0,0),(5825,1186,'王桥乡',4,'',0,1,0,0),(5826,1186,'路桥乡',4,'',0,1,0,0),(5827,1186,'馆陶镇',4,'',0,1,0,0),(5828,1186,'魏僧寨镇',4,'',0,1,0,0),(5829,1187,'东代固乡',4,'',0,1,0,0),(5830,1187,'仕望集乡',4,'',0,1,0,0),(5831,1187,'前大磨乡',4,'',0,1,0,0),(5832,1187,'北台头乡',4,'',0,1,0,0),(5833,1187,'北皋镇',4,'',0,1,0,0),(5834,1187,'南双庙乡',4,'',0,1,0,0),(5835,1187,'双井镇',4,'',0,1,0,0),(5836,1187,'回隆镇',4,'',0,1,0,0),(5837,1187,'大辛庄乡',4,'',0,1,0,0),(5838,1187,'大马村乡',4,'',0,1,0,0),(5839,1187,'张二庄乡',4,'',0,1,0,0),(5840,1187,'德政镇',4,'',0,1,0,0),(5841,1187,'棘针寨乡',4,'',0,1,0,0),(5842,1187,'沙口集乡',4,'',0,1,0,0),(5843,1187,'泊口乡',4,'',0,1,0,0),(5844,1187,'牙里镇',4,'',0,1,0,0),(5845,1187,'车往镇',4,'',0,1,0,0),(5846,1187,'边马乡',4,'',0,1,0,0),(5847,1187,'野胡拐乡',4,'',0,1,0,0),(5848,1187,'院堡乡',4,'',0,1,0,0),(5849,1187,'魏城镇',4,'',0,1,0,0),(5850,1188,'双塔镇',4,'',0,1,0,0),(5851,1188,'吴官营乡',4,'',0,1,0,0),(5852,1188,'小寨镇',4,'',0,1,0,0),(5853,1188,'曹庄乡',4,'',0,1,0,0),(5854,1188,'浮图店乡',4,'',0,1,0,0),(5855,1188,'风正乡',4,'',0,1,0,0),(5856,1188,'鸡泽镇',4,'',0,1,0,0),(5857,1189,'东镇镇',4,'',0,1,0,0),(5858,1189,'临城镇',4,'',0,1,0,0),(5859,1189,'石城乡',4,'',0,1,0,0),(5860,1189,'西竖镇',4,'',0,1,0,0),(5861,1189,'赵庄乡',4,'',0,1,0,0),(5862,1189,'郝庄镇',4,'',0,1,0,0),(5863,1189,'鸭鸽营乡',4,'',0,1,0,0),(5864,1189,'黑城乡',4,'',0,1,0,0),(5865,1190,'下堡寺镇',4,'',0,1,0,0),(5866,1190,'东枣园乡',4,'',0,1,0,0),(5867,1190,'临西镇',4,'',0,1,0,0),(5868,1190,'吕寨乡',4,'',0,1,0,0),(5869,1190,'大刘庄乡',4,'',0,1,0,0),(5870,1190,'尖冢镇',4,'',0,1,0,0),(5871,1190,'摇鞍镇乡',4,'',0,1,0,0),(5872,1190,'河西镇',4,'',0,1,0,0),(5873,1190,'老官寨乡',4,'',0,1,0,0),(5874,1191,'任城镇',4,'',0,1,0,0),(5875,1191,'大屯乡',4,'',0,1,0,0),(5876,1191,'天口乡',4,'',0,1,0,0),(5877,1191,'永福庄乡',4,'',0,1,0,0),(5878,1191,'西固城乡',4,'',0,1,0,0),(5879,1191,'辛店镇',4,'',0,1,0,0),(5880,1191,'邢家湾镇',4,'',0,1,0,0),(5881,1191,'骆庄乡',4,'',0,1,0,0),(5882,1192,'五郭店乡',4,'',0,1,0,0),(5883,1192,'侯家庄乡',4,'',0,1,0,0),(5884,1192,'内丘镇',4,'',0,1,0,0),(5885,1192,'南赛乡',4,'',0,1,0,0),(5886,1192,'大孟村镇',4,'',0,1,0,0),(5887,1192,'官庄镇',4,'',0,1,0,0),(5888,1192,'柳林镇',4,'',0,1,0,0),(5889,1192,'獐貘乡',4,'',0,1,0,0),(5890,1192,'金店镇',4,'',0,1,0,0),(5891,1193,'三思乡',4,'',0,1,0,0),(5892,1193,'东三召乡',4,'',0,1,0,0),(5893,1193,'史召乡',4,'',0,1,0,0),(5894,1193,'和阳镇',4,'',0,1,0,0),(5895,1193,'河郭乡',4,'',0,1,0,0),(5896,1193,'贾宋镇',4,'',0,1,0,0),(5897,1193,'郝桥镇',4,'',0,1,0,0),(5898,1193,'阎里乡',4,'',0,1,0,0),(5899,1194,'凤岗街道',4,'',0,1,0,0),(5900,1194,'前紫冢镇',4,'',0,1,0,0),(5901,1194,'北胡街道',4,'',0,1,0,0),(5902,1194,'南便村乡',4,'',0,1,0,0),(5903,1194,'南杜街道',4,'',0,1,0,0),(5904,1194,'垂杨镇',4,'',0,1,0,0),(5905,1194,'大屯乡',4,'',0,1,0,0),(5906,1194,'大村乡',4,'',0,1,0,0),(5907,1194,'大高村镇',4,'',0,1,0,0),(5908,1194,'明化镇',4,'',0,1,0,0),(5909,1194,'段芦头镇',4,'',0,1,0,0),(5910,1194,'王道寨乡',4,'',0,1,0,0),(5911,1194,'苏村镇',4,'',0,1,0,0),(5912,1194,'薛吴村乡',4,'',0,1,0,0),(5913,1194,'西丁街道',4,'',0,1,0,0),(5914,1195,'七级镇',4,'',0,1,0,0),(5915,1195,'侯贯镇',4,'',0,1,0,0),(5916,1195,'固献乡',4,'',0,1,0,0),(5917,1195,'常屯乡',4,'',0,1,0,0),(5918,1195,'常庄乡',4,'',0,1,0,0),(5919,1195,'张营乡',4,'',0,1,0,0),(5920,1195,'方家营乡',4,'',0,1,0,0),(5921,1195,'枣园乡',4,'',0,1,0,0),(5922,1195,'梨元屯镇',4,'',0,1,0,0),(5923,1195,'洺州镇',4,'',0,1,0,0),(5924,1195,'章台镇',4,'',0,1,0,0),(5925,1195,'第什营乡',4,'',0,1,0,0),(5926,1195,'贺营乡',4,'',0,1,0,0),(5927,1195,'贺钊乡',4,'',0,1,0,0),(5928,1195,'赵村乡',4,'',0,1,0,0),(5929,1195,'高公庄乡',4,'',0,1,0,0),(5930,1196,'东汪镇',4,'',0,1,0,0),(5931,1196,'侯口乡',4,'',0,1,0,0),(5932,1196,'凤凰镇',4,'',0,1,0,0),(5933,1196,'北河庄镇',4,'',0,1,0,0),(5934,1196,'北鱼乡',4,'',0,1,0,0),(5935,1196,'唐邱乡',4,'',0,1,0,0),(5936,1196,'四芝兰镇',4,'',0,1,0,0),(5937,1196,'大曹庄乡',4,'',0,1,0,0),(5938,1196,'大曹庄农场',4,'',0,1,0,0),(5939,1196,'大陆村镇',4,'',0,1,0,0),(5940,1196,'徐家河乡',4,'',0,1,0,0),(5941,1196,'换马店镇',4,'',0,1,0,0),(5942,1196,'河渠镇',4,'',0,1,0,0),(5943,1196,'纪昌庄乡',4,'',0,1,0,0),(5944,1196,'耿庄桥镇',4,'',0,1,0,0),(5945,1196,'苏家庄镇',4,'',0,1,0,0),(5946,1196,'贾家口镇',4,'',0,1,0,0),(5947,1197,'堤村乡',4,'',0,1,0,0),(5948,1197,'官亭镇',4,'',0,1,0,0),(5949,1197,'小吕寨镇',4,'',0,1,0,0),(5950,1197,'巨鹿镇',4,'',0,1,0,0),(5951,1197,'张王疃乡',4,'',0,1,0,0),(5952,1197,'王虎寨镇',4,'',0,1,0,0),(5953,1197,'苏家营乡',4,'',0,1,0,0),(5954,1197,'西郭城镇',4,'',0,1,0,0),(5955,1197,'观寨乡',4,'',0,1,0,0),(5956,1197,'阎疃镇',4,'',0,1,0,0),(5957,1198,'丰州镇',4,'',0,1,0,0),(5958,1198,'寻召乡',4,'',0,1,0,0),(5959,1198,'平乡镇',4,'',0,1,0,0),(5960,1198,'河古庙镇',4,'',0,1,0,0),(5961,1198,'油召乡',4,'',0,1,0,0),(5962,1198,'田付村乡',4,'',0,1,0,0),(5963,1198,'节固乡',4,'',0,1,0,0),(5964,1199,'东召乡',4,'',0,1,0,0),(5965,1199,'件只乡',4,'',0,1,0,0),(5966,1199,'冯家寨乡',4,'',0,1,0,0),(5967,1199,'北塘疃乡',4,'',0,1,0,0),(5968,1199,'大平台乡',4,'',0,1,0,0),(5969,1199,'广宗镇',4,'',0,1,0,0),(5970,1199,'核桃园乡',4,'',0,1,0,0),(5971,1199,'葫芦乡',4,'',0,1,0,0),(5972,1200,'仁让里乡',4,'',0,1,0,0),(5973,1200,'寻寨镇',4,'',0,1,0,0),(5974,1200,'新河镇',4,'',0,1,0,0),(5975,1200,'白神首乡',4,'',0,1,0,0),(5976,1200,'荆家庄乡',4,'',0,1,0,0),(5977,1200,'西流乡',4,'',0,1,0,0),(5978,1201,'内步乡',4,'',0,1,0,0),(5979,1201,'固城店镇',4,'',0,1,0,0),(5980,1201,'柏乡镇',4,'',0,1,0,0),(5981,1201,'王家庄乡',4,'',0,1,0,0),(5982,1201,'西汪乡',4,'',0,1,0,0),(5983,1201,'龙华乡',4,'',0,1,0,0),(5984,1202,'东郭村乡',4,'',0,1,0,0),(5985,1202,'北大街街道',4,'',0,1,0,0),(5986,1202,'南长街街道',4,'',0,1,0,0),(5987,1202,'大梁庄乡',4,'',0,1,0,0),(5988,1202,'西大街街道',4,'',0,1,0,0),(5989,1202,'西门里街道',4,'',0,1,0,0),(5990,1203,'中兴路街道',4,'',0,1,0,0),(5991,1203,'南大郭乡',4,'',0,1,0,0),(5992,1203,'张宽街道',4,'',0,1,0,0),(5993,1203,'李村乡',4,'',0,1,0,0),(5994,1203,'章村街道',4,'',0,1,0,0),(5995,1203,'达活泉街道',4,'',0,1,0,0),(5996,1203,'钢铁路街道',4,'',0,1,0,0),(5997,1204,'册井乡',4,'',0,1,0,0),(5998,1204,'刘石岗乡',4,'',0,1,0,0),(5999,1204,'十里亭镇',4,'',0,1,0,0),(6000,1204,'周庄街道',4,'',0,1,0,0),(6001,1204,'新城镇',4,'',0,1,0,0),(6002,1204,'柴关乡',4,'',0,1,0,0),(6003,1204,'桥东街道',4,'',0,1,0,0),(6004,1204,'桥西街道',4,'',0,1,0,0),(6005,1204,'沙河城镇',4,'',0,1,0,0),(6006,1204,'留村乡',4,'',0,1,0,0),(6007,1204,'白塔镇',4,'',0,1,0,0),(6008,1204,'綦村镇',4,'',0,1,0,0),(6009,1204,'蝉房乡',4,'',0,1,0,0),(6010,1204,'褡裢街道',4,'',0,1,0,0),(6011,1204,'赞善街道',4,'',0,1,0,0),(6012,1205,'坝营镇',4,'',0,1,0,0),(6013,1205,'油坊镇',4,'',0,1,0,0),(6014,1205,'王官庄镇',4,'',0,1,0,0),(6015,1205,'葛仙庄镇',4,'',0,1,0,0),(6016,1205,'谢炉镇',4,'',0,1,0,0),(6017,1205,'连庄镇',4,'',0,1,0,0),(6018,1206,'东汪镇',4,'',0,1,0,0),(6019,1206,'会宁镇',4,'',0,1,0,0),(6020,1206,'冀家村乡',4,'',0,1,0,0),(6021,1206,'北小庄乡',4,'',0,1,0,0),(6022,1206,'南石门镇',4,'',0,1,0,0),(6023,1206,'城计头乡',4,'',0,1,0,0),(6024,1206,'太子井乡',4,'',0,1,0,0),(6025,1206,'宋家庄乡',4,'',0,1,0,0),(6026,1206,'宋家庄镇',4,'',0,1,0,0),(6027,1206,'将军墓镇',4,'',0,1,0,0),(6028,1206,'晏家屯镇',4,'',0,1,0,0),(6029,1206,'浆水镇',4,'',0,1,0,0),(6030,1206,'王快镇',4,'',0,1,0,0),(6031,1206,'白岸乡',4,'',0,1,0,0),(6032,1206,'皇寺镇',4,'',0,1,0,0),(6033,1206,'祝村镇',4,'',0,1,0,0),(6034,1206,'羊范镇',4,'',0,1,0,0),(6035,1206,'西黄村镇',4,'',0,1,0,0),(6036,1206,'豫让桥街道',4,'',0,1,0,0),(6037,1206,'路罗镇',4,'',0,1,0,0),(6038,1206,'龙泉寺乡',4,'',0,1,0,0),(6039,1207,'东良乡',4,'',0,1,0,0),(6040,1207,'北楼乡',4,'',0,1,0,0),(6041,1207,'千户营乡',4,'',0,1,0,0),(6042,1207,'双碑乡',4,'',0,1,0,0),(6043,1207,'固城镇',4,'',0,1,0,0),(6044,1207,'大张庄乡',4,'',0,1,0,0),(6045,1207,'尹村镇',4,'',0,1,0,0),(6046,1207,'山口镇',4,'',0,1,0,0),(6047,1207,'牛家桥乡',4,'',0,1,0,0),(6048,1207,'莲子镇',4,'',0,1,0,0),(6049,1207,'隆尧镇',4,'',0,1,0,0),(6050,1207,'魏家庄镇',4,'',0,1,0,0),(6051,1208,'东关街道',4,'',0,1,0,0),(6052,1208,'东金庄乡',4,'',0,1,0,0),(6053,1208,'中华路街道',4,'',0,1,0,0),(6054,1208,'五四路街道',4,'',0,1,0,0),(6055,1208,'和平里街道',4,'',0,1,0,0),(6056,1208,'百楼乡',4,'',0,1,0,0),(6057,1208,'西关街道',4,'',0,1,0,0),(6058,1208,'韩庄乡',4,'',0,1,0,0),(6059,1209,'五尧乡',4,'',0,1,0,0),(6060,1209,'南关街道',4,'',0,1,0,0),(6061,1209,'南大园乡',4,'',0,1,0,0),(6062,1209,'杨庄乡',4,'',0,1,0,0),(6063,1209,'永华街道',4,'',0,1,0,0),(6064,1209,'焦庄乡',4,'',0,1,0,0),(6065,1209,'红星街道',4,'',0,1,0,0),(6066,1209,'联盟街道',4,'',0,1,0,0),(6067,1209,'裕华街道',4,'',0,1,0,0),(6068,1210,'东墟乡',4,'',0,1,0,0),(6069,1210,'北杨村乡',4,'',0,1,0,0),(6070,1210,'南小王乡',4,'',0,1,0,0),(6071,1210,'博野镇',4,'',0,1,0,0),(6072,1210,'城东乡',4,'',0,1,0,0),(6073,1210,'小店镇',4,'',0,1,0,0),(6074,1210,'程委镇',4,'',0,1,0,0),(6075,1211,'仁厚镇',4,'',0,1,0,0),(6076,1211,'倒马关乡',4,'',0,1,0,0),(6077,1211,'军城镇',4,'',0,1,0,0),(6078,1211,'北店头乡',4,'',0,1,0,0),(6079,1211,'北罗镇',4,'',0,1,0,0),(6080,1211,'南店头乡',4,'',0,1,0,0),(6081,1211,'大洋乡',4,'',0,1,0,0),(6082,1211,'川里镇',4,'',0,1,0,0),(6083,1211,'王京镇',4,'',0,1,0,0),(6084,1211,'白合镇',4,'',0,1,0,0),(6085,1211,'石门乡',4,'',0,1,0,0),(6086,1211,'罗庄乡',4,'',0,1,0,0),(6087,1211,'羊角乡',4,'',0,1,0,0),(6088,1211,'迷城乡',4,'',0,1,0,0),(6089,1211,'都亭乡',4,'',0,1,0,0),(6090,1211,'长古城乡',4,'',0,1,0,0),(6091,1211,'雹水乡',4,'',0,1,0,0),(6092,1211,'高昌镇',4,'',0,1,0,0),(6093,1211,'黄石口乡',4,'',0,1,0,0),(6094,1211,'齐家佐乡',4,'',0,1,0,0),(6095,1212,'伍仁桥镇',4,'',0,1,0,0),(6096,1212,'北段村乡',4,'',0,1,0,0),(6097,1212,'南娄底乡',4,'',0,1,0,0),(6098,1212,'大五女镇',4,'',0,1,0,0),(6099,1212,'明官店乡',4,'',0,1,0,0),(6100,1212,'石佛镇',4,'',0,1,0,0),(6101,1212,'祁州药市街道',4,'',0,1,0,0),(6102,1212,'祁州镇',4,'',0,1,0,0),(6103,1212,'西佛落乡',4,'',0,1,0,0),(6104,1212,'西安国城乡',4,'',0,1,0,0),(6105,1212,'郑章镇',4,'',0,1,0,0),(6106,1213,'三台镇',4,'',0,1,0,0),(6107,1213,'刘李庄镇',4,'',0,1,0,0),(6108,1213,'同口镇',4,'',0,1,0,0),(6109,1213,'圈头乡',4,'',0,1,0,0),(6110,1213,'大王镇',4,'',0,1,0,0),(6111,1213,'安州镇',4,'',0,1,0,0),(6112,1213,'安新镇',4,'',0,1,0,0),(6113,1213,'寨里乡',4,'',0,1,0,0),(6114,1213,'端村镇',4,'',0,1,0,0),(6115,1213,'老河头镇',4,'',0,1,0,0),(6116,1213,'芦庄乡',4,'',0,1,0,0),(6117,1213,'赵北口镇',4,'',0,1,0,0),(6118,1214,'东落堡乡',4,'',0,1,0,0),(6119,1214,'北南蔡乡',4,'',0,1,0,0),(6120,1214,'北河镇',4,'',0,1,0,0),(6121,1214,'北田乡',4,'',0,1,0,0),(6122,1214,'固城镇',4,'',0,1,0,0),(6123,1214,'天宫寺乡',4,'',0,1,0,0),(6124,1214,'姚村乡',4,'',0,1,0,0),(6125,1214,'定兴镇',4,'',0,1,0,0),(6126,1214,'小朱庄乡',4,'',0,1,0,0),(6127,1214,'张家庄乡',4,'',0,1,0,0),(6128,1214,'李郁庄乡',4,'',0,1,0,0),(6129,1214,'杨村乡',4,'',0,1,0,0),(6130,1214,'柳卓乡',4,'',0,1,0,0),(6131,1214,'肖村乡',4,'',0,1,0,0),(6132,1214,'贤寓镇',4,'',0,1,0,0),(6133,1214,'高里乡',4,'',0,1,0,0),(6134,1215,'东亭镇',4,'',0,1,0,0),(6135,1215,'东旺镇',4,'',0,1,0,0),(6136,1215,'东留春乡',4,'',0,1,0,0),(6137,1215,'北城区街道',4,'',0,1,0,0),(6138,1215,'南城区街道',4,'',0,1,0,0),(6139,1215,'叮咛店镇',4,'',0,1,0,0),(6140,1215,'号头庄回族乡',4,'',0,1,0,0),(6141,1215,'周村乡',4,'',0,1,0,0),(6142,1215,'大辛庄镇',4,'',0,1,0,0),(6143,1215,'大鹿庄乡',4,'',0,1,0,0),(6144,1215,'子位镇',4,'',0,1,0,0),(6145,1215,'庞村镇',4,'',0,1,0,0),(6146,1215,'开元镇',4,'',0,1,0,0),(6147,1215,'息冢乡',4,'',0,1,0,0),(6148,1215,'明月店镇',4,'',0,1,0,0),(6149,1215,'李亲顾镇',4,'',0,1,0,0),(6150,1215,'杨家庄乡',4,'',0,1,0,0),(6151,1215,'清风店镇',4,'',0,1,0,0),(6152,1215,'留早镇',4,'',0,1,0,0),(6153,1215,'砖路镇',4,'',0,1,0,0),(6154,1215,'西城乡',4,'',0,1,0,0),(6155,1215,'西城区街道',4,'',0,1,0,0),(6156,1215,'赵村乡',4,'',0,1,0,0),(6157,1215,'邢邑镇',4,'',0,1,0,0),(6158,1215,'高蓬镇',4,'',0,1,0,0),(6159,1216,'八于乡',4,'',0,1,0,0),(6160,1216,'南张镇',4,'',0,1,0,0),(6161,1216,'大河镇',4,'',0,1,0,0),(6162,1216,'容城镇',4,'',0,1,0,0),(6163,1216,'小里镇',4,'',0,1,0,0),(6164,1216,'平王乡',4,'',0,1,0,0),(6165,1216,'晾马台乡',4,'',0,1,0,0),(6166,1216,'贾光乡',4,'',0,1,0,0),(6167,1217,'东史端乡',4,'',0,1,0,0),(6168,1217,'东釜山乡',4,'',0,1,0,0),(6169,1217,'义联庄乡',4,'',0,1,0,0),(6170,1217,'大因镇',4,'',0,1,0,0),(6171,1217,'大王店镇',4,'',0,1,0,0),(6172,1217,'安肃镇',4,'',0,1,0,0),(6173,1217,'崔庄镇',4,'',0,1,0,0),(6174,1217,'户木乡',4,'',0,1,0,0),(6175,1217,'正村乡',4,'',0,1,0,0),(6176,1217,'漕河镇',4,'',0,1,0,0),(6177,1217,'瀑河乡',4,'',0,1,0,0),(6178,1217,'留村乡',4,'',0,1,0,0),(6179,1217,'遂城镇',4,'',0,1,0,0),(6180,1217,'高林村镇',4,'',0,1,0,0),(6181,1218,'东风街道',4,'',0,1,0,0),(6182,1218,'先锋街道',4,'',0,1,0,0),(6183,1218,'南奇乡',4,'',0,1,0,0),(6184,1218,'大马坊乡',4,'',0,1,0,0),(6185,1218,'富昌乡',4,'',0,1,0,0),(6186,1218,'建设南路街道',4,'',0,1,0,0),(6187,1218,'新市场街道',4,'',0,1,0,0),(6188,1218,'江城乡',4,'',0,1,0,0),(6189,1218,'韩村乡',4,'',0,1,0,0),(6190,1218,'韩村北路街道',4,'',0,1,0,0),(6191,1218,'颉庄乡',4,'',0,1,0,0),(6192,1219,'七峪乡',4,'',0,1,0,0),(6193,1219,'凌云册回族满族乡',4,'',0,1,0,0),(6194,1219,'南城司乡',4,'',0,1,0,0),(6195,1219,'坡仓乡',4,'',0,1,0,0),(6196,1219,'塘湖镇',4,'',0,1,0,0),(6197,1219,'大龙华乡',4,'',0,1,0,0),(6198,1219,'安格庄乡',4,'',0,1,0,0),(6199,1219,'富岗乡',4,'',0,1,0,0),(6200,1219,'尉都乡',4,'',0,1,0,0),(6201,1219,'易州镇',4,'',0,1,0,0),(6202,1219,'桥头乡',4,'',0,1,0,0),(6203,1219,'桥家河乡',4,'',0,1,0,0),(6204,1219,'梁格庄镇',4,'',0,1,0,0),(6205,1219,'流井乡',4,'',0,1,0,0),(6206,1219,'牛岗乡',4,'',0,1,0,0),(6207,1219,'独乐乡',4,'',0,1,0,0),(6208,1219,'狼牙山镇',4,'',0,1,0,0),(6209,1219,'甘河净乡',4,'',0,1,0,0),(6210,1219,'白马乡',4,'',0,1,0,0),(6211,1219,'紫荆关镇',4,'',0,1,0,0),(6212,1219,'良岗镇',4,'',0,1,0,0),(6213,1219,'蔡家峪乡',4,'',0,1,0,0),(6214,1219,'裴山镇',4,'',0,1,0,0),(6215,1219,'西山北乡',4,'',0,1,0,0),(6216,1219,'西陵镇',4,'',0,1,0,0),(6217,1219,'高村乡',4,'',0,1,0,0),(6218,1219,'高陌乡',4,'',0,1,0,0),(6219,1220,'下河乡',4,'',0,1,0,0),(6220,1220,'东旺乡',4,'',0,1,0,0),(6221,1220,'产德乡',4,'',0,1,0,0),(6222,1220,'党城乡',4,'',0,1,0,0),(6223,1220,'北台乡',4,'',0,1,0,0),(6224,1220,'孝墓乡',4,'',0,1,0,0),(6225,1220,'庄窠乡',4,'',0,1,0,0),(6226,1220,'恒州镇',4,'',0,1,0,0),(6227,1220,'文德乡',4,'',0,1,0,0),(6228,1220,'晓林乡',4,'',0,1,0,0),(6229,1220,'灵山镇',4,'',0,1,0,0),(6230,1220,'燕赵镇',4,'',0,1,0,0),(6231,1220,'羊平镇',4,'',0,1,0,0),(6232,1220,'范家庄乡',4,'',0,1,0,0),(6233,1220,'路庄子乡',4,'',0,1,0,0),(6234,1220,'邸村乡',4,'',0,1,0,0),(6235,1220,'郎家庄乡',4,'',0,1,0,0),(6236,1220,'齐村乡',4,'',0,1,0,0),(6237,1221,'中韩庄乡',4,'',0,1,0,0),(6238,1221,'固店镇',4,'',0,1,0,0),(6239,1221,'寺庄乡',4,'',0,1,0,0),(6240,1221,'望都镇',4,'',0,1,0,0),(6241,1221,'贾村乡',4,'',0,1,0,0),(6242,1221,'赵庄乡',4,'',0,1,0,0),(6243,1221,'高岭乡',4,'',0,1,0,0),(6244,1221,'黑堡乡',4,'',0,1,0,0),(6245,1222,'三坡镇',4,'',0,1,0,0),(6246,1222,'东文山乡',4,'',0,1,0,0),(6247,1222,'义安镇',4,'',0,1,0,0),(6248,1222,'九龙镇',4,'',0,1,0,0),(6249,1222,'其中口乡',4,'',0,1,0,0),(6250,1222,'娄村满族乡',4,'',0,1,0,0),(6251,1222,'宋各庄乡',4,'',0,1,0,0),(6252,1222,'明义乡',4,'',0,1,0,0),(6253,1222,'永阳镇',4,'',0,1,0,0),(6254,1222,'涞水镇',4,'',0,1,0,0),(6255,1222,'王村乡',4,'',0,1,0,0),(6256,1222,'石亭镇',4,'',0,1,0,0),(6257,1222,'胡家庄乡',4,'',0,1,0,0),(6258,1222,'赵各庄镇',4,'',0,1,0,0),(6259,1222,'龙门乡',4,'',0,1,0,0),(6260,1223,'上庄乡',4,'',0,1,0,0),(6261,1223,'下北头乡',4,'',0,1,0,0),(6262,1223,'东团堡乡',4,'',0,1,0,0),(6263,1223,'乌龙沟乡',4,'',0,1,0,0),(6264,1223,'北石佛乡',4,'',0,1,0,0),(6265,1223,'南屯乡',4,'',0,1,0,0),(6266,1223,'塔崖驿乡',4,'',0,1,0,0),(6267,1223,'杨家庄镇',4,'',0,1,0,0),(6268,1223,'水堡镇',4,'',0,1,0,0),(6269,1223,'涞源镇',4,'',0,1,0,0),(6270,1223,'烟煤洞乡',4,'',0,1,0,0),(6271,1223,'王安镇',4,'',0,1,0,0),(6272,1223,'留家庄乡',4,'',0,1,0,0),(6273,1223,'走马驿镇',4,'',0,1,0,0),(6274,1223,'金家井乡',4,'',0,1,0,0),(6275,1223,'银坊镇',4,'',0,1,0,0),(6276,1223,'马庄乡',4,'',0,1,0,0),(6277,1224,'东仙坡镇',4,'',0,1,0,0),(6278,1224,'东城坊镇',4,'',0,1,0,0),(6279,1224,'义合庄乡',4,'',0,1,0,0),(6280,1224,'刁窝乡',4,'',0,1,0,0),(6281,1224,'双塔街道',4,'',0,1,0,0),(6282,1224,'孙庄乡',4,'',0,1,0,0),(6283,1224,'松林店镇',4,'',0,1,0,0),(6284,1224,'林家屯乡',4,'',0,1,0,0),(6285,1224,'桃园街道',4,'',0,1,0,0),(6286,1224,'清凉寺街道',4,'',0,1,0,0),(6287,1224,'百尺竿乡',4,'',0,1,0,0),(6288,1224,'码头镇',4,'',0,1,0,0),(6289,1224,'豆庄乡',4,'',0,1,0,0),(6290,1224,'高官庄镇',4,'',0,1,0,0),(6291,1225,'东吕乡',4,'',0,1,0,0),(6292,1225,'何桥乡',4,'',0,1,0,0),(6293,1225,'冉庄镇',4,'',0,1,0,0),(6294,1225,'北店乡',4,'',0,1,0,0),(6295,1225,'北王力乡',4,'',0,1,0,0),(6296,1225,'大庄镇',4,'',0,1,0,0),(6297,1225,'孙村乡',4,'',0,1,0,0),(6298,1225,'张登镇',4,'',0,1,0,0),(6299,1225,'望亭乡',4,'',0,1,0,0),(6300,1225,'李庄乡',4,'',0,1,0,0),(6301,1225,'清苑镇',4,'',0,1,0,0),(6302,1225,'温仁镇',4,'',0,1,0,0),(6303,1225,'白团乡',4,'',0,1,0,0),(6304,1225,'石桥乡',4,'',0,1,0,0),(6305,1225,'臧村镇',4,'',0,1,0,0),(6306,1225,'阎庄乡',4,'',0,1,0,0),(6307,1225,'阳城镇',4,'',0,1,0,0),(6308,1225,'魏村镇',4,'',0,1,0,0),(6309,1226,'于家庄乡',4,'',0,1,0,0),(6310,1226,'刘家台乡',4,'',0,1,0,0),(6311,1226,'南韩村镇',4,'',0,1,0,0),(6312,1226,'坨南乡',4,'',0,1,0,0),(6313,1226,'大册营镇',4,'',0,1,0,0),(6314,1226,'惠阳街道',4,'',0,1,0,0),(6315,1226,'方顺桥乡',4,'',0,1,0,0),(6316,1226,'满城镇',4,'',0,1,0,0),(6317,1226,'白龙乡',4,'',0,1,0,0),(6318,1226,'石井乡',4,'',0,1,0,0),(6319,1226,'神星镇',4,'',0,1,0,0),(6320,1226,'要庄乡',4,'',0,1,0,0),(6321,1226,'贤台乡',4,'',0,1,0,0),(6322,1227,'万安镇',4,'',0,1,0,0),(6323,1227,'北埝头乡',4,'',0,1,0,0),(6324,1227,'北郭丹镇',4,'',0,1,0,0),(6325,1227,'南庄镇',4,'',0,1,0,0),(6326,1227,'大曲堤乡',4,'',0,1,0,0),(6327,1227,'大百尺镇',4,'',0,1,0,0),(6328,1227,'小陈乡',4,'',0,1,0,0),(6329,1227,'林堡乡',4,'',0,1,0,0),(6330,1227,'桑园镇',4,'',0,1,0,0),(6331,1227,'留史镇',4,'',0,1,0,0),(6332,1227,'蠡吾镇',4,'',0,1,0,0),(6333,1227,'辛兴镇',4,'',0,1,0,0),(6334,1227,'鲍墟乡',4,'',0,1,0,0),(6335,1228,'下庄乡',4,'',0,1,0,0),(6336,1228,'东下关乡',4,'',0,1,0,0),(6337,1228,'北果元乡',4,'',0,1,0,0),(6338,1228,'台峪乡',4,'',0,1,0,0),(6339,1228,'史家寨乡',4,'',0,1,0,0),(6340,1228,'吴王口乡',4,'',0,1,0,0),(6341,1228,'城南庄镇',4,'',0,1,0,0),(6342,1228,'大台乡',4,'',0,1,0,0),(6343,1228,'平阳镇',4,'',0,1,0,0),(6344,1228,'王林口乡',4,'',0,1,0,0),(6345,1228,'砂窝乡',4,'',0,1,0,0),(6346,1228,'阜平镇',4,'',0,1,0,0),(6347,1228,'龙泉关镇',4,'',0,1,0,0),(6348,1229,'北沙口乡',4,'',0,1,0,0),(6349,1229,'双堂乡',4,'',0,1,0,0),(6350,1229,'大营镇',4,'',0,1,0,0),(6351,1229,'张岗乡',4,'',0,1,0,0),(6352,1229,'昝岗镇',4,'',0,1,0,0),(6353,1229,'朱各庄乡',4,'',0,1,0,0),(6354,1229,'米家务乡',4,'',0,1,0,0),(6355,1229,'雄州镇',4,'',0,1,0,0),(6356,1229,'龙湾乡',4,'',0,1,0,0),(6357,1230,'台鱼乡',4,'',0,1,0,0),(6358,1230,'大悲乡',4,'',0,1,0,0),(6359,1230,'安阳乡',4,'',0,1,0,0),(6360,1230,'河口乡',4,'',0,1,0,0),(6361,1230,'白云乡',4,'',0,1,0,0),(6362,1230,'神南乡',4,'',0,1,0,0),(6363,1230,'腰山镇',4,'',0,1,0,0),(6364,1230,'蒲上乡',4,'',0,1,0,0),(6365,1230,'蒲阳镇',4,'',0,1,0,0),(6366,1230,'高于铺镇',4,'',0,1,0,0),(6367,1231,'东盛街道',4,'',0,1,0,0),(6368,1231,'东马营乡',4,'',0,1,0,0),(6369,1231,'兴华路街道',4,'',0,1,0,0),(6370,1231,'军城街道',4,'',0,1,0,0),(6371,1231,'北城街道',4,'',0,1,0,0),(6372,1231,'和平街道',4,'',0,1,0,0),(6373,1231,'张六庄乡',4,'',0,1,0,0),(6374,1231,'新城镇',4,'',0,1,0,0),(6375,1231,'方官镇',4,'',0,1,0,0),(6376,1231,'梁家营乡',4,'',0,1,0,0),(6377,1231,'泗庄镇',4,'',0,1,0,0),(6378,1231,'白沟镇',4,'',0,1,0,0),(6379,1231,'肖官营乡',4,'',0,1,0,0),(6380,1231,'辛桥乡',4,'',0,1,0,0),(6381,1231,'辛立庄镇',4,'',0,1,0,0),(6382,1232,'小王果庄',4,'',0,1,0,0),(6383,1232,'庞口镇',4,'',0,1,0,0),(6384,1232,'庞家佐乡',4,'',0,1,0,0),(6385,1232,'晋庄乡',4,'',0,1,0,0),(6386,1232,'蒲口乡',4,'',0,1,0,0),(6387,1232,'西演镇',4,'',0,1,0,0),(6388,1232,'邢家南乡',4,'',0,1,0,0),(6389,1232,'高阳镇',4,'',0,1,0,0),(6390,1232,'龙化乡',4,'',0,1,0,0),(6391,1233,'万全镇',4,'',0,1,0,0),(6392,1233,'北新屯乡',4,'',0,1,0,0),(6393,1233,'北沙城乡',4,'',0,1,0,0),(6394,1233,'孔家庄镇',4,'',0,1,0,0),(6395,1233,'安家堡乡',4,'',0,1,0,0),(6396,1233,'宣平堡乡',4,'',0,1,0,0),(6397,1233,'旧堡乡',4,'',0,1,0,0),(6398,1233,'洗马林镇',4,'',0,1,0,0),(6399,1233,'膳房堡乡',4,'',0,1,0,0),(6400,1233,'郭磊庄镇',4,'',0,1,0,0),(6401,1233,'高庙堡乡',4,'',0,1,0,0),(6402,1234,'城镇街道',4,'',0,1,0,0),(6403,1234,'定方水乡',4,'',0,1,0,0),(6404,1234,'段家堡乡',4,'',0,1,0,0),(6405,1234,'煤矿街道',4,'',0,1,0,0),(6406,1234,'花园乡',4,'',0,1,0,0),(6407,1234,'辛庄子乡',4,'',0,1,0,0),(6408,1235,'侯家庙乡',4,'',0,1,0,0),(6409,1235,'南关街道',4,'',0,1,0,0),(6410,1235,'南大街街道',4,'',0,1,0,0),(6411,1235,'大北街街道',4,'',0,1,0,0),(6412,1235,'天泰寺街道',4,'',0,1,0,0),(6413,1235,'工业街街道',4,'',0,1,0,0),(6414,1235,'庞家堡镇',4,'',0,1,0,0),(6415,1235,'建国街街道',4,'',0,1,0,0),(6416,1235,'春光乡',4,'',0,1,0,0),(6417,1235,'河子西乡',4,'',0,1,0,0),(6418,1235,'皇城街道',4,'',0,1,0,0),(6419,1236,'东望山乡',4,'',0,1,0,0),(6420,1236,'塔儿村乡',4,'',0,1,0,0),(6421,1236,'大仓盖镇',4,'',0,1,0,0),(6422,1236,'姚家房镇',4,'',0,1,0,0),(6423,1236,'崞村镇',4,'',0,1,0,0),(6424,1236,'李家堡乡',4,'',0,1,0,0),(6425,1236,'江家屯乡',4,'',0,1,0,0),(6426,1236,'沙岭子镇',4,'',0,1,0,0),(6427,1236,'洋河南镇',4,'',0,1,0,0),(6428,1236,'深井镇',4,'',0,1,0,0),(6429,1236,'王家湾乡',4,'',0,1,0,0),(6430,1236,'贾家营镇',4,'',0,1,0,0),(6431,1236,'赵川镇',4,'',0,1,0,0),(6432,1236,'顾家营镇',4,'',0,1,0,0),(6433,1237,'七甲乡',4,'',0,1,0,0),(6434,1237,'三工地镇',4,'',0,1,0,0),(6435,1237,'下马圈乡',4,'',0,1,0,0),(6436,1237,'八道沟镇',4,'',0,1,0,0),(6437,1237,'南壕堑镇',4,'',0,1,0,0),(6438,1237,'大苏计乡',4,'',0,1,0,0),(6439,1237,'大营盘乡',4,'',0,1,0,0),(6440,1237,'大青沟镇',4,'',0,1,0,0),(6441,1237,'套里庄乡',4,'',0,1,0,0),(6442,1237,'小蒜沟镇',4,'',0,1,0,0),(6443,1237,'炕塄乡',4,'',0,1,0,0),(6444,1237,'甲石河乡',4,'',0,1,0,0),(6445,1237,'石井乡',4,'',0,1,0,0),(6446,1237,'红土梁镇',4,'',0,1,0,0),(6447,1238,'四台嘴乡',4,'',0,1,0,0),(6448,1238,'清三营乡',4,'',0,1,0,0),(6449,1238,'狮子沟乡',4,'',0,1,0,0),(6450,1238,'白旗乡',4,'',0,1,0,0),(6451,1238,'石嘴子乡',4,'',0,1,0,0),(6452,1238,'石窑子乡',4,'',0,1,0,0),(6453,1238,'红旗营乡',4,'',0,1,0,0),(6454,1238,'西湾子镇',4,'',0,1,0,0),(6455,1238,'驿马图乡',4,'',0,1,0,0),(6456,1238,'高家营镇',4,'',0,1,0,0),(6457,1239,'丹清河乡',4,'',0,1,0,0),(6458,1239,'二号卜乡',4,'',0,1,0,0),(6459,1239,'哈必嘎乡',4,'',0,1,0,0),(6460,1239,'土城子镇',4,'',0,1,0,0),(6461,1239,'处长地乡',4,'',0,1,0,0),(6462,1239,'屯垦镇',4,'',0,1,0,0),(6463,1239,'康保镇',4,'',0,1,0,0),(6464,1239,'张纪镇',4,'',0,1,0,0),(6465,1239,'忠义乡',4,'',0,1,0,0),(6466,1239,'李家地镇',4,'',0,1,0,0),(6467,1239,'满德堂乡',4,'',0,1,0,0),(6468,1239,'照阳河镇',4,'',0,1,0,0),(6469,1239,'芦家营乡',4,'',0,1,0,0),(6470,1239,'邓油坊镇',4,'',0,1,0,0),(6471,1239,'阎油房乡',4,'',0,1,0,0),(6472,1240,'三号乡',4,'',0,1,0,0),(6473,1240,'两面井乡',4,'',0,1,0,0),(6474,1240,'二台镇',4,'',0,1,0,0),(6475,1240,'二泉井乡',4,'',0,1,0,0),(6476,1240,'公会镇',4,'',0,1,0,0),(6477,1240,'单晶河乡',4,'',0,1,0,0),(6478,1240,'台路沟乡',4,'',0,1,0,0),(6479,1240,'大囫囵镇',4,'',0,1,0,0),(6480,1240,'大河乡',4,'',0,1,0,0),(6481,1240,'小二台乡',4,'',0,1,0,0),(6482,1240,'张北镇',4,'',0,1,0,0),(6483,1240,'战海乡',4,'',0,1,0,0),(6484,1240,'油篓沟乡',4,'',0,1,0,0),(6485,1240,'海流图乡',4,'',0,1,0,0),(6486,1240,'白庙滩乡',4,'',0,1,0,0),(6487,1240,'郝家营乡',4,'',0,1,0,0),(6488,1240,'馒头营乡',4,'',0,1,0,0),(6489,1240,'黄石崖乡',4,'',0,1,0,0),(6490,1241,'太平庄乡',4,'',0,1,0,0),(6491,1241,'头百户镇',4,'',0,1,0,0),(6492,1241,'左卫镇',4,'',0,1,0,0),(6493,1241,'怀安城镇',4,'',0,1,0,0),(6494,1241,'柴沟堡镇',4,'',0,1,0,0),(6495,1241,'渡口堡乡',4,'',0,1,0,0),(6496,1241,'王虎屯乡',4,'',0,1,0,0),(6497,1241,'第三堡乡',4,'',0,1,0,0),(6498,1241,'第六屯乡',4,'',0,1,0,0),(6499,1241,'西沙城乡',4,'',0,1,0,0),(6500,1241,'西湾堡乡',4,'',0,1,0,0),(6501,1242,'东八里乡',4,'',0,1,0,0),(6502,1242,'东花园镇',4,'',0,1,0,0),(6503,1242,'北辛堡镇',4,'',0,1,0,0),(6504,1242,'土木镇',4,'',0,1,0,0),(6505,1242,'大黄庄镇',4,'',0,1,0,0),(6506,1242,'存瑞镇',4,'',0,1,0,0),(6507,1242,'孙庄子乡',4,'',0,1,0,0),(6508,1242,'官厅镇',4,'',0,1,0,0),(6509,1242,'小南辛堡镇',4,'',0,1,0,0),(6510,1242,'新保安镇',4,'',0,1,0,0),(6511,1242,'桑园镇',4,'',0,1,0,0),(6512,1242,'沙城镇',4,'',0,1,0,0),(6513,1242,'狼山乡',4,'',0,1,0,0),(6514,1242,'王家楼回族乡',4,'',0,1,0,0),(6515,1242,'瑞云观乡',4,'',0,1,0,0),(6516,1242,'西八里镇',4,'',0,1,0,0),(6517,1242,'鸡鸣驿乡',4,'',0,1,0,0),(6518,1243,'五一路街道',4,'',0,1,0,0),(6519,1243,'南站街道',4,'',0,1,0,0),(6520,1243,'姚家庄镇',4,'',0,1,0,0),(6521,1243,'工业路街道',4,'',0,1,0,0),(6522,1243,'红旗楼街道',4,'',0,1,0,0),(6523,1243,'老鸦庄镇',4,'',0,1,0,0),(6524,1243,'胜利北路街道',4,'',0,1,0,0),(6525,1243,'花园街街道',4,'',0,1,0,0),(6526,1243,'马路东街道',4,'',0,1,0,0),(6527,1244,'东窑子镇',4,'',0,1,0,0),(6528,1244,'南营坊街道',4,'',0,1,0,0),(6529,1244,'堡子里街道',4,'',0,1,0,0),(6530,1244,'大境门街道',4,'',0,1,0,0),(6531,1244,'工人新村街道',4,'',0,1,0,0),(6532,1244,'新华街街道',4,'',0,1,0,0),(6533,1244,'明德北街街道',4,'',0,1,0,0),(6534,1244,'明德南街街道',4,'',0,1,0,0),(6535,1244,'沈家屯镇',4,'',0,1,0,0),(6536,1245,'丰源店乡',4,'',0,1,0,0),(6537,1245,'九连城镇',4,'',0,1,0,0),(6538,1245,'二道渠乡',4,'',0,1,0,0),(6539,1245,'大二号回族乡',4,'',0,1,0,0),(6540,1245,'小厂镇',4,'',0,1,0,0),(6541,1245,'小河子乡',4,'',0,1,0,0),(6542,1245,'平定堡镇',4,'',0,1,0,0),(6543,1245,'白土窑乡',4,'',0,1,0,0),(6544,1245,'莲花滩乡',4,'',0,1,0,0),(6545,1245,'西辛营乡',4,'',0,1,0,0),(6546,1245,'长梁乡',4,'',0,1,0,0),(6547,1245,'闪电河乡',4,'',0,1,0,0),(6548,1245,'高山堡乡',4,'',0,1,0,0),(6549,1245,'黄盖淖镇',4,'',0,1,0,0),(6550,1246,'东小庄乡',4,'',0,1,0,0),(6551,1246,'五堡镇',4,'',0,1,0,0),(6552,1246,'保岱镇',4,'',0,1,0,0),(6553,1246,'卧佛寺乡',4,'',0,1,0,0),(6554,1246,'大堡镇',4,'',0,1,0,0),(6555,1246,'大河南乡',4,'',0,1,0,0),(6556,1246,'张家堡镇',4,'',0,1,0,0),(6557,1246,'栾庄乡',4,'',0,1,0,0),(6558,1246,'武家沟镇',4,'',0,1,0,0),(6559,1246,'河东镇',4,'',0,1,0,0),(6560,1246,'涿鹿镇',4,'',0,1,0,0),(6561,1246,'温泉屯乡',4,'',0,1,0,0),(6562,1246,'矾山镇',4,'',0,1,0,0),(6563,1246,'蟒石口乡',4,'',0,1,0,0),(6564,1246,'谢家堡乡',4,'',0,1,0,0),(6565,1246,'赵家蓬区',4,'',0,1,0,0),(6566,1246,'辉耀乡',4,'',0,1,0,0),(6567,1246,'黑山寺乡',4,'',0,1,0,0),(6568,1247,'下宫村乡',4,'',0,1,0,0),(6569,1247,'代王城镇',4,'',0,1,0,0),(6570,1247,'北水泉镇',4,'',0,1,0,0),(6571,1247,'南岭庄乡',4,'',0,1,0,0),(6572,1247,'南杨庄乡',4,'',0,1,0,0),(6573,1247,'南留庄镇',4,'',0,1,0,0),(6574,1247,'吉家庄镇',4,'',0,1,0,0),(6575,1247,'宋庄镇',4,'',0,1,0,0),(6576,1247,'常宁乡',4,'',0,1,0,0),(6577,1247,'暖泉镇',4,'',0,1,0,0),(6578,1247,'杨庄窠乡',4,'',0,1,0,0),(6579,1247,'柏树乡',4,'',0,1,0,0),(6580,1247,'桃花镇',4,'',0,1,0,0),(6581,1247,'涌泉庄乡',4,'',0,1,0,0),(6582,1247,'白乐镇',4,'',0,1,0,0),(6583,1247,'白草村乡',4,'',0,1,0,0),(6584,1247,'草沟堡乡',4,'',0,1,0,0),(6585,1247,'蔚州镇',4,'',0,1,0,0),(6586,1247,'西合营镇',4,'',0,1,0,0),(6587,1247,'阳眷镇',4,'',0,1,0,0),(6588,1247,'陈家洼乡',4,'',0,1,0,0),(6589,1247,'黄梅乡',4,'',0,1,0,0),(6590,1248,'三道川乡',4,'',0,1,0,0),(6591,1248,'东万口乡',4,'',0,1,0,0),(6592,1248,'东卯镇',4,'',0,1,0,0),(6593,1248,'云州乡',4,'',0,1,0,0),(6594,1248,'后城镇',4,'',0,1,0,0),(6595,1248,'大海陀乡',4,'',0,1,0,0),(6596,1248,'样田乡',4,'',0,1,0,0),(6597,1248,'炮梁乡',4,'',0,1,0,0),(6598,1248,'独石口镇',4,'',0,1,0,0),(6599,1248,'田家窑镇',4,'',0,1,0,0),(6600,1248,'白草镇',4,'',0,1,0,0),(6601,1248,'茨营子乡',4,'',0,1,0,0),(6602,1248,'赤城镇',4,'',0,1,0,0),(6603,1248,'镇宁堡乡',4,'',0,1,0,0),(6604,1248,'雕鹗镇',4,'',0,1,0,0),(6605,1248,'马营乡',4,'',0,1,0,0),(6606,1248,'龙关镇',4,'',0,1,0,0),(6607,1248,'龙门所镇',4,'',0,1,0,0),(6608,1249,'三马坊乡',4,'',0,1,0,0),(6609,1249,'东井集镇',4,'',0,1,0,0),(6610,1249,'东坊城堡乡',4,'',0,1,0,0),(6611,1249,'东城镇',4,'',0,1,0,0),(6612,1249,'井儿沟乡',4,'',0,1,0,0),(6613,1249,'化稍营镇',4,'',0,1,0,0),(6614,1249,'大田洼乡',4,'',0,1,0,0),(6615,1249,'揣骨疃镇',4,'',0,1,0,0),(6616,1249,'浮图讲乡',4,'',0,1,0,0),(6617,1249,'西城镇',4,'',0,1,0,0),(6618,1249,'要家庄乡',4,'',0,1,0,0),(6619,1249,'辛堡乡',4,'',0,1,0,0),(6620,1249,'马圈堡乡',4,'',0,1,0,0),(6621,1249,'高墙乡',4,'',0,1,0,0),(6622,1250,'万胜永乡',4,'',0,1,0,0),(6623,1250,'五道营乡',4,'',0,1,0,0),(6624,1250,'凤山镇',4,'',0,1,0,0),(6625,1250,'北头营乡',4,'',0,1,0,0),(6626,1250,'南关蒙古族乡',4,'',0,1,0,0),(6627,1250,'四岔口乡',4,'',0,1,0,0),(6628,1250,'土城镇',4,'',0,1,0,0),(6629,1250,'外沟门乡',4,'',0,1,0,0),(6630,1250,'大滩镇',4,'',0,1,0,0),(6631,1250,'大阁镇',4,'',0,1,0,0),(6632,1250,'天桥镇',4,'',0,1,0,0),(6633,1250,'小坝子乡',4,'',0,1,0,0),(6634,1250,'杨木栅子乡',4,'',0,1,0,0),(6635,1250,'汤河乡',4,'',0,1,0,0),(6636,1250,'波罗诺镇',4,'',0,1,0,0),(6637,1250,'王营乡',4,'',0,1,0,0),(6638,1250,'石人沟乡',4,'',0,1,0,0),(6639,1250,'窟窿山乡',4,'',0,1,0,0),(6640,1250,'胡麻营乡',4,'',0,1,0,0),(6641,1250,'苏家店乡',4,'',0,1,0,0),(6642,1250,'草原乡',4,'',0,1,0,0),(6643,1250,'西官营乡',4,'',0,1,0,0),(6644,1250,'选将营乡',4,'',0,1,0,0),(6645,1250,'鱼儿山镇',4,'',0,1,0,0),(6646,1250,'黄旗镇',4,'',0,1,0,0),(6647,1250,'黑山咀镇',4,'',0,1,0,0),(6648,1251,'三道河乡',4,'',0,1,0,0),(6649,1251,'上石洞乡',4,'',0,1,0,0),(6650,1251,'八卦岭满族乡',4,'',0,1,0,0),(6651,1251,'六道河镇',4,'',0,1,0,0),(6652,1251,'兴隆镇',4,'',0,1,0,0),(6653,1251,'北水泉乡',4,'',0,1,0,0),(6654,1251,'北营房镇',4,'',0,1,0,0),(6655,1251,'半壁山镇',4,'',0,1,0,0),(6656,1251,'南天门满族乡',4,'',0,1,0,0),(6657,1251,'大杖子乡',4,'',0,1,0,0),(6658,1251,'大水泉乡',4,'',0,1,0,0),(6659,1251,'孤山子乡',4,'',0,1,0,0),(6660,1251,'安子岭乡',4,'',0,1,0,0),(6661,1251,'平安堡镇',4,'',0,1,0,0),(6662,1251,'挂兰峪镇',4,'',0,1,0,0),(6663,1251,'李家营乡',4,'',0,1,0,0),(6664,1251,'蓝旗营乡',4,'',0,1,0,0),(6665,1251,'蘑菇峪乡',4,'',0,1,0,0),(6666,1251,'陡子峪乡',4,'',0,1,0,0),(6667,1251,'青松岭镇',4,'',0,1,0,0),(6668,1252,'中华路街道',4,'',0,1,0,0),(6669,1252,'冯营子镇',4,'',0,1,0,0),(6670,1252,'大石庙镇',4,'',0,1,0,0),(6671,1252,'头道牌楼街道',4,'',0,1,0,0),(6672,1252,'新华路街道',4,'',0,1,0,0),(6673,1252,'桥东街道',4,'',0,1,0,0),(6674,1252,'水泉沟镇',4,'',0,1,0,0),(6675,1252,'潘家沟街道',4,'',0,1,0,0),(6676,1252,'牛圈子沟镇',4,'',0,1,0,0),(6677,1252,'狮子沟镇',4,'',0,1,0,0),(6678,1252,'石洞子沟街道',4,'',0,1,0,0),(6679,1252,'西大街街道',4,'',0,1,0,0),(6680,1253,'偏桥子镇',4,'',0,1,0,0),(6681,1253,'双塔山镇',4,'',0,1,0,0),(6682,1253,'大庙镇',4,'',0,1,0,0),(6683,1253,'滦河镇',4,'',0,1,0,0),(6684,1254,'三义永乡',4,'',0,1,0,0),(6685,1254,'下伙房乡',4,'',0,1,0,0),(6686,1254,'克勒沟镇',4,'',0,1,0,0),(6687,1254,'兰旗卡伦乡',4,'',0,1,0,0),(6688,1254,'半截塔镇',4,'',0,1,0,0),(6689,1254,'南山嘴乡',4,'',0,1,0,0),(6690,1254,'哈里哈乡',4,'',0,1,0,0),(6691,1254,'四合永镇',4,'',0,1,0,0),(6692,1254,'四道沟乡',4,'',0,1,0,0),(6693,1254,'围场镇',4,'',0,1,0,0),(6694,1254,'城子乡',4,'',0,1,0,0),(6695,1254,'大唤起乡',4,'',0,1,0,0),(6696,1254,'大头山乡',4,'',0,1,0,0),(6697,1254,'姜家店乡',4,'',0,1,0,0),(6698,1254,'宝元栈乡',4,'',0,1,0,0),(6699,1254,'山湾子乡',4,'',0,1,0,0),(6700,1254,'广发永乡',4,'',0,1,0,0),(6701,1254,'张家湾乡',4,'',0,1,0,0),(6702,1254,'御道口乡',4,'',0,1,0,0),(6703,1254,'新地乡',4,'',0,1,0,0),(6704,1254,'新拨乡',4,'',0,1,0,0),(6705,1254,'朝阳地镇',4,'',0,1,0,0),(6706,1254,'朝阳湾镇',4,'',0,1,0,0),(6707,1254,'杨家湾乡',4,'',0,1,0,0),(6708,1254,'棋盘山镇',4,'',0,1,0,0),(6709,1254,'燕格柏乡',4,'',0,1,0,0),(6710,1254,'牌楼乡',4,'',0,1,0,0),(6711,1254,'石桌子乡',4,'',0,1,0,0),(6712,1254,'老窝铺乡',4,'',0,1,0,0),(6713,1254,'育太和乡',4,'',0,1,0,0),(6714,1254,'腰站乡',4,'',0,1,0,0),(6715,1254,'西龙头乡',4,'',0,1,0,0),(6716,1254,'道坝子乡',4,'',0,1,0,0),(6717,1254,'郭家湾乡',4,'',0,1,0,0),(6718,1254,'银窝沟乡',4,'',0,1,0,0),(6719,1254,'黄土坎乡',4,'',0,1,0,0),(6720,1254,'龙头山乡',4,'',0,1,0,0),(6721,1255,'东大地乡',4,'',0,1,0,0),(6722,1255,'东黄花川乡',4,'',0,1,0,0),(6723,1255,'亮甲台乡',4,'',0,1,0,0),(6724,1255,'化皮溜子乡',4,'',0,1,0,0),(6725,1255,'塌山乡',4,'',0,1,0,0),(6726,1255,'大字沟门乡',4,'',0,1,0,0),(6727,1255,'大石柱子乡',4,'',0,1,0,0),(6728,1255,'孟子岭乡',4,'',0,1,0,0),(6729,1255,'宽城镇',4,'',0,1,0,0),(6730,1255,'峪耳崖镇',4,'',0,1,0,0),(6731,1255,'板城镇',4,'',0,1,0,0),(6732,1255,'汤道河镇',4,'',0,1,0,0),(6733,1255,'独石沟乡',4,'',0,1,0,0),(6734,1255,'碾子峪乡',4,'',0,1,0,0),(6735,1255,'苇子沟乡',4,'',0,1,0,0),(6736,1255,'铧尖乡',4,'',0,1,0,0),(6737,1255,'饽罗台乡',4,'',0,1,0,0),(6738,1255,'龙须门镇',4,'',0,1,0,0),(6739,1256,'七家岱满族乡',4,'',0,1,0,0),(6740,1256,'七沟镇',4,'',0,1,0,0),(6741,1256,'党坝镇',4,'',0,1,0,0),(6742,1256,'南五十家子蒙古族满族镇',4,'',0,1,0,0),(6743,1256,'卧龙镇',4,'',0,1,0,0),(6744,1256,'台头山乡',4,'',0,1,0,0),(6745,1256,'小寺沟镇',4,'',0,1,0,0),(6746,1256,'平房满族蒙古族乡',4,'',0,1,0,0),(6747,1256,'平泉镇',4,'',0,1,0,0),(6748,1256,'杨树岭镇',4,'',0,1,0,0),(6749,1256,'松树台乡',4,'',0,1,0,0),(6750,1256,'柳溪满族乡',4,'',0,1,0,0),(6751,1256,'榆树林子镇',4,'',0,1,0,0),(6752,1256,'王土房乡',4,'',0,1,0,0),(6753,1256,'茅兰沟满族蒙古族乡',4,'',0,1,0,0),(6754,1256,'蒙和乌苏蒙古族乡',4,'',0,1,0,0),(6755,1256,'道虎沟乡',4,'',0,1,0,0),(6756,1256,'郭杖子满族乡',4,'',0,1,0,0),(6757,1256,'黄土梁子镇',4,'',0,1,0,0),(6758,1257,'三家乡',4,'',0,1,0,0),(6759,1257,'三沟镇',4,'',0,1,0,0),(6760,1257,'上板城镇',4,'',0,1,0,0),(6761,1257,'上谷乡',4,'',0,1,0,0),(6762,1257,'下板城镇',4,'',0,1,0,0),(6763,1257,'东小白旗乡',4,'',0,1,0,0),(6764,1257,'两家满族乡',4,'',0,1,0,0),(6765,1257,'五道河乡',4,'',0,1,0,0),(6766,1257,'仓子乡',4,'',0,1,0,0),(6767,1257,'八家乡',4,'',0,1,0,0),(6768,1257,'六沟镇',4,'',0,1,0,0),(6769,1257,'刘杖子乡',4,'',0,1,0,0),(6770,1257,'双峰寺镇',4,'',0,1,0,0),(6771,1257,'大营子乡',4,'',0,1,0,0),(6772,1257,'头沟镇',4,'',0,1,0,0),(6773,1257,'孟家院乡',4,'',0,1,0,0),(6774,1257,'岔沟乡',4,'',0,1,0,0),(6775,1257,'岗子满族乡',4,'',0,1,0,0),(6776,1257,'新杖子乡',4,'',0,1,0,0),(6777,1257,'满杖子乡',4,'',0,1,0,0),(6778,1257,'甲山镇',4,'',0,1,0,0),(6779,1257,'石灰窑乡',4,'',0,1,0,0),(6780,1257,'磴上乡',4,'',0,1,0,0),(6781,1257,'鞍匠乡',4,'',0,1,0,0),(6782,1257,'高寺台镇',4,'',0,1,0,0),(6783,1258,'两间房乡',4,'',0,1,0,0),(6784,1258,'五道营子满族乡',4,'',0,1,0,0),(6785,1258,'付家店满族乡',4,'',0,1,0,0),(6786,1258,'付营子乡',4,'',0,1,0,0),(6787,1258,'大屯满族乡',4,'',0,1,0,0),(6788,1258,'安纯沟门满族乡',4,'',0,1,0,0),(6789,1258,'小营满族乡',4,'',0,1,0,0),(6790,1258,'巴克什营镇',4,'',0,1,0,0),(6791,1258,'平坊满族乡',4,'',0,1,0,0),(6792,1258,'张百湾镇',4,'',0,1,0,0),(6793,1258,'涝洼乡',4,'',0,1,0,0),(6794,1258,'滦平镇',4,'',0,1,0,0),(6795,1258,'火斗山乡',4,'',0,1,0,0),(6796,1258,'红旗镇',4,'',0,1,0,0),(6797,1258,'虎什哈镇',4,'',0,1,0,0),(6798,1258,'西地满族乡',4,'',0,1,0,0),(6799,1258,'西沟满族乡',4,'',0,1,0,0),(6800,1258,'邓厂满族乡',4,'',0,1,0,0),(6801,1258,'金沟屯镇',4,'',0,1,0,0),(6802,1258,'长山峪镇',4,'',0,1,0,0),(6803,1258,'陈栅子乡',4,'',0,1,0,0),(6804,1258,'马营子满族乡',4,'',0,1,0,0),(6805,1259,'七家镇',4,'',0,1,0,0),(6806,1259,'中关镇',4,'',0,1,0,0),(6807,1259,'偏坡营满族乡',4,'',0,1,0,0),(6808,1259,'八达营蒙古族乡',4,'',0,1,0,0),(6809,1259,'唐三营镇',4,'',0,1,0,0),(6810,1259,'太平庄满族乡',4,'',0,1,0,0),(6811,1259,'尹家营满族乡',4,'',0,1,0,0),(6812,1259,'山湾乡',4,'',0,1,0,0),(6813,1259,'庙子沟蒙古族满族乡',4,'',0,1,0,0),(6814,1259,'张三营镇',4,'',0,1,0,0),(6815,1259,'旧屯满族乡',4,'',0,1,0,0),(6816,1259,'步古沟镇',4,'',0,1,0,0),(6817,1259,'汤头沟镇',4,'',0,1,0,0),(6818,1259,'湾沟门乡',4,'',0,1,0,0),(6819,1259,'白虎沟满族蒙古族乡',4,'',0,1,0,0),(6820,1259,'碱房乡',4,'',0,1,0,0),(6821,1259,'章吉营乡',4,'',0,1,0,0),(6822,1259,'茅荆坝乡',4,'',0,1,0,0),(6823,1259,'荒地乡',4,'',0,1,0,0),(6824,1259,'蓝旗镇',4,'',0,1,0,0),(6825,1259,'西阿超满族蒙古族乡',4,'',0,1,0,0),(6826,1259,'郭家屯镇',4,'',0,1,0,0),(6827,1259,'隆化镇',4,'',0,1,0,0),(6828,1259,'韩家店乡',4,'',0,1,0,0),(6829,1259,'韩麻营镇',4,'',0,1,0,0),(6830,1260,'北马圈子镇',4,'',0,1,0,0),(6831,1260,'寿王坟镇',4,'',0,1,0,0),(6832,1260,'汪家庄镇',4,'',0,1,0,0),(6833,1260,'鹰手营子镇',4,'',0,1,0,0),(6834,1261,'冀州镇',4,'',0,1,0,0),(6835,1261,'北漳淮乡',4,'',0,1,0,0),(6836,1261,'南午村镇',4,'',0,1,0,0),(6837,1261,'周村镇',4,'',0,1,0,0),(6838,1261,'官道李镇',4,'',0,1,0,0),(6839,1261,'小寨乡',4,'',0,1,0,0),(6840,1261,'徐家庄乡',4,'',0,1,0,0),(6841,1261,'码头李镇',4,'',0,1,0,0),(6842,1261,'西王镇',4,'',0,1,0,0),(6843,1261,'门庄乡',4,'',0,1,0,0),(6844,1261,'魏屯镇',4,'',0,1,0,0),(6845,1262,'东黄城乡',4,'',0,1,0,0),(6846,1262,'南王庄镇',4,'',0,1,0,0),(6847,1262,'大何庄乡',4,'',0,1,0,0),(6848,1262,'大子文乡',4,'',0,1,0,0),(6849,1262,'安平镇',4,'',0,1,0,0),(6850,1262,'程油子乡',4,'',0,1,0,0),(6851,1262,'西两洼乡',4,'',0,1,0,0),(6852,1262,'马店镇',4,'',0,1,0,0),(6853,1263,'三朗乡',4,'',0,1,0,0),(6854,1263,'军屯镇',4,'',0,1,0,0),(6855,1263,'夏庄镇',4,'',0,1,0,0),(6856,1263,'建国镇',4,'',0,1,0,0),(6857,1263,'房庄乡',4,'',0,1,0,0),(6858,1263,'故城镇',4,'',0,1,0,0),(6859,1263,'武官寨镇',4,'',0,1,0,0),(6860,1263,'西半屯镇',4,'',0,1,0,0),(6861,1263,'辛庄乡',4,'',0,1,0,0),(6862,1263,'郑口镇',4,'',0,1,0,0),(6863,1263,'里老乡',4,'',0,1,0,0),(6864,1263,'青罕镇',4,'',0,1,0,0),(6865,1263,'饶阳店镇',4,'',0,1,0,0),(6866,1264,'刘集乡',4,'',0,1,0,0),(6867,1264,'北留智镇',4,'',0,1,0,0),(6868,1264,'后留名府乡',4,'',0,1,0,0),(6869,1264,'安陵镇',4,'',0,1,0,0),(6870,1264,'广川镇',4,'',0,1,0,0),(6871,1264,'景州镇',4,'',0,1,0,0),(6872,1264,'杜桥镇',4,'',0,1,0,0),(6873,1264,'梁集乡',4,'',0,1,0,0),(6874,1264,'洚河流镇',4,'',0,1,0,0),(6875,1264,'温城乡',4,'',0,1,0,0),(6876,1264,'王瞳镇',4,'',0,1,0,0),(6877,1264,'王谦寺镇',4,'',0,1,0,0),(6878,1264,'留智庙镇',4,'',0,1,0,0),(6879,1264,'连镇乡',4,'',0,1,0,0),(6880,1264,'青兰乡',4,'',0,1,0,0),(6881,1264,'龙华镇',4,'',0,1,0,0),(6882,1265,'唐林乡',4,'',0,1,0,0),(6883,1265,'嘉会镇',4,'',0,1,0,0),(6884,1265,'大营镇',4,'',0,1,0,0),(6885,1265,'张秀屯乡',4,'',0,1,0,0),(6886,1265,'恩察镇',4,'',0,1,0,0),(6887,1265,'新屯乡',4,'',0,1,0,0),(6888,1265,'枣强镇',4,'',0,1,0,0),(6889,1265,'王均乡',4,'',0,1,0,0),(6890,1265,'王常乡',4,'',0,1,0,0),(6891,1265,'肖张镇',4,'',0,1,0,0),(6892,1265,'马屯镇',4,'',0,1,0,0),(6893,1266,'中华街道',4,'',0,1,0,0),(6894,1266,'何家庄乡',4,'',0,1,0,0),(6895,1266,'大麻森乡',4,'',0,1,0,0),(6896,1266,'彭杜村乡',4,'',0,1,0,0),(6897,1266,'河东街道',4,'',0,1,0,0),(6898,1266,'河西街道',4,'',0,1,0,0),(6899,1266,'赵圈镇',4,'',0,1,0,0),(6900,1266,'路北街道',4,'',0,1,0,0),(6901,1266,'邓庄乡',4,'',0,1,0,0),(6902,1266,'郑家河沿镇',4,'',0,1,0,0),(6903,1267,'北代乡',4,'',0,1,0,0),(6904,1267,'周家窝乡',4,'',0,1,0,0),(6905,1267,'孙庄乡',4,'',0,1,0,0),(6906,1267,'武强镇',4,'',0,1,0,0),(6907,1267,'街关镇',4,'',0,1,0,0),(6908,1267,'豆村乡',4,'',0,1,0,0),(6909,1268,'圈头乡',4,'',0,1,0,0),(6910,1268,'大紫塔乡',4,'',0,1,0,0),(6911,1268,'审坡镇',4,'',0,1,0,0),(6912,1268,'武邑镇',4,'',0,1,0,0),(6913,1268,'清凉店镇',4,'',0,1,0,0),(6914,1268,'肖桥头镇',4,'',0,1,0,0),(6915,1268,'赵桥镇',4,'',0,1,0,0),(6916,1268,'韩庄镇',4,'',0,1,0,0),(6917,1268,'龙店乡',4,'',0,1,0,0),(6918,1269,'东安庄乡',4,'',0,1,0,0),(6919,1269,'乔屯乡',4,'',0,1,0,0),(6920,1269,'兵曹乡',4,'',0,1,0,0),(6921,1269,'前磨头镇',4,'',0,1,0,0),(6922,1269,'北溪村乡',4,'',0,1,0,0),(6923,1269,'唐奉镇',4,'',0,1,0,0),(6924,1269,'大冯营乡',4,'',0,1,0,0),(6925,1269,'大堤镇',4,'',0,1,0,0),(6926,1269,'大屯乡',4,'',0,1,0,0),(6927,1269,'太古庄乡',4,'',0,1,0,0),(6928,1269,'护驾迟镇',4,'',0,1,0,0),(6929,1269,'榆科镇',4,'',0,1,0,0),(6930,1269,'深州镇',4,'',0,1,0,0),(6931,1269,'王家井镇',4,'',0,1,0,0),(6932,1269,'穆村乡',4,'',0,1,0,0),(6933,1269,'辰时镇',4,'',0,1,0,0),(6934,1269,'魏桥镇',4,'',0,1,0,0),(6935,1270,'古城镇',4,'',0,1,0,0),(6936,1270,'大白乡',4,'',0,1,0,0),(6937,1270,'崔家庙镇',4,'',0,1,0,0),(6938,1270,'建桥乡',4,'',0,1,0,0),(6939,1270,'漫河乡',4,'',0,1,0,0),(6940,1270,'王集乡',4,'',0,1,0,0),(6941,1270,'码头镇',4,'',0,1,0,0),(6942,1270,'蒋坊乡',4,'',0,1,0,0),(6943,1270,'阜城镇',4,'',0,1,0,0),(6944,1270,'霞口镇',4,'',0,1,0,0),(6945,1271,'东里满乡',4,'',0,1,0,0),(6946,1271,'五公镇',4,'',0,1,0,0),(6947,1271,'大官亭乡',4,'',0,1,0,0),(6948,1271,'大尹村镇',4,'',0,1,0,0),(6949,1271,'王同岳乡',4,'',0,1,0,0),(6950,1271,'留楚乡',4,'',0,1,0,0),(6951,1271,'饶阳镇',4,'',0,1,0,0),(6952,1272,'新集镇',4,'',0,1,0,0),(6953,1272,'李旗庄镇',4,'',0,1,0,0),(6954,1272,'杨庄镇',4,'',0,1,0,0),(6955,1272,'段甲岭镇',4,'',0,1,0,0),(6956,1272,'洵阳镇',4,'',0,1,0,0),(6957,1272,'燕郊镇',4,'',0,1,0,0),(6958,1272,'皇庄镇',4,'',0,1,0,0),(6959,1272,'高楼镇',4,'',0,1,0,0),(6960,1272,'黄土庄镇',4,'',0,1,0,0),(6961,1272,'齐心庄镇',4,'',0,1,0,0),(6962,1273,'东湾乡',4,'',0,1,0,0),(6963,1273,'固安镇',4,'',0,1,0,0),(6964,1273,'宫村镇',4,'',0,1,0,0),(6965,1273,'彭村乡',4,'',0,1,0,0),(6966,1273,'柳泉镇',4,'',0,1,0,0),(6967,1273,'渠沟乡',4,'',0,1,0,0),(6968,1273,'牛驼镇',4,'',0,1,0,0),(6969,1273,'礼让店乡',4,'',0,1,0,0),(6970,1273,'马庄镇',4,'',0,1,0,0),(6971,1274,'夏垫镇',4,'',0,1,0,0),(6972,1274,'大厂镇',4,'',0,1,0,0),(6973,1274,'祁各庄乡',4,'',0,1,0,0),(6974,1274,'邵府乡',4,'',0,1,0,0),(6975,1274,'陈府乡',4,'',0,1,0,0),(6976,1275,'北位乡',4,'',0,1,0,0),(6977,1275,'南赵扶镇',4,'',0,1,0,0),(6978,1275,'大尚屯镇',4,'',0,1,0,0),(6979,1275,'大广安乡',4,'',0,1,0,0),(6980,1275,'平舒镇',4,'',0,1,0,0),(6981,1275,'旺村镇',4,'',0,1,0,0),(6982,1275,'权村镇',4,'',0,1,0,0),(6983,1275,'留各庄镇',4,'',0,1,0,0),(6984,1275,'臧屯乡',4,'',0,1,0,0),(6985,1275,'里坦镇',4,'',0,1,0,0),(6986,1276,'东沽港镇',4,'',0,1,0,0),(6987,1276,'仇庄乡',4,'',0,1,0,0),(6988,1276,'光明西道街道',4,'',0,1,0,0),(6989,1276,'北史家务乡',4,'',0,1,0,0),(6990,1276,'杨税务乡',4,'',0,1,0,0),(6991,1276,'码头镇',4,'',0,1,0,0),(6992,1276,'落垡镇',4,'',0,1,0,0),(6993,1276,'葛渔城镇',4,'',0,1,0,0),(6994,1276,'调河头乡',4,'',0,1,0,0),(6995,1276,'银河南路街道',4,'',0,1,0,0),(6996,1277,'万庄镇',4,'',0,1,0,0),(6997,1277,'九州镇',4,'',0,1,0,0),(6998,1277,'北旺乡',4,'',0,1,0,0),(6999,1277,'南尖塔镇',4,'',0,1,0,0),(7000,1277,'新开路街道',4,'',0,1,0,0),(7001,1277,'爱民东道街道',4,'',0,1,0,0),(7002,1277,'解放道街道',4,'',0,1,0,0),(7003,1277,'银河北路街道',4,'',0,1,0,0),(7004,1278,'兴隆宫镇',4,'',0,1,0,0),(7005,1278,'史各庄镇',4,'',0,1,0,0),(7006,1278,'大围河回族满族乡',4,'',0,1,0,0),(7007,1278,'大柳河镇',4,'',0,1,0,0),(7008,1278,'大留镇镇',4,'',0,1,0,0),(7009,1278,'孙氏镇',4,'',0,1,0,0),(7010,1278,'左各庄镇',4,'',0,1,0,0),(7011,1278,'德归镇',4,'',0,1,0,0),(7012,1278,'文安镇',4,'',0,1,0,0),(7013,1278,'新镇镇',4,'',0,1,0,0),(7014,1278,'滩里镇',4,'',0,1,0,0),(7015,1278,'苏桥镇',4,'',0,1,0,0),(7016,1278,'赵各庄镇',4,'',0,1,0,0),(7017,1279,'三圣口乡',4,'',0,1,0,0),(7018,1279,'刘街乡',4,'',0,1,0,0),(7019,1279,'别古庄镇',4,'',0,1,0,0),(7020,1279,'后奕镇',4,'',0,1,0,0),(7021,1279,'曹家务乡',4,'',0,1,0,0),(7022,1279,'永清镇',4,'',0,1,0,0),(7023,1279,'管家务回族乡',4,'',0,1,0,0),(7024,1279,'里澜城镇',4,'',0,1,0,0),(7025,1279,'韩村镇',4,'',0,1,0,0),(7026,1279,'龙虎庄乡',4,'',0,1,0,0),(7027,1280,'东杨庄乡',4,'',0,1,0,0),(7028,1280,'东段乡',4,'',0,1,0,0),(7029,1280,'信安镇',4,'',0,1,0,0),(7030,1280,'南孟镇',4,'',0,1,0,0),(7031,1280,'堂二里镇',4,'',0,1,0,0),(7032,1280,'岔河集乡',4,'',0,1,0,0),(7033,1280,'康仙庄乡',4,'',0,1,0,0),(7034,1280,'杨芬港乡',4,'',0,1,0,0),(7035,1280,'煎茶铺镇',4,'',0,1,0,0),(7036,1280,'王庄子乡',4,'',0,1,0,0),(7037,1280,'胜芳镇',4,'',0,1,0,0),(7038,1280,'霸州镇',4,'',0,1,0,0),(7039,1281,'五百户镇',4,'',0,1,0,0),(7040,1281,'刘宋镇',4,'',0,1,0,0),(7041,1281,'安头屯镇',4,'',0,1,0,0),(7042,1281,'安平镇',4,'',0,1,0,0),(7043,1281,'淑阳镇',4,'',0,1,0,0),(7044,1281,'渠口镇',4,'',0,1,0,0),(7045,1281,'蒋辛屯镇',4,'',0,1,0,0),(7046,1281,'钱旺乡',4,'',0,1,0,0),(7047,1281,'钳屯乡',4,'',0,1,0,0),(7048,1282,'东光镇',4,'',0,1,0,0),(7049,1282,'于桥乡',4,'',0,1,0,0),(7050,1282,'南霞口镇',4,'',0,1,0,0),(7051,1282,'大单镇',4,'',0,1,0,0),(7052,1282,'找王镇',4,'',0,1,0,0),(7053,1282,'灯明寺镇',4,'',0,1,0,0),(7054,1282,'秦村镇',4,'',0,1,0,0),(7055,1282,'连镇镇',4,'',0,1,0,0),(7056,1282,'龙王李乡',4,'',0,1,0,0),(7057,1283,'七间房乡',4,'',0,1,0,0),(7058,1283,'于村乡',4,'',0,1,0,0),(7059,1283,'出岸镇',4,'',0,1,0,0),(7060,1283,'北汉乡',4,'',0,1,0,0),(7061,1283,'北辛庄乡',4,'',0,1,0,0),(7062,1283,'吕公堡镇',4,'',0,1,0,0),(7063,1283,'新华路街道',4,'',0,1,0,0),(7064,1283,'梁召镇',4,'',0,1,0,0),(7065,1283,'永丰路街道',4,'',0,1,0,0),(7066,1283,'石门桥镇',4,'',0,1,0,0),(7067,1283,'苟各庄镇',4,'',0,1,0,0),(7068,1283,'莫阝州镇',4,'',0,1,0,0),(7069,1283,'西环路街道',4,'',0,1,0,0),(7070,1283,'议论堡乡',4,'',0,1,0,0),(7071,1283,'辛中驿镇',4,'',0,1,0,0),(7072,1283,'长丰镇',4,'',0,1,0,0),(7073,1283,'青塔乡',4,'',0,1,0,0),(7074,1283,'麻家坞乡',4,'',0,1,0,0),(7075,1284,'乌马营镇',4,'',0,1,0,0),(7076,1284,'冯家口镇',4,'',0,1,0,0),(7077,1284,'刘八里乡',4,'',0,1,0,0),(7078,1284,'南皮镇',4,'',0,1,0,0),(7079,1284,'大浪淀乡',4,'',0,1,0,0),(7080,1284,'寨子镇',4,'',0,1,0,0),(7081,1284,'潞灌乡',4,'',0,1,0,0),(7082,1284,'王寺镇',4,'',0,1,0,0),(7083,1284,'鲍官屯镇',4,'',0,1,0,0),(7084,1285,'于集镇',4,'',0,1,0,0),(7085,1285,'何庄乡',4,'',0,1,0,0),(7086,1285,'安陵镇',4,'',0,1,0,0),(7087,1285,'宋门乡',4,'',0,1,0,0),(7088,1285,'曹家洼乡',4,'',0,1,0,0),(7089,1285,'杨家寺乡',4,'',0,1,0,0),(7090,1285,'桑园镇',4,'',0,1,0,0),(7091,1285,'梁集镇',4,'',0,1,0,0),(7092,1285,'沟店铺乡',4,'',0,1,0,0),(7093,1285,'铁城镇',4,'',0,1,0,0),(7094,1286,'孟村镇',4,'',0,1,0,0),(7095,1286,'宋庄子乡',4,'',0,1,0,0),(7096,1286,'新县镇',4,'',0,1,0,0),(7097,1286,'牛进庄乡',4,'',0,1,0,0),(7098,1286,'辛店镇',4,'',0,1,0,0),(7099,1286,'高寨镇',4,'',0,1,0,0),(7100,1287,'东环街道',4,'',0,1,0,0),(7101,1287,'南大街街道',4,'',0,1,0,0),(7102,1287,'小赵庄乡',4,'',0,1,0,0),(7103,1287,'建设北街街道',4,'',0,1,0,0),(7104,1287,'车站街道',4,'',0,1,0,0),(7105,1287,'道东街道',4,'',0,1,0,0),(7106,1288,'仵龙堂乡',4,'',0,1,0,0),(7107,1288,'兴济镇',4,'',0,1,0,0),(7108,1288,'刘家庙乡',4,'',0,1,0,0),(7109,1288,'大官厅乡',4,'',0,1,0,0),(7110,1288,'大褚村回族乡',4,'',0,1,0,0),(7111,1288,'姚官屯乡',4,'',0,1,0,0),(7112,1288,'崔尔庄镇',4,'',0,1,0,0),(7113,1288,'张官屯乡',4,'',0,1,0,0),(7114,1288,'捷地回族乡',4,'',0,1,0,0),(7115,1288,'旧州镇',4,'',0,1,0,0),(7116,1288,'李天木回族乡',4,'',0,1,0,0),(7117,1288,'杜林回族乡',4,'',0,1,0,0),(7118,1288,'杜生镇',4,'',0,1,0,0),(7119,1288,'汪家铺乡',4,'',0,1,0,0),(7120,1288,'纸房头乡',4,'',0,1,0,0),(7121,1288,'薛官屯乡',4,'',0,1,0,0),(7122,1288,'风化店乡',4,'',0,1,0,0),(7123,1288,'高川乡',4,'',0,1,0,0),(7124,1288,'黄递铺乡',4,'',0,1,0,0),(7125,1289,'兴村乡',4,'',0,1,0,0),(7126,1289,'北石槽乡',4,'',0,1,0,0),(7127,1289,'卧佛堂镇',4,'',0,1,0,0),(7128,1289,'尊祖庄乡',4,'',0,1,0,0),(7129,1289,'故仙乡',4,'',0,1,0,0),(7130,1289,'时村乡',4,'',0,1,0,0),(7131,1289,'景和镇',4,'',0,1,0,0),(7132,1289,'束城镇',4,'',0,1,0,0),(7133,1289,'果子洼回族乡',4,'',0,1,0,0),(7134,1289,'沙河桥镇',4,'',0,1,0,0),(7135,1289,'沙洼乡',4,'',0,1,0,0),(7136,1289,'瀛州镇',4,'',0,1,0,0),(7137,1289,'留古寺镇',4,'',0,1,0,0),(7138,1289,'米各庄镇',4,'',0,1,0,0),(7139,1289,'行别营乡',4,'',0,1,0,0),(7140,1289,'西九吉乡',4,'',0,1,0,0),(7141,1289,'诗经村乡',4,'',0,1,0,0),(7142,1289,'郭家村乡',4,'',0,1,0,0),(7143,1289,'黎民居乡',4,'',0,1,0,0),(7144,1289,'龙华店乡',4,'',0,1,0,0),(7145,1290,'交河镇',4,'',0,1,0,0),(7146,1290,'古楼街道',4,'',0,1,0,0),(7147,1290,'四营乡',4,'',0,1,0,0),(7148,1290,'富镇镇',4,'',0,1,0,0),(7149,1290,'寺门村镇',4,'',0,1,0,0),(7150,1290,'文庙镇',4,'',0,1,0,0),(7151,1290,'河东街道',4,'',0,1,0,0),(7152,1290,'泊镇',4,'',0,1,0,0),(7153,1290,'洼里王镇',4,'',0,1,0,0),(7154,1290,'王武庄乡',4,'',0,1,0,0),(7155,1290,'营子乡',4,'',0,1,0,0),(7156,1290,'西辛店乡',4,'',0,1,0,0),(7157,1290,'解放街道',4,'',0,1,0,0),(7158,1290,'郝村镇',4,'',0,1,0,0),(7159,1290,'齐桥镇',4,'',0,1,0,0),(7160,1291,'小山乡',4,'',0,1,0,0),(7161,1291,'张会亭乡',4,'',0,1,0,0),(7162,1291,'苏基镇',4,'',0,1,0,0),(7163,1291,'赵毛陶乡',4,'',0,1,0,0),(7164,1291,'辛集镇',4,'',0,1,0,0),(7165,1291,'香坊乡',4,'',0,1,0,0),(7166,1291,'高湾镇',4,'',0,1,0,0),(7167,1292,'临河乡',4,'',0,1,0,0),(7168,1292,'乐寿镇',4,'',0,1,0,0),(7169,1292,'十五级乡',4,'',0,1,0,0),(7170,1292,'南河头乡',4,'',0,1,0,0),(7171,1292,'商林乡',4,'',0,1,0,0),(7172,1292,'垒头乡',4,'',0,1,0,0),(7173,1292,'小平王乡',4,'',0,1,0,0),(7174,1292,'张村乡',4,'',0,1,0,0),(7175,1292,'徐留高乡',4,'',0,1,0,0),(7176,1292,'本斋回族乡',4,'',0,1,0,0),(7177,1292,'段村乡',4,'',0,1,0,0),(7178,1292,'河城街镇',4,'',0,1,0,0),(7179,1292,'淮镇镇',4,'',0,1,0,0),(7180,1292,'西城乡',4,'',0,1,0,0),(7181,1292,'郭庄镇',4,'',0,1,0,0),(7182,1292,'陈庄乡',4,'',0,1,0,0),(7183,1292,'陌南乡',4,'',0,1,0,0),(7184,1292,'韩村乡',4,'',0,1,0,0),(7185,1293,'千童镇',4,'',0,1,0,0),(7186,1293,'圣佛镇',4,'',0,1,0,0),(7187,1293,'孟店乡',4,'',0,1,0,0),(7188,1293,'小庄乡',4,'',0,1,0,0),(7189,1293,'小营乡',4,'',0,1,0,0),(7190,1293,'常庄乡',4,'',0,1,0,0),(7191,1293,'庆云镇',4,'',0,1,0,0),(7192,1293,'望树镇',4,'',0,1,0,0),(7193,1293,'杨集乡',4,'',0,1,0,0),(7194,1293,'盐山镇',4,'',0,1,0,0),(7195,1293,'边务乡',4,'',0,1,0,0),(7196,1293,'韩集镇',4,'',0,1,0,0),(7197,1294,'万里镇',4,'',0,1,0,0),(7198,1294,'付家佐乡',4,'',0,1,0,0),(7199,1294,'尚村镇',4,'',0,1,0,0),(7200,1294,'师素乡',4,'',0,1,0,0),(7201,1294,'梁家村镇',4,'',0,1,0,0),(7202,1294,'河北留善寺乡',4,'',0,1,0,0),(7203,1294,'窝北镇',4,'',0,1,0,0),(7204,1294,'肃宁镇',4,'',0,1,0,0),(7205,1294,'邵庄乡',4,'',0,1,0,0),(7206,1295,'公园街道',4,'',0,1,0,0),(7207,1295,'南湖街道',4,'',0,1,0,0),(7208,1295,'南环中路街道',4,'',0,1,0,0),(7209,1295,'南陈屯乡',4,'',0,1,0,0),(7210,1295,'小王庄镇',4,'',0,1,0,0),(7211,1295,'市场街道',4,'',0,1,0,0),(7212,1295,'水月寺街道',4,'',0,1,0,0),(7213,1295,'西环中街街道',4,'',0,1,0,0),(7214,1296,'周官屯乡',4,'',0,1,0,0),(7215,1296,'新兴镇',4,'',0,1,0,0),(7216,1296,'曹寺乡',4,'',0,1,0,0),(7217,1296,'木门店镇',4,'',0,1,0,0),(7218,1296,'流河镇',4,'',0,1,0,0),(7219,1296,'清州镇',4,'',0,1,0,0),(7220,1296,'盘古乡',4,'',0,1,0,0),(7221,1296,'金牛镇',4,'',0,1,0,0),(7222,1296,'陈嘴乡',4,'',0,1,0,0),(7223,1296,'马厂镇',4,'',0,1,0,0),(7224,1297,'南排河镇',4,'',0,1,0,0),(7225,1297,'吕桥镇',4,'',0,1,0,0),(7226,1297,'官庄乡',4,'',0,1,0,0),(7227,1297,'常郭乡',4,'',0,1,0,0),(7228,1297,'新村回族乡',4,'',0,1,0,0),(7229,1297,'旧城镇',4,'',0,1,0,0),(7230,1297,'滕庄子乡',4,'',0,1,0,0),(7231,1297,'羊三木回族乡',4,'',0,1,0,0),(7232,1297,'羊二庄回族乡',4,'',0,1,0,0),(7233,1297,'骅东街道',4,'',0,1,0,0),(7234,1297,'骅中街道',4,'',0,1,0,0),(7235,1297,'骅西街道',4,'',0,1,0,0),(7236,1297,'黄骅镇',4,'',0,1,0,0),(7237,1297,'齐家务乡',4,'',0,1,0,0),(7238,1298,'万柏林街道',4,'',0,1,0,0),(7239,1298,'下元街道',4,'',0,1,0,0),(7240,1298,'东社街道',4,'',0,1,0,0),(7241,1298,'兴华街道',4,'',0,1,0,0),(7242,1298,'化客头街道',4,'',0,1,0,0),(7243,1298,'千峰街道',4,'',0,1,0,0),(7244,1298,'南寒街道',4,'',0,1,0,0),(7245,1298,'和平街道',4,'',0,1,0,0),(7246,1298,'小井峪街道',4,'',0,1,0,0),(7247,1298,'杜儿坪街道',4,'',0,1,0,0),(7248,1298,'王封乡',4,'',0,1,0,0),(7249,1298,'白家庄街道',4,'',0,1,0,0),(7250,1298,'神堂沟街道',4,'',0,1,0,0),(7251,1298,'西铭街道',4,'',0,1,0,0),(7252,1298,'长风街道',4,'',0,1,0,0),(7253,1299,'东曲街道',4,'',0,1,0,0),(7254,1299,'原相乡',4,'',0,1,0,0),(7255,1299,'嘉乐泉乡',4,'',0,1,0,0),(7256,1299,'屯兰街道',4,'',0,1,0,0),(7257,1299,'岔口乡',4,'',0,1,0,0),(7258,1299,'常安乡',4,'',0,1,0,0),(7259,1299,'桃园街道',4,'',0,1,0,0),(7260,1299,'梭峪乡',4,'',0,1,0,0),(7261,1299,'河口镇',4,'',0,1,0,0),(7262,1299,'西曲街道',4,'',0,1,0,0),(7263,1299,'邢家社乡',4,'',0,1,0,0),(7264,1299,'镇城底镇',4,'',0,1,0,0),(7265,1299,'阁上乡',4,'',0,1,0,0),(7266,1299,'马兰镇',4,'',0,1,0,0),(7267,1300,'天池店乡',4,'',0,1,0,0),(7268,1300,'娄烦镇',4,'',0,1,0,0),(7269,1300,'庙湾乡',4,'',0,1,0,0),(7270,1300,'杜交曲镇',4,'',0,1,0,0),(7271,1300,'盖家庄乡',4,'',0,1,0,0),(7272,1300,'米峪镇乡',4,'',0,1,0,0),(7273,1300,'静游镇',4,'',0,1,0,0),(7274,1300,'马家庄乡',4,'',0,1,0,0),(7275,1301,'刘家堡乡',4,'',0,1,0,0),(7276,1301,'北格镇',4,'',0,1,0,0),(7277,1301,'北营街道',4,'',0,1,0,0),(7278,1301,'坞城街道',4,'',0,1,0,0),(7279,1301,'小店街道',4,'',0,1,0,0),(7280,1301,'平阳街道',4,'',0,1,0,0),(7281,1301,'营盘街道',4,'',0,1,0,0),(7282,1301,'西温庄乡',4,'',0,1,0,0),(7283,1301,'黄陵街道',4,'',0,1,0,0),(7284,1302,'上兰街道',4,'',0,1,0,0),(7285,1302,'光社街道',4,'',0,1,0,0),(7286,1302,'南寨街道',4,'',0,1,0,0),(7287,1302,'古城街道',4,'',0,1,0,0),(7288,1302,'向阳镇',4,'',0,1,0,0),(7289,1302,'尖草坪街道',4,'',0,1,0,0),(7290,1302,'新城街道',4,'',0,1,0,0),(7291,1302,'柏板乡',4,'',0,1,0,0),(7292,1302,'柴村街道',4,'',0,1,0,0),(7293,1302,'汇丰街道',4,'',0,1,0,0),(7294,1302,'西鄢乡',4,'',0,1,0,0),(7295,1302,'迎新街街道',4,'',0,1,0,0),(7296,1302,'阳曲镇',4,'',0,1,0,0),(7297,1302,'马头水乡',4,'',0,1,0,0),(7298,1303,'义井街道',4,'',0,1,0,0),(7299,1303,'姚村镇',4,'',0,1,0,0),(7300,1303,'晋源街道',4,'',0,1,0,0),(7301,1303,'晋祠镇',4,'',0,1,0,0),(7302,1303,'罗城街道',4,'',0,1,0,0),(7303,1303,'金胜镇',4,'',0,1,0,0),(7304,1304,'三桥街道',4,'',0,1,0,0),(7305,1304,'中涧河乡',4,'',0,1,0,0),(7306,1304,'坝陵桥街道',4,'',0,1,0,0),(7307,1304,'大东关街道',4,'',0,1,0,0),(7308,1304,'小返乡',4,'',0,1,0,0),(7309,1304,'巨轮街道',4,'',0,1,0,0),(7310,1304,'敦化坊街道',4,'',0,1,0,0),(7311,1304,'杏花岭街道',4,'',0,1,0,0),(7312,1304,'杨家峪街道',4,'',0,1,0,0),(7313,1304,'涧河街道',4,'',0,1,0,0),(7314,1304,'职工新村街道',4,'',0,1,0,0),(7315,1304,'鼓楼街道',4,'',0,1,0,0),(7316,1305,'东于镇',4,'',0,1,0,0),(7317,1305,'徐沟镇',4,'',0,1,0,0),(7318,1305,'柳杜乡',4,'',0,1,0,0),(7319,1305,'清源镇',4,'',0,1,0,0),(7320,1305,'王答乡',4,'',0,1,0,0),(7321,1305,'盂封镇',4,'',0,1,0,0),(7322,1305,'西谷乡',4,'',0,1,0,0),(7323,1305,'集义乡',4,'',0,1,0,0),(7324,1305,'马峪乡',4,'',0,1,0,0),(7325,1306,'庙前街道',4,'',0,1,0,0),(7326,1306,'文庙街道',4,'',0,1,0,0),(7327,1306,'柳巷街道',4,'',0,1,0,0),(7328,1306,'桥东街道',4,'',0,1,0,0),(7329,1306,'老军营街道',4,'',0,1,0,0),(7330,1306,'迎泽街道',4,'',0,1,0,0),(7331,1306,'郝庄镇',4,'',0,1,0,0),(7332,1307,'东黄水镇',4,'',0,1,0,0),(7333,1307,'候村乡',4,'',0,1,0,0),(7334,1307,'凌井店乡',4,'',0,1,0,0),(7335,1307,'北小店乡',4,'',0,1,0,0),(7336,1307,'大盂镇',4,'',0,1,0,0),(7337,1307,'杨兴乡',4,'',0,1,0,0),(7338,1307,'泥屯镇',4,'',0,1,0,0),(7339,1307,'西凌井乡',4,'',0,1,0,0),(7340,1307,'高村乡',4,'',0,1,0,0),(7341,1307,'黄寨镇',4,'',0,1,0,0),(7342,1308,'云冈镇',4,'',0,1,0,0),(7343,1308,'口泉乡',4,'',0,1,0,0),(7344,1308,'古店镇',4,'',0,1,0,0),(7345,1308,'平旺乡',4,'',0,1,0,0),(7346,1308,'新旺乡',4,'',0,1,0,0),(7347,1308,'水泊寺乡',4,'',0,1,0,0),(7348,1308,'西韩岭乡',4,'',0,1,0,0),(7349,1308,'马军营乡',4,'',0,1,0,0),(7350,1308,'高山镇',4,'',0,1,0,0),(7351,1308,'鸦儿崖乡',4,'',0,1,0,0),(7352,1309,'东街街道',4,'',0,1,0,0),(7353,1309,'北关街道',4,'',0,1,0,0),(7354,1309,'北街街道',4,'',0,1,0,0),(7355,1309,'南关街道',4,'',0,1,0,0),(7356,1309,'南街街道',4,'',0,1,0,0),(7357,1309,'向阳里街道',4,'',0,1,0,0),(7358,1309,'大庆路街道',4,'',0,1,0,0),(7359,1309,'振华南街街道',4,'',0,1,0,0),(7360,1309,'新华街街道',4,'',0,1,0,0),(7361,1309,'新建北路街道',4,'',0,1,0,0),(7362,1309,'新建南路街道',4,'',0,1,0,0),(7363,1309,'老平旺街道',4,'',0,1,0,0),(7364,1309,'西花园街道',4,'',0,1,0,0),(7365,1309,'西街街道',4,'',0,1,0,0),(7366,1310,'倍加皂镇',4,'',0,1,0,0),(7367,1310,'党留庄乡',4,'',0,1,0,0),(7368,1310,'吉家庄乡',4,'',0,1,0,0),(7369,1310,'周士庄镇',4,'',0,1,0,0),(7370,1310,'峰峪乡',4,'',0,1,0,0),(7371,1310,'杜庄乡',4,'',0,1,0,0),(7372,1310,'瓜园乡',4,'',0,1,0,0),(7373,1310,'聚乐堡乡',4,'',0,1,0,0),(7374,1310,'西坪镇',4,'',0,1,0,0),(7375,1310,'许堡乡',4,'',0,1,0,0),(7376,1311,'三十里铺乡',4,'',0,1,0,0),(7377,1311,'南河堡乡',4,'',0,1,0,0),(7378,1311,'南高崖乡',4,'',0,1,0,0),(7379,1311,'张西河乡',4,'',0,1,0,0),(7380,1311,'新平堡镇',4,'',0,1,0,0),(7381,1311,'玉泉镇',4,'',0,1,0,0),(7382,1311,'米薪湾镇',4,'',0,1,0,0),(7383,1311,'谷前堡镇',4,'',0,1,0,0),(7384,1311,'贾家屯乡',4,'',0,1,0,0),(7385,1311,'赵家沟乡',4,'',0,1,0,0),(7386,1311,'逯家湾镇',4,'',0,1,0,0),(7387,1312,'三屯乡',4,'',0,1,0,0),(7388,1312,'云兴镇',4,'',0,1,0,0),(7389,1312,'小京庄乡',4,'',0,1,0,0),(7390,1312,'店湾镇',4,'',0,1,0,0),(7391,1312,'张家场乡',4,'',0,1,0,0),(7392,1312,'水窑乡',4,'',0,1,0,0),(7393,1312,'管家堡乡',4,'',0,1,0,0),(7394,1312,'马道头乡',4,'',0,1,0,0),(7395,1312,'鹊儿山镇',4,'',0,1,0,0),(7396,1313,'一斗泉乡',4,'',0,1,0,0),(7397,1313,'作疃乡',4,'',0,1,0,0),(7398,1313,'加斗乡',4,'',0,1,0,0),(7399,1313,'南村镇',4,'',0,1,0,0),(7400,1313,'壶泉镇',4,'',0,1,0,0),(7401,1313,'宜兴乡',4,'',0,1,0,0),(7402,1313,'望狐乡',4,'',0,1,0,0),(7403,1313,'梁庄乡',4,'',0,1,0,0),(7404,1313,'蕉山乡',4,'',0,1,0,0),(7405,1314,'上深涧乡',4,'',0,1,0,0),(7406,1314,'堡子湾乡',4,'',0,1,0,0),(7407,1314,'新荣镇',4,'',0,1,0,0),(7408,1314,'破鲁堡乡',4,'',0,1,0,0),(7409,1314,'花园湾屯乡',4,'',0,1,0,0),(7410,1314,'西村乡',4,'',0,1,0,0),(7411,1314,'郭家窑乡',4,'',0,1,0,0),(7412,1315,'下韩村乡',4,'',0,1,0,0),(7413,1315,'东坊城乡',4,'',0,1,0,0),(7414,1315,'千佛岭乡',4,'',0,1,0,0),(7415,1315,'南榆林乡',4,'',0,1,0,0),(7416,1315,'吴城乡',4,'',0,1,0,0),(7417,1315,'大仁庄乡',4,'',0,1,0,0),(7418,1315,'大磁窑镇',4,'',0,1,0,0),(7419,1315,'官儿乡',4,'',0,1,0,0),(7420,1315,'永安镇',4,'',0,1,0,0),(7421,1315,'沙圪坨镇',4,'',0,1,0,0),(7422,1315,'王庄堡镇',4,'',0,1,0,0),(7423,1315,'蔡村镇',4,'',0,1,0,0),(7424,1315,'裴村乡',4,'',0,1,0,0),(7425,1315,'西坊城镇',4,'',0,1,0,0),(7426,1315,'西留村乡',4,'',0,1,0,0),(7427,1315,'青磁窑乡',4,'',0,1,0,0),(7428,1315,'驼峰乡',4,'',0,1,0,0),(7429,1315,'黄花滩乡',4,'',0,1,0,0),(7430,1316,'上寨镇',4,'',0,1,0,0),(7431,1316,'下关乡',4,'',0,1,0,0),(7432,1316,'东河南镇',4,'',0,1,0,0),(7433,1316,'史庄乡',4,'',0,1,0,0),(7434,1316,'柳科乡',4,'',0,1,0,0),(7435,1316,'武灵镇',4,'',0,1,0,0),(7436,1316,'独峪乡',4,'',0,1,0,0),(7437,1316,'白崖台乡',4,'',0,1,0,0),(7438,1316,'石家乡',4,'',0,1,0,0),(7439,1316,'红石塄乡',4,'',0,1,0,0),(7440,1316,'落水河乡',4,'',0,1,0,0),(7441,1316,'赵北乡',4,'',0,1,0,0),(7442,1317,'口泉街道',4,'',0,1,0,0),(7443,1317,'同家梁街道',4,'',0,1,0,0),(7444,1317,'四台沟街道',4,'',0,1,0,0),(7445,1317,'四老沟街道',4,'',0,1,0,0),(7446,1317,'大斗沟街道',4,'',0,1,0,0),(7447,1317,'姜家湾街道',4,'',0,1,0,0),(7448,1317,'平泉路街道',4,'',0,1,0,0),(7449,1317,'忻州窑街道',4,'',0,1,0,0),(7450,1317,'挖金湾街道',4,'',0,1,0,0),(7451,1317,'新平旺街道',4,'',0,1,0,0),(7452,1317,'新泉路街道',4,'',0,1,0,0),(7453,1317,'新胜街道',4,'',0,1,0,0),(7454,1317,'晋华宫街道',4,'',0,1,0,0),(7455,1317,'杏儿沟街道',4,'',0,1,0,0),(7456,1317,'民胜街道',4,'',0,1,0,0),(7457,1317,'永定庄街道',4,'',0,1,0,0),(7458,1317,'煤峪口街道',4,'',0,1,0,0),(7459,1317,'燕子山街道',4,'',0,1,0,0),(7460,1317,'王村街道',4,'',0,1,0,0),(7461,1317,'白洞街道',4,'',0,1,0,0),(7462,1317,'雁崖街道',4,'',0,1,0,0),(7463,1317,'青磁窑街道',4,'',0,1,0,0),(7464,1317,'马口街道',4,'',0,1,0,0),(7465,1317,'马脊梁街道',4,'',0,1,0,0),(7466,1318,'下深井乡',4,'',0,1,0,0),(7467,1318,'东小村镇',4,'',0,1,0,0),(7468,1318,'北徐屯乡',4,'',0,1,0,0),(7469,1318,'友宰镇',4,'',0,1,0,0),(7470,1318,'古城镇',4,'',0,1,0,0),(7471,1318,'大白登镇',4,'',0,1,0,0),(7472,1318,'狮子屯镇',4,'',0,1,0,0),(7473,1318,'王官屯镇',4,'',0,1,0,0),(7474,1318,'罗文皂镇',4,'',0,1,0,0),(7475,1318,'长城乡',4,'',0,1,0,0),(7476,1318,'马家皂乡',4,'',0,1,0,0),(7477,1318,'鳌石乡',4,'',0,1,0,0),(7478,1318,'龙泉镇',4,'',0,1,0,0),(7479,1319,'上站街道',4,'',0,1,0,0),(7480,1319,'下站街道',4,'',0,1,0,0),(7481,1319,'义井街道',4,'',0,1,0,0),(7482,1319,'北大街街道',4,'',0,1,0,0),(7483,1319,'南山路街道',4,'',0,1,0,0),(7484,1319,'坡底街道',4,'',0,1,0,0),(7485,1320,'东回镇',4,'',0,1,0,0),(7486,1320,'冠山镇',4,'',0,1,0,0),(7487,1320,'冶西镇',4,'',0,1,0,0),(7488,1320,'娘子关镇',4,'',0,1,0,0),(7489,1320,'岔口乡',4,'',0,1,0,0),(7490,1320,'巨城镇',4,'',0,1,0,0),(7491,1320,'张庄镇',4,'',0,1,0,0),(7492,1320,'柏井镇',4,'',0,1,0,0),(7493,1320,'石门口乡',4,'',0,1,0,0),(7494,1320,'锁簧镇',4,'',0,1,0,0),(7495,1321,'上社镇',4,'',0,1,0,0),(7496,1321,'下社乡',4,'',0,1,0,0),(7497,1321,'东粱乡',4,'',0,1,0,0),(7498,1321,'仙人乡',4,'',0,1,0,0),(7499,1321,'北下庄乡',4,'',0,1,0,0),(7500,1321,'南娄镇',4,'',0,1,0,0),(7501,1321,'孙家庄镇',4,'',0,1,0,0),(7502,1321,'梁家寨乡',4,'',0,1,0,0),(7503,1321,'牛村镇',4,'',0,1,0,0),(7504,1321,'秀水镇',4,'',0,1,0,0),(7505,1321,'苌池镇',4,'',0,1,0,0),(7506,1321,'西潘乡',4,'',0,1,0,0),(7507,1321,'西烟镇',4,'',0,1,0,0),(7508,1321,'路家村镇',4,'',0,1,0,0),(7509,1322,'平潭街街道',4,'',0,1,0,0),(7510,1322,'桥头街道',4,'',0,1,0,0),(7511,1322,'沙坪街道',4,'',0,1,0,0),(7512,1322,'蔡洼街道',4,'',0,1,0,0),(7513,1322,'贵石沟街道',4,'',0,1,0,0),(7514,1322,'赛鱼街道',4,'',0,1,0,0),(7515,1323,'义井镇',4,'',0,1,0,0),(7516,1323,'平坦镇',4,'',0,1,0,0),(7517,1323,'旧街乡',4,'',0,1,0,0),(7518,1323,'李家庄乡',4,'',0,1,0,0),(7519,1323,'杨家庄乡',4,'',0,1,0,0),(7520,1323,'河底镇',4,'',0,1,0,0),(7521,1323,'荫营镇',4,'',0,1,0,0),(7522,1323,'西南舁乡',4,'',0,1,0,0),(7523,1324,'东街街道',4,'',0,1,0,0),(7524,1324,'五一路街道',4,'',0,1,0,0),(7525,1324,'五马街道',4,'',0,1,0,0),(7526,1324,'北关街道',4,'',0,1,0,0),(7527,1324,'北董街道',4,'',0,1,0,0),(7528,1324,'南街街道',4,'',0,1,0,0),(7529,1324,'太行东街街道',4,'',0,1,0,0),(7530,1324,'太行西街街道',4,'',0,1,0,0),(7531,1324,'英雄街道',4,'',0,1,0,0),(7532,1324,'西街街道',4,'',0,1,0,0),(7533,1325,'东井岭乡',4,'',0,1,0,0),(7534,1325,'五龙山乡',4,'',0,1,0,0),(7535,1325,'店上镇',4,'',0,1,0,0),(7536,1325,'晋庄镇',4,'',0,1,0,0),(7537,1325,'树掌镇',4,'',0,1,0,0),(7538,1325,'桥上乡',4,'',0,1,0,0),(7539,1325,'百尺镇',4,'',0,1,0,0),(7540,1325,'石坡乡',4,'',0,1,0,0),(7541,1325,'集店乡',4,'',0,1,0,0),(7542,1325,'鹅屋乡',4,'',0,1,0,0),(7543,1325,'黄山乡',4,'',0,1,0,0),(7544,1325,'龙泉镇',4,'',0,1,0,0),(7545,1326,'上村镇',4,'',0,1,0,0),(7546,1326,'丰宜镇',4,'',0,1,0,0),(7547,1326,'余吾镇',4,'',0,1,0,0),(7548,1326,'吾元镇',4,'',0,1,0,0),(7549,1326,'张店镇',4,'',0,1,0,0),(7550,1326,'李高乡',4,'',0,1,0,0),(7551,1326,'河神庙乡',4,'',0,1,0,0),(7552,1326,'渔泽镇',4,'',0,1,0,0),(7553,1326,'西贾乡',4,'',0,1,0,0),(7554,1326,'路村乡',4,'',0,1,0,0),(7555,1326,'麒绛镇',4,'',0,1,0,0),(7556,1327,'东寺头乡',4,'',0,1,0,0),(7557,1327,'中五井乡',4,'',0,1,0,0),(7558,1327,'北社乡',4,'',0,1,0,0),(7559,1327,'北耽车乡',4,'',0,1,0,0),(7560,1327,'杏城镇',4,'',0,1,0,0),(7561,1327,'石城镇',4,'',0,1,0,0),(7562,1327,'苗庄镇',4,'',0,1,0,0),(7563,1327,'虹梯关乡',4,'',0,1,0,0),(7564,1327,'西沟乡',4,'',0,1,0,0),(7565,1327,'阳高乡',4,'',0,1,0,0),(7566,1327,'青羊镇',4,'',0,1,0,0),(7567,1327,'龙溪镇',4,'',0,1,0,0),(7568,1328,'上司乡',4,'',0,1,0,0),(7569,1328,'丰州镇',4,'',0,1,0,0),(7570,1328,'分水岭乡',4,'',0,1,0,0),(7571,1328,'墨镫乡',4,'',0,1,0,0),(7572,1328,'大有乡',4,'',0,1,0,0),(7573,1328,'故县乡',4,'',0,1,0,0),(7574,1328,'故城镇',4,'',0,1,0,0),(7575,1328,'洪水镇',4,'',0,1,0,0),(7576,1328,'涌泉乡',4,'',0,1,0,0),(7577,1328,'监漳镇',4,'',0,1,0,0),(7578,1328,'石北乡',4,'',0,1,0,0),(7579,1328,'蟠龙镇',4,'',0,1,0,0),(7580,1328,'贾豁乡',4,'',0,1,0,0),(7581,1328,'韩北乡',4,'',0,1,0,0),(7582,1329,'册村镇',4,'',0,1,0,0),(7583,1329,'南泉乡',4,'',0,1,0,0),(7584,1329,'南里乡',4,'',0,1,0,0),(7585,1329,'定昌镇',4,'',0,1,0,0),(7586,1329,'故县镇',4,'',0,1,0,0),(7587,1329,'新店镇',4,'',0,1,0,0),(7588,1329,'杨安乡',4,'',0,1,0,0),(7589,1329,'松村乡',4,'',0,1,0,0),(7590,1329,'次村乡',4,'',0,1,0,0),(7591,1329,'段柳乡',4,'',0,1,0,0),(7592,1329,'漳源镇',4,'',0,1,0,0),(7593,1329,'牛寺乡',4,'',0,1,0,0),(7594,1329,'郭村镇',4,'',0,1,0,0),(7595,1330,'中峪乡',4,'',0,1,0,0),(7596,1330,'交口乡',4,'',0,1,0,0),(7597,1330,'官滩乡',4,'',0,1,0,0),(7598,1330,'景风乡',4,'',0,1,0,0),(7599,1330,'李元镇',4,'',0,1,0,0),(7600,1330,'沁河镇',4,'',0,1,0,0),(7601,1330,'法中乡',4,'',0,1,0,0),(7602,1330,'灵空山镇',4,'',0,1,0,0),(7603,1330,'王和镇',4,'',0,1,0,0),(7604,1330,'王陶乡',4,'',0,1,0,0),(7605,1330,'聪子峪乡',4,'',0,1,0,0),(7606,1330,'赤石桥乡',4,'',0,1,0,0),(7607,1330,'郭道镇',4,'',0,1,0,0),(7608,1330,'韩洪乡',4,'',0,1,0,0),(7609,1331,'史迥乡',4,'',0,1,0,0),(7610,1331,'合室乡',4,'',0,1,0,0),(7611,1331,'店上镇',4,'',0,1,0,0),(7612,1331,'微子镇',4,'',0,1,0,0),(7613,1331,'成家川街道',4,'',0,1,0,0),(7614,1331,'潞华街道',4,'',0,1,0,0),(7615,1331,'翟店镇',4,'',0,1,0,0),(7616,1331,'辛安泉镇',4,'',0,1,0,0),(7617,1331,'黄牛蹄乡',4,'',0,1,0,0),(7618,1332,'上马乡',4,'',0,1,0,0),(7619,1332,'下良镇',4,'',0,1,0,0),(7620,1332,'候堡镇',4,'',0,1,0,0),(7621,1332,'北底乡',4,'',0,1,0,0),(7622,1332,'古韩镇',4,'',0,1,0,0),(7623,1332,'善福乡',4,'',0,1,0,0),(7624,1332,'夏店镇',4,'',0,1,0,0),(7625,1332,'王村镇',4,'',0,1,0,0),(7626,1332,'王桥镇',4,'',0,1,0,0),(7627,1332,'虒亭镇',4,'',0,1,0,0),(7628,1332,'西营镇',4,'',0,1,0,0),(7629,1333,'堠北庄镇',4,'',0,1,0,0),(7630,1333,'大辛庄镇',4,'',0,1,0,0),(7631,1333,'故县街道',4,'',0,1,0,0),(7632,1333,'老顶山镇',4,'',0,1,0,0),(7633,1333,'西白兔乡',4,'',0,1,0,0),(7634,1333,'长北街道',4,'',0,1,0,0),(7635,1333,'马厂镇',4,'',0,1,0,0),(7636,1333,'黄碾镇',4,'',0,1,0,0),(7637,1334,'丹朱镇',4,'',0,1,0,0),(7638,1334,'南漳镇',4,'',0,1,0,0),(7639,1334,'南陈乡',4,'',0,1,0,0),(7640,1334,'大堡头镇',4,'',0,1,0,0),(7641,1334,'宋村乡',4,'',0,1,0,0),(7642,1334,'岚水乡',4,'',0,1,0,0),(7643,1334,'常张乡',4,'',0,1,0,0),(7644,1334,'慈林镇',4,'',0,1,0,0),(7645,1334,'石哲镇',4,'',0,1,0,0),(7646,1334,'碾张乡',4,'',0,1,0,0),(7647,1334,'色头镇',4,'',0,1,0,0),(7648,1334,'鲍店镇',4,'',0,1,0,0),(7649,1335,'东和乡',4,'',0,1,0,0),(7650,1335,'八义镇',4,'',0,1,0,0),(7651,1335,'北呈乡',4,'',0,1,0,0),(7652,1335,'南宋乡',4,'',0,1,0,0),(7653,1335,'苏店镇',4,'',0,1,0,0),(7654,1335,'萌城镇',4,'',0,1,0,0),(7655,1335,'西池乡',4,'',0,1,0,0),(7656,1335,'西火镇',4,'',0,1,0,0),(7657,1335,'贾掌镇',4,'',0,1,0,0),(7658,1335,'郝家庄乡',4,'',0,1,0,0),(7659,1335,'韩店镇',4,'',0,1,0,0),(7660,1336,'上遥镇',4,'',0,1,0,0),(7661,1336,'东阳关镇',4,'',0,1,0,0),(7662,1336,'停河铺乡',4,'',0,1,0,0),(7663,1336,'洪井乡',4,'',0,1,0,0),(7664,1336,'程家山乡',4,'',0,1,0,0),(7665,1336,'西井镇',4,'',0,1,0,0),(7666,1336,'西仵乡',4,'',0,1,0,0),(7667,1336,'黄崖洞镇',4,'',0,1,0,0),(7668,1336,'黎侯镇',4,'',0,1,0,0),(7669,1337,'东街街道',4,'',0,1,0,0),(7670,1337,'北石店镇',4,'',0,1,0,0),(7671,1337,'北街街道',4,'',0,1,0,0),(7672,1337,'南街街道',4,'',0,1,0,0),(7673,1337,'矿区街道',4,'',0,1,0,0),(7674,1337,'西上庄街道',4,'',0,1,0,0),(7675,1337,'西街街道',4,'',0,1,0,0),(7676,1337,'钟家庄街道',4,'',0,1,0,0),(7677,1338,'中村镇',4,'',0,1,0,0),(7678,1338,'十里乡',4,'',0,1,0,0),(7679,1338,'嘉峰镇',4,'',0,1,0,0),(7680,1338,'固县乡',4,'',0,1,0,0),(7681,1338,'土沃乡',4,'',0,1,0,0),(7682,1338,'张村乡',4,'',0,1,0,0),(7683,1338,'柿庄镇',4,'',0,1,0,0),(7684,1338,'樊村河乡',4,'',0,1,0,0),(7685,1338,'端氏镇',4,'',0,1,0,0),(7686,1338,'胡底乡',4,'',0,1,0,0),(7687,1338,'苏庄乡',4,'',0,1,0,0),(7688,1338,'郑庄镇',4,'',0,1,0,0),(7689,1338,'郑村镇',4,'',0,1,0,0),(7690,1338,'龙港镇',4,'',0,1,0,0),(7691,1339,'下村镇',4,'',0,1,0,0),(7692,1339,'北义城镇',4,'',0,1,0,0),(7693,1339,'南岭乡',4,'',0,1,0,0),(7694,1339,'南村镇',4,'',0,1,0,0),(7695,1339,'周村镇',4,'',0,1,0,0),(7696,1339,'大东沟镇',4,'',0,1,0,0),(7697,1339,'大箕镇',4,'',0,1,0,0),(7698,1339,'大阳镇',4,'',0,1,0,0),(7699,1339,'山河镇',4,'',0,1,0,0),(7700,1339,'川底乡',4,'',0,1,0,0),(7701,1339,'巴公镇',4,'',0,1,0,0),(7702,1339,'晋庙铺镇',4,'',0,1,0,0),(7703,1339,'李寨乡',4,'',0,1,0,0),(7704,1339,'柳树口镇',4,'',0,1,0,0),(7705,1339,'犁川镇',4,'',0,1,0,0),(7706,1339,'金村镇',4,'',0,1,0,0),(7707,1339,'高都镇',4,'',0,1,0,0),(7708,1340,'东冶镇',4,'',0,1,0,0),(7709,1340,'东城街道',4,'',0,1,0,0),(7710,1340,'凤城镇',4,'',0,1,0,0),(7711,1340,'北留镇',4,'',0,1,0,0),(7712,1340,'固隆乡',4,'',0,1,0,0),(7713,1340,'寺头乡',4,'',0,1,0,0),(7714,1340,'横河镇',4,'',0,1,0,0),(7715,1340,'次营镇',4,'',0,1,0,0),(7716,1340,'河北镇',4,'',0,1,0,0),(7717,1340,'润城镇',4,'',0,1,0,0),(7718,1340,'演礼乡',4,'',0,1,0,0),(7719,1340,'町店镇',4,'',0,1,0,0),(7720,1340,'白桑乡',4,'',0,1,0,0),(7721,1340,'芹池镇',4,'',0,1,0,0),(7722,1340,'董封乡',4,'',0,1,0,0),(7723,1340,'蟒河镇',4,'',0,1,0,0),(7724,1340,'西河乡',4,'',0,1,0,0),(7725,1340,'驾岭乡',4,'',0,1,0,0),(7726,1341,'六泉乡',4,'',0,1,0,0),(7727,1341,'古郊乡',4,'',0,1,0,0),(7728,1341,'夺火乡镇',4,'',0,1,0,0),(7729,1341,'崇文镇',4,'',0,1,0,0),(7730,1341,'平城镇',4,'',0,1,0,0),(7731,1341,'杨村镇',4,'',0,1,0,0),(7732,1341,'潞城镇',4,'',0,1,0,0),(7733,1341,'礼义镇',4,'',0,1,0,0),(7734,1341,'秦家庄镇',4,'',0,1,0,0),(7735,1341,'西河底镇',4,'',0,1,0,0),(7736,1341,'附城镇',4,'',0,1,0,0),(7737,1341,'马圪当乡',4,'',0,1,0,0),(7738,1342,'三甲镇',4,'',0,1,0,0),(7739,1342,'东城街街道',4,'',0,1,0,0),(7740,1342,'北城街街道',4,'',0,1,0,0),(7741,1342,'北诗镇',4,'',0,1,0,0),(7742,1342,'南城街街道',4,'',0,1,0,0),(7743,1342,'原村乡',4,'',0,1,0,0),(7744,1342,'寺庄镇',4,'',0,1,0,0),(7745,1342,'建宁乡',4,'',0,1,0,0),(7746,1342,'永录乡',4,'',0,1,0,0),(7747,1342,'河西镇',4,'',0,1,0,0),(7748,1342,'石末乡',4,'',0,1,0,0),(7749,1342,'神农镇',4,'',0,1,0,0),(7750,1342,'米山镇',4,'',0,1,0,0),(7751,1342,'野川镇',4,'',0,1,0,0),(7752,1342,'陈区镇',4,'',0,1,0,0),(7753,1342,'马村镇',4,'',0,1,0,0),(7754,1343,'丁家窑乡',4,'',0,1,0,0),(7755,1343,'元堡子镇',4,'',0,1,0,0),(7756,1343,'右卫镇',4,'',0,1,0,0),(7757,1343,'威远镇',4,'',0,1,0,0),(7758,1343,'新城镇',4,'',0,1,0,0),(7759,1343,'李达窑乡',4,'',0,1,0,0),(7760,1343,'杨千河乡',4,'',0,1,0,0),(7761,1343,'牛心堡乡',4,'',0,1,0,0),(7762,1343,'白头里乡',4,'',0,1,0,0),(7763,1343,'高家堡乡',4,'',0,1,0,0),(7764,1344,'下喇叭乡',4,'',0,1,0,0),(7765,1344,'北周庄镇',4,'',0,1,0,0),(7766,1344,'古城镇',4,'',0,1,0,0),(7767,1344,'合盛堡乡',4,'',0,1,0,0),(7768,1344,'后所乡',4,'',0,1,0,0),(7769,1344,'吴马营乡',4,'',0,1,0,0),(7770,1344,'安荣乡',4,'',0,1,0,0),(7771,1344,'岱岳乡',4,'',0,1,0,0),(7772,1344,'岱岳镇',4,'',0,1,0,0),(7773,1344,'张家庄乡',4,'',0,1,0,0),(7774,1344,'玉井镇',4,'',0,1,0,0),(7775,1344,'薛圐圙乡',4,'',0,1,0,0),(7776,1344,'马营乡',4,'',0,1,0,0),(7777,1344,'马营庄乡',4,'',0,1,0,0),(7778,1345,'下木角乡',4,'',0,1,0,0),(7779,1345,'下水头乡',4,'',0,1,0,0),(7780,1345,'下面高乡',4,'',0,1,0,0),(7781,1345,'井坪镇',4,'',0,1,0,0),(7782,1345,'凤凰城镇',4,'',0,1,0,0),(7783,1345,'双碾乡',4,'',0,1,0,0),(7784,1345,'向阳堡乡',4,'',0,1,0,0),(7785,1345,'榆林乡',4,'',0,1,0,0),(7786,1345,'白堂乡',4,'',0,1,0,0),(7787,1345,'西水界乡',4,'',0,1,0,0),(7788,1345,'阻虎乡',4,'',0,1,0,0),(7789,1345,'陶村乡',4,'',0,1,0,0),(7790,1345,'高石庄乡',4,'',0,1,0,0),(7791,1346,'下社镇',4,'',0,1,0,0),(7792,1346,'下马峪乡',4,'',0,1,0,0),(7793,1346,'义井乡',4,'',0,1,0,0),(7794,1346,'南河种镇',4,'',0,1,0,0),(7795,1346,'南泉乡',4,'',0,1,0,0),(7796,1346,'大临河乡',4,'',0,1,0,0),(7797,1346,'大黄巍乡',4,'',0,1,0,0),(7798,1346,'杏寨乡',4,'',0,1,0,0),(7799,1346,'白马石乡',4,'',0,1,0,0),(7800,1346,'臧寨乡',4,'',0,1,0,0),(7801,1346,'金城镇',4,'',0,1,0,0),(7802,1346,'镇子梁乡',4,'',0,1,0,0),(7803,1347,'云中镇',4,'',0,1,0,0),(7804,1347,'亲和乡',4,'',0,1,0,0),(7805,1347,'何家堡乡',4,'',0,1,0,0),(7806,1347,'吴家窑镇',4,'',0,1,0,0),(7807,1347,'新家园乡',4,'',0,1,0,0),(7808,1347,'毛家皂镇',4,'',0,1,0,0),(7809,1347,'河头乡',4,'',0,1,0,0),(7810,1347,'海北头乡',4,'',0,1,0,0),(7811,1347,'金沙滩镇',4,'',0,1,0,0),(7812,1347,'马辛庄乡',4,'',0,1,0,0),(7813,1348,'下团堡乡',4,'',0,1,0,0),(7814,1348,'利民镇',4,'',0,1,0,0),(7815,1348,'北城街道',4,'',0,1,0,0),(7816,1348,'北旺庄街道',4,'',0,1,0,0),(7817,1348,'南城街道',4,'',0,1,0,0),(7818,1348,'南榆林乡',4,'',0,1,0,0),(7819,1348,'小平易乡',4,'',0,1,0,0),(7820,1348,'张蔡庄乡',4,'',0,1,0,0),(7821,1348,'沙塄河乡',4,'',0,1,0,0),(7822,1348,'滋润乡',4,'',0,1,0,0),(7823,1348,'神头街道',4,'',0,1,0,0),(7824,1348,'神头镇',4,'',0,1,0,0),(7825,1348,'福善庄乡',4,'',0,1,0,0),(7826,1348,'窑子头乡',4,'',0,1,0,0),(7827,1348,'贾庄乡',4,'',0,1,0,0),(7828,1349,'三佳乡',4,'',0,1,0,0),(7829,1349,'东南街道',4,'',0,1,0,0),(7830,1349,'义安镇',4,'',0,1,0,0),(7831,1349,'义棠镇',4,'',0,1,0,0),(7832,1349,'北关街道',4,'',0,1,0,0),(7833,1349,'北坛街道',4,'',0,1,0,0),(7834,1349,'城关乡',4,'',0,1,0,0),(7835,1349,'宋古乡',4,'',0,1,0,0),(7836,1349,'张兰镇',4,'',0,1,0,0),(7837,1349,'洪山镇',4,'',0,1,0,0),(7838,1349,'绵山镇',4,'',0,1,0,0),(7839,1349,'西关街道',4,'',0,1,0,0),(7840,1349,'西南街道',4,'',0,1,0,0),(7841,1349,'连福镇',4,'',0,1,0,0),(7842,1349,'龙凤镇',4,'',0,1,0,0),(7843,1350,'义兴镇',4,'',0,1,0,0),(7844,1350,'喂马乡',4,'',0,1,0,0),(7845,1350,'平松乡',4,'',0,1,0,0),(7846,1350,'李阳镇',4,'',0,1,0,0),(7847,1350,'松烟镇',4,'',0,1,0,0),(7848,1350,'横岭镇',4,'',0,1,0,0),(7849,1350,'牛川乡',4,'',0,1,0,0),(7850,1350,'阳光占乡',4,'',0,1,0,0),(7851,1350,'青城镇',4,'',0,1,0,0),(7852,1350,'马坊乡',4,'',0,1,0,0),(7853,1351,'任村乡',4,'',0,1,0,0),(7854,1351,'侯城乡',4,'',0,1,0,0),(7855,1351,'北汪乡',4,'',0,1,0,0),(7856,1351,'小白乡',4,'',0,1,0,0),(7857,1351,'明星镇',4,'',0,1,0,0),(7858,1351,'水秀乡',4,'',0,1,0,0),(7859,1351,'胡村镇',4,'',0,1,0,0),(7860,1351,'范村镇',4,'',0,1,0,0),(7861,1351,'阳邑乡',4,'',0,1,0,0),(7862,1352,'上湖乡',4,'',0,1,0,0),(7863,1352,'南燕竹镇',4,'',0,1,0,0),(7864,1352,'宗艾镇',4,'',0,1,0,0),(7865,1352,'尹灵芝镇',4,'',0,1,0,0),(7866,1352,'平头镇',4,'',0,1,0,0),(7867,1352,'平舒乡',4,'',0,1,0,0),(7868,1352,'景尚乡',4,'',0,1,0,0),(7869,1352,'朝阳镇',4,'',0,1,0,0),(7870,1352,'松塔镇',4,'',0,1,0,0),(7871,1352,'温家庄乡',4,'',0,1,0,0),(7872,1352,'羊头崖乡',4,'',0,1,0,0),(7873,1352,'西洛镇',4,'',0,1,0,0),(7874,1352,'謦愁乡',4,'',0,1,0,0),(7875,1352,'马首乡',4,'',0,1,0,0),(7876,1353,'寒王乡',4,'',0,1,0,0),(7877,1353,'拐儿镇',4,'',0,1,0,0),(7878,1353,'桐峪镇',4,'',0,1,0,0),(7879,1353,'石匣乡',4,'',0,1,0,0),(7880,1353,'粟城乡',4,'',0,1,0,0),(7881,1353,'羊角乡',4,'',0,1,0,0),(7882,1353,'芹泉镇',4,'',0,1,0,0),(7883,1353,'辽阳镇',4,'',0,1,0,0),(7884,1353,'麻田镇',4,'',0,1,0,0),(7885,1353,'龙泉乡',4,'',0,1,0,0),(7886,1354,'东泉镇',4,'',0,1,0,0),(7887,1354,'中都乡',4,'',0,1,0,0),(7888,1354,'南政乡',4,'',0,1,0,0),(7889,1354,'卜宜乡',4,'',0,1,0,0),(7890,1354,'古陶镇',4,'',0,1,0,0),(7891,1354,'孟山乡',4,'',0,1,0,0),(7892,1354,'宁固镇',4,'',0,1,0,0),(7893,1354,'岳壁乡',4,'',0,1,0,0),(7894,1354,'朱坑乡',4,'',0,1,0,0),(7895,1354,'杜家庄乡',4,'',0,1,0,0),(7896,1354,'段村镇',4,'',0,1,0,0),(7897,1354,'洪善镇',4,'',0,1,0,0),(7898,1354,'襄垣乡',4,'',0,1,0,0),(7899,1354,'香乐乡',4,'',0,1,0,0),(7900,1355,'三都乡',4,'',0,1,0,0),(7901,1355,'东冶头镇',4,'',0,1,0,0),(7902,1355,'乐平镇',4,'',0,1,0,0),(7903,1355,'大寨镇',4,'',0,1,0,0),(7904,1355,'孔氏乡',4,'',0,1,0,0),(7905,1355,'李家庄乡',4,'',0,1,0,0),(7906,1355,'沾尚镇',4,'',0,1,0,0),(7907,1355,'界都乡',4,'',0,1,0,0),(7908,1355,'皋落镇',4,'',0,1,0,0),(7909,1355,'西寨乡',4,'',0,1,0,0),(7910,1355,'赵壁乡',4,'',0,1,0,0),(7911,1355,'闫庄乡',4,'',0,1,0,0),(7912,1356,'东赵乡',4,'',0,1,0,0),(7913,1356,'东阳镇',4,'',0,1,0,0),(7914,1356,'乌金山镇',4,'',0,1,0,0),(7915,1356,'什贴镇',4,'',0,1,0,0),(7916,1356,'修文镇',4,'',0,1,0,0),(7917,1356,'北关街道',4,'',0,1,0,0),(7918,1356,'北田镇',4,'',0,1,0,0),(7919,1356,'安宁街街道',4,'',0,1,0,0),(7920,1356,'庄子乡',4,'',0,1,0,0),(7921,1356,'张庆乡',4,'',0,1,0,0),(7922,1356,'新华街街道',4,'',0,1,0,0),(7923,1356,'新建街街道',4,'',0,1,0,0),(7924,1356,'晋华街街道',4,'',0,1,0,0),(7925,1356,'经纬街道',4,'',0,1,0,0),(7926,1356,'西南街街道',4,'',0,1,0,0),(7927,1356,'路西街街道',4,'',0,1,0,0),(7928,1356,'郭家堡乡',4,'',0,1,0,0),(7929,1356,'锦纶街街道',4,'',0,1,0,0),(7930,1356,'长凝镇',4,'',0,1,0,0),(7931,1357,'云簇镇',4,'',0,1,0,0),(7932,1357,'兰峪乡',4,'',0,1,0,0),(7933,1357,'北寨乡',4,'',0,1,0,0),(7934,1357,'河峪乡',4,'',0,1,0,0),(7935,1357,'社城镇',4,'',0,1,0,0),(7936,1357,'箕城镇',4,'',0,1,0,0),(7937,1357,'西马乡',4,'',0,1,0,0),(7938,1357,'讲堂乡',4,'',0,1,0,0),(7939,1357,'郝北镇',4,'',0,1,0,0),(7940,1358,'两渡镇',4,'',0,1,0,0),(7941,1358,'交口乡',4,'',0,1,0,0),(7942,1358,'南关镇',4,'',0,1,0,0),(7943,1358,'坛镇乡',4,'',0,1,0,0),(7944,1358,'夏门镇',4,'',0,1,0,0),(7945,1358,'段纯镇',4,'',0,1,0,0),(7946,1358,'王禹乡',4,'',0,1,0,0),(7947,1358,'粱家焉乡',4,'',0,1,0,0),(7948,1358,'翠峰镇',4,'',0,1,0,0),(7949,1358,'英武乡',4,'',0,1,0,0),(7950,1358,'静升镇',4,'',0,1,0,0),(7951,1358,'马和乡',4,'',0,1,0,0),(7952,1359,'东观镇',4,'',0,1,0,0),(7953,1359,'古县镇',4,'',0,1,0,0),(7954,1359,'城赵镇',4,'',0,1,0,0),(7955,1359,'峪口乡',4,'',0,1,0,0),(7956,1359,'昭余镇',4,'',0,1,0,0),(7957,1359,'来远镇',4,'',0,1,0,0),(7958,1359,'西六支乡',4,'',0,1,0,0),(7959,1359,'贾令镇',4,'',0,1,0,0),(7960,1360,'万泉乡',4,'',0,1,0,0),(7961,1360,'光华乡',4,'',0,1,0,0),(7962,1360,'南张乡',4,'',0,1,0,0),(7963,1360,'汉薛镇',4,'',0,1,0,0),(7964,1360,'王显乡',4,'',0,1,0,0),(7965,1360,'皇甫乡',4,'',0,1,0,0),(7966,1360,'荣河镇',4,'',0,1,0,0),(7967,1360,'裴庄乡',4,'',0,1,0,0),(7968,1360,'西村乡',4,'',0,1,0,0),(7969,1360,'解店镇',4,'',0,1,0,0),(7970,1360,'贾村乡',4,'',0,1,0,0),(7971,1360,'通化镇',4,'',0,1,0,0),(7972,1360,'里望乡',4,'',0,1,0,0),(7973,1360,'高村乡',4,'',0,1,0,0),(7974,1361,'七级镇',4,'',0,1,0,0),(7975,1361,'三管镇',4,'',0,1,0,0),(7976,1361,'东张镇',4,'',0,1,0,0),(7977,1361,'临晋镇',4,'',0,1,0,0),(7978,1361,'北景乡',4,'',0,1,0,0),(7979,1361,'北辛乡',4,'',0,1,0,0),(7980,1361,'卓里工贸区',4,'',0,1,0,0),(7981,1361,'孙吉镇',4,'',0,1,0,0),(7982,1361,'嵋阳镇',4,'',0,1,0,0),(7983,1361,'庙上乡',4,'',0,1,0,0),(7984,1361,'楚侯乡',4,'',0,1,0,0),(7985,1361,'牛杜工贸区',4,'',0,1,0,0),(7986,1361,'猗氏镇',4,'',0,1,0,0),(7987,1361,'耽子镇',4,'',0,1,0,0),(7988,1361,'角杯乡',4,'',0,1,0,0),(7989,1361,'闫家庄工贸区',4,'',0,1,0,0),(7990,1362,'华峰乡',4,'',0,1,0,0),(7991,1362,'历山镇',4,'',0,1,0,0),(7992,1362,'古城镇',4,'',0,1,0,0),(7993,1362,'新城镇',4,'',0,1,0,0),(7994,1362,'毛家镇',4,'',0,1,0,0),(7995,1362,'王茅镇',4,'',0,1,0,0),(7996,1362,'皋落乡',4,'',0,1,0,0),(7997,1362,'英言乡',4,'',0,1,0,0),(7998,1362,'蒲掌乡',4,'',0,1,0,0),(7999,1362,'解峪乡',4,'',0,1,0,0),(8000,1362,'长直乡',4,'',0,1,0,0),(8001,1363,'南大里乡',4,'',0,1,0,0),(8002,1363,'埝掌镇',4,'',0,1,0,0),(8003,1363,'尉郭乡',4,'',0,1,0,0),(8004,1363,'庙前镇',4,'',0,1,0,0),(8005,1363,'水头镇',4,'',0,1,0,0),(8006,1363,'泗交镇',4,'',0,1,0,0),(8007,1363,'瑶峰镇',4,'',0,1,0,0),(8008,1363,'祁家河乡',4,'',0,1,0,0),(8009,1363,'禹王乡',4,'',0,1,0,0),(8010,1363,'胡张乡',4,'',0,1,0,0),(8011,1363,'裴介镇',4,'',0,1,0,0),(8012,1364,'三门镇',4,'',0,1,0,0),(8013,1364,'圣人涧镇',4,'',0,1,0,0),(8014,1364,'坡底乡',4,'',0,1,0,0),(8015,1364,'常乐镇',4,'',0,1,0,0),(8016,1364,'张店镇',4,'',0,1,0,0),(8017,1364,'张村镇',4,'',0,1,0,0),(8018,1364,'曹川镇',4,'',0,1,0,0),(8019,1364,'杜马乡',4,'',0,1,0,0),(8020,1364,'洪池乡',4,'',0,1,0,0),(8021,1364,'部官乡',4,'',0,1,0,0),(8022,1365,'1个开发区',4,'',0,1,0,0),(8023,1365,'万安镇',4,'',0,1,0,0),(8024,1365,'三泉镇',4,'',0,1,0,0),(8025,1365,'北张镇',4,'',0,1,0,0),(8026,1365,'古交镇',4,'',0,1,0,0),(8027,1365,'横桥乡',4,'',0,1,0,0),(8028,1365,'泉掌镇',4,'',0,1,0,0),(8029,1365,'泽掌镇',4,'',0,1,0,0),(8030,1365,'阳王镇',4,'',0,1,0,0),(8031,1365,'龙兴镇',4,'',0,1,0,0),(8032,1366,'卿头镇',4,'',0,1,0,0),(8033,1366,'城东街道',4,'',0,1,0,0),(8034,1366,'城北街道',4,'',0,1,0,0),(8035,1366,'城西街道',4,'',0,1,0,0),(8036,1366,'开张镇',4,'',0,1,0,0),(8037,1366,'张营镇',4,'',0,1,0,0),(8038,1366,'枵栳镇',4,'',0,1,0,0),(8039,1366,'蒲州镇',4,'',0,1,0,0),(8040,1366,'虞乡镇',4,'',0,1,0,0),(8041,1366,'韩阳镇',4,'',0,1,0,0),(8042,1367,'下化乡',4,'',0,1,0,0),(8043,1367,'僧楼镇',4,'',0,1,0,0),(8044,1367,'城区街道',4,'',0,1,0,0),(8045,1367,'小梁乡',4,'',0,1,0,0),(8046,1367,'柴家乡',4,'',0,1,0,0),(8047,1367,'樊村镇',4,'',0,1,0,0),(8048,1367,'清涧街道',4,'',0,1,0,0),(8049,1367,'赵家庄乡',4,'',0,1,0,0),(8050,1367,'阳村乡',4,'',0,1,0,0),(8051,1368,'三路里镇',4,'',0,1,0,0),(8052,1368,'上王乡',4,'',0,1,0,0),(8053,1368,'上郭乡',4,'',0,1,0,0),(8054,1368,'东城街道',4,'',0,1,0,0),(8055,1368,'东郭镇',4,'',0,1,0,0),(8056,1368,'中城街道',4,'',0,1,0,0),(8057,1368,'冯村乡',4,'',0,1,0,0),(8058,1368,'北城街道',4,'',0,1,0,0),(8059,1368,'北相镇',4,'',0,1,0,0),(8060,1368,'南城街道',4,'',0,1,0,0),(8061,1368,'大渠街道',4,'',0,1,0,0),(8062,1368,'姚孟街道',4,'',0,1,0,0),(8063,1368,'安邑街道',4,'',0,1,0,0),(8064,1368,'席张乡',4,'',0,1,0,0),(8065,1368,'泓芝驿镇',4,'',0,1,0,0),(8066,1368,'王范乡',4,'',0,1,0,0),(8067,1368,'禹都经济技术开发区',4,'',0,1,0,0),(8068,1368,'西城街道',4,'',0,1,0,0),(8069,1368,'解州镇',4,'',0,1,0,0),(8070,1368,'金井乡',4,'',0,1,0,0),(8071,1368,'陶村镇',4,'',0,1,0,0),(8072,1368,'龙居镇',4,'',0,1,0,0),(8073,1369,'化峪镇',4,'',0,1,0,0),(8074,1369,'太阳乡',4,'',0,1,0,0),(8075,1369,'清河镇',4,'',0,1,0,0),(8076,1369,'稷峰镇',4,'',0,1,0,0),(8077,1369,'翟店镇',4,'',0,1,0,0),(8078,1369,'蔡村乡',4,'',0,1,0,0),(8079,1369,'西社镇',4,'',0,1,0,0),(8080,1370,'么里镇',4,'',0,1,0,0),(8081,1370,'冷口乡',4,'',0,1,0,0),(8082,1370,'南凡镇',4,'',0,1,0,0),(8083,1370,'卫庄镇',4,'',0,1,0,0),(8084,1370,'古绛镇',4,'',0,1,0,0),(8085,1370,'大交镇',4,'',0,1,0,0),(8086,1370,'安峪镇',4,'',0,1,0,0),(8087,1370,'横水镇',4,'',0,1,0,0),(8088,1370,'郝庄乡',4,'',0,1,0,0),(8089,1370,'陈村镇',4,'',0,1,0,0),(8090,1371,'东垆乡',4,'',0,1,0,0),(8091,1371,'南卫乡',4,'',0,1,0,0),(8092,1371,'古魏镇',4,'',0,1,0,0),(8093,1371,'大王镇',4,'',0,1,0,0),(8094,1371,'学张乡',4,'',0,1,0,0),(8095,1371,'永乐镇',4,'',0,1,0,0),(8096,1371,'西陌镇',4,'',0,1,0,0),(8097,1371,'阳城镇',4,'',0,1,0,0),(8098,1371,'陌南镇',4,'',0,1,0,0),(8099,1371,'风陵渡镇',4,'',0,1,0,0),(8100,1372,'东镇镇',4,'',0,1,0,0),(8101,1372,'候村乡',4,'',0,1,0,0),(8102,1372,'凹底镇',4,'',0,1,0,0),(8103,1372,'后宫乡',4,'',0,1,0,0),(8104,1372,'桐城镇',4,'',0,1,0,0),(8105,1372,'河底镇',4,'',0,1,0,0),(8106,1372,'石门乡',4,'',0,1,0,0),(8107,1372,'礼元镇',4,'',0,1,0,0),(8108,1372,'神柏乡',4,'',0,1,0,0),(8109,1372,'薛店镇',4,'',0,1,0,0),(8110,1372,'裴社乡',4,'',0,1,0,0),(8111,1372,'郭家庄镇',4,'',0,1,0,0),(8112,1372,'阳隅乡',4,'',0,1,0,0),(8113,1373,'东冶镇',4,'',0,1,0,0),(8114,1373,'东雷乡',4,'',0,1,0,0),(8115,1373,'五台山风景名胜区',4,'',0,1,0,0),(8116,1373,'台城镇',4,'',0,1,0,0),(8117,1373,'台怀镇',4,'',0,1,0,0),(8118,1373,'建安乡',4,'',0,1,0,0),(8119,1373,'沟南乡',4,'',0,1,0,0),(8120,1373,'灵境乡',4,'',0,1,0,0),(8121,1373,'白家庄镇',4,'',0,1,0,0),(8122,1373,'石咀乡',4,'',0,1,0,0),(8123,1373,'神西乡',4,'',0,1,0,0),(8124,1373,'耿镇镇',4,'',0,1,0,0),(8125,1373,'茹村乡',4,'',0,1,0,0),(8126,1373,'蒋坊乡',4,'',0,1,0,0),(8127,1373,'豆村镇',4,'',0,1,0,0),(8128,1373,'金岗库乡',4,'',0,1,0,0),(8129,1373,'门限石乡',4,'',0,1,0,0),(8130,1373,'阳白乡',4,'',0,1,0,0),(8131,1373,'陈家庄乡',4,'',0,1,0,0),(8132,1373,'高洪口乡',4,'',0,1,0,0),(8133,1374,'三岔镇',4,'',0,1,0,0),(8134,1374,'东秀庄乡',4,'',0,1,0,0),(8135,1374,'前所乡',4,'',0,1,0,0),(8136,1374,'孙家坪乡',4,'',0,1,0,0),(8137,1374,'小河头镇',4,'',0,1,0,0),(8138,1374,'新寨乡',4,'',0,1,0,0),(8139,1374,'李家坪乡',4,'',0,1,0,0),(8140,1374,'杏岭子乡',4,'',0,1,0,0),(8141,1374,'梁家坪乡',4,'',0,1,0,0),(8142,1374,'砚城镇',4,'',0,1,0,0),(8143,1374,'胡会乡',4,'',0,1,0,0),(8144,1374,'韩家楼乡',4,'',0,1,0,0),(8145,1375,'上馆镇',4,'',0,1,0,0),(8146,1375,'峨口镇',4,'',0,1,0,0),(8147,1375,'峪口乡',4,'',0,1,0,0),(8148,1375,'新高乡',4,'',0,1,0,0),(8149,1375,'枣林镇',4,'',0,1,0,0),(8150,1375,'滩上镇',4,'',0,1,0,0),(8151,1375,'磨坊乡',4,'',0,1,0,0),(8152,1375,'聂营镇',4,'',0,1,0,0),(8153,1375,'胡峪乡',4,'',0,1,0,0),(8154,1375,'阳明堡镇',4,'',0,1,0,0),(8155,1375,'雁门关乡',4,'',0,1,0,0),(8156,1376,'东关镇',4,'',0,1,0,0),(8157,1376,'义门镇',4,'',0,1,0,0),(8158,1376,'冯家川乡',4,'',0,1,0,0),(8159,1376,'南河沟乡',4,'',0,1,0,0),(8160,1376,'土崖塔乡',4,'',0,1,0,0),(8161,1376,'孙家沟乡',4,'',0,1,0,0),(8162,1376,'尧圪台乡',4,'',0,1,0,0),(8163,1376,'杨家湾镇',4,'',0,1,0,0),(8164,1376,'林遮峪乡',4,'',0,1,0,0),(8165,1376,'桥头镇',4,'',0,1,0,0),(8166,1376,'窖洼乡',4,'',0,1,0,0),(8167,1376,'腰庄乡',4,'',0,1,0,0),(8168,1376,'韩家川乡',4,'',0,1,0,0),(8169,1377,'万家寨镇',4,'',0,1,0,0),(8170,1377,'南堡子乡',4,'',0,1,0,0),(8171,1377,'天峰坪镇',4,'',0,1,0,0),(8172,1377,'尚峪乡',4,'',0,1,0,0),(8173,1377,'新关镇',4,'',0,1,0,0),(8174,1377,'楼沟乡',4,'',0,1,0,0),(8175,1377,'水泉乡',4,'',0,1,0,0),(8176,1377,'窑头乡',4,'',0,1,0,0),(8177,1377,'老营镇',4,'',0,1,0,0),(8178,1377,'陈家营乡',4,'',0,1,0,0),(8179,1378,'东社镇',4,'',0,1,0,0),(8180,1378,'中阳乡',4,'',0,1,0,0),(8181,1378,'北城街道',4,'',0,1,0,0),(8182,1378,'南城街道',4,'',0,1,0,0),(8183,1378,'南白乡',4,'',0,1,0,0),(8184,1378,'大林乡',4,'',0,1,0,0),(8185,1378,'大牛店镇',4,'',0,1,0,0),(8186,1378,'子干乡',4,'',0,1,0,0),(8187,1378,'崞阳镇',4,'',0,1,0,0),(8188,1378,'新原乡',4,'',0,1,0,0),(8189,1378,'楼板寨乡',4,'',0,1,0,0),(8190,1378,'段家堡乡',4,'',0,1,0,0),(8191,1378,'沿沟乡',4,'',0,1,0,0),(8192,1378,'王家庄乡',4,'',0,1,0,0),(8193,1378,'苏龙口镇',4,'',0,1,0,0),(8194,1378,'西镇乡',4,'',0,1,0,0),(8195,1378,'解村乡',4,'',0,1,0,0),(8196,1378,'轩岗镇',4,'',0,1,0,0),(8197,1378,'长梁沟镇',4,'',0,1,0,0),(8198,1378,'闫庄镇',4,'',0,1,0,0),(8199,1379,'东寨镇',4,'',0,1,0,0),(8200,1379,'东马坊乡',4,'',0,1,0,0),(8201,1379,'余庄乡',4,'',0,1,0,0),(8202,1379,'凤凰镇',4,'',0,1,0,0),(8203,1379,'化北屯乡',4,'',0,1,0,0),(8204,1379,'城区街道',4,'',0,1,0,0),(8205,1379,'怀道乡',4,'',0,1,0,0),(8206,1379,'新堡乡',4,'',0,1,0,0),(8207,1379,'涔山乡',4,'',0,1,0,0),(8208,1379,'石家庄镇',4,'',0,1,0,0),(8209,1379,'薛家洼乡',4,'',0,1,0,0),(8210,1379,'西马坊乡',4,'',0,1,0,0),(8211,1379,'迭台寺乡',4,'',0,1,0,0),(8212,1379,'阳方口镇',4,'',0,1,0,0),(8213,1380,'南王乡',4,'',0,1,0,0),(8214,1380,'受录乡',4,'',0,1,0,0),(8215,1380,'季庄乡',4,'',0,1,0,0),(8216,1380,'宏道镇',4,'',0,1,0,0),(8217,1380,'晋昌镇',4,'',0,1,0,0),(8218,1380,'杨芳乡',4,'',0,1,0,0),(8219,1380,'河边镇',4,'',0,1,0,0),(8220,1380,'神山乡',4,'',0,1,0,0),(8221,1380,'蒋村乡',4,'',0,1,0,0),(8222,1381,'三井镇',4,'',0,1,0,0),(8223,1381,'大涧乡',4,'',0,1,0,0),(8224,1381,'宋家沟乡',4,'',0,1,0,0),(8225,1381,'岚漪镇',4,'',0,1,0,0),(8226,1381,'李家沟乡',4,'',0,1,0,0),(8227,1381,'水峪贯乡',4,'',0,1,0,0),(8228,1381,'温泉乡',4,'',0,1,0,0),(8229,1381,'王家岔乡',4,'',0,1,0,0),(8230,1381,'神堂坪乡',4,'',0,1,0,0),(8231,1381,'西豹峪乡',4,'',0,1,0,0),(8232,1381,'阳坪乡',4,'',0,1,0,0),(8233,1381,'高家会乡',4,'',0,1,0,0),(8234,1382,'三交镇',4,'',0,1,0,0),(8235,1382,'东楼乡',4,'',0,1,0,0),(8236,1382,'兰村乡',4,'',0,1,0,0),(8237,1382,'北义井乡',4,'',0,1,0,0),(8238,1382,'南城街道',4,'',0,1,0,0),(8239,1382,'合索乡',4,'',0,1,0,0),(8240,1382,'奇村镇',4,'',0,1,0,0),(8241,1382,'庄磨镇',4,'',0,1,0,0),(8242,1382,'播明镇',4,'',0,1,0,0),(8243,1382,'新建路街道',4,'',0,1,0,0),(8244,1382,'曹张乡',4,'',0,1,0,0),(8245,1382,'秦城乡',4,'',0,1,0,0),(8246,1382,'紫岩乡',4,'',0,1,0,0),(8247,1382,'董村镇',4,'',0,1,0,0),(8248,1382,'西张乡',4,'',0,1,0,0),(8249,1382,'解原乡',4,'',0,1,0,0),(8250,1382,'豆罗镇',4,'',0,1,0,0),(8251,1382,'长征街街道',4,'',0,1,0,0),(8252,1382,'阳坡乡',4,'',0,1,0,0),(8253,1382,'高城乡',4,'',0,1,0,0),(8254,1383,'刘家塔镇',4,'',0,1,0,0),(8255,1383,'前川乡',4,'',0,1,0,0),(8256,1383,'单寨乡',4,'',0,1,0,0),(8257,1383,'土沟乡',4,'',0,1,0,0),(8258,1383,'巡镇',4,'',0,1,0,0),(8259,1383,'文笔镇',4,'',0,1,0,0),(8260,1383,'旧县乡',4,'',0,1,0,0),(8261,1383,'楼子营镇',4,'',0,1,0,0),(8262,1383,'沙坪乡',4,'',0,1,0,0),(8263,1383,'沙泉乡',4,'',0,1,0,0),(8264,1383,'社梁乡',4,'',0,1,0,0),(8265,1383,'赵家沟乡',4,'',0,1,0,0),(8266,1383,'鹿固乡',4,'',0,1,0,0),(8267,1384,'东湖乡',4,'',0,1,0,0),(8268,1384,'义井镇',4,'',0,1,0,0),(8269,1384,'八角镇',4,'',0,1,0,0),(8270,1384,'大严备乡',4,'',0,1,0,0),(8271,1384,'太平庄乡',4,'',0,1,0,0),(8272,1384,'烈堡乡',4,'',0,1,0,0),(8273,1384,'虎北乡',4,'',0,1,0,0),(8274,1384,'贺职乡',4,'',0,1,0,0),(8275,1384,'长畛乡',4,'',0,1,0,0),(8276,1384,'龙泉镇',4,'',0,1,0,0),(8277,1385,'下茹越乡',4,'',0,1,0,0),(8278,1385,'东山乡',4,'',0,1,0,0),(8279,1385,'光裕堡乡',4,'',0,1,0,0),(8280,1385,'大营镇',4,'',0,1,0,0),(8281,1385,'岩头乡',4,'',0,1,0,0),(8282,1385,'杏园乡',4,'',0,1,0,0),(8283,1385,'柏家庄乡',4,'',0,1,0,0),(8284,1385,'横涧乡',4,'',0,1,0,0),(8285,1385,'砂河镇',4,'',0,1,0,0),(8286,1385,'神堂堡乡',4,'',0,1,0,0),(8287,1385,'繁城镇',4,'',0,1,0,0),(8288,1385,'金山铺乡',4,'',0,1,0,0),(8289,1385,'集义庄乡',4,'',0,1,0,0),(8290,1386,'中庄乡',4,'',0,1,0,0),(8291,1386,'丰润镇',4,'',0,1,0,0),(8292,1386,'双路乡',4,'',0,1,0,0),(8293,1386,'堂尔上乡',4,'',0,1,0,0),(8294,1386,'娑婆乡',4,'',0,1,0,0),(8295,1386,'娘子神乡',4,'',0,1,0,0),(8296,1386,'康家会镇',4,'',0,1,0,0),(8297,1386,'杜家村镇',4,'',0,1,0,0),(8298,1386,'段家寨乡',4,'',0,1,0,0),(8299,1386,'王村乡',4,'',0,1,0,0),(8300,1386,'神峪沟乡',4,'',0,1,0,0),(8301,1386,'赤泥洼乡',4,'',0,1,0,0),(8302,1386,'辛村乡',4,'',0,1,0,0),(8303,1386,'鹅城镇',4,'',0,1,0,0),(8304,1387,'光华镇',4,'',0,1,0,0),(8305,1387,'关王庙乡',4,'',0,1,0,0),(8306,1387,'双鹤乡',4,'',0,1,0,0),(8307,1387,'台头镇',4,'',0,1,0,0),(8308,1387,'尉庄乡',4,'',0,1,0,0),(8309,1387,'昌宁镇',4,'',0,1,0,0),(8310,1387,'枣岭乡',4,'',0,1,0,0),(8311,1387,'管头镇',4,'',0,1,0,0),(8312,1387,'西交口乡',4,'',0,1,0,0),(8313,1387,'西坡镇',4,'',0,1,0,0),(8314,1388,'上马街道',4,'',0,1,0,0),(8315,1388,'凤城乡',4,'',0,1,0,0),(8316,1388,'张村街道',4,'',0,1,0,0),(8317,1388,'新田乡',4,'',0,1,0,0),(8318,1388,'浍滨街道',4,'',0,1,0,0),(8319,1388,'路东街道',4,'',0,1,0,0),(8320,1388,'路西街道',4,'',0,1,0,0),(8321,1388,'高村乡',4,'',0,1,0,0),(8322,1389,'北平镇',4,'',0,1,0,0),(8323,1389,'南垣乡',4,'',0,1,0,0),(8324,1389,'古阳镇',4,'',0,1,0,0),(8325,1389,'岳阳镇',4,'',0,1,0,0),(8326,1389,'旧县镇',4,'',0,1,0,0),(8327,1389,'永乐乡',4,'',0,1,0,0),(8328,1389,'石壁乡',4,'',0,1,0,0),(8329,1390,'东城乡',4,'',0,1,0,0),(8330,1390,'中垛乡',4,'',0,1,0,0),(8331,1390,'吉昌镇',4,'',0,1,0,0),(8332,1390,'壶口镇',4,'',0,1,0,0),(8333,1390,'屯里镇',4,'',0,1,0,0),(8334,1390,'文城乡',4,'',0,1,0,0),(8335,1390,'柏山寺乡',4,'',0,1,0,0),(8336,1390,'车城乡',4,'',0,1,0,0),(8337,1391,'三多乡',4,'',0,1,0,0),(8338,1391,'太古乡',4,'',0,1,0,0),(8339,1391,'太德乡',4,'',0,1,0,0),(8340,1391,'徐家垛乡',4,'',0,1,0,0),(8341,1391,'昕水镇',4,'',0,1,0,0),(8342,1391,'曲峨镇',4,'',0,1,0,0),(8343,1392,'冀氏镇',4,'',0,1,0,0),(8344,1392,'和川镇',4,'',0,1,0,0),(8345,1392,'唐城镇',4,'',0,1,0,0),(8346,1392,'府城镇',4,'',0,1,0,0),(8347,1392,'杜村乡',4,'',0,1,0,0),(8348,1392,'良马乡',4,'',0,1,0,0),(8349,1392,'马必乡',4,'',0,1,0,0),(8350,1393,'一平垣乡',4,'',0,1,0,0),(8351,1393,'乔李镇',4,'',0,1,0,0),(8352,1393,'乡贤街街道',4,'',0,1,0,0),(8353,1393,'刘村镇',4,'',0,1,0,0),(8354,1393,'南街街道',4,'',0,1,0,0),(8355,1393,'县底镇',4,'',0,1,0,0),(8356,1393,'吴村镇',4,'',0,1,0,0),(8357,1393,'土门镇',4,'',0,1,0,0),(8358,1393,'大阳镇',4,'',0,1,0,0),(8359,1393,'尧庙镇',4,'',0,1,0,0),(8360,1393,'屯里镇',4,'',0,1,0,0),(8361,1393,'枕头乡',4,'',0,1,0,0),(8362,1393,'段店乡',4,'',0,1,0,0),(8363,1393,'水塔街街道',4,'',0,1,0,0),(8364,1393,'汾河街道',4,'',0,1,0,0),(8365,1393,'河底乡',4,'',0,1,0,0),(8366,1393,'滨河办事处',4,'',0,1,0,0),(8367,1393,'解放路街道',4,'',0,1,0,0),(8368,1393,'贺家庄乡',4,'',0,1,0,0),(8369,1393,'贾得乡',4,'',0,1,0,0),(8370,1393,'车站街街道',4,'',0,1,0,0),(8371,1393,'辛寺街街道',4,'',0,1,0,0),(8372,1393,'金殿镇',4,'',0,1,0,0),(8373,1393,'铁路东街道',4,'',0,1,0,0),(8374,1393,'魏村镇',4,'',0,1,0,0),(8375,1393,'鼓楼西街街道',4,'',0,1,0,0),(8376,1394,'乐昌镇',4,'',0,1,0,0),(8377,1394,'北董乡',4,'',0,1,0,0),(8378,1394,'史村镇',4,'',0,1,0,0),(8379,1394,'曲村镇',4,'',0,1,0,0),(8380,1394,'杨谈乡',4,'',0,1,0,0),(8381,1394,'里村镇',4,'',0,1,0,0),(8382,1394,'高显镇',4,'',0,1,0,0),(8383,1395,'交口乡',4,'',0,1,0,0),(8384,1395,'南庄乡',4,'',0,1,0,0),(8385,1395,'坡头乡',4,'',0,1,0,0),(8386,1395,'打石腰乡',4,'',0,1,0,0),(8387,1395,'桑壁镇',4,'',0,1,0,0),(8388,1395,'芝河镇',4,'',0,1,0,0),(8389,1395,'阁底乡',4,'',0,1,0,0),(8390,1396,'佃坪乡',4,'',0,1,0,0),(8391,1396,'僧念镇',4,'',0,1,0,0),(8392,1396,'勍香镇',4,'',0,1,0,0),(8393,1396,'和平镇',4,'',0,1,0,0),(8394,1396,'团柏乡',4,'',0,1,0,0),(8395,1396,'对竹镇',4,'',0,1,0,0),(8396,1396,'永安镇',4,'',0,1,0,0),(8397,1396,'邢家要乡',4,'',0,1,0,0),(8398,1397,'万安镇',4,'',0,1,0,0),(8399,1397,'兴唐寺乡',4,'',0,1,0,0),(8400,1397,'刘家垣镇',4,'',0,1,0,0),(8401,1397,'堤村乡',4,'',0,1,0,0),(8402,1397,'大槐树镇',4,'',0,1,0,0),(8403,1397,'山头乡',4,'',0,1,0,0),(8404,1397,'左木乡',4,'',0,1,0,0),(8405,1397,'广胜寺镇',4,'',0,1,0,0),(8406,1397,'明姜镇',4,'',0,1,0,0),(8407,1397,'曲亭镇',4,'',0,1,0,0),(8408,1397,'淹底乡',4,'',0,1,0,0),(8409,1397,'甘亭镇',4,'',0,1,0,0),(8410,1397,'苏堡镇',4,'',0,1,0,0),(8411,1397,'赵城镇',4,'',0,1,0,0),(8412,1397,'辛村乡',4,'',0,1,0,0),(8413,1397,'龙马乡',4,'',0,1,0,0),(8414,1398,'东张镇',4,'',0,1,0,0),(8415,1398,'北王乡',4,'',0,1,0,0),(8416,1398,'北韩乡',4,'',0,1,0,0),(8417,1398,'响水河镇',4,'',0,1,0,0),(8418,1398,'天坛镇',4,'',0,1,0,0),(8419,1398,'寨圪塔乡',4,'',0,1,0,0),(8420,1398,'张庄镇',4,'',0,1,0,0),(8421,1398,'槐埝乡',4,'',0,1,0,0),(8422,1398,'米家垣乡',4,'',0,1,0,0),(8423,1399,'中卫乡',4,'',0,1,0,0),(8424,1399,'南唐乡',4,'',0,1,0,0),(8425,1399,'南梁镇',4,'',0,1,0,0),(8426,1399,'唐兴镇',4,'',0,1,0,0),(8427,1399,'桥上镇',4,'',0,1,0,0),(8428,1399,'浇底乡',4,'',0,1,0,0),(8429,1399,'王庄乡',4,'',0,1,0,0),(8430,1399,'西闫镇',4,'',0,1,0,0),(8431,1399,'里寨镇',4,'',0,1,0,0),(8432,1399,'隆化镇',4,'',0,1,0,0),(8433,1400,'乔家湾乡',4,'',0,1,0,0),(8434,1400,'克城镇',4,'',0,1,0,0),(8435,1400,'古县乡',4,'',0,1,0,0),(8436,1400,'太林乡',4,'',0,1,0,0),(8437,1400,'山中乡',4,'',0,1,0,0),(8438,1400,'红道乡',4,'',0,1,0,0),(8439,1400,'蒲城镇',4,'',0,1,0,0),(8440,1400,'薛关镇',4,'',0,1,0,0),(8441,1400,'黑龙关镇',4,'',0,1,0,0),(8442,1401,'南贾镇',4,'',0,1,0,0),(8443,1401,'南辛店乡',4,'',0,1,0,0),(8444,1401,'古城镇',4,'',0,1,0,0),(8445,1401,'大邓乡',4,'',0,1,0,0),(8446,1401,'新城镇',4,'',0,1,0,0),(8447,1401,'景毛乡',4,'',0,1,0,0),(8448,1401,'永固乡',4,'',0,1,0,0),(8449,1401,'汾城镇',4,'',0,1,0,0),(8450,1401,'襄陵镇',4,'',0,1,0,0),(8451,1401,'西贾乡',4,'',0,1,0,0),(8452,1401,'赵康镇',4,'',0,1,0,0),(8453,1401,'邓庄镇',4,'',0,1,0,0),(8454,1401,'陶寺乡',4,'',0,1,0,0),(8455,1402,'下李乡',4,'',0,1,0,0),(8456,1402,'午城镇',4,'',0,1,0,0),(8457,1402,'城南乡',4,'',0,1,0,0),(8458,1402,'寨子乡',4,'',0,1,0,0),(8459,1402,'阳头升乡',4,'',0,1,0,0),(8460,1402,'陡坡乡',4,'',0,1,0,0),(8461,1402,'黄土镇',4,'',0,1,0,0),(8462,1402,'龙泉镇',4,'',0,1,0,0),(8463,1403,'三教乡',4,'',0,1,0,0),(8464,1403,'北环路街道',4,'',0,1,0,0),(8465,1403,'南环路街道',4,'',0,1,0,0),(8466,1403,'大张镇',4,'',0,1,0,0),(8467,1403,'师庄乡',4,'',0,1,0,0),(8468,1403,'开元街道',4,'',0,1,0,0),(8469,1403,'李曹镇',4,'',0,1,0,0),(8470,1403,'白龙镇',4,'',0,1,0,0),(8471,1403,'辛置镇',4,'',0,1,0,0),(8472,1403,'退沙街道',4,'',0,1,0,0),(8473,1403,'陶唐峪乡',4,'',0,1,0,0),(8474,1403,'鼓楼街道',4,'',0,1,0,0),(8475,1404,'下枣林乡',4,'',0,1,0,0),(8476,1404,'宁兴镇',4,'',0,1,0,0),(8477,1404,'暖泉镇',4,'',0,1,0,0),(8478,1404,'枝柯镇',4,'',0,1,0,0),(8479,1404,'武家庄镇',4,'',0,1,0,0),(8480,1404,'车鸣峪乡',4,'',0,1,0,0),(8481,1404,'金罗镇',4,'',0,1,0,0),(8482,1405,'三交街道',4,'',0,1,0,0),(8483,1405,'三交镇',4,'',0,1,0,0),(8484,1405,'丛罗峪镇',4,'',0,1,0,0),(8485,1405,'临泉镇',4,'',0,1,0,0),(8486,1405,'克虎镇',4,'',0,1,0,0),(8487,1405,'兔板镇',4,'',0,1,0,0),(8488,1405,'刘家会镇',4,'',0,1,0,0),(8489,1405,'城内街道',4,'',0,1,0,0),(8490,1405,'城庄镇',4,'',0,1,0,0),(8491,1405,'大禹乡',4,'',0,1,0,0),(8492,1405,'安业乡',4,'',0,1,0,0),(8493,1405,'安家庄乡',4,'',0,1,0,0),(8494,1405,'招贤镇',4,'',0,1,0,0),(8495,1405,'曲峪镇',4,'',0,1,0,0),(8496,1405,'木瓜坪乡',4,'',0,1,0,0),(8497,1405,'林家坪镇',4,'',0,1,0,0),(8498,1405,'湍水头镇',4,'',0,1,0,0),(8499,1405,'玉坪乡',4,'',0,1,0,0),(8500,1405,'白文街道',4,'',0,1,0,0),(8501,1405,'白文镇',4,'',0,1,0,0),(8502,1405,'石白头乡',4,'',0,1,0,0),(8503,1405,'碛口街道',4,'',0,1,0,0),(8504,1405,'碛口镇',4,'',0,1,0,0),(8505,1405,'第八堡乡',4,'',0,1,0,0),(8506,1405,'车赶乡',4,'',0,1,0,0),(8507,1405,'雷家碛乡',4,'',0,1,0,0),(8508,1405,'青凉寺乡',4,'',0,1,0,0),(8509,1406,'双池镇',4,'',0,1,0,0),(8510,1406,'回龙乡',4,'',0,1,0,0),(8511,1406,'康城镇',4,'',0,1,0,0),(8512,1406,'桃红坡镇',4,'',0,1,0,0),(8513,1406,'水头镇',4,'',0,1,0,0),(8514,1406,'温泉乡',4,'',0,1,0,0),(8515,1406,'石口乡',4,'',0,1,0,0),(8516,1407,'东坡底乡',4,'',0,1,0,0),(8517,1407,'会立乡',4,'',0,1,0,0),(8518,1407,'夏家营镇',4,'',0,1,0,0),(8519,1407,'天宁镇',4,'',0,1,0,0),(8520,1407,'岭底乡',4,'',0,1,0,0),(8521,1407,'庞泉沟镇',4,'',0,1,0,0),(8522,1407,'水峪贯镇',4,'',0,1,0,0),(8523,1407,'洪相乡',4,'',0,1,0,0),(8524,1407,'西社镇',4,'',0,1,0,0),(8525,1407,'西营镇',4,'',0,1,0,0),(8526,1408,'东会乡',4,'',0,1,0,0),(8527,1408,'交楼申乡',4,'',0,1,0,0),(8528,1408,'固贤乡',4,'',0,1,0,0),(8529,1408,'圪达上乡',4,'',0,1,0,0),(8530,1408,'奥家湾乡',4,'',0,1,0,0),(8531,1408,'孟家坪乡',4,'',0,1,0,0),(8532,1408,'康宁镇',4,'',0,1,0,0),(8533,1408,'恶虎滩乡',4,'',0,1,0,0),(8534,1408,'瓦塘镇',4,'',0,1,0,0),(8535,1408,'罗峪口镇',4,'',0,1,0,0),(8536,1408,'蔚汾镇',4,'',0,1,0,0),(8537,1408,'蔡家会镇',4,'',0,1,0,0),(8538,1408,'蔡家崖乡',4,'',0,1,0,0),(8539,1408,'贺家会乡',4,'',0,1,0,0),(8540,1408,'赵家坪乡',4,'',0,1,0,0),(8541,1408,'高家村镇',4,'',0,1,0,0),(8542,1408,'魏家滩镇',4,'',0,1,0,0),(8543,1409,'下堡镇',4,'',0,1,0,0),(8544,1409,'下栅乡',4,'',0,1,0,0),(8545,1409,'中阳楼街道',4,'',0,1,0,0),(8546,1409,'兑镇镇',4,'',0,1,0,0),(8547,1409,'南阳乡',4,'',0,1,0,0),(8548,1409,'大孝堡乡',4,'',0,1,0,0),(8549,1409,'振兴街道',4,'',0,1,0,0),(8550,1409,'新义街道',4,'',0,1,0,0),(8551,1409,'杜村乡',4,'',0,1,0,0),(8552,1409,'柱濮镇',4,'',0,1,0,0),(8553,1409,'梧桐镇',4,'',0,1,0,0),(8554,1409,'西辛庄镇',4,'',0,1,0,0),(8555,1409,'阳泉曲镇',4,'',0,1,0,0),(8556,1409,'驿马乡',4,'',0,1,0,0),(8557,1409,'高阳镇',4,'',0,1,0,0),(8558,1410,'上明乡',4,'',0,1,0,0),(8559,1410,'东村镇',4,'',0,1,0,0),(8560,1410,'土峪乡',4,'',0,1,0,0),(8561,1410,'大蛇头乡',4,'',0,1,0,0),(8562,1410,'岚城镇',4,'',0,1,0,0),(8563,1410,'普明镇',4,'',0,1,0,0),(8564,1410,'梁家庄乡',4,'',0,1,0,0),(8565,1410,'河口乡',4,'',0,1,0,0),(8566,1410,'王狮乡',4,'',0,1,0,0),(8567,1410,'界河口镇',4,'',0,1,0,0),(8568,1410,'社科乡',4,'',0,1,0,0),(8569,1410,'顺会乡',4,'',0,1,0,0),(8570,1411,'下曲镇',4,'',0,1,0,0),(8571,1411,'凤城镇',4,'',0,1,0,0),(8572,1411,'刘胡兰镇',4,'',0,1,0,0),(8573,1411,'北张乡',4,'',0,1,0,0),(8574,1411,'南安镇',4,'',0,1,0,0),(8575,1411,'南庄镇',4,'',0,1,0,0),(8576,1411,'南武乡',4,'',0,1,0,0),(8577,1411,'孝义镇',4,'',0,1,0,0),(8578,1411,'开栅镇',4,'',0,1,0,0),(8579,1411,'西城乡',4,'',0,1,0,0),(8580,1411,'西槽头乡',4,'',0,1,0,0),(8581,1411,'马西乡',4,'',0,1,0,0),(8582,1412,'北武当镇',4,'',0,1,0,0),(8583,1412,'圪洞镇',4,'',0,1,0,0),(8584,1412,'大武镇',4,'',0,1,0,0),(8585,1412,'峪口镇',4,'',0,1,0,0),(8586,1412,'积翠乡',4,'',0,1,0,0),(8587,1412,'马坊镇',4,'',0,1,0,0),(8588,1412,'麻地会乡',4,'',0,1,0,0),(8589,1413,'三交镇',4,'',0,1,0,0),(8590,1413,'孟门镇',4,'',0,1,0,0),(8591,1413,'庄上镇',4,'',0,1,0,0),(8592,1413,'成家庄镇',4,'',0,1,0,0),(8593,1413,'李家湾乡',4,'',0,1,0,0),(8594,1413,'柳林镇',4,'',0,1,0,0),(8595,1413,'王家沟乡',4,'',0,1,0,0),(8596,1413,'留誉镇',4,'',0,1,0,0),(8597,1413,'石西乡',4,'',0,1,0,0),(8598,1413,'穆村镇',4,'',0,1,0,0),(8599,1413,'薛村镇',4,'',0,1,0,0),(8600,1413,'贾家垣乡',4,'',0,1,0,0),(8601,1413,'金家庄乡',4,'',0,1,0,0),(8602,1413,'陈家湾乡',4,'',0,1,0,0),(8603,1413,'高家沟乡',4,'',0,1,0,0),(8604,1414,'三泉镇',4,'',0,1,0,0),(8605,1414,'冀村镇',4,'',0,1,0,0),(8606,1414,'太和桥街道',4,'',0,1,0,0),(8607,1414,'峪道河镇',4,'',0,1,0,0),(8608,1414,'文峰街道',4,'',0,1,0,0),(8609,1414,'杏花村镇',4,'',0,1,0,0),(8610,1414,'杨家庄镇',4,'',0,1,0,0),(8611,1414,'栗家庄乡',4,'',0,1,0,0),(8612,1414,'演武镇',4,'',0,1,0,0),(8613,1414,'石庄镇',4,'',0,1,0,0),(8614,1414,'肖家庄镇',4,'',0,1,0,0),(8615,1414,'西河乡',4,'',0,1,0,0),(8616,1414,'贾家庄镇',4,'',0,1,0,0),(8617,1414,'阳城乡',4,'',0,1,0,0),(8618,1415,'义牒镇',4,'',0,1,0,0),(8619,1415,'前山乡',4,'',0,1,0,0),(8620,1415,'和合乡',4,'',0,1,0,0),(8621,1415,'小蒜镇',4,'',0,1,0,0),(8622,1415,'曹家垣乡',4,'',0,1,0,0),(8623,1415,'灵泉镇',4,'',0,1,0,0),(8624,1415,'罗村镇',4,'',0,1,0,0),(8625,1415,'裴沟乡',4,'',0,1,0,0),(8626,1415,'龙交乡',4,'',0,1,0,0),(8627,1416,'交口街道',4,'',0,1,0,0),(8628,1416,'信义镇',4,'',0,1,0,0),(8629,1416,'凤山街道',4,'',0,1,0,0),(8630,1416,'吴城镇',4,'',0,1,0,0),(8631,1416,'坪头乡',4,'',0,1,0,0),(8632,1416,'城北街道',4,'',0,1,0,0),(8633,1416,'枣林乡',4,'',0,1,0,0),(8634,1416,'滨河街道',4,'',0,1,0,0),(8635,1416,'田家会街道',4,'',0,1,0,0),(8636,1416,'红眼川乡',4,'',0,1,0,0),(8637,1416,'莲花池街道',4,'',0,1,0,0),(8638,1416,'西属巴街道',4,'',0,1,0,0),(8639,1417,'三道营乡',4,'',0,1,0,0),(8640,1417,'公喇嘛乡',4,'',0,1,0,0),(8641,1417,'城关镇',4,'',0,1,0,0),(8642,1417,'大红城乡',4,'',0,1,0,0),(8643,1417,'巧尔什营乡',4,'',0,1,0,0),(8644,1417,'新店子乡',4,'',0,1,0,0),(8645,1417,'樊家窑乡',4,'',0,1,0,0),(8646,1417,'盛乐镇',4,'',0,1,0,0),(8647,1417,'羊群沟乡',4,'',0,1,0,0),(8648,1417,'舍必崖乡',4,'',0,1,0,0),(8649,1417,'董家营乡',4,'',0,1,0,0),(8650,1417,'西沟门乡',4,'',0,1,0,0),(8651,1417,'黑老窑乡',4,'',0,1,0,0),(8652,1418,'中山西路街道',4,'',0,1,0,0),(8653,1418,'光明路街道',4,'',0,1,0,0),(8654,1418,'攸攸板镇',4,'',0,1,0,0),(8655,1418,'新华西路街道',4,'',0,1,0,0),(8656,1418,'海拉尔西路街道',4,'',0,1,0,0),(8657,1418,'环河街街道',4,'',0,1,0,0),(8658,1418,'通道街街道',4,'',0,1,0,0),(8659,1418,'钢铁路街道',4,'',0,1,0,0),(8660,1419,'三两乡',4,'',0,1,0,0),(8661,1419,'兵州亥乡',4,'',0,1,0,0),(8662,1419,'北什轴乡',4,'',0,1,0,0),(8663,1419,'只几梁乡',4,'',0,1,0,0),(8664,1419,'台阁牧镇',4,'',0,1,0,0),(8665,1419,'善岱镇',4,'',0,1,0,0),(8666,1419,'塔布赛乡',4,'',0,1,0,0),(8667,1419,'大岱乡',4,'',0,1,0,0),(8668,1419,'察素齐镇',4,'',0,1,0,0),(8669,1419,'把什乡',4,'',0,1,0,0),(8670,1419,'毕克齐镇',4,'',0,1,0,0),(8671,1419,'沙尔沁乡',4,'',0,1,0,0),(8672,1419,'沙尔营乡',4,'',0,1,0,0),(8673,1419,'白庙子镇',4,'',0,1,0,0),(8674,1419,'铁帽乡',4,'',0,1,0,0),(8675,1419,'陶思浩乡',4,'',0,1,0,0),(8676,1420,'中滩乡',4,'',0,1,0,0),(8677,1420,'乃只盖乡',4,'',0,1,0,0),(8678,1420,'五申镇',4,'',0,1,0,0),(8679,1420,'伍什家乡',4,'',0,1,0,0),(8680,1420,'双河镇',4,'',0,1,0,0),(8681,1420,'古城乡',4,'',0,1,0,0),(8682,1420,'新营子镇',4,'',0,1,0,0),(8683,1420,'永圣域乡',4,'',0,1,0,0),(8684,1420,'燕山营乡',4,'',0,1,0,0),(8685,1421,'东街街道',4,'',0,1,0,0),(8686,1421,'东风路街道',4,'',0,1,0,0),(8687,1421,'中山东路街道',4,'',0,1,0,0),(8688,1421,'保合少乡',4,'',0,1,0,0),(8689,1421,'毫沁营镇',4,'',0,1,0,0),(8690,1421,'海东路街道',4,'',0,1,0,0),(8691,1421,'西街街道',4,'',0,1,0,0),(8692,1421,'迎新路街道',4,'',0,1,0,0),(8693,1421,'锡林路街道',4,'',0,1,0,0),(8694,1422,'上秃亥乡',4,'',0,1,0,0),(8695,1422,'东土城乡',4,'',0,1,0,0),(8696,1422,'东红胜乡',4,'',0,1,0,0),(8697,1422,'中后河乡',4,'',0,1,0,0),(8698,1422,'二份子乡',4,'',0,1,0,0),(8699,1422,'厂汉木台乡',4,'',0,1,0,0),(8700,1422,'可可以力更镇',4,'',0,1,0,0),(8701,1422,'哈乐镇',4,'',0,1,0,0),(8702,1422,'哈拉合少乡',4,'',0,1,0,0),(8703,1422,'哈拉门独乡',4,'',0,1,0,0),(8704,1422,'大豆铺乡',4,'',0,1,0,0),(8705,1422,'大青山乡',4,'',0,1,0,0),(8706,1422,'纳令沟乡',4,'',0,1,0,0),(8707,1422,'耗赖山乡',4,'',0,1,0,0),(8708,1422,'西乌兰不浪镇',4,'',0,1,0,0),(8709,1422,'西红山子乡',4,'',0,1,0,0),(8710,1423,'五良太乡',4,'',0,1,0,0),(8711,1423,'北堡乡',4,'',0,1,0,0),(8712,1423,'单台子乡',4,'',0,1,0,0),(8713,1423,'喇嘛湾镇',4,'',0,1,0,0),(8714,1423,'城关镇',4,'',0,1,0,0),(8715,1423,'小庙子乡',4,'',0,1,0,0),(8716,1423,'暖泉乡',4,'',0,1,0,0),(8717,1423,'杨家窑乡',4,'',0,1,0,0),(8718,1423,'王桂窑乡',4,'',0,1,0,0),(8719,1423,'窑沟乡',4,'',0,1,0,0),(8720,1423,'韭菜庄乡',4,'',0,1,0,0),(8721,1424,'兴隆巷街道',4,'',0,1,0,0),(8722,1424,'大南街街道',4,'',0,1,0,0),(8723,1424,'小召前街街道',4,'',0,1,0,0),(8724,1424,'小黑镇',4,'',0,1,0,0),(8725,1424,'桃花乡',4,'',0,1,0,0),(8726,1424,'石羊桥东路街道',4,'',0,1,0,0),(8727,1424,'西菜园街道',4,'',0,1,0,0),(8728,1424,'鄂尔多斯路街道',4,'',0,1,0,0),(8729,1424,'长和廊街道',4,'',0,1,0,0),(8730,1425,'中专路街道',4,'',0,1,0,0),(8731,1425,'乌兰察布路街道',4,'',0,1,0,0),(8732,1425,'人民路街道',4,'',0,1,0,0),(8733,1425,'大学东路街道',4,'',0,1,0,0),(8734,1425,'大学西路街道',4,'',0,1,0,0),(8735,1425,'太平庄乡',4,'',0,1,0,0),(8736,1425,'巧报镇',4,'',0,1,0,0),(8737,1425,'巴彦镇',4,'',0,1,0,0),(8738,1425,'榆林镇',4,'',0,1,0,0),(8739,1425,'西把栅乡',4,'',0,1,0,0),(8740,1425,'金河镇',4,'',0,1,0,0),(8741,1425,'黄合少镇',4,'',0,1,0,0),(8742,1426,'东兴街道',4,'',0,1,0,0),(8743,1426,'东站街道',4,'',0,1,0,0),(8744,1426,'二里半街道',4,'',0,1,0,0),(8745,1426,'南圪洞街道',4,'',0,1,0,0),(8746,1426,'南门外街道',4,'',0,1,0,0),(8747,1426,'和平街道',4,'',0,1,0,0),(8748,1426,'回民街道',4,'',0,1,0,0),(8749,1426,'杨圪楞街道',4,'',0,1,0,0),(8750,1426,'河东街道',4,'',0,1,0,0),(8751,1426,'河东镇',4,'',0,1,0,0),(8752,1426,'西脑包街道',4,'',0,1,0,0),(8753,1426,'财神庙街道',4,'',0,1,0,0),(8754,1426,'铁西街道',4,'',0,1,0,0),(8755,1427,'兴胜镇',4,'',0,1,0,0),(8756,1427,'古城湾乡',4,'',0,1,0,0),(8757,1427,'哈业胡同镇',4,'',0,1,0,0),(8758,1427,'哈业脑包乡',4,'',0,1,0,0),(8759,1427,'哈林格尔镇',4,'',0,1,0,0),(8760,1427,'新城镇',4,'',0,1,0,0),(8761,1427,'沙尔沁乡',4,'',0,1,0,0),(8762,1427,'沙河镇',4,'',0,1,0,0),(8763,1427,'莎木佳镇',4,'',0,1,0,0),(8764,1427,'阿嘎如泰苏木',4,'',0,1,0,0),(8765,1427,'麻池镇',4,'',0,1,0,0),(8766,1428,'下湿壕乡',4,'',0,1,0,0),(8767,1428,'九分子乡',4,'',0,1,0,0),(8768,1428,'兴顺西乡',4,'',0,1,0,0),(8769,1428,'卜塔亥乡',4,'',0,1,0,0),(8770,1428,'大庙乡',4,'',0,1,0,0),(8771,1428,'忽鸡沟乡',4,'',0,1,0,0),(8772,1428,'新建乡',4,'',0,1,0,0),(8773,1428,'白灵淖乡',4,'',0,1,0,0),(8774,1428,'红泥井乡',4,'',0,1,0,0),(8775,1428,'西斗铺镇',4,'',0,1,0,0),(8776,1428,'金山镇',4,'',0,1,0,0),(8777,1428,'银号乡',4,'',0,1,0,0),(8778,1429,'三道河乡',4,'',0,1,0,0),(8779,1429,'三间房乡',4,'',0,1,0,0),(8780,1429,'九峰山生态管理委员会',4,'',0,1,0,0),(8781,1429,'二十四顷地乡',4,'',0,1,0,0),(8782,1429,'党三尧乡',4,'',0,1,0,0),(8783,1429,'双龙镇',4,'',0,1,0,0),(8784,1429,'吴坝乡',4,'',0,1,0,0),(8785,1429,'大城西乡',4,'',0,1,0,0),(8786,1429,'将军尧乡',4,'',0,1,0,0),(8787,1429,'小召子乡',4,'',0,1,0,0),(8788,1429,'明沙淖乡',4,'',0,1,0,0),(8789,1429,'毛岱乡',4,'',0,1,0,0),(8790,1429,'沙海子乡',4,'',0,1,0,0),(8791,1429,'沟门镇',4,'',0,1,0,0),(8792,1429,'海子乡',4,'',0,1,0,0),(8793,1429,'美岱召镇',4,'',0,1,0,0),(8794,1429,'苏波盖乡',4,'',0,1,0,0),(8795,1429,'萨拉齐镇',4,'',0,1,0,0),(8796,1430,'前进道街道',4,'',0,1,0,0),(8797,1430,'友谊大街街道',4,'',0,1,0,0),(8798,1430,'团结大街街道',4,'',0,1,0,0),(8799,1430,'少先路街道',4,'',0,1,0,0),(8800,1430,'市府东路街道',4,'',0,1,0,0),(8801,1430,'张家营子街道',4,'',0,1,0,0),(8802,1430,'昆工路街道',4,'',0,1,0,0),(8803,1430,'昆河镇',4,'',0,1,0,0),(8804,1430,'林荫路街道',4,'',0,1,0,0),(8805,1430,'沼潭街道',4,'',0,1,0,0),(8806,1430,'白云路街道',4,'',0,1,0,0),(8807,1430,'阿尔丁大街街道',4,'',0,1,0,0),(8808,1430,'鞍山道街道',4,'',0,1,0,0),(8809,1430,'黄河西路街道',4,'',0,1,0,0),(8810,1431,'矿山路街道',4,'',0,1,0,0),(8811,1431,'通阳道街道',4,'',0,1,0,0),(8812,1432,'五当召镇',4,'',0,1,0,0),(8813,1432,'五当沟街道',4,'',0,1,0,0),(8814,1432,'国庆乡',4,'',0,1,0,0),(8815,1432,'大发街道',4,'',0,1,0,0),(8816,1432,'大磁街道',4,'',0,1,0,0),(8817,1432,'白狐沟街道',4,'',0,1,0,0),(8818,1432,'石拐街道',4,'',0,1,0,0),(8819,1433,'乌克忽洞乡',4,'',0,1,0,0),(8820,1433,'乌兰忽洞乡',4,'',0,1,0,0),(8821,1433,'大苏吉乡',4,'',0,1,0,0),(8822,1433,'小文公乡',4,'',0,1,0,0),(8823,1433,'巴音敖包苏木',4,'',0,1,0,0),(8824,1433,'巴音珠日和苏木',4,'',0,1,0,0),(8825,1433,'希拉穆仁镇',4,'',0,1,0,0),(8826,1433,'新宝力格苏木',4,'',0,1,0,0),(8827,1433,'查干哈达苏木',4,'',0,1,0,0),(8828,1433,'查干敖包苏木',4,'',0,1,0,0),(8829,1433,'查干淖尔苏木',4,'',0,1,0,0),(8830,1433,'满都拉镇',4,'',0,1,0,0),(8831,1433,'百灵庙镇',4,'',0,1,0,0),(8832,1433,'石宝镇',4,'',0,1,0,0),(8833,1433,'西河乡',4,'',0,1,0,0),(8834,1433,'都荣敖包苏木',4,'',0,1,0,0),(8835,1433,'额尔登敖包苏木',4,'',0,1,0,0),(8836,1434,'万青路街道',4,'',0,1,0,0),(8837,1434,'乌素图街道',4,'',0,1,0,0),(8838,1434,'先锋道街道',4,'',0,1,0,0),(8839,1434,'富强路街道',4,'',0,1,0,0),(8840,1434,'幸福路街道',4,'',0,1,0,0),(8841,1434,'科学路街道',4,'',0,1,0,0),(8842,1434,'自由路街道',4,'',0,1,0,0),(8843,1434,'青山路街道',4,'',0,1,0,0),(8844,1434,'青福镇',4,'',0,1,0,0),(8845,1435,'三道坎街道',4,'',0,1,0,0),(8846,1435,'乌兰淖尔镇',4,'',0,1,0,0),(8847,1435,'五虎山街道',4,'',0,1,0,0),(8848,1435,'巴音赛街道',4,'',0,1,0,0),(8849,1435,'振华街道',4,'',0,1,0,0),(8850,1435,'教子沟街道',4,'',0,1,0,0),(8851,1435,'梁家沟街道',4,'',0,1,0,0),(8852,1435,'苏海图街道',4,'',0,1,0,0),(8853,1436,'凤凰岭街道',4,'',0,1,0,0),(8854,1436,'千里山镇',4,'',0,1,0,0),(8855,1436,'卡布其街道',4,'',0,1,0,0),(8856,1436,'新华街道',4,'',0,1,0,0),(8857,1436,'新华西街道',4,'',0,1,0,0),(8858,1436,'海北街道',4,'',0,1,0,0),(8859,1436,'滨河街道',4,'',0,1,0,0),(8860,1437,'公乌素镇',4,'',0,1,0,0),(8861,1437,'巴音陶亥镇',4,'',0,1,0,0),(8862,1437,'拉僧仲街道',4,'',0,1,0,0),(8863,1437,'拉僧庙镇',4,'',0,1,0,0),(8864,1437,'西卓子山街道',4,'',0,1,0,0),(8865,1438,'五家镇',4,'',0,1,0,0),(8866,1438,'元宝山镇',4,'',0,1,0,0),(8867,1438,'古山镇',4,'',0,1,0,0),(8868,1438,'小五家回族乡',4,'',0,1,0,0),(8869,1438,'山前镇',4,'',0,1,0,0),(8870,1438,'平庄城区街道',4,'',0,1,0,0),(8871,1438,'平庄镇',4,'',0,1,0,0),(8872,1438,'建昌营镇',4,'',0,1,0,0),(8873,1438,'美丽河镇',4,'',0,1,0,0),(8874,1438,'西露天街道',4,'',0,1,0,0),(8875,1438,'风水沟镇',4,'',0,1,0,0),(8876,1438,'马林镇',4,'',0,1,0,0),(8877,1438,'马蹄营子乡',4,'',0,1,0,0),(8878,1439,'万合永镇',4,'',0,1,0,0),(8879,1439,'三义乡',4,'',0,1,0,0),(8880,1439,'乌兰布统乡',4,'',0,1,0,0),(8881,1439,'书声乡',4,'',0,1,0,0),(8882,1439,'南店镇',4,'',0,1,0,0),(8883,1439,'同兴镇',4,'',0,1,0,0),(8884,1439,'土城子镇',4,'',0,1,0,0),(8885,1439,'宇宙地镇',4,'',0,1,0,0),(8886,1439,'巴彦查干苏木',4,'',0,1,0,0),(8887,1439,'巴彦高勒苏木',4,'',0,1,0,0),(8888,1439,'广兴源镇',4,'',0,1,0,0),(8889,1439,'新井乡',4,'',0,1,0,0),(8890,1439,'新庙乡',4,'',0,1,0,0),(8891,1439,'新开地乡',4,'',0,1,0,0),(8892,1439,'浩来呼热乡',4,'',0,1,0,0),(8893,1439,'红山子乡',4,'',0,1,0,0),(8894,1439,'经棚镇',4,'',0,1,0,0),(8895,1439,'芝瑞镇',4,'',0,1,0,0),(8896,1439,'达日罕乌拉苏木',4,'',0,1,0,0),(8897,1439,'达来诺日镇',4,'',0,1,0,0),(8898,1440,'乃林果树农场',4,'',0,1,0,0),(8899,1440,'乃林镇',4,'',0,1,0,0),(8900,1440,'十家满族乡',4,'',0,1,0,0),(8901,1440,'南台子乡',4,'',0,1,0,0),(8902,1440,'四十家子乡',4,'',0,1,0,0),(8903,1440,'大牛群乡',4,'',0,1,0,0),(8904,1440,'小牛群乡',4,'',0,1,0,0),(8905,1440,'旺业甸镇',4,'',0,1,0,0),(8906,1440,'昌盛远乡',4,'',0,1,0,0),(8907,1440,'楼子店乡',4,'',0,1,0,0),(8908,1440,'永丰乡',4,'',0,1,0,0),(8909,1440,'牛营子镇',4,'',0,1,0,0),(8910,1440,'王爷府镇',4,'',0,1,0,0),(8911,1440,'美林乡',4,'',0,1,0,0),(8912,1440,'西桥乡',4,'',0,1,0,0),(8913,1440,'锦山镇',4,'',0,1,0,0),(8914,1440,'马鞍山乡',4,'',0,1,0,0),(8915,1440,'马鞍山羊场',4,'',0,1,0,0),(8916,1440,'龙山镇',4,'',0,1,0,0),(8917,1441,'三座店乡',4,'',0,1,0,0),(8918,1441,'五化乡',4,'',0,1,0,0),(8919,1441,'八里罕镇',4,'',0,1,0,0),(8920,1441,'大双庙乡',4,'',0,1,0,0),(8921,1441,'大城子镇',4,'',0,1,0,0),(8922,1441,'大明镇',4,'',0,1,0,0),(8923,1441,'天义镇',4,'',0,1,0,0),(8924,1441,'小城子镇',4,'',0,1,0,0),(8925,1441,'必斯营子乡',4,'',0,1,0,0),(8926,1441,'忙农镇',4,'',0,1,0,0),(8927,1441,'汐子镇',4,'',0,1,0,0),(8928,1441,'甸子镇',4,'',0,1,0,0),(8929,1441,'黑里河镇',4,'',0,1,0,0),(8930,1442,'大板镇',4,'',0,1,0,0),(8931,1442,'宝日勿苏镇',4,'',0,1,0,0),(8932,1442,'岗根苏木',4,'',0,1,0,0),(8933,1442,'巴彦塔拉苏木',4,'',0,1,0,0),(8934,1442,'巴彦汉镇',4,'',0,1,0,0),(8935,1442,'巴彦琥硕镇',4,'',0,1,0,0),(8936,1442,'幸福之路苏木',4,'',0,1,0,0),(8937,1442,'朝阳乡',4,'',0,1,0,0),(8938,1442,'查干沐沦苏木',4,'',0,1,0,0),(8939,1442,'查干诺尔苏木',4,'',0,1,0,0),(8940,1442,'沙巴尔台苏木',4,'',0,1,0,0),(8941,1442,'益和诺尔苏木',4,'',0,1,0,0),(8942,1442,'索博日嘎苏木',4,'',0,1,0,0),(8943,1442,'羊场乡',4,'',0,1,0,0),(8944,1442,'胡日哈苏木',4,'',0,1,0,0),(8945,1442,'西拉沐沦苏木',4,'',0,1,0,0),(8946,1443,'三山乡',4,'',0,1,0,0),(8947,1443,'丰水山镇',4,'',0,1,0,0),(8948,1443,'乌兰达坝苏木',4,'',0,1,0,0),(8949,1443,'十三敖包乡',4,'',0,1,0,0),(8950,1443,'哈拉哈达乡',4,'',0,1,0,0),(8951,1443,'哈达英格乡',4,'',0,1,0,0),(8952,1443,'杨家营子镇',4,'',0,1,0,0),(8953,1443,'林东镇',4,'',0,1,0,0),(8954,1443,'查干哈达苏木',4,'',0,1,0,0),(8955,1443,'毛宝力格乡',4,'',0,1,0,0),(8956,1443,'浩尔吐乡',4,'',0,1,0,0),(8957,1443,'白音勿拉苏木',4,'',0,1,0,0),(8958,1443,'白音敖包乡',4,'',0,1,0,0),(8959,1443,'白音沟乡',4,'',0,1,0,0),(8960,1443,'白音诺尔镇',4,'',0,1,0,0),(8961,1443,'碧流台镇',4,'',0,1,0,0),(8962,1443,'花加拉嘎乡',4,'',0,1,0,0),(8963,1443,'野猪沟乡',4,'',0,1,0,0),(8964,1443,'隆昌镇',4,'',0,1,0,0),(8965,1444,'下洼镇',4,'',0,1,0,0),(8966,1444,'丰收乡',4,'',0,1,0,0),(8967,1444,'克力代乡',4,'',0,1,0,0),(8968,1444,'南塔乡',4,'',0,1,0,0),(8969,1444,'双井乡',4,'',0,1,0,0),(8970,1444,'古鲁板蒿乡',4,'',0,1,0,0),(8971,1444,'哈沙吐乡',4,'',0,1,0,0),(8972,1444,'四家子镇',4,'',0,1,0,0),(8973,1444,'四德堂乡',4,'',0,1,0,0),(8974,1444,'四道湾子镇',4,'',0,1,0,0),(8975,1444,'大甸子乡',4,'',0,1,0,0),(8976,1444,'宝国吐乡',4,'',0,1,0,0),(8977,1444,'康家营子乡',4,'',0,1,0,0),(8978,1444,'敖吉乡',4,'',0,1,0,0),(8979,1444,'敖润苏莫苏木',4,'',0,1,0,0),(8980,1444,'敖音勿苏乡',4,'',0,1,0,0),(8981,1444,'新地乡',4,'',0,1,0,0),(8982,1444,'新惠镇',4,'',0,1,0,0),(8983,1444,'新窝铺乡',4,'',0,1,0,0),(8984,1444,'木头营子乡',4,'',0,1,0,0),(8985,1444,'林家地乡',4,'',0,1,0,0),(8986,1444,'牛古吐乡',4,'',0,1,0,0),(8987,1444,'王家营子乡',4,'',0,1,0,0),(8988,1444,'玛尼罕乡',4,'',0,1,0,0),(8989,1444,'萨力巴乡',4,'',0,1,0,0),(8990,1444,'贝子府镇',4,'',0,1,0,0),(8991,1444,'金厂沟梁镇',4,'',0,1,0,0),(8992,1444,'长胜镇',4,'',0,1,0,0),(8993,1444,'高家窝铺乡',4,'',0,1,0,0),(8994,1445,'上官地镇',4,'',0,1,0,0),(8995,1445,'东山乡',4,'',0,1,0,0),(8996,1445,'五三镇',4,'',0,1,0,0),(8997,1445,'关家营满族乡',4,'',0,1,0,0),(8998,1445,'初头朗镇',4,'',0,1,0,0),(8999,1445,'向阳街道',4,'',0,1,0,0),(9000,1445,'哈拉道口镇',4,'',0,1,0,0),(9001,1445,'城子乡',4,'',0,1,0,0),(9002,1445,'大六份乡',4,'',0,1,0,0),(9003,1445,'大夫营子乡',4,'',0,1,0,0),(9004,1445,'大庙镇',4,'',0,1,0,0),(9005,1445,'大碾子乡',4,'',0,1,0,0),(9006,1445,'太平地乡',4,'',0,1,0,0),(9007,1445,'姜家营子乡',4,'',0,1,0,0),(9008,1445,'孤山子乡',4,'',0,1,0,0),(9009,1445,'安庆镇',4,'',0,1,0,0),(9010,1445,'岗子乡',4,'',0,1,0,0),(9011,1445,'当铺地镇',4,'',0,1,0,0),(9012,1445,'忙牛营乡',4,'',0,1,0,0),(9013,1445,'振兴街道',4,'',0,1,0,0),(9014,1445,'木头沟乡',4,'',0,1,0,0),(9015,1445,'松州街道',4,'',0,1,0,0),(9016,1445,'水地乡',4,'',0,1,0,0),(9017,1445,'河南营子乡',4,'',0,1,0,0),(9018,1445,'猴头沟乡',4,'',0,1,0,0),(9019,1445,'王家店乡',4,'',0,1,0,0),(9020,1445,'王府乡',4,'',0,1,0,0),(9021,1445,'碾坊乡',4,'',0,1,0,0),(9022,1445,'穆家营子镇',4,'',0,1,0,0),(9023,1445,'红花沟镇',4,'',0,1,0,0),(9024,1445,'老府镇',4,'',0,1,0,0),(9025,1445,'铁东街道',4,'',0,1,0,0),(9026,1446,'下场乡',4,'',0,1,0,0),(9027,1446,'五十家子镇',4,'',0,1,0,0),(9028,1446,'兴隆庄乡',4,'',0,1,0,0),(9029,1446,'十二吐乡',4,'',0,1,0,0),(9030,1446,'双井店乡',4,'',0,1,0,0),(9031,1446,'大井镇',4,'',0,1,0,0),(9032,1446,'大川乡',4,'',0,1,0,0),(9033,1446,'大营子乡',4,'',0,1,0,0),(9034,1446,'官地镇',4,'',0,1,0,0),(9035,1446,'新城子镇',4,'',0,1,0,0),(9036,1446,'新林镇',4,'',0,1,0,0),(9037,1446,'板石房子乡',4,'',0,1,0,0),(9038,1446,'林西镇',4,'',0,1,0,0),(9039,1446,'统部镇',4,'',0,1,0,0),(9040,1446,'老房身乡',4,'',0,1,0,0),(9041,1446,'隆平乡',4,'',0,1,0,0),(9042,1447,'三中街街道',4,'',0,1,0,0),(9043,1447,'东城街道',4,'',0,1,0,0),(9044,1447,'南新街街道',4,'',0,1,0,0),(9045,1447,'哈达街道',4,'',0,1,0,0),(9046,1447,'城郊乡',4,'',0,1,0,0),(9047,1447,'文钟镇',4,'',0,1,0,0),(9048,1447,'桥北镇',4,'',0,1,0,0),(9049,1447,'永巨街道',4,'',0,1,0,0),(9050,1447,'站前街道',4,'',0,1,0,0),(9051,1447,'红庙子镇',4,'',0,1,0,0),(9052,1447,'西屯街道',4,'',0,1,0,0),(9053,1447,'铁南街道',4,'',0,1,0,0),(9054,1447,'长青街道',4,'',0,1,0,0),(9055,1448,'乌丹镇',4,'',0,1,0,0),(9056,1448,'乌敦套海镇',4,'',0,1,0,0),(9057,1448,'五分地镇',4,'',0,1,0,0),(9058,1448,'亿合公乡',4,'',0,1,0,0),(9059,1448,'大兴乡',4,'',0,1,0,0),(9060,1448,'头分地镇',4,'',0,1,0,0),(9061,1448,'头段地乡',4,'',0,1,0,0),(9062,1448,'山嘴子乡',4,'',0,1,0,0),(9063,1448,'巴嘎塔拉苏木',4,'',0,1,0,0),(9064,1448,'布力彦苏木',4,'',0,1,0,0),(9065,1448,'广德公镇',4,'',0,1,0,0),(9066,1448,'庄头营子乡',4,'',0,1,0,0),(9067,1448,'新苏莫苏木',4,'',0,1,0,0),(9068,1448,'朝格温都苏木',4,'',0,1,0,0),(9069,1448,'杜家地乡',4,'',0,1,0,0),(9070,1448,'杨树沟门乡',4,'',0,1,0,0),(9071,1448,'格日僧苏木',4,'',0,1,0,0),(9072,1448,'桥头镇',4,'',0,1,0,0),(9073,1448,'梧桐花镇',4,'',0,1,0,0),(9074,1448,'毛山东乡',4,'',0,1,0,0),(9075,1448,'海拉苏镇',4,'',0,1,0,0),(9076,1448,'玉田皋乡',4,'',0,1,0,0),(9077,1448,'白音套海苏木',4,'',0,1,0,0),(9078,1448,'解放营乡',4,'',0,1,0,0),(9079,1448,'阿什罕苏木',4,'',0,1,0,0),(9080,1448,'高家梁乡',4,'',0,1,0,0),(9081,1448,'高日罕苏木',4,'',0,1,0,0),(9082,1449,'东沙布台乡委会',4,'',0,1,0,0),(9083,1449,'乌兰哈达乡',4,'',0,1,0,0),(9084,1449,'先峰乡',4,'',0,1,0,0),(9085,1449,'双胜镇',4,'',0,1,0,0),(9086,1449,'坤都镇',4,'',0,1,0,0),(9087,1449,'天山口镇',4,'',0,1,0,0),(9088,1449,'天山镇',4,'',0,1,0,0),(9089,1449,'岗台乡',4,'',0,1,0,0),(9090,1449,'巴彦包勒格苏木',4,'',0,1,0,0),(9091,1449,'巴彦包特乡',4,'',0,1,0,0),(9092,1449,'巴彦温都尔苏木',4,'',0,1,0,0),(9093,1449,'巴彦花镇',4,'',0,1,0,0),(9094,1449,'巴彦诺尔苏木',4,'',0,1,0,0),(9095,1449,'巴拉奇如德苏木',4,'',0,1,0,0),(9096,1449,'扎嘎斯台镇',4,'',0,1,0,0),(9097,1449,'新民乡',4,'',0,1,0,0),(9098,1449,'柴达木苏木',4,'',0,1,0,0),(9099,1449,'白城子乡',4,'',0,1,0,0),(9100,1449,'绍根镇',4,'',0,1,0,0),(9101,1449,'罕苏木苏木',4,'',0,1,0,0),(9102,1449,'荞麦塔拉乡',4,'',0,1,0,0),(9103,1449,'赛汉塔拉苏木',4,'',0,1,0,0),(9104,1449,'道德镇',4,'',0,1,0,0),(9105,1450,'东明镇',4,'',0,1,0,0),(9106,1450,'义隆永镇',4,'',0,1,0,0),(9107,1450,'八仙筒镇',4,'',0,1,0,0),(9108,1450,'固日班花苏木',4,'',0,1,0,0),(9109,1450,'国有六号农场',4,'',0,1,0,0),(9110,1450,'土城子镇',4,'',0,1,0,0),(9111,1450,'大沁他拉镇',4,'',0,1,0,0),(9112,1450,'奈林苏木',4,'',0,1,0,0),(9113,1450,'巴嘎波日和苏木',4,'',0,1,0,0),(9114,1450,'平安镇',4,'',0,1,0,0),(9115,1450,'得胜镇',4,'',0,1,0,0),(9116,1450,'新镇',4,'',0,1,0,0),(9117,1450,'明仁苏木',4,'',0,1,0,0),(9118,1450,'沙日浩来镇',4,'',0,1,0,0),(9119,1450,'治安镇',4,'',0,1,0,0),(9120,1450,'清河苏木',4,'',0,1,0,0),(9121,1450,'白音他拉镇',4,'',0,1,0,0),(9122,1450,'白音昌乡',4,'',0,1,0,0),(9123,1450,'章古台苏木',4,'',0,1,0,0),(9124,1450,'苇莲苏乡',4,'',0,1,0,0),(9125,1450,'青龙山镇',4,'',0,1,0,0),(9126,1450,'黄花塔拉镇',4,'',0,1,0,0),(9127,1451,'三家子镇',4,'',0,1,0,0),(9128,1451,'先进苏木',4,'',0,1,0,0),(9129,1451,'六家子镇',4,'',0,1,0,0),(9130,1451,'哈尔稿苏木',4,'',0,1,0,0),(9131,1451,'库伦镇',4,'',0,1,0,0),(9132,1451,'扣河子镇',4,'',0,1,0,0),(9133,1451,'水泉镇',4,'',0,1,0,0),(9134,1451,'白音花苏木',4,'',0,1,0,0),(9135,1451,'茫汗苏木',4,'',0,1,0,0),(9136,1451,'额勒顺镇',4,'',0,1,0,0),(9137,1452,'三棵树乡',4,'',0,1,0,0),(9138,1452,'东来镇',4,'',0,1,0,0),(9139,1452,'东风镇',4,'',0,1,0,0),(9140,1452,'义和塔拉苏木',4,'',0,1,0,0),(9141,1452,'保安镇',4,'',0,1,0,0),(9142,1452,'兴安乡',4,'',0,1,0,0),(9143,1452,'北兴镇',4,'',0,1,0,0),(9144,1452,'北清河乡',4,'',0,1,0,0),(9145,1452,'双河镇',4,'',0,1,0,0),(9146,1452,'吉日嘎郎吐镇',4,'',0,1,0,0),(9147,1452,'和平镇',4,'',0,1,0,0),(9148,1452,'坤都岭镇',4,'',0,1,0,0),(9149,1452,'大榆树镇',4,'',0,1,0,0),(9150,1452,'小街基镇',4,'',0,1,0,0),(9151,1452,'建华镇',4,'',0,1,0,0),(9152,1452,'开鲁镇',4,'',0,1,0,0),(9153,1452,'新华镇',4,'',0,1,0,0),(9154,1452,'清河牧场',4,'',0,1,0,0),(9155,1452,'道德镇',4,'',0,1,0,0),(9156,1452,'麦新镇',4,'',0,1,0,0),(9157,1452,'黑龙坝镇',4,'',0,1,0,0),(9158,1453,'乌兰哈达苏木',4,'',0,1,0,0),(9159,1453,'乌力吉木仁苏木',4,'',0,1,0,0),(9160,1453,'乌额格其苏木',4,'',0,1,0,0),(9161,1453,'前德门苏木',4,'',0,1,0,0),(9162,1453,'嘎亥图镇',4,'',0,1,0,0),(9163,1453,'嘎达苏种畜场',4,'',0,1,0,0),(9164,1453,'太平山乡',4,'',0,1,0,0),(9165,1453,'巨日合镇',4,'',0,1,0,0),(9166,1453,'巴彦塔拉苏木',4,'',0,1,0,0),(9167,1453,'巴彦芒哈苏木',4,'',0,1,0,0),(9168,1453,'巴雅尔吐胡硕镇',4,'',0,1,0,0),(9169,1453,'查布嘎图苏木',4,'',0,1,0,0),(9170,1453,'格日朝鲁苏木',4,'',0,1,0,0),(9171,1453,'毛都苏木',4,'',0,1,0,0),(9172,1453,'罕山镇',4,'',0,1,0,0),(9173,1453,'联合屯镇',4,'',0,1,0,0),(9174,1453,'道老杜苏木',4,'',0,1,0,0),(9175,1453,'阿日昆都冷苏木',4,'',0,1,0,0),(9176,1453,'香山镇',4,'',0,1,0,0),(9177,1453,'鲁北镇',4,'',0,1,0,0),(9178,1453,'黄花山镇',4,'',0,1,0,0),(9179,1454,'三义堂农场',4,'',0,1,0,0),(9180,1454,'东郊街道',4,'',0,1,0,0),(9181,1454,'丰田镇',4,'',0,1,0,0),(9182,1454,'余粮堡镇',4,'',0,1,0,0),(9183,1454,'哲南农场',4,'',0,1,0,0),(9184,1454,'大林镇',4,'',0,1,0,0),(9185,1454,'大罕镇',4,'',0,1,0,0),(9186,1454,'孔家窝堡镇',4,'',0,1,0,0),(9187,1454,'庆和镇',4,'',0,1,0,0),(9188,1454,'建国镇',4,'',0,1,0,0),(9189,1454,'敖力布皋镇',4,'',0,1,0,0),(9190,1454,'施介街道',4,'',0,1,0,0),(9191,1454,'明仁街道',4,'',0,1,0,0),(9192,1454,'木里图镇',4,'',0,1,0,0),(9193,1454,'民主镇',4,'',0,1,0,0),(9194,1454,'永清街道',4,'',0,1,0,0),(9195,1454,'河西镇',4,'',0,1,0,0),(9196,1454,'清河镇',4,'',0,1,0,0),(9197,1454,'清真街道',4,'',0,1,0,0),(9198,1454,'电厂街道',4,'',0,1,0,0),(9199,1454,'科尔沁街道',4,'',0,1,0,0),(9200,1454,'红星镇',4,'',0,1,0,0),(9201,1454,'育新镇',4,'',0,1,0,0),(9202,1454,'胡力海镇',4,'',0,1,0,0),(9203,1454,'莫力庙苏木',4,'',0,1,0,0),(9204,1454,'西六方镇',4,'',0,1,0,0),(9205,1454,'西门街道',4,'',0,1,0,0),(9206,1454,'角干镇',4,'',0,1,0,0),(9207,1454,'辽河镇',4,'',0,1,0,0),(9208,1454,'钱家店镇',4,'',0,1,0,0),(9209,1454,'铁南街道',4,'',0,1,0,0),(9210,1454,'霍林街道',4,'',0,1,0,0),(9211,1454,'高林屯种畜场',4,'',0,1,0,0),(9212,1455,'七棵树乡',4,'',0,1,0,0),(9213,1455,'东苏林场',4,'',0,1,0,0),(9214,1455,'乌斯吐苏木',4,'',0,1,0,0),(9215,1455,'代力吉镇',4,'',0,1,0,0),(9216,1455,'保康镇',4,'',0,1,0,0),(9217,1455,'努日木镇',4,'',0,1,0,0),(9218,1455,'协代苏木',4,'',0,1,0,0),(9219,1455,'哈日干吐苏木',4,'',0,1,0,0),(9220,1455,'团结乡',4,'',0,1,0,0),(9221,1455,'图布信苏木',4,'',0,1,0,0),(9222,1455,'宝龙山镇',4,'',0,1,0,0),(9223,1455,'巴彦召苏木',4,'',0,1,0,0),(9224,1455,'巴彦塔拉镇',4,'',0,1,0,0),(9225,1455,'巴彦苏木',4,'',0,1,0,0),(9226,1455,'希伯花镇',4,'',0,1,0,0),(9227,1455,'敖包苏木',4,'',0,1,0,0),(9228,1455,'敖本台苏木',4,'',0,1,0,0),(9229,1455,'新河乡',4,'',0,1,0,0),(9230,1455,'架玛吐镇',4,'',0,1,0,0),(9231,1455,'海力锦苏木',4,'',0,1,0,0),(9232,1455,'珠日河镇',4,'',0,1,0,0),(9233,1455,'白兴吐苏木',4,'',0,1,0,0),(9234,1455,'胜利乡',4,'',0,1,0,0),(9235,1455,'腰林毛都镇',4,'',0,1,0,0),(9236,1455,'舍伯吐镇',4,'',0,1,0,0),(9237,1455,'花吐古拉镇',4,'',0,1,0,0),(9238,1455,'花胡硕苏木',4,'',0,1,0,0),(9239,1455,'门达镇',4,'',0,1,0,0),(9240,1455,'额伦索克苏木',4,'',0,1,0,0),(9241,1456,'乌兰敖道苏木',4,'',0,1,0,0),(9242,1456,'伊胡塔镇',4,'',0,1,0,0),(9243,1456,'公河来苏木',4,'',0,1,0,0),(9244,1456,'努古斯台镇',4,'',0,1,0,0),(9245,1456,'双胜乡',4,'',0,1,0,0),(9246,1456,'吉尔嘎朗镇',4,'',0,1,0,0),(9247,1456,'向阳乡',4,'',0,1,0,0),(9248,1456,'巴嘎塔拉苏木',4,'',0,1,0,0),(9249,1456,'巴彦毛都苏木',4,'',0,1,0,0),(9250,1456,'巴雅斯古楞苏木',4,'',0,1,0,0),(9251,1456,'常胜镇',4,'',0,1,0,0),(9252,1456,'散都镇',4,'',0,1,0,0),(9253,1456,'朝鲁吐镇',4,'',0,1,0,0),(9254,1456,'查日苏镇',4,'',0,1,0,0),(9255,1456,'浩坦苏木',4,'',0,1,0,0),(9256,1456,'海斯改苏木',4,'',0,1,0,0),(9257,1456,'海鲁吐镇',4,'',0,1,0,0),(9258,1456,'甘旗卡镇',4,'',0,1,0,0),(9259,1456,'胜利镇',4,'',0,1,0,0),(9260,1456,'茂道吐苏木',4,'',0,1,0,0),(9261,1456,'金宝屯镇',4,'',0,1,0,0),(9262,1456,'阿古拉镇',4,'',0,1,0,0),(9263,1456,'阿都沁苏木',4,'',0,1,0,0),(9264,1456,'额莫勒苏木',4,'',0,1,0,0),(9265,1457,'宝日呼吉尔街道',4,'',0,1,0,0),(9266,1457,'沙尔呼热镇',4,'',0,1,0,0),(9267,1457,'珠斯花街道',4,'',0,1,0,0),(9268,1457,'莫斯台街道',4,'',0,1,0,0),(9269,1457,'达莱胡硕苏木',4,'',0,1,0,0),(9270,1458,'万利镇',4,'',0,1,0,0),(9271,1458,'交通街街道',4,'',0,1,0,0),(9272,1458,'公园路街道',4,'',0,1,0,0),(9273,1458,'哈巴格希乡',4,'',0,1,0,0),(9274,1458,'天骄路街道',4,'',0,1,0,0),(9275,1458,'富兴路街道',4,'',0,1,0,0),(9276,1458,'布日都镇',4,'',0,1,0,0),(9277,1458,'建设街街道',4,'',0,1,0,0),(9278,1458,'林荫路街道',4,'',0,1,0,0),(9279,1458,'柴登镇',4,'',0,1,0,0),(9280,1458,'罕台镇',4,'',0,1,0,0),(9281,1458,'铜川镇',4,'',0,1,0,0),(9282,1459,'乌兰沙巴尔台乡',4,'',0,1,0,0),(9283,1459,'乌兰陶勒盖镇',4,'',0,1,0,0),(9284,1459,'乌审召镇',4,'',0,1,0,0),(9285,1459,'呼吉尔特乡',4,'',0,1,0,0),(9286,1459,'嘎鲁图苏木',4,'',0,1,0,0),(9287,1459,'图克镇',4,'',0,1,0,0),(9288,1459,'沙尔利格镇',4,'',0,1,0,0),(9289,1459,'河南乡',4,'',0,1,0,0),(9290,1459,'浩勒报吉乡',4,'',0,1,0,0),(9291,1459,'纳林河镇',4,'',0,1,0,0),(9292,1459,'达布察克镇',4,'',0,1,0,0),(9293,1459,'陶利镇',4,'',0,1,0,0),(9294,1459,'黄陶勒盖乡',4,'',0,1,0,0),(9295,1460,'乌兰木伦镇',4,'',0,1,0,0),(9296,1460,'伊金霍洛镇',4,'',0,1,0,0),(9297,1460,'红庆河镇',4,'',0,1,0,0),(9298,1460,'纳林陶亥镇',4,'',0,1,0,0),(9299,1460,'苏布尔嘎镇',4,'',0,1,0,0),(9300,1460,'设札萨克镇',4,'',0,1,0,0),(9301,1460,'阿勒腾席热镇',4,'',0,1,0,0),(9302,1461,'准格尔召镇',4,'',0,1,0,0),(9303,1461,'大路镇',4,'',0,1,0,0),(9304,1461,'布尔陶亥苏木',4,'',0,1,0,0),(9305,1461,'暖水镇',4,'',0,1,0,0),(9306,1461,'柴达木镇',4,'',0,1,0,0),(9307,1461,'沙圪堵镇',4,'',0,1,0,0),(9308,1461,'纳日松镇',4,'',0,1,0,0),(9309,1461,'薛家湾镇',4,'',0,1,0,0),(9310,1461,'龙口镇',4,'',0,1,0,0),(9311,1462,'伊和乌素镇',4,'',0,1,0,0),(9312,1462,'吉日嘎朗图镇',4,'',0,1,0,0),(9313,1462,'呼和木独镇',4,'',0,1,0,0),(9314,1462,'四十里梁镇',4,'',0,1,0,0),(9315,1462,'塔然高勒乡',4,'',0,1,0,0),(9316,1462,'巴拉贡镇',4,'',0,1,0,0),(9317,1462,'巴音乌素镇',4,'',0,1,0,0),(9318,1462,'杭锦淖尔乡',4,'',0,1,0,0),(9319,1462,'浩绕柴达木苏木',4,'',0,1,0,0),(9320,1462,'独贵特拉镇',4,'',0,1,0,0),(9321,1462,'锡尼镇',4,'',0,1,0,0),(9322,1462,'阿门其日格乡',4,'',0,1,0,0),(9323,1463,'中和西镇',4,'',0,1,0,0),(9324,1463,'乌兰乡',4,'',0,1,0,0),(9325,1463,'吉格斯太镇',4,'',0,1,0,0),(9326,1463,'大树湾镇',4,'',0,1,0,0),(9327,1463,'展旦召苏木',4,'',0,1,0,0),(9328,1463,'德胜泰乡',4,'',0,1,0,0),(9329,1463,'敖包梁乡',4,'',0,1,0,0),(9330,1463,'昭君坟乡',4,'',0,1,0,0),(9331,1463,'树林召乡',4,'',0,1,0,0),(9332,1463,'树林召镇',4,'',0,1,0,0),(9333,1463,'榆林子乡',4,'',0,1,0,0),(9334,1463,'王爱召镇',4,'',0,1,0,0),(9335,1463,'白泥井镇',4,'',0,1,0,0),(9336,1463,'盐店乡',4,'',0,1,0,0),(9337,1463,'耳字壕镇',4,'',0,1,0,0),(9338,1463,'蓿亥图乡',4,'',0,1,0,0),(9339,1463,'解放滩镇',4,'',0,1,0,0),(9340,1463,'青达门乡',4,'',0,1,0,0),(9341,1463,'马场壕乡',4,'',0,1,0,0),(9342,1463,'高头窑镇',4,'',0,1,0,0),(9343,1464,'泊尔江海子镇',4,'',0,1,0,0),(9344,1465,'三段地镇',4,'',0,1,0,0),(9345,1465,'上海庙牧场',4,'',0,1,0,0),(9346,1465,'上海庙镇',4,'',0,1,0,0),(9347,1465,'二道川乡',4,'',0,1,0,0),(9348,1465,'城川镇',4,'',0,1,0,0),(9349,1465,'布拉格苏木',4,'',0,1,0,0),(9350,1465,'敖勒召其镇',4,'',0,1,0,0),(9351,1465,'昂素镇',4,'',0,1,0,0),(9352,1465,'毛盖图苏木',4,'',0,1,0,0),(9353,1465,'珠和苏木',4,'',0,1,0,0),(9354,1466,'乌兰镇',4,'',0,1,0,0),(9355,1466,'公其日嘎乡',4,'',0,1,0,0),(9356,1466,'包乐浩晓镇',4,'',0,1,0,0),(9357,1466,'察汗淖尔镇',4,'',0,1,0,0),(9358,1466,'新召苏木',4,'',0,1,0,0),(9359,1466,'木凯淖尔乡',4,'',0,1,0,0),(9360,1466,'查布苏木',4,'',0,1,0,0),(9361,1466,'棋盘井镇',4,'',0,1,0,0),(9362,1466,'沙井镇',4,'',0,1,0,0),(9363,1466,'碱柜镇',4,'',0,1,0,0),(9364,1466,'苏米图苏木',4,'',0,1,0,0),(9365,1466,'阿尔巴斯苏木',4,'',0,1,0,0),(9366,1467,'兴华街道',4,'',0,1,0,0),(9367,1467,'卧牛河镇',4,'',0,1,0,0),(9368,1467,'向阳街道',4,'',0,1,0,0),(9369,1467,'大河湾镇',4,'',0,1,0,0),(9370,1467,'成吉思汗镇',4,'',0,1,0,0),(9371,1467,'正阳街道',4,'',0,1,0,0),(9372,1467,'河西街道',4,'',0,1,0,0),(9373,1467,'洼堤镇',4,'',0,1,0,0),(9374,1467,'浩饶山镇',4,'',0,1,0,0),(9375,1467,'磨菇气镇',4,'',0,1,0,0),(9376,1467,'繁荣街道',4,'',0,1,0,0),(9377,1467,'萨马街鄂温克民族乡',4,'',0,1,0,0),(9378,1467,'达斡尔民族乡',4,'',0,1,0,0),(9379,1467,'鄂伦春民族乡',4,'',0,1,0,0),(9380,1467,'铁东街道',4,'',0,1,0,0),(9381,1467,'高台子街道',4,'',0,1,0,0),(9382,1468,'克尔伦苏木',4,'',0,1,0,0),(9383,1468,'呼伦苏木',4,'',0,1,0,0),(9384,1468,'宝格德乌拉苏木',4,'',0,1,0,0),(9385,1468,'杭乌拉苏木',4,'',0,1,0,0),(9386,1468,'贝尔苏木',4,'',0,1,0,0),(9387,1468,'赛汉塔拉苏木',4,'',0,1,0,0),(9388,1468,'达来东苏木',4,'',0,1,0,0),(9389,1468,'达来苏木',4,'',0,1,0,0),(9390,1468,'阿拉坦额莫勒镇',4,'',0,1,0,0),(9391,1468,'阿敦础鲁苏木',4,'',0,1,0,0),(9392,1469,'乌布尔宝力格苏木',4,'',0,1,0,0),(9393,1469,'吉布胡郎图苏木',4,'',0,1,0,0),(9394,1469,'嵯岗镇',4,'',0,1,0,0),(9395,1469,'巴音诺尔苏木',4,'',0,1,0,0),(9396,1469,'甘珠尔苏木',4,'',0,1,0,0),(9397,1469,'罕达盖苏木',4,'',0,1,0,0),(9398,1469,'莫达木吉苏木',4,'',0,1,0,0),(9399,1469,'阿木古郎镇',4,'',0,1,0,0),(9400,1470,'敖鲁古雅鄂温克族乡',4,'',0,1,0,0),(9401,1470,'森工路街道',4,'',0,1,0,0),(9402,1470,'河东街道',4,'',0,1,0,0),(9403,1470,'河西街道',4,'',0,1,0,0),(9404,1470,'满归镇',4,'',0,1,0,0),(9405,1470,'金河镇',4,'',0,1,0,0),(9406,1470,'阿龙山镇',4,'',0,1,0,0),(9407,1471,'健康街道',4,'',0,1,0,0),(9408,1471,'向华街道',4,'',0,1,0,0),(9409,1471,'呼伦街道',4,'',0,1,0,0),(9410,1471,'哈克镇',4,'',0,1,0,0),(9411,1471,'奋斗街道',4,'',0,1,0,0),(9412,1471,'正阳街道',4,'',0,1,0,0),(9413,1471,'胜利街道',4,'',0,1,0,0),(9414,1471,'靠山街道',4,'',0,1,0,0),(9415,1472,'东山街道',4,'',0,1,0,0),(9416,1472,'兴华街道',4,'',0,1,0,0),(9417,1472,'扎赉诺尔矿区灵泉街道',4,'',0,1,0,0),(9418,1472,'扎赉诺尔矿区第一街道',4,'',0,1,0,0),(9419,1472,'扎赉诺尔矿区第三街道',4,'',0,1,0,0),(9420,1472,'扎赉诺尔矿区第二街道',4,'',0,1,0,0),(9421,1472,'扎赉诺尔矿区第五街道',4,'',0,1,0,0),(9422,1472,'扎赉诺尔矿区第四街道',4,'',0,1,0,0),(9423,1472,'新开河镇',4,'',0,1,0,0),(9424,1472,'道北街道',4,'',0,1,0,0),(9425,1472,'道南街道',4,'',0,1,0,0),(9426,1473,'乌奴耳镇',4,'',0,1,0,0),(9427,1473,'乌尔其汉镇',4,'',0,1,0,0),(9428,1473,'伊图里河镇',4,'',0,1,0,0),(9429,1473,'免渡河镇',4,'',0,1,0,0),(9430,1473,'博克图镇',4,'',0,1,0,0),(9431,1473,'图里河镇',4,'',0,1,0,0),(9432,1473,'塔尔气镇',4,'',0,1,0,0),(9433,1473,'巴林镇',4,'',0,1,0,0),(9434,1473,'库都尔镇',4,'',0,1,0,0),(9435,1473,'建设街道',4,'',0,1,0,0),(9436,1473,'新工街道',4,'',0,1,0,0),(9437,1473,'暖泉街道',4,'',0,1,0,0),(9438,1473,'永兴街道',4,'',0,1,0,0),(9439,1473,'煤田镇',4,'',0,1,0,0),(9440,1473,'牧原镇',4,'',0,1,0,0),(9441,1473,'红旗街道',4,'',0,1,0,0),(9442,1473,'绰源镇',4,'',0,1,0,0),(9443,1473,'胜利街道',4,'',0,1,0,0),(9444,1474,'哈达阳镇',4,'',0,1,0,0),(9445,1474,'塔温敖宝镇',4,'',0,1,0,0),(9446,1474,'宝山镇',4,'',0,1,0,0),(9447,1474,'尼尔基镇',4,'',0,1,0,0),(9448,1474,'巴彦鄂温克民族乡',4,'',0,1,0,0),(9449,1474,'杜拉尔鄂温克民族乡',4,'',0,1,0,0),(9450,1474,'红彦镇',4,'',0,1,0,0),(9451,1474,'腾克镇',4,'',0,1,0,0),(9452,1474,'西瓦尔图镇',4,'',0,1,0,0),(9453,1474,'阿尔拉镇',4,'',0,1,0,0),(9454,1475,'乌鲁布铁镇',4,'',0,1,0,0),(9455,1475,'古里乡',4,'',0,1,0,0),(9456,1475,'大杨树镇',4,'',0,1,0,0),(9457,1475,'托扎敏镇',4,'',0,1,0,0),(9458,1475,'甘河镇',4,'',0,1,0,0),(9459,1475,'诺敏镇',4,'',0,1,0,0),(9460,1475,'阿里河镇',4,'',0,1,0,0),(9461,1476,'伊敏河镇',4,'',0,1,0,0),(9462,1476,'伊敏苏木',4,'',0,1,0,0),(9463,1476,'大雁矿区',4,'',0,1,0,0),(9464,1476,'巴彦塔拉达斡尔族乡',4,'',0,1,0,0),(9465,1476,'巴彦嵯岗苏木',4,'',0,1,0,0),(9466,1476,'巴彦托海镇',4,'',0,1,0,0),(9467,1476,'红花尔基镇',4,'',0,1,0,0),(9468,1476,'辉苏木',4,'',0,1,0,0),(9469,1476,'锡尼河准苏木',4,'',0,1,0,0),(9470,1476,'锡尼河巴润苏木',4,'',0,1,0,0),(9471,1477,'亚东镇',4,'',0,1,0,0),(9472,1477,'六合镇',4,'',0,1,0,0),(9473,1477,'向阳峪镇',4,'',0,1,0,0),(9474,1477,'得力其尔鄂温克族乡',4,'',0,1,0,0),(9475,1477,'新发朝鲜族乡',4,'',0,1,0,0),(9476,1477,'查巴奇鄂温克族乡',4,'',0,1,0,0),(9477,1477,'那吉镇',4,'',0,1,0,0),(9478,1477,'霍尔奇镇',4,'',0,1,0,0),(9479,1477,'音河达斡尔鄂温克族乡',4,'',0,1,0,0),(9480,1478,'东乌珠尔苏木',4,'',0,1,0,0),(9481,1478,'完工镇',4,'',0,1,0,0),(9482,1478,'宝日希勒镇',4,'',0,1,0,0),(9483,1478,'巴彦哈达苏木',4,'',0,1,0,0),(9484,1478,'巴彦库仁镇',4,'',0,1,0,0),(9485,1478,'特泥河苏木',4,'',0,1,0,0),(9486,1478,'西乌珠尔苏木',4,'',0,1,0,0),(9487,1478,'鄂温克民族苏木',4,'',0,1,0,0),(9488,1479,'三河回族乡',4,'',0,1,0,0),(9489,1479,'上库力乡',4,'',0,1,0,0),(9490,1479,'室韦俄罗斯族民族乡',4,'',0,1,0,0),(9491,1479,'新城街道',4,'',0,1,0,0),(9492,1479,'莫尔道嘎镇',4,'',0,1,0,0),(9493,1479,'黑山头镇',4,'',0,1,0,0),(9494,1480,'东环街道',4,'',0,1,0,0),(9495,1480,'丹达木头乡',4,'',0,1,0,0),(9496,1480,'乌兰图克镇',4,'',0,1,0,0),(9497,1480,'乌兰淖尔乡',4,'',0,1,0,0),(9498,1480,'份子地镇',4,'',0,1,0,0),(9499,1480,'先锋街道',4,'',0,1,0,0),(9500,1480,'八一乡',4,'',0,1,0,0),(9501,1480,'八岱乡',4,'',0,1,0,0),(9502,1480,'北环街道',4,'',0,1,0,0),(9503,1480,'友谊乡',4,'',0,1,0,0),(9504,1480,'古城乡',4,'',0,1,0,0),(9505,1480,'团结街道',4,'',0,1,0,0),(9506,1480,'城关乡',4,'',0,1,0,0),(9507,1480,'小召镇',4,'',0,1,0,0),(9508,1480,'干召庙镇',4,'',0,1,0,0),(9509,1480,'建设乡',4,'',0,1,0,0),(9510,1480,'新丰乡',4,'',0,1,0,0),(9511,1480,'新华街道',4,'',0,1,0,0),(9512,1480,'新华镇',4,'',0,1,0,0),(9513,1480,'曙光乡',4,'',0,1,0,0),(9514,1480,'狼山镇',4,'',0,1,0,0),(9515,1480,'白脑包乡',4,'',0,1,0,0),(9516,1480,'西环街道',4,'',0,1,0,0),(9517,1480,'解放街道',4,'',0,1,0,0),(9518,1480,'车站街道',4,'',0,1,0,0),(9519,1480,'铁南街道',4,'',0,1,0,0),(9520,1480,'降胜镇',4,'',0,1,0,0),(9521,1480,'马场地镇',4,'',0,1,0,0),(9522,1480,'黄羊木头镇',4,'',0,1,0,0),(9523,1481,'乌兰苏木',4,'',0,1,0,0),(9524,1481,'乌加河镇',4,'',0,1,0,0),(9525,1481,'乌梁素太乡',4,'',0,1,0,0),(9526,1481,'同和太种畜场',4,'',0,1,0,0),(9527,1481,'呼鲁斯太苏木',4,'',0,1,0,0),(9528,1481,'宏丰乡',4,'',0,1,0,0),(9529,1481,'川井苏木',4,'',0,1,0,0),(9530,1481,'巴盟乌北林场',4,'',0,1,0,0),(9531,1481,'巴音哈太苏木',4,'',0,1,0,0),(9532,1481,'巴音杭盖苏木',4,'',0,1,0,0),(9533,1481,'巴音苏木',4,'',0,1,0,0),(9534,1481,'德岭山镇',4,'',0,1,0,0),(9535,1481,'新忽热苏木',4,'',0,1,0,0),(9536,1481,'桑根达来苏木',4,'',0,1,0,0),(9537,1481,'海流图镇',4,'',0,1,0,0),(9538,1481,'温更镇',4,'',0,1,0,0),(9539,1481,'牧羊海牧场',4,'',0,1,0,0),(9540,1481,'石兰计乡',4,'',0,1,0,0),(9541,1481,'石哈河镇',4,'',0,1,0,0),(9542,1482,'先锋乡',4,'',0,1,0,0),(9543,1482,'公庙子镇',4,'',0,1,0,0),(9544,1482,'北圪堵乡',4,'',0,1,0,0),(9545,1482,'呼和布拉格镇',4,'',0,1,0,0),(9546,1482,'大佘太镇',4,'',0,1,0,0),(9547,1482,'小佘太乡',4,'',0,1,0,0),(9548,1482,'巴彦淖尔市国营中滩农场',4,'',0,1,0,0),(9549,1482,'巴彦淖尔市国营乌梁素海渔场',4,'',0,1,0,0),(9550,1482,'巴彦淖尔市国营新安农场',4,'',0,1,0,0),(9551,1482,'巴彦淖尔市国营苏独仑农场',4,'',0,1,0,0),(9552,1482,'巴彦淖尔市国营西山咀农场',4,'',0,1,0,0),(9553,1482,'巴音花镇',4,'',0,1,0,0),(9554,1482,'新安镇',4,'',0,1,0,0),(9555,1482,'明安乡',4,'',0,1,0,0),(9556,1482,'朝阳镇',4,'',0,1,0,0),(9557,1482,'树林子乡',4,'',0,1,0,0),(9558,1482,'沙德格苏木',4,'',0,1,0,0),(9559,1482,'苏独仑乡',4,'',0,1,0,0),(9560,1482,'西小召镇',4,'',0,1,0,0),(9561,1482,'西山咀镇',4,'',0,1,0,0),(9562,1482,'长胜乡',4,'',0,1,0,0),(9563,1482,'额尔登布拉格苏木',4,'',0,1,0,0),(9564,1482,'黑柳子镇',4,'',0,1,0,0),(9565,1483,'乌力吉苏木',4,'',0,1,0,0),(9566,1483,'乌根高勒苏木',4,'',0,1,0,0),(9567,1483,'呼和温都尔镇',4,'',0,1,0,0),(9568,1483,'宝音图苏木',4,'',0,1,0,0),(9569,1483,'巴音前达门苏木',4,'',0,1,0,0),(9570,1483,'巴音宝力格镇',4,'',0,1,0,0),(9571,1483,'巴音戈壁苏木',4,'',0,1,0,0),(9572,1483,'巴音温都尔苏木',4,'',0,1,0,0),(9573,1483,'赛乌素镇',4,'',0,1,0,0),(9574,1483,'那仁宝力格苏木',4,'',0,1,0,0),(9575,1484,'什巴乡',4,'',0,1,0,0),(9576,1484,'向阳乡',4,'',0,1,0,0),(9577,1484,'和胜乡',4,'',0,1,0,0),(9578,1484,'国营建丰农场',4,'',0,1,0,0),(9579,1484,'城南乡',4,'',0,1,0,0),(9580,1484,'塔尔湖镇',4,'',0,1,0,0),(9581,1484,'复兴镇',4,'',0,1,0,0),(9582,1484,'天吉太镇',4,'',0,1,0,0),(9583,1484,'套海镇',4,'',0,1,0,0),(9584,1484,'新公中镇',4,'',0,1,0,0),(9585,1484,'海子堰乡',4,'',0,1,0,0),(9586,1484,'美林乡',4,'',0,1,0,0),(9587,1484,'胜丰镇',4,'',0,1,0,0),(9588,1484,'银定图乡',4,'',0,1,0,0),(9589,1484,'隆兴昌镇',4,'',0,1,0,0),(9590,1485,'三道桥镇',4,'',0,1,0,0),(9591,1485,'二道桥镇',4,'',0,1,0,0),(9592,1485,'南小召乡',4,'',0,1,0,0),(9593,1485,'南渠乡',4,'',0,1,0,0),(9594,1485,'召庙镇',4,'',0,1,0,0),(9595,1485,'四支乡',4,'',0,1,0,0),(9596,1485,'团结镇',4,'',0,1,0,0),(9597,1485,'太阳庙乡',4,'',0,1,0,0),(9598,1485,'头道桥镇',4,'',0,1,0,0),(9599,1485,'巴市太阳庙农场',4,'',0,1,0,0),(9600,1485,'查干敖包乡',4,'',0,1,0,0),(9601,1485,'沙海乡',4,'',0,1,0,0),(9602,1485,'红旗乡',4,'',0,1,0,0),(9603,1485,'红星乡',4,'',0,1,0,0),(9604,1485,'联合乡',4,'',0,1,0,0),(9605,1485,'蛮会镇',4,'',0,1,0,0),(9606,1485,'陕坝镇',4,'',0,1,0,0),(9607,1486,'乌兰布和农场',4,'',0,1,0,0),(9608,1486,'公地乡',4,'',0,1,0,0),(9609,1486,'协城镇',4,'',0,1,0,0),(9610,1486,'哈腾套海农场',4,'',0,1,0,0),(9611,1486,'哈腾套海苏木',4,'',0,1,0,0),(9612,1486,'巴彦套海农场',4,'',0,1,0,0),(9613,1486,'巴彦高勒镇',4,'',0,1,0,0),(9614,1486,'沙漠林业实验中心',4,'',0,1,0,0),(9615,1486,'沙金套海苏木',4,'',0,1,0,0),(9616,1486,'渡口乡',4,'',0,1,0,0),(9617,1486,'纳林套海农场',4,'',0,1,0,0),(9618,1486,'补隆淖尔镇',4,'',0,1,0,0),(9619,1486,'隆盛合镇',4,'',0,1,0,0),(9620,1487,'三义泉镇',4,'',0,1,0,0),(9621,1487,'元山子乡',4,'',0,1,0,0),(9622,1487,'北城区街道',4,'',0,1,0,0),(9623,1487,'官屯堡乡',4,'',0,1,0,0),(9624,1487,'工业区街道',4,'',0,1,0,0),(9625,1487,'巨宝庄镇',4,'',0,1,0,0),(9626,1487,'新城区街道',4,'',0,1,0,0),(9627,1487,'新城湾镇',4,'',0,1,0,0),(9628,1487,'旧城区街道',4,'',0,1,0,0),(9629,1487,'永善庄乡',4,'',0,1,0,0),(9630,1487,'浑源窑乡',4,'',0,1,0,0),(9631,1487,'红砂坝镇',4,'',0,1,0,0),(9632,1487,'隆盛庄镇',4,'',0,1,0,0),(9633,1487,'马家囗囗乡',4,'',0,1,0,0),(9634,1487,'黑土台镇',4,'',0,1,0,0),(9635,1487,'黑圪塔洼乡',4,'',0,1,0,0),(9636,1488,'二台子镇',4,'',0,1,0,0),(9637,1488,'五一乡',4,'',0,1,0,0),(9638,1488,'五股泉乡',4,'',0,1,0,0),(9639,1488,'台基庙乡',4,'',0,1,0,0),(9640,1488,'城关镇',4,'',0,1,0,0),(9641,1488,'壕欠镇',4,'',0,1,0,0),(9642,1488,'大同夭乡',4,'',0,1,0,0),(9643,1488,'大库联乡',4,'',0,1,0,0),(9644,1488,'店子镇',4,'',0,1,0,0),(9645,1488,'张皋镇',4,'',0,1,0,0),(9646,1488,'曹四夭乡',4,'',0,1,0,0),(9647,1488,'民族团结乡',4,'',0,1,0,0),(9648,1488,'赛乌素镇',4,'',0,1,0,0),(9649,1488,'鄂尔栋乡',4,'',0,1,0,0),(9650,1489,'三苏木乡',4,'',0,1,0,0),(9651,1489,'六苏木乡',4,'',0,1,0,0),(9652,1489,'十九号乡',4,'',0,1,0,0),(9653,1489,'厂汉营乡',4,'',0,1,0,0),(9654,1489,'厢黄地乡',4,'',0,1,0,0),(9655,1489,'双古城乡',4,'',0,1,0,0),(9656,1489,'后营乡',4,'',0,1,0,0),(9657,1489,'城关镇',4,'',0,1,0,0),(9658,1489,'天成乡',4,'',0,1,0,0),(9659,1489,'崞县夭乡',4,'',0,1,0,0),(9660,1489,'曹碾满族乡',4,'',0,1,0,0),(9661,1489,'永兴镇',4,'',0,1,0,0),(9662,1489,'程家营乡',4,'',0,1,0,0),(9663,1489,'麦胡图镇',4,'',0,1,0,0),(9664,1490,'七号镇',4,'',0,1,0,0),(9665,1490,'公腊胡洞乡',4,'',0,1,0,0),(9666,1490,'六十顷乡',4,'',0,1,0,0),(9667,1490,'六支箭乡',4,'',0,1,0,0),(9668,1490,'德包图乡',4,'',0,1,0,0),(9669,1490,'德善乡',4,'',0,1,0,0),(9670,1490,'朝阳镇',4,'',0,1,0,0),(9671,1490,'白土卜子乡',4,'',0,1,0,0),(9672,1490,'白音特拉乡',4,'',0,1,0,0),(9673,1490,'长顺镇',4,'',0,1,0,0),(9674,1491,'八苏木乡',4,'',0,1,0,0),(9675,1491,'六苏木乡',4,'',0,1,0,0),(9676,1491,'十八台镇',4,'',0,1,0,0),(9677,1491,'卓资山镇',4,'',0,1,0,0),(9678,1491,'印堂子乡',4,'',0,1,0,0),(9679,1491,'后房子乡',4,'',0,1,0,0),(9680,1491,'复兴乡',4,'',0,1,0,0),(9681,1491,'大榆树乡',4,'',0,1,0,0),(9682,1491,'巴音锡勒镇',4,'',0,1,0,0),(9683,1491,'旗下营镇',4,'',0,1,0,0),(9684,1491,'梅力盖图乡',4,'',0,1,0,0),(9685,1491,'梨花镇',4,'',0,1,0,0),(9686,1491,'福生庄乡',4,'',0,1,0,0),(9687,1491,'红召乡',4,'',0,1,0,0),(9688,1492,'三虎地乡',4,'',0,1,0,0),(9689,1492,'三面井乡',4,'',0,1,0,0),(9690,1492,'十八顷镇',4,'',0,1,0,0),(9691,1492,'卯都乡',4,'',0,1,0,0),(9692,1492,'商都镇',4,'',0,1,0,0),(9693,1492,'大南坊子乡',4,'',0,1,0,0),(9694,1492,'大库伦乡',4,'',0,1,0,0),(9695,1492,'大拉子乡',4,'',0,1,0,0),(9696,1492,'大黑沙土镇',4,'',0,1,0,0),(9697,1492,'小海子镇',4,'',0,1,0,0),(9698,1492,'屯垦队镇',4,'',0,1,0,0),(9699,1492,'格化司台乡',4,'',0,1,0,0),(9700,1492,'玻璃忽镜乡',4,'',0,1,0,0),(9701,1492,'西井子镇',4,'',0,1,0,0),(9702,1492,'西坊子乡',4,'',0,1,0,0),(9703,1493,'东八号乡',4,'',0,1,0,0),(9704,1493,'乌兰哈达苏木',4,'',0,1,0,0),(9705,1493,'乌兰花乡',4,'',0,1,0,0),(9706,1493,'乌兰花镇',4,'',0,1,0,0),(9707,1493,'供济堂乡',4,'',0,1,0,0),(9708,1493,'卫井苏木',4,'',0,1,0,0),(9709,1493,'吉尔嘎郎图苏木',4,'',0,1,0,0),(9710,1493,'吉生太乡',4,'',0,1,0,0),(9711,1493,'大井坡乡',4,'',0,1,0,0),(9712,1493,'大黑河乡',4,'',0,1,0,0),(9713,1493,'巨巾号乡',4,'',0,1,0,0),(9714,1493,'库伦图乡',4,'',0,1,0,0),(9715,1493,'忽鸡图乡',4,'',0,1,0,0),(9716,1493,'查干敖包苏木',4,'',0,1,0,0),(9717,1493,'查干补力格苏木',4,'',0,1,0,0),(9718,1493,'江岸苏木',4,'',0,1,0,0),(9719,1493,'活福滩乡',4,'',0,1,0,0),(9720,1493,'白音敖包苏木',4,'',0,1,0,0),(9721,1493,'白音朝克图苏木',4,'',0,1,0,0),(9722,1493,'白音花苏木',4,'',0,1,0,0),(9723,1493,'红格尔苏木',4,'',0,1,0,0),(9724,1493,'脑木更苏木',4,'',0,1,0,0),(9725,1493,'西河子乡',4,'',0,1,0,0),(9726,1494,'三道沟乡',4,'',0,1,0,0),(9727,1494,'义发泉乡',4,'',0,1,0,0),(9728,1494,'乌兰苏木',4,'',0,1,0,0),(9729,1494,'乌素图镇',4,'',0,1,0,0),(9730,1494,'五号乡',4,'',0,1,0,0),(9731,1494,'元山子乡',4,'',0,1,0,0),(9732,1494,'土城子乡',4,'',0,1,0,0),(9733,1494,'大滩乡',4,'',0,1,0,0),(9734,1494,'头号乡',4,'',0,1,0,0),(9735,1494,'宏盘乡',4,'',0,1,0,0),(9736,1494,'小米粮局乡',4,'',0,1,0,0),(9737,1494,'巴音乡',4,'',0,1,0,0),(9738,1494,'广益隆乡',4,'',0,1,0,0),(9739,1494,'库联苏木',4,'',0,1,0,0),(9740,1494,'得胜乡',4,'',0,1,0,0),(9741,1494,'科布尔镇',4,'',0,1,0,0),(9742,1494,'金盆乡',4,'',0,1,0,0),(9743,1494,'铁沙盖镇',4,'',0,1,0,0),(9744,1494,'黄羊城乡',4,'',0,1,0,0),(9745,1495,'三岔口乡',4,'',0,1,0,0),(9746,1495,'乌拉哈乌拉乡',4,'',0,1,0,0),(9747,1495,'呼和乌素乡',4,'',0,1,0,0),(9748,1495,'土贵乌拉乡',4,'',0,1,0,0),(9749,1495,'土贵乌拉镇',4,'',0,1,0,0),(9750,1495,'巴音塔拉镇',4,'',0,1,0,0),(9751,1495,'平地泉镇',4,'',0,1,0,0),(9752,1495,'煤窑乡',4,'',0,1,0,0),(9753,1495,'玫瑰营镇',4,'',0,1,0,0),(9754,1495,'赛汉塔拉乡',4,'',0,1,0,0),(9755,1495,'高宏店乡',4,'',0,1,0,0),(9756,1495,'黄茂营乡',4,'',0,1,0,0),(9757,1496,'乌兰哈达苏木',4,'',0,1,0,0),(9758,1496,'八号地乡',4,'',0,1,0,0),(9759,1496,'哈彦忽洞苏木',4,'',0,1,0,0),(9760,1496,'土牧尔台镇',4,'',0,1,0,0),(9761,1496,'大六号镇',4,'',0,1,0,0),(9762,1496,'当郎忽洞苏木',4,'',0,1,0,0),(9763,1496,'白音察干镇',4,'',0,1,0,0),(9764,1496,'石夭沟乡',4,'',0,1,0,0),(9765,1496,'石门口乡',4,'',0,1,0,0),(9766,1496,'红格尔图镇',4,'',0,1,0,0),(9767,1496,'贲红镇',4,'',0,1,0,0),(9768,1496,'锡勒苏木',4,'',0,1,0,0),(9769,1496,'阿贵图乡',4,'',0,1,0,0),(9770,1496,'韩勿拉苏木',4,'',0,1,0,0),(9771,1497,'工业区街道',4,'',0,1,0,0),(9772,1497,'新体路街道',4,'',0,1,0,0),(9773,1497,'新区街道',4,'',0,1,0,0),(9774,1497,'新华街街道',4,'',0,1,0,0),(9775,1497,'桥东街道',4,'',0,1,0,0),(9776,1497,'桥西街道',4,'',0,1,0,0),(9777,1497,'白海子镇',4,'',0,1,0,0),(9778,1497,'福利区街道',4,'',0,1,0,0),(9779,1497,'虎山街道',4,'',0,1,0,0),(9780,1497,'马莲渠乡',4,'',0,1,0,0),(9781,1497,'黄家村乡',4,'',0,1,0,0),(9782,1498,'乌兰哈达镇',4,'',0,1,0,0),(9783,1498,'五一街道',4,'',0,1,0,0),(9784,1498,'兴安街道',4,'',0,1,0,0),(9785,1498,'和平街道',4,'',0,1,0,0),(9786,1498,'居力很镇',4,'',0,1,0,0),(9787,1498,'永联街道',4,'',0,1,0,0),(9788,1498,'爱国街道',4,'',0,1,0,0),(9789,1498,'胜利街道',4,'',0,1,0,0),(9790,1498,'都林街道',4,'',0,1,0,0),(9791,1498,'铁西街道',4,'',0,1,0,0),(9792,1499,'二龙山乡',4,'',0,1,0,0),(9793,1499,'五家户乡',4,'',0,1,0,0),(9794,1499,'努文木仁乡',4,'',0,1,0,0),(9795,1499,'图牧吉镇',4,'',0,1,0,0),(9796,1499,'好力保乡',4,'',0,1,0,0),(9797,1499,'宝力根花苏木',4,'',0,1,0,0),(9798,1499,'小城子乡',4,'',0,1,0,0),(9799,1499,'巴岱乡',4,'',0,1,0,0),(9800,1499,'巴彦乌兰苏木',4,'',0,1,0,0),(9801,1499,'巴彦扎拉嘎乡',4,'',0,1,0,0),(9802,1499,'巴彦高勒镇',4,'',0,1,0,0),(9803,1499,'巴达尔胡镇',4,'',0,1,0,0),(9804,1499,'新林镇',4,'',0,1,0,0),(9805,1499,'绰勒镇',4,'',0,1,0,0),(9806,1499,'罕达罕乡',4,'',0,1,0,0),(9807,1499,'胡尔勒镇',4,'',0,1,0,0),(9808,1499,'阿尔本格勒镇',4,'',0,1,0,0),(9809,1499,'阿拉达尔吐苏木',4,'',0,1,0,0),(9810,1499,'音德尔镇',4,'',0,1,0,0),(9811,1500,'代钦塔拉苏木',4,'',0,1,0,0),(9812,1500,'吐列毛都镇',4,'',0,1,0,0),(9813,1500,'哈日诺尔苏木',4,'',0,1,0,0),(9814,1500,'坤都冷苏木',4,'',0,1,0,0),(9815,1500,'好腰苏木镇',4,'',0,1,0,0),(9816,1500,'巴仁哲里木镇',4,'',0,1,0,0),(9817,1500,'巴彦呼舒镇',4,'',0,1,0,0),(9818,1500,'巴彦淖尔苏木',4,'',0,1,0,0),(9819,1500,'巴彦茫哈苏木',4,'',0,1,0,0),(9820,1500,'巴扎拉嘎苏木',4,'',0,1,0,0),(9821,1500,'新佳木苏木',4,'',0,1,0,0),(9822,1500,'杜尔基镇',4,'',0,1,0,0),(9823,1500,'西日嘎苏木',4,'',0,1,0,0),(9824,1500,'额木庭高勒苏木',4,'',0,1,0,0),(9825,1500,'高力板镇',4,'',0,1,0,0),(9826,1501,'乌兰毛都苏木',4,'',0,1,0,0),(9827,1501,'俄体镇',4,'',0,1,0,0),(9828,1501,'勿布林苏木',4,'',0,1,0,0),(9829,1501,'卫东镇',4,'',0,1,0,0),(9830,1501,'古迹乡',4,'',0,1,0,0),(9831,1501,'哈拉黑镇',4,'',0,1,0,0),(9832,1501,'大坝沟镇',4,'',0,1,0,0),(9833,1501,'大石寨镇',4,'',0,1,0,0),(9834,1501,'太本站镇',4,'',0,1,0,0),(9835,1501,'好仁苏木',4,'',0,1,0,0),(9836,1501,'察尔森镇',4,'',0,1,0,0),(9837,1501,'巴拉格歹乡',4,'',0,1,0,0),(9838,1501,'归流河镇',4,'',0,1,0,0),(9839,1501,'树木沟乡',4,'',0,1,0,0),(9840,1501,'桃合木苏木',4,'',0,1,0,0),(9841,1501,'满族屯满族乡',4,'',0,1,0,0),(9842,1501,'索伦镇',4,'',0,1,0,0),(9843,1501,'葛根庙镇',4,'',0,1,0,0),(9844,1501,'阿力得尔苏木',4,'',0,1,0,0),(9845,1501,'额尔格图镇',4,'',0,1,0,0),(9846,1502,'东杜尔基镇',4,'',0,1,0,0),(9847,1502,'九龙乡',4,'',0,1,0,0),(9848,1502,'六户镇',4,'',0,1,0,0),(9849,1502,'国营农场',4,'',0,1,0,0),(9850,1502,'太东乡',4,'',0,1,0,0),(9851,1502,'太和乡',4,'',0,1,0,0),(9852,1502,'太平乡',4,'',0,1,0,0),(9853,1502,'学田乡',4,'',0,1,0,0),(9854,1502,'宝石镇',4,'',0,1,0,0),(9855,1502,'水泉镇',4,'',0,1,0,0),(9856,1502,'永安镇',4,'',0,1,0,0),(9857,1502,'溪柳乡',4,'',0,1,0,0),(9858,1502,'突泉镇',4,'',0,1,0,0),(9859,1503,'五岔沟镇',4,'',0,1,0,0),(9860,1503,'伊尔施镇',4,'',0,1,0,0),(9861,1503,'天池镇',4,'',0,1,0,0),(9862,1503,'新城街道',4,'',0,1,0,0),(9863,1503,'明水镇',4,'',0,1,0,0),(9864,1503,'林海街道',4,'',0,1,0,0),(9865,1503,'温泉街道',4,'',0,1,0,0),(9866,1503,'白狼镇',4,'',0,1,0,0),(9867,1504,'乌里雅斯太镇',4,'',0,1,0,0),(9868,1504,'呼热图淖尔苏木',4,'',0,1,0,0),(9869,1504,'嘎达布其镇和萨麦苏木',4,'',0,1,0,0),(9870,1504,'满都胡宝拉格镇',4,'',0,1,0,0),(9871,1504,'道特淖尔镇',4,'',0,1,0,0),(9872,1504,'额吉淖尔镇',4,'',0,1,0,0),(9873,1505,'东城街道',4,'',0,1,0,0),(9874,1505,'乌兰街道',4,'',0,1,0,0),(9875,1505,'格日勒敖都苏木',4,'',0,1,0,0),(9876,1505,'锡林街道',4,'',0,1,0,0),(9877,1506,'多伦淖尔镇',4,'',0,1,0,0),(9878,1506,'大北沟镇和大河口乡',4,'',0,1,0,0),(9879,1506,'蔡木山乡',4,'',0,1,0,0),(9880,1507,'千斤沟镇',4,'',0,1,0,0),(9881,1507,'宝昌镇',4,'',0,1,0,0),(9882,1507,'幸福乡',4,'',0,1,0,0),(9883,1507,'红旗镇',4,'',0,1,0,0),(9884,1507,'贡宝拉格苏木',4,'',0,1,0,0),(9885,1507,'骆驼山镇',4,'',0,1,0,0),(9886,1508,'上都镇',4,'',0,1,0,0),(9887,1508,'哈毕日嘎镇和宝绍代苏木',4,'',0,1,0,0),(9888,1508,'桑根达来镇',4,'',0,1,0,0),(9889,1508,'赛音呼都嘎苏木',4,'',0,1,0,0),(9890,1508,'那日图苏木',4,'',0,1,0,0),(9891,1509,'乌兰查布苏木',4,'',0,1,0,0),(9892,1509,'伊和淖尔苏木',4,'',0,1,0,0),(9893,1509,'明安图镇',4,'',0,1,0,0),(9894,1509,'星耀镇',4,'',0,1,0,0),(9895,1510,'乌日根塔拉镇和额仁淖尔苏木',4,'',0,1,0,0),(9896,1510,'朱日和镇',4,'',0,1,0,0),(9897,1510,'桑宝拉格苏木',4,'',0,1,0,0),(9898,1510,'赛汉塔拉镇',4,'',0,1,0,0),(9899,1510,'赛罕乌力吉苏木',4,'',0,1,0,0),(9900,1511,'巴彦乌拉苏木',4,'',0,1,0,0),(9901,1511,'巴彦淖尔镇',4,'',0,1,0,0),(9902,1511,'查干敖包镇',4,'',0,1,0,0),(9903,1511,'满都拉图镇',4,'',0,1,0,0),(9904,1511,'赛罕高毕苏木',4,'',0,1,0,0),(9905,1512,'吉仁高勒镇',4,'',0,1,0,0),(9906,1512,'巴彦花镇',4,'',0,1,0,0),(9907,1512,'巴拉嘎尔高勒镇',4,'',0,1,0,0),(9908,1512,'浩勒图高勒镇和巴彦胡舒苏木',4,'',0,1,0,0),(9909,1512,'高日罕镇',4,'',0,1,0,0),(9910,1513,'南郊街道',4,'',0,1,0,0),(9911,1513,'宝力根苏木',4,'',0,1,0,0),(9912,1513,'宝力根街道',4,'',0,1,0,0),(9913,1513,'巴彦锡勒街道',4,'',0,1,0,0),(9914,1513,'希日塔拉街道',4,'',0,1,0,0),(9915,1513,'朝克乌拉苏木',4,'',0,1,0,0),(9916,1513,'杭盖街道',4,'',0,1,0,0),(9917,1513,'楚古兰街道',4,'',0,1,0,0),(9918,1513,'阿尔善宝拉格镇',4,'',0,1,0,0),(9919,1513,'额尔敦街道',4,'',0,1,0,0),(9920,1514,'巴彦塔拉镇和翁贡乌拉苏木',4,'',0,1,0,0),(9921,1514,'新宝拉格镇',4,'',0,1,0,0),(9922,1515,'伊和高勒苏木',4,'',0,1,0,0),(9923,1515,'别力古台镇',4,'',0,1,0,0),(9924,1515,'吉尔嘎朗图苏木',4,'',0,1,0,0),(9925,1515,'查干淖尔镇',4,'',0,1,0,0),(9926,1515,'洪格尔高勒镇',4,'',0,1,0,0),(9927,1515,'那仁宝拉格苏木',4,'',0,1,0,0),(9928,1516,'阿拉腾敖包镇和孟根布拉格苏木',4,'',0,1,0,0),(9929,1516,'阿拉腾朝克苏木',4,'',0,1,0,0),(9930,1516,'雅布赖镇',4,'',0,1,0,0),(9931,1516,'额肯呼都格镇',4,'',0,1,0,0),(9932,1517,'乌力吉苏木',4,'',0,1,0,0),(9933,1517,'乌素图镇',4,'',0,1,0,0),(9934,1517,'吉兰泰镇',4,'',0,1,0,0),(9935,1517,'嘉尔格勒赛汉镇',4,'',0,1,0,0),(9936,1517,'宗别立镇',4,'',0,1,0,0),(9937,1517,'巴彦木仁苏木',4,'',0,1,0,0),(9938,1517,'巴彦浩特镇',4,'',0,1,0,0),(9939,1517,'巴彦诺日公苏木',4,'',0,1,0,0),(9940,1517,'巴润别立镇',4,'',0,1,0,0),(9941,1517,'敖伦布拉格镇',4,'',0,1,0,0),(9942,1517,'温都尔勒图镇',4,'',0,1,0,0),(9943,1517,'腾格里额里斯苏木',4,'',0,1,0,0),(9944,1517,'额尔克哈什哈苏木',4,'',0,1,0,0),(9945,1518,'东风镇',4,'',0,1,0,0),(9946,1518,'苏泊淖尔苏木',4,'',0,1,0,0),(9947,1518,'赛汉桃来苏木',4,'',0,1,0,0),(9948,1518,'达来呼布镇',4,'',0,1,0,0),(9949,1518,'马鬃山苏木',4,'',0,1,0,0),(9950,1519,'东湖街道',4,'',0,1,0,0),(9951,1519,'东陵街道',4,'',0,1,0,0),(9952,1519,'丰乐街道',4,'',0,1,0,0),(9953,1519,'五三街道',4,'',0,1,0,0),(9954,1519,'前进街道',4,'',0,1,0,0),(9955,1519,'南塔街道',4,'',0,1,0,0),(9956,1519,'李相镇',4,'',0,1,0,0),(9957,1519,'桃仙街道',4,'',0,1,0,0),(9958,1519,'泉园街道',4,'',0,1,0,0),(9959,1519,'浑河站东街道',4,'',0,1,0,0),(9960,1519,'浑河站西街道',4,'',0,1,0,0),(9961,1519,'深井子街道',4,'',0,1,0,0),(9962,1519,'满堂满族乡',4,'',0,1,0,0),(9963,1519,'王滨沟乡',4,'',0,1,0,0),(9964,1519,'白塔街道',4,'',0,1,0,0),(9965,1519,'祝家屯镇',4,'',0,1,0,0),(9966,1519,'英达街道',4,'',0,1,0,0),(9967,1519,'辉山街道',4,'',0,1,0,0),(9968,1519,'马关桥街道',4,'',0,1,0,0),(9969,1519,'高坎镇',4,'',0,1,0,0),(9970,1520,'于洪街道',4,'',0,1,0,0),(9971,1520,'光辉乡',4,'',0,1,0,0),(9972,1520,'北塔街道',4,'',0,1,0,0),(9973,1520,'北陵街道',4,'',0,1,0,0),(9974,1520,'大兴街道',4,'',0,1,0,0),(9975,1520,'大潘街道',4,'',0,1,0,0),(9976,1520,'大青中朝友谊街道',4,'',0,1,0,0),(9977,1520,'平罗街道',4,'',0,1,0,0),(9978,1520,'彰驿站镇',4,'',0,1,0,0),(9979,1520,'杨士街道',4,'',0,1,0,0),(9980,1520,'沈辽路街道',4,'',0,1,0,0),(9981,1520,'沙岭街道',4,'',0,1,0,0),(9982,1520,'翟家街道',4,'',0,1,0,0),(9983,1520,'迎宾路街道',4,'',0,1,0,0),(9984,1520,'造化街道',4,'',0,1,0,0),(9985,1520,'陵东街道',4,'',0,1,0,0),(9986,1520,'陵西街道',4,'',0,1,0,0),(9987,1520,'马三家街道',4,'',0,1,0,0),(9988,1520,'高花镇',4,'',0,1,0,0),(9989,1521,'中华路街道',4,'',0,1,0,0),(9990,1521,'云集街道',4,'',0,1,0,0),(9991,1521,'八经街道',4,'',0,1,0,0),(9992,1521,'北市街道',4,'',0,1,0,0),(9993,1521,'北站街道',4,'',0,1,0,0),(9994,1521,'北道口街道',4,'',0,1,0,0),(9995,1521,'十四纬路街道',4,'',0,1,0,0),(9996,1521,'南湖街道',4,'',0,1,0,0),(9997,1521,'南站街道',4,'',0,1,0,0),(9998,1521,'吴淞街道',4,'',0,1,0,0),(9999,1521,'园路街道',4,'',0,1,0,0),(10000,1521,'新兴街道',4,'',0,1,0,0),(10001,1521,'新华街道',4,'',0,1,0,0),(10002,1521,'民主街道',4,'',0,1,0,0),(10003,1521,'砂山街道',4,'',0,1,0,0),(10004,1521,'胜利街道',4,'',0,1,0,0),(10005,1521,'西塔街道',4,'',0,1,0,0),(10006,1521,'遂川街道',4,'',0,1,0,0),(10007,1521,'长白街道',4,'',0,1,0,0),(10008,1521,'集贤街道',4,'',0,1,0,0),(10009,1521,'马路湾街道',4,'',0,1,0,0),(10010,1522,'万泉街道',4,'',0,1,0,0),(10011,1522,'东塔街道',4,'',0,1,0,0),(10012,1522,'东站街道',4,'',0,1,0,0),(10013,1522,'二台子街道',4,'',0,1,0,0),(10014,1522,'大北街道',4,'',0,1,0,0),(10015,1522,'小东街道',4,'',0,1,0,0),(10016,1522,'小北街道',4,'',0,1,0,0),(10017,1522,'小津桥街道',4,'',0,1,0,0),(10018,1522,'文官街道',4,'',0,1,0,0),(10019,1522,'新东街道',4,'',0,1,0,0),(10020,1522,'洮昌街道',4,'',0,1,0,0),(10021,1522,'珠林街道',4,'',0,1,0,0),(10022,1522,'管城街道',4,'',0,1,0,0),(10023,1522,'辽沈街道',4,'',0,1,0,0),(10024,1522,'长安街道',4,'',0,1,0,0),(10025,1523,'东关屯镇',4,'',0,1,0,0),(10026,1523,'东升满族蒙古族乡',4,'',0,1,0,0),(10027,1523,'两家子乡',4,'',0,1,0,0),(10028,1523,'二牛所口镇',4,'',0,1,0,0),(10029,1523,'北四家子乡',4,'',0,1,0,0),(10030,1523,'小城子镇',4,'',0,1,0,0),(10031,1523,'山东屯乡',4,'',0,1,0,0),(10032,1523,'康平镇',4,'',0,1,0,0),(10033,1523,'张强镇',4,'',0,1,0,0),(10034,1523,'方家屯镇',4,'',0,1,0,0),(10035,1523,'柳树屯蒙古族满族乡',4,'',0,1,0,0),(10036,1523,'沙金台蒙古族满族乡',4,'',0,1,0,0),(10037,1523,'海洲窝堡乡',4,'',0,1,0,0),(10038,1523,'西关屯满族蒙古族乡',4,'',0,1,0,0),(10039,1523,'郝官屯镇',4,'',0,1,0,0),(10040,1524,'三道岗子乡',4,'',0,1,0,0),(10041,1524,'东城街道',4,'',0,1,0,0),(10042,1524,'东蛇山子乡',4,'',0,1,0,0),(10043,1524,'于家窝堡乡',4,'',0,1,0,0),(10044,1524,'公主屯镇',4,'',0,1,0,0),(10045,1524,'兴隆堡镇',4,'',0,1,0,0),(10046,1524,'兴隆镇',4,'',0,1,0,0),(10047,1524,'前当堡镇',4,'',0,1,0,0),(10048,1524,'卢屯乡',4,'',0,1,0,0),(10049,1524,'周坨子乡',4,'',0,1,0,0),(10050,1524,'大柳屯镇',4,'',0,1,0,0),(10051,1524,'大民屯镇',4,'',0,1,0,0),(10052,1524,'大红旗镇',4,'',0,1,0,0),(10053,1524,'姚堡乡',4,'',0,1,0,0),(10054,1524,'张屯乡',4,'',0,1,0,0),(10055,1524,'新农村乡',4,'',0,1,0,0),(10056,1524,'新城街道',4,'',0,1,0,0),(10057,1524,'新柳街道',4,'',0,1,0,0),(10058,1524,'柳河沟镇',4,'',0,1,0,0),(10059,1524,'梁山镇',4,'',0,1,0,0),(10060,1524,'法哈牛镇',4,'',0,1,0,0),(10061,1524,'红旗乡',4,'',0,1,0,0),(10062,1524,'罗家房子乡',4,'',0,1,0,0),(10063,1524,'胡台镇',4,'',0,1,0,0),(10064,1524,'西城街道',4,'',0,1,0,0),(10065,1524,'辽滨街道',4,'',0,1,0,0),(10066,1524,'金五台子乡',4,'',0,1,0,0),(10067,1524,'陶屯乡',4,'',0,1,0,0),(10068,1524,'高台子乡',4,'',0,1,0,0),(10069,1525,'兴隆台镇',4,'',0,1,0,0),(10070,1525,'尹家乡',4,'',0,1,0,0),(10071,1525,'新城子乡',4,'',0,1,0,0),(10072,1525,'新城子街道',4,'',0,1,0,0),(10073,1525,'清水台街道',4,'',0,1,0,0),(10074,1525,'清水台镇',4,'',0,1,0,0),(10075,1525,'石佛寺朝鲜族锡伯族乡',4,'',0,1,0,0),(10076,1525,'蒲河街道',4,'',0,1,0,0),(10077,1525,'虎石台街道',4,'',0,1,0,0),(10078,1525,'财落街道',4,'',0,1,0,0),(10079,1525,'道义街道',4,'',0,1,0,0),(10080,1525,'马刚乡',4,'',0,1,0,0),(10081,1525,'黄家锡伯族乡',4,'',0,1,0,0),(10082,1526,'万莲街道',4,'',0,1,0,0),(10083,1526,'五里河街道',4,'',0,1,0,0),(10084,1526,'大南街道',4,'',0,1,0,0),(10085,1526,'大西街道',4,'',0,1,0,0),(10086,1526,'山东庙街道',4,'',0,1,0,0),(10087,1526,'新北站街道',4,'',0,1,0,0),(10088,1526,'朱剪炉街道',4,'',0,1,0,0),(10089,1526,'滨河街道',4,'',0,1,0,0),(10090,1526,'皇城街道',4,'',0,1,0,0),(10091,1526,'风雨坛街道',4,'',0,1,0,0),(10092,1527,'丁家房镇',4,'',0,1,0,0),(10093,1527,'三面船镇',4,'',0,1,0,0),(10094,1527,'五台子乡',4,'',0,1,0,0),(10095,1527,'依牛堡子乡',4,'',0,1,0,0),(10096,1527,'冯贝堡乡',4,'',0,1,0,0),(10097,1527,'包家屯乡',4,'',0,1,0,0),(10098,1527,'十间房乡',4,'',0,1,0,0),(10099,1527,'卧牛石乡',4,'',0,1,0,0),(10100,1527,'双台子乡',4,'',0,1,0,0),(10101,1527,'叶茂台镇',4,'',0,1,0,0),(10102,1527,'和平乡',4,'',0,1,0,0),(10103,1527,'四家子蒙古族乡',4,'',0,1,0,0),(10104,1527,'大孤家子镇',4,'',0,1,0,0),(10105,1527,'孟家乡',4,'',0,1,0,0),(10106,1527,'慈恩寺乡',4,'',0,1,0,0),(10107,1527,'柏家沟镇',4,'',0,1,0,0),(10108,1527,'法库镇',4,'',0,1,0,0),(10109,1527,'登士堡子镇',4,'',0,1,0,0),(10110,1527,'秀水河子镇',4,'',0,1,0,0),(10111,1528,'三台子街道',4,'',0,1,0,0),(10112,1528,'三洞桥街道',4,'',0,1,0,0),(10113,1528,'亚明街道',4,'',0,1,0,0),(10114,1528,'克俭街道',4,'',0,1,0,0),(10115,1528,'华山街道',4,'',0,1,0,0),(10116,1528,'向工街道',4,'',0,1,0,0),(10117,1528,'塔湾街道',4,'',0,1,0,0),(10118,1528,'太平街道',4,'',0,1,0,0),(10119,1528,'寿泉街道',4,'',0,1,0,0),(10120,1528,'崇山街道',4,'',0,1,0,0),(10121,1528,'怒江街道',4,'',0,1,0,0),(10122,1528,'新乐街道',4,'',0,1,0,0),(10123,1528,'昆山街道',4,'',0,1,0,0),(10124,1528,'明廉街道',4,'',0,1,0,0),(10125,1528,'泰山街道',4,'',0,1,0,0),(10126,1528,'辽河街道',4,'',0,1,0,0),(10127,1528,'长江街道',4,'',0,1,0,0),(10128,1528,'陵北街道',4,'',0,1,0,0),(10129,1528,'黄河街道',4,'',0,1,0,0),(10130,1528,'黑龙江街道',4,'',0,1,0,0),(10131,1529,'中兴街道',4,'',0,1,0,0),(10132,1529,'临湖街道',4,'',0,1,0,0),(10133,1529,'佟沟乡',4,'',0,1,0,0),(10134,1529,'八一镇',4,'',0,1,0,0),(10135,1529,'十里河镇',4,'',0,1,0,0),(10136,1529,'城郊街道',4,'',0,1,0,0),(10137,1529,'大沟乡',4,'',0,1,0,0),(10138,1529,'姚千户屯镇',4,'',0,1,0,0),(10139,1529,'林盛堡镇',4,'',0,1,0,0),(10140,1529,'民主街道',4,'',0,1,0,0),(10141,1529,'永乐乡',4,'',0,1,0,0),(10142,1529,'沙河铺镇',4,'',0,1,0,0),(10143,1529,'湖西街道',4,'',0,1,0,0),(10144,1529,'王纲堡乡',4,'',0,1,0,0),(10145,1529,'白清寨乡',4,'',0,1,0,0),(10146,1529,'红菱堡镇',4,'',0,1,0,0),(10147,1529,'解放街道',4,'',0,1,0,0),(10148,1529,'铁友街道',4,'',0,1,0,0),(10149,1529,'陈相屯镇',4,'',0,1,0,0),(10150,1530,'于家房镇',4,'',0,1,0,0),(10151,1530,'六间房乡',4,'',0,1,0,0),(10152,1530,'养士堡乡',4,'',0,1,0,0),(10153,1530,'冷子堡镇',4,'',0,1,0,0),(10154,1530,'刘二堡镇',4,'',0,1,0,0),(10155,1530,'四方台镇',4,'',0,1,0,0),(10156,1530,'城郊乡',4,'',0,1,0,0),(10157,1530,'大黑岗子乡',4,'',0,1,0,0),(10158,1530,'新民屯镇',4,'',0,1,0,0),(10159,1530,'朱家房镇',4,'',0,1,0,0),(10160,1530,'杨士岗镇',4,'',0,1,0,0),(10161,1530,'满都户镇',4,'',0,1,0,0),(10162,1530,'潘家堡乡',4,'',0,1,0,0),(10163,1530,'牛心坨乡',4,'',0,1,0,0),(10164,1530,'老大房乡',4,'',0,1,0,0),(10165,1530,'老观坨乡',4,'',0,1,0,0),(10166,1530,'肖寨门镇',4,'',0,1,0,0),(10167,1530,'茨榆坨镇',4,'',0,1,0,0),(10168,1530,'辽中镇',4,'',0,1,0,0),(10169,1530,'长滩镇',4,'',0,1,0,0),(10170,1531,'七路街道',4,'',0,1,0,0),(10171,1531,'云峰街道',4,'',0,1,0,0),(10172,1531,'保工街道',4,'',0,1,0,0),(10173,1531,'兴华街道',4,'',0,1,0,0),(10174,1531,'兴工街道',4,'',0,1,0,0),(10175,1531,'兴顺街道',4,'',0,1,0,0),(10176,1531,'兴齐街道',4,'',0,1,0,0),(10177,1531,'凌空街道',4,'',0,1,0,0),(10178,1531,'十二路街道',4,'',0,1,0,0),(10179,1531,'卫工街道',4,'',0,1,0,0),(10180,1531,'启工街道',4,'',0,1,0,0),(10181,1531,'工人村街道',4,'',0,1,0,0),(10182,1531,'笃工街道',4,'',0,1,0,0),(10183,1531,'艳粉街道',4,'',0,1,0,0),(10184,1531,'贵和街道',4,'',0,1,0,0),(10185,1531,'路官街道',4,'',0,1,0,0),(10186,1531,'轻工街道',4,'',0,1,0,0),(10187,1531,'重工街道',4,'',0,1,0,0),(10188,1531,'霁虹街道',4,'',0,1,0,0),(10189,1531,'齐贤街道',4,'',0,1,0,0),(10190,1532,'人民路街道',4,'',0,1,0,0),(10191,1532,'昆明街道',4,'',0,1,0,0),(10192,1532,'桂林街道',4,'',0,1,0,0),(10193,1532,'桃源街道',4,'',0,1,0,0),(10194,1532,'海军广场街道',4,'',0,1,0,0),(10195,1532,'葵英街道',4,'',0,1,0,0),(10196,1532,'虎滩街道',4,'',0,1,0,0),(10197,1532,'青泥洼桥街道',4,'',0,1,0,0),(10198,1533,'仙人洞镇',4,'',0,1,0,0),(10199,1533,'光明山镇',4,'',0,1,0,0),(10200,1533,'兰店乡',4,'',0,1,0,0),(10201,1533,'兴达街道',4,'',0,1,0,0),(10202,1533,'吴炉镇',4,'',0,1,0,0),(10203,1533,'城关街道',4,'',0,1,0,0),(10204,1533,'城山镇',4,'',0,1,0,0),(10205,1533,'塔岭镇',4,'',0,1,0,0),(10206,1533,'大营镇',4,'',0,1,0,0),(10207,1533,'大郑镇',4,'',0,1,0,0),(10208,1533,'太平岭满族乡',4,'',0,1,0,0),(10209,1533,'徐岭镇',4,'',0,1,0,0),(10210,1533,'新华街道',4,'',0,1,0,0),(10211,1533,'昌盛街道',4,'',0,1,0,0),(10212,1533,'明阳镇',4,'',0,1,0,0),(10213,1533,'栗子房镇',4,'',0,1,0,0),(10214,1533,'桂云花满族乡',4,'',0,1,0,0),(10215,1533,'步云山乡',4,'',0,1,0,0),(10216,1533,'王家镇',4,'',0,1,0,0),(10217,1533,'石城乡',4,'',0,1,0,0),(10218,1533,'荷花山镇',4,'',0,1,0,0),(10219,1533,'蓉花山镇',4,'',0,1,0,0),(10220,1533,'长岭镇',4,'',0,1,0,0),(10221,1533,'青堆镇',4,'',0,1,0,0),(10222,1533,'鞍子山乡',4,'',0,1,0,0),(10223,1533,'黑岛镇',4,'',0,1,0,0),(10224,1534,'三涧堡镇',4,'',0,1,0,0),(10225,1534,'光荣街道',4,'',0,1,0,0),(10226,1534,'北海镇',4,'',0,1,0,0),(10227,1534,'双岛湾镇',4,'',0,1,0,0),(10228,1534,'市场街道',4,'',0,1,0,0),(10229,1534,'得胜街道',4,'',0,1,0,0),(10230,1534,'水师营街道',4,'',0,1,0,0),(10231,1534,'江西街道',4,'',0,1,0,0),(10232,1534,'登峰街道',4,'',0,1,0,0),(10233,1534,'铁山街道',4,'',0,1,0,0),(10234,1534,'长城镇',4,'',0,1,0,0),(10235,1534,'龙头镇',4,'',0,1,0,0),(10236,1534,'龙王塘街道',4,'',0,1,0,0),(10237,1535,'丰荣街道',4,'',0,1,0,0),(10238,1535,'元台镇',4,'',0,1,0,0),(10239,1535,'南山街道',4,'',0,1,0,0),(10240,1535,'双塔镇',4,'',0,1,0,0),(10241,1535,'同益乡',4,'',0,1,0,0),(10242,1535,'四平镇',4,'',0,1,0,0),(10243,1535,'城子坦镇',4,'',0,1,0,0),(10244,1535,'墨盘乡',4,'',0,1,0,0),(10245,1535,'大刘家镇',4,'',0,1,0,0),(10246,1535,'大谭镇',4,'',0,1,0,0),(10247,1535,'太平街道',4,'',0,1,0,0),(10248,1535,'夹河庙镇',4,'',0,1,0,0),(10249,1535,'安波镇',4,'',0,1,0,0),(10250,1535,'星台镇',4,'',0,1,0,0),(10251,1535,'杨树房镇',4,'',0,1,0,0),(10252,1535,'沙包镇',4,'',0,1,0,0),(10253,1535,'瓦窝镇',4,'',0,1,0,0),(10254,1535,'皮口镇',4,'',0,1,0,0),(10255,1535,'莲山镇',4,'',0,1,0,0),(10256,1535,'铁西街道',4,'',0,1,0,0),(10257,1536,'中山公园街道',4,'',0,1,0,0),(10258,1536,'兴工街道',4,'',0,1,0,0),(10259,1536,'南沙河口街道',4,'',0,1,0,0),(10260,1536,'星海湾街道',4,'',0,1,0,0),(10261,1536,'春柳街道',4,'',0,1,0,0),(10262,1536,'李家街道',4,'',0,1,0,0),(10263,1536,'白山路街道',4,'',0,1,0,0),(10264,1536,'马栏街道',4,'',0,1,0,0),(10265,1536,'黑石礁街道',4,'',0,1,0,0),(10266,1537,'万家岭镇',4,'',0,1,0,0),(10267,1537,'三台满族乡',4,'',0,1,0,0),(10268,1537,'东岗镇',4,'',0,1,0,0),(10269,1537,'交流岛乡',4,'',0,1,0,0),(10270,1537,'仙浴湾镇',4,'',0,1,0,0),(10271,1537,'共济街道',4,'',0,1,0,0),(10272,1537,'土城乡',4,'',0,1,0,0),(10273,1537,'复州城镇',4,'',0,1,0,0),(10274,1537,'复州湾镇',4,'',0,1,0,0),(10275,1537,'太阳街道',4,'',0,1,0,0),(10276,1537,'岗店街道',4,'',0,1,0,0),(10277,1537,'岭东街道',4,'',0,1,0,0),(10278,1537,'得利寺镇',4,'',0,1,0,0),(10279,1537,'文兰街道',4,'',0,1,0,0),(10280,1537,'新华街道',4,'',0,1,0,0),(10281,1537,'李官镇',4,'',0,1,0,0),(10282,1537,'李店镇',4,'',0,1,0,0),(10283,1537,'杨家满族乡',4,'',0,1,0,0),(10284,1537,'松树镇',4,'',0,1,0,0),(10285,1537,'永宁镇',4,'',0,1,0,0),(10286,1537,'泡崖乡',4,'',0,1,0,0),(10287,1537,'炮台镇',4,'',0,1,0,0),(10288,1537,'祝华街道',4,'',0,1,0,0),(10289,1537,'老虎屯镇',4,'',0,1,0,0),(10290,1537,'西杨乡',4,'',0,1,0,0),(10291,1537,'许屯镇',4,'',0,1,0,0),(10292,1537,'谢屯镇',4,'',0,1,0,0),(10293,1537,'赵屯乡',4,'',0,1,0,0),(10294,1537,'铁东街道',4,'',0,1,0,0),(10295,1537,'长兴岛镇',4,'',0,1,0,0),(10296,1537,'阎店乡',4,'',0,1,0,0),(10297,1537,'驼山乡',4,'',0,1,0,0),(10298,1538,'中华路街道',4,'',0,1,0,0),(10299,1538,'兴华街道',4,'',0,1,0,0),(10300,1538,'凌水街道',4,'',0,1,0,0),(10301,1538,'南关岭街道',4,'',0,1,0,0),(10302,1538,'周水子街道',4,'',0,1,0,0),(10303,1538,'大连湾街道',4,'',0,1,0,0),(10304,1538,'机场前街道',4,'',0,1,0,0),(10305,1538,'椒金山街道',4,'',0,1,0,0),(10306,1538,'泉水街道',4,'',0,1,0,0),(10307,1538,'泡崖街道',4,'',0,1,0,0),(10308,1538,'甘井子街道',4,'',0,1,0,0),(10309,1538,'红旗街道',4,'',0,1,0,0),(10310,1538,'营城子镇',4,'',0,1,0,0),(10311,1538,'辛寨子街道',4,'',0,1,0,0),(10312,1538,'革镇堡镇',4,'',0,1,0,0),(10313,1539,'人民广场街道',4,'',0,1,0,0),(10314,1539,'八一路街道',4,'',0,1,0,0),(10315,1539,'北京街道',4,'',0,1,0,0),(10316,1539,'日新街道',4,'',0,1,0,0),(10317,1539,'白云街道',4,'',0,1,0,0),(10318,1539,'站北街道',4,'',0,1,0,0),(10319,1539,'香炉礁街道',4,'',0,1,0,0),(10320,1540,'七顶山满族乡',4,'',0,1,0,0),(10321,1540,'三十里堡镇',4,'',0,1,0,0),(10322,1540,'中长街道',4,'',0,1,0,0),(10323,1540,'二十里堡镇',4,'',0,1,0,0),(10324,1540,'亮甲店镇',4,'',0,1,0,0),(10325,1540,'先进街道',4,'',0,1,0,0),(10326,1540,'光明街道',4,'',0,1,0,0),(10327,1540,'华家屯镇',4,'',0,1,0,0),(10328,1540,'友谊街道',4,'',0,1,0,0),(10329,1540,'向应镇',4,'',0,1,0,0),(10330,1540,'大孤山街道',4,'',0,1,0,0),(10331,1540,'大李家镇',4,'',0,1,0,0),(10332,1540,'大魏家镇',4,'',0,1,0,0),(10333,1540,'得胜镇',4,'',0,1,0,0),(10334,1540,'拥政街道',4,'',0,1,0,0),(10335,1540,'新港街道',4,'',0,1,0,0),(10336,1540,'杏树屯镇',4,'',0,1,0,0),(10337,1540,'海青岛街道',4,'',0,1,0,0),(10338,1540,'湾里街道',4,'',0,1,0,0),(10339,1540,'满家滩街道',4,'',0,1,0,0),(10340,1540,'登沙河镇',4,'',0,1,0,0),(10341,1540,'石河镇',4,'',0,1,0,0),(10342,1540,'站前街道',4,'',0,1,0,0),(10343,1540,'董家沟街道',4,'',0,1,0,0),(10344,1540,'马桥子街道',4,'',0,1,0,0),(10345,1541,'大长山岛镇',4,'',0,1,0,0),(10346,1541,'小长山乡',4,'',0,1,0,0),(10347,1541,'广鹿乡',4,'',0,1,0,0),(10348,1541,'海洋乡',4,'',0,1,0,0),(10349,1541,'獐子镇',4,'',0,1,0,0),(10350,1542,'东鞍山镇',4,'',0,1,0,0),(10351,1542,'千山镇',4,'',0,1,0,0),(10352,1542,'唐家房镇',4,'',0,1,0,0),(10353,1542,'大孤山街道',4,'',0,1,0,0),(10354,1542,'大孤山镇',4,'',0,1,0,0),(10355,1542,'宁远镇',4,'',0,1,0,0),(10356,1542,'旧堡街道',4,'',0,1,0,0),(10357,1542,'汤岗子镇',4,'',0,1,0,0),(10358,1542,'达道湾镇',4,'',0,1,0,0),(10359,1542,'齐大山镇',4,'',0,1,0,0),(10360,1543,'台安镇',4,'',0,1,0,0),(10361,1543,'富家镇',4,'',0,1,0,0),(10362,1543,'新台镇',4,'',0,1,0,0),(10363,1543,'新开河镇',4,'',0,1,0,0),(10364,1543,'桑林镇',4,'',0,1,0,0),(10365,1543,'桓洞镇',4,'',0,1,0,0),(10366,1543,'西佛镇',4,'',0,1,0,0),(10367,1543,'达牛镇',4,'',0,1,0,0),(10368,1543,'韭菜台镇',4,'',0,1,0,0),(10369,1543,'高力房镇',4,'',0,1,0,0),(10370,1543,'黄沙坨镇',4,'',0,1,0,0),(10371,1544,'三家子镇',4,'',0,1,0,0),(10372,1544,'偏岭镇',4,'',0,1,0,0),(10373,1544,'前营子镇',4,'',0,1,0,0),(10374,1544,'哈达碑镇',4,'',0,1,0,0),(10375,1544,'哨子河乡',4,'',0,1,0,0),(10376,1544,'大房身乡',4,'',0,1,0,0),(10377,1544,'大营子镇',4,'',0,1,0,0),(10378,1544,'岫岩镇',4,'',0,1,0,0),(10379,1544,'岭沟乡',4,'',0,1,0,0),(10380,1544,'新甸镇',4,'',0,1,0,0),(10381,1544,'朝阳乡',4,'',0,1,0,0),(10382,1544,'杨家堡镇',4,'',0,1,0,0),(10383,1544,'汤沟镇',4,'',0,1,0,0),(10384,1544,'洋河镇',4,'',0,1,0,0),(10385,1544,'牧牛乡',4,'',0,1,0,0),(10386,1544,'石庙子镇',4,'',0,1,0,0),(10387,1544,'石灰窑镇',4,'',0,1,0,0),(10388,1544,'红旗营子乡',4,'',0,1,0,0),(10389,1544,'苏子沟镇',4,'',0,1,0,0),(10390,1544,'韭菜沟乡',4,'',0,1,0,0),(10391,1544,'黄花甸镇',4,'',0,1,0,0),(10392,1544,'龙潭镇',4,'',0,1,0,0),(10393,1545,'东四街道',4,'',0,1,0,0),(10394,1545,'中小镇',4,'',0,1,0,0),(10395,1545,'八里镇',4,'',0,1,0,0),(10396,1545,'兴海街道',4,'',0,1,0,0),(10397,1545,'南台镇',4,'',0,1,0,0),(10398,1545,'响堂街道',4,'',0,1,0,0),(10399,1545,'大屯镇',4,'',0,1,0,0),(10400,1545,'孤山镇',4,'',0,1,0,0),(10401,1545,'岔沟镇',4,'',0,1,0,0),(10402,1545,'感王镇',4,'',0,1,0,0),(10403,1545,'接文镇',4,'',0,1,0,0),(10404,1545,'望台镇',4,'',0,1,0,0),(10405,1545,'析木镇',4,'',0,1,0,0),(10406,1545,'毛祁镇',4,'',0,1,0,0),(10407,1545,'海州街道',4,'',0,1,0,0),(10408,1545,'温香镇',4,'',0,1,0,0),(10409,1545,'牌楼镇',4,'',0,1,0,0),(10410,1545,'牛庄镇',4,'',0,1,0,0),(10411,1545,'王石镇',4,'',0,1,0,0),(10412,1545,'甘泉镇',4,'',0,1,0,0),(10413,1545,'耿庄镇',4,'',0,1,0,0),(10414,1545,'腾鳌镇',4,'',0,1,0,0),(10415,1545,'英落镇',4,'',0,1,0,0),(10416,1545,'西四镇',4,'',0,1,0,0),(10417,1545,'西柳镇',4,'',0,1,0,0),(10418,1545,'马风镇',4,'',0,1,0,0),(10419,1545,'高坨镇',4,'',0,1,0,0),(10420,1546,'友好街道',4,'',0,1,0,0),(10421,1546,'双山街道',4,'',0,1,0,0),(10422,1546,'曙光街道',4,'',0,1,0,0),(10423,1546,'沙河街道',4,'',0,1,0,0),(10424,1546,'沙河镇',4,'',0,1,0,0),(10425,1546,'深北街道',4,'',0,1,0,0),(10426,1546,'深南街道',4,'',0,1,0,0),(10427,1546,'灵山街道',4,'',0,1,0,0),(10428,1546,'立山街道',4,'',0,1,0,0),(10429,1547,'东长甸街道',4,'',0,1,0,0),(10430,1547,'和平街道',4,'',0,1,0,0),(10431,1547,'园林街道',4,'',0,1,0,0),(10432,1547,'对炉街道',4,'',0,1,0,0),(10433,1547,'山南街道',4,'',0,1,0,0),(10434,1547,'常青街道',4,'',0,1,0,0),(10435,1547,'新兴街道',4,'',0,1,0,0),(10436,1547,'汪峪街道',4,'',0,1,0,0),(10437,1547,'湖南街道',4,'',0,1,0,0),(10438,1547,'站前街道',4,'',0,1,0,0),(10439,1547,'胜利街道',4,'',0,1,0,0),(10440,1547,'解放街道',4,'',0,1,0,0),(10441,1547,'钢城街道',4,'',0,1,0,0),(10442,1547,'长甸街道',4,'',0,1,0,0),(10443,1548,'八家子街道',4,'',0,1,0,0),(10444,1548,'共和街道',4,'',0,1,0,0),(10445,1548,'兴盛街道',4,'',0,1,0,0),(10446,1548,'北陶官街道',4,'',0,1,0,0),(10447,1548,'南华街道',4,'',0,1,0,0),(10448,1548,'启明街道',4,'',0,1,0,0),(10449,1548,'大陆街道',4,'',0,1,0,0),(10450,1548,'新陶街道',4,'',0,1,0,0),(10451,1548,'永乐街道',4,'',0,1,0,0),(10452,1548,'永发街道',4,'',0,1,0,0),(10453,1548,'繁荣街道',4,'',0,1,0,0),(10454,1549,'万新街道',4,'',0,1,0,0),(10455,1549,'东洲街道',4,'',0,1,0,0),(10456,1549,'刘山街道',4,'',0,1,0,0),(10457,1549,'千金乡',4,'',0,1,0,0),(10458,1549,'南花园街道',4,'',0,1,0,0),(10459,1549,'平山街道',4,'',0,1,0,0),(10460,1549,'张甸街道',4,'',0,1,0,0),(10461,1549,'搭连街道',4,'',0,1,0,0),(10462,1549,'新屯街道',4,'',0,1,0,0),(10463,1549,'碾盘乡',4,'',0,1,0,0),(10464,1549,'章党街道',4,'',0,1,0,0),(10465,1549,'老虎台街道',4,'',0,1,0,0),(10466,1549,'龙凤街道',4,'',0,1,0,0),(10467,1550,'上马乡',4,'',0,1,0,0),(10468,1550,'兰山乡',4,'',0,1,0,0),(10469,1550,'后安镇',4,'',0,1,0,0),(10470,1550,'哈达镇',4,'',0,1,0,0),(10471,1550,'峡河乡',4,'',0,1,0,0),(10472,1550,'拉古满族乡',4,'',0,1,0,0),(10473,1550,'救兵乡',4,'',0,1,0,0),(10474,1550,'汤图满族乡',4,'',0,1,0,0),(10475,1550,'海浪乡',4,'',0,1,0,0),(10476,1550,'石文镇',4,'',0,1,0,0),(10477,1550,'章党镇',4,'',0,1,0,0),(10478,1550,'马圈子乡',4,'',0,1,0,0),(10479,1551,'上夹河镇',4,'',0,1,0,0),(10480,1551,'下夹河乡',4,'',0,1,0,0),(10481,1551,'北四平乡',4,'',0,1,0,0),(10482,1551,'南杂木镇',4,'',0,1,0,0),(10483,1551,'响水河子乡',4,'',0,1,0,0),(10484,1551,'大四平镇',4,'',0,1,0,0),(10485,1551,'平顶山镇',4,'',0,1,0,0),(10486,1551,'新宾镇',4,'',0,1,0,0),(10487,1551,'旺清门镇',4,'',0,1,0,0),(10488,1551,'木奇镇',4,'',0,1,0,0),(10489,1551,'榆树乡',4,'',0,1,0,0),(10490,1551,'永陵镇',4,'',0,1,0,0),(10491,1551,'红升乡',4,'',0,1,0,0),(10492,1551,'红庙子乡',4,'',0,1,0,0),(10493,1551,'苇子峪镇',4,'',0,1,0,0),(10494,1552,'东公园街道',4,'',0,1,0,0),(10495,1552,'新抚街道',4,'',0,1,0,0),(10496,1552,'榆林街道',4,'',0,1,0,0),(10497,1552,'永安台街道',4,'',0,1,0,0),(10498,1552,'福民街道',4,'',0,1,0,0),(10499,1552,'站前街道',4,'',0,1,0,0),(10500,1553,'五老屯街道',4,'',0,1,0,0),(10501,1553,'光明街道',4,'',0,1,0,0),(10502,1553,'古城子街道',4,'',0,1,0,0),(10503,1553,'和平街道',4,'',0,1,0,0),(10504,1553,'塔峪镇',4,'',0,1,0,0),(10505,1553,'工农街道',4,'',0,1,0,0),(10506,1553,'建设街道',4,'',0,1,0,0),(10507,1553,'新民街道',4,'',0,1,0,0),(10508,1553,'朴屯街道',4,'',0,1,0,0),(10509,1553,'李石街道',4,'',0,1,0,0),(10510,1553,'演武街道',4,'',0,1,0,0),(10511,1553,'田屯街道',4,'',0,1,0,0),(10512,1554,'北三家乡',4,'',0,1,0,0),(10513,1554,'南口前镇',4,'',0,1,0,0),(10514,1554,'南山城镇',4,'',0,1,0,0),(10515,1554,'土口子乡',4,'',0,1,0,0),(10516,1554,'夏家堡镇',4,'',0,1,0,0),(10517,1554,'大孤家镇',4,'',0,1,0,0),(10518,1554,'大苏河乡',4,'',0,1,0,0),(10519,1554,'敖家堡乡',4,'',0,1,0,0),(10520,1554,'枸乃甸乡',4,'',0,1,0,0),(10521,1554,'清原镇',4,'',0,1,0,0),(10522,1554,'湾甸子镇',4,'',0,1,0,0),(10523,1554,'红透山镇',4,'',0,1,0,0),(10524,1554,'英额门镇',4,'',0,1,0,0),(10525,1554,'草市镇',4,'',0,1,0,0),(10526,1555,'会元乡',4,'',0,1,0,0),(10527,1555,'前甸镇',4,'',0,1,0,0),(10528,1555,'将军堡街道',4,'',0,1,0,0),(10529,1555,'抚顺城街道',4,'',0,1,0,0),(10530,1555,'新华街道',4,'',0,1,0,0),(10531,1555,'河东街道',4,'',0,1,0,0),(10532,1555,'河北乡',4,'',0,1,0,0),(10533,1555,'葛布街道',4,'',0,1,0,0),(10534,1555,'长春街道',4,'',0,1,0,0),(10535,1556,'下马塘镇',4,'',0,1,0,0),(10536,1556,'南芬街道',4,'',0,1,0,0),(10537,1556,'思山岭满族乡',4,'',0,1,0,0),(10538,1556,'郭家街道',4,'',0,1,0,0),(10539,1556,'铁山街道',4,'',0,1,0,0),(10540,1557,'东明街道',4,'',0,1,0,0),(10541,1557,'北台街道',4,'',0,1,0,0),(10542,1557,'千金街道',4,'',0,1,0,0),(10543,1557,'南地街道',4,'',0,1,0,0),(10544,1557,'崔东街道',4,'',0,1,0,0),(10545,1557,'工人街道',4,'',0,1,0,0),(10546,1557,'平山街道',4,'',0,1,0,0),(10547,1557,'桥头镇',4,'',0,1,0,0),(10548,1557,'站前街道',4,'',0,1,0,0),(10549,1558,'东兴街道',4,'',0,1,0,0),(10550,1558,'北地街道',4,'',0,1,0,0),(10551,1558,'卧龙街道',4,'',0,1,0,0),(10552,1558,'新明街道',4,'',0,1,0,0),(10553,1558,'明山街道',4,'',0,1,0,0),(10554,1558,'牛心台街道',4,'',0,1,0,0),(10555,1558,'金山街道',4,'',0,1,0,0),(10556,1558,'高台子镇',4,'',0,1,0,0),(10557,1558,'高峪街道',4,'',0,1,0,0),(10558,1559,'东营坊乡',4,'',0,1,0,0),(10559,1559,'南甸子镇',4,'',0,1,0,0),(10560,1559,'小市镇',4,'',0,1,0,0),(10561,1559,'清河城镇',4,'',0,1,0,0),(10562,1559,'田师付镇',4,'',0,1,0,0),(10563,1559,'碱厂镇',4,'',0,1,0,0),(10564,1559,'草河口镇',4,'',0,1,0,0),(10565,1559,'草河城镇',4,'',0,1,0,0),(10566,1559,'草河掌镇',4,'',0,1,0,0),(10567,1559,'连山关镇',4,'',0,1,0,0),(10568,1559,'高官镇',4,'',0,1,0,0),(10569,1560,'二棚甸子镇',4,'',0,1,0,0),(10570,1560,'五里甸子镇',4,'',0,1,0,0),(10571,1560,'八里甸子镇',4,'',0,1,0,0),(10572,1560,'北甸子乡',4,'',0,1,0,0),(10573,1560,'华来镇',4,'',0,1,0,0),(10574,1560,'古城镇',4,'',0,1,0,0),(10575,1560,'向阳乡',4,'',0,1,0,0),(10576,1560,'四平乡',4,'',0,1,0,0),(10577,1560,'普乐堡镇',4,'',0,1,0,0),(10578,1560,'桓仁镇',4,'',0,1,0,0),(10579,1560,'沙尖子镇',4,'',0,1,0,0),(10580,1560,'雅河朝鲜族乡',4,'',0,1,0,0),(10581,1560,'黑沟乡',4,'',0,1,0,0),(10582,1561,'东风街道',4,'',0,1,0,0),(10583,1561,'张其寨乡',4,'',0,1,0,0),(10584,1561,'彩北街道',4,'',0,1,0,0),(10585,1561,'彩屯街道',4,'',0,1,0,0),(10586,1561,'歪头山镇',4,'',0,1,0,0),(10587,1561,'河东街道',4,'',0,1,0,0),(10588,1561,'河西街道',4,'',0,1,0,0),(10589,1561,'火连寨镇',4,'',0,1,0,0),(10590,1561,'石桥子镇',4,'',0,1,0,0),(10591,1561,'竖井街道',4,'',0,1,0,0),(10592,1562,'前阳镇',4,'',0,1,0,0),(10593,1562,'北井子镇',4,'',0,1,0,0),(10594,1562,'十字街镇',4,'',0,1,0,0),(10595,1562,'合隆满族乡',4,'',0,1,0,0),(10596,1562,'大东街道',4,'',0,1,0,0),(10597,1562,'孤山镇',4,'',0,1,0,0),(10598,1562,'小甸子镇',4,'',0,1,0,0),(10599,1562,'新兴街道',4,'',0,1,0,0),(10600,1562,'新农镇',4,'',0,1,0,0),(10601,1562,'新城街道',4,'',0,1,0,0),(10602,1562,'椅圈镇',4,'',0,1,0,0),(10603,1562,'汤池镇',4,'',0,1,0,0),(10604,1562,'菩萨庙镇',4,'',0,1,0,0),(10605,1562,'长安镇',4,'',0,1,0,0),(10606,1562,'长山镇',4,'',0,1,0,0),(10607,1562,'马家店镇',4,'',0,1,0,0),(10608,1562,'黄土坎镇',4,'',0,1,0,0),(10609,1562,'黑沟镇',4,'',0,1,0,0),(10610,1562,'龙王庙镇',4,'',0,1,0,0),(10611,1563,'七道街道',4,'',0,1,0,0),(10612,1563,'九道街道',4,'',0,1,0,0),(10613,1563,'八道街道',4,'',0,1,0,0),(10614,1563,'六道口街道',4,'',0,1,0,0),(10615,1563,'兴东街道',4,'',0,1,0,0),(10616,1563,'广济街道',4,'',0,1,0,0),(10617,1563,'蛤蟆塘镇',4,'',0,1,0,0),(10618,1564,'东汤镇',4,'',0,1,0,0),(10619,1564,'凤凰城街道',4,'',0,1,0,0),(10620,1564,'凤山街道',4,'',0,1,0,0),(10621,1564,'刘家河镇',4,'',0,1,0,0),(10622,1564,'四门子镇',4,'',0,1,0,0),(10623,1564,'大兴镇',4,'',0,1,0,0),(10624,1564,'大堡镇',4,'',0,1,0,0),(10625,1564,'宝山镇',4,'',0,1,0,0),(10626,1564,'弟兄山镇',4,'',0,1,0,0),(10627,1564,'沙里寨镇',4,'',0,1,0,0),(10628,1564,'爱阳镇',4,'',0,1,0,0),(10629,1564,'白旗镇',4,'',0,1,0,0),(10630,1564,'石城镇',4,'',0,1,0,0),(10631,1564,'红旗镇',4,'',0,1,0,0),(10632,1564,'草河街道',4,'',0,1,0,0),(10633,1564,'蓝旗镇',4,'',0,1,0,0),(10634,1564,'赛马镇',4,'',0,1,0,0),(10635,1564,'边门镇',4,'',0,1,0,0),(10636,1564,'通远堡镇',4,'',0,1,0,0),(10637,1564,'青城子镇',4,'',0,1,0,0),(10638,1564,'鸡冠山镇',4,'',0,1,0,0),(10639,1565,'下露河朝鲜族乡',4,'',0,1,0,0),(10640,1565,'八河川镇',4,'',0,1,0,0),(10641,1565,'双山子镇',4,'',0,1,0,0),(10642,1565,'古楼子乡',4,'',0,1,0,0),(10643,1565,'大川头镇',4,'',0,1,0,0),(10644,1565,'大西岔镇',4,'',0,1,0,0),(10645,1565,'太平哨镇',4,'',0,1,0,0),(10646,1565,'宽甸镇',4,'',0,1,0,0),(10647,1565,'振江镇',4,'',0,1,0,0),(10648,1565,'杨木川镇',4,'',0,1,0,0),(10649,1565,'步达远镇',4,'',0,1,0,0),(10650,1565,'毛甸子镇',4,'',0,1,0,0),(10651,1565,'永甸镇',4,'',0,1,0,0),(10652,1565,'灌水镇',4,'',0,1,0,0),(10653,1565,'牛毛坞镇',4,'',0,1,0,0),(10654,1565,'石湖沟乡',4,'',0,1,0,0),(10655,1565,'硼海镇',4,'',0,1,0,0),(10656,1565,'红石镇',4,'',0,1,0,0),(10657,1565,'虎山镇',4,'',0,1,0,0),(10658,1565,'长甸镇',4,'',0,1,0,0),(10659,1565,'青山沟镇',4,'',0,1,0,0),(10660,1565,'青椅山镇',4,'',0,1,0,0),(10661,1566,'临江街道',4,'',0,1,0,0),(10662,1566,'六道沟街道',4,'',0,1,0,0),(10663,1566,'头道桥街道',4,'',0,1,0,0),(10664,1566,'安民镇',4,'',0,1,0,0),(10665,1566,'帽盔山街道',4,'',0,1,0,0),(10666,1566,'浪头镇',4,'',0,1,0,0),(10667,1566,'站前街道',4,'',0,1,0,0),(10668,1566,'纤维街道',4,'',0,1,0,0),(10669,1567,'九连城镇',4,'',0,1,0,0),(10670,1567,'五龙背镇',4,'',0,1,0,0),(10671,1567,'同兴镇',4,'',0,1,0,0),(10672,1567,'太平湾街道',4,'',0,1,0,0),(10673,1567,'楼房镇',4,'',0,1,0,0),(10674,1567,'汤山城镇',4,'',0,1,0,0),(10675,1567,'珍珠街道',4,'',0,1,0,0),(10676,1567,'金矿街道',4,'',0,1,0,0),(10677,1567,'鸭绿江街道',4,'',0,1,0,0),(10678,1568,'七里河镇',4,'',0,1,0,0),(10679,1568,'义州镇',4,'',0,1,0,0),(10680,1568,'九道岭镇',4,'',0,1,0,0),(10681,1568,'刘龙台镇',4,'',0,1,0,0),(10682,1568,'前杨乡',4,'',0,1,0,0),(10683,1568,'地藏寺满族乡',4,'',0,1,0,0),(10684,1568,'城关满族乡',4,'',0,1,0,0),(10685,1568,'大定堡满族乡',4,'',0,1,0,0),(10686,1568,'大榆树堡镇',4,'',0,1,0,0),(10687,1568,'头台满族乡',4,'',0,1,0,0),(10688,1568,'头道河满族乡',4,'',0,1,0,0),(10689,1568,'张家堡乡',4,'',0,1,0,0),(10690,1568,'瓦子峪镇',4,'',0,1,0,0),(10691,1568,'留龙沟满族乡',4,'',0,1,0,0),(10692,1568,'白庙子乡',4,'',0,1,0,0),(10693,1568,'稍户营子镇',4,'',0,1,0,0),(10694,1568,'聚粮屯满族乡',4,'',0,1,0,0),(10695,1568,'高台子镇',4,'',0,1,0,0),(10696,1569,'凌安街道',4,'',0,1,0,0),(10697,1569,'康宁街道',4,'',0,1,0,0),(10698,1569,'榴花街道',4,'',0,1,0,0),(10699,1569,'正大街道',4,'',0,1,0,0),(10700,1569,'百股街道',4,'',0,1,0,0),(10701,1569,'石桥街道',4,'',0,1,0,0),(10702,1569,'菊园街道',4,'',0,1,0,0),(10703,1569,'铁新街道',4,'',0,1,0,0),(10704,1569,'锦铁街道',4,'',0,1,0,0),(10705,1569,'马家街道',4,'',0,1,0,0),(10706,1569,'龙江街道',4,'',0,1,0,0),(10707,1570,'三台子镇',4,'',0,1,0,0),(10708,1570,'余积镇',4,'',0,1,0,0),(10709,1570,'双羊镇',4,'',0,1,0,0),(10710,1570,'右卫镇',4,'',0,1,0,0),(10711,1570,'大业乡',4,'',0,1,0,0),(10712,1570,'大凌河街道',4,'',0,1,0,0),(10713,1570,'娘娘宫镇',4,'',0,1,0,0),(10714,1570,'安屯乡',4,'',0,1,0,0),(10715,1570,'建业乡',4,'',0,1,0,0),(10716,1570,'新庄子镇',4,'',0,1,0,0),(10717,1570,'松山镇',4,'',0,1,0,0),(10718,1570,'板石沟乡',4,'',0,1,0,0),(10719,1570,'沈家台镇',4,'',0,1,0,0),(10720,1570,'温滴楼满族乡',4,'',0,1,0,0),(10721,1570,'班吉塔镇',4,'',0,1,0,0),(10722,1570,'白台子乡',4,'',0,1,0,0),(10723,1570,'石山镇',4,'',0,1,0,0),(10724,1570,'翠岩镇',4,'',0,1,0,0),(10725,1570,'西八千乡',4,'',0,1,0,0),(10726,1570,'谢屯乡',4,'',0,1,0,0),(10727,1570,'金城街道',4,'',0,1,0,0),(10728,1570,'闫家镇',4,'',0,1,0,0),(10729,1571,'中安镇',4,'',0,1,0,0),(10730,1571,'北镇街道',4,'',0,1,0,0),(10731,1571,'吴家乡',4,'',0,1,0,0),(10732,1571,'大屯乡',4,'',0,1,0,0),(10733,1571,'大市镇',4,'',0,1,0,0),(10734,1571,'富屯乡',4,'',0,1,0,0),(10735,1571,'常兴店镇',4,'',0,1,0,0),(10736,1571,'广宁街道',4,'',0,1,0,0),(10737,1571,'廖屯镇',4,'',0,1,0,0),(10738,1571,'柳家乡',4,'',0,1,0,0),(10739,1571,'正安镇',4,'',0,1,0,0),(10740,1571,'沟帮子镇',4,'',0,1,0,0),(10741,1571,'罗罗堡镇',4,'',0,1,0,0),(10742,1571,'观音阁街道',4,'',0,1,0,0),(10743,1571,'赵屯镇',4,'',0,1,0,0),(10744,1571,'辽城乡',4,'',0,1,0,0),(10745,1571,'闾阳镇',4,'',0,1,0,0),(10746,1571,'青堆子镇',4,'',0,1,0,0),(10747,1571,'高山子镇',4,'',0,1,0,0),(10748,1571,'鲍家乡',4,'',0,1,0,0),(10749,1572,'保安街道',4,'',0,1,0,0),(10750,1572,'北街街道',4,'',0,1,0,0),(10751,1572,'南街街道',4,'',0,1,0,0),(10752,1572,'士英街道',4,'',0,1,0,0),(10753,1572,'天安街道',4,'',0,1,0,0),(10754,1572,'敬业街道',4,'',0,1,0,0),(10755,1572,'石油街道',4,'',0,1,0,0),(10756,1572,'站前街道',4,'',0,1,0,0),(10757,1572,'饶阳街道',4,'',0,1,0,0),(10758,1573,'兴隆街道',4,'',0,1,0,0),(10759,1573,'凌南街道',4,'',0,1,0,0),(10760,1573,'凌西街道',4,'',0,1,0,0),(10761,1573,'大薛街道',4,'',0,1,0,0),(10762,1573,'天桥街道',4,'',0,1,0,0),(10763,1573,'太和街道',4,'',0,1,0,0),(10764,1573,'女儿河乡',4,'',0,1,0,0),(10765,1573,'新民乡',4,'',0,1,0,0),(10766,1573,'杏山街道',4,'',0,1,0,0),(10767,1573,'汤河街道',4,'',0,1,0,0),(10768,1573,'王家街道',4,'',0,1,0,0),(10769,1573,'营盘乡',4,'',0,1,0,0),(10770,1573,'钟屯乡',4,'',0,1,0,0),(10771,1574,'八道壕镇',4,'',0,1,0,0),(10772,1574,'励家镇',4,'',0,1,0,0),(10773,1574,'半拉门镇',4,'',0,1,0,0),(10774,1574,'四家子镇',4,'',0,1,0,0),(10775,1574,'大兴乡',4,'',0,1,0,0),(10776,1574,'大虎山镇',4,'',0,1,0,0),(10777,1574,'太和镇',4,'',0,1,0,0),(10778,1574,'姜屯镇',4,'',0,1,0,0),(10779,1574,'小东镇',4,'',0,1,0,0),(10780,1574,'常兴镇',4,'',0,1,0,0),(10781,1574,'新兴镇',4,'',0,1,0,0),(10782,1574,'新立屯镇',4,'',0,1,0,0),(10783,1574,'无梁殿镇',4,'',0,1,0,0),(10784,1574,'段家乡',4,'',0,1,0,0),(10785,1574,'白厂门镇',4,'',0,1,0,0),(10786,1574,'绕阳河镇',4,'',0,1,0,0),(10787,1574,'胡家镇',4,'',0,1,0,0),(10788,1574,'芳山镇',4,'',0,1,0,0),(10789,1574,'英城子乡',4,'',0,1,0,0),(10790,1574,'薛屯乡',4,'',0,1,0,0),(10791,1574,'镇安满族乡',4,'',0,1,0,0),(10792,1574,'黑山镇',4,'',0,1,0,0),(10793,1575,'南楼街道',4,'',0,1,0,0),(10794,1575,'周家镇',4,'',0,1,0,0),(10795,1575,'官屯镇',4,'',0,1,0,0),(10796,1575,'建一镇',4,'',0,1,0,0),(10797,1575,'旗口镇',4,'',0,1,0,0),(10798,1575,'水源镇',4,'',0,1,0,0),(10799,1575,'永安镇',4,'',0,1,0,0),(10800,1575,'汤池镇',4,'',0,1,0,0),(10801,1575,'沟沿镇',4,'',0,1,0,0),(10802,1575,'溥洛铺镇',4,'',0,1,0,0),(10803,1575,'石佛镇',4,'',0,1,0,0),(10804,1575,'石桥街道',4,'',0,1,0,0),(10805,1575,'虎庄镇',4,'',0,1,0,0),(10806,1575,'金桥街道',4,'',0,1,0,0),(10807,1575,'钢都街道',4,'',0,1,0,0),(10808,1575,'青花街道',4,'',0,1,0,0),(10809,1575,'高坎镇',4,'',0,1,0,0),(10810,1575,'黄土岭镇',4,'',0,1,0,0),(10811,1576,'万福镇',4,'',0,1,0,0),(10812,1576,'东城街道',4,'',0,1,0,0),(10813,1576,'九垄地镇',4,'',0,1,0,0),(10814,1576,'九寨镇',4,'',0,1,0,0),(10815,1576,'二台乡',4,'',0,1,0,0),(10816,1576,'什字街镇',4,'',0,1,0,0),(10817,1576,'卧龙泉镇',4,'',0,1,0,0),(10818,1576,'双台镇',4,'',0,1,0,0),(10819,1576,'古楼街道',4,'',0,1,0,0),(10820,1576,'团山街道',4,'',0,1,0,0),(10821,1576,'团甸镇',4,'',0,1,0,0),(10822,1576,'太阳升街道',4,'',0,1,0,0),(10823,1576,'小石棚乡',4,'',0,1,0,0),(10824,1576,'归州镇',4,'',0,1,0,0),(10825,1576,'徐屯镇',4,'',0,1,0,0),(10826,1576,'暖泉镇',4,'',0,1,0,0),(10827,1576,'杨运镇',4,'',0,1,0,0),(10828,1576,'果园乡',4,'',0,1,0,0),(10829,1576,'梁屯镇',4,'',0,1,0,0),(10830,1576,'榜式堡镇',4,'',0,1,0,0),(10831,1576,'沙岗镇',4,'',0,1,0,0),(10832,1576,'矿洞沟镇',4,'',0,1,0,0),(10833,1576,'西城街道',4,'',0,1,0,0),(10834,1576,'西海街道',4,'',0,1,0,0),(10835,1576,'陈屯镇',4,'',0,1,0,0),(10836,1576,'青石岭镇',4,'',0,1,0,0),(10837,1576,'高屯镇',4,'',0,1,0,0),(10838,1577,'东风街道',4,'',0,1,0,0),(10839,1577,'八田地街道',4,'',0,1,0,0),(10840,1577,'建丰街道',4,'',0,1,0,0),(10841,1577,'建设街道',4,'',0,1,0,0),(10842,1577,'新兴街道',4,'',0,1,0,0),(10843,1577,'新建街道',4,'',0,1,0,0),(10844,1577,'跃进街道',4,'',0,1,0,0),(10845,1578,'二道镇',4,'',0,1,0,0),(10846,1578,'城东街道',4,'',0,1,0,0),(10847,1578,'柳树镇',4,'',0,1,0,0),(10848,1578,'老边街道',4,'',0,1,0,0),(10849,1578,'路南镇',4,'',0,1,0,0),(10850,1578,'边城镇',4,'',0,1,0,0),(10851,1579,'五台子街道',4,'',0,1,0,0),(10852,1579,'得胜街道',4,'',0,1,0,0),(10853,1579,'河北街道',4,'',0,1,0,0),(10854,1579,'清华街道',4,'',0,1,0,0),(10855,1579,'渔市街道',4,'',0,1,0,0),(10856,1579,'胜利街道',4,'',0,1,0,0),(10857,1579,'西市场街道',4,'',0,1,0,0),(10858,1580,'望海街道',4,'',0,1,0,0),(10859,1580,'海东街道',4,'',0,1,0,0),(10860,1580,'海星街道',4,'',0,1,0,0),(10861,1580,'熊岳镇',4,'',0,1,0,0),(10862,1580,'红旗镇',4,'',0,1,0,0),(10863,1580,'红海街道',4,'',0,1,0,0),(10864,1580,'芦屯镇',4,'',0,1,0,0),(10865,1581,'城南街道',4,'',0,1,0,0),(10866,1581,'孙家湾街道',4,'',0,1,0,0),(10867,1581,'水泉镇',4,'',0,1,0,0),(10868,1581,'煤海街道',4,'',0,1,0,0),(10869,1581,'红树街道',4,'',0,1,0,0),(10870,1581,'高德街道',4,'',0,1,0,0),(10871,1582,'东六家子镇',4,'',0,1,0,0),(10872,1582,'两家子乡',4,'',0,1,0,0),(10873,1582,'丰田乡',4,'',0,1,0,0),(10874,1582,'二道河子蒙古族乡',4,'',0,1,0,0),(10875,1582,'五峰镇',4,'',0,1,0,0),(10876,1582,'兴隆堡乡',4,'',0,1,0,0),(10877,1582,'兴隆山乡',4,'',0,1,0,0),(10878,1582,'冯家镇',4,'',0,1,0,0),(10879,1582,'前福兴地乡',4,'',0,1,0,0),(10880,1582,'双庙乡',4,'',0,1,0,0),(10881,1582,'后新秋镇',4,'',0,1,0,0),(10882,1582,'哈尔套镇',4,'',0,1,0,0),(10883,1582,'四合城乡',4,'',0,1,0,0),(10884,1582,'四堡子乡',4,'',0,1,0,0),(10885,1582,'大冷蒙古族乡',4,'',0,1,0,0),(10886,1582,'大四家子乡',4,'',0,1,0,0),(10887,1582,'大德乡',4,'',0,1,0,0),(10888,1582,'平安乡',4,'',0,1,0,0),(10889,1582,'彰武镇',4,'',0,1,0,0),(10890,1582,'满堂红乡',4,'',0,1,0,0),(10891,1582,'章古台镇',4,'',0,1,0,0),(10892,1582,'苇子沟蒙古族乡',4,'',0,1,0,0),(10893,1582,'西六家子蒙古族满族乡',4,'',0,1,0,0),(10894,1582,'阿尔乡镇',4,'',0,1,0,0),(10895,1583,'中部街道',4,'',0,1,0,0),(10896,1583,'北部街道',4,'',0,1,0,0),(10897,1583,'南部街道',4,'',0,1,0,0),(10898,1583,'街基街道',4,'',0,1,0,0),(10899,1583,'长营子镇',4,'',0,1,0,0),(10900,1584,'东梁街道',4,'',0,1,0,0),(10901,1584,'五龙街道',4,'',0,1,0,0),(10902,1584,'和平街道',4,'',0,1,0,0),(10903,1584,'工人村街道',4,'',0,1,0,0),(10904,1584,'平安西部街道',4,'',0,1,0,0),(10905,1584,'新兴街道',4,'',0,1,0,0),(10906,1584,'河北街道',4,'',0,1,0,0),(10907,1584,'站前街道',4,'',0,1,0,0),(10908,1584,'西山街道',4,'',0,1,0,0),(10909,1584,'西街道',4,'',0,1,0,0),(10910,1584,'韩家店镇',4,'',0,1,0,0),(10911,1585,'乌龙坝镇',4,'',0,1,0,0),(10912,1585,'六台街道',4,'',0,1,0,0),(10913,1585,'新北街道',4,'',0,1,0,0),(10914,1585,'河西镇',4,'',0,1,0,0),(10915,1585,'清河街道',4,'',0,1,0,0),(10916,1585,'艾友街道',4,'',0,1,0,0),(10917,1586,'东苑街道',4,'',0,1,0,0),(10918,1586,'中苑街道',4,'',0,1,0,0),(10919,1586,'北苑街道',4,'',0,1,0,0),(10920,1586,'华东街道',4,'',0,1,0,0),(10921,1586,'四合镇',4,'',0,1,0,0),(10922,1586,'学苑街道',4,'',0,1,0,0),(10923,1586,'西苑街道',4,'',0,1,0,0),(10924,1587,'七家子乡',4,'',0,1,0,0),(10925,1587,'东梁镇',4,'',0,1,0,0),(10926,1587,'于寺镇',4,'',0,1,0,0),(10927,1587,'伊玛图镇',4,'',0,1,0,0),(10928,1587,'佛寺镇',4,'',0,1,0,0),(10929,1587,'八家子乡',4,'',0,1,0,0),(10930,1587,'务欢池镇',4,'',0,1,0,0),(10931,1587,'化石戈乡',4,'',0,1,0,0),(10932,1587,'十家子镇',4,'',0,1,0,0),(10933,1587,'卧凤沟乡',4,'',0,1,0,0),(10934,1587,'哈达户稍乡',4,'',0,1,0,0),(10935,1587,'国华乡',4,'',0,1,0,0),(10936,1587,'塔营子乡',4,'',0,1,0,0),(10937,1587,'大五家子镇',4,'',0,1,0,0),(10938,1587,'大固本镇',4,'',0,1,0,0),(10939,1587,'大巴镇',4,'',0,1,0,0),(10940,1587,'大板镇',4,'',0,1,0,0),(10941,1587,'太平乡',4,'',0,1,0,0),(10942,1587,'富荣镇',4,'',0,1,0,0),(10943,1587,'平安地镇',4,'',0,1,0,0),(10944,1587,'建设镇',4,'',0,1,0,0),(10945,1587,'扎兰营子乡',4,'',0,1,0,0),(10946,1587,'招束沟乡',4,'',0,1,0,0),(10947,1587,'新民镇',4,'',0,1,0,0),(10948,1587,'旧庙镇',4,'',0,1,0,0),(10949,1587,'沙拉镇',4,'',0,1,0,0),(10950,1587,'泡子镇',4,'',0,1,0,0),(10951,1587,'王府镇',4,'',0,1,0,0),(10952,1587,'福兴地镇',4,'',0,1,0,0),(10953,1587,'紫都台乡',4,'',0,1,0,0),(10954,1587,'红帽子乡',4,'',0,1,0,0),(10955,1587,'老河土乡',4,'',0,1,0,0),(10956,1587,'苍土乡',4,'',0,1,0,0),(10957,1587,'蜘蛛山乡',4,'',0,1,0,0),(10958,1587,'镇',4,'',0,1,0,0),(10959,1588,'东京陵乡',4,'',0,1,0,0),(10960,1588,'东宁卫乡',4,'',0,1,0,0),(10961,1588,'新华街道',4,'',0,1,0,0),(10962,1588,'望水台街道',4,'',0,1,0,0),(10963,1588,'祁家镇',4,'',0,1,0,0),(10964,1589,'光华街道',4,'',0,1,0,0),(10965,1589,'工农街道',4,'',0,1,0,0),(10966,1589,'新村街道',4,'',0,1,0,0),(10967,1589,'曙光镇',4,'',0,1,0,0),(10968,1589,'长征街道',4,'',0,1,0,0),(10969,1590,'团山子街道',4,'',0,1,0,0),(10970,1590,'安平乡',4,'',0,1,0,0),(10971,1590,'安平街道',4,'',0,1,0,0),(10972,1590,'汤河镇',4,'',0,1,0,0),(10973,1590,'苏家街道',4,'',0,1,0,0),(10974,1591,'东兴街道',4,'',0,1,0,0),(10975,1591,'南门街道',4,'',0,1,0,0),(10976,1591,'庆阳街道',4,'',0,1,0,0),(10977,1591,'文圣街道',4,'',0,1,0,0),(10978,1591,'武圣街道',4,'',0,1,0,0),(10979,1591,'襄平街道',4,'',0,1,0,0),(10980,1592,'万宝桥街道',4,'',0,1,0,0),(10981,1592,'五星镇',4,'',0,1,0,0),(10982,1592,'佟二堡镇',4,'',0,1,0,0),(10983,1592,'古城街道',4,'',0,1,0,0),(10984,1592,'大河南镇',4,'',0,1,0,0),(10985,1592,'张台子镇',4,'',0,1,0,0),(10986,1592,'柳条寨镇',4,'',0,1,0,0),(10987,1592,'柳河子镇',4,'',0,1,0,0),(10988,1592,'沈旦堡镇',4,'',0,1,0,0),(10989,1592,'烟台街道',4,'',0,1,0,0),(10990,1592,'王家镇',4,'',0,1,0,0),(10991,1592,'罗大台镇',4,'',0,1,0,0),(10992,1592,'西大窑镇',4,'',0,1,0,0),(10993,1592,'西马峰镇',4,'',0,1,0,0),(10994,1592,'铧子镇',4,'',0,1,0,0),(10995,1592,'鸡冠山乡',4,'',0,1,0,0),(10996,1593,'卫国路街道',4,'',0,1,0,0),(10997,1593,'星火街道',4,'',0,1,0,0),(10998,1593,'站前街道',4,'',0,1,0,0),(10999,1593,'胜利街道',4,'',0,1,0,0),(11000,1593,'跃进街道',4,'',0,1,0,0),(11001,1593,'铁西街道',4,'',0,1,0,0),(11002,1594,'下达河乡',4,'',0,1,0,0),(11003,1594,'八会镇',4,'',0,1,0,0),(11004,1594,'兰家镇',4,'',0,1,0,0),(11005,1594,'刘二堡镇',4,'',0,1,0,0),(11006,1594,'吉洞峪满族乡',4,'',0,1,0,0),(11007,1594,'唐马寨镇',4,'',0,1,0,0),(11008,1594,'寒岭镇',4,'',0,1,0,0),(11009,1594,'小北河镇',4,'',0,1,0,0),(11010,1594,'小屯镇',4,'',0,1,0,0),(11011,1594,'柳壕镇',4,'',0,1,0,0),(11012,1594,'沙岭镇',4,'',0,1,0,0),(11013,1594,'河栏镇',4,'',0,1,0,0),(11014,1594,'甜水满族乡',4,'',0,1,0,0),(11015,1594,'穆家镇',4,'',0,1,0,0),(11016,1594,'隆昌镇',4,'',0,1,0,0),(11017,1594,'首山镇',4,'',0,1,0,0),(11018,1594,'黄泥洼镇',4,'',0,1,0,0),(11019,1595,'于楼街道',4,'',0,1,0,0),(11020,1595,'兴海街道',4,'',0,1,0,0),(11021,1595,'兴盛街道',4,'',0,1,0,0),(11022,1595,'兴隆街道',4,'',0,1,0,0),(11023,1595,'创新街道',4,'',0,1,0,0),(11024,1595,'友谊街道',4,'',0,1,0,0),(11025,1595,'平安街道',4,'',0,1,0,0),(11026,1595,'振兴街道',4,'',0,1,0,0),(11027,1595,'新工街道',4,'',0,1,0,0),(11028,1595,'新生街道',4,'',0,1,0,0),(11029,1595,'曙光街道',4,'',0,1,0,0),(11030,1595,'欢喜街道',4,'',0,1,0,0),(11031,1595,'沈采街道',4,'',0,1,0,0),(11032,1595,'渤海街道',4,'',0,1,0,0),(11033,1595,'红村街道',4,'',0,1,0,0),(11034,1595,'茨采街道',4,'',0,1,0,0),(11035,1595,'锦采街道',4,'',0,1,0,0),(11036,1595,'高升街道',4,'',0,1,0,0),(11037,1596,'东风街道',4,'',0,1,0,0),(11038,1596,'化工街道',4,'',0,1,0,0),(11039,1596,'双盛街道',4,'',0,1,0,0),(11040,1596,'建设街道',4,'',0,1,0,0),(11041,1596,'石油街道',4,'',0,1,0,0),(11042,1596,'红旗街道',4,'',0,1,0,0),(11043,1596,'胜利街道',4,'',0,1,0,0),(11044,1596,'辽河街道',4,'',0,1,0,0),(11045,1596,'铁东街道',4,'',0,1,0,0),(11046,1597,'东风镇',4,'',0,1,0,0),(11047,1597,'二界沟镇',4,'',0,1,0,0),(11048,1597,'唐家乡',4,'',0,1,0,0),(11049,1597,'大洼镇',4,'',0,1,0,0),(11050,1597,'平安乡',4,'',0,1,0,0),(11051,1597,'新兴镇',4,'',0,1,0,0),(11052,1597,'新开镇',4,'',0,1,0,0),(11053,1597,'新立镇',4,'',0,1,0,0),(11054,1597,'清水镇',4,'',0,1,0,0),(11055,1597,'王家乡',4,'',0,1,0,0),(11056,1597,'田家镇',4,'',0,1,0,0),(11057,1597,'田庄台镇',4,'',0,1,0,0),(11058,1597,'荣兴朝鲜族乡',4,'',0,1,0,0),(11059,1597,'西安镇',4,'',0,1,0,0),(11060,1597,'赵圈河乡',4,'',0,1,0,0),(11061,1598,'东郭镇',4,'',0,1,0,0),(11062,1598,'古城子镇',4,'',0,1,0,0),(11063,1598,'吴家乡',4,'',0,1,0,0),(11064,1598,'坝墙子镇',4,'',0,1,0,0),(11065,1598,'大荒乡',4,'',0,1,0,0),(11066,1598,'太平镇',4,'',0,1,0,0),(11067,1598,'沙岭镇',4,'',0,1,0,0),(11068,1598,'甜水乡',4,'',0,1,0,0),(11069,1598,'石新镇',4,'',0,1,0,0),(11070,1598,'羊圈子镇',4,'',0,1,0,0),(11071,1598,'胡家镇',4,'',0,1,0,0),(11072,1598,'陆家乡',4,'',0,1,0,0),(11073,1598,'陈家乡',4,'',0,1,0,0),(11074,1598,'高升镇',4,'',0,1,0,0),(11075,1599,'上肥地满族乡',4,'',0,1,0,0),(11076,1599,'下肥地满族乡',4,'',0,1,0,0),(11077,1599,'业民镇',4,'',0,1,0,0),(11078,1599,'中固镇',4,'',0,1,0,0),(11079,1599,'八宝镇',4,'',0,1,0,0),(11080,1599,'八棵树镇',4,'',0,1,0,0),(11081,1599,'兴开街道',4,'',0,1,0,0),(11082,1599,'城东乡',4,'',0,1,0,0),(11083,1599,'威远堡镇',4,'',0,1,0,0),(11084,1599,'庆云堡镇',4,'',0,1,0,0),(11085,1599,'新城街道',4,'',0,1,0,0),(11086,1599,'李家台乡',4,'',0,1,0,0),(11087,1599,'松山堡乡',4,'',0,1,0,0),(11088,1599,'林丰满族乡',4,'',0,1,0,0),(11089,1599,'老城街道',4,'',0,1,0,0),(11090,1599,'莲花镇',4,'',0,1,0,0),(11091,1599,'金沟子镇',4,'',0,1,0,0),(11092,1599,'靠山镇',4,'',0,1,0,0),(11093,1599,'马家寨乡',4,'',0,1,0,0),(11094,1599,'黄旗寨满族乡',4,'',0,1,0,0),(11095,1600,'七家子镇',4,'',0,1,0,0),(11096,1600,'三江口镇',4,'',0,1,0,0),(11097,1600,'下二台乡',4,'',0,1,0,0),(11098,1600,'东嘎镇',4,'',0,1,0,0),(11099,1600,'亮中桥镇',4,'',0,1,0,0),(11100,1600,'傅家镇',4,'',0,1,0,0),(11101,1600,'八面城镇',4,'',0,1,0,0),(11102,1600,'前双井镇',4,'',0,1,0,0),(11103,1600,'十八家子乡',4,'',0,1,0,0),(11104,1600,'双庙子镇',4,'',0,1,0,0),(11105,1600,'古榆树镇',4,'',0,1,0,0),(11106,1600,'后窑乡',4,'',0,1,0,0),(11107,1600,'四合镇',4,'',0,1,0,0),(11108,1600,'四面城镇',4,'',0,1,0,0),(11109,1600,'大兴乡',4,'',0,1,0,0),(11110,1600,'大四家子乡',4,'',0,1,0,0),(11111,1600,'大洼镇',4,'',0,1,0,0),(11112,1600,'太平乡',4,'',0,1,0,0),(11113,1600,'头道镇',4,'',0,1,0,0),(11114,1600,'宝力镇',4,'',0,1,0,0),(11115,1600,'平安堡乡',4,'',0,1,0,0),(11116,1600,'昌图镇',4,'',0,1,0,0),(11117,1600,'曲家店乡',4,'',0,1,0,0),(11118,1600,'朝阳镇',4,'',0,1,0,0),(11119,1600,'毛家店镇',4,'',0,1,0,0),(11120,1600,'泉头镇',4,'',0,1,0,0),(11121,1600,'老四平镇',4,'',0,1,0,0),(11122,1600,'老城镇',4,'',0,1,0,0),(11123,1600,'通江口乡',4,'',0,1,0,0),(11124,1600,'金家镇',4,'',0,1,0,0),(11125,1600,'长发乡',4,'',0,1,0,0),(11126,1600,'马仲河镇',4,'',0,1,0,0),(11127,1600,'雌鹭树镇',4,'',0,1,0,0),(11128,1601,'向阳街道',4,'',0,1,0,0),(11129,1601,'张相镇',4,'',0,1,0,0),(11130,1601,'杨木林子乡',4,'',0,1,0,0),(11131,1601,'红旗街道',4,'',0,1,0,0),(11132,1601,'聂家满族乡',4,'',0,1,0,0),(11133,1602,'凉泉镇',4,'',0,1,0,0),(11134,1602,'和隆满族乡',4,'',0,1,0,0),(11135,1602,'天德镇',4,'',0,1,0,0),(11136,1602,'安民镇',4,'',0,1,0,0),(11137,1602,'平岗镇',4,'',0,1,0,0),(11138,1602,'德兴满族乡',4,'',0,1,0,0),(11139,1602,'成平满族乡',4,'',0,1,0,0),(11140,1602,'房木镇',4,'',0,1,0,0),(11141,1602,'振兴镇',4,'',0,1,0,0),(11142,1602,'明德满族乡',4,'',0,1,0,0),(11143,1602,'更刻乡',4,'',0,1,0,0),(11144,1602,'柏榆乡',4,'',0,1,0,0),(11145,1602,'营厂满族乡',4,'',0,1,0,0),(11146,1602,'西丰镇',4,'',0,1,0,0),(11147,1602,'郜家店镇',4,'',0,1,0,0),(11148,1602,'金星满族乡',4,'',0,1,0,0),(11149,1602,'钓鱼乡',4,'',0,1,0,0),(11150,1602,'陶然乡',4,'',0,1,0,0),(11151,1603,'兀术街街道',4,'',0,1,0,0),(11152,1603,'大明镇',4,'',0,1,0,0),(11153,1603,'晓南镇',4,'',0,1,0,0),(11154,1603,'晓明镇',4,'',0,1,0,0),(11155,1603,'调兵山街道',4,'',0,1,0,0),(11156,1604,'凡河镇',4,'',0,1,0,0),(11157,1604,'双井子乡',4,'',0,1,0,0),(11158,1604,'大甸子镇',4,'',0,1,0,0),(11159,1604,'平顶堡镇',4,'',0,1,0,0),(11160,1604,'新台子镇',4,'',0,1,0,0),(11161,1604,'李千户乡',4,'',0,1,0,0),(11162,1604,'横道河子满族乡',4,'',0,1,0,0),(11163,1604,'熊官屯乡',4,'',0,1,0,0),(11164,1604,'白旗寨满族乡',4,'',0,1,0,0),(11165,1604,'腰堡镇',4,'',0,1,0,0),(11166,1604,'蔡牛乡',4,'',0,1,0,0),(11167,1604,'镇西堡镇',4,'',0,1,0,0),(11168,1604,'阿吉镇',4,'',0,1,0,0),(11169,1604,'鸡冠山乡',4,'',0,1,0,0),(11170,1605,'岭东街道',4,'',0,1,0,0),(11171,1605,'工人街道',4,'',0,1,0,0),(11172,1605,'柴河街道',4,'',0,1,0,0),(11173,1605,'红旗街道',4,'',0,1,0,0),(11174,1605,'铁西街道',4,'',0,1,0,0),(11175,1605,'铜钟街道',4,'',0,1,0,0),(11176,1605,'龙山乡',4,'',0,1,0,0),(11177,1606,'万元店镇',4,'',0,1,0,0),(11178,1606,'三十家子镇',4,'',0,1,0,0),(11179,1606,'三家子蒙古族乡',4,'',0,1,0,0),(11180,1606,'三道河子乡',4,'',0,1,0,0),(11181,1606,'东城街道',4,'',0,1,0,0),(11182,1606,'佛爷洞乡',4,'',0,1,0,0),(11183,1606,'凌北镇',4,'',0,1,0,0),(11184,1606,'刀尔登镇',4,'',0,1,0,0),(11185,1606,'刘杖子乡',4,'',0,1,0,0),(11186,1606,'北炉乡',4,'',0,1,0,0),(11187,1606,'北街街道',4,'',0,1,0,0),(11188,1606,'南街街道',4,'',0,1,0,0),(11189,1606,'四合当镇',4,'',0,1,0,0),(11190,1606,'四官营子镇',4,'',0,1,0,0),(11191,1606,'城关镇',4,'',0,1,0,0),(11192,1606,'宋杖子镇',4,'',0,1,0,0),(11193,1606,'小城子镇',4,'',0,1,0,0),(11194,1606,'杨杖子镇',4,'',0,1,0,0),(11195,1606,'松岭子镇',4,'',0,1,0,0),(11196,1606,'沟门子镇',4,'',0,1,0,0),(11197,1606,'热水汤街道',4,'',0,1,0,0),(11198,1606,'牛营子乡',4,'',0,1,0,0),(11199,1606,'瓦房店乡',4,'',0,1,0,0),(11200,1606,'红山街道',4,'',0,1,0,0),(11201,1607,'三宝乡',4,'',0,1,0,0),(11202,1607,'三宝营乡',4,'',0,1,0,0),(11203,1607,'三宝街道',4,'',0,1,0,0),(11204,1607,'上园镇',4,'',0,1,0,0),(11205,1607,'东官营乡',4,'',0,1,0,0),(11206,1607,'五间房镇',4,'',0,1,0,0),(11207,1607,'冠山街道',4,'',0,1,0,0),(11208,1607,'凉水河蒙古族乡',4,'',0,1,0,0),(11209,1607,'北四家乡',4,'',0,1,0,0),(11210,1607,'北塔子乡',4,'',0,1,0,0),(11211,1607,'南八家子乡',4,'',0,1,0,0),(11212,1607,'南山街道',4,'',0,1,0,0),(11213,1607,'台吉营乡',4,'',0,1,0,0),(11214,1607,'台吉街道',4,'',0,1,0,0),(11215,1607,'台吉镇',4,'',0,1,0,0),(11216,1607,'哈尔脑乡',4,'',0,1,0,0),(11217,1607,'城关街道',4,'',0,1,0,0),(11218,1607,'大三家子乡',4,'',0,1,0,0),(11219,1607,'大板镇',4,'',0,1,0,0),(11220,1607,'娄家店乡',4,'',0,1,0,0),(11221,1607,'宝国老镇',4,'',0,1,0,0),(11222,1607,'小塔子乡',4,'',0,1,0,0),(11223,1607,'巴图营乡',4,'',0,1,0,0),(11224,1607,'桥北街道',4,'',0,1,0,0),(11225,1607,'泉巨永乡',4,'',0,1,0,0),(11226,1607,'章吉营乡',4,'',0,1,0,0),(11227,1607,'蒙古营乡',4,'',0,1,0,0),(11228,1607,'西官营镇',4,'',0,1,0,0),(11229,1607,'长皋乡',4,'',0,1,0,0),(11230,1607,'马友营蒙古族乡',4,'',0,1,0,0),(11231,1607,'黑城子镇',4,'',0,1,0,0),(11232,1607,'龙潭乡',4,'',0,1,0,0),(11233,1608,'他拉皋镇',4,'',0,1,0,0),(11234,1608,'光明街道',4,'',0,1,0,0),(11235,1608,'凌凤街道',4,'',0,1,0,0),(11236,1608,'凌河街道',4,'',0,1,0,0),(11237,1608,'前进街道',4,'',0,1,0,0),(11238,1608,'北塔街道',4,'',0,1,0,0),(11239,1608,'南塔街道',4,'',0,1,0,0),(11240,1608,'孙家湾乡',4,'',0,1,0,0),(11241,1608,'桃花吐镇',4,'',0,1,0,0),(11242,1608,'燕北街道',4,'',0,1,0,0),(11243,1608,'站南街道',4,'',0,1,0,0),(11244,1608,'红旗街道',4,'',0,1,0,0),(11245,1608,'长宝营子乡',4,'',0,1,0,0),(11246,1608,'龙山街道',4,'',0,1,0,0),(11247,1609,'东哨乡',4,'',0,1,0,0),(11248,1609,'中三家镇',4,'',0,1,0,0),(11249,1609,'公营子镇',4,'',0,1,0,0),(11250,1609,'六官营子镇',4,'',0,1,0,0),(11251,1609,'十二德堡乡',4,'',0,1,0,0),(11252,1609,'南公营子镇',4,'',0,1,0,0),(11253,1609,'南哨镇',4,'',0,1,0,0),(11254,1609,'卧虎沟乡',4,'',0,1,0,0),(11255,1609,'坤都营子乡',4,'',0,1,0,0),(11256,1609,'大城子镇',4,'',0,1,0,0),(11257,1609,'山咀子镇',4,'',0,1,0,0),(11258,1609,'平房子镇',4,'',0,1,0,0),(11259,1609,'水泉乡',4,'',0,1,0,0),(11260,1609,'白塔子镇',4,'',0,1,0,0),(11261,1609,'羊角沟乡',4,'',0,1,0,0),(11262,1609,'老爷庙镇',4,'',0,1,0,0),(11263,1609,'草场乡',4,'',0,1,0,0),(11264,1610,'万寿',4,'',0,1,0,0),(11265,1610,'三家蒙古族',4,'',0,1,0,0),(11266,1610,'义成功',4,'',0,1,0,0),(11267,1610,'八家',4,'',0,1,0,0),(11268,1610,'叶柏寿',4,'',0,1,0,0),(11269,1610,'哈拉道',4,'',0,1,0,0),(11270,1610,'喀喇沁',4,'',0,1,0,0),(11271,1610,'太平庄',4,'',0,1,0,0),(11272,1610,'奎德素',4,'',0,1,0,0),(11273,1610,'富山',4,'',0,1,0,0),(11274,1610,'小塘',4,'',0,1,0,0),(11275,1610,'建平',4,'',0,1,0,0),(11276,1610,'张家营子',4,'',0,1,0,0),(11277,1610,'昌隆永',4,'',0,1,0,0),(11278,1610,'朱力科',4,'',0,1,0,0),(11279,1610,'杨树岭',4,'',0,1,0,0),(11280,1610,'榆树林子',4,'',0,1,0,0),(11281,1610,'沙海',4,'',0,1,0,0),(11282,1610,'深井',4,'',0,1,0,0),(11283,1610,'烧锅营子',4,'',0,1,0,0),(11284,1610,'热水',4,'',0,1,0,0),(11285,1610,'白山',4,'',0,1,0,0),(11286,1610,'罗福沟',4,'',0,1,0,0),(11287,1610,'老官地',4,'',0,1,0,0),(11288,1610,'青峰',4,'',0,1,0,0),(11289,1610,'青松岭',4,'',0,1,0,0),(11290,1610,'马场',4,'',0,1,0,0),(11291,1610,'黑水',4,'',0,1,0,0),(11292,1611,'七道岭乡',4,'',0,1,0,0),(11293,1611,'东大屯乡',4,'',0,1,0,0),(11294,1611,'东大道乡',4,'',0,1,0,0),(11295,1611,'乌兰河硕蒙古族乡',4,'',0,1,0,0),(11296,1611,'二十家子镇',4,'',0,1,0,0),(11297,1611,'六家子镇',4,'',0,1,0,0),(11298,1611,'北四家子乡',4,'',0,1,0,0),(11299,1611,'北沟门子乡',4,'',0,1,0,0),(11300,1611,'南双庙乡',4,'',0,1,0,0),(11301,1611,'古山子乡',4,'',0,1,0,0),(11302,1611,'台子乡',4,'',0,1,0,0),(11303,1611,'大庙镇',4,'',0,1,0,0),(11304,1611,'尚志乡',4,'',0,1,0,0),(11305,1611,'木头城子镇',4,'',0,1,0,0),(11306,1611,'杨树湾乡',4,'',0,1,0,0),(11307,1611,'松岭门蒙古族乡',4,'',0,1,0,0),(11308,1611,'柳城镇',4,'',0,1,0,0),(11309,1611,'根德营子乡',4,'',0,1,0,0),(11310,1611,'波罗赤镇',4,'',0,1,0,0),(11311,1611,'王营子乡',4,'',0,1,0,0),(11312,1611,'瓦房子镇',4,'',0,1,0,0),(11313,1611,'羊山镇',4,'',0,1,0,0),(11314,1611,'胜利乡',4,'',0,1,0,0),(11315,1611,'长在营子乡',4,'',0,1,0,0),(11316,1611,'黑牛营子乡',4,'',0,1,0,0),(11317,1612,'七道泉子镇',4,'',0,1,0,0),(11318,1612,'半拉山街道',4,'',0,1,0,0),(11319,1612,'召都巴镇',4,'',0,1,0,0),(11320,1612,'向阳街道',4,'',0,1,0,0),(11321,1612,'大平房镇',4,'',0,1,0,0),(11322,1612,'新华街道',4,'',0,1,0,0),(11323,1612,'联合乡',4,'',0,1,0,0),(11324,1612,'西大营子镇',4,'',0,1,0,0),(11325,1612,'边杖子乡',4,'',0,1,0,0),(11326,1612,'马山街道',4,'',0,1,0,0),(11327,1612,'龙泉街道',4,'',0,1,0,0),(11328,1613,'三道沟满族乡',4,'',0,1,0,0),(11329,1613,'东辛庄镇',4,'',0,1,0,0),(11330,1613,'元台子满族乡',4,'',0,1,0,0),(11331,1613,'刘台子满族乡',4,'',0,1,0,0),(11332,1613,'华山街道',4,'',0,1,0,0),(11333,1613,'南大山满族乡',4,'',0,1,0,0),(11334,1613,'双树乡',4,'',0,1,0,0),(11335,1613,'古城街道',4,'',0,1,0,0),(11336,1613,'四家屯街道',4,'',0,1,0,0),(11337,1613,'围屏满族乡',4,'',0,1,0,0),(11338,1613,'城东街道',4,'',0,1,0,0),(11339,1613,'大寨满族乡',4,'',0,1,0,0),(11340,1613,'宁远街道',4,'',0,1,0,0),(11341,1613,'旧门满族乡',4,'',0,1,0,0),(11342,1613,'曹庄镇',4,'',0,1,0,0),(11343,1613,'望海满族乡',4,'',0,1,0,0),(11344,1613,'沙后所镇',4,'',0,1,0,0),(11345,1613,'海滨满族乡',4,'',0,1,0,0),(11346,1613,'温泉街道',4,'',0,1,0,0),(11347,1613,'白塔满族乡',4,'',0,1,0,0),(11348,1613,'碱厂满族乡',4,'',0,1,0,0),(11349,1613,'红崖子满族乡',4,'',0,1,0,0),(11350,1613,'羊安满族乡',4,'',0,1,0,0),(11351,1613,'药王满族乡',4,'',0,1,0,0),(11352,1613,'菊花岛乡',4,'',0,1,0,0),(11353,1613,'郭家镇',4,'',0,1,0,0),(11354,1613,'钓鱼台街道',4,'',0,1,0,0),(11355,1613,'高家岭满族乡',4,'',0,1,0,0),(11356,1614,'三家子街道',4,'',0,1,0,0),(11357,1614,'九龙街道',4,'',0,1,0,0),(11358,1614,'小凌河街道',4,'',0,1,0,0),(11359,1614,'暖池塘镇',4,'',0,1,0,0),(11360,1614,'沙锅屯乡',4,'',0,1,0,0),(11361,1614,'沙锅屯街道',4,'',0,1,0,0),(11362,1614,'缸窑岭镇',4,'',0,1,0,0),(11363,1614,'苇子沟街道',4,'',0,1,0,0),(11364,1614,'赵家屯街道',4,'',0,1,0,0),(11365,1614,'邱皮沟街道',4,'',0,1,0,0),(11366,1614,'黄土坎乡',4,'',0,1,0,0),(11367,1615,'二道湾子蒙古族乡',4,'',0,1,0,0),(11368,1615,'八家子镇',4,'',0,1,0,0),(11369,1615,'养马甸子乡',4,'',0,1,0,0),(11370,1615,'和尚房子乡',4,'',0,1,0,0),(11371,1615,'喇嘛洞镇',4,'',0,1,0,0),(11372,1615,'大屯镇',4,'',0,1,0,0),(11373,1615,'头道营子乡',4,'',0,1,0,0),(11374,1615,'娘娘庙乡',4,'',0,1,0,0),(11375,1615,'小德营子乡',4,'',0,1,0,0),(11376,1615,'巴什罕乡',4,'',0,1,0,0),(11377,1615,'建昌镇',4,'',0,1,0,0),(11378,1615,'新开岭乡',4,'',0,1,0,0),(11379,1615,'杨树湾子乡',4,'',0,1,0,0),(11380,1615,'汤神庙镇',4,'',0,1,0,0),(11381,1615,'牤牛营子乡',4,'',0,1,0,0),(11382,1615,'王宝营子乡',4,'',0,1,0,0),(11383,1615,'玲珑塔镇',4,'',0,1,0,0),(11384,1615,'石佛乡',4,'',0,1,0,0),(11385,1615,'素珠营子乡',4,'',0,1,0,0),(11386,1615,'老达杖子乡',4,'',0,1,0,0),(11387,1615,'药王庙镇',4,'',0,1,0,0),(11388,1615,'西碱厂乡',4,'',0,1,0,0),(11389,1615,'要路沟乡',4,'',0,1,0,0),(11390,1615,'谷杖子乡',4,'',0,1,0,0),(11391,1615,'贺杖子乡',4,'',0,1,0,0),(11392,1615,'雷家店乡',4,'',0,1,0,0),(11393,1615,'魏家岭乡',4,'',0,1,0,0),(11394,1615,'黑山科乡',4,'',0,1,0,0),(11395,1616,'万家镇',4,'',0,1,0,0),(11396,1616,'前卫镇',4,'',0,1,0,0),(11397,1616,'前所镇',4,'',0,1,0,0),(11398,1616,'加碑岩乡',4,'',0,1,0,0),(11399,1616,'城郊乡',4,'',0,1,0,0),(11400,1616,'塔山屯镇',4,'',0,1,0,0),(11401,1616,'大王庙镇',4,'',0,1,0,0),(11402,1616,'宽帮镇',4,'',0,1,0,0),(11403,1616,'小庄子镇',4,'',0,1,0,0),(11404,1616,'明水满族乡',4,'',0,1,0,0),(11405,1616,'李家堡乡',4,'',0,1,0,0),(11406,1616,'永安堡乡',4,'',0,1,0,0),(11407,1616,'沙河镇',4,'',0,1,0,0),(11408,1616,'王宝镇',4,'',0,1,0,0),(11409,1616,'秋子沟乡',4,'',0,1,0,0),(11410,1616,'绥中镇',4,'',0,1,0,0),(11411,1616,'网户满族乡',4,'',0,1,0,0),(11412,1616,'范家满族乡',4,'',0,1,0,0),(11413,1616,'荒地镇',4,'',0,1,0,0),(11414,1616,'葛家满族乡',4,'',0,1,0,0),(11415,1616,'西平坡满族乡',4,'',0,1,0,0),(11416,1616,'西庙子镇',4,'',0,1,0,0),(11417,1616,'高台镇',4,'',0,1,0,0),(11418,1616,'高岭镇',4,'',0,1,0,0),(11419,1616,'高甸子满族乡',4,'',0,1,0,0),(11420,1617,'一〇八街道',4,'',0,1,0,0),(11421,1617,'兴工街道',4,'',0,1,0,0),(11422,1617,'化工街道',4,'',0,1,0,0),(11423,1617,'化机街道',4,'',0,1,0,0),(11424,1617,'台集屯镇',4,'',0,1,0,0),(11425,1617,'塔山乡',4,'',0,1,0,0),(11426,1617,'大兴乡',4,'',0,1,0,0),(11427,1617,'孤竹营子乡',4,'',0,1,0,0),(11428,1617,'寺儿堡镇',4,'',0,1,0,0),(11429,1617,'山神庙子乡',4,'',0,1,0,0),(11430,1617,'张相公屯乡',4,'',0,1,0,0),(11431,1617,'新台门镇',4,'',0,1,0,0),(11432,1617,'杨家杖子街道',4,'',0,1,0,0),(11433,1617,'杨郊乡',4,'',0,1,0,0),(11434,1617,'水泥街道',4,'',0,1,0,0),(11435,1617,'沙河营乡',4,'',0,1,0,0),(11436,1617,'渤海街道',4,'',0,1,0,0),(11437,1617,'白马石乡',4,'',0,1,0,0),(11438,1617,'石油街道',4,'',0,1,0,0),(11439,1617,'站前街道',4,'',0,1,0,0),(11440,1617,'虹螺岘镇',4,'',0,1,0,0),(11441,1617,'连山街道',4,'',0,1,0,0),(11442,1617,'金星镇',4,'',0,1,0,0),(11443,1617,'钢屯镇',4,'',0,1,0,0),(11444,1617,'锦郊街道',4,'',0,1,0,0),(11445,1617,'高桥镇',4,'',0,1,0,0),(11446,1618,'东街道',4,'',0,1,0,0),(11447,1618,'北港街道',4,'',0,1,0,0),(11448,1618,'双龙街道',4,'',0,1,0,0),(11449,1618,'望海寺街道',4,'',0,1,0,0),(11450,1618,'滨海街道',4,'',0,1,0,0),(11451,1618,'玉皇街道',4,'',0,1,0,0),(11452,1618,'葫芦岛街道',4,'',0,1,0,0),(11453,1618,'西街道',4,'',0,1,0,0),(11454,1618,'连湾街道',4,'',0,1,0,0),(11455,1618,'龙湾街道',4,'',0,1,0,0),(11456,1619,'上河湾镇',4,'',0,1,0,0),(11457,1619,'九台街道',4,'',0,1,0,0),(11458,1619,'九郊街道',4,'',0,1,0,0),(11459,1619,'兴隆镇',4,'',0,1,0,0),(11460,1619,'其塔木镇',4,'',0,1,0,0),(11461,1619,'土们岭镇',4,'',0,1,0,0),(11462,1619,'城子街镇',4,'',0,1,0,0),(11463,1619,'沐石河镇',4,'',0,1,0,0),(11464,1619,'波泥河镇',4,'',0,1,0,0),(11465,1619,'纪家镇',4,'',0,1,0,0),(11466,1619,'胡家回族乡',4,'',0,1,0,0),(11467,1619,'苇子沟镇',4,'',0,1,0,0),(11468,1619,'莽卡满族乡',4,'',0,1,0,0),(11469,1619,'营城街道',4,'',0,1,0,0),(11470,1619,'西营城镇',4,'',0,1,0,0),(11471,1620,'东方广场街道',4,'',0,1,0,0),(11472,1620,'东湖镇',4,'',0,1,0,0),(11473,1620,'东盛街道',4,'',0,1,0,0),(11474,1620,'东站街道',4,'',0,1,0,0),(11475,1620,'八里堡街道',4,'',0,1,0,0),(11476,1620,'劝农山镇',4,'',0,1,0,0),(11477,1620,'卡伦湖镇',4,'',0,1,0,0),(11478,1620,'吉林街道',4,'',0,1,0,0),(11479,1620,'四家乡',4,'',0,1,0,0),(11480,1620,'泉眼镇',4,'',0,1,0,0),(11481,1620,'英俊镇',4,'',0,1,0,0),(11482,1620,'荣光街道',4,'',0,1,0,0),(11483,1620,'远达街道',4,'',0,1,0,0),(11484,1620,'龙嘉镇',4,'',0,1,0,0),(11485,1621,'万金塔乡',4,'',0,1,0,0),(11486,1621,'万顺乡',4,'',0,1,0,0),(11487,1621,'三岗乡',4,'',0,1,0,0),(11488,1621,'三盛玉镇',4,'',0,1,0,0),(11489,1621,'伏龙泉镇',4,'',0,1,0,0),(11490,1621,'农安镇',4,'',0,1,0,0),(11491,1621,'前岗乡',4,'',0,1,0,0),(11492,1621,'华家镇',4,'',0,1,0,0),(11493,1621,'哈拉海镇',4,'',0,1,0,0),(11494,1621,'小城子乡',4,'',0,1,0,0),(11495,1621,'巴吉垒镇',4,'',0,1,0,0),(11496,1621,'开安镇',4,'',0,1,0,0),(11497,1621,'新农乡',4,'',0,1,0,0),(11498,1621,'杨树林乡',4,'',0,1,0,0),(11499,1621,'永安乡',4,'',0,1,0,0),(11500,1621,'烧锅镇',4,'',0,1,0,0),(11501,1621,'青山口乡',4,'',0,1,0,0),(11502,1621,'靠山镇',4,'',0,1,0,0),(11503,1621,'高家店镇',4,'',0,1,0,0),(11504,1621,'黄鱼圈乡',4,'',0,1,0,0),(11505,1621,'龙王乡',4,'',0,1,0,0),(11506,1622,'临河街道',4,'',0,1,0,0),(11507,1622,'全安街道',4,'',0,1,0,0),(11508,1622,'净月街道',4,'',0,1,0,0),(11509,1622,'南岭街道',4,'',0,1,0,0),(11510,1622,'幸福乡',4,'',0,1,0,0),(11511,1622,'新春街道',4,'',0,1,0,0),(11512,1622,'新湖镇',4,'',0,1,0,0),(11513,1622,'新立城镇',4,'',0,1,0,0),(11514,1622,'明珠街道',4,'',0,1,0,0),(11515,1622,'曙光街道',4,'',0,1,0,0),(11516,1622,'桃源街道',4,'',0,1,0,0),(11517,1622,'民康街道',4,'',0,1,0,0),(11518,1622,'永兴街道',4,'',0,1,0,0),(11519,1622,'永吉街道',4,'',0,1,0,0),(11520,1622,'玉潭镇',4,'',0,1,0,0),(11521,1622,'自强街道',4,'',0,1,0,0),(11522,1622,'长通街道',4,'',0,1,0,0),(11523,1622,'鸿城街道',4,'',0,1,0,0),(11524,1623,'云山街道',4,'',0,1,0,0),(11525,1623,'双营子回族乡',4,'',0,1,0,0),(11526,1623,'太平镇',4,'',0,1,0,0),(11527,1623,'奢岭街道',4,'',0,1,0,0),(11528,1623,'山河街道',4,'',0,1,0,0),(11529,1623,'平湖街道',4,'',0,1,0,0),(11530,1623,'鹿乡镇',4,'',0,1,0,0),(11531,1623,'齐家镇',4,'',0,1,0,0),(11532,1624,'万宝镇',4,'',0,1,0,0),(11533,1624,'东广街道',4,'',0,1,0,0),(11534,1624,'兰家镇',4,'',0,1,0,0),(11535,1624,'兴业街道',4,'',0,1,0,0),(11536,1624,'兴隆山镇',4,'',0,1,0,0),(11537,1624,'凯旋街道',4,'',0,1,0,0),(11538,1624,'南广街道',4,'',0,1,0,0),(11539,1624,'合隆镇',4,'',0,1,0,0),(11540,1624,'团山街道',4,'',0,1,0,0),(11541,1624,'奋进乡',4,'',0,1,0,0),(11542,1624,'新发街道',4,'',0,1,0,0),(11543,1624,'柳影街道',4,'',0,1,0,0),(11544,1624,'站前街道',4,'',0,1,0,0),(11545,1624,'米沙子镇',4,'',0,1,0,0),(11546,1624,'群英街道',4,'',0,1,0,0),(11547,1625,'五台乡',4,'',0,1,0,0),(11548,1625,'同太乡',4,'',0,1,0,0),(11549,1625,'夏家店街道',4,'',0,1,0,0),(11550,1625,'大房身镇',4,'',0,1,0,0),(11551,1625,'大青嘴镇',4,'',0,1,0,0),(11552,1625,'天台镇',4,'',0,1,0,0),(11553,1625,'岔路口镇',4,'',0,1,0,0),(11554,1625,'布海镇',4,'',0,1,0,0),(11555,1625,'建设街道',4,'',0,1,0,0),(11556,1625,'惠发街道',4,'',0,1,0,0),(11557,1625,'朝阳乡',4,'',0,1,0,0),(11558,1625,'朱城子镇',4,'',0,1,0,0),(11559,1625,'松花江镇',4,'',0,1,0,0),(11560,1625,'胜利街道',4,'',0,1,0,0),(11561,1625,'菜园子镇',4,'',0,1,0,0),(11562,1625,'边岗乡',4,'',0,1,0,0),(11563,1625,'达家沟镇',4,'',0,1,0,0),(11564,1625,'郭家镇',4,'',0,1,0,0),(11565,1626,'乐山镇',4,'',0,1,0,0),(11566,1626,'南湖街道',4,'',0,1,0,0),(11567,1626,'南站街道',4,'',0,1,0,0),(11568,1626,'双德乡',4,'',0,1,0,0),(11569,1626,'富锋镇',4,'',0,1,0,0),(11570,1626,'桂林街道',4,'',0,1,0,0),(11571,1626,'永昌街道',4,'',0,1,0,0),(11572,1626,'永春镇',4,'',0,1,0,0),(11573,1626,'清和街道',4,'',0,1,0,0),(11574,1626,'湖西街道',4,'',0,1,0,0),(11575,1626,'红旗街道',4,'',0,1,0,0),(11576,1626,'重庆街道',4,'',0,1,0,0),(11577,1627,'五棵树镇',4,'',0,1,0,0),(11578,1627,'保寿镇',4,'',0,1,0,0),(11579,1627,'先锋乡',4,'',0,1,0,0),(11580,1627,'八号镇',4,'',0,1,0,0),(11581,1627,'刘家镇',4,'',0,1,0,0),(11582,1627,'华昌街道',4,'',0,1,0,0),(11583,1627,'向阳镇',4,'',0,1,0,0),(11584,1627,'土桥镇',4,'',0,1,0,0),(11585,1627,'城发乡',4,'',0,1,0,0),(11586,1627,'城郊街道',4,'',0,1,0,0),(11587,1627,'培英街道',4,'',0,1,0,0),(11588,1627,'大坡镇',4,'',0,1,0,0),(11589,1627,'大岭镇',4,'',0,1,0,0),(11590,1627,'太安乡',4,'',0,1,0,0),(11591,1627,'延和朝鲜族乡',4,'',0,1,0,0),(11592,1627,'弓棚镇',4,'',0,1,0,0),(11593,1627,'恩育乡',4,'',0,1,0,0),(11594,1627,'新庄镇',4,'',0,1,0,0),(11595,1627,'新立镇',4,'',0,1,0,0),(11596,1627,'正阳街道',4,'',0,1,0,0),(11597,1627,'泗河镇',4,'',0,1,0,0),(11598,1627,'环城乡',4,'',0,1,0,0),(11599,1627,'秀水镇',4,'',0,1,0,0),(11600,1627,'红星乡',4,'',0,1,0,0),(11601,1627,'育民乡',4,'',0,1,0,0),(11602,1627,'闵家镇',4,'',0,1,0,0),(11603,1627,'青山乡',4,'',0,1,0,0),(11604,1627,'黑林镇',4,'',0,1,0,0),(11605,1628,'东风街道',4,'',0,1,0,0),(11606,1628,'合心镇',4,'',0,1,0,0),(11607,1628,'城西镇',4,'',0,1,0,0),(11608,1628,'春城街道',4,'',0,1,0,0),(11609,1628,'普阳街道',4,'',0,1,0,0),(11610,1628,'正阳街道',4,'',0,1,0,0),(11611,1628,'西新镇',4,'',0,1,0,0),(11612,1628,'铁西街道',4,'',0,1,0,0),(11613,1628,'锦程街道',4,'',0,1,0,0),(11614,1628,'青年路街道',4,'',0,1,0,0),(11615,1629,'丰满乡',4,'',0,1,0,0),(11616,1629,'丰满街道',4,'',0,1,0,0),(11617,1629,'前二道乡',4,'',0,1,0,0),(11618,1629,'大长屯街道',4,'',0,1,0,0),(11619,1629,'小白山乡',4,'',0,1,0,0),(11620,1629,'旺起镇',4,'',0,1,0,0),(11621,1629,'朱雀山管委会',4,'',0,1,0,0),(11622,1629,'江南乡',4,'',0,1,0,0),(11623,1629,'江南街道',4,'',0,1,0,0),(11624,1629,'沿丰街道',4,'',0,1,0,0),(11625,1629,'泰山街道',4,'',0,1,0,0),(11626,1629,'石井街道',4,'',0,1,0,0),(11627,1629,'红旗街道',4,'',0,1,0,0),(11628,1629,'高新街道',4,'',0,1,0,0),(11629,1630,'东局子街道',4,'',0,1,0,0),(11630,1630,'两家子满族乡',4,'',0,1,0,0),(11631,1630,'九站街道',4,'',0,1,0,0),(11632,1630,'兴华街道',4,'',0,1,0,0),(11633,1630,'双吉街道',4,'',0,1,0,0),(11634,1630,'哈达湾工业开发区',4,'',0,1,0,0),(11635,1630,'哈达湾街道',4,'',0,1,0,0),(11636,1630,'土城子满族朝鲜族乡',4,'',0,1,0,0),(11637,1630,'孤店子镇',4,'',0,1,0,0),(11638,1630,'左家镇',4,'',0,1,0,0),(11639,1630,'幸福经济管理区',4,'',0,1,0,0),(11640,1630,'延安街道',4,'',0,1,0,0),(11641,1630,'延江街道',4,'',0,1,0,0),(11642,1630,'怡春里街道',4,'',0,1,0,0),(11643,1630,'文庙街道',4,'',0,1,0,0),(11644,1630,'新地号街道',4,'',0,1,0,0),(11645,1630,'新建街道',4,'',0,1,0,0),(11646,1630,'桦皮厂镇',4,'',0,1,0,0),(11647,1630,'民主街道',4,'',0,1,0,0),(11648,1630,'站前街道',4,'',0,1,0,0),(11649,1630,'维昌街道',4,'',0,1,0,0),(11650,1630,'莲花街道',4,'',0,1,0,0),(11651,1630,'通江街道',4,'',0,1,0,0),(11652,1631,'二道甸子镇',4,'',0,1,0,0),(11653,1631,'八道河子镇',4,'',0,1,0,0),(11654,1631,'公吉乡',4,'',0,1,0,0),(11655,1631,'北台子乡',4,'',0,1,0,0),(11656,1631,'启新街道',4,'',0,1,0,0),(11657,1631,'夹皮沟镇',4,'',0,1,0,0),(11658,1631,'常山镇',4,'',0,1,0,0),(11659,1631,'新华街道',4,'',0,1,0,0),(11660,1631,'明桦街道',4,'',0,1,0,0),(11661,1631,'桦南乡',4,'',0,1,0,0),(11662,1631,'桦树林子乡',4,'',0,1,0,0),(11663,1631,'桦郊乡',4,'',0,1,0,0),(11664,1631,'榆木桥子镇',4,'',0,1,0,0),(11665,1631,'横道河子乡',4,'',0,1,0,0),(11666,1631,'永吉街道',4,'',0,1,0,0),(11667,1631,'白山镇',4,'',0,1,0,0),(11668,1631,'红石砬子镇',4,'',0,1,0,0),(11669,1631,'老金厂镇',4,'',0,1,0,0),(11670,1631,'胜利街道',4,'',0,1,0,0),(11671,1631,'苏密沟乡',4,'',0,1,0,0),(11672,1631,'金沙乡',4,'',0,1,0,0),(11673,1632,'一拉溪镇',4,'',0,1,0,0),(11674,1632,'万昌镇',4,'',0,1,0,0),(11675,1632,'三家子乡',4,'',0,1,0,0),(11676,1632,'北大湖镇',4,'',0,1,0,0),(11677,1632,'双河镇',4,'',0,1,0,0),(11678,1632,'口前镇',4,'',0,1,0,0),(11679,1632,'大岗子乡',4,'',0,1,0,0),(11680,1632,'官厅乡',4,'',0,1,0,0),(11681,1632,'岔路河镇',4,'',0,1,0,0),(11682,1632,'春登乡',4,'',0,1,0,0),(11683,1632,'西阳镇',4,'',0,1,0,0),(11684,1632,'金家满族乡',4,'',0,1,0,0),(11685,1632,'黄榆乡',4,'',0,1,0,0),(11686,1633,'东宁街道',4,'',0,1,0,0),(11687,1633,'取柴河镇',4,'',0,1,0,0),(11688,1633,'吉昌镇',4,'',0,1,0,0),(11689,1633,'呼兰镇',4,'',0,1,0,0),(11690,1633,'宝山乡',4,'',0,1,0,0),(11691,1633,'富太镇',4,'',0,1,0,0),(11692,1633,'明城镇',4,'',0,1,0,0),(11693,1633,'朝阳山镇',4,'',0,1,0,0),(11694,1633,'松山镇',4,'',0,1,0,0),(11695,1633,'河南街道',4,'',0,1,0,0),(11696,1633,'烟筒山镇',4,'',0,1,0,0),(11697,1633,'牛心镇',4,'',0,1,0,0),(11698,1633,'石嘴镇',4,'',0,1,0,0),(11699,1633,'磐石经济开发区',4,'',0,1,0,0),(11700,1633,'福安街道',4,'',0,1,0,0),(11701,1633,'红旗岭镇',4,'',0,1,0,0),(11702,1633,'驿马镇',4,'',0,1,0,0),(11703,1633,'黑石镇',4,'',0,1,0,0),(11704,1634,'上营镇',4,'',0,1,0,0),(11705,1634,'北城街道',4,'',0,1,0,0),(11706,1634,'吉舒街道',4,'',0,1,0,0),(11707,1634,'天德乡',4,'',0,1,0,0),(11708,1634,'平安镇',4,'',0,1,0,0),(11709,1634,'开原镇',4,'',0,1,0,0),(11710,1634,'新安乡',4,'',0,1,0,0),(11711,1634,'朝阳镇',4,'',0,1,0,0),(11712,1634,'水曲柳镇',4,'',0,1,0,0),(11713,1634,'法特镇',4,'',0,1,0,0),(11714,1634,'溪河镇',4,'',0,1,0,0),(11715,1634,'环城街道',4,'',0,1,0,0),(11716,1634,'白旗镇',4,'',0,1,0,0),(11717,1634,'莲花乡',4,'',0,1,0,0),(11718,1634,'金马镇',4,'',0,1,0,0),(11719,1635,'临江街道',4,'',0,1,0,0),(11720,1635,'北山街道',4,'',0,1,0,0),(11721,1635,'北极街道',4,'',0,1,0,0),(11722,1635,'南京街道',4,'',0,1,0,0),(11723,1635,'吉林市高新技术产业开发区',4,'',0,1,0,0),(11724,1635,'向阳街道',4,'',0,1,0,0),(11725,1635,'大东街道',4,'',0,1,0,0),(11726,1635,'大绥河镇',4,'',0,1,0,0),(11727,1635,'德胜街道',4,'',0,1,0,0),(11728,1635,'搜登站镇',4,'',0,1,0,0),(11729,1635,'欢喜乡',4,'',0,1,0,0),(11730,1635,'致和街道',4,'',0,1,0,0),(11731,1635,'越北镇',4,'',0,1,0,0),(11732,1635,'长春路街道',4,'',0,1,0,0),(11733,1635,'青岛街道',4,'',0,1,0,0),(11734,1635,'高新街道',4,'',0,1,0,0),(11735,1635,'黄旗街道',4,'',0,1,0,0),(11736,1636,'乌林朝鲜族乡',4,'',0,1,0,0),(11737,1636,'前进乡',4,'',0,1,0,0),(11738,1636,'天北镇',4,'',0,1,0,0),(11739,1636,'天岗镇',4,'',0,1,0,0),(11740,1636,'奶子山街道',4,'',0,1,0,0),(11741,1636,'庆岭镇',4,'',0,1,0,0),(11742,1636,'拉法街道',4,'',0,1,0,0),(11743,1636,'新农街道',4,'',0,1,0,0),(11744,1636,'新站镇',4,'',0,1,0,0),(11745,1636,'松江镇',4,'',0,1,0,0),(11746,1636,'民主街道',4,'',0,1,0,0),(11747,1636,'河北街道',4,'',0,1,0,0),(11748,1636,'河南街道',4,'',0,1,0,0),(11749,1636,'漂河镇',4,'',0,1,0,0),(11750,1636,'白石山镇',4,'',0,1,0,0),(11751,1636,'长安街道',4,'',0,1,0,0),(11752,1636,'黄松甸镇',4,'',0,1,0,0),(11753,1637,'乌拉街满族镇',4,'',0,1,0,0),(11754,1637,'大口钦满族镇',4,'',0,1,0,0),(11755,1637,'山前街道',4,'',0,1,0,0),(11756,1637,'承德街道',4,'',0,1,0,0),(11757,1637,'新吉林街道',4,'',0,1,0,0),(11758,1637,'新安街道',4,'',0,1,0,0),(11759,1637,'榆树街道',4,'',0,1,0,0),(11760,1637,'江北乡',4,'',0,1,0,0),(11761,1637,'江密峰镇',4,'',0,1,0,0),(11762,1637,'泡子沿街道',4,'',0,1,0,0),(11763,1637,'湘潭街道',4,'',0,1,0,0),(11764,1637,'缸窑镇',4,'',0,1,0,0),(11765,1637,'遵义街道',4,'',0,1,0,0),(11766,1637,'金珠乡',4,'',0,1,0,0),(11767,1637,'铁东街道',4,'',0,1,0,0),(11768,1637,'靠山街道',4,'',0,1,0,0),(11769,1637,'龙华街道',4,'',0,1,0,0),(11770,1637,'龙潭街道',4,'',0,1,0,0),(11771,1638,'三道乡',4,'',0,1,0,0),(11772,1638,'二道镇',4,'',0,1,0,0),(11773,1638,'伊丹镇',4,'',0,1,0,0),(11774,1638,'伊通镇',4,'',0,1,0,0),(11775,1638,'大孤山镇',4,'',0,1,0,0),(11776,1638,'小孤山镇',4,'',0,1,0,0),(11777,1638,'新兴乡',4,'',0,1,0,0),(11778,1638,'景台镇',4,'',0,1,0,0),(11779,1638,'河源镇',4,'',0,1,0,0),(11780,1638,'莫里青乡',4,'',0,1,0,0),(11781,1638,'营城子镇',4,'',0,1,0,0),(11782,1638,'西苇镇',4,'',0,1,0,0),(11783,1638,'靠山镇',4,'',0,1,0,0),(11784,1638,'马鞍山镇',4,'',0,1,0,0),(11785,1638,'黄岭子镇',4,'',0,1,0,0),(11786,1639,'东三街道',4,'',0,1,0,0),(11787,1639,'二十家子满族镇',4,'',0,1,0,0),(11788,1639,'八屋镇',4,'',0,1,0,0),(11789,1639,'刘房子镇',4,'',0,1,0,0),(11790,1639,'十屋镇',4,'',0,1,0,0),(11791,1639,'南崴子镇',4,'',0,1,0,0),(11792,1639,'双城堡镇',4,'',0,1,0,0),(11793,1639,'双龙镇',4,'',0,1,0,0),(11794,1639,'响水镇',4,'',0,1,0,0),(11795,1639,'大岭镇',4,'',0,1,0,0),(11796,1639,'大榆树镇',4,'',0,1,0,0),(11797,1639,'岭东街道',4,'',0,1,0,0),(11798,1639,'岭西街道',4,'',0,1,0,0),(11799,1639,'怀德镇',4,'',0,1,0,0),(11800,1639,'朝阳坡镇',4,'',0,1,0,0),(11801,1639,'杨大城子镇',4,'',0,1,0,0),(11802,1639,'桑树台镇',4,'',0,1,0,0),(11803,1639,'毛城子镇',4,'',0,1,0,0),(11804,1639,'永发乡',4,'',0,1,0,0),(11805,1639,'河北街道',4,'',0,1,0,0),(11806,1639,'河南街道',4,'',0,1,0,0),(11807,1639,'环岭街道',4,'',0,1,0,0),(11808,1639,'玻璃城子镇',4,'',0,1,0,0),(11809,1639,'秦家屯镇',4,'',0,1,0,0),(11810,1639,'苇子沟街道',4,'',0,1,0,0),(11811,1639,'范家屯镇',4,'',0,1,0,0),(11812,1639,'铁北街道',4,'',0,1,0,0),(11813,1639,'陶家屯镇',4,'',0,1,0,0),(11814,1639,'黑林子镇',4,'',0,1,0,0),(11815,1639,'龙山满族乡',4,'',0,1,0,0),(11816,1640,'东明镇',4,'',0,1,0,0),(11817,1640,'兴隆镇',4,'',0,1,0,0),(11818,1640,'卧虎镇',4,'',0,1,0,0),(11819,1640,'双山镇',4,'',0,1,0,0),(11820,1640,'新立乡',4,'',0,1,0,0),(11821,1640,'服先镇',4,'',0,1,0,0),(11822,1640,'柳条乡',4,'',0,1,0,0),(11823,1640,'永加乡',4,'',0,1,0,0),(11824,1640,'王奔镇',4,'',0,1,0,0),(11825,1640,'玻璃山镇',4,'',0,1,0,0),(11826,1640,'红旗街道',4,'',0,1,0,0),(11827,1640,'茂林镇',4,'',0,1,0,0),(11828,1640,'辽东街道',4,'',0,1,0,0),(11829,1640,'辽北街道',4,'',0,1,0,0),(11830,1640,'辽南街道',4,'',0,1,0,0),(11831,1640,'辽西街道',4,'',0,1,0,0),(11832,1640,'那木斯蒙古族乡',4,'',0,1,0,0),(11833,1640,'郑家屯街道',4,'',0,1,0,0),(11834,1641,'万发镇',4,'',0,1,0,0),(11835,1641,'东河镇',4,'',0,1,0,0),(11836,1641,'刘家馆子镇',4,'',0,1,0,0),(11837,1641,'十家堡镇',4,'',0,1,0,0),(11838,1641,'双河乡',4,'',0,1,0,0),(11839,1641,'喇嘛店镇',4,'',0,1,0,0),(11840,1641,'四棵树乡',4,'',0,1,0,0),(11841,1641,'孟家岭镇',4,'',0,1,0,0),(11842,1641,'小城子镇',4,'',0,1,0,0),(11843,1641,'小宽镇',4,'',0,1,0,0),(11844,1641,'林海镇',4,'',0,1,0,0),(11845,1641,'梨树乡',4,'',0,1,0,0),(11846,1641,'梨树镇',4,'',0,1,0,0),(11847,1641,'榆树台镇',4,'',0,1,0,0),(11848,1641,'沈洋镇',4,'',0,1,0,0),(11849,1641,'泉眼岭乡',4,'',0,1,0,0),(11850,1641,'白山乡',4,'',0,1,0,0),(11851,1641,'石岭镇',4,'',0,1,0,0),(11852,1641,'胜利乡',4,'',0,1,0,0),(11853,1641,'董家窝堡乡',4,'',0,1,0,0),(11854,1641,'蔡家镇',4,'',0,1,0,0),(11855,1641,'郭家店镇',4,'',0,1,0,0),(11856,1641,'金山乡',4,'',0,1,0,0),(11857,1642,'叶赫镇',4,'',0,1,0,0),(11858,1643,'仁兴街道',4,'',0,1,0,0),(11859,1643,'北沟街道',4,'',0,1,0,0),(11860,1643,'地直街道',4,'',0,1,0,0),(11861,1643,'平西乡',4,'',0,1,0,0),(11862,1643,'站前街道',4,'',0,1,0,0),(11863,1643,'英雄街道',4,'',0,1,0,0),(11864,1644,'三合朝鲜族满族乡',4,'',0,1,0,0),(11865,1644,'东丰镇',4,'',0,1,0,0),(11866,1644,'二龙山乡',4,'',0,1,0,0),(11867,1644,'南屯基镇',4,'',0,1,0,0),(11868,1644,'大兴镇',4,'',0,1,0,0),(11869,1644,'大阳镇',4,'',0,1,0,0),(11870,1644,'小四平镇',4,'',0,1,0,0),(11871,1644,'拉拉河镇',4,'',0,1,0,0),(11872,1644,'杨木林镇',4,'',0,1,0,0),(11873,1644,'横道河镇',4,'',0,1,0,0),(11874,1644,'沙河镇',4,'',0,1,0,0),(11875,1644,'猴石镇',4,'',0,1,0,0),(11876,1644,'那丹伯镇',4,'',0,1,0,0),(11877,1644,'黄泥河镇',4,'',0,1,0,0),(11878,1645,'云顶镇',4,'',0,1,0,0),(11879,1645,'安恕镇',4,'',0,1,0,0),(11880,1645,'安石镇',4,'',0,1,0,0),(11881,1645,'宴平乡',4,'',0,1,0,0),(11882,1645,'寿山镇',4,'',0,1,0,0),(11883,1645,'平岗镇',4,'',0,1,0,0),(11884,1645,'建安镇',4,'',0,1,0,0),(11885,1645,'泉太镇',4,'',0,1,0,0),(11886,1645,'甲山乡',4,'',0,1,0,0),(11887,1645,'白泉镇',4,'',0,1,0,0),(11888,1645,'足民乡',4,'',0,1,0,0),(11889,1646,'东山街道',4,'',0,1,0,0),(11890,1646,'仙城街道',4,'',0,1,0,0),(11891,1646,'先锋街道',4,'',0,1,0,0),(11892,1646,'太安街道',4,'',0,1,0,0),(11893,1646,'安家街道',4,'',0,1,0,0),(11894,1646,'富国街道',4,'',0,1,0,0),(11895,1646,'灯塔乡',4,'',0,1,0,0),(11896,1647,'东吉街道',4,'',0,1,0,0),(11897,1647,'北寿街道',4,'',0,1,0,0),(11898,1647,'南康街道',4,'',0,1,0,0),(11899,1647,'向阳街道',4,'',0,1,0,0),(11900,1647,'寿山镇',4,'',0,1,0,0),(11901,1647,'工农乡',4,'',0,1,0,0),(11902,1647,'新兴街道',4,'',0,1,0,0),(11903,1647,'福镇街道',4,'',0,1,0,0),(11904,1647,'站前街道',4,'',0,1,0,0),(11905,1647,'西宁街道',4,'',0,1,0,0),(11906,1648,'东昌街道',4,'',0,1,0,0),(11907,1648,'光明街道',4,'',0,1,0,0),(11908,1648,'团结街道',4,'',0,1,0,0),(11909,1648,'新站街道',4,'',0,1,0,0),(11910,1648,'江东乡',4,'',0,1,0,0),(11911,1648,'环通乡',4,'',0,1,0,0),(11912,1648,'老站街道',4,'',0,1,0,0),(11913,1648,'金厂镇',4,'',0,1,0,0),(11914,1648,'龙泉街道',4,'',0,1,0,0),(11915,1649,'东通化街道',4,'',0,1,0,0),(11916,1649,'二道江乡',4,'',0,1,0,0),(11917,1649,'五道江镇',4,'',0,1,0,0),(11918,1649,'桃园街道',4,'',0,1,0,0),(11919,1649,'民主街道',4,'',0,1,0,0),(11920,1649,'铁厂镇',4,'',0,1,0,0),(11921,1649,'鸭园镇',4,'',0,1,0,0),(11922,1650,'三源浦朝鲜族镇',4,'',0,1,0,0),(11923,1650,'五道沟镇',4,'',0,1,0,0),(11924,1650,'亨通镇',4,'',0,1,0,0),(11925,1650,'凉水河子镇',4,'',0,1,0,0),(11926,1650,'向阳镇',4,'',0,1,0,0),(11927,1650,'圣水河子镇',4,'',0,1,0,0),(11928,1650,'姜家店朝鲜族乡',4,'',0,1,0,0),(11929,1650,'孤山子镇',4,'',0,1,0,0),(11930,1650,'安口镇',4,'',0,1,0,0),(11931,1650,'时家店乡',4,'',0,1,0,0),(11932,1650,'柳南乡',4,'',0,1,0,0),(11933,1650,'柳河镇',4,'',0,1,0,0),(11934,1650,'红石镇',4,'',0,1,0,0),(11935,1650,'罗通山镇',4,'',0,1,0,0),(11936,1650,'驼腰岭镇',4,'',0,1,0,0),(11937,1651,'一座营镇',4,'',0,1,0,0),(11938,1651,'中和镇',4,'',0,1,0,0),(11939,1651,'光明街道',4,'',0,1,0,0),(11940,1651,'兴华乡',4,'',0,1,0,0),(11941,1651,'双兴乡',4,'',0,1,0,0),(11942,1651,'吉乐乡',4,'',0,1,0,0),(11943,1651,'和平街道',4,'',0,1,0,0),(11944,1651,'小杨满族乡',4,'',0,1,0,0),(11945,1651,'山城镇',4,'',0,1,0,0),(11946,1651,'康大营镇',4,'',0,1,0,0),(11947,1651,'新华街道',4,'',0,1,0,0),(11948,1651,'新合镇',4,'',0,1,0,0),(11949,1651,'曙光镇',4,'',0,1,0,0),(11950,1651,'李炉乡',4,'',0,1,0,0),(11951,1651,'杏岭乡',4,'',0,1,0,0),(11952,1651,'水道镇',4,'',0,1,0,0),(11953,1651,'海龙镇',4,'',0,1,0,0),(11954,1651,'湾龙乡',4,'',0,1,0,0),(11955,1651,'牛心顶镇',4,'',0,1,0,0),(11956,1651,'福民街道',4,'',0,1,0,0),(11957,1651,'红梅镇',4,'',0,1,0,0),(11958,1651,'解放街道',4,'',0,1,0,0),(11959,1651,'进化镇',4,'',0,1,0,0),(11960,1651,'黑山头镇',4,'',0,1,0,0),(11961,1652,'庆阳镇',4,'',0,1,0,0),(11962,1652,'抚民镇',4,'',0,1,0,0),(11963,1652,'朝阳镇',4,'',0,1,0,0),(11964,1652,'杉松岗镇',4,'',0,1,0,0),(11965,1652,'样子哨镇',4,'',0,1,0,0),(11966,1652,'楼街朝鲜族乡',4,'',0,1,0,0),(11967,1652,'石道河镇',4,'',0,1,0,0),(11968,1652,'辉南镇',4,'',0,1,0,0),(11969,1652,'辉发城镇',4,'',0,1,0,0),(11970,1652,'金川镇',4,'',0,1,0,0),(11971,1653,'三棵榆树镇',4,'',0,1,0,0),(11972,1653,'东来乡',4,'',0,1,0,0),(11973,1653,'二密镇',4,'',0,1,0,0),(11974,1653,'光华镇',4,'',0,1,0,0),(11975,1653,'兴林镇',4,'',0,1,0,0),(11976,1653,'四棚乡',4,'',0,1,0,0),(11977,1653,'大安镇',4,'',0,1,0,0),(11978,1653,'大泉源满族朝鲜族乡',4,'',0,1,0,0),(11979,1653,'富江乡',4,'',0,1,0,0),(11980,1653,'快大茂镇',4,'',0,1,0,0),(11981,1653,'果松镇',4,'',0,1,0,0),(11982,1653,'江甸镇',4,'',0,1,0,0),(11983,1653,'石湖镇',4,'',0,1,0,0),(11984,1653,'英额布镇',4,'',0,1,0,0),(11985,1654,'凉水朝鲜族乡',4,'',0,1,0,0),(11986,1654,'台上镇',4,'',0,1,0,0),(11987,1654,'团结街道',4,'',0,1,0,0),(11988,1654,'城东街道',4,'',0,1,0,0),(11989,1654,'大路镇',4,'',0,1,0,0),(11990,1654,'太王镇',4,'',0,1,0,0),(11991,1654,'头道镇',4,'',0,1,0,0),(11992,1654,'榆林镇',4,'',0,1,0,0),(11993,1654,'清河镇',4,'',0,1,0,0),(11994,1654,'花甸镇',4,'',0,1,0,0),(11995,1654,'财源镇',4,'',0,1,0,0),(11996,1654,'通胜街道',4,'',0,1,0,0),(11997,1654,'青石镇',4,'',0,1,0,0),(11998,1654,'麻线乡',4,'',0,1,0,0),(11999,1654,'黎明街道',4,'',0,1,0,0),(12000,1655,'六道沟镇',4,'',0,1,0,0),(12001,1655,'兴隆街道',4,'',0,1,0,0),(12002,1655,'四道沟镇',4,'',0,1,0,0),(12003,1655,'大栗子街道',4,'',0,1,0,0),(12004,1655,'大湖街道',4,'',0,1,0,0),(12005,1655,'建国街道',4,'',0,1,0,0),(12006,1655,'新市街道',4,'',0,1,0,0),(12007,1655,'桦树镇',4,'',0,1,0,0),(12008,1655,'森工街道',4,'',0,1,0,0),(12009,1655,'花山镇',4,'',0,1,0,0),(12010,1655,'苇沙河镇',4,'',0,1,0,0),(12011,1655,'蚂蚁河乡',4,'',0,1,0,0),(12012,1655,'闹枝镇',4,'',0,1,0,0),(12013,1656,'七道江镇',4,'',0,1,0,0),(12014,1656,'三道沟镇',4,'',0,1,0,0),(12015,1656,'东兴街道',4,'',0,1,0,0),(12016,1656,'六道江镇',4,'',0,1,0,0),(12017,1656,'城南街道',4,'',0,1,0,0),(12018,1656,'新建街道',4,'',0,1,0,0),(12019,1656,'板石街道',4,'',0,1,0,0),(12020,1656,'江北街道',4,'',0,1,0,0),(12021,1656,'河口街道',4,'',0,1,0,0),(12022,1656,'红土崖镇',4,'',0,1,0,0),(12023,1656,'红旗街道',4,'',0,1,0,0),(12024,1656,'通沟街道',4,'',0,1,0,0),(12025,1657,'万良镇',4,'',0,1,0,0),(12026,1657,'东岗镇',4,'',0,1,0,0),(12027,1657,'仙人桥镇',4,'',0,1,0,0),(12028,1657,'兴参镇',4,'',0,1,0,0),(12029,1657,'兴隆乡',4,'',0,1,0,0),(12030,1657,'北岗镇',4,'',0,1,0,0),(12031,1657,'抚松镇',4,'',0,1,0,0),(12032,1657,'抽水乡',4,'',0,1,0,0),(12033,1657,'新屯子镇',4,'',0,1,0,0),(12034,1657,'松江河镇',4,'',0,1,0,0),(12035,1657,'沿江乡',4,'',0,1,0,0),(12036,1657,'泉阳镇',4,'',0,1,0,0),(12037,1657,'漫江镇',4,'',0,1,0,0),(12038,1657,'露水河镇',4,'',0,1,0,0),(12039,1658,'城墙街道',4,'',0,1,0,0),(12040,1658,'大石人镇',4,'',0,1,0,0),(12041,1658,'大阳岔镇',4,'',0,1,0,0),(12042,1658,'孙家堡子街道',4,'',0,1,0,0),(12043,1658,'松树镇',4,'',0,1,0,0),(12044,1658,'正岔街道',4,'',0,1,0,0),(12045,1658,'江源街道',4,'',0,1,0,0),(12046,1658,'湾沟镇',4,'',0,1,0,0),(12047,1658,'石人镇',4,'',0,1,0,0),(12048,1658,'砟子镇',4,'',0,1,0,0),(12049,1659,'八道沟镇',4,'',0,1,0,0),(12050,1659,'十二道沟乡',4,'',0,1,0,0),(12051,1659,'十四道沟镇',4,'',0,1,0,0),(12052,1659,'宝泉山镇',4,'',0,1,0,0),(12053,1659,'新房子镇',4,'',0,1,0,0),(12054,1659,'金华乡',4,'',0,1,0,0),(12055,1659,'长白镇',4,'',0,1,0,0),(12056,1659,'马鹿沟镇',4,'',0,1,0,0),(12057,1660,'三道湖镇',4,'',0,1,0,0),(12058,1660,'景山镇',4,'',0,1,0,0),(12059,1660,'濛江乡',4,'',0,1,0,0),(12060,1660,'花园口镇',4,'',0,1,0,0),(12061,1660,'赤松乡',4,'',0,1,0,0),(12062,1660,'那尔轰镇',4,'',0,1,0,0),(12063,1660,'靖宇镇',4,'',0,1,0,0),(12064,1660,'龙泉镇',4,'',0,1,0,0),(12065,1661,'严字乡',4,'',0,1,0,0),(12066,1661,'干安镇',4,'',0,1,0,0),(12067,1661,'干水工业集中区',4,'',0,1,0,0),(12068,1661,'余字乡',4,'',0,1,0,0),(12069,1661,'大布苏工业园区',4,'',0,1,0,0),(12070,1661,'大布苏镇',4,'',0,1,0,0),(12071,1661,'安字镇',4,'',0,1,0,0),(12072,1661,'所字镇',4,'',0,1,0,0),(12073,1661,'水字镇',4,'',0,1,0,0),(12074,1661,'让字镇',4,'',0,1,0,0),(12075,1661,'赞字乡',4,'',0,1,0,0),(12076,1661,'道字乡',4,'',0,1,0,0),(12077,1661,'鳞字农业特色园区',4,'',0,1,0,0),(12078,1662,'东三家子乡',4,'',0,1,0,0),(12079,1662,'乌兰图嘎镇',4,'',0,1,0,0),(12080,1662,'乌兰塔拉乡',4,'',0,1,0,0),(12081,1662,'八郎镇',4,'',0,1,0,0),(12082,1662,'前郭尔罗斯镇',4,'',0,1,0,0),(12083,1662,'吉拉吐乡',4,'',0,1,0,0),(12084,1662,'哈拉毛都镇',4,'',0,1,0,0),(12085,1662,'国营八郎农场',4,'',0,1,0,0),(12086,1662,'大山乡',4,'',0,1,0,0),(12087,1662,'套浩太乡',4,'',0,1,0,0),(12088,1662,'宝甸乡',4,'',0,1,0,0),(12089,1662,'平凤乡',4,'',0,1,0,0),(12090,1662,'查干湖旅游经济开发区',4,'',0,1,0,0),(12091,1662,'查干花镇',4,'',0,1,0,0),(12092,1662,'洪泉乡',4,'',0,1,0,0),(12093,1662,'浩特芒哈乡',4,'',0,1,0,0),(12094,1662,'海渤日戈镇',4,'',0,1,0,0),(12095,1662,'王府站镇',4,'',0,1,0,0),(12096,1662,'白依拉嘎乡',4,'',0,1,0,0),(12097,1662,'红光农场',4,'',0,1,0,0),(12098,1662,'红旗农场',4,'',0,1,0,0),(12099,1662,'莲花农场',4,'',0,1,0,0),(12100,1662,'蒙古艾里乡',4,'',0,1,0,0),(12101,1662,'达里巴乡',4,'',0,1,0,0),(12102,1662,'长山镇',4,'',0,1,0,0),(12103,1662,'长龙乡',4,'',0,1,0,0),(12104,1663,'临江街道',4,'',0,1,0,0),(12105,1663,'伯都乡',4,'',0,1,0,0),(12106,1663,'兴原乡',4,'',0,1,0,0),(12107,1663,'前进街道',4,'',0,1,0,0),(12108,1663,'和平街道',4,'',0,1,0,0),(12109,1663,'善友镇',4,'',0,1,0,0),(12110,1663,'团结街道',4,'',0,1,0,0),(12111,1663,'大洼镇',4,'',0,1,0,0),(12112,1663,'工农街道',4,'',0,1,0,0),(12113,1663,'建设街道',4,'',0,1,0,0),(12114,1663,'文化街道',4,'',0,1,0,0),(12115,1663,'新区街道',4,'',0,1,0,0),(12116,1663,'新城乡',4,'',0,1,0,0),(12117,1663,'毛都站镇',4,'',0,1,0,0),(12118,1663,'民主街道',4,'',0,1,0,0),(12119,1663,'沿江街道',4,'',0,1,0,0),(12120,1663,'石化街道',4,'',0,1,0,0),(12121,1663,'繁荣街道',4,'',0,1,0,0),(12122,1663,'铁西街道',4,'',0,1,0,0),(12123,1664,'三井子镇',4,'',0,1,0,0),(12124,1664,'三岔河镇',4,'',0,1,0,0),(12125,1664,'三骏乡',4,'',0,1,0,0),(12126,1664,'五家站镇',4,'',0,1,0,0),(12127,1664,'伊家店乡',4,'',0,1,0,0),(12128,1664,'增盛镇',4,'',0,1,0,0),(12129,1664,'大林子镇',4,'',0,1,0,0),(12130,1664,'弓棚子镇',4,'',0,1,0,0),(12131,1664,'新万发镇',4,'',0,1,0,0),(12132,1664,'新源镇',4,'',0,1,0,0),(12133,1664,'新站乡',4,'',0,1,0,0),(12134,1664,'更新乡',4,'',0,1,0,0),(12135,1664,'永平乡',4,'',0,1,0,0),(12136,1664,'社里乡',4,'',0,1,0,0),(12137,1664,'肖家乡',4,'',0,1,0,0),(12138,1664,'蔡家沟镇',4,'',0,1,0,0),(12139,1664,'长春岭镇',4,'',0,1,0,0),(12140,1664,'陶赖昭镇',4,'',0,1,0,0),(12141,1665,'三青山镇',4,'',0,1,0,0),(12142,1665,'太平川镇',4,'',0,1,0,0),(12143,1665,'长岭镇',4,'',0,1,0,0),(12144,1666,'两家子镇',4,'',0,1,0,0),(12145,1666,'丰收镇',4,'',0,1,0,0),(12146,1666,'临江街道',4,'',0,1,0,0),(12147,1666,'乐胜乡',4,'',0,1,0,0),(12148,1666,'光明街道',4,'',0,1,0,0),(12149,1666,'原古城乡',4,'',0,1,0,0),(12150,1666,'原大榆树乡',4,'',0,1,0,0),(12151,1666,'原来福乡',4,'',0,1,0,0),(12152,1666,'原西大洼乡',4,'',0,1,0,0),(12153,1666,'叉干镇',4,'',0,1,0,0),(12154,1666,'四棵树乡',4,'',0,1,0,0),(12155,1666,'大岗子镇',4,'',0,1,0,0),(12156,1666,'大赉乡',4,'',0,1,0,0),(12157,1666,'太山镇',4,'',0,1,0,0),(12158,1666,'安北街道',4,'',0,1,0,0),(12159,1666,'安平街道',4,'',0,1,0,0),(12160,1666,'安广镇',4,'',0,1,0,0),(12161,1666,'慧阳街道',4,'',0,1,0,0),(12162,1666,'文化街道',4,'',0,1,0,0),(12163,1666,'新平安镇',4,'',0,1,0,0),(12164,1666,'新艾里蒙古族乡',4,'',0,1,0,0),(12165,1666,'月亮泡镇',4,'',0,1,0,0),(12166,1666,'海坨乡',4,'',0,1,0,0),(12167,1666,'烧锅镇乡',4,'',0,1,0,0),(12168,1666,'红岗子乡',4,'',0,1,0,0),(12169,1666,'联合乡',4,'',0,1,0,0),(12170,1666,'舍力镇',4,'',0,1,0,0),(12171,1666,'锦华街道',4,'',0,1,0,0),(12172,1666,'长虹街道',4,'',0,1,0,0),(12173,1666,'龙沼镇',4,'',0,1,0,0),(12174,1666,'龙泉街道',4,'',0,1,0,0),(12175,1667,'三合乡',4,'',0,1,0,0),(12176,1667,'东胜乡',4,'',0,1,0,0),(12177,1667,'东风乡',4,'',0,1,0,0),(12178,1667,'保平街道',4,'',0,1,0,0),(12179,1667,'城南街道',4,'',0,1,0,0),(12180,1667,'岭下镇',4,'',0,1,0,0),(12181,1667,'平台镇',4,'',0,1,0,0),(12182,1667,'平安镇',4,'',0,1,0,0),(12183,1667,'幸福街道',4,'',0,1,0,0),(12184,1667,'德顺蒙古族乡',4,'',0,1,0,0),(12185,1667,'新华街道',4,'',0,1,0,0),(12186,1667,'新立街道',4,'',0,1,0,0),(12187,1667,'林海镇',4,'',0,1,0,0),(12188,1667,'洮河镇',4,'',0,1,0,0),(12189,1667,'海明街道',4,'',0,1,0,0),(12190,1667,'瑞光街道',4,'',0,1,0,0),(12191,1667,'金祥乡',4,'',0,1,0,0),(12192,1667,'铁东街道',4,'',0,1,0,0),(12193,1667,'长庆街道',4,'',0,1,0,0),(12194,1667,'青山镇',4,'',0,1,0,0),(12195,1668,'万宝乡',4,'',0,1,0,0),(12196,1668,'万宝镇',4,'',0,1,0,0),(12197,1668,'东升乡',4,'',0,1,0,0),(12198,1668,'二龙乡',4,'',0,1,0,0),(12199,1668,'光明街道',4,'',0,1,0,0),(12200,1668,'兴隆街道',4,'',0,1,0,0),(12201,1668,'向阳街道',4,'',0,1,0,0),(12202,1668,'呼和车力蒙古族乡',4,'',0,1,0,0),(12203,1668,'团结街道',4,'',0,1,0,0),(12204,1668,'大通乡',4,'',0,1,0,0),(12205,1668,'安定镇',4,'',0,1,0,0),(12206,1668,'富文街道',4,'',0,1,0,0),(12207,1668,'永康街道',4,'',0,1,0,0),(12208,1668,'永茂乡',4,'',0,1,0,0),(12209,1668,'洮府街道',4,'',0,1,0,0),(12210,1668,'瓦房镇',4,'',0,1,0,0),(12211,1668,'福顺乡',4,'',0,1,0,0),(12212,1668,'聚宝乡',4,'',0,1,0,0),(12213,1668,'胡力吐蒙古族乡',4,'',0,1,0,0),(12214,1668,'蛟流河乡',4,'',0,1,0,0),(12215,1668,'通达街道',4,'',0,1,0,0),(12216,1668,'那金镇',4,'',0,1,0,0),(12217,1668,'野马乡',4,'',0,1,0,0),(12218,1668,'黑水镇',4,'',0,1,0,0),(12219,1669,'乌兰花镇',4,'',0,1,0,0),(12220,1669,'八面乡',4,'',0,1,0,0),(12221,1669,'兴隆山镇',4,'',0,1,0,0),(12222,1669,'包拉温都蒙古族乡',4,'',0,1,0,0),(12223,1669,'十花道乡',4,'',0,1,0,0),(12224,1669,'双岗镇',4,'',0,1,0,0),(12225,1669,'向海蒙古族乡',4,'',0,1,0,0),(12226,1669,'团结乡',4,'',0,1,0,0),(12227,1669,'开通镇',4,'',0,1,0,0),(12228,1669,'新兴乡',4,'',0,1,0,0),(12229,1669,'新华镇',4,'',0,1,0,0),(12230,1669,'新发乡',4,'',0,1,0,0),(12231,1669,'瞻榆镇',4,'',0,1,0,0),(12232,1669,'苏公坨乡',4,'',0,1,0,0),(12233,1669,'边昭镇',4,'',0,1,0,0),(12234,1669,'鸿兴镇',4,'',0,1,0,0),(12235,1670,'东屏镇',4,'',0,1,0,0),(12236,1670,'丹岱乡',4,'',0,1,0,0),(12237,1670,'五棵树镇',4,'',0,1,0,0),(12238,1670,'保民乡',4,'',0,1,0,0),(12239,1670,'到保镇',4,'',0,1,0,0),(12240,1670,'哈吐气蒙古族乡',4,'',0,1,0,0),(12241,1670,'嘎什根乡',4,'',0,1,0,0),(12242,1670,'坦途镇',4,'',0,1,0,0),(12243,1670,'大屯镇',4,'',0,1,0,0),(12244,1670,'建平乡',4,'',0,1,0,0),(12245,1670,'沿江镇',4,'',0,1,0,0),(12246,1670,'胜利乡',4,'',0,1,0,0),(12247,1670,'英华乡',4,'',0,1,0,0),(12248,1670,'莫莫格蒙古族乡',4,'',0,1,0,0),(12249,1670,'镇赉镇',4,'',0,1,0,0),(12250,1670,'黑鱼泡镇',4,'',0,1,0,0),(12251,1671,'东城镇',4,'',0,1,0,0),(12252,1671,'光明街道',4,'',0,1,0,0),(12253,1671,'八家子林业局',4,'',0,1,0,0),(12254,1671,'八家子镇',4,'',0,1,0,0),(12255,1671,'南坪镇',4,'',0,1,0,0),(12256,1671,'和龙市林业局',4,'',0,1,0,0),(12257,1671,'境内还有和龙林业局',4,'',0,1,0,0),(12258,1671,'头道镇',4,'',0,1,0,0),(12259,1671,'崇善镇',4,'',0,1,0,0),(12260,1671,'文化街道',4,'',0,1,0,0),(12261,1671,'民惠街道',4,'',0,1,0,0),(12262,1671,'福洞镇',4,'',0,1,0,0),(12263,1671,'西城镇',4,'',0,1,0,0),(12264,1671,'龙城镇',4,'',0,1,0,0),(12265,1672,'凉水镇',4,'',0,1,0,0),(12266,1672,'向上街道',4,'',0,1,0,0),(12267,1672,'新华街道',4,'',0,1,0,0),(12268,1672,'月宫街道',4,'',0,1,0,0),(12269,1672,'月晴镇',4,'',0,1,0,0),(12270,1672,'石砚镇',4,'',0,1,0,0),(12271,1672,'长安镇',4,'',0,1,0,0),(12272,1673,'万宝镇',4,'',0,1,0,0),(12273,1673,'两江镇',4,'',0,1,0,0),(12274,1673,'二道白河镇',4,'',0,1,0,0),(12275,1673,'亮兵镇',4,'',0,1,0,0),(12276,1673,'新合乡',4,'',0,1,0,0),(12277,1673,'明月镇',4,'',0,1,0,0),(12278,1673,'松江镇',4,'',0,1,0,0),(12279,1673,'永庆乡',4,'',0,1,0,0),(12280,1673,'石门镇',4,'',0,1,0,0),(12281,1674,'三道湾镇',4,'',0,1,0,0),(12282,1674,'依兰镇',4,'',0,1,0,0),(12283,1674,'公园街道',4,'',0,1,0,0),(12284,1674,'北山街道',4,'',0,1,0,0),(12285,1674,'小营镇',4,'',0,1,0,0),(12286,1674,'建工街道',4,'',0,1,0,0),(12287,1674,'新兴街道',4,'',0,1,0,0),(12288,1674,'朝阳街道',4,'',0,1,0,0),(12289,1674,'河南街道',4,'',0,1,0,0),(12290,1675,'丹江街道',4,'',0,1,0,0),(12291,1675,'大桥乡',4,'',0,1,0,0),(12292,1675,'大石头镇',4,'',0,1,0,0),(12293,1675,'大蒲柴河镇',4,'',0,1,0,0),(12294,1675,'官地镇',4,'',0,1,0,0),(12295,1675,'民主街道',4,'',0,1,0,0),(12296,1675,'江南镇',4,'',0,1,0,0),(12297,1675,'江源镇',4,'',0,1,0,0),(12298,1675,'沙河沿镇',4,'',0,1,0,0),(12299,1675,'渤海街道',4,'',0,1,0,0),(12300,1675,'秋梨沟镇',4,'',0,1,0,0),(12301,1675,'红石乡',4,'',0,1,0,0),(12302,1675,'翰章乡',4,'',0,1,0,0),(12303,1675,'胜利街道',4,'',0,1,0,0),(12304,1675,'贤儒镇',4,'',0,1,0,0),(12305,1675,'雁鸣湖镇',4,'',0,1,0,0),(12306,1675,'青沟子乡',4,'',0,1,0,0),(12307,1675,'额穆镇',4,'',0,1,0,0),(12308,1675,'黄泥河镇',4,'',0,1,0,0),(12309,1675,'黑石乡',4,'',0,1,0,0),(12310,1676,'东光镇',4,'',0,1,0,0),(12311,1676,'复兴镇',4,'',0,1,0,0),(12312,1676,'大兴沟镇',4,'',0,1,0,0),(12313,1676,'天桥岭镇',4,'',0,1,0,0),(12314,1676,'春阳镇',4,'',0,1,0,0),(12315,1676,'汪清镇',4,'',0,1,0,0),(12316,1676,'百草沟镇',4,'',0,1,0,0),(12317,1676,'罗子沟镇',4,'',0,1,0,0),(12318,1676,'鸡冠乡',4,'',0,1,0,0),(12319,1677,'三家子满族乡',4,'',0,1,0,0),(12320,1677,'哈达门乡',4,'',0,1,0,0),(12321,1677,'密江乡',4,'',0,1,0,0),(12322,1677,'敬信镇',4,'',0,1,0,0),(12323,1677,'新安街道',4,'',0,1,0,0),(12324,1677,'春化镇',4,'',0,1,0,0),(12325,1677,'杨泡满族乡',4,'',0,1,0,0),(12326,1677,'板石镇',4,'',0,1,0,0),(12327,1677,'河南街道',4,'',0,1,0,0),(12328,1677,'英安镇',4,'',0,1,0,0),(12329,1677,'近海街道',4,'',0,1,0,0),(12330,1677,'靖和街道',4,'',0,1,0,0),(12331,1677,'马川子乡',4,'',0,1,0,0),(12332,1678,'三合镇',4,'',0,1,0,0),(12333,1678,'东盛涌镇',4,'',0,1,0,0),(12334,1678,'安民街道',4,'',0,1,0,0),(12335,1678,'开山屯镇',4,'',0,1,0,0),(12336,1678,'德新乡',4,'',0,1,0,0),(12337,1678,'智新镇',4,'',0,1,0,0),(12338,1678,'朝阳川镇',4,'',0,1,0,0),(12339,1678,'白金乡',4,'',0,1,0,0),(12340,1678,'老头沟镇',4,'',0,1,0,0),(12341,1678,'龙门街道',4,'',0,1,0,0),(12342,1679,'二河乡',4,'',0,1,0,0),(12343,1679,'五常镇',4,'',0,1,0,0),(12344,1679,'八家子乡',4,'',0,1,0,0),(12345,1679,'兴盛乡',4,'',0,1,0,0),(12346,1679,'兴隆乡',4,'',0,1,0,0),(12347,1679,'冲河镇',4,'',0,1,0,0),(12348,1679,'卫国乡',4,'',0,1,0,0),(12349,1679,'向阳镇',4,'',0,1,0,0),(12350,1679,'安家镇',4,'',0,1,0,0),(12351,1679,'小山子镇',4,'',0,1,0,0),(12352,1679,'山河镇',4,'',0,1,0,0),(12353,1679,'常堡乡',4,'',0,1,0,0),(12354,1679,'志广乡',4,'',0,1,0,0),(12355,1679,'拉林满族镇',4,'',0,1,0,0),(12356,1679,'杜家镇',4,'',0,1,0,0),(12357,1679,'民乐朝鲜族乡',4,'',0,1,0,0),(12358,1679,'民意乡',4,'',0,1,0,0),(12359,1679,'沙河子镇',4,'',0,1,0,0),(12360,1679,'牛家满族镇',4,'',0,1,0,0),(12361,1679,'红旗满族乡',4,'',0,1,0,0),(12362,1679,'背荫河镇',4,'',0,1,0,0),(12363,1679,'营城子满族乡',4,'',0,1,0,0),(12364,1679,'长山乡',4,'',0,1,0,0),(12365,1679,'龙凤山乡',4,'',0,1,0,0),(12366,1680,'三道岗镇',4,'',0,1,0,0),(12367,1680,'依兰镇',4,'',0,1,0,0),(12368,1680,'团山子乡',4,'',0,1,0,0),(12369,1680,'宏克利镇',4,'',0,1,0,0),(12370,1680,'愚公乡',4,'',0,1,0,0),(12371,1680,'江湾镇',4,'',0,1,0,0),(12372,1680,'达连河镇',4,'',0,1,0,0),(12373,1680,'迎兰朝鲜族乡',4,'',0,1,0,0),(12374,1680,'道台桥镇',4,'',0,1,0,0),(12375,1681,'七政街道',4,'',0,1,0,0),(12376,1681,'保健路街道',4,'',0,1,0,0),(12377,1681,'先锋路街道',4,'',0,1,0,0),(12378,1681,'和兴路街道',4,'',0,1,0,0),(12379,1681,'哈西街道',4,'',0,1,0,0),(12380,1681,'大成街道',4,'',0,1,0,0),(12381,1681,'奋斗路街道',4,'',0,1,0,0),(12382,1681,'文化街道',4,'',0,1,0,0),(12383,1681,'新春街道',4,'',0,1,0,0),(12384,1681,'曲线街道',4,'',0,1,0,0),(12385,1681,'松花江街道',4,'',0,1,0,0),(12386,1681,'燎原街道',4,'',0,1,0,0),(12387,1681,'王岗镇',4,'',0,1,0,0),(12388,1681,'红旗满族乡',4,'',0,1,0,0),(12389,1681,'芦家街道',4,'',0,1,0,0),(12390,1681,'花园街道',4,'',0,1,0,0),(12391,1681,'荣市街道',4,'',0,1,0,0),(12392,1681,'跃进乡',4,'',0,1,0,0),(12393,1681,'通达街道',4,'',0,1,0,0),(12394,1681,'革新街道',4,'',0,1,0,0),(12395,1682,'万隆乡',4,'',0,1,0,0),(12396,1682,'东官镇',4,'',0,1,0,0),(12397,1682,'临江乡',4,'',0,1,0,0),(12398,1682,'乐群满族乡',4,'',0,1,0,0),(12399,1682,'五家镇',4,'',0,1,0,0),(12400,1682,'公正满族乡',4,'',0,1,0,0),(12401,1682,'兰棱镇',4,'',0,1,0,0),(12402,1682,'农丰满族锡伯族镇',4,'',0,1,0,0),(12403,1682,'单城镇',4,'',0,1,0,0),(12404,1682,'双城市社区管理委员会',4,'',0,1,0,0),(12405,1682,'双城镇',4,'',0,1,0,0),(12406,1682,'同心满族乡',4,'',0,1,0,0),(12407,1682,'周家镇',4,'',0,1,0,0),(12408,1682,'团结满族乡',4,'',0,1,0,0),(12409,1682,'希勤满族乡',4,'',0,1,0,0),(12410,1682,'幸福满族乡',4,'',0,1,0,0),(12411,1682,'新兴满族乡',4,'',0,1,0,0),(12412,1682,'朝阳乡',4,'',0,1,0,0),(12413,1682,'杏山镇',4,'',0,1,0,0),(12414,1682,'水泉乡',4,'',0,1,0,0),(12415,1682,'永胜乡',4,'',0,1,0,0),(12416,1682,'联兴满族乡',4,'',0,1,0,0),(12417,1682,'金城乡',4,'',0,1,0,0),(12418,1682,'青岭满族乡',4,'',0,1,0,0),(12419,1682,'韩甸镇',4,'',0,1,0,0),(12420,1683,'二八镇',4,'',0,1,0,0),(12421,1683,'兰河街道',4,'',0,1,0,0),(12422,1683,'利民街道',4,'',0,1,0,0),(12423,1683,'双井镇',4,'',0,1,0,0),(12424,1683,'呼兰街道',4,'',0,1,0,0),(12425,1683,'大用镇',4,'',0,1,0,0),(12426,1683,'孟家乡',4,'',0,1,0,0),(12427,1683,'康金镇',4,'',0,1,0,0),(12428,1683,'方台镇',4,'',0,1,0,0),(12429,1683,'杨林乡',4,'',0,1,0,0),(12430,1683,'沈家镇',4,'',0,1,0,0),(12431,1683,'白奎镇',4,'',0,1,0,0),(12432,1683,'石人镇',4,'',0,1,0,0),(12433,1683,'腰堡街道',4,'',0,1,0,0),(12434,1683,'莲花镇',4,'',0,1,0,0),(12435,1683,'许堡乡',4,'',0,1,0,0),(12436,1683,'长岭镇',4,'',0,1,0,0),(12437,1684,'兆麟街道',4,'',0,1,0,0),(12438,1684,'共乐街道',4,'',0,1,0,0),(12439,1684,'城乡路街道',4,'',0,1,0,0),(12440,1684,'太平镇',4,'',0,1,0,0),(12441,1684,'安和街道',4,'',0,1,0,0),(12442,1684,'安静街道',4,'',0,1,0,0),(12443,1684,'尚志街道',4,'',0,1,0,0),(12444,1684,'工农街道',4,'',0,1,0,0),(12445,1684,'工程街道',4,'',0,1,0,0),(12446,1684,'康安街道',4,'',0,1,0,0),(12447,1684,'建国街道',4,'',0,1,0,0),(12448,1684,'抚顺街道',4,'',0,1,0,0),(12449,1684,'斯大林街道',4,'',0,1,0,0),(12450,1684,'新农镇',4,'',0,1,0,0),(12451,1684,'新华街道',4,'',0,1,0,0),(12452,1684,'新发镇',4,'',0,1,0,0),(12453,1684,'新阳路街道',4,'',0,1,0,0),(12454,1684,'榆树镇',4,'',0,1,0,0),(12455,1684,'正阳河街道',4,'',0,1,0,0),(12456,1684,'经纬街道',4,'',0,1,0,0),(12457,1684,'群力乡',4,'',0,1,0,0),(12458,1684,'通江街道',4,'',0,1,0,0),(12459,1685,'三宝乡',4,'',0,1,0,0),(12460,1685,'宁远镇',4,'',0,1,0,0),(12461,1685,'宾安镇',4,'',0,1,0,0),(12462,1685,'宾州镇',4,'',0,1,0,0),(12463,1685,'宾西镇',4,'',0,1,0,0),(12464,1685,'居仁镇',4,'',0,1,0,0),(12465,1685,'常安镇',4,'',0,1,0,0),(12466,1685,'平坊镇',4,'',0,1,0,0),(12467,1685,'摆渡镇',4,'',0,1,0,0),(12468,1685,'新甸镇',4,'',0,1,0,0),(12469,1685,'民和乡',4,'',0,1,0,0),(12470,1685,'永和乡',4,'',0,1,0,0),(12471,1685,'满井镇',4,'',0,1,0,0),(12472,1685,'糖坊镇',4,'',0,1,0,0),(12473,1685,'经建乡',4,'',0,1,0,0),(12474,1685,'胜利镇',4,'',0,1,0,0),(12475,1685,'鸟河乡',4,'',0,1,0,0),(12476,1686,'一面坡镇',4,'',0,1,0,0),(12477,1686,'乌吉密乡',4,'',0,1,0,0),(12478,1686,'亚布力镇',4,'',0,1,0,0),(12479,1686,'亮河镇',4,'',0,1,0,0),(12480,1686,'元宝镇',4,'',0,1,0,0),(12481,1686,'尚志镇',4,'',0,1,0,0),(12482,1686,'帽儿山镇',4,'',0,1,0,0),(12483,1686,'庆阳镇',4,'',0,1,0,0),(12484,1686,'河东朝鲜族乡',4,'',0,1,0,0),(12485,1686,'珍珠山乡',4,'',0,1,0,0),(12486,1686,'石头河子镇',4,'',0,1,0,0),(12487,1686,'老街基乡',4,'',0,1,0,0),(12488,1686,'苇河镇',4,'',0,1,0,0),(12489,1686,'长寿乡',4,'',0,1,0,0),(12490,1686,'马延乡',4,'',0,1,0,0),(12491,1686,'鱼池朝鲜族乡',4,'',0,1,0,0),(12492,1686,'黑龙宫镇',4,'',0,1,0,0),(12493,1687,'万发镇',4,'',0,1,0,0),(12494,1687,'丰乐乡',4,'',0,1,0,0),(12495,1687,'兴隆镇',4,'',0,1,0,0),(12496,1687,'华山乡',4,'',0,1,0,0),(12497,1687,'天增镇',4,'',0,1,0,0),(12498,1687,'富江乡',4,'',0,1,0,0),(12499,1687,'山后乡',4,'',0,1,0,0),(12500,1687,'巴彦港镇',4,'',0,1,0,0),(12501,1687,'巴彦镇',4,'',0,1,0,0),(12502,1687,'德祥乡',4,'',0,1,0,0),(12503,1687,'松花江乡',4,'',0,1,0,0),(12504,1687,'洼兴镇',4,'',0,1,0,0),(12505,1687,'红光乡',4,'',0,1,0,0),(12506,1687,'西集镇',4,'',0,1,0,0),(12507,1687,'镇东乡',4,'',0,1,0,0),(12508,1687,'黑山镇',4,'',0,1,0,0),(12509,1687,'龙庙镇',4,'',0,1,0,0),(12510,1687,'龙泉镇',4,'',0,1,0,0),(12511,1688,'保国街道',4,'',0,1,0,0),(12512,1688,'兴建街道',4,'',0,1,0,0),(12513,1688,'友协街道',4,'',0,1,0,0),(12514,1688,'平房镇',4,'',0,1,0,0),(12515,1688,'平新镇',4,'',0,1,0,0),(12516,1688,'新伟街道',4,'',0,1,0,0),(12517,1688,'新疆街道',4,'',0,1,0,0),(12518,1688,'联盟街道',4,'',0,1,0,0),(12519,1689,'中和镇',4,'',0,1,0,0),(12520,1689,'六团镇',4,'',0,1,0,0),(12521,1689,'加信镇',4,'',0,1,0,0),(12522,1689,'安山乡',4,'',0,1,0,0),(12523,1689,'寿山乡',4,'',0,1,0,0),(12524,1689,'延寿镇',4,'',0,1,0,0),(12525,1689,'延河镇',4,'',0,1,0,0),(12526,1689,'玉河乡',4,'',0,1,0,0),(12527,1689,'青川乡',4,'',0,1,0,0),(12528,1690,'伊汉通乡',4,'',0,1,0,0),(12529,1690,'会发镇',4,'',0,1,0,0),(12530,1690,'大罗密镇',4,'',0,1,0,0),(12531,1690,'天门乡',4,'',0,1,0,0),(12532,1690,'宝兴乡',4,'',0,1,0,0),(12533,1690,'德善乡',4,'',0,1,0,0),(12534,1690,'方正镇',4,'',0,1,0,0),(12535,1690,'松南乡',4,'',0,1,0,0),(12536,1691,'东兴镇',4,'',0,1,0,0),(12537,1691,'利东镇',4,'',0,1,0,0),(12538,1691,'吉兴乡',4,'',0,1,0,0),(12539,1691,'大贵镇',4,'',0,1,0,0),(12540,1691,'建国乡',4,'',0,1,0,0),(12541,1691,'新民镇',4,'',0,1,0,0),(12542,1691,'木兰镇',4,'',0,1,0,0),(12543,1691,'柳河镇',4,'',0,1,0,0),(12544,1692,'万宝街道',4,'',0,1,0,0),(12545,1692,'三电街道',4,'',0,1,0,0),(12546,1692,'乐业镇',4,'',0,1,0,0),(12547,1692,'太阳岛街道',4,'',0,1,0,0),(12548,1692,'对青山镇',4,'',0,1,0,0),(12549,1692,'松北街道',4,'',0,1,0,0),(12550,1692,'松浦街道',4,'',0,1,0,0),(12551,1693,'三站乡',4,'',0,1,0,0),(12552,1693,'乌鸦泡镇',4,'',0,1,0,0),(12553,1693,'凤山镇',4,'',0,1,0,0),(12554,1693,'富林乡',4,'',0,1,0,0),(12555,1693,'浓河镇',4,'',0,1,0,0),(12556,1693,'清河镇',4,'',0,1,0,0),(12557,1693,'祥顺镇',4,'',0,1,0,0),(12558,1693,'通河镇',4,'',0,1,0,0),(12559,1694,'三棵树大街街道',4,'',0,1,0,0),(12560,1694,'东原街道',4,'',0,1,0,0),(12561,1694,'东莱街道',4,'',0,1,0,0),(12562,1694,'仁里街道',4,'',0,1,0,0),(12563,1694,'化工街道',4,'',0,1,0,0),(12564,1694,'南直路街道',4,'',0,1,0,0),(12565,1694,'南马街道',4,'',0,1,0,0),(12566,1694,'团结镇',4,'',0,1,0,0),(12567,1694,'大兴街道',4,'',0,1,0,0),(12568,1694,'大有坊街道',4,'',0,1,0,0),(12569,1694,'太古街道',4,'',0,1,0,0),(12570,1694,'太平大街街道',4,'',0,1,0,0),(12571,1694,'崇俭街道',4,'',0,1,0,0),(12572,1694,'巨源镇',4,'',0,1,0,0),(12573,1694,'振江街道',4,'',0,1,0,0),(12574,1694,'新一街道',4,'',0,1,0,0),(12575,1694,'新乐街道',4,'',0,1,0,0),(12576,1694,'民主乡',4,'',0,1,0,0),(12577,1694,'民强街道',4,'',0,1,0,0),(12578,1694,'水泥路街道',4,'',0,1,0,0),(12579,1694,'永源镇',4,'',0,1,0,0),(12580,1694,'滨江街道',4,'',0,1,0,0),(12581,1694,'火车头街道',4,'',0,1,0,0),(12582,1694,'胜利街道',4,'',0,1,0,0),(12583,1694,'青年农场',4,'',0,1,0,0),(12584,1694,'靖宇街道',4,'',0,1,0,0),(12585,1694,'黎华街道',4,'',0,1,0,0),(12586,1695,'亚沟镇',4,'',0,1,0,0),(12587,1695,'交界镇',4,'',0,1,0,0),(12588,1695,'双丰镇',4,'',0,1,0,0),(12589,1695,'和平街道',4,'',0,1,0,0),(12590,1695,'大岭乡',4,'',0,1,0,0),(12591,1695,'小岭镇',4,'',0,1,0,0),(12592,1695,'巨源镇',4,'',0,1,0,0),(12593,1695,'平山镇',4,'',0,1,0,0),(12594,1695,'料甸满族乡',4,'',0,1,0,0),(12595,1695,'新华镇',4,'',0,1,0,0),(12596,1695,'杨树乡',4,'',0,1,0,0),(12597,1695,'松峰山镇',4,'',0,1,0,0),(12598,1695,'永源镇',4,'',0,1,0,0),(12599,1695,'河东街道',4,'',0,1,0,0),(12600,1695,'玉泉镇',4,'',0,1,0,0),(12601,1695,'红星乡',4,'',0,1,0,0),(12602,1695,'胜利街道',4,'',0,1,0,0),(12603,1695,'舍利乡',4,'',0,1,0,0),(12604,1695,'蜚克图镇',4,'',0,1,0,0),(12605,1695,'通城街道',4,'',0,1,0,0),(12606,1695,'阿什河街道',4,'',0,1,0,0),(12607,1696,'六顺街道',4,'',0,1,0,0),(12608,1696,'向阳乡',4,'',0,1,0,0),(12609,1696,'安埠街道',4,'',0,1,0,0),(12610,1696,'幸福镇',4,'',0,1,0,0),(12611,1696,'成高子镇',4,'',0,1,0,0),(12612,1696,'新成街道',4,'',0,1,0,0),(12613,1696,'新香坊街道',4,'',0,1,0,0),(12614,1696,'红旗街道',4,'',0,1,0,0),(12615,1696,'通天街道',4,'',0,1,0,0),(12616,1696,'铁东街道',4,'',0,1,0,0),(12617,1696,'香坊大街街道',4,'',0,1,0,0),(12618,1697,'三兴镇',4,'',0,1,0,0),(12619,1697,'上游乡',4,'',0,1,0,0),(12620,1697,'中心镇',4,'',0,1,0,0),(12621,1697,'依安农场',4,'',0,1,0,0),(12622,1697,'依安镇',4,'',0,1,0,0),(12623,1697,'依龙镇',4,'',0,1,0,0),(12624,1697,'先锋乡',4,'',0,1,0,0),(12625,1697,'双阳镇',4,'',0,1,0,0),(12626,1697,'太东乡',4,'',0,1,0,0),(12627,1697,'富饶乡',4,'',0,1,0,0),(12628,1697,'新兴乡',4,'',0,1,0,0),(12629,1697,'新发乡',4,'',0,1,0,0),(12630,1697,'新屯乡',4,'',0,1,0,0),(12631,1697,'红星乡',4,'',0,1,0,0),(12632,1697,'解放乡',4,'',0,1,0,0),(12633,1697,'阳春乡',4,'',0,1,0,0),(12634,1698,'干丰镇',4,'',0,1,0,0),(12635,1698,'克东镇',4,'',0,1,0,0),(12636,1698,'宝泉镇',4,'',0,1,0,0),(12637,1698,'昌盛乡',4,'',0,1,0,0),(12638,1698,'润津乡',4,'',0,1,0,0),(12639,1698,'玉岗镇',4,'',0,1,0,0),(12640,1698,'金城乡',4,'',0,1,0,0),(12641,1699,'克山农场',4,'',0,1,0,0),(12642,1699,'克山镇',4,'',0,1,0,0),(12643,1699,'北兴镇',4,'',0,1,0,0),(12644,1699,'北联镇',4,'',0,1,0,0),(12645,1699,'双河乡',4,'',0,1,0,0),(12646,1699,'发展乡',4,'',0,1,0,0),(12647,1699,'古北乡',4,'',0,1,0,0),(12648,1699,'古城镇',4,'',0,1,0,0),(12649,1699,'向华乡',4,'',0,1,0,0),(12650,1699,'曙光乡',4,'',0,1,0,0),(12651,1699,'河北乡',4,'',0,1,0,0),(12652,1699,'河南乡',4,'',0,1,0,0),(12653,1699,'西城镇',4,'',0,1,0,0),(12654,1699,'西建乡',4,'',0,1,0,0),(12655,1699,'西河镇',4,'',0,1,0,0),(12656,1699,'西联乡',4,'',0,1,0,0),(12657,1700,'北兴街道',4,'',0,1,0,0),(12658,1700,'幸福街道',4,'',0,1,0,0),(12659,1700,'杜尔门沁达斡尔族乡',4,'',0,1,0,0),(12660,1700,'沿江街道',4,'',0,1,0,0),(12661,1700,'电力街道',4,'',0,1,0,0),(12662,1700,'红宝石街道',4,'',0,1,0,0),(12663,1700,'红岸街道',4,'',0,1,0,0),(12664,1700,'铁北街道',4,'',0,1,0,0),(12665,1700,'长青乡',4,'',0,1,0,0),(12666,1701,'二道湾镇',4,'',0,1,0,0),(12667,1701,'友谊达斡尔族满族柯尔克孜族乡',4,'',0,1,0,0),(12668,1701,'塔哈满族达斡尔族乡',4,'',0,1,0,0),(12669,1701,'富海镇',4,'',0,1,0,0),(12670,1701,'富裕镇',4,'',0,1,0,0),(12671,1701,'富路镇',4,'',0,1,0,0),(12672,1701,'忠厚乡',4,'',0,1,0,0),(12673,1701,'繁荣乡',4,'',0,1,0,0),(12674,1701,'绍文乡',4,'',0,1,0,0),(12675,1701,'龙安桥镇',4,'',0,1,0,0),(12676,1702,'中华街道',4,'',0,1,0,0),(12677,1702,'卜奎街道',4,'',0,1,0,0),(12678,1702,'建设街道',4,'',0,1,0,0),(12679,1702,'文化街道',4,'',0,1,0,0),(12680,1702,'西大桥街道',4,'',0,1,0,0),(12681,1703,'三道镇',4,'',0,1,0,0),(12682,1703,'上升乡',4,'',0,1,0,0),(12683,1703,'丰产乡',4,'',0,1,0,0),(12684,1703,'兴农镇',4,'',0,1,0,0),(12685,1703,'兴华乡',4,'',0,1,0,0),(12686,1703,'兴国乡',4,'',0,1,0,0),(12687,1703,'国富镇',4,'',0,1,0,0),(12688,1703,'大众乡',4,'',0,1,0,0),(12689,1703,'富强镇',4,'',0,1,0,0),(12690,1703,'拜泉镇',4,'',0,1,0,0),(12691,1703,'新生乡',4,'',0,1,0,0),(12692,1703,'时中乡',4,'',0,1,0,0),(12693,1703,'永勤乡',4,'',0,1,0,0),(12694,1703,'爱农乡',4,'',0,1,0,0),(12695,1703,'长春镇',4,'',0,1,0,0),(12696,1703,'龙泉镇',4,'',0,1,0,0),(12697,1704,'三间房镇',4,'',0,1,0,0),(12698,1704,'新兴街道',4,'',0,1,0,0),(12699,1704,'新建街道',4,'',0,1,0,0),(12700,1704,'林机街道',4,'',0,1,0,0),(12701,1704,'水师营满族镇',4,'',0,1,0,0),(12702,1704,'道北街道',4,'',0,1,0,0),(12703,1705,'共和镇',4,'',0,1,0,0),(12704,1705,'卧牛吐达斡尔族镇',4,'',0,1,0,0),(12705,1705,'哈拉海农场',4,'',0,1,0,0),(12706,1705,'梅里斯乡',4,'',0,1,0,0),(12707,1705,'梅里斯街道',4,'',0,1,0,0),(12708,1705,'莽格吐达斡尔族乡',4,'',0,1,0,0),(12709,1705,'达呼店镇',4,'',0,1,0,0),(12710,1705,'雅尔塞镇',4,'',0,1,0,0),(12711,1706,'克利镇',4,'',0,1,0,0),(12712,1706,'和平镇',4,'',0,1,0,0),(12713,1706,'塔子城镇',4,'',0,1,0,0),(12714,1706,'大兴镇',4,'',0,1,0,0),(12715,1706,'宁姜蒙古族乡',4,'',0,1,0,0),(12716,1706,'平洋镇',4,'',0,1,0,0),(12717,1706,'江桥蒙古族镇',4,'',0,1,0,0),(12718,1706,'汤池镇',4,'',0,1,0,0),(12719,1706,'泰来镇',4,'',0,1,0,0),(12720,1706,'胜利蒙古族乡',4,'',0,1,0,0),(12721,1707,'东阳镇',4,'',0,1,0,0),(12722,1707,'中兴乡',4,'',0,1,0,0),(12723,1707,'兴隆乡',4,'',0,1,0,0),(12724,1707,'宝山乡',4,'',0,1,0,0),(12725,1707,'巨宝镇',4,'',0,1,0,0),(12726,1707,'平阳镇',4,'',0,1,0,0),(12727,1707,'查哈阳乡',4,'',0,1,0,0),(12728,1707,'甘南镇',4,'',0,1,0,0),(12729,1707,'长山乡',4,'',0,1,0,0),(12730,1707,'音河镇',4,'',0,1,0,0),(12731,1708,'东安街道',4,'',0,1,0,0),(12732,1708,'富强街道',4,'',0,1,0,0),(12733,1708,'繁荣街道',4,'',0,1,0,0),(12734,1708,'跃进街道',4,'',0,1,0,0),(12735,1709,'九井镇',4,'',0,1,0,0),(12736,1709,'二克浅镇',4,'',0,1,0,0),(12737,1709,'六合镇',4,'',0,1,0,0),(12738,1709,'兴旺鄂温克族乡',4,'',0,1,0,0),(12739,1709,'同义镇',4,'',0,1,0,0),(12740,1709,'同心乡',4,'',0,1,0,0),(12741,1709,'和盛乡',4,'',0,1,0,0),(12742,1709,'孔国乡',4,'',0,1,0,0),(12743,1709,'学田镇',4,'',0,1,0,0),(12744,1709,'拉哈镇、',4,'',0,1,0,0),(12745,1709,'老莱镇',4,'',0,1,0,0),(12746,1709,'讷南镇',4,'',0,1,0,0),(12747,1709,'讷河镇',4,'',0,1,0,0),(12748,1709,'通南镇',4,'',0,1,0,0),(12749,1709,'长发镇',4,'',0,1,0,0),(12750,1709,'龙河镇',4,'',0,1,0,0),(12751,1710,'东湖街道',4,'',0,1,0,0),(12752,1710,'光荣街道',4,'',0,1,0,0),(12753,1710,'北局宅街道',4,'',0,1,0,0),(12754,1710,'南浦街道',4,'',0,1,0,0),(12755,1710,'扎龙乡',4,'',0,1,0,0),(12756,1710,'站前街道',4,'',0,1,0,0),(12757,1710,'通东街道',4,'',0,1,0,0),(12758,1710,'龙华街道',4,'',0,1,0,0),(12759,1711,'七棵树镇',4,'',0,1,0,0),(12760,1711,'华民乡',4,'',0,1,0,0),(12761,1711,'哈拉海乡',4,'',0,1,0,0),(12762,1711,'头站乡',4,'',0,1,0,0),(12763,1711,'山泉镇',4,'',0,1,0,0),(12764,1711,'广厚乡',4,'',0,1,0,0),(12765,1711,'景星镇',4,'',0,1,0,0),(12766,1711,'杏山乡',4,'',0,1,0,0),(12767,1711,'济沁河乡',4,'',0,1,0,0),(12768,1711,'白山乡',4,'',0,1,0,0),(12769,1711,'鲁河乡',4,'',0,1,0,0),(12770,1711,'黑岗乡',4,'',0,1,0,0),(12771,1711,'龙兴镇',4,'',0,1,0,0),(12772,1711,'龙江镇',4,'',0,1,0,0),(12773,1712,'五龙街道',4,'',0,1,0,0),(12774,1712,'南航街道',4,'',0,1,0,0),(12775,1712,'彩虹街道',4,'',0,1,0,0),(12776,1712,'正阳街道',4,'',0,1,0,0),(12777,1712,'江安街道',4,'',0,1,0,0),(12778,1712,'湖滨街道',4,'',0,1,0,0),(12779,1713,'东海街道',4,'',0,1,0,0),(12780,1713,'城子河街道',4,'',0,1,0,0),(12781,1713,'城西街道',4,'',0,1,0,0),(12782,1713,'杏花街道',4,'',0,1,0,0),(12783,1713,'正阳街道',4,'',0,1,0,0),(12784,1713,'永丰朝鲜族乡',4,'',0,1,0,0),(12785,1713,'长青乡',4,'',0,1,0,0),(12786,1714,'二人班乡',4,'',0,1,0,0),(12787,1714,'兴凯湖朝鲜族乡',4,'',0,1,0,0),(12788,1714,'兴凯镇',4,'',0,1,0,0),(12789,1714,'和平乡',4,'',0,1,0,0),(12790,1714,'太平乡',4,'',0,1,0,0),(12791,1714,'密山镇',4,'',0,1,0,0),(12792,1714,'富源乡',4,'',0,1,0,0),(12793,1714,'当壁镇',4,'',0,1,0,0),(12794,1714,'承紫河乡',4,'',0,1,0,0),(12795,1714,'杨木乡',4,'',0,1,0,0),(12796,1714,'柳毛乡',4,'',0,1,0,0),(12797,1714,'白泡子乡',4,'',0,1,0,0),(12798,1714,'知一镇',4,'',0,1,0,0),(12799,1714,'裴德镇',4,'',0,1,0,0),(12800,1714,'连珠山镇',4,'',0,1,0,0),(12801,1714,'黑台镇',4,'',0,1,0,0),(12802,1715,'二道河子街道',4,'',0,1,0,0),(12803,1715,'大恒山街道',4,'',0,1,0,0),(12804,1715,'奋斗街道',4,'',0,1,0,0),(12805,1715,'小恒山街道',4,'',0,1,0,0),(12806,1715,'张新街道',4,'',0,1,0,0),(12807,1715,'柳毛乡',4,'',0,1,0,0),(12808,1715,'柳毛街道',4,'',0,1,0,0),(12809,1715,'桦木林街道',4,'',0,1,0,0),(12810,1715,'红旗乡',4,'',0,1,0,0),(12811,1716,'平岗街道',4,'',0,1,0,0),(12812,1716,'石磷街道',4,'',0,1,0,0),(12813,1716,'碱场街道',4,'',0,1,0,0),(12814,1716,'穆棱街道',4,'',0,1,0,0),(12815,1716,'街里街道',4,'',0,1,0,0),(12816,1717,'东兴街道',4,'',0,1,0,0),(12817,1717,'兰岭乡',4,'',0,1,0,0),(12818,1717,'大通沟街道',4,'',0,1,0,0),(12819,1717,'洗煤街道',4,'',0,1,0,0),(12820,1717,'滴道河乡',4,'',0,1,0,0),(12821,1717,'矿里街道',4,'',0,1,0,0),(12822,1718,'东方红镇',4,'',0,1,0,0),(12823,1718,'东诚镇',4,'',0,1,0,0),(12824,1718,'伟光乡',4,'',0,1,0,0),(12825,1718,'宝东镇',4,'',0,1,0,0),(12826,1718,'新乐乡',4,'',0,1,0,0),(12827,1718,'杨岗镇',4,'',0,1,0,0),(12828,1718,'珍宝岛乡',4,'',0,1,0,0),(12829,1718,'虎头镇',4,'',0,1,0,0),(12830,1718,'虎林镇',4,'',0,1,0,0),(12831,1718,'迎春镇',4,'',0,1,0,0),(12832,1718,'阿北乡',4,'',0,1,0,0),(12833,1719,'下亮子乡',4,'',0,1,0,0),(12834,1719,'东海镇',4,'',0,1,0,0),(12835,1719,'八五一零农场',4,'',0,1,0,0),(12836,1719,'兴农镇',4,'',0,1,0,0),(12837,1719,'向阳镇',4,'',0,1,0,0),(12838,1719,'哈达镇',4,'',0,1,0,0),(12839,1719,'平阳镇',4,'',0,1,0,0),(12840,1719,'明德朝鲜族乡',4,'',0,1,0,0),(12841,1719,'永和镇',4,'',0,1,0,0),(12842,1719,'永安镇',4,'',0,1,0,0),(12843,1719,'鸡东镇',4,'',0,1,0,0),(12844,1719,'鸡林朝鲜族乡',4,'',0,1,0,0),(12845,1720,'东风街道',4,'',0,1,0,0),(12846,1720,'南山街道',4,'',0,1,0,0),(12847,1720,'向阳街道',4,'',0,1,0,0),(12848,1720,'立新街道',4,'',0,1,0,0),(12849,1720,'红军路街道',4,'',0,1,0,0),(12850,1720,'红星乡',4,'',0,1,0,0),(12851,1720,'西山街道',4,'',0,1,0,0),(12852,1720,'西郊乡',4,'',0,1,0,0),(12853,1720,'西鸡西街道',4,'',0,1,0,0),(12854,1721,'麻山街道',4,'',0,1,0,0),(12855,1722,'三街街道',4,'',0,1,0,0),(12856,1722,'东山街道',4,'',0,1,0,0),(12857,1722,'东方红乡',4,'',0,1,0,0),(12858,1722,'工人村街道',4,'',0,1,0,0),(12859,1722,'新一街道',4,'',0,1,0,0),(12860,1722,'新华镇',4,'',0,1,0,0),(12861,1722,'红旗乡',4,'',0,1,0,0),(12862,1722,'蔬园乡',4,'',0,1,0,0),(12863,1723,'兴安路街道',4,'',0,1,0,0),(12864,1723,'兴建路街道',4,'',0,1,0,0),(12865,1723,'兴长路街道',4,'',0,1,0,0),(12866,1723,'河东路街道',4,'',0,1,0,0),(12867,1723,'竣德路街道',4,'',0,1,0,0),(12868,1724,'岭北街道',4,'',0,1,0,0),(12869,1724,'岭南街道',4,'',0,1,0,0),(12870,1724,'沟北街道',4,'',0,1,0,0),(12871,1724,'沟南街道',4,'',0,1,0,0),(12872,1725,'六号街道',4,'',0,1,0,0),(12873,1725,'大陆街道',4,'',0,1,0,0),(12874,1725,'富力街道',4,'',0,1,0,0),(12875,1725,'铁东街道',4,'',0,1,0,0),(12876,1725,'铁西街道',4,'',0,1,0,0),(12877,1725,'鹿林山街道',4,'',0,1,0,0),(12878,1726,'光明街道',4,'',0,1,0,0),(12879,1726,'北山街道',4,'',0,1,0,0),(12880,1726,'南翼街道',4,'',0,1,0,0),(12881,1726,'红军街道',4,'',0,1,0,0),(12882,1726,'胜利街道',4,'',0,1,0,0),(12883,1727,'团结街道',4,'',0,1,0,0),(12884,1727,'新南街道',4,'',0,1,0,0),(12885,1727,'湖滨街道',4,'',0,1,0,0),(12886,1727,'红旗街道',4,'',0,1,0,0),(12887,1727,'育才街道',4,'',0,1,0,0),(12888,1727,'解放街道',4,'',0,1,0,0),(12889,1728,'北山乡',4,'',0,1,0,0),(12890,1728,'北岗乡',4,'',0,1,0,0),(12891,1728,'富强乡',4,'',0,1,0,0),(12892,1728,'忠仁镇',4,'',0,1,0,0),(12893,1728,'新富乡',4,'',0,1,0,0),(12894,1728,'福兴满族乡',4,'',0,1,0,0),(12895,1728,'绥东镇',4,'',0,1,0,0),(12896,1728,'绥滨镇',4,'',0,1,0,0),(12897,1728,'连生乡',4,'',0,1,0,0),(12898,1729,'东明朝鲜族乡',4,'',0,1,0,0),(12899,1729,'凤翔镇',4,'',0,1,0,0),(12900,1729,'名山镇',4,'',0,1,0,0),(12901,1729,'团结镇',4,'',0,1,0,0),(12902,1729,'太平沟乡',4,'',0,1,0,0),(12903,1729,'环山乡',4,'',0,1,0,0),(12904,1729,'肇兴镇',4,'',0,1,0,0),(12905,1729,'鹤北镇',4,'',0,1,0,0),(12906,1730,'东建乡',4,'',0,1,0,0),(12907,1730,'兴盛乡',4,'',0,1,0,0),(12908,1730,'兴隆镇',4,'',0,1,0,0),(12909,1730,'友谊镇',4,'',0,1,0,0),(12910,1730,'友邻乡',4,'',0,1,0,0),(12911,1730,'庆丰乡',4,'',0,1,0,0),(12912,1730,'建设乡',4,'',0,1,0,0),(12913,1730,'成富朝鲜族满族乡',4,'',0,1,0,0),(12914,1730,'新镇乡',4,'',0,1,0,0),(12915,1730,'风岗镇',4,'',0,1,0,0),(12916,1730,'龙山镇',4,'',0,1,0,0),(12917,1731,'东荣街道',4,'',0,1,0,0),(12918,1731,'太保镇',4,'',0,1,0,0),(12919,1731,'振兴东路街道',4,'',0,1,0,0),(12920,1731,'振兴中路街道',4,'',0,1,0,0),(12921,1731,'集贤街道',4,'',0,1,0,0),(12922,1732,'七星街道',4,'',0,1,0,0),(12923,1732,'七星镇',4,'',0,1,0,0),(12924,1732,'上游街道',4,'',0,1,0,0),(12925,1732,'东保卫街道',4,'',0,1,0,0),(12926,1732,'双阳街道',4,'',0,1,0,0),(12927,1732,'双鸭山农场',4,'',0,1,0,0),(12928,1732,'新安街道',4,'',0,1,0,0),(12929,1732,'红旗街道',4,'',0,1,0,0),(12930,1732,'跃进街道',4,'',0,1,0,0),(12931,1733,'七星河乡',4,'',0,1,0,0),(12932,1733,'七星泡镇',4,'',0,1,0,0),(12933,1733,'万金山乡',4,'',0,1,0,0),(12934,1733,'五九七农场',4,'',0,1,0,0),(12935,1733,'八五三农场',4,'',0,1,0,0),(12936,1733,'八五二农场',4,'',0,1,0,0),(12937,1733,'夹信子镇',4,'',0,1,0,0),(12938,1733,'宝清镇',4,'',0,1,0,0),(12939,1733,'小城子镇',4,'',0,1,0,0),(12940,1733,'尖山子乡',4,'',0,1,0,0),(12941,1733,'朝阳乡',4,'',0,1,0,0),(12942,1733,'青原镇',4,'',0,1,0,0),(12943,1733,'龙头镇',4,'',0,1,0,0),(12944,1734,'中心站街道',4,'',0,1,0,0),(12945,1734,'二马路街道',4,'',0,1,0,0),(12946,1734,'八马路街道',4,'',0,1,0,0),(12947,1734,'安邦乡',4,'',0,1,0,0),(12948,1734,'富安街道',4,'',0,1,0,0),(12949,1734,'窑地街道',4,'',0,1,0,0),(12950,1734,'铁西街道',4,'',0,1,0,0),(12951,1734,'长安街道',4,'',0,1,0,0),(12952,1735,'东山街道',4,'',0,1,0,0),(12953,1735,'中山街道',4,'',0,1,0,0),(12954,1735,'中心街道',4,'',0,1,0,0),(12955,1735,'北山街道',4,'',0,1,0,0),(12956,1735,'南山街道',4,'',0,1,0,0),(12957,1735,'西山街道',4,'',0,1,0,0),(12958,1735,'长胜乡',4,'',0,1,0,0),(12959,1736,'丰乐镇',4,'',0,1,0,0),(12960,1736,'兴安乡',4,'',0,1,0,0),(12961,1736,'升昌镇',4,'',0,1,0,0),(12962,1736,'太平镇',4,'',0,1,0,0),(12963,1736,'永安乡',4,'',0,1,0,0),(12964,1736,'福利镇',4,'',0,1,0,0),(12965,1736,'腰屯乡',4,'',0,1,0,0),(12966,1736,'集贤镇',4,'',0,1,0,0),(12967,1737,'五林洞林场',4,'',0,1,0,0),(12968,1737,'五林洞镇',4,'',0,1,0,0),(12969,1737,'八五九农场',4,'',0,1,0,0),(12970,1737,'四排赫哲族乡',4,'',0,1,0,0),(12971,1737,'大佳河乡',4,'',0,1,0,0),(12972,1737,'大通河乡',4,'',0,1,0,0),(12973,1737,'奇源林场',4,'',0,1,0,0),(12974,1737,'小佳河镇',4,'',0,1,0,0),(12975,1737,'山里乡',4,'',0,1,0,0),(12976,1737,'红卫农场',4,'',0,1,0,0),(12977,1737,'红旗岭农场',4,'',0,1,0,0),(12978,1737,'胜利农场',4,'',0,1,0,0),(12979,1737,'芦源林场',4,'',0,1,0,0),(12980,1737,'西丰镇',4,'',0,1,0,0),(12981,1737,'西林子乡',4,'',0,1,0,0),(12982,1737,'饶河农场',4,'',0,1,0,0),(12983,1737,'饶河镇',4,'',0,1,0,0),(12984,1738,'八井子乡',4,'',0,1,0,0),(12985,1738,'双榆树乡',4,'',0,1,0,0),(12986,1738,'和平牧场',4,'',0,1,0,0),(12987,1738,'大同镇',4,'',0,1,0,0),(12988,1738,'大同镇街道',4,'',0,1,0,0),(12989,1738,'太阳升镇',4,'',0,1,0,0),(12990,1738,'庆葡街道',4,'',0,1,0,0),(12991,1738,'新华街道',4,'',0,1,0,0),(12992,1738,'林源街道',4,'',0,1,0,0),(12993,1738,'林源镇',4,'',0,1,0,0),(12994,1738,'祝三乡',4,'',0,1,0,0),(12995,1738,'立志街道',4,'',0,1,0,0),(12996,1738,'老山头乡',4,'',0,1,0,0),(12997,1738,'高台子镇',4,'',0,1,0,0),(12998,1738,'高平街道',4,'',0,1,0,0),(12999,1739,'一心乡',4,'',0,1,0,0),(13000,1739,'他拉哈镇',4,'',0,1,0,0),(13001,1739,'克尔台乡',4,'',0,1,0,0),(13002,1739,'巴彦查干乡',4,'',0,1,0,0),(13003,1739,'敖林西伯乡',4,'',0,1,0,0),(13004,1739,'江湾乡',4,'',0,1,0,0),(13005,1739,'泰康镇',4,'',0,1,0,0),(13006,1739,'烟筒屯镇',4,'',0,1,0,0),(13007,1739,'白音诺勒乡',4,'',0,1,0,0),(13008,1739,'胡吉吐莫镇',4,'',0,1,0,0),(13009,1739,'腰新乡',4,'',0,1,0,0),(13010,1740,'三合乡',4,'',0,1,0,0),(13011,1740,'东兴乡',4,'',0,1,0,0),(13012,1740,'四合乡',4,'',0,1,0,0),(13013,1740,'宏伟乡',4,'',0,1,0,0),(13014,1740,'林甸镇',4,'',0,1,0,0),(13015,1740,'红旗镇',4,'',0,1,0,0),(13016,1740,'花园乡',4,'',0,1,0,0),(13017,1740,'黎明乡',4,'',0,1,0,0),(13018,1741,'八百垧街道',4,'',0,1,0,0),(13019,1741,'创业街道',4,'',0,1,0,0),(13020,1741,'杏南街道',4,'',0,1,0,0),(13021,1741,'杏树岗镇',4,'',0,1,0,0),(13022,1741,'红岗街道',4,'',0,1,0,0),(13023,1741,'解放街道',4,'',0,1,0,0),(13024,1742,'丰乐镇',4,'',0,1,0,0),(13025,1742,'二井镇',4,'',0,1,0,0),(13026,1742,'兴城镇',4,'',0,1,0,0),(13027,1742,'双发乡',4,'',0,1,0,0),(13028,1742,'托古乡',4,'',0,1,0,0),(13029,1742,'新福乡',4,'',0,1,0,0),(13030,1742,'朝阳乡',4,'',0,1,0,0),(13031,1742,'朝阳沟镇',4,'',0,1,0,0),(13032,1742,'榆树乡',4,'',0,1,0,0),(13033,1742,'永乐镇',4,'',0,1,0,0),(13034,1742,'永胜乡',4,'',0,1,0,0),(13035,1742,'肇州镇',4,'',0,1,0,0),(13036,1743,'三站镇',4,'',0,1,0,0),(13037,1743,'义顺蒙古族乡',4,'',0,1,0,0),(13038,1743,'二站镇',4,'',0,1,0,0),(13039,1743,'古恰乡',4,'',0,1,0,0),(13040,1743,'古龙镇',4,'',0,1,0,0),(13041,1743,'和平乡',4,'',0,1,0,0),(13042,1743,'大兴乡',4,'',0,1,0,0),(13043,1743,'头台镇',4,'',0,1,0,0),(13044,1743,'新站镇',4,'',0,1,0,0),(13045,1743,'民意乡',4,'',0,1,0,0),(13046,1743,'浩德蒙古族乡',4,'',0,1,0,0),(13047,1743,'福兴乡',4,'',0,1,0,0),(13048,1743,'肇源镇',4,'',0,1,0,0),(13049,1743,'茂兴镇',4,'',0,1,0,0),(13050,1743,'薄荷台乡',4,'',0,1,0,0),(13051,1743,'超等蒙古族乡',4,'',0,1,0,0),(13052,1744,'乘风街道',4,'',0,1,0,0),(13053,1744,'喇嘛甸镇',4,'',0,1,0,0),(13054,1744,'奋斗街道',4,'',0,1,0,0),(13055,1744,'庆新街道',4,'',0,1,0,0),(13056,1744,'西宾街道',4,'',0,1,0,0),(13057,1744,'银浪街道',4,'',0,1,0,0),(13058,1744,'龙岗街道',4,'',0,1,0,0),(13059,1745,'东安街道',4,'',0,1,0,0),(13060,1745,'东风街道',4,'',0,1,0,0),(13061,1745,'会战街道',4,'',0,1,0,0),(13062,1745,'友谊街道',4,'',0,1,0,0),(13063,1745,'富强街道',4,'',0,1,0,0),(13064,1745,'拥军街道',4,'',0,1,0,0),(13065,1745,'火炬街道',4,'',0,1,0,0),(13066,1745,'萨尔图街道',4,'',0,1,0,0),(13067,1745,'铁人街道',4,'',0,1,0,0),(13068,1746,'三永街道',4,'',0,1,0,0),(13069,1746,'东光街道',4,'',0,1,0,0),(13070,1746,'兴化村街道',4,'',0,1,0,0),(13071,1746,'卧里屯街道',4,'',0,1,0,0),(13072,1746,'黎明街道',4,'',0,1,0,0),(13073,1746,'龙凤街道',4,'',0,1,0,0),(13074,1746,'龙凤镇',4,'',0,1,0,0),(13075,1747,'卫国林场',4,'',0,1,0,0),(13076,1747,'山峰林场',4,'',0,1,0,0),(13077,1747,'新风林场',4,'',0,1,0,0),(13078,1747,'查山林场',4,'',0,1,0,0),(13079,1747,'永绪经营所',4,'',0,1,0,0),(13080,1747,'溪水经营所',4,'',0,1,0,0),(13081,1747,'红山经营所',4,'',0,1,0,0),(13082,1747,'红山街道',4,'',0,1,0,0),(13083,1747,'美林经营所',4,'',0,1,0,0),(13084,1747,'蔚兰经营所',4,'',0,1,0,0),(13085,1747,'长青经营所',4,'',0,1,0,0),(13086,1747,'阳光林场',4,'',0,1,0,0),(13087,1747,'青山经营所',4,'',0,1,0,0),(13088,1748,'上游林场',4,'',0,1,0,0),(13089,1748,'东克林林场',4,'',0,1,0,0),(13090,1748,'乌伊岭街道',4,'',0,1,0,0),(13091,1748,'前卫林场',4,'',0,1,0,0),(13092,1748,'建新林场',4,'',0,1,0,0),(13093,1748,'林海林场',4,'',0,1,0,0),(13094,1748,'桔源经营所',4,'',0,1,0,0),(13095,1748,'永胜经营所',4,'',0,1,0,0),(13096,1748,'福民林场',4,'',0,1,0,0),(13097,1748,'移山林场',4,'',0,1,0,0),(13098,1748,'美峰林场',4,'',0,1,0,0),(13099,1748,'美林林场',4,'',0,1,0,0),(13100,1748,'阿廷河林场',4,'',0,1,0,0),(13101,1749,'东方红经营所',4,'',0,1,0,0),(13102,1749,'乌马河街道',4,'',0,1,0,0),(13103,1749,'伊东经营所',4,'',0,1,0,0),(13104,1749,'伊敏林场',4,'',0,1,0,0),(13105,1749,'伊林经营所',4,'',0,1,0,0),(13106,1749,'伊青经营所',4,'',0,1,0,0),(13107,1749,'前进经营所',4,'',0,1,0,0),(13108,1749,'安全经营所',4,'',0,1,0,0),(13109,1749,'河北经营所',4,'',0,1,0,0),(13110,1749,'翠岭经营所',4,'',0,1,0,0),(13111,1749,'育苗经营所',4,'',0,1,0,0),(13112,1749,'西岭林场',4,'',0,1,0,0),(13113,1749,'青山林场',4,'',0,1,0,0),(13114,1750,'丽丰林场',4,'',0,1,0,0),(13115,1750,'丽林经营所',4,'',0,1,0,0),(13116,1750,'五星街道',4,'',0,1,0,0),(13117,1750,'五营街道',4,'',0,1,0,0),(13118,1750,'前丰林场',4,'',0,1,0,0),(13119,1750,'平原经营所',4,'',0,1,0,0),(13120,1750,'平山经营所',4,'',0,1,0,0),(13121,1750,'杨树河林场',4,'',0,1,0,0),(13122,1750,'永丰经营所',4,'',0,1,0,0),(13123,1750,'翠北林场',4,'',0,1,0,0),(13124,1751,'东升街道',4,'',0,1,0,0),(13125,1751,'前进街道',4,'',0,1,0,0),(13126,1751,'旭日街道',4,'',0,1,0,0),(13127,1751,'朝阳街道',4,'',0,1,0,0),(13128,1751,'红升街道',4,'',0,1,0,0),(13129,1752,'三岔河林场',4,'',0,1,0,0),(13130,1752,'东升街道',4,'',0,1,0,0),(13131,1752,'亮子河林场',4,'',0,1,0,0),(13132,1752,'南岔经营所',4,'',0,1,0,0),(13133,1752,'四合营林场',4,'',0,1,0,0),(13134,1752,'大磊林场',4,'',0,1,0,0),(13135,1752,'太平经营所',4,'',0,1,0,0),(13136,1752,'奋斗经营所',4,'',0,1,0,0),(13137,1752,'威岭经营所',4,'',0,1,0,0),(13138,1752,'岩石经营所',4,'',0,1,0,0),(13139,1752,'晨明镇',4,'',0,1,0,0),(13140,1752,'松青经营所',4,'',0,1,0,0),(13141,1752,'柳树经营所',4,'',0,1,0,0),(13142,1752,'桦阳经营所',4,'',0,1,0,0),(13143,1752,'梧桐街道',4,'',0,1,0,0),(13144,1752,'浩良河经营所',4,'',0,1,0,0),(13145,1752,'浩良河镇',4,'',0,1,0,0),(13146,1752,'石头河林场',4,'',0,1,0,0),(13147,1752,'翠岗林场',4,'',0,1,0,0),(13148,1752,'联合街道',4,'',0,1,0,0),(13149,1752,'西水街道',4,'',0,1,0,0),(13150,1752,'迎春乡',4,'',0,1,0,0),(13151,1753,'三合经营所',4,'',0,1,0,0),(13152,1753,'东卡林场',4,'',0,1,0,0),(13153,1753,'中心经营所',4,'',0,1,0,0),(13154,1753,'友好街道',4,'',0,1,0,0),(13155,1753,'友谊经营所',4,'',0,1,0,0),(13156,1753,'双子河街道',4,'',0,1,0,0),(13157,1753,'奋斗林场',4,'',0,1,0,0),(13158,1753,'岭峰林场',4,'',0,1,0,0),(13159,1753,'广川经营所',4,'',0,1,0,0),(13160,1753,'朝阳经营所',4,'',0,1,0,0),(13161,1753,'松园林场',4,'',0,1,0,0),(13162,1753,'永青经营所',4,'',0,1,0,0),(13163,1753,'碧云经营所',4,'',0,1,0,0),(13164,1753,'绿源林场',4,'',0,1,0,0),(13165,1753,'铁林街道',4,'',0,1,0,0),(13166,1753,'青杨经营所',4,'',0,1,0,0),(13167,1753,'鸡爪河林场',4,'',0,1,0,0),(13168,1754,'乌云镇',4,'',0,1,0,0),(13169,1754,'乌拉嘎镇',4,'',0,1,0,0),(13170,1754,'保兴乡',4,'',0,1,0,0),(13171,1754,'向阳乡',4,'',0,1,0,0),(13172,1754,'嘉荫农场',4,'',0,1,0,0),(13173,1754,'常胜乡',4,'',0,1,0,0),(13174,1754,'朝阳镇',4,'',0,1,0,0),(13175,1754,'沪嘉乡',4,'',0,1,0,0),(13176,1754,'红光乡',4,'',0,1,0,0),(13177,1754,'青山乡',4,'',0,1,0,0),(13178,1755,'带岭街道',4,'',0,1,0,0),(13179,1755,'青川经营所',4,'',0,1,0,0),(13180,1756,'乌拉嘎经营所',4,'',0,1,0,0),(13181,1756,'兴安街道',4,'',0,1,0,0),(13182,1756,'北沟林场',4,'',0,1,0,0),(13183,1756,'南沟林场',4,'',0,1,0,0),(13184,1756,'新青街道',4,'',0,1,0,0),(13185,1756,'松林经营所',4,'',0,1,0,0),(13186,1756,'柳树河林场',4,'',0,1,0,0),(13187,1756,'桦林林场',4,'',0,1,0,0),(13188,1756,'水源林场',4,'',0,1,0,0),(13189,1756,'汤林林场',4,'',0,1,0,0),(13190,1756,'泉林林场',4,'',0,1,0,0),(13191,1756,'笑山林场',4,'',0,1,0,0),(13192,1756,'红林经营所',4,'',0,1,0,0),(13193,1756,'结源林场',4,'',0,1,0,0),(13194,1756,'青林林场',4,'',0,1,0,0),(13195,1757,'东升林场',4,'',0,1,0,0),(13196,1757,'中心苗圃',4,'',0,1,0,0),(13197,1757,'二清河林场',4,'',0,1,0,0),(13198,1757,'二龙山林场',4,'',0,1,0,0),(13199,1757,'克林经营所',4,'',0,1,0,0),(13200,1757,'团结经营所',4,'',0,1,0,0),(13201,1757,'守虎山林场',4,'',0,1,0,0),(13202,1757,'峻岭林场',4,'',0,1,0,0),(13203,1757,'日新林场',4,'',0,1,0,0),(13204,1757,'河北街道',4,'',0,1,0,0),(13205,1757,'河南街道',4,'',0,1,0,0),(13206,1757,'泉石林场',4,'',0,1,0,0),(13207,1757,'石林林场',4,'',0,1,0,0),(13208,1757,'磨石山经营所',4,'',0,1,0,0),(13209,1757,'育林经营所',4,'',0,1,0,0),(13210,1757,'高峰林场',4,'',0,1,0,0),(13211,1758,'三杨林场',4,'',0,1,0,0),(13212,1758,'二杨河经营所',4,'',0,1,0,0),(13213,1758,'二皮河经营所',4,'',0,1,0,0),(13214,1758,'五星河经营所',4,'',0,1,0,0),(13215,1758,'共青经营所',4,'',0,1,0,0),(13216,1758,'库斯特经营所',4,'',0,1,0,0),(13217,1758,'曙光经营所',4,'',0,1,0,0),(13218,1758,'汤北林场',4,'',0,1,0,0),(13219,1758,'汤南经营所',4,'',0,1,0,0),(13220,1758,'汤洪岭林场',4,'',0,1,0,0),(13221,1758,'清水河林场',4,'',0,1,0,0),(13222,1758,'红星街道',4,'',0,1,0,0),(13223,1758,'霍吉河林场',4,'',0,1,0,0),(13224,1759,'三股流经营所',4,'',0,1,0,0),(13225,1759,'五道库经营所',4,'',0,1,0,0),(13226,1759,'兰新经营所',4,'',0,1,0,0),(13227,1759,'卧龙河林场',4,'',0,1,0,0),(13228,1759,'大西林林场',4,'',0,1,0,0),(13229,1759,'对青山经营所',4,'',0,1,0,0),(13230,1759,'松岭经营所',4,'',0,1,0,0),(13231,1759,'桦皮羌子林场',4,'',0,1,0,0),(13232,1759,'碧仓库林场',4,'',0,1,0,0),(13233,1759,'缓岭经营所',4,'',0,1,0,0),(13234,1759,'美溪街道',4,'',0,1,0,0),(13235,1759,'群峦经营所',4,'',0,1,0,0),(13236,1759,'金沙河林场',4,'',0,1,0,0),(13237,1759,'青山口林场',4,'',0,1,0,0),(13238,1759,'顺利河林场',4,'',0,1,0,0),(13239,1760,'么河经营所',4,'',0,1,0,0),(13240,1760,'冲锋经营所',4,'',0,1,0,0),(13241,1760,'向阳街道',4,'',0,1,0,0),(13242,1760,'尖山河经营所',4,'',0,1,0,0),(13243,1760,'开源河林场',4,'',0,1,0,0),(13244,1760,'抚育河经营所',4,'',0,1,0,0),(13245,1760,'昆仑气林场',4,'',0,1,0,0),(13246,1760,'曙光街道',4,'',0,1,0,0),(13247,1760,'翠峦河经营所',4,'',0,1,0,0),(13248,1760,'解放经营所',4,'',0,1,0,0),(13249,1761,'新兴街道',4,'',0,1,0,0),(13250,1761,'苔青街道',4,'',0,1,0,0),(13251,1761,'西林街道',4,'',0,1,0,0),(13252,1762,'奋斗街道',4,'',0,1,0,0),(13253,1762,'金山街道',4,'',0,1,0,0),(13254,1763,'双丰镇',4,'',0,1,0,0),(13255,1763,'工农乡',4,'',0,1,0,0),(13256,1763,'年丰朝鲜族乡',4,'',0,1,0,0),(13257,1763,'朗乡镇',4,'',0,1,0,0),(13258,1763,'桃山镇',4,'',0,1,0,0),(13259,1763,'王杨乡',4,'',0,1,0,0),(13260,1763,'铁力镇',4,'',0,1,0,0),(13261,1764,'佳东街道',4,'',0,1,0,0),(13262,1764,'佳南街道',4,'',0,1,0,0),(13263,1764,'建国乡',4,'',0,1,0,0),(13264,1764,'建国街道',4,'',0,1,0,0),(13265,1764,'晓云街道',4,'',0,1,0,0),(13266,1764,'松江乡',4,'',0,1,0,0),(13267,1764,'造纸街道',4,'',0,1,0,0),(13268,1765,'亮子河街道',4,'',0,1,0,0),(13269,1765,'南岗街道',4,'',0,1,0,0),(13270,1765,'奋斗街道',4,'',0,1,0,0),(13271,1765,'永安街道',4,'',0,1,0,0),(13272,1765,'田园街道',4,'',0,1,0,0),(13273,1765,'站前街道',4,'',0,1,0,0),(13274,1766,'三村镇',4,'',0,1,0,0),(13275,1766,'临江镇',4,'',0,1,0,0),(13276,1766,'乐业镇',4,'',0,1,0,0),(13277,1766,'八岔赫哲族乡',4,'',0,1,0,0),(13278,1766,'同江镇',4,'',0,1,0,0),(13279,1766,'向阳乡',4,'',0,1,0,0),(13280,1766,'和兴街道',4,'',0,1,0,0),(13281,1766,'安康街道',4,'',0,1,0,0),(13282,1766,'幸福街道',4,'',0,1,0,0),(13283,1766,'杏林街道',4,'',0,1,0,0),(13284,1766,'街津口赫哲族乡',4,'',0,1,0,0),(13285,1766,'金川乡',4,'',0,1,0,0),(13286,1766,'银川乡',4,'',0,1,0,0),(13287,1766,'青河乡',4,'',0,1,0,0),(13288,1767,'保卫街道',4,'',0,1,0,0),(13289,1767,'建设街道',4,'',0,1,0,0),(13290,1767,'桥南街道',4,'',0,1,0,0),(13291,1767,'西南岗街道',4,'',0,1,0,0),(13292,1767,'西林街道',4,'',0,1,0,0),(13293,1767,'长安街道',4,'',0,1,0,0),(13294,1768,'上街基镇',4,'',0,1,0,0),(13295,1768,'二龙山镇',4,'',0,1,0,0),(13296,1768,'兴隆岗镇',4,'',0,1,0,0),(13297,1768,'向阳川镇',4,'',0,1,0,0),(13298,1768,'大榆树镇',4,'',0,1,0,0),(13299,1768,'头林镇',4,'',0,1,0,0),(13300,1768,'宏胜镇',4,'',0,1,0,0),(13301,1768,'富锦镇',4,'',0,1,0,0),(13302,1768,'砚山镇',4,'',0,1,0,0),(13303,1768,'锦山镇',4,'',0,1,0,0),(13304,1768,'长安镇',4,'',0,1,0,0),(13305,1769,'二道河农场',4,'',0,1,0,0),(13306,1769,'别拉洪乡',4,'',0,1,0,0),(13307,1769,'前哨农场',4,'',0,1,0,0),(13308,1769,'前锋农场',4,'',0,1,0,0),(13309,1769,'寒葱沟镇',4,'',0,1,0,0),(13310,1769,'抓吉镇',4,'',0,1,0,0),(13311,1769,'抚远镇',4,'',0,1,0,0),(13312,1769,'浓桥镇',4,'',0,1,0,0),(13313,1769,'浓江乡',4,'',0,1,0,0),(13314,1769,'海青乡',4,'',0,1,0,0),(13315,1769,'通江乡',4,'',0,1,0,0),(13316,1769,'鸭南乡',4,'',0,1,0,0),(13317,1770,'土龙山镇',4,'',0,1,0,0),(13318,1770,'大八浪乡',4,'',0,1,0,0),(13319,1770,'孟家岗镇',4,'',0,1,0,0),(13320,1770,'明义乡',4,'',0,1,0,0),(13321,1770,'桦南镇',4,'',0,1,0,0),(13322,1770,'梨树乡',4,'',0,1,0,0),(13323,1770,'石头河子镇',4,'',0,1,0,0),(13324,1770,'金沙乡',4,'',0,1,0,0),(13325,1770,'闫家镇',4,'',0,1,0,0),(13326,1770,'驼腰子镇',4,'',0,1,0,0),(13327,1771,'东河乡',4,'',0,1,0,0),(13328,1771,'创业乡',4,'',0,1,0,0),(13329,1771,'四马架乡',4,'',0,1,0,0),(13330,1771,'团结街道',4,'',0,1,0,0),(13331,1771,'建民街道',4,'',0,1,0,0),(13332,1771,'悦来镇',4,'',0,1,0,0),(13333,1771,'新城镇',4,'',0,1,0,0),(13334,1771,'星火朝鲜族乡',4,'',0,1,0,0),(13335,1771,'梨丰乡',4,'',0,1,0,0),(13336,1771,'横头山镇',4,'',0,1,0,0),(13337,1771,'苏家店镇',4,'',0,1,0,0),(13338,1771,'荣安街道',4,'',0,1,0,0),(13339,1771,'长新街道',4,'',0,1,0,0),(13340,1772,'吉祥乡',4,'',0,1,0,0),(13341,1772,'太平川乡',4,'',0,1,0,0),(13342,1772,'振兴乡',4,'',0,1,0,0),(13343,1772,'永发乡',4,'',0,1,0,0),(13344,1772,'汤原镇',4,'',0,1,0,0),(13345,1772,'汤旺朝鲜族乡',4,'',0,1,0,0),(13346,1772,'竹帘镇',4,'',0,1,0,0),(13347,1772,'胜利乡',4,'',0,1,0,0),(13348,1772,'香兰镇',4,'',0,1,0,0),(13349,1772,'鹤立镇',4,'',0,1,0,0),(13350,1773,'四丰乡',4,'',0,1,0,0),(13351,1773,'大来镇',4,'',0,1,0,0),(13352,1773,'平安乡',4,'',0,1,0,0),(13353,1773,'建国乡',4,'',0,1,0,0),(13354,1773,'敖其镇',4,'',0,1,0,0),(13355,1773,'望江镇',4,'',0,1,0,0),(13356,1773,'松木河乡',4,'',0,1,0,0),(13357,1773,'松江乡',4,'',0,1,0,0),(13358,1773,'沿江乡',4,'',0,1,0,0),(13359,1773,'群胜乡',4,'',0,1,0,0),(13360,1773,'莲江口镇',4,'',0,1,0,0),(13361,1773,'西格木乡',4,'',0,1,0,0),(13362,1773,'长发镇',4,'',0,1,0,0),(13363,1773,'长青乡',4,'',0,1,0,0),(13364,1773,'高峰乡',4,'',0,1,0,0),(13365,1774,'倭肯镇',4,'',0,1,0,0),(13366,1774,'勃利镇',4,'',0,1,0,0),(13367,1774,'双河镇',4,'',0,1,0,0),(13368,1774,'吉兴乡',4,'',0,1,0,0),(13369,1774,'大四站镇',4,'',0,1,0,0),(13370,1774,'小五站镇',4,'',0,1,0,0),(13371,1774,'恒太乡',4,'',0,1,0,0),(13372,1774,'抢垦乡',4,'',0,1,0,0),(13373,1774,'杏树乡',4,'',0,1,0,0),(13374,1774,'永顺乡',4,'',0,1,0,0),(13375,1774,'罗泉乡',4,'',0,1,0,0),(13376,1774,'镇郊乡',4,'',0,1,0,0),(13377,1774,'长兴乡',4,'',0,1,0,0),(13378,1774,'青山乡',4,'',0,1,0,0),(13379,1775,'兴华街道',4,'',0,1,0,0),(13380,1775,'北山街道',4,'',0,1,0,0),(13381,1775,'新合街道',4,'',0,1,0,0),(13382,1775,'新城街道',4,'',0,1,0,0),(13383,1775,'新安街道',4,'',0,1,0,0),(13384,1775,'新建街道',4,'',0,1,0,0),(13385,1775,'新立街道',4,'',0,1,0,0),(13386,1775,'河南街道',4,'',0,1,0,0),(13387,1775,'红旗镇',4,'',0,1,0,0),(13388,1775,'缸窑沟街道',4,'',0,1,0,0),(13389,1775,'越秀街道',4,'',0,1,0,0),(13390,1776,'万宝河镇',4,'',0,1,0,0),(13391,1776,'兴岗街道',4,'',0,1,0,0),(13392,1776,'桃东街道',4,'',0,1,0,0),(13393,1776,'桃北街道',4,'',0,1,0,0),(13394,1776,'桃南街道',4,'',0,1,0,0),(13395,1776,'桃山街道',4,'',0,1,0,0),(13396,1776,'桃西街道',4,'',0,1,0,0),(13397,1777,'东风街道',4,'',0,1,0,0),(13398,1777,'中心河乡',4,'',0,1,0,0),(13399,1777,'向阳街道',4,'',0,1,0,0),(13400,1777,'宏伟镇',4,'',0,1,0,0),(13401,1777,'富强街道',4,'',0,1,0,0),(13402,1777,'新富街道',4,'',0,1,0,0),(13403,1777,'茄子河镇',4,'',0,1,0,0),(13404,1777,'铁山乡',4,'',0,1,0,0),(13405,1777,'龙湖街道',4,'',0,1,0,0),(13406,1778,'三岔口',4,'',0,1,0,0),(13407,1778,'东宁镇',4,'',0,1,0,0),(13408,1778,'大肚川镇',4,'',0,1,0,0),(13409,1778,'绥阳镇',4,'',0,1,0,0),(13410,1778,'老黑山镇',4,'',0,1,0,0),(13411,1778,'道河镇',4,'',0,1,0,0),(13412,1779,'七星街道',4,'',0,1,0,0),(13413,1779,'五星街道',4,'',0,1,0,0),(13414,1779,'兴隆镇',4,'',0,1,0,0),(13415,1779,'新安街道',4,'',0,1,0,0),(13416,1779,'长安街道',4,'',0,1,0,0),(13417,1780,'三陵乡',4,'',0,1,0,0),(13418,1780,'东京城林业局',4,'',0,1,0,0),(13419,1780,'东京城镇',4,'',0,1,0,0),(13420,1780,'东关社区',4,'',0,1,0,0),(13421,1780,'乐园社区',4,'',0,1,0,0),(13422,1780,'兰岗镇',4,'',0,1,0,0),(13423,1780,'卧龙朝鲜族乡',4,'',0,1,0,0),(13424,1780,'宁安镇',4,'',0,1,0,0),(13425,1780,'文庙社区',4,'',0,1,0,0),(13426,1780,'江南朝鲜族满族乡',4,'',0,1,0,0),(13427,1780,'沙兰镇',4,'',0,1,0,0),(13428,1780,'海浪镇',4,'',0,1,0,0),(13429,1780,'渤海镇',4,'',0,1,0,0),(13430,1780,'石岩镇',4,'',0,1,0,0),(13431,1780,'虹桥社区',4,'',0,1,0,0),(13432,1780,'西关社区',4,'',0,1,0,0),(13433,1780,'铁工社区',4,'',0,1,0,0),(13434,1780,'镜泊乡',4,'',0,1,0,0),(13435,1780,'马河乡',4,'',0,1,0,0),(13436,1781,'三道通镇',4,'',0,1,0,0),(13437,1781,'五林镇',4,'',0,1,0,0),(13438,1781,'刁翎镇',4,'',0,1,0,0),(13439,1781,'古城镇',4,'',0,1,0,0),(13440,1781,'奎山乡',4,'',0,1,0,0),(13441,1781,'建堂乡',4,'',0,1,0,0),(13442,1781,'朱家镇',4,'',0,1,0,0),(13443,1781,'林口镇',4,'',0,1,0,0),(13444,1781,'柳树镇',4,'',0,1,0,0),(13445,1781,'莲花镇',4,'',0,1,0,0),(13446,1781,'青山乡',4,'',0,1,0,0),(13447,1781,'龙爪镇',4,'',0,1,0,0),(13448,1782,'三道镇',4,'',0,1,0,0),(13449,1782,'二道镇',4,'',0,1,0,0),(13450,1782,'山市镇',4,'',0,1,0,0),(13451,1782,'新安朝鲜族镇',4,'',0,1,0,0),(13452,1782,'柴河镇',4,'',0,1,0,0),(13453,1782,'横道镇',4,'',0,1,0,0),(13454,1782,'海南朝鲜族乡',4,'',0,1,0,0),(13455,1782,'海林镇',4,'',0,1,0,0),(13456,1782,'长汀镇',4,'',0,1,0,0),(13457,1783,'兴平街道',4,'',0,1,0,0),(13458,1783,'北安乡',4,'',0,1,0,0),(13459,1783,'北山街道',4,'',0,1,0,0),(13460,1783,'向阳街道',4,'',0,1,0,0),(13461,1783,'大庆街道',4,'',0,1,0,0),(13462,1783,'新华街道',4,'',0,1,0,0),(13463,1783,'铁北街道',4,'',0,1,0,0),(13464,1783,'黄花街道',4,'',0,1,0,0),(13465,1784,'下城子镇',4,'',0,1,0,0),(13466,1784,'八面通林业局',4,'',0,1,0,0),(13467,1784,'八面通镇',4,'',0,1,0,0),(13468,1784,'共和乡',4,'',0,1,0,0),(13469,1784,'兴源镇',4,'',0,1,0,0),(13470,1784,'河西乡',4,'',0,1,0,0),(13471,1784,'磨刀石镇',4,'',0,1,0,0),(13472,1784,'福录乡',4,'',0,1,0,0),(13473,1784,'穆棱林业局',4,'',0,1,0,0),(13474,1784,'穆棱镇',4,'',0,1,0,0),(13475,1784,'马桥河镇',4,'',0,1,0,0),(13476,1785,'绥芬河镇',4,'',0,1,0,0),(13477,1785,'阜宁镇',4,'',0,1,0,0),(13478,1786,'先锋街道',4,'',0,1,0,0),(13479,1786,'江滨街道',4,'',0,1,0,0),(13480,1786,'沿江乡',4,'',0,1,0,0),(13481,1786,'沿江街道',4,'',0,1,0,0),(13482,1786,'温春镇',4,'',0,1,0,0),(13483,1786,'火炬街道',4,'',0,1,0,0),(13484,1786,'牡丹街道',4,'',0,1,0,0),(13485,1786,'立新街道',4,'',0,1,0,0),(13486,1787,'前进街道',4,'',0,1,0,0),(13487,1787,'新兴街道',4,'',0,1,0,0),(13488,1787,'桦林橡胶厂街道',4,'',0,1,0,0),(13489,1787,'桦林镇',4,'',0,1,0,0),(13490,1787,'铁岭镇',4,'',0,1,0,0),(13491,1787,'阳明街道',4,'',0,1,0,0),(13492,1788,'五大连池镇',4,'',0,1,0,0),(13493,1788,'兴安乡',4,'',0,1,0,0),(13494,1788,'兴隆乡',4,'',0,1,0,0),(13495,1788,'双泉乡',4,'',0,1,0,0),(13496,1788,'和平镇',4,'',0,1,0,0),(13497,1788,'团结乡',4,'',0,1,0,0),(13498,1788,'太平乡',4,'',0,1,0,0),(13499,1788,'建设乡',4,'',0,1,0,0),(13500,1788,'新发乡',4,'',0,1,0,0),(13501,1788,'朝阳乡',4,'',0,1,0,0),(13502,1788,'青山街道',4,'',0,1,0,0),(13503,1788,'龙镇',4,'',0,1,0,0),(13504,1789,'东胜乡',4,'',0,1,0,0),(13505,1789,'主星朝鲜族乡',4,'',0,1,0,0),(13506,1789,'二井镇',4,'',0,1,0,0),(13507,1789,'兆麟街道',4,'',0,1,0,0),(13508,1789,'北岗街道',4,'',0,1,0,0),(13509,1789,'和平街道',4,'',0,1,0,0),(13510,1789,'城郊乡',4,'',0,1,0,0),(13511,1789,'庆华街道',4,'',0,1,0,0),(13512,1789,'杨家乡',4,'',0,1,0,0),(13513,1789,'海星镇',4,'',0,1,0,0),(13514,1789,'石泉镇',4,'',0,1,0,0),(13515,1789,'赵光镇',4,'',0,1,0,0),(13516,1789,'通北镇',4,'',0,1,0,0),(13517,1789,'铁南街道',4,'',0,1,0,0),(13518,1789,'铁西街道',4,'',0,1,0,0),(13519,1790,'临江乡',4,'',0,1,0,0),(13520,1790,'伊拉哈镇',4,'',0,1,0,0),(13521,1790,'前进镇',4,'',0,1,0,0),(13522,1790,'双山镇',4,'',0,1,0,0),(13523,1790,'塔溪乡',4,'',0,1,0,0),(13524,1790,'多宝山镇',4,'',0,1,0,0),(13525,1790,'嫩江镇',4,'',0,1,0,0),(13526,1790,'海江镇',4,'',0,1,0,0),(13527,1790,'白云乡',4,'',0,1,0,0),(13528,1790,'科洛镇',4,'',0,1,0,0),(13529,1790,'联兴乡',4,'',0,1,0,0),(13530,1790,'长江乡',4,'',0,1,0,0),(13531,1790,'长福镇',4,'',0,1,0,0),(13532,1790,'霍龙门乡',4,'',0,1,0,0),(13533,1791,'卧牛河乡',4,'',0,1,0,0),(13534,1791,'城区街道',4,'',0,1,0,0),(13535,1791,'奋斗乡',4,'',0,1,0,0),(13536,1791,'孙吴镇',4,'',0,1,0,0),(13537,1791,'正阳山乡',4,'',0,1,0,0),(13538,1791,'沿江满族乡',4,'',0,1,0,0),(13539,1791,'清溪乡',4,'',0,1,0,0),(13540,1791,'红旗乡',4,'',0,1,0,0),(13541,1791,'群山乡',4,'',0,1,0,0),(13542,1791,'腰屯乡',4,'',0,1,0,0),(13543,1791,'西兴乡',4,'',0,1,0,0),(13544,1791,'辰清镇',4,'',0,1,0,0),(13545,1792,'上马厂乡',4,'',0,1,0,0),(13546,1792,'二站乡',4,'',0,1,0,0),(13547,1792,'兴安街道',4,'',0,1,0,0),(13548,1792,'四嘉子满族乡',4,'',0,1,0,0),(13549,1792,'坤河达斡尔族满族乡',4,'',0,1,0,0),(13550,1792,'幸福乡',4,'',0,1,0,0),(13551,1792,'张地营子乡',4,'',0,1,0,0),(13552,1792,'新生鄂伦春族乡',4,'',0,1,0,0),(13553,1792,'海兰街道',4,'',0,1,0,0),(13554,1792,'爱辉镇',4,'',0,1,0,0),(13555,1792,'罕达汽镇',4,'',0,1,0,0),(13556,1792,'花园街道',4,'',0,1,0,0),(13557,1792,'西兴街道',4,'',0,1,0,0),(13558,1792,'西岗子镇',4,'',0,1,0,0),(13559,1792,'西峰山乡',4,'',0,1,0,0),(13560,1793,'陆乡',4,'',0,1,0,0),(13561,1794,'克林乡',4,'',0,1,0,0),(13562,1794,'奇克街道',4,'',0,1,0,0),(13563,1794,'宝山乡',4,'',0,1,0,0),(13564,1794,'干岔子乡',4,'',0,1,0,0),(13565,1794,'新兴鄂伦春族乡',4,'',0,1,0,0),(13566,1794,'新鄂鄂伦春族乡',4,'',0,1,0,0),(13567,1794,'松树沟乡',4,'',0,1,0,0),(13568,1794,'边疆镇',4,'',0,1,0,0),(13569,1794,'逊河镇',4,'',0,1,0,0),(13570,1795,'临江镇',4,'',0,1,0,0),(13571,1795,'兰河乡',4,'',0,1,0,0),(13572,1795,'兰西镇',4,'',0,1,0,0),(13573,1795,'北安乡',4,'',0,1,0,0),(13574,1795,'奋斗乡',4,'',0,1,0,0),(13575,1795,'平山镇',4,'',0,1,0,0),(13576,1795,'康荣乡',4,'',0,1,0,0),(13577,1795,'星火乡',4,'',0,1,0,0),(13578,1795,'榆林镇',4,'',0,1,0,0),(13579,1795,'燎原乡',4,'',0,1,0,0),(13580,1795,'红光乡',4,'',0,1,0,0),(13581,1795,'红星乡',4,'',0,1,0,0),(13582,1795,'远大乡',4,'',0,1,0,0),(13583,1795,'长岗乡',4,'',0,1,0,0),(13584,1795,'长江乡',4,'',0,1,0,0),(13585,1796,'万宝山镇',4,'',0,1,0,0),(13586,1796,'中本镇',4,'',0,1,0,0),(13587,1796,'任民镇',4,'',0,1,0,0),(13588,1796,'先源乡',4,'',0,1,0,0),(13589,1796,'升平镇',4,'',0,1,0,0),(13590,1796,'卧里屯乡',4,'',0,1,0,0),(13591,1796,'吉兴岗镇',4,'',0,1,0,0),(13592,1796,'太平庄镇',4,'',0,1,0,0),(13593,1796,'安虹街道',4,'',0,1,0,0),(13594,1796,'安达镇',4,'',0,1,0,0),(13595,1796,'新兴街道',4,'',0,1,0,0),(13596,1796,'昌德镇',4,'',0,1,0,0),(13597,1796,'火石山乡',4,'',0,1,0,0),(13598,1796,'羊草镇',4,'',0,1,0,0),(13599,1796,'老虎岗镇',4,'',0,1,0,0),(13600,1796,'铁西街道',4,'',0,1,0,0),(13601,1796,'青肯泡乡',4,'',0,1,0,0),(13602,1797,'丰收乡',4,'',0,1,0,0),(13603,1797,'久胜镇',4,'',0,1,0,0),(13604,1797,'勤劳镇',4,'',0,1,0,0),(13605,1797,'发展乡',4,'',0,1,0,0),(13606,1797,'同乐乡',4,'',0,1,0,0),(13607,1797,'大罗镇',4,'',0,1,0,0),(13608,1797,'巨宝山乡',4,'',0,1,0,0),(13609,1797,'平安镇',4,'',0,1,0,0),(13610,1797,'庆安镇',4,'',0,1,0,0),(13611,1797,'建民乡',4,'',0,1,0,0),(13612,1797,'新胜乡',4,'',0,1,0,0),(13613,1797,'欢胜乡',4,'',0,1,0,0),(13614,1797,'民乐镇',4,'',0,1,0,0),(13615,1797,'致富乡',4,'',0,1,0,0),(13616,1798,'光荣乡',4,'',0,1,0,0),(13617,1798,'兴仁镇',4,'',0,1,0,0),(13618,1798,'双兴乡',4,'',0,1,0,0),(13619,1798,'崇德镇',4,'',0,1,0,0),(13620,1798,'明水镇',4,'',0,1,0,0),(13621,1798,'树人乡',4,'',0,1,0,0),(13622,1798,'永久乡',4,'',0,1,0,0),(13623,1798,'永兴镇',4,'',0,1,0,0),(13624,1798,'繁荣乡',4,'',0,1,0,0),(13625,1798,'育林乡',4,'',0,1,0,0),(13626,1798,'通泉乡',4,'',0,1,0,0),(13627,1798,'通达镇',4,'',0,1,0,0),(13628,1799,'东升乡',4,'',0,1,0,0),(13629,1799,'东郊乡',4,'',0,1,0,0),(13630,1799,'先锋镇',4,'',0,1,0,0),(13631,1799,'卫星镇',4,'',0,1,0,0),(13632,1799,'厢白满族乡',4,'',0,1,0,0),(13633,1799,'后三乡',4,'',0,1,0,0),(13634,1799,'恭六乡',4,'',0,1,0,0),(13635,1799,'惠七满族镇',4,'',0,1,0,0),(13636,1799,'望奎镇',4,'',0,1,0,0),(13637,1799,'海丰镇',4,'',0,1,0,0),(13638,1799,'火箭乡',4,'',0,1,0,0),(13639,1799,'灯塔乡',4,'',0,1,0,0),(13640,1799,'灵山满族乡',4,'',0,1,0,0),(13641,1799,'莲花镇',4,'',0,1,0,0),(13642,1799,'通江镇',4,'',0,1,0,0),(13643,1800,'东方红水库地区',4,'',0,1,0,0),(13644,1800,'东林乡',4,'',0,1,0,0),(13645,1800,'东风镇',4,'',0,1,0,0),(13646,1800,'丰山乡',4,'',0,1,0,0),(13647,1800,'乐业乡',4,'',0,1,0,0),(13648,1800,'伦河镇',4,'',0,1,0,0),(13649,1800,'共合镇',4,'',0,1,0,0),(13650,1800,'共荣乡',4,'',0,1,0,0),(13651,1800,'前进乡',4,'',0,1,0,0),(13652,1800,'双录乡',4,'',0,1,0,0),(13653,1800,'向荣乡',4,'',0,1,0,0),(13654,1800,'扎音河乡',4,'',0,1,0,0),(13655,1800,'林场公司',4,'',0,1,0,0),(13656,1800,'永和乡',4,'',0,1,0,0),(13657,1800,'永富乡',4,'',0,1,0,0),(13658,1800,'海伦农场',4,'',0,1,0,0),(13659,1800,'海伦绥化种畜场',4,'',0,1,0,0),(13660,1800,'海伦镇',4,'',0,1,0,0),(13661,1800,'海兴镇',4,'',0,1,0,0),(13662,1800,'海北镇',4,'',0,1,0,0),(13663,1800,'海南乡',4,'',0,1,0,0),(13664,1800,'爱民乡',4,'',0,1,0,0),(13665,1800,'百祥乡',4,'',0,1,0,0),(13666,1800,'祥富镇',4,'',0,1,0,0),(13667,1800,'福民乡',4,'',0,1,0,0),(13668,1800,'红光农场',4,'',0,1,0,0),(13669,1800,'联发乡',4,'',0,1,0,0),(13670,1800,'长发乡',4,'',0,1,0,0),(13671,1801,'三井乡',4,'',0,1,0,0),(13672,1801,'三河镇',4,'',0,1,0,0),(13673,1801,'东兴办事处',4,'',0,1,0,0),(13674,1801,'东富乡',4,'',0,1,0,0),(13675,1801,'东津镇',4,'',0,1,0,0),(13676,1801,'五营乡',4,'',0,1,0,0),(13677,1801,'兴和朝鲜族乡',4,'',0,1,0,0),(13678,1801,'兴福乡',4,'',0,1,0,0),(13679,1801,'北林办事处',4,'',0,1,0,0),(13680,1801,'双河镇',4,'',0,1,0,0),(13681,1801,'吉泰街道',4,'',0,1,0,0),(13682,1801,'四方台镇',4,'',0,1,0,0),(13683,1801,'大有街道',4,'',0,1,0,0),(13684,1801,'太平川镇',4,'',0,1,0,0),(13685,1801,'宝山镇',4,'',0,1,0,0),(13686,1801,'张维镇',4,'',0,1,0,0),(13687,1801,'新华乡',4,'',0,1,0,0),(13688,1801,'永安满族镇',4,'',0,1,0,0),(13689,1801,'津河镇',4,'',0,1,0,0),(13690,1801,'爱路街道',4,'',0,1,0,0),(13691,1801,'秦家镇',4,'',0,1,0,0),(13692,1801,'紫来街道',4,'',0,1,0,0),(13693,1801,'红旗满族乡',4,'',0,1,0,0),(13694,1801,'绥胜满族镇',4,'',0,1,0,0),(13695,1801,'西长发镇',4,'',0,1,0,0),(13696,1801,'连岗乡',4,'',0,1,0,0),(13697,1802,'上集镇',4,'',0,1,0,0),(13698,1802,'克音河乡',4,'',0,1,0,0),(13699,1802,'双岔河镇',4,'',0,1,0,0),(13700,1802,'后头乡',4,'',0,1,0,0),(13701,1802,'四海店镇',4,'',0,1,0,0),(13702,1802,'泥尔河乡',4,'',0,1,0,0),(13703,1802,'绥中乡',4,'',0,1,0,0),(13704,1802,'绥棱镇',4,'',0,1,0,0),(13705,1802,'长山乡',4,'',0,1,0,0),(13706,1802,'阁山乡',4,'',0,1,0,0),(13707,1802,'靠山乡',4,'',0,1,0,0),(13708,1803,'东升区办事处',4,'',0,1,0,0),(13709,1803,'东发办事处',4,'',0,1,0,0),(13710,1803,'五站镇',4,'',0,1,0,0),(13711,1803,'五里明镇',4,'',0,1,0,0),(13712,1803,'向阳乡',4,'',0,1,0,0),(13713,1803,'四方山农场',4,'',0,1,0,0),(13714,1803,'四站镇',4,'',0,1,0,0),(13715,1803,'太平乡',4,'',0,1,0,0),(13716,1803,'姜家镇',4,'',0,1,0,0),(13717,1803,'安民乡',4,'',0,1,0,0),(13718,1803,'宋站镇',4,'',0,1,0,0),(13719,1803,'宣化乡',4,'',0,1,0,0),(13720,1803,'尚家镇',4,'',0,1,0,0),(13721,1803,'德昌乡',4,'',0,1,0,0),(13722,1803,'昌五镇',4,'',0,1,0,0),(13723,1803,'明久乡',4,'',0,1,0,0),(13724,1803,'朝阳区办事处',4,'',0,1,0,0),(13725,1803,'正阳区办事处',4,'',0,1,0,0),(13726,1803,'洪河乡',4,'',0,1,0,0),(13727,1803,'海城乡',4,'',0,1,0,0),(13728,1803,'涝洲镇',4,'',0,1,0,0),(13729,1803,'肇东镇',4,'',0,1,0,0),(13730,1803,'西八里乡',4,'',0,1,0,0),(13731,1803,'西园区办事处',4,'',0,1,0,0),(13732,1803,'跃进乡',4,'',0,1,0,0),(13733,1803,'里木店镇',4,'',0,1,0,0),(13734,1803,'黎明镇',4,'',0,1,0,0),(13735,1804,'中和镇',4,'',0,1,0,0),(13736,1804,'兴华镇',4,'',0,1,0,0),(13737,1804,'劳动乡',4,'',0,1,0,0),(13738,1804,'建设乡',4,'',0,1,0,0),(13739,1804,'德胜乡',4,'',0,1,0,0),(13740,1804,'新村乡',4,'',0,1,0,0),(13741,1804,'昌盛乡',4,'',0,1,0,0),(13742,1804,'柞岗乡',4,'',0,1,0,0),(13743,1804,'民政乡',4,'',0,1,0,0),(13744,1804,'永丰镇',4,'',0,1,0,0),(13745,1804,'祯祥镇',4,'',0,1,0,0),(13746,1804,'芦河镇',4,'',0,1,0,0),(13747,1804,'迎春乡',4,'',0,1,0,0),(13748,1804,'连丰乡',4,'',0,1,0,0),(13749,1804,'青冈原种场',4,'',0,1,0,0),(13750,1804,'青冈种羊场',4,'',0,1,0,0),(13751,1804,'青冈种马场',4,'',0,1,0,0),(13752,1804,'青冈镇',4,'',0,1,0,0),(13753,1805,'三卡乡',4,'',0,1,0,0),(13754,1805,'兴华乡',4,'',0,1,0,0),(13755,1805,'北疆乡',4,'',0,1,0,0),(13756,1805,'呼玛镇',4,'',0,1,0,0),(13757,1805,'白银纳鄂伦春族乡',4,'',0,1,0,0),(13758,1805,'金山乡',4,'',0,1,0,0),(13759,1805,'韩家园林业局',4,'',0,1,0,0),(13760,1805,'韩家园镇',4,'',0,1,0,0),(13761,1805,'鸥浦乡',4,'',0,1,0,0),(13762,1806,'依西肯乡',4,'',0,1,0,0),(13763,1806,'十八站林业局',4,'',0,1,0,0),(13764,1806,'十八站鄂伦春族乡',4,'',0,1,0,0),(13765,1806,'塔河镇',4,'',0,1,0,0),(13766,1806,'开库康乡',4,'',0,1,0,0),(13767,1806,'瓦拉干镇',4,'',0,1,0,0),(13768,1806,'盘古镇',4,'',0,1,0,0),(13769,1807,'东山街道',4,'',0,1,0,0),(13770,1807,'光明街道',4,'',0,1,0,0),(13771,1807,'加北乡',4,'',0,1,0,0),(13772,1807,'加格达奇林业局',4,'',0,1,0,0),(13773,1807,'卫东街道',4,'',0,1,0,0),(13774,1807,'曙光街道',4,'',0,1,0,0),(13775,1807,'白桦乡',4,'',0,1,0,0),(13776,1807,'红旗街道',4,'',0,1,0,0),(13777,1807,'长虹街道',4,'',0,1,0,0),(13778,1808,'呼中镇',4,'',0,1,0,0),(13779,1808,'呼源镇',4,'',0,1,0,0),(13780,1808,'宏伟镇',4,'',0,1,0,0),(13781,1808,'碧水镇',4,'',0,1,0,0),(13782,1809,'塔尔根镇',4,'',0,1,0,0),(13783,1809,'塔源镇',4,'',0,1,0,0),(13784,1809,'大乌苏镇',4,'',0,1,0,0),(13785,1809,'宏图镇',4,'',0,1,0,0),(13786,1809,'新林镇',4,'',0,1,0,0),(13787,1809,'碧洲镇',4,'',0,1,0,0),(13788,1809,'翠岗镇',4,'',0,1,0,0),(13789,1810,'劲松镇',4,'',0,1,0,0),(13790,1810,'古源镇',4,'',0,1,0,0),(13791,1810,'小扬气镇',4,'',0,1,0,0),(13792,1811,'兴安镇',4,'',0,1,0,0),(13793,1811,'劲涛镇',4,'',0,1,0,0),(13794,1811,'北极乡',4,'',0,1,0,0),(13795,1811,'图强镇',4,'',0,1,0,0),(13796,1811,'西林吉镇',4,'',0,1,0,0),(13797,2027,'宝塔桥街道',4,'',0,1,0,0),(13798,2027,'小市街道',4,'',0,1,0,0),(13799,2027,'幕府山街道',4,'',0,1,0,0),(13800,2027,'建宁路街道',4,'',0,1,0,0),(13801,2027,'热河南路街道',4,'',0,1,0,0),(13802,2027,'阅江楼街道',4,'',0,1,0,0),(13803,2028,'东沟镇',4,'',0,1,0,0),(13804,2028,'八百桥镇',4,'',0,1,0,0),(13805,2028,'冶山镇',4,'',0,1,0,0),(13806,2028,'卸甲甸街道',4,'',0,1,0,0),(13807,2028,'山潘街道',4,'',0,1,0,0),(13808,2028,'新篁镇',4,'',0,1,0,0),(13809,2028,'新集镇',4,'',0,1,0,0),(13810,2028,'横梁镇',4,'',0,1,0,0),(13811,2028,'玉带镇',4,'',0,1,0,0),(13812,2028,'瓜埠镇',4,'',0,1,0,0),(13813,2028,'程桥镇',4,'',0,1,0,0),(13814,2028,'竹镇镇',4,'',0,1,0,0),(13815,2028,'葛塘街道',4,'',0,1,0,0),(13816,2028,'西厂门街道',4,'',0,1,0,0),(13817,2028,'长芦街道',4,'',0,1,0,0),(13818,2028,'雄州镇',4,'',0,1,0,0),(13819,2028,'马集镇',4,'',0,1,0,0),(13820,2028,'马鞍镇',4,'',0,1,0,0),(13821,2028,'龙袍镇',4,'',0,1,0,0),(13822,2029,'兴隆街道',4,'',0,1,0,0),(13823,2029,'南湖街道',4,'',0,1,0,0),(13824,2029,'南苑街道',4,'',0,1,0,0),(13825,2029,'双闸街道',4,'',0,1,0,0),(13826,2029,'江心洲街道',4,'',0,1,0,0),(13827,2029,'沙洲街道',4,'',0,1,0,0),(13828,2029,'滨湖街道',4,'',0,1,0,0),(13829,2030,'仙林街道',4,'',0,1,0,0),(13830,2030,'八卦洲街道',4,'',0,1,0,0),(13831,2030,'尧化街道',4,'',0,1,0,0),(13832,2030,'栖霞街道',4,'',0,1,0,0),(13833,2030,'燕子矶街道',4,'',0,1,0,0),(13834,2030,'迈皋桥街道',4,'',0,1,0,0),(13835,2030,'靖安街道',4,'',0,1,0,0),(13836,2030,'马群街道',4,'',0,1,0,0),(13837,2030,'龙潭街道',4,'',0,1,0,0),(13838,2031,'东山街道',4,'',0,1,0,0),(13839,2031,'横溪镇',4,'',0,1,0,0),(13840,2031,'江宁街道',4,'',0,1,0,0),(13841,2031,'汤山街道',4,'',0,1,0,0),(13842,2031,'淳化街道',4,'',0,1,0,0),(13843,2031,'湖熟镇',4,'',0,1,0,0),(13844,2031,'禄口街道',4,'',0,1,0,0),(13845,2031,'秣陵街道',4,'',0,1,0,0),(13846,2031,'谷里街道',4,'',0,1,0,0),(13847,2032,'乌江镇',4,'',0,1,0,0),(13848,2032,'南京高新技术产业开发区',4,'',0,1,0,0),(13849,2032,'星甸镇',4,'',0,1,0,0),(13850,2032,'桥林镇',4,'',0,1,0,0),(13851,2032,'永宁镇',4,'',0,1,0,0),(13852,2032,'江浦街道',4,'',0,1,0,0),(13853,2032,'汤泉农场',4,'',0,1,0,0),(13854,2032,'汤泉镇',4,'',0,1,0,0),(13855,2032,'沿江街道',4,'',0,1,0,0),(13856,2032,'泰山街道',4,'',0,1,0,0),(13857,2032,'盘城镇',4,'',0,1,0,0),(13858,2032,'石桥镇',4,'',0,1,0,0),(13859,2032,'老山林场',4,'',0,1,0,0),(13860,2032,'顶山街道',4,'',0,1,0,0),(13861,2033,'东屏镇',4,'',0,1,0,0),(13862,2033,'和凤镇',4,'',0,1,0,0),(13863,2033,'晶桥镇',4,'',0,1,0,0),(13864,2033,'柘塘镇',4,'',0,1,0,0),(13865,2033,'永阳镇',4,'',0,1,0,0),(13866,2033,'洪蓝镇',4,'',0,1,0,0),(13867,2033,'溧水县林场',4,'',0,1,0,0),(13868,2033,'溧水开发区',4,'',0,1,0,0),(13869,2033,'白马镇',4,'',0,1,0,0),(13870,2033,'石湫镇',4,'',0,1,0,0),(13871,2034,'丹凤街街道',4,'',0,1,0,0),(13872,2034,'兰园街道',4,'',0,1,0,0),(13873,2034,'卫岗街道',4,'',0,1,0,0),(13874,2034,'后宰门街道',4,'',0,1,0,0),(13875,2034,'孝陵卫街道',4,'',0,1,0,0),(13876,2034,'新街口街道',4,'',0,1,0,0),(13877,2034,'梅园新村街道',4,'',0,1,0,0),(13878,2034,'玄武湖街道',4,'',0,1,0,0),(13879,2034,'玄武门街道',4,'',0,1,0,0),(13880,2034,'红山街道',4,'',0,1,0,0),(13881,2034,'锁金村街道',4,'',0,1,0,0),(13882,2035,'五老村街道',4,'',0,1,0,0),(13883,2035,'光华路街道',4,'',0,1,0,0),(13884,2035,'大光路街道',4,'',0,1,0,0),(13885,2035,'建康路街道',4,'',0,1,0,0),(13886,2035,'朝天宫街道',4,'',0,1,0,0),(13887,2035,'止马营街道',4,'',0,1,0,0),(13888,2035,'洪武路街道',4,'',0,1,0,0),(13889,2035,'淮海路街道',4,'',0,1,0,0),(13890,2035,'瑞金路街道',4,'',0,1,0,0),(13891,2035,'苜蓿园街道',4,'',0,1,0,0),(13892,2036,'中华门街道',4,'',0,1,0,0),(13893,2036,'双塘街道',4,'',0,1,0,0),(13894,2036,'夫子庙街道',4,'',0,1,0,0),(13895,2036,'秦虹街道',4,'',0,1,0,0),(13896,2036,'红花街道',4,'',0,1,0,0),(13897,2037,'宁南街道',4,'',0,1,0,0),(13898,2037,'板桥街道',4,'',0,1,0,0),(13899,2037,'梅山街道',4,'',0,1,0,0),(13900,2037,'西善桥街道',4,'',0,1,0,0),(13901,2037,'赛虹桥街道',4,'',0,1,0,0),(13902,2037,'铁心桥街道',4,'',0,1,0,0),(13903,2037,'雨花新村街道',4,'',0,1,0,0),(13904,2038,'东坝镇',4,'',0,1,0,0),(13905,2038,'古柏镇',4,'',0,1,0,0),(13906,2038,'固城镇',4,'',0,1,0,0),(13907,2038,'桠溪镇',4,'',0,1,0,0),(13908,2038,'淳溪镇',4,'',0,1,0,0),(13909,2038,'漆桥镇',4,'',0,1,0,0),(13910,2038,'砖墙镇',4,'',0,1,0,0),(13911,2038,'阳江镇',4,'',0,1,0,0),(13912,2039,'中央门街道',4,'',0,1,0,0),(13913,2039,'华侨路街道',4,'',0,1,0,0),(13914,2039,'宁海路街道',4,'',0,1,0,0),(13915,2039,'挹江门街道',4,'',0,1,0,0),(13916,2039,'江东街道',4,'',0,1,0,0),(13917,2039,'湖南路街道',4,'',0,1,0,0),(13918,2039,'莫愁湖街道',4,'',0,1,0,0),(13919,2040,'北大街街道',4,'',0,1,0,0),(13920,2040,'山北街道',4,'',0,1,0,0),(13921,2040,'惠山街道',4,'',0,1,0,0),(13922,2040,'黄巷街道',4,'',0,1,0,0),(13923,2041,'南禅寺街道',4,'',0,1,0,0),(13924,2041,'扬名街道',4,'',0,1,0,0),(13925,2041,'清名桥街道',4,'',0,1,0,0),(13926,2041,'迎龙桥街道',4,'',0,1,0,0),(13927,2041,'金匮街道',4,'',0,1,0,0),(13928,2041,'金星街道',4,'',0,1,0,0),(13929,2042,'丁蜀镇',4,'',0,1,0,0),(13930,2042,'万石镇',4,'',0,1,0,0),(13931,2042,'周铁镇',4,'',0,1,0,0),(13932,2042,'和桥镇',4,'',0,1,0,0),(13933,2042,'城北街道',4,'',0,1,0,0),(13934,2042,'大浦镇',4,'',0,1,0,0),(13935,2042,'太华镇',4,'',0,1,0,0),(13936,2042,'官林镇',4,'',0,1,0,0),(13937,2042,'宜城街道',4,'',0,1,0,0),(13938,2042,'张渚镇',4,'',0,1,0,0),(13939,2042,'徐舍镇',4,'',0,1,0,0),(13940,2042,'新庄镇',4,'',0,1,0,0),(13941,2042,'新建镇',4,'',0,1,0,0),(13942,2042,'新街镇',4,'',0,1,0,0),(13943,2042,'杨巷镇',4,'',0,1,0,0),(13944,2042,'湖父镇',4,'',0,1,0,0),(13945,2042,'芳庄镇',4,'',0,1,0,0),(13946,2042,'芳桥镇',4,'',0,1,0,0),(13947,2042,'西渚镇',4,'',0,1,0,0),(13948,2042,'高塍镇',4,'',0,1,0,0),(13949,2042,'鲸塘镇',4,'',0,1,0,0),(13950,2043,'上马墩街道',4,'',0,1,0,0),(13951,2043,'崇安寺街道',4,'',0,1,0,0),(13952,2043,'广瑞路街道',4,'',0,1,0,0),(13953,2043,'广益街道',4,'',0,1,0,0),(13954,2043,'江海街道',4,'',0,1,0,0),(13955,2043,'通江街道',4,'',0,1,0,0),(13956,2044,'前洲镇',4,'',0,1,0,0),(13957,2044,'堰桥镇',4,'',0,1,0,0),(13958,2044,'洛社镇',4,'',0,1,0,0),(13959,2044,'玉祁镇',4,'',0,1,0,0),(13960,2044,'钱桥镇',4,'',0,1,0,0),(13961,2044,'阳山镇',4,'',0,1,0,0),(13962,2045,'云亭镇',4,'',0,1,0,0),(13963,2045,'利港镇',4,'',0,1,0,0),(13964,2045,'华士镇',4,'',0,1,0,0),(13965,2045,'南闸镇',4,'',0,1,0,0),(13966,2045,'周庄镇',4,'',0,1,0,0),(13967,2045,'夏港镇',4,'',0,1,0,0),(13968,2045,'新桥镇',4,'',0,1,0,0),(13969,2045,'月城镇',4,'',0,1,0,0),(13970,2045,'澄江街道',4,'',0,1,0,0),(13971,2045,'璜土镇',4,'',0,1,0,0),(13972,2045,'申港镇',4,'',0,1,0,0),(13973,2045,'祝塘镇',4,'',0,1,0,0),(13974,2045,'长泾镇',4,'',0,1,0,0),(13975,2045,'霞客镇',4,'',0,1,0,0),(13976,2045,'青阳镇',4,'',0,1,0,0),(13977,2045,'顾山镇',4,'',0,1,0,0),(13978,2046,'华庄街道',4,'',0,1,0,0),(13979,2046,'南站街道',4,'',0,1,0,0),(13980,2046,'坊前街道',4,'',0,1,0,0),(13981,2046,'太湖街道',4,'',0,1,0,0),(13982,2046,'旺庄街道',4,'',0,1,0,0),(13983,2046,'梅村镇',4,'',0,1,0,0),(13984,2046,'河埒街道',4,'',0,1,0,0),(13985,2046,'滨湖街道',4,'',0,1,0,0),(13986,2046,'硕放街道',4,'',0,1,0,0),(13987,2046,'胡埭镇',4,'',0,1,0,0),(13988,2046,'荣巷街道',4,'',0,1,0,0),(13989,2046,'蠡园街道',4,'',0,1,0,0),(13990,2046,'蠡湖街道',4,'',0,1,0,0),(13991,2046,'马山镇',4,'',0,1,0,0),(13992,2046,'鸿山镇',4,'',0,1,0,0),(13993,2047,'东亭镇',4,'',0,1,0,0),(13994,2047,'东北塘镇',4,'',0,1,0,0),(13995,2047,'东港镇',4,'',0,1,0,0),(13996,2047,'安镇镇',4,'',0,1,0,0),(13997,2047,'羊尖镇',4,'',0,1,0,0),(13998,2047,'锡北镇',4,'',0,1,0,0),(13999,2047,'鸿山镇',4,'',0,1,0,0),(14000,2047,'鹅湖镇',4,'',0,1,0,0),(14001,2048,'凤城镇',4,'',0,1,0,0),(14002,2048,'华山镇',4,'',0,1,0,0),(14003,2048,'大沙河林场',4,'',0,1,0,0),(14004,2048,'大沙河镇',4,'',0,1,0,0),(14005,2048,'孙楼镇',4,'',0,1,0,0),(14006,2048,'宋楼镇',4,'',0,1,0,0),(14007,2048,'师寨镇',4,'',0,1,0,0),(14008,2048,'常店镇',4,'',0,1,0,0),(14009,2048,'梁寨镇',4,'',0,1,0,0),(14010,2048,'欢口镇',4,'',0,1,0,0),(14011,2048,'王沟镇',4,'',0,1,0,0),(14012,2048,'范楼镇',4,'',0,1,0,0),(14013,2048,'赵庄镇',4,'',0,1,0,0),(14014,2048,'顺河镇',4,'',0,1,0,0),(14015,2048,'首羡镇',4,'',0,1,0,0),(14016,2049,'三河尖街道',4,'',0,1,0,0),(14017,2049,'义安街道',4,'',0,1,0,0),(14018,2049,'九里街道',4,'',0,1,0,0),(14019,2049,'利国街道',4,'',0,1,0,0),(14020,2049,'垞城街道',4,'',0,1,0,0),(14021,2049,'大黄山街道',4,'',0,1,0,0),(14022,2049,'庞庄街道',4,'',0,1,0,0),(14023,2049,'张双楼街道',4,'',0,1,0,0),(14024,2049,'张集街道',4,'',0,1,0,0),(14025,2049,'拾屯街道',4,'',0,1,0,0),(14026,2049,'桃园街道',4,'',0,1,0,0),(14027,2049,'火花街道',4,'',0,1,0,0),(14028,2049,'电厂街道',4,'',0,1,0,0),(14029,2049,'苏山街道',4,'',0,1,0,0),(14030,2050,'大郭庄街道',4,'',0,1,0,0),(14031,2050,'天桥街道',4,'',0,1,0,0),(14032,2050,'子房街道',4,'',0,1,0,0),(14033,2050,'彭城街道',4,'',0,1,0,0),(14034,2050,'潘塘街道',4,'',0,1,0,0),(14035,2050,'翠屏山街道',4,'',0,1,0,0),(14036,2050,'青年街道',4,'',0,1,0,0),(14037,2050,'骆驼山街道',4,'',0,1,0,0),(14038,2050,'黄山街道',4,'',0,1,0,0),(14039,2051,'北沟镇',4,'',0,1,0,0),(14040,2051,'双塘镇',4,'',0,1,0,0),(14041,2051,'合沟镇',4,'',0,1,0,0),(14042,2051,'唐店镇',4,'',0,1,0,0),(14043,2051,'新安镇',4,'',0,1,0,0),(14044,2051,'新店镇',4,'',0,1,0,0),(14045,2051,'时集镇',4,'',0,1,0,0),(14046,2051,'棋盘镇',4,'',0,1,0,0),(14047,2051,'港头镇',4,'',0,1,0,0),(14048,2051,'王庄镇',4,'',0,1,0,0),(14049,2051,'瓦窑镇',4,'',0,1,0,0),(14050,2051,'窑湾镇',4,'',0,1,0,0),(14051,2051,'草桥镇',4,'',0,1,0,0),(14052,2051,'邵店镇',4,'',0,1,0,0),(14053,2051,'阿湖镇',4,'',0,1,0,0),(14054,2051,'高流镇',4,'',0,1,0,0),(14055,2052,'五段镇',4,'',0,1,0,0),(14056,2052,'大屯镇',4,'',0,1,0,0),(14057,2052,'安国镇',4,'',0,1,0,0),(14058,2052,'张寨镇',4,'',0,1,0,0),(14059,2052,'张庄镇',4,'',0,1,0,0),(14060,2052,'敬安镇',4,'',0,1,0,0),(14061,2052,'朱寨镇',4,'',0,1,0,0),(14062,2052,'杨屯镇',4,'',0,1,0,0),(14063,2052,'栖山镇',4,'',0,1,0,0),(14064,2052,'沛城镇',4,'',0,1,0,0),(14065,2052,'河口镇',4,'',0,1,0,0),(14066,2052,'胡寨镇',4,'',0,1,0,0),(14067,2052,'魏庙镇',4,'',0,1,0,0),(14068,2052,'鹿楼镇',4,'',0,1,0,0),(14069,2052,'龙固镇',4,'',0,1,0,0),(14070,2053,'七里沟街道',4,'',0,1,0,0),(14071,2053,'和平街道',4,'',0,1,0,0),(14072,2053,'奎山街道',4,'',0,1,0,0),(14073,2053,'段庄街道',4,'',0,1,0,0),(14074,2053,'永安街道',4,'',0,1,0,0),(14075,2053,'泰山街道',4,'',0,1,0,0),(14076,2053,'湖滨街道',4,'',0,1,0,0),(14077,2053,'王陵街道',4,'',0,1,0,0),(14078,2053,'翟山街道',4,'',0,1,0,0),(14079,2053,'金山街道',4,'',0,1,0,0),(14080,2054,'凌城镇',4,'',0,1,0,0),(14081,2054,'双沟镇',4,'',0,1,0,0),(14082,2054,'古邳镇',4,'',0,1,0,0),(14083,2054,'姚集镇',4,'',0,1,0,0),(14084,2054,'官山镇',4,'',0,1,0,0),(14085,2054,'岚山镇',4,'',0,1,0,0),(14086,2054,'庆安镇',4,'',0,1,0,0),(14087,2054,'李集镇',4,'',0,1,0,0),(14088,2054,'桃园镇',4,'',0,1,0,0),(14089,2054,'梁集镇',4,'',0,1,0,0),(14090,2054,'沙集镇',4,'',0,1,0,0),(14091,2054,'王集镇',4,'',0,1,0,0),(14092,2054,'睢城镇',4,'',0,1,0,0),(14093,2054,'邱集镇',4,'',0,1,0,0),(14094,2054,'高作镇',4,'',0,1,0,0),(14095,2054,'魏集镇',4,'',0,1,0,0),(14096,2055,'塔山镇',4,'',0,1,0,0),(14097,2055,'夏桥街道',4,'',0,1,0,0),(14098,2055,'大吴镇',4,'',0,1,0,0),(14099,2055,'江庄镇',4,'',0,1,0,0),(14100,2055,'汴塘镇',4,'',0,1,0,0),(14101,2055,'紫庄镇',4,'',0,1,0,0),(14102,2055,'老矿街道',4,'',0,1,0,0),(14103,2055,'贾汪镇',4,'',0,1,0,0),(14104,2055,'青山泉镇',4,'',0,1,0,0),(14105,2056,'八义集镇',4,'',0,1,0,0),(14106,2056,'八路镇',4,'',0,1,0,0),(14107,2056,'占城镇',4,'',0,1,0,0),(14108,2056,'四户镇',4,'',0,1,0,0),(14109,2056,'土山镇',4,'',0,1,0,0),(14110,2056,'官湖镇',4,'',0,1,0,0),(14111,2056,'宿羊山镇',4,'',0,1,0,0),(14112,2056,'岔河镇',4,'',0,1,0,0),(14113,2056,'张楼农场',4,'',0,1,0,0),(14114,2056,'戴圩镇',4,'',0,1,0,0),(14115,2056,'戴庄镇',4,'',0,1,0,0),(14116,2056,'新河镇',4,'',0,1,0,0),(14117,2056,'港上镇',4,'',0,1,0,0),(14118,2056,'炮车镇',4,'',0,1,0,0),(14119,2056,'燕子埠镇',4,'',0,1,0,0),(14120,2056,'碾庄镇',4,'',0,1,0,0),(14121,2056,'议堂镇',4,'',0,1,0,0),(14122,2056,'赵墩镇',4,'',0,1,0,0),(14123,2056,'车辐山镇',4,'',0,1,0,0),(14124,2056,'运河镇',4,'',0,1,0,0),(14125,2056,'邢楼镇',4,'',0,1,0,0),(14126,2056,'邳城农场',4,'',0,1,0,0),(14127,2056,'邳城镇',4,'',0,1,0,0),(14128,2056,'邹庄镇',4,'',0,1,0,0),(14129,2056,'铁富镇',4,'',0,1,0,0),(14130,2056,'陈楼镇',4,'',0,1,0,0),(14131,2057,'三堡镇',4,'',0,1,0,0),(14132,2057,'伊庄镇',4,'',0,1,0,0),(14133,2057,'何桥镇',4,'',0,1,0,0),(14134,2057,'刘集镇',4,'',0,1,0,0),(14135,2057,'利国镇',4,'',0,1,0,0),(14136,2057,'单集镇',4,'',0,1,0,0),(14137,2057,'国营沿湖农场',4,'',0,1,0,0),(14138,2057,'大彭镇',4,'',0,1,0,0),(14139,2057,'大许镇',4,'',0,1,0,0),(14140,2057,'张集镇',4,'',0,1,0,0),(14141,2057,'徐庄镇',4,'',0,1,0,0),(14142,2057,'房村镇',4,'',0,1,0,0),(14143,2057,'柳新镇',4,'',0,1,0,0),(14144,2057,'柳泉镇',4,'',0,1,0,0),(14145,2057,'棠张镇',4,'',0,1,0,0),(14146,2057,'汉王镇',4,'',0,1,0,0),(14147,2057,'茅村镇',4,'',0,1,0,0),(14148,2057,'郑集镇',4,'',0,1,0,0),(14149,2057,'铜山镇',4,'',0,1,0,0),(14150,2057,'马坡镇',4,'',0,1,0,0),(14151,2057,'黄集镇',4,'',0,1,0,0),(14152,2058,'东环街道',4,'',0,1,0,0),(14153,2058,'丰财街道',4,'',0,1,0,0),(14154,2058,'大庙镇',4,'',0,1,0,0),(14155,2058,'大黄山镇',4,'',0,1,0,0),(14156,2058,'牌楼街道',4,'',0,1,0,0),(14157,2058,'环城街道',4,'',0,1,0,0),(14158,2058,'琵琶街道',4,'',0,1,0,0),(14159,2058,'金山桥街道',4,'',0,1,0,0),(14160,2058,'铜沛街道',4,'',0,1,0,0),(14161,2058,'黄楼街道',4,'',0,1,0,0),(14162,2059,'兰陵街道',4,'',0,1,0,0),(14163,2059,'天宁经济开发区',4,'',0,1,0,0),(14164,2059,'天宁街道',4,'',0,1,0,0),(14165,2059,'红梅街道',4,'',0,1,0,0),(14166,2059,'茶山街道',4,'',0,1,0,0),(14167,2059,'雕庄街道',4,'',0,1,0,0),(14168,2059,'青龙街道',4,'',0,1,0,0),(14169,2060,'丁堰街道',4,'',0,1,0,0),(14170,2060,'戚墅堰街道',4,'',0,1,0,0),(14171,2060,'潞城街道',4,'',0,1,0,0),(14172,2061,'三井街道',4,'',0,1,0,0),(14173,2061,'孟河镇',4,'',0,1,0,0),(14174,2061,'新桥镇',4,'',0,1,0,0),(14175,2061,'春江镇',4,'',0,1,0,0),(14176,2061,'河海街道',4,'',0,1,0,0),(14177,2061,'罗溪镇',4,'',0,1,0,0),(14178,2061,'薛家镇',4,'',0,1,0,0),(14179,2061,'西夏墅镇',4,'',0,1,0,0),(14180,2061,'龙虎塘街道',4,'',0,1,0,0),(14181,2062,'前黄镇',4,'',0,1,0,0),(14182,2062,'南夏墅街道',4,'',0,1,0,0),(14183,2062,'嘉泽镇',4,'',0,1,0,0),(14184,2062,'奔牛镇',4,'',0,1,0,0),(14185,2062,'横山桥镇',4,'',0,1,0,0),(14186,2062,'横林镇',4,'',0,1,0,0),(14187,2062,'洛阳镇',4,'',0,1,0,0),(14188,2062,'湖塘镇',4,'',0,1,0,0),(14189,2062,'湟里镇',4,'',0,1,0,0),(14190,2062,'牛塘镇',4,'',0,1,0,0),(14191,2062,'礼嘉镇',4,'',0,1,0,0),(14192,2062,'遥观镇',4,'',0,1,0,0),(14193,2062,'邹区镇',4,'',0,1,0,0),(14194,2062,'郑陆镇',4,'',0,1,0,0),(14195,2062,'雪堰镇',4,'',0,1,0,0),(14196,2063,'上兴镇',4,'',0,1,0,0),(14197,2063,'上黄镇',4,'',0,1,0,0),(14198,2063,'别桥镇',4,'',0,1,0,0),(14199,2063,'南渡镇',4,'',0,1,0,0),(14200,2063,'埭头镇',4,'',0,1,0,0),(14201,2063,'天目湖镇',4,'',0,1,0,0),(14202,2063,'戴埠镇',4,'',0,1,0,0),(14203,2063,'溧城镇',4,'',0,1,0,0),(14204,2063,'社渚镇',4,'',0,1,0,0),(14205,2063,'竹箦镇',4,'',0,1,0,0),(14206,2064,'儒林镇',4,'',0,1,0,0),(14207,2064,'尧塘镇',4,'',0,1,0,0),(14208,2064,'指前镇',4,'',0,1,0,0),(14209,2064,'朱林镇',4,'',0,1,0,0),(14210,2064,'直溪镇',4,'',0,1,0,0),(14211,2064,'薛埠镇',4,'',0,1,0,0),(14212,2064,'金城镇',4,'',0,1,0,0),(14213,2065,'五星街道',4,'',0,1,0,0),(14214,2065,'北港街道',4,'',0,1,0,0),(14215,2065,'南大街街道',4,'',0,1,0,0),(14216,2065,'新闸街道',4,'',0,1,0,0),(14217,2065,'永红街道',4,'',0,1,0,0),(14218,2065,'荷花池街道',4,'',0,1,0,0),(14219,2065,'西林街道',4,'',0,1,0,0),(14220,2066,'东山镇',4,'',0,1,0,0),(14221,2066,'临湖镇',4,'',0,1,0,0),(14222,2066,'光福镇',4,'',0,1,0,0),(14223,2066,'城南街道',4,'',0,1,0,0),(14224,2066,'木渎镇',4,'',0,1,0,0),(14225,2066,'横泾街道',4,'',0,1,0,0),(14226,2066,'甪直镇',4,'',0,1,0,0),(14227,2066,'胥口镇',4,'',0,1,0,0),(14228,2066,'苏苑街道',4,'',0,1,0,0),(14229,2066,'藏书镇',4,'',0,1,0,0),(14230,2066,'西山镇',4,'',0,1,0,0),(14231,2066,'越溪街道',4,'',0,1,0,0),(14232,2066,'车坊镇',4,'',0,1,0,0),(14233,2066,'郭巷街道',4,'',0,1,0,0),(14234,2066,'长桥街道',4,'',0,1,0,0),(14235,2066,'香山街道',4,'',0,1,0,0),(14236,2066,'龙西街道',4,'',0,1,0,0),(14237,2067,'七都镇',4,'',0,1,0,0),(14238,2067,'同里镇',4,'',0,1,0,0),(14239,2067,'平望镇',4,'',0,1,0,0),(14240,2067,'松陵镇',4,'',0,1,0,0),(14241,2067,'桃源镇',4,'',0,1,0,0),(14242,2067,'横扇镇',4,'',0,1,0,0),(14243,2067,'汾湖镇',4,'',0,1,0,0),(14244,2067,'盛泽镇',4,'',0,1,0,0),(14245,2067,'震泽镇',4,'',0,1,0,0),(14246,2068,'双凤镇',4,'',0,1,0,0),(14247,2068,'城厢镇',4,'',0,1,0,0),(14248,2068,'太仓港港口开发区',4,'',0,1,0,0),(14249,2068,'太仓经济开发区',4,'',0,1,0,0),(14250,2068,'沙溪镇',4,'',0,1,0,0),(14251,2068,'浏河镇',4,'',0,1,0,0),(14252,2068,'浮桥镇',4,'',0,1,0,0),(14253,2068,'璜泾镇',4,'',0,1,0,0),(14254,2068,'陆渡镇',4,'',0,1,0,0),(14255,2069,'古里镇',4,'',0,1,0,0),(14256,2069,'尚湖镇',4,'',0,1,0,0),(14257,2069,'支塘镇',4,'',0,1,0,0),(14258,2069,'新港镇',4,'',0,1,0,0),(14259,2069,'梅李镇',4,'',0,1,0,0),(14260,2069,'沙家浜镇',4,'',0,1,0,0),(14261,2069,'海虞镇',4,'',0,1,0,0),(14262,2069,'董浜镇',4,'',0,1,0,0),(14263,2069,'虞山镇',4,'',0,1,0,0),(14264,2069,'辛庄镇',4,'',0,1,0,0),(14265,2070,'城北街道',4,'',0,1,0,0),(14266,2070,'娄门街道',4,'',0,1,0,0),(14267,2070,'平江路街道',4,'',0,1,0,0),(14268,2070,'桃花坞街道',4,'',0,1,0,0),(14269,2070,'苏锦街道',4,'',0,1,0,0),(14270,2070,'观前街道',4,'',0,1,0,0),(14271,2071,'乐余镇',4,'',0,1,0,0),(14272,2071,'凤凰镇',4,'',0,1,0,0),(14273,2071,'南丰镇',4,'',0,1,0,0),(14274,2071,'塘桥镇',4,'',0,1,0,0),(14275,2071,'大新镇',4,'',0,1,0,0),(14276,2071,'常阴沙农场',4,'',0,1,0,0),(14277,2071,'杨舍镇',4,'',0,1,0,0),(14278,2071,'金港镇',4,'',0,1,0,0),(14279,2071,'锦丰镇',4,'',0,1,0,0),(14280,2072,'千灯镇',4,'',0,1,0,0),(14281,2072,'周市镇',4,'',0,1,0,0),(14282,2072,'周庄镇',4,'',0,1,0,0),(14283,2072,'巴城镇',4,'',0,1,0,0),(14284,2072,'张浦镇',4,'',0,1,0,0),(14285,2072,'淀山湖镇',4,'',0,1,0,0),(14286,2072,'玉山镇',4,'',0,1,0,0),(14287,2072,'花桥镇',4,'',0,1,0,0),(14288,2072,'锦溪镇',4,'',0,1,0,0),(14289,2072,'陆家镇',4,'',0,1,0,0),(14290,2073,'南门街道',4,'',0,1,0,0),(14291,2073,'友新街道',4,'',0,1,0,0),(14292,2073,'双塔街道',4,'',0,1,0,0),(14293,2073,'吴门桥街道',4,'',0,1,0,0),(14294,2073,'胥江街道',4,'',0,1,0,0),(14295,2073,'葑门街道',4,'',0,1,0,0),(14296,2074,'元和街道',4,'',0,1,0,0),(14297,2074,'北桥街道',4,'',0,1,0,0),(14298,2074,'太平街道',4,'',0,1,0,0),(14299,2074,'望亭镇',4,'',0,1,0,0),(14300,2074,'渭塘镇',4,'',0,1,0,0),(14301,2074,'阳澄湖镇',4,'',0,1,0,0),(14302,2074,'黄埭镇',4,'',0,1,0,0),(14303,2074,'黄桥街道',4,'',0,1,0,0),(14304,2075,'唯亭镇',4,'',0,1,0,0),(14305,2075,'娄葑镇',4,'',0,1,0,0),(14306,2075,'胜浦镇',4,'',0,1,0,0),(14307,2076,'东渚镇',4,'',0,1,0,0),(14308,2076,'枫桥街道',4,'',0,1,0,0),(14309,2076,'横塘街道',4,'',0,1,0,0),(14310,2076,'浒墅关镇',4,'',0,1,0,0),(14311,2076,'狮山街道',4,'',0,1,0,0),(14312,2076,'通安镇',4,'',0,1,0,0),(14313,2077,'彩香街道',4,'',0,1,0,0),(14314,2077,'留园街道',4,'',0,1,0,0),(14315,2077,'白洋湾街道',4,'',0,1,0,0),(14316,2077,'石路街道',4,'',0,1,0,0),(14317,2077,'虎丘街道',4,'',0,1,0,0),(14318,2078,'东元镇',4,'',0,1,0,0),(14319,2078,'东海镇',4,'',0,1,0,0),(14320,2078,'久隆镇',4,'',0,1,0,0),(14321,2078,'兆民镇',4,'',0,1,0,0),(14322,2078,'北新镇',4,'',0,1,0,0),(14323,2078,'南阳镇',4,'',0,1,0,0),(14324,2078,'合作镇',4,'',0,1,0,0),(14325,2078,'向阳镇',4,'',0,1,0,0),(14326,2078,'吕四港镇',4,'',0,1,0,0),(14327,2078,'启隆乡',4,'',0,1,0,0),(14328,2078,'和合镇',4,'',0,1,0,0),(14329,2078,'大兴镇',4,'',0,1,0,0),(14330,2078,'天汾镇',4,'',0,1,0,0),(14331,2078,'寅阳镇',4,'',0,1,0,0),(14332,2078,'少直镇',4,'',0,1,0,0),(14333,2078,'志良镇',4,'',0,1,0,0),(14334,2078,'惠丰镇',4,'',0,1,0,0),(14335,2078,'惠萍镇',4,'',0,1,0,0),(14336,2078,'新安镇',4,'',0,1,0,0),(14337,2078,'民主镇',4,'',0,1,0,0),(14338,2078,'汇龙镇',4,'',0,1,0,0),(14339,2078,'海复镇',4,'',0,1,0,0),(14340,2078,'王鲍镇',4,'',0,1,0,0),(14341,2078,'近海镇',4,'',0,1,0,0),(14342,2079,'丰利镇',4,'',0,1,0,0),(14343,2079,'兵房镇',4,'',0,1,0,0),(14344,2079,'双甸镇',4,'',0,1,0,0),(14345,2079,'大豫镇',4,'',0,1,0,0),(14346,2079,'岔河镇',4,'',0,1,0,0),(14347,2079,'掘港镇',4,'',0,1,0,0),(14348,2079,'新店镇',4,'',0,1,0,0),(14349,2079,'曹埠镇',4,'',0,1,0,0),(14350,2079,'栟茶镇',4,'',0,1,0,0),(14351,2079,'河口镇',4,'',0,1,0,0),(14352,2079,'洋口镇',4,'',0,1,0,0),(14353,2079,'苴镇',4,'',0,1,0,0),(14354,2079,'袁庄镇',4,'',0,1,0,0),(14355,2079,'长沙镇',4,'',0,1,0,0),(14356,2079,'马塘镇',4,'',0,1,0,0),(14357,2080,'丁埝镇',4,'',0,1,0,0),(14358,2080,'下原镇',4,'',0,1,0,0),(14359,2080,'东陈镇',4,'',0,1,0,0),(14360,2080,'九华镇',4,'',0,1,0,0),(14361,2080,'吴窑镇',4,'',0,1,0,0),(14362,2080,'如城镇',4,'',0,1,0,0),(14363,2080,'常青镇',4,'',0,1,0,0),(14364,2080,'搬经镇',4,'',0,1,0,0),(14365,2080,'林梓镇',4,'',0,1,0,0),(14366,2080,'柴湾镇',4,'',0,1,0,0),(14367,2080,'桃园镇',4,'',0,1,0,0),(14368,2080,'江安镇',4,'',0,1,0,0),(14369,2080,'白蒲镇',4,'',0,1,0,0),(14370,2080,'石庄镇',4,'',0,1,0,0),(14371,2080,'磨头镇',4,'',0,1,0,0),(14372,2080,'袁桥镇',4,'',0,1,0,0),(14373,2080,'郭园镇',4,'',0,1,0,0),(14374,2080,'长江镇',4,'',0,1,0,0),(14375,2080,'雪岸镇',4,'',0,1,0,0),(14376,2080,'高明镇',4,'',0,1,0,0),(14377,2081,'中兴街道',4,'',0,1,0,0),(14378,2081,'任港街道',4,'',0,1,0,0),(14379,2081,'和平桥街道',4,'',0,1,0,0),(14380,2081,'城东街道',4,'',0,1,0,0),(14381,2081,'学田街道',4,'',0,1,0,0),(14382,2081,'小海镇',4,'',0,1,0,0),(14383,2081,'文峰街道',4,'',0,1,0,0),(14384,2081,'新城桥街道',4,'',0,1,0,0),(14385,2081,'新开镇',4,'',0,1,0,0),(14386,2081,'狼山镇',4,'',0,1,0,0),(14387,2081,'竹行镇',4,'',0,1,0,0),(14388,2081,'虹桥街道',4,'',0,1,0,0),(14389,2081,'观音山镇',4,'',0,1,0,0),(14390,2081,'钟秀街道',4,'',0,1,0,0),(14391,2082,'南莫镇',4,'',0,1,0,0),(14392,2082,'城东镇',4,'',0,1,0,0),(14393,2082,'墩头镇',4,'',0,1,0,0),(14394,2082,'大公镇',4,'',0,1,0,0),(14395,2082,'孙庄镇',4,'',0,1,0,0),(14396,2082,'曲塘镇',4,'',0,1,0,0),(14397,2082,'李堡镇',4,'',0,1,0,0),(14398,2082,'海安镇',4,'',0,1,0,0),(14399,2082,'白甸镇',4,'',0,1,0,0),(14400,2082,'老坝港镇',4,'',0,1,0,0),(14401,2082,'胡集镇',4,'',0,1,0,0),(14402,2082,'西场镇',4,'',0,1,0,0),(14403,2082,'角斜镇',4,'',0,1,0,0),(14404,2082,'雅周镇',4,'',0,1,0,0),(14405,2083,'万年镇',4,'',0,1,0,0),(14406,2083,'三厂镇',4,'',0,1,0,0),(14407,2083,'三和镇',4,'',0,1,0,0),(14408,2083,'三星镇',4,'',0,1,0,0),(14409,2083,'三阳镇',4,'',0,1,0,0),(14410,2083,'东灶港镇',4,'',0,1,0,0),(14411,2083,'临江镇',4,'',0,1,0,0),(14412,2083,'余东镇',4,'',0,1,0,0),(14413,2083,'刘浩镇',4,'',0,1,0,0),(14414,2083,'包场镇',4,'',0,1,0,0),(14415,2083,'四甲镇',4,'',0,1,0,0),(14416,2083,'天补镇',4,'',0,1,0,0),(14417,2083,'常乐镇',4,'',0,1,0,0),(14418,2083,'德胜镇',4,'',0,1,0,0),(14419,2083,'悦来镇',4,'',0,1,0,0),(14420,2083,'树勋镇',4,'',0,1,0,0),(14421,2083,'正余镇',4,'',0,1,0,0),(14422,2083,'海永乡',4,'',0,1,0,0),(14423,2083,'海门镇',4,'',0,1,0,0),(14424,2083,'王浩镇',4,'',0,1,0,0),(14425,2083,'货隆镇',4,'',0,1,0,0),(14426,2083,'麒麟镇',4,'',0,1,0,0),(14427,2084,'唐闸镇街道',4,'',0,1,0,0),(14428,2084,'天生港镇街道',4,'',0,1,0,0),(14429,2084,'幸福乡',4,'',0,1,0,0),(14430,2084,'永兴街道',4,'',0,1,0,0),(14431,2084,'秦灶街道',4,'',0,1,0,0),(14432,2084,'陈桥乡',4,'',0,1,0,0),(14433,2085,'三余镇',4,'',0,1,0,0),(14434,2085,'东社镇',4,'',0,1,0,0),(14435,2085,'二甲镇',4,'',0,1,0,0),(14436,2085,'五接镇',4,'',0,1,0,0),(14437,2085,'五甲镇',4,'',0,1,0,0),(14438,2085,'先锋镇',4,'',0,1,0,0),(14439,2085,'兴东镇',4,'',0,1,0,0),(14440,2085,'兴仁镇',4,'',0,1,0,0),(14441,2085,'刘桥镇',4,'',0,1,0,0),(14442,2085,'十总镇',4,'',0,1,0,0),(14443,2085,'四安镇',4,'',0,1,0,0),(14444,2085,'姜灶镇',4,'',0,1,0,0),(14445,2085,'川港镇',4,'',0,1,0,0),(14446,2085,'平东镇',4,'',0,1,0,0),(14447,2085,'平潮镇',4,'',0,1,0,0),(14448,2085,'张芝山镇',4,'',0,1,0,0),(14449,2085,'石港镇',4,'',0,1,0,0),(14450,2085,'西亭镇',4,'',0,1,0,0),(14451,2085,'金沙镇',4,'',0,1,0,0),(14452,2085,'骑岸镇',4,'',0,1,0,0),(14453,2086,'南辰乡',4,'',0,1,0,0),(14454,2086,'双店镇',4,'',0,1,0,0),(14455,2086,'安峰镇',4,'',0,1,0,0),(14456,2086,'山左口乡',4,'',0,1,0,0),(14457,2086,'岗埠农场',4,'',0,1,0,0),(14458,2086,'平明镇',4,'',0,1,0,0),(14459,2086,'张湾乡',4,'',0,1,0,0),(14460,2086,'房山镇',4,'',0,1,0,0),(14461,2086,'曲阳乡',4,'',0,1,0,0),(14462,2086,'李埝乡',4,'',0,1,0,0),(14463,2086,'桃林镇',4,'',0,1,0,0),(14464,2086,'横沟乡',4,'',0,1,0,0),(14465,2086,'洪庄镇',4,'',0,1,0,0),(14466,2086,'浦南镇',4,'',0,1,0,0),(14467,2086,'温泉镇',4,'',0,1,0,0),(14468,2086,'牛山镇',4,'',0,1,0,0),(14469,2086,'白塔埠镇',4,'',0,1,0,0),(14470,2086,'石梁河镇',4,'',0,1,0,0),(14471,2086,'石榴镇',4,'',0,1,0,0),(14472,2086,'石湖乡',4,'',0,1,0,0),(14473,2086,'青湖镇',4,'',0,1,0,0),(14474,2086,'驼峰乡',4,'',0,1,0,0),(14475,2086,'黄川镇',4,'',0,1,0,0),(14476,2087,'云台乡',4,'',0,1,0,0),(14477,2087,'云台农场',4,'',0,1,0,0),(14478,2087,'南云台林场',4,'',0,1,0,0),(14479,2087,'南城镇',4,'',0,1,0,0),(14480,2087,'宁海乡',4,'',0,1,0,0),(14481,2087,'新东街道',4,'',0,1,0,0),(14482,2087,'新南街道',4,'',0,1,0,0),(14483,2087,'新海街道',4,'',0,1,0,0),(14484,2087,'浦东街道',4,'',0,1,0,0),(14485,2087,'浦西街道',4,'',0,1,0,0),(14486,2087,'花果山乡',4,'',0,1,0,0),(14487,2087,'路南街道',4,'',0,1,0,0),(14488,2088,'幸福路街道',4,'',0,1,0,0),(14489,2088,'新坝镇',4,'',0,1,0,0),(14490,2088,'朐阳街道',4,'',0,1,0,0),(14491,2088,'洪门街道',4,'',0,1,0,0),(14492,2088,'海州街道',4,'',0,1,0,0),(14493,2088,'锦屏镇',4,'',0,1,0,0),(14494,2089,'下车乡',4,'',0,1,0,0),(14495,2089,'东王集乡',4,'',0,1,0,0),(14496,2089,'东辛农场',4,'',0,1,0,0),(14497,2089,'五图河农场',4,'',0,1,0,0),(14498,2089,'伊山镇',4,'',0,1,0,0),(14499,2089,'伊芦乡',4,'',0,1,0,0),(14500,2089,'侍庄乡',4,'',0,1,0,0),(14501,2089,'南岗乡',4,'',0,1,0,0),(14502,2089,'同兴镇',4,'',0,1,0,0),(14503,2089,'四队镇',4,'',0,1,0,0),(14504,2089,'图河乡',4,'',0,1,0,0),(14505,2089,'圩丰镇',4,'',0,1,0,0),(14506,2089,'小伊乡',4,'',0,1,0,0),(14507,2089,'杨集镇',4,'',0,1,0,0),(14508,2089,'板浦镇',4,'',0,1,0,0),(14509,2089,'沂北乡',4,'',0,1,0,0),(14510,2089,'灌西盐场',4,'',0,1,0,0),(14511,2089,'燕尾港镇',4,'',0,1,0,0),(14512,2089,'白蚬乡',4,'',0,1,0,0),(14513,2089,'穆圩乡',4,'',0,1,0,0),(14514,2089,'陡沟乡',4,'',0,1,0,0),(14515,2089,'鲁河乡',4,'',0,1,0,0),(14516,2089,'龙苴镇',4,'',0,1,0,0),(14517,2090,'三口镇',4,'',0,1,0,0),(14518,2090,'五队乡',4,'',0,1,0,0),(14519,2090,'北陈集镇',4,'',0,1,0,0),(14520,2090,'堆沟港镇',4,'',0,1,0,0),(14521,2090,'孟兴庄镇',4,'',0,1,0,0),(14522,2090,'张店镇',4,'',0,1,0,0),(14523,2090,'新安镇',4,'',0,1,0,0),(14524,2090,'新集乡',4,'',0,1,0,0),(14525,2090,'李集乡',4,'',0,1,0,0),(14526,2090,'汤沟镇',4,'',0,1,0,0),(14527,2090,'田楼乡',4,'',0,1,0,0),(14528,2090,'百禄镇',4,'',0,1,0,0),(14529,2090,'花园乡',4,'',0,1,0,0),(14530,2090,'长茂镇',4,'',0,1,0,0),(14531,2091,'厉庄镇',4,'',0,1,0,0),(14532,2091,'城头镇',4,'',0,1,0,0),(14533,2091,'城西镇',4,'',0,1,0,0),(14534,2091,'塔山镇',4,'',0,1,0,0),(14535,2091,'墩尚镇',4,'',0,1,0,0),(14536,2091,'宋庄镇',4,'',0,1,0,0),(14537,2091,'柘汪镇',4,'',0,1,0,0),(14538,2091,'欢墩镇',4,'',0,1,0,0),(14539,2091,'沙河子园艺场',4,'',0,1,0,0),(14540,2091,'沙河镇',4,'',0,1,0,0),(14541,2091,'海头镇',4,'',0,1,0,0),(14542,2091,'班庄镇',4,'',0,1,0,0),(14543,2091,'石桥镇',4,'',0,1,0,0),(14544,2091,'罗阳镇',4,'',0,1,0,0),(14545,2091,'赣榆海洋经济开发区',4,'',0,1,0,0),(14546,2091,'赣马镇',4,'',0,1,0,0),(14547,2091,'金山镇',4,'',0,1,0,0),(14548,2091,'门河镇',4,'',0,1,0,0),(14549,2091,'青口盐场',4,'',0,1,0,0),(14550,2091,'青口镇',4,'',0,1,0,0),(14551,2091,'黑林镇',4,'',0,1,0,0),(14552,2092,'中云街道',4,'',0,1,0,0),(14553,2092,'云山街道',4,'',0,1,0,0),(14554,2092,'前三岛乡',4,'',0,1,0,0),(14555,2092,'墟沟街道',4,'',0,1,0,0),(14556,2092,'宿城乡',4,'',0,1,0,0),(14557,2092,'朝阳镇',4,'',0,1,0,0),(14558,2092,'板桥街道',4,'',0,1,0,0),(14559,2092,'猴嘴街道',4,'',0,1,0,0),(14560,2092,'连云街道',4,'',0,1,0,0),(14561,2092,'连岛街道',4,'',0,1,0,0),(14562,2092,'高公岛乡',4,'',0,1,0,0),(14563,2093,'三堡乡',4,'',0,1,0,0),(14564,2093,'上河镇',4,'',0,1,0,0),(14565,2093,'仇桥镇',4,'',0,1,0,0),(14566,2093,'南闸镇',4,'',0,1,0,0),(14567,2093,'南马厂乡',4,'',0,1,0,0),(14568,2093,'博里镇',4,'',0,1,0,0),(14569,2093,'城东乡',4,'',0,1,0,0),(14570,2093,'复兴镇',4,'',0,1,0,0),(14571,2093,'季桥镇',4,'',0,1,0,0),(14572,2093,'宋集乡',4,'',0,1,0,0),(14573,2093,'席桥镇',4,'',0,1,0,0),(14574,2093,'平桥镇',4,'',0,1,0,0),(14575,2093,'建淮乡',4,'',0,1,0,0),(14576,2093,'施河镇',4,'',0,1,0,0),(14577,2093,'朱桥镇',4,'',0,1,0,0),(14578,2093,'林集镇',4,'',0,1,0,0),(14579,2093,'泾口镇',4,'',0,1,0,0),(14580,2093,'流均镇',4,'',0,1,0,0),(14581,2093,'淮城镇',4,'',0,1,0,0),(14582,2093,'溪河镇',4,'',0,1,0,0),(14583,2093,'白马湖农场',4,'',0,1,0,0),(14584,2093,'苏嘴镇',4,'',0,1,0,0),(14585,2093,'范集镇',4,'',0,1,0,0),(14586,2093,'茭陵乡',4,'',0,1,0,0),(14587,2093,'车桥镇',4,'',0,1,0,0),(14588,2093,'钦工镇',4,'',0,1,0,0),(14589,2093,'顺河镇',4,'',0,1,0,0),(14590,2093,'马甸镇',4,'',0,1,0,0),(14591,2094,'万集镇',4,'',0,1,0,0),(14592,2094,'三河镇',4,'',0,1,0,0),(14593,2094,'东双沟镇',4,'',0,1,0,0),(14594,2094,'仁和镇',4,'',0,1,0,0),(14595,2094,'共和镇',4,'',0,1,0,0),(14596,2094,'岔河镇',4,'',0,1,0,0),(14597,2094,'朱坝镇',4,'',0,1,0,0),(14598,2094,'老子山镇',4,'',0,1,0,0),(14599,2094,'蒋坝镇',4,'',0,1,0,0),(14600,2094,'西顺河镇',4,'',0,1,0,0),(14601,2094,'高良涧镇',4,'',0,1,0,0),(14602,2094,'黄集镇',4,'',0,1,0,0),(14603,2095,'东胡集镇',4,'',0,1,0,0),(14604,2095,'义兴镇',4,'',0,1,0,0),(14605,2095,'五港镇',4,'',0,1,0,0),(14606,2095,'余圩办事处',4,'',0,1,0,0),(14607,2095,'保滩镇',4,'',0,1,0,0),(14608,2095,'前进镇',4,'',0,1,0,0),(14609,2095,'北集办事处',4,'',0,1,0,0),(14610,2095,'南禄办事处',4,'',0,1,0,0),(14611,2095,'南集镇',4,'',0,1,0,0),(14612,2095,'唐集镇',4,'',0,1,0,0),(14613,2095,'大东镇',4,'',0,1,0,0),(14614,2095,'小李集办事处',4,'',0,1,0,0),(14615,2095,'岔庙镇',4,'',0,1,0,0),(14616,2095,'工业新区',4,'',0,1,0,0),(14617,2095,'徐集乡',4,'',0,1,0,0),(14618,2095,'成集镇',4,'',0,1,0,0),(14619,2095,'方渡办事处',4,'',0,1,0,0),(14620,2095,'时码办事处',4,'',0,1,0,0),(14621,2095,'朱码镇',4,'',0,1,0,0),(14622,2095,'杨口办事处',4,'',0,1,0,0),(14623,2095,'梁岔镇',4,'',0,1,0,0),(14624,2095,'河网办事处',4,'',0,1,0,0),(14625,2095,'浅集办事处',4,'',0,1,0,0),(14626,2095,'涟城镇',4,'',0,1,0,0),(14627,2095,'灰墩办事处',4,'',0,1,0,0),(14628,2095,'石湖镇',4,'',0,1,0,0),(14629,2095,'红窑镇',4,'',0,1,0,0),(14630,2095,'经济开发新区',4,'',0,1,0,0),(14631,2095,'蒋庵办事处',4,'',0,1,0,0),(14632,2095,'陈师镇',4,'',0,1,0,0),(14633,2095,'高沟镇',4,'',0,1,0,0),(14634,2095,'黄营乡',4,'',0,1,0,0),(14635,2096,'丁集镇',4,'',0,1,0,0),(14636,2096,'三树镇',4,'',0,1,0,0),(14637,2096,'五里镇',4,'',0,1,0,0),(14638,2096,'凌桥乡',4,'',0,1,0,0),(14639,2096,'刘老庄乡',4,'',0,1,0,0),(14640,2096,'南陈集镇',4,'',0,1,0,0),(14641,2096,'古寨乡',4,'',0,1,0,0),(14642,2096,'吴城镇',4,'',0,1,0,0),(14643,2096,'吴集镇',4,'',0,1,0,0),(14644,2096,'徐溜镇',4,'',0,1,0,0),(14645,2096,'新渡乡',4,'',0,1,0,0),(14646,2096,'棉花庄镇',4,'',0,1,0,0),(14647,2096,'淮阴工业园',4,'',0,1,0,0),(14648,2096,'渔沟镇',4,'',0,1,0,0),(14649,2096,'王兴镇',4,'',0,1,0,0),(14650,2096,'王营镇',4,'',0,1,0,0),(14651,2096,'码头镇',4,'',0,1,0,0),(14652,2096,'老张集乡',4,'',0,1,0,0),(14653,2096,'袁集乡',4,'',0,1,0,0),(14654,2096,'西宋集镇',4,'',0,1,0,0),(14655,2096,'赵集镇',4,'',0,1,0,0),(14656,2096,'韩桥乡',4,'',0,1,0,0),(14657,2097,'东湖街道',4,'',0,1,0,0),(14658,2097,'京沪路办事处',4,'',0,1,0,0),(14659,2097,'北京路街道',4,'',0,1,0,0),(14660,2097,'广州街道',4,'',0,1,0,0),(14661,2097,'徐扬乡',4,'',0,1,0,0),(14662,2097,'新港街道',4,'',0,1,0,0),(14663,2097,'水渡口街道',4,'',0,1,0,0),(14664,2097,'淮海街道',4,'',0,1,0,0),(14665,2097,'西安路街道',4,'',0,1,0,0),(14666,2097,'钵池乡',4,'',0,1,0,0),(14667,2097,'长东街道',4,'',0,1,0,0),(14668,2097,'长西街道',4,'',0,1,0,0),(14669,2098,'和平镇',4,'',0,1,0,0),(14670,2098,'城南乡',4,'',0,1,0,0),(14671,2098,'武墩镇',4,'',0,1,0,0),(14672,2098,'浦楼街道',4,'',0,1,0,0),(14673,2098,'清安街道',4,'',0,1,0,0),(14674,2098,'清江街道',4,'',0,1,0,0),(14675,2098,'盐河镇',4,'',0,1,0,0),(14676,2098,'闸口街道',4,'',0,1,0,0),(14677,2098,'黄码乡',4,'',0,1,0,0),(14678,2099,'三河农场',4,'',0,1,0,0),(14679,2099,'仇集镇',4,'',0,1,0,0),(14680,2099,'兴隆乡',4,'',0,1,0,0),(14681,2099,'古桑乡',4,'',0,1,0,0),(14682,2099,'官滩镇',4,'',0,1,0,0),(14683,2099,'旧铺镇',4,'',0,1,0,0),(14684,2099,'明祖陵镇',4,'',0,1,0,0),(14685,2099,'桂五镇',4,'',0,1,0,0),(14686,2099,'河桥镇',4,'',0,1,0,0),(14687,2099,'淮河镇',4,'',0,1,0,0),(14688,2099,'王店乡',4,'',0,1,0,0),(14689,2099,'盱城镇',4,'',0,1,0,0),(14690,2099,'穆店乡',4,'',0,1,0,0),(14691,2099,'管镇镇',4,'',0,1,0,0),(14692,2099,'维桥乡',4,'',0,1,0,0),(14693,2099,'观音寺镇',4,'',0,1,0,0),(14694,2099,'铁佛镇',4,'',0,1,0,0),(14695,2099,'马坝镇',4,'',0,1,0,0),(14696,2099,'鲍集镇',4,'',0,1,0,0),(14697,2099,'黄花塘镇',4,'',0,1,0,0),(14698,2100,'前锋镇',4,'',0,1,0,0),(14699,2100,'吕良镇',4,'',0,1,0,0),(14700,2100,'塔集镇',4,'',0,1,0,0),(14701,2100,'复兴圩农场',4,'',0,1,0,0),(14702,2100,'宝应湖农场',4,'',0,1,0,0),(14703,2100,'戴楼镇',4,'',0,1,0,0),(14704,2100,'涂沟镇',4,'',0,1,0,0),(14705,2100,'金北镇',4,'',0,1,0,0),(14706,2100,'金南镇',4,'',0,1,0,0),(14707,2100,'银集镇',4,'',0,1,0,0),(14708,2100,'闵桥镇',4,'',0,1,0,0),(14709,2100,'陈桥镇',4,'',0,1,0,0),(14710,2100,'黎城镇',4,'',0,1,0,0),(14711,2101,'三仓镇',4,'',0,1,0,0),(14712,2101,'东台镇',4,'',0,1,0,0),(14713,2101,'五烈镇',4,'',0,1,0,0),(14714,2101,'南沈灶镇',4,'',0,1,0,0),(14715,2101,'台南镇',4,'',0,1,0,0),(14716,2101,'后港镇',4,'',0,1,0,0),(14717,2101,'唐洋镇',4,'',0,1,0,0),(14718,2101,'四灶镇',4,'',0,1,0,0),(14719,2101,'头灶镇',4,'',0,1,0,0),(14720,2101,'安丰镇',4,'',0,1,0,0),(14721,2101,'富东镇',4,'',0,1,0,0),(14722,2101,'富安镇',4,'',0,1,0,0),(14723,2101,'广山镇',4,'',0,1,0,0),(14724,2101,'廉贻镇',4,'',0,1,0,0),(14725,2101,'弶港镇',4,'',0,1,0,0),(14726,2101,'新曹镇',4,'',0,1,0,0),(14727,2101,'新街镇',4,'',0,1,0,0),(14728,2101,'时埝镇',4,'',0,1,0,0),(14729,2101,'曹丿镇',4,'',0,1,0,0),(14730,2101,'梁垛镇',4,'',0,1,0,0),(14731,2101,'海丰镇',4,'',0,1,0,0),(14732,2101,'溱东镇',4,'',0,1,0,0),(14733,2101,'许河镇',4,'',0,1,0,0),(14734,2102,'五星街道',4,'',0,1,0,0),(14735,2102,'伍佑镇',4,'',0,1,0,0),(14736,2102,'便仓镇',4,'',0,1,0,0),(14737,2102,'先锋街道',4,'',0,1,0,0),(14738,2102,'南洋镇',4,'',0,1,0,0),(14739,2102,'大洋街道',4,'',0,1,0,0),(14740,2102,'张庄镇',4,'',0,1,0,0),(14741,2102,'文峰街道',4,'',0,1,0,0),(14742,2102,'新兴镇',4,'',0,1,0,0),(14743,2102,'新洋街道',4,'',0,1,0,0),(14744,2102,'步凤镇',4,'',0,1,0,0),(14745,2102,'毓龙街道',4,'',0,1,0,0),(14746,2102,'永丰镇',4,'',0,1,0,0),(14747,2102,'青墩镇',4,'',0,1,0,0),(14748,2102,'黄海街道',4,'',0,1,0,0),(14749,2103,'七套乡',4,'',0,1,0,0),(14750,2103,'六套乡',4,'',0,1,0,0),(14751,2103,'南河镇',4,'',0,1,0,0),(14752,2103,'县开发区',4,'',0,1,0,0),(14753,2103,'双港镇',4,'',0,1,0,0),(14754,2103,'响水镇',4,'',0,1,0,0),(14755,2103,'大有镇',4,'',0,1,0,0),(14756,2103,'小尖镇',4,'',0,1,0,0),(14757,2103,'张集乡',4,'',0,1,0,0),(14758,2103,'省属灌东盐场',4,'',0,1,0,0),(14759,2103,'省属黄海农场',4,'',0,1,0,0),(14760,2103,'老舍乡',4,'',0,1,0,0),(14761,2103,'运河镇',4,'',0,1,0,0),(14762,2103,'陈家港镇',4,'',0,1,0,0),(14763,2103,'黄圩镇',4,'',0,1,0,0),(14764,2104,'万盈镇',4,'',0,1,0,0),(14765,2104,'三龙镇',4,'',0,1,0,0),(14766,2104,'刘庄镇',4,'',0,1,0,0),(14767,2104,'南阳镇',4,'',0,1,0,0),(14768,2104,'大中镇',4,'',0,1,0,0),(14769,2104,'大桥镇',4,'',0,1,0,0),(14770,2104,'小海镇',4,'',0,1,0,0),(14771,2104,'新丰镇',4,'',0,1,0,0),(14772,2104,'方强镇',4,'',0,1,0,0),(14773,2104,'白驹镇',4,'',0,1,0,0),(14774,2104,'草堰镇',4,'',0,1,0,0),(14775,2104,'草庙镇',4,'',0,1,0,0),(14776,2104,'裕华镇',4,'',0,1,0,0),(14777,2104,'西团镇',4,'',0,1,0,0),(14778,2105,'临海镇',4,'',0,1,0,0),(14779,2105,'兴桥镇',4,'',0,1,0,0),(14780,2105,'千秋镇',4,'',0,1,0,0),(14781,2105,'合德镇',4,'',0,1,0,0),(14782,2105,'四明镇',4,'',0,1,0,0),(14783,2105,'国营临海农场',4,'',0,1,0,0),(14784,2105,'国营射阳盐场',4,'',0,1,0,0),(14785,2105,'国营新洋农场',4,'',0,1,0,0),(14786,2105,'国营淮海农场',4,'',0,1,0,0),(14787,2105,'射阳县农业经济开发区',4,'',0,1,0,0),(14788,2105,'新坍镇',4,'',0,1,0,0),(14789,2105,'江苏省射阳经济开发区',4,'',0,1,0,0),(14790,2105,'洋马镇',4,'',0,1,0,0),(14791,2105,'海河镇',4,'',0,1,0,0),(14792,2105,'海通镇',4,'',0,1,0,0),(14793,2105,'特庸镇',4,'',0,1,0,0),(14794,2105,'盐东镇',4,'',0,1,0,0),(14795,2105,'盘湾镇',4,'',0,1,0,0),(14796,2105,'耦耕镇',4,'',0,1,0,0),(14797,2105,'通洋镇',4,'',0,1,0,0),(14798,2105,'长荡镇',4,'',0,1,0,0),(14799,2105,'阜余镇',4,'',0,1,0,0),(14800,2105,'陈洋镇',4,'',0,1,0,0),(14801,2105,'黄尖镇',4,'',0,1,0,0),(14802,2105,'黄沙港镇',4,'',0,1,0,0),(14803,2106,'上冈镇',4,'',0,1,0,0),(14804,2106,'冈东镇',4,'',0,1,0,0),(14805,2106,'冈西镇',4,'',0,1,0,0),(14806,2106,'宝塔镇',4,'',0,1,0,0),(14807,2106,'庆丰镇',4,'',0,1,0,0),(14808,2106,'建湖县经济开发区管理委员会',4,'',0,1,0,0),(14809,2106,'建阳镇',4,'',0,1,0,0),(14810,2106,'恒济镇',4,'',0,1,0,0),(14811,2106,'沿河镇',4,'',0,1,0,0),(14812,2106,'芦沟镇',4,'',0,1,0,0),(14813,2106,'草堰口镇',4,'',0,1,0,0),(14814,2106,'蒋营镇',4,'',0,1,0,0),(14815,2106,'近湖镇',4,'',0,1,0,0),(14816,2106,'钟庄镇',4,'',0,1,0,0),(14817,2106,'颜单镇',4,'',0,1,0,0),(14818,2106,'高作镇',4,'',0,1,0,0),(14819,2107,'东坎镇',4,'',0,1,0,0),(14820,2107,'五汛镇',4,'',0,1,0,0),(14821,2107,'八巨镇',4,'',0,1,0,0),(14822,2107,'八滩镇',4,'',0,1,0,0),(14823,2107,'大套乡',4,'',0,1,0,0),(14824,2107,'天场乡',4,'',0,1,0,0),(14825,2107,'振东乡',4,'',0,1,0,0),(14826,2107,'新滩盐场',4,'',0,1,0,0),(14827,2107,'樊集乡',4,'',0,1,0,0),(14828,2107,'正红镇',4,'',0,1,0,0),(14829,2107,'滨海港镇',4,'',0,1,0,0),(14830,2107,'滨淮农场',4,'',0,1,0,0),(14831,2107,'滨淮镇',4,'',0,1,0,0),(14832,2107,'界牌镇',4,'',0,1,0,0),(14833,2107,'蔡桥镇',4,'',0,1,0,0),(14834,2107,'通榆镇',4,'',0,1,0,0),(14835,2107,'陈涛乡',4,'',0,1,0,0),(14836,2108,'义丰镇',4,'',0,1,0,0),(14837,2108,'北蒋镇',4,'',0,1,0,0),(14838,2108,'北龙港镇',4,'',0,1,0,0),(14839,2108,'大冈镇',4,'',0,1,0,0),(14840,2108,'大纵湖镇',4,'',0,1,0,0),(14841,2108,'学富镇',4,'',0,1,0,0),(14842,2108,'尚庄镇',4,'',0,1,0,0),(14843,2108,'张庄街道',4,'',0,1,0,0),(14844,2108,'新区管委会',4,'',0,1,0,0),(14845,2108,'楼王镇',4,'',0,1,0,0),(14846,2108,'潘黄镇',4,'',0,1,0,0),(14847,2108,'秦南镇',4,'',0,1,0,0),(14848,2108,'葛武镇',4,'',0,1,0,0),(14849,2108,'郭猛镇',4,'',0,1,0,0),(14850,2108,'龙冈镇',4,'',0,1,0,0),(14851,2109,'三灶镇',4,'',0,1,0,0),(14852,2109,'东沟镇',4,'',0,1,0,0),(14853,2109,'公兴镇',4,'',0,1,0,0),(14854,2109,'古河镇',4,'',0,1,0,0),(14855,2109,'合利镇',4,'',0,1,0,0),(14856,2109,'吴滩镇',4,'',0,1,0,0),(14857,2109,'开发区',4,'',0,1,0,0),(14858,2109,'新沟镇',4,'',0,1,0,0),(14859,2109,'施庄镇',4,'',0,1,0,0),(14860,2109,'杨集镇',4,'',0,1,0,0),(14861,2109,'板湖镇',4,'',0,1,0,0),(14862,2109,'沟墩镇',4,'',0,1,0,0),(14863,2109,'益林镇',4,'',0,1,0,0),(14864,2109,'硕集镇',4,'',0,1,0,0),(14865,2109,'罗桥镇',4,'',0,1,0,0),(14866,2109,'羊寨镇',4,'',0,1,0,0),(14867,2109,'芦蒲镇',4,'',0,1,0,0),(14868,2109,'郭墅镇',4,'',0,1,0,0),(14869,2109,'阜城镇',4,'',0,1,0,0),(14870,2109,'陈良镇',4,'',0,1,0,0),(14871,2109,'陈集镇',4,'',0,1,0,0),(14872,2110,'刘集镇',4,'',0,1,0,0),(14873,2110,'大仪镇',4,'',0,1,0,0),(14874,2110,'新城镇',4,'',0,1,0,0),(14875,2110,'新集镇',4,'',0,1,0,0),(14876,2110,'月塘乡',4,'',0,1,0,0),(14877,2110,'朴席镇',4,'',0,1,0,0),(14878,2110,'真州镇',4,'',0,1,0,0),(14879,2110,'谢集乡',4,'',0,1,0,0),(14880,2110,'陈集镇',4,'',0,1,0,0),(14881,2110,'青山镇',4,'',0,1,0,0),(14882,2110,'马集镇',4,'',0,1,0,0),(14883,2111,'夏集镇',4,'',0,1,0,0),(14884,2111,'安宜镇',4,'',0,1,0,0),(14885,2111,'射阳湖镇',4,'',0,1,0,0),(14886,2111,'小官庄镇',4,'',0,1,0,0),(14887,2111,'山阳镇',4,'',0,1,0,0),(14888,2111,'广洋湖镇',4,'',0,1,0,0),(14889,2111,'曹甸镇',4,'',0,1,0,0),(14890,2111,'望直港镇',4,'',0,1,0,0),(14891,2111,'柳堡镇',4,'',0,1,0,0),(14892,2111,'泾河镇',4,'',0,1,0,0),(14893,2111,'范水镇',4,'',0,1,0,0),(14894,2111,'西安丰镇',4,'',0,1,0,0),(14895,2111,'鲁垛镇',4,'',0,1,0,0),(14896,2111,'黄塍镇',4,'',0,1,0,0),(14897,2112,'东关街道',4,'',0,1,0,0),(14898,2112,'文峰街道',4,'',0,1,0,0),(14899,2112,'曲江街道',4,'',0,1,0,0),(14900,2112,'汤汪乡',4,'',0,1,0,0),(14901,2112,'汶河街道',4,'',0,1,0,0),(14902,2112,'湾头镇',4,'',0,1,0,0),(14903,2113,'丁伙镇',4,'',0,1,0,0),(14904,2113,'丁沟镇',4,'',0,1,0,0),(14905,2113,'仙女镇',4,'',0,1,0,0),(14906,2113,'吴桥镇',4,'',0,1,0,0),(14907,2113,'大桥镇',4,'',0,1,0,0),(14908,2113,'宜陵镇',4,'',0,1,0,0),(14909,2113,'小纪镇',4,'',0,1,0,0),(14910,2113,'樊川镇',4,'',0,1,0,0),(14911,2113,'武坚镇',4,'',0,1,0,0),(14912,2113,'浦头镇',4,'',0,1,0,0),(14913,2113,'真武镇',4,'',0,1,0,0),(14914,2113,'邵伯镇',4,'',0,1,0,0),(14915,2113,'郭村镇',4,'',0,1,0,0),(14916,2114,'八里镇',4,'',0,1,0,0),(14917,2114,'双桥乡',4,'',0,1,0,0),(14918,2114,'双桥街道',4,'',0,1,0,0),(14919,2114,'城北乡',4,'',0,1,0,0),(14920,2114,'平山乡',4,'',0,1,0,0),(14921,2114,'扬子津街道',4,'',0,1,0,0),(14922,2114,'文汇街街道',4,'',0,1,0,0),(14923,2114,'施桥镇',4,'',0,1,0,0),(14924,2114,'梅岭街道',4,'',0,1,0,0),(14925,2114,'西湖镇',4,'',0,1,0,0),(14926,2115,'公道镇',4,'',0,1,0,0),(14927,2115,'头桥镇',4,'',0,1,0,0),(14928,2115,'方巷镇',4,'',0,1,0,0),(14929,2115,'李典镇',4,'',0,1,0,0),(14930,2115,'杨庙镇',4,'',0,1,0,0),(14931,2115,'杭集镇',4,'',0,1,0,0),(14932,2115,'槐泗镇',4,'',0,1,0,0),(14933,2115,'汊河街道',4,'',0,1,0,0),(14934,2115,'沙头镇',4,'',0,1,0,0),(14935,2115,'泰安镇',4,'',0,1,0,0),(14936,2115,'瓜洲镇',4,'',0,1,0,0),(14937,2115,'甘泉镇',4,'',0,1,0,0),(14938,2115,'蒋王街道',4,'',0,1,0,0),(14939,2115,'邗上街道',4,'',0,1,0,0),(14940,2116,'三垛镇',4,'',0,1,0,0),(14941,2116,'临泽镇',4,'',0,1,0,0),(14942,2116,'八桥镇',4,'',0,1,0,0),(14943,2116,'卸甲镇',4,'',0,1,0,0),(14944,2116,'司徒镇',4,'',0,1,0,0),(14945,2116,'周山镇',4,'',0,1,0,0),(14946,2116,'周巷镇',4,'',0,1,0,0),(14947,2116,'天山镇',4,'',0,1,0,0),(14948,2116,'横泾镇',4,'',0,1,0,0),(14949,2116,'汉留镇',4,'',0,1,0,0),(14950,2116,'汤庄镇',4,'',0,1,0,0),(14951,2116,'甘垛镇',4,'',0,1,0,0),(14952,2116,'界首镇',4,'',0,1,0,0),(14953,2116,'菱塘回族乡',4,'',0,1,0,0),(14954,2116,'车逻镇',4,'',0,1,0,0),(14955,2116,'送桥镇',4,'',0,1,0,0),(14956,2116,'郭集镇',4,'',0,1,0,0),(14957,2116,'马棚镇',4,'',0,1,0,0),(14958,2116,'高邮镇',4,'',0,1,0,0),(14959,2116,'龙虬镇',4,'',0,1,0,0),(14960,2117,'上党镇',4,'',0,1,0,0),(14961,2117,'世业镇',4,'',0,1,0,0),(14962,2117,'宝堰镇',4,'',0,1,0,0),(14963,2117,'谷阳镇',4,'',0,1,0,0),(14964,2117,'辛丰镇',4,'',0,1,0,0),(14965,2117,'高桥镇',4,'',0,1,0,0),(14966,2117,'高资镇',4,'',0,1,0,0),(14967,2118,'云阳镇',4,'',0,1,0,0),(14968,2118,'司徒镇',4,'',0,1,0,0),(14969,2118,'后巷镇',4,'',0,1,0,0),(14970,2118,'吕城镇',4,'',0,1,0,0),(14971,2118,'埤城镇',4,'',0,1,0,0),(14972,2118,'导墅镇',4,'',0,1,0,0),(14973,2118,'延陵镇',4,'',0,1,0,0),(14974,2118,'新桥镇',4,'',0,1,0,0),(14975,2118,'珥陵镇',4,'',0,1,0,0),(14976,2118,'界牌镇',4,'',0,1,0,0),(14977,2118,'皇塘镇',4,'',0,1,0,0),(14978,2118,'访仙镇',4,'',0,1,0,0),(14979,2118,'陵口镇',4,'',0,1,0,0),(14980,2119,'丁卯街道',4,'',0,1,0,0),(14981,2119,'丁岗镇',4,'',0,1,0,0),(14982,2119,'健康路街道',4,'',0,1,0,0),(14983,2119,'四牌楼街道',4,'',0,1,0,0),(14984,2119,'大市口街道',4,'',0,1,0,0),(14985,2119,'大港街道',4,'',0,1,0,0),(14986,2119,'大港镇',4,'',0,1,0,0),(14987,2119,'大路镇',4,'',0,1,0,0),(14988,2119,'姚桥镇',4,'',0,1,0,0),(14989,2119,'正东路街道',4,'',0,1,0,0),(14990,2119,'谏壁镇',4,'',0,1,0,0),(14991,2119,'象山镇',4,'',0,1,0,0),(14992,2120,'下蜀镇',4,'',0,1,0,0),(14993,2120,'华阳镇',4,'',0,1,0,0),(14994,2120,'后白镇',4,'',0,1,0,0),(14995,2120,'天王镇',4,'',0,1,0,0),(14996,2120,'宝华镇',4,'',0,1,0,0),(14997,2120,'白兔镇',4,'',0,1,0,0),(14998,2120,'茅山镇',4,'',0,1,0,0),(14999,2120,'边城镇',4,'',0,1,0,0),(15000,2120,'郭庄镇',4,'',0,1,0,0),(15001,2120,'黄梅镇',4,'',0,1,0,0),(15002,2121,'三茅镇',4,'',0,1,0,0),(15003,2121,'八桥镇',4,'',0,1,0,0),(15004,2121,'新坝镇',4,'',0,1,0,0),(15005,2121,'油坊镇',4,'',0,1,0,0),(15006,2121,'西来桥镇',4,'',0,1,0,0),(15007,2122,'七里甸街道',4,'',0,1,0,0),(15008,2122,'和平路街道',4,'',0,1,0,0),(15009,2122,'宝塔路街道',4,'',0,1,0,0),(15010,2122,'蒋乔镇',4,'',0,1,0,0),(15011,2122,'金山街道',4,'',0,1,0,0),(15012,2123,'下圩镇',4,'',0,1,0,0),(15013,2123,'中堡镇',4,'',0,1,0,0),(15014,2123,'临城镇',4,'',0,1,0,0),(15015,2123,'合陈镇',4,'',0,1,0,0),(15016,2123,'周奋乡',4,'',0,1,0,0),(15017,2123,'周庄镇',4,'',0,1,0,0),(15018,2123,'垛田镇',4,'',0,1,0,0),(15019,2123,'城东镇',4,'',0,1,0,0),(15020,2123,'大垛镇',4,'',0,1,0,0),(15021,2123,'大营镇',4,'',0,1,0,0),(15022,2123,'大邹镇',4,'',0,1,0,0),(15023,2123,'安丰镇',4,'',0,1,0,0),(15024,2123,'张郭镇',4,'',0,1,0,0),(15025,2123,'戴南镇',4,'',0,1,0,0),(15026,2123,'戴窑镇',4,'',0,1,0,0),(15027,2123,'新垛镇',4,'',0,1,0,0),(15028,2123,'昌荣镇',4,'',0,1,0,0),(15029,2123,'昭阳镇',4,'',0,1,0,0),(15030,2123,'李中镇',4,'',0,1,0,0),(15031,2123,'林湖乡',4,'',0,1,0,0),(15032,2123,'永丰镇',4,'',0,1,0,0),(15033,2123,'沈伦镇',4,'',0,1,0,0),(15034,2123,'沙沟镇',4,'',0,1,0,0),(15035,2123,'海南镇',4,'',0,1,0,0),(15036,2123,'竹泓镇',4,'',0,1,0,0),(15037,2123,'缸顾乡',4,'',0,1,0,0),(15038,2123,'老圩乡',4,'',0,1,0,0),(15039,2123,'茅山镇',4,'',0,1,0,0),(15040,2123,'荻垛镇',4,'',0,1,0,0),(15041,2123,'西郊镇',4,'',0,1,0,0),(15042,2123,'西鲍乡',4,'',0,1,0,0),(15043,2123,'钓鱼镇',4,'',0,1,0,0),(15044,2123,'陈堡镇',4,'',0,1,0,0),(15045,2123,'陶庄镇',4,'',0,1,0,0),(15046,2124,'俞垛镇',4,'',0,1,0,0),(15047,2124,'兴泰镇',4,'',0,1,0,0),(15048,2124,'华港镇',4,'',0,1,0,0),(15049,2124,'城东街道',4,'',0,1,0,0),(15050,2124,'城中街道',4,'',0,1,0,0),(15051,2124,'城南街道',4,'',0,1,0,0),(15052,2124,'大伦镇',4,'',0,1,0,0),(15053,2124,'大泗镇',4,'',0,1,0,0),(15054,2124,'姜堰镇',4,'',0,1,0,0),(15055,2124,'娄庄镇',4,'',0,1,0,0),(15056,2124,'张甸镇',4,'',0,1,0,0),(15057,2124,'桥头镇',4,'',0,1,0,0),(15058,2124,'梁徐镇',4,'',0,1,0,0),(15059,2124,'沈高镇',4,'',0,1,0,0),(15060,2124,'淤溪镇',4,'',0,1,0,0),(15061,2124,'溱潼镇',4,'',0,1,0,0),(15062,2124,'白米镇',4,'',0,1,0,0),(15063,2124,'罡杨镇',4,'',0,1,0,0),(15064,2124,'苏陈镇',4,'',0,1,0,0),(15065,2124,'蒋垛镇',4,'',0,1,0,0),(15066,2124,'顾高镇',4,'',0,1,0,0),(15067,2125,'七圩镇',4,'',0,1,0,0),(15068,2125,'元竹镇',4,'',0,1,0,0),(15069,2125,'分界镇',4,'',0,1,0,0),(15070,2125,'刘陈镇',4,'',0,1,0,0),(15071,2125,'南沙镇',4,'',0,1,0,0),(15072,2125,'古溪镇',4,'',0,1,0,0),(15073,2125,'大生镇',4,'',0,1,0,0),(15074,2125,'姚王镇',4,'',0,1,0,0),(15075,2125,'宣堡镇',4,'',0,1,0,0),(15076,2125,'广陵镇',4,'',0,1,0,0),(15077,2125,'张桥镇',4,'',0,1,0,0),(15078,2125,'新街镇',4,'',0,1,0,0),(15079,2125,'曲霞镇',4,'',0,1,0,0),(15080,2125,'根思乡',4,'',0,1,0,0),(15081,2125,'横垛镇',4,'',0,1,0,0),(15082,2125,'河失镇',4,'',0,1,0,0),(15083,2125,'泰兴镇',4,'',0,1,0,0),(15084,2125,'溪桥镇',4,'',0,1,0,0),(15085,2125,'珊瑚镇',4,'',0,1,0,0),(15086,2125,'胡庄镇',4,'',0,1,0,0),(15087,2125,'蒋华镇',4,'',0,1,0,0),(15088,2125,'过船镇',4,'',0,1,0,0),(15089,2125,'马甸镇',4,'',0,1,0,0),(15090,2125,'黄桥镇',4,'',0,1,0,0),(15091,2126,'九龙镇',4,'',0,1,0,0),(15092,2126,'京泰路街道',4,'',0,1,0,0),(15093,2126,'凤凰路街道',4,'',0,1,0,0),(15094,2126,'城东街道',4,'',0,1,0,0),(15095,2126,'城中街道',4,'',0,1,0,0),(15096,2126,'城北街道',4,'',0,1,0,0),(15097,2126,'城南街道',4,'',0,1,0,0),(15098,2126,'城西街道',4,'',0,1,0,0),(15099,2126,'寺巷镇',4,'',0,1,0,0),(15100,2126,'泰山街道',4,'',0,1,0,0),(15101,2127,'东兴镇',4,'',0,1,0,0),(15102,2127,'季市镇',4,'',0,1,0,0),(15103,2127,'孤山镇',4,'',0,1,0,0),(15104,2127,'斜桥镇',4,'',0,1,0,0),(15105,2127,'新桥镇',4,'',0,1,0,0),(15106,2127,'生祠镇',4,'',0,1,0,0),(15107,2127,'红光镇',4,'',0,1,0,0),(15108,2127,'西来镇',4,'',0,1,0,0),(15109,2127,'靖城镇',4,'',0,1,0,0),(15110,2127,'马桥镇',4,'',0,1,0,0),(15111,2128,'刁铺街道',4,'',0,1,0,0),(15112,2128,'口岸街道',4,'',0,1,0,0),(15113,2128,'永安洲镇',4,'',0,1,0,0),(15114,2128,'白马镇',4,'',0,1,0,0),(15115,2128,'许庄街道',4,'',0,1,0,0),(15116,2128,'野徐镇',4,'',0,1,0,0),(15117,2129,'三棵树乡',4,'',0,1,0,0),(15118,2129,'中杨镇',4,'',0,1,0,0),(15119,2129,'仓集镇',4,'',0,1,0,0),(15120,2129,'南蔡乡',4,'',0,1,0,0),(15121,2129,'双庄镇',4,'',0,1,0,0),(15122,2129,'古城街道',4,'',0,1,0,0),(15123,2129,'古楚街道',4,'',0,1,0,0),(15124,2129,'埠子镇',4,'',0,1,0,0),(15125,2129,'屠园乡',4,'',0,1,0,0),(15126,2129,'幸福街道',4,'',0,1,0,0),(15127,2129,'河滨街道',4,'',0,1,0,0),(15128,2129,'洋北镇',4,'',0,1,0,0),(15129,2129,'洋河镇',4,'',0,1,0,0),(15130,2129,'罗圩乡',4,'',0,1,0,0),(15131,2129,'耿车镇',4,'',0,1,0,0),(15132,2129,'郑楼镇',4,'',0,1,0,0),(15133,2129,'陈集镇',4,'',0,1,0,0),(15134,2129,'项里街道',4,'',0,1,0,0),(15135,2129,'黄河街道',4,'',0,1,0,0),(15136,2129,'龙河镇',4,'',0,1,0,0),(15137,2130,'丁嘴镇',4,'',0,1,0,0),(15138,2130,'井头乡',4,'',0,1,0,0),(15139,2130,'仰化镇',4,'',0,1,0,0),(15140,2130,'侍岭镇',4,'',0,1,0,0),(15141,2130,'保安乡',4,'',0,1,0,0),(15142,2130,'关庙镇',4,'',0,1,0,0),(15143,2130,'大兴镇',4,'',0,1,0,0),(15144,2130,'新庄镇',4,'',0,1,0,0),(15145,2130,'晓店镇',4,'',0,1,0,0),(15146,2130,'曹集乡',4,'',0,1,0,0),(15147,2130,'来龙镇',4,'',0,1,0,0),(15148,2130,'王官集镇',4,'',0,1,0,0),(15149,2130,'皂河镇',4,'',0,1,0,0),(15150,2130,'蔡集镇',4,'',0,1,0,0),(15151,2130,'陆集镇',4,'',0,1,0,0),(15152,2130,'顺河镇',4,'',0,1,0,0),(15153,2130,'黄墩镇',4,'',0,1,0,0),(15154,2131,'万匹乡',4,'',0,1,0,0),(15155,2131,'东小店乡',4,'',0,1,0,0),(15156,2131,'刘集镇',4,'',0,1,0,0),(15157,2131,'北丁集乡',4,'',0,1,0,0),(15158,2131,'华冲镇',4,'',0,1,0,0),(15159,2131,'吴集镇',4,'',0,1,0,0),(15160,2131,'周集乡',4,'',0,1,0,0),(15161,2131,'塘沟镇',4,'',0,1,0,0),(15162,2131,'官墩乡',4,'',0,1,0,0),(15163,2131,'庙头镇',4,'',0,1,0,0),(15164,2131,'张圩乡',4,'',0,1,0,0),(15165,2131,'悦来镇',4,'',0,1,0,0),(15166,2131,'扎下镇',4,'',0,1,0,0),(15167,2131,'新河镇',4,'',0,1,0,0),(15168,2131,'李恒镇',4,'',0,1,0,0),(15169,2131,'桑墟镇',4,'',0,1,0,0),(15170,2131,'汤涧镇',4,'',0,1,0,0),(15171,2131,'沂涛镇',4,'',0,1,0,0),(15172,2131,'沭城镇',4,'',0,1,0,0),(15173,2131,'湖东镇',4,'',0,1,0,0),(15174,2131,'潼阳镇',4,'',0,1,0,0),(15175,2131,'耿圩镇',4,'',0,1,0,0),(15176,2131,'胡集镇',4,'',0,1,0,0),(15177,2131,'茆圩乡',4,'',0,1,0,0),(15178,2131,'西圩乡',4,'',0,1,0,0),(15179,2131,'贤官镇',4,'',0,1,0,0),(15180,2131,'钱集镇',4,'',0,1,0,0),(15181,2131,'陇集镇',4,'',0,1,0,0),(15182,2131,'青伊湖农场',4,'',0,1,0,0),(15183,2131,'青伊湖镇',4,'',0,1,0,0),(15184,2131,'韩山镇',4,'',0,1,0,0),(15185,2131,'颜集镇',4,'',0,1,0,0),(15186,2131,'马厂镇',4,'',0,1,0,0),(15187,2131,'高墟镇',4,'',0,1,0,0),(15188,2131,'龙庙镇',4,'',0,1,0,0),(15189,2132,'上塘镇',4,'',0,1,0,0),(15190,2132,'临淮镇',4,'',0,1,0,0),(15191,2132,'半城镇',4,'',0,1,0,0),(15192,2132,'双沟镇',4,'',0,1,0,0),(15193,2132,'四河乡',4,'',0,1,0,0),(15194,2132,'城头乡',4,'',0,1,0,0),(15195,2132,'天岗湖乡',4,'',0,1,0,0),(15196,2132,'太平镇',4,'',0,1,0,0),(15197,2132,'孙园镇',4,'',0,1,0,0),(15198,2132,'峰山乡',4,'',0,1,0,0),(15199,2132,'归仁镇',4,'',0,1,0,0),(15200,2132,'曹庙乡',4,'',0,1,0,0),(15201,2132,'朱湖镇',4,'',0,1,0,0),(15202,2132,'梅花镇',4,'',0,1,0,0),(15203,2132,'江苏省洪泽湖农场',4,'',0,1,0,0),(15204,2132,'瑶沟乡',4,'',0,1,0,0),(15205,2132,'界集镇',4,'',0,1,0,0),(15206,2132,'石集乡',4,'',0,1,0,0),(15207,2132,'车门乡',4,'',0,1,0,0),(15208,2132,'金锁镇',4,'',0,1,0,0),(15209,2132,'陈圩乡',4,'',0,1,0,0),(15210,2132,'青阳镇',4,'',0,1,0,0),(15211,2132,'魏营镇',4,'',0,1,0,0),(15212,2132,'龙集镇',4,'',0,1,0,0),(15213,2133,'三庄乡',4,'',0,1,0,0),(15214,2133,'临河镇',4,'',0,1,0,0),(15215,2133,'众兴镇',4,'',0,1,0,0),(15216,2133,'八集乡',4,'',0,1,0,0),(15217,2133,'南刘集乡',4,'',0,1,0,0),(15218,2133,'卢集镇',4,'',0,1,0,0),(15219,2133,'庄圩乡',4,'',0,1,0,0),(15220,2133,'张家圩镇',4,'',0,1,0,0),(15221,2133,'新袁镇',4,'',0,1,0,0),(15222,2133,'李口镇',4,'',0,1,0,0),(15223,2133,'棉花原种场',4,'',0,1,0,0),(15224,2133,'泗阳农场',4,'',0,1,0,0),(15225,2133,'爱园镇',4,'',0,1,0,0),(15226,2133,'王集镇',4,'',0,1,0,0),(15227,2133,'穿城镇',4,'',0,1,0,0),(15228,2133,'裴圩镇',4,'',0,1,0,0),(15229,2133,'里仁乡',4,'',0,1,0,0),(15230,2133,'高渡镇',4,'',0,1,0,0),(15231,2134,'南星街道',4,'',0,1,0,0),(15232,2134,'小营街道',4,'',0,1,0,0),(15233,2134,'望江街道',4,'',0,1,0,0),(15234,2134,'清波街道',4,'',0,1,0,0),(15235,2134,'湖滨街道',4,'',0,1,0,0),(15236,2134,'紫阳街道',4,'',0,1,0,0),(15237,2135,'东新街道',4,'',0,1,0,0),(15238,2135,'天水街道',4,'',0,1,0,0),(15239,2135,'文晖街道',4,'',0,1,0,0),(15240,2135,'朝晖街道',4,'',0,1,0,0),(15241,2135,'武林街道',4,'',0,1,0,0),(15242,2135,'潮鸣街道',4,'',0,1,0,0),(15243,2135,'石桥街道',4,'',0,1,0,0),(15244,2135,'长庆街道',4,'',0,1,0,0),(15245,2136,'三口镇',4,'',0,1,0,0),(15246,2136,'上甘街道',4,'',0,1,0,0),(15247,2136,'乐平乡',4,'',0,1,0,0),(15248,2136,'千洪乡',4,'',0,1,0,0),(15249,2136,'大峡谷镇',4,'',0,1,0,0),(15250,2136,'太湖源镇',4,'',0,1,0,0),(15251,2136,'太阳镇',4,'',0,1,0,0),(15252,2136,'岛石镇',4,'',0,1,0,0),(15253,2136,'新桥乡',4,'',0,1,0,0),(15254,2136,'于潜镇',4,'',0,1,0,0),(15255,2136,'昌化镇',4,'',0,1,0,0),(15256,2136,'板桥乡',4,'',0,1,0,0),(15257,2136,'横畈镇',4,'',0,1,0,0),(15258,2136,'横路乡',4,'',0,1,0,0),(15259,2136,'河桥镇',4,'',0,1,0,0),(15260,2136,'清凉峰镇',4,'',0,1,0,0),(15261,2136,'湍口镇',4,'',0,1,0,0),(15262,2136,'潜川镇',4,'',0,1,0,0),(15263,2136,'玲珑街道',4,'',0,1,0,0),(15264,2136,'藻溪镇',4,'',0,1,0,0),(15265,2136,'西天目乡',4,'',0,1,0,0),(15266,2136,'锦城街道',4,'',0,1,0,0),(15267,2136,'青山湖街道',4,'',0,1,0,0),(15268,2136,'马啸乡',4,'',0,1,0,0),(15269,2136,'高虹镇',4,'',0,1,0,0),(15270,2136,'龙岗镇',4,'',0,1,0,0),(15271,2137,'东湖街道',4,'',0,1,0,0),(15272,2137,'中泰乡',4,'',0,1,0,0),(15273,2137,'临平街道',4,'',0,1,0,0),(15274,2137,'乔司镇',4,'',0,1,0,0),(15275,2137,'仁和镇',4,'',0,1,0,0),(15276,2137,'仓前镇',4,'',0,1,0,0),(15277,2137,'余杭镇',4,'',0,1,0,0),(15278,2137,'南苑街道',4,'',0,1,0,0),(15279,2137,'塘栖镇',4,'',0,1,0,0),(15280,2137,'崇贤镇',4,'',0,1,0,0),(15281,2137,'径山镇',4,'',0,1,0,0),(15282,2137,'星桥街道',4,'',0,1,0,0),(15283,2137,'瓶窑镇',4,'',0,1,0,0),(15284,2137,'百丈镇',4,'',0,1,0,0),(15285,2137,'良渚镇',4,'',0,1,0,0),(15286,2137,'运河镇',4,'',0,1,0,0),(15287,2137,'闲林镇',4,'',0,1,0,0),(15288,2137,'鸬鸟镇',4,'',0,1,0,0),(15289,2137,'黄湖镇',4,'',0,1,0,0),(15290,2138,'万市镇',4,'',0,1,0,0),(15291,2138,'上官乡',4,'',0,1,0,0),(15292,2138,'东洲街道',4,'',0,1,0,0),(15293,2138,'受降镇',4,'',0,1,0,0),(15294,2138,'场口镇',4,'',0,1,0,0),(15295,2138,'大源镇',4,'',0,1,0,0),(15296,2138,'富春街道',4,'',0,1,0,0),(15297,2138,'常安镇',4,'',0,1,0,0),(15298,2138,'常绿镇',4,'',0,1,0,0),(15299,2138,'新桐乡',4,'',0,1,0,0),(15300,2138,'新登镇',4,'',0,1,0,0),(15301,2138,'春建乡',4,'',0,1,0,0),(15302,2138,'春江街道',4,'',0,1,0,0),(15303,2138,'永昌镇',4,'',0,1,0,0),(15304,2138,'洞桥镇',4,'',0,1,0,0),(15305,2138,'渌渚镇',4,'',0,1,0,0),(15306,2138,'渔山乡',4,'',0,1,0,0),(15307,2138,'湖源乡',4,'',0,1,0,0),(15308,2138,'灵桥镇',4,'',0,1,0,0),(15309,2138,'环山乡',4,'',0,1,0,0),(15310,2138,'胥口镇',4,'',0,1,0,0),(15311,2138,'里山镇',4,'',0,1,0,0),(15312,2138,'高桥镇',4,'',0,1,0,0),(15313,2138,'鹿山街道',4,'',0,1,0,0),(15314,2138,'龙门镇',4,'',0,1,0,0),(15315,2139,'三都镇',4,'',0,1,0,0),(15316,2139,'下涯镇',4,'',0,1,0,0),(15317,2139,'干潭镇',4,'',0,1,0,0),(15318,2139,'大同镇',4,'',0,1,0,0),(15319,2139,'大慈岩镇',4,'',0,1,0,0),(15320,2139,'大洋镇',4,'',0,1,0,0),(15321,2139,'寿昌镇',4,'',0,1,0,0),(15322,2139,'新安江街道',4,'',0,1,0,0),(15323,2139,'更楼街道',4,'',0,1,0,0),(15324,2139,'李家镇',4,'',0,1,0,0),(15325,2139,'杨村桥镇',4,'',0,1,0,0),(15326,2139,'梅城镇',4,'',0,1,0,0),(15327,2139,'洋溪街道',4,'',0,1,0,0),(15328,2139,'航头镇',4,'',0,1,0,0),(15329,2139,'莲花镇',4,'',0,1,0,0),(15330,2139,'钦堂乡',4,'',0,1,0,0),(15331,2140,'上塘镇',4,'',0,1,0,0),(15332,2140,'半山镇',4,'',0,1,0,0),(15333,2140,'和睦街道',4,'',0,1,0,0),(15334,2140,'大关街道',4,'',0,1,0,0),(15335,2140,'小河街道',4,'',0,1,0,0),(15336,2140,'康桥镇',4,'',0,1,0,0),(15337,2140,'拱宸桥街道',4,'',0,1,0,0),(15338,2140,'湖墅街道',4,'',0,1,0,0),(15339,2140,'祥符镇',4,'',0,1,0,0),(15340,2140,'米市巷街道',4,'',0,1,0,0),(15341,2141,'凤川镇',4,'',0,1,0,0),(15342,2141,'分水镇',4,'',0,1,0,0),(15343,2141,'合村乡',4,'',0,1,0,0),(15344,2141,'富春江镇',4,'',0,1,0,0),(15345,2141,'新合乡',4,'',0,1,0,0),(15346,2141,'旧县街道',4,'',0,1,0,0),(15347,2141,'桐君街道',4,'',0,1,0,0),(15348,2141,'横村镇',4,'',0,1,0,0),(15349,2141,'江南镇',4,'',0,1,0,0),(15350,2141,'瑶琳镇',4,'',0,1,0,0),(15351,2141,'百江镇',4,'',0,1,0,0),(15352,2141,'莪山畲族乡',4,'',0,1,0,0),(15353,2141,'钟山乡',4,'',0,1,0,0),(15354,2142,'丁桥镇',4,'',0,1,0,0),(15355,2142,'下沙街道',4,'',0,1,0,0),(15356,2142,'九堡镇',4,'',0,1,0,0),(15357,2142,'凯旋街道',4,'',0,1,0,0),(15358,2142,'四季青街道',4,'',0,1,0,0),(15359,2142,'彭埠镇',4,'',0,1,0,0),(15360,2142,'白杨街道',4,'',0,1,0,0),(15361,2142,'笕桥镇',4,'',0,1,0,0),(15362,2142,'采荷街道',4,'',0,1,0,0),(15363,2142,'闸弄口街道',4,'',0,1,0,0),(15364,2143,'中洲镇',4,'',0,1,0,0),(15365,2143,'临岐镇',4,'',0,1,0,0),(15366,2143,'千岛湖镇',4,'',0,1,0,0),(15367,2143,'大墅镇',4,'',0,1,0,0),(15368,2143,'姜家镇',4,'',0,1,0,0),(15369,2143,'威坪镇',4,'',0,1,0,0),(15370,2143,'安阳乡',4,'',0,1,0,0),(15371,2143,'宋村乡',4,'',0,1,0,0),(15372,2143,'富文乡',4,'',0,1,0,0),(15373,2143,'屏门乡',4,'',0,1,0,0),(15374,2143,'左口乡',4,'',0,1,0,0),(15375,2143,'文昌镇',4,'',0,1,0,0),(15376,2143,'枫树岭镇',4,'',0,1,0,0),(15377,2143,'梓桐镇',4,'',0,1,0,0),(15378,2143,'汾口镇',4,'',0,1,0,0),(15379,2143,'浪川乡',4,'',0,1,0,0),(15380,2143,'王阜乡',4,'',0,1,0,0),(15381,2143,'瑶山乡',4,'',0,1,0,0),(15382,2143,'界首乡',4,'',0,1,0,0),(15383,2143,'石林镇',4,'',0,1,0,0),(15384,2143,'里商乡',4,'',0,1,0,0),(15385,2143,'金峰乡',4,'',0,1,0,0),(15386,2143,'鸠坑乡',4,'',0,1,0,0),(15387,2144,'浦沿街道',4,'',0,1,0,0),(15388,2144,'西兴街道',4,'',0,1,0,0),(15389,2144,'长河街道',4,'',0,1,0,0),(15390,2145,'临浦镇',4,'',0,1,0,0),(15391,2145,'义桥镇',4,'',0,1,0,0),(15392,2145,'义蓬镇',4,'',0,1,0,0),(15393,2145,'党山镇',4,'',0,1,0,0),(15394,2145,'党湾镇',4,'',0,1,0,0),(15395,2145,'北干街道',4,'',0,1,0,0),(15396,2145,'南阳镇',4,'',0,1,0,0),(15397,2145,'坎山镇',4,'',0,1,0,0),(15398,2145,'城厢街道',4,'',0,1,0,0),(15399,2145,'宁围镇',4,'',0,1,0,0),(15400,2145,'戴村镇',4,'',0,1,0,0),(15401,2145,'所前镇',4,'',0,1,0,0),(15402,2145,'新塘街道',4,'',0,1,0,0),(15403,2145,'新湾镇',4,'',0,1,0,0),(15404,2145,'新街镇',4,'',0,1,0,0),(15405,2145,'楼塔镇',4,'',0,1,0,0),(15406,2145,'河上镇',4,'',0,1,0,0),(15407,2145,'河庄镇',4,'',0,1,0,0),(15408,2145,'浦阳镇',4,'',0,1,0,0),(15409,2145,'瓜沥镇',4,'',0,1,0,0),(15410,2145,'益农镇',4,'',0,1,0,0),(15411,2145,'蜀山街道',4,'',0,1,0,0),(15412,2145,'衙前镇',4,'',0,1,0,0),(15413,2145,'进化镇',4,'',0,1,0,0),(15414,2145,'闻堰镇',4,'',0,1,0,0),(15415,2145,'靖江镇',4,'',0,1,0,0),(15416,2146,'三墩镇',4,'',0,1,0,0),(15417,2146,'北山街道',4,'',0,1,0,0),(15418,2146,'古荡街道',4,'',0,1,0,0),(15419,2146,'周浦乡',4,'',0,1,0,0),(15420,2146,'文新街道',4,'',0,1,0,0),(15421,2146,'灵隐街道',4,'',0,1,0,0),(15422,2146,'留下镇',4,'',0,1,0,0),(15423,2146,'翠苑街道',4,'',0,1,0,0),(15424,2146,'蒋村乡',4,'',0,1,0,0),(15425,2146,'袁浦镇',4,'',0,1,0,0),(15426,2146,'西湖街道',4,'',0,1,0,0),(15427,2146,'西溪街道',4,'',0,1,0,0),(15428,2146,'转塘镇',4,'',0,1,0,0),(15429,2146,'龙坞镇',4,'',0,1,0,0),(15430,2147,'丈亭镇',4,'',0,1,0,0),(15431,2147,'三七市镇',4,'',0,1,0,0),(15432,2147,'临山镇',4,'',0,1,0,0),(15433,2147,'低塘街道',4,'',0,1,0,0),(15434,2147,'兰江街道',4,'',0,1,0,0),(15435,2147,'凤山街道',4,'',0,1,0,0),(15436,2147,'四明山镇',4,'',0,1,0,0),(15437,2147,'大岚镇',4,'',0,1,0,0),(15438,2147,'大隐镇',4,'',0,1,0,0),(15439,2147,'小曹娥镇',4,'',0,1,0,0),(15440,2147,'梁弄镇',4,'',0,1,0,0),(15441,2147,'梨洲街道',4,'',0,1,0,0),(15442,2147,'河姆渡镇',4,'',0,1,0,0),(15443,2147,'泗门镇',4,'',0,1,0,0),(15444,2147,'牟山镇',4,'',0,1,0,0),(15445,2147,'郎霞街道',4,'',0,1,0,0),(15446,2147,'阳明街道',4,'',0,1,0,0),(15447,2147,'陆埠镇',4,'',0,1,0,0),(15448,2147,'马渚镇',4,'',0,1,0,0),(15449,2147,'鹿亭乡',4,'',0,1,0,0),(15450,2147,'黄家埠镇',4,'',0,1,0,0),(15451,2148,'大碶街道',4,'',0,1,0,0),(15452,2148,'小港街道',4,'',0,1,0,0),(15453,2148,'新碶街道',4,'',0,1,0,0),(15454,2148,'春晓镇',4,'',0,1,0,0),(15455,2148,'柴桥街道',4,'',0,1,0,0),(15456,2148,'梅山乡',4,'',0,1,0,0),(15457,2148,'白峰镇',4,'',0,1,0,0),(15458,2148,'霞浦街道',4,'',0,1,0,0),(15459,2149,'大堰镇',4,'',0,1,0,0),(15460,2149,'尚田镇',4,'',0,1,0,0),(15461,2149,'岳林街道',4,'',0,1,0,0),(15462,2149,'松岙镇',4,'',0,1,0,0),(15463,2149,'江口街道',4,'',0,1,0,0),(15464,2149,'溪口镇',4,'',0,1,0,0),(15465,2149,'莼湖镇',4,'',0,1,0,0),(15466,2149,'萧王庙街道',4,'',0,1,0,0),(15467,2149,'裘村镇',4,'',0,1,0,0),(15468,2149,'西坞街道',4,'',0,1,0,0),(15469,2149,'锦屏街道',4,'',0,1,0,0),(15470,2150,'一市镇',4,'',0,1,0,0),(15471,2150,'前童镇',4,'',0,1,0,0),(15472,2150,'力洋镇',4,'',0,1,0,0),(15473,2150,'大佳何镇',4,'',0,1,0,0),(15474,2150,'岔路镇',4,'',0,1,0,0),(15475,2150,'强蛟镇',4,'',0,1,0,0),(15476,2150,'桃源街道',4,'',0,1,0,0),(15477,2150,'桑洲镇',4,'',0,1,0,0),(15478,2150,'桥头胡街道',4,'',0,1,0,0),(15479,2150,'梅林街道',4,'',0,1,0,0),(15480,2150,'深圳镇',4,'',0,1,0,0),(15481,2150,'胡陈乡',4,'',0,1,0,0),(15482,2150,'茶院乡',4,'',0,1,0,0),(15483,2150,'西店镇',4,'',0,1,0,0),(15484,2150,'越溪乡',4,'',0,1,0,0),(15485,2150,'跃龙街道',4,'',0,1,0,0),(15486,2150,'长街镇',4,'',0,1,0,0),(15487,2150,'黄坛镇',4,'',0,1,0,0),(15488,2151,'三北镇',4,'',0,1,0,0),(15489,2151,'匡堰镇',4,'',0,1,0,0),(15490,2151,'周巷镇',4,'',0,1,0,0),(15491,2151,'坎墩街道',4,'',0,1,0,0),(15492,2151,'天元镇',4,'',0,1,0,0),(15493,2151,'宗汉街道',4,'',0,1,0,0),(15494,2151,'崇寿镇',4,'',0,1,0,0),(15495,2151,'庵东镇',4,'',0,1,0,0),(15496,2151,'掌起镇',4,'',0,1,0,0),(15497,2151,'新浦镇',4,'',0,1,0,0),(15498,2151,'桥头镇',4,'',0,1,0,0),(15499,2151,'横河镇',4,'',0,1,0,0),(15500,2151,'浒山街道',4,'',0,1,0,0),(15501,2151,'胜山镇',4,'',0,1,0,0),(15502,2151,'范市镇',4,'',0,1,0,0),(15503,2151,'观海卫镇',4,'',0,1,0,0),(15504,2151,'逍林镇',4,'',0,1,0,0),(15505,2151,'长河镇',4,'',0,1,0,0),(15506,2151,'附海镇',4,'',0,1,0,0),(15507,2151,'龙山镇',4,'',0,1,0,0),(15508,2152,'东柳街道',4,'',0,1,0,0),(15509,2152,'东胜街道',4,'',0,1,0,0),(15510,2152,'东郊街道',4,'',0,1,0,0),(15511,2152,'明楼街道',4,'',0,1,0,0),(15512,2152,'白鹤街道',4,'',0,1,0,0),(15513,2152,'百丈街道',4,'',0,1,0,0),(15514,2152,'福明街道',4,'',0,1,0,0),(15515,2153,'中马街道',4,'',0,1,0,0),(15516,2153,'孔浦街道',4,'',0,1,0,0),(15517,2153,'庄桥街道',4,'',0,1,0,0),(15518,2153,'慈城镇',4,'',0,1,0,0),(15519,2153,'文教街道',4,'',0,1,0,0),(15520,2153,'洪塘街道',4,'',0,1,0,0),(15521,2153,'甬江街道',4,'',0,1,0,0),(15522,2153,'白沙街道',4,'',0,1,0,0),(15523,2154,'南门街道',4,'',0,1,0,0),(15524,2154,'月湖街道',4,'',0,1,0,0),(15525,2154,'望春街道',4,'',0,1,0,0),(15526,2154,'段塘街道',4,'',0,1,0,0),(15527,2154,'江厦街道',4,'',0,1,0,0),(15528,2154,'白云街道',4,'',0,1,0,0),(15529,2154,'西门街道',4,'',0,1,0,0),(15530,2154,'鼓楼街道',4,'',0,1,0,0),(15531,2155,'东陈乡',4,'',0,1,0,0),(15532,2155,'丹东街道',4,'',0,1,0,0),(15533,2155,'丹西街道',4,'',0,1,0,0),(15534,2155,'墙头镇',4,'',0,1,0,0),(15535,2155,'大徐镇',4,'',0,1,0,0),(15536,2155,'定塘镇',4,'',0,1,0,0),(15537,2155,'新桥镇',4,'',0,1,0,0),(15538,2155,'晓塘乡',4,'',0,1,0,0),(15539,2155,'泗洲头镇',4,'',0,1,0,0),(15540,2155,'涂茨镇',4,'',0,1,0,0),(15541,2155,'爵溪街道',4,'',0,1,0,0),(15542,2155,'石浦镇',4,'',0,1,0,0),(15543,2155,'茅洋乡',4,'',0,1,0,0),(15544,2155,'西周镇',4,'',0,1,0,0),(15545,2155,'贤庠镇',4,'',0,1,0,0),(15546,2155,'高塘岛乡',4,'',0,1,0,0),(15547,2155,'鹤浦镇',4,'',0,1,0,0),(15548,2155,'黄避岙乡',4,'',0,1,0,0),(15549,2156,'下应街道',4,'',0,1,0,0),(15550,2156,'东吴镇',4,'',0,1,0,0),(15551,2156,'云龙镇',4,'',0,1,0,0),(15552,2156,'五乡镇',4,'',0,1,0,0),(15553,2156,'古林镇',4,'',0,1,0,0),(15554,2156,'咸祥镇',4,'',0,1,0,0),(15555,2156,'塘溪镇',4,'',0,1,0,0),(15556,2156,'姜山镇',4,'',0,1,0,0),(15557,2156,'横溪镇',4,'',0,1,0,0),(15558,2156,'横街镇',4,'',0,1,0,0),(15559,2156,'洞桥镇',4,'',0,1,0,0),(15560,2156,'瞻岐镇',4,'',0,1,0,0),(15561,2156,'石碶街道',4,'',0,1,0,0),(15562,2156,'章水镇',4,'',0,1,0,0),(15563,2156,'邱隘镇',4,'',0,1,0,0),(15564,2156,'鄞江镇',4,'',0,1,0,0),(15565,2156,'钟公庙街道',4,'',0,1,0,0),(15566,2156,'集士港镇',4,'',0,1,0,0),(15567,2156,'高桥镇',4,'',0,1,0,0),(15568,2156,'龙观乡',4,'',0,1,0,0),(15569,2157,'九龙湖镇',4,'',0,1,0,0),(15570,2157,'庄市街道',4,'',0,1,0,0),(15571,2157,'招宝山街道',4,'',0,1,0,0),(15572,2157,'澥浦镇',4,'',0,1,0,0),(15573,2157,'蛟川街道',4,'',0,1,0,0),(15574,2157,'骆驼街道',4,'',0,1,0,0),(15575,2158,'七里港镇',4,'',0,1,0,0),(15576,2158,'乐成镇',4,'',0,1,0,0),(15577,2158,'仙溪镇',4,'',0,1,0,0),(15578,2158,'北白象镇',4,'',0,1,0,0),(15579,2158,'南塘镇',4,'',0,1,0,0),(15580,2158,'南岳镇',4,'',0,1,0,0),(15581,2158,'双峰乡',4,'',0,1,0,0),(15582,2158,'四都乡',4,'',0,1,0,0),(15583,2158,'城北乡',4,'',0,1,0,0),(15584,2158,'大荆镇',4,'',0,1,0,0),(15585,2158,'天成乡',4,'',0,1,0,0),(15586,2158,'岭底乡',4,'',0,1,0,0),(15587,2158,'智仁乡',4,'',0,1,0,0),(15588,2158,'柳市镇',4,'',0,1,0,0),(15589,2158,'淡溪镇',4,'',0,1,0,0),(15590,2158,'清江镇',4,'',0,1,0,0),(15591,2158,'湖雾镇',4,'',0,1,0,0),(15592,2158,'白石镇',4,'',0,1,0,0),(15593,2158,'石帆镇',4,'',0,1,0,0),(15594,2158,'磐石镇',4,'',0,1,0,0),(15595,2158,'福溪乡',4,'',0,1,0,0),(15596,2158,'翁垟镇',4,'',0,1,0,0),(15597,2158,'芙蓉镇',4,'',0,1,0,0),(15598,2158,'蒲岐镇',4,'',0,1,0,0),(15599,2158,'虹桥镇',4,'',0,1,0,0),(15600,2158,'象阳镇',4,'',0,1,0,0),(15601,2158,'镇安乡',4,'',0,1,0,0),(15602,2158,'雁湖乡',4,'',0,1,0,0),(15603,2158,'雁荡镇',4,'',0,1,0,0),(15604,2158,'黄华镇',4,'',0,1,0,0),(15605,2158,'龙西乡',4,'',0,1,0,0),(15606,2159,'凤卧镇',4,'',0,1,0,0),(15607,2159,'凤巢乡',4,'',0,1,0,0),(15608,2159,'南湖乡',4,'',0,1,0,0),(15609,2159,'南雁镇',4,'',0,1,0,0),(15610,2159,'南麂镇',4,'',0,1,0,0),(15611,2159,'吴垟乡',4,'',0,1,0,0),(15612,2159,'宋埠镇',4,'',0,1,0,0),(15613,2159,'宋桥镇',4,'',0,1,0,0),(15614,2159,'山门镇',4,'',0,1,0,0),(15615,2159,'怀溪乡',4,'',0,1,0,0),(15616,2159,'昆阳镇',4,'',0,1,0,0),(15617,2159,'晓坑乡',4,'',0,1,0,0),(15618,2159,'朝阳乡',4,'',0,1,0,0),(15619,2159,'桃源乡',4,'',0,1,0,0),(15620,2159,'梅源乡',4,'',0,1,0,0),(15621,2159,'梅溪乡',4,'',0,1,0,0),(15622,2159,'榆垟镇',4,'',0,1,0,0),(15623,2159,'水头镇',4,'',0,1,0,0),(15624,2159,'维新乡',4,'',0,1,0,0),(15625,2159,'腾蛟镇',4,'',0,1,0,0),(15626,2159,'萧江镇',4,'',0,1,0,0),(15627,2159,'西湾乡',4,'',0,1,0,0),(15628,2159,'郑楼镇',4,'',0,1,0,0),(15629,2159,'钱仓镇',4,'',0,1,0,0),(15630,2159,'闹村乡',4,'',0,1,0,0),(15631,2159,'青街畲族乡',4,'',0,1,0,0),(15632,2159,'顺溪镇',4,'',0,1,0,0),(15633,2159,'鳌江镇',4,'',0,1,0,0),(15634,2159,'鹤溪镇',4,'',0,1,0,0),(15635,2159,'麻步镇',4,'',0,1,0,0),(15636,2159,'龙尾乡',4,'',0,1,0,0),(15637,2160,'上林乡',4,'',0,1,0,0),(15638,2160,'下垟乡',4,'',0,1,0,0),(15639,2160,'东溪乡',4,'',0,1,0,0),(15640,2160,'二源乡',4,'',0,1,0,0),(15641,2160,'云湖乡',4,'',0,1,0,0),(15642,2160,'仰山乡',4,'',0,1,0,0),(15643,2160,'公阳乡',4,'',0,1,0,0),(15644,2160,'十源乡',4,'',0,1,0,0),(15645,2160,'南田镇',4,'',0,1,0,0),(15646,2160,'双桂乡',4,'',0,1,0,0),(15647,2160,'周壤乡',4,'',0,1,0,0),(15648,2160,'周山畲族乡',4,'',0,1,0,0),(15649,2160,'大峃镇',4,'',0,1,0,0),(15650,2160,'富岙乡',4,'',0,1,0,0),(15651,2160,'岭后乡',4,'',0,1,0,0),(15652,2160,'峃口乡',4,'',0,1,0,0),(15653,2160,'巨屿镇',4,'',0,1,0,0),(15654,2160,'平和乡',4,'',0,1,0,0),(15655,2160,'朱雅乡',4,'',0,1,0,0),(15656,2160,'桂山乡',4,'',0,1,0,0),(15657,2160,'樟台乡',4,'',0,1,0,0),(15658,2160,'玉壶镇',4,'',0,1,0,0),(15659,2160,'珊溪镇',4,'',0,1,0,0),(15660,2160,'百丈漈镇',4,'',0,1,0,0),(15661,2160,'石垟乡',4,'',0,1,0,0),(15662,2160,'西坑畲族镇',4,'',0,1,0,0),(15663,2160,'里阳乡',4,'',0,1,0,0),(15664,2160,'金垟乡',4,'',0,1,0,0),(15665,2160,'金星乡',4,'',0,1,0,0),(15666,2160,'金炉乡',4,'',0,1,0,0),(15667,2160,'黄坦镇',4,'',0,1,0,0),(15668,2160,'黄寮乡',4,'',0,1,0,0),(15669,2160,'龙川乡',4,'',0,1,0,0),(15670,2161,'上塘镇',4,'',0,1,0,0),(15671,2161,'下寮乡',4,'',0,1,0,0),(15672,2161,'东皋乡',4,'',0,1,0,0),(15673,2161,'乌牛镇',4,'',0,1,0,0),(15674,2161,'五（氵束鸟）乡',4,'',0,1,0,0),(15675,2161,'大岙乡',4,'',0,1,0,0),(15676,2161,'大箬岩镇',4,'',0,1,0,0),(15677,2161,'山坑乡',4,'',0,1,0,0),(15678,2161,'岩坦镇',4,'',0,1,0,0),(15679,2161,'岩头镇',4,'',0,1,0,0),(15680,2161,'岭头乡',4,'',0,1,0,0),(15681,2161,'巽宅镇',4,'',0,1,0,0),(15682,2161,'应坑乡',4,'',0,1,0,0),(15683,2161,'张溪乡',4,'',0,1,0,0),(15684,2161,'徐岙乡',4,'',0,1,0,0),(15685,2161,'昆阳乡',4,'',0,1,0,0),(15686,2161,'枫林镇',4,'',0,1,0,0),(15687,2161,'桥下镇',4,'',0,1,0,0),(15688,2161,'桥头镇',4,'',0,1,0,0),(15689,2161,'沙头镇',4,'',0,1,0,0),(15690,2161,'渠口乡',4,'',0,1,0,0),(15691,2161,'溪下乡',4,'',0,1,0,0),(15692,2161,'溪口乡',4,'',0,1,0,0),(15693,2161,'潘坑乡',4,'',0,1,0,0),(15694,2161,'瓯北镇',4,'',0,1,0,0),(15695,2161,'界坑乡',4,'',0,1,0,0),(15696,2161,'石染乡',4,'',0,1,0,0),(15697,2161,'碧莲镇',4,'',0,1,0,0),(15698,2161,'花坦乡',4,'',0,1,0,0),(15699,2161,'茗岙乡',4,'',0,1,0,0),(15700,2161,'表山乡',4,'',0,1,0,0),(15701,2161,'西岙乡',4,'',0,1,0,0),(15702,2161,'西源乡',4,'',0,1,0,0),(15703,2161,'西溪乡',4,'',0,1,0,0),(15704,2161,'陡门乡',4,'',0,1,0,0),(15705,2161,'鲤溪乡',4,'',0,1,0,0),(15706,2161,'鹤盛乡',4,'',0,1,0,0),(15707,2161,'黄南乡',4,'',0,1,0,0),(15708,2162,'万排乡',4,'',0,1,0,0),(15709,2162,'三魁镇',4,'',0,1,0,0),(15710,2162,'下洪乡',4,'',0,1,0,0),(15711,2162,'东溪乡',4,'',0,1,0,0),(15712,2162,'九峰乡',4,'',0,1,0,0),(15713,2162,'仕阳镇',4,'',0,1,0,0),(15714,2162,'仙稔乡',4,'',0,1,0,0),(15715,2162,'凤垟乡',4,'',0,1,0,0),(15716,2162,'包垟乡',4,'',0,1,0,0),(15717,2162,'南院乡',4,'',0,1,0,0),(15718,2162,'司前畲族镇',4,'',0,1,0,0),(15719,2162,'垟溪乡',4,'',0,1,0,0),(15720,2162,'大安乡',4,'',0,1,0,0),(15721,2162,'岭北乡',4,'',0,1,0,0),(15722,2162,'峰文乡',4,'',0,1,0,0),(15723,2162,'峰门乡',4,'',0,1,0,0),(15724,2162,'彭溪镇',4,'',0,1,0,0),(15725,2162,'新浦乡',4,'',0,1,0,0),(15726,2162,'月湖乡',4,'',0,1,0,0),(15727,2162,'松垟乡',4,'',0,1,0,0),(15728,2162,'柳峰乡',4,'',0,1,0,0),(15729,2162,'横坑乡',4,'',0,1,0,0),(15730,2162,'泗溪镇',4,'',0,1,0,0),(15731,2162,'洲岭乡',4,'',0,1,0,0),(15732,2162,'百丈镇',4,'',0,1,0,0),(15733,2162,'碑排乡',4,'',0,1,0,0),(15734,2162,'竹里畲族乡',4,'',0,1,0,0),(15735,2162,'筱村镇',4,'',0,1,0,0),(15736,2162,'罗阳镇',4,'',0,1,0,0),(15737,2162,'翁山乡',4,'',0,1,0,0),(15738,2162,'联云乡',4,'',0,1,0,0),(15739,2162,'西旸镇',4,'',0,1,0,0),(15740,2162,'雅阳镇',4,'',0,1,0,0),(15741,2162,'雪溪乡',4,'',0,1,0,0),(15742,2162,'黄桥乡',4,'',0,1,0,0),(15743,2162,'龟湖镇',4,'',0,1,0,0),(15744,2163,'东屏镇',4,'',0,1,0,0),(15745,2163,'元觉乡',4,'',0,1,0,0),(15746,2163,'北岙镇',4,'',0,1,0,0),(15747,2163,'大门镇',4,'',0,1,0,0),(15748,2163,'霓屿乡',4,'',0,1,0,0),(15749,2163,'鹿西乡',4,'',0,1,0,0),(15750,2164,'上望街道',4,'',0,1,0,0),(15751,2164,'东山街道',4,'',0,1,0,0),(15752,2164,'东岩乡',4,'',0,1,0,0),(15753,2164,'仙降镇',4,'',0,1,0,0),(15754,2164,'北麂乡',4,'',0,1,0,0),(15755,2164,'北龙乡',4,'',0,1,0,0),(15756,2164,'塘下镇',4,'',0,1,0,0),(15757,2164,'大南乡',4,'',0,1,0,0),(15758,2164,'宁益乡',4,'',0,1,0,0),(15759,2164,'安阳街道',4,'',0,1,0,0),(15760,2164,'平阳坑镇',4,'',0,1,0,0),(15761,2164,'曹村镇',4,'',0,1,0,0),(15762,2164,'林溪乡',4,'',0,1,0,0),(15763,2164,'枫岭乡',4,'',0,1,0,0),(15764,2164,'桂峰乡',4,'',0,1,0,0),(15765,2164,'桐浦乡',4,'',0,1,0,0),(15766,2164,'梅屿乡',4,'',0,1,0,0),(15767,2164,'永安乡',4,'',0,1,0,0),(15768,2164,'汀田镇',4,'',0,1,0,0),(15769,2164,'湖岭镇',4,'',0,1,0,0),(15770,2164,'潘岱街道',4,'',0,1,0,0),(15771,2164,'潮基乡',4,'',0,1,0,0),(15772,2164,'玉海街道',4,'',0,1,0,0),(15773,2164,'碧山镇',4,'',0,1,0,0),(15774,2164,'芳庄乡',4,'',0,1,0,0),(15775,2164,'荆谷乡',4,'',0,1,0,0),(15776,2164,'莘塍镇',4,'',0,1,0,0),(15777,2164,'营前乡',4,'',0,1,0,0),(15778,2164,'金川乡',4,'',0,1,0,0),(15779,2164,'锦湖街道',4,'',0,1,0,0),(15780,2164,'陶山镇',4,'',0,1,0,0),(15781,2164,'顺泰乡',4,'',0,1,0,0),(15782,2164,'飞云镇',4,'',0,1,0,0),(15783,2164,'马屿镇',4,'',0,1,0,0),(15784,2164,'高楼乡',4,'',0,1,0,0),(15785,2164,'鹿木乡',4,'',0,1,0,0),(15786,2164,'龙湖镇',4,'',0,1,0,0),(15787,2165,'三垟街道',4,'',0,1,0,0),(15788,2165,'丽岙镇',4,'',0,1,0,0),(15789,2165,'仙岩镇',4,'',0,1,0,0),(15790,2165,'南白象街道',4,'',0,1,0,0),(15791,2165,'娄桥街道',4,'',0,1,0,0),(15792,2165,'新桥街道',4,'',0,1,0,0),(15793,2165,'景山街道',4,'',0,1,0,0),(15794,2165,'梧田街道',4,'',0,1,0,0),(15795,2165,'泽雅镇',4,'',0,1,0,0),(15796,2165,'潘桥镇',4,'',0,1,0,0),(15797,2165,'瞿溪镇',4,'',0,1,0,0),(15798,2165,'茶山街道',4,'',0,1,0,0),(15799,2165,'郭溪镇',4,'',0,1,0,0),(15800,2166,'中墩乡',4,'',0,1,0,0),(15801,2166,'云岩乡',4,'',0,1,0,0),(15802,2166,'五凤乡',4,'',0,1,0,0),(15803,2166,'仙居乡',4,'',0,1,0,0),(15804,2166,'凤池乡',4,'',0,1,0,0),(15805,2166,'凤阳畲族乡',4,'',0,1,0,0),(15806,2166,'南宋镇',4,'',0,1,0,0),(15807,2166,'大渔镇',4,'',0,1,0,0),(15808,2166,'宜山镇',4,'',0,1,0,0),(15809,2166,'岱岭畲族乡',4,'',0,1,0,0),(15810,2166,'括山乡',4,'',0,1,0,0),(15811,2166,'新安乡',4,'',0,1,0,0),(15812,2166,'昌禅乡',4,'',0,1,0,0),(15813,2166,'望里镇',4,'',0,1,0,0),(15814,2166,'桥墩镇',4,'',0,1,0,0),(15815,2166,'沿浦镇',4,'',0,1,0,0),(15816,2166,'浦亭乡',4,'',0,1,0,0),(15817,2166,'渔寮乡',4,'',0,1,0,0),(15818,2166,'灵溪镇',4,'',0,1,0,0),(15819,2166,'炎亭镇',4,'',0,1,0,0),(15820,2166,'石坪乡',4,'',0,1,0,0),(15821,2166,'矾山镇',4,'',0,1,0,0),(15822,2166,'腾垟乡',4,'',0,1,0,0),(15823,2166,'舥艚镇',4,'',0,1,0,0),(15824,2166,'芦浦镇',4,'',0,1,0,0),(15825,2166,'莒溪镇',4,'',0,1,0,0),(15826,2166,'蒲城乡',4,'',0,1,0,0),(15827,2166,'藻溪镇',4,'',0,1,0,0),(15828,2166,'观美镇',4,'',0,1,0,0),(15829,2166,'赤溪镇',4,'',0,1,0,0),(15830,2166,'金乡镇',4,'',0,1,0,0),(15831,2166,'钱库镇',4,'',0,1,0,0),(15832,2166,'霞关镇',4,'',0,1,0,0),(15833,2166,'马站镇',4,'',0,1,0,0),(15834,2166,'龙沙乡',4,'',0,1,0,0),(15835,2166,'龙港镇',4,'',0,1,0,0),(15836,2167,'七都镇',4,'',0,1,0,0),(15837,2167,'上戍乡',4,'',0,1,0,0),(15838,2167,'临江镇',4,'',0,1,0,0),(15839,2167,'五马街道',4,'',0,1,0,0),(15840,2167,'仰义乡',4,'',0,1,0,0),(15841,2167,'南浦街道',4,'',0,1,0,0),(15842,2167,'南郊乡',4,'',0,1,0,0),(15843,2167,'南门街道',4,'',0,1,0,0),(15844,2167,'双屿镇',4,'',0,1,0,0),(15845,2167,'双潮乡',4,'',0,1,0,0),(15846,2167,'岙底乡',4,'',0,1,0,0),(15847,2167,'广化街道',4,'',0,1,0,0),(15848,2167,'水心街道',4,'',0,1,0,0),(15849,2167,'江滨街道',4,'',0,1,0,0),(15850,2167,'洪殿街道',4,'',0,1,0,0),(15851,2167,'绣山街道',4,'',0,1,0,0),(15852,2167,'莲池街道',4,'',0,1,0,0),(15853,2167,'蒲鞋市街道',4,'',0,1,0,0),(15854,2167,'藤桥镇',4,'',0,1,0,0),(15855,2167,'黄龙街道',4,'',0,1,0,0),(15856,2167,'黎明街道',4,'',0,1,0,0),(15857,2168,'天河镇',4,'',0,1,0,0),(15858,2168,'永中街道',4,'',0,1,0,0),(15859,2168,'永兴街道',4,'',0,1,0,0),(15860,2168,'沙城镇',4,'',0,1,0,0),(15861,2168,'海城街道',4,'',0,1,0,0),(15862,2168,'海滨街道',4,'',0,1,0,0),(15863,2168,'灵昆镇',4,'',0,1,0,0),(15864,2168,'状元镇',4,'',0,1,0,0),(15865,2168,'瑶溪镇',4,'',0,1,0,0),(15866,2168,'蒲州街道',4,'',0,1,0,0),(15867,2169,'七星镇',4,'',0,1,0,0),(15868,2169,'东栅街道',4,'',0,1,0,0),(15869,2169,'余新镇',4,'',0,1,0,0),(15870,2169,'凤桥镇',4,'',0,1,0,0),(15871,2169,'南湖街道',4,'',0,1,0,0),(15872,2169,'城南街道',4,'',0,1,0,0),(15873,2169,'大桥镇',4,'',0,1,0,0),(15874,2169,'建设街道',4,'',0,1,0,0),(15875,2169,'新丰镇',4,'',0,1,0,0),(15876,2169,'新兴街道',4,'',0,1,0,0),(15877,2169,'新嘉街道',4,'',0,1,0,0),(15878,2169,'解放街道',4,'',0,1,0,0),(15879,2170,'丁栅镇',4,'',0,1,0,0),(15880,2170,'大云镇',4,'',0,1,0,0),(15881,2170,'天凝镇',4,'',0,1,0,0),(15882,2170,'姚庄镇',4,'',0,1,0,0),(15883,2170,'干窑镇',4,'',0,1,0,0),(15884,2170,'惠民镇',4,'',0,1,0,0),(15885,2170,'杨庙镇',4,'',0,1,0,0),(15886,2170,'洪溪镇',4,'',0,1,0,0),(15887,2170,'西塘镇',4,'',0,1,0,0),(15888,2170,'陶庄镇',4,'',0,1,0,0),(15889,2170,'魏塘镇',4,'',0,1,0,0),(15890,2171,'乍浦镇',4,'',0,1,0,0),(15891,2171,'全塘镇',4,'',0,1,0,0),(15892,2171,'广陈镇',4,'',0,1,0,0),(15893,2171,'当湖街道',4,'',0,1,0,0),(15894,2171,'新仓镇',4,'',0,1,0,0),(15895,2171,'新埭镇',4,'',0,1,0,0),(15896,2171,'曹桥街道',4,'',0,1,0,0),(15897,2171,'林埭镇',4,'',0,1,0,0),(15898,2171,'钟埭街道',4,'',0,1,0,0),(15899,2171,'黄姑镇',4,'',0,1,0,0),(15900,2172,'乌镇镇',4,'',0,1,0,0),(15901,2172,'凤鸣街道',4,'',0,1,0,0),(15902,2172,'同福乡',4,'',0,1,0,0),(15903,2172,'大麻镇',4,'',0,1,0,0),(15904,2172,'屠甸镇',4,'',0,1,0,0),(15905,2172,'崇福镇',4,'',0,1,0,0),(15906,2172,'梧桐街道',4,'',0,1,0,0),(15907,2172,'河山镇',4,'',0,1,0,0),(15908,2172,'洲泉镇',4,'',0,1,0,0),(15909,2172,'濮院镇',4,'',0,1,0,0),(15910,2172,'石门镇',4,'',0,1,0,0),(15911,2172,'高桥镇',4,'',0,1,0,0),(15912,2172,'龙翔街道',4,'',0,1,0,0),(15913,2173,'丁桥镇',4,'',0,1,0,0),(15914,2173,'周王庙镇',4,'',0,1,0,0),(15915,2173,'斜桥镇',4,'',0,1,0,0),(15916,2173,'海昌街道',4,'',0,1,0,0),(15917,2173,'海洲街道',4,'',0,1,0,0),(15918,2173,'盐官镇',4,'',0,1,0,0),(15919,2173,'硖石街道',4,'',0,1,0,0),(15920,2173,'袁花镇',4,'',0,1,0,0),(15921,2173,'许村镇',4,'',0,1,0,0),(15922,2173,'长安镇',4,'',0,1,0,0),(15923,2173,'马桥街道',4,'',0,1,0,0),(15924,2173,'黄湾镇',4,'',0,1,0,0),(15925,2174,'于城镇',4,'',0,1,0,0),(15926,2174,'武原镇',4,'',0,1,0,0),(15927,2174,'沈荡镇',4,'',0,1,0,0),(15928,2174,'澉浦镇',4,'',0,1,0,0),(15929,2174,'百步镇',4,'',0,1,0,0),(15930,2174,'秦山镇',4,'',0,1,0,0),(15931,2174,'西塘桥镇',4,'',0,1,0,0),(15932,2174,'通元镇',4,'',0,1,0,0),(15933,2175,'嘉北街道',4,'',0,1,0,0),(15934,2175,'塘汇街道',4,'',0,1,0,0),(15935,2175,'新城街道',4,'',0,1,0,0),(15936,2175,'新塍镇',4,'',0,1,0,0),(15937,2175,'油车港镇',4,'',0,1,0,0),(15938,2175,'洪合镇',4,'',0,1,0,0),(15939,2175,'王店镇',4,'',0,1,0,0),(15940,2175,'王江泾镇',4,'',0,1,0,0),(15941,2176,'千金镇',4,'',0,1,0,0),(15942,2176,'南浔镇',4,'',0,1,0,0),(15943,2176,'双林镇',4,'',0,1,0,0),(15944,2176,'和孚镇',4,'',0,1,0,0),(15945,2176,'善琏镇',4,'',0,1,0,0),(15946,2176,'旧馆镇',4,'',0,1,0,0),(15947,2176,'石淙镇',4,'',0,1,0,0),(15948,2176,'练市镇',4,'',0,1,0,0),(15949,2176,'菱湖镇',4,'',0,1,0,0),(15950,2177,'东林镇',4,'',0,1,0,0),(15951,2177,'八里店镇',4,'',0,1,0,0),(15952,2177,'凤凰街道',4,'',0,1,0,0),(15953,2177,'埭溪镇',4,'',0,1,0,0),(15954,2177,'妙西镇',4,'',0,1,0,0),(15955,2177,'康山街道',4,'',0,1,0,0),(15956,2177,'月河街道',4,'',0,1,0,0),(15957,2177,'朝阳街道',4,'',0,1,0,0),(15958,2177,'杨家埠镇',4,'',0,1,0,0),(15959,2177,'爱山街道',4,'',0,1,0,0),(15960,2177,'环渚乡',4,'',0,1,0,0),(15961,2177,'白雀乡',4,'',0,1,0,0),(15962,2177,'织里镇',4,'',0,1,0,0),(15963,2177,'道场乡',4,'',0,1,0,0),(15964,2177,'飞英街道',4,'',0,1,0,0),(15965,2177,'龙泉街道',4,'',0,1,0,0),(15966,2178,'上墅乡',4,'',0,1,0,0),(15967,2178,'天荒坪镇',4,'',0,1,0,0),(15968,2178,'孝丰镇',4,'',0,1,0,0),(15969,2178,'山川乡',4,'',0,1,0,0),(15970,2178,'报福镇',4,'',0,1,0,0),(15971,2178,'昆铜乡',4,'',0,1,0,0),(15972,2178,'杭垓镇',4,'',0,1,0,0),(15973,2178,'梅溪镇',4,'',0,1,0,0),(15974,2178,'溪龙乡',4,'',0,1,0,0),(15975,2178,'皈山乡',4,'',0,1,0,0),(15976,2178,'章村镇',4,'',0,1,0,0),(15977,2178,'良朋镇',4,'',0,1,0,0),(15978,2178,'递铺镇',4,'',0,1,0,0),(15979,2178,'鄣吴镇',4,'',0,1,0,0),(15980,2178,'高禹镇',4,'',0,1,0,0),(15981,2179,'三合乡',4,'',0,1,0,0),(15982,2179,'干元镇',4,'',0,1,0,0),(15983,2179,'新安镇',4,'',0,1,0,0),(15984,2179,'新市镇',4,'',0,1,0,0),(15985,2179,'武康镇',4,'',0,1,0,0),(15986,2179,'洛舍镇',4,'',0,1,0,0),(15987,2179,'禹越镇',4,'',0,1,0,0),(15988,2179,'筏头乡',4,'',0,1,0,0),(15989,2179,'莫干山镇',4,'',0,1,0,0),(15990,2179,'钟管镇',4,'',0,1,0,0),(15991,2179,'雷甸镇',4,'',0,1,0,0),(15992,2180,'二界岭乡',4,'',0,1,0,0),(15993,2180,'吕山乡',4,'',0,1,0,0),(15994,2180,'吴山乡',4,'',0,1,0,0),(15995,2180,'和平镇',4,'',0,1,0,0),(15996,2180,'夹浦镇',4,'',0,1,0,0),(15997,2180,'小浦镇',4,'',0,1,0,0),(15998,2180,'李家巷镇',4,'',0,1,0,0),(15999,2180,'林城镇',4,'',0,1,0,0),(16000,2180,'槐坎乡',4,'',0,1,0,0),(16001,2180,'水口乡',4,'',0,1,0,0),(16002,2180,'泗安镇',4,'',0,1,0,0),(16003,2180,'洪桥镇',4,'',0,1,0,0),(16004,2180,'煤山镇',4,'',0,1,0,0),(16005,2180,'白岘乡',4,'',0,1,0,0),(16006,2180,'虹星桥镇',4,'',0,1,0,0),(16007,2180,'雉城镇',4,'',0,1,0,0),(16008,2181,'丁宅乡',4,'',0,1,0,0),(16009,2181,'上浦镇',4,'',0,1,0,0),(16010,2181,'下管镇',4,'',0,1,0,0),(16011,2181,'东关街道',4,'',0,1,0,0),(16012,2181,'丰惠镇',4,'',0,1,0,0),(16013,2181,'小越镇',4,'',0,1,0,0),(16014,2181,'岭南乡',4,'',0,1,0,0),(16015,2181,'崧厦镇',4,'',0,1,0,0),(16016,2181,'曹娥街道',4,'',0,1,0,0),(16017,2181,'梁湖镇',4,'',0,1,0,0),(16018,2181,'永和镇',4,'',0,1,0,0),(16019,2181,'汤浦镇',4,'',0,1,0,0),(16020,2181,'沥海镇',4,'',0,1,0,0),(16021,2181,'百官街道',4,'',0,1,0,0),(16022,2181,'盖北镇',4,'',0,1,0,0),(16023,2181,'章镇镇',4,'',0,1,0,0),(16024,2181,'谢塘镇',4,'',0,1,0,0),(16025,2181,'道墟镇',4,'',0,1,0,0),(16026,2181,'长塘镇',4,'',0,1,0,0),(16027,2181,'陈溪乡',4,'',0,1,0,0),(16028,2181,'驿亭镇',4,'',0,1,0,0),(16029,2182,'三江街道',4,'',0,1,0,0),(16030,2182,'三界镇',4,'',0,1,0,0),(16031,2182,'下王镇',4,'',0,1,0,0),(16032,2182,'仙岩镇',4,'',0,1,0,0),(16033,2182,'剡湖街道',4,'',0,1,0,0),(16034,2182,'北漳镇',4,'',0,1,0,0),(16035,2182,'崇仁镇',4,'',0,1,0,0),(16036,2182,'浦口街道',4,'',0,1,0,0),(16037,2182,'王院镇',4,'',0,1,0,0),(16038,2182,'甘霖镇',4,'',0,1,0,0),(16039,2182,'石璜镇',4,'',0,1,0,0),(16040,2182,'竹溪镇',4,'',0,1,0,0),(16041,2182,'谷来镇',4,'',0,1,0,0),(16042,2182,'贵门镇',4,'',0,1,0,0),(16043,2182,'通源镇',4,'',0,1,0,0),(16044,2182,'里南镇',4,'',0,1,0,0),(16045,2182,'金庭镇',4,'',0,1,0,0),(16046,2182,'长乐镇',4,'',0,1,0,0),(16047,2182,'雅璜镇',4,'',0,1,0,0),(16048,2182,'鹿山街道',4,'',0,1,0,0),(16049,2182,'黄泽镇',4,'',0,1,0,0),(16050,2183,'七星街道',4,'',0,1,0,0),(16051,2183,'东茗乡',4,'',0,1,0,0),(16052,2183,'儒岙镇',4,'',0,1,0,0),(16053,2183,'南明街道',4,'',0,1,0,0),(16054,2183,'双彩乡',4,'',0,1,0,0),(16055,2183,'回山镇',4,'',0,1,0,0),(16056,2183,'城南乡',4,'',0,1,0,0),(16057,2183,'大市聚镇',4,'',0,1,0,0),(16058,2183,'小将镇',4,'',0,1,0,0),(16059,2183,'巧英乡',4,'',0,1,0,0),(16060,2183,'新林乡',4,'',0,1,0,0),(16061,2183,'梅渚镇',4,'',0,1,0,0),(16062,2183,'沙溪镇',4,'',0,1,0,0),(16063,2183,'澄潭镇',4,'',0,1,0,0),(16064,2183,'羽林街道',4,'',0,1,0,0),(16065,2183,'镜岭镇',4,'',0,1,0,0),(16066,2184,'兰亭镇',4,'',0,1,0,0),(16067,2184,'华舍街道',4,'',0,1,0,0),(16068,2184,'夏履镇',4,'',0,1,0,0),(16069,2184,'孙端镇',4,'',0,1,0,0),(16070,2184,'安昌镇',4,'',0,1,0,0),(16071,2184,'富盛镇',4,'',0,1,0,0),(16072,2184,'平水镇',4,'',0,1,0,0),(16073,2184,'杨汛桥镇',4,'',0,1,0,0),(16074,2184,'柯岩街道',4,'',0,1,0,0),(16075,2184,'柯桥街道',4,'',0,1,0,0),(16076,2184,'湖塘街道',4,'',0,1,0,0),(16077,2184,'漓渚镇',4,'',0,1,0,0),(16078,2184,'王坛镇',4,'',0,1,0,0),(16079,2184,'福全镇',4,'',0,1,0,0),(16080,2184,'稽东镇',4,'',0,1,0,0),(16081,2184,'钱清镇',4,'',0,1,0,0),(16082,2184,'陶堰镇',4,'',0,1,0,0),(16083,2184,'马鞍镇',4,'',0,1,0,0),(16084,2184,'齐贤镇',4,'',0,1,0,0),(16085,2185,'东和乡',4,'',0,1,0,0),(16086,2185,'东白湖镇',4,'',0,1,0,0),(16087,2185,'五泄镇',4,'',0,1,0,0),(16088,2185,'同山镇',4,'',0,1,0,0),(16089,2185,'大唐镇',4,'',0,1,0,0),(16090,2185,'安华镇',4,'',0,1,0,0),(16091,2185,'山下湖镇',4,'',0,1,0,0),(16092,2185,'岭北镇',4,'',0,1,0,0),(16093,2185,'应店街镇',4,'',0,1,0,0),(16094,2185,'店口镇',4,'',0,1,0,0),(16095,2185,'暨阳街道',4,'',0,1,0,0),(16096,2185,'枫桥镇',4,'',0,1,0,0),(16097,2185,'次坞镇',4,'',0,1,0,0),(16098,2185,'江藻镇',4,'',0,1,0,0),(16099,2185,'浣东街道',4,'',0,1,0,0),(16100,2185,'浬浦镇',4,'',0,1,0,0),(16101,2185,'牌头镇',4,'',0,1,0,0),(16102,2185,'王家井镇',4,'',0,1,0,0),(16103,2185,'璜山镇',4,'',0,1,0,0),(16104,2185,'直埠镇',4,'',0,1,0,0),(16105,2185,'草塔镇',4,'',0,1,0,0),(16106,2185,'街亭镇',4,'',0,1,0,0),(16107,2185,'赵家镇',4,'',0,1,0,0),(16108,2185,'阮市镇',4,'',0,1,0,0),(16109,2185,'陈宅镇',4,'',0,1,0,0),(16110,2185,'陶朱街道',4,'',0,1,0,0),(16111,2185,'马剑镇',4,'',0,1,0,0),(16112,2186,'东浦镇',4,'',0,1,0,0),(16113,2186,'东湖镇',4,'',0,1,0,0),(16114,2186,'北海街道',4,'',0,1,0,0),(16115,2186,'城南街道',4,'',0,1,0,0),(16116,2186,'塔山街道',4,'',0,1,0,0),(16117,2186,'府山街道',4,'',0,1,0,0),(16118,2186,'斗门镇',4,'',0,1,0,0),(16119,2186,'灵芝镇',4,'',0,1,0,0),(16120,2186,'皋埠镇',4,'',0,1,0,0),(16121,2186,'稽山街道',4,'',0,1,0,0),(16122,2186,'蕺山街道',4,'',0,1,0,0),(16123,2186,'鉴湖镇',4,'',0,1,0,0),(16124,2186,'马山镇',4,'',0,1,0,0),(16125,2187,'临城街道',4,'',0,1,0,0),(16126,2187,'册子乡',4,'',0,1,0,0),(16127,2187,'北蝉乡',4,'',0,1,0,0),(16128,2187,'双桥镇',4,'',0,1,0,0),(16129,2187,'城东街道',4,'',0,1,0,0),(16130,2187,'小沙镇',4,'',0,1,0,0),(16131,2187,'岑港镇',4,'',0,1,0,0),(16132,2187,'干缆镇',4,'',0,1,0,0),(16133,2187,'昌国街道',4,'',0,1,0,0),(16134,2187,'环南街道',4,'',0,1,0,0),(16135,2187,'白泉镇',4,'',0,1,0,0),(16136,2187,'盐仓街道',4,'',0,1,0,0),(16137,2187,'解放街道',4,'',0,1,0,0),(16138,2187,'金塘镇',4,'',0,1,0,0),(16139,2187,'长白乡',4,'',0,1,0,0),(16140,2187,'马岙镇',4,'',0,1,0,0),(16141,2188,'东沙镇',4,'',0,1,0,0),(16142,2188,'岱东镇',4,'',0,1,0,0),(16143,2188,'岱西镇',4,'',0,1,0,0),(16144,2188,'秀山乡',4,'',0,1,0,0),(16145,2188,'衢山镇',4,'',0,1,0,0),(16146,2188,'长涂镇',4,'',0,1,0,0),(16147,2188,'高亭镇',4,'',0,1,0,0),(16148,2189,'五龙乡',4,'',0,1,0,0),(16149,2189,'嵊山镇',4,'',0,1,0,0),(16150,2189,'枸杞乡',4,'',0,1,0,0),(16151,2189,'洋山镇',4,'',0,1,0,0),(16152,2189,'花鸟乡',4,'',0,1,0,0),(16153,2189,'菜园镇',4,'',0,1,0,0),(16154,2189,'黄龙乡',4,'',0,1,0,0),(16155,2190,'东极镇',4,'',0,1,0,0),(16156,2190,'东港街道',4,'',0,1,0,0),(16157,2190,'佛渡乡',4,'',0,1,0,0),(16158,2190,'六横镇',4,'',0,1,0,0),(16159,2190,'勾山街道',4,'',0,1,0,0),(16160,2190,'展茅镇',4,'',0,1,0,0),(16161,2190,'普陀山镇',4,'',0,1,0,0),(16162,2190,'朱家尖镇',4,'',0,1,0,0),(16163,2190,'桃花镇',4,'',0,1,0,0),(16164,2190,'沈家门街道',4,'',0,1,0,0),(16165,2190,'登步乡',4,'',0,1,0,0),(16166,2190,'白沙乡',4,'',0,1,0,0),(16167,2190,'虾峙镇',4,'',0,1,0,0),(16168,2190,'蚂蚁岛乡',4,'',0,1,0,0),(16169,2191,'东案乡',4,'',0,1,0,0),(16170,2191,'何家乡',4,'',0,1,0,0),(16171,2191,'同弓乡',4,'',0,1,0,0),(16172,2191,'大桥头乡',4,'',0,1,0,0),(16173,2191,'天马镇',4,'',0,1,0,0),(16174,2191,'宋畈乡',4,'',0,1,0,0),(16175,2191,'招贤镇',4,'',0,1,0,0),(16176,2191,'新昌乡',4,'',0,1,0,0),(16177,2191,'新桥乡',4,'',0,1,0,0),(16178,2191,'球川镇',4,'',0,1,0,0),(16179,2191,'白石镇',4,'',0,1,0,0),(16180,2191,'芳村镇',4,'',0,1,0,0),(16181,2191,'辉埠镇',4,'',0,1,0,0),(16182,2191,'青石镇',4,'',0,1,0,0),(16183,2192,'中村乡',4,'',0,1,0,0),(16184,2192,'何田乡',4,'',0,1,0,0),(16185,2192,'华埠镇',4,'',0,1,0,0),(16186,2192,'城关镇',4,'',0,1,0,0),(16187,2192,'塘坞乡',4,'',0,1,0,0),(16188,2192,'大溪边乡',4,'',0,1,0,0),(16189,2192,'张湾乡',4,'',0,1,0,0),(16190,2192,'村头镇',4,'',0,1,0,0),(16191,2192,'杨林镇',4,'',0,1,0,0),(16192,2192,'林山乡',4,'',0,1,0,0),(16193,2192,'桐村镇',4,'',0,1,0,0),(16194,2192,'池淮镇',4,'',0,1,0,0),(16195,2192,'苏庄镇',4,'',0,1,0,0),(16196,2192,'金村乡',4,'',0,1,0,0),(16197,2192,'长虹乡',4,'',0,1,0,0),(16198,2192,'音坑乡',4,'',0,1,0,0),(16199,2192,'马金镇',4,'',0,1,0,0),(16200,2192,'齐溪镇',4,'',0,1,0,0),(16201,2193,'七里乡',4,'',0,1,0,0),(16202,2193,'万田乡',4,'',0,1,0,0),(16203,2193,'九华乡',4,'',0,1,0,0),(16204,2193,'信安街道',4,'',0,1,0,0),(16205,2193,'华墅乡',4,'',0,1,0,0),(16206,2193,'双港街道',4,'',0,1,0,0),(16207,2193,'姜家山乡',4,'',0,1,0,0),(16208,2193,'府山街道',4,'',0,1,0,0),(16209,2193,'新新街道',4,'',0,1,0,0),(16210,2193,'沟溪乡',4,'',0,1,0,0),(16211,2193,'白云街道',4,'',0,1,0,0),(16212,2193,'石室乡',4,'',0,1,0,0),(16213,2193,'石梁镇',4,'',0,1,0,0),(16214,2193,'航埠镇',4,'',0,1,0,0),(16215,2193,'花园街道',4,'',0,1,0,0),(16216,2193,'荷花街道',4,'',0,1,0,0),(16217,2193,'黄家乡',4,'',0,1,0,0),(16218,2194,'上余镇',4,'',0,1,0,0),(16219,2194,'保安乡',4,'',0,1,0,0),(16220,2194,'凤林镇',4,'',0,1,0,0),(16221,2194,'双塔街道',4,'',0,1,0,0),(16222,2194,'双溪口乡',4,'',0,1,0,0),(16223,2194,'四都镇',4,'',0,1,0,0),(16224,2194,'坛石镇',4,'',0,1,0,0),(16225,2194,'塘源口乡',4,'',0,1,0,0),(16226,2194,'大桥镇',4,'',0,1,0,0),(16227,2194,'大陈乡',4,'',0,1,0,0),(16228,2194,'峡口镇',4,'',0,1,0,0),(16229,2194,'廿八都镇',4,'',0,1,0,0),(16230,2194,'张村乡',4,'',0,1,0,0),(16231,2194,'新塘边镇',4,'',0,1,0,0),(16232,2194,'淤头镇',4,'',0,1,0,0),(16233,2194,'清湖镇',4,'',0,1,0,0),(16234,2194,'石门镇',4,'',0,1,0,0),(16235,2194,'碗窑乡',4,'',0,1,0,0),(16236,2194,'虎山街道',4,'',0,1,0,0),(16237,2194,'贺村镇',4,'',0,1,0,0),(16238,2194,'长台镇',4,'',0,1,0,0),(16239,2195,'上方镇',4,'',0,1,0,0),(16240,2195,'举村乡',4,'',0,1,0,0),(16241,2195,'云溪乡',4,'',0,1,0,0),(16242,2195,'全旺镇',4,'',0,1,0,0),(16243,2195,'双桥乡',4,'',0,1,0,0),(16244,2195,'后溪镇',4,'',0,1,0,0),(16245,2195,'周家乡',4,'',0,1,0,0),(16246,2195,'大洲镇',4,'',0,1,0,0),(16247,2195,'太真乡',4,'',0,1,0,0),(16248,2195,'岭洋乡',4,'',0,1,0,0),(16249,2195,'峡川镇',4,'',0,1,0,0),(16250,2195,'廿里镇',4,'',0,1,0,0),(16251,2195,'杜泽镇',4,'',0,1,0,0),(16252,2195,'樟潭街道',4,'',0,1,0,0),(16253,2195,'横路乡',4,'',0,1,0,0),(16254,2195,'浮石街道',4,'',0,1,0,0),(16255,2195,'湖南镇',4,'',0,1,0,0),(16256,2195,'灰坪乡',4,'',0,1,0,0),(16257,2195,'莲花镇',4,'',0,1,0,0),(16258,2195,'高家镇',4,'',0,1,0,0),(16259,2195,'黄坛口乡',4,'',0,1,0,0),(16260,2196,'东华街道',4,'',0,1,0,0),(16261,2196,'塔石镇',4,'',0,1,0,0),(16262,2196,'大街乡',4,'',0,1,0,0),(16263,2196,'小南海镇',4,'',0,1,0,0),(16264,2196,'庙下乡',4,'',0,1,0,0),(16265,2196,'模环乡',4,'',0,1,0,0),(16266,2196,'横山镇',4,'',0,1,0,0),(16267,2196,'沐尘畲族乡',4,'',0,1,0,0),(16268,2196,'湖镇镇',4,'',0,1,0,0),(16269,2196,'溪口镇',4,'',0,1,0,0),(16270,2196,'石佛乡',4,'',0,1,0,0),(16271,2196,'社阳乡',4,'',0,1,0,0),(16272,2196,'罗家乡',4,'',0,1,0,0),(16273,2196,'詹家镇',4,'',0,1,0,0),(16274,2196,'龙洲街道',4,'',0,1,0,0),(16275,2197,'三单乡',4,'',0,1,0,0),(16276,2197,'东阳江镇',4,'',0,1,0,0),(16277,2197,'佐村镇',4,'',0,1,0,0),(16278,2197,'六石街道',4,'',0,1,0,0),(16279,2197,'千祥镇',4,'',0,1,0,0),(16280,2197,'南市街道',4,'',0,1,0,0),(16281,2197,'南马镇',4,'',0,1,0,0),(16282,2197,'吴宁街道',4,'',0,1,0,0),(16283,2197,'城东街道',4,'',0,1,0,0),(16284,2197,'巍山镇',4,'',0,1,0,0),(16285,2197,'横店镇',4,'',0,1,0,0),(16286,2197,'歌山镇',4,'',0,1,0,0),(16287,2197,'江北街道',4,'',0,1,0,0),(16288,2197,'湖溪镇',4,'',0,1,0,0),(16289,2197,'画水镇',4,'',0,1,0,0),(16290,2197,'白云街道',4,'',0,1,0,0),(16291,2197,'虎鹿镇',4,'',0,1,0,0),(16292,2197,'马宅镇',4,'',0,1,0,0),(16293,2198,'上溪镇',4,'',0,1,0,0),(16294,2198,'义亭镇',4,'',0,1,0,0),(16295,2198,'佛堂镇',4,'',0,1,0,0),(16296,2198,'北苑街道',4,'',0,1,0,0),(16297,2198,'后宅街道',4,'',0,1,0,0),(16298,2198,'城西街道',4,'',0,1,0,0),(16299,2198,'大陈镇',4,'',0,1,0,0),(16300,2198,'廿三里街道',4,'',0,1,0,0),(16301,2198,'江东街道',4,'',0,1,0,0),(16302,2198,'稠城街道',4,'',0,1,0,0),(16303,2198,'稠江街道',4,'',0,1,0,0),(16304,2198,'苏溪镇',4,'',0,1,0,0),(16305,2198,'赤岸镇',4,'',0,1,0,0),(16306,2199,'上华街道',4,'',0,1,0,0),(16307,2199,'云山街道',4,'',0,1,0,0),(16308,2199,'兰江街道',4,'',0,1,0,0),(16309,2199,'女埠街道',4,'',0,1,0,0),(16310,2199,'柏社乡',4,'',0,1,0,0),(16311,2199,'梅江镇',4,'',0,1,0,0),(16312,2199,'水亭畲族乡',4,'',0,1,0,0),(16313,2199,'永昌街道',4,'',0,1,0,0),(16314,2199,'游埠镇',4,'',0,1,0,0),(16315,2199,'灵洞乡',4,'',0,1,0,0),(16316,2199,'诸葛镇',4,'',0,1,0,0),(16317,2199,'赤溪街道',4,'',0,1,0,0),(16318,2199,'香溪镇',4,'',0,1,0,0),(16319,2199,'马涧镇',4,'',0,1,0,0),(16320,2199,'黄店镇',4,'',0,1,0,0),(16321,2200,'三江口街道',4,'',0,1,0,0),(16322,2200,'干西乡',4,'',0,1,0,0),(16323,2200,'城东街道',4,'',0,1,0,0),(16324,2200,'城中街道',4,'',0,1,0,0),(16325,2200,'城北街道',4,'',0,1,0,0),(16326,2200,'城西街道',4,'',0,1,0,0),(16327,2200,'塔石乡',4,'',0,1,0,0),(16328,2200,'安地镇',4,'',0,1,0,0),(16329,2200,'岭上乡',4,'',0,1,0,0),(16330,2200,'新狮街道',4,'',0,1,0,0),(16331,2200,'江南街道',4,'',0,1,0,0),(16332,2200,'汤溪镇',4,'',0,1,0,0),(16333,2200,'沙畈乡',4,'',0,1,0,0),(16334,2200,'洋埠镇',4,'',0,1,0,0),(16335,2200,'琅玡镇',4,'',0,1,0,0),(16336,2200,'白龙桥镇',4,'',0,1,0,0),(16337,2200,'秋滨街道',4,'',0,1,0,0),(16338,2200,'竹马乡',4,'',0,1,0,0),(16339,2200,'箬阳乡',4,'',0,1,0,0),(16340,2200,'罗埠镇',4,'',0,1,0,0),(16341,2200,'罗店镇',4,'',0,1,0,0),(16342,2200,'苏孟乡',4,'',0,1,0,0),(16343,2200,'莘畈乡',4,'',0,1,0,0),(16344,2200,'蒋堂镇',4,'',0,1,0,0),(16345,2200,'西关街道',4,'',0,1,0,0),(16346,2200,'长山乡',4,'',0,1,0,0),(16347,2200,'雅畈镇',4,'',0,1,0,0),(16348,2201,'三港乡',4,'',0,1,0,0),(16349,2201,'俞源乡',4,'',0,1,0,0),(16350,2201,'坦洪乡',4,'',0,1,0,0),(16351,2201,'壶山街道',4,'',0,1,0,0),(16352,2201,'大溪口乡',4,'',0,1,0,0),(16353,2201,'大田乡',4,'',0,1,0,0),(16354,2201,'履坦镇',4,'',0,1,0,0),(16355,2201,'新宅镇',4,'',0,1,0,0),(16356,2201,'柳城畲族镇',4,'',0,1,0,0),(16357,2201,'桃溪镇',4,'',0,1,0,0),(16358,2201,'桐琴镇',4,'',0,1,0,0),(16359,2201,'泉溪镇',4,'',0,1,0,0),(16360,2201,'熟溪街道',4,'',0,1,0,0),(16361,2201,'王宅镇',4,'',0,1,0,0),(16362,2201,'白姆乡',4,'',0,1,0,0),(16363,2201,'白洋街道',4,'',0,1,0,0),(16364,2201,'茭道镇',4,'',0,1,0,0),(16365,2201,'西联乡',4,'',0,1,0,0),(16366,2202,'东城街道',4,'',0,1,0,0),(16367,2202,'前仓镇',4,'',0,1,0,0),(16368,2202,'古山镇',4,'',0,1,0,0),(16369,2202,'唐先镇',4,'',0,1,0,0),(16370,2202,'方岩镇',4,'',0,1,0,0),(16371,2202,'江南街道',4,'',0,1,0,0),(16372,2202,'石柱镇',4,'',0,1,0,0),(16373,2202,'舟山镇',4,'',0,1,0,0),(16374,2202,'芝英街道',4,'',0,1,0,0),(16375,2202,'花街镇',4,'',0,1,0,0),(16376,2202,'西城街道',4,'',0,1,0,0),(16377,2202,'西溪镇',4,'',0,1,0,0),(16378,2202,'象珠镇',4,'',0,1,0,0),(16379,2202,'龙山镇',4,'',0,1,0,0),(16380,2203,'中余乡',4,'',0,1,0,0),(16381,2203,'仙华街道',4,'',0,1,0,0),(16382,2203,'前吴乡',4,'',0,1,0,0),(16383,2203,'大畈乡',4,'',0,1,0,0),(16384,2203,'岩头镇',4,'',0,1,0,0),(16385,2203,'杭坪镇',4,'',0,1,0,0),(16386,2203,'檀溪镇',4,'',0,1,0,0),(16387,2203,'浦南街道',4,'',0,1,0,0),(16388,2203,'浦阳街道',4,'',0,1,0,0),(16389,2203,'白马镇',4,'',0,1,0,0),(16390,2203,'花桥乡',4,'',0,1,0,0),(16391,2203,'虞宅乡',4,'',0,1,0,0),(16392,2203,'郑宅镇',4,'',0,1,0,0),(16393,2203,'郑家坞镇',4,'',0,1,0,0),(16394,2203,'黄宅镇',4,'',0,1,0,0),(16395,2204,'万苍乡',4,'',0,1,0,0),(16396,2204,'九和乡',4,'',0,1,0,0),(16397,2204,'仁川镇',4,'',0,1,0,0),(16398,2204,'冷水镇',4,'',0,1,0,0),(16399,2204,'双峰乡',4,'',0,1,0,0),(16400,2204,'双溪乡',4,'',0,1,0,0),(16401,2204,'墨林乡',4,'',0,1,0,0),(16402,2204,'大盘镇',4,'',0,1,0,0),(16403,2204,'安文镇',4,'',0,1,0,0),(16404,2204,'尖山镇',4,'',0,1,0,0),(16405,2204,'尚湖镇',4,'',0,1,0,0),(16406,2204,'新渥镇',4,'',0,1,0,0),(16407,2204,'方前镇',4,'',0,1,0,0),(16408,2204,'深泽乡',4,'',0,1,0,0),(16409,2204,'玉山镇',4,'',0,1,0,0),(16410,2204,'盘峰乡',4,'',0,1,0,0),(16411,2204,'窈川乡',4,'',0,1,0,0),(16412,2204,'维新乡',4,'',0,1,0,0),(16413,2204,'胡宅乡',4,'',0,1,0,0),(16414,2204,'高二乡',4,'',0,1,0,0),(16415,2205,'东孝街道',4,'',0,1,0,0),(16416,2205,'傅村镇',4,'',0,1,0,0),(16417,2205,'塘雅镇',4,'',0,1,0,0),(16418,2205,'多湖街道',4,'',0,1,0,0),(16419,2205,'孝顺镇',4,'',0,1,0,0),(16420,2205,'岭下镇',4,'',0,1,0,0),(16421,2205,'曹宅镇',4,'',0,1,0,0),(16422,2205,'江东镇',4,'',0,1,0,0),(16423,2205,'源东乡',4,'',0,1,0,0),(16424,2205,'澧浦镇',4,'',0,1,0,0),(16425,2205,'赤松镇',4,'',0,1,0,0),(16426,2206,'亭旁镇',4,'',0,1,0,0),(16427,2206,'健跳镇',4,'',0,1,0,0),(16428,2206,'六敖镇',4,'',0,1,0,0),(16429,2206,'小雄镇',4,'',0,1,0,0),(16430,2206,'横渡镇',4,'',0,1,0,0),(16431,2206,'沙柳镇',4,'',0,1,0,0),(16432,2206,'沿赤乡',4,'',0,1,0,0),(16433,2206,'泗淋乡',4,'',0,1,0,0),(16434,2206,'浬浦镇',4,'',0,1,0,0),(16435,2206,'海游镇',4,'',0,1,0,0),(16436,2206,'珠岙镇',4,'',0,1,0,0),(16437,2206,'花桥镇',4,'',0,1,0,0),(16438,2206,'蛇蟠乡',4,'',0,1,0,0),(16439,2206,'高枧乡',4,'',0,1,0,0),(16440,2207,'上盘镇',4,'',0,1,0,0),(16441,2207,'东塍镇',4,'',0,1,0,0),(16442,2207,'古城街道',4,'',0,1,0,0),(16443,2207,'大洋街道',4,'',0,1,0,0),(16444,2207,'大田街道',4,'',0,1,0,0),(16445,2207,'小芝镇',4,'',0,1,0,0),(16446,2207,'尤溪镇',4,'',0,1,0,0),(16447,2207,'括苍镇',4,'',0,1,0,0),(16448,2207,'杜桥镇',4,'',0,1,0,0),(16449,2207,'桃渚镇',4,'',0,1,0,0),(16450,2207,'永丰镇',4,'',0,1,0,0),(16451,2207,'汇溪镇',4,'',0,1,0,0),(16452,2207,'汛桥镇',4,'',0,1,0,0),(16453,2207,'江南街道',4,'',0,1,0,0),(16454,2207,'河头镇',4,'',0,1,0,0),(16455,2207,'沿江镇',4,'',0,1,0,0),(16456,2207,'涌泉镇',4,'',0,1,0,0),(16457,2207,'白水洋镇',4,'',0,1,0,0),(16458,2207,'邵家渡街道',4,'',0,1,0,0),(16459,2208,'皤滩乡',4,'',0,1,0,0),(16460,2208,'上张乡',4,'',0,1,0,0),(16461,2208,'下各镇',4,'',0,1,0,0),(16462,2208,'南峰街道',4,'',0,1,0,0),(16463,2208,'双庙乡',4,'',0,1,0,0),(16464,2208,'埠头镇',4,'',0,1,0,0),(16465,2208,'大战乡',4,'',0,1,0,0),(16466,2208,'安岭乡',4,'',0,1,0,0),(16467,2208,'安洲街道',4,'',0,1,0,0),(16468,2208,'官路镇',4,'',0,1,0,0),(16469,2208,'广度乡',4,'',0,1,0,0),(16470,2208,'朱溪镇',4,'',0,1,0,0),(16471,2208,'横溪镇',4,'',0,1,0,0),(16472,2208,'步路乡',4,'',0,1,0,0),(16473,2208,'淡竹乡',4,'',0,1,0,0),(16474,2208,'湫山乡',4,'',0,1,0,0),(16475,2208,'溪港乡',4,'',0,1,0,0),(16476,2208,'田市镇',4,'',0,1,0,0),(16477,2208,'白塔镇',4,'',0,1,0,0),(16478,2208,'福应街道',4,'',0,1,0,0),(16479,2209,'三合镇',4,'',0,1,0,0),(16480,2209,'三州乡',4,'',0,1,0,0),(16481,2209,'南屏乡',4,'',0,1,0,0),(16482,2209,'坦头镇',4,'',0,1,0,0),(16483,2209,'始丰街道',4,'',0,1,0,0),(16484,2209,'平桥镇',4,'',0,1,0,0),(16485,2209,'泳溪乡',4,'',0,1,0,0),(16486,2209,'洪畴镇',4,'',0,1,0,0),(16487,2209,'白鹤镇',4,'',0,1,0,0),(16488,2209,'石梁镇',4,'',0,1,0,0),(16489,2209,'福溪街道',4,'',0,1,0,0),(16490,2209,'街头镇',4,'',0,1,0,0),(16491,2209,'赤城街道',4,'',0,1,0,0),(16492,2209,'雷峰乡',4,'',0,1,0,0),(16493,2209,'龙溪乡',4,'',0,1,0,0),(16494,2210,'三甲街道',4,'',0,1,0,0),(16495,2210,'下陈街道',4,'',0,1,0,0),(16496,2210,'前所街道',4,'',0,1,0,0),(16497,2210,'大陈镇',4,'',0,1,0,0),(16498,2210,'洪家街道',4,'',0,1,0,0),(16499,2210,'海门街道',4,'',0,1,0,0),(16500,2210,'白云街道',4,'',0,1,0,0),(16501,2210,'章安街道',4,'',0,1,0,0),(16502,2210,'葭沚街道',4,'',0,1,0,0),(16503,2211,'坞根镇',4,'',0,1,0,0),(16504,2211,'城东街道',4,'',0,1,0,0),(16505,2211,'城北街道',4,'',0,1,0,0),(16506,2211,'城南镇',4,'',0,1,0,0),(16507,2211,'城西街道',4,'',0,1,0,0),(16508,2211,'大溪镇',4,'',0,1,0,0),(16509,2211,'太平街道',4,'',0,1,0,0),(16510,2211,'新河镇',4,'',0,1,0,0),(16511,2211,'松门镇',4,'',0,1,0,0),(16512,2211,'横峰街道',4,'',0,1,0,0),(16513,2211,'泽国镇',4,'',0,1,0,0),(16514,2211,'温峤镇',4,'',0,1,0,0),(16515,2211,'滨海镇',4,'',0,1,0,0),(16516,2211,'石塘镇',4,'',0,1,0,0),(16517,2211,'石桥头镇',4,'',0,1,0,0),(16518,2211,'箬横镇',4,'',0,1,0,0),(16519,2212,'干江镇',4,'',0,1,0,0),(16520,2212,'楚门镇',4,'',0,1,0,0),(16521,2212,'沙门镇',4,'',0,1,0,0),(16522,2212,'海山乡',4,'',0,1,0,0),(16523,2212,'清港镇',4,'',0,1,0,0),(16524,2212,'珠港镇',4,'',0,1,0,0),(16525,2212,'芦浦镇',4,'',0,1,0,0),(16526,2212,'鸡山乡',4,'',0,1,0,0),(16527,2212,'龙溪乡',4,'',0,1,0,0),(16528,2213,'峰江街道',4,'',0,1,0,0),(16529,2213,'新桥镇',4,'',0,1,0,0),(16530,2213,'桐屿街道',4,'',0,1,0,0),(16531,2213,'横街镇',4,'',0,1,0,0),(16532,2213,'蓬街镇',4,'',0,1,0,0),(16533,2213,'螺洋街道',4,'',0,1,0,0),(16534,2213,'路北街道',4,'',0,1,0,0),(16535,2213,'路南街道',4,'',0,1,0,0),(16536,2213,'路桥街道',4,'',0,1,0,0),(16537,2213,'金清镇',4,'',0,1,0,0),(16538,2214,'上垟乡',4,'',0,1,0,0),(16539,2214,'上郑乡',4,'',0,1,0,0),(16540,2214,'东城街道',4,'',0,1,0,0),(16541,2214,'北城街道',4,'',0,1,0,0),(16542,2214,'北洋镇',4,'',0,1,0,0),(16543,2214,'南城街道',4,'',0,1,0,0),(16544,2214,'头陀镇',4,'',0,1,0,0),(16545,2214,'宁溪镇',4,'',0,1,0,0),(16546,2214,'富山乡',4,'',0,1,0,0),(16547,2214,'屿头乡',4,'',0,1,0,0),(16548,2214,'平田乡',4,'',0,1,0,0),(16549,2214,'新前街道',4,'',0,1,0,0),(16550,2214,'江口街道',4,'',0,1,0,0),(16551,2214,'沙埠镇',4,'',0,1,0,0),(16552,2214,'澄江街道',4,'',0,1,0,0),(16553,2214,'茅畲乡',4,'',0,1,0,0),(16554,2214,'西城街道',4,'',0,1,0,0),(16555,2214,'院桥镇',4,'',0,1,0,0),(16556,2214,'高桥街道',4,'',0,1,0,0),(16557,2215,'云丰乡',4,'',0,1,0,0),(16558,2215,'云和镇',4,'',0,1,0,0),(16559,2215,'云坛乡',4,'',0,1,0,0),(16560,2215,'大塆乡',4,'',0,1,0,0),(16561,2215,'大源乡',4,'',0,1,0,0),(16562,2215,'安溪畲族乡',4,'',0,1,0,0),(16563,2215,'崇头镇',4,'',0,1,0,0),(16564,2215,'朱村乡',4,'',0,1,0,0),(16565,2215,'沙铺乡',4,'',0,1,0,0),(16566,2215,'石塘镇',4,'',0,1,0,0),(16567,2215,'紧水滩镇',4,'',0,1,0,0),(16568,2215,'赤石乡',4,'',0,1,0,0),(16569,2215,'雾溪畲族乡',4,'',0,1,0,0),(16570,2215,'黄源乡',4,'',0,1,0,0),(16571,2216,'举水乡',4,'',0,1,0,0),(16572,2216,'五大堡乡',4,'',0,1,0,0),(16573,2216,'合湖乡',4,'',0,1,0,0),(16574,2216,'四山乡',4,'',0,1,0,0),(16575,2216,'安南乡',4,'',0,1,0,0),(16576,2216,'官塘乡',4,'',0,1,0,0),(16577,2216,'屏都镇',4,'',0,1,0,0),(16578,2216,'岭头乡',4,'',0,1,0,0),(16579,2216,'左溪镇',4,'',0,1,0,0),(16580,2216,'张村乡',4,'',0,1,0,0),(16581,2216,'松源镇',4,'',0,1,0,0),(16582,2216,'江根乡',4,'',0,1,0,0),(16583,2216,'淤上乡',4,'',0,1,0,0),(16584,2216,'百山祖乡',4,'',0,1,0,0),(16585,2216,'竹口镇',4,'',0,1,0,0),(16586,2216,'荷地镇',4,'',0,1,0,0),(16587,2216,'贤良镇',4,'',0,1,0,0),(16588,2216,'隆宫乡',4,'',0,1,0,0),(16589,2216,'黄田镇',4,'',0,1,0,0),(16590,2216,'龙溪乡',4,'',0,1,0,0),(16591,2217,'东坑镇',4,'',0,1,0,0),(16592,2217,'外舍乡',4,'',0,1,0,0),(16593,2217,'大地乡',4,'',0,1,0,0),(16594,2217,'大均乡',4,'',0,1,0,0),(16595,2217,'大漈乡',4,'',0,1,0,0),(16596,2217,'大顺乡',4,'',0,1,0,0),(16597,2217,'家地乡',4,'',0,1,0,0),(16598,2217,'景南乡',4,'',0,1,0,0),(16599,2217,'标溪乡',4,'',0,1,0,0),(16600,2217,'梅岐乡',4,'',0,1,0,0),(16601,2217,'梧桐乡',4,'',0,1,0,0),(16602,2217,'毛垟乡',4,'',0,1,0,0),(16603,2217,'沙湾镇',4,'',0,1,0,0),(16604,2217,'渤海镇',4,'',0,1,0,0),(16605,2217,'澄照乡',4,'',0,1,0,0),(16606,2217,'秋炉乡',4,'',0,1,0,0),(16607,2217,'英川镇',4,'',0,1,0,0),(16608,2217,'葛山乡',4,'',0,1,0,0),(16609,2217,'郑坑乡',4,'',0,1,0,0),(16610,2217,'金钟乡',4,'',0,1,0,0),(16611,2217,'陈村乡',4,'',0,1,0,0),(16612,2217,'雁溪乡',4,'',0,1,0,0),(16613,2217,'鸬鹚乡',4,'',0,1,0,0),(16614,2217,'鹤溪镇',4,'',0,1,0,0),(16615,2218,'三都乡',4,'',0,1,0,0),(16616,2218,'古市镇',4,'',0,1,0,0),(16617,2218,'叶村乡',4,'',0,1,0,0),(16618,2218,'四都乡',4,'',0,1,0,0),(16619,2218,'大东坝镇',4,'',0,1,0,0),(16620,2218,'安民乡',4,'',0,1,0,0),(16621,2218,'斋坛乡',4,'',0,1,0,0),(16622,2218,'新兴乡',4,'',0,1,0,0),(16623,2218,'新处乡',4,'',0,1,0,0),(16624,2218,'望松乡',4,'',0,1,0,0),(16625,2218,'板桥畲族乡',4,'',0,1,0,0),(16626,2218,'枫坪乡',4,'',0,1,0,0),(16627,2218,'樟溪乡',4,'',0,1,0,0),(16628,2218,'玉岩镇',4,'',0,1,0,0),(16629,2218,'竹源乡',4,'',0,1,0,0),(16630,2218,'裕溪乡',4,'',0,1,0,0),(16631,2218,'西屏镇',4,'',0,1,0,0),(16632,2218,'谢村乡',4,'',0,1,0,0),(16633,2218,'象溪镇',4,'',0,1,0,0),(16634,2218,'赤寿乡',4,'',0,1,0,0),(16635,2219,'七里乡',4,'',0,1,0,0),(16636,2219,'三溪乡',4,'',0,1,0,0),(16637,2219,'东方镇',4,'',0,1,0,0),(16638,2219,'东渡镇',4,'',0,1,0,0),(16639,2219,'五云镇',4,'',0,1,0,0),(16640,2219,'前路乡',4,'',0,1,0,0),(16641,2219,'南溪乡',4,'',0,1,0,0),(16642,2219,'双川乡',4,'',0,1,0,0),(16643,2219,'双溪口乡',4,'',0,1,0,0),(16644,2219,'城北乡',4,'',0,1,0,0),(16645,2219,'壶镇镇',4,'',0,1,0,0),(16646,2219,'大洋镇',4,'',0,1,0,0),(16647,2219,'大源镇',4,'',0,1,0,0),(16648,2219,'新川乡',4,'',0,1,0,0),(16649,2219,'新建镇',4,'',0,1,0,0),(16650,2219,'新碧镇',4,'',0,1,0,0),(16651,2219,'方溪乡',4,'',0,1,0,0),(16652,2219,'木栗乡',4,'',0,1,0,0),(16653,2219,'溶江乡',4,'',0,1,0,0),(16654,2219,'白竹乡',4,'',0,1,0,0),(16655,2219,'石笕乡',4,'',0,1,0,0),(16656,2219,'胡源乡',4,'',0,1,0,0),(16657,2219,'舒洪镇',4,'',0,1,0,0),(16658,2219,'雁岭乡',4,'',0,1,0,0),(16659,2220,'万象街道',4,'',0,1,0,0),(16660,2220,'丽新畲族乡',4,'',0,1,0,0),(16661,2220,'仙渡乡',4,'',0,1,0,0),(16662,2220,'双溪镇',4,'',0,1,0,0),(16663,2220,'双黄乡',4,'',0,1,0,0),(16664,2220,'大港头镇',4,'',0,1,0,0),(16665,2220,'太平乡',4,'',0,1,0,0),(16666,2220,'富岭街道',4,'',0,1,0,0),(16667,2220,'岩泉街道',4,'',0,1,0,0),(16668,2220,'峰源乡',4,'',0,1,0,0),(16669,2220,'水阁街道',4,'',0,1,0,0),(16670,2220,'白云街道',4,'',0,1,0,0),(16671,2220,'碧湖镇',4,'',0,1,0,0),(16672,2220,'紫金街道',4,'',0,1,0,0),(16673,2220,'老竹畲族镇',4,'',0,1,0,0),(16674,2220,'联城镇',4,'',0,1,0,0),(16675,2220,'高溪乡',4,'',0,1,0,0),(16676,2220,'黄村乡',4,'',0,1,0,0),(16677,2221,'三仁畲族乡',4,'',0,1,0,0),(16678,2221,'云峰镇',4,'',0,1,0,0),(16679,2221,'北界镇',4,'',0,1,0,0),(16680,2221,'垵口乡',4,'',0,1,0,0),(16681,2221,'大柘镇',4,'',0,1,0,0),(16682,2221,'妙高镇',4,'',0,1,0,0),(16683,2221,'应村乡',4,'',0,1,0,0),(16684,2221,'新路湾镇',4,'',0,1,0,0),(16685,2221,'柘岱口乡',4,'',0,1,0,0),(16686,2221,'湖山乡',4,'',0,1,0,0),(16687,2221,'濂竹乡',4,'',0,1,0,0),(16688,2221,'焦滩乡',4,'',0,1,0,0),(16689,2221,'王村口镇',4,'',0,1,0,0),(16690,2221,'石练镇',4,'',0,1,0,0),(16691,2221,'蔡源乡',4,'',0,1,0,0),(16692,2221,'西畈乡',4,'',0,1,0,0),(16693,2221,'金竹镇',4,'',0,1,0,0),(16694,2221,'高坪乡',4,'',0,1,0,0),(16695,2221,'黄沙腰镇',4,'',0,1,0,0),(16696,2221,'龙洋乡',4,'',0,1,0,0),(16697,2222,'万山乡',4,'',0,1,0,0),(16698,2222,'万阜乡',4,'',0,1,0,0),(16699,2222,'东源镇',4,'',0,1,0,0),(16700,2222,'仁宫乡',4,'',0,1,0,0),(16701,2222,'仁庄镇',4,'',0,1,0,0),(16702,2222,'北山镇',4,'',0,1,0,0),(16703,2222,'吴坑乡',4,'',0,1,0,0),(16704,2222,'季宅乡',4,'',0,1,0,0),(16705,2222,'小舟山乡',4,'',0,1,0,0),(16706,2222,'山口镇',4,'',0,1,0,0),(16707,2222,'岭根乡',4,'',0,1,0,0),(16708,2222,'巨浦乡',4,'',0,1,0,0),(16709,2222,'方山乡',4,'',0,1,0,0),(16710,2222,'汤垟乡',4,'',0,1,0,0),(16711,2222,'海口镇',4,'',0,1,0,0),(16712,2222,'海溪乡',4,'',0,1,0,0),(16713,2222,'温溪镇',4,'',0,1,0,0),(16714,2222,'石溪乡',4,'',0,1,0,0),(16715,2222,'祯埠乡',4,'',0,1,0,0),(16716,2222,'祯旺乡',4,'',0,1,0,0),(16717,2222,'章旦乡',4,'',0,1,0,0),(16718,2222,'章村乡',4,'',0,1,0,0),(16719,2222,'腊口镇',4,'',0,1,0,0),(16720,2222,'舒桥乡',4,'',0,1,0,0),(16721,2222,'船寮镇',4,'',0,1,0,0),(16722,2222,'贵岙乡',4,'',0,1,0,0),(16723,2222,'阜山乡',4,'',0,1,0,0),(16724,2222,'高市乡',4,'',0,1,0,0),(16725,2222,'高湖镇',4,'',0,1,0,0),(16726,2222,'鹤城镇',4,'',0,1,0,0),(16727,2222,'黄垟乡',4,'',0,1,0,0),(16728,2223,'上垟镇',4,'',0,1,0,0),(16729,2223,'住龙镇',4,'',0,1,0,0),(16730,2223,'八都镇',4,'',0,1,0,0),(16731,2223,'兰巨乡',4,'',0,1,0,0),(16732,2223,'剑池街道',4,'',0,1,0,0),(16733,2223,'城北乡',4,'',0,1,0,0),(16734,2223,'塔石乡',4,'',0,1,0,0),(16735,2223,'安仁镇',4,'',0,1,0,0),(16736,2223,'宝溪乡',4,'',0,1,0,0),(16737,2223,'小梅镇',4,'',0,1,0,0),(16738,2223,'屏南镇',4,'',0,1,0,0),(16739,2223,'岩樟乡',4,'',0,1,0,0),(16740,2223,'查田镇',4,'',0,1,0,0),(16741,2223,'竹垟畲族乡',4,'',0,1,0,0),(16742,2223,'西街街道',4,'',0,1,0,0),(16743,2223,'道太乡',4,'',0,1,0,0),(16744,2223,'锦溪镇',4,'',0,1,0,0),(16745,2223,'龙南乡',4,'',0,1,0,0),(16746,2223,'龙渊街道',4,'',0,1,0,0),(16747,2224,'义兴镇',4,'',0,1,0,0),(16748,2224,'义城镇',4,'',0,1,0,0),(16749,2224,'大圩乡',4,'',0,1,0,0),(16750,2224,'宁国路街道',4,'',0,1,0,0),(16751,2224,'巢湖路街道',4,'',0,1,0,0),(16752,2224,'常青街道',4,'',0,1,0,0),(16753,2224,'烟墩乡',4,'',0,1,0,0),(16754,2224,'芜湖路街道',4,'',0,1,0,0),(16755,2224,'骆岗街道',4,'',0,1,0,0),(16756,2225,'三十岗乡',4,'',0,1,0,0),(16757,2225,'三牌楼街道',4,'',0,1,0,0),(16758,2225,'亳州路街道',4,'',0,1,0,0),(16759,2225,'光明街道',4,'',0,1,0,0),(16760,2225,'县桥街道',4,'',0,1,0,0),(16761,2225,'双岗街道',4,'',0,1,0,0),(16762,2225,'大杨镇',4,'',0,1,0,0),(16763,2225,'安庆路街道',4,'',0,1,0,0),(16764,2225,'杏林街道',4,'',0,1,0,0),(16765,2225,'杏花村街道',4,'',0,1,0,0),(16766,2225,'海棠街道',4,'',0,1,0,0),(16767,2225,'益民街道',4,'',0,1,0,0),(16768,2225,'逍遥津街道',4,'',0,1,0,0),(16769,2226,'七里塘街道',4,'',0,1,0,0),(16770,2226,'七里站街道',4,'',0,1,0,0),(16771,2226,'三里街街道',4,'',0,1,0,0),(16772,2226,'和平路街道',4,'',0,1,0,0),(16773,2226,'城东街道',4,'',0,1,0,0),(16774,2226,'大兴镇',4,'',0,1,0,0),(16775,2226,'大通路街道',4,'',0,1,0,0),(16776,2226,'方庙街道',4,'',0,1,0,0),(16777,2226,'明光路街道',4,'',0,1,0,0),(16778,2226,'磨店乡',4,'',0,1,0,0),(16779,2226,'红光街道',4,'',0,1,0,0),(16780,2226,'胜利路街道',4,'',0,1,0,0),(16781,2226,'车站街道',4,'',0,1,0,0),(16782,2226,'铜陵路街道',4,'',0,1,0,0),(16783,2226,'长淮街道',4,'',0,1,0,0),(16784,2227,'众兴乡',4,'',0,1,0,0),(16785,2227,'元疃镇',4,'',0,1,0,0),(16786,2227,'八斗镇',4,'',0,1,0,0),(16787,2227,'包公镇',4,'',0,1,0,0),(16788,2227,'古城镇',4,'',0,1,0,0),(16789,2227,'响导乡',4,'',0,1,0,0),(16790,2227,'店埠镇',4,'',0,1,0,0),(16791,2227,'张集乡',4,'',0,1,0,0),(16792,2227,'撮镇镇',4,'',0,1,0,0),(16793,2227,'杨店乡',4,'',0,1,0,0),(16794,2227,'桥头集镇',4,'',0,1,0,0),(16795,2227,'梁园镇',4,'',0,1,0,0),(16796,2227,'牌坊回族满族乡',4,'',0,1,0,0),(16797,2227,'白龙镇',4,'',0,1,0,0),(16798,2227,'石塘镇',4,'',0,1,0,0),(16799,2227,'长临河镇',4,'',0,1,0,0),(16800,2227,'陈集乡',4,'',0,1,0,0),(16801,2227,'马湖乡',4,'',0,1,0,0),(16802,2228,'三河镇',4,'',0,1,0,0),(16803,2228,'上派镇',4,'',0,1,0,0),(16804,2228,'严店乡',4,'',0,1,0,0),(16805,2228,'丰乐镇',4,'',0,1,0,0),(16806,2228,'官亭镇',4,'',0,1,0,0),(16807,2228,'小庙镇',4,'',0,1,0,0),(16808,2228,'山南镇',4,'',0,1,0,0),(16809,2228,'柿树岗乡',4,'',0,1,0,0),(16810,2228,'桃花镇',4,'',0,1,0,0),(16811,2228,'紫蓬镇',4,'',0,1,0,0),(16812,2228,'花岗镇',4,'',0,1,0,0),(16813,2228,'铭传乡',4,'',0,1,0,0),(16814,2228,'高刘镇',4,'',0,1,0,0),(16815,2228,'高店乡',4,'',0,1,0,0),(16816,2229,'三里庵街道',4,'',0,1,0,0),(16817,2229,'五里墩街道',4,'',0,1,0,0),(16818,2229,'井岗镇',4,'',0,1,0,0),(16819,2229,'南七里站街道',4,'',0,1,0,0),(16820,2229,'南岗镇',4,'',0,1,0,0),(16821,2229,'琥珀山庄街道',4,'',0,1,0,0),(16822,2229,'稻香村街道',4,'',0,1,0,0),(16823,2229,'笔架山街道',4,'',0,1,0,0),(16824,2229,'荷叶地街道',4,'',0,1,0,0),(16825,2229,'西园新村街道',4,'',0,1,0,0),(16826,2230,'三十头乡',4,'',0,1,0,0),(16827,2230,'下塘镇',4,'',0,1,0,0),(16828,2230,'义井乡',4,'',0,1,0,0),(16829,2230,'双墩镇',4,'',0,1,0,0),(16830,2230,'吴山镇',4,'',0,1,0,0),(16831,2230,'岗集镇',4,'',0,1,0,0),(16832,2230,'左店乡',4,'',0,1,0,0),(16833,2230,'庄墓镇',4,'',0,1,0,0),(16834,2230,'朱巷镇',4,'',0,1,0,0),(16835,2230,'杜集乡',4,'',0,1,0,0),(16836,2230,'杨庙镇',4,'',0,1,0,0),(16837,2230,'水湖镇',4,'',0,1,0,0),(16838,2230,'罗塘乡',4,'',0,1,0,0),(16839,2230,'造甲乡',4,'',0,1,0,0),(16840,2230,'陶楼乡',4,'',0,1,0,0),(16841,2231,'三山街道',4,'',0,1,0,0),(16842,2231,'保定街道',4,'',0,1,0,0),(16843,2231,'峨桥镇',4,'',0,1,0,0),(16844,2231,'龙湖街道',4,'',0,1,0,0),(16845,2232,'三里镇',4,'',0,1,0,0),(16846,2232,'何湾镇',4,'',0,1,0,0),(16847,2232,'家发镇',4,'',0,1,0,0),(16848,2232,'工山镇',4,'',0,1,0,0),(16849,2232,'弋江镇',4,'',0,1,0,0),(16850,2232,'烟墩镇',4,'',0,1,0,0),(16851,2232,'籍山镇',4,'',0,1,0,0),(16852,2232,'许镇镇',4,'',0,1,0,0),(16853,2233,'中山南路街道',4,'',0,1,0,0),(16854,2233,'利民路街道',4,'',0,1,0,0),(16855,2233,'南瑞街道',4,'',0,1,0,0),(16856,2233,'弋江桥街道',4,'',0,1,0,0),(16857,2233,'火龙岗镇',4,'',0,1,0,0),(16858,2233,'马塘镇',4,'',0,1,0,0),(16859,2233,'鲁港镇',4,'',0,1,0,0),(16860,2234,'孙村镇',4,'',0,1,0,0),(16861,2234,'峨山乡',4,'',0,1,0,0),(16862,2234,'平铺镇',4,'',0,1,0,0),(16863,2234,'新港镇',4,'',0,1,0,0),(16864,2234,'繁阳镇',4,'',0,1,0,0),(16865,2234,'荻港镇',4,'',0,1,0,0),(16866,2235,'六郎镇',4,'',0,1,0,0),(16867,2235,'方村镇',4,'',0,1,0,0),(16868,2235,'湾沚镇',4,'',0,1,0,0),(16869,2235,'红杨镇',4,'',0,1,0,0),(16870,2235,'花桥镇',4,'',0,1,0,0),(16871,2235,'陶辛镇',4,'',0,1,0,0),(16872,2236,'东门街道',4,'',0,1,0,0),(16873,2236,'北京路街道',4,'',0,1,0,0),(16874,2236,'北门街道',4,'',0,1,0,0),(16875,2236,'吉和街道',4,'',0,1,0,0),(16876,2236,'天门山街道',4,'',0,1,0,0),(16877,2236,'弋矶山街道',4,'',0,1,0,0),(16878,2236,'汀棠街道',4,'',0,1,0,0),(16879,2236,'荆山街道',4,'',0,1,0,0),(16880,2236,'赭山街道',4,'',0,1,0,0),(16881,2236,'赭麓街道',4,'',0,1,0,0),(16882,2236,'镜湖街道',4,'',0,1,0,0),(16883,2237,'四褐山街道',4,'',0,1,0,0),(16884,2237,'大桥街道',4,'',0,1,0,0),(16885,2237,'大闸街道',4,'',0,1,0,0),(16886,2237,'官陡街道',4,'',0,1,0,0),(16887,2237,'张镇街道',4,'',0,1,0,0),(16888,2237,'清水街道',4,'',0,1,0,0),(16889,2237,'湾里街道',4,'',0,1,0,0),(16890,2237,'裕溪口街道',4,'',0,1,0,0),(16891,2238,'东刘集镇',4,'',0,1,0,0),(16892,2238,'临北回族乡',4,'',0,1,0,0),(16893,2238,'双忠庙镇',4,'',0,1,0,0),(16894,2238,'城关镇',4,'',0,1,0,0),(16895,2238,'大新镇',4,'',0,1,0,0),(16896,2238,'头铺镇',4,'',0,1,0,0),(16897,2238,'小圩镇',4,'',0,1,0,0),(16898,2238,'小溪镇',4,'',0,1,0,0),(16899,2238,'新集镇',4,'',0,1,0,0),(16900,2238,'朱顶镇',4,'',0,1,0,0),(16901,2238,'武桥镇',4,'',0,1,0,0),(16902,2238,'沫河口镇',4,'',0,1,0,0),(16903,2238,'沱湖乡',4,'',0,1,0,0),(16904,2238,'浍南镇',4,'',0,1,0,0),(16905,2238,'申集镇',4,'',0,1,0,0),(16906,2239,'仲兴乡',4,'',0,1,0,0),(16907,2239,'任桥镇',4,'',0,1,0,0),(16908,2239,'刘集镇',4,'',0,1,0,0),(16909,2239,'城关镇',4,'',0,1,0,0),(16910,2239,'新马桥镇',4,'',0,1,0,0),(16911,2239,'杨庙乡',4,'',0,1,0,0),(16912,2239,'湖沟镇',4,'',0,1,0,0),(16913,2239,'濠城镇',4,'',0,1,0,0),(16914,2239,'王庄镇',4,'',0,1,0,0),(16915,2239,'石湖乡',4,'',0,1,0,0),(16916,2239,'连城镇',4,'',0,1,0,0),(16917,2240,'万福镇',4,'',0,1,0,0),(16918,2240,'兰桥乡',4,'',0,1,0,0),(16919,2240,'双桥集镇',4,'',0,1,0,0),(16920,2240,'古城乡',4,'',0,1,0,0),(16921,2240,'唐集镇',4,'',0,1,0,0),(16922,2240,'城关镇',4,'',0,1,0,0),(16923,2240,'常坟镇',4,'',0,1,0,0),(16924,2240,'徐圩乡',4,'',0,1,0,0),(16925,2240,'找郢乡',4,'',0,1,0,0),(16926,2240,'河溜镇',4,'',0,1,0,0),(16927,2240,'淝南乡',4,'',0,1,0,0),(16928,2240,'淝河乡',4,'',0,1,0,0),(16929,2240,'荆芡乡',4,'',0,1,0,0),(16930,2240,'褚集乡',4,'',0,1,0,0),(16931,2240,'陈集乡',4,'',0,1,0,0),(16932,2240,'马城镇',4,'',0,1,0,0),(16933,2240,'魏庄镇',4,'',0,1,0,0),(16934,2240,'鲍集镇',4,'',0,1,0,0),(16935,2240,'龙亢农场',4,'',0,1,0,0),(16936,2240,'龙亢镇',4,'',0,1,0,0),(16937,2241,'吴小街镇',4,'',0,1,0,0),(16938,2241,'小蚌埠镇',4,'',0,1,0,0),(16939,2241,'曹老集镇',4,'',0,1,0,0),(16940,2241,'梅桥乡',4,'',0,1,0,0),(16941,2241,'淮滨街道',4,'',0,1,0,0),(16942,2242,'大庆街道',4,'',0,1,0,0),(16943,2242,'张公山街道',4,'',0,1,0,0),(16944,2242,'朝阳街道',4,'',0,1,0,0),(16945,2242,'秦集镇',4,'',0,1,0,0),(16946,2242,'纬四街道',4,'',0,1,0,0),(16947,2242,'钓鱼台街道',4,'',0,1,0,0),(16948,2242,'长青乡',4,'',0,1,0,0),(16949,2243,'天桥街道',4,'',0,1,0,0),(16950,2243,'宏业村街道',4,'',0,1,0,0),(16951,2243,'燕山乡',4,'',0,1,0,0),(16952,2243,'纬二路街道',4,'',0,1,0,0),(16953,2243,'胜利街道',4,'',0,1,0,0),(16954,2243,'雪华乡',4,'',0,1,0,0),(16955,2243,'青年街道',4,'',0,1,0,0),(16956,2243,'黄庄街道',4,'',0,1,0,0),(16957,2243,'龙湖新村街道',4,'',0,1,0,0),(16958,2244,'东升街道',4,'',0,1,0,0),(16959,2244,'东风街道',4,'',0,1,0,0),(16960,2244,'延安街道',4,'',0,1,0,0),(16961,2244,'曹山街道',4,'',0,1,0,0),(16962,2244,'李楼乡',4,'',0,1,0,0),(16963,2244,'治淮街道',4,'',0,1,0,0),(16964,2244,'解放街道',4,'',0,1,0,0),(16965,2244,'长淮卫镇',4,'',0,1,0,0),(16966,2245,'八公山镇',4,'',0,1,0,0),(16967,2245,'土坝孜街道',4,'',0,1,0,0),(16968,2245,'山王镇',4,'',0,1,0,0),(16969,2245,'新庄孜街道',4,'',0,1,0,0),(16970,2245,'毕家岗街道',4,'',0,1,0,0),(16971,2246,'丁集乡',4,'',0,1,0,0),(16972,2246,'关店乡',4,'',0,1,0,0),(16973,2246,'刘集乡',4,'',0,1,0,0),(16974,2246,'古店乡',4,'',0,1,0,0),(16975,2246,'城关镇',4,'',0,1,0,0),(16976,2246,'城北乡',4,'',0,1,0,0),(16977,2246,'夏集乡',4,'',0,1,0,0),(16978,2246,'大兴集乡',4,'',0,1,0,0),(16979,2246,'大山镇',4,'',0,1,0,0),(16980,2246,'尚塘乡',4,'',0,1,0,0),(16981,2246,'岳张集镇',4,'',0,1,0,0),(16982,2246,'新集镇',4,'',0,1,0,0),(16983,2246,'朱马店镇',4,'',0,1,0,0),(16984,2246,'李冲回族乡',4,'',0,1,0,0),(16985,2246,'杨村乡',4,'',0,1,0,0),(16986,2246,'桂集乡',4,'',0,1,0,0),(16987,2246,'毛集镇',4,'',0,1,0,0),(16988,2246,'焦岗乡',4,'',0,1,0,0),(16989,2246,'钱庙乡',4,'',0,1,0,0),(16990,2246,'顾桥镇',4,'',0,1,0,0),(16991,2247,'上窑镇',4,'',0,1,0,0),(16992,2247,'九龙岗镇',4,'',0,1,0,0),(16993,2247,'大通街道',4,'',0,1,0,0),(16994,2247,'孔店乡',4,'',0,1,0,0),(16995,2247,'洛河镇',4,'',0,1,0,0),(16996,2248,'古沟回族乡',4,'',0,1,0,0),(16997,2248,'夹沟乡',4,'',0,1,0,0),(16998,2248,'平圩镇',4,'',0,1,0,0),(16999,2248,'架河乡',4,'',0,1,0,0),(17000,2248,'泥河镇',4,'',0,1,0,0),(17001,2248,'潘集镇',4,'',0,1,0,0),(17002,2248,'田集街道',4,'',0,1,0,0),(17003,2248,'祁集乡',4,'',0,1,0,0),(17004,2248,'芦集镇',4,'',0,1,0,0),(17005,2248,'贺疃乡',4,'',0,1,0,0),(17006,2248,'高皇镇',4,'',0,1,0,0),(17007,2249,'三和乡',4,'',0,1,0,0),(17008,2249,'公园街道',4,'',0,1,0,0),(17009,2249,'史院乡',4,'',0,1,0,0),(17010,2249,'国庆街道',4,'',0,1,0,0),(17011,2249,'安成镇',4,'',0,1,0,0),(17012,2249,'新淮街道',4,'',0,1,0,0),(17013,2249,'曹庵镇',4,'',0,1,0,0),(17014,2249,'朝阳街道',4,'',0,1,0,0),(17015,2249,'泉山街道',4,'',0,1,0,0),(17016,2249,'洞山街道',4,'',0,1,0,0),(17017,2249,'淮滨街道',4,'',0,1,0,0),(17018,2249,'田东街道',4,'',0,1,0,0),(17019,2249,'舜耕镇',4,'',0,1,0,0),(17020,2249,'龙泉街道',4,'',0,1,0,0),(17021,2250,'唐山镇',4,'',0,1,0,0),(17022,2250,'孙庙乡',4,'',0,1,0,0),(17023,2250,'孤堆回族乡',4,'',0,1,0,0),(17024,2250,'平山街道',4,'',0,1,0,0),(17025,2250,'望峰岗镇',4,'',0,1,0,0),(17026,2250,'李郢孜镇',4,'',0,1,0,0),(17027,2250,'杨公镇',4,'',0,1,0,0),(17028,2250,'立新街道',4,'',0,1,0,0),(17029,2250,'蔡家岗街道',4,'',0,1,0,0),(17030,2250,'谢三村街道',4,'',0,1,0,0),(17031,2250,'谢家集街道',4,'',0,1,0,0),(17032,2251,'丹阳镇',4,'',0,1,0,0),(17033,2251,'乌溪镇',4,'',0,1,0,0),(17034,2251,'博望镇',4,'',0,1,0,0),(17035,2251,'塘南镇',4,'',0,1,0,0),(17036,2251,'大陇乡',4,'',0,1,0,0),(17037,2251,'太白镇',4,'',0,1,0,0),(17038,2251,'姑孰镇',4,'',0,1,0,0),(17039,2251,'年陡乡',4,'',0,1,0,0),(17040,2251,'护河镇',4,'',0,1,0,0),(17041,2251,'新市镇',4,'',0,1,0,0),(17042,2251,'江心乡',4,'',0,1,0,0),(17043,2251,'湖阳乡',4,'',0,1,0,0),(17044,2251,'石桥镇',4,'',0,1,0,0),(17045,2251,'黄池镇',4,'',0,1,0,0),(17046,2252,'桃源路街道',4,'',0,1,0,0),(17047,2252,'沙塘路街道',4,'',0,1,0,0),(17048,2252,'湖东路街道',4,'',0,1,0,0),(17049,2252,'解放路街道',4,'',0,1,0,0),(17050,2252,'霍里镇',4,'',0,1,0,0),(17051,2253,'塘西街道',4,'',0,1,0,0),(17052,2253,'慈湖乡',4,'',0,1,0,0),(17053,2253,'慈湖街道',4,'',0,1,0,0),(17054,2253,'江边街道',4,'',0,1,0,0),(17055,2253,'金家庄街道',4,'',0,1,0,0),(17056,2254,'佳山乡',4,'',0,1,0,0),(17057,2254,'向山镇',4,'',0,1,0,0),(17058,2254,'安民街道',4,'',0,1,0,0),(17059,2254,'平湖街道',4,'',0,1,0,0),(17060,2254,'采石街道',4,'',0,1,0,0),(17061,2254,'银塘镇',4,'',0,1,0,0),(17062,2254,'雨山街道',4,'',0,1,0,0),(17063,2255,'朔里镇',4,'',0,1,0,0),(17064,2255,'段圆镇',4,'',0,1,0,0),(17065,2255,'石台镇',4,'',0,1,0,0),(17066,2255,'矿山集街道',4,'',0,1,0,0),(17067,2255,'高岳街道',4,'',0,1,0,0),(17068,2256,'临涣镇',4,'',0,1,0,0),(17069,2256,'五沟镇',4,'',0,1,0,0),(17070,2256,'刘桥镇',4,'',0,1,0,0),(17071,2256,'南坪镇',4,'',0,1,0,0),(17072,2256,'双堆集镇',4,'',0,1,0,0),(17073,2256,'四铺乡',4,'',0,1,0,0),(17074,2256,'孙疃镇',4,'',0,1,0,0),(17075,2256,'濉溪镇',4,'',0,1,0,0),(17076,2256,'百善镇',4,'',0,1,0,0),(17077,2256,'铁佛镇',4,'',0,1,0,0),(17078,2256,'韩村镇',4,'',0,1,0,0),(17079,2257,'临海童街道',4,'',0,1,0,0),(17080,2257,'任楼街道',4,'',0,1,0,0),(17081,2257,'前岭街道',4,'',0,1,0,0),(17082,2257,'古饶镇',4,'',0,1,0,0),(17083,2257,'宋疃镇',4,'',0,1,0,0),(17084,2257,'杨庄街道',4,'',0,1,0,0),(17085,2257,'烈山镇',4,'',0,1,0,0),(17086,2257,'百善街道',4,'',0,1,0,0),(17087,2258,'三堤口街道',4,'',0,1,0,0),(17088,2258,'东山街道',4,'',0,1,0,0),(17089,2258,'任圩街道',4,'',0,1,0,0),(17090,2258,'刘桥街道',4,'',0,1,0,0),(17091,2258,'渠沟镇',4,'',0,1,0,0),(17092,2258,'相南街道',4,'',0,1,0,0),(17093,2258,'相山东街道',4,'',0,1,0,0),(17094,2258,'相山西街道',4,'',0,1,0,0),(17095,2259,'凤凰山街道',4,'',0,1,0,0),(17096,2259,'新庙街道',4,'',0,1,0,0),(17097,2259,'狮子山街道',4,'',0,1,0,0),(17098,2259,'矶山街道',4,'',0,1,0,0),(17099,2259,'西湖镇',4,'',0,1,0,0),(17100,2260,'大通镇',4,'',0,1,0,0),(17101,2260,'安铜街道',4,'',0,1,0,0),(17102,2260,'普济圩农场',4,'',0,1,0,0),(17103,2260,'桥南街道',4,'',0,1,0,0),(17104,2260,'灰河乡',4,'',0,1,0,0),(17105,2260,'铜山镇',4,'',0,1,0,0),(17106,2261,'扫把沟街道',4,'',0,1,0,0),(17107,2261,'杨家山街道',4,'',0,1,0,0),(17108,2261,'横港街道',4,'',0,1,0,0),(17109,2261,'石城路街道',4,'',0,1,0,0),(17110,2261,'铜官山街道',4,'',0,1,0,0),(17111,2261,'长江路街道',4,'',0,1,0,0),(17112,2262,'东联乡',4,'',0,1,0,0),(17113,2262,'五松镇',4,'',0,1,0,0),(17114,2262,'天门镇',4,'',0,1,0,0),(17115,2262,'老洲乡',4,'',0,1,0,0),(17116,2262,'胥坝乡',4,'',0,1,0,0),(17117,2262,'西联乡',4,'',0,1,0,0),(17118,2262,'钟鸣镇',4,'',0,1,0,0),(17119,2262,'顺安镇',4,'',0,1,0,0),(17120,2263,'十里铺乡',4,'',0,1,0,0),(17121,2263,'山口乡',4,'',0,1,0,0),(17122,2263,'德宽路街道',4,'',0,1,0,0),(17123,2263,'海口镇',4,'',0,1,0,0),(17124,2263,'玉琳路街道',4,'',0,1,0,0),(17125,2263,'石化路街道',4,'',0,1,0,0),(17126,2263,'花亭路街道',4,'',0,1,0,0),(17127,2263,'菱湖街道',4,'',0,1,0,0),(17128,2263,'集贤路街道',4,'',0,1,0,0),(17129,2263,'龙山路街道',4,'',0,1,0,0),(17130,2264,'刘畈乡',4,'',0,1,0,0),(17131,2264,'北中镇',4,'',0,1,0,0),(17132,2264,'城西乡',4,'',0,1,0,0),(17133,2264,'大石乡',4,'',0,1,0,0),(17134,2264,'天华镇',4,'',0,1,0,0),(17135,2264,'寺前镇',4,'',0,1,0,0),(17136,2264,'小池镇',4,'',0,1,0,0),(17137,2264,'弥陀镇',4,'',0,1,0,0),(17138,2264,'徐桥镇',4,'',0,1,0,0),(17139,2264,'新仓镇',4,'',0,1,0,0),(17140,2264,'晋熙镇',4,'',0,1,0,0),(17141,2264,'江塘乡',4,'',0,1,0,0),(17142,2264,'汤泉乡',4,'',0,1,0,0),(17143,2264,'牛镇镇',4,'',0,1,0,0),(17144,2264,'百里镇',4,'',0,1,0,0),(17145,2265,'五横乡',4,'',0,1,0,0),(17146,2265,'大龙山镇',4,'',0,1,0,0),(17147,2265,'杨桥镇',4,'',0,1,0,0),(17148,2265,'白泽湖乡',4,'',0,1,0,0),(17149,2265,'皖河农场',4,'',0,1,0,0),(17150,2265,'罗岭镇',4,'',0,1,0,0),(17151,2265,'菱北街道',4,'',0,1,0,0),(17152,2266,'下仓镇',4,'',0,1,0,0),(17153,2266,'九姑乡',4,'',0,1,0,0),(17154,2266,'二郎镇',4,'',0,1,0,0),(17155,2266,'五里乡',4,'',0,1,0,0),(17156,2266,'佐坝乡',4,'',0,1,0,0),(17157,2266,'凉亭镇',4,'',0,1,0,0),(17158,2266,'北浴乡',4,'',0,1,0,0),(17159,2266,'千岭乡',4,'',0,1,0,0),(17160,2266,'华阳河农场总场',4,'',0,1,0,0),(17161,2266,'复兴镇',4,'',0,1,0,0),(17162,2266,'孚玉镇',4,'',0,1,0,0),(17163,2266,'柳坪乡',4,'',0,1,0,0),(17164,2266,'汇口镇',4,'',0,1,0,0),(17165,2266,'河塌乡',4,'',0,1,0,0),(17166,2266,'洲头乡',4,'',0,1,0,0),(17167,2266,'破凉镇',4,'',0,1,0,0),(17168,2266,'程岭乡',4,'',0,1,0,0),(17169,2266,'许岭镇',4,'',0,1,0,0),(17170,2266,'趾凤乡',4,'',0,1,0,0),(17171,2266,'长铺镇',4,'',0,1,0,0),(17172,2266,'陈汉乡',4,'',0,1,0,0),(17173,2266,'隘口乡',4,'',0,1,0,0),(17174,2266,'高岭乡',4,'',0,1,0,0),(17175,2267,'中关乡',4,'',0,1,0,0),(17176,2267,'主簿镇',4,'',0,1,0,0),(17177,2267,'五河镇',4,'',0,1,0,0),(17178,2267,'冶溪镇',4,'',0,1,0,0),(17179,2267,'包家乡',4,'',0,1,0,0),(17180,2267,'古坊乡',4,'',0,1,0,0),(17181,2267,'和平乡',4,'',0,1,0,0),(17182,2267,'响肠镇',4,'',0,1,0,0),(17183,2267,'天堂镇',4,'',0,1,0,0),(17184,2267,'头陀镇',4,'',0,1,0,0),(17185,2267,'姚河乡',4,'',0,1,0,0),(17186,2267,'巍岭乡',4,'',0,1,0,0),(17187,2267,'店前镇',4,'',0,1,0,0),(17188,2267,'来榜镇',4,'',0,1,0,0),(17189,2267,'毛尖山乡',4,'',0,1,0,0),(17190,2267,'河图镇',4,'',0,1,0,0),(17191,2267,'温泉镇',4,'',0,1,0,0),(17192,2267,'田头乡',4,'',0,1,0,0),(17193,2267,'白帽镇',4,'',0,1,0,0),(17194,2267,'石关乡',4,'',0,1,0,0),(17195,2267,'莲云乡',4,'',0,1,0,0),(17196,2267,'菖蒲镇',4,'',0,1,0,0),(17197,2267,'青天乡',4,'',0,1,0,0),(17198,2267,'黄尾镇',4,'',0,1,0,0),(17199,2268,'三桥镇',4,'',0,1,0,0),(17200,2268,'公岭镇',4,'',0,1,0,0),(17201,2268,'凉亭乡',4,'',0,1,0,0),(17202,2268,'小市镇',4,'',0,1,0,0),(17203,2268,'平山镇',4,'',0,1,0,0),(17204,2268,'月山镇',4,'',0,1,0,0),(17205,2268,'江镇镇',4,'',0,1,0,0),(17206,2268,'洪铺镇',4,'',0,1,0,0),(17207,2268,'清河乡',4,'',0,1,0,0),(17208,2268,'石牌镇',4,'',0,1,0,0),(17209,2268,'石镜乡',4,'',0,1,0,0),(17210,2268,'秀山乡',4,'',0,1,0,0),(17211,2268,'腊树镇',4,'',0,1,0,0),(17212,2268,'茶岭镇',4,'',0,1,0,0),(17213,2268,'金拱镇',4,'',0,1,0,0),(17214,2268,'雷埠乡',4,'',0,1,0,0),(17215,2268,'马庙镇',4,'',0,1,0,0),(17216,2268,'高河镇',4,'',0,1,0,0),(17217,2268,'黄墩镇',4,'',0,1,0,0),(17218,2268,'黄龙镇',4,'',0,1,0,0),(17219,2269,'凉泉乡',4,'',0,1,0,0),(17220,2269,'华阳镇',4,'',0,1,0,0),(17221,2269,'太慈镇',4,'',0,1,0,0),(17222,2269,'杨湾镇',4,'',0,1,0,0),(17223,2269,'漳湖镇',4,'',0,1,0,0),(17224,2269,'赛口镇',4,'',0,1,0,0),(17225,2269,'长岭镇',4,'',0,1,0,0),(17226,2269,'雷池乡',4,'',0,1,0,0),(17227,2269,'高士镇',4,'',0,1,0,0),(17228,2269,'鸦滩镇',4,'',0,1,0,0),(17229,2270,'义津镇',4,'',0,1,0,0),(17230,2270,'会宫乡',4,'',0,1,0,0),(17231,2270,'凤仪乡',4,'',0,1,0,0),(17232,2270,'周潭镇',4,'',0,1,0,0),(17233,2270,'固山镇',4,'',0,1,0,0),(17234,2270,'官埠桥镇',4,'',0,1,0,0),(17235,2270,'枞阳镇',4,'',0,1,0,0),(17236,2270,'横埠镇',4,'',0,1,0,0),(17237,2270,'汤沟镇',4,'',0,1,0,0),(17238,2270,'浮山镇',4,'',0,1,0,0),(17239,2270,'白梅乡',4,'',0,1,0,0),(17240,2270,'白湖乡',4,'',0,1,0,0),(17241,2270,'老洲镇',4,'',0,1,0,0),(17242,2270,'金社乡',4,'',0,1,0,0),(17243,2270,'钱桥镇',4,'',0,1,0,0),(17244,2270,'钱铺乡',4,'',0,1,0,0),(17245,2270,'铁铜乡',4,'',0,1,0,0),(17246,2270,'长沙乡',4,'',0,1,0,0),(17247,2270,'陈瑶湖镇',4,'',0,1,0,0),(17248,2270,'雨坛乡',4,'',0,1,0,0),(17249,2270,'项铺镇',4,'',0,1,0,0),(17250,2270,'麒麟镇',4,'',0,1,0,0),(17251,2271,'中义乡',4,'',0,1,0,0),(17252,2271,'兴店镇',4,'',0,1,0,0),(17253,2271,'卅铺镇',4,'',0,1,0,0),(17254,2271,'南演街道',4,'',0,1,0,0),(17255,2271,'双港镇',4,'',0,1,0,0),(17256,2271,'吕亭镇',4,'',0,1,0,0),(17257,2271,'唐湾镇',4,'',0,1,0,0),(17258,2271,'大关镇',4,'',0,1,0,0),(17259,2271,'大塘乡',4,'',0,1,0,0),(17260,2271,'太平街道',4,'',0,1,0,0),(17261,2271,'嬉子湖镇',4,'',0,1,0,0),(17262,2271,'孔城镇',4,'',0,1,0,0),(17263,2271,'挂车河镇',4,'',0,1,0,0),(17264,2271,'文昌街道',4,'',0,1,0,0),(17265,2271,'新渡镇',4,'',0,1,0,0),(17266,2271,'碧峰街道',4,'',0,1,0,0),(17267,2271,'老梅镇',4,'',0,1,0,0),(17268,2271,'范岗镇',4,'',0,1,0,0),(17269,2271,'金神镇',4,'',0,1,0,0),(17270,2271,'陶冲镇',4,'',0,1,0,0),(17271,2271,'青草镇',4,'',0,1,0,0),(17272,2271,'香铺镇',4,'',0,1,0,0),(17273,2271,'高桥镇',4,'',0,1,0,0),(17274,2271,'鲟鱼镇',4,'',0,1,0,0),(17275,2271,'黄铺乡',4,'',0,1,0,0),(17276,2271,'龙眠乡',4,'',0,1,0,0),(17277,2272,'五庙乡',4,'',0,1,0,0),(17278,2272,'余井镇',4,'',0,1,0,0),(17279,2272,'塔畈乡',4,'',0,1,0,0),(17280,2272,'天柱山镇',4,'',0,1,0,0),(17281,2272,'官庄镇',4,'',0,1,0,0),(17282,2272,'彭岭工业区',4,'',0,1,0,0),(17283,2272,'梅城镇',4,'',0,1,0,0),(17284,2272,'槎水镇',4,'',0,1,0,0),(17285,2272,'水吼镇',4,'',0,1,0,0),(17286,2272,'油坝乡',4,'',0,1,0,0),(17287,2272,'源潭镇',4,'',0,1,0,0),(17288,2272,'王河镇',4,'',0,1,0,0),(17289,2272,'痘姆乡',4,'',0,1,0,0),(17290,2272,'黄柏镇',4,'',0,1,0,0),(17291,2272,'黄泥镇',4,'',0,1,0,0),(17292,2272,'黄铺镇',4,'',0,1,0,0),(17293,2272,'龙潭乡',4,'',0,1,0,0),(17294,2273,'人民路街道',4,'',0,1,0,0),(17295,2273,'华中路街道',4,'',0,1,0,0),(17296,2273,'孝肃路街道',4,'',0,1,0,0),(17297,2273,'宜城路街道',4,'',0,1,0,0),(17298,2273,'建设路街道',4,'',0,1,0,0),(17299,2273,'新河路街道',4,'',0,1,0,0),(17300,2273,'新洲乡',4,'',0,1,0,0),(17301,2273,'老峰镇',4,'',0,1,0,0),(17302,2273,'长风乡',4,'',0,1,0,0),(17303,2273,'龙狮桥乡',4,'',0,1,0,0),(17304,2274,'万安镇',4,'',0,1,0,0),(17305,2274,'东临溪镇',4,'',0,1,0,0),(17306,2274,'五城镇',4,'',0,1,0,0),(17307,2274,'商山乡',4,'',0,1,0,0),(17308,2274,'山斗乡',4,'',0,1,0,0),(17309,2274,'岭南乡',4,'',0,1,0,0),(17310,2274,'板桥乡',4,'',0,1,0,0),(17311,2274,'榆村乡',4,'',0,1,0,0),(17312,2274,'汪村镇',4,'',0,1,0,0),(17313,2274,'流口镇',4,'',0,1,0,0),(17314,2274,'海阳镇',4,'',0,1,0,0),(17315,2274,'渭桥乡',4,'',0,1,0,0),(17316,2274,'源芳乡',4,'',0,1,0,0),(17317,2274,'溪口镇',4,'',0,1,0,0),(17318,2274,'璜尖乡',4,'',0,1,0,0),(17319,2274,'白际乡',4,'',0,1,0,0),(17320,2274,'蓝田镇',4,'',0,1,0,0),(17321,2274,'陈霞乡',4,'',0,1,0,0),(17322,2274,'鹤城乡',4,'',0,1,0,0),(17323,2274,'齐云山镇',4,'',0,1,0,0),(17324,2274,'龙田乡',4,'',0,1,0,0),(17325,2275,'奕棋镇',4,'',0,1,0,0),(17326,2275,'屯光镇',4,'',0,1,0,0),(17327,2275,'新潭镇',4,'',0,1,0,0),(17328,2275,'昱东街道',4,'',0,1,0,0),(17329,2275,'昱中街道',4,'',0,1,0,0),(17330,2275,'昱西街道',4,'',0,1,0,0),(17331,2275,'老街街道',4,'',0,1,0,0),(17332,2275,'阳湖镇',4,'',0,1,0,0),(17333,2275,'黎阳镇',4,'',0,1,0,0),(17334,2276,'呈坎镇',4,'',0,1,0,0),(17335,2276,'富溪乡',4,'',0,1,0,0),(17336,2276,'岩寺镇',4,'',0,1,0,0),(17337,2276,'徽州街道',4,'',0,1,0,0),(17338,2276,'杨村乡',4,'',0,1,0,0),(17339,2276,'洽舍乡',4,'',0,1,0,0),(17340,2276,'潜口镇',4,'',0,1,0,0),(17341,2276,'西溪南镇',4,'',0,1,0,0),(17342,2277,'三阳乡',4,'',0,1,0,0),(17343,2277,'上丰乡',4,'',0,1,0,0),(17344,2277,'北岸镇',4,'',0,1,0,0),(17345,2277,'坑口乡',4,'',0,1,0,0),(17346,2277,'富堨镇',4,'',0,1,0,0),(17347,2277,'小川乡',4,'',0,1,0,0),(17348,2277,'岔口镇',4,'',0,1,0,0),(17349,2277,'徽城镇',4,'',0,1,0,0),(17350,2277,'新溪口乡',4,'',0,1,0,0),(17351,2277,'昌溪乡',4,'',0,1,0,0),(17352,2277,'杞梓里镇',4,'',0,1,0,0),(17353,2277,'桂林镇',4,'',0,1,0,0),(17354,2277,'森村乡',4,'',0,1,0,0),(17355,2277,'武阳乡',4,'',0,1,0,0),(17356,2277,'深渡镇',4,'',0,1,0,0),(17357,2277,'溪头镇',4,'',0,1,0,0),(17358,2277,'狮石乡',4,'',0,1,0,0),(17359,2277,'王村镇',4,'',0,1,0,0),(17360,2277,'璜田乡',4,'',0,1,0,0),(17361,2277,'石门乡',4,'',0,1,0,0),(17362,2277,'绍濂乡',4,'',0,1,0,0),(17363,2277,'街口镇',4,'',0,1,0,0),(17364,2277,'许村镇',4,'',0,1,0,0),(17365,2277,'郑村镇',4,'',0,1,0,0),(17366,2277,'金川乡',4,'',0,1,0,0),(17367,2277,'长陔乡',4,'',0,1,0,0),(17368,2277,'雄村乡',4,'',0,1,0,0),(17369,2277,'霞坑镇',4,'',0,1,0,0),(17370,2278,'凫峰乡',4,'',0,1,0,0),(17371,2278,'历口镇',4,'',0,1,0,0),(17372,2278,'古溪乡',4,'',0,1,0,0),(17373,2278,'塔坊乡',4,'',0,1,0,0),(17374,2278,'大坦乡',4,'',0,1,0,0),(17375,2278,'安凌镇',4,'',0,1,0,0),(17376,2278,'小路口镇',4,'',0,1,0,0),(17377,2278,'平里镇',4,'',0,1,0,0),(17378,2278,'新安乡',4,'',0,1,0,0),(17379,2278,'柏溪乡',4,'',0,1,0,0),(17380,2278,'渚口乡',4,'',0,1,0,0),(17381,2278,'溶口乡',4,'',0,1,0,0),(17382,2278,'祁山镇',4,'',0,1,0,0),(17383,2278,'祁红乡',4,'',0,1,0,0),(17384,2278,'箬坑乡',4,'',0,1,0,0),(17385,2278,'芦溪乡',4,'',0,1,0,0),(17386,2278,'金字牌镇',4,'',0,1,0,0),(17387,2278,'闪里镇',4,'',0,1,0,0),(17388,2279,'三口镇',4,'',0,1,0,0),(17389,2279,'乌石乡',4,'',0,1,0,0),(17390,2279,'仙源镇',4,'',0,1,0,0),(17391,2279,'太平湖镇',4,'',0,1,0,0),(17392,2279,'新丰乡',4,'',0,1,0,0),(17393,2279,'新华乡',4,'',0,1,0,0),(17394,2279,'新城街道',4,'',0,1,0,0),(17395,2279,'新明乡',4,'',0,1,0,0),(17396,2279,'永丰乡',4,'',0,1,0,0),(17397,2279,'汤口镇',4,'',0,1,0,0),(17398,2279,'焦村镇',4,'',0,1,0,0),(17399,2279,'甘棠镇',4,'',0,1,0,0),(17400,2279,'耿城镇',4,'',0,1,0,0),(17401,2279,'谭家桥镇',4,'',0,1,0,0),(17402,2279,'龙门乡',4,'',0,1,0,0),(17403,2280,'宏村镇',4,'',0,1,0,0),(17404,2280,'宏潭乡',4,'',0,1,0,0),(17405,2280,'柯村乡',4,'',0,1,0,0),(17406,2280,'洪星乡',4,'',0,1,0,0),(17407,2280,'渔亭镇',4,'',0,1,0,0),(17408,2280,'碧阳镇',4,'',0,1,0,0),(17409,2280,'美溪乡',4,'',0,1,0,0),(17410,2280,'西递镇',4,'',0,1,0,0),(17411,2281,'二郎口镇',4,'',0,1,0,0),(17412,2281,'六镇镇',4,'',0,1,0,0),(17413,2281,'十字乡',4,'',0,1,0,0),(17414,2281,'古河镇',4,'',0,1,0,0),(17415,2281,'周岗乡',4,'',0,1,0,0),(17416,2281,'复兴乡',4,'',0,1,0,0),(17417,2281,'大墅镇',4,'',0,1,0,0),(17418,2281,'武岗镇',4,'',0,1,0,0),(17419,2281,'石沛镇',4,'',0,1,0,0),(17420,2281,'程家市乡',4,'',0,1,0,0),(17421,2281,'章辉镇',4,'',0,1,0,0),(17422,2281,'管坝乡',4,'',0,1,0,0),(17423,2281,'草庵乡',4,'',0,1,0,0),(17424,2281,'襄河镇',4,'',0,1,0,0),(17425,2281,'西王镇',4,'',0,1,0,0),(17426,2281,'陈浅乡',4,'',0,1,0,0),(17427,2281,'马厂镇',4,'',0,1,0,0),(17428,2282,'临淮镇',4,'',0,1,0,0),(17429,2282,'二铺乡',4,'',0,1,0,0),(17430,2282,'亮岗乡',4,'',0,1,0,0),(17431,2282,'刘府镇',4,'',0,1,0,0),(17432,2282,'周圩乡',4,'',0,1,0,0),(17433,2282,'城西乡',4,'',0,1,0,0),(17434,2282,'大庙镇',4,'',0,1,0,0),(17435,2282,'大溪河镇',4,'',0,1,0,0),(17436,2282,'官塘乡',4,'',0,1,0,0),(17437,2282,'官沟乡',4,'',0,1,0,0),(17438,2282,'小溪河镇',4,'',0,1,0,0),(17439,2282,'府城镇',4,'',0,1,0,0),(17440,2282,'总铺镇',4,'',0,1,0,0),(17441,2282,'曹店乡',4,'',0,1,0,0),(17442,2282,'板桥镇',4,'',0,1,0,0),(17443,2282,'枣巷渔业乡',4,'',0,1,0,0),(17444,2282,'梅市乡',4,'',0,1,0,0),(17445,2282,'武店镇',4,'',0,1,0,0),(17446,2282,'殷涧镇',4,'',0,1,0,0),(17447,2282,'燃灯乡',4,'',0,1,0,0),(17448,2282,'石门山镇',4,'',0,1,0,0),(17449,2282,'红心镇',4,'',0,1,0,0),(17450,2282,'西泉镇',4,'',0,1,0,0),(17451,2282,'门台镇',4,'',0,1,0,0),(17452,2282,'黄泥铺镇',4,'',0,1,0,0),(17453,2282,'黄湾乡',4,'',0,1,0,0),(17454,2283,'三官集乡',4,'',0,1,0,0),(17455,2283,'乌衣镇',4,'',0,1,0,0),(17456,2283,'南谯街道',4,'',0,1,0,0),(17457,2283,'城郊乡',4,'',0,1,0,0),(17458,2283,'大柳镇',4,'',0,1,0,0),(17459,2283,'大王镇',4,'',0,1,0,0),(17460,2283,'常山乡',4,'',0,1,0,0),(17461,2283,'施集乡',4,'',0,1,0,0),(17462,2283,'汪郢乡',4,'',0,1,0,0),(17463,2283,'沙河镇',4,'',0,1,0,0),(17464,2283,'珠龙镇',4,'',0,1,0,0),(17465,2283,'皇甫乡',4,'',0,1,0,0),(17466,2283,'章广镇',4,'',0,1,0,0),(17467,2283,'腰铺镇',4,'',0,1,0,0),(17468,2283,'花山乡',4,'',0,1,0,0),(17469,2283,'黄圩乡',4,'',0,1,0,0),(17470,2283,'黄泥岗镇',4,'',0,1,0,0),(17471,2284,'万寿乡',4,'',0,1,0,0),(17472,2284,'仁和集镇',4,'',0,1,0,0),(17473,2284,'便益乡',4,'',0,1,0,0),(17474,2284,'关塘集乡',4,'',0,1,0,0),(17475,2284,'冶山镇',4,'',0,1,0,0),(17476,2284,'十八集乡',4,'',0,1,0,0),(17477,2284,'城南街道',4,'',0,1,0,0),(17478,2284,'大通镇',4,'',0,1,0,0),(17479,2284,'天长街道',4,'',0,1,0,0),(17480,2284,'安乐镇',4,'',0,1,0,0),(17481,2284,'平安镇',4,'',0,1,0,0),(17482,2284,'张铺镇',4,'',0,1,0,0),(17483,2284,'新街乡',4,'',0,1,0,0),(17484,2284,'杨村镇',4,'',0,1,0,0),(17485,2284,'桥湾街道',4,'',0,1,0,0),(17486,2284,'永丰街道',4,'',0,1,0,0),(17487,2284,'汊涧镇',4,'',0,1,0,0),(17488,2284,'界牌镇',4,'',0,1,0,0),(17489,2284,'石梁镇',4,'',0,1,0,0),(17490,2284,'秦栏镇',4,'',0,1,0,0),(17491,2284,'芦龙乡',4,'',0,1,0,0),(17492,2284,'谕兴乡',4,'',0,1,0,0),(17493,2284,'郑集镇',4,'',0,1,0,0),(17494,2284,'金集镇',4,'',0,1,0,0),(17495,2284,'釜山镇',4,'',0,1,0,0),(17496,2284,'铜城镇',4,'',0,1,0,0),(17497,2284,'高庙集镇',4,'',0,1,0,0),(17498,2284,'龙集乡',4,'',0,1,0,0),(17499,2285,'七里塘乡',4,'',0,1,0,0),(17500,2285,'三和集镇',4,'',0,1,0,0),(17501,2285,'东兴乡',4,'',0,1,0,0),(17502,2285,'严桥乡',4,'',0,1,0,0),(17503,2285,'九梓乡',4,'',0,1,0,0),(17504,2285,'二龙回族乡',4,'',0,1,0,0),(17505,2285,'仁和乡',4,'',0,1,0,0),(17506,2285,'仓镇镇',4,'',0,1,0,0),(17507,2285,'吴圩镇',4,'',0,1,0,0),(17508,2285,'大桥乡',4,'',0,1,0,0),(17509,2285,'天河乡',4,'',0,1,0,0),(17510,2285,'定城镇',4,'',0,1,0,0),(17511,2285,'岱山镇',4,'',0,1,0,0),(17512,2285,'年家岗镇',4,'',0,1,0,0),(17513,2285,'张桥镇',4,'',0,1,0,0),(17514,2285,'拂晓乡',4,'',0,1,0,0),(17515,2285,'斋朗乡',4,'',0,1,0,0),(17516,2285,'朱湾镇',4,'',0,1,0,0),(17517,2285,'朱马乡',4,'',0,1,0,0),(17518,2285,'桑涧镇',4,'',0,1,0,0),(17519,2285,'永康镇',4,'',0,1,0,0),(17520,2285,'池河镇',4,'',0,1,0,0),(17521,2285,'炉桥镇',4,'',0,1,0,0),(17522,2285,'界牌集镇',4,'',0,1,0,0),(17523,2285,'程桥乡',4,'',0,1,0,0),(17524,2285,'站岗乡',4,'',0,1,0,0),(17525,2285,'练铺乡',4,'',0,1,0,0),(17526,2285,'能仁乡',4,'',0,1,0,0),(17527,2285,'范岗乡',4,'',0,1,0,0),(17528,2285,'蒋集乡',4,'',0,1,0,0),(17529,2285,'藕塘镇',4,'',0,1,0,0),(17530,2285,'西卅店镇',4,'',0,1,0,0),(17531,2285,'连江镇',4,'',0,1,0,0),(17532,2285,'青山乡',4,'',0,1,0,0),(17533,2285,'青洛乡',4,'',0,1,0,0),(17534,2285,'靠山乡',4,'',0,1,0,0),(17535,2285,'高塘乡',4,'',0,1,0,0),(17536,2286,'三关乡',4,'',0,1,0,0),(17537,2286,'三界镇',4,'',0,1,0,0),(17538,2286,'古沛镇',4,'',0,1,0,0),(17539,2286,'司巷乡',4,'',0,1,0,0),(17540,2286,'嘉山乡',4,'',0,1,0,0),(17541,2286,'城关街道',4,'',0,1,0,0),(17542,2286,'城北街道',4,'',0,1,0,0),(17543,2286,'城西街道',4,'',0,1,0,0),(17544,2286,'太平乡',4,'',0,1,0,0),(17545,2286,'女山湖镇',4,'',0,1,0,0),(17546,2286,'张八岭镇',4,'',0,1,0,0),(17547,2286,'招信镇',4,'',0,1,0,0),(17548,2286,'明东乡',4,'',0,1,0,0),(17549,2286,'柳巷乡',4,'',0,1,0,0),(17550,2286,'桥头镇',4,'',0,1,0,0),(17551,2286,'横山乡',4,'',0,1,0,0),(17552,2286,'泊岗乡',4,'',0,1,0,0),(17553,2286,'津里镇',4,'',0,1,0,0),(17554,2286,'涝口乡',4,'',0,1,0,0),(17555,2286,'涧溪镇',4,'',0,1,0,0),(17556,2286,'潘村镇',4,'',0,1,0,0),(17557,2286,'石坝镇',4,'',0,1,0,0),(17558,2286,'管店镇',4,'',0,1,0,0),(17559,2286,'紫阳乡',4,'',0,1,0,0),(17560,2286,'自来桥镇',4,'',0,1,0,0),(17561,2286,'苏巷镇',4,'',0,1,0,0),(17562,2286,'邵岗乡',4,'',0,1,0,0),(17563,2286,'马岗乡',4,'',0,1,0,0),(17564,2286,'鲁山乡',4,'',0,1,0,0),(17565,2287,'三城乡',4,'',0,1,0,0),(17566,2287,'兴隆乡',4,'',0,1,0,0),(17567,2287,'半塔镇',4,'',0,1,0,0),(17568,2287,'双塘乡',4,'',0,1,0,0),(17569,2287,'大英镇',4,'',0,1,0,0),(17570,2287,'张山乡',4,'',0,1,0,0),(17571,2287,'新安镇',4,'',0,1,0,0),(17572,2287,'施官镇',4,'',0,1,0,0),(17573,2287,'杨郢颖乡',4,'',0,1,0,0),(17574,2287,'武集乡',4,'',0,1,0,0),(17575,2287,'水口镇',4,'',0,1,0,0),(17576,2287,'汊河镇',4,'',0,1,0,0),(17577,2287,'独山乡',4,'',0,1,0,0),(17578,2287,'相官镇',4,'',0,1,0,0),(17579,2287,'舜山乡',4,'',0,1,0,0),(17580,2287,'邵集乡',4,'',0,1,0,0),(17581,2287,'雷官镇',4,'',0,1,0,0),(17582,2287,'龙山乡',4,'',0,1,0,0),(17583,2288,'东门街道',4,'',0,1,0,0),(17584,2288,'凤凰街道',4,'',0,1,0,0),(17585,2288,'北门街道',4,'',0,1,0,0),(17586,2288,'南门街道',4,'',0,1,0,0),(17587,2288,'扬子街道',4,'',0,1,0,0),(17588,2288,'清流街道',4,'',0,1,0,0),(17589,2288,'琅玡街道',4,'',0,1,0,0),(17590,2288,'西门街道',4,'',0,1,0,0),(17591,2289,'于寨镇',4,'',0,1,0,0),(17592,2289,'关庙镇',4,'',0,1,0,0),(17593,2289,'单桥镇',4,'',0,1,0,0),(17594,2289,'同城镇',4,'',0,1,0,0),(17595,2289,'吕寨镇',4,'',0,1,0,0),(17596,2289,'土陂乡',4,'',0,1,0,0),(17597,2289,'城关镇',4,'',0,1,0,0),(17598,2289,'姜寨镇',4,'',0,1,0,0),(17599,2289,'宋集镇',4,'',0,1,0,0),(17600,2289,'庙岔镇',4,'',0,1,0,0),(17601,2289,'庞营乡',4,'',0,1,0,0),(17602,2289,'张新镇',4,'',0,1,0,0),(17603,2289,'张营乡',4,'',0,1,0,0),(17604,2289,'杨小街乡',4,'',0,1,0,0),(17605,2289,'杨桥镇',4,'',0,1,0,0),(17606,2289,'滑集镇',4,'',0,1,0,0),(17607,2289,'牛庄乡',4,'',0,1,0,0),(17608,2289,'瓦店镇',4,'',0,1,0,0),(17609,2289,'田桥乡',4,'',0,1,0,0),(17610,2289,'白庙镇',4,'',0,1,0,0),(17611,2289,'老集镇',4,'',0,1,0,0),(17612,2289,'艾亭镇',4,'',0,1,0,0),(17613,2289,'范兴集乡',4,'',0,1,0,0),(17614,2289,'谢集乡',4,'',0,1,0,0),(17615,2289,'谭棚镇',4,'',0,1,0,0),(17616,2289,'迎仙镇',4,'',0,1,0,0),(17617,2289,'邢塘镇',4,'',0,1,0,0),(17618,2289,'长官镇',4,'',0,1,0,0),(17619,2289,'陈集镇',4,'',0,1,0,0),(17620,2289,'陶老乡',4,'',0,1,0,0),(17621,2289,'韦寨镇',4,'',0,1,0,0),(17622,2289,'高塘乡',4,'',0,1,0,0),(17623,2289,'黄岭镇',4,'',0,1,0,0),(17624,2290,'三堂镇',4,'',0,1,0,0),(17625,2290,'三塔镇',4,'',0,1,0,0),(17626,2290,'二郎乡',4,'',0,1,0,0),(17627,2290,'五星镇',4,'',0,1,0,0),(17628,2290,'倪邱镇',4,'',0,1,0,0),(17629,2290,'关集镇',4,'',0,1,0,0),(17630,2290,'原墙镇',4,'',0,1,0,0),(17631,2290,'双庙镇',4,'',0,1,0,0),(17632,2290,'双浮镇',4,'',0,1,0,0),(17633,2290,'坟台镇',4,'',0,1,0,0),(17634,2290,'城关镇',4,'',0,1,0,0),(17635,2290,'大庙集镇',4,'',0,1,0,0),(17636,2290,'大新镇',4,'',0,1,0,0),(17637,2290,'官集镇',4,'',0,1,0,0),(17638,2290,'旧县镇',4,'',0,1,0,0),(17639,2290,'李兴镇',4,'',0,1,0,0),(17640,2290,'桑营镇',4,'',0,1,0,0),(17641,2290,'洪山镇',4,'',0,1,0,0),(17642,2290,'清浅镇',4,'',0,1,0,0),(17643,2290,'皮条孙镇',4,'',0,1,0,0),(17644,2290,'税镇镇',4,'',0,1,0,0),(17645,2290,'肖口镇',4,'',0,1,0,0),(17646,2290,'胡总乡',4,'',0,1,0,0),(17647,2290,'苗老集镇',4,'',0,1,0,0),(17648,2290,'蔡庙镇',4,'',0,1,0,0),(17649,2290,'赵庙镇',4,'',0,1,0,0),(17650,2290,'赵集乡',4,'',0,1,0,0),(17651,2290,'郭庙乡',4,'',0,1,0,0),(17652,2290,'阮桥镇',4,'',0,1,0,0),(17653,2290,'马集乡',4,'',0,1,0,0),(17654,2290,'高庙镇',4,'',0,1,0,0),(17655,2291,'东城街道',4,'',0,1,0,0),(17656,2291,'任寨乡',4,'',0,1,0,0),(17657,2291,'光武镇',4,'',0,1,0,0),(17658,2291,'大黄镇',4,'',0,1,0,0),(17659,2291,'戴桥镇',4,'',0,1,0,0),(17660,2291,'新马集镇',4,'',0,1,0,0),(17661,2291,'泉阳镇',4,'',0,1,0,0),(17662,2291,'王集镇',4,'',0,1,0,0),(17663,2291,'田营镇',4,'',0,1,0,0),(17664,2291,'砖集镇',4,'',0,1,0,0),(17665,2291,'舒庄镇',4,'',0,1,0,0),(17666,2291,'芦村镇',4,'',0,1,0,0),(17667,2291,'西城街道',4,'',0,1,0,0),(17668,2291,'邴集乡',4,'',0,1,0,0),(17669,2291,'陶庙镇',4,'',0,1,0,0),(17670,2291,'靳寨乡',4,'',0,1,0,0),(17671,2291,'顾集镇',4,'',0,1,0,0),(17672,2291,'颍南街道',4,'',0,1,0,0),(17673,2292,'三塔集镇',4,'',0,1,0,0),(17674,2292,'中岗镇',4,'',0,1,0,0),(17675,2292,'于集乡',4,'',0,1,0,0),(17676,2292,'会龙乡',4,'',0,1,0,0),(17677,2292,'公桥乡',4,'',0,1,0,0),(17678,2292,'地城镇',4,'',0,1,0,0),(17679,2292,'城关镇',4,'',0,1,0,0),(17680,2292,'城郊乡',4,'',0,1,0,0),(17681,2292,'张寨镇',4,'',0,1,0,0),(17682,2292,'新村镇',4,'',0,1,0,0),(17683,2292,'方集镇',4,'',0,1,0,0),(17684,2292,'曹集镇',4,'',0,1,0,0),(17685,2292,'朱寨镇',4,'',0,1,0,0),(17686,2292,'柳沟镇',4,'',0,1,0,0),(17687,2292,'柴集镇',4,'',0,1,0,0),(17688,2292,'段郢乡',4,'',0,1,0,0),(17689,2292,'洪河桥镇',4,'',0,1,0,0),(17690,2292,'焦陂镇',4,'',0,1,0,0),(17691,2292,'王化镇',4,'',0,1,0,0),(17692,2292,'王堰镇',4,'',0,1,0,0),(17693,2292,'王家坝镇',4,'',0,1,0,0),(17694,2292,'王店孜乡',4,'',0,1,0,0),(17695,2292,'田集镇',4,'',0,1,0,0),(17696,2292,'老观乡',4,'',0,1,0,0),(17697,2292,'苗集镇',4,'',0,1,0,0),(17698,2292,'袁集镇',4,'',0,1,0,0),(17699,2292,'许堂乡',4,'',0,1,0,0),(17700,2292,'赵集镇',4,'',0,1,0,0),(17701,2292,'郜台乡',4,'',0,1,0,0),(17702,2292,'阜蒙农场',4,'',0,1,0,0),(17703,2292,'黄岗镇',4,'',0,1,0,0),(17704,2292,'龙王乡',4,'',0,1,0,0),(17705,2293,'冉庙乡',4,'',0,1,0,0),(17706,2293,'口孜镇',4,'',0,1,0,0),(17707,2293,'向阳街道',4,'',0,1,0,0),(17708,2293,'插花镇',4,'',0,1,0,0),(17709,2293,'新乌江镇',4,'',0,1,0,0),(17710,2293,'新华街道',4,'',0,1,0,0),(17711,2293,'杨楼孜镇',4,'',0,1,0,0),(17712,2293,'枣庄镇',4,'',0,1,0,0),(17713,2293,'正午镇',4,'',0,1,0,0),(17714,2293,'河东街道',4,'',0,1,0,0),(17715,2293,'老庙镇',4,'',0,1,0,0),(17716,2293,'袁寨镇',4,'',0,1,0,0),(17717,2294,'三十里铺镇',4,'',0,1,0,0),(17718,2294,'三合镇',4,'',0,1,0,0),(17719,2294,'九龙镇',4,'',0,1,0,0),(17720,2294,'京九街道',4,'',0,1,0,0),(17721,2294,'文峰街道',4,'',0,1,0,0),(17722,2294,'清河街道',4,'',0,1,0,0),(17723,2294,'王店镇',4,'',0,1,0,0),(17724,2294,'程集镇',4,'',0,1,0,0),(17725,2294,'西湖景区街道',4,'',0,1,0,0),(17726,2294,'西湖镇',4,'',0,1,0,0),(17727,2294,'颍西街道',4,'',0,1,0,0),(17728,2294,'马寨乡',4,'',0,1,0,0),(17729,2294,'鼓楼街道',4,'',0,1,0,0),(17730,2295,'中市街道',4,'',0,1,0,0),(17731,2295,'伍明镇',4,'',0,1,0,0),(17732,2295,'周棚街道',4,'',0,1,0,0),(17733,2295,'宁老庄镇',4,'',0,1,0,0),(17734,2295,'行流镇',4,'',0,1,0,0),(17735,2295,'闻集镇',4,'',0,1,0,0),(17736,2296,'五十铺乡',4,'',0,1,0,0),(17737,2296,'八里河镇',4,'',0,1,0,0),(17738,2296,'六十铺镇',4,'',0,1,0,0),(17739,2296,'关屯乡',4,'',0,1,0,0),(17740,2296,'刘集乡',4,'',0,1,0,0),(17741,2296,'十八里铺镇',4,'',0,1,0,0),(17742,2296,'半岗镇',4,'',0,1,0,0),(17743,2296,'南照镇',4,'',0,1,0,0),(17744,2296,'古城乡',4,'',0,1,0,0),(17745,2296,'垂岗乡',4,'',0,1,0,0),(17746,2296,'城关镇',4,'',0,1,0,0),(17747,2296,'夏桥镇',4,'',0,1,0,0),(17748,2296,'建颍乡',4,'',0,1,0,0),(17749,2296,'新集镇',4,'',0,1,0,0),(17750,2296,'杨湖镇',4,'',0,1,0,0),(17751,2296,'江口镇',4,'',0,1,0,0),(17752,2296,'江店孜镇',4,'',0,1,0,0),(17753,2296,'汤店镇',4,'',0,1,0,0),(17754,2296,'润河镇',4,'',0,1,0,0),(17755,2296,'王岗镇',4,'',0,1,0,0),(17756,2296,'盛堂乡',4,'',0,1,0,0),(17757,2296,'红星镇',4,'',0,1,0,0),(17758,2296,'耿棚镇',4,'',0,1,0,0),(17759,2296,'西三十铺镇',4,'',0,1,0,0),(17760,2296,'谢桥镇',4,'',0,1,0,0),(17761,2296,'赛涧回族乡',4,'',0,1,0,0),(17762,2296,'陈桥镇',4,'',0,1,0,0),(17763,2296,'颖河乡',4,'',0,1,0,0),(17764,2296,'鲁口镇',4,'',0,1,0,0),(17765,2296,'黄坝乡',4,'',0,1,0,0),(17766,2296,'黄桥镇',4,'',0,1,0,0),(17767,2297,'三八街道',4,'',0,1,0,0),(17768,2297,'三里湾街道',4,'',0,1,0,0),(17769,2297,'东关街道',4,'',0,1,0,0),(17770,2297,'北关街道',4,'',0,1,0,0),(17771,2297,'南关街道',4,'',0,1,0,0),(17772,2297,'城东街道',4,'',0,1,0,0),(17773,2297,'墉桥街道',4,'',0,1,0,0),(17774,2297,'大店镇',4,'',0,1,0,0),(17775,2297,'大营镇',4,'',0,1,0,0),(17776,2297,'夹沟镇',4,'',0,1,0,0),(17777,2297,'支河乡',4,'',0,1,0,0),(17778,2297,'时村镇',4,'',0,1,0,0),(17779,2297,'曹村镇',4,'',0,1,0,0),(17780,2297,'朱仙庄镇',4,'',0,1,0,0),(17781,2297,'杨庄乡',4,'',0,1,0,0),(17782,2297,'栏杆镇',4,'',0,1,0,0),(17783,2297,'桃园镇',4,'',0,1,0,0),(17784,2297,'桃沟乡',4,'',0,1,0,0),(17785,2297,'永安镇',4,'',0,1,0,0),(17786,2297,'永镇乡',4,'',0,1,0,0),(17787,2297,'汴河街道',4,'',0,1,0,0),(17788,2297,'沱河街道',4,'',0,1,0,0),(17789,2297,'灰古镇',4,'',0,1,0,0),(17790,2297,'符离集镇',4,'',0,1,0,0),(17791,2297,'芦岭镇',4,'',0,1,0,0),(17792,2297,'苗庵乡',4,'',0,1,0,0),(17793,2297,'蒿沟乡',4,'',0,1,0,0),(17794,2297,'蕲县镇',4,'',0,1,0,0),(17795,2297,'褚兰镇',4,'',0,1,0,0),(17796,2297,'西二铺乡',4,'',0,1,0,0),(17797,2297,'西关街道',4,'',0,1,0,0),(17798,2297,'西寺坡镇',4,'',0,1,0,0),(17799,2297,'解集乡',4,'',0,1,0,0),(17800,2297,'道东街道',4,'',0,1,0,0),(17801,2297,'顺河乡',4,'',0,1,0,0),(17802,2298,'丁湖镇',4,'',0,1,0,0),(17803,2298,'刘圩镇',4,'',0,1,0,0),(17804,2298,'墩集镇',4,'',0,1,0,0),(17805,2298,'大庄镇',4,'',0,1,0,0),(17806,2298,'大杨乡',4,'',0,1,0,0),(17807,2298,'大路口乡',4,'',0,1,0,0),(17808,2298,'屏山镇',4,'',0,1,0,0),(17809,2298,'山头镇',4,'',0,1,0,0),(17810,2298,'泗城镇',4,'',0,1,0,0),(17811,2298,'瓦坊乡',4,'',0,1,0,0),(17812,2298,'草庙镇',4,'',0,1,0,0),(17813,2298,'草沟镇',4,'',0,1,0,0),(17814,2298,'长沟镇',4,'',0,1,0,0),(17815,2298,'黄圩镇',4,'',0,1,0,0),(17816,2298,'黑塔镇',4,'',0,1,0,0),(17817,2299,'下楼镇',4,'',0,1,0,0),(17818,2299,'冯庙镇',4,'',0,1,0,0),(17819,2299,'向阳乡',4,'',0,1,0,0),(17820,2299,'大庙乡',4,'',0,1,0,0),(17821,2299,'大路乡',4,'',0,1,0,0),(17822,2299,'娄庄镇',4,'',0,1,0,0),(17823,2299,'尤集镇',4,'',0,1,0,0),(17824,2299,'尹集镇',4,'',0,1,0,0),(17825,2299,'朝阳镇',4,'',0,1,0,0),(17826,2299,'朱集乡',4,'',0,1,0,0),(17827,2299,'杨疃镇',4,'',0,1,0,0),(17828,2299,'浍沟镇',4,'',0,1,0,0),(17829,2299,'渔沟镇',4,'',0,1,0,0),(17830,2299,'灵城镇',4,'',0,1,0,0),(17831,2299,'禅堂乡',4,'',0,1,0,0),(17832,2299,'虞姬乡',4,'',0,1,0,0),(17833,2299,'韦集镇',4,'',0,1,0,0),(17834,2299,'高楼镇',4,'',0,1,0,0),(17835,2299,'黄湾镇',4,'',0,1,0,0),(17836,2300,'关帝庙镇',4,'',0,1,0,0),(17837,2300,'刘暗楼乡',4,'',0,1,0,0),(17838,2300,'周寨镇',4,'',0,1,0,0),(17839,2300,'唐寨镇',4,'',0,1,0,0),(17840,2300,'官庄坝镇',4,'',0,1,0,0),(17841,2300,'文庄镇',4,'',0,1,0,0),(17842,2300,'曹庄镇',4,'',0,1,0,0),(17843,2300,'朱楼镇',4,'',0,1,0,0),(17844,2300,'权集乡',4,'',0,1,0,0),(17845,2300,'李庄镇',4,'',0,1,0,0),(17846,2300,'玄庙镇',4,'',0,1,0,0),(17847,2300,'砀城镇',4,'',0,1,0,0),(17848,2300,'程庄镇',4,'',0,1,0,0),(17849,2300,'良梨镇',4,'',0,1,0,0),(17850,2300,'葛集镇',4,'',0,1,0,0),(17851,2300,'西南门镇',4,'',0,1,0,0),(17852,2300,'赵屯乡',4,'',0,1,0,0),(17853,2300,'黄楼乡',4,'',0,1,0,0),(17854,2301,'丁里镇',4,'',0,1,0,0),(17855,2301,'刘套镇',4,'',0,1,0,0),(17856,2301,'圣泉乡',4,'',0,1,0,0),(17857,2301,'大屯镇',4,'',0,1,0,0),(17858,2301,'官桥镇',4,'',0,1,0,0),(17859,2301,'庄里乡',4,'',0,1,0,0),(17860,2301,'张庄寨镇',4,'',0,1,0,0),(17861,2301,'新庄镇',4,'',0,1,0,0),(17862,2301,'杜楼镇',4,'',0,1,0,0),(17863,2301,'杨楼镇',4,'',0,1,0,0),(17864,2301,'永堌镇',4,'',0,1,0,0),(17865,2301,'王寨镇',4,'',0,1,0,0),(17866,2301,'白土镇',4,'',0,1,0,0),(17867,2301,'祖楼镇',4,'',0,1,0,0),(17868,2301,'赵庄镇',4,'',0,1,0,0),(17869,2301,'阎集镇',4,'',0,1,0,0),(17870,2301,'青龙集镇',4,'',0,1,0,0),(17871,2301,'马井镇',4,'',0,1,0,0),(17872,2301,'黄口镇',4,'',0,1,0,0),(17873,2301,'龙城镇',4,'',0,1,0,0),(17874,2302,'仙踪镇',4,'',0,1,0,0),(17875,2302,'昭关镇',4,'',0,1,0,0),(17876,2302,'林头镇',4,'',0,1,0,0),(17877,2302,'清溪镇',4,'',0,1,0,0),(17878,2302,'环峰镇',4,'',0,1,0,0),(17879,2302,'运漕镇',4,'',0,1,0,0),(17880,2302,'铜闸镇',4,'',0,1,0,0),(17881,2302,'陶厂镇',4,'',0,1,0,0),(17882,2303,'乌江镇',4,'',0,1,0,0),(17883,2303,'功桥镇',4,'',0,1,0,0),(17884,2303,'历阳镇',4,'',0,1,0,0),(17885,2303,'善厚镇',4,'',0,1,0,0),(17886,2303,'姥桥镇',4,'',0,1,0,0),(17887,2303,'沈巷镇',4,'',0,1,0,0),(17888,2303,'白桥镇',4,'',0,1,0,0),(17889,2303,'石杨镇',4,'',0,1,0,0),(17890,2303,'西埠镇',4,'',0,1,0,0),(17891,2303,'香泉镇',4,'',0,1,0,0),(17892,2304,'中垾镇',4,'',0,1,0,0),(17893,2304,'中庙街道',4,'',0,1,0,0),(17894,2304,'亚父街道',4,'',0,1,0,0),(17895,2304,'凤凰山街道',4,'',0,1,0,0),(17896,2304,'半汤街道',4,'',0,1,0,0),(17897,2304,'卧牛山街道',4,'',0,1,0,0),(17898,2304,'坝镇镇',4,'',0,1,0,0),(17899,2304,'夏阁镇',4,'',0,1,0,0),(17900,2304,'天河街道',4,'',0,1,0,0),(17901,2304,'庙岗乡',4,'',0,1,0,0),(17902,2304,'散兵镇',4,'',0,1,0,0),(17903,2304,'柘皋镇',4,'',0,1,0,0),(17904,2304,'栏杆集镇',4,'',0,1,0,0),(17905,2304,'槐林镇',4,'',0,1,0,0),(17906,2304,'炯炀镇',4,'',0,1,0,0),(17907,2304,'苏湾镇',4,'',0,1,0,0),(17908,2304,'银屏镇',4,'',0,1,0,0),(17909,2304,'黄麓镇',4,'',0,1,0,0),(17910,2305,'万山镇',4,'',0,1,0,0),(17911,2305,'乐桥镇',4,'',0,1,0,0),(17912,2305,'冶父山镇',4,'',0,1,0,0),(17913,2305,'同大镇',4,'',0,1,0,0),(17914,2305,'庐城镇',4,'',0,1,0,0),(17915,2305,'柯坦镇',4,'',0,1,0,0),(17916,2305,'汤池镇',4,'',0,1,0,0),(17917,2305,'泥河镇',4,'',0,1,0,0),(17918,2305,'白山镇',4,'',0,1,0,0),(17919,2305,'白湖镇',4,'',0,1,0,0),(17920,2305,'盛桥镇',4,'',0,1,0,0),(17921,2305,'石头镇',4,'',0,1,0,0),(17922,2305,'矾山镇',4,'',0,1,0,0),(17923,2305,'罗河镇',4,'',0,1,0,0),(17924,2305,'郭河镇',4,'',0,1,0,0),(17925,2305,'金牛镇',4,'',0,1,0,0),(17926,2305,'龙桥镇',4,'',0,1,0,0),(17927,2306,'严桥镇',4,'',0,1,0,0),(17928,2306,'二坝镇',4,'',0,1,0,0),(17929,2306,'刘渡镇',4,'',0,1,0,0),(17930,2306,'十里墩乡',4,'',0,1,0,0),(17931,2306,'姚沟镇',4,'',0,1,0,0),(17932,2306,'开城镇',4,'',0,1,0,0),(17933,2306,'无城镇',4,'',0,1,0,0),(17934,2306,'昆山乡',4,'',0,1,0,0),(17935,2306,'汤沟镇',4,'',0,1,0,0),(17936,2306,'泉塘镇',4,'',0,1,0,0),(17937,2306,'泥汊镇',4,'',0,1,0,0),(17938,2306,'洪巷乡',4,'',0,1,0,0),(17939,2306,'牛埠镇',4,'',0,1,0,0),(17940,2306,'白茆镇',4,'',0,1,0,0),(17941,2306,'石涧镇',4,'',0,1,0,0),(17942,2306,'福渡镇',4,'',0,1,0,0),(17943,2306,'红庙镇',4,'',0,1,0,0),(17944,2306,'蜀山镇',4,'',0,1,0,0),(17945,2306,'襄安镇',4,'',0,1,0,0),(17946,2306,'赫店镇',4,'',0,1,0,0),(17947,2306,'陡沟镇',4,'',0,1,0,0),(17948,2306,'高沟镇',4,'',0,1,0,0),(17949,2306,'鹤毛乡',4,'',0,1,0,0),(17950,2307,'三觉镇',4,'',0,1,0,0),(17951,2307,'丰庄镇',4,'',0,1,0,0),(17952,2307,'众兴镇',4,'',0,1,0,0),(17953,2307,'保义农场',4,'',0,1,0,0),(17954,2307,'保义镇',4,'',0,1,0,0),(17955,2307,'八公山乡',4,'',0,1,0,0),(17956,2307,'刘岗镇',4,'',0,1,0,0),(17957,2307,'双庙集镇',4,'',0,1,0,0),(17958,2307,'双桥镇',4,'',0,1,0,0),(17959,2307,'堰口镇',4,'',0,1,0,0),(17960,2307,'大顺镇',4,'',0,1,0,0),(17961,2307,'安丰塘镇',4,'',0,1,0,0),(17962,2307,'安丰镇',4,'',0,1,0,0),(17963,2307,'寿春镇',4,'',0,1,0,0),(17964,2307,'寿西湖农场',4,'',0,1,0,0),(17965,2307,'小甸镇',4,'',0,1,0,0),(17966,2307,'张李乡',4,'',0,1,0,0),(17967,2307,'板桥镇',4,'',0,1,0,0),(17968,2307,'正阳关农场',4,'',0,1,0,0),(17969,2307,'正阳关镇',4,'',0,1,0,0),(17970,2307,'涧沟镇',4,'',0,1,0,0),(17971,2307,'炎刘镇',4,'',0,1,0,0),(17972,2307,'瓦埠镇',4,'',0,1,0,0),(17973,2307,'窑口乡',4,'',0,1,0,0),(17974,2307,'茶庵镇',4,'',0,1,0,0),(17975,2307,'迎河镇',4,'',0,1,0,0),(17976,2307,'陶店回族乡',4,'',0,1,0,0),(17977,2307,'隐贤镇',4,'',0,1,0,0),(17978,2308,'万佛湖镇',4,'',0,1,0,0),(17979,2308,'五显镇',4,'',0,1,0,0),(17980,2308,'千人桥镇',4,'',0,1,0,0),(17981,2308,'南港镇',4,'',0,1,0,0),(17982,2308,'县经济技术开发区',4,'',0,1,0,0),(17983,2308,'城关镇',4,'',0,1,0,0),(17984,2308,'山七镇',4,'',0,1,0,0),(17985,2308,'干汊河镇',4,'',0,1,0,0),(17986,2308,'庐镇乡',4,'',0,1,0,0),(17987,2308,'张母桥镇',4,'',0,1,0,0),(17988,2308,'春秋乡',4,'',0,1,0,0),(17989,2308,'晓天镇',4,'',0,1,0,0),(17990,2308,'杭埠镇',4,'',0,1,0,0),(17991,2308,'柏林乡',4,'',0,1,0,0),(17992,2308,'桃溪镇',4,'',0,1,0,0),(17993,2308,'棠树乡',4,'',0,1,0,0),(17994,2308,'汤池镇',4,'',0,1,0,0),(17995,2308,'河棚镇',4,'',0,1,0,0),(17996,2308,'百神庙镇',4,'',0,1,0,0),(17997,2308,'舒茶镇',4,'',0,1,0,0),(17998,2308,'阙店乡',4,'',0,1,0,0),(17999,2308,'高峰乡',4,'',0,1,0,0),(18000,2309,'丁集镇',4,'',0,1,0,0),(18001,2309,'分路口镇',4,'',0,1,0,0),(18002,2309,'北市街道',4,'',0,1,0,0),(18003,2309,'单王乡',4,'',0,1,0,0),(18004,2309,'南市街道',4,'',0,1,0,0),(18005,2309,'固镇镇',4,'',0,1,0,0),(18006,2309,'城南镇',4,'',0,1,0,0),(18007,2309,'小华山街道',4,'',0,1,0,0),(18008,2309,'平桥乡',4,'',0,1,0,0),(18009,2309,'徐集镇',4,'',0,1,0,0),(18010,2309,'新安镇',4,'',0,1,0,0),(18011,2309,'江家店镇',4,'',0,1,0,0),(18012,2309,'独山镇',4,'',0,1,0,0),(18013,2309,'狮子岗乡',4,'',0,1,0,0),(18014,2309,'石婆店镇',4,'',0,1,0,0),(18015,2309,'石板冲乡',4,'',0,1,0,0),(18016,2309,'罗集乡',4,'',0,1,0,0),(18017,2309,'苏埠镇',4,'',0,1,0,0),(18018,2309,'西市街道',4,'',0,1,0,0),(18019,2309,'西河口乡',4,'',0,1,0,0),(18020,2309,'青山乡',4,'',0,1,0,0),(18021,2309,'韩摆渡镇',4,'',0,1,0,0),(18022,2309,'顺河镇',4,'',0,1,0,0),(18023,2309,'鼓楼街道',4,'',0,1,0,0),(18024,2310,'三十铺镇',4,'',0,1,0,0),(18025,2310,'三里桥街道',4,'',0,1,0,0),(18026,2310,'东市街道',4,'',0,1,0,0),(18027,2310,'东桥镇',4,'',0,1,0,0),(18028,2310,'东河口镇',4,'',0,1,0,0),(18029,2310,'中市街道',4,'',0,1,0,0),(18030,2310,'中店乡',4,'',0,1,0,0),(18031,2310,'先生店乡',4,'',0,1,0,0),(18032,2310,'双河镇',4,'',0,1,0,0),(18033,2310,'城北乡',4,'',0,1,0,0),(18034,2310,'孙岗镇',4,'',0,1,0,0),(18035,2310,'张店镇',4,'',0,1,0,0),(18036,2310,'施桥镇',4,'',0,1,0,0),(18037,2310,'望城街道',4,'',0,1,0,0),(18038,2310,'木厂镇',4,'',0,1,0,0),(18039,2310,'椿树镇',4,'',0,1,0,0),(18040,2310,'横塘岗乡',4,'',0,1,0,0),(18041,2310,'毛坦厂镇',4,'',0,1,0,0),(18042,2310,'淠东乡',4,'',0,1,0,0),(18043,2310,'清水河街道',4,'',0,1,0,0),(18044,2310,'翁墩乡',4,'',0,1,0,0),(18045,2310,'马头镇',4,'',0,1,0,0),(18046,2311,'全军乡',4,'',0,1,0,0),(18047,2311,'关庙乡',4,'',0,1,0,0),(18048,2311,'南溪镇',4,'',0,1,0,0),(18049,2311,'双河镇',4,'',0,1,0,0),(18050,2311,'古碑镇',4,'',0,1,0,0),(18051,2311,'吴家店镇',4,'',0,1,0,0),(18052,2311,'响洪甸镇',4,'',0,1,0,0),(18053,2311,'天堂寨镇',4,'',0,1,0,0),(18054,2311,'张冲乡',4,'',0,1,0,0),(18055,2311,'张畈乡',4,'',0,1,0,0),(18056,2311,'斑竹园镇',4,'',0,1,0,0),(18057,2311,'果子园乡',4,'',0,1,0,0),(18058,2311,'桃岭乡',4,'',0,1,0,0),(18059,2311,'梅山镇',4,'',0,1,0,0),(18060,2311,'槐树湾乡',4,'',0,1,0,0),(18061,2311,'水竹萍乡',4,'',0,1,0,0),(18062,2311,'汤家汇镇',4,'',0,1,0,0),(18063,2311,'沙河乡',4,'',0,1,0,0),(18064,2311,'油坊店乡',4,'',0,1,0,0),(18065,2311,'燕子河镇',4,'',0,1,0,0),(18066,2311,'白塔畈乡',4,'',0,1,0,0),(18067,2311,'花石乡',4,'',0,1,0,0),(18068,2311,'铁冲乡',4,'',0,1,0,0),(18069,2311,'银山畈乡',4,'',0,1,0,0),(18070,2311,'长岭乡',4,'',0,1,0,0),(18071,2311,'青山镇',4,'',0,1,0,0),(18072,2312,'上士市镇',4,'',0,1,0,0),(18073,2312,'下符桥镇',4,'',0,1,0,0),(18074,2312,'与儿街镇',4,'',0,1,0,0),(18075,2312,'东西溪乡',4,'',0,1,0,0),(18076,2312,'但家庙镇',4,'',0,1,0,0),(18077,2312,'佛子岭镇',4,'',0,1,0,0),(18078,2312,'单龙寺乡',4,'',0,1,0,0),(18079,2312,'大化坪镇',4,'',0,1,0,0),(18080,2312,'太平畈乡',4,'',0,1,0,0),(18081,2312,'太阳乡',4,'',0,1,0,0),(18082,2312,'漫水河镇',4,'',0,1,0,0),(18083,2312,'磨子潭镇',4,'',0,1,0,0),(18084,2312,'落儿岭镇',4,'',0,1,0,0),(18085,2312,'衡山镇',4,'',0,1,0,0),(18086,2312,'诸佛庵镇',4,'',0,1,0,0),(18087,2312,'黑石渡镇',4,'',0,1,0,0),(18088,2313,'三流乡',4,'',0,1,0,0),(18089,2313,'临水镇',4,'',0,1,0,0),(18090,2313,'临淮岗乡',4,'',0,1,0,0),(18091,2313,'乌龙镇',4,'',0,1,0,0),(18092,2313,'众兴集镇',4,'',0,1,0,0),(18093,2313,'冯井镇',4,'',0,1,0,0),(18094,2313,'冯瓴乡',4,'',0,1,0,0),(18095,2313,'城关镇',4,'',0,1,0,0),(18096,2313,'城西湖乡',4,'',0,1,0,0),(18097,2313,'夏店镇',4,'',0,1,0,0),(18098,2313,'姚李镇',4,'',0,1,0,0),(18099,2313,'孟集镇',4,'',0,1,0,0),(18100,2313,'宋店乡',4,'',0,1,0,0),(18101,2313,'岔路镇',4,'',0,1,0,0),(18102,2313,'彭塔乡',4,'',0,1,0,0),(18103,2313,'扈胡镇',4,'',0,1,0,0),(18104,2313,'新店镇',4,'',0,1,0,0),(18105,2313,'曹庙镇',4,'',0,1,0,0),(18106,2313,'河口镇',4,'',0,1,0,0),(18107,2313,'洪集镇',4,'',0,1,0,0),(18108,2313,'潘集乡',4,'',0,1,0,0),(18109,2313,'王截流乡',4,'',0,1,0,0),(18110,2313,'白莲乡',4,'',0,1,0,0),(18111,2313,'石店镇',4,'',0,1,0,0),(18112,2313,'花园镇',4,'',0,1,0,0),(18113,2313,'范桥乡',4,'',0,1,0,0),(18114,2313,'邵岗乡',4,'',0,1,0,0),(18115,2313,'长集镇',4,'',0,1,0,0),(18116,2313,'马店镇',4,'',0,1,0,0),(18117,2313,'高塘镇',4,'',0,1,0,0),(18118,2313,'龙潭镇',4,'',0,1,0,0),(18119,2314,'中疃镇',4,'',0,1,0,0),(18120,2314,'丹风乡',4,'',0,1,0,0),(18121,2314,'刘家集乡',4,'',0,1,0,0),(18122,2314,'双桥乡',4,'',0,1,0,0),(18123,2314,'城关镇',4,'',0,1,0,0),(18124,2314,'大李集镇',4,'',0,1,0,0),(18125,2314,'孙庙乡',4,'',0,1,0,0),(18126,2314,'孙集镇',4,'',0,1,0,0),(18127,2314,'展沟镇',4,'',0,1,0,0),(18128,2314,'巩店镇',4,'',0,1,0,0),(18129,2314,'张村镇',4,'',0,1,0,0),(18130,2314,'新张集乡',4,'',0,1,0,0),(18131,2314,'旧城镇',4,'',0,1,0,0),(18132,2314,'春店乡',4,'',0,1,0,0),(18133,2314,'望疃镇',4,'',0,1,0,0),(18134,2314,'永兴镇',4,'',0,1,0,0),(18135,2314,'汝集镇',4,'',0,1,0,0),(18136,2314,'江集镇',4,'',0,1,0,0),(18137,2314,'王人镇',4,'',0,1,0,0),(18138,2314,'王市镇',4,'',0,1,0,0),(18139,2314,'程家集镇',4,'',0,1,0,0),(18140,2314,'纪王场乡',4,'',0,1,0,0),(18141,2314,'胡集镇',4,'',0,1,0,0),(18142,2314,'西潘楼镇',4,'',0,1,0,0),(18143,2314,'阚疃镇',4,'',0,1,0,0),(18144,2314,'马店孜镇',4,'',0,1,0,0),(18145,2315,'临湖镇',4,'',0,1,0,0),(18146,2315,'丹城镇',4,'',0,1,0,0),(18147,2315,'义门镇',4,'',0,1,0,0),(18148,2315,'公吉寺镇',4,'',0,1,0,0),(18149,2315,'单集林场',4,'',0,1,0,0),(18150,2315,'双庙镇',4,'',0,1,0,0),(18151,2315,'城东镇',4,'',0,1,0,0),(18152,2315,'城关镇',4,'',0,1,0,0),(18153,2315,'城西镇',4,'',0,1,0,0),(18154,2315,'店集镇',4,'',0,1,0,0),(18155,2315,'张老家乡',4,'',0,1,0,0),(18156,2315,'新兴镇',4,'',0,1,0,0),(18157,2315,'曹市镇',4,'',0,1,0,0),(18158,2315,'标里镇',4,'',0,1,0,0),(18159,2315,'楚店镇',4,'',0,1,0,0),(18160,2315,'牌坊镇',4,'',0,1,0,0),(18161,2315,'石弓镇',4,'',0,1,0,0),(18162,2315,'耿皇乡',4,'',0,1,0,0),(18163,2315,'花沟镇',4,'',0,1,0,0),(18164,2315,'西阳镇',4,'',0,1,0,0),(18165,2315,'闸北镇',4,'',0,1,0,0),(18166,2315,'陈大镇',4,'',0,1,0,0),(18167,2315,'青疃镇',4,'',0,1,0,0),(18168,2315,'马店集镇',4,'',0,1,0,0),(18169,2315,'高公镇',4,'',0,1,0,0),(18170,2315,'高炉镇',4,'',0,1,0,0),(18171,2315,'龙山镇',4,'',0,1,0,0),(18172,2316,'三义镇',4,'',0,1,0,0),(18173,2316,'乐土镇',4,'',0,1,0,0),(18174,2316,'双涧镇',4,'',0,1,0,0),(18175,2316,'吕望乡',4,'',0,1,0,0),(18176,2316,'坛城镇',4,'',0,1,0,0),(18177,2316,'城关镇',4,'',0,1,0,0),(18178,2316,'小涧镇',4,'',0,1,0,0),(18179,2316,'小辛集乡',4,'',0,1,0,0),(18180,2316,'岳坊镇',4,'',0,1,0,0),(18181,2316,'常兴镇',4,'',0,1,0,0),(18182,2316,'板桥集镇',4,'',0,1,0,0),(18183,2316,'柳林镇',4,'',0,1,0,0),(18184,2316,'楚村镇',4,'',0,1,0,0),(18185,2316,'漆园镇',4,'',0,1,0,0),(18186,2316,'王集乡',4,'',0,1,0,0),(18187,2316,'田桥镇',4,'',0,1,0,0),(18188,2316,'移村乡',4,'',0,1,0,0),(18189,2316,'立仓镇',4,'',0,1,0,0),(18190,2316,'篱笆乡',4,'',0,1,0,0),(18191,2316,'罗集乡',4,'',0,1,0,0),(18192,2316,'范集镇',4,'',0,1,0,0),(18193,2316,'许疃镇',4,'',0,1,0,0),(18194,2316,'马集镇',4,'',0,1,0,0),(18195,2317,'五马镇',4,'',0,1,0,0),(18196,2317,'十九里镇',4,'',0,1,0,0),(18197,2317,'十八里镇',4,'',0,1,0,0),(18198,2317,'十河镇',4,'',0,1,0,0),(18199,2317,'华佗镇',4,'',0,1,0,0),(18200,2317,'双沟镇',4,'',0,1,0,0),(18201,2317,'古井镇',4,'',0,1,0,0),(18202,2317,'古城镇',4,'',0,1,0,0),(18203,2317,'城父镇',4,'',0,1,0,0),(18204,2317,'大杨镇',4,'',0,1,0,0),(18205,2317,'张店乡',4,'',0,1,0,0),(18206,2317,'汤陵街道',4,'',0,1,0,0),(18207,2317,'沙土镇',4,'',0,1,0,0),(18208,2317,'淝河镇',4,'',0,1,0,0),(18209,2317,'牛集镇',4,'',0,1,0,0),(18210,2317,'立德镇',4,'',0,1,0,0),(18211,2317,'芦庙镇',4,'',0,1,0,0),(18212,2317,'花戏楼街道',4,'',0,1,0,0),(18213,2317,'薛阁街道',4,'',0,1,0,0),(18214,2317,'观堂镇',4,'',0,1,0,0),(18215,2317,'谯东镇',4,'',0,1,0,0),(18216,2317,'赵桥乡',4,'',0,1,0,0),(18217,2317,'颜集镇',4,'',0,1,0,0),(18218,2317,'魏岗镇',4,'',0,1,0,0),(18219,2317,'龙扬镇',4,'',0,1,0,0),(18220,2318,'东流镇',4,'',0,1,0,0),(18221,2318,'大渡口镇',4,'',0,1,0,0),(18222,2318,'官港镇',4,'',0,1,0,0),(18223,2318,'尧渡镇',4,'',0,1,0,0),(18224,2318,'张溪镇',4,'',0,1,0,0),(18225,2318,'昭潭镇',4,'',0,1,0,0),(18226,2318,'木塔乡',4,'',0,1,0,0),(18227,2318,'泥溪镇',4,'',0,1,0,0),(18228,2318,'洋湖镇',4,'',0,1,0,0),(18229,2318,'胜利镇',4,'',0,1,0,0),(18230,2318,'花园里乡',4,'',0,1,0,0),(18231,2318,'葛公镇',4,'',0,1,0,0),(18232,2318,'青山乡',4,'',0,1,0,0),(18233,2318,'香隅镇',4,'',0,1,0,0),(18234,2318,'龙泉镇',4,'',0,1,0,0),(18235,2319,'丁香镇',4,'',0,1,0,0),(18236,2319,'七都镇',4,'',0,1,0,0),(18237,2319,'仁里镇',4,'',0,1,0,0),(18238,2319,'仙寓镇',4,'',0,1,0,0),(18239,2319,'大演乡',4,'',0,1,0,0),(18240,2319,'小河镇',4,'',0,1,0,0),(18241,2319,'横渡镇',4,'',0,1,0,0),(18242,2319,'矶滩乡',4,'',0,1,0,0),(18243,2320,'乌沙镇',4,'',0,1,0,0),(18244,2320,'唐田镇',4,'',0,1,0,0),(18245,2320,'墩上街道',4,'',0,1,0,0),(18246,2320,'梅村镇',4,'',0,1,0,0),(18247,2320,'梅街镇',4,'',0,1,0,0),(18248,2320,'梅龙街道',4,'',0,1,0,0),(18249,2320,'棠溪镇',4,'',0,1,0,0),(18250,2320,'殷汇镇',4,'',0,1,0,0),(18251,2320,'江口街道',4,'',0,1,0,0),(18252,2320,'池阳街道',4,'',0,1,0,0),(18253,2320,'涓桥镇',4,'',0,1,0,0),(18254,2320,'牌楼镇',4,'',0,1,0,0),(18255,2320,'牛头山镇',4,'',0,1,0,0),(18256,2320,'秋江街道',4,'',0,1,0,0),(18257,2320,'秋浦街道',4,'',0,1,0,0),(18258,2320,'里山街道',4,'',0,1,0,0),(18259,2320,'马衙街道',4,'',0,1,0,0),(18260,2321,'丁桥镇',4,'',0,1,0,0),(18261,2321,'乔木乡',4,'',0,1,0,0),(18262,2321,'九华乡',4,'',0,1,0,0),(18263,2321,'九华镇',4,'',0,1,0,0),(18264,2321,'庙前镇',4,'',0,1,0,0),(18265,2321,'新河镇',4,'',0,1,0,0),(18266,2321,'木镇镇',4,'',0,1,0,0),(18267,2321,'朱备镇',4,'',0,1,0,0),(18268,2321,'杜村乡',4,'',0,1,0,0),(18269,2321,'杨田镇',4,'',0,1,0,0),(18270,2321,'蓉城镇',4,'',0,1,0,0),(18271,2321,'酉华乡',4,'',0,1,0,0),(18272,2321,'陵阳镇',4,'',0,1,0,0),(18273,2322,'万家乡',4,'',0,1,0,0),(18274,2322,'中溪镇',4,'',0,1,0,0),(18275,2322,'云梯畲族乡',4,'',0,1,0,0),(18276,2322,'仙霞镇',4,'',0,1,0,0),(18277,2322,'南山街道',4,'',0,1,0,0),(18278,2322,'南极乡',4,'',0,1,0,0),(18279,2322,'天湖镇',4,'',0,1,0,0),(18280,2322,'宁墩镇',4,'',0,1,0,0),(18281,2322,'方塘乡',4,'',0,1,0,0),(18282,2322,'梅林镇',4,'',0,1,0,0),(18283,2322,'汪溪镇',4,'',0,1,0,0),(18284,2322,'河沥街道',4,'',0,1,0,0),(18285,2322,'港口镇',4,'',0,1,0,0),(18286,2322,'甲路镇',4,'',0,1,0,0),(18287,2322,'竹峰乡',4,'',0,1,0,0),(18288,2322,'胡乐镇',4,'',0,1,0,0),(18289,2322,'西津街道',4,'',0,1,0,0),(18290,2322,'霞西镇',4,'',0,1,0,0),(18291,2322,'青龙乡',4,'',0,1,0,0),(18292,2323,'五星乡',4,'',0,1,0,0),(18293,2323,'养贤乡',4,'',0,1,0,0),(18294,2323,'双桥街道',4,'',0,1,0,0),(18295,2323,'古泉镇',4,'',0,1,0,0),(18296,2323,'向阳镇',4,'',0,1,0,0),(18297,2323,'周王镇',4,'',0,1,0,0),(18298,2323,'孙埠镇',4,'',0,1,0,0),(18299,2323,'寒亭镇',4,'',0,1,0,0),(18300,2323,'敬亭山街道',4,'',0,1,0,0),(18301,2323,'文昌镇',4,'',0,1,0,0),(18302,2323,'新田镇',4,'',0,1,0,0),(18303,2323,'朱桥乡',4,'',0,1,0,0),(18304,2323,'杨柳镇',4,'',0,1,0,0),(18305,2323,'水东镇',4,'',0,1,0,0),(18306,2323,'水阳镇',4,'',0,1,0,0),(18307,2323,'沈村镇',4,'',0,1,0,0),(18308,2323,'洪林镇',4,'',0,1,0,0),(18309,2323,'济川街道',4,'',0,1,0,0),(18310,2323,'溪口镇',4,'',0,1,0,0),(18311,2323,'澄江街道',4,'',0,1,0,0),(18312,2323,'狸桥镇',4,'',0,1,0,0),(18313,2323,'西林街道',4,'',0,1,0,0),(18314,2323,'金坝乡',4,'',0,1,0,0),(18315,2323,'飞彩街道',4,'',0,1,0,0),(18316,2323,'鳌峰街道',4,'',0,1,0,0),(18317,2323,'黄渡乡',4,'',0,1,0,0),(18318,2324,'东亭乡',4,'',0,1,0,0),(18319,2324,'卢村乡',4,'',0,1,0,0),(18320,2324,'四合乡',4,'',0,1,0,0),(18321,2324,'新杭镇',4,'',0,1,0,0),(18322,2324,'杨滩乡',4,'',0,1,0,0),(18323,2324,'柏垫镇',4,'',0,1,0,0),(18324,2324,'桃州镇',4,'',0,1,0,0),(18325,2324,'祠山岗茶场',4,'',0,1,0,0),(18326,2324,'誓节镇',4,'',0,1,0,0),(18327,2324,'邱村镇',4,'',0,1,0,0),(18328,2325,'三溪镇',4,'',0,1,0,0),(18329,2325,'云乐乡',4,'',0,1,0,0),(18330,2325,'俞村乡',4,'',0,1,0,0),(18331,2325,'兴隆乡',4,'',0,1,0,0),(18332,2325,'孙村乡',4,'',0,1,0,0),(18333,2325,'庙首镇',4,'',0,1,0,0),(18334,2325,'旌阳镇',4,'',0,1,0,0),(18335,2325,'版书乡',4,'',0,1,0,0),(18336,2325,'白地镇',4,'',0,1,0,0),(18337,2325,'蔡家桥镇',4,'',0,1,0,0),(18338,2326,'丁家桥镇',4,'',0,1,0,0),(18339,2326,'云岭镇',4,'',0,1,0,0),(18340,2326,'昌桥乡',4,'',0,1,0,0),(18341,2326,'桃花潭镇',4,'',0,1,0,0),(18342,2326,'榔桥镇',4,'',0,1,0,0),(18343,2326,'汀溪乡',4,'',0,1,0,0),(18344,2326,'泾川镇',4,'',0,1,0,0),(18345,2326,'琴溪镇',4,'',0,1,0,0),(18346,2326,'茂林镇',4,'',0,1,0,0),(18347,2326,'蔡村镇',4,'',0,1,0,0),(18348,2326,'黄村镇',4,'',0,1,0,0),(18349,2327,'上庄镇',4,'',0,1,0,0),(18350,2327,'临溪镇',4,'',0,1,0,0),(18351,2327,'伏岭镇',4,'',0,1,0,0),(18352,2327,'华阳镇',4,'',0,1,0,0),(18353,2327,'家朋乡',4,'',0,1,0,0),(18354,2327,'扬溪镇',4,'',0,1,0,0),(18355,2327,'板桥头乡',4,'',0,1,0,0),(18356,2327,'瀛洲乡',4,'',0,1,0,0),(18357,2327,'荆州乡',4,'',0,1,0,0),(18358,2327,'金沙镇',4,'',0,1,0,0),(18359,2327,'长安镇',4,'',0,1,0,0),(18360,2328,'东夏镇',4,'',0,1,0,0),(18361,2328,'凌笪乡',4,'',0,1,0,0),(18362,2328,'十字镇',4,'',0,1,0,0),(18363,2328,'南丰镇',4,'',0,1,0,0),(18364,2328,'姚村乡',4,'',0,1,0,0),(18365,2328,'幸福乡',4,'',0,1,0,0),(18366,2328,'建平镇',4,'',0,1,0,0),(18367,2328,'新发镇',4,'',0,1,0,0),(18368,2328,'梅渚镇',4,'',0,1,0,0),(18369,2328,'毕桥镇',4,'',0,1,0,0),(18370,2328,'涛城镇',4,'',0,1,0,0),(18371,2328,'飞里乡',4,'',0,1,0,0),(18372,2329,'红星农场',4,'',0,1,0,0),(18373,2329,'三叉街街道',4,'',0,1,0,0),(18374,2329,'上渡街道',4,'',0,1,0,0),(18375,2329,'下渡街道',4,'',0,1,0,0),(18376,2329,'东升街道',4,'',0,1,0,0),(18377,2329,'临江街道',4,'',0,1,0,0),(18378,2329,'仓山镇',4,'',0,1,0,0),(18379,2329,'城门镇',4,'',0,1,0,0),(18380,2329,'对湖街道',4,'',0,1,0,0),(18381,2329,'建新镇',4,'',0,1,0,0),(18382,2329,'盖山镇',4,'',0,1,0,0),(18383,2329,'螺洲镇',4,'',0,1,0,0),(18384,2329,'金山街道',4,'',0,1,0,0),(18385,2330,'上海街道',4,'',0,1,0,0),(18386,2330,'义洲街道',4,'',0,1,0,0),(18387,2330,'后洲街道',4,'',0,1,0,0),(18388,2330,'宁化街道',4,'',0,1,0,0),(18389,2330,'新港街道',4,'',0,1,0,0),(18390,2330,'洋中街道',4,'',0,1,0,0),(18391,2330,'苍霞街道',4,'',0,1,0,0),(18392,2330,'茶亭街道',4,'',0,1,0,0),(18393,2330,'鳌峰街道',4,'',0,1,0,0),(18394,2331,'东庠乡',4,'',0,1,0,0),(18395,2331,'中楼乡',4,'',0,1,0,0),(18396,2331,'北厝镇',4,'',0,1,0,0),(18397,2331,'南海乡',4,'',0,1,0,0),(18398,2331,'大练乡',4,'',0,1,0,0),(18399,2331,'屿头乡',4,'',0,1,0,0),(18400,2331,'岚城乡',4,'',0,1,0,0),(18401,2331,'平原镇',4,'',0,1,0,0),(18402,2331,'敖东镇',4,'',0,1,0,0),(18403,2331,'流水镇',4,'',0,1,0,0),(18404,2331,'潭城镇',4,'',0,1,0,0),(18405,2331,'澳前镇',4,'',0,1,0,0),(18406,2331,'白青乡',4,'',0,1,0,0),(18407,2331,'芦洋乡',4,'',0,1,0,0),(18408,2331,'苏澳镇',4,'',0,1,0,0),(18409,2332,'宦溪镇',4,'',0,1,0,0),(18410,2332,'寿山乡',4,'',0,1,0,0),(18411,2332,'岳峰镇',4,'',0,1,0,0),(18412,2332,'新店镇',4,'',0,1,0,0),(18413,2332,'日溪乡',4,'',0,1,0,0),(18414,2332,'王庄街道',4,'',0,1,0,0),(18415,2332,'象园街道',4,'',0,1,0,0),(18416,2332,'鼓山镇',4,'',0,1,0,0),(18417,2333,'东洋乡',4,'',0,1,0,0),(18418,2333,'丹云乡',4,'',0,1,0,0),(18419,2333,'同安镇',4,'',0,1,0,0),(18420,2333,'城峰镇',4,'',0,1,0,0),(18421,2333,'塘前乡',4,'',0,1,0,0),(18422,2333,'大洋镇',4,'',0,1,0,0),(18423,2333,'富泉乡',4,'',0,1,0,0),(18424,2333,'岭路乡',4,'',0,1,0,0),(18425,2333,'嵩口镇',4,'',0,1,0,0),(18426,2333,'梧桐镇',4,'',0,1,0,0),(18427,2333,'樟城镇',4,'',0,1,0,0),(18428,2333,'洑口乡',4,'',0,1,0,0),(18429,2333,'清凉镇',4,'',0,1,0,0),(18430,2333,'白云乡',4,'',0,1,0,0),(18431,2333,'盖洋乡',4,'',0,1,0,0),(18432,2333,'盘谷乡',4,'',0,1,0,0),(18433,2333,'红星乡',4,'',0,1,0,0),(18434,2333,'葛岭镇',4,'',0,1,0,0),(18435,2333,'赤锡乡',4,'',0,1,0,0),(18436,2333,'长庆镇',4,'',0,1,0,0),(18437,2333,'霞拔乡',4,'',0,1,0,0),(18438,2334,'东阁华侨农场',4,'',0,1,0,0),(18439,2334,'江镜华侨农场',4,'',0,1,0,0),(18440,2334,'一都镇',4,'',0,1,0,0),(18441,2334,'三山镇',4,'',0,1,0,0),(18442,2334,'上迳镇',4,'',0,1,0,0),(18443,2334,'东张镇',4,'',0,1,0,0),(18444,2334,'东瀚镇',4,'',0,1,0,0),(18445,2334,'元代：',4,'',0,1,0,0),(18446,2334,'南岭镇',4,'',0,1,0,0),(18447,2334,'唐代：',4,'',0,1,0,0),(18448,2334,'城头镇',4,'',0,1,0,0),(18449,2334,'新厝镇',4,'',0,1,0,0),(18450,2334,'江镜镇',4,'',0,1,0,0),(18451,2334,'江阴镇',4,'',0,1,0,0),(18452,2334,'沙埔镇',4,'',0,1,0,0),(18453,2334,'海口镇',4,'',0,1,0,0),(18454,2334,'清代：',4,'',0,1,0,0),(18455,2334,'渔溪镇',4,'',0,1,0,0),(18456,2334,'港头镇',4,'',0,1,0,0),(18457,2334,'镜洋镇',4,'',0,1,0,0),(18458,2334,'高山镇',4,'',0,1,0,0),(18459,2334,'龙田镇',4,'',0,1,0,0),(18460,2335,'罗源湾开发区',4,'',0,1,0,0),(18461,2335,'中房镇',4,'',0,1,0,0),(18462,2335,'松山镇',4,'',0,1,0,0),(18463,2335,'洪洋乡',4,'',0,1,0,0),(18464,2335,'白塔乡',4,'',0,1,0,0),(18465,2335,'碧里乡',4,'',0,1,0,0),(18466,2335,'西兰乡',4,'',0,1,0,0),(18467,2335,'起步镇',4,'',0,1,0,0),(18468,2335,'鉴江镇',4,'',0,1,0,0),(18469,2335,'霍口畲族乡',4,'',0,1,0,0),(18470,2335,'飞竹镇',4,'',0,1,0,0),(18471,2336,'下宫乡',4,'',0,1,0,0),(18472,2336,'东岱镇',4,'',0,1,0,0),(18473,2336,'东湖镇',4,'',0,1,0,0),(18474,2336,'丹阳镇',4,'',0,1,0,0),(18475,2336,'坑园镇',4,'',0,1,0,0),(18476,2336,'安凯乡',4,'',0,1,0,0),(18477,2336,'官坂镇',4,'',0,1,0,0),(18478,2336,'小沧畲族乡',4,'',0,1,0,0),(18479,2336,'敖江镇',4,'',0,1,0,0),(18480,2336,'晓澳镇',4,'',0,1,0,0),(18481,2336,'江南乡',4,'',0,1,0,0),(18482,2336,'浦口镇',4,'',0,1,0,0),(18483,2336,'潘渡乡',4,'',0,1,0,0),(18484,2336,'琯头镇',4,'',0,1,0,0),(18485,2336,'筱埕镇',4,'',0,1,0,0),(18486,2336,'苔菉镇',4,'',0,1,0,0),(18487,2336,'蓼沿乡',4,'',0,1,0,0),(18488,2336,'透堡镇',4,'',0,1,0,0),(18489,2336,'长龙镇',4,'',0,1,0,0),(18490,2336,'马祖乡',4,'',0,1,0,0),(18491,2336,'马鼻镇',4,'',0,1,0,0),(18492,2336,'黄岐镇',4,'',0,1,0,0),(18493,2337,'古槐镇',4,'',0,1,0,0),(18494,2337,'文岭镇',4,'',0,1,0,0),(18495,2337,'文武砂镇',4,'',0,1,0,0),(18496,2337,'松下镇',4,'',0,1,0,0),(18497,2337,'梅花镇',4,'',0,1,0,0),(18498,2337,'江田镇',4,'',0,1,0,0),(18499,2337,'湖南镇',4,'',0,1,0,0),(18500,2337,'漳港街道',4,'',0,1,0,0),(18501,2337,'漳港镇',4,'',0,1,0,0),(18502,2337,'潭头镇',4,'',0,1,0,0),(18503,2337,'猴屿乡',4,'',0,1,0,0),(18504,2337,'玉田镇',4,'',0,1,0,0),(18505,2337,'罗联乡',4,'',0,1,0,0),(18506,2337,'航城街道',4,'',0,1,0,0),(18507,2337,'营前街道',4,'',0,1,0,0),(18508,2337,'营前镇',4,'',0,1,0,0),(18509,2337,'金峰镇',4,'',0,1,0,0),(18510,2337,'首占镇',4,'',0,1,0,0),(18511,2337,'鹤上镇',4,'',0,1,0,0),(18512,2338,'江洋农场',4,'',0,1,0,0),(18513,2338,'上街镇',4,'',0,1,0,0),(18514,2338,'南屿镇',4,'',0,1,0,0),(18515,2338,'南通镇',4,'',0,1,0,0),(18516,2338,'大湖乡',4,'',0,1,0,0),(18517,2338,'小箬乡',4,'',0,1,0,0),(18518,2338,'尚干镇',4,'',0,1,0,0),(18519,2338,'廷坪乡',4,'',0,1,0,0),(18520,2338,'洋里乡',4,'',0,1,0,0),(18521,2338,'白沙镇',4,'',0,1,0,0),(18522,2338,'祥谦镇',4,'',0,1,0,0),(18523,2338,'竹岐乡',4,'',0,1,0,0),(18524,2338,'荆溪镇',4,'',0,1,0,0),(18525,2338,'青口镇',4,'',0,1,0,0),(18526,2338,'鸿尾乡',4,'',0,1,0,0),(18527,2339,'三溪乡',4,'',0,1,0,0),(18528,2339,'上莲乡',4,'',0,1,0,0),(18529,2339,'下祝乡',4,'',0,1,0,0),(18530,2339,'东桥镇',4,'',0,1,0,0),(18531,2339,'云龙乡',4,'',0,1,0,0),(18532,2339,'坂东镇',4,'',0,1,0,0),(18533,2339,'塔庄镇',4,'',0,1,0,0),(18534,2339,'桔林乡',4,'',0,1,0,0),(18535,2339,'梅溪镇',4,'',0,1,0,0),(18536,2339,'池园镇',4,'',0,1,0,0),(18537,2339,'白中镇',4,'',0,1,0,0),(18538,2339,'白樟镇',4,'',0,1,0,0),(18539,2339,'省璜镇',4,'',0,1,0,0),(18540,2339,'金沙镇',4,'',0,1,0,0),(18541,2339,'雄江镇',4,'',0,1,0,0),(18542,2340,'亭江镇',4,'',0,1,0,0),(18543,2340,'琅岐镇',4,'',0,1,0,0),(18544,2340,'马尾镇',4,'',0,1,0,0),(18545,2341,'东街街道',4,'',0,1,0,0),(18546,2341,'五凤街道',4,'',0,1,0,0),(18547,2341,'华大街道',4,'',0,1,0,0),(18548,2341,'南街街道',4,'',0,1,0,0),(18549,2341,'安泰街道',4,'',0,1,0,0),(18550,2341,'水部街道',4,'',0,1,0,0),(18551,2341,'洪山镇',4,'',0,1,0,0),(18552,2341,'温泉街道',4,'',0,1,0,0),(18553,2341,'鼓西街道',4,'',0,1,0,0),(18554,2342,'五显镇',4,'',0,1,0,0),(18555,2342,'凤南农场',4,'',0,1,0,0),(18556,2342,'北山农场',4,'',0,1,0,0),(18557,2342,'大同街道',4,'',0,1,0,0),(18558,2342,'新民镇',4,'',0,1,0,0),(18559,2342,'汀溪水库',4,'',0,1,0,0),(18560,2342,'汀溪镇',4,'',0,1,0,0),(18561,2342,'汀溪防护林场',4,'',0,1,0,0),(18562,2342,'洪塘镇',4,'',0,1,0,0),(18563,2342,'白沙仑农场',4,'',0,1,0,0),(18564,2342,'祥平街道',4,'',0,1,0,0),(18565,2342,'祥溪林场',4,'',0,1,0,0),(18566,2342,'竹坝华侨农场',4,'',0,1,0,0),(18567,2342,'莲花镇',4,'',0,1,0,0),(18568,2342,'西柯镇',4,'',0,1,0,0),(18569,2343,'万石植物园',4,'',0,1,0,0),(18570,2343,'中华街道',4,'',0,1,0,0),(18571,2343,'云顶岩',4,'',0,1,0,0),(18572,2343,'农科所',4,'',0,1,0,0),(18573,2343,'嘉莲街道',4,'',0,1,0,0),(18574,2343,'开元街道',4,'',0,1,0,0),(18575,2343,'梧村街道',4,'',0,1,0,0),(18576,2343,'滨海街道',4,'',0,1,0,0),(18577,2343,'筼筜街道',4,'',0,1,0,0),(18578,2343,'莲前街道',4,'',0,1,0,0),(18579,2343,'鹭江街道',4,'',0,1,0,0),(18580,2343,'鼓浪屿街道',4,'',0,1,0,0),(18581,2344,'东孚镇',4,'',0,1,0,0),(18582,2344,'天竺山林场',4,'',0,1,0,0),(18583,2344,'杏林马銮湾',4,'',0,1,0,0),(18584,2344,'海沧农场',4,'',0,1,0,0),(18585,2344,'海沧镇',4,'',0,1,0,0),(18586,2344,'第一农场',4,'',0,1,0,0),(18587,2345,'前哨盐场',4,'',0,1,0,0),(18588,2345,'忠仑苗圃',4,'',0,1,0,0),(18589,2345,'殿前街道',4,'',0,1,0,0),(18590,2345,'江头街道',4,'',0,1,0,0),(18591,2345,'湖边水库',4,'',0,1,0,0),(18592,2345,'禾山街道',4,'',0,1,0,0),(18593,2345,'金山街道',4,'',0,1,0,0),(18594,2345,'高崎国际机场',4,'',0,1,0,0),(18595,2346,'内厝镇',4,'',0,1,0,0),(18596,2346,'大嶝镇',4,'',0,1,0,0),(18597,2346,'大帽山农场',4,'',0,1,0,0),(18598,2346,'新圩镇',4,'',0,1,0,0),(18599,2346,'新店镇',4,'',0,1,0,0),(18600,2346,'马巷镇',4,'',0,1,0,0),(18601,2347,'侨英街道',4,'',0,1,0,0),(18602,2347,'后溪镇',4,'',0,1,0,0),(18603,2347,'坂头防护林场',4,'',0,1,0,0),(18604,2347,'天马华侨农场',4,'',0,1,0,0),(18605,2347,'杏林街道',4,'',0,1,0,0),(18606,2347,'杏滨街道',4,'',0,1,0,0),(18607,2347,'灌口镇',4,'',0,1,0,0),(18608,2347,'省天马种猪场',4,'',0,1,0,0),(18609,2347,'第二农场',4,'',0,1,0,0),(18610,2347,'集美部队农场',4,'',0,1,0,0),(18611,2348,'书峰乡',4,'',0,1,0,0),(18612,2348,'园庄镇',4,'',0,1,0,0),(18613,2348,'大济镇',4,'',0,1,0,0),(18614,2348,'度尾镇',4,'',0,1,0,0),(18615,2348,'枫亭镇',4,'',0,1,0,0),(18616,2348,'榜头镇',4,'',0,1,0,0),(18617,2348,'游洋镇',4,'',0,1,0,0),(18618,2348,'盖尾镇',4,'',0,1,0,0),(18619,2348,'石苍乡',4,'',0,1,0,0),(18620,2348,'社硎乡',4,'',0,1,0,0),(18621,2348,'西苑乡',4,'',0,1,0,0),(18622,2348,'象溪乡',4,'',0,1,0,0),(18623,2348,'赖店镇',4,'',0,1,0,0),(18624,2348,'郊尾镇',4,'',0,1,0,0),(18625,2348,'钟山镇',4,'',0,1,0,0),(18626,2348,'鲤南镇',4,'',0,1,0,0),(18627,2348,'龙华镇',4,'',0,1,0,0),(18628,2349,'东海镇',4,'',0,1,0,0),(18629,2349,'凤凰山街道',4,'',0,1,0,0),(18630,2349,'华亭镇',4,'',0,1,0,0),(18631,2349,'常太镇',4,'',0,1,0,0),(18632,2349,'灵川镇',4,'',0,1,0,0),(18633,2349,'霞林街道',4,'',0,1,0,0),(18634,2350,'三江口镇',4,'',0,1,0,0),(18635,2350,'国欢镇',4,'',0,1,0,0),(18636,2350,'大洋乡',4,'',0,1,0,0),(18637,2350,'庄边镇',4,'',0,1,0,0),(18638,2350,'新县镇',4,'',0,1,0,0),(18639,2350,'梧塘镇',4,'',0,1,0,0),(18640,2350,'江口镇',4,'',0,1,0,0),(18641,2350,'涵西街道',4,'',0,1,0,0),(18642,2350,'白塘镇',4,'',0,1,0,0),(18643,2350,'白沙镇',4,'',0,1,0,0),(18644,2350,'萩芦镇',4,'',0,1,0,0),(18645,2350,'赤港华侨经济开发区',4,'',0,1,0,0),(18646,2351,'东埔镇',4,'',0,1,0,0),(18647,2351,'东峤镇',4,'',0,1,0,0),(18648,2351,'东庄镇',4,'',0,1,0,0),(18649,2351,'南日镇',4,'',0,1,0,0),(18650,2351,'埭头镇',4,'',0,1,0,0),(18651,2351,'山亭乡',4,'',0,1,0,0),(18652,2351,'平海镇',4,'',0,1,0,0),(18653,2351,'忠门镇',4,'',0,1,0,0),(18654,2351,'月塘乡',4,'',0,1,0,0),(18655,2351,'湄洲镇',4,'',0,1,0,0),(18656,2351,'笏石镇',4,'',0,1,0,0),(18657,2352,'北高镇',4,'',0,1,0,0),(18658,2352,'拱辰街道',4,'',0,1,0,0),(18659,2352,'新度镇',4,'',0,1,0,0),(18660,2352,'西天尾镇',4,'',0,1,0,0),(18661,2352,'黄石镇',4,'',0,1,0,0),(18662,2353,'中村乡',4,'',0,1,0,0),(18663,2353,'城东乡',4,'',0,1,0,0),(18664,2353,'富兴堡街道',4,'',0,1,0,0),(18665,2353,'岩前镇',4,'',0,1,0,0),(18666,2353,'白沙街道',4,'',0,1,0,0),(18667,2353,'荆西街道',4,'',0,1,0,0),(18668,2353,'莘口镇',4,'',0,1,0,0),(18669,2354,'上京镇',4,'',0,1,0,0),(18670,2354,'前坪乡',4,'',0,1,0,0),(18671,2354,'华兴乡',4,'',0,1,0,0),(18672,2354,'吴山乡',4,'',0,1,0,0),(18673,2354,'太华镇',4,'',0,1,0,0),(18674,2354,'奇韬镇',4,'',0,1,0,0),(18675,2354,'屏山乡',4,'',0,1,0,0),(18676,2354,'广平镇',4,'',0,1,0,0),(18677,2354,'建设镇',4,'',0,1,0,0),(18678,2354,'文江乡',4,'',0,1,0,0),(18679,2354,'桃源镇',4,'',0,1,0,0),(18680,2354,'梅山乡',4,'',0,1,0,0),(18681,2354,'武陵乡',4,'',0,1,0,0),(18682,2354,'济阳乡',4,'',0,1,0,0),(18683,2354,'湖美乡',4,'',0,1,0,0),(18684,2354,'石牌镇',4,'',0,1,0,0),(18685,2354,'谢洋乡',4,'',0,1,0,0),(18686,2355,'中沙乡',4,'',0,1,0,0),(18687,2355,'城南乡',4,'',0,1,0,0),(18688,2355,'城郊乡',4,'',0,1,0,0),(18689,2355,'安乐乡',4,'',0,1,0,0),(18690,2355,'安远乡',4,'',0,1,0,0),(18691,2355,'方田乡',4,'',0,1,0,0),(18692,2355,'曹坊乡',4,'',0,1,0,0),(18693,2355,'水茜乡',4,'',0,1,0,0),(18694,2355,'河龙乡',4,'',0,1,0,0),(18695,2355,'治平乡',4,'',0,1,0,0),(18696,2355,'泉上镇',4,'',0,1,0,0),(18697,2355,'济村乡',4,'',0,1,0,0),(18698,2355,'淮土乡',4,'',0,1,0,0),(18699,2355,'湖村镇',4,'',0,1,0,0),(18700,2355,'石壁镇',4,'',0,1,0,0),(18701,2356,'万全乡',4,'',0,1,0,0),(18702,2356,'万安镇',4,'',0,1,0,0),(18703,2356,'余坊乡',4,'',0,1,0,0),(18704,2356,'光明乡',4,'',0,1,0,0),(18705,2356,'南口乡',4,'',0,1,0,0),(18706,2356,'大源乡',4,'',0,1,0,0),(18707,2356,'安仁乡',4,'',0,1,0,0),(18708,2356,'水南镇',4,'',0,1,0,0),(18709,2356,'漠源乡',4,'',0,1,0,0),(18710,2356,'白莲镇',4,'',0,1,0,0),(18711,2356,'高唐镇',4,'',0,1,0,0),(18712,2356,'黄潭镇',4,'',0,1,0,0),(18713,2357,'中仙乡',4,'',0,1,0,0),(18714,2357,'八字桥乡',4,'',0,1,0,0),(18715,2357,'台溪乡',4,'',0,1,0,0),(18716,2357,'坂面乡',4,'',0,1,0,0),(18717,2357,'尤溪口镇',4,'',0,1,0,0),(18718,2357,'新阳镇',4,'',0,1,0,0),(18719,2357,'梅仙镇',4,'',0,1,0,0),(18720,2357,'汤川乡',4,'',0,1,0,0),(18721,2357,'洋中镇',4,'',0,1,0,0),(18722,2357,'溪尾乡',4,'',0,1,0,0),(18723,2357,'管前镇',4,'',0,1,0,0),(18724,2357,'联合乡',4,'',0,1,0,0),(18725,2357,'西城镇',4,'',0,1,0,0),(18726,2357,'西滨镇',4,'',0,1,0,0),(18727,2358,'伊家乡',4,'',0,1,0,0),(18728,2358,'均口镇',4,'',0,1,0,0),(18729,2358,'客坊乡',4,'',0,1,0,0),(18730,2358,'溪口镇',4,'',0,1,0,0),(18731,2358,'溪源乡',4,'',0,1,0,0),(18732,2358,'里心镇',4,'',0,1,0,0),(18733,2358,'金溪乡',4,'',0,1,0,0),(18734,2358,'黄坊乡',4,'',0,1,0,0),(18735,2358,'黄埠乡',4,'',0,1,0,0),(18736,2359,'城关乡',4,'',0,1,0,0),(18737,2359,'夏坊乡',4,'',0,1,0,0),(18738,2359,'夏阳乡',4,'',0,1,0,0),(18739,2359,'枫溪乡',4,'',0,1,0,0),(18740,2359,'沙溪乡',4,'',0,1,0,0),(18741,2359,'瀚仙镇',4,'',0,1,0,0),(18742,2359,'盖洋镇',4,'',0,1,0,0),(18743,2359,'胡坊镇',4,'',0,1,0,0),(18744,2360,'列西街道',4,'',0,1,0,0),(18745,2360,'北门街道',4,'',0,1,0,0),(18746,2360,'徐碧乡',4,'',0,1,0,0),(18747,2360,'洋溪乡',4,'',0,1,0,0),(18748,2360,'陈大镇',4,'',0,1,0,0),(18749,2361,'上坪乡',4,'',0,1,0,0),(18750,2361,'大湖镇',4,'',0,1,0,0),(18751,2361,'安砂镇',4,'',0,1,0,0),(18752,2361,'小陶镇',4,'',0,1,0,0),(18753,2361,'曹远镇',4,'',0,1,0,0),(18754,2361,'槐南乡',4,'',0,1,0,0),(18755,2361,'洪田镇',4,'',0,1,0,0),(18756,2361,'燕北街道',4,'',0,1,0,0),(18757,2361,'燕南街道',4,'',0,1,0,0),(18758,2361,'燕西街道',4,'',0,1,0,0),(18759,2361,'罗坊乡',4,'',0,1,0,0),(18760,2361,'西洋镇',4,'',0,1,0,0),(18761,2361,'贡川镇',4,'',0,1,0,0),(18762,2361,'青水畲族乡',4,'',0,1,0,0),(18763,2362,'南阳乡',4,'',0,1,0,0),(18764,2362,'南霞乡',4,'',0,1,0,0),(18765,2362,'夏茂镇',4,'',0,1,0,0),(18766,2362,'大洛镇',4,'',0,1,0,0),(18767,2362,'富口镇',4,'',0,1,0,0),(18768,2362,'湖源乡',4,'',0,1,0,0),(18769,2362,'虬江街道',4,'',0,1,0,0),(18770,2362,'郑湖乡',4,'',0,1,0,0),(18771,2362,'青州镇',4,'',0,1,0,0),(18772,2362,'高桥镇',4,'',0,1,0,0),(18773,2362,'高砂镇',4,'',0,1,0,0),(18774,2363,'上青乡',4,'',0,1,0,0),(18775,2363,'下渠乡',4,'',0,1,0,0),(18776,2363,'大布乡',4,'',0,1,0,0),(18777,2363,'大田乡',4,'',0,1,0,0),(18778,2363,'开善乡',4,'',0,1,0,0),(18779,2363,'新桥乡',4,'',0,1,0,0),(18780,2363,'朱口镇',4,'',0,1,0,0),(18781,2363,'梅口乡',4,'',0,1,0,0),(18782,2363,'龙安乡',4,'',0,1,0,0),(18783,2363,'龙湖镇',4,'',0,1,0,0),(18784,2364,'东华乡',4,'',0,1,0,0),(18785,2364,'余朋乡',4,'',0,1,0,0),(18786,2364,'嵩口镇',4,'',0,1,0,0),(18787,2364,'嵩溪镇',4,'',0,1,0,0),(18788,2364,'李家乡',4,'',0,1,0,0),(18789,2364,'林畲乡',4,'',0,1,0,0),(18790,2364,'沙芜乡',4,'',0,1,0,0),(18791,2364,'温郊乡',4,'',0,1,0,0),(18792,2364,'灵地镇',4,'',0,1,0,0),(18793,2364,'田源乡',4,'',0,1,0,0),(18794,2364,'赖坊乡',4,'',0,1,0,0),(18795,2364,'邓家乡',4,'',0,1,0,0),(18796,2364,'里田乡',4,'',0,1,0,0),(18797,2364,'长校镇',4,'',0,1,0,0),(18798,2365,'东海街道',4,'',0,1,0,0),(18799,2365,'丰泽街道',4,'',0,1,0,0),(18800,2365,'北峰街道',4,'',0,1,0,0),(18801,2365,'华大街道',4,'',0,1,0,0),(18802,2365,'城东街道',4,'',0,1,0,0),(18803,2365,'泉秀街道',4,'',0,1,0,0),(18804,2365,'清源街道',4,'',0,1,0,0),(18805,2366,'东田镇',4,'',0,1,0,0),(18806,2366,'丰州镇',4,'',0,1,0,0),(18807,2366,'乐峰镇',4,'',0,1,0,0),(18808,2366,'九都镇',4,'',0,1,0,0),(18809,2366,'仑苍镇',4,'',0,1,0,0),(18810,2366,'向阳乡',4,'',0,1,0,0),(18811,2366,'官桥镇',4,'',0,1,0,0),(18812,2366,'康美镇',4,'',0,1,0,0),(18813,2366,'柳城街道',4,'',0,1,0,0),(18814,2366,'梅山镇',4,'',0,1,0,0),(18815,2366,'水头镇',4,'',0,1,0,0),(18816,2366,'洪梅镇',4,'',0,1,0,0),(18817,2366,'洪濑镇',4,'',0,1,0,0),(18818,2366,'省新镇',4,'',0,1,0,0),(18819,2366,'眉山乡',4,'',0,1,0,0),(18820,2366,'石井镇',4,'',0,1,0,0),(18821,2366,'码头镇',4,'',0,1,0,0),(18822,2366,'罗东镇',4,'',0,1,0,0),(18823,2366,'美林街道',4,'',0,1,0,0),(18824,2366,'翔云镇',4,'',0,1,0,0),(18825,2366,'英都镇',4,'',0,1,0,0),(18826,2366,'蓬华镇',4,'',0,1,0,0),(18827,2366,'诗山镇',4,'',0,1,0,0),(18828,2366,'金淘镇',4,'',0,1,0,0),(18829,2366,'霞美镇',4,'',0,1,0,0),(18830,2367,'剑斗镇',4,'',0,1,0,0),(18831,2367,'参内乡',4,'',0,1,0,0),(18832,2367,'城厢镇',4,'',0,1,0,0),(18833,2367,'大坪乡',4,'',0,1,0,0),(18834,2367,'官桥镇',4,'',0,1,0,0),(18835,2367,'尚卿乡',4,'',0,1,0,0),(18836,2367,'感德镇',4,'',0,1,0,0),(18837,2367,'桃舟乡',4,'',0,1,0,0),(18838,2367,'湖上乡',4,'',0,1,0,0),(18839,2367,'湖头镇',4,'',0,1,0,0),(18840,2367,'白濑乡',4,'',0,1,0,0),(18841,2367,'祥华乡',4,'',0,1,0,0),(18842,2367,'福田乡',4,'',0,1,0,0),(18843,2367,'芦田镇',4,'',0,1,0,0),(18844,2367,'蓝田乡',4,'',0,1,0,0),(18845,2367,'蓬莱镇',4,'',0,1,0,0),(18846,2367,'虎邱镇',4,'',0,1,0,0),(18847,2367,'西坪镇',4,'',0,1,0,0),(18848,2367,'金谷镇',4,'',0,1,0,0),(18849,2367,'长坑乡',4,'',0,1,0,0),(18850,2367,'魁斗镇',4,'',0,1,0,0),(18851,2367,'龙涓乡',4,'',0,1,0,0),(18852,2367,'龙门镇',4,'',0,1,0,0),(18853,2368,'三班镇',4,'',0,1,0,0),(18854,2368,'上涌镇',4,'',0,1,0,0),(18855,2368,'南埕镇',4,'',0,1,0,0),(18856,2368,'国宝乡',4,'',0,1,0,0),(18857,2368,'大铭乡',4,'',0,1,0,0),(18858,2368,'春美乡',4,'',0,1,0,0),(18859,2368,'杨梅乡',4,'',0,1,0,0),(18860,2368,'桂阳乡',4,'',0,1,0,0),(18861,2368,'水口镇',4,'',0,1,0,0),(18862,2368,'汤头乡',4,'',0,1,0,0),(18863,2368,'浔中镇',4,'',0,1,0,0),(18864,2368,'盖德乡',4,'',0,1,0,0),(18865,2368,'美湖乡',4,'',0,1,0,0),(18866,2368,'葛坑镇',4,'',0,1,0,0),(18867,2368,'赤水镇',4,'',0,1,0,0),(18868,2368,'雷峰镇',4,'',0,1,0,0),(18869,2368,'龙浔镇',4,'',0,1,0,0),(18870,2368,'龙门滩镇',4,'',0,1,0,0),(18871,2369,'东园镇',4,'',0,1,0,0),(18872,2369,'东岭镇',4,'',0,1,0,0),(18873,2369,'东桥镇',4,'',0,1,0,0),(18874,2369,'净峰镇',4,'',0,1,0,0),(18875,2369,'小岝镇',4,'',0,1,0,0),(18876,2369,'山霞镇',4,'',0,1,0,0),(18877,2369,'崇武镇',4,'',0,1,0,0),(18878,2369,'张坂镇',4,'',0,1,0,0),(18879,2369,'洛阳镇',4,'',0,1,0,0),(18880,2369,'涂寨镇',4,'',0,1,0,0),(18881,2369,'百崎回族乡',4,'',0,1,0,0),(18882,2369,'紫山镇',4,'',0,1,0,0),(18883,2369,'螺城镇',4,'',0,1,0,0),(18884,2369,'螺阳镇',4,'',0,1,0,0),(18885,2369,'辋川镇',4,'',0,1,0,0),(18886,2369,'黄塘镇',4,'',0,1,0,0),(18887,2370,'东石镇',4,'',0,1,0,0),(18888,2370,'五里工业区',4,'',0,1,0,0),(18889,2370,'内坑镇',4,'',0,1,0,0),(18890,2370,'安平开发区',4,'',0,1,0,0),(18891,2370,'安海镇',4,'',0,1,0,0),(18892,2370,'新塘街道',4,'',0,1,0,0),(18893,2370,'梅岭街道',4,'',0,1,0,0),(18894,2370,'永和镇',4,'',0,1,0,0),(18895,2370,'池店镇',4,'',0,1,0,0),(18896,2370,'深沪镇',4,'',0,1,0,0),(18897,2370,'灵源街道',4,'',0,1,0,0),(18898,2370,'磁灶镇',4,'',0,1,0,0),(18899,2370,'紫帽镇',4,'',0,1,0,0),(18900,2370,'罗山街道',4,'',0,1,0,0),(18901,2370,'英林镇',4,'',0,1,0,0),(18902,2370,'西园街道',4,'',0,1,0,0),(18903,2370,'西滨镇',4,'',0,1,0,0),(18904,2370,'金井镇',4,'',0,1,0,0),(18905,2370,'陈埭镇',4,'',0,1,0,0),(18906,2370,'龙湖镇',4,'',0,1,0,0),(18907,2371,'一都镇',4,'',0,1,0,0),(18908,2371,'下洋镇',4,'',0,1,0,0),(18909,2371,'东关镇',4,'',0,1,0,0),(18910,2371,'东平镇',4,'',0,1,0,0),(18911,2371,'五里街镇',4,'',0,1,0,0),(18912,2371,'介福乡',4,'',0,1,0,0),(18913,2371,'仙夹镇',4,'',0,1,0,0),(18914,2371,'吾峰镇',4,'',0,1,0,0),(18915,2371,'呈祥乡',4,'',0,1,0,0),(18916,2371,'坑仔口镇',4,'',0,1,0,0),(18917,2371,'外山乡',4,'',0,1,0,0),(18918,2371,'岵山镇',4,'',0,1,0,0),(18919,2371,'桂洋镇',4,'',0,1,0,0),(18920,2371,'桃城镇',4,'',0,1,0,0),(18921,2371,'横口乡',4,'',0,1,0,0),(18922,2371,'湖洋镇',4,'',0,1,0,0),(18923,2371,'玉斗镇',4,'',0,1,0,0),(18924,2371,'石鼓镇',4,'',0,1,0,0),(18925,2371,'苏坑镇',4,'',0,1,0,0),(18926,2371,'蓬壶镇',4,'',0,1,0,0),(18927,2371,'达埔镇',4,'',0,1,0,0),(18928,2371,'锦斗镇',4,'',0,1,0,0),(18929,2372,'前黄镇',4,'',0,1,0,0),(18930,2372,'南埔镇',4,'',0,1,0,0),(18931,2372,'后龙镇',4,'',0,1,0,0),(18932,2372,'山腰街道',4,'',0,1,0,0),(18933,2372,'峰尾镇',4,'',0,1,0,0),(18934,2372,'涂岭镇',4,'',0,1,0,0),(18935,2372,'界山镇',4,'',0,1,0,0),(18936,2373,'双阳镇',4,'',0,1,0,0),(18937,2373,'河市镇',4,'',0,1,0,0),(18938,2373,'罗溪镇',4,'',0,1,0,0),(18939,2373,'虹山乡',4,'',0,1,0,0),(18940,2373,'马甲镇',4,'',0,1,0,0),(18941,2374,'凤里街道',4,'',0,1,0,0),(18942,2374,'宝盖镇',4,'',0,1,0,0),(18943,2374,'永宁镇',4,'',0,1,0,0),(18944,2374,'灵秀镇',4,'',0,1,0,0),(18945,2374,'祥芝镇',4,'',0,1,0,0),(18946,2374,'蚶江镇',4,'',0,1,0,0),(18947,2374,'锦尚镇',4,'',0,1,0,0),(18948,2374,'鸿山镇',4,'',0,1,0,0),(18949,2375,'乌丘乡',4,'',0,1,0,0),(18950,2375,'烈屿乡',4,'',0,1,0,0),(18951,2375,'金城镇',4,'',0,1,0,0),(18952,2375,'金宁乡',4,'',0,1,0,0),(18953,2375,'金沙镇',4,'',0,1,0,0),(18954,2375,'金湖镇',4,'',0,1,0,0),(18955,2376,'临江街道',4,'',0,1,0,0),(18956,2376,'开元街道',4,'',0,1,0,0),(18957,2376,'江南街道',4,'',0,1,0,0),(18958,2376,'浮桥街道',4,'',0,1,0,0),(18959,2376,'经济技术开发区',4,'',0,1,0,0),(18960,2376,'鲤中街道',4,'',0,1,0,0),(18961,2377,'前楼镇',4,'',0,1,0,0),(18962,2377,'康美镇',4,'',0,1,0,0),(18963,2377,'杏陈镇',4,'',0,1,0,0),(18964,2377,'樟塘镇',4,'',0,1,0,0),(18965,2377,'铜陵（虚拟）镇',4,'',0,1,0,0),(18966,2377,'陈城镇',4,'',0,1,0,0),(18967,2378,'下河乡',4,'',0,1,0,0),(18968,2378,'东厦镇',4,'',0,1,0,0),(18969,2378,'列屿镇',4,'',0,1,0,0),(18970,2378,'和平乡',4,'',0,1,0,0),(18971,2378,'和平农场',4,'',0,1,0,0),(18972,2378,'常山华侨经济开发区',4,'',0,1,0,0),(18973,2378,'火田镇',4,'',0,1,0,0),(18974,2378,'莆美镇',4,'',0,1,0,0),(18975,2378,'陈岱镇',4,'',0,1,0,0),(18976,2378,'马铺乡',4,'',0,1,0,0),(18977,2379,'丰山镇',4,'',0,1,0,0),(18978,2379,'仙都镇',4,'',0,1,0,0),(18979,2379,'新圩镇',4,'',0,1,0,0),(18980,2379,'沙建镇',4,'',0,1,0,0),(18981,2379,'湖林乡',4,'',0,1,0,0),(18982,2379,'马坑乡',4,'',0,1,0,0),(18983,2379,'高安镇',4,'',0,1,0,0),(18984,2379,'高车乡',4,'',0,1,0,0),(18985,2380,'丰田镇',4,'',0,1,0,0),(18986,2380,'书洋镇',4,'',0,1,0,0),(18987,2380,'南坑镇',4,'',0,1,0,0),(18988,2380,'和溪镇',4,'',0,1,0,0),(18989,2380,'奎洋镇',4,'',0,1,0,0),(18990,2380,'山城镇',4,'',0,1,0,0),(18991,2380,'梅林镇',4,'',0,1,0,0),(18992,2380,'船场镇',4,'',0,1,0,0),(18993,2380,'金山镇',4,'',0,1,0,0),(18994,2380,'靖城镇',4,'',0,1,0,0),(18995,2380,'龙山镇',4,'',0,1,0,0),(18996,2381,'九峰镇',4,'',0,1,0,0),(18997,2381,'五寨乡',4,'',0,1,0,0),(18998,2381,'南胜镇',4,'',0,1,0,0),(18999,2381,'国强乡',4,'',0,1,0,0),(19000,2381,'坂仔镇',4,'',0,1,0,0),(19001,2381,'大溪镇',4,'',0,1,0,0),(19002,2381,'安厚镇',4,'',0,1,0,0),(19003,2381,'小溪镇',4,'',0,1,0,0),(19004,2381,'山格镇',4,'',0,1,0,0),(19005,2381,'崎岭乡',4,'',0,1,0,0),(19006,2381,'文峰镇',4,'',0,1,0,0),(19007,2381,'秀峰乡',4,'',0,1,0,0),(19008,2381,'芦溪镇',4,'',0,1,0,0),(19009,2381,'长乐乡',4,'',0,1,0,0),(19010,2381,'霞寨镇',4,'',0,1,0,0),(19011,2382,'万安农场',4,'',0,1,0,0),(19012,2382,'佛昙镇',4,'',0,1,0,0),(19013,2382,'六鳌镇',4,'',0,1,0,0),(19014,2382,'前亭镇',4,'',0,1,0,0),(19015,2382,'南浦乡',4,'',0,1,0,0),(19016,2382,'古雷镇',4,'',0,1,0,0),(19017,2382,'大南坂镇',4,'',0,1,0,0),(19018,2382,'官浔镇',4,'',0,1,0,0),(19019,2382,'旧镇镇',4,'',0,1,0,0),(19020,2382,'杜浔镇',4,'',0,1,0,0),(19021,2382,'沙西镇',4,'',0,1,0,0),(19022,2382,'深土镇',4,'',0,1,0,0),(19023,2382,'湖西畲族乡',4,'',0,1,0,0),(19024,2382,'漳浦盐场',4,'',0,1,0,0),(19025,2382,'盘陀镇',4,'',0,1,0,0),(19026,2382,'石榴镇',4,'',0,1,0,0),(19027,2382,'赤土乡',4,'',0,1,0,0),(19028,2382,'赤岭畲族乡',4,'',0,1,0,0),(19029,2382,'赤湖镇',4,'',0,1,0,0),(19030,2382,'长桥镇',4,'',0,1,0,0),(19031,2382,'霞美镇',4,'',0,1,0,0),(19032,2382,'马坪镇',4,'',0,1,0,0),(19033,2383,'五峰农场',4,'',0,1,0,0),(19034,2383,'南坑街道',4,'',0,1,0,0),(19035,2383,'后房农场',4,'',0,1,0,0),(19036,2383,'大房农场',4,'',0,1,0,0),(19037,2383,'天宝林场',4,'',0,1,0,0),(19038,2383,'天宝镇',4,'',0,1,0,0),(19039,2383,'巷口街道',4,'',0,1,0,0),(19040,2383,'新桥街道',4,'',0,1,0,0),(19041,2383,'浦南镇',4,'',0,1,0,0),(19042,2383,'石亭镇',4,'',0,1,0,0),(19043,2383,'芗城区奶牛场',4,'',0,1,0,0),(19044,2383,'芝山镇',4,'',0,1,0,0),(19045,2383,'西桥街道',4,'',0,1,0,0),(19046,2383,'通北街道',4,'',0,1,0,0),(19047,2384,'四都镇',4,'',0,1,0,0),(19048,2384,'太平镇',4,'',0,1,0,0),(19049,2384,'官陂镇',4,'',0,1,0,0),(19050,2384,'建设乡',4,'',0,1,0,0),(19051,2384,'桥东镇',4,'',0,1,0,0),(19052,2384,'梅岭镇',4,'',0,1,0,0),(19053,2384,'梅洲乡',4,'',0,1,0,0),(19054,2384,'深桥镇',4,'',0,1,0,0),(19055,2384,'白洋乡',4,'',0,1,0,0),(19056,2384,'秀篆镇',4,'',0,1,0,0),(19057,2384,'红星乡',4,'',0,1,0,0),(19058,2384,'西潭乡',4,'',0,1,0,0),(19059,2384,'边贸旅游区管委会',4,'',0,1,0,0),(19060,2384,'金星乡',4,'',0,1,0,0),(19061,2384,'闽粤边界开发区管委会',4,'',0,1,0,0),(19062,2384,'霞葛镇',4,'',0,1,0,0),(19063,2385,'兴泰工业区',4,'',0,1,0,0),(19064,2385,'古农农场',4,'',0,1,0,0),(19065,2385,'坂里乡',4,'',0,1,0,0),(19066,2385,'岩溪镇',4,'',0,1,0,0),(19067,2385,'枋洋镇',4,'',0,1,0,0),(19068,2385,'陈巷镇',4,'',0,1,0,0),(19069,2386,'朝阳镇',4,'',0,1,0,0),(19070,2386,'步文镇',4,'',0,1,0,0),(19071,2386,'郭坑镇',4,'',0,1,0,0),(19072,2386,'龙文工业开发区管委会',4,'',0,1,0,0),(19073,2387,'东园开发区',4,'',0,1,0,0),(19074,2387,'东园镇',4,'',0,1,0,0),(19075,2387,'东泗乡',4,'',0,1,0,0),(19076,2387,'九湖镇',4,'',0,1,0,0),(19077,2387,'九龙岭林场',4,'',0,1,0,0),(19078,2387,'双第华侨农场',4,'',0,1,0,0),(19079,2387,'招商局漳州开发区',4,'',0,1,0,0),(19080,2387,'林下林场',4,'',0,1,0,0),(19081,2387,'榜山镇',4,'',0,1,0,0),(19082,2387,'浮宫镇',4,'',0,1,0,0),(19083,2387,'海澄镇',4,'',0,1,0,0),(19084,2387,'港尾镇',4,'',0,1,0,0),(19085,2387,'白水镇',4,'',0,1,0,0),(19086,2387,'程溪农场',4,'',0,1,0,0),(19087,2387,'程溪镇',4,'',0,1,0,0),(19088,2387,'紫泥镇',4,'',0,1,0,0),(19089,2387,'良种场',4,'',0,1,0,0),(19090,2387,'苍坂农场',4,'',0,1,0,0),(19091,2387,'角美工业开发区',4,'',0,1,0,0),(19092,2387,'角美镇',4,'',0,1,0,0),(19093,2387,'隆教畲族乡',4,'',0,1,0,0),(19094,2387,'颜厝镇',4,'',0,1,0,0),(19095,2387,'龙池开发区',4,'',0,1,0,0),(19096,2388,'华桥乡',4,'',0,1,0,0),(19097,2388,'司前乡',4,'',0,1,0,0),(19098,2388,'寨里镇',4,'',0,1,0,0),(19099,2388,'崇仁乡',4,'',0,1,0,0),(19100,2388,'李坊乡',4,'',0,1,0,0),(19101,2388,'止马镇',4,'',0,1,0,0),(19102,2388,'鸾凤乡',4,'',0,1,0,0),(19103,2389,'南山镇',4,'',0,1,0,0),(19104,2389,'四鹤街道',4,'',0,1,0,0),(19105,2389,'塔前镇',4,'',0,1,0,0),(19106,2389,'夏道镇',4,'',0,1,0,0),(19107,2389,'大横镇',4,'',0,1,0,0),(19108,2389,'太平镇',4,'',0,1,0,0),(19109,2389,'峡阳镇',4,'',0,1,0,0),(19110,2389,'巨口乡',4,'',0,1,0,0),(19111,2389,'来舟镇',4,'',0,1,0,0),(19112,2389,'樟湖镇',4,'',0,1,0,0),(19113,2389,'水东街道',4,'',0,1,0,0),(19114,2389,'水南街道',4,'',0,1,0,0),(19115,2389,'洋后镇',4,'',0,1,0,0),(19116,2389,'炉下镇',4,'',0,1,0,0),(19117,2389,'王台镇',4,'',0,1,0,0),(19118,2389,'紫云街道',4,'',0,1,0,0),(19119,2389,'茫荡镇',4,'',0,1,0,0),(19120,2389,'西芹镇',4,'',0,1,0,0),(19121,2389,'赤门乡',4,'',0,1,0,0),(19122,2389,'黄墩街道',4,'',0,1,0,0),(19123,2390,'东峰镇',4,'',0,1,0,0),(19124,2390,'东游镇',4,'',0,1,0,0),(19125,2390,'南雅镇',4,'',0,1,0,0),(19126,2390,'吉阳镇',4,'',0,1,0,0),(19127,2390,'小松镇',4,'',0,1,0,0),(19128,2390,'小桥镇',4,'',0,1,0,0),(19129,2390,'川石乡',4,'',0,1,0,0),(19130,2390,'建安街道',4,'',0,1,0,0),(19131,2390,'徐墩镇',4,'',0,1,0,0),(19132,2390,'房道镇',4,'',0,1,0,0),(19133,2390,'水源乡',4,'',0,1,0,0),(19134,2390,'玉山镇',4,'',0,1,0,0),(19135,2390,'瓯宁街道',4,'',0,1,0,0),(19136,2390,'芝山街道',4,'',0,1,0,0),(19137,2390,'迪口镇',4,'',0,1,0,0),(19138,2390,'通济街道',4,'',0,1,0,0),(19139,2390,'顺阳乡',4,'',0,1,0,0),(19140,2390,'龙村乡',4,'',0,1,0,0),(19141,2391,'书坊乡',4,'',0,1,0,0),(19142,2391,'将口镇',4,'',0,1,0,0),(19143,2391,'小湖镇',4,'',0,1,0,0),(19144,2391,'崇雒乡',4,'',0,1,0,0),(19145,2391,'徐市镇',4,'',0,1,0,0),(19146,2391,'水吉镇',4,'',0,1,0,0),(19147,2391,'漳墩镇',4,'',0,1,0,0),(19148,2391,'潭城街道',4,'',0,1,0,0),(19149,2391,'童游街道',4,'',0,1,0,0),(19150,2391,'莒口镇',4,'',0,1,0,0),(19151,2391,'回龙乡',4,'',0,1,0,0),(19152,2391,'麻沙镇',4,'',0,1,0,0),(19153,2391,'黄坑镇',4,'',0,1,0,0),(19154,2392,'东平镇',4,'',0,1,0,0),(19155,2392,'外屯乡',4,'',0,1,0,0),(19156,2392,'岭腰乡',4,'',0,1,0,0),(19157,2392,'星溪乡',4,'',0,1,0,0),(19158,2392,'杨源乡',4,'',0,1,0,0),(19159,2392,'澄源乡',4,'',0,1,0,0),(19160,2392,'熊山镇',4,'',0,1,0,0),(19161,2392,'石屯镇',4,'',0,1,0,0),(19162,2392,'铁山镇',4,'',0,1,0,0),(19163,2392,'镇前镇',4,'',0,1,0,0),(19164,2393,'旧县乡',4,'',0,1,0,0),(19165,2393,'河东乡',4,'',0,1,0,0),(19166,2393,'渭田镇',4,'',0,1,0,0),(19167,2393,'溪东乡',4,'',0,1,0,0),(19168,2393,'祖墩乡',4,'',0,1,0,0),(19169,2393,'花桥乡',4,'',0,1,0,0),(19170,2393,'茶平乡',4,'',0,1,0,0),(19171,2393,'郑墩镇',4,'',0,1,0,0),(19172,2394,'上梅乡',4,'',0,1,0,0),(19173,2394,'五夫镇',4,'',0,1,0,0),(19174,2394,'兴田镇',4,'',0,1,0,0),(19175,2394,'吴屯乡',4,'',0,1,0,0),(19176,2394,'岚谷乡',4,'',0,1,0,0),(19177,2394,'新丰街道',4,'',0,1,0,0),(19178,2394,'星村镇',4,'',0,1,0,0),(19179,2394,'武夷街道',4,'',0,1,0,0),(19180,2394,'洋庄乡',4,'',0,1,0,0),(19181,2395,'万安乡',4,'',0,1,0,0),(19182,2395,'临江镇',4,'',0,1,0,0),(19183,2395,'九牧镇',4,'',0,1,0,0),(19184,2395,'仙阳镇',4,'',0,1,0,0),(19185,2395,'南浦镇',4,'',0,1,0,0),(19186,2395,'古楼乡',4,'',0,1,0,0),(19187,2395,'官路乡',4,'',0,1,0,0),(19188,2395,'富岭镇',4,'',0,1,0,0),(19189,2395,'山下乡',4,'',0,1,0,0),(19190,2395,'忠信镇',4,'',0,1,0,0),(19191,2395,'枫溪乡',4,'',0,1,0,0),(19192,2395,'水北街镇',4,'',0,1,0,0),(19193,2395,'水南乡',4,'',0,1,0,0),(19194,2395,'永兴镇',4,'',0,1,0,0),(19195,2395,'濠村乡',4,'',0,1,0,0),(19196,2395,'盘亭乡',4,'',0,1,0,0),(19197,2395,'石陂镇',4,'',0,1,0,0),(19198,2395,'管厝乡',4,'',0,1,0,0),(19199,2395,'莲塘镇',4,'',0,1,0,0),(19200,2396,'下沙镇',4,'',0,1,0,0),(19201,2396,'卫闽镇',4,'',0,1,0,0),(19202,2396,'吴家塘镇',4,'',0,1,0,0),(19203,2396,'和平镇',4,'',0,1,0,0),(19204,2396,'城郊镇',4,'',0,1,0,0),(19205,2396,'大埠岗镇',4,'',0,1,0,0),(19206,2396,'大竹镇',4,'',0,1,0,0),(19207,2396,'张厝乡',4,'',0,1,0,0),(19208,2396,'拿口镇',4,'',0,1,0,0),(19209,2396,'晒口街道',4,'',0,1,0,0),(19210,2396,'桂林乡',4,'',0,1,0,0),(19211,2396,'水北街道',4,'',0,1,0,0),(19212,2396,'水北镇',4,'',0,1,0,0),(19213,2396,'沿山镇',4,'',0,1,0,0),(19214,2396,'洪墩镇',4,'',0,1,0,0),(19215,2396,'肖家坊镇',4,'',0,1,0,0),(19216,2396,'通泰街道',4,'',0,1,0,0),(19217,2396,'金坑乡',4,'',0,1,0,0),(19218,2397,'仁寿镇',4,'',0,1,0,0),(19219,2397,'元坑镇',4,'',0,1,0,0),(19220,2397,'双溪镇',4,'',0,1,0,0),(19221,2397,'埔上镇',4,'',0,1,0,0),(19222,2397,'大历镇',4,'',0,1,0,0),(19223,2397,'大干镇',4,'',0,1,0,0),(19224,2397,'岚下乡',4,'',0,1,0,0),(19225,2397,'建西镇',4,'',0,1,0,0),(19226,2397,'水南镇',4,'',0,1,0,0),(19227,2397,'洋口镇',4,'',0,1,0,0),(19228,2397,'洋墩乡',4,'',0,1,0,0),(19229,2397,'郑坊乡',4,'',0,1,0,0),(19230,2397,'际会乡',4,'',0,1,0,0),(19231,2397,'高阳乡',4,'',0,1,0,0),(19232,2398,'下都乡',4,'',0,1,0,0),(19233,2398,'中都镇',4,'',0,1,0,0),(19234,2398,'临城镇',4,'',0,1,0,0),(19235,2398,'南阳镇',4,'',0,1,0,0),(19236,2398,'古田镇',4,'',0,1,0,0),(19237,2398,'太拔乡',4,'',0,1,0,0),(19238,2398,'官庄乡',4,'',0,1,0,0),(19239,2398,'庐丰乡',4,'',0,1,0,0),(19240,2398,'才溪村',4,'',0,1,0,0),(19241,2398,'旧县乡',4,'',0,1,0,0),(19242,2398,'步云乡',4,'',0,1,0,0),(19243,2398,'泮境乡',4,'',0,1,0,0),(19244,2398,'湖洋乡',4,'',0,1,0,0),(19245,2398,'溪口乡',4,'',0,1,0,0),(19246,2398,'珊瑚乡',4,'',0,1,0,0),(19247,2398,'白砂镇',4,'',0,1,0,0),(19248,2398,'稔田镇',4,'',0,1,0,0),(19249,2398,'茶地乡',4,'',0,1,0,0),(19250,2398,'蓝溪镇',4,'',0,1,0,0),(19251,2398,'蛟洋乡',4,'',0,1,0,0),(19252,2398,'通贤乡',4,'',0,1,0,0),(19253,2399,'万安镇',4,'',0,1,0,0),(19254,2399,'东肖街道',4,'',0,1,0,0),(19255,2399,'中城街道',4,'',0,1,0,0),(19256,2399,'南城街道',4,'',0,1,0,0),(19257,2399,'大池镇',4,'',0,1,0,0),(19258,2399,'小池镇',4,'',0,1,0,0),(19259,2399,'岩山乡',4,'',0,1,0,0),(19260,2399,'曹溪街道',4,'',0,1,0,0),(19261,2399,'江山乡',4,'',0,1,0,0),(19262,2399,'白沙镇',4,'',0,1,0,0),(19263,2399,'红坊镇',4,'',0,1,0,0),(19264,2399,'苏坂乡',4,'',0,1,0,0),(19265,2399,'西城街道',4,'',0,1,0,0),(19266,2399,'西陂街道',4,'',0,1,0,0),(19267,2399,'适中镇',4,'',0,1,0,0),(19268,2399,'铁山街道',4,'',0,1,0,0),(19269,2399,'雁石镇',4,'',0,1,0,0),(19270,2399,'龙门街道',4,'',0,1,0,0),(19271,2400,'万安乡',4,'',0,1,0,0),(19272,2400,'下坝乡',4,'',0,1,0,0),(19273,2400,'东留乡',4,'',0,1,0,0),(19274,2400,'中堡镇',4,'',0,1,0,0),(19275,2400,'中山镇',4,'',0,1,0,0),(19276,2400,'中赤乡',4,'',0,1,0,0),(19277,2400,'十方镇',4,'',0,1,0,0),(19278,2400,'城厢乡',4,'',0,1,0,0),(19279,2400,'大禾乡',4,'',0,1,0,0),(19280,2400,'岩前镇',4,'',0,1,0,0),(19281,2400,'桃溪镇',4,'',0,1,0,0),(19282,2400,'武东乡',4,'',0,1,0,0),(19283,2400,'民主乡',4,'',0,1,0,0),(19284,2400,'永平乡',4,'',0,1,0,0),(19285,2400,'湘店乡',4,'',0,1,0,0),(19286,2400,'象洞乡',4,'',0,1,0,0),(19287,2401,'下洋镇',4,'',0,1,0,0),(19288,2401,'仙师镇',4,'',0,1,0,0),(19289,2401,'古竹乡',4,'',0,1,0,0),(19290,2401,'合溪乡',4,'',0,1,0,0),(19291,2401,'坎市镇',4,'',0,1,0,0),(19292,2401,'城郊乡',4,'',0,1,0,0),(19293,2401,'培丰镇',4,'',0,1,0,0),(19294,2401,'堂堡乡',4,'',0,1,0,0),(19295,2401,'大溪乡',4,'',0,1,0,0),(19296,2401,'岐岭乡',4,'',0,1,0,0),(19297,2401,'峰市镇',4,'',0,1,0,0),(19298,2401,'抚市镇',4,'',0,1,0,0),(19299,2401,'洪山乡',4,'',0,1,0,0),(19300,2401,'湖坑镇',4,'',0,1,0,0),(19301,2401,'湖山乡',4,'',0,1,0,0),(19302,2401,'湖雷镇',4,'',0,1,0,0),(19303,2401,'虎岗乡',4,'',0,1,0,0),(19304,2401,'西溪乡',4,'',0,1,0,0),(19305,2401,'金砂乡',4,'',0,1,0,0),(19306,2401,'陈东乡',4,'',0,1,0,0),(19307,2401,'高头乡',4,'',0,1,0,0),(19308,2401,'高陂镇',4,'',0,1,0,0),(19309,2401,'龙潭镇',4,'',0,1,0,0),(19310,2402,'南洋乡',4,'',0,1,0,0),(19311,2402,'双洋镇',4,'',0,1,0,0),(19312,2402,'吾祠乡',4,'',0,1,0,0),(19313,2402,'和平镇',4,'',0,1,0,0),(19314,2402,'官田乡',4,'',0,1,0,0),(19315,2402,'拱桥镇',4,'',0,1,0,0),(19316,2402,'新桥镇',4,'',0,1,0,0),(19317,2402,'桂林街道',4,'',0,1,0,0),(19318,2402,'永福镇',4,'',0,1,0,0),(19319,2402,'溪南镇',4,'',0,1,0,0),(19320,2402,'灵地乡',4,'',0,1,0,0),(19321,2402,'芦芝乡',4,'',0,1,0,0),(19322,2402,'菁城街道',4,'',0,1,0,0),(19323,2402,'西园乡',4,'',0,1,0,0),(19324,2402,'象湖镇',4,'',0,1,0,0),(19325,2402,'赤水镇',4,'',0,1,0,0),(19326,2403,'北团镇',4,'',0,1,0,0),(19327,2403,'四堡乡',4,'',0,1,0,0),(19328,2403,'塘前乡',4,'',0,1,0,0),(19329,2403,'姑田镇',4,'',0,1,0,0),(19330,2403,'宣和乡',4,'',0,1,0,0),(19331,2403,'庙前镇',4,'',0,1,0,0),(19332,2403,'揭乐乡',4,'',0,1,0,0),(19333,2403,'文亨乡',4,'',0,1,0,0),(19334,2403,'新泉镇',4,'',0,1,0,0),(19335,2403,'曲溪乡',4,'',0,1,0,0),(19336,2403,'朋口镇',4,'',0,1,0,0),(19337,2403,'李屋乡',4,'',0,1,0,0),(19338,2403,'林坊乡',4,'',0,1,0,0),(19339,2403,'罗坊乡',4,'',0,1,0,0),(19340,2403,'莒溪镇',4,'',0,1,0,0),(19341,2403,'莲峰镇',4,'',0,1,0,0),(19342,2403,'赖源乡',4,'',0,1,0,0),(19343,2403,'隔川乡',4,'',0,1,0,0),(19344,2404,'三洲乡',4,'',0,1,0,0),(19345,2404,'南山镇',4,'',0,1,0,0),(19346,2404,'古城镇',4,'',0,1,0,0),(19347,2404,'四都镇',4,'',0,1,0,0),(19348,2404,'大同镇',4,'',0,1,0,0),(19349,2404,'宣成乡',4,'',0,1,0,0),(19350,2404,'庵杰乡',4,'',0,1,0,0),(19351,2404,'新桥镇',4,'',0,1,0,0),(19352,2404,'汀州镇',4,'',0,1,0,0),(19353,2404,'河田镇',4,'',0,1,0,0),(19354,2404,'涂坊镇',4,'',0,1,0,0),(19355,2404,'濯田镇',4,'',0,1,0,0),(19356,2404,'童坊镇',4,'',0,1,0,0),(19357,2404,'策武乡',4,'',0,1,0,0),(19358,2404,'红山乡',4,'',0,1,0,0),(19359,2404,'羊牯乡',4,'',0,1,0,0),(19360,2404,'铁长乡',4,'',0,1,0,0),(19361,2404,'馆前镇',4,'',0,1,0,0),(19362,2405,'凤埔乡',4,'',0,1,0,0),(19363,2405,'凤都镇',4,'',0,1,0,0),(19364,2405,'卓洋乡',4,'',0,1,0,0),(19365,2405,'吉巷乡',4,'',0,1,0,0),(19366,2405,'大桥镇',4,'',0,1,0,0),(19367,2405,'大甲乡',4,'',0,1,0,0),(19368,2405,'平湖镇',4,'',0,1,0,0),(19369,2405,'新城镇',4,'',0,1,0,0),(19370,2405,'杉洋镇',4,'',0,1,0,0),(19371,2405,'松吉乡',4,'',0,1,0,0),(19372,2405,'水口镇',4,'',0,1,0,0),(19373,2405,'泮洋乡',4,'',0,1,0,0),(19374,2405,'湖滨乡',4,'',0,1,0,0),(19375,2405,'鹤塘镇',4,'',0,1,0,0),(19376,2405,'黄田镇',4,'',0,1,0,0),(19377,2406,'七步镇',4,'',0,1,0,0),(19378,2406,'咸村镇',4,'',0,1,0,0),(19379,2406,'李墩镇',4,'',0,1,0,0),(19380,2406,'泗桥乡',4,'',0,1,0,0),(19381,2406,'浦源镇',4,'',0,1,0,0),(19382,2406,'玛坑乡',4,'',0,1,0,0),(19383,2406,'礼门乡',4,'',0,1,0,0),(19384,2406,'纯池镇',4,'',0,1,0,0),(19385,2407,'下党乡',4,'',0,1,0,0),(19386,2407,'凤阳乡',4,'',0,1,0,0),(19387,2407,'南阳镇',4,'',0,1,0,0),(19388,2407,'坑底乡',4,'',0,1,0,0),(19389,2407,'大安乡',4,'',0,1,0,0),(19390,2407,'平溪乡',4,'',0,1,0,0),(19391,2407,'托溪乡',4,'',0,1,0,0),(19392,2407,'斜滩镇',4,'',0,1,0,0),(19393,2407,'武曲镇',4,'',0,1,0,0),(19394,2407,'清源乡',4,'',0,1,0,0),(19395,2407,'犀溪乡',4,'',0,1,0,0),(19396,2407,'竹管垅乡',4,'',0,1,0,0),(19397,2407,'芹洋乡',4,'',0,1,0,0),(19398,2408,'双溪镇',4,'',0,1,0,0),(19399,2408,'寿山乡',4,'',0,1,0,0),(19400,2408,'屏城乡',4,'',0,1,0,0),(19401,2408,'岭下乡',4,'',0,1,0,0),(19402,2408,'棠口乡',4,'',0,1,0,0),(19403,2408,'熙岭乡',4,'',0,1,0,0),(19404,2408,'甘棠乡',4,'',0,1,0,0),(19405,2408,'路下乡',4,'',0,1,0,0),(19406,2408,'长桥镇',4,'',0,1,0,0),(19407,2408,'黛溪镇',4,'',0,1,0,0),(19408,2409,'东源乡',4,'',0,1,0,0),(19409,2409,'乍洋乡',4,'',0,1,0,0),(19410,2409,'城郊乡',4,'',0,1,0,0),(19411,2409,'宅中乡',4,'',0,1,0,0),(19412,2409,'富溪镇',4,'',0,1,0,0),(19413,2409,'楮坪乡',4,'',0,1,0,0),(19414,2409,'英山乡',4,'',0,1,0,0),(19415,2409,'黄柏乡',4,'',0,1,0,0),(19416,2410,'赛岐开发区',4,'',0,1,0,0),(19417,2410,'上白石镇',4,'',0,1,0,0),(19418,2410,'下白石镇',4,'',0,1,0,0),(19419,2410,'坂中畲族乡',4,'',0,1,0,0),(19420,2410,'城北街道',4,'',0,1,0,0),(19421,2410,'城阳乡',4,'',0,1,0,0),(19422,2410,'康厝畲族乡',4,'',0,1,0,0),(19423,2410,'晓阳镇',4,'',0,1,0,0),(19424,2410,'松罗乡',4,'',0,1,0,0),(19425,2410,'湾坞乡',4,'',0,1,0,0),(19426,2410,'溪尾镇',4,'',0,1,0,0),(19427,2410,'溪柄镇',4,'',0,1,0,0),(19428,2410,'溪潭镇',4,'',0,1,0,0),(19429,2410,'潭头镇',4,'',0,1,0,0),(19430,2410,'甘棠镇',4,'',0,1,0,0),(19431,2410,'社口镇',4,'',0,1,0,0),(19432,2410,'穆云畲族乡',4,'',0,1,0,0),(19433,2410,'穆阳镇',4,'',0,1,0,0),(19434,2410,'范坑乡',4,'',0,1,0,0),(19435,2410,'赛岐镇',4,'',0,1,0,0),(19436,2410,'阳头街道',4,'',0,1,0,0),(19437,2411,'龙安开发区',4,'',0,1,0,0),(19438,2411,'佳阳乡',4,'',0,1,0,0),(19439,2411,'前岐镇',4,'',0,1,0,0),(19440,2411,'叠石乡',4,'',0,1,0,0),(19441,2411,'山前街道',4,'',0,1,0,0),(19442,2411,'嵛山镇',4,'',0,1,0,0),(19443,2411,'店下镇',4,'',0,1,0,0),(19444,2411,'桐城街道',4,'',0,1,0,0),(19445,2411,'沙埕镇',4,'',0,1,0,0),(19446,2411,'点头镇',4,'',0,1,0,0),(19447,2411,'白琳镇',4,'',0,1,0,0),(19448,2411,'硖门畲族乡',4,'',0,1,0,0),(19449,2411,'磻溪镇',4,'',0,1,0,0),(19450,2411,'秦屿镇',4,'',0,1,0,0),(19451,2411,'管阳镇',4,'',0,1,0,0),(19452,2411,'贯岭镇',4,'',0,1,0,0),(19453,2412,'东侨开发区',4,'',0,1,0,0),(19454,2412,'七都镇',4,'',0,1,0,0),(19455,2412,'三都镇',4,'',0,1,0,0),(19456,2412,'九都镇',4,'',0,1,0,0),(19457,2412,'八都镇',4,'',0,1,0,0),(19458,2412,'城南镇',4,'',0,1,0,0),(19459,2412,'洋中镇',4,'',0,1,0,0),(19460,2412,'洪口乡',4,'',0,1,0,0),(19461,2412,'漳湾镇',4,'',0,1,0,0),(19462,2412,'石后乡',4,'',0,1,0,0),(19463,2412,'蕉北街道',4,'',0,1,0,0),(19464,2412,'虎贝乡',4,'',0,1,0,0),(19465,2412,'赤溪镇',4,'',0,1,0,0),(19466,2412,'金涵畲族乡',4,'',0,1,0,0),(19467,2412,'霍童镇',4,'',0,1,0,0),(19468,2412,'飞鸾镇',4,'',0,1,0,0),(19469,2413,'三沙镇',4,'',0,1,0,0),(19470,2413,'下浒镇',4,'',0,1,0,0),(19471,2413,'北壁乡',4,'',0,1,0,0),(19472,2413,'崇儒畲族乡',4,'',0,1,0,0),(19473,2413,'松港街道',4,'',0,1,0,0),(19474,2413,'柏洋乡',4,'',0,1,0,0),(19475,2413,'水门畲族乡',4,'',0,1,0,0),(19476,2413,'沙江镇',4,'',0,1,0,0),(19477,2413,'海岛乡',4,'',0,1,0,0),(19478,2413,'溪南镇',4,'',0,1,0,0),(19479,2413,'牙城镇',4,'',0,1,0,0),(19480,2413,'盐田畲族乡',4,'',0,1,0,0),(19481,2413,'长春镇',4,'',0,1,0,0),(19482,2414,'八一桥街道',4,'',0,1,0,0),(19483,2414,'公园街道',4,'',0,1,0,0),(19484,2414,'墩子塘街道',4,'',0,1,0,0),(19485,2414,'大院街道',4,'',0,1,0,0),(19486,2414,'彭家桥街道',4,'',0,1,0,0),(19487,2414,'沙井街道',4,'',0,1,0,0),(19488,2414,'滕王阁街道',4,'',0,1,0,0),(19489,2414,'百花洲街道',4,'',0,1,0,0),(19490,2414,'董家窑街道',4,'',0,1,0,0),(19491,2414,'豫章街道',4,'',0,1,0,0),(19492,2414,'贤士湖管委会',4,'',0,1,0,0),(19493,2415,'三江镇',4,'',0,1,0,0),(19494,2415,'东新乡',4,'',0,1,0,0),(19495,2415,'八一乡',4,'',0,1,0,0),(19496,2415,'南新乡',4,'',0,1,0,0),(19497,2415,'向塘镇',4,'',0,1,0,0),(19498,2415,'塔城乡',4,'',0,1,0,0),(19499,2415,'塘南镇',4,'',0,1,0,0),(19500,2415,'富山乡',4,'',0,1,0,0),(19501,2415,'岗上镇',4,'',0,1,0,0),(19502,2415,'幽兰镇',4,'',0,1,0,0),(19503,2415,'广福镇',4,'',0,1,0,0),(19504,2415,'昌东镇',4,'',0,1,0,0),(19505,2415,'武阳镇',4,'',0,1,0,0),(19506,2415,'泾口乡',4,'',0,1,0,0),(19507,2415,'莲塘镇',4,'',0,1,0,0),(19508,2415,'蒋巷镇',4,'',0,1,0,0),(19509,2415,'麻丘镇',4,'',0,1,0,0),(19510,2415,'黄马乡',4,'',0,1,0,0),(19511,2416,'万埠镇',4,'',0,1,0,0),(19512,2416,'东阳镇',4,'',0,1,0,0),(19513,2416,'乔乐乡',4,'',0,1,0,0),(19514,2416,'新民乡',4,'',0,1,0,0),(19515,2416,'石鼻镇',4,'',0,1,0,0),(19516,2416,'长均乡',4,'',0,1,0,0),(19517,2416,'长埠镇',4,'',0,1,0,0),(19518,2416,'黄洲镇',4,'',0,1,0,0),(19519,2416,'鼎湖镇',4,'',0,1,0,0),(19520,2416,'龙津镇',4,'',0,1,0,0),(19521,2417,'乐化镇',4,'',0,1,0,0),(19522,2417,'南矶乡',4,'',0,1,0,0),(19523,2417,'厚田乡',4,'',0,1,0,0),(19524,2417,'大塘坪乡',4,'',0,1,0,0),(19525,2417,'昌邑乡',4,'',0,1,0,0),(19526,2417,'望城镇',4,'',0,1,0,0),(19527,2417,'松湖镇',4,'',0,1,0,0),(19528,2417,'樵舍镇',4,'',0,1,0,0),(19529,2417,'流湖乡',4,'',0,1,0,0),(19530,2417,'溪霞镇',4,'',0,1,0,0),(19531,2417,'生米镇',4,'',0,1,0,0),(19532,2417,'石埠乡',4,'',0,1,0,0),(19533,2417,'石岗镇',4,'',0,1,0,0),(19534,2417,'联圩乡',4,'',0,1,0,0),(19535,2417,'西山镇',4,'',0,1,0,0),(19536,2417,'象山镇',4,'',0,1,0,0),(19537,2417,'金桥乡',4,'',0,1,0,0),(19538,2417,'铁河乡',4,'',0,1,0,0),(19539,2417,'长堎镇',4,'',0,1,0,0),(19540,2418,'太平乡',4,'',0,1,0,0),(19541,2418,'幸福街道',4,'',0,1,0,0),(19542,2418,'招贤镇',4,'',0,1,0,0),(19543,2418,'梅岭镇',4,'',0,1,0,0),(19544,2418,'站前街道',4,'',0,1,0,0),(19545,2418,'罗亭镇',4,'',0,1,0,0),(19546,2419,'丁公路街道',4,'',0,1,0,0),(19547,2419,'十字街街道',4,'',0,1,0,0),(19548,2419,'南浦街道',4,'',0,1,0,0),(19549,2419,'南站街道',4,'',0,1,0,0),(19550,2419,'广润门街道',4,'',0,1,0,0),(19551,2419,'朝阳洲街道',4,'',0,1,0,0),(19552,2419,'桃源街道',4,'',0,1,0,0),(19553,2419,'桃花镇',4,'',0,1,0,0),(19554,2419,'系马桩街道',4,'',0,1,0,0),(19555,2419,'绳金塔街道',4,'',0,1,0,0),(19556,2419,'西湖街道',4,'',0,1,0,0),(19557,2420,'七里乡',4,'',0,1,0,0),(19558,2420,'三里乡',4,'',0,1,0,0),(19559,2420,'三阳集乡',4,'',0,1,0,0),(19560,2420,'下埠集乡',4,'',0,1,0,0),(19561,2420,'二塘乡',4,'',0,1,0,0),(19562,2420,'前坊镇',4,'',0,1,0,0),(19563,2420,'南台乡',4,'',0,1,0,0),(19564,2420,'张公镇',4,'',0,1,0,0),(19565,2420,'文港镇',4,'',0,1,0,0),(19566,2420,'李渡镇',4,'',0,1,0,0),(19567,2420,'架桥镇',4,'',0,1,0,0),(19568,2420,'梅庄镇',4,'',0,1,0,0),(19569,2420,'民和镇',4,'',0,1,0,0),(19570,2420,'池溪乡',4,'',0,1,0,0),(19571,2420,'泉岭乡',4,'',0,1,0,0),(19572,2420,'温圳镇',4,'',0,1,0,0),(19573,2420,'白圩乡',4,'',0,1,0,0),(19574,2420,'罗溪镇',4,'',0,1,0,0),(19575,2420,'衙前乡',4,'',0,1,0,0),(19576,2420,'钟陵乡',4,'',0,1,0,0),(19577,2420,'长山晏乡',4,'',0,1,0,0),(19578,2421,'三家店街道',4,'',0,1,0,0),(19579,2421,'京山街道',4,'',0,1,0,0),(19580,2421,'岱山街道',4,'',0,1,0,0),(19581,2421,'徐家坊街道',4,'',0,1,0,0),(19582,2421,'洪都街道',4,'',0,1,0,0),(19583,2421,'青云谱镇',4,'',0,1,0,0),(19584,2422,'上海路街道',4,'',0,1,0,0),(19585,2422,'京东镇',4,'',0,1,0,0),(19586,2422,'塘山镇',4,'',0,1,0,0),(19587,2422,'扬子洲乡',4,'',0,1,0,0),(19588,2422,'湖坊镇',4,'',0,1,0,0),(19589,2422,'罗家镇',4,'',0,1,0,0),(19590,2422,'蛟桥镇',4,'',0,1,0,0),(19591,2422,'青山路街道',4,'',0,1,0,0),(19592,2423,'临港镇',4,'',0,1,0,0),(19593,2423,'乐港镇',4,'',0,1,0,0),(19594,2423,'众埠镇',4,'',0,1,0,0),(19595,2423,'十里岗乡',4,'',0,1,0,0),(19596,2423,'双田镇',4,'',0,1,0,0),(19597,2423,'后港镇',4,'',0,1,0,0),(19598,2423,'塔前镇',4,'',0,1,0,0),(19599,2423,'塔山街道',4,'',0,1,0,0),(19600,2423,'接渡镇',4,'',0,1,0,0),(19601,2423,'洎阳街道',4,'',0,1,0,0),(19602,2423,'洪岩镇',4,'',0,1,0,0),(19603,2423,'洺口镇',4,'',0,1,0,0),(19604,2423,'浯口镇',4,'',0,1,0,0),(19605,2423,'涌山镇',4,'',0,1,0,0),(19606,2423,'礼林镇',4,'',0,1,0,0),(19607,2423,'金鹅山乡',4,'',0,1,0,0),(19608,2423,'镇桥镇',4,'',0,1,0,0),(19609,2423,'高家镇',4,'',0,1,0,0),(19610,2423,'鸬鹚乡',4,'',0,1,0,0),(19611,2424,'丽阳乡',4,'',0,1,0,0),(19612,2424,'吕蒙乡',4,'',0,1,0,0),(19613,2424,'昌江区开发区',4,'',0,1,0,0),(19614,2424,'景德镇高新区管委会',4,'',0,1,0,0),(19615,2424,'竟成镇',4,'',0,1,0,0),(19616,2424,'荷塘乡',4,'',0,1,0,0),(19617,2424,'西郊垦殖场',4,'',0,1,0,0),(19618,2424,'西郊街道',4,'',0,1,0,0),(19619,2424,'鲇鱼山镇',4,'',0,1,0,0),(19620,2425,'三龙乡',4,'',0,1,0,0),(19621,2425,'兴田乡',4,'',0,1,0,0),(19622,2425,'勒功乡',4,'',0,1,0,0),(19623,2425,'寿安镇',4,'',0,1,0,0),(19624,2425,'峙滩乡',4,'',0,1,0,0),(19625,2425,'庄湾乡',4,'',0,1,0,0),(19626,2425,'江村乡',4,'',0,1,0,0),(19627,2425,'洪源镇',4,'',0,1,0,0),(19628,2425,'浮梁镇',4,'',0,1,0,0),(19629,2425,'湘湖镇',4,'',0,1,0,0),(19630,2425,'王港乡',4,'',0,1,0,0),(19631,2425,'瑶里镇',4,'',0,1,0,0),(19632,2425,'经公桥镇',4,'',0,1,0,0),(19633,2425,'蛟潭镇',4,'',0,1,0,0),(19634,2425,'西湖乡',4,'',0,1,0,0),(19635,2425,'鹅湖镇',4,'',0,1,0,0),(19636,2425,'黄坛乡',4,'',0,1,0,0),(19637,2426,'周路口街道',4,'',0,1,0,0),(19638,2426,'太白园街道',4,'',0,1,0,0),(19639,2426,'新厂街道',4,'',0,1,0,0),(19640,2426,'新村街道',4,'',0,1,0,0),(19641,2426,'昌江街道',4,'',0,1,0,0),(19642,2426,'昌河街道',4,'',0,1,0,0),(19643,2426,'珠山街道',4,'',0,1,0,0),(19644,2426,'石狮埠街道',4,'',0,1,0,0),(19645,2426,'里村街道',4,'',0,1,0,0),(19646,2427,'上栗镇',4,'',0,1,0,0),(19647,2427,'东源乡',4,'',0,1,0,0),(19648,2427,'彭高镇',4,'',0,1,0,0),(19649,2427,'桐木镇',4,'',0,1,0,0),(19650,2427,'福田镇',4,'',0,1,0,0),(19651,2427,'赤山镇',4,'',0,1,0,0),(19652,2427,'金山镇',4,'',0,1,0,0),(19653,2427,'长平乡',4,'',0,1,0,0),(19654,2427,'鸡冠山乡',4,'',0,1,0,0),(19655,2428,'丹江街道',4,'',0,1,0,0),(19656,2428,'五陂镇',4,'',0,1,0,0),(19657,2428,'八一街道',4,'',0,1,0,0),(19658,2428,'凤凰街道',4,'',0,1,0,0),(19659,2428,'后埠街道',4,'',0,1,0,0),(19660,2428,'安源镇',4,'',0,1,0,0),(19661,2428,'白源街道',4,'',0,1,0,0),(19662,2428,'青山镇',4,'',0,1,0,0),(19663,2428,'高坑镇',4,'',0,1,0,0),(19664,2429,'下埠镇',4,'',0,1,0,0),(19665,2429,'东桥镇',4,'',0,1,0,0),(19666,2429,'峡山口街道',4,'',0,1,0,0),(19667,2429,'广寒寨乡',4,'',0,1,0,0),(19668,2429,'排上镇',4,'',0,1,0,0),(19669,2429,'湘东镇',4,'',0,1,0,0),(19670,2429,'白竺乡',4,'',0,1,0,0),(19671,2429,'老关镇',4,'',0,1,0,0),(19672,2429,'腊市镇',4,'',0,1,0,0),(19673,2429,'荷尧镇',4,'',0,1,0,0),(19674,2429,'麻山镇',4,'',0,1,0,0),(19675,2430,'万龙山乡',4,'',0,1,0,0),(19676,2430,'上埠镇',4,'',0,1,0,0),(19677,2430,'南坑镇',4,'',0,1,0,0),(19678,2430,'宣风镇',4,'',0,1,0,0),(19679,2430,'张佳坊乡',4,'',0,1,0,0),(19680,2430,'新泉乡',4,'',0,1,0,0),(19681,2430,'源南乡',4,'',0,1,0,0),(19682,2430,'芦溪镇',4,'',0,1,0,0),(19683,2430,'银河镇',4,'',0,1,0,0),(19684,2430,'长丰乡',4,'',0,1,0,0),(19685,2431,'三板桥乡',4,'',0,1,0,0),(19686,2431,'六市乡',4,'',0,1,0,0),(19687,2431,'升坊镇',4,'',0,1,0,0),(19688,2431,'南岭乡',4,'',0,1,0,0),(19689,2431,'坊楼镇',4,'',0,1,0,0),(19690,2431,'湖上乡',4,'',0,1,0,0),(19691,2431,'琴亭镇',4,'',0,1,0,0),(19692,2431,'神泉乡',4,'',0,1,0,0),(19693,2431,'良坊镇',4,'',0,1,0,0),(19694,2431,'荷塘乡',4,'',0,1,0,0),(19695,2431,'路口镇',4,'',0,1,0,0),(19696,2431,'闪石乡',4,'',0,1,0,0),(19697,2431,'高洲乡',4,'',0,1,0,0),(19698,2432,'城子镇',4,'',0,1,0,0),(19699,2432,'城门乡',4,'',0,1,0,0),(19700,2432,'岷山乡',4,'',0,1,0,0),(19701,2432,'新合镇',4,'',0,1,0,0),(19702,2432,'新塘乡',4,'',0,1,0,0),(19703,2432,'永安乡',4,'',0,1,0,0),(19704,2432,'江洲镇',4,'',0,1,0,0),(19705,2432,'沙河街镇',4,'',0,1,0,0),(19706,2432,'涌泉乡',4,'',0,1,0,0),(19707,2432,'港口街镇',4,'',0,1,0,0),(19708,2432,'狮子镇',4,'',0,1,0,0),(19709,2432,'马回岭镇',4,'',0,1,0,0),(19710,2433,'三都镇',4,'',0,1,0,0),(19711,2433,'上奉镇',4,'',0,1,0,0),(19712,2433,'上杭乡',4,'',0,1,0,0),(19713,2433,'上衫乡',4,'',0,1,0,0),(19714,2433,'东港乡',4,'',0,1,0,0),(19715,2433,'义宁镇',4,'',0,1,0,0),(19716,2433,'何市镇',4,'',0,1,0,0),(19717,2433,'余段乡',4,'',0,1,0,0),(19718,2433,'全丰镇',4,'',0,1,0,0),(19719,2433,'古市镇',4,'',0,1,0,0),(19720,2433,'四都镇',4,'',0,1,0,0),(19721,2433,'复源乡',4,'',0,1,0,0),(19722,2433,'大桥镇',4,'',0,1,0,0),(19723,2433,'大椿乡',4,'',0,1,0,0),(19724,2433,'山口镇',4,'',0,1,0,0),(19725,2433,'布甲乡',4,'',0,1,0,0),(19726,2433,'庙岭乡',4,'',0,1,0,0),(19727,2433,'征村乡',4,'',0,1,0,0),(19728,2433,'新湾乡',4,'',0,1,0,0),(19729,2433,'杭口镇',4,'',0,1,0,0),(19730,2433,'水源乡',4,'',0,1,0,0),(19731,2433,'渣津镇',4,'',0,1,0,0),(19732,2433,'港口镇',4,'',0,1,0,0),(19733,2433,'溪口镇',4,'',0,1,0,0),(19734,2433,'漫江乡',4,'',0,1,0,0),(19735,2433,'白岭镇',4,'',0,1,0,0),(19736,2433,'石坳乡',4,'',0,1,0,0),(19737,2433,'程坊乡',4,'',0,1,0,0),(19738,2433,'竹坪乡',4,'',0,1,0,0),(19739,2433,'西港镇',4,'',0,1,0,0),(19740,2433,'路口乡',4,'',0,1,0,0),(19741,2433,'马坳镇',4,'',0,1,0,0),(19742,2433,'黄坳乡',4,'',0,1,0,0),(19743,2433,'黄沙镇',4,'',0,1,0,0),(19744,2433,'黄港镇',4,'',0,1,0,0),(19745,2433,'黄龙乡',4,'',0,1,0,0),(19746,2434,'七里湖街道',4,'',0,1,0,0),(19747,2434,'五里街道',4,'',0,1,0,0),(19748,2434,'十里街道',4,'',0,1,0,0),(19749,2434,'姑塘镇',4,'',0,1,0,0),(19750,2434,'威家镇',4,'',0,1,0,0),(19751,2434,'新港镇',4,'',0,1,0,0),(19752,2434,'海会镇',4,'',0,1,0,0),(19753,2434,'牯岭镇',4,'',0,1,0,0),(19754,2434,'莲花镇',4,'',0,1,0,0),(19755,2434,'虞家河乡',4,'',0,1,0,0),(19756,2434,'赛阳镇',4,'',0,1,0,0),(19757,2435,'东升镇',4,'',0,1,0,0),(19758,2435,'天红镇',4,'',0,1,0,0),(19759,2435,'太平关乡',4,'',0,1,0,0),(19760,2435,'定山镇',4,'',0,1,0,0),(19761,2435,'杨梓镇',4,'',0,1,0,0),(19762,2435,'棉船镇',4,'',0,1,0,0),(19763,2435,'浩山乡',4,'',0,1,0,0),(19764,2435,'浪溪镇',4,'',0,1,0,0),(19765,2435,'芙蓉墩镇',4,'',0,1,0,0),(19766,2435,'马垱镇',4,'',0,1,0,0),(19767,2435,'黄岭乡',4,'',0,1,0,0),(19768,2435,'黄花镇',4,'',0,1,0,0),(19769,2435,'龙城镇',4,'',0,1,0,0),(19770,2436,'丰林镇',4,'',0,1,0,0),(19771,2436,'共青开放开发区城区',4,'',0,1,0,0),(19772,2436,'吴山乡',4,'',0,1,0,0),(19773,2436,'园艺场',4,'',0,1,0,0),(19774,2436,'塘山乡',4,'',0,1,0,0),(19775,2436,'宝塔乡',4,'',0,1,0,0),(19776,2436,'彭山林场',4,'',0,1,0,0),(19777,2436,'林泉乡',4,'',0,1,0,0),(19778,2436,'江益镇',4,'',0,1,0,0),(19779,2436,'河东乡',4,'',0,1,0,0),(19780,2436,'爱民乡',4,'',0,1,0,0),(19781,2436,'甘露镇',4,'',0,1,0,0),(19782,2436,'磨溪乡',4,'',0,1,0,0),(19783,2436,'聂桥镇',4,'',0,1,0,0),(19784,2436,'茶山街道',4,'',0,1,0,0),(19785,2436,'蒲亭镇',4,'',0,1,0,0),(19786,2436,'车桥镇',4,'',0,1,0,0),(19787,2436,'邹桥乡',4,'',0,1,0,0),(19788,2436,'金湖镇',4,'',0,1,0,0),(19789,2436,'高塘乡',4,'',0,1,0,0),(19790,2437,'华林镇',4,'',0,1,0,0),(19791,2437,'南康镇',4,'',0,1,0,0),(19792,2437,'横塘镇',4,'',0,1,0,0),(19793,2437,'泽泉乡',4,'',0,1,0,0),(19794,2437,'温泉镇',4,'',0,1,0,0),(19795,2437,'白鹿镇',4,'',0,1,0,0),(19796,2437,'苏家当乡',4,'',0,1,0,0),(19797,2437,'蓼南乡',4,'',0,1,0,0),(19798,2437,'蓼花镇',4,'',0,1,0,0),(19799,2437,'蛟塘镇',4,'',0,1,0,0),(19800,2438,'上汤乡',4,'',0,1,0,0),(19801,2438,'东林乡',4,'',0,1,0,0),(19802,2438,'大洞乡',4,'',0,1,0,0),(19803,2438,'宋溪镇',4,'',0,1,0,0),(19804,2438,'官莲乡',4,'',0,1,0,0),(19805,2438,'巾口乡',4,'',0,1,0,0),(19806,2438,'新宁镇',4,'',0,1,0,0),(19807,2438,'杨洲乡',4,'',0,1,0,0),(19808,2438,'横路乡',4,'',0,1,0,0),(19809,2438,'泉口镇',4,'',0,1,0,0),(19810,2438,'清江乡',4,'',0,1,0,0),(19811,2438,'澧溪镇',4,'',0,1,0,0),(19812,2438,'甫田乡',4,'',0,1,0,0),(19813,2438,'石渡乡',4,'',0,1,0,0),(19814,2438,'石门楼镇',4,'',0,1,0,0),(19815,2438,'罗坪镇',4,'',0,1,0,0),(19816,2438,'罗溪乡',4,'',0,1,0,0),(19817,2438,'船滩镇',4,'',0,1,0,0),(19818,2438,'鲁溪镇',4,'',0,1,0,0),(19819,2439,'三溪桥镇',4,'',0,1,0,0),(19820,2439,'三角乡',4,'',0,1,0,0),(19821,2439,'九合乡',4,'',0,1,0,0),(19822,2439,'吴城镇',4,'',0,1,0,0),(19823,2439,'柘林镇',4,'',0,1,0,0),(19824,2439,'梅棠镇',4,'',0,1,0,0),(19825,2439,'江上乡',4,'',0,1,0,0),(19826,2439,'江益镇',4,'',0,1,0,0),(19827,2439,'涂埠镇',4,'',0,1,0,0),(19828,2439,'滩溪镇',4,'',0,1,0,0),(19829,2439,'燕坊镇',4,'',0,1,0,0),(19830,2439,'白槎镇',4,'',0,1,0,0),(19831,2439,'立新乡',4,'',0,1,0,0),(19832,2439,'艾城镇',4,'',0,1,0,0),(19833,2439,'虬津镇',4,'',0,1,0,0),(19834,2439,'马口镇',4,'',0,1,0,0),(19835,2440,'人民路街道',4,'',0,1,0,0),(19836,2440,'向阳街道',4,'',0,1,0,0),(19837,2440,'湓浦街道',4,'',0,1,0,0),(19838,2440,'滨兴街道',4,'',0,1,0,0),(19839,2440,'甘棠街道',4,'',0,1,0,0),(19840,2440,'白水湖街道',4,'',0,1,0,0),(19841,2440,'金鸡坡街道',4,'',0,1,0,0),(19842,2441,'付垅乡',4,'',0,1,0,0),(19843,2441,'凰村乡',4,'',0,1,0,0),(19844,2441,'双钟镇',4,'',0,1,0,0),(19845,2441,'城山镇',4,'',0,1,0,0),(19846,2441,'大垅乡',4,'',0,1,0,0),(19847,2441,'张青乡',4,'',0,1,0,0),(19848,2441,'文桥乡',4,'',0,1,0,0),(19849,2441,'武山镇',4,'',0,1,0,0),(19850,2441,'流泗镇',4,'',0,1,0,0),(19851,2441,'流芳乡',4,'',0,1,0,0),(19852,2441,'舜德乡',4,'',0,1,0,0),(19853,2441,'马影镇',4,'',0,1,0,0),(19854,2442,'乐园乡',4,'',0,1,0,0),(19855,2442,'南义镇',4,'',0,1,0,0),(19856,2442,'南阳乡',4,'',0,1,0,0),(19857,2442,'夏畈镇',4,'',0,1,0,0),(19858,2442,'大德山林场',4,'',0,1,0,0),(19859,2442,'桂林街道',4,'',0,1,0,0),(19860,2442,'横港镇',4,'',0,1,0,0),(19861,2442,'横立山乡',4,'',0,1,0,0),(19862,2442,'武蛟乡',4,'',0,1,0,0),(19863,2442,'洪一乡',4,'',0,1,0,0),(19864,2442,'洪下乡',4,'',0,1,0,0),(19865,2442,'湓城街道',4,'',0,1,0,0),(19866,2442,'白杨镇',4,'',0,1,0,0),(19867,2442,'码头镇',4,'',0,1,0,0),(19868,2442,'肇陈镇',4,'',0,1,0,0),(19869,2442,'花园乡',4,'',0,1,0,0),(19870,2442,'范镇',4,'',0,1,0,0),(19871,2442,'赛湖农场',4,'',0,1,0,0),(19872,2442,'青山林场',4,'',0,1,0,0),(19873,2442,'高丰镇',4,'',0,1,0,0),(19874,2442,'黄金乡',4,'',0,1,0,0),(19875,2443,'万户镇',4,'',0,1,0,0),(19876,2443,'三汊港镇',4,'',0,1,0,0),(19877,2443,'中馆镇',4,'',0,1,0,0),(19878,2443,'北山乡',4,'',0,1,0,0),(19879,2443,'南峰镇',4,'',0,1,0,0),(19880,2443,'周溪镇',4,'',0,1,0,0),(19881,2443,'和合乡',4,'',0,1,0,0),(19882,2443,'土塘镇',4,'',0,1,0,0),(19883,2443,'多宝乡',4,'',0,1,0,0),(19884,2443,'大树乡',4,'',0,1,0,0),(19885,2443,'大沙镇',4,'',0,1,0,0),(19886,2443,'大港镇',4,'',0,1,0,0),(19887,2443,'左里镇',4,'',0,1,0,0),(19888,2443,'徐埠镇',4,'',0,1,0,0),(19889,2443,'春桥乡',4,'',0,1,0,0),(19890,2443,'汪墩乡',4,'',0,1,0,0),(19891,2443,'狮山乡',4,'',0,1,0,0),(19892,2443,'芗溪乡',4,'',0,1,0,0),(19893,2443,'苏山乡',4,'',0,1,0,0),(19894,2443,'蔡岭镇',4,'',0,1,0,0),(19895,2443,'西源乡',4,'',0,1,0,0),(19896,2443,'都昌镇',4,'',0,1,0,0),(19897,2443,'阳峰乡',4,'',0,1,0,0),(19898,2443,'鸣山乡',4,'',0,1,0,0),(19899,2444,'上村林场',4,'',0,1,0,0),(19900,2444,'凤阳乡',4,'',0,1,0,0),(19901,2444,'分宜镇',4,'',0,1,0,0),(19902,2444,'双林镇',4,'',0,1,0,0),(19903,2444,'山下林场',4,'',0,1,0,0),(19904,2444,'操场乡',4,'',0,1,0,0),(19905,2444,'杨桥镇',4,'',0,1,0,0),(19906,2444,'洋江乡',4,'',0,1,0,0),(19907,2444,'洞村乡',4,'',0,1,0,0),(19908,2444,'湖泽镇',4,'',0,1,0,0),(19909,2444,'畜牧良种场',4,'',0,1,0,0),(19910,2444,'芳山林场',4,'',0,1,0,0),(19911,2444,'钤山镇',4,'',0,1,0,0),(19912,2444,'长埠林场',4,'',0,1,0,0),(19913,2444,'高岚乡',4,'',0,1,0,0),(19914,2445,'下村镇',4,'',0,1,0,0),(19915,2445,'九龙山乡',4,'',0,1,0,0),(19916,2445,'人和乡',4,'',0,1,0,0),(19917,2445,'南安乡',4,'',0,1,0,0),(19918,2445,'城北街道',4,'',0,1,0,0),(19919,2445,'城南街道',4,'',0,1,0,0),(19920,2445,'姚圩镇',4,'',0,1,0,0),(19921,2445,'新溪乡',4,'',0,1,0,0),(19922,2445,'新钢街道',4,'',0,1,0,0),(19923,2445,'欧里镇',4,'',0,1,0,0),(19924,2445,'水北镇',4,'',0,1,0,0),(19925,2445,'水西镇',4,'',0,1,0,0),(19926,2445,'河下镇',4,'',0,1,0,0),(19927,2445,'珠珊镇',4,'',0,1,0,0),(19928,2445,'界水乡',4,'',0,1,0,0),(19929,2445,'罗坊镇',4,'',0,1,0,0),(19930,2445,'良山镇',4,'',0,1,0,0),(19931,2445,'袁河街道',4,'',0,1,0,0),(19932,2445,'观巢镇',4,'',0,1,0,0),(19933,2445,'鹄山乡',4,'',0,1,0,0),(19934,2446,'中童镇',4,'',0,1,0,0),(19935,2446,'平定乡',4,'',0,1,0,0),(19936,2446,'春涛乡',4,'',0,1,0,0),(19937,2446,'杨溪乡',4,'',0,1,0,0),(19938,2446,'洪湖乡',4,'',0,1,0,0),(19939,2446,'潢溪镇',4,'',0,1,0,0),(19940,2446,'画桥镇',4,'',0,1,0,0),(19941,2446,'邓埠镇',4,'',0,1,0,0),(19942,2446,'锦江镇',4,'',0,1,0,0),(19943,2446,'马荃镇',4,'',0,1,0,0),(19944,2446,'黄庄乡',4,'',0,1,0,0),(19945,2447,'东湖街道',4,'',0,1,0,0),(19946,2447,'交通街道',4,'',0,1,0,0),(19947,2447,'四青街道',4,'',0,1,0,0),(19948,2447,'夏埠乡',4,'',0,1,0,0),(19949,2447,'梅园街道',4,'',0,1,0,0),(19950,2447,'江边街道',4,'',0,1,0,0),(19951,2447,'白露街道',4,'',0,1,0,0),(19952,2447,'童家镇',4,'',0,1,0,0),(19953,2448,'上清镇',4,'',0,1,0,0),(19954,2448,'东门街道',4,'',0,1,0,0),(19955,2448,'余家乡',4,'',0,1,0,0),(19956,2448,'冷水镇',4,'',0,1,0,0),(19957,2448,'周坊镇',4,'',0,1,0,0),(19958,2448,'塘湾镇',4,'',0,1,0,0),(19959,2448,'彭湾乡',4,'',0,1,0,0),(19960,2448,'志光镇',4,'',0,1,0,0),(19961,2448,'文坊镇',4,'',0,1,0,0),(19962,2448,'樟坪畲族乡',4,'',0,1,0,0),(19963,2448,'河潭镇',4,'',0,1,0,0),(19964,2448,'泗沥镇',4,'',0,1,0,0),(19965,2448,'流口镇',4,'',0,1,0,0),(19966,2448,'滨江乡',4,'',0,1,0,0),(19967,2448,'白田乡',4,'',0,1,0,0),(19968,2448,'罗河镇',4,'',0,1,0,0),(19969,2448,'耳口乡',4,'',0,1,0,0),(19970,2448,'花园街道',4,'',0,1,0,0),(19971,2448,'金屯镇',4,'',0,1,0,0),(19972,2448,'雄石街道',4,'',0,1,0,0),(19973,2448,'雷溪乡',4,'',0,1,0,0),(19974,2448,'鸿塘镇',4,'',0,1,0,0),(19975,2448,'龙虎山镇',4,'',0,1,0,0),(19976,2449,'东山镇',4,'',0,1,0,0),(19977,2449,'五指峰乡',4,'',0,1,0,0),(19978,2449,'双溪乡',4,'',0,1,0,0),(19979,2449,'安和乡',4,'',0,1,0,0),(19980,2449,'寺下乡',4,'',0,1,0,0),(19981,2449,'平富乡',4,'',0,1,0,0),(19982,2449,'梅水乡',4,'',0,1,0,0),(19983,2449,'水岩乡',4,'',0,1,0,0),(19984,2449,'油石乡',4,'',0,1,0,0),(19985,2449,'社溪镇',4,'',0,1,0,0),(19986,2449,'紫阳乡',4,'',0,1,0,0),(19987,2449,'营前镇',4,'',0,1,0,0),(19988,2449,'陡水镇',4,'',0,1,0,0),(19989,2449,'黄埠镇',4,'',0,1,0,0),(19990,2450,'仙下乡',4,'',0,1,0,0),(19991,2450,'利村乡',4,'',0,1,0,0),(19992,2450,'宽田乡',4,'',0,1,0,0),(19993,2450,'小溪乡',4,'',0,1,0,0),(19994,2450,'岭背镇',4,'',0,1,0,0),(19995,2450,'新陂乡',4,'',0,1,0,0),(19996,2450,'桥头乡',4,'',0,1,0,0),(19997,2450,'梓山镇',4,'',0,1,0,0),(19998,2450,'段屋乡',4,'',0,1,0,0),(19999,2450,'沙心乡',4,'',0,1,0,0),(20000,2450,'盘古山镇',4,'',0,1,0,0),(20001,2450,'祁禄山镇',4,'',0,1,0,0),(20002,2450,'禾丰镇',4,'',0,1,0,0),(20003,2450,'罗坳镇',4,'',0,1,0,0),(20004,2450,'罗江乡',4,'',0,1,0,0),(20005,2450,'葛坳乡',4,'',0,1,0,0),(20006,2450,'贡江镇',4,'',0,1,0,0),(20007,2450,'车溪乡',4,'',0,1,0,0),(20008,2450,'铁山垅镇',4,'',0,1,0,0),(20009,2450,'银坑镇',4,'',0,1,0,0),(20010,2450,'靖石乡',4,'',0,1,0,0),(20011,2450,'马安乡',4,'',0,1,0,0),(20012,2450,'黄麟乡',4,'',0,1,0,0),(20013,2451,'中村乡',4,'',0,1,0,0),(20014,2451,'右水乡',4,'',0,1,0,0),(20015,2451,'周田镇',4,'',0,1,0,0),(20016,2451,'富城乡',4,'',0,1,0,0),(20017,2451,'小密乡',4,'',0,1,0,0),(20018,2451,'庄口镇',4,'',0,1,0,0),(20019,2451,'庄埠乡',4,'',0,1,0,0),(20020,2451,'文武坝镇',4,'',0,1,0,0),(20021,2451,'晓龙乡',4,'',0,1,0,0),(20022,2451,'永隆乡',4,'',0,1,0,0),(20023,2451,'洞头乡',4,'',0,1,0,0),(20024,2451,'清溪乡',4,'',0,1,0,0),(20025,2451,'珠兰乡',4,'',0,1,0,0),(20026,2451,'白鹅乡',4,'',0,1,0,0),(20027,2451,'站塘乡',4,'',0,1,0,0),(20028,2451,'筠门岭镇',4,'',0,1,0,0),(20029,2451,'西江镇',4,'',0,1,0,0),(20030,2451,'高排乡',4,'',0,1,0,0),(20031,2451,'麻州镇',4,'',0,1,0,0),(20032,2452,'万隆乡',4,'',0,1,0,0),(20033,2452,'古陂镇',4,'',0,1,0,0),(20034,2452,'嘉定镇',4,'',0,1,0,0),(20035,2452,'大塘埠镇',4,'',0,1,0,0),(20036,2452,'大桥镇',4,'',0,1,0,0),(20037,2452,'大阿镇',4,'',0,1,0,0),(20038,2452,'安西镇',4,'',0,1,0,0),(20039,2452,'小江镇',4,'',0,1,0,0),(20040,2452,'小河镇',4,'',0,1,0,0),(20041,2452,'崇仙乡',4,'',0,1,0,0),(20042,2452,'新田镇',4,'',0,1,0,0),(20043,2452,'正平镇',4,'',0,1,0,0),(20044,2452,'油山镇',4,'',0,1,0,0),(20045,2452,'虎山乡',4,'',0,1,0,0),(20046,2452,'西牛镇',4,'',0,1,0,0),(20047,2452,'铁石口镇',4,'',0,1,0,0),(20048,2453,'中寨乡',4,'',0,1,0,0),(20049,2453,'南迳镇',4,'',0,1,0,0),(20050,2453,'城厢镇',4,'',0,1,0,0),(20051,2453,'大吉山镇',4,'',0,1,0,0),(20052,2453,'社迳乡',4,'',0,1,0,0),(20053,2453,'金龙镇',4,'',0,1,0,0),(20054,2453,'陂头镇',4,'',0,1,0,0),(20055,2453,'龙下乡',4,'',0,1,0,0),(20056,2453,'龙源坝镇',4,'',0,1,0,0),(20057,2454,'东村乡',4,'',0,1,0,0),(20058,2454,'兴江乡',4,'',0,1,0,0),(20059,2454,'兴莲乡',4,'',0,1,0,0),(20060,2454,'南坑乡',4,'',0,1,0,0),(20061,2454,'古龙冈镇',4,'',0,1,0,0),(20062,2454,'均村乡',4,'',0,1,0,0),(20063,2454,'城岗乡',4,'',0,1,0,0),(20064,2454,'埠头乡',4,'',0,1,0,0),(20065,2454,'崇贤乡',4,'',0,1,0,0),(20066,2454,'方太乡',4,'',0,1,0,0),(20067,2454,'杰村乡',4,'',0,1,0,0),(20068,2454,'枫边乡',4,'',0,1,0,0),(20069,2454,'梅窖镇',4,'',0,1,0,0),(20070,2454,'樟木乡',4,'',0,1,0,0),(20071,2454,'永丰乡',4,'',0,1,0,0),(20072,2454,'江背镇',4,'',0,1,0,0),(20073,2454,'潋江镇',4,'',0,1,0,0),(20074,2454,'社富乡',4,'',0,1,0,0),(20075,2454,'良村镇',4,'',0,1,0,0),(20076,2454,'茶园乡',4,'',0,1,0,0),(20077,2454,'长冈乡',4,'',0,1,0,0),(20078,2454,'隆坪乡',4,'',0,1,0,0),(20079,2454,'高兴镇',4,'',0,1,0,0),(20080,2454,'鼎龙乡',4,'',0,1,0,0),(20081,2454,'龙口镇',4,'',0,1,0,0),(20082,2455,'三江乡',4,'',0,1,0,0),(20083,2455,'东山街道',4,'',0,1,0,0),(20084,2455,'凤岗镇',4,'',0,1,0,0),(20085,2455,'十八塘乡',4,'',0,1,0,0),(20086,2455,'唐江镇',4,'',0,1,0,0),(20087,2455,'坪市乡',4,'',0,1,0,0),(20088,2455,'大坪乡',4,'',0,1,0,0),(20089,2455,'太窝乡',4,'',0,1,0,0),(20090,2455,'朱坊乡',4,'',0,1,0,0),(20091,2455,'横寨乡',4,'',0,1,0,0),(20092,2455,'横市镇',4,'',0,1,0,0),(20093,2455,'浮石乡',4,'',0,1,0,0),(20094,2455,'潭东镇',4,'',0,1,0,0),(20095,2455,'潭口镇',4,'',0,1,0,0),(20096,2455,'蓉江街道',4,'',0,1,0,0),(20097,2455,'赤土畲族乡',4,'',0,1,0,0),(20098,2455,'镜坝镇',4,'',0,1,0,0),(20099,2455,'隆木乡',4,'',0,1,0,0),(20100,2455,'麻双乡',4,'',0,1,0,0),(20101,2455,'龙华乡',4,'',0,1,0,0),(20102,2455,'龙回镇',4,'',0,1,0,0),(20103,2455,'龙岭镇',4,'',0,1,0,0),(20104,2456,'内良乡',4,'',0,1,0,0),(20105,2456,'南安镇',4,'',0,1,0,0),(20106,2456,'吉村镇',4,'',0,1,0,0),(20107,2456,'左拔镇',4,'',0,1,0,0),(20108,2456,'新城镇',4,'',0,1,0,0),(20109,2456,'樟斗镇',4,'',0,1,0,0),(20110,2456,'池江镇',4,'',0,1,0,0),(20111,2456,'河洞乡',4,'',0,1,0,0),(20112,2456,'浮江乡',4,'',0,1,0,0),(20113,2456,'青龙镇',4,'',0,1,0,0),(20114,2456,'黄龙镇',4,'',0,1,0,0),(20115,2457,'东山坝镇',4,'',0,1,0,0),(20116,2457,'东韶乡',4,'',0,1,0,0),(20117,2457,'会同乡',4,'',0,1,0,0),(20118,2457,'固厚乡',4,'',0,1,0,0),(20119,2457,'固村镇',4,'',0,1,0,0),(20120,2457,'大沽乡',4,'',0,1,0,0),(20121,2457,'安福乡',4,'',0,1,0,0),(20122,2457,'对坊乡',4,'',0,1,0,0),(20123,2457,'小布镇',4,'',0,1,0,0),(20124,2457,'梅江镇',4,'',0,1,0,0),(20125,2457,'洛口镇',4,'',0,1,0,0),(20126,2457,'湛田乡',4,'',0,1,0,0),(20127,2457,'田埠乡',4,'',0,1,0,0),(20128,2457,'田头镇',4,'',0,1,0,0),(20129,2457,'石上镇',4,'',0,1,0,0),(20130,2457,'竹笮乡',4,'',0,1,0,0),(20131,2457,'肖田乡',4,'',0,1,0,0),(20132,2457,'蔡江乡',4,'',0,1,0,0),(20133,2457,'赖村镇',4,'',0,1,0,0),(20134,2457,'钓峰乡',4,'',0,1,0,0),(20135,2457,'长胜镇',4,'',0,1,0,0),(20136,2457,'青塘镇',4,'',0,1,0,0),(20137,2457,'黄石镇',4,'',0,1,0,0),(20138,2457,'黄陂镇',4,'',0,1,0,0),(20139,2458,'三百山镇',4,'',0,1,0,0),(20140,2458,'凤山乡',4,'',0,1,0,0),(20141,2458,'双芫乡',4,'',0,1,0,0),(20142,2458,'塘村乡',4,'',0,1,0,0),(20143,2458,'天心镇',4,'',0,1,0,0),(20144,2458,'孔田镇',4,'',0,1,0,0),(20145,2458,'新龙乡',4,'',0,1,0,0),(20146,2458,'欣山镇',4,'',0,1,0,0),(20147,2458,'浮槎乡',4,'',0,1,0,0),(20148,2458,'版石镇',4,'',0,1,0,0),(20149,2458,'蔡坊乡',4,'',0,1,0,0),(20150,2458,'车头镇',4,'',0,1,0,0),(20151,2458,'重石乡',4,'',0,1,0,0),(20152,2458,'镇岗乡',4,'',0,1,0,0),(20153,2458,'长沙乡',4,'',0,1,0,0),(20154,2458,'高云山乡',4,'',0,1,0,0),(20155,2458,'鹤子镇',4,'',0,1,0,0),(20156,2458,'龙布镇',4,'',0,1,0,0),(20157,2459,'历市镇',4,'',0,1,0,0),(20158,2459,'天九镇',4,'',0,1,0,0),(20159,2459,'岭北镇',4,'',0,1,0,0),(20160,2459,'岿美山镇',4,'',0,1,0,0),(20161,2459,'老城镇',4,'',0,1,0,0),(20162,2459,'鹅公镇',4,'',0,1,0,0),(20163,2459,'龙塘镇',4,'',0,1,0,0),(20164,2460,'三标乡',4,'',0,1,0,0),(20165,2460,'丹溪乡',4,'',0,1,0,0),(20166,2460,'南桥镇',4,'',0,1,0,0),(20167,2460,'吉潭镇',4,'',0,1,0,0),(20168,2460,'文峰乡',4,'',0,1,0,0),(20169,2460,'晨光镇',4,'',0,1,0,0),(20170,2460,'桂竹帽镇',4,'',0,1,0,0),(20171,2460,'水源乡',4,'',0,1,0,0),(20172,2460,'澄江镇',4,'',0,1,0,0),(20173,2460,'留车镇',4,'',0,1,0,0),(20174,2460,'罗珊乡',4,'',0,1,0,0),(20175,2460,'菖蒲乡',4,'',0,1,0,0),(20176,2460,'长宁镇',4,'',0,1,0,0),(20177,2460,'项山乡',4,'',0,1,0,0),(20178,2460,'龙廷乡',4,'',0,1,0,0),(20179,2461,'上堡乡',4,'',0,1,0,0),(20180,2461,'丰州乡',4,'',0,1,0,0),(20181,2461,'乐洞乡',4,'',0,1,0,0),(20182,2461,'关田镇',4,'',0,1,0,0),(20183,2461,'思顺乡',4,'',0,1,0,0),(20184,2461,'扬眉镇',4,'',0,1,0,0),(20185,2461,'文英乡',4,'',0,1,0,0),(20186,2461,'杰坝乡',4,'',0,1,0,0),(20187,2461,'横水镇',4,'',0,1,0,0),(20188,2461,'聂都乡',4,'',0,1,0,0),(20189,2461,'过埠镇',4,'',0,1,0,0),(20190,2461,'金坑乡',4,'',0,1,0,0),(20191,2461,'铅厂镇',4,'',0,1,0,0),(20192,2461,'长龙镇',4,'',0,1,0,0),(20193,2461,'麟潭乡',4,'',0,1,0,0),(20194,2461,'龙勾乡',4,'',0,1,0,0),(20195,2462,'丁陂乡',4,'',0,1,0,0),(20196,2462,'万田乡',4,'',0,1,0,0),(20197,2462,'九堡镇',4,'',0,1,0,0),(20198,2462,'云石山乡',4,'',0,1,0,0),(20199,2462,'叶坪乡',4,'',0,1,0,0),(20200,2462,'壬田镇',4,'',0,1,0,0),(20201,2462,'大柏地乡',4,'',0,1,0,0),(20202,2462,'岗面乡',4,'',0,1,0,0),(20203,2462,'拔英乡',4,'',0,1,0,0),(20204,2462,'日东乡',4,'',0,1,0,0),(20205,2462,'武阳镇',4,'',0,1,0,0),(20206,2462,'沙洲坝镇',4,'',0,1,0,0),(20207,2462,'泽覃乡',4,'',0,1,0,0),(20208,2462,'瑞林镇',4,'',0,1,0,0),(20209,2462,'谢坊镇',4,'',0,1,0,0),(20210,2462,'象湖镇',4,'',0,1,0,0),(20211,2462,'黄柏乡',4,'',0,1,0,0),(20212,2463,'丰山乡',4,'',0,1,0,0),(20213,2463,'大由乡',4,'',0,1,0,0),(20214,2463,'小松镇',4,'',0,1,0,0),(20215,2463,'屏山镇',4,'',0,1,0,0),(20216,2463,'木兰乡',4,'',0,1,0,0),(20217,2463,'横江镇',4,'',0,1,0,0),(20218,2463,'珠坑乡',4,'',0,1,0,0),(20219,2463,'琴江镇',4,'',0,1,0,0),(20220,2463,'高田镇',4,'',0,1,0,0),(20221,2463,'龙岗乡',4,'',0,1,0,0),(20222,2464,'东外街道',4,'',0,1,0,0),(20223,2464,'南外街道',4,'',0,1,0,0),(20224,2464,'水东镇',4,'',0,1,0,0),(20225,2464,'水南镇',4,'',0,1,0,0),(20226,2464,'水西镇',4,'',0,1,0,0),(20227,2464,'沙河镇',4,'',0,1,0,0),(20228,2464,'沙石镇',4,'',0,1,0,0),(20229,2464,'湖边镇',4,'',0,1,0,0),(20230,2464,'蟠龙镇',4,'',0,1,0,0),(20231,2464,'解放街道',4,'',0,1,0,0),(20232,2464,'赣江街道',4,'',0,1,0,0),(20233,2464,'黄金岭街道',4,'',0,1,0,0),(20234,2465,'三溪乡',4,'',0,1,0,0),(20235,2465,'五云镇',4,'',0,1,0,0),(20236,2465,'储潭乡',4,'',0,1,0,0),(20237,2465,'南塘镇',4,'',0,1,0,0),(20238,2465,'吉埠镇',4,'',0,1,0,0),(20239,2465,'大埠乡',4,'',0,1,0,0),(20240,2465,'大田乡',4,'',0,1,0,0),(20241,2465,'梅林镇',4,'',0,1,0,0),(20242,2465,'江口镇',4,'',0,1,0,0),(20243,2465,'沙地镇',4,'',0,1,0,0),(20244,2465,'湖江乡',4,'',0,1,0,0),(20245,2465,'王母渡镇',4,'',0,1,0,0),(20246,2465,'田村镇',4,'',0,1,0,0),(20247,2465,'白鹭乡',4,'',0,1,0,0),(20248,2465,'石芫乡',4,'',0,1,0,0),(20249,2465,'茅店镇',4,'',0,1,0,0),(20250,2465,'长洛乡',4,'',0,1,0,0),(20251,2465,'阳埠乡',4,'',0,1,0,0),(20252,2465,'韩坊乡',4,'',0,1,0,0),(20253,2466,'东江乡',4,'',0,1,0,0),(20254,2466,'临塘乡',4,'',0,1,0,0),(20255,2466,'关西镇',4,'',0,1,0,0),(20256,2466,'南亨乡',4,'',0,1,0,0),(20257,2466,'夹湖乡',4,'',0,1,0,0),(20258,2466,'杨村镇',4,'',0,1,0,0),(20259,2466,'桃江乡',4,'',0,1,0,0),(20260,2466,'武当镇',4,'',0,1,0,0),(20261,2466,'汶龙镇',4,'',0,1,0,0),(20262,2466,'渡江镇',4,'',0,1,0,0),(20263,2466,'程龙镇',4,'',0,1,0,0),(20264,2466,'里仁镇',4,'',0,1,0,0),(20265,2466,'龙南镇',4,'',0,1,0,0),(20266,2467,'五丰镇',4,'',0,1,0,0),(20267,2467,'夏造镇',4,'',0,1,0,0),(20268,2467,'宝山乡',4,'',0,1,0,0),(20269,2467,'弹前乡',4,'',0,1,0,0),(20270,2467,'枧头镇',4,'',0,1,0,0),(20271,2467,'武术乡',4,'',0,1,0,0),(20272,2467,'沙坪镇',4,'',0,1,0,0),(20273,2467,'涧田乡',4,'',0,1,0,0),(20274,2467,'潞田镇',4,'',0,1,0,0),(20275,2467,'百加镇',4,'',0,1,0,0),(20276,2467,'窑头镇',4,'',0,1,0,0),(20277,2467,'罗塘乡',4,'',0,1,0,0),(20278,2467,'芙蓉镇',4,'',0,1,0,0),(20279,2467,'韶口乡',4,'',0,1,0,0),(20280,2467,'顺峰乡',4,'',0,1,0,0),(20281,2467,'高陂镇',4,'',0,1,0,0),(20282,2468,'下七乡',4,'',0,1,0,0),(20283,2468,'东上乡',4,'',0,1,0,0),(20284,2468,'厦坪镇',4,'',0,1,0,0),(20285,2468,'古城镇',4,'',0,1,0,0),(20286,2468,'坳里乡',4,'',0,1,0,0),(20287,2468,'大陇镇',4,'',0,1,0,0),(20288,2468,'拿山乡',4,'',0,1,0,0),(20289,2468,'新城镇',4,'',0,1,0,0),(20290,2468,'柏露乡',4,'',0,1,0,0),(20291,2468,'睦村乡',4,'',0,1,0,0),(20292,2468,'茅坪乡',4,'',0,1,0,0),(20293,2468,'茨坪街道',4,'',0,1,0,0),(20294,2468,'荷花乡',4,'',0,1,0,0),(20295,2468,'葛田乡',4,'',0,1,0,0),(20296,2468,'长坪乡',4,'',0,1,0,0),(20297,2468,'鹅岭乡',4,'',0,1,0,0),(20298,2468,'黄坳乡',4,'',0,1,0,0),(20299,2468,'龙市镇',4,'',0,1,0,0),(20300,2469,'万福镇',4,'',0,1,0,0),(20301,2469,'凤凰镇',4,'',0,1,0,0),(20302,2469,'北源乡',4,'',0,1,0,0),(20303,2469,'固江镇',4,'',0,1,0,0),(20304,2469,'大冲乡',4,'',0,1,0,0),(20305,2469,'天河镇',4,'',0,1,0,0),(20306,2469,'安塘乡',4,'',0,1,0,0),(20307,2469,'官田乡',4,'',0,1,0,0),(20308,2469,'指阳乡',4,'',0,1,0,0),(20309,2469,'敖城镇',4,'',0,1,0,0),(20310,2469,'敦厚镇',4,'',0,1,0,0),(20311,2469,'桐坪镇',4,'',0,1,0,0),(20312,2469,'梅塘乡',4,'',0,1,0,0),(20313,2469,'横江镇',4,'',0,1,0,0),(20314,2469,'永和镇',4,'',0,1,0,0),(20315,2469,'永阳镇',4,'',0,1,0,0),(20316,2469,'油田镇',4,'',0,1,0,0),(20317,2469,'登龙乡',4,'',0,1,0,0),(20318,2469,'里田乡',4,'',0,1,0,0),(20319,2470,'习溪桥街道',4,'',0,1,0,0),(20320,2470,'兴桥镇',4,'',0,1,0,0),(20321,2470,'北门街道',4,'',0,1,0,0),(20322,2470,'古南街道',4,'',0,1,0,0),(20323,2470,'文山街道',4,'',0,1,0,0),(20324,2470,'曲濑乡',4,'',0,1,0,0),(20325,2470,'樟山镇',4,'',0,1,0,0),(20326,2470,'永叔街道',4,'',0,1,0,0),(20327,2470,'白塘街道',4,'',0,1,0,0),(20328,2470,'禾埠乡',4,'',0,1,0,0),(20329,2470,'长塘镇',4,'',0,1,0,0),(20330,2471,'丁江镇',4,'',0,1,0,0),(20331,2471,'乌江镇',4,'',0,1,0,0),(20332,2471,'八都镇',4,'',0,1,0,0),(20333,2471,'冠山乡',4,'',0,1,0,0),(20334,2471,'双村镇',4,'',0,1,0,0),(20335,2471,'尚贤乡',4,'',0,1,0,0),(20336,2471,'文峰镇',4,'',0,1,0,0),(20337,2471,'枫江镇',4,'',0,1,0,0),(20338,2471,'水南镇',4,'',0,1,0,0),(20339,2471,'水田乡',4,'',0,1,0,0),(20340,2471,'白水镇',4,'',0,1,0,0),(20341,2471,'白沙镇',4,'',0,1,0,0),(20342,2471,'盘谷镇',4,'',0,1,0,0),(20343,2471,'螺田镇',4,'',0,1,0,0),(20344,2471,'醪桥镇',4,'',0,1,0,0),(20345,2471,'金滩镇',4,'',0,1,0,0),(20346,2471,'阜田镇',4,'',0,1,0,0),(20347,2471,'黄桥镇',4,'',0,1,0,0),(20348,2472,'严田镇',4,'',0,1,0,0),(20349,2472,'寮塘乡',4,'',0,1,0,0),(20350,2472,'山庄乡',4,'',0,1,0,0),(20351,2472,'平都镇',4,'',0,1,0,0),(20352,2472,'彭坊乡',4,'',0,1,0,0),(20353,2472,'枫田镇',4,'',0,1,0,0),(20354,2472,'横龙镇',4,'',0,1,0,0),(20355,2472,'泰山乡',4,'',0,1,0,0),(20356,2472,'洋溪镇',4,'',0,1,0,0),(20357,2472,'洋门乡',4,'',0,1,0,0),(20358,2472,'洲湖镇',4,'',0,1,0,0),(20359,2472,'浒坑镇',4,'',0,1,0,0),(20360,2472,'瓜畲乡',4,'',0,1,0,0),(20361,2472,'甘洛乡',4,'',0,1,0,0),(20362,2472,'章庄乡',4,'',0,1,0,0),(20363,2472,'竹江乡',4,'',0,1,0,0),(20364,2472,'赤谷乡',4,'',0,1,0,0),(20365,2472,'金田乡',4,'',0,1,0,0),(20366,2472,'钱山乡',4,'',0,1,0,0),(20367,2473,'仁和镇',4,'',0,1,0,0),(20368,2473,'巴邱镇',4,'',0,1,0,0),(20369,2473,'戈坪乡',4,'',0,1,0,0),(20370,2473,'桐林乡',4,'',0,1,0,0),(20371,2473,'水边镇',4,'',0,1,0,0),(20372,2473,'砚溪镇',4,'',0,1,0,0),(20373,2473,'福民乡',4,'',0,1,0,0),(20374,2473,'罗田镇',4,'',0,1,0,0),(20375,2473,'金江乡',4,'',0,1,0,0),(20376,2473,'马埠镇',4,'',0,1,0,0),(20377,2474,'七琴镇',4,'',0,1,0,0),(20378,2474,'三湖镇',4,'',0,1,0,0),(20379,2474,'城上乡',4,'',0,1,0,0),(20380,2474,'大洋洲镇',4,'',0,1,0,0),(20381,2474,'桃溪乡',4,'',0,1,0,0),(20382,2474,'沂江乡',4,'',0,1,0,0),(20383,2474,'溧江乡',4,'',0,1,0,0),(20384,2474,'潭丘乡',4,'',0,1,0,0),(20385,2474,'界埠乡',4,'',0,1,0,0),(20386,2474,'神政桥乡',4,'',0,1,0,0),(20387,2474,'荷浦乡',4,'',0,1,0,0),(20388,2474,'金川镇',4,'',0,1,0,0),(20389,2474,'麦斜镇',4,'',0,1,0,0),(20390,2475,'七都乡',4,'',0,1,0,0),(20391,2475,'三坊乡',4,'',0,1,0,0),(20392,2475,'上固乡',4,'',0,1,0,0),(20393,2475,'上溪乡',4,'',0,1,0,0),(20394,2475,'中村乡',4,'',0,1,0,0),(20395,2475,'佐龙乡',4,'',0,1,0,0),(20396,2475,'八江乡',4,'',0,1,0,0),(20397,2475,'古县镇',4,'',0,1,0,0),(20398,2475,'君埠乡',4,'',0,1,0,0),(20399,2475,'坑田镇',4,'',0,1,0,0),(20400,2475,'恩江镇',4,'',0,1,0,0),(20401,2475,'沙溪镇',4,'',0,1,0,0),(20402,2475,'沿陂镇',4,'',0,1,0,0),(20403,2475,'潭城乡',4,'',0,1,0,0),(20404,2475,'潭头乡',4,'',0,1,0,0),(20405,2475,'瑶田镇',4,'',0,1,0,0),(20406,2475,'石马镇',4,'',0,1,0,0),(20407,2475,'藤田镇',4,'',0,1,0,0),(20408,2475,'陶塘乡',4,'',0,1,0,0),(20409,2475,'鹿冈乡',4,'',0,1,0,0),(20410,2475,'龙冈畲族乡',4,'',0,1,0,0),(20411,2476,'三湾乡',4,'',0,1,0,0),(20412,2476,'台岭乡',4,'',0,1,0,0),(20413,2476,'在中乡',4,'',0,1,0,0),(20414,2476,'坳南乡',4,'',0,1,0,0),(20415,2476,'埠前镇',4,'',0,1,0,0),(20416,2476,'怀忠镇',4,'',0,1,0,0),(20417,2476,'才丰乡',4,'',0,1,0,0),(20418,2476,'文竹镇',4,'',0,1,0,0),(20419,2476,'曲白乡',4,'',0,1,0,0),(20420,2476,'沙市镇',4,'',0,1,0,0),(20421,2476,'烟阁乡',4,'',0,1,0,0),(20422,2476,'石桥镇',4,'',0,1,0,0),(20423,2476,'禾川镇',4,'',0,1,0,0),(20424,2476,'芦溪乡',4,'',0,1,0,0),(20425,2476,'莲洲乡',4,'',0,1,0,0),(20426,2476,'象形乡',4,'',0,1,0,0),(20427,2476,'里田镇',4,'',0,1,0,0),(20428,2476,'高市乡',4,'',0,1,0,0),(20429,2476,'高桥楼镇',4,'',0,1,0,0),(20430,2476,'高溪乡',4,'',0,1,0,0),(20431,2476,'龙源口镇',4,'',0,1,0,0),(20432,2476,'龙田乡',4,'',0,1,0,0),(20433,2476,'龙门镇',4,'',0,1,0,0),(20434,2477,'万合镇',4,'',0,1,0,0),(20435,2477,'上圯乡',4,'',0,1,0,0),(20436,2477,'上模乡',4,'',0,1,0,0),(20437,2477,'中龙乡',4,'',0,1,0,0),(20438,2477,'冠朝镇',4,'',0,1,0,0),(20439,2477,'南溪乡',4,'',0,1,0,0),(20440,2477,'塘洲镇',4,'',0,1,0,0),(20441,2477,'小龙镇',4,'',0,1,0,0),(20442,2477,'桥头镇',4,'',0,1,0,0),(20443,2477,'水槎乡',4,'',0,1,0,0),(20444,2477,'沙村镇',4,'',0,1,0,0),(20445,2477,'沿溪镇',4,'',0,1,0,0),(20446,2477,'澄江镇',4,'',0,1,0,0),(20447,2477,'灌溪镇',4,'',0,1,0,0),(20448,2477,'石山乡',4,'',0,1,0,0),(20449,2477,'碧溪镇',4,'',0,1,0,0),(20450,2477,'禾市镇',4,'',0,1,0,0),(20451,2477,'老营盘镇',4,'',0,1,0,0),(20452,2477,'苏溪镇',4,'',0,1,0,0),(20453,2477,'苑前镇',4,'',0,1,0,0),(20454,2477,'螺溪镇',4,'',0,1,0,0),(20455,2477,'马市镇',4,'',0,1,0,0),(20456,2478,'五斗江乡',4,'',0,1,0,0),(20457,2478,'南江乡',4,'',0,1,0,0),(20458,2478,'双桥乡',4,'',0,1,0,0),(20459,2478,'堆子前镇',4,'',0,1,0,0),(20460,2478,'大坑乡',4,'',0,1,0,0),(20461,2478,'大汾镇',4,'',0,1,0,0),(20462,2478,'左安镇',4,'',0,1,0,0),(20463,2478,'巾石乡',4,'',0,1,0,0),(20464,2478,'戴家埔乡',4,'',0,1,0,0),(20465,2478,'新江乡',4,'',0,1,0,0),(20466,2478,'枚江乡',4,'',0,1,0,0),(20467,2478,'汤湖镇',4,'',0,1,0,0),(20468,2478,'泉江镇',4,'',0,1,0,0),(20469,2478,'珠田乡',4,'',0,1,0,0),(20470,2478,'碧洲镇',4,'',0,1,0,0),(20471,2478,'禾源镇',4,'',0,1,0,0),(20472,2478,'草林镇',4,'',0,1,0,0),(20473,2478,'营盘圩乡',4,'',0,1,0,0),(20474,2478,'衙前镇',4,'',0,1,0,0),(20475,2478,'西溪乡',4,'',0,1,0,0),(20476,2478,'雩田镇',4,'',0,1,0,0),(20477,2478,'高坪镇',4,'',0,1,0,0),(20478,2478,'黄坑乡',4,'',0,1,0,0),(20479,2479,'东固畲族乡',4,'',0,1,0,0),(20480,2479,'值夏镇',4,'',0,1,0,0),(20481,2479,'天玉镇',4,'',0,1,0,0),(20482,2479,'富滩镇',4,'',0,1,0,0),(20483,2479,'富田镇',4,'',0,1,0,0),(20484,2479,'文陂乡',4,'',0,1,0,0),(20485,2479,'新圩镇',4,'',0,1,0,0),(20486,2479,'河东街道',4,'',0,1,0,0),(20487,2480,'三兴镇',4,'',0,1,0,0),(20488,2480,'仙源乡',4,'',0,1,0,0),(20489,2480,'双桥镇',4,'',0,1,0,0),(20490,2480,'岭东乡',4,'',0,1,0,0),(20491,2480,'康乐街道',4,'',0,1,0,0),(20492,2480,'株潭镇',4,'',0,1,0,0),(20493,2480,'潭埠镇',4,'',0,1,0,0),(20494,2480,'白水乡',4,'',0,1,0,0),(20495,2480,'白良乡',4,'',0,1,0,0),(20496,2480,'罗城镇',4,'',0,1,0,0),(20497,2480,'茭湖乡',4,'',0,1,0,0),(20498,2480,'赤兴乡',4,'',0,1,0,0),(20499,2480,'马步乡',4,'',0,1,0,0),(20500,2480,'高城乡',4,'',0,1,0,0),(20501,2480,'高村镇',4,'',0,1,0,0),(20502,2480,'鹅峰乡',4,'',0,1,0,0),(20503,2480,'黄茅镇',4,'',0,1,0,0),(20504,2481,'南港镇',4,'',0,1,0,0),(20505,2481,'塔下乡',4,'',0,1,0,0),(20506,2481,'徐家渡镇',4,'',0,1,0,0),(20507,2481,'敖阳街道',4,'',0,1,0,0),(20508,2481,'新界埠乡',4,'',0,1,0,0),(20509,2481,'泗溪镇',4,'',0,1,0,0),(20510,2481,'田心镇',4,'',0,1,0,0),(20511,2481,'翰堂镇',4,'',0,1,0,0),(20512,2481,'芦洲乡',4,'',0,1,0,0),(20513,2481,'蒙山乡',4,'',0,1,0,0),(20514,2481,'野市乡',4,'',0,1,0,0),(20515,2481,'锦江镇',4,'',0,1,0,0),(20516,2481,'镇渡乡',4,'',0,1,0,0),(20517,2482,'上塘镇',4,'',0,1,0,0),(20518,2482,'丽村镇',4,'',0,1,0,0),(20519,2482,'剑光街道',4,'',0,1,0,0),(20520,2482,'剑南街道',4,'',0,1,0,0),(20521,2482,'同田乡',4,'',0,1,0,0),(20522,2482,'孙渡街道',4,'',0,1,0,0),(20523,2482,'小港镇',4,'',0,1,0,0),(20524,2482,'尚庄街道',4,'',0,1,0,0),(20525,2482,'张巷镇',4,'',0,1,0,0),(20526,2482,'拖船镇',4,'',0,1,0,0),(20527,2482,'曲江镇',4,'',0,1,0,0),(20528,2482,'杜市镇',4,'',0,1,0,0),(20529,2482,'桥东镇',4,'',0,1,0,0),(20530,2482,'梅林镇',4,'',0,1,0,0),(20531,2482,'段潭乡',4,'',0,1,0,0),(20532,2482,'河洲街道',4,'',0,1,0,0),(20533,2482,'泉港镇',4,'',0,1,0,0),(20534,2482,'洛市镇',4,'',0,1,0,0),(20535,2482,'淘沙镇',4,'',0,1,0,0),(20536,2482,'湖塘乡',4,'',0,1,0,0),(20537,2482,'白土镇',4,'',0,1,0,0),(20538,2482,'石江乡',4,'',0,1,0,0),(20539,2482,'石滩镇',4,'',0,1,0,0),(20540,2482,'秀市镇',4,'',0,1,0,0),(20541,2482,'筱塘乡',4,'',0,1,0,0),(20542,2482,'荣塘镇',4,'',0,1,0,0),(20543,2482,'荷湖乡',4,'',0,1,0,0),(20544,2482,'董家镇',4,'',0,1,0,0),(20545,2482,'蕉坑乡',4,'',0,1,0,0),(20546,2482,'袁渡镇',4,'',0,1,0,0),(20547,2482,'铁路镇',4,'',0,1,0,0),(20548,2482,'隍城镇',4,'',0,1,0,0),(20549,2483,'上富镇',4,'',0,1,0,0),(20550,2483,'仰山乡',4,'',0,1,0,0),(20551,2483,'会埠镇',4,'',0,1,0,0),(20552,2483,'冯川镇',4,'',0,1,0,0),(20553,2483,'宋埠镇',4,'',0,1,0,0),(20554,2483,'干洲镇',4,'',0,1,0,0),(20555,2483,'柳溪乡',4,'',0,1,0,0),(20556,2483,'澡下镇',4,'',0,1,0,0),(20557,2483,'澡溪乡',4,'',0,1,0,0),(20558,2483,'甘坊镇',4,'',0,1,0,0),(20559,2483,'百丈山名胜风景区',4,'',0,1,0,0),(20560,2483,'石溪办事处',4,'',0,1,0,0),(20561,2483,'罗市镇',4,'',0,1,0,0),(20562,2483,'赤岸镇',4,'',0,1,0,0),(20563,2483,'赤田镇',4,'',0,1,0,0),(20564,2484,'双峰林场',4,'',0,1,0,0),(20565,2484,'同安乡',4,'',0,1,0,0),(20566,2484,'天宝乡',4,'',0,1,0,0),(20567,2484,'新庄镇',4,'',0,1,0,0),(20568,2484,'新昌镇',4,'',0,1,0,0),(20569,2484,'桥西乡',4,'',0,1,0,0),(20570,2484,'棠浦镇',4,'',0,1,0,0),(20571,2484,'潭山镇',4,'',0,1,0,0),(20572,2484,'澄塘镇',4,'',0,1,0,0),(20573,2484,'石市镇',4,'',0,1,0,0),(20574,2484,'花桥乡',4,'',0,1,0,0),(20575,2484,'芳溪镇',4,'',0,1,0,0),(20576,2484,'车上林场',4,'',0,1,0,0),(20577,2484,'黄岗乡',4,'',0,1,0,0),(20578,2485,'中洲乡',4,'',0,1,0,0),(20579,2485,'临江镇',4,'',0,1,0,0),(20580,2485,'义成镇',4,'',0,1,0,0),(20581,2485,'刘公庙镇',4,'',0,1,0,0),(20582,2485,'吴城乡',4,'',0,1,0,0),(20583,2485,'城北街道',4,'',0,1,0,0),(20584,2485,'大桥街道',4,'',0,1,0,0),(20585,2485,'店下镇',4,'',0,1,0,0),(20586,2485,'昌付镇',4,'',0,1,0,0),(20587,2485,'永泰镇',4,'',0,1,0,0),(20588,2485,'洋湖乡',4,'',0,1,0,0),(20589,2485,'洲上乡',4,'',0,1,0,0),(20590,2485,'淦阳街道',4,'',0,1,0,0),(20591,2485,'福城街道',4,'',0,1,0,0),(20592,2485,'经楼镇',4,'',0,1,0,0),(20593,2485,'观上镇',4,'',0,1,0,0),(20594,2485,'阁山镇',4,'',0,1,0,0),(20595,2485,'鹿江街道',4,'',0,1,0,0),(20596,2485,'黄土岗镇',4,'',0,1,0,0),(20597,2486,'三阳镇',4,'',0,1,0,0),(20598,2486,'下浦街道',4,'',0,1,0,0),(20599,2486,'凤凰街道',4,'',0,1,0,0),(20600,2486,'化成街道',4,'',0,1,0,0),(20601,2486,'南庙乡',4,'',0,1,0,0),(20602,2486,'天台镇',4,'',0,1,0,0),(20603,2486,'官园街道',4,'',0,1,0,0),(20604,2486,'寨下乡',4,'',0,1,0,0),(20605,2486,'彬江镇',4,'',0,1,0,0),(20606,2486,'慈化镇',4,'',0,1,0,0),(20607,2486,'新坊乡',4,'',0,1,0,0),(20608,2486,'新田乡',4,'',0,1,0,0),(20609,2486,'柏木乡',4,'',0,1,0,0),(20610,2486,'楠木乡',4,'',0,1,0,0),(20611,2486,'水江乡',4,'',0,1,0,0),(20612,2486,'洪塘镇',4,'',0,1,0,0),(20613,2486,'洪江乡',4,'',0,1,0,0),(20614,2486,'渥江乡',4,'',0,1,0,0),(20615,2486,'温汤镇',4,'',0,1,0,0),(20616,2486,'湖田乡',4,'',0,1,0,0),(20617,2486,'湛郎街道',4,'',0,1,0,0),(20618,2486,'灵泉街道',4,'',0,1,0,0),(20619,2486,'珠泉街道',4,'',0,1,0,0),(20620,2486,'秀江街道',4,'',0,1,0,0),(20621,2486,'竹亭乡',4,'',0,1,0,0),(20622,2486,'芦村乡',4,'',0,1,0,0),(20623,2486,'西村镇',4,'',0,1,0,0),(20624,2486,'绕市乡',4,'',0,1,0,0),(20625,2486,'金园街道',4,'',0,1,0,0),(20626,2486,'金瑞镇',4,'',0,1,0,0),(20627,2486,'飞剑潭乡',4,'',0,1,0,0),(20628,2487,'三都镇',4,'',0,1,0,0),(20629,2487,'大段镇',4,'',0,1,0,0),(20630,2487,'带溪乡',4,'',0,1,0,0),(20631,2487,'排埠镇',4,'',0,1,0,0),(20632,2487,'棋坪镇',4,'',0,1,0,0),(20633,2487,'永宁镇',4,'',0,1,0,0),(20634,2487,'温泉镇',4,'',0,1,0,0),(20635,2487,'港口乡',4,'',0,1,0,0),(20636,2487,'高桥乡',4,'',0,1,0,0),(20637,2488,'三爪仑乡',4,'',0,1,0,0),(20638,2488,'中源乡',4,'',0,1,0,0),(20639,2488,'仁首镇',4,'',0,1,0,0),(20640,2488,'双溪镇',4,'',0,1,0,0),(20641,2488,'宝峰镇',4,'',0,1,0,0),(20642,2488,'水口乡',4,'',0,1,0,0),(20643,2488,'罗湾乡',4,'',0,1,0,0),(20644,2488,'躁都镇',4,'',0,1,0,0),(20645,2488,'雷公尖乡',4,'',0,1,0,0),(20646,2488,'香田乡',4,'',0,1,0,0),(20647,2488,'高湖镇',4,'',0,1,0,0),(20648,2489,'上湖乡',4,'',0,1,0,0),(20649,2489,'伍桥镇',4,'',0,1,0,0),(20650,2489,'八景镇',4,'',0,1,0,0),(20651,2489,'大城镇',4,'',0,1,0,0),(20652,2489,'太阳镇',4,'',0,1,0,0),(20653,2489,'建山镇',4,'',0,1,0,0),(20654,2489,'新街镇',4,'',0,1,0,0),(20655,2489,'村前镇',4,'',0,1,0,0),(20656,2489,'杨圩镇',4,'',0,1,0,0),(20657,2489,'汪家圩乡',4,'',0,1,0,0),(20658,2489,'灰埠镇',4,'',0,1,0,0),(20659,2489,'独城镇',4,'',0,1,0,0),(20660,2489,'瑞州街道',4,'',0,1,0,0),(20661,2489,'田南镇',4,'',0,1,0,0),(20662,2489,'相城镇',4,'',0,1,0,0),(20663,2489,'石脑镇',4,'',0,1,0,0),(20664,2489,'祥符镇',4,'',0,1,0,0),(20665,2489,'筠阳街道',4,'',0,1,0,0),(20666,2489,'荷岭镇',4,'',0,1,0,0),(20667,2489,'蓝坊镇',4,'',0,1,0,0),(20668,2489,'黄沙岗镇',4,'',0,1,0,0),(20669,2489,'龙潭镇',4,'',0,1,0,0),(20670,2490,'圩上桥镇',4,'',0,1,0,0),(20671,2490,'孝岗镇',4,'',0,1,0,0),(20672,2490,'小璜镇',4,'',0,1,0,0),(20673,2490,'岗上积镇',4,'',0,1,0,0),(20674,2490,'杨桥殿镇',4,'',0,1,0,0),(20675,2490,'王桥镇',4,'',0,1,0,0),(20676,2490,'珀玕乡',4,'',0,1,0,0),(20677,2490,'瑶圩乡',4,'',0,1,0,0),(20678,2490,'虎圩乡',4,'',0,1,0,0),(20679,2490,'詹圩镇',4,'',0,1,0,0),(20680,2490,'邓家乡',4,'',0,1,0,0),(20681,2490,'马圩镇',4,'',0,1,0,0),(20682,2490,'黎圩镇',4,'',0,1,0,0),(20683,2491,'七里岗乡',4,'',0,1,0,0),(20684,2491,'上顿渡镇',4,'',0,1,0,0),(20685,2491,'东馆镇',4,'',0,1,0,0),(20686,2491,'云山镇',4,'',0,1,0,0),(20687,2491,'六水桥街道',4,'',0,1,0,0),(20688,2491,'唱凯镇',4,'',0,1,0,0),(20689,2491,'城西街道',4,'',0,1,0,0),(20690,2491,'大岗镇',4,'',0,1,0,0),(20691,2491,'太阳镇',4,'',0,1,0,0),(20692,2491,'孝桥镇',4,'',0,1,0,0),(20693,2491,'展坪乡',4,'',0,1,0,0),(20694,2491,'崇岗镇',4,'',0,1,0,0),(20695,2491,'嵩湖乡',4,'',0,1,0,0),(20696,2491,'抚北镇',4,'',0,1,0,0),(20697,2491,'文昌街道',4,'',0,1,0,0),(20698,2491,'桐源乡',4,'',0,1,0,0),(20699,2491,'河埠乡',4,'',0,1,0,0),(20700,2491,'温泉镇',4,'',0,1,0,0),(20701,2491,'湖南乡',4,'',0,1,0,0),(20702,2491,'秋溪镇',4,'',0,1,0,0),(20703,2491,'罗湖镇',4,'',0,1,0,0),(20704,2491,'罗针镇',4,'',0,1,0,0),(20705,2491,'腾桥镇',4,'',0,1,0,0),(20706,2491,'茅排乡',4,'',0,1,0,0),(20707,2491,'荆公路街道',4,'',0,1,0,0),(20708,2491,'荣山镇',4,'',0,1,0,0),(20709,2491,'西大街街道',4,'',0,1,0,0),(20710,2491,'连城乡',4,'',0,1,0,0),(20711,2491,'钟岭街道',4,'',0,1,0,0),(20712,2491,'青云街道',4,'',0,1,0,0),(20713,2491,'青泥镇',4,'',0,1,0,0),(20714,2491,'高坪镇',4,'',0,1,0,0),(20715,2491,'鹏田乡',4,'',0,1,0,0),(20716,2491,'龙溪镇',4,'',0,1,0,0),(20717,2492,'万崇镇',4,'',0,1,0,0),(20718,2492,'公溪镇',4,'',0,1,0,0),(20719,2492,'南村乡',4,'',0,1,0,0),(20720,2492,'增田镇',4,'',0,1,0,0),(20721,2492,'山砀镇',4,'',0,1,0,0),(20722,2492,'戴坊镇',4,'',0,1,0,0),(20723,2492,'招携镇',4,'',0,1,0,0),(20724,2492,'湖坪乡',4,'',0,1,0,0),(20725,2492,'湖溪乡',4,'',0,1,0,0),(20726,2492,'牛田镇',4,'',0,1,0,0),(20727,2492,'罗陂乡',4,'',0,1,0,0),(20728,2492,'谷岗乡',4,'',0,1,0,0),(20729,2492,'金竹畲族乡',4,'',0,1,0,0),(20730,2492,'鳌溪镇',4,'',0,1,0,0),(20731,2492,'龚坊镇',4,'',0,1,0,0),(20732,2493,'三溪乡',4,'',0,1,0,0),(20733,2493,'东坪乡',4,'',0,1,0,0),(20734,2493,'傅坊乡',4,'',0,1,0,0),(20735,2493,'太和镇',4,'',0,1,0,0),(20736,2493,'太源乡',4,'',0,1,0,0),(20737,2493,'市山镇',4,'',0,1,0,0),(20738,2493,'桑田镇',4,'',0,1,0,0),(20739,2493,'洽湾镇',4,'',0,1,0,0),(20740,2493,'琴城镇',4,'',0,1,0,0),(20741,2493,'白舍镇',4,'',0,1,0,0),(20742,2493,'紫霄镇',4,'',0,1,0,0),(20743,2493,'莱溪乡',4,'',0,1,0,0),(20744,2494,'万坊镇',4,'',0,1,0,0),(20745,2494,'上唐镇',4,'',0,1,0,0),(20746,2494,'天井源乡',4,'',0,1,0,0),(20747,2494,'建昌镇',4,'',0,1,0,0),(20748,2494,'徐家乡',4,'',0,1,0,0),(20749,2494,'新丰街镇',4,'',0,1,0,0),(20750,2494,'株良镇',4,'',0,1,0,0),(20751,2494,'沙洲镇',4,'',0,1,0,0),(20752,2494,'洪门镇',4,'',0,1,0,0),(20753,2494,'浔溪乡',4,'',0,1,0,0),(20754,2494,'里塔镇',4,'',0,1,0,0),(20755,2494,'龙湖镇',4,'',0,1,0,0),(20756,2495,'东陂镇',4,'',0,1,0,0),(20757,2495,'中港乡',4,'',0,1,0,0),(20758,2495,'二都镇',4,'',0,1,0,0),(20759,2495,'凤冈镇',4,'',0,1,0,0),(20760,2495,'南源乡',4,'',0,1,0,0),(20761,2495,'圳口乡',4,'',0,1,0,0),(20762,2495,'新丰乡',4,'',0,1,0,0),(20763,2495,'桃陂乡',4,'',0,1,0,0),(20764,2495,'梨溪镇',4,'',0,1,0,0),(20765,2495,'棠阴镇',4,'',0,1,0,0),(20766,2495,'神冈乡',4,'',0,1,0,0),(20767,2495,'黄陂镇',4,'',0,1,0,0),(20768,2496,'三山乡',4,'',0,1,0,0),(20769,2496,'六家桥乡',4,'',0,1,0,0),(20770,2496,'孙坊镇',4,'',0,1,0,0),(20771,2496,'巴山镇',4,'',0,1,0,0),(20772,2496,'桃源乡',4,'',0,1,0,0),(20773,2496,'河上镇',4,'',0,1,0,0),(20774,2496,'白陂乡',4,'',0,1,0,0),(20775,2496,'白鹭乡',4,'',0,1,0,0),(20776,2496,'相山镇',4,'',0,1,0,0),(20777,2496,'石庄乡',4,'',0,1,0,0),(20778,2496,'礼陂镇',4,'',0,1,0,0),(20779,2496,'航埠镇',4,'',0,1,0,0),(20780,2496,'许坊乡',4,'',0,1,0,0),(20781,2496,'郭圩乡',4,'',0,1,0,0),(20782,2496,'马鞍镇',4,'',0,1,0,0),(20783,2497,'千善乡',4,'',0,1,0,0),(20784,2497,'塘坊乡',4,'',0,1,0,0),(20785,2497,'头陂镇',4,'',0,1,0,0),(20786,2497,'尖峰乡',4,'',0,1,0,0),(20787,2497,'杨溪乡',4,'',0,1,0,0),(20788,2497,'水南圩乡',4,'',0,1,0,0),(20789,2497,'甘竹镇',4,'',0,1,0,0),(20790,2497,'盱江镇',4,'',0,1,0,0),(20791,2497,'赤水镇',4,'',0,1,0,0),(20792,2497,'长桥乡',4,'',0,1,0,0),(20793,2497,'驿前镇',4,'',0,1,0,0),(20794,2498,'乌石镇',4,'',0,1,0,0),(20795,2498,'嵩市镇',4,'',0,1,0,0),(20796,2498,'石峡乡',4,'',0,1,0,0),(20797,2498,'马头山镇',4,'',0,1,0,0),(20798,2498,'高埠镇',4,'',0,1,0,0),(20799,2498,'高田乡',4,'',0,1,0,0),(20800,2498,'鹤城镇',4,'',0,1,0,0),(20801,2499,'何源镇',4,'',0,1,0,0),(20802,2499,'双塘镇',4,'',0,1,0,0),(20803,2499,'合市镇',4,'',0,1,0,0),(20804,2499,'对桥乡',4,'',0,1,0,0),(20805,2499,'左坊镇',4,'',0,1,0,0),(20806,2499,'浒湾镇',4,'',0,1,0,0),(20807,2499,'琅琚镇',4,'',0,1,0,0),(20808,2499,'琉璃乡',4,'',0,1,0,0),(20809,2499,'石门乡',4,'',0,1,0,0),(20810,2499,'秀谷镇',4,'',0,1,0,0),(20811,2499,'陆坊乡',4,'',0,1,0,0),(20812,2499,'陈坊积乡',4,'',0,1,0,0),(20813,2499,'黄通乡',4,'',0,1,0,0),(20814,2500,'中田乡',4,'',0,1,0,0),(20815,2500,'厚村乡',4,'',0,1,0,0),(20816,2500,'宏村镇',4,'',0,1,0,0),(20817,2500,'德胜镇',4,'',0,1,0,0),(20818,2500,'日峰镇',4,'',0,1,0,0),(20819,2500,'樟溪乡',4,'',0,1,0,0),(20820,2500,'洵口镇',4,'',0,1,0,0),(20821,2500,'湖坊乡',4,'',0,1,0,0),(20822,2500,'潭溪乡',4,'',0,1,0,0),(20823,2500,'熊村镇',4,'',0,1,0,0),(20824,2500,'社苹乡',4,'',0,1,0,0),(20825,2500,'荷源乡',4,'',0,1,0,0),(20826,2500,'西城乡',4,'',0,1,0,0),(20827,2500,'龙安镇',4,'',0,1,0,0),(20828,2501,'上坊乡',4,'',0,1,0,0),(20829,2501,'南溪乡',4,'',0,1,0,0),(20830,2501,'大源镇',4,'',0,1,0,0),(20831,2501,'大黄乡',4,'',0,1,0,0),(20832,2501,'梓埠镇',4,'',0,1,0,0),(20833,2501,'汪家乡',4,'',0,1,0,0),(20834,2501,'湖云乡',4,'',0,1,0,0),(20835,2501,'珠山乡',4,'',0,1,0,0),(20836,2501,'珠田乡',4,'',0,1,0,0),(20837,2501,'石镇镇',4,'',0,1,0,0),(20838,2501,'苏桥乡',4,'',0,1,0,0),(20839,2501,'裴梅镇',4,'',0,1,0,0),(20840,2501,'陈营镇',4,'',0,1,0,0),(20841,2501,'青云镇',4,'',0,1,0,0),(20842,2501,'齐埠乡',4,'',0,1,0,0),(20843,2502,'上泸镇',4,'',0,1,0,0),(20844,2502,'五府山镇',4,'',0,1,0,0),(20845,2502,'华坛山镇',4,'',0,1,0,0),(20846,2502,'四十八镇',4,'',0,1,0,0),(20847,2502,'大地乡',4,'',0,1,0,0),(20848,2502,'尊桥乡',4,'',0,1,0,0),(20849,2502,'应家乡',4,'',0,1,0,0),(20850,2502,'旭日工业园区(开发区)',4,'',0,1,0,0),(20851,2502,'旭日镇',4,'',0,1,0,0),(20852,2502,'望仙乡',4,'',0,1,0,0),(20853,2502,'枫岭头镇',4,'',0,1,0,0),(20854,2502,'清水乡',4,'',0,1,0,0),(20855,2502,'湖村乡',4,'',0,1,0,0),(20856,2502,'煌固镇',4,'',0,1,0,0),(20857,2502,'田墩镇',4,'',0,1,0,0),(20858,2502,'皂头镇',4,'',0,1,0,0),(20859,2502,'石人乡',4,'',0,1,0,0),(20860,2502,'石狮乡',4,'',0,1,0,0),(20861,2502,'花厅镇',4,'',0,1,0,0),(20862,2502,'茶亭镇',4,'',0,1,0,0),(20863,2502,'董团乡',4,'',0,1,0,0),(20864,2502,'郑坊镇',4,'',0,1,0,0),(20865,2502,'铁山乡',4,'',0,1,0,0),(20866,2502,'黄市乡',4,'',0,1,0,0),(20867,2502,'黄沙岭乡',4,'',0,1,0,0),(20868,2503,'三塘乡',4,'',0,1,0,0),(20869,2503,'东塘乡',4,'',0,1,0,0),(20870,2503,'乌泥镇',4,'',0,1,0,0),(20871,2503,'九龙乡',4,'',0,1,0,0),(20872,2503,'古埠镇',4,'',0,1,0,0),(20873,2503,'大塘乡',4,'',0,1,0,0),(20874,2503,'大溪乡',4,'',0,1,0,0),(20875,2503,'康山乡',4,'',0,1,0,0),(20876,2503,'杨埠乡',4,'',0,1,0,0),(20877,2503,'枫港乡',4,'',0,1,0,0),(20878,2503,'梅港乡',4,'',0,1,0,0),(20879,2503,'江埠乡',4,'',0,1,0,0),(20880,2503,'洪家嘴乡',4,'',0,1,0,0),(20881,2503,'玉亭镇',4,'',0,1,0,0),(20882,2503,'瑞洪镇',4,'',0,1,0,0),(20883,2503,'白马桥乡',4,'',0,1,0,0),(20884,2503,'石口镇',4,'',0,1,0,0),(20885,2503,'社庚乡',4,'',0,1,0,0),(20886,2503,'鹭鸶港乡',4,'',0,1,0,0),(20887,2503,'黄金埠镇',4,'',0,1,0,0),(20888,2504,'三江工业基地',4,'',0,1,0,0),(20889,2504,'东市街道',4,'',0,1,0,0),(20890,2504,'凤凰工业园区',4,'',0,1,0,0),(20891,2504,'北门街道',4,'',0,1,0,0),(20892,2504,'朝阳乡',4,'',0,1,0,0),(20893,2504,'水南街道',4,'',0,1,0,0),(20894,2504,'沙溪镇',4,'',0,1,0,0),(20895,2504,'灵溪镇',4,'',0,1,0,0),(20896,2504,'秦峰乡',4,'',0,1,0,0),(20897,2504,'茅家岭街道',4,'',0,1,0,0),(20898,2504,'西市街道',4,'',0,1,0,0),(20899,2505,'中云镇',4,'',0,1,0,0),(20900,2505,'古坦乡',4,'',0,1,0,0),(20901,2505,'大鄣山乡',4,'',0,1,0,0),(20902,2505,'太白镇',4,'',0,1,0,0),(20903,2505,'思口镇',4,'',0,1,0,0),(20904,2505,'段莘乡',4,'',0,1,0,0),(20905,2505,'江湾镇',4,'',0,1,0,0),(20906,2505,'沱川乡',4,'',0,1,0,0),(20907,2505,'浙源乡',4,'',0,1,0,0),(20908,2505,'清华镇',4,'',0,1,0,0),(20909,2505,'溪头乡',4,'',0,1,0,0),(20910,2505,'珍珠山乡',4,'',0,1,0,0),(20911,2505,'甲路乡',4,'',0,1,0,0),(20912,2505,'秋口镇',4,'',0,1,0,0),(20913,2505,'紫阳镇',4,'',0,1,0,0),(20914,2505,'许村镇',4,'',0,1,0,0),(20915,2505,'赋春镇',4,'',0,1,0,0),(20916,2505,'镇头镇',4,'',0,1,0,0),(20917,2506,'下溪镇',4,'',0,1,0,0),(20918,2506,'五都镇',4,'',0,1,0,0),(20919,2506,'吴村镇',4,'',0,1,0,0),(20920,2506,'塘墀乡',4,'',0,1,0,0),(20921,2506,'壶峤镇',4,'',0,1,0,0),(20922,2506,'大南镇',4,'',0,1,0,0),(20923,2506,'大石乡',4,'',0,1,0,0),(20924,2506,'少阳乡',4,'',0,1,0,0),(20925,2506,'岭底乡',4,'',0,1,0,0),(20926,2506,'嵩峰乡',4,'',0,1,0,0),(20927,2506,'排山镇',4,'',0,1,0,0),(20928,2506,'枧底镇',4,'',0,1,0,0),(20929,2506,'桐畈镇',4,'',0,1,0,0),(20930,2506,'横山镇',4,'',0,1,0,0),(20931,2506,'毛村镇',4,'',0,1,0,0),(20932,2506,'永丰镇',4,'',0,1,0,0),(20933,2506,'沙田镇',4,'',0,1,0,0),(20934,2506,'泉波镇',4,'',0,1,0,0),(20935,2506,'洋口镇',4,'',0,1,0,0),(20936,2506,'湖丰镇',4,'',0,1,0,0),(20937,2506,'社后乡',4,'',0,1,0,0),(20938,2506,'管村乡',4,'',0,1,0,0),(20939,2506,'芦林工业园区管理委员会',4,'',0,1,0,0),(20940,2506,'铜钹山垦殖场',4,'',0,1,0,0),(20941,2506,'霞峰镇',4,'',0,1,0,0),(20942,2507,'三县岭乡',4,'',0,1,0,0),(20943,2507,'中畈乡',4,'',0,1,0,0),(20944,2507,'南岩镇',4,'',0,1,0,0),(20945,2507,'叠山镇',4,'',0,1,0,0),(20946,2507,'圭峰镇',4,'',0,1,0,0),(20947,2507,'弋江镇',4,'',0,1,0,0),(20948,2507,'旭光乡',4,'',0,1,0,0),(20949,2507,'曹溪镇',4,'',0,1,0,0),(20950,2507,'朱坑镇',4,'',0,1,0,0),(20951,2507,'樟树墩镇',4,'',0,1,0,0),(20952,2507,'清湖乡',4,'',0,1,0,0),(20953,2507,'港口镇',4,'',0,1,0,0),(20954,2507,'湾里乡',4,'',0,1,0,0),(20955,2507,'漆工镇',4,'',0,1,0,0),(20956,2507,'烈桥乡',4,'',0,1,0,0),(20957,2507,'箭竹乡',4,'',0,1,0,0),(20958,2507,'花亭乡',4,'',0,1,0,0),(20959,2507,'葛溪乡',4,'',0,1,0,0),(20960,2508,'万村乡',4,'',0,1,0,0),(20961,2508,'张村乡',4,'',0,1,0,0),(20962,2508,'新岗山镇',4,'',0,1,0,0),(20963,2508,'李宅乡',4,'',0,1,0,0),(20964,2508,'泗洲镇',4,'',0,1,0,0),(20965,2508,'海口镇',4,'',0,1,0,0),(20966,2508,'皈大乡',4,'',0,1,0,0),(20967,2508,'绕二镇',4,'',0,1,0,0),(20968,2508,'花桥镇',4,'',0,1,0,0),(20969,2508,'银城镇',4,'',0,1,0,0),(20970,2508,'黄柏乡',4,'',0,1,0,0),(20971,2508,'龙头山乡',4,'',0,1,0,0),(20972,2509,'司铺乡',4,'',0,1,0,0),(20973,2509,'姚家乡',4,'',0,1,0,0),(20974,2509,'岑阳镇',4,'',0,1,0,0),(20975,2509,'新篁乡',4,'',0,1,0,0),(20976,2509,'港边乡',4,'',0,1,0,0),(20977,2509,'莲荷乡',4,'',0,1,0,0),(20978,2509,'葛源镇',4,'',0,1,0,0),(20979,2509,'青板乡',4,'',0,1,0,0),(20980,2509,'龙门畈乡',4,'',0,1,0,0),(20981,2510,'三清乡(三清山风景名胜区)',4,'',0,1,0,0),(20982,2510,'三清山风景区林场',4,'',0,1,0,0),(20983,2510,'下塘乡',4,'',0,1,0,0),(20984,2510,'下镇镇',4,'',0,1,0,0),(20985,2510,'临湖镇',4,'',0,1,0,0),(20986,2510,'仙岩镇',4,'',0,1,0,0),(20987,2510,'六都乡',4,'',0,1,0,0),(20988,2510,'冰溪镇',4,'',0,1,0,0),(20989,2510,'华村乡',4,'',0,1,0,0),(20990,2510,'南山乡',4,'',0,1,0,0),(20991,2510,'双明镇',4,'',0,1,0,0),(20992,2510,'四股桥乡',4,'',0,1,0,0),(20993,2510,'岩瑞镇',4,'',0,1,0,0),(20994,2510,'必姆镇',4,'',0,1,0,0),(20995,2510,'怀玉乡',4,'',0,1,0,0),(20996,2510,'文成镇',4,'',0,1,0,0),(20997,2510,'樟村镇',4,'',0,1,0,0),(20998,2510,'横街镇',4,'',0,1,0,0),(20999,2510,'白云镇',4,'',0,1,0,0),(21000,2510,'紫湖镇',4,'',0,1,0,0),(21001,2510,'金山工业园',4,'',0,1,0,0),(21002,2511,'乐丰镇',4,'',0,1,0,0),(21003,2511,'侯家岗乡',4,'',0,1,0,0),(21004,2511,'凰岗镇',4,'',0,1,0,0),(21005,2511,'双港镇',4,'',0,1,0,0),(21006,2511,'古南乡',4,'',0,1,0,0),(21007,2511,'古县渡镇',4,'',0,1,0,0),(21008,2511,'响水滩乡',4,'',0,1,0,0),(21009,2511,'四十里街镇',4,'',0,1,0,0),(21010,2511,'团林乡',4,'',0,1,0,0),(21011,2511,'庙前乡',4,'',0,1,0,0),(21012,2511,'昌洲乡',4,'',0,1,0,0),(21013,2511,'枧田街乡',4,'',0,1,0,0),(21014,2511,'柘港乡',4,'',0,1,0,0),(21015,2511,'桐山乡',4,'',0,1,0,0),(21016,2511,'桥头街乡',4,'',0,1,0,0),(21017,2511,'油墩街镇',4,'',0,1,0,0),(21018,2511,'游城乡',4,'',0,1,0,0),(21019,2511,'珠湖乡',4,'',0,1,0,0),(21020,2511,'田畈街镇',4,'',0,1,0,0),(21021,2511,'白沙洲乡',4,'',0,1,0,0),(21022,2511,'石门街镇',4,'',0,1,0,0),(21023,2511,'肖家岭乡',4,'',0,1,0,0),(21024,2511,'芦田乡',4,'',0,1,0,0),(21025,2511,'莲山乡',4,'',0,1,0,0),(21026,2511,'莲湖乡',4,'',0,1,0,0),(21027,2511,'莲花山乡',4,'',0,1,0,0),(21028,2511,'谢家滩镇',4,'',0,1,0,0),(21029,2511,'鄱阳镇',4,'',0,1,0,0),(21030,2511,'金盘岭镇',4,'',0,1,0,0),(21031,2511,'银宝湖乡',4,'',0,1,0,0),(21032,2511,'饶丰镇',4,'',0,1,0,0),(21033,2511,'饶埠镇',4,'',0,1,0,0),(21034,2511,'高家岭镇',4,'',0,1,0,0),(21035,2511,'鸦鹊湖乡',4,'',0,1,0,0),(21036,2512,'天柱山乡',4,'',0,1,0,0),(21037,2512,'太源畲族乡',4,'',0,1,0,0),(21038,2512,'新滩乡',4,'',0,1,0,0),(21039,2512,'武夷山镇',4,'',0,1,0,0),(21040,2512,'永平镇',4,'',0,1,0,0),(21041,2512,'汪二镇',4,'',0,1,0,0),(21042,2512,'河口镇',4,'',0,1,0,0),(21043,2512,'湖坊镇',4,'',0,1,0,0),(21044,2512,'石塘镇',4,'',0,1,0,0),(21045,2512,'稼轩乡',4,'',0,1,0,0),(21046,2512,'篁碧畲族乡',4,'',0,1,0,0),(21047,2512,'紫溪乡',4,'',0,1,0,0),(21048,2512,'英将乡',4,'',0,1,0,0),(21049,2512,'葛仙山乡',4,'',0,1,0,0),(21050,2512,'虹桥乡',4,'',0,1,0,0),(21051,2512,'陈坊乡',4,'',0,1,0,0),(21052,2512,'鹅湖镇',4,'',0,1,0,0),(21053,2513,'东关街道',4,'',0,1,0,0),(21054,2513,'东门街道',4,'',0,1,0,0),(21055,2513,'司里街街道',4,'',0,1,0,0),(21056,2513,'和平路街道',4,'',0,1,0,0),(21057,2513,'姚家街道',4,'',0,1,0,0),(21058,2513,'建新街道',4,'',0,1,0,0),(21059,2513,'文东街道',4,'',0,1,0,0),(21060,2513,'智远街道',4,'',0,1,0,0),(21061,2513,'泉城路街道',4,'',0,1,0,0),(21062,2513,'甸柳街道',4,'',0,1,0,0),(21063,2513,'解放路街道',4,'',0,1,0,0),(21064,2513,'趵突泉街道',4,'',0,1,0,0),(21065,2513,'龙洞街道',4,'',0,1,0,0),(21066,2514,'东风街道',4,'',0,1,0,0),(21067,2514,'仲宫镇',4,'',0,1,0,0),(21068,2514,'全福街道',4,'',0,1,0,0),(21069,2514,'华山镇',4,'',0,1,0,0),(21070,2514,'唐王镇',4,'',0,1,0,0),(21071,2514,'孙村镇',4,'',0,1,0,0),(21072,2514,'山大路街道',4,'',0,1,0,0),(21073,2514,'彩石乡',4,'',0,1,0,0),(21074,2514,'柳埠镇',4,'',0,1,0,0),(21075,2514,'洪家楼街道',4,'',0,1,0,0),(21076,2514,'港沟镇',4,'',0,1,0,0),(21077,2514,'王舍人镇',4,'',0,1,0,0),(21078,2514,'董家镇',4,'',0,1,0,0),(21079,2514,'西营镇',4,'',0,1,0,0),(21080,2514,'遥墙镇',4,'',0,1,0,0),(21081,2514,'郭店镇',4,'',0,1,0,0),(21082,2514,'锦绣川乡',4,'',0,1,0,0),(21083,2514,'高而乡',4,'',0,1,0,0),(21084,2515,'孙集',4,'',0,1,0,0),(21085,2515,'张坊',4,'',0,1,0,0),(21086,2515,'怀仁',4,'',0,1,0,0),(21087,2515,'殷巷',4,'',0,1,0,0),(21088,2515,'沙河',4,'',0,1,0,0),(21089,2515,'玉皇庙街道办事处',4,'',0,1,0,0),(21090,2515,'白桥',4,'',0,1,0,0),(21091,2515,'许商街道办事处',4,'',0,1,0,0),(21092,2515,'贾庄',4,'',0,1,0,0),(21093,2515,'郑路',4,'',0,1,0,0),(21094,2515,'韩庙',4,'',0,1,0,0),(21095,2515,'龙桑寺',4,'',0,1,0,0),(21096,2516,'制锦市街道',4,'',0,1,0,0),(21097,2516,'北园街道',4,'',0,1,0,0),(21098,2516,'北坦街街道',4,'',0,1,0,0),(21099,2516,'堤口路街道',4,'',0,1,0,0),(21100,2516,'大桥镇',4,'',0,1,0,0),(21101,2516,'天桥东街街道',4,'',0,1,0,0),(21102,2516,'官扎营街道',4,'',0,1,0,0),(21103,2516,'宝华街街道',4,'',0,1,0,0),(21104,2516,'工人新村北村街道',4,'',0,1,0,0),(21105,2516,'工人新村南村街道',4,'',0,1,0,0),(21106,2516,'无影山街道',4,'',0,1,0,0),(21107,2516,'桑梓店镇',4,'',0,1,0,0),(21108,2516,'泺口街道',4,'',0,1,0,0),(21109,2516,'纬北路街道',4,'',0,1,0,0),(21110,2516,'药山街道',4,'',0,1,0,0),(21111,2517,'七贤街道',4,'',0,1,0,0),(21112,2517,'七里山街道',4,'',0,1,0,0),(21113,2517,'二七街道',4,'',0,1,0,0),(21114,2517,'党家街道',4,'',0,1,0,0),(21115,2517,'六里山街道',4,'',0,1,0,0),(21116,2517,'兴隆街道',4,'',0,1,0,0),(21117,2517,'十六里河街道',4,'',0,1,0,0),(21118,2517,'四里村街道',4,'',0,1,0,0),(21119,2517,'大观园街道',4,'',0,1,0,0),(21120,2517,'杆石桥街道',4,'',0,1,0,0),(21121,2517,'泺源街道',4,'',0,1,0,0),(21122,2517,'王官庄街道',4,'',0,1,0,0),(21123,2517,'白马山街道',4,'',0,1,0,0),(21124,2517,'舜玉路街道',4,'',0,1,0,0),(21125,2517,'舜耕街道',4,'',0,1,0,0),(21126,2517,'陡沟街道',4,'',0,1,0,0),(21127,2517,'魏家庄街道',4,'',0,1,0,0),(21128,2518,'东阿镇',4,'',0,1,0,0),(21129,2518,'孔村镇',4,'',0,1,0,0),(21130,2518,'孝直镇',4,'',0,1,0,0),(21131,2518,'安城乡',4,'',0,1,0,0),(21132,2518,'平阴镇',4,'',0,1,0,0),(21133,2518,'洪范池镇',4,'',0,1,0,0),(21134,2518,'玫瑰镇',4,'',0,1,0,0),(21135,2519,'中大槐树街道',4,'',0,1,0,0),(21136,2519,'五里沟街道',4,'',0,1,0,0),(21137,2519,'匡山街道',4,'',0,1,0,0),(21138,2519,'南辛庄街道',4,'',0,1,0,0),(21139,2519,'吴家堡镇',4,'',0,1,0,0),(21140,2519,'张庄路街道',4,'',0,1,0,0),(21141,2519,'振兴街街道',4,'',0,1,0,0),(21142,2519,'段店北路街道',4,'',0,1,0,0),(21143,2519,'段店镇',4,'',0,1,0,0),(21144,2519,'美里湖街道',4,'',0,1,0,0),(21145,2519,'营市街街道',4,'',0,1,0,0),(21146,2519,'西市场街道',4,'',0,1,0,0),(21147,2519,'道德街街道',4,'',0,1,0,0),(21148,2519,'青年公园街道',4,'',0,1,0,0),(21149,2520,'二太平镇',4,'',0,1,0,0),(21150,2520,'仁风镇',4,'',0,1,0,0),(21151,2520,'垛石镇',4,'',0,1,0,0),(21152,2520,'孙耿镇',4,'',0,1,0,0),(21153,2520,'崔寨镇',4,'',0,1,0,0),(21154,2520,'新市镇',4,'',0,1,0,0),(21155,2520,'曲堤镇',4,'',0,1,0,0),(21156,2520,'济阳镇',4,'',0,1,0,0),(21157,2521,'刁镇',4,'',0,1,0,0),(21158,2521,'双山街道',4,'',0,1,0,0),(21159,2521,'圣井街道',4,'',0,1,0,0),(21160,2521,'垛庄镇',4,'',0,1,0,0),(21161,2521,'埠村街道',4,'',0,1,0,0),(21162,2521,'宁家埠镇',4,'',0,1,0,0),(21163,2521,'官庄乡',4,'',0,1,0,0),(21164,2521,'文祖镇',4,'',0,1,0,0),(21165,2521,'明水街道',4,'',0,1,0,0),(21166,2521,'普集镇',4,'',0,1,0,0),(21167,2521,'曹范镇',4,'',0,1,0,0),(21168,2521,'枣园街道',4,'',0,1,0,0),(21169,2521,'水寨镇',4,'',0,1,0,0),(21170,2521,'白云湖镇',4,'',0,1,0,0),(21171,2521,'相公庄镇',4,'',0,1,0,0),(21172,2521,'绣惠镇',4,'',0,1,0,0),(21173,2521,'辛寨乡',4,'',0,1,0,0),(21174,2521,'高官寨镇',4,'',0,1,0,0),(21175,2521,'黄河乡',4,'',0,1,0,0),(21176,2521,'龙山街道',4,'',0,1,0,0),(21177,2522,'万德镇',4,'',0,1,0,0),(21178,2522,'五峰山街道',4,'',0,1,0,0),(21179,2522,'双泉乡',4,'',0,1,0,0),(21180,2522,'孝里镇',4,'',0,1,0,0),(21181,2522,'崮云湖街道',4,'',0,1,0,0),(21182,2522,'平安街道',4,'',0,1,0,0),(21183,2522,'张夏镇',4,'',0,1,0,0),(21184,2522,'归德镇',4,'',0,1,0,0),(21185,2522,'文昌街道',4,'',0,1,0,0),(21186,2522,'武家庄乡',4,'',0,1,0,0),(21187,2522,'马山镇',4,'',0,1,0,0),(21188,2523,'七级镇',4,'',0,1,0,0),(21189,2523,'丰城镇',4,'',0,1,0,0),(21190,2523,'刘家庄镇',4,'',0,1,0,0),(21191,2523,'北安街道',4,'',0,1,0,0),(21192,2523,'华山镇',4,'',0,1,0,0),(21193,2523,'南泉镇',4,'',0,1,0,0),(21194,2523,'大信镇',4,'',0,1,0,0),(21195,2523,'岙山卫镇',4,'',0,1,0,0),(21196,2523,'店集镇',4,'',0,1,0,0),(21197,2523,'普东镇',4,'',0,1,0,0),(21198,2523,'段泊岚镇',4,'',0,1,0,0),(21199,2523,'温泉镇',4,'',0,1,0,0),(21200,2523,'潮海街道',4,'',0,1,0,0),(21201,2523,'灵山镇',4,'',0,1,0,0),(21202,2523,'王村镇',4,'',0,1,0,0),(21203,2523,'环秀街道',4,'',0,1,0,0),(21204,2523,'田横镇',4,'',0,1,0,0),(21205,2523,'移风店镇',4,'',0,1,0,0),(21206,2523,'蓝村镇',4,'',0,1,0,0),(21207,2523,'通济街道',4,'',0,1,0,0),(21208,2523,'金口镇',4,'',0,1,0,0),(21209,2523,'龙山街道',4,'',0,1,0,0),(21210,2523,'龙泉镇',4,'',0,1,0,0),(21211,2524,'兴隆路街道',4,'',0,1,0,0),(21212,2524,'嘉兴路街道',4,'',0,1,0,0),(21213,2524,'水清沟街道',4,'',0,1,0,0),(21214,2524,'河西街道',4,'',0,1,0,0),(21215,2524,'洛阳路街道',4,'',0,1,0,0),(21216,2524,'海伦路街道',4,'',0,1,0,0),(21217,2524,'阜新路街道',4,'',0,1,0,0),(21218,2525,'上马街道',4,'',0,1,0,0),(21219,2525,'城阳街道',4,'',0,1,0,0),(21220,2525,'夏庄街道',4,'',0,1,0,0),(21221,2525,'惜福街道',4,'',0,1,0,0),(21222,2525,'棘洪滩街道',4,'',0,1,0,0),(21223,2525,'河套街道',4,'',0,1,0,0),(21224,2525,'流亭街道',4,'',0,1,0,0),(21225,2525,'红岛街道',4,'',0,1,0,0),(21226,2526,'中韩街道',4,'',0,1,0,0),(21227,2526,'北宅街道',4,'',0,1,0,0),(21228,2526,'沙子口街道',4,'',0,1,0,0),(21229,2526,'王哥庄街道',4,'',0,1,0,0),(21230,2527,'冠县路街道',4,'',0,1,0,0),(21231,2527,'利津路街道',4,'',0,1,0,0),(21232,2527,'北仲路街道',4,'',0,1,0,0),(21233,2527,'华阳路街道',4,'',0,1,0,0),(21234,2527,'合肥路街道',4,'',0,1,0,0),(21235,2527,'威海路街道',4,'',0,1,0,0),(21236,2527,'宁夏路街道',4,'',0,1,0,0),(21237,2527,'延安路街道',4,'',0,1,0,0),(21238,2527,'敦化路街道',4,'',0,1,0,0),(21239,2527,'泰山路街道',4,'',0,1,0,0),(21240,2527,'热河路街道',4,'',0,1,0,0),(21241,2527,'登州路街道',4,'',0,1,0,0),(21242,2527,'胶州路街道',4,'',0,1,0,0),(21243,2527,'辽宁路街道',4,'',0,1,0,0),(21244,2527,'辽源路街道',4,'',0,1,0,0),(21245,2527,'黄台路街道',4,'',0,1,0,0),(21246,2528,'中山路街道',4,'',0,1,0,0),(21247,2528,'云南路街道',4,'',0,1,0,0),(21248,2528,'八大关街道',4,'',0,1,0,0),(21249,2528,'八大峡街道',4,'',0,1,0,0),(21250,2528,'八大湖街道',4,'',0,1,0,0),(21251,2528,'台西街道',4,'',0,1,0,0),(21252,2528,'江苏路街道',4,'',0,1,0,0),(21253,2528,'浮山街道',4,'',0,1,0,0),(21254,2528,'湛山街道',4,'',0,1,0,0),(21255,2528,'珠海路街道',4,'',0,1,0,0),(21256,2528,'观海路街道',4,'',0,1,0,0),(21257,2528,'金口路街道',4,'',0,1,0,0),(21258,2528,'金湖路街道',4,'',0,1,0,0),(21259,2528,'金门路街道',4,'',0,1,0,0),(21260,2529,'万家镇',4,'',0,1,0,0),(21261,2529,'云山镇',4,'',0,1,0,0),(21262,2529,'仁兆镇',4,'',0,1,0,0),(21263,2529,'兰底镇',4,'',0,1,0,0),(21264,2529,'南村镇',4,'',0,1,0,0),(21265,2529,'古岘镇',4,'',0,1,0,0),(21266,2529,'同和街道',4,'',0,1,0,0),(21267,2529,'城关街道',4,'',0,1,0,0),(21268,2529,'大泽山镇',4,'',0,1,0,0),(21269,2529,'大田镇',4,'',0,1,0,0),(21270,2529,'崔召镇',4,'',0,1,0,0),(21271,2529,'崔家集镇',4,'',0,1,0,0),(21272,2529,'店子镇',4,'',0,1,0,0),(21273,2529,'张戈庄镇',4,'',0,1,0,0),(21274,2529,'张舍镇',4,'',0,1,0,0),(21275,2529,'新河镇',4,'',0,1,0,0),(21276,2529,'旧店镇',4,'',0,1,0,0),(21277,2529,'明村镇',4,'',0,1,0,0),(21278,2529,'李园街道',4,'',0,1,0,0),(21279,2529,'灰埠镇',4,'',0,1,0,0),(21280,2529,'田庄镇',4,'',0,1,0,0),(21281,2529,'白埠镇',4,'',0,1,0,0),(21282,2529,'祝沟镇',4,'',0,1,0,0),(21283,2529,'蓼兰镇',4,'',0,1,0,0),(21284,2529,'郭庄镇',4,'',0,1,0,0),(21285,2529,'长乐镇',4,'',0,1,0,0),(21286,2529,'门村镇',4,'',0,1,0,0),(21287,2529,'香店街道',4,'',0,1,0,0),(21288,2529,'马戈庄镇',4,'',0,1,0,0),(21289,2529,'麻兰镇',4,'',0,1,0,0),(21290,2530,'九水路街道',4,'',0,1,0,0),(21291,2530,'兴华路街道',4,'',0,1,0,0),(21292,2530,'兴城路街道',4,'',0,1,0,0),(21293,2530,'振华路街道',4,'',0,1,0,0),(21294,2530,'李村街道',4,'',0,1,0,0),(21295,2530,'楼山街道',4,'',0,1,0,0),(21296,2530,'永安路街道',4,'',0,1,0,0),(21297,2530,'永清路街道',4,'',0,1,0,0),(21298,2530,'浮山路街道',4,'',0,1,0,0),(21299,2530,'湘潭路街道',4,'',0,1,0,0),(21300,2530,'虎山路街道',4,'',0,1,0,0),(21301,2531,'六汪镇',4,'',0,1,0,0),(21302,2531,'大场镇',4,'',0,1,0,0),(21303,2531,'大村镇',4,'',0,1,0,0),(21304,2531,'宝山镇',4,'',0,1,0,0),(21305,2531,'张家楼镇',4,'',0,1,0,0),(21306,2531,'泊里镇',4,'',0,1,0,0),(21307,2531,'海青镇',4,'',0,1,0,0),(21308,2531,'滨海街道办事处',4,'',0,1,0,0),(21309,2531,'灵山卫街道办事处',4,'',0,1,0,0),(21310,2531,'王台镇',4,'',0,1,0,0),(21311,2531,'珠山街道办事处',4,'',0,1,0,0),(21312,2531,'珠海街道办事处',4,'',0,1,0,0),(21313,2531,'琅玡台度假区',4,'',0,1,0,0),(21314,2531,'琅玡镇',4,'',0,1,0,0),(21315,2531,'理务关镇',4,'',0,1,0,0),(21316,2531,'积米崖港区',4,'',0,1,0,0),(21317,2531,'经济技术开发区',4,'',0,1,0,0),(21318,2531,'胶河经济区',4,'',0,1,0,0),(21319,2531,'藏南镇',4,'',0,1,0,0),(21320,2531,'铁山街道办事处',4,'',0,1,0,0),(21321,2531,'隐珠街道办事处',4,'',0,1,0,0),(21322,2531,'黄山经济区',4,'',0,1,0,0),(21323,2532,'中云街道',4,'',0,1,0,0),(21324,2532,'九龙镇',4,'',0,1,0,0),(21325,2532,'云溪街道',4,'',0,1,0,0),(21326,2532,'北关街道',4,'',0,1,0,0),(21327,2532,'南关街道',4,'',0,1,0,0),(21328,2532,'张应镇',4,'',0,1,0,0),(21329,2532,'李哥庄镇',4,'',0,1,0,0),(21330,2532,'杜村镇',4,'',0,1,0,0),(21331,2532,'洋河镇',4,'',0,1,0,0),(21332,2532,'胶东镇',4,'',0,1,0,0),(21333,2532,'胶北镇',4,'',0,1,0,0),(21334,2532,'胶莱镇',4,'',0,1,0,0),(21335,2532,'胶西镇',4,'',0,1,0,0),(21336,2532,'营海镇',4,'',0,1,0,0),(21337,2532,'里岔镇',4,'',0,1,0,0),(21338,2532,'铺集镇',4,'',0,1,0,0),(21339,2532,'阜安街道',4,'',0,1,0,0),(21340,2532,'马店镇',4,'',0,1,0,0),(21341,2533,'南墅镇',4,'',0,1,0,0),(21342,2533,'夏格庄镇',4,'',0,1,0,0),(21343,2533,'姜山镇',4,'',0,1,0,0),(21344,2533,'孙受镇',4,'',0,1,0,0),(21345,2533,'店埠镇',4,'',0,1,0,0),(21346,2533,'日庄镇',4,'',0,1,0,0),(21347,2533,'望城街道',4,'',0,1,0,0),(21348,2533,'李权庄镇',4,'',0,1,0,0),(21349,2533,'梅花山街道',4,'',0,1,0,0),(21350,2533,'武备镇',4,'',0,1,0,0),(21351,2533,'水集街道',4,'',0,1,0,0),(21352,2533,'河头店镇',4,'',0,1,0,0),(21353,2533,'沽河街道',4,'',0,1,0,0),(21354,2533,'院上镇',4,'',0,1,0,0),(21355,2533,'马连庄镇',4,'',0,1,0,0),(21356,2533,'龙水街道',4,'',0,1,0,0),(21357,2534,'柳花泊街道',4,'',0,1,0,0),(21358,2534,'红石崖街道',4,'',0,1,0,0),(21359,2534,'薛家岛街道',4,'',0,1,0,0),(21360,2534,'辛安街街道',4,'',0,1,0,0),(21361,2534,'长江路街道',4,'',0,1,0,0),(21362,2534,'黄岛街道',4,'',0,1,0,0),(21363,2535,'凤凰镇',4,'',0,1,0,0),(21364,2535,'南王镇',4,'',0,1,0,0),(21365,2535,'敬仲镇',4,'',0,1,0,0),(21366,2535,'朱台镇',4,'',0,1,0,0),(21367,2535,'梧台镇',4,'',0,1,0,0),(21368,2535,'皇城镇',4,'',0,1,0,0),(21369,2535,'稷下街道',4,'',0,1,0,0),(21370,2535,'辛店街道',4,'',0,1,0,0),(21371,2535,'边河乡',4,'',0,1,0,0),(21372,2535,'金岭镇',4,'',0,1,0,0),(21373,2535,'闻韶街道',4,'',0,1,0,0),(21374,2535,'雪宫街道',4,'',0,1,0,0),(21375,2535,'齐都镇',4,'',0,1,0,0),(21376,2535,'齐陵街道',4,'',0,1,0,0),(21377,2536,'八陡镇',4,'',0,1,0,0),(21378,2536,'北博山镇',4,'',0,1,0,0),(21379,2536,'南博山镇',4,'',0,1,0,0),(21380,2536,'城东街道',4,'',0,1,0,0),(21381,2536,'城西街道',4,'',0,1,0,0),(21382,2536,'域城镇',4,'',0,1,0,0),(21383,2536,'夏家庄镇',4,'',0,1,0,0),(21384,2536,'山头镇',4,'',0,1,0,0),(21385,2536,'崮山镇',4,'',0,1,0,0),(21386,2536,'池上镇',4,'',0,1,0,0),(21387,2536,'源泉镇',4,'',0,1,0,0),(21388,2536,'白塔镇',4,'',0,1,0,0),(21389,2536,'石马镇',4,'',0,1,0,0),(21390,2537,'丝绸路街道',4,'',0,1,0,0),(21391,2537,'北郊镇',4,'',0,1,0,0),(21392,2537,'南郊镇',4,'',0,1,0,0),(21393,2537,'城北路街道',4,'',0,1,0,0),(21394,2537,'大街街道',4,'',0,1,0,0),(21395,2537,'永安街街道',4,'',0,1,0,0),(21396,2537,'王村镇',4,'',0,1,0,0),(21397,2537,'萌水镇',4,'',0,1,0,0),(21398,2537,'青年路街道',4,'',0,1,0,0),(21399,2538,'中埠镇',4,'',0,1,0,0),(21400,2538,'体育场街道',4,'',0,1,0,0),(21401,2538,'傅家镇',4,'',0,1,0,0),(21402,2538,'公园街道',4,'',0,1,0,0),(21403,2538,'南定镇',4,'',0,1,0,0),(21404,2538,'卫固镇',4,'',0,1,0,0),(21405,2538,'和平街道',4,'',0,1,0,0),(21406,2538,'四宝山办',4,'',0,1,0,0),(21407,2538,'房镇镇',4,'',0,1,0,0),(21408,2538,'杏园街道',4,'',0,1,0,0),(21409,2538,'沣水镇',4,'',0,1,0,0),(21410,2538,'湖田镇',4,'',0,1,0,0),(21411,2538,'石桥街道',4,'',0,1,0,0),(21412,2538,'科苑街道',4,'',0,1,0,0),(21413,2538,'车站街道',4,'',0,1,0,0),(21414,2538,'马尚镇',4,'',0,1,0,0),(21415,2539,'周家镇',4,'',0,1,0,0),(21416,2539,'唐山镇',4,'',0,1,0,0),(21417,2539,'新城镇',4,'',0,1,0,0),(21418,2539,'果里镇',4,'',0,1,0,0),(21419,2539,'田庄镇',4,'',0,1,0,0),(21420,2539,'索镇镇',4,'',0,1,0,0),(21421,2539,'荆家镇',4,'',0,1,0,0),(21422,2539,'起凤镇',4,'',0,1,0,0),(21423,2539,'邢家镇',4,'',0,1,0,0),(21424,2539,'陈庄镇',4,'',0,1,0,0),(21425,2539,'马桥镇',4,'',0,1,0,0),(21426,2540,'三岔乡',4,'',0,1,0,0),(21427,2540,'东里镇',4,'',0,1,0,0),(21428,2540,'中庄镇',4,'',0,1,0,0),(21429,2540,'南麻镇',4,'',0,1,0,0),(21430,2540,'土门镇',4,'',0,1,0,0),(21431,2540,'大张庄镇',4,'',0,1,0,0),(21432,2540,'张家坡镇',4,'',0,1,0,0),(21433,2540,'徐家庄乡',4,'',0,1,0,0),(21434,2540,'悦庄镇',4,'',0,1,0,0),(21435,2540,'燕崖乡',4,'',0,1,0,0),(21436,2540,'石桥乡',4,'',0,1,0,0),(21437,2540,'西里镇',4,'',0,1,0,0),(21438,2540,'鲁村镇',4,'',0,1,0,0),(21439,2541,'东坪镇',4,'',0,1,0,0),(21440,2541,'双沟镇',4,'',0,1,0,0),(21441,2541,'商城路街道',4,'',0,1,0,0),(21442,2541,'商家镇',4,'',0,1,0,0),(21443,2541,'城南镇',4,'',0,1,0,0),(21444,2541,'太河乡',4,'',0,1,0,0),(21445,2541,'寨里镇',4,'',0,1,0,0),(21446,2541,'岭子镇',4,'',0,1,0,0),(21447,2541,'峨庄乡',4,'',0,1,0,0),(21448,2541,'张庄乡',4,'',0,1,0,0),(21449,2541,'昆仑镇',4,'',0,1,0,0),(21450,2541,'杨寨镇',4,'',0,1,0,0),(21451,2541,'松龄路街道',4,'',0,1,0,0),(21452,2541,'洪山镇',4,'',0,1,0,0),(21453,2541,'淄河镇',4,'',0,1,0,0),(21454,2541,'磁村镇',4,'',0,1,0,0),(21455,2541,'罗村镇',4,'',0,1,0,0),(21456,2541,'般阳路街道',4,'',0,1,0,0),(21457,2541,'西河镇',4,'',0,1,0,0),(21458,2541,'黄家铺镇',4,'',0,1,0,0),(21459,2541,'黑旺镇',4,'',0,1,0,0),(21460,2541,'龙泉镇',4,'',0,1,0,0),(21461,2542,'唐坊镇',4,'',0,1,0,0),(21462,2542,'常家镇',4,'',0,1,0,0),(21463,2542,'木李镇',4,'',0,1,0,0),(21464,2542,'田镇镇',4,'',0,1,0,0),(21465,2542,'花沟镇',4,'',0,1,0,0),(21466,2542,'赵店镇',4,'',0,1,0,0),(21467,2542,'青城镇',4,'',0,1,0,0),(21468,2542,'高城镇',4,'',0,1,0,0),(21469,2542,'黑里寨镇',4,'',0,1,0,0),(21470,2543,'张山子镇',4,'',0,1,0,0),(21471,2543,'泥沟镇',4,'',0,1,0,0),(21472,2543,'涧头集镇',4,'',0,1,0,0),(21473,2543,'运河街道',4,'',0,1,0,0),(21474,2543,'邳庄镇',4,'',0,1,0,0),(21475,2543,'马兰屯镇',4,'',0,1,0,0),(21476,2544,'冯卯镇',4,'',0,1,0,0),(21477,2544,'凫城乡',4,'',0,1,0,0),(21478,2544,'北庄镇',4,'',0,1,0,0),(21479,2544,'城头镇',4,'',0,1,0,0),(21480,2544,'山城街道',4,'',0,1,0,0),(21481,2544,'店子镇',4,'',0,1,0,0),(21482,2544,'徐庄镇',4,'',0,1,0,0),(21483,2544,'桑村镇',4,'',0,1,0,0),(21484,2544,'水泉镇',4,'',0,1,0,0),(21485,2544,'西集镇',4,'',0,1,0,0),(21486,2545,'古邵镇',4,'',0,1,0,0),(21487,2545,'吴林街道办事处',4,'',0,1,0,0),(21488,2545,'坛山街道办事处',4,'',0,1,0,0),(21489,2545,'峨山镇',4,'',0,1,0,0),(21490,2545,'底阁镇',4,'',0,1,0,0),(21491,2545,'榴园镇',4,'',0,1,0,0),(21492,2545,'阴平镇',4,'',0,1,0,0),(21493,2546,'中心街街道',4,'',0,1,0,0),(21494,2546,'光明路街道',4,'',0,1,0,0),(21495,2546,'各塔埠矿区街道',4,'',0,1,0,0),(21496,2546,'孟庄镇',4,'',0,1,0,0),(21497,2546,'文化路街道',4,'',0,1,0,0),(21498,2546,'永安乡',4,'',0,1,0,0),(21499,2546,'税郭镇',4,'',0,1,0,0),(21500,2546,'西王庄乡',4,'',0,1,0,0),(21501,2546,'齐村镇',4,'',0,1,0,0),(21502,2546,'龙山路街道',4,'',0,1,0,0),(21503,2547,'东沙河镇',4,'',0,1,0,0),(21504,2547,'东郭镇',4,'',0,1,0,0),(21505,2547,'北辛街道',4,'',0,1,0,0),(21506,2547,'南沙河镇',4,'',0,1,0,0),(21507,2547,'善南街道',4,'',0,1,0,0),(21508,2547,'大坞镇',4,'',0,1,0,0),(21509,2547,'姜屯镇',4,'',0,1,0,0),(21510,2547,'官桥镇',4,'',0,1,0,0),(21511,2547,'张汪镇',4,'',0,1,0,0),(21512,2547,'木石镇',4,'',0,1,0,0),(21513,2547,'柴胡店镇',4,'',0,1,0,0),(21514,2547,'洪绪镇',4,'',0,1,0,0),(21515,2547,'滨湖镇',4,'',0,1,0,0),(21516,2547,'界河镇',4,'',0,1,0,0),(21517,2547,'级索镇',4,'',0,1,0,0),(21518,2547,'羊庄镇',4,'',0,1,0,0),(21519,2547,'荆河街道',4,'',0,1,0,0),(21520,2547,'西岗镇',4,'',0,1,0,0),(21521,2547,'鲍沟镇',4,'',0,1,0,0),(21522,2547,'龙泉街道',4,'',0,1,0,0),(21523,2547,'龙阳镇',4,'',0,1,0,0),(21524,2548,'临城街道',4,'',0,1,0,0),(21525,2548,'兴仁街道',4,'',0,1,0,0),(21526,2548,'兴城街道',4,'',0,1,0,0),(21527,2548,'周营镇',4,'',0,1,0,0),(21528,2548,'常庄镇',4,'',0,1,0,0),(21529,2548,'张苑镇',4,'',0,1,0,0),(21530,2548,'沙沟镇',4,'',0,1,0,0),(21531,2548,'邹坞镇',4,'',0,1,0,0),(21532,2548,'陶庄镇',4,'',0,1,0,0),(21533,2549,'东城街道办事处',4,'',0,1,0,0),(21534,2549,'六户镇',4,'',0,1,0,0),(21535,2549,'史口镇',4,'',0,1,0,0),(21536,2549,'文汇街道办事处',4,'',0,1,0,0),(21537,2549,'牛庄镇',4,'',0,1,0,0),(21538,2549,'胜利街道办事处',4,'',0,1,0,0),(21539,2549,'胜园街道办事处',4,'',0,1,0,0),(21540,2549,'辛店街道办事处',4,'',0,1,0,0),(21541,2549,'黄河路街道办事处',4,'',0,1,0,0),(21542,2549,'龙居乡',4,'',0,1,0,0),(21543,2550,'刁口乡',4,'',0,1,0,0),(21544,2550,'利津镇',4,'',0,1,0,0),(21545,2550,'北宋镇',4,'',0,1,0,0),(21546,2550,'北岭乡',4,'',0,1,0,0),(21547,2550,'明集乡',4,'',0,1,0,0),(21548,2550,'汀罗镇',4,'',0,1,0,0),(21549,2550,'盐窝镇',4,'',0,1,0,0),(21550,2550,'虎滩乡',4,'',0,1,0,0),(21551,2550,'陈庄镇',4,'',0,1,0,0),(21552,2551,'垦利镇',4,'',0,1,0,0),(21553,2551,'永安镇',4,'',0,1,0,0),(21554,2551,'胜坨镇',4,'',0,1,0,0),(21555,2551,'董集乡',4,'',0,1,0,0),(21556,2551,'西宋乡',4,'',0,1,0,0),(21557,2551,'郝家镇',4,'',0,1,0,0),(21558,2551,'黄河口镇',4,'',0,1,0,0),(21559,2552,'丁庄镇',4,'',0,1,0,0),(21560,2552,'城区办事处',4,'',0,1,0,0),(21561,2552,'大王镇',4,'',0,1,0,0),(21562,2552,'大码头乡',4,'',0,1,0,0),(21563,2552,'广饶镇',4,'',0,1,0,0),(21564,2552,'李鹊镇',4,'',0,1,0,0),(21565,2552,'清河办事处',4,'',0,1,0,0),(21566,2552,'石村镇',4,'',0,1,0,0),(21567,2552,'稻庄镇',4,'',0,1,0,0),(21568,2552,'经济开发区办事处',4,'',0,1,0,0),(21569,2552,'花官乡',4,'',0,1,0,0),(21570,2552,'西刘桥乡',4,'',0,1,0,0),(21571,2552,'陈官乡',4,'',0,1,0,0),(21572,2553,'义和镇',4,'',0,1,0,0),(21573,2553,'仙河镇',4,'',0,1,0,0),(21574,2553,'六合乡',4,'',0,1,0,0),(21575,2553,'太平乡',4,'',0,1,0,0),(21576,2553,'孤岛镇',4,'',0,1,0,0),(21577,2553,'新户乡',4,'',0,1,0,0),(21578,2553,'河口街道',4,'',0,1,0,0),(21579,2554,'夏甸镇',4,'',0,1,0,0),(21580,2554,'大秦家镇',4,'',0,1,0,0),(21581,2554,'张星镇',4,'',0,1,0,0),(21582,2554,'梦芝街道',4,'',0,1,0,0),(21583,2554,'毕郭镇',4,'',0,1,0,0),(21584,2554,'泉山街道',4,'',0,1,0,0),(21585,2554,'玲珑镇',4,'',0,1,0,0),(21586,2554,'罗峰街道',4,'',0,1,0,0),(21587,2554,'蚕庄镇',4,'',0,1,0,0),(21588,2554,'辛庄镇',4,'',0,1,0,0),(21589,2554,'金岭镇',4,'',0,1,0,0),(21590,2554,'阜山镇',4,'',0,1,0,0),(21591,2554,'齐山镇',4,'',0,1,0,0),(21592,2555,'亭口镇',4,'',0,1,0,0),(21593,2555,'唐家泊镇',4,'',0,1,0,0),(21594,2555,'官道镇',4,'',0,1,0,0),(21595,2555,'寺口镇',4,'',0,1,0,0),(21596,2555,'庄园街道',4,'',0,1,0,0),(21597,2555,'庙后镇',4,'',0,1,0,0),(21598,2555,'杨础镇',4,'',0,1,0,0),(21599,2555,'松山镇',4,'',0,1,0,0),(21600,2555,'桃村镇',4,'',0,1,0,0),(21601,2555,'翠屏街道',4,'',0,1,0,0),(21602,2555,'臧家庄镇',4,'',0,1,0,0),(21603,2555,'苏家店镇',4,'',0,1,0,0),(21604,2555,'蛇窝泊镇',4,'',0,1,0,0),(21605,2555,'西城镇',4,'',0,1,0,0),(21606,2555,'观里镇',4,'',0,1,0,0),(21607,2556,'东村街道',4,'',0,1,0,0),(21608,2556,'二十里店镇',4,'',0,1,0,0),(21609,2556,'凤城街道',4,'',0,1,0,0),(21610,2556,'发城镇',4,'',0,1,0,0),(21611,2556,'大闫家镇',4,'',0,1,0,0),(21612,2556,'小纪镇',4,'',0,1,0,0),(21613,2556,'徐家店镇',4,'',0,1,0,0),(21614,2556,'方圆街道',4,'',0,1,0,0),(21615,2556,'朱吴镇',4,'',0,1,0,0),(21616,2556,'留格店镇',4,'',0,1,0,0),(21617,2556,'盘石店镇',4,'',0,1,0,0),(21618,2556,'行村镇',4,'',0,1,0,0),(21619,2556,'辛安镇',4,'',0,1,0,0),(21620,2556,'郭城镇',4,'',0,1,0,0),(21621,2557,'养马岛街道',4,'',0,1,0,0),(21622,2557,'大窑镇',4,'',0,1,0,0),(21623,2557,'姜格庄镇',4,'',0,1,0,0),(21624,2557,'宁海街道',4,'',0,1,0,0),(21625,2557,'开发区',4,'',0,1,0,0),(21626,2557,'文化街道',4,'',0,1,0,0),(21627,2557,'武宁镇',4,'',0,1,0,0),(21628,2557,'水道镇',4,'',0,1,0,0),(21629,2557,'玉林店镇',4,'',0,1,0,0),(21630,2557,'王格庄镇',4,'',0,1,0,0),(21631,2557,'莒格庄镇',4,'',0,1,0,0),(21632,2557,'观水镇',4,'',0,1,0,0),(21633,2557,'高陵镇',4,'',0,1,0,0),(21634,2557,'龙泉镇',4,'',0,1,0,0),(21635,2558,'古现街道',4,'',0,1,0,0),(21636,2558,'回里镇',4,'',0,1,0,0),(21637,2558,'大季家街道',4,'',0,1,0,0),(21638,2558,'张格庄镇',4,'',0,1,0,0),(21639,2558,'清洋街道',4,'',0,1,0,0),(21640,2558,'福新街道',4,'',0,1,0,0),(21641,2558,'门楼镇',4,'',0,1,0,0),(21642,2558,'高疃镇',4,'',0,1,0,0),(21643,2559,'世回尧街道',4,'',0,1,0,0),(21644,2559,'东山街道',4,'',0,1,0,0),(21645,2559,'凤凰台街道',4,'',0,1,0,0),(21646,2559,'只楚街道',4,'',0,1,0,0),(21647,2559,'向阳街道',4,'',0,1,0,0),(21648,2559,'奇山街道',4,'',0,1,0,0),(21649,2559,'幸福街道',4,'',0,1,0,0),(21650,2559,'毓璜顶街道',4,'',0,1,0,0),(21651,2559,'白石街道',4,'',0,1,0,0),(21652,2559,'芝罘岛街道',4,'',0,1,0,0),(21653,2559,'通伸街道',4,'',0,1,0,0),(21654,2559,'黄务街道',4,'',0,1,0,0),(21655,2560,'初家街道',4,'',0,1,0,0),(21656,2560,'滨海路街道',4,'',0,1,0,0),(21657,2560,'莱山镇',4,'',0,1,0,0),(21658,2560,'解甲庄镇',4,'',0,1,0,0),(21659,2560,'黄海路街道',4,'',0,1,0,0),(21660,2561,'三山岛街道',4,'',0,1,0,0),(21661,2561,'土山镇',4,'',0,1,0,0),(21662,2561,'城港路街道',4,'',0,1,0,0),(21663,2561,'夏邱镇',4,'',0,1,0,0),(21664,2561,'平里店镇',4,'',0,1,0,0),(21665,2561,'文峰路街道',4,'',0,1,0,0),(21666,2561,'文昌路街道',4,'',0,1,0,0),(21667,2561,'朱桥镇',4,'',0,1,0,0),(21668,2561,'柞村镇',4,'',0,1,0,0),(21669,2561,'永安路街道',4,'',0,1,0,0),(21670,2561,'沙河镇',4,'',0,1,0,0),(21671,2561,'程郭镇',4,'',0,1,0,0),(21672,2561,'虎头崖镇',4,'',0,1,0,0),(21673,2561,'郭家店镇',4,'',0,1,0,0),(21674,2561,'金城镇',4,'',0,1,0,0),(21675,2561,'驿道镇',4,'',0,1,0,0),(21676,2562,'万第镇',4,'',0,1,0,0),(21677,2562,'冯格庄街道',4,'',0,1,0,0),(21678,2562,'古柳街道',4,'',0,1,0,0),(21679,2562,'吕格庄镇',4,'',0,1,0,0),(21680,2562,'团旺镇',4,'',0,1,0,0),(21681,2562,'城厢街道',4,'',0,1,0,0),(21682,2562,'大夼镇',4,'',0,1,0,0),(21683,2562,'姜疃镇',4,'',0,1,0,0),(21684,2562,'山前店镇',4,'',0,1,0,0),(21685,2562,'柏林庄镇',4,'',0,1,0,0),(21686,2562,'沐浴店镇',4,'',0,1,0,0),(21687,2562,'河洛镇',4,'',0,1,0,0),(21688,2562,'照旺庄镇',4,'',0,1,0,0),(21689,2562,'穴坊镇',4,'',0,1,0,0),(21690,2562,'羊郡镇',4,'',0,1,0,0),(21691,2562,'谭格庄镇',4,'',0,1,0,0),(21692,2562,'高格庄镇',4,'',0,1,0,0),(21693,2562,'龙旺庄街道',4,'',0,1,0,0),(21694,2563,'刘家沟镇',4,'',0,1,0,0),(21695,2563,'北沟镇',4,'',0,1,0,0),(21696,2563,'南王街道',4,'',0,1,0,0),(21697,2563,'大柳行镇',4,'',0,1,0,0),(21698,2563,'大辛店镇',4,'',0,1,0,0),(21699,2563,'小门家镇',4,'',0,1,0,0),(21700,2563,'新港街道',4,'',0,1,0,0),(21701,2563,'村里集镇',4,'',0,1,0,0),(21702,2563,'潮水镇',4,'',0,1,0,0),(21703,2563,'登州街道',4,'',0,1,0,0),(21704,2563,'紫荆山街道',4,'',0,1,0,0),(21705,2563,'蓬莱阁街道',4,'',0,1,0,0),(21706,2564,'北长山乡',4,'',0,1,0,0),(21707,2564,'北隍城乡',4,'',0,1,0,0),(21708,2564,'南长山镇',4,'',0,1,0,0),(21709,2564,'南隍城乡',4,'',0,1,0,0),(21710,2564,'大钦岛乡',4,'',0,1,0,0),(21711,2564,'小钦岛乡',4,'',0,1,0,0),(21712,2564,'砣矶镇',4,'',0,1,0,0),(21713,2564,'黑山乡',4,'',0,1,0,0),(21714,2565,'七甲镇',4,'',0,1,0,0),(21715,2565,'下丁家镇',4,'',0,1,0,0),(21716,2565,'东江镇',4,'',0,1,0,0),(21717,2565,'东莱街道',4,'',0,1,0,0),(21718,2565,'兰高镇',4,'',0,1,0,0),(21719,2565,'北马镇',4,'',0,1,0,0),(21720,2565,'徐福镇',4,'',0,1,0,0),(21721,2565,'新嘉街道',4,'',0,1,0,0),(21722,2565,'石良镇',4,'',0,1,0,0),(21723,2565,'芦头镇',4,'',0,1,0,0),(21724,2565,'诸由观镇',4,'',0,1,0,0),(21725,2565,'黄山馆镇',4,'',0,1,0,0),(21726,2565,'龙港街道',4,'',0,1,0,0),(21727,2566,'七贤镇',4,'',0,1,0,0),(21728,2566,'上林镇',4,'',0,1,0,0),(21729,2566,'东城街办',4,'',0,1,0,0),(21730,2566,'九山镇',4,'',0,1,0,0),(21731,2566,'五井镇',4,'',0,1,0,0),(21732,2566,'冶源镇',4,'',0,1,0,0),(21733,2566,'卧龙镇',4,'',0,1,0,0),(21734,2566,'城关街办',4,'',0,1,0,0),(21735,2566,'大关镇',4,'',0,1,0,0),(21736,2566,'寺头镇',4,'',0,1,0,0),(21737,2566,'杨善镇',4,'',0,1,0,0),(21738,2566,'柳山镇',4,'',0,1,0,0),(21739,2566,'石家河乡',4,'',0,1,0,0),(21740,2566,'纸坊镇',4,'',0,1,0,0),(21741,2566,'营子镇',4,'',0,1,0,0),(21742,2566,'蒋峪镇',4,'',0,1,0,0),(21743,2566,'辛寨镇',4,'',0,1,0,0),(21744,2566,'龙岗镇',4,'',0,1,0,0),(21745,2567,'凤凰街办',4,'',0,1,0,0),(21746,2567,'南流镇',4,'',0,1,0,0),(21747,2567,'坊安街办',4,'',0,1,0,0),(21748,2567,'恒安街办',4,'',0,1,0,0),(21749,2567,'眉村镇',4,'',0,1,0,0),(21750,2567,'穆村镇',4,'',0,1,0,0),(21751,2567,'荆山洼镇',4,'',0,1,0,0),(21752,2567,'长宁街办',4,'',0,1,0,0),(21753,2568,'东关街道',4,'',0,1,0,0),(21754,2568,'二十里堡街道',4,'',0,1,0,0),(21755,2568,'北苑街道',4,'',0,1,0,0),(21756,2568,'南苑街道',4,'',0,1,0,0),(21757,2568,'大虞街道',4,'',0,1,0,0),(21758,2568,'广文街道',4,'',0,1,0,0),(21759,2568,'新城街道',4,'',0,1,0,0),(21760,2568,'樱桃园街道',4,'',0,1,0,0),(21761,2568,'院校街道',4,'',0,1,0,0),(21762,2569,'临浯镇',4,'',0,1,0,0),(21763,2569,'关王镇',4,'',0,1,0,0),(21764,2569,'凌河镇',4,'',0,1,0,0),(21765,2569,'刘家尧镇',4,'',0,1,0,0),(21766,2569,'吾山镇',4,'',0,1,0,0),(21767,2569,'大盛镇',4,'',0,1,0,0),(21768,2569,'安丘镇',4,'',0,1,0,0),(21769,2569,'官庄镇',4,'',0,1,0,0),(21770,2569,'庵上镇',4,'',0,1,0,0),(21771,2569,'景芝镇',4,'',0,1,0,0),(21772,2569,'柘山镇',4,'',0,1,0,0),(21773,2569,'王家庄镇',4,'',0,1,0,0),(21774,2569,'白芬子镇',4,'',0,1,0,0),(21775,2569,'石埠子镇',4,'',0,1,0,0),(21776,2569,'石堆镇',4,'',0,1,0,0),(21777,2569,'管公镇',4,'',0,1,0,0),(21778,2569,'红沙沟镇',4,'',0,1,0,0),(21779,2569,'贾戈镇',4,'',0,1,0,0),(21780,2569,'赵戈镇',4,'',0,1,0,0),(21781,2569,'辉渠镇',4,'',0,1,0,0),(21782,2569,'金冢子镇',4,'',0,1,0,0),(21783,2569,'雹泉镇',4,'',0,1,0,0),(21784,2569,'黄旗堡镇',4,'',0,1,0,0),(21785,2570,'南孙乡',4,'',0,1,0,0),(21786,2570,'双杨店镇',4,'',0,1,0,0),(21787,2570,'固堤镇',4,'',0,1,0,0),(21788,2570,'央子镇',4,'',0,1,0,0),(21789,2570,'寒亭街道',4,'',0,1,0,0),(21790,2570,'开元街道',4,'',0,1,0,0),(21791,2570,'朱里镇',4,'',0,1,0,0),(21792,2570,'河滩镇',4,'',0,1,0,0),(21793,2570,'泊子乡',4,'',0,1,0,0),(21794,2570,'高里镇',4,'',0,1,0,0),(21795,2571,'上口镇',4,'',0,1,0,0),(21796,2571,'侯镇',4,'',0,1,0,0),(21797,2571,'化龙镇',4,'',0,1,0,0),(21798,2571,'卧铺乡',4,'',0,1,0,0),(21799,2571,'台头镇',4,'',0,1,0,0),(21800,2571,'圣城街道',4,'',0,1,0,0),(21801,2571,'孙家集街道',4,'',0,1,0,0),(21802,2571,'文家街道',4,'',0,1,0,0),(21803,2571,'洛城街道',4,'',0,1,0,0),(21804,2571,'王高镇',4,'',0,1,0,0),(21805,2571,'田柳镇',4,'',0,1,0,0),(21806,2571,'田马镇',4,'',0,1,0,0),(21807,2571,'留吕镇',4,'',0,1,0,0),(21808,2571,'稻田镇',4,'',0,1,0,0),(21809,2571,'纪台镇',4,'',0,1,0,0),(21810,2571,'经济开发区',4,'',0,1,0,0),(21811,2571,'羊口镇',4,'',0,1,0,0),(21812,2571,'营里镇',4,'',0,1,0,0),(21813,2571,'道口镇',4,'',0,1,0,0),(21814,2572,'乔官镇',4,'',0,1,0,0),(21815,2572,'五图镇',4,'',0,1,0,0),(21816,2572,'北岩镇',4,'',0,1,0,0),(21817,2572,'南郝镇',4,'',0,1,0,0),(21818,2572,'唐吾镇',4,'',0,1,0,0),(21819,2572,'尧沟镇',4,'',0,1,0,0),(21820,2572,'崔家庄镇',4,'',0,1,0,0),(21821,2572,'昌乐镇',4,'',0,1,0,0),(21822,2572,'朱刘镇',4,'',0,1,0,0),(21823,2572,'朱汉镇',4,'',0,1,0,0),(21824,2572,'白塔镇',4,'',0,1,0,0),(21825,2572,'红河镇',4,'',0,1,0,0),(21826,2572,'阿陀镇',4,'',0,1,0,0),(21827,2572,'马宋镇',4,'',0,1,0,0),(21828,2572,'高崖镇',4,'',0,1,0,0),(21829,2573,'丈岭镇',4,'',0,1,0,0),(21830,2573,'北孟镇',4,'',0,1,0,0),(21831,2573,'卜庄镇',4,'',0,1,0,0),(21832,2573,'双台乡',4,'',0,1,0,0),(21833,2573,'围子镇',4,'',0,1,0,0),(21834,2573,'夏店镇',4,'',0,1,0,0),(21835,2573,'太保庄乡',4,'',0,1,0,0),(21836,2573,'奎聚街道办事处',4,'',0,1,0,0),(21837,2573,'宋庄镇',4,'',0,1,0,0),(21838,2573,'岞山镇',4,'',0,1,0,0),(21839,2573,'柳疃镇',4,'',0,1,0,0),(21840,2573,'石埠镇',4,'',0,1,0,0),(21841,2573,'都昌街道办事处',4,'',0,1,0,0),(21842,2573,'饮马镇',4,'',0,1,0,0),(21843,2573,'龙池镇',4,'',0,1,0,0),(21844,2574,'于河镇',4,'',0,1,0,0),(21845,2574,'军埠口镇',4,'',0,1,0,0),(21846,2574,'北关街道',4,'',0,1,0,0),(21847,2574,'南关街道',4,'',0,1,0,0),(21848,2574,'城关街道',4,'',0,1,0,0),(21849,2574,'望留镇',4,'',0,1,0,0),(21850,2574,'符山镇',4,'',0,1,0,0),(21851,2574,'西关街道',4,'',0,1,0,0),(21852,2575,'九台镇',4,'',0,1,0,0),(21853,2575,'吕标镇',4,'',0,1,0,0),(21854,2575,'孟疃镇',4,'',0,1,0,0),(21855,2575,'密州街道',4,'',0,1,0,0),(21856,2575,'昌城镇',4,'',0,1,0,0),(21857,2575,'朱解镇',4,'',0,1,0,0),(21858,2575,'枳沟镇',4,'',0,1,0,0),(21859,2575,'桃园乡',4,'',0,1,0,0),(21860,2575,'桃林乡',4,'',0,1,0,0),(21861,2575,'瓦店镇',4,'',0,1,0,0),(21862,2575,'百尺河镇',4,'',0,1,0,0),(21863,2575,'皇华镇',4,'',0,1,0,0),(21864,2575,'相州镇',4,'',0,1,0,0),(21865,2575,'石桥子镇',4,'',0,1,0,0),(21866,2575,'程戈庄镇',4,'',0,1,0,0),(21867,2575,'舜王街道',4,'',0,1,0,0),(21868,2575,'贾悦镇',4,'',0,1,0,0),(21869,2575,'辛兴镇',4,'',0,1,0,0),(21870,2575,'郝戈庄镇',4,'',0,1,0,0),(21871,2575,'郭家屯镇',4,'',0,1,0,0),(21872,2575,'马庄镇',4,'',0,1,0,0),(21873,2575,'龙都街道',4,'',0,1,0,0),(21874,2576,'东坝街道',4,'',0,1,0,0),(21875,2576,'东夏镇',4,'',0,1,0,0),(21876,2576,'东高镇',4,'',0,1,0,0),(21877,2576,'云门山街道',4,'',0,1,0,0),(21878,2576,'五里镇',4,'',0,1,0,0),(21879,2576,'何官镇',4,'',0,1,0,0),(21880,2576,'口埠镇',4,'',0,1,0,0),(21881,2576,'庙子镇',4,'',0,1,0,0),(21882,2576,'弥河镇',4,'',0,1,0,0),(21883,2576,'昭德街道',4,'',0,1,0,0),(21884,2576,'普通镇',4,'',0,1,0,0),(21885,2576,'朱良镇',4,'',0,1,0,0),(21886,2576,'王坟镇',4,'',0,1,0,0),(21887,2576,'王府街道',4,'',0,1,0,0),(21888,2576,'王母宫街道',4,'',0,1,0,0),(21889,2576,'益都街道',4,'',0,1,0,0),(21890,2576,'谭坊镇',4,'',0,1,0,0),(21891,2576,'邵庄镇',4,'',0,1,0,0),(21892,2576,'郑母镇',4,'',0,1,0,0),(21893,2576,'高柳镇',4,'',0,1,0,0),(21894,2576,'黄楼镇',4,'',0,1,0,0),(21895,2577,'井沟镇',4,'',0,1,0,0),(21896,2577,'仁和镇',4,'',0,1,0,0),(21897,2577,'双羊镇',4,'',0,1,0,0),(21898,2577,'周戈庄镇',4,'',0,1,0,0),(21899,2577,'呼家庄镇',4,'',0,1,0,0),(21900,2577,'夏庄镇',4,'',0,1,0,0),(21901,2577,'大牟家镇',4,'',0,1,0,0),(21902,2577,'姚哥庄镇',4,'',0,1,0,0),(21903,2577,'姜庄镇',4,'',0,1,0,0),(21904,2577,'密水街办',4,'',0,1,0,0),(21905,2577,'康庄镇',4,'',0,1,0,0),(21906,2577,'拒城河镇',4,'',0,1,0,0),(21907,2577,'朝阳街办',4,'',0,1,0,0),(21908,2577,'李家营镇',4,'',0,1,0,0),(21909,2577,'柏城镇',4,'',0,1,0,0),(21910,2577,'柴沟镇',4,'',0,1,0,0),(21911,2577,'河崖镇',4,'',0,1,0,0),(21912,2577,'注沟镇',4,'',0,1,0,0),(21913,2577,'醴泉街办',4,'',0,1,0,0),(21914,2577,'阚家镇',4,'',0,1,0,0),(21915,2578,'三贾街道',4,'',0,1,0,0),(21916,2578,'二十里铺镇',4,'',0,1,0,0),(21917,2578,'南张镇',4,'',0,1,0,0),(21918,2578,'唐口镇',4,'',0,1,0,0),(21919,2578,'喻屯镇',4,'',0,1,0,0),(21920,2578,'安居镇',4,'',0,1,0,0),(21921,2578,'接庄镇',4,'',0,1,0,0),(21922,2578,'李营镇',4,'',0,1,0,0),(21923,2578,'柳行街道',4,'',0,1,0,0),(21924,2578,'石桥镇',4,'',0,1,0,0),(21925,2578,'许庄街道',4,'',0,1,0,0),(21926,2578,'长沟镇',4,'',0,1,0,0),(21927,2579,'兴隆庄镇',4,'',0,1,0,0),(21928,2579,'大安镇',4,'',0,1,0,0),(21929,2579,'小孟镇',4,'',0,1,0,0),(21930,2579,'新兖镇',4,'',0,1,0,0),(21931,2579,'新驿镇',4,'',0,1,0,0),(21932,2579,'永安街道',4,'',0,1,0,0),(21933,2579,'漕河镇',4,'',0,1,0,0),(21934,2579,'王因镇',4,'',0,1,0,0),(21935,2579,'谷村镇',4,'',0,1,0,0),(21936,2579,'颜店镇',4,'',0,1,0,0),(21937,2579,'黄屯镇',4,'',0,1,0,0),(21938,2579,'鼓楼街道',4,'',0,1,0,0),(21939,2580,'万张乡',4,'',0,1,0,0),(21940,2580,'仲山乡',4,'',0,1,0,0),(21941,2580,'卧龙山镇',4,'',0,1,0,0),(21942,2580,'嘉祥镇',4,'',0,1,0,0),(21943,2580,'大张楼镇',4,'',0,1,0,0),(21944,2580,'梁宝寺镇',4,'',0,1,0,0),(21945,2580,'满硐乡',4,'',0,1,0,0),(21946,2580,'疃里镇',4,'',0,1,0,0),(21947,2580,'盂姑集乡',4,'',0,1,0,0),(21948,2580,'纸坊镇',4,'',0,1,0,0),(21949,2580,'老僧堂乡',4,'',0,1,0,0),(21950,2580,'金屯镇',4,'',0,1,0,0),(21951,2580,'马村镇',4,'',0,1,0,0),(21952,2580,'马集乡',4,'',0,1,0,0),(21953,2580,'黄垓乡',4,'',0,1,0,0),(21954,2581,'仙营街道',4,'',0,1,0,0),(21955,2581,'南苑街道',4,'',0,1,0,0),(21956,2581,'槐街道',4,'',0,1,0,0),(21957,2581,'济阳街道',4,'',0,1,0,0),(21958,2581,'观音阁街道',4,'',0,1,0,0),(21959,2581,'越河街道',4,'',0,1,0,0),(21960,2581,'金城街道',4,'',0,1,0,0),(21961,2581,'阜桥街道',4,'',0,1,0,0),(21962,2582,'两城乡',4,'',0,1,0,0),(21963,2582,'傅村镇',4,'',0,1,0,0),(21964,2582,'南阳镇',4,'',0,1,0,0),(21965,2582,'夏镇街道',4,'',0,1,0,0),(21966,2582,'张楼乡',4,'',0,1,0,0),(21967,2582,'微山岛乡',4,'',0,1,0,0),(21968,2582,'昭阳街道',4,'',0,1,0,0),(21969,2582,'欢城镇',4,'',0,1,0,0),(21970,2582,'留庄镇',4,'',0,1,0,0),(21971,2582,'西平乡',4,'',0,1,0,0),(21972,2582,'赵庙乡',4,'',0,1,0,0),(21973,2582,'韩庄镇',4,'',0,1,0,0),(21974,2582,'马坡乡',4,'',0,1,0,0),(21975,2582,'高楼乡',4,'',0,1,0,0),(21976,2582,'鲁桥镇',4,'',0,1,0,0),(21977,2583,'书院街道',4,'',0,1,0,0),(21978,2583,'南辛镇',4,'',0,1,0,0),(21979,2583,'吴村镇',4,'',0,1,0,0),(21980,2583,'姚村镇',4,'',0,1,0,0),(21981,2583,'小雪镇',4,'',0,1,0,0),(21982,2583,'息陬乡',4,'',0,1,0,0),(21983,2583,'时庄镇',4,'',0,1,0,0),(21984,2583,'王庄乡',4,'',0,1,0,0),(21985,2583,'董庄乡',4,'',0,1,0,0),(21986,2583,'防山乡',4,'',0,1,0,0),(21987,2583,'陵城镇',4,'',0,1,0,0),(21988,2583,'鲁城街道',4,'',0,1,0,0),(21989,2584,'大路口乡',4,'',0,1,0,0),(21990,2584,'寿张集乡',4,'',0,1,0,0),(21991,2584,'小安山镇',4,'',0,1,0,0),(21992,2584,'小路口镇',4,'',0,1,0,0),(21993,2584,'徐集镇',4,'',0,1,0,0),(21994,2584,'拳铺镇',4,'',0,1,0,0),(21995,2584,'杨营镇',4,'',0,1,0,0),(21996,2584,'梁山镇',4,'',0,1,0,0),(21997,2584,'赵固堆乡',4,'',0,1,0,0),(21998,2584,'韩垓镇',4,'',0,1,0,0),(21999,2584,'韩岗镇',4,'',0,1,0,0),(22000,2584,'馆驿镇',4,'',0,1,0,0),(22001,2584,'马营乡',4,'',0,1,0,0),(22002,2584,'黑虎庙乡',4,'',0,1,0,0),(22003,2585,'义桥乡',4,'',0,1,0,0),(22004,2585,'军屯乡',4,'',0,1,0,0),(22005,2585,'刘楼乡',4,'',0,1,0,0),(22006,2585,'南旺镇',4,'',0,1,0,0),(22007,2585,'南站镇',4,'',0,1,0,0),(22008,2585,'寅寺镇',4,'',0,1,0,0),(22009,2585,'康驿镇',4,'',0,1,0,0),(22010,2585,'杨店乡',4,'',0,1,0,0),(22011,2585,'次邱镇',4,'',0,1,0,0),(22012,2585,'汶上镇',4,'',0,1,0,0),(22013,2585,'白石乡',4,'',0,1,0,0),(22014,2585,'苑庄镇',4,'',0,1,0,0),(22015,2585,'郭仓乡',4,'',0,1,0,0),(22016,2585,'郭楼镇',4,'',0,1,0,0),(22017,2586,'中册镇',4,'',0,1,0,0),(22018,2586,'圣水峪乡',4,'',0,1,0,0),(22019,2586,'大黄沟乡',4,'',0,1,0,0),(22020,2586,'星村镇',4,'',0,1,0,0),(22021,2586,'杨柳镇',4,'',0,1,0,0),(22022,2586,'柘沟镇',4,'',0,1,0,0),(22023,2586,'泉林镇',4,'',0,1,0,0),(22024,2586,'泗张镇',4,'',0,1,0,0),(22025,2586,'泗河街道',4,'',0,1,0,0),(22026,2586,'济河街道',4,'',0,1,0,0),(22027,2586,'苗馆镇',4,'',0,1,0,0),(22028,2586,'金庄镇',4,'',0,1,0,0),(22029,2586,'高峪乡',4,'',0,1,0,0),(22030,2587,'中心店镇',4,'',0,1,0,0),(22031,2587,'凫山街道',4,'',0,1,0,0),(22032,2587,'北宿镇',4,'',0,1,0,0),(22033,2587,'千泉街道',4,'',0,1,0,0),(22034,2587,'唐村镇',4,'',0,1,0,0),(22035,2587,'城前镇',4,'',0,1,0,0),(22036,2587,'大束镇',4,'',0,1,0,0),(22037,2587,'太平镇',4,'',0,1,0,0),(22038,2587,'峄山镇',4,'',0,1,0,0),(22039,2587,'平阳寺镇',4,'',0,1,0,0),(22040,2587,'张庄镇',4,'',0,1,0,0),(22041,2587,'田黄镇',4,'',0,1,0,0),(22042,2587,'看庄镇',4,'',0,1,0,0),(22043,2587,'石墙镇',4,'',0,1,0,0),(22044,2587,'郭里镇',4,'',0,1,0,0),(22045,2587,'钢山街道',4,'',0,1,0,0),(22046,2587,'香城镇',4,'',0,1,0,0),(22047,2588,'兴隆乡',4,'',0,1,0,0),(22048,2588,'化雨乡',4,'',0,1,0,0),(22049,2588,'卜集乡',4,'',0,1,0,0),(22050,2588,'司马镇',4,'',0,1,0,0),(22051,2588,'王丕镇',4,'',0,1,0,0),(22052,2588,'羊山镇',4,'',0,1,0,0),(22053,2588,'胡集镇',4,'',0,1,0,0),(22054,2588,'金乡镇',4,'',0,1,0,0),(22055,2588,'霄云镇',4,'',0,1,0,0),(22056,2588,'马庙镇',4,'',0,1,0,0),(22057,2588,'高河乡',4,'',0,1,0,0),(22058,2588,'鱼山镇',4,'',0,1,0,0),(22059,2588,'鸡黍镇',4,'',0,1,0,0),(22060,2589,'唐马乡',4,'',0,1,0,0),(22061,2589,'张黄镇',4,'',0,1,0,0),(22062,2589,'李阁镇',4,'',0,1,0,0),(22063,2589,'清河镇',4,'',0,1,0,0),(22064,2589,'王庙镇',4,'',0,1,0,0),(22065,2589,'王鲁镇',4,'',0,1,0,0),(22066,2589,'罗屯乡',4,'',0,1,0,0),(22067,2589,'老砦乡',4,'',0,1,0,0),(22068,2589,'谷亭镇',4,'',0,1,0,0),(22069,2589,'鱼城镇',4,'',0,1,0,0),(22070,2590,'东平镇',4,'',0,1,0,0),(22071,2590,'商老庄乡',4,'',0,1,0,0),(22072,2590,'大羊乡',4,'',0,1,0,0),(22073,2590,'州城镇',4,'',0,1,0,0),(22074,2590,'彭集镇',4,'',0,1,0,0),(22075,2590,'戴庙乡',4,'',0,1,0,0),(22076,2590,'接山乡',4,'',0,1,0,0),(22077,2590,'斑鸠店镇',4,'',0,1,0,0),(22078,2590,'新湖乡',4,'',0,1,0,0),(22079,2590,'旧县乡',4,'',0,1,0,0),(22080,2590,'梯门乡',4,'',0,1,0,0),(22081,2590,'沙河站镇',4,'',0,1,0,0),(22082,2590,'老湖镇',4,'',0,1,0,0),(22083,2590,'银山镇',4,'',0,1,0,0),(22084,2591,'东庄乡',4,'',0,1,0,0),(22085,2591,'东疏镇',4,'',0,1,0,0),(22086,2591,'乡饮乡',4,'',0,1,0,0),(22087,2591,'伏山镇',4,'',0,1,0,0),(22088,2591,'华丰镇',4,'',0,1,0,0),(22089,2591,'堽城镇',4,'',0,1,0,0),(22090,2591,'宁阳镇',4,'',0,1,0,0),(22091,2591,'泗店镇',4,'',0,1,0,0),(22092,2591,'磁窑镇',4,'',0,1,0,0),(22093,2591,'葛石镇',4,'',0,1,0,0),(22094,2591,'蒋集镇',4,'',0,1,0,0),(22095,2591,'鹤山乡',4,'',0,1,0,0),(22096,2592,'下港乡',4,'',0,1,0,0),(22097,2592,'化马湾乡',4,'',0,1,0,0),(22098,2592,'北集坡镇',4,'',0,1,0,0),(22099,2592,'夏张镇',4,'',0,1,0,0),(22100,2592,'大汶口镇',4,'',0,1,0,0),(22101,2592,'太平街道',4,'',0,1,0,0),(22102,2592,'山口镇',4,'',0,1,0,0),(22103,2592,'徂徕镇',4,'',0,1,0,0),(22104,2592,'房村镇',4,'',0,1,0,0),(22105,2592,'满庄镇',4,'',0,1,0,0),(22106,2592,'祝阳镇',4,'',0,1,0,0),(22107,2592,'粥店街道',4,'',0,1,0,0),(22108,2592,'良庄镇',4,'',0,1,0,0),(22109,2592,'范镇',4,'',0,1,0,0),(22110,2592,'角峪镇',4,'',0,1,0,0),(22111,2592,'道朗镇',4,'',0,1,0,0),(22112,2592,'马庄镇',4,'',0,1,0,0),(22113,2592,'黄前镇',4,'',0,1,0,0),(22114,2593,'东都镇',4,'',0,1,0,0),(22115,2593,'刘杜镇',4,'',0,1,0,0),(22116,2593,'天宝镇',4,'',0,1,0,0),(22117,2593,'宫里镇',4,'',0,1,0,0),(22118,2593,'小协镇',4,'',0,1,0,0),(22119,2593,'岳家庄乡',4,'',0,1,0,0),(22120,2593,'放城镇',4,'',0,1,0,0),(22121,2593,'新汶街道',4,'',0,1,0,0),(22122,2593,'果都镇',4,'',0,1,0,0),(22123,2593,'楼德镇',4,'',0,1,0,0),(22124,2593,'汶南镇',4,'',0,1,0,0),(22125,2593,'泉沟镇',4,'',0,1,0,0),(22126,2593,'石莱镇',4,'',0,1,0,0),(22127,2593,'禹村镇',4,'',0,1,0,0),(22128,2593,'羊流镇',4,'',0,1,0,0),(22129,2593,'翟镇',4,'',0,1,0,0),(22130,2593,'西张庄镇',4,'',0,1,0,0),(22131,2593,'谷里镇',4,'',0,1,0,0),(22132,2593,'青云街道',4,'',0,1,0,0),(22133,2593,'龙延镇',4,'',0,1,0,0),(22134,2594,'上高街道',4,'',0,1,0,0),(22135,2594,'大津口乡',4,'',0,1,0,0),(22136,2594,'岱庙街道',4,'',0,1,0,0),(22137,2594,'徐家楼街道',4,'',0,1,0,0),(22138,2594,'泰前街道',4,'',0,1,0,0),(22139,2594,'省庄镇',4,'',0,1,0,0),(22140,2594,'财源街道',4,'',0,1,0,0),(22141,2594,'邱家店镇',4,'',0,1,0,0),(22142,2595,'仪阳乡',4,'',0,1,0,0),(22143,2595,'孙伯镇',4,'',0,1,0,0),(22144,2595,'安临站镇',4,'',0,1,0,0),(22145,2595,'安驾庄镇',4,'',0,1,0,0),(22146,2595,'新城街道',4,'',0,1,0,0),(22147,2595,'桃园镇',4,'',0,1,0,0),(22148,2595,'汶阳镇',4,'',0,1,0,0),(22149,2595,'湖屯镇',4,'',0,1,0,0),(22150,2595,'潮泉镇',4,'',0,1,0,0),(22151,2595,'王庄镇',4,'',0,1,0,0),(22152,2595,'王瓜店镇',4,'',0,1,0,0),(22153,2595,'石横镇',4,'',0,1,0,0),(22154,2595,'老城镇',4,'',0,1,0,0),(22155,2595,'边院镇',4,'',0,1,0,0),(22156,2596,'下初镇',4,'',0,1,0,0),(22157,2596,'乳山口镇',4,'',0,1,0,0),(22158,2596,'乳山寨镇',4,'',0,1,0,0),(22159,2596,'冯家镇',4,'',0,1,0,0),(22160,2596,'午极镇',4,'',0,1,0,0),(22161,2596,'南黄镇',4,'',0,1,0,0),(22162,2596,'城区街道办事处',4,'',0,1,0,0),(22163,2596,'夏村镇',4,'',0,1,0,0),(22164,2596,'大孤山镇',4,'',0,1,0,0),(22165,2596,'崖子镇',4,'',0,1,0,0),(22166,2596,'徐家镇',4,'',0,1,0,0),(22167,2596,'海阳所镇',4,'',0,1,0,0),(22168,2596,'白沙滩镇',4,'',0,1,0,0),(22169,2596,'育黎镇',4,'',0,1,0,0),(22170,2596,'诸往镇',4,'',0,1,0,0),(22171,2597,'侯家镇',4,'',0,1,0,0),(22172,2597,'大水泊镇',4,'',0,1,0,0),(22173,2597,'天福路街道办事处',4,'',0,1,0,0),(22174,2597,'宋村镇',4,'',0,1,0,0),(22175,2597,'小观镇',4,'',0,1,0,0),(22176,2597,'张家产镇',4,'',0,1,0,0),(22177,2597,'文登营镇',4,'',0,1,0,0),(22178,2597,'汪疃镇',4,'',0,1,0,0),(22179,2597,'泽头镇',4,'',0,1,0,0),(22180,2597,'泽库镇',4,'',0,1,0,0),(22181,2597,'环山路街道办事处',4,'',0,1,0,0),(22182,2597,'界石镇',4,'',0,1,0,0),(22183,2597,'米山镇',4,'',0,1,0,0),(22184,2597,'苘山镇',4,'',0,1,0,0),(22185,2597,'葛家镇',4,'',0,1,0,0),(22186,2597,'高村镇',4,'',0,1,0,0),(22187,2597,'龙山路街道办事处',4,'',0,1,0,0),(22188,2598,'万欣街道',4,'',0,1,0,0),(22189,2598,'凤林街道',4,'',0,1,0,0),(22190,2598,'初村镇',4,'',0,1,0,0),(22191,2598,'卧龙街道',4,'',0,1,0,0),(22192,2598,'孙家疃镇',4,'',0,1,0,0),(22193,2598,'崮山镇',4,'',0,1,0,0),(22194,2598,'张村镇',4,'',0,1,0,0),(22195,2598,'怡园街道',4,'',0,1,0,0),(22196,2598,'桥头镇',4,'',0,1,0,0),(22197,2598,'泊于镇',4,'',0,1,0,0),(22198,2598,'温泉镇',4,'',0,1,0,0),(22199,2598,'环翠楼街道',4,'',0,1,0,0),(22200,2598,'田和街道',4,'',0,1,0,0),(22201,2598,'皇冠街道',4,'',0,1,0,0),(22202,2598,'竹岛街道',4,'',0,1,0,0),(22203,2598,'羊亭镇',4,'',0,1,0,0),(22204,2598,'草庙子镇',4,'',0,1,0,0),(22205,2598,'西苑街道',4,'',0,1,0,0),(22206,2598,'鲸园街道',4,'',0,1,0,0),(22207,2599,'上庄镇',4,'',0,1,0,0),(22208,2599,'东山街道',4,'',0,1,0,0),(22209,2599,'人和镇',4,'',0,1,0,0),(22210,2599,'俚岛镇',4,'',0,1,0,0),(22211,2599,'埠柳镇',4,'',0,1,0,0),(22212,2599,'夏庄镇',4,'',0,1,0,0),(22213,2599,'大疃镇',4,'',0,1,0,0),(22214,2599,'宁津街道',4,'',0,1,0,0),(22215,2599,'崖头镇',4,'',0,1,0,0),(22216,2599,'崖西镇',4,'',0,1,0,0),(22217,2599,'成山镇',4,'',0,1,0,0),(22218,2599,'斥山街道',4,'',0,1,0,0),(22219,2599,'桃园街道',4,'',0,1,0,0),(22220,2599,'港湾街道',4,'',0,1,0,0),(22221,2599,'港西镇',4,'',0,1,0,0),(22222,2599,'滕家镇',4,'',0,1,0,0),(22223,2599,'王连街道',4,'',0,1,0,0),(22224,2599,'石岛管理区',4,'',0,1,0,0),(22225,2599,'荫子镇',4,'',0,1,0,0),(22226,2599,'虎山镇',4,'',0,1,0,0),(22227,2600,'三庄镇',4,'',0,1,0,0),(22228,2600,'两城镇',4,'',0,1,0,0),(22229,2600,'前三岛乡',4,'',0,1,0,0),(22230,2600,'南湖镇',4,'',0,1,0,0),(22231,2600,'奎山街道',4,'',0,1,0,0),(22232,2600,'日照开发区虚拟街道',4,'',0,1,0,0),(22233,2600,'日照街道',4,'',0,1,0,0),(22234,2600,'河山镇',4,'',0,1,0,0),(22235,2600,'涛雒镇',4,'',0,1,0,0),(22236,2600,'石臼街道',4,'',0,1,0,0),(22237,2600,'秦楼街道',4,'',0,1,0,0),(22238,2600,'西湖镇',4,'',0,1,0,0),(22239,2600,'陈疃镇',4,'',0,1,0,0),(22240,2601,'中至镇',4,'',0,1,0,0),(22241,2601,'于里镇',4,'',0,1,0,0),(22242,2601,'叩官镇',4,'',0,1,0,0),(22243,2601,'户部乡',4,'',0,1,0,0),(22244,2601,'松柏乡',4,'',0,1,0,0),(22245,2601,'汪湖镇',4,'',0,1,0,0),(22246,2601,'洪凝镇',4,'',0,1,0,0),(22247,2601,'潮河镇',4,'',0,1,0,0),(22248,2601,'石场乡',4,'',0,1,0,0),(22249,2601,'街头镇',4,'',0,1,0,0),(22250,2601,'许孟镇',4,'',0,1,0,0),(22251,2601,'高泽镇',4,'',0,1,0,0),(22252,2602,'后村镇',4,'',0,1,0,0),(22253,2602,'安东卫街道',4,'',0,1,0,0),(22254,2602,'岚山头街道',4,'',0,1,0,0),(22255,2602,'巨峰镇',4,'',0,1,0,0),(22256,2602,'碑廓镇',4,'',0,1,0,0),(22257,2602,'虎山镇',4,'',0,1,0,0),(22258,2602,'高兴镇',4,'',0,1,0,0),(22259,2602,'黄墩镇',4,'',0,1,0,0),(22260,2603,'东莞镇',4,'',0,1,0,0),(22261,2603,'中楼镇',4,'',0,1,0,0),(22262,2603,'刘家官庄镇',4,'',0,1,0,0),(22263,2603,'城阳镇',4,'',0,1,0,0),(22264,2603,'夏庄镇',4,'',0,1,0,0),(22265,2603,'安庄镇',4,'',0,1,0,0),(22266,2603,'寨里河乡',4,'',0,1,0,0),(22267,2603,'小店镇',4,'',0,1,0,0),(22268,2603,'峤山镇',4,'',0,1,0,0),(22269,2603,'库山乡',4,'',0,1,0,0),(22270,2603,'店子集镇',4,'',0,1,0,0),(22271,2603,'招贤镇',4,'',0,1,0,0),(22272,2603,'果庄乡',4,'',0,1,0,0),(22273,2603,'桑园乡',4,'',0,1,0,0),(22274,2603,'洛河镇',4,'',0,1,0,0),(22275,2603,'浮来山镇',4,'',0,1,0,0),(22276,2603,'碁山镇',4,'',0,1,0,0),(22277,2603,'长岭镇',4,'',0,1,0,0),(22278,2603,'阎庄镇',4,'',0,1,0,0),(22279,2603,'陵阳镇',4,'',0,1,0,0),(22280,2603,'龙山镇',4,'',0,1,0,0),(22281,2604,'口镇',4,'',0,1,0,0),(22282,2604,'和庄',4,'',0,1,0,0),(22283,2604,'大王庄镇',4,'',0,1,0,0),(22284,2604,'寨里镇',4,'',0,1,0,0),(22285,2604,'张家洼街道',4,'',0,1,0,0),(22286,2604,'方下镇',4,'',0,1,0,0),(22287,2604,'杨庄镇',4,'',0,1,0,0),(22288,2604,'牛泉镇',4,'',0,1,0,0),(22289,2604,'羊里镇',4,'',0,1,0,0),(22290,2604,'苗山镇',4,'',0,1,0,0),(22291,2604,'茶叶口镇',4,'',0,1,0,0),(22292,2604,'莱芜市',4,'',0,1,0,0),(22293,2604,'辛庄镇',4,'',0,1,0,0),(22294,2604,'雪野镇',4,'',0,1,0,0),(22295,2604,'高庄街道',4,'',0,1,0,0),(22296,2605,'艾山街道',4,'',0,1,0,0),(22297,2605,'里辛镇',4,'',0,1,0,0),(22298,2605,'颜庄镇',4,'',0,1,0,0),(22299,2605,'黄庄镇',4,'',0,1,0,0),(22300,2606,'临沭镇',4,'',0,1,0,0),(22301,2606,'南古镇',4,'',0,1,0,0),(22302,2606,'大兴镇',4,'',0,1,0,0),(22303,2606,'店头镇',4,'',0,1,0,0),(22304,2606,'曹庄镇',4,'',0,1,0,0),(22305,2606,'朱仓乡',4,'',0,1,0,0),(22306,2606,'玉山镇',4,'',0,1,0,0),(22307,2606,'白旄镇',4,'',0,1,0,0),(22308,2606,'石门镇',4,'',0,1,0,0),(22309,2606,'蛟龙镇',4,'',0,1,0,0),(22310,2606,'郑山镇',4,'',0,1,0,0),(22311,2606,'青云镇',4,'',0,1,0,0),(22312,2607,'义堂镇',4,'',0,1,0,0),(22313,2607,'兰山街道',4,'',0,1,0,0),(22314,2607,'半程镇',4,'',0,1,0,0),(22315,2607,'南坊街道',4,'',0,1,0,0),(22316,2607,'朱保镇',4,'',0,1,0,0),(22317,2607,'李官镇',4,'',0,1,0,0),(22318,2607,'枣沟头镇',4,'',0,1,0,0),(22319,2607,'白沙埠镇',4,'',0,1,0,0),(22320,2607,'金雀山街道',4,'',0,1,0,0),(22321,2607,'银雀山街道',4,'',0,1,0,0),(22322,2607,'马厂湖镇',4,'',0,1,0,0),(22323,2608,'丰阳镇',4,'',0,1,0,0),(22324,2608,'临涧镇',4,'',0,1,0,0),(22325,2608,'仲村镇',4,'',0,1,0,0),(22326,2608,'保太镇',4,'',0,1,0,0),(22327,2608,'卞桥镇',4,'',0,1,0,0),(22328,2608,'地方镇',4,'',0,1,0,0),(22329,2608,'平邑镇',4,'',0,1,0,0),(22330,2608,'柏林镇',4,'',0,1,0,0),(22331,2608,'武台镇',4,'',0,1,0,0),(22332,2608,'流峪镇',4,'',0,1,0,0),(22333,2608,'温水镇',4,'',0,1,0,0),(22334,2608,'白彦镇',4,'',0,1,0,0),(22335,2608,'资邱乡',4,'',0,1,0,0),(22336,2608,'郑城镇',4,'',0,1,0,0),(22337,2608,'铜石镇',4,'',0,1,0,0),(22338,2608,'魏庄乡',4,'',0,1,0,0),(22339,2609,'依汶镇',4,'',0,1,0,0),(22340,2609,'双堠镇',4,'',0,1,0,0),(22341,2609,'大庄镇',4,'',0,1,0,0),(22342,2609,'孙祖镇',4,'',0,1,0,0),(22343,2609,'岸堤镇',4,'',0,1,0,0),(22344,2609,'张庄镇',4,'',0,1,0,0),(22345,2609,'杨家坡镇',4,'',0,1,0,0),(22346,2609,'湖头镇',4,'',0,1,0,0),(22347,2609,'界湖镇',4,'',0,1,0,0),(22348,2609,'砖埠镇',4,'',0,1,0,0),(22349,2609,'苏村镇',4,'',0,1,0,0),(22350,2609,'葛沟镇',4,'',0,1,0,0),(22351,2609,'蒲汪镇',4,'',0,1,0,0),(22352,2609,'辛集镇',4,'',0,1,0,0),(22353,2609,'铜井镇',4,'',0,1,0,0),(22354,2609,'青驼镇',4,'',0,1,0,0),(22355,2609,'马牧池乡',4,'',0,1,0,0),(22356,2610,'四十里堡镇',4,'',0,1,0,0),(22357,2610,'圈里乡',4,'',0,1,0,0),(22358,2610,'夏蔚镇',4,'',0,1,0,0),(22359,2610,'姚店子镇',4,'',0,1,0,0),(22360,2610,'富官庄乡',4,'',0,1,0,0),(22361,2610,'崔家峪镇',4,'',0,1,0,0),(22362,2610,'杨庄镇',4,'',0,1,0,0),(22363,2610,'沂水镇',4,'',0,1,0,0),(22364,2610,'沙沟镇',4,'',0,1,0,0),(22365,2610,'泉庄乡',4,'',0,1,0,0),(22366,2610,'许家湖镇',4,'',0,1,0,0),(22367,2610,'诸葛镇',4,'',0,1,0,0),(22368,2610,'道托乡',4,'',0,1,0,0),(22369,2610,'院东头乡',4,'',0,1,0,0),(22370,2610,'马站镇',4,'',0,1,0,0),(22371,2610,'高庄镇',4,'',0,1,0,0),(22372,2610,'高桥镇',4,'',0,1,0,0),(22373,2610,'黄山铺镇',4,'',0,1,0,0),(22374,2610,'龙家圈乡',4,'',0,1,0,0),(22375,2611,'九曲镇',4,'',0,1,0,0),(22376,2611,'八湖镇',4,'',0,1,0,0),(22377,2611,'凤凰岭乡',4,'',0,1,0,0),(22378,2611,'刘店子乡',4,'',0,1,0,0),(22379,2611,'太平镇',4,'',0,1,0,0),(22380,2611,'梅埠镇',4,'',0,1,0,0),(22381,2611,'汤头镇',4,'',0,1,0,0),(22382,2611,'汤河镇',4,'',0,1,0,0),(22383,2611,'相公镇',4,'',0,1,0,0),(22384,2611,'芝麻墩镇',4,'',0,1,0,0),(22385,2611,'郑旺镇',4,'',0,1,0,0),(22386,2611,'重沟镇',4,'',0,1,0,0),(22387,2612,'付庄街道',4,'',0,1,0,0),(22388,2612,'册山街道',4,'',0,1,0,0),(22389,2612,'双月湖街道',4,'',0,1,0,0),(22390,2612,'汤庄街道',4,'',0,1,0,0),(22391,2612,'盛庄街道',4,'',0,1,0,0),(22392,2612,'罗庄街道',4,'',0,1,0,0),(22393,2612,'罗西街道',4,'',0,1,0,0),(22394,2612,'高都街道',4,'',0,1,0,0),(22395,2613,'三合乡',4,'',0,1,0,0),(22396,2613,'下村乡',4,'',0,1,0,0),(22397,2613,'二庙乡',4,'',0,1,0,0),(22398,2613,'兰陵镇',4,'',0,1,0,0),(22399,2613,'兴明乡',4,'',0,1,0,0),(22400,2613,'南桥镇',4,'',0,1,0,0),(22401,2613,'卞庄镇',4,'',0,1,0,0),(22402,2613,'向城镇',4,'',0,1,0,0),(22403,2613,'大仲村镇',4,'',0,1,0,0),(22404,2613,'尚岩镇',4,'',0,1,0,0),(22405,2613,'层山镇',4,'',0,1,0,0),(22406,2613,'庄坞镇',4,'',0,1,0,0),(22407,2613,'新兴镇',4,'',0,1,0,0),(22408,2613,'沂堂镇',4,'',0,1,0,0),(22409,2613,'矿坑乡',4,'',0,1,0,0),(22410,2613,'磨山镇',4,'',0,1,0,0),(22411,2613,'神山镇',4,'',0,1,0,0),(22412,2613,'贾庄乡',4,'',0,1,0,0),(22413,2613,'车辋镇',4,'',0,1,0,0),(22414,2613,'长城镇',4,'',0,1,0,0),(22415,2613,'鲁城乡',4,'',0,1,0,0),(22416,2614,'十字路镇',4,'',0,1,0,0),(22417,2614,'团林镇',4,'',0,1,0,0),(22418,2614,'坊前镇',4,'',0,1,0,0),(22419,2614,'坪上镇',4,'',0,1,0,0),(22420,2614,'壮岗镇',4,'',0,1,0,0),(22421,2614,'大店镇',4,'',0,1,0,0),(22422,2614,'岭泉镇',4,'',0,1,0,0),(22423,2614,'文疃镇',4,'',0,1,0,0),(22424,2614,'朱芦镇',4,'',0,1,0,0),(22425,2614,'板泉镇',4,'',0,1,0,0),(22426,2614,'汀水镇',4,'',0,1,0,0),(22427,2614,'洙边镇',4,'',0,1,0,0),(22428,2614,'涝坡镇',4,'',0,1,0,0),(22429,2614,'相沟乡',4,'',0,1,0,0),(22430,2614,'相邸镇',4,'',0,1,0,0),(22431,2614,'石莲子镇',4,'',0,1,0,0),(22432,2614,'筵宾镇',4,'',0,1,0,0),(22433,2614,'道口乡',4,'',0,1,0,0),(22434,2615,'坦埠镇',4,'',0,1,0,0),(22435,2615,'垛庄镇',4,'',0,1,0,0),(22436,2615,'岱崮镇',4,'',0,1,0,0),(22437,2615,'常路镇',4,'',0,1,0,0),(22438,2615,'旧寨乡',4,'',0,1,0,0),(22439,2615,'桃墟镇',4,'',0,1,0,0),(22440,2615,'界牌镇',4,'',0,1,0,0),(22441,2615,'联城乡',4,'',0,1,0,0),(22442,2615,'蒙阴镇',4,'',0,1,0,0),(22443,2615,'野店镇',4,'',0,1,0,0),(22444,2615,'高都镇',4,'',0,1,0,0),(22445,2616,'上冶镇',4,'',0,1,0,0),(22446,2616,'刘庄镇',4,'',0,1,0,0),(22447,2616,'南张庄乡',4,'',0,1,0,0),(22448,2616,'城北乡',4,'',0,1,0,0),(22449,2616,'大田庄乡',4,'',0,1,0,0),(22450,2616,'探沂镇',4,'',0,1,0,0),(22451,2616,'新庄镇',4,'',0,1,0,0),(22452,2616,'新桥镇',4,'',0,1,0,0),(22453,2616,'方城镇',4,'',0,1,0,0),(22454,2616,'朱田镇',4,'',0,1,0,0),(22455,2616,'梁邱镇',4,'',0,1,0,0),(22456,2616,'汪沟镇',4,'',0,1,0,0),(22457,2616,'石井乡',4,'',0,1,0,0),(22458,2616,'胡阳乡',4,'',0,1,0,0),(22459,2616,'芍药山乡',4,'',0,1,0,0),(22460,2616,'薛庄镇',4,'',0,1,0,0),(22461,2616,'费城镇',4,'',0,1,0,0),(22462,2616,'马庄镇',4,'',0,1,0,0),(22463,2617,'庙山镇',4,'',0,1,0,0),(22464,2617,'归昌乡',4,'',0,1,0,0),(22465,2617,'新村乡',4,'',0,1,0,0),(22466,2617,'李庄镇',4,'',0,1,0,0),(22467,2617,'杨集镇',4,'',0,1,0,0),(22468,2617,'沙墩镇',4,'',0,1,0,0),(22469,2617,'泉源乡',4,'',0,1,0,0),(22470,2617,'港上镇',4,'',0,1,0,0),(22471,2617,'褚墩镇',4,'',0,1,0,0),(22472,2617,'红花乡',4,'',0,1,0,0),(22473,2617,'胜利乡',4,'',0,1,0,0),(22474,2617,'花园乡',4,'',0,1,0,0),(22475,2617,'郯城镇',4,'',0,1,0,0),(22476,2617,'重坊镇',4,'',0,1,0,0),(22477,2617,'马头镇',4,'',0,1,0,0),(22478,2617,'高峰头镇',4,'',0,1,0,0),(22479,2617,'黄山镇',4,'',0,1,0,0),(22480,2618,'临南镇',4,'',0,1,0,0),(22481,2618,'临盘镇',4,'',0,1,0,0),(22482,2618,'临邑镇',4,'',0,1,0,0),(22483,2618,'兴隆镇',4,'',0,1,0,0),(22484,2618,'孟寺镇',4,'',0,1,0,0),(22485,2618,'宿安乡',4,'',0,1,0,0),(22486,2618,'德平镇',4,'',0,1,0,0),(22487,2618,'林子镇',4,'',0,1,0,0),(22488,2618,'理合务乡',4,'',0,1,0,0),(22489,2618,'翟家乡',4,'',0,1,0,0),(22490,2619,'丁坞镇',4,'',0,1,0,0),(22491,2619,'云红街道',4,'',0,1,0,0),(22492,2619,'化楼镇',4,'',0,1,0,0),(22493,2619,'大孙乡',4,'',0,1,0,0),(22494,2619,'孔镇',4,'',0,1,0,0),(22495,2619,'寨头堡乡',4,'',0,1,0,0),(22496,2619,'市中街道',4,'',0,1,0,0),(22497,2619,'朱集镇',4,'',0,1,0,0),(22498,2619,'杨安镇',4,'',0,1,0,0),(22499,2619,'胡家街道',4,'',0,1,0,0),(22500,2619,'花园镇',4,'',0,1,0,0),(22501,2619,'西段乡',4,'',0,1,0,0),(22502,2619,'郑店镇',4,'',0,1,0,0),(22503,2619,'郭家街道',4,'',0,1,0,0),(22504,2619,'铁营乡',4,'',0,1,0,0),(22505,2619,'黄夹镇',4,'',0,1,0,0),(22506,2620,'东李官屯镇',4,'',0,1,0,0),(22507,2620,'双庙镇',4,'',0,1,0,0),(22508,2620,'夏津镇',4,'',0,1,0,0),(22509,2620,'宋楼乡',4,'',0,1,0,0),(22510,2620,'新盛店镇',4,'',0,1,0,0),(22511,2620,'渡口驿乡',4,'',0,1,0,0),(22512,2620,'田庄乡',4,'',0,1,0,0),(22513,2620,'白马湖镇',4,'',0,1,0,0),(22514,2620,'苏留庄镇',4,'',0,1,0,0),(22515,2620,'郑保屯镇',4,'',0,1,0,0),(22516,2620,'雷集镇',4,'',0,1,0,0),(22517,2620,'香赵庄镇',4,'',0,1,0,0),(22518,2621,'保店镇',4,'',0,1,0,0),(22519,2621,'刘营伍乡',4,'',0,1,0,0),(22520,2621,'大曹镇',4,'',0,1,0,0),(22521,2621,'大柳镇',4,'',0,1,0,0),(22522,2621,'宁津镇',4,'',0,1,0,0),(22523,2621,'张大庄乡',4,'',0,1,0,0),(22524,2621,'时集镇',4,'',0,1,0,0),(22525,2621,'杜集镇',4,'',0,1,0,0),(22526,2621,'柴胡店镇',4,'',0,1,0,0),(22527,2621,'相衙镇',4,'',0,1,0,0),(22528,2621,'长官镇',4,'',0,1,0,0),(22529,2622,'三唐乡',4,'',0,1,0,0),(22530,2622,'前曹镇',4,'',0,1,0,0),(22531,2622,'坊子乡',4,'',0,1,0,0),(22532,2622,'平原镇',4,'',0,1,0,0),(22533,2622,'张华镇',4,'',0,1,0,0),(22534,2622,'恩城镇',4,'',0,1,0,0),(22535,2622,'王庙镇',4,'',0,1,0,0),(22536,2622,'王打卦乡',4,'',0,1,0,0),(22537,2622,'王杲铺镇',4,'',0,1,0,0),(22538,2622,'王风楼镇',4,'',0,1,0,0),(22539,2622,'腰站镇',4,'',0,1,0,0),(22540,2623,'东辛店乡',4,'',0,1,0,0),(22541,2623,'严务乡',4,'',0,1,0,0),(22542,2623,'中丁乡',4,'',0,1,0,0),(22543,2623,'尚堂镇',4,'',0,1,0,0),(22544,2623,'崔口镇',4,'',0,1,0,0),(22545,2623,'常家镇',4,'',0,1,0,0),(22546,2623,'庆云镇',4,'',0,1,0,0),(22547,2623,'徐园子乡',4,'',0,1,0,0),(22548,2623,'渤海路街道',4,'',0,1,0,0),(22549,2624,'东地街道',4,'',0,1,0,0),(22550,2624,'二屯镇',4,'',0,1,0,0),(22551,2624,'天衢街道',4,'',0,1,0,0),(22552,2624,'宋官屯镇',4,'',0,1,0,0),(22553,2624,'抬头寺乡',4,'',0,1,0,0),(22554,2624,'新华街道',4,'',0,1,0,0),(22555,2624,'新湖街道',4,'',0,1,0,0),(22556,2624,'袁桥乡',4,'',0,1,0,0),(22557,2624,'赵虎镇',4,'',0,1,0,0),(22558,2624,'运河街道',4,'',0,1,0,0),(22559,2624,'黄河涯镇',4,'',0,1,0,0),(22560,2625,'李家户乡',4,'',0,1,0,0),(22561,2625,'杨庄乡',4,'',0,1,0,0),(22562,2625,'武城镇',4,'',0,1,0,0),(22563,2625,'甲马营乡',4,'',0,1,0,0),(22564,2625,'老城镇',4,'',0,1,0,0),(22565,2625,'膝庄镇',4,'',0,1,0,0),(22566,2625,'郝王庄镇',4,'',0,1,0,0),(22567,2625,'鲁权屯镇',4,'',0,1,0,0),(22568,2626,'伦镇',4,'',0,1,0,0),(22569,2626,'十里望回族乡',4,'',0,1,0,0),(22570,2626,'安仁镇',4,'',0,1,0,0),(22571,2626,'张庄镇',4,'',0,1,0,0),(22572,2626,'房寺镇',4,'',0,1,0,0),(22573,2626,'李屯乡',4,'',0,1,0,0),(22574,2626,'禹石街道',4,'',0,1,0,0),(22575,2626,'粱家镇',4,'',0,1,0,0),(22576,2626,'莒镇乡',4,'',0,1,0,0),(22577,2626,'辛寨镇',4,'',0,1,0,0),(22578,2626,'辛店镇',4,'',0,1,0,0),(22579,2627,'丁庄乡',4,'',0,1,0,0),(22580,2627,'义渡口乡',4,'',0,1,0,0),(22581,2627,'于集乡',4,'',0,1,0,0),(22582,2627,'前孙镇',4,'',0,1,0,0),(22583,2627,'宋家镇',4,'',0,1,0,0),(22584,2627,'徽王庄镇',4,'',0,1,0,0),(22585,2627,'滋镇',4,'',0,1,0,0),(22586,2627,'神头镇',4,'',0,1,0,0),(22587,2627,'边临镇',4,'',0,1,0,0),(22588,2627,'郑家寨镇',4,'',0,1,0,0),(22589,2627,'陵城镇',4,'',0,1,0,0),(22590,2627,'麋镇',4,'',0,1,0,0),(22591,2628,'仁里集镇',4,'',0,1,0,0),(22592,2628,'刘桥乡',4,'',0,1,0,0),(22593,2628,'华店乡',4,'',0,1,0,0),(22594,2628,'大黄乡',4,'',0,1,0,0),(22595,2628,'安头乡',4,'',0,1,0,0),(22596,2628,'宣章屯镇',4,'',0,1,0,0),(22597,2628,'晏城镇',4,'',0,1,0,0),(22598,2628,'潘店镇',4,'',0,1,0,0),(22599,2628,'焦庙镇',4,'',0,1,0,0),(22600,2628,'祝阿镇',4,'',0,1,0,0),(22601,2628,'胡官屯镇',4,'',0,1,0,0),(22602,2628,'表白寺镇',4,'',0,1,0,0),(22603,2628,'赵官镇',4,'',0,1,0,0),(22604,2628,'马集乡',4,'',0,1,0,0),(22605,2629,'于集镇',4,'',0,1,0,0),(22606,2629,'侯营镇',4,'',0,1,0,0),(22607,2629,'凤凰办事处',4,'',0,1,0,0),(22608,2629,'北城办事处',4,'',0,1,0,0),(22609,2629,'古楼办事处',4,'',0,1,0,0),(22610,2629,'堂邑镇',4,'',0,1,0,0),(22611,2629,'张炉集镇',4,'',0,1,0,0),(22612,2629,'斗虎屯镇',4,'',0,1,0,0),(22613,2629,'新区办事处',4,'',0,1,0,0),(22614,2629,'朱老庄乡',4,'',0,1,0,0),(22615,2629,'柳园办事处',4,'',0,1,0,0),(22616,2629,'梁水镇',4,'',0,1,0,0),(22617,2629,'沙镇',4,'',0,1,0,0),(22618,2629,'湖西办事处',4,'',0,1,0,0),(22619,2629,'许营乡',4,'',0,1,0,0),(22620,2629,'道口铺办事处',4,'',0,1,0,0),(22621,2629,'郑家镇',4,'',0,1,0,0),(22622,2629,'阎寺办事处',4,'',0,1,0,0),(22623,2630,'刘集镇',4,'',0,1,0,0),(22624,2630,'单庄乡',4,'',0,1,0,0),(22625,2630,'大桥镇',4,'',0,1,0,0),(22626,2630,'姚寨镇',4,'',0,1,0,0),(22627,2630,'姜楼镇',4,'',0,1,0,0),(22628,2630,'工业园',4,'',0,1,0,0),(22629,2630,'新城办事处',4,'',0,1,0,0),(22630,2630,'牛角店镇',4,'',0,1,0,0),(22631,2630,'铜城办事处',4,'',0,1,0,0),(22632,2630,'陈集乡',4,'',0,1,0,0),(22633,2630,'顾官屯镇',4,'',0,1,0,0),(22634,2630,'高集镇',4,'',0,1,0,0),(22635,2631,'先锋办事处',4,'',0,1,0,0),(22636,2631,'八岔路镇',4,'',0,1,0,0),(22637,2631,'刘垓子镇',4,'',0,1,0,0),(22638,2631,'唐园镇',4,'',0,1,0,0),(22639,2631,'大辛庄办事处',4,'',0,1,0,0),(22640,2631,'尚店乡',4,'',0,1,0,0),(22641,2631,'康庄镇',4,'',0,1,0,0),(22642,2631,'戴湾乡',4,'',0,1,0,0),(22643,2631,'新华办事处',4,'',0,1,0,0),(22644,2631,'松林镇',4,'',0,1,0,0),(22645,2631,'潘庄镇',4,'',0,1,0,0),(22646,2631,'烟店镇',4,'',0,1,0,0),(22647,2631,'老赵庄镇',4,'',0,1,0,0),(22648,2631,'金郝庄乡',4,'',0,1,0,0),(22649,2631,'青年办事处',4,'',0,1,0,0),(22650,2631,'魏湾镇',4,'',0,1,0,0),(22651,2632,'万善乡',4,'',0,1,0,0),(22652,2632,'东古城镇',4,'',0,1,0,0),(22653,2632,'兰沃乡',4,'',0,1,0,0),(22654,2632,'冠城镇',4,'',0,1,0,0),(22655,2632,'北馆陶镇',4,'',0,1,0,0),(22656,2632,'定远寨乡',4,'',0,1,0,0),(22657,2632,'店子乡',4,'',0,1,0,0),(22658,2632,'斜店乡',4,'',0,1,0,0),(22659,2632,'柳林镇',4,'',0,1,0,0),(22660,2632,'桑阿镇',4,'',0,1,0,0),(22661,2632,'梁堂乡',4,'',0,1,0,0),(22662,2632,'清水镇',4,'',0,1,0,0),(22663,2632,'烟庄乡',4,'',0,1,0,0),(22664,2632,'甘官屯乡',4,'',0,1,0,0),(22665,2632,'范寨乡',4,'',0,1,0,0),(22666,2632,'贾镇',4,'',0,1,0,0),(22667,2632,'辛集乡',4,'',0,1,0,0),(22668,2633,'丁块乡',4,'',0,1,0,0),(22669,2633,'乐平铺镇',4,'',0,1,0,0),(22670,2633,'冯官屯镇',4,'',0,1,0,0),(22671,2633,'博平镇',4,'',0,1,0,0),(22672,2633,'大桑乡',4,'',0,1,0,0),(22673,2633,'孙桥乡',4,'',0,1,0,0),(22674,2633,'广平乡',4,'',0,1,0,0),(22675,2633,'张营乡',4,'',0,1,0,0),(22676,2633,'杜郎口镇',4,'',0,1,0,0),(22677,2633,'杨官屯乡',4,'',0,1,0,0),(22678,2633,'洪官屯乡',4,'',0,1,0,0),(22679,2633,'温陈乡',4,'',0,1,0,0),(22680,2633,'王老乡',4,'',0,1,0,0),(22681,2633,'肖庄乡',4,'',0,1,0,0),(22682,2633,'胡屯乡',4,'',0,1,0,0),(22683,2633,'茌平镇',4,'',0,1,0,0),(22684,2633,'菜屯镇',4,'',0,1,0,0),(22685,2633,'贾寨乡',4,'',0,1,0,0),(22686,2633,'赵官屯乡',4,'',0,1,0,0),(22687,2633,'郝集乡',4,'',0,1,0,0),(22688,2633,'韩屯镇',4,'',0,1,0,0),(22689,2633,'韩集乡',4,'',0,1,0,0),(22690,2634,'俎店乡',4,'',0,1,0,0),(22691,2634,'十八里铺镇',4,'',0,1,0,0),(22692,2634,'古云镇',4,'',0,1,0,0),(22693,2634,'古城镇',4,'',0,1,0,0),(22694,2634,'大张家镇',4,'',0,1,0,0),(22695,2634,'大王寨乡',4,'',0,1,0,0),(22696,2634,'妹冢镇',4,'',0,1,0,0),(22697,2634,'张寨乡',4,'',0,1,0,0),(22698,2634,'张鲁镇',4,'',0,1,0,0),(22699,2634,'徐庄乡',4,'',0,1,0,0),(22700,2634,'朝城镇',4,'',0,1,0,0),(22701,2634,'柿子园乡',4,'',0,1,0,0),(22702,2634,'樱桃园镇',4,'',0,1,0,0),(22703,2634,'河店镇',4,'',0,1,0,0),(22704,2634,'燕店镇',4,'',0,1,0,0),(22705,2634,'王奉镇',4,'',0,1,0,0),(22706,2634,'王庄集乡',4,'',0,1,0,0),(22707,2634,'莘亭镇',4,'',0,1,0,0),(22708,2634,'莘城镇',4,'',0,1,0,0),(22709,2634,'董杜庄镇',4,'',0,1,0,0),(22710,2634,'观城镇',4,'',0,1,0,0),(22711,2634,'魏庄乡',4,'',0,1,0,0),(22712,2635,'七级',4,'',0,1,0,0),(22713,2635,'侨润',4,'',0,1,0,0),(22714,2635,'十五里园',4,'',0,1,0,0),(22715,2635,'博济桥',4,'',0,1,0,0),(22716,2635,'大布',4,'',0,1,0,0),(22717,2635,'安乐',4,'',0,1,0,0),(22718,2635,'定水',4,'',0,1,0,0),(22719,2635,'寿张',4,'',0,1,0,0),(22720,2635,'张秋',4,'',0,1,0,0),(22721,2635,'李台',4,'',0,1,0,0),(22722,2635,'狮子楼',4,'',0,1,0,0),(22723,2635,'石佛',4,'',0,1,0,0),(22724,2635,'西湖',4,'',0,1,0,0),(22725,2635,'郭屯',4,'',0,1,0,0),(22726,2635,'金斗营',4,'',0,1,0,0),(22727,2635,'闫楼',4,'',0,1,0,0),(22728,2635,'阿城',4,'',0,1,0,0),(22729,2635,'高庙王',4,'',0,1,0,0),(22730,2636,'三十里铺镇',4,'',0,1,0,0),(22731,2636,'人和街道办事处',4,'',0,1,0,0),(22732,2636,'固河镇',4,'',0,1,0,0),(22733,2636,'姜店乡',4,'',0,1,0,0),(22734,2636,'尹集镇',4,'',0,1,0,0),(22735,2636,'杨屯乡',4,'',0,1,0,0),(22736,2636,'梁村镇',4,'',0,1,0,0),(22737,2636,'汇鑫街道办事处',4,'',0,1,0,0),(22738,2636,'清平镇',4,'',0,1,0,0),(22739,2636,'琉寺镇',4,'',0,1,0,0),(22740,2636,'赵寨子乡',4,'',0,1,0,0),(22741,2636,'鱼邱湖街道办事处',4,'',0,1,0,0),(22742,2637,'乔庄镇',4,'',0,1,0,0),(22743,2637,'兴福镇',4,'',0,1,0,0),(22744,2637,'博兴镇',4,'',0,1,0,0),(22745,2637,'吕艺镇',4,'',0,1,0,0),(22746,2637,'店子镇',4,'',0,1,0,0),(22747,2637,'庞家镇',4,'',0,1,0,0),(22748,2637,'曹王镇',4,'',0,1,0,0),(22749,2637,'湖滨镇',4,'',0,1,0,0),(22750,2637,'纯化镇',4,'',0,1,0,0),(22751,2637,'陈户镇',4,'',0,1,0,0),(22752,2638,'何坊乡',4,'',0,1,0,0),(22753,2638,'大年陈乡',4,'',0,1,0,0),(22754,2638,'姜楼镇',4,'',0,1,0,0),(22755,2638,'惠民镇',4,'',0,1,0,0),(22756,2638,'李庄镇',4,'',0,1,0,0),(22757,2638,'桑落墅镇',4,'',0,1,0,0),(22758,2638,'淄角镇',4,'',0,1,0,0),(22759,2638,'清河镇',4,'',0,1,0,0),(22760,2638,'皂户李乡',4,'',0,1,0,0),(22761,2638,'石庙镇',4,'',0,1,0,0),(22762,2638,'胡集镇',4,'',0,1,0,0),(22763,2638,'辛店乡',4,'',0,1,0,0),(22764,2638,'魏集镇',4,'',0,1,0,0),(22765,2638,'麻店镇',4,'',0,1,0,0),(22766,2639,'佘家巷乡',4,'',0,1,0,0),(22767,2639,'信阳乡',4,'',0,1,0,0),(22768,2639,'埕口镇',4,'',0,1,0,0),(22769,2639,'小泊头镇',4,'',0,1,0,0),(22770,2639,'无棣镇',4,'',0,1,0,0),(22771,2639,'柳堡乡',4,'',0,1,0,0),(22772,2639,'水湾镇',4,'',0,1,0,0),(22773,2639,'碣石山镇',4,'',0,1,0,0),(22774,2639,'西小王乡',4,'',0,1,0,0),(22775,2639,'车镇乡',4,'',0,1,0,0),(22776,2639,'马山子镇',4,'',0,1,0,0),(22777,2640,'下河乡',4,'',0,1,0,0),(22778,2640,'下洼镇',4,'',0,1,0,0),(22779,2640,'冯家镇',4,'',0,1,0,0),(22780,2640,'利国乡',4,'',0,1,0,0),(22781,2640,'古城镇',4,'',0,1,0,0),(22782,2640,'大高镇',4,'',0,1,0,0),(22783,2640,'富国镇',4,'',0,1,0,0),(22784,2640,'泊头镇',4,'',0,1,0,0),(22785,2640,'海防办事处',4,'',0,1,0,0),(22786,2640,'滨海乡',4,'',0,1,0,0),(22787,2640,'黄升乡',4,'',0,1,0,0),(22788,2641,'北镇街道',4,'',0,1,0,0),(22789,2641,'单寺乡',4,'',0,1,0,0),(22790,2641,'堡集镇',4,'',0,1,0,0),(22791,2641,'小营街道',4,'',0,1,0,0),(22792,2641,'尚集乡',4,'',0,1,0,0),(22793,2641,'市东街道',4,'',0,1,0,0),(22794,2641,'市中街道',4,'',0,1,0,0),(22795,2641,'市西街道',4,'',0,1,0,0),(22796,2641,'彭李街道',4,'',0,1,0,0),(22797,2641,'旧镇',4,'',0,1,0,0),(22798,2641,'杜店镇',4,'',0,1,0,0),(22799,2641,'梁才街道',4,'',0,1,0,0),(22800,2641,'滨北街道',4,'',0,1,0,0),(22801,2641,'里则街道',4,'',0,1,0,0),(22802,2642,'临池镇',4,'',0,1,0,0),(22803,2642,'九户镇',4,'',0,1,0,0),(22804,2642,'台子镇',4,'',0,1,0,0),(22805,2642,'好升镇',4,'',0,1,0,0),(22806,2642,'孙镇',4,'',0,1,0,0),(22807,2642,'明集镇',4,'',0,1,0,0),(22808,2642,'焦桥镇',4,'',0,1,0,0),(22809,2642,'码头镇',4,'',0,1,0,0),(22810,2642,'西董镇',4,'',0,1,0,0),(22811,2642,'长山镇',4,'',0,1,0,0),(22812,2642,'青阳镇',4,'',0,1,0,0),(22813,2642,'韩店镇',4,'',0,1,0,0),(22814,2642,'高新街道',4,'',0,1,0,0),(22815,2642,'魏桥镇',4,'',0,1,0,0),(22816,2642,'黄山街道',4,'',0,1,0,0),(22817,2642,'黛溪街道',4,'',0,1,0,0),(22818,2643,'劳店乡',4,'',0,1,0,0),(22819,2643,'商店镇',4,'',0,1,0,0),(22820,2643,'水落坡乡',4,'',0,1,0,0),(22821,2643,'河流镇',4,'',0,1,0,0),(22822,2643,'洋湖乡',4,'',0,1,0,0),(22823,2643,'流坡坞镇',4,'',0,1,0,0),(22824,2643,'温店镇',4,'',0,1,0,0),(22825,2643,'翟王镇',4,'',0,1,0,0),(22826,2643,'阳信镇',4,'',0,1,0,0),(22827,2644,'三春集镇',4,'',0,1,0,0),(22828,2644,'东明集镇',4,'',0,1,0,0),(22829,2644,'刘楼镇',4,'',0,1,0,0),(22830,2644,'城关镇',4,'',0,1,0,0),(22831,2644,'大屯镇',4,'',0,1,0,0),(22832,2644,'小井乡',4,'',0,1,0,0),(22833,2644,'武胜桥乡',4,'',0,1,0,0),(22834,2644,'沙窝乡',4,'',0,1,0,0),(22835,2644,'焦园乡',4,'',0,1,0,0),(22836,2644,'菜园集乡',4,'',0,1,0,0),(22837,2644,'长兴集乡',4,'',0,1,0,0),(22838,2644,'陆圈镇',4,'',0,1,0,0),(22839,2644,'马头镇',4,'',0,1,0,0),(22840,2645,'单城镇',4,'',0,1,0,0),(22841,2645,'孙溜镇',4,'',0,1,0,0),(22842,2645,'张集乡',4,'',0,1,0,0),(22843,2645,'徐寨镇',4,'',0,1,0,0),(22844,2645,'时楼镇',4,'',0,1,0,0),(22845,2645,'曹庄镇',4,'',0,1,0,0),(22846,2645,'朱集镇',4,'',0,1,0,0),(22847,2645,'李新庄',4,'',0,1,0,0),(22848,2645,'李田楼乡',4,'',0,1,0,0),(22849,2645,'杨楼镇',4,'',0,1,0,0),(22850,2645,'浮岗镇',4,'',0,1,0,0),(22851,2645,'终兴镇',4,'',0,1,0,0),(22852,2645,'莱河镇',4,'',0,1,0,0),(22853,2645,'蔡堂镇',4,'',0,1,0,0),(22854,2645,'谢集乡',4,'',0,1,0,0),(22855,2645,'郭村镇',4,'',0,1,0,0),(22856,2645,'高老家乡',4,'',0,1,0,0),(22857,2645,'高韦庄镇',4,'',0,1,0,0),(22858,2645,'黄岗镇',4,'',0,1,0,0),(22859,2645,'龙王庙乡',4,'',0,1,0,0),(22860,2646,'仿山乡',4,'',0,1,0,0),(22861,2646,'冉固镇',4,'',0,1,0,0),(22862,2646,'半堤乡',4,'',0,1,0,0),(22863,2646,'南王店乡',4,'',0,1,0,0),(22864,2646,'孟海镇',4,'',0,1,0,0),(22865,2646,'定陶镇',4,'',0,1,0,0),(22866,2646,'张湾乡',4,'',0,1,0,0),(22867,2646,'杜堂乡',4,'',0,1,0,0),(22868,2646,'陈集镇',4,'',0,1,0,0),(22869,2646,'马集镇',4,'',0,1,0,0),(22870,2646,'黄店镇',4,'',0,1,0,0),(22871,2647,'万丰镇',4,'',0,1,0,0),(22872,2647,'大义镇',4,'',0,1,0,0),(22873,2647,'大谢集镇',4,'',0,1,0,0),(22874,2647,'太平镇',4,'',0,1,0,0),(22875,2647,'巨野镇',4,'',0,1,0,0),(22876,2647,'柳林镇',4,'',0,1,0,0),(22877,2647,'核桃园镇',4,'',0,1,0,0),(22878,2647,'独山镇',4,'',0,1,0,0),(22879,2647,'田庄镇',4,'',0,1,0,0),(22880,2647,'田桥镇',4,'',0,1,0,0),(22881,2647,'章缝镇',4,'',0,1,0,0),(22882,2647,'营里镇',4,'',0,1,0,0),(22883,2647,'董官屯镇',4,'',0,1,0,0),(22884,2647,'陶庙镇',4,'',0,1,0,0),(22885,2647,'麒麟镇',4,'',0,1,0,0),(22886,2647,'龙堌镇',4,'',0,1,0,0),(22887,2648,'九女镇',4,'',0,1,0,0),(22888,2648,'伯乐镇',4,'',0,1,0,0),(22889,2648,'党集乡',4,'',0,1,0,0),(22890,2648,'南鲁镇',4,'',0,1,0,0),(22891,2648,'大田集镇',4,'',0,1,0,0),(22892,2648,'天宫镇',4,'',0,1,0,0),(22893,2648,'孙寺镇',4,'',0,1,0,0),(22894,2648,'张楼乡',4,'',0,1,0,0),(22895,2648,'成武镇',4,'',0,1,0,0),(22896,2648,'汶上镇',4,'',0,1,0,0),(22897,2648,'白浮镇',4,'',0,1,0,0),(22898,2648,'苟村镇',4,'',0,1,0,0),(22899,2649,'仵楼乡',4,'',0,1,0,0),(22900,2649,'侯集回族镇',4,'',0,1,0,0),(22901,2649,'倪集乡',4,'',0,1,0,0),(22902,2649,'南李集乡',4,'',0,1,0,0),(22903,2649,'古营集镇',4,'',0,1,0,0),(22904,2649,'大寨集乡',4,'',0,1,0,0),(22905,2649,'大集乡',4,'',0,1,0,0),(22906,2649,'孙老家镇',4,'',0,1,0,0),(22907,2649,'安仁集乡',4,'',0,1,0,0),(22908,2649,'安蔡楼镇',4,'',0,1,0,0),(22909,2649,'常乐集乡',4,'',0,1,0,0),(22910,2649,'庄寨镇',4,'',0,1,0,0),(22911,2649,'普连集镇',4,'',0,1,0,0),(22912,2649,'曹城镇',4,'',0,1,0,0),(22913,2649,'朱洪庙乡',4,'',0,1,0,0),(22914,2649,'桃源集镇',4,'',0,1,0,0),(22915,2649,'梁堤头镇',4,'',0,1,0,0),(22916,2649,'楼庄乡',4,'',0,1,0,0),(22917,2649,'王集镇',4,'',0,1,0,0),(22918,2649,'申楼乡',4,'',0,1,0,0),(22919,2649,'砖庙镇',4,'',0,1,0,0),(22920,2649,'苏集镇',4,'',0,1,0,0),(2292