'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports['default'] = parse;

var _domhandler = require('domhandler');

var _domhandler2 = _interopRequireDefault(_domhandler);

var _Parser = require('./Parser');

var _Parser2 = _interopRequireDefault(_Parser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function transformNode(node) {
    if (['tag', 'text'].indexOf(node.type) === -1) {
        throw new Error('not supported name ' + node.name + ' of type ' + node.type);
    }
    if (node.type === 'text') {
        return {
            type: node.type,
            text: node.data
        };
    }
    return {
        name: node.name,
        children: transform(node.children),
        attrs: node.attribs
    };
}
function transform(nodes) {
    return nodes.map(transformNode);
}
function parse(html, done) {
    var handler = new _domhandler2['default'](function (err, children) {
        if (err) {
            console.error(err);
            done(err);
        }
        try {
            done(null, transform(children));
        } catch (e) {
            console.error(e);
            done(e);
        }
    }, {});
    var parser = new _Parser2['default'](handler, { xmlMode: true });
    parser.write(html);
    parser.done();
}
module.exports = exports['default'];