<!-- 导航 -->
<view class="nav">
  <block qq:for="{{nav_status_list}}" qq:key="key">
    <view class="item fl tc cr-888 {{nav_status_index == index ? 'active' : ''}}" data-index="{{index}}" bindtap="nav_event">{{item.name}}</view>
  </block>
</view>

<!-- 列表 -->
<scroll-view scroll-y="{{true}}" class="scroll-box" bindscrolltolower="scroll_lower" lower-threshold="30">
  <view class="data-list">
    <view class="item bg-white spacing-mb" qq:if="{{data_list.length > 0}}" qq:for="{{data_list}}" qq:key="key">
      <view class="base oh br-b">
        <text class="cr-666">{{item.add_time}}</text>
        <text class="fr cr-main">{{item.status_name}}</text>
      </view>
      <navigator url="/pages/plugins/invoice/invoice-detail/invoice-detail?id={{item.id}}" hover-class="none">
        <view class="content">
          <view class="single-text">
            <text class="title cr-666">业务类型</text>
            <text class="value">{{item.business_type_name}}</text>
          </view>
          <view class="single-text">
            <text class="title cr-666">申请类型</text>
            <text class="value">{{item.apply_type_name}}</text>
          </view>
          <view class="single-text">
            <text class="title cr-666">发票类型</text>
            <text class="value">{{item.invoice_type_name}}</text>
          </view>
          <view class="single-text">
            <text class="title cr-666">发票金额</text>
            <text class="value">{{item.total_price}}</text>
            <text class="unit cr-888">元</text>
          </view>
          <view class="single-text">
            <text class="title cr-666">发票抬头</text>
            <text class="value">{{item.invoice_title}}</text>
          </view>
        </view>
      </navigator>
      <view qq:if="{{item.status == 0 || item.status == 3 || item.status == 4}}" class="operation tr br-t-dashed">
        <button qq:if="{{item.status == 0 || item.status == 3}}" class="cr-666 br" type="default" size="mini" bindtap="edit_event" data-value="{{item.id}}" hover-class="none">编辑</button>
        <button class="submit-delete" type="default" size="mini" bindtap="delete_event" data-value="{{item.id}}" data-index="{{index}}" hover-class="none">删除</button>
      </view>
    </view>

    <view qq:if="{{data_list.length == 0}}">
      <import src="/pages/common/nodata.qml" />
      <template is="nodata" data="{{status: data_list_loding_status}}">
      </template>
    </view>

    <import src="/pages/common/bottom_line.qml" />
    <template is="bottom_line" data="{{status: data_bottom_line_status}}"></template>
  </view>
</scroll-view>