﻿<!DOCTYPE html>
<html lang="zh-cn">
 <head>
 <meta charset="utf-8">
 <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
 <title>微信接口开发在线调试工具 V1.0 </title>
 <meta name="keywords" content="微信在线调试工具,微信开发调试工具,微信开发接口调试,微信公众平台开发调试,WeChat Debugger"/>
 <meta name="description" content="微信在线调试工具,微信开发调试工具,微信开发接口调试,微信公众平台开发调试,WeChat Debugger" /> 
 <link href="weixinpost/css/bootstrap.min.css" rel="stylesheet">
 <link href="weixinpost/css/common.css" rel="stylesheet">
 <link href="weixinpost/css/emulator.css" rel="stylesheet">
 <script type="text/javascript" src="weixinpost/js/require.js"></script>
 <script type="text/javascript" src="weixinpost/js/jquery.min.js"></script>
 <style>
 .table-responsive.panel-body{overflow:auto;}
 .table{table-layout:fixed; min-width:900px;}
 .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td,.table>tfoot>tr>td{vertical-align:middle;}
 .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td{overflow:hidden; text-overflow:ellipsis;}
 .table>thead>tr>th{border-top:none;}
 .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th{border-top:none;}
 </style>
<!--

通用成绩查询系统解决方案(简单通用易用):

方案4:微信公众号N选1个查询条件直接查询工资、成绩、水电费等
自助开通试用:http://new.12391.net/ 
视频教程下载:http://pan.baidu.com/s/1ge6BPEr 
代码购买:https://item.taobao.com/item.htm?id=520496908275 
整体服务:https://item.taobao.com/item.htm?id=529624346797 

方案3(荐):微信公众号一对一绑定才可以查询工资、成绩、水电费等
自助开通试用:http://add.96cha.com/ 
代码购买:https://item.taobao.com/item.htm?id=44248394675 
整体服务:https://item.taobao.com/item.htm?id=528187132312 

方案2(荐):用户在线登录查询工资成绩水电费等，可自助修改密码
自助开通试用:http://add.dbcha.com/ 
视频教程下载:http://pan.baidu.com/s/1boANMwv 
代码购买:https://item.taobao.com/item.htm?id=43193387085 
整体服务:https://item.taobao.com/item.htm?id=528108807297 

方案1:直接通过设定的（1-3个）查询条件查询
免费即时开通:http://add.12391.net/ 
视频教程下载:http://pan.baidu.com/s/1eSoDn26 
代码购买:https://item.taobao.com/item.htm?id=528692002051 
整体服务:https://item.taobao.com/item.htm?id=520023732507 

代码版：不加密，无域名限制，无时间限制,一次付费一直可用(域名和网站空间费用另外自理)
整体服务：无需域名 无需空间 无需代码 无需技术人员 无需备案，即开即用 ,按时间付费

通用模糊检索系统解决方案(简单通用易用):

方案1:通用多选一模糊查询系统单输入框版
自助开通试用:http://add.xuelikai.com:1111/ 
视频教程下载:http://pan.baidu.com/s/1ge6BPEr (只参考第一步第二步)
代码购买:https://item.taobao.com/item.htm?id=520167788658 

方案2:通用多选一模糊查询系统下拉可选条件版
自助开通试用:http://add.xuelikai.com:2222/
视频教程下载:http://pan.baidu.com/s/1ge6BPEr (只参考第一步第二步)
代码购买:https://item.taobao.com/item.htm?id=520167788658 

方案3(荐):通用多选一模糊查询系统多输入框版
自助开通试用:http://add.xuelikai.com:3333/
视频教程下载:http://pan.baidu.com/s/1ge6BPEr (只参考第一步第二步)
代码购买:https://item.taobao.com/item.htm?id=520167788658 
　

以上三个模糊检索方案也可以用于多选一精准查询系统
　
-->
 </head>
 <body>
 <div class="container-fluid">
 <div class="clearfix">
 <div class="col-xs-12 col-sm-8">
 <form action="" method="get" class="form-horizontal form">
 <div class="page-header">
 <h4>微信接口开发在线调试工具 V1.0</h4>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label"></label>
 <div class="col-sm-10">
 <input name="submit" type="button" onclick="submitform()" value="发送消息" class="btn btn-primary">
 <input name="submit" type="button" onclick="checkSignature()" value="Token验证" class="btn btn-warning">
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">接口URL</label>
 <div class="col-sm-10">
 <input type="text" id="mpurl" value="http://asp.96448.cn/_weixin/chengji.asp" placeholder="" class="form-control" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">Token</label>
 <div class="col-sm-10">
 <input type="text" id="mptoken" value="weixin" placeholder="" class="form-control" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">消息类型</label>
 <div class="col-sm-10">
 <div class="radio-inline"><input type="radio" name="type" value="subscribe" id="type_subscribe" onclick="toggle('subscribe')" /><label for="type_subscribe">关注</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="unsubscribe" id="type_unsubscribe" onclick="toggle('unsubscribe')" /><label for="type_unsubscribe">取消关注</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="other" id="type_unsubscribe" onclick="toggle('other')" /><label for="type_unsubscribe">自定义XML</label></div>
 <br>
 <div class="radio-inline"><input type="radio" name="type" value="text" id="type_text" onclick="toggle('text')" checked="checked" /><label for="type_text">文本</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="image" id="type_image" onclick="toggle('image')" /><label for="type_image">图片</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="voice" id="type_voice" onclick="toggle('voice')" /><label for="type_voice">语音</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="video" id="type_video" onclick="toggle('video')" /><label for="type_video">视频</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="location" id="type_location" onclick="toggle('location')" /><label for="type_location">位置</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="link" id="type_link" onclick="toggle('link')" /><label for="type_link">链接</label></div>
 <div class="radio-inline"><input type="radio" name="type" value="menu" id="type_menu" onclick="toggle('menu')" /><label for="type_menu">菜单点击</label></div>
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">发送用户</label>
 <div class="col-sm-10">
 <input type="text" id="fromuser" value="ojpX_test12345678912345678900" class="form-control" required="required" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">接收用户</label>
 <div class="col-sm-10">
 <input type="text" id="touser" value="gh_123456789" class="form-control" />
 </div>
 </div>
 <div class="form-group content_type" id="text">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">内容</label>
 <div class="col-sm-10">
 <input type="text" id="contentvalue" value="01@张三" class="form-control" />
 </div>
 </div>
 <div id="image" class="content_type">
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">图片链接</label>
 <div class="col-sm-10">
 <input type="text" id="picurl" value="https://mmbiz.qlogo.cn/mmbiz/iapWtZUUn667LklNrIXYmtaZia1DcHNpBh11sanaXiaRhLITNQaQuLPG1MqMiciaSEkzIIMfmUuFmtUBmiczlSt0tlrw/0?wx_fmt=jpeg" class="form-control" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">图片ID</label>
 <div class="col-sm-10">
 <input type="text" id="mediaid" value="iapWtZUUn667LklNrIXYmtaZia1DcHNpBh11sanaXiaRhLITNQaQuLPG1MqMiciaSEkzIIMfmUuFmtUBmiczlSt0tlrw" class="form-control" />
 </div>
 </div>
 </div>
 <div id="voice" class="content_type">
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">语音ID</label>
 <div class="col-sm-10">
 <input type="text" id="mediaid" value="iapWtZUUn667LklNrIXYmtaZia1DcHNpBh11sanaXiaRhLITNQaQuLPG1MqMiciaSEkzIIMfmUuFmtUBmiczlSt0tlrw" class="form-control" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">语音格式</label>
 <div class="col-sm-10">
 <input type="text" id="format" value="amr" class="form-control" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">语音识别</label>
 <div class="col-sm-10">
 <input type="text" id="recognition" value="等我有钱了，我要买好多好多美女!" class="form-control" />
 </div>
 </div>
 </div>
 <div id="video" class="content_type">
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">视频ID</label>
 <div class="col-sm-10">
 <input type="text" id="mediaid" value="DBVFRIj29LB2hxuYpc0R6VLyxwgyCHZPbRj_IIs6YaGhutyXUKtFSDcSCPeoqUYr" class="form-control" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">缩略图ID</label>
 <div class="col-sm-10">
 <input type="text" id="thumbmediaid" value="mxUJ5gcCeesJwx2T9qsk62YzIclCP_HnRdfTQcojlPeT2G9Q3d22UkSLyBFLZ01J" class="form-control" />
 </div>
 </div>
 </div>

 <div id="location" class="content_type">
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">X坐标</label>
 <div class="col-sm-10">
 <input type="text" id="location_x" class="form-control" value="28.888888" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">Y坐标</label>
 <div class="col-sm-10">
 <input type="text" id="location_y" class="form-control" value="119.999999" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">缩放大小</label>
 <div class="col-sm-10">
 <input type="text" id="scale" class="form-control" value="16" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">位置信息</label>
 <div class="col-sm-10">
 <input type="text" id="label" class="form-control" value="中国浙江省金华市武义县12391.net 邮政编码: 321200" />
 </div>
 </div>
 </div>
 <div id="link" class="content_type">
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">标题</label>
 <div class="col-sm-10">
 <input type="text" id="linktitle" class="form-control" value="免费查询系统（工资\成绩\物业等）" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">描述</label>
 <div class="col-sm-10">
 <input type="text" id="linkdescription" class="form-control" value="在线注册，即时开通，灵活支持你的几乎所有二维表，自定义查询条件，可设是否验证码。" />
 </div>
 </div>
 <div class="form-group" >
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">链接</label>
 <div class="col-sm-10">
 <input type="text" id="linkurl" class="form-control" value="http://12391.net/" />
 </div>
 </div>
 </div>
 <div class="form-group content_type" id="menu">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">事件KEY值</label>
 <div class="col-sm-10">
 <input type="text" id="event_key" class="form-control" value="关于我们" />
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">发送消息</label>
 <div class="col-sm-10">
 <textarea id="sendxml" rows="8" cols="50" class="form-control" readonly="readonly"></textarea>
 </div>
 </div>
 <div class="form-group">
 <label class="col-xs-12 col-sm-2 col-md-2 control-label">接收消息</label>
 <div class="col-sm-10">
 <pre id="receive"></pre>
 </div>
 </div>
 </form>
 </div>
 <div class="col-sm-4" id="demoSendBox">
 <div class="chatPanel form" style="width:300px;">
 <div class="page-header">
 <h4>效果预览</h4>
 </div>
 <div id="donation">
 <div id="" style="text-align:left; padding-bottom:10px;">
 <img src="weixinpost/images/noavatar_middle.gif" style="width:34px;height:34px;margin-right:6px;float:right;" class="img-rounded">
 <div id="" class="btn btn-success" style="margin-right: 4px;float: right;max-width: 184px;text-align:left;">此调试器非常有用，打架收藏下哈！</div>
 <div style="clear:both;"></div>
 </div>
 <div id="" style="text-align: left; padding-bottom: 10px;">
 <img src="weixinpost/images/weixin.jpeg" style="width:34px;height:34px;margin-left:6px; float:left;" class="img-rounded">
 <div class="mediaPanel"><div class="mediaImg" ><img id="svpic" height="300" width="250" src="https://mmbiz.qlogo.cn/mmbiz/iapWtZUUn667LklNrIXYmtaZia1DcHNpBh11sanaXiaRhLITNQaQuLPG1MqMiciaSEkzIIMfmUuFmtUBmiczlSt0tlrw/0?wx_fmt=jpeg" alt="随便放二维码" ></div></div>
 <div style="clear:both;"></div>
 </div>
 </div>

 <div id="svposttext" style="text-align:left; padding-bottom:10px;display:none;">
 <img src="weixinpost/images/noavatar_middle.gif" style="width:34px;height:34px;margin-right:6px;float:right;" class="img-rounded">
 <div id="svpostinfo" class="btn btn-success" style="margin-right: 4px;float: right;max-width: 184px;text-align:left;">发送内容</div>
 <div style="clear:both;"></div>
 </div>

 <div class="chatItem you">
 <div id="svtext" style="text-align:left; padding-bottom:10px;display:none;">
 <img src="weixinpost/images/weixin.jpeg" style="width:34px;height:34px;margin-left:6px; float:left;" class="img-rounded">
 <div class="btn btn-success" style="margin-left: 4px;float: left;max-width: 184px;text-align:left;">回复内容</div>
 <div style="clear:both;"></div>
 </div>

 <div id="svurlbox" style="display:none;">
 <div class="media mediaFullText">
 <div class="mediaPanel">
 <a href="javascript:;" id="svurl" target="_blank">
 <div class="mediaHead"><span class="title" id="svtitle">标题</span><span class="time"><%=month(now())%>月<%=day(now())%>日</span>
 <div class="clr"></div>
 </div>
 <div class="mediaImg"><img id="svpic" src=""></div>
 <div class="mediaContent mediaContentP"><p id="svinfo"></p></div>
 </a>
 <div id="svinfolist"></div>
 <div class="mediaFooter">
 <div class="mediaFooterbox clearfix" onclick="opensvurl();">
 <span class="mesgIcon right">&gt;</span>
 <span style="line-height:50px;" class="left">查看全文</span>
 </div>
 <div class="clr"></div>
 </div>
 </div>
 </div>
 </div>
 </div>
 </div>
 </div>
 </div>

 <script type="text/javascript">
 require(['jquery'], function($){
 $('.content_type').hide();
 $('#text').show();
 toggle('text');
 });
 function opensvurl(){
 var href=$("#svurl").attr("href");
 window.open(href, "_blank");
 }
 function popensvurl(href){
 if(href)window.open(href, "_blank");
 }
 function toggle(type) {
 curtype = type;
 $('.content_type').hide();
 $("#" + curtype).show();

 buildRequest(type);
 $('#receive').text('');
 $('#svposttext').hide();
 $('#svtext').hide();
 $('#svurlbox').hide();
 $('#sendxml').attr('readonly', 'readonly');
 if(type == 'other') {
 $('#sendxml').removeAttr('readonly');
 }
 }

 function getxml(xml){
 var xmlobject = null;
 try{
 if(window.ActiveXObject){
 xmlobject =new ActiveXObject("Microsoft.XMLDOM");
 xmlobject.async="false";
 xmlobject.loadXML(xml);
 }else{// 用于 Mozilla, Firefox, Opera, 等浏览器的代码：
 var parser=new DOMParser();
 xmlobject =parser.parseFromString(xml,"text/xml");
 }
 }catch(e){alert("您的浏览器不支持模拟测试");}
 return xmlobject;
 }

 function buildRequest(type) {
 var $demoSendBox = $('#demoSendBox');
 $('span.time', $demoSendBox).show();
 $('div.mediaImg', $demoSendBox).show();
 $('div.mediaContent', $demoSendBox).show();
 $('div.mediaFooterbox', $demoSendBox).show();
 var time = Math.round(new Date().getTime()/1000);
 xml = "<xml>\n"+
 " <ToUserName><![CDATA["+$('#touser').val()+"]]></ToUserName>\n"+
 " <FromUserName><![CDATA["+$('#fromuser').val()+"]]></FromUserName>\n"+
 " <CreateTime>"+time+"</CreateTime>\n";
 if (type == 'text') {
 xml += " <MsgType><![CDATA[text]]></MsgType>\n";
 xml += " <Content><![CDATA["+$('#contentvalue').val()+"]]></Content>\n";
 $('#svpostinfo').text($('#contentvalue').val());
 } else if (type == 'image') {
 xml += " <MsgType><![CDATA[image]]></MsgType>\n";
 xml += " <PicUrl><![CDATA["+$('#picurl').val()+"]]></PicUrl>\n";
 xml += " <MediaId><![CDATA["+$('#mediaid').val()+"]]></MediaId>\n";
 $('#svpostinfo').html('<img height="114" width="153" src="'+$('#picurl').val()+'">');
 } else if (type == 'voice') {
 xml += " <MsgType><![CDATA[voice]]></MsgType>\n";
 xml += " <MediaId><![CDATA["+$('#mediaid').val()+"]]></MediaId>\n";
 xml += " <Format><![CDATA["+$('#format').val()+"]]></Format>\n";
 xml += " <Recognition><![CDATA["+$('#recognition').val()+"]]></Recognition>\n";
 $('#svpostinfo').html('我发了声音信息');
 } else if (type == 'video') {
 xml += " <MsgType><![CDATA[video]]></MsgType>\n";
 xml += " <MediaId><![CDATA["+$('#mediaid').val()+"]]></MediaId>\n";
 xml += " <ThumbMediaId><![CDATA["+$('#thumbmediaid').val()+"]]></ThumbMediaId>\n";
 $('#svpostinfo').html('我发了视频信息');
 } else if (type == 'location') {
 xml += " <MsgType><![CDATA[location]]></MsgType>\n";
 xml += " <Location_X>"+parseFloat($('#location_x').val())+"</Location_X>\n";
 xml += " <Location_Y>"+parseFloat($('#location_y').val())+"</Location_Y>\n";
 xml += " <Scale><![CDATA["+$('#scale').val()+"]]></Scale>\n";
 xml += " <Label><![CDATA["+$('#label').val()+"]]></Label>\n";
 $('span.time', $demoSendBox).hide();
 $('div.mediaImg', $demoSendBox).hide();
 $('div.mediaContent', $demoSendBox).hide();
 $('#svpostinfo').html('我发了定位信息');
 } else if (type == 'link') {
 xml += " <MsgType><![CDATA[link]]></MsgType>\n";
 xml += " <Title><![CDATA["+$('#linktitle').val()+"]]></Title>\n";
 xml += " <Description><![CDATA["+$('#linkdescription').val()+"]]></Description>\n";
 xml += " <Url><![CDATA["+$('#linkurl').val()+"]]></Url>\n";
 $('#svpostinfo').html('我发了链接信息');
 } else if (type == 'subscribe') {
 xml += " <MsgType><![CDATA[event]]></MsgType>\n";
 xml += " <Event><![CDATA[subscribe]]></Event>\n";
 xml += " <EventKey><![CDATA[]]></EventKey>\n";
 } else if (type == 'unsubscribe') {
 xml += " <MsgType><![CDATA[event]]></MsgType>\n";
 xml += " <Event><![CDATA[unsubscribe]]></Event>\n";
 xml += " <EventKey><![CDATA[]]></EventKey>\n";
 } else if (type == 'menu') {
 xml += " <MsgType><![CDATA[event]]></MsgType>\n";
 xml += " <Event><![CDATA[CLICK]]></Event>\n";
 xml += " <EventKey><![CDATA["+$('#event_key').val()+"]]></EventKey>\n";
 }
 xml += " <MsgId>1234567890abcdef</MsgId>\n"+
 "</xml>";
 if(type == 'other') {
 xml = $('#sendxml').val();
 }
 $('#sendxml').val(xml);
 }
 function checkSignature() {
 $.ajax('weixinpost/url/',{
 type: "POST",
 dataType: "json",
 data : {
 mpurl: $('#mpurl').val(),
 mptoken: $('#mptoken').val(),
 },
 beforeSend : function(){
 if ($('#mpurl').val() == "" || $('#mptoken').val() == ""){
 alert("接口URL及Token未填写");
 return;
 }
 if ($('#mpurl').val().substring(0, 7) != "http://"){
 alert("接口URL需要以http://开头");
 return;
 }
 },
 success: function(s) {
 if (s.status == "1"){
 alert("Token校验成功");
 }else{
 alert("Token校验失败！");
 }
 return;
 },
 error: function() {
 alert("接口无响应或超时！");
 },
 timeout: 5000,
 })
 }
 function submitform() {
 buildRequest(curtype);
 $('#svtext').hide();$('#svurlbox').hide();$('#svinfolist').hide();
 $('div.mediaFooterbox', $('#demoSendBox')).show();
 $.ajax('weixinpost/url/',{
 type: "POST",
 dataType: "text",
 data : {
 mpurl: $('#mpurl').val(),
 mptoken: $('#mptoken').val(),
 mpxml: $('#sendxml').val().replace(/[\r\n]/g,""),
 },
 beforeSend : function(){
 if ($('#mpurl').val() == ""){
 alert("接口URL未填写");
 return;
 }
 if ($('#mpurl').val().substring(0, 7) != "http://"){
 alert("接口URL需要以http://开头");
 return;
 }
 if(curtype!='subscribe' && curtype!='unsubscribe'){
 if(curtype=='text' || curtype=='image' || curtype=='voice' || curtype=='video' || curtype=='link' || curtype == 'location'){
 $('#svposttext').show();
 }
 }
 $('#donation').hide();
 // $('#svposttext').show();
 $('#receive').text('加载中。。。');
 },
 success: function(s) {
 var xmlobject = getxml(s);
 if(xmlobject){
 var xmlobj = xmlobject.getElementsByTagName("xml");
 if(xmlobj.length){
 var xmls = xmlobj.item(0);
 var xml = xmls;
 var FromUserName = xml.getElementsByTagName("FromUserName")[0].firstChild.nodeValue;
 var ToUserName = xml.getElementsByTagName("ToUserName")[0].firstChild.nodeValue;
 var MsgType = xml.getElementsByTagName("MsgType")[0].firstChild.nodeValue;

 if(MsgType=='text'){
 var Content = xml.getElementsByTagName("Content")[0].firstChild.nodeValue;
 Content = nl2br(Content);
 $('#svtext').show().find('div.btn').html(Content);
 }else if(MsgType == 'news'){
 var Title = xml.getElementsByTagName("Title")[0].firstChild.nodeValue;
 var Description = xml.getElementsByTagName("Description")[0].firstChild.nodeValue;
 var PicUrl = xml.getElementsByTagName("PicUrl")[0].firstChild.nodeValue;
 var Url = xml.getElementsByTagName("Url")[0].firstChild.nodeValue;
 if(Url.indexOf('http://') == -1 && Url.indexOf('https://') == -1) {
 Url = '../app/' + Url;
 }
 $('#svtitle').html(Title);
 $('#svinfo').html(Description);
 $('#svpic').attr('src', PicUrl);
 $('#svurlbox').show().find('a#svurl').attr('href', Url);
 var titleObj = xml.getElementsByTagName("Title");
 if(titleObj.length>1){
 var svinfolist = imghtml = '';
 var UrlObj = xml.getElementsByTagName("Url");
 var PicUrlObj = xml.getElementsByTagName("PicUrl");
 for(var ti=1;ti<titleObj.length;ti++){
 imghtml = PicUrlObj[ti].firstChild.nodeValue ? '<img align="right" src="'+PicUrlObj[ti].firstChild.nodeValue+'">' : '';
 svinfolist += '<p class="clearfix" onclick="popensvurl(\''+UrlObj[ti].firstChild.nodeValue+'\')">'+titleObj[ti].firstChild.nodeValue+imghtml+'</p>';
 }
 $('div.mediaFooterbox', $('#demoSendBox')).hide();
 $('#svinfolist').show().html(svinfolist);
 }
 }
 }
 }
 $('#receive').text(s);
 },
 error: function() {
 alert("接口无响应或超时！");
 },
 timeout:10000
 })
 }

 function nl2br(str, is_xhtml) {
 var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br ' + '/>' : '<br>'; // Adjust comment to avoid issue on phpjs.org display
 return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
 }
 </script>
 </div>
 <div class="container-fluid footer" style="margin:0px auto;text-align:center;" role="footer">
 <div class="page-header"></div>
 <span >
 <p><a target="_blank" href="https://mp.weixin.qq.com/">微信公众平台</a> <a target="_blank" href="http://12391.net/">免费查询系统</a> <a target="_blank" href="http://aiyaha.taobao.com/">功能定制淘宝</a></p>
 </span>
 <div style="display:none;">
 </div>
 </div>
 </body>
</html>