<?php
if (!defined("ABSPATH")) {
	die;
}
function cao_body_classes($classes)
{
	if (!session_id()) {
		session_start();
	}
	$dark_session = !empty($_SESSION["is_ripro_dark"]) ? true : false;
	$this_dark = _cao("is_ripro_dark") ? "ripro-dark" : '';
	if ($dark_session) {
		$this_dark = "ripro-dark";
	}
	$classes[] = $this_dark;
	if (_cao("is_site_max_width", "0")) {
		$classes[] = "max_width";
	}
	if (!is_singular()) {
		$classes[] = "hfeed";
	}
	if (is_home()) {
		$classes[] = "modular-title-2";
	}
	$navbar_style = _cao("navbar_style", "sticky");
	if (is_singular("post") || is_page()) {
		$navbar_style = cao_compare_options($navbar_style, rwmb_meta("navbar_style"));
	}
	$classes[] = "navbar-" . $navbar_style;
	if (_cao("navbar_full", false) == true) {
		$classes[] = "navbar-full";
	}
	if (_cao("navbar_slide", false) == true) {
		$classes[] = "navbar-slide";
	}
	if (cao_compare_options(_cao("navbar_hidden", false), rwmb_meta("navbar_hidden")) == true) {
		$classes[] = "navbar-hidden";
	}
	if (_cao("disable_search", false) == true) {
		$classes[] = "no-search";
	}
	$classes[] = "sidebar-" . cao_sidebar();
	if (cao_show_hero()) {
		$classes[] = "with-hero";
		if (is_home()) {
			$classes[] = "hero-" . _cao("hero_home_style", "none");
			$classes[] = "hero-" . _cao("hero_home_content", "image");
		} else {
			if (is_singular("post") || is_page()) {
				$classes[] = "hero-" . cao_compare_options(_cao("hero_single_style", "none"), rwmb_meta("hero_single_style"));
				$classes[] = get_post_format() ? "hero-" . get_post_format() : "hero-image";
			}
		}
	}
	$classes[] = "pagination-" . _cao("pagination", "infinite_button");
	if (get_previous_posts_link()) {
		$classes[] = "paged-previous";
	}
	if (get_next_posts_link()) {
		$classes[] = "paged-next";
	}
	if ((is_singular("post") || is_page()) && rwmb_meta("cao_subheading") != '') {
		$classes[] = "with-subheading";
	}
	if (!is_active_sidebar("off_canvas")) {
		$classes[] = "no-off-canvas";
	}
	return $classes;
}
add_filter("body_class", "cao_body_classes");
function cao_entry_header($options = array())
{
	$options = array_merge(array("outside_loop" => false, "container" => "header", "tag" => "h2", "link" => true, "white" => false, "author" => false, "category" => false, "date" => false, "comment" => false, "like" => false), $options);
	$queried_object = get_queried_object();
	$post_id = $options["outside_loop"] ? $queried_object->ID : get_the_ID();
	$categories = get_the_category($post_id);
	echo "\r\n  ";
	echo "<" . $options["container"] . " class=\"entry-header" . esc_attr($options["white"] ? " white" : '') . "\">";
	echo "    ";
	if ($options["author"] || $options["category"] || $options["date"] || $options["comment"] || $options["like"]) {
		echo "      <div class=\"entry-meta\">\r\n        ";
		if ($options["author"]) {
			$author_id = get_post_field("post_author", $post_id);
			echo "          <span class=\"meta-author\">\r\n            <a>\r\n              ";
			echo get_avatar(get_the_author_meta("email", $author_id), "40", null, get_the_author_meta("display_name", $author_id));
			echo get_the_author_meta("display_name", $author_id);
			echo "            </a>\r\n          </span>\r\n        ";
		}
		if ($categories && $options["category"]) {
			echo "          <span class=\"meta-category\">\r\n            ";
			foreach ($categories as $key => $category) {
				if ($key == 3) {
					break;
				}
				echo "              <a";
				echo _target_blank();
				echo " href=\"";
				echo esc_url(get_category_link($category->term_id));
				echo "\" rel=\"category\">\r\n                  <i class=\"dot\"></i>";
				echo esc_html($category->name);
				echo "              </a>\r\n            ";
			}
			echo "          </span>\r\n        ";
		}
		if ($options["date"]) {
			echo "          <span class=\"meta-date\">\r\n            <a";
			echo _target_blank();
			echo " href=\"";
			echo esc_url(get_the_permalink($post_id));
			echo "\">\r\n              <time datetime=\"";
			echo esc_attr(get_the_date("c", $post_id));
			echo "\">\r\n                ";
			echo _timeago(get_gmt_from_date(get_the_time("Y-m-d G:i:s")));
			echo "              </time>\r\n            </a>\r\n          </span>\r\n        ";
		}
		if ($options["comment"] && !post_password_required($post_id) && (comments_open($post_id) || get_comments_number($post_id))) {
			echo "          <span class=\"meta-comment\">\r\n            <a";
			echo _target_blank();
			echo " href=\"";
			echo esc_url(get_the_permalink($post_id) . "#comments");
			echo "\">\r\n              ";
			printf(_n("%s 评论", "%s 评论", esc_html(get_comments_number($post_id)), "cao"), esc_html(number_format_i18n(get_comments_number($post_id))));
			echo "            </a>\r\n          </span>\r\n        ";
		}
		echo "      </div>\r\n    ";
	}
	echo "\r\n    ";
	if ($options["link"]) {
		echo "<" . $options["tag"] . " class=\"entry-title\"><a" . _target_blank() . " href=\"" . esc_url(get_permalink($post_id)) . "\" title=\"" . get_the_title($post_id) . "\" rel=\"bookmark\">" . get_the_title($post_id) . "</a></" . $options["tag"] . ">";
	} else {
		echo "<" . $options["tag"] . " class=\"entry-title\">" . get_the_title($post_id) . "</" . $options["tag"] . ">";
	}
	echo "  ";
	echo "</" . $options["container"] . ">";
}
if (!function_exists("cao_thumbnail_ratio")) {
	function cao_thumbnail_ratio()
	{
		$thumbnail = _cao("thumbnail-px");
		if ($thumbnail["width"] && $thumbnail["height"]) {
			return $thumbnail["height"] / $thumbnail["width"] * 100 . "%";
		} else {
			return 200 / 300 * 100 . "%";
		}
	}
}
if (!function_exists("cao_entry_media")) {
	function cao_entry_media()
	{
		global $post;
		$ratio = cao_thumbnail_ratio();
		echo "  <div class=\"entry-media\">\r\n    <div class=\"placeholder\" style=\"padding-bottom: ";
		echo esc_attr($ratio);
		echo ";\">\r\n      <a";
		echo _target_blank();
		echo "  href=\"";
		echo esc_url(get_permalink());
		echo "\">\r\n        <img class=\"lazyload\" data-src=\"";
		echo esc_url(_get_post_timthumb_src());
		echo "\" src=\"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==\" alt=\"";
		echo get_the_title();
		echo "\">  \r\n      </a>\r\n      ";
		if (_cao("post_tim_rload", "0")) {
			echo "      <div class=\"cao-cover\"><img src=\"";
			echo get_template_directory_uri();
			echo "/assets/images/svg/rings.svg\" width=\"50\" height=\"50px\"></div>\r\n      ";
		}
		echo "    </div>\r\n    ";
		get_template_part("parts/entry-format");
		echo "  </div>\r\n  ";
	}
}
function cao_sidebar()
{
	if (is_singular("post") || is_page()) {
		global $post;
		$sidebar = get_post_meta($post->ID, "post_style", true);
		if ($sidebar == "no_sidebar") {
			$sidebar = "none";
		} else {
			$sidebar = "right";
		}
		return $sidebar;
	} else {
		return "none";
	}
}
function cao_column_classes($sidebar)
{
	$content_column_class = "content-column col-lg-9";
	$sidebar_column_class = "sidebar-column col-lg-3";
	if ($sidebar == "none") {
		$content_column_class = "col-lg-12";
	}
	return array($content_column_class, $sidebar_column_class);
}
function cao_side_thumbnail()
{
	if ((is_singular("post") || is_page()) && has_post_thumbnail()) {
		$image_location = "mixed";
		$featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
		if (($image_location == "mixed" && $featured_image[2] > $featured_image[1] || $image_location == "side") && !get_post_format()) {
			return true;
		}
	}
	return false;
}
function cao_show_hero()
{
	global $post;
	if (is_singular("post") || is_page()) {
		$post_style = get_post_meta($post->ID, "post_hero", true);
		if ($post_style) {
			return true;
		}
	}
	return false;
}
function cao_is_gif()
{
	if (has_post_thumbnail()) {
		$featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
		$featured_image = $featured_image[0];
		$path_parts = pathinfo($featured_image);
		$extension = $path_parts["extension"];
		return $extension == "gif" ? true : false;
	}
	return false;
}
if (!function_exists("cao_lazy_content_images")) {
	function cao_lazy_content_images($content)
	{
		global $post;
		$_the_content = $content;
		if (is_feed() || is_preview() || function_exists("is_mobile") && is_mobile()) {
			return $content;
		}
		if (false !== strpos($content, "data-original")) {
			return $content;
		}
		return preg_replace_callback("/(<\\s*img[^>]+)(src\\s*=\\s*\"[^\"]+\")([^>]+>)/i", function ($matches) {
			if (!preg_match("/class\\s*=\\s*\"/i", $matches[0])) {
				$class_attr = "class=\"\" ";
			}
			$replacement = $matches[1] . $class_attr . "src=\"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==\" data-srcset" . substr($matches[2], 3) . $matches[3];
			$replacement = preg_replace("/class\\s*=\\s*\"/i", "class=\"lazyload ", $replacement);
			$replacement .= "<noscript>" . $matches[0] . "</noscript>";
			return $replacement;
		}, $content);
	}
	if (_cao("cao_lazy_content_images", false)) {
		add_filter("the_content", "cao_lazy_content_images", 99);
	}
}
function cao_compare_options($global, $override)
{
	if ($global == $override || $override == '') {
		return $global;
	} else {
		return $override;
	}
}
if (!function_exists("rwmb_meta")) {
	function rwmb_meta($key, $args = '', $post_id = null)
	{
		return false;
	}
}
function _the_theme_name()
{
	$current_theme = wp_get_theme();
	return $current_theme->get("Name");
}
function _the_theme_version()
{
	$current_theme = wp_get_theme();
	return $current_theme->get("Version");
}
function _the_theme_aurl()
{
	$current_theme = wp_get_theme();
	return $current_theme->get("ThemeURI");
}
function _get_description_max_length()
{
	return 200;
}
function _get_delimiter()
{
	return _cao("connector") ? _cao("connector") : "-";
}
remove_action("wp_head", "_wp_render_title_tag", 1);
function _title()
{
	if (_cao("del_ripro_seo", "0")) {
		return wp_title("-", true, "right");
	}
	global $paged, $post;
	$html = '';
	$t = trim(wp_title('', false));
	if ($t) {
		$html .= $t . _get_delimiter();
	}
	if (get_query_var("page")) {
		$html .= "第" . get_query_var("page") . "页" . _get_delimiter();
	}
	$html .= get_bloginfo("name");
	if (is_home()) {
		if ($paged > 1) {
			$html .= _get_delimiter() . "最新发布";
		} else {
			if (get_option("blogdescription")) {
				$html .= _get_delimiter() . get_option("blogdescription");
			}
		}
	}
	if (is_category()) {
		global $wp_query;
		$cat_ID = get_query_var("cat");
		$seo_str = get_term_meta($cat_ID, "seo-title", true);
		$cat_tit = $seo_str ? $seo_str : _get_tax_meta($cat_ID, "title");
		if ($cat_tit) {
			$html = $cat_tit;
		}
	} else {
		if (is_tag()) {
			$tagName = single_tag_title('', false);
			$tagObject = get_term_by("name", $tagName, "post_tag");
			$tagID = $tagObject->term_id;
			$seo_str = get_term_meta($tagID, "seo-title", true);
			$html = $seo_str ? trim($seo_str) : $tagName;
		} else {
			if (is_singular() && get_post_meta($post->ID, "post_titie_s", true)) {
				$html = get_post_meta($post->ID, "post_titie", true);
			}
		}
	}
	if ($paged > 1) {
		$html .= _get_delimiter() . "第" . $paged . "页";
	}
	return $html;
}
function _the_head()
{
	_keywords();
	_description();
	_post_views_record();
	$css_str = _cao("web_css");
	if ($css_str) {
		echo "<style>" . $css_str . "</style>";
	}
}
add_action("wp_head", "_the_head");
function _keywords()
{
	if (_cao("del_ripro_seo", "0")) {
		return;
	}
	global $s, $post;
	$keywords = '';
	if (is_singular()) {
		if (get_the_tags($post->ID)) {
			foreach (get_the_tags($post->ID) as $tag) {
				$keywords .= $tag->name . ",";
			}
		}
		foreach (get_the_category($post->ID) as $category) {
			$keywords .= $category->cat_name . ", ";
		}
		if (get_post_meta($post->ID, "post_keywords_s", true)) {
			$the = trim(get_post_meta($post->ID, "keywords", true));
			if ($the) {
				$keywords = $the;
			}
		} else {
			$keywords = substr_replace($keywords, '', -2);
		}
	} elseif (is_home()) {
		$seo_opt = _cao("seo");
		$keywords = !empty($seo_opt["web_keywords"]) ? $seo_opt["web_keywords"] : "RiPro主题是最好的资源下载付费主题";
	} elseif (is_tag()) {
		$tagName = single_tag_title('', false);
		$tagObject = get_term_by("name", $tagName, "post_tag");
		$tagID = $tagObject->term_id;
		$seo_str = get_term_meta($tagID, "seo-keywords", true);
		$keywords = $seo_str ? trim($seo_str) : $tagName;
	} elseif (is_category()) {
		global $wp_query;
		$cat_ID = get_query_var("cat");
		$seo_str = get_term_meta($cat_ID, "seo-keywords", true);
		$keywords = $seo_str ? trim($seo_str) : trim(wp_title('', false));
	} elseif (is_search()) {
		$keywords = esc_html($s, 1);
	} else {
		$keywords = trim(wp_title('', false));
	}
	if ($keywords) {
		echo "<meta name=\"keywords\" content=\"{$keywords}\">\n";
	}
}
function _description()
{
	if (_cao("del_ripro_seo", "0")) {
		return;
	}
	global $s, $post;
	$description = '';
	$blog_name = get_bloginfo("name");
	if (is_singular()) {
		if (!empty($post->post_excerpt)) {
			$text = $post->post_excerpt;
		} else {
			$text = $post->post_content;
		}
		$description = trim(str_replace(array("\r\n", "\r", "\n", "　", " "), " ", str_replace("\"", "'", strip_tags($text))));
		$description = substr_ext(strip_tags(strip_shortcodes($description)), 0, 140, "utf-8", "...");
		if (!$description) {
			$description = $blog_name . "-" . trim(wp_title('', false));
		}
		if (get_post_meta($post->ID, "post_description_s", true)) {
			$the = trim(get_post_meta($post->ID, "description", true));
			if ($the) {
				$description = $the;
			}
		}
	} elseif (is_home()) {
		$seo_opt = _cao("seo");
		$description = !empty($seo_opt["web_description"]) ? $seo_opt["web_description"] : "RiPro主题是最好的资源下载付费主题";
	} elseif (is_tag()) {
		$tagName = single_tag_title('', false);
		$tagObject = get_term_by("name", $tagName, "post_tag");
		$tagID = $tagObject->term_id;
		$seo_str = get_term_meta($tagID, "seo-description", true);
		$description = $seo_str ? trim($seo_str) : trim(wp_title('', false));
	} elseif (is_category()) {
		global $wp_query;
		$cat_ID = get_query_var("cat");
		$seo_str = get_term_meta($cat_ID, "seo-description", true);
		$description = $seo_str ? trim($seo_str) : trim(wp_title('', false));
	} elseif (is_archive()) {
		$description = $blog_name . "-" . trim(wp_title('', false));
	} elseif (is_search()) {
		$description = $blog_name . ": '" . esc_html($s, 1) . "' " . __("的搜索結果", "haoui");
	} elseif (!is_tag()) {
		$description = $blog_name . "'" . trim(wp_title('', false)) . "'";
	}
	$description = mb_substr($description, 0, _get_description_max_length(), "utf-8");
	echo "<meta name=\"description\" content=\"{$description}\">\n";
}
function _get_tax_meta($id = 0, $field = '')
{
	$ops = get_option("_taxonomy_meta_{$id}");
	if (empty($ops)) {
		return '';
	}
	if (empty($field)) {
		return $ops;
	}
	return isset($ops[$field]) ? $ops[$field] : '';
}
function cao_oauth_page_rewrite_rules($wp_rewrite)
{
	if ($ps = get_option("permalink_structure")) {
		$new_rules["oauth/([A-Za-z]+)\$"] = "index.php?oauth=\$matches[1]";
		$new_rules["oauth/([A-Za-z]+)/callback\$"] = "index.php?oauth=\$matches[1]&oauth_callback=1";
		$wp_rewrite->rules = $new_rules + $wp_rewrite->rules;
	}
}
add_action("generate_rewrite_rules", "cao_oauth_page_rewrite_rules");
function cao_add_oauth_page_query_vars($public_query_vars)
{
	if (!is_admin()) {
		$public_query_vars[] = "oauth";
		$public_query_vars[] = "oauth_callback";
	}
	return $public_query_vars;
}
add_filter("query_vars", "cao_add_oauth_page_query_vars");
function cao_oauth_page_template()
{
	$oauth = strtolower(get_query_var("oauth"));
	$oauth_callback = get_query_var("oauth_callback");
	if ($oauth) {
		if (in_array($oauth, array("qq", "qqagent", "weixin", "mpweixin", "weixinagent", "weibo", "weiboagent"))) {
			global $wp_query;
			$wp_query->is_home = false;
			$wp_query->is_page = true;
			$template = $oauth_callback ? TEMPLATEPATH . "/inc/oauth/" . $oauth . "/callback.php" : TEMPLATEPATH . "/inc/oauth/" . $oauth . "/login.php";
			load_template($template);
			exit;
		} else {
			unset($oauth);
			return;
		}
	}
}
add_action("template_redirect", "cao_oauth_page_template", 5);
if (_cao("is_close_wpreg") || _cao("is_close_wplogin")) {
}
function getQrcode($url)
{
	require_once get_template_directory() . "/inc/class/qrcode.class.php";
	$errorCorrectionLevel = "L";
	$matrixPointSize = 6;
	ob_start();
	QRcode::png($url, false, $errorCorrectionLevel, $matrixPointSize, 2);
	$data = ob_get_contents();
	ob_end_clean();
	$imageString = base64_encode($data);
	header("content-type:application/json; charset=utf-8");
	return "data:image/jpeg;base64," . $imageString;
}
function cao_avatar_hook($avatar, $id_or_email, $size, $default, $alt, $str = "img")
{
	$user = false;
	if (is_numeric($id_or_email)) {
		$id = (int) $id_or_email;
		$user = get_user_by("id", $id);
	} else {
		if (is_object($id_or_email)) {
			if (!empty($id_or_email->user_id)) {
				$id = (int) $id_or_email->user_id;
				$user = get_user_by("id", $id);
			}
		} else {
			$user = get_user_by("email", $id_or_email);
		}
	}
	if ($user && is_object($user)) {
		$uid = $user->data->ID;
		$user_email = $user->data->user_email;
		$_qqAvatarAPI = "https://q.qlogo.cn/qqapp/";
		$_gravatarAPI = "https://cn.gravatar.com/avatar/";
		$_user_avatar_type = get_user_meta($uid, "user_avatar_type", true);
		switch ($_user_avatar_type) {
			case "gravatar":
				$user_custom_avatar = get_user_meta($uid, "user_custom_avatar", true);
				$avatar_url = $user_custom_avatar ? $user_custom_avatar : _the_theme_avatar();
				break;
			case "qq":
				$qqConfig = _cao("oauth_qq");
				$avatar_url = $_qqAvatarAPI . $qqConfig["appid"] . "/" . get_user_meta($uid, "open_qq_openid", true) . "/100";
				break;
			case "weibo":
				$avatar_url = set_url_scheme(get_user_meta($uid, "open_weibo_avatar", true));
				break;
			case "weixin":
				$avatar_url = set_url_scheme(get_user_meta($uid, "open_weixin_avatar", true));
				break;
			case "custom":
				$avatar_url = set_url_scheme(get_user_meta($uid, "user_custom_avatar", true));
			default:
				$avatar_url = _the_theme_avatar();
		}
		if ($str == "img") {
			if (is_admin()) {
				$avatar = "<img alt='{$alt}' src='{$avatar_url}' class='avatar avatar-{$size} photo {$_user_avatar_type}' height='{$size}' width='{$size}' />";
			} else {
				$avatar = "<img alt='{$alt}' data-src='{$avatar_url}' class='lazyload avatar avatar-{$size} photo {$_user_avatar_type}' height='{$size}' width='{$size}' />";
			}
		} else {
			$avatar = $avatar_url;
		}
	}
	return $avatar;
}
add_filter("get_avatar", "cao_avatar_hook", 1, 5);
function _the_theme_avatar()
{
	return get_template_directory_uri() . "/assets/images/avatar/1.png";
}
function _is_bind_openid($type = "qq")
{
	global $current_user;
	$uid = $current_user->ID;
	$_bind = (int) get_user_meta($uid, "open_" . $type . "_bind", true);
	return $_bind ? true : false;
}
function _the_open_oauth_login_btn()
{
	if (_cao("is_oauth_qq") || _cao("is_oauth_weixin") || _cao("is_oauth_mpweixin") || _cao("is_oauth_weibo")) {
		$oauthArr = array("qq", "weixin", "mpweixin", "weibo");
		echo "<div class=\"open-oauth  text-center\">";
		$rurl = home_url(add_query_arg(array()));
		foreach ($oauthArr as $value) {
			if (_cao("is_oauth_" . $value)) {
				if ($value == "mpweixin") {
					echo "<a href=\"" . esc_url(home_url("/oauth/mpweixin")) . "\" class=\"go-mpweixin btn btn-" . $value . "\"><i class=\"fa fa-weixin\"></i></a>";
				} else {
					echo "<a href=\"" . esc_url(home_url("/oauth/" . $value . "?rurl=" . $rurl)) . "\" class=\"btn btn-" . $value . "\"><i class=\"fa fa-" . $value . "\"></i></a>";
				}
			}
		}
		echo "</div>";
		echo "<div class=\"or-text\"><span>or</span></div>";
	}
}
function _the_open_oauth_btn()
{
	$oauthArr = array("qq", "weixin", "mpweixin", "weibo");
	foreach ($oauthArr as $value) {
		switch ($value) {
			case "qq":
				$opname = "QQ";
				$fa = "qq";
				break;
			case "weixin":
				$opname = "微信";
				$fa = "weixin";
				break;
			case "mpweixin":
				$opname = "公众号";
				$fa = "weixin";
				break;
			case "weibo":
				$opname = "微博";
				$fa = "weibo";
				break;
		}
		if (_cao("is_oauth_" . $value)) {
			if (_is_bind_openid($value)) {
				echo "<a href=\"javascript: void(0);\" title=\"" . $opname . "登录\" class=\"btn unset-bind\" data-id=\"" . $value . "\"><i class=\"fa fa-" . $fa . "\"></i> 解绑" . $opname . "</a>";
			} else {
				if ($value == "mpweixin") {
					echo "<a href=\"" . esc_url(home_url("/oauth/mpweixin")) . "\" title=\"" . $opname . "登录\" class=\"bind-mpweixin btn\"><i class=\"fa fa-" . $fa . "\"></i> 绑定" . $opname . "</a>";
				} else {
					echo "<a href=\"" . esc_url(home_url("/oauth/" . $value)) . "\" title=\"" . $opname . "登录\" class=\"btn\"><i class=\"fa fa-" . $fa . "\"></i> 绑定" . $opname . "</a>";
				}
			}
		}
	}
}
function _get_user_avatar_url($type = "gravatar", $user_id = 0)
{
	if ($user_id > 0) {
		$uid = $user_id;
	} else {
		global $current_user;
		$uid = $current_user->ID;
	}
	$user = get_user_by("id", $uid);
	$user_email = $user->data->user_email;
	$_user_avatar_type = get_user_meta($uid, "user_avatar_type", true);
	if ($type == "user") {
		$this_type = $_user_avatar_type;
	} else {
		$this_type = $type;
	}
	$_qqAvatarAPI = "https://q.qlogo.cn/qqapp/";
	$_gravatarAPI = "https://cn.gravatar.com/avatar/";
	switch ($this_type) {
		case "gravatar":
			$user_custom_avatar = get_user_meta($uid, "user_custom_avatar", true);
			$avatar_url = $user_custom_avatar ? $user_custom_avatar : _the_theme_avatar();
			break;
		case "qq":
			$qqConfig = _cao("oauth_qq");
			$avatar_url = $_qqAvatarAPI . $qqConfig["appid"] . "/" . get_user_meta($uid, "open_qq_openid", true) . "/100";
			break;
		case "weibo":
			$avatar_url = set_url_scheme(get_user_meta($uid, "open_weibo_avatar", true));
			break;
		case "weixin":
			$avatar_url = set_url_scheme(get_user_meta($uid, "open_weixin_avatar", true));
			break;
		case "custom":
			$avatar_url = set_url_scheme(get_user_meta($uid, "user_custom_avatar", true));
		default:
			$avatar_url = _the_theme_avatar();
	}
	return $avatar_url;
}
function _get_user_avatar($user_email = '', $src = false, $size = 50)
{
	global $current_user;
	if (!$user_email) {
		$user_email = $current_user->user_email;
	}
	$avatar = get_avatar($user_email, $size);
	if ($src) {
		return $avatar;
	} else {
		return $avatar;
	}
}
function _get_post_shop_status()
{
	global $post;
	$post_ID = $post->ID;
	if (get_post_meta($post_ID, "cao_status", true)) {
		return true;
	}
	return false;
}
function _get_post_shop_hide()
{
	global $post;
	if (has_shortcode($post->post_content, "rihide")) {
		return true;
	}
	return false;
}
function _get_post_video_status()
{
	global $post;
	$post_ID = $post->ID;
	if (get_post_meta($post_ID, "cao_video", true)) {
		return true;
	}
	return false;
}
function _get_post_video_url()
{
	global $post;
	$video_url = get_post_meta($post->ID, "video_url", true);
	if ($video_url != '') {
		return $video_url;
	}
	return false;
}
function _get_post_price()
{
	global $post;
	$post_ID = $post->ID;
	$price = get_post_meta($post_ID, "cao_price", true);
	$priceVal = $price ? $price : "0";
	return $priceVal;
}
function _get_post_cat()
{
	global $post;
	$post_ID = $post->ID;
	$category = get_the_category($post->ID);
	$cat_neme = $category[0]->cat_name;
	$cat_links = get_category_link($category[0]->cat_ID);
	return "<a href=\"" . $cat_links . "\">" . $cat_neme . "</a>";
}
function _post_views_record()
{
	if (is_singular()) {
		global $post;
		$post_ID = $post->ID;
		if ($post_ID) {
			$post_views = (int) get_post_meta($post_ID, "views", true);
			if (!update_post_meta($post_ID, "views", $post_views + 1)) {
				add_post_meta($post_ID, "views", 1, true);
			}
		}
	}
}
function _get_post_views($before = '', $after = '')
{
	global $post;
	$post_ID = $post->ID;
	$views = (int) get_post_meta($post_ID, "views", true);
	if ($views >= 1000) {
		$views = round($views / 1000, 2) . "K";
	}
	return $before . $views . $after;
}
if (_cao("set_postthumbnail") && !function_exists("_set_postthumbnail")) {
	function _set_postthumbnail()
	{
		global $post;
		if (empty($post)) {
			return;
		}
		$already_has_thumb = has_post_thumbnail($post->ID);
		if (!$already_has_thumb) {
			$attached_image = get_children("post_parent={$post->ID}&post_type=attachment&post_mime_type=image&numberposts=1");
			if ($attached_image) {
				foreach ($attached_image as $attachment_id => $attachment) {
					set_post_thumbnail($post->ID, $attachment_id);
				}
			}
		}
	}
	add_action("save_post", "_set_postthumbnail");
	add_action("draft_to_publish", "_set_postthumbnail");
	add_action("new_to_publish", "_set_postthumbnail");
	add_action("pending_to_publish", "_set_postthumbnail");
	add_action("future_to_publish", "_set_postthumbnail");
}
function _the_theme_thumb()
{
	return _cao("post_default_thumb")["url"] ? _cao("post_default_thumb")["url"] : get_template_directory_uri() . "/assets/images/thumb/1.jpg";
	$rand = mt_rand(1, 10);
	return get_template_directory_uri() . "/assets/images/thumb/" . $rand . ".jpg";
}
function _the_theme_thumb_full()
{
	return get_template_directory_uri() . "/assets/images/thumb/full.jpg";
}
function _the_loader_img()
{
	return get_template_directory_uri() . "/assets/images/loader/preloader.gif";
}
if (!function_exists("_get_post_thumbnail_url")) {
	function _get_post_thumbnail_url($post = null)
	{
		if ($post === null) {
			global $post;
		}
		if (has_post_thumbnail($post)) {
			$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), "full");
			$post_thumbnail_src = $image[0];
		} else {
			$post_thumbnail_src = '';
			@($output = preg_match_all("/<img.+src=['\"]([^'\"]+)['\"].*>/i", $post->post_content, $matches));
			if (!empty($matches[1][0])) {
				global $wpdb;
				$att = $wpdb->get_row($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid LIKE '%s'", $matches[1][0]));
				if ($att) {
					$post_thumbnail_src = $att->ID;
				} else {
					$post_thumbnail_src = $matches[1][0];
				}
			} else {
				$post_thumbnail_src = _the_theme_thumb();
			}
		}
		return $post_thumbnail_src;
	}
}
if (!function_exists("timthumb")) {
	function timthumb($src, $size = null, $set = null)
	{
		if (cao_is_gif()) {
			return $src;
		}
		$modular = _cao("thumbnail_handle");
		if (is_numeric($src)) {
			if ($modular == "timthumb_mi") {
				$src = image_downsize($src, "thumbnail");
			} else {
				$src = image_downsize($src, "full");
			}
			$src = $src[0];
		}
		if ($set == "original") {
			return $src;
		}
		if ($modular == "timthumb_php" || empty($modular) || $set == "tim") {
			return get_template_directory_uri() . "/timthumb.php?src=" . $src . "&h=" . $size["h"] . "&w=" . $size["w"] . "&zc=1&a=c&q=100&s=1";
		} else {
			if ($modular == "other") {
				$thumbnail_other = _cao("thumbnail_other", '');
				return $src . $thumbnail_other;
			} else {
				return $src;
			}
		}
	}
}
if (!function_exists("_get_post_timthumb_src")) {
	function _get_post_timthumb_src()
	{
		$thum_px = _cao("thumbnail-px");
		$img_w = $thum_px ? $thum_px["width"] : "300";
		$img_h = $thum_px ? $thum_px["height"] : "200";
		$src = timthumb(_get_post_thumbnail_url(), array("w" => $img_w, "h" => $img_h));
		return $src;
	}
}
function _str_cut($str, $start, $width, $trimmarker)
{
	$output = preg_replace("/^(?:[\\x00-\\x7F]|[\\xC0-\\xFF][\\x80-\\xBF]+){0," . $start . "}((?:[\\x00-\\x7F]|[\\xC0-\\xFF][\\x80-\\xBF]+){0," . $width . "}).*/s", "\\1", $str);
	return $output . $trimmarker;
}
function substr_ext($str, $start = 0, $length, $charset = "utf-8", $suffix = '')
{
	if (function_exists("mb_substr")) {
		return mb_substr($str, $start, $length, $charset) . $suffix;
	}
	if (function_exists("iconv_substr")) {
		return iconv_substr($str, $start, $length, $charset) . $suffix;
	}
	$re["utf-8"] = "/[\1-]|[?-?][?-?]|[?-?][?-?]{2}|[?-?][?-?]{3}/";
	$re["gb2312"] = "/[\1-]|[?-?][?-?]/";
	$re["gbk"] = "/[\1-]|[?-?][@-?]/";
	$re["big5"] = "/[\1-]|[?-?]([@-~]|?-?])/";
	preg_match_all($re[$charset], $str, $match);
	$slice = join('', array_slice($match[0], $start, $length));
	return $slice . $suffix;
}
function mi_str_encode($string)
{
	return $string;
	$len = strlen($string);
	$buf = '';
	for ($i = 0; $i < $len; $i = $i + 1) {
		if (ord($string[$i]) <= 127) {
			$buf .= $string[$i];
		} elseif (ord($string[$i]) < 192) {
			$buf .= "&#xfffd;";
		} elseif (ord($string[$i]) < 224) {
			$buf .= sprintf("&#%d;", ord($string[$i + 0]) + ord($string[$i + 1]));
			$i = $i + 1;
			$i += 1;
		} elseif (ord($string[$i]) < 240) {
			ord($string[$i + 2]);
			$buf .= sprintf("&#%d;", ord($string[$i + 0]) + ord($string[$i + 1]) + ord($string[$i + 2]));
			$i = $i + 2;
			$i += 2;
		} else {
			ord($string[$i + 2]);
			ord($string[$i + 3]);
			$buf .= sprintf("&#%d;", ord($string[$i + 0]) + ord($string[$i + 1]) + ord($string[$i + 2]) + ord($string[$i + 3]));
			$i = $i + 3;
			$i += 3;
		}
	}
	return $buf;
}
function draw_txt_to($card, $pos, $str, $iswrite, $font_file)
{
	$_str_h = $pos["top"];
	$fontsize = $pos["fontsize"];
	$width = $pos["width"];
	$margin_lift = $pos["left"];
	$hang_size = $pos["hang_size"];
	$temp_string = '';
	$tp = 0;
	$font_color = imagecolorallocate($card, $pos["color"][0], $pos["color"][1], $pos["color"][2]);
	$i = 0;
	$str = strip_tags(str_replace("&nbsp;", '', $str));
	while ($i < mb_strlen($str)) {
		$box = imagettfbbox($fontsize, 0, $font_file, mi_str_encode($temp_string));
		$_string_length = $box[2] - $box[0];
		$temptext = mb_substr($str, $i, 1);
		$temp = imagettfbbox($fontsize, 0, $font_file, mi_str_encode($temptext));
		if ($_string_length + $temp[2] - $temp[0] < $width) {
			$temp_string .= mb_substr($str, $i, 1);
			if ($i == mb_strlen($str) - 1) {
				$_str_h = $_str_h + $hang_size;
				$_str_h += $hang_size;
				$tp = $tp + 1;
				if ($iswrite) {
					imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, mi_str_encode($temp_string));
				}
			}
		} else {
			$texts = mb_substr($str, $i, 1);
			$isfuhao = preg_match("/[\\pP]/u", $texts) ? true : false;
			if ($isfuhao) {
				$temp_string .= $texts;
				$f = mb_substr($str, $i + 1, 1);
				$fh = preg_match("/[\\pP]/u", $f) ? true : false;
				if ($fh) {
					$temp_string .= $f;
					$i = $i + 1;
				}
			} else {
				$i = $i + -1;
			}
			$tmp_str_len = mb_strlen($temp_string);
			$s = mb_substr($temp_string, $tmp_str_len - 1, 1);
			if (is_firstfuhao($s)) {
				$temp_string = rtrim($temp_string, $s);
				$i = $i + -1;
			}
			$_str_h = $_str_h + $hang_size;
			$_str_h += $hang_size;
			$tp = $tp + 1;
			if ($iswrite) {
				imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, mi_str_encode($temp_string));
			}
			$temp_string = '';
		}
		$i = $i + 1;
	}
	return $tp * $hang_size;
}
function is_firstfuhao($str)
{
	$fuhaos = array("0" => "\"", "1" => "“", "2" => "'", "3" => "<", "4" => "《");
	return in_array($str, $fuhaos);
}
function create_bigger_image($post_id, $date, $title, $content, $head_img, $qrcode_img = null, $author, $category, $modified)
{
	$im = imagecreatetruecolor(800, 1059);
	$white = imagecolorallocate($im, 255, 255, 255);
	$gray = imagecolorallocate($im, 200, 200, 200);
	$red = imagecolorallocate($im, 240, 66, 66);
	$foot_text_color = imagecolorallocate($im, 6, 39, 67);
	$black = imagecolorallocate($im, 0, 0, 0);
	$title_text_color = imagecolorallocate($im, 255, 51, 51);
	$english_font = get_template_directory() . "/assets/fonts/share/Montserrat-Regular.ttf";
	$chinese_font = get_template_directory() . "/assets/fonts/share/MFShangYa_Regular.otf";
	$chinese_font_2 = get_template_directory() . "/assets/fonts/share/hanyixizhongyuan.ttf";
	imagefill($im, 0, 0, $white);
	$head_img = imagecreatefromstring(file_get_contents(timthumb($head_img, array("w" => 800, "h" => "520"), "tim")));
	imagecopy($im, $head_img, 0, 0, 0, 0, 800, 520);
	$day = $date["day"];
	$day_width = imagettfbbox(80, 0, $english_font, $day);
	$day_width = abs($day_width[2] - $day_width[0]);
	$year = $date["year"];
	$year_width = imagettfbbox(24, 0, $english_font, $year);
	$year_width = abs($year_width[2] - $year_width[0]);
	$day_left = ($year_width - $day_width) / 2;
	imagettftext($im, 80, 0, 50 + $day_left, 420, $white, $english_font, $day);
	imageline($im, 50, 440, 50 + $year_width, 440, $white);
	imagettftext($im, 24, 0, 50, 480, $white, $english_font, $year);
	$title = mi_str_encode($title);
	$title_conf = array("color" => array("0" => 52, "1" => 73, "2" => 94), "fontsize" => 28, "width" => 680, "left" => 60, "top" => 540, "hang_size" => 24);
	draw_txt_to($im, $title_conf, $title, true, $chinese_font);
	$des_conf = array("color" => array("0" => 99, "1" => 99, "2" => 99), "fontsize" => 20, "width" => 680, "left" => 60, "top" => 660, "hang_size" => 18);
	draw_txt_to($im, $des_conf, $content, true, $chinese_font_2);
	$style = array();
	imagesetstyle($im, $style);
	imageline($im, 0, 780, 800, 780, $gray);
	$foot_text = _cao("poster_desc");
	$foot_text = $foot_text ? $foot_text : get_bloginfo("description");
	$foot_text = mi_str_encode($foot_text);
	$poster_logo = _cao("poster_logo");
	if ($poster_logo) {
		$logo_img = $poster_logo;
	} else {
		$site_logo = _cao("site_logo");
		if ($site_logo) {
			$logo_img = _cao("site_logo");
		} else {
			$logo_img = '';
		}
	}
	$logo_img = imagecreatefromstring(file_get_contents(timthumb($logo_img, array("w" => 250, "h" => 50), "tim")));
	if ($qrcode_img) {
		$foot_text_width = imagettfbbox(20, 0, $chinese_font, $foot_text);
		$foot_text_width = abs($foot_text_width[2] - $foot_text_width[0]);
		$foot_text_left = 200 - $foot_text_width / 2;
		imagecopy($im, $logo_img, 80, 930, 0, 0, 250, 50);
		imagettftext($im, 20, 0, $foot_text_left, 890, $foot_text_color, $chinese_font_2, $foot_text);
		$qrcode_str = file_get_contents($qrcode_img);
		$qrcode_size = getimagesizefromstring($qrcode_str);
		$qrcode_img = imagecreatefromstring($qrcode_str);
		imagecopyresized($im, $qrcode_img, 520, 800, 0, 0, 240, 240, $qrcode_size[0], $qrcode_size[1]);
	} else {
		$foot_text_width = imagettfbbox(20, 0, $chinese_font, $foot_text);
		$foot_text_width = abs($foot_text_width[2] - $foot_text_width[0]);
		$foot_text_left = 400 - $foot_text_width / 2;
		imagecopy($im, $logo_img, 280, 950, 0, 0, 240, 50);
		imagettftext($im, 20, 0, $foot_text_left, 1240, $foot_text_color, $chinese_font_2, $foot_text);
	}
	$upload_dir = wp_upload_dir();
	$poster_dir = $upload_dir["basedir"] . "/posterimg";
	if (!is_dir($poster_dir)) {
		wp_mkdir_p($poster_dir);
	}
	$filename = "/poster-" . $post_id . ".png";
	$file = $poster_dir . $filename;
	imagepng($im, $file);
	require_once ABSPATH . "wp-admin/includes/image.php";
	require_once ABSPATH . "wp-admin/includes/file.php";
	require_once ABSPATH . "wp-admin/includes/media.php";
	$src = $upload_dir["baseurl"] . "/posterimg" . $filename;
	error_reporting(0);
	imagedestroy($im);
	if (is_wp_error($src)) {
		return false;
	}
	if (_cao("disabled_wp_cdn") && _cao("_wp_cdn_domain")) {
		$src = str_replace(_cao("_wp_cdn_domain"), esc_url(home_url("/")), $src);
	}
	return $src;
}
function _autu_post_haibao($post_id)
{
	$type = get_post_type($post_id);
	if ("post" == $type) {
		delete_post_meta($post_id, "bigger_cover");
	}
}
add_action("save_post", "_autu_post_haibao");
function get_bigger_img()
{
	$post_id = sanitize_text_field($_POST["id"]);
	if (wp_verify_nonce($_POST["nonce"], "mi-create-bigger-image-" . $post_id)) {
		get_the_time("d", $post_id);
		get_the_time("Y/m", $post_id);
		if (!_cao("autu_post_haibao", false)) {
			$this_bigger_cover = get_post_meta($post_id, "bigger_cover", true);
			if (_cao("disabled_wp_cdn") && _cao("_wp_cdn_domain")) {
				$this_bigger_cover = str_replace(_cao("_wp_cdn_domain"), esc_url(home_url("/")), $this_bigger_cover);
			}
			if ($this_bigger_cover) {
				$msg = array("s" => 200, "src" => $this_bigger_cover);
				echo json_encode($msg);
				exit(0);
			}
		}
		$date = array("day" => get_the_time("d", $post_id), "year" => get_the_time("Y/m", $post_id));
		$post_extend = get_post_meta($post_id, "post_extend", true);
		$post_extend = wp_parse_args((array) $xz_data[$xz_k], array("bigger_head_img" => '', "bigger_title" => '', "bigger_desc" => ''));
		$post_title = $post_extend["bigger_title"] ? $post_extend["bigger_title"] : get_the_title($post_id);
		$share_title = $post_extend["bigger_title"] ? $post_extend["bigger_title"] : get_the_title($post_id);
		$post_author_id = get_post($post_id)->post_author;
		$post_cat_id = get_the_category($post_id);
		$post_category = $post_extend["bigger_category"] ? $post_extend["bigger_category"] : $post_cat_id[0]->cat_name;
		$post_modified_id = get_post($post_id)->post_modified;
		$post_modified = $post_extend["bigger_modified"] ? $post_extend["bigger_modified"] : $post_modified_id;
		$title = substr_ext($post_title, 0, 28, "utf-8", '');
		$author = $post_author_id;
		$category = substr_ext($post_category, 0, 6, "utf-8", '');
		$modified = substr_ext($post_modified, 0, 10, "utf-8", '');
		$post = get_post($post_id);
		if ($post_extend["bigger_desc"]) {
			$content = $post_extend["bigger_desc"];
		} else {
			$content = $post->post_excerpt ? $post->post_excerpt : $post->post_content;
		}
		$content = substr_ext(strip_tags(strip_shortcodes($content)), 0, 46, "utf-8", "...");
		$share_content = "【" . $share_title . "】" . substr_ext(strip_tags(strip_shortcodes($content)), 0, 120, "utf-8", '');
		$content = str_replace(PHP_EOL, '', strip_tags(apply_filters("the_excerpt", $content)));
		if ($post_extend["bigger_head_img"]) {
			$att = wp_get_attachment_image_src($post_extend["bigger_head_img"], "full");
			$head_img = $att[0];
		} else {
			$head_img = _get_post_thumbnail_url($post);
		}
		$base_link = get_the_permalink($post_id);
		$userids = get_current_user_id();
		if ($userids > 0) {
			$afflink = cao_get_referral_link($userids, $base_link);
		} else {
			$afflink = $base_link;
		}
		$qrcode_img = get_template_directory_uri() . "/inc/plugins/qrcode.php?data=" . $afflink;
		$result = create_bigger_image($post_id, $date, $title, $content, $head_img, $qrcode_img, $author, $category, $modified);
		if ($result) {
			$pic = "&pic=" . urlencode($result);
			if (get_post_meta($post_id, "bigger_cover", true)) {
				update_post_meta($post_id, "bigger_cover", $result);
			} else {
				add_post_meta($post_id, "bigger_cover", $result);
			}
			$msg = array("s" => 200, "src" => $result);
		} else {
			$msg = array("s" => 404, "m" => "封面生成失败，请稍后再试！");
		}
	} else {
		$msg = array("s" => 404, "m" => "图片地址404错误");
	}
	echo json_encode($msg);
	exit(0);
}
add_action("wp_ajax_nopriv_create-bigger-image", "get_bigger_img");
add_action("wp_ajax_create-bigger-image", "get_bigger_img");
function _excerpt_length($length)
{
	return _cao("_site_excerpt_length", "42");
}
add_filter("excerpt_length", "_excerpt_length");
function _get_excerpt($limit = 40, $after = "...")
{
	$excerpt = get_the_excerpt();
	$limit = _cao("_site_excerpt_length", "42");
	if (mb_strlen($excerpt) > $limit) {
		return _str_cut(strip_tags($excerpt), 0, $limit, $after);
	} else {
		return $excerpt;
	}
}
function _get_category_tags($args)
{
	global $wpdb;
	$tags = $wpdb->get_results("\r\n        SELECT DISTINCT terms2.term_id as tag_id, terms2.name as tag_name\r\n        FROM\r\n            {$wpdb->posts} as p1\r\n            LEFT JOIN {$wpdb->term_relationships} as r1 ON p1.ID = r1.object_ID\r\n            LEFT JOIN {$wpdb->term_taxonomy} as t1 ON r1.term_taxonomy_id = t1.term_taxonomy_id\r\n            LEFT JOIN {$wpdb->terms} as terms1 ON t1.term_id = terms1.term_id,\r\n\r\n            {$wpdb->posts} as p2\r\n            LEFT JOIN {$wpdb->term_relationships} as r2 ON p2.ID = r2.object_ID\r\n            LEFT JOIN {$wpdb->term_taxonomy} as t2 ON r2.term_taxonomy_id = t2.term_taxonomy_id\r\n            LEFT JOIN {$wpdb->terms} as terms2 ON t2.term_id = terms2.term_id\r\n        WHERE\r\n            t1.taxonomy = 'category' AND p1.post_status = 'publish' AND terms1.term_id IN (" . $args["categories"] . ") AND\r\n            t2.taxonomy = 'post_tag' AND p2.post_status = 'publish'\r\n            AND p1.ID = p2.ID\r\n        ORDER by tag_name LIMIT 10\r\n    ");
	$count = 0;
	if ($tags) {
		foreach ($tags as $tag) {
			$mytag[$count] = get_term_by("id", $tag->tag_id, "post_tag");
			$count++;
		}
	} else {
		$mytag = null;
	}
	return $mytag;
}
function _get_post_comments($before = "<i class=\"fa fa-comments-o\"></i> ", $after = '')
{
	return $before . get_comments_number("0", "1", "%") . $after;
}
function _get_post_time()
{
	return _timeago(get_gmt_from_date(get_the_time("Y-m-d G:i:s")));
}
function cao_comment($comment, $args, $depth)
{
	$GLOBALS["comment"] = $comment;
	if ("pingback" == $comment->comment_type || "trackback" == $comment->comment_type) {
		echo "\r\n  <li id=\"comment-";
		comment_ID();
		echo "\" ";
		comment_class();
		echo ">\r\n    <div class=\"comment-body\">\r\n      ";
		esc_html_e("Pingback:", "cao");
		echo " ";
		comment_author_link();
		echo " ";
		edit_comment_link(esc_html__("编辑", "cao"), "<span class=\"edit-link\">", "</span>");
		echo "    </div>\r\n\r\n  ";
	} else {
		echo "\r\n  <li id=\"comment-";
		comment_ID();
		echo "\" ";
		comment_class(empty($args["has_children"]) ? '' : "parent");
		echo ">\r\n    <article id=\"div-comment-";
		comment_ID();
		echo "\" class=\"comment-wrapper u-clearfix\" itemscope itemtype=\"https://schema.org/Comment\">\r\n      <div class=\"comment-author-avatar vcard\">\r\n        ";
		echo get_avatar($comment->comment_author_email);
		echo "      </div>\r\n\r\n      <div class=\"comment-content\">\r\n        <div class=\"comment-author-name vcard\" itemprop=\"author\">\r\n          ";
		$CaoUser = new CaoUser($comment->user_id);
		if ($CaoUser->vip_status()) {
			$vip_name_class = "fn vip";
		} else {
			$vip_name_class = "fn";
		}
		printf("<cite class=\"%s\"><i class=\"fa fa-diamond\"></i> %s</cite>", $vip_name_class, $CaoUser->vip_name() . " " . get_comment_author_link());
		echo "        </div>\r\n\r\n        <div class=\"comment-metadata\">\r\n          <time datetime=\"";
		comment_time("c");
		echo "\" itemprop=\"datePublished\">\r\n            ";
		printf(_x("%1\$s at %2\$s", "1: date, 2: time", "cao"), get_comment_date(), get_comment_time());
		echo "          </time>\r\n\r\n          ";
		edit_comment_link(esc_html__("编辑", "cao"), " <span class=\"edit-link\">", "</span>");
		comment_reply_link(array_merge($args, array("add_below" => "div-comment", "depth" => $depth, "max_depth" => $args["max_depth"], "before" => "<span class=\"reply-link\">", "after" => "</span>")));
		echo "        </div>\r\n\r\n        <div class=\"comment-body\" itemprop=\"comment\">\r\n          ";
		comment_text();
		echo "        </div>\r\n\r\n        ";
		if ("0" == $comment->comment_approved) {
			echo "          <p class=\"comment-awaiting-moderation\">";
			esc_html_e("你的评论正在等待审核.", "cao");
			echo "</p>\r\n        ";
		}
		echo "      </div>\r\n    </article> ";
	}
}
if (!function_exists("_paging")) {
	function _paging()
	{
		global $wp_query;
		$total = $wp_query->max_num_pages;
		$big = 999999999;
		if ($total > 1) {
			if (!($current_page = get_query_var("paged"))) {
				$current_page = 1;
			}
			if (get_option("permalink_structure")) {
				$format = "page/%#%/";
			} else {
				$format = "&paged=%#%";
			}
			echo "<div class=\"col-12\"><div class=\"numeric-pagination\">";
			echo paginate_links(array("base" => str_replace($big, "%#%", esc_url(get_pagenum_link($big))), "format" => $format, "current" => max(1, get_query_var("paged")), "total" => $total, "mid_size" => 3, "type" => "list", "prev_text" => "<i class=\"mdi mdi-chevron-left\"></i>", "next_text" => "<i class=\"mdi mdi-chevron-right\"></i>"));
			echo "</div></div>";
		}
	}
}
function cao_the_pagenavi($total_count, $number_per_page = 15, $paged, $the_url)
{
	$current_page = $paged;
	$base_url = add_query_arg($_GET, $the_url);
	$total_pages = ceil($total_count / $number_per_page);
	$first_page_url = $base_url . "&amp;paged=1";
	$last_page_url = $base_url . "&amp;paged=" . $total_pages;
	if ($current_page > 1 && $current_page < $total_pages) {
		$prev_page = $current_page - 1;
		$prev_page_url = $base_url . "&amp;paged=" . $prev_page;
		$next_page = $current_page + 1;
		$next_page_url = $base_url . "&amp;paged=" . $next_page;
	} else {
		if ($current_page == 1) {
			$prev_page_url = "#";
			$first_page_url = "#";
			if ($total_pages > 1) {
				$next_page = $current_page + 1;
				$next_page_url = $base_url . "&amp;paged=" . $next_page;
			} else {
				$next_page_url = "#";
				$class = "class=\"disabled\"";
			}
		} elseif ($current_page == $total_pages) {
			$prev_page = $current_page - 1;
			$prev_page_url = $base_url . "&amp;paged=" . $prev_page;
			$next_page_url = "#";
			$last_page_url = "#";
		}
	}
	echo "    <div class=\"cao-pagination pagination-area\">\r\n        <nav aria-label=\"Page navigation\">\r\n          <ul class=\"pagination cao-pagination\">\r\n            <!-- <li><span>共";
	echo "条</span></li> -->\r\n            <li>\r\n              <a href=\"";
	echo $first_page_url;
	echo "\" aria-label=\"Previous\">\r\n                <span aria-hidden=\"true\">&laquo;</span>\r\n              </a>\r\n            </li>\r\n            <li><a href=\"";
	echo $prev_page_url;
	echo "\">上一页</a></li>\r\n            <li><span>第";
	echo $current_page;
	echo "页,共";
	echo $total_pages;
	echo "页</span></li>\r\n            <li><a href=\"";
	echo $next_page_url;
	echo "\">下一页</a></li>\r\n            <li>\r\n              <a href=\"";
	echo $last_page_url;
	echo "\" aria-label=\"Next\">\r\n                <span aria-hidden=\"true\">&raquo;</span>\r\n              </a>\r\n            </li>\r\n          </ul>\r\n        </nav>\r\n\r\n    </div>\r\n    ";
}
function cao_admin_pagenavi($total_count, $number_per_page = 20)
{
	$current_page = isset($_GET["paged"]) ? $_GET["paged"] : 1;
	if (isset($_GET["paged"])) {
		unset($_GET["paged"]);
	}
	$base_url = add_query_arg($_GET, admin_url("admin.php"));
	$total_pages = ceil($total_count . $number_per_page);
	$first_page_url = $base_url . "&amp;paged=1";
	$last_page_url = $base_url . "&amp;paged=" . $total_pages;
	if ($current_page > 1 && $current_page < $total_pages) {
		$prev_page = $current_page - 1;
		$prev_page_url = $base_url . "&amp;paged=" . $prev_page;
		$next_page = $current_page + 1;
		$next_page_url = $base_url . "&amp;paged=" . $next_page;
	} else {
		if ($current_page == 1) {
			$prev_page_url = "#";
			$first_page_url = "#";
			if ($total_pages > 1) {
				$next_page = $current_page + 1;
				$next_page_url = $base_url . "&amp;paged=" . $next_page;
			} else {
				$next_page_url = "#";
			}
		} elseif ($current_page == $total_pages) {
			$prev_page = $current_page - 1;
			$prev_page_url = $base_url . "&amp;paged=" . $prev_page;
			$next_page_url = "#";
			$last_page_url = "#";
		}
	}
	echo "    <div class=\"tablenav\">\r\n        <div class=\"tablenav-pages\">\r\n            <span class=\"displaying-num \">每页 ";
	echo $number_per_page;
	echo " 共 ";
	echo $total_count;
	echo "</span>\r\n            <span class=\"pagination-links\">\r\n                <a class=\"first-page button ";
	if ($current_page == 1) {
		echo "disabled";
	}
	echo "\" title=\"前往第一页\" href=\"";
	echo $first_page_url;
	echo "\">«</a>\r\n                <a class=\"prev-page button ";
	if ($current_page == 1) {
		echo "disabled";
	}
	echo "\" title=\"前往上一页\" href=\"";
	echo $prev_page_url;
	echo "\">‹</a>\r\n                <span class=\"paging-input \">第 ";
	echo $current_page;
	echo " 页，共 <span class=\"total-pages\">";
	echo $total_pages;
	echo "</span> 页</span>\r\n                <a class=\"next-page button ";
	if ($current_page == $total_pages) {
		echo "disabled";
	}
	echo "\" title=\"前往下一页\" href=\"";
	echo $next_page_url;
	echo "\">›</a>\r\n                <a class=\"last-page button ";
	if ($current_page == $total_pages) {
		echo "disabled";
	}
	echo "\" title=\"前往最后一页\" href=\"";
	echo $last_page_url;
	echo "\">»</a>\r\n            </span>\r\n        </div>\r\n        <br class=\"clear\">\r\n    </div>\r\n    ";
}
add_action("init", "go_functionality_urls");
function go_functionality_urls()
{
	add_rewrite_rule("^go", "index.php?go=1", "top");
}
add_action("query_vars", "go_add_query_vars");
function go_add_query_vars($public_query_vars)
{
	$public_query_vars[] = "go";
	return $public_query_vars;
}
add_action("template_redirect", "go_template_redirect");
function go_template_redirect()
{
	global $wp;
	global $wp_query;
	$shangche_page = strtolower(get_query_var("go"));
	if ($shangche_page == "1") {
		$template = TEMPLATEPATH . "/inc/go.php";
		load_template($template);
		exit;
	}
}
function _download_file($file_dir)
{
	if (substr($file_dir, 0, 7) == "http://" || substr($file_dir, 0, 8) == "https://" || substr($file_dir, 0, 10) == "thunder://" || substr($file_dir, 0, 7) == "magnet:" || substr($file_dir, 0, 5) == "ed2k:") {
		$file_path = chop($file_dir);
		echo "<script type='text/javascript'>window.location='{$file_path}';setTimeout(function(){window.close()},2000)</script>";
		exit;
	}
	$file_dir = ABSPATH . "/" . chop($file_dir);
	if (!file_exists($file_dir)) {
		header("HTTP/1.1 404 NOT FOUND");
		return false;
	}
	$pathinfoarr = pathinfo($file_dir);
	$file_name = time() . mt_rand(1000, 9999) . "." . $pathinfoarr["extension"];
	$file = fopen($file_dir, "rb");
	header("Content-Description: File Transfer");
	Header("Content-type: application/octet-stream");
	Header("Accept-Ranges: bytes");
	Header("Accept-Length: " . filesize($file_dir));
	Header("Content-Disposition: attachment; filename=" . $file_name);
	echo fread($file, filesize($file_dir));
	fclose($file);
	exit;
}
function cao_get_referral_link($user_id = 0, $base_link = '')
{
	if (!$base_link) {
		$base_link = home_url();
	}
	if (!$user_id) {
		$user_id = get_current_user_id();
	}
	return add_query_arg(array("ref" => $user_id), $base_link);
}
function cao_retrieve_referral_keyword()
{
	if (!session_id()) {
		session_start();
	}
	$ref_from = isset($_SESSION["cao_from_user_id"]) ? absint($_SESSION["cao_from_user_id"]) : 0;
	if (isset($_REQUEST["ref"]) && $ref_from == 0) {
		$ref = absint($_REQUEST["ref"]);
		$from_user_id = $ref;
		$_SESSION["cao_from_user_id"] = $from_user_id;
	}
}
add_action("template_redirect", "cao_retrieve_referral_keyword");
add_action("admin_menu", "cao_retrieve_referral_keyword");
function _cao_add_follow_user($uid = '', $to_uid = '')
{
	$_meta_key = "follow_user";
	if (get_userdata($to_uid) == false) {
		return "false";
	}
	$old_follow = get_user_meta($uid, $_meta_key, true);
	if (is_array($old_follow)) {
		$new_follow = $old_follow;
	} else {
		$new_follow = array(0);
	}
	if (!in_array($to_uid, $new_follow)) {
		array_push($new_follow, $to_uid);
	}
	return update_user_meta($uid, $_meta_key, $new_follow);
}
function _cao_del_follow_user($uid = '', $to_uid = '')
{
	$_meta_key = "follow_user";
	if (get_userdata($to_uid) == false) {
		return false;
	}
	$follow_users = get_user_meta($uid, $_meta_key, true);
	if (!is_array($follow_users)) {
		return false;
	}
	if (!in_array($to_uid, $follow_users)) {
		return false;
	}
	foreach ($follow_users as $key => $user_id) {
		if ($user_id == $to_uid) {
			unset($follow_users[$key]);
			break;
		}
	}
	return update_user_meta($uid, $_meta_key, $follow_users);
}
function _cao_add_follow_post($uid = '', $to_post = '')
{
	$_meta_key = "follow_post";
	$to_post = (int) $to_post;
	if (get_post_status($to_post) === false) {
		return "false";
	}
	$old_follow = get_user_meta($uid, $_meta_key, true);
	if (is_array($old_follow)) {
		$new_follow = $old_follow;
	} else {
		$new_follow = array(0);
	}
	if (!in_array($to_post, $new_follow)) {
		array_push($new_follow, $to_post);
	}
	return update_user_meta($uid, $_meta_key, $new_follow);
}
function is_get_post_fav($post_id)
{
	$user_id = get_current_user_id();
	if (!$user_id) {
		return false;
	}
	$old_follow = get_user_meta($user_id, "follow_post", true);
	if (empty($old_follow) || !is_array($old_follow)) {
		return false;
	}
	if (in_array($post_id, $old_follow)) {
		return true;
	} else {
		return false;
	}
}
function _cao_del_follow_post($uid = '', $to_post = '')
{
	$_meta_key = "follow_post";
	$to_post = (int) $to_post;
	if (get_post_status($to_post) === false) {
		return "false";
	}
	$follow_users = get_user_meta($uid, $_meta_key, true);
	if (!is_array($follow_users)) {
		return false;
	}
	if (!in_array($to_post, $follow_users)) {
		return false;
	}
	foreach ($follow_users as $key => $user_id) {
		if ($user_id == $to_post) {
			unset($follow_users[$key]);
			break;
		}
	}
	return update_user_meta($uid, $_meta_key, $follow_users);
}
function _cao_user_is_qiandao($users_id = 0)
{
	global $current_user;
	if (!is_user_logged_in()) {
		return false;
	}
	$uid = !$users_id ? $current_user->ID : $users_id;
	$_meta_key = "cao_qiandao_time";
	$this_user_qiandao_time = get_user_meta($uid, $_meta_key, true) > 0 ? get_user_meta($uid, $_meta_key, true) : 0;
	$getTime = getTime();
	$thenTime = time();
	if ($getTime["star"] < $this_user_qiandao_time && $getTime["end"] > $this_user_qiandao_time) {
		return true;
	}
	return false;
}
function add_to_user_bonus($this_user_id = 0, $charge_money = 0)
{
	if (!$this_user_id || !_cao("is_charge_ref_float", false)) {
		return false;
	}
	$form_uid = get_user_meta($this_user_id, "cao_ref_from", true);
	$cao_ref_from_uid = $form_uid ? (int) $form_uid : 0;
	$charge_rate = (int) _cao("site_change_rate");
	if ($cao_ref_from_uid) {
		$site_novip_ref_float = _cao("site_novip_ref_float");
		$site_vip_ref_float = _cao("site_vip_ref_float");
		$CaoUser = new CaoUser($cao_ref_from_uid);
		if ($CaoUser->vip_status()) {
			$amount = sprintf("%0.2f", $charge_money * $site_vip_ref_float / $charge_rate);
		} else {
			$amount = sprintf("%0.2f", $charge_money * $site_novip_ref_float / $charge_rate);
		}
		$Reflog = new Reflog($cao_ref_from_uid);
		$Reflog->add_total_bonus($amount);
	}
	return;
}
function add_post_author_bonus($author_id = 0, $pay_price = 0)
{
	if (!$author_id || !_cao("site_postpay_ref_float", false)) {
		return false;
	}
	$charge_rate = (int) _cao("site_change_rate");
	$charge_ref_float = _cao("site_postpay_ref_float");
	$charge_money = sprintf("%0.2f", $pay_price / $charge_rate);
	$yongjin = sprintf("%0.2f", $charge_money * $charge_ref_float);
	$Reflog = new Reflog($author_id);
	$Reflog->add_total_bonus($yongjin);
	return;
}
function cao_only_selected_category($query)
{
	if (!is_admin() && $query->is_main_query()) {
		$order = !empty($_GET["order"]) ? $_GET["order"] : null;
		$cat = !empty($_GET["cat"]) ? (int) $_GET["cat"] : null;
		$cao_type = !empty($_GET["cao_type"]) ? (int) $_GET["cao_type"] : null;
		$custom_meta_arr = !empty($_GET) ? $_GET : null;
		if ($order) {
			if ($order == "hot") {
				$query->set("meta_key", "views");
				$query->set("orderby", "meta_value_num");
				$query->set("order", "DESC");
			} else {
				$query->set("orderby", $order);
			}
		}
		if ($cat) {
			$term_id = (int) $cat;
			$tax_query = array(array("taxonomy" => "category", "field" => "term_id", "operator" => "IN", "terms" => array($term_id)));
			$query->set("tax_query", $tax_query);
		}
		$custom_meta_query = array();
		if ($cao_type) {
			switch ($cao_type) {
				case "1":
					$_type_meta_key = "cao_price";
					$_type_value = "0";
					$_type_compare = "=";
					break;
				case "2":
					$_type_meta_key = "cao_price";
					$_type_value = "0";
					$_type_compare = ">";
					break;
				case "3":
					$_type_meta_key = "cao_vip_rate";
					$_type_value = "0";
					$_type_compare = "=";
					break;
				case "4":
					$_type_meta_key = "cao_vip_rate";
					$_type_value = "1";
					$_type_compare = "!=";
					break;
				default:
					break;
			}
			$type_meta_query = array(array("key" => $_type_meta_key, "value" => $_type_value, "compare" => $_type_compare));
			array_push($custom_meta_query, $type_meta_query);
		}
		if ($custom_meta_arr && _cao("is_custom_post_meta_opt", "0") && _cao("custom_post_meta_opt", "0")) {
			$custom_post_meta_opt = _cao("custom_post_meta_opt", "0");
			foreach ($custom_post_meta_opt as $filter) {
				$_meta_key = $filter["meta_ua"];
				if (array_key_exists($_meta_key, $custom_meta_arr) && $_GET[$_meta_key] != "all") {
					$opt_meta_query = array(array("key" => $_meta_key, "value" => $_GET[$_meta_key], "compare" => "="));
					array_push($custom_meta_query, $opt_meta_query);
				}
			}
		}
		$query->set("meta_query", $custom_meta_query);
	}
	return $query;
}
add_filter("pre_get_posts", "cao_only_selected_category");
if (_cao("is_all_publish_posts", false)) {
	if (current_user_can("contributor") && !current_user_can("upload_files")) {
		add_action("admin_init", "allow_contributor_uploads");
	}
	function allow_contributor_uploads()
	{
		$contributor = get_role("contributor");
		$contributor->add_cap("upload_files");
	}
}
function dimox_breadcrumbs()
{
	global $post;
	if (is_single() && !_cao("is_archive_crumbs") && !is_attachment()) {
		$categorys = get_the_category();
		$category = $categorys[0];
		return "当前位置：<a href=\"" . get_bloginfo("url") . "\">" . get_bloginfo("name") . "</a> <small>></small> " . get_category_parents($category->term_id, true, " <small>></small> ") . get_the_title();
	} else {
		if (is_attachment()) {
			$parent = get_post($post->post_parent);
			$cat = get_the_category($parent->ID);
			if (!$cat) {
				return false;
			}
			$cat = $cat[0];
			return "当前位置：<a href=\"" . get_bloginfo("url") . "\">" . get_bloginfo("name") . "</a> <small>></small> " . get_category_parents($cat->term_id, true, " <small>></small> ") . get_the_title();
		} else {
			return false;
		}
	}
}
function _sendMail($email, $title, $message)
{
	$headers = array("Content-Type: text/html; charset=UTF-8");
	$message = tpl_email_html($email, $title, $message);
	$send_email = wp_mail($email, $title, $message, $headers);
	if ($send_email) {
		return true;
	}
	return false;
}
function tpl_email_html($user, $title, $desc)
{
	date_default_timezone_set("Asia/Shanghai");
	$html = "<div style=\"background-color:#eef2fa;border:1px solid #d8e3e8;color: #111;padding:0 15px;-moz-border-radius:5px;-webkit-border-radius:5px;-khtml-border-radius:5px;\">";
	$html .= "<p style=\"font-weight: bold;color: #2196F3;font-size: 18px;\">" . $title . "</p>";
	$html .= sprintf("<p>您好，%s</p>", $user);
	$html .= sprintf("<p>内容: %s</p>", $desc);
	$html .= sprintf("<p>时间: %s</p>", date("Y-m-d H:i:s"));
	$a_href = "<a href=\"" . home_url() . "\">" . get_bloginfo("name") . "</a>";
	$html .= sprintf("<p>官网： %s</p>", $a_href);
	$html .= "</div>";
	return $html;
}
function _target_blank()
{
	return _cao("target_blank") ? " target=\"_blank\"" : '';
}
add_filter("mce_buttons", "wp_add_next_page_button");
function wp_add_next_page_button($mce_buttons)
{
	$pos = array_search("wp_more", $mce_buttons, true);
	if ($pos !== false) {
		$tmp_buttons = array_slice($mce_buttons, 0, $pos + 1);
		$tmp_buttons[] = "wp_page";
		$mce_buttons = array_merge($tmp_buttons, array_slice($mce_buttons, $pos + 1));
	}
	return $mce_buttons;
}
function _the_cao_ads($name = '', $class = '')
{
	if (!_cao($name . "_s")) {
		return;
	}
	echo "<div class=\"site-ads ads-" . $class . "\">" . _cao($name) . "</div>";
}
function getTime()
{
	date_default_timezone_set("Asia/Shanghai");
	$str = date("Y-m-d", time()) . "0:0:0";
	$data["star"] = strtotime($str);
	$str = date("Y-m-d", time()) . "24:00:00";
	$data["end"] = strtotime($str);
	return $data;
}
function get_category_root_id($cat)
{
	$this_category = get_category($cat);
	while ($this_category->category_parent) {
		$this_category = get_category($this_category->category_parent);
	}
	return $this_category->term_id;
}
function get_category_deel($cat)
{
	$categories = get_terms("category", array("hide_empty" => 0, "parent" => 0));
	$get_term_children = get_term_children($cat_ID, "category");
}
function is_boosvip_status($user_id)
{
	$vip_type = get_user_meta($user_id, "cao_user_type", true);
	$vip_end_date = get_user_meta($user_id, "cao_vip_end_time", true);
	if ($vip_type == "vip" && $vip_end_date == "9999-09-09") {
		return true;
	}
	return false;
}
function _timeago($time)
{
	date_default_timezone_set("ETC/GMT");
	$time = strtotime($time);
	$difference = time() - $time;
	if (!_cao("post_is_timeago", "1")) {
		return date("Y-m-d", $time);
	}
	switch ($difference) {
		case $difference <= "1":
			$msg = "刚刚";
			break;
		case $difference > "1" && $difference <= "60":
			$msg = floor($difference) . "秒前";
			break;
		case $difference > "60" && $difference <= "3600":
			$msg = floor($difference / 60) . "分钟前";
			break;
		case $difference > "3600" && $difference <= "86400":
			$msg = floor($difference / 3600) . "小时前";
			break;
		case $difference > "86400" && $difference <= "2592000":
			$msg = floor($difference / 86400) . "天前";
			break;
		case $difference > "2592000":
			$msg = '' . date("Y-m-d", $time) . '';
			break;
	}
	return $msg;
}
function get_url_contents($url)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 60);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_URL, $url);
	$result = curl_exec($ch);
	if ($result === false) {
		echo "Curl error: " . curl_error($ch);
	}
	curl_close($ch);
	return $result;
}
function reset_password_message($message, $key)
{
	if (strpos($_POST["user_login"], "@")) {
		$user_data = get_user_by("email", trim($_POST["user_login"]));
	} else {
		$login = trim($_POST["user_login"]);
		$user_data = get_user_by("login", $login);
	}
	$user_login = $user_data->user_login;
	$msg = __("有人要求重设如下帐号的密码：") . "\r\n\r\n";
	$msg .= network_site_url() . "\r\n\r\n";
	$msg .= sprintf(__("用户名：%s"), $user_login) . "\r\n\r\n";
	$msg .= __("若这不是您本人要求的，请忽略本邮件，一切如常。") . "\r\n\r\n";
	$msg .= __("要重置您的密码，请打开下面的链接：") . "\r\n\r\n";
	$msg .= network_site_url("wp-login.php?action=rp&key={$key}&login=" . rawurlencode($user_login), "login");
	return $msg;
}
add_filter("retrieve_password_message", "reset_password_message", null, 2);
function ripro_custom_login_img()
{
	echo "<style type=\"text/css\">\r\nh1 a {background-image: url(" . _cao("site_logo") . ") !important; height: 50px !important;width: 150px !important;background-size: 150px !important;}\r\n</style>";
}
add_action("login_head", "ripro_custom_login_img");
function ripro_custom_loginlogo_url($url)
{
	return get_bloginfo("url");
}
add_filter("login_headerurl", "ripro_custom_loginlogo_url");
function is_site_shop_open()
{
	$is_close_site_shop = _cao("close_site_shop", "0");
	return !$is_close_site_shop;
}
function _cao_get_client_ip()
{
	if ($_SERVER["HTTP_CLIENT_IP"] && strcasecmp($_SERVER["HTTP_CLIENT_IP"], "unknown")) {
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	} elseif ($_SERVER["HTTP_X_FORWARDED_FOR"] && strcasecmp($_SERVER["HTTP_X_FORWARDED_FOR"], "unknown")) {
		$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	} elseif ($_SERVER["REMOTE_ADDR"] && strcasecmp($_SERVER["REMOTE_ADDR"], "unknown")) {
		$ip = $_SERVER["REMOTE_ADDR"];
	} elseif (isset($_SERVER["REMOTE_ADDR"]) && $_SERVER["REMOTE_ADDR"] && strcasecmp($_SERVER["REMOTE_ADDR"], "unknown")) {
		$ip = $_SERVER["REMOTE_ADDR"];
	} else {
		$ip = "unknown";
	}
	return $ip;
}
function _cao_get_pay_type_html()
{
	$alipay = false;
	$weixinpay = false;
	$alipay_type = 0;
	$wxpay_type = 0;
	if (_cao("is_codepay")) {
		$codepay = _cao("codepay");
		switch ($codepay["pay_mode"]) {
			case "all":
				$alipay = true;
				$alipay_type = 7;
				$weixinpay = true;
				$wxpay_type = 8;
				break;
			case "weixin":
				$weixinpay = true;
				$wxpay_type = 8;
				break;
			case "alipay":
				$alipay = true;
				$alipay_type = 7;
				break;
		}
	}
	if (_cao("is_payjs")) {
		$weixinpay = true;
		$wxpay_type = 4;
	}
	if (_cao("is_xunhupay")) {
		$weixinpay = true;
		$wxpay_type = 5;
	}
	if (_cao("is_xunhualipay")) {
		$alipay = true;
		$alipay_type = 6;
	}
	if (_cao("is_alipay")) {
		$alipay = true;
		$alipay_type = 1;
	}
	if (_cao("is_weixinpay")) {
		$weixinpay = true;
		$wxpay_type = 2;
	}
	$html = "<div class=\"pay-button-box\">";
	$is_user_logged_in = is_user_logged_in();
	$is_online_pay_status = _cao("is_online_pay_status", true);
	$is_online_pay_reta = _cao("is_online_pay_reta", true);
	if (!$is_user_logged_in || $is_user_logged_in && $is_online_pay_status && (cao_get_page_by_slug("user") != get_the_ID() || !_cao("is_pay_vip_dashed_zxzf"))) {
		if ($alipay) {
			$html .= "<div class=\"pay-item\" id=\"alipay\" data-type=\"" . $alipay_type . "\">";
			$html .= "<i class=\"alipay\"></i><span>支付宝</span>";
			$html .= "</div>";
		}
		if ($weixinpay) {
			$html .= "<div class=\"pay-item\" id=\"weixinpay\" data-type=\"" . $wxpay_type . "\">";
			$html .= "<i class=\"weixinpay\"></i><span>微信支付</span>";
			$html .= "</div>";
		}
	}
	if ($is_user_logged_in && (cao_get_page_by_slug("user") != get_the_ID() || !_cao("is_pay_vip_dashed_yec"))) {
		$html .= "<div class=\"pay-item\" id=\"yecpay\" data-type=\"9999\">";
		$html .= "<i class=\"yecpay\"></i><span>余额支付</span>";
		$html .= "</div>";
	}
	$html .= "</div>";
	if (cao_get_page_by_slug("user") != get_the_ID()) {
		if (!$is_user_logged_in && _cao("is_ripro_nologin_pay", "1")) {
			$html .= "<p style=\"font-size: 13px; padding: 0; margin: 0;\">当前为游客购买模式</p>";
		} else {
			$html .= "<p style=\"font-size: 13px; padding: 0; margin: 0;\">免费或" . _cao("site_vip_name") . "免费资源仅限余额支付</p>";
			if (!$is_online_pay_reta && $is_online_pay_status) {
				$html .= "<p style=\"font-size: 13px; padding: 0; margin: 0;\">仅余额支付享受折扣特权</p>";
			}
		}
	}
	return array("html" => $html, "alipay" => $alipay_type, "weixinpay" => $wxpay_type);
}
function cao_get_page_by_slug($slug)
{
	global $wpdb;
	$page_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_name = '{$slug}'");
	return $page_id;
}
function cao_get_post_downBtn($post_id = 0)
{
	if (_cao("is_nojs_downurl_blank")) {
		return "<a target=\"_blank\" href=\"" . esc_url(home_url("/go?post_id=" . $post_id)) . "\" class=\"go-downblank btn btn--secondary btn--block\"><i class=\"fa fa-cloud-download\"></i> 立即下载</a>";
	} else {
		return "<a target=\"_blank\" data-id=\"" . $post_id . "\" class=\"go-down btn btn--secondary btn--block\"><i class=\"fa fa-cloud-download\"></i> 立即下载</a>";
	}
}
function cao_theme_archive_title($title)
{
	if (is_category()) {
		$title = single_cat_title('', false);
	} elseif (is_tag()) {
		$title = single_tag_title('', false);
	} elseif (is_author()) {
		$title = "<span class=\"vcard\">" . get_the_author() . "</span>";
	} elseif (is_post_type_archive()) {
		$title = post_type_archive_title('', false);
	} elseif (is_tax()) {
		$title = single_term_title('', false);
	}
	return $title;
}
add_filter("get_the_archive_title", "cao_theme_archive_title");
function is_cao_site_list_blog()
{
	if (!session_id()) {
		session_start();
	}
	if (empty($_SESSION["is_blog_style"]) && _cao("site_list_style", "default") == "blog") {
		return true;
	} else {
		$retVal = !empty($_SESSION["is_blog_style"]) ? $_SESSION["is_blog_style"] : false;
		return $retVal;
	}
}
function cao_wp_die($title = '', $msg = '')
{
	$css = "<style type=\"text/css\">#error-page{margin-top:20vh;}h1{margin-top:-20px;text-align:center;padding-bottom:20px;}p{text-align:center;}p a{text-align:center;background:#555;padding:.714em 2em;text-decoration:none;color:#fff;border-radius:4px;}.p-none{text-align:unset;}</style>";
	wp_die($css . "<h1>" . $title . "</h1><p class=\"p-none\">" . $msg . "</p><br><p><a href=\"" . esc_url(home_url()) . "\">返回首页</a></p>", $title);
}
function is_weixin_view()
{
	if (strpos($_SERVER["HTTP_USER_AGENT"], "MicroMessenger") !== false) {
		return true;
	} else {
		return false;
	}
}