<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=ad';

if (is_submit_of('adsubmit'))
{
    $adid = intval($_POST['adid']);
    $_POST['title'] = self_substr(strip_html_tags(trim($_POST['title'])), 0, 50);
    if (empty($_POST['title']))
    {
        $_POST['title'] = 'AD' . data('ndHis');
    }

    //模板
    $html = '';
    $adcodes = array();
    switch($_POST['adcode']['type'])
    {
        case 'html':
            $adcodes['html'] = $_POST['adcode']['html'];
            $html = stripslashes($_POST['adcode']['html']);
            break;
        case 'flash':
            $adcodes['flashheight'] = floatval($_POST['adcode']['flashheight']);
            $adcodes['flashwidth'] = floatval($_POST['adcode']['flashwidth']);
            $adcodes['flashurl'] = $_POST['adcode']['flashurl'];

            $width = empty($adcodes['flashwidth']) ? '' : 'width="' . $adcodes['flashwidth'] . '"';
            $height = empty($adcodes['flashheight'])?'':'width="'.$adcodes['flashheight'] . '"';
            $html  = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" adcodebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,45,0" ' . $width . ' ' . $height . '>' . "\n";
            $html .= '<param name="movie" value="' . stripslashes($_POST['adcode']['flashurl']) . '" />' . "\n";
            $html .= '<param name="quality" value="high" />' . "\n";
            $html .= '<embed src="' . stripslashes($_POST['adcode']['flashurl']) . '" quality="high" pluginspage="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" ' . $width . ' ' . $height . '></embed>' . "\n";
            $html .= '</object>' . "\n";
            break;
        case 'image':
            $width = empty($adcodes['imageheight']) ? '' : 'width="' . $adcodes['imageheight'] . '"';
            $height = empty($adcodes['imagewidth']) ? '' : 'width="' . $adcodes['imagewidth'] . '"';
            $adcodes['imageheight'] = floatval($_POST['adcode']['imageheight']);
            $adcodes['imagewidth'] = floatval($_POST['adcode']['imagewidth']);
            $adcodes['imagesrc'] = $_POST['adcode']['imagesrc'];
            $adcodes['imageurl'] = $_POST['adcode']['imageurl'];
            $adcodes['imagealt'] = self_substr(strip_html_tags(trim($_POST['adcode']['imagealt'])), 0, 200);
            $html  = '<a href="' . $adcodes['imageurl'] . '" target="_blank"><img src="' . stripslashes($_POST['adcode']['imagesrc']) . '" ' . $width . ' ' . $height . ' border="0" alt="' . $adcodes['imagealt'] . '"></a>';
            break;
        case 'text':
            $adcodes['textcontent'] = strip_html_tags(trim($_POST['adcode']['textcontent']));
            $adcodes['texturl'] = $_POST['adcode']['texturl'];
            $adcodes['textsize'] = floatval($_POST['adcode']['textsize']);
            $size = empty($adcodes['textsize']) ? '' : 'style="font-size:' . $adcodes['textsize'] . 'px;"';
            $html  = '<a href="' . stripslashes($_POST['adcode']['texturl']) . '" target="_blank" ' . $size . '>' . $adcodes['textcontent'] . '</a>';
            break;
        default:
            break;
    }

    if (empty($adcodes))
    {
        throw_message('请检查必填选项是否填写完整！');
    }
    else
    {
        $adcodes['type'] = $_POST['adcode']['type'];
    }

    $data = array(
        'title' => $_POST['title'],
        'code' => addslashes(serialize(self_stripslashes($adcodes)))
    );

    if (empty($adid))
    {
        $adid = $globals['db']->insert(T('ad'), $data, TRUE);
    }
    else
    {
        $globals['db']->update(T('ad'), $data, array('adid' => $adid));
    }

    //写入模板
    $_tpl = __DATA__ . '/adtpl/' . $adid . '.html';
    if (!is_dir(__DATA__ . '/adtpl/'))
    {
        mk_dir(__DATA__ . '/adtpl/');
    }
    @file_put_contents($_tpl, $html);

    //缓存更新
    include_once(__INCLUDE__ . '/cache.inc.php');
    cache_ad();

    throw_message('操作成功！', $self);
}
elseif (is_submit_of('delsubmit'))
{
    include_once(__INCLUDE__ . '/admin.delete.inc.php');
    !empty($_POST['adids']) && delete_ad($_POST['adids'])
        ? throw_message('批量删除成功！', $self)
        : throw_message('不能批量删除！');
}

if (empty($_GET['op']))
{
    $list = array();
    $adlist = $globals['db']->select(T('ad'));
    foreach ($adlist as $key => $value)
    {
        $value['code'] = unserialize($value['code']);
        $list[] = $value;
    }
}
elseif ($_GET['op'] == 'add' || $_GET['op'] == 'edit')
{
    $_GET['adid'] = isset($_GET['adid']) && is_numeric($_GET['adid']) ? intval($_GET['adid']) : 0;

    $single = array();
    if ($_GET['adid'])
    {
        $single = $globals['db']->select(T('ad'), array('adid' => $_GET['adid']), '', TRUE);
    }

    if (empty($single))
    {
        //默认数据
        $single = array('adid' => 0, 'code'=>array('type' => 'html'));
    }
    else
    {
        $single['code'] = unserialize($single['code']);
    }

    //显示处理
    $adcodes = array($single['code']['type'] => ' selected');
}
elseif ($_GET['op'] == 'tpl')
{
    $adcode = strip_html_tags("<!--{template data/adtpl/$_GET[adid]}-->");
}
elseif ($_GET['op'] == 'js')
{
    $adcode = strip_html_tags("<script type=\"text/javascript\" src=\""
                                . $settings['siteurl']
                                . "/js.php?adid=$_GET[adid]\"></script>");
}
?>