<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }
$self = 'index.php?model=backup';

@set_time_limit(0);
$backup_dir = dirname(__FILE__) . '/backup';
if (!is_dir($backup_dir)) { mk_dir($backup_dir); }

$_GET = self_stripslashes($_GET);

$_tablenames = array();

if (!empty($_GET['tablenames']))
{
    if (is_array($_GET['tablenames']))
    {
        $_tablenames = $_GET['tablenames'];
        $_GET['tablenames'] = implode(',', $_GET['tablenames']);
    }
    else
    {
        $_tablenames = explode(',', $_GET['tablenames']);
    }
}

if (!empty($_GET['tablenames']))
{
    // 初始化使用到的变量
    $_GET['isstruct'] = empty($_GET['isstruct']) ? 0 : intval($_GET['isstruct']);
    $_GET['nowtable'] = empty($_GET['nowtable']) ? '' : trim($_GET['nowtable']);
    $_GET['page'] = isset($_GET['page']) ? intval($_GET['page']) : 0;
    $_GET['pagesize'] = isset($_GET['pagesize']) && is_numeric($_GET['pagesize']) ? intval($_GET['pagesize']) : 300;

    // 第一页的操作
    if(empty($_GET['nowtable']))
    {
        clear_dir($backup_dir);
        println('清空备份目录 ...');

        if ($_GET['isstruct'])
        {
            $backup_file = $backup_dir . "/tables_struct_" . substr(md5(time() . mt_rand(1000, 5000)), 0, 16) . '.sql';

            $fp = fopen($backup_file, "w");
            foreach($_tablenames as $t)
            {
                if (!ereg('session|member$', $t))
                {
                    fwrite($fp, "DROP TABLE IF EXISTS `$t`;\r\n\r\n");
                    $row = $globals['db']->executeReader('SHOW CREATE TABLE ' . $config['db_name'] . '.' . $t);
                    fwrite($fp, "" . $row[0]['create table'] . ";\r\n\r\n");
                }
            }
            fclose($fp);
            println('备份数据表结构信息完成.');

            $url = $self . '&pagesize=' . $_GET['pagesize'] . '&page=' . ++$_GET['page']
                 . '&isstruct=' . $_GET['isstruct'] . '&nowtable=' . $_tablenames[0]
                 . '&tablenames=' . $_GET['tablenames'];
            //dump($url);
            //exit;
            self_redirect($url, 1);
        }
    }
    else
    {
//dump($_GET);
//exit;
        include_once($globals['db']->getColumns($_GET['nowtable']));
        $columns = ${'table_' . $_GET['nowtable']};

        if ($_GET['page'] < 1) { $_GET['page'] = 1; }
        $start = ($_GET['page'] - 1) * $_GET['pagesize'];
        $filename = $backup_dir . '/' . $_GET['nowtable'] . '_' . $_GET['page'] . '_'
                  . substr(md5(time() . mt_rand(1000, 5000)), 0, 16) . '.sql';

        $params = new ArrayObject();
        $sql = 'SELECT * FROM ' . $_GET['nowtable'] . ' LIMIT ?, ?;';
        $params->append(new SqlParameter(1, intval($start), DB_PARAM_INT));
        $params->append(new SqlParameter(2, intval($_GET['pagesize']), DB_PARAM_INT));
        $list = $globals['db']->executeReader($sql, $params);
        if (!empty($list))
        {
            $count = count($list);
            $i = 0;

            $content = '';
            $_columns_string = 'INSERT INTO ' . $globals['db']->antiQuote($_GET['nowtable']) . ' (';

            for($i = 0; $i < $count; $i++)
            {
                $columns_string = $columns_values = $comma = '';

                foreach ($columns as $key => $value)
                {
                    $columns_string .= $comma . $globals['db']->antiQuote($key);
                    $columns_values .= $comma . $globals['db']->quote(replace_VBCRLF(addslashes($list[$i][$key])));
                    $comma = ', ';
                }

                $line = $_columns_string . $columns_string . ') VALUES (' . $columns_values . ');' . "\r\n";
                $content .= $line;
            }
            file_put_contents($filename, $content);
            println('第 ' . $_GET['page'] .  ' 次备份表 ' . $_GET['nowtable'] . ' 中的 ' . $count . ' 条数据！');
            println('正在进行下一次备份 ... ');
            //dump($url);
            //exit;
            $url = $self . '&pagesize=' . $_GET['pagesize'] . '&page=' . ++$_GET['page']
                 . '&isstruct=' . $_GET['isstruct'] . '&nowtable=' . $_GET['nowtable']
                 . '&tablenames=' . $_GET['tablenames'];
            self_redirect($url, 1);
        }
        else
        {
            println('第 ' . $_GET['page'] .  ' 次表 ' . $_GET['nowtable'] . ' 中没有数据。');
            println('正在进行下一次备份 ... ');
        }

        for ($i = 0; $i < count($_tablenames); $i++)
        {
            if ($_tablenames[$i] == $_GET['nowtable'])
            {
                if(isset($_tablenames[$i + 1]))
                {
                    $_GET['nowtable'] = $_tablenames[$i + 1];
                    $_GET['page'] = 0;
                    break;
                }
                else
                {
                    self_ob_clean();
                    println('所有数据备份完成！');
                    exit;
                }
            }
        }
        $url = $self . '&pagesize=' . $_GET['pagesize'] . '&page=' . ++$_GET['page']
             . '&isstruct=' . $_GET['isstruct'] . '&nowtable=' . $_GET['nowtable']
             . '&tablenames=' . $_GET['tablenames'];
        self_redirect($url, 1);
    }
}

function replace_VBCRLF($str)
{
    $str = str_replace("\r", "\\r", $str);
    $str = str_replace("\n", "\\n", $str);
    return $str;
}

$sycms_tables = array();
//$params = new ArrayObject();
//$sql = "SHOW TABLE STATUS LIKE ?;";
//$params->append(new SqlParameter(1, $config['db_table_prefix'] . '%', DB_PARAM_STR));
//$sycms_tables = $globals['db']->executeReader($sql, $params);

$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'ad');
$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'import');
$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'link');
$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'media');
$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'settings');
$sycms_tables[] = array('name' => $config['db_table_prefix'] . 'type');

?>