<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=ccapi_account';

require_once(__INCLUDE__ . '/ccapi.inc.php');

// 绑定资源库帐户
if (is_submit_of('bind'))
{
    $post = array(
                'password' => isset($_POST['sitepw']) ? $_POST['sitepw'] : '',
                'siteEmail' => isset($_POST['siteemail']) ? $_POST['siteemail'] : '',
                'siteUrl' => isset($_POST['siteurl']) ? $_POST['siteurl'] : '',
                'charset' => 'gbk'
            );
    import('http');
    $result = Http::quickGet('http://union.bokecc.com/maxphp/bind.bo', '', $post);

    if (is_numeric($result))
    {
        switch ($result){
            case '-1':
                $msg = '密码错误';
                break;
            case '-2':
                $msg = '没有这个用户';
                break;
            case '-3':
                $msg = '服务器端出现未知错误';
                break;
            case '-4':
                $msg = '域名个数超出最大限制';
                break;
            case '-5':
                $msg = '绑定域名不能为空';
                break;
        }
        throw_message($msg);
    }
    elseif ($result == '')
    {
        throw_message('服务器访问失败！');
    }
    else
    {
        $result = explode(',', $result);
    }

    $data = array();
    $data['sitename'] = urldecode($result[4]);
    $data['siteurl'] = urldecode($result[2]);
    $data['siteurl'] = (substr($data['siteurl'], -1) == '/') ? $data['siteurl'] : $data['siteurl'] . '/';
    $data['sitelogo'] = $result[5];
    $data['sitetype'] = $result[3];
    $data['siteemail'] = $post['siteEmail'];
    $data['ccid'] = $result[0];
    $data['password'] = $post['password'];
    $data['key'] = $result[1];
    save_array('ccapi_settings', $data);
    if ($result[6] == 1)
    {
        $msg = '添加新域名成功！';
    }
    elseif ($result[6] == 2)
    {
        $msg = '绑定旧域名成功！';
    }
    throw_message($msg, $self);
}
elseif (is_submit_of('unbind')) // 解除绑定
{
    @unlink(__DATA__ . '/ccapi_settings.cache.php');
    throw_message('成功解除绑定！', $self);
}
elseif (is_submit_of('edit')) // 解除绑定
{
    $sitetype = isset($_POST['sitetype']) && is_numeric($_POST['sitetype']) ? intval($_POST['sitetype']) : 0;
    $newpwd = isset($_POST['newpwd']) ? trim($_POST['newpwd']) : '';
    $newpwd2 = isset($_POST['newpwd2']) ? trim($_POST['newpwd2']) : '';
    if ($newpwd != $newpwd2)
    {
        throw_message('两次输入的密码不一致！');
    }
    $oldpwd = isset($_POST['oldpwd']) ? trim($_POST['oldpwd']) : '';
    if ($newpwd != '')
    {
        $sitepw = $newpwd;
    }
    else
    {
        $sitepw = $ccapi_settings['password'];
    }
    $sitename = isset($_POST['sitename']) ? trim($_POST['sitename']) : '';
    $siteurl = isset($_POST['siteurl']) ? trim($_POST['siteurl']) : '';
    $sitelogo = isset($_POST['sitelogo']) ? trim($_POST['sitelogo']) : '';

    $code = ccapi_auth_code('password=' . urlencode($newpwd)
                                .'&oldPassword=' . urlencode($oldpwd)
                                .'&siteName=' . urlencode($sitename)
                                .'&oldSiteUrl=' . urlencode($siteurl)
                                .'&siteUrl=' . urlencode($siteurl)
                                .'&siteLogo=' . urlencode($sitelogo)
                                .'&siteType=' . $sitetype,
                            'encode',
                            $ccapi_settings['key']);
    $retval = ccapi_edit_union($ccapi_settings['ccid'], $code);
    if (TRUE === $retval)
    {
        $data = array();
        $data['sitename'] = $sitename;
        $data['siteurl'] = $siteurl;
        $data['sitelogo'] = $sitelogo;
        $data['sitetype'] = $sitetype;
        $data['siteemail'] = $ccapi_settings['siteemail'];
        $data['ccid'] = $ccapi_settings['ccid'];
        $data['password'] = $sitepw;
        $data['key'] = $ccapi_settings['key'];
        save_array('ccapi_settings', $data);
        throw_message('编辑成功', $self);
    }
    throw_message($retval);
}
elseif (is_submit_of('reg')) // 解除绑定
{
    $sitename = isset($_POST['sitename']) ? trim($_POST['sitename']) : '';
    $siteurl = isset($_POST['siteurl']) ? trim($_POST['siteurl']) : '';
    $sitelogo = isset($_POST['sitelogo']) ? trim($_POST['sitelogo']) : '';
    $sitetype = isset($_POST['sitetype']) && is_numeric($_POST['sitetype']) ? intval($_POST['sitetype']) : 0;
    $siteemail = isset($_POST['siteemail']) ? trim($_POST['siteemail']) : '';
    $agreement = isset($_POST['agreement']) && is_numeric($_POST['agreement']) ? intval($_POST['agreement']) : 0;

    if (!$agreement) { throw_message('没有选择同意注册协议'); }

    //$sitename_encode = iconv('gb2312','utf-8',$sitename);
    //import('chinese');
    //$chs = new Chinese();
    //$sitename_encode = $chs->Convert(Chinese::Simplified, Chinese::UTF8, $sitename);

    $result = ccapi_reg_union($sitename, $siteurl, $sitelogo, $sitetype, $siteemail);
    if (is_array($result))
    {
        $data['sitename'] = $sitename;
        $data['siteurl'] = $siteurl;
        $data['sitelogo'] = $sitelogo;
        $data['sitetype'] = $sitetype;
        $data['siteemail'] = $siteemail;
        $data['ccid'] = $result[0];
        $data['password'] = $result[1];
        $data['key'] = $result[2];
        save_array('ccapi_settings', $data);
        throw_message('注册成功！', $self);
    }

    throw_message($result);
}
?>