<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=link';
//取得单个数据
$single = $list = array();

$linkid = isset($_GET['linkid']) && is_numeric($_GET['linkid']) ? intval($_GET['linkid']) : 0;

if ($linkid) { $single = $globals['db']->select(T('link'), array('linkid' => $linkid), '', TRUE); }
if (!empty($_GET['op']) && $_GET['op'] != 'add' && empty($single)) { throw_message('未知错误！'); }

// 添加或修改
if (is_submit_of('linksubmit'))
{
    append_link($_POST)
        ? throw_message('操作成功！', $self)
        : throw_message('操作失败，未知的错误！');
}

// 批量删除
if (is_submit_of('deletesubmit'))
{
    include_once(__INCLUDE__ . '/admin.delete.inc.php');
    !empty($_POST['ids']) && delete_link($_POST['ids'])
        ? throw_message('批量删除成功！', $self)
        : throw_message('不能批量删除！');
}

if (is_submit_of('ordersubmit'))
{
    foreach ($_POST['orderid'] as $key => $value)
    {
        $globals['db']->update(T('link'),
                                array('orderid' => intval($value)),
                                array('linkid' => intval($key))
                            );
    }

    throw_message('操作成功！', $self);
}

if (empty($_GET['op']))
{
    $sql = 'SELECT `linkid`, `name`, `url`, `logo`, `description`, `orderid`'
         . ' FROM ' . T('link')
         . ' ORDER BY `orderid` DESC';
    $list = $globals['db']->executeReader($sql);
}
elseif ($_GET['op'] == 'add')
{
    // 添加
    $single = array('name' => '', 'logo' => '', 'url' => '', 'description' => '', 'orderid' => 0);
}
elseif ($_GET['op'] == 'edit')
{
}
elseif ($_GET['op'] == 'delete')
{
    if ($linkid)
    {
        $globals['db']->delete(T('link'), array('linkid' => $linkid));
        throw_message('删除成功！', $self);
    }
    else
    {
        throw_message('不能删除！');
    }

}

function append_link($post)
{
    global $globals, $linkid;
    $data = array();
    $post['name'] = self_substr(strip_html_tags(trim($post['name'])), 0, 20);
    if (empty($post['name'])) { throw_message('网站名称不能为空！'); }
    $post['url'] = self_substr(strip_html_tags(trim($post['url'])), 0, 255);
    if (empty($post['url'])) { throw_message('网站URL不能为空！'); }
    $post['logo'] = empty($post['logo']) ? '' : self_substr(strip_html_tags($post['logo']) , 0, 255);
    $post['description'] = empty($post['description'])
                            ? ''
                            : self_substr(strip_html_tags($post['description']) , 0, 255);
    $post['orderid'] = is_numeric($post['orderid']) ? intval($post['orderid']) : 0;
    unset($post['linksubmit']);

    if (empty($linkid))
    {
        return $globals['db']->insert(T('link'), $post);
    }
    else
    {
        return $globals['db']->update(T('link'), $post, array('linkid' => $linkid));
    }
}

?>