<?php
if (!defined('__IN_SY__')) { exit('Access Denied'); }

if (empty($settings['makehtml']) || empty($settings['allowrewrite']))
{
    throw_message('请在 <a href="index.php?model=setting">站点设置</a> 中同时开启 生成HTML 和 URL Rewrite 两项！');
}

set_time_limit(0);
$self = 'index.php?model=make';

$_GET['pagesize'] = isset($_GET['pagesize']) && is_numeric($_GET['pagesize']) ? intval($_GET['pagesize']) : 0;
$_GET['offset'] = isset($_GET['offset']) && is_numeric($_GET['offset']) ? intval($_GET['offset']) : 0;
$_GET['typeid'] = isset($_GET['typeid']) && is_numeric($_GET['typeid']) ? intval($_GET['typeid']) : 0;
$_GET['maketype'] = empty($_GET['maketype']) ? '' : $_GET['maketype'];

if ($maketype)
{
    if (!function_exists($maketype))
    {
        throw_message('请正确选择生成类型！');
    }

    import('http');

    //dump($maketype);
    if ($maketype == 'make_index')
    {
        make_index();
    }
    elseif ($maketype == 'make_type')
    {
        make_type($_GET['typeid']);
    }
    elseif ($maketype == 'make_type_all')
    {
        make_type_all();
    }
    elseif ($maketype == 'make_media')
    {
        if (make_media())
        {
            $url = $self . '&maketype=' . $_GET['maketype'] . '&typeid=' . $_GET['typeid']
                  . '&pagesize=' . $_GET['pagesize']
                  . '&offset=' . ($_GET['offset'] + $_GET['pagesize']);
            //dump($url);
            //exit;
            //sleep(3);
            self_redirect($url, 1);
        }
        else
        {
            println('生成内容页成功！');
        }
    }
    elseif ($maketype == 'make_media_all')
    {
        if (make_media_all())
        {
            $url = $self . '&maketype=' . $_GET['maketype']
                  . '&pagesize=' . $_GET['pagesize']
                  . '&offset=' . ($_GET['offset'] + $_GET['pagesize']);
            //dump($url);
            //exit;
            //sleep(3);
            self_redirect($url, 1);
        }
        else
        {
            println('生成内容页成功！');
        }
    }
    //$maketype();

    exit;
}

// 生成首页
function make_index()
{
    global $settings;
    $path_url = $settings['sitepath'] . '/index.html';
    make_write($settings['siteurl'] . '/index.php', __ROOT__ . '/index.html');
    println('文件 <a href="' . $path_url . '" target="_blank">' . $path_url . '</a> 生成成功！');
}

// 生成所有分类页
function make_type_all()
{
    global $types, $self;

    $my_typeid = isset($_GET['my_typeid']) && is_numeric($_GET['my_typeid']) ? intval($_GET['my_typeid']) : 0;

    if (isset($types[$my_typeid]))
    {
        if (make_type($types[$my_typeid]['typeid']))
        {
            $url = $self . '&maketype=make_type_all&my_typeid=' . ($my_typeid + 1);
            //sleep(3);
            self_redirect($url, 1);
        }
    }
    else
    {
        println('生成所有分类页成功！');
    }
}

// 生成分类页
function make_type($typeid)
{
    global $globals, $settings;

    $count = $globals['db']->getScalar(T('media'), array('typeid' => intval($typeid)));
    $page_count = @ceil($count / 20);
    if ($page_count < 1) { $page_count = 1; }

    $byname = get_byname($typeid);
    $path = __ROOT__ . '/' . $byname . '/';
    mk_dir($path);

    println('开始生成分类页 ... ');
    for ($i = 1; $i <= $page_count; $i++)
    {
        $url = $settings['siteurl'] . '/type.php?typeid=' . $typeid . '&page=' . $i;
        $i == 1 ? $filename = 'index.html' : $filename = 'index_' . $i . '.html';
        $path_url = $settings['sitepath'] . '/' . $byname . '/' . $filename;
        $file = $path . $filename;

        if (make_write($url, $file))
        {
            println('文件 <a href="' . $path_url . '" target="_blank">' . $path_url . '</a> 生成成功！');
        }
        else
        {
            println('文件 ' . $path_url . ' 生成失败！');
        }
    }
    println('分类页生成成功！');
    return TRUE;
}

function make_media()
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `mediaid` FROM ' . T('media') . ' WHERE `typeid` = ? LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $_GET['typeid'], DB_PARAM_INT));
    $params->append(new SqlParameter(2, $_GET['offset'], DB_PARAM_INT));
    $params->append(new SqlParameter(3, $_GET['pagesize'], DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    if (empty($result)) { return FALSE; }

    foreach ($result as $key => $value)
    {
        make_media_html($value['mediaid'], $_GET['typeid']);
    }

    return TRUE;
}

function make_media_all()
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `mediaid`, `typeid` FROM ' . T('media') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $_GET['offset'], DB_PARAM_INT));
    $params->append(new SqlParameter(2, $_GET['pagesize'], DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    if (empty($result)) { return FALSE; }

    foreach ($result as $key => $value)
    {
        make_media_html($value['mediaid'], $value['typeid']);
    }

    return TRUE;
}

function make_media_html($mediaid, $typeid)
{
    global $globals, $settings;
    $byname = get_byname($typeid);
    $path = __ROOT__ . '/' . $byname . '/' . $mediaid . '/';
    mk_dir($path);

    $url = $settings['siteurl'] . '/media.php?typeid=' . $typeid . '&mediaid=' . $mediaid;
    $filename = 'index.html';
    $path_url = $settings['sitepath'] . '/' . $byname . '/' . $mediaid . '/' . $filename;
    $file = $path . $filename;

    if (make_write($url, $file))
    {
        println('文件 <a href="' . $path_url . '" target="_blank">' . $path_url . '</a> 生成成功！');
    }
    else
    {
        println('文件 ' . $path_url . ' 生成失败！');
    }
}

function make_write($filename, $newfile)
{
    $content = Http::quickGet($filename);
    $result = file_put_contents($newfile, $content);
    @chmod($newfile, 0777);
    if ($result)
    {
        clearstatcache();
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function temp_message($message1, $message2)
{
    global $config;
    $msg = "<html>\n<head>\n"
         . '<meta http-equiv="Content-Type" content="text/html; charset=' . $config['charset'] . '" />'
         . '<title>SYCMS 提示信息</title>'
         . '<base target="_self"/>' . "\n</head>\n"
         . '<body leftmargin="0" topmargin="0">' . "\n"
         . '<div style="padding-top:4px;height:24;font-size:10pt;">'
         . $message1 . "</div>\n<br /><br />\r\n" . $message2 . "\r\n</body>\n</html>";

    echo $msg;
}

?>