<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=media_add';

$_GET['mediaid'] = isset($_GET['mediaid']) && is_numeric($_GET['mediaid']) ? intval($_GET['mediaid']) : 0;

if (is_submit_of('mediasubmit'))
{
    $data = array(
                'typeid' => isset($_POST['typeid']) && is_numeric($_POST['typeid'])
                                ? intval($_POST['typeid'])
                                : 0,
                'name' => isset($_POST['name'])
                            ? self_substr(strip_html_tags(trim($_POST['name'])), 0, 50)
                            : '',
                'color' => isset($_POST['color'])
                                ? self_substr(strip_html_tags(trim($_POST['color'])), 0, 7)
                                : '',
                'state' => isset($_POST['state'])
                                ? self_substr(strip_html_tags(trim($_POST['state'])), 0, 50)
                                : '',
                'starring' => isset($_POST['starring'])
                            ? self_substr(strip_html_tags(trim($_POST['starring'])), 0, 255)
                            : '',
                'uvid' => isset($_POST['uvid'])
                            ? self_substr(strip_html_tags(trim($_POST['uvid'])), 0, 50)
                            : '',
                'pic' => isset($_POST['pic'])
                            ? self_substr(strip_html_tags(trim($_POST['pic'])), 0, 255)
                            : '',
                'genre' => isset($_POST['genre'])
                                ? self_substr(strip_html_tags(trim($_POST['genre'])), 0, 8)
                                : '',
                'urls' => isset($_POST['urls'])
                            ? trim($_POST['urls'])
                            : '',
                'description' => isset($_POST['description'])
                                ? trim($_POST['description'])
                                : '',
                'tags' => isset($_POST['tags'])
                            ? self_substr(strip_html_tags(trim($_POST['tags'])), 0, 255)
                            : '',
                'vouch' => isset($_POST['vouch']) && is_numeric($_POST['vouch'])
                                ? intval($_POST['vouch'])
                                : 0,
                'hot' => isset($_POST['hot']) && is_numeric($_POST['hot'])
                            ? intval($_POST['hot'])
                            : 0,
                'views' => isset($_POST['views']) && is_numeric($_POST['views'])
                                ? intval($_POST['views'])
                                : 0,
                'createdate' => time()
            );

    if (empty($data['typeid']) || empty($data['name']))
    {
        throw_message('类型和媒体名称必须填写！');
    }

    if (empty($data['uvid']) && empty($data['urls']))
    {
        throw_message('资源库或者路径不能全部为空！');
    }

    if (empty($_GET['mediaid']))
    {
        $globals['db']->insert(T('media'), $data);
    }
    else
    {
        $globals['db']->update(T('media'), $data, array('mediaid' => $_GET['mediaid']));
    }

    throw_message('操作成功！', 'index.php?model=media');
}

//取得单个数据
$single = array('state' => '连载', 'description' => '', 'views' => 1000);
if ($_GET['mediaid'])
{
    $single = $globals['db']->select(T('media'), array('mediaid' => $_GET['mediaid']), '', TRUE);
}
@include_once(__DATA__ . '/ccapi_settings.cache.php');
$baseurl = get_base_url();
$ccapi_ccid = (empty($ccapi_settings['ccid']) || $baseurl == 'http://localhost' || $baseurl == 'http://127.0.0.1')
            ? ''
            : $ccapi_settings['ccid'];
?>