<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

set_time_limit(0);
$turl = 'index.php?model=stat';

//处理统计更新
$pagesize = empty($_GET['pagesize']) ? 0 : intval($_GET['pagesize']);
$counttype = empty($_GET['counttype']) ? '' : 'stat_' . $_GET['counttype'];
if ($pagesize && $counttype)
{
    $offset = empty($_GET['offset']) ? 0 : intval($_GET['offset']);
    if ($offset < 0) { $offset = 0; }

    if (!function_exists($counttype))
    {
        throw_message('请正确选择要重新统计的数据类型！');
    }
    if ($counttype($offset, $pagesize))
    {
        $jump = $turl . '&counttype=' . $_GET['counttype']
                . '&pagesize=' . $_GET['pagesize'] . '&offset=' . ($offset + $pagesize);
        $processing = '<a href="' . $jump . '">处理数据中( ' . $offset
                    . ' )，请耐心等候...</a> (<a href="' . $turl . '">强制终止</a>)';
        throw_message($processing, $jump);
    } else {
        //更新缓存
        include_cache(__INCLUDE__ . '/cache.inc.php');
        cache_types();
        throw_message('操作成功！', $turl);
    }
}


function stat_type_medianum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `typeid`, `medianum` FROM ' . T('type') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('media'), array('typeid' => $value['typeid']));
        if ($count != $value['medianum'])
        {
            $data[$value['typeid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('type') . ' SET `medianum` = ?'
                . " WHERE `typeid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

?>