<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=template';
$tpl_dir = __TEMPLATE__ . '/' . $settings['template'] . '/';

if (is_submit_of('editsubmit'))
{
    $filefullname = get_full_path($_POST['filename']);

    //复制当前的文件
    $temp_file = $filefullname . '.bak';
    if (!file_exists($temp_file))
    {
        // 如果不能复制就读取并写入
        if (!@copy($filefullname, $temp_file))
        {
            file_put_contents($temp_file, file_get_contents($filefullname));
        }
    }

    $fp = fopen($filefullname, 'wb');
    flock($fp, 2);
    fwrite($fp, stripslashes($_POST['content']));
    fclose($fp);

    //清空模板缓存
    $filename = rtrim($_POST['filename'], '.html'); // 移除.html
    $_tpl = in_string($filename, '/') ? $filename : 'template/' . $settings['template'] . '/' . $filename;
    $cache_file = __DATA__ . '/tpl/' . str_replace('/', '.', $_tpl) . '.php';
    @unlink($cache_file);

    throw_message('操作成功！', $self);
}

if (empty($_GET['op']))
{
    //获取模板列表
    $tpls = array();
    if($dir = opendir($tpl_dir))
    {
        while (($file = readdir($dir)) !== FALSE)
        {
            if(is_file($tpl_dir . $file) && get_ext($file) == 'html')
            {
                $status = 0;
                if (file_exists($tpl_dir . $file . '.bak')) { $status = 1; }
                $tpls[] = array($file, $status);
            }
        }
        closedir($dir);
    }
}
elseif($_GET['op'] == 'edit')
{
    $filefullname = get_full_path($_GET['filename']);
    $fp = fopen($filefullname, 'rb');
    $content = trim(strip_html_tags(fread($fp, filesize($filefullname))));
    fclose($fp);
}
elseif($_GET['op'] == 'repair')
{
    $filefullname = get_full_path($_GET['filename']);

    $temp_file = $filefullname . '.bak';

    if(file_exists($temp_file))
    {
        if (!@copy($temp_file, $filefullname))
        {
            file_put_contents($filefullname, file_get_contents($temp_file));
            @unlink($temp_file);
        }
        else
        {
            @unlink($temp_file);
        }

        //清空模板缓存
        $filename = rtrim($_GET['filename'], '.html'); // 移除.html
        $_tpl = in_string($filename, '/') ? $filename : 'template/' . $settings['template'] . '/' . $filename;
        $cache_file = __DATA__ . '/tpl/' . str_replace('/', '.', $_tpl) . '.php';
        @unlink($cache_file);
    }
    else
    {
        throw_message('您编辑的模板文件不存在！');
    }

    throw_message('操作成功！', $self);
}

// 根据模板名取得全路径
function get_full_path($filename)
{
    global $settings;

    $_tpl = __TEMPLATE__ . '/' . $settings['template'] . '/' . $filename;

    if (!empty($filename))
    {
        $filename = str_replace(array('..', '/', '\\'), array('', '', ''), $filename);

        if (!empty($filename) && get_ext($filename) == 'html')
        {
            if(is_writeable($_tpl))
            {
                return $_tpl;
            }
        }
    }
    throw_message('指定的文件不能编辑，请检查您的模板目录权限！');
}

?>