<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$self = 'index.php?model=type';
//取得单个数据
$single = $list = array();

$_GET['typeid'] = isset($_GET['typeid']) && is_numeric($_GET['typeid']) ? intval($_GET['typeid']) : 0;
if ($_GET['typeid']) { $single = $globals['db']->select(T('type'), array('typeid' => $_GET['typeid']), '', TRUE); }
if (!empty($_GET['op']) && $_GET['op'] != 'add' && empty($single)) { throw_message('未知错误！'); }

if (is_submit_of('typesubmit'))
{
    $data = array(
                'name' => isset($_POST['name'])
                            ? self_substr(strip_html_tags(trim($_POST['name'])), 0, 50)
                            : '',
                'byname' => isset($_POST['byname'])
                                ? self_substr(strip_html_tags(trim($_POST['byname'])), 0, 50)
                                : '',
                'parentid' => isset($_POST['parentid']) && is_numeric($_POST['parentid'])
                                ? intval($_POST['parentid'])
                                : 0,
                'orderid' => isset($_POST['orderid']) && is_numeric($_POST['orderid'])
                                ? intval($_POST['orderid'])
                                : 0
            );
//dump($data, '$data');
//exit;
    if (empty($data['name']) || empty($data['byname'])) { throw_message('分类名称和分类别名必须填写！'); }

    if (empty($_GET['typeid']))
    {
        $globals['db']->insert(T('type'), $data);
    }
    else
    {
        $typelist = $_typelist = array();
        $sql = 'SELECT `typeid`, `name`, `byname`, `parentid`, `orderid`'
             . ' FROM ' . T('type')
             . ' WHERE `parentid` = ?'
             . ' ORDER BY `orderid` DESC;';
        $params = new ArrayObject();
        $params->append(new SqlParameter(1, intval($_GET['typeid']), DB_PARAM_INT));
        $_typelist = $globals['db']->executeReader($sql, $params);
        regroup_array($_typelist, $typelist, intval($_GET['typeid']));
        foreach ($typelist as $key => $value)
        {
            if (($data['parentid'] == $value['typeid']) || ($data['parentid'] == $_GET['typeid']))
            {
                throw_message('分类移动错误！');
            }
        }
        $globals['db']->update(T('type'), $data, array('typeid' => $_GET['typeid']));
    }

    //更新缓存
    include_cache(__INCLUDE__ . '/cache.inc.php');
    cache_types();
    throw_message('操作成功！', $self);
}
elseif (is_submit_of('ordersubmit'))
{
    foreach ($_POST['orderid'] as $orderid => $value)
    {
        $globals['db']->update(T('type'),
                                array('orderid' => intval($value)),
                                array('typeid' => intval($orderid))
                            );
    }

    //更新缓存
    include_cache(__INCLUDE__ . '/cache.inc.php');
    cache_types();

    throw_message('操作成功！', $self);
}

if (empty($_GET['op']))
{
    // 列表
    $list = $types;
}
elseif ($_GET['op'] == 'add')
{
    // 添加
    $single = array('typeid' => 0, 'name' => '', 'byname' => '', 'orderid' => 0);
}
elseif ($_GET['op'] == 'edit')
{

}
elseif ($_GET['op'] == 'delete')
{
    if ($_GET['typeid'])
    {
        foreach ($types as $key => $value)
        {
            if ($value['parentid'] == $_GET['typeid']) { throw_message('该类型下还有子类型，不能删除！'); }
        }

        $globals['db']->delete(T('media'), array('typeid' => $_GET['typeid']));
        $globals['db']->delete(T('type'), array('typeid' => $_GET['typeid']));
        //更新缓存
        include_cache(__INCLUDE__ . '/cache.inc.php');
        cache_types();
        throw_message('删除成功！', $self);
    }
    else
    {
        throw_message('不能删除！');
    }
}
?>