<?php

require_once(dirname(__FILE__) . '/init.php');
require_once(__INCLUDE__ . '/search.inc.php');

$_GET['m'] = empty($_GET['m']) ? '' : trim($_GET['m']);
$_GET['q'] = empty($_GET['q']) ? '' : strip_search_key($_GET['q']);

if (empty($_GET['m'])) { exit('[]'); }

/**
 +------------------------------------------------------------------------------
 * Think兼容函数库 针对5.2.0以下版本
 +------------------------------------------------------------------------------
 * @category   Think
 * @package  Common
 * @author   liu21st <liu21st@gmail.com>
 * @version  $Id$
 +------------------------------------------------------------------------------
 */

if (!function_exists('json_encode')) {
     function format_json_value(&$value)
    {
        if(is_bool($value)) {
			$value = $value?'true':'false';
        }elseif(is_int($value)) {
            $value = intval($value);
        }elseif(is_float($value)) {
            $value = floatval($value);
        }elseif(defined($value) && $value === null) {
            $value = strval(constant($value));
        }elseif(is_string($value)) {
            $value = '"'.addslashes($value).'"';
        }
        return $value;
    }

    function json_encode($data)
    {
    	if(is_object($data)) {
            //对象转换成数组
            $data = get_object_vars($data);
        }else if(!is_array($data)) {
        	// 普通格式直接输出
            return format_json_value($data);
        }
        // 判断是否关联数组
        if(empty($data) || is_numeric(implode('',array_keys($data)))) {
        	$assoc  =  false;
        }else {
        	$assoc  =  true;
        }
        // 组装 Json字符串
        $json = $assoc ? '{' : '[' ;
        foreach($data as $key=>$val) {
            if(!is_null($val)) {
                if($assoc) {
                    $json .= "\"$key\":".json_encode($val).",";
                }else {
                    $json .= json_encode($val).",";
                }
            }
        }
        if(strlen($json)>1) {// 加上判断 防止空数组
        	$json  = substr($json,0,-1);
        }
        $json .= $assoc ? '}' : ']' ;
        return $json;
    }
}
if (!function_exists('json_decode')) {
    function json_decode($json,$assoc=false)
    {
        // 目前不支持二维数组或对象
        $begin  =  substr($json,0,1) ;
        if(!in_array($begin,array('{','['))) {
            // 不是对象或者数组直接返回
        	return $json;
        }
        $parse = substr($json,1,-1);
        $data  = explode(',',$parse);
        if($flag = $begin =='{' ) {
        	// 转换成PHP对象
            $result   = new stdClass();
            foreach($data as $val) {
            	$item    = explode(':',$val);
                $key =  substr($item[0],1,-1);
                $result->$key = json_decode($item[1],$assoc);
            }
            if($assoc) {
                $result   = get_object_vars($result);
            }
        }else {
        	// 转换成PHP数组
            $result   = array();
            foreach($data as $val) {
            	$result[]  =  json_decode($val,$assoc);
            }
        }
        return $result;
    }
}

$data = array();

if ($_GET['m'] == 'media')
{
    $params = new ArrayObject();
    $sql = 'SELECT `mediaid`, `typeid`, `name`, `state`, `views` FROM ' . T('media')
         . " WHERE `name` LIKE BINARY ? ORDER BY `views` DESC LIMIT 0, 20;";
    $params->append(new SqlParameter(1, '%' . $_GET['q'] . '%', DB_PARAM_STR, 20));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $data[$key]['url'] = get_media_url($value['mediaid'], $value['typeid']);
        $data[$key]['title'] = $value['name'] . ' <font color="blue"><sup>' . $value['state'] . '</sup></font>';
        $data[$key]['status'] = $value['views'] . ' 点击';
    }
}

echo json_encode($data);
?>