DROP TABLE IF EXISTS `sy_ad`;
CREATE TABLE `sy_ad` (
  `adid` smallint(6) unsigned NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `code` text NOT NULL,
  PRIMARY KEY  (`adid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_import`;
CREATE TABLE `sy_import` (
  `importid` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(80) NOT NULL,
  `starring` varchar(80) default NULL,
  `pic` varchar(255) default NULL,
  `genre` char(8) default NULL,
  `urls` text,
  `tags` varchar(255) default NULL,
  `description` text,
  `state` varchar(50) default NULL,
  `uvid` varchar(50) default NULL,
  `type` smallint(6) unsigned default '0',
  `createdate` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`importid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_link`;
CREATE TABLE `sy_link` (
  `linkid` smallint(6) unsigned NOT NULL auto_increment,
  `name` char(20) NOT NULL,
  `logo` varchar(255) default NULL,
  `url` varchar(255) NOT NULL,
  `description` tinytext,
  `orderid` tinyint(3) unsigned NOT NULL default '50',
  PRIMARY KEY  (`linkid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_media`;
CREATE TABLE `sy_media` (
  `mediaid` mediumint(8) unsigned NOT NULL auto_increment,
  `typeid` smallint(6) unsigned NOT NULL,
  `name` char(80) NOT NULL,
  `color` char(7) default NULL,
  `starring` varchar(80) default NULL,
  `pic` varchar(255) default NULL,
  `genre` char(8) default NULL,
  `urls` text,
  `description` text,
  `tags` varchar(255) default NULL,
  `state` varchar(50) default NULL,
  `vouch` tinyint(1) unsigned NOT NULL default '0',
  `hot` tinyint(1) unsigned NOT NULL default '0',
  `views` int(10) unsigned NOT NULL default '0',
  `createdate` int(10) unsigned NOT NULL,
  `uvid` varchar(50) default NULL,
  PRIMARY KEY  (`mediaid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_member`;
CREATE TABLE `sy_member` (
  `uid` mediumint(8) unsigned NOT NULL auto_increment,
  `username` char(15) NOT NULL,
  `password` char(32) NOT NULL,
  PRIMARY KEY  (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_session`;
CREATE TABLE `sy_session` (
  `uid` mediumint(8) unsigned NOT NULL,
  `username` char(15) NOT NULL,
  `password` char(32) NOT NULL,
  `lastactivity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_settings`;
CREATE TABLE `sy_settings` (
  `name` varchar(30) NOT NULL default '',
  `value` text NOT NULL,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sy_type`;
CREATE TABLE `sy_type` (
  `typeid` smallint(6) unsigned NOT NULL auto_increment,
  `name` char(50) NOT NULL,
  `byname` char(50) NOT NULL,
  `parentid` smallint(6) unsigned NOT NULL default '0',
  `orderid` tinyint(3) unsigned NOT NULL default '0',
  `medianum` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`typeid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

INSERT INTO `sy_member` (`username`, `password`) VALUES ('admin', '21232f297a57a5a743894a0e4a801fc3');
