<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

/**
 * 批量删除广告
 *
 * @param array $adids 广告id
 * @return boolean
 */
function delete_ad($adids)
{
    global $globals;
    if (empty($adids)) { return TRUE; }
    $sql = 'DELETE FROM ' . T('ad') . ' WHERE `adid` IN (' . self_implode($adids) . ');';
    $globals['db']->executeNonQuery($sql);
    foreach ($adids as $key => $value)
    {
        @unlink(__DATA__ . '/adtpl/' . $value . '.html');
    }
    return TRUE;
}

/**
 * 批量删除友情链接
 *
 * @param array $linkids 链接id
 * @return boolean
 */
function delete_link($linkids)
{
    global $globals;
    if (empty($linkids)) { return TRUE; }
    $sql = 'DELETE FROM ' . T('link') . ' WHERE `linkid` IN (' . self_implode($linkids) . ');';
    $globals['db']->executeNonQuery($sql);
    return TRUE;
}

/**
 * 批量删除媒体数据
 *
 * @param array $mediaids 媒体id
 * @return boolean
 */
function delete_media($mediaids)
{
    global $globals;
    if (empty($mediaids)) { return TRUE; }
    $sql = 'DELETE FROM ' . T('media') . ' WHERE `mediaid` IN (' . self_implode($mediaids) . ');';
    $globals['db']->executeNonQuery($sql);
    return TRUE;
}

/**
 * 批量删除临时数据
 *
 * @param array $importids 媒体id
 * @return boolean
 */
function delete_import($importids)
{
    global $globals;
    if (empty($importids)) { return TRUE; }
    $sql = 'DELETE FROM ' . T('import') . ' WHERE `importid` IN (' . self_implode($importids) . ');';
    $globals['db']->executeNonQuery($sql);
    return TRUE;
}

?>