<?php

// 缓存开始标记
if (!defined('__CACHE_HEADER__'))
{
    define('__CACHE_HEADER__', "<?php\n//");
}

// 缓存结束标记
if (!defined('__CACHE_FOOTER__'))
{
    define('__CACHE_FOOTER__', "\n?>");
}

class Cache
{

    public function __construct()
    {
    }

    public function __destruct()
    {
    }

    /**
     * 判断缓存是否存在
     *
     * @access public
     * @param string $filename 文件名
     * @return boolean
     */
    public static function Exist($filename)
    {
        return file_exists(self::_getFile($filename));
    }

    /**
     * 取得缓存文件内容
     *
     * @access public
     * @param string $filename 文件名
     * @return mixed
     */
    public static function Get($filename)
    {
        global $settings;
        $filename = self::_getFile($filename);
        $content = @file_get_contents($filename);
        if (FALSE !== $content)
        {
            $expire = substr($content, strlen(__CACHE_HEADER__), 6);
            if ($expire != -1 && time() > filemtime($filename) + $expire)
            {
                 unlink($filename);
                 return FALSE;
            }
            $content = substr($content, strlen(__CACHE_HEADER__) + 6, -strlen(__CACHE_FOOTER__));
            if ($settings['cache_compress'] && function_exists('gzcompress'))
            {
                $content = gzuncompress($content);
            }
            $content = unserialize($content);
            return $content;
        }
        return FALSE;
    }

    /**
     * 缓存文件
     *
     * @access public
     * @param string $filename 文件名
     * @param mixed $value 内容
     * @param string $expire 过期时间
     * @return boolean
     */
	public static function Add($filename, $value, $expire = '')
	{
        global $settings;
        if (empty($expire) || $expire < 180)
        {
            $expire = 180; // 最少60秒
        }
        $filename = self::_getFile($filename);
        $data = serialize($value);
        if ($settings['cache_compress'] && function_exists('gzcompress'))
        {
            $data = gzcompress($data, 3);
        }
        $data = __CACHE_HEADER__ . sprintf('%06d', $expire) . $data . __CACHE_FOOTER__;
        $result = @file_put_contents($filename, $data);
        if ($result)
        {
            clearstatcache();
            return TRUE;
        }
        else
        {
            return FALSE;
        }
	}

    /**
     * 删除缓存文件
     *
     * @access public
     * @param string $filename 文件名
     * @return boolean
     */
    public static function Del($filename)
    {
        $f = self::_getFile($filename);
        if (file_exists($f)) { @unlink($f); }
        return TRUE;
    }

    /**
     * 获取缓存文件路径
     *
     * @access public
     * @param string $prefix 文件名前缀
     * @return boolean
     */
    public static function Clear($prefix = '')
    {
        try
        {
            $dir = glob(__DATA__ . $prefix . '*.php');
            if ($dir)
            {
                foreach ($dir as $k => $v)
                {
                    if (file_exists($v))
                    {
                        unlink($v);
                    }
                }
            }
            else
            {
                return FALSE;
            }
            return TRUE;
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }

    /**
     * 获取缓存文件路径
     *
     * @access private
     * @param string $filename 文件名
     * @return string
     */
    private static function _getFile($filename)
    {
        $_dir = __DATA__ . '/';
        if (in_string($filename, '/'))
        {
            $dir = dirname($filename);
            mk_dir($_dir . $dir);
        }
        return $_dir . $filename . '.php';
    }
}
?>