<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

/**
 * 缓存系统配置信息
 *
 * @param
 * @return void
 */
function cache_settings()
{
    global $globals, $settings;

    $settings = array();
    $result = $globals['db']->select(T('settings'));
    foreach ($result as $key => $value)
    {
        if ($value['name'] == 'privacy')
        {
            $value['value'] = empty($value['value']) ? array() : unserialize($value['value']);
        }
        $settings[$value['name']] = is_numeric($value['value']) ? intval($value['value']) : $value['value'];
    }
    save_array('settings', $settings, __DATA__ . '/settings.cache.php');
}

/**
 * 缓存分类
 *
 * @param
 * @return void
 */
function cache_types()
{
    global $globals;

    $list = $_list = array();
    $sql = 'SELECT `typeid`, `name`, `byname`, `parentid`, `orderid`, `medianum`'
         . ' FROM ' . T('type')
         . ' ORDER BY `orderid` DESC;';
    $_list = $globals['db']->executeReader($sql);
    regroup_array($_list, $list);
    save_array('types', $list, __DATA__ . '/types.cache.php');
}

/**
 * 缓存广告
 *
 * @param
 * @return void
 */
function cache_ad()
{
    global $globals;
    if (!is_dir(__DATA__ . '/adtpl/'))
    {
        mk_dir(__DATA__ . '/adtpl/');
    }
    clear_dir(__DATA__ . '/adtpl/');
    $result = $globals['db']->select(T('ad'));
    foreach ($result as $key => $value)
    {
        $value['code'] = unserialize($value['code']);
        //写入模板
        $_tpl = __DATA__ . '/adtpl/' . $value['adid'] . '.html';
        @file_put_contents($_tpl, $value['code']['html']);
    }
    return TRUE;
}

?>