<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

@include_once(__DATA__ . '/ccapi_settings.cache.php');
@include_once(__DATA__ . '/ccapi_bindtypes.cache.php');

//加密函数
function ccapi_auth_code($string , $action='' , $key ='')
{
    if (!$string) { return '';}
    $key = $key ? md5($key) : md5(time());
    $key_length = strlen( $key);
    $skip = (ord($key[0]) + ord($key[$key_length - 1])) % $key_length; //
    $string = ($action == 'decode' ? base64_decode($string) : substr(md5($key), 0, 8) . $string);
    $str_length = strlen($string);
    $box = array();
    for ($i = 0; $i < $key_length; $i++)
    {
        $box[$i] = (ord($key[$i]) + $skip) % 128;
    }
    $result = '';
    for ( $i = 0; $i < $str_length; $i++)
    {
        $result .= chr((ord( $string[$i]) ^ $box[$i * $skip % $key_length]));
    }
    if($action == 'decode')
    {
        if (substr($result, 0, 8) == substr(md5($key), 0, 8))
        {
            return substr($result, 8);
        }
        else
        {
            return $result;
        }
     }
     else
     {
        return str_replace('=', '', base64_encode( $result));
     }
}

//得到所有绑定的联盟分类，用逗号隔开
function getRelationUnionCid()
{
    global $ccapi_bindtypes;
    //@include_once(__DATA__ . '/ccapi_bindtypes.cache.php');
    if (count($ccapi_bindtypes) > 0)
    {
        $unionId=array();
        foreach ($ccapi_bindtypes as $_tid)
        {
            $_carr = explode(',', $_tid);
            foreach ($_carr as $_cu)
            {
                if(!$_cu) { continue; }
                if (!isset($unionId[$_cu])) { $unionId[$_cu] = $_cu; }
            }
        }
        $unionId = implode(',', $unionId);
        $unionId = rtrim($unionId, ',');
        return $unionId;
    }
}

//根据联盟id得到与之绑定的本地分类id
function ccapi_getRelationLocalCid($cid)
{
    global $ccapi_bindtypes;
    //@include(__DATA__ . '/ccapi_bindtypes.cache.php');
    if (count($ccapi_bindtypes) > 0)
    {
        foreach ($ccapi_bindtypes as $_key => $_tid)
        {
            $_carr = explode(',', $_tid);
            foreach ($_carr as $_cu)
            {
                if ($cid == $_cu) { return $_key; }
            }
        }
    }
    else
    {
        return FALSE;
    }
}

//获取trade返回的xml专辑信息
function ccapi_getTradeXML($ccid, $code, $tp)
{
    $trynum = 0;
    if ($tp == 'getitem')
    {
        $url = 'http://trade.bokecc.com/trade/action/g.jsp?id=' . $ccid . '&type=2&p=' . urlencode($code);
    }
    elseif ($tp == 'getday')
    {
        $url = 'http://trade.bokecc.com/trade/action/h.jsp?id=' . $ccid . '&type=2&p=' . urlencode($code);
    }
    elseif ($tp == 'gettype')
    {
        $url = 'http://trade.bokecc.com/thirdparty/action/c.jsp?id=' . $ccid . '&type=2&p=' . urlencode($code);
    }

    import('http');
    $http = new Http();
    $http->setTarget($url);
    $http->sendRequest();
    $XMLresult = $http->getResult();
    if ($XMLresult == "" && $trynum < 3)
    {
        $trynum++;
        ccapi_getTradeXML($ccid, $code, $tp);
    }elseif (!preg_match("</vlist>", $XMLresult))
    {
        echo "获取远程数据失败！<br><a href=# onClick='javascript:self.location.reload()'>点击这里重试</a>";
        return FALSE;
    }
    else
    {
        return $XMLresult;
    }
}

function ccapi_parser_XML($xmlStr, $splicTag = 'v')
{
    $datas = $indexs = null;
    if(!$xmlStr || !$splicTag)
    {
        return '';
    }
    if (!function_exists('xml_parser_create'))
    {
        exit('Not support xml parser!');
    }
    $xml_parser = xml_parser_create(); //创建XML解析器
    xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, 0); //XML标签全部由大写字母组成
    xml_parser_set_option($xml_parser, XML_OPTION_SKIP_WHITE, 1); //忽略由白空字符组成的值
    xml_parser_set_option($xml_parser, XML_OPTION_TARGET_ENCODING, 'UTF-8'); //该 XML 解析器所使用的目标编码方式为utf－8
    if (!xml_parse_into_struct($xml_parser, $xmlStr, $datas, $indexs))
    { //将标签和数据分离到$indexs和$datas数组中
        return array();
    }
    xml_parser_free($xml_parser); //释放XML解析器
    $tags = array();
    if (array_key_exists($splicTag, $indexs))
    { //如果找到需要整合的索引键值
        $splicTags = $indexs[$splicTag];
        for($i = 0; $i < count($splicTags); $i += 2)
        {
            $offset = $splicTags[$i] + 1; //计算数组的偏移量（通过该键的开始位置计算）
            $len = $splicTags[$i + 1] - $offset; //计算截取数组的长度（通过该键的解说位置计算）
            $tag = '';
            for($j = 0; $j <= $len; $j++)
            { //循环截取xml内容
                if($datas[$j+$offset]['type'] == 'complete')
                {
                    $tag[$datas[$j+$offset]['tag']] = $datas[$j+$offset]['value'];
                }
            }
            $temptags = '';
            $tags[] = $tag;
        }
    }
    else
    {
        return false;
    }
    return $tags;
}

function ccapi_get_url()
{
    if (!empty($_SERVER['HTTP_HOST']))
    {
        $baseurl = $_SERVER['HTTP_HOST'];
    }
    else
    {
        $baseurl = $_SERVER['SERVER_NAME'];
    }
      return $baseurl;
}

function ccapi_prompt($url = '', $t = 0)
{
    $url = $url ? $url : $_SERVER['HTTP_REFERER'];
    echo "<META HTTP-EQUIV='Refresh' CONTENT='$t; URL=$url'>";
    exit;
}

//弹出消息提示
function ccapi_alertMsg($msg, $local)
{
    if (!empty($local))
    {
        $local = "location.href='$local'";
    }
    else
    {
        $local = 'history.go(-1)';
    }
    echo "<script>alert('$msg');$local;</script>";
    exit;
}

// cc资源库注册接口
function ccapi_reg_union($sitename, $siteurl, $sitelogo, $sitetype, $siteemail)
{
    $msg = '';
    import('http');
    $http = new Http();
    $http->setTarget('http://union.bokecc.com/maxphp/reg.bo');
    $http->addParam('siteName', $sitename);
    $http->addParam('siteUrl', $siteurl);
    $http->addParam('siteLogo', $sitelogo);
    $http->addParam('siteType', $sitetype);
    $http->addParam('siteEmail', $siteemail);
    $http->sendRequest();
    $result = $http->getResult();

    if (is_numeric($result))
    {
        switch ($result)
        {
            case '-1':
                $msg = '邮箱为空';
                break;
            case '-2':
                $msg = '邮箱已注册';
                break;
            case '-3':
                $msg = '网站域名为空';
                break;
            case '-4':
                $msg = '网站名称为空';
                break;
            case '-5':
                $msg = '网站类型为空';
                break;
        }
        return $msg;
    }
    elseif ($result == "")
    {
        return "服务器访问失败";
    }
    else
    {
        return explode(',', $result);
    }
}

function ccapi_edit_union($ccid, $code)
{
    $msg = '';
    import('http');
    $http = new Http();
    $http->setTarget('http://union.bokecc.com/maxphp/edit.bo');
    $http->addParam('siteid', $ccid);
    $http->addParam('code', $code);
    $http->sendRequest();
    $result = $http->getResult();

    switch ($result)
    {
        default:
            $msg = "服务器访问失败";
            break;
        case '1':
            return TRUE;
            break;
        case '0':
            $msg = '联盟ID错误';
            break;
        case '-1':
            $msg = 'URL为空';
            break;
        case '-2':
            $msg = '网站名称为空';
            break;
        case '-3':
            $msg = '网站类型为空';
            break;
        case '-4':
            $msg = '服务器端出现未知错误';
            break;
        case '-5':
            $msg = '解密异常';
            break;
        case '-6':
            $msg = '绑定域名信息为空';
            break;
        case '-7':
            $msg = '不能获取已经绑定的域名信息';
            break;
        case '-8':
            $msg = '旧密码验证错误';
            break;
    }
    return $msg;
}

function ccapi_type_html($type)
{
    $tarray = array();
    $tarray[1] = "新闻";
    $tarray[2] = "军事";
    $tarray[3] = "音乐";
    $tarray[4] = "影视";
    $tarray[5] = "动漫";
    $tarray[6] = "游戏";
    $tarray[7] = "美女";
    $tarray[8] = "娱乐";
    $tarray[9] = "交友";
    $tarray[10] = "教育";
    $tarray[11] = "艺术";
    $tarray[12] = "学术";
    $tarray[13] = "技术";
    $tarray[14] = "动物";
    $tarray[15] = "旅游";
    $tarray[16] = "生活";
    $tarray[17] = "时尚";
    $tarray[18] = "电脑";
    $tarray[19] = "汽车";
    $tarray[20] = "手机";
    $tarray[21] = "摄影";
    $tarray[22] = "戏曲";
    $tarray[23] = "外语";
    $tarray[24] = "公益";
    $tarray[25] = "校园";
    $tarray[26] = "数码";
    $tarray[27] = "IT";
    $tarray[28] = "历史";
    $tarray[29] = "天文";
    $tarray[30] = "地理";
    $tarray[31] = "财经";
    $tarray[32] = "地区";
    $tarray[33] = "人物";
    $tarray[34] = "体育";
    $tarray[35] = "健康";
    $tarray[36] = "综合";
    echo '<table width="450px" border="0"><tr>';
    $i = 1;
    foreach ($tarray as $_key => $_val)
    {
        $checked = ($type == $_key) ? 'checked' : '';
        echo "<td><input type='radio' name='sitetype' value='$_key'  $checked /> $_val</td>";
        if ($i%6 == 0 && $i != 36) echo "</tr><tr>";
        $i++;
    }
    echo "</tr></table>";
}

?>