<?php
/*
 * 公共函数库
 */

if (!defined('__IN_SY__')) { exit('Access Denied'); }

function println($string)
{
    echo $string . "\r\n<br />";
}

/**
 * 变量输出
 *
 * @param string $var   变量名
 * @param string $label 显示标签
 * @return NULL
 */
function dump($var, $label = NULL)
{
    $label = ($label === NULL) ? '' : rtrim($label) . ' ';
    ob_start();
    var_dump($var);
    $output = ob_get_clean();
    if (!extension_loaded('xdebug'))
    {
        $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
        $output = '<pre>'
                . $label
                . htmlspecialchars($output, ENT_QUOTES, 'UTF-8')
                . '</pre>';
    }

    echo($output);
    return NULL;
}

/**
 * 转义字符串
 *
 * @param string/array $string 需要转义的字符串/数组
 * @return string
 */
function self_addslashes($string)
{
    if (is_array($string))
    {
        foreach ($string as $key => $val)
        {
            $string[$key] = self_addslashes($val);
        }
    }
    else
    {
        $string = addslashes($string);
    }
    return $string;
}

/**
 * 去掉转义字符串
 *
 * @param string/array $string 需要去掉转义的字符串/数组
 * @return string
 */
function self_stripslashes($string)
{
    if (is_array($string))
    {
        foreach ($string as $key => $val)
        {
            $string[$key] = self_stripslashes($val);
        }
    }
    else
    {
        $string = stripslashes($string);
    }
    return $string;
}

/**
 * 取消HTML代码
 *
 * @param string/array $string 需要取消HTML代码的字符串/数组
 * @return string
 */
function strip_html_tags($string)
{
    if (is_array($string))
    {
        foreach ($string as $key => $val)
        {
            $string[$key] = strip_html_tags($val);
        }
    }
    else
    {
        $string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1',
                str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string));
    }
    return $string;
}

/**
 * 字符串截取，支持中文和其他编码
 *
 * @param string $str 需要转换的字符串
 * @param string $start 开始位置
 * @param string $length 截取长度
 * @param string $charset 编码格式
 * @param string $suffix 截断显示字符
 * @return string
 */
function self_substr($str, $start = 0, $length, $charset = 'utf-8', $suffix = FALSE)
{
    if (function_exists("mb_substr"))
    {
        return mb_substr($str, $start, $length, $charset);
    }
    elseif (function_exists('iconv_substr'))
    {
        return iconv_substr($str, $start, $length, $charset);
    }
    $re['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
    $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
    $re['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
    $re['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
    preg_match_all($re[$charset], $str, $match);
    $slice = join("", array_slice($match[0], $start, $length));
    if ($suffix) { return $slice . "…"; }
    return $slice;
}

/**
 * 取得HTML里的文本
 *
 * @param $str HTML字符串
 * @return string
 */
function get_text_from_html($str)
{
    $str = preg_replace("/<sty(.*)\\/style>|<scr(.*)\\/script>|<!--(.*)-->/isU", '', $str);
    $alltext = '';
    $start = 1;
    for ($i = 0; $i < strlen($str); $i++)
    {
        if ($start == 0 && $str[$i] == '>')
        {
            $start = 1;
        }
        elseif ($start == 1)
        {
            if ($str[$i] == '<')
            {
                $start = 0;
                $alltext .= ' ';
            }
            elseif (ord($str[$i]) > 31)
            {
                $alltext .= $str[$i];
            }
        }
    }
    $alltext = str_replace('　', ' ', $alltext);
    $alltext = preg_replace("/&([^;&]*)(;|&)/", '', $alltext);
    $alltext = preg_replace("/[ ]+/s", ' ', $alltext);
    return $alltext;
}

/**
 * 取得客户端的ip
 *
 * @param
 * @return string
 */
function get_ip()
{
    if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
    {
        $ip = getenv("HTTP_CLIENT_IP");
    }
    else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
    {
        $ip = getenv("HTTP_X_FORWARDED_FOR");
    }
    else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
    {
        $ip = getenv("REMOTE_ADDR");
    }
    else if (isset($_SERVER['REMOTE_ADDR'])
        && $_SERVER['REMOTE_ADDR']
        && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
    {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    else
    {
        $ip = "unknown";
    }

    return $ip;
}

/**
 * 当前ip是否允许访问
 *
 * @param string $ip 允许访问的ip范围
 * @return boolean
 */
function allow_ip($ip)
{
    return empty($ip)
            ? TRUE
            : preg_match("/^(" . str_replace(array("\r\n", ' '),
                                        array('|', ''),
                                        preg_quote($ip, '/')) . ")/",
            get_ip());
}

/**
 * 当前ip是否禁止访问
 *
 * @param string $ip 禁止访问的ip范围
 * @return boolean
 */
function forbid_ip($ip)
{
    return empty($ip)
            ? FALSE
            : preg_match("/^(" . str_replace(array("\r\n", ' '),
                                        array('|', ''),
                                        preg_quote($ip, '/')) . ")/",
            get_ip());
}

/**
 * 取得客户端的操作系统类型
 *
 * @param
 * @return string
 */
function get_os()
{
    $os = '';
    $agent = trim($_SERVER["HTTP_USER_AGENT"]);

    if (eregi('win', $agent) && strpos($agent, '95'))          { $os = 'Windows 95'; }
    elseif (eregi('win 9x', $agent) && strpos($agent, '4.90')) { $os = 'Windows ME'; }
    elseif (eregi('win', $agent) && ereg('98', $agent))        { $os = 'Windows 98'; }
    elseif (eregi('win', $agent) && eregi('nt 5\.0', $agent))  { $os = 'Windows 2000'; }
    elseif (eregi('win', $agent) && eregi('nt 5\.1', $agent))  { $os = 'Windows XP'; }
    elseif (eregi('win', $agent) && eregi('nt 5\.2', $agent))  { $os = 'Windows 2003'; }
    elseif (eregi('win', $agent) && eregi('nt 6\.0', $agent))  { $os = 'Windows Vista'; }
    elseif (eregi('win', $agent) && eregi('nt', $agent))       { $os = 'Windows NT'; }
    elseif (eregi('win', $agent) && ereg('32', $agent))        { $os = 'Windows 32'; }
    elseif (eregi('linux', $agent))                            { $os = 'Linux'; }
    elseif (eregi('unix', $agent))                             { $os = 'Unix'; }
    elseif (eregi('sun', $agent) && eregi('os', $agent))       { $os = 'SunOS'; }
    elseif (eregi('ibm', $agent) && eregi('os', $agent))       { $os = 'IBM OS/2'; }
    elseif (eregi('Mac', $agent) && eregi('PC', $agent))       { $os = 'Macintosh'; }
    elseif (eregi('PowerPC', $agent))                          { $os = 'PowerPC'; }
    elseif (eregi('AIX', $agent))                              { $os = 'AIX'; }
    elseif (eregi('HPUX', $agent))                             { $os = 'HPUX'; }
    elseif (eregi('NetBSD', $agent))                           { $os = 'NetBSD'; }
    elseif (eregi('BSD', $agent))                              { $os = 'BSD'; }
    elseif (ereg('OSF1', $agent))                              { $os = 'OSF1'; }
    elseif (ereg('IRIX', $agent))                              { $os = 'IRIX'; }
    elseif (eregi('FreeBSD', $agent))                          { $os = 'FreeBSD'; }

    if ($os == '')
    {
        $os_t = explode('(', $agent);
        $os = $os_t[0];
    }

    $os = str_replace('|', '', htmlspecialchars($os));
    if (strlen($os) > 50) { $os = substr($os, 0, 20); }

    return $os;
}

/**
 * 生成唯一标识号
 *
 * @param string $mix 类型变量
 * @return string
 */
function to_guid_string($mix)
{
    if (is_resource($mix))
    {
        $mix = get_resource_type($mix) . strval($mix);
    }
    else
    {
        $mix = serialize($mix);
    }

    return md5($mix);
}

/**
 * 建立目录
 *
 * @param string  $dir  需要建立的目录
 * @param integer $mode 八进制
 * @return boolean
 */
function mk_dir($dir, $mode = 0755)
{
    if (is_dir($dir) || @mkdir($dir, $mode)) { return TRUE; }
    if (!mk_dir(dirname($dir), $mode)) { return FALSE; }
    return @mkdir($dir, $mode);
}

/**
 * 判断目录是否为空
 *
 * @param string $directory 需要判断的目录
 * @return boolean
 */
function empty_dir($directory)
{
    $handle = opendir($directory);
    while (($file = readdir($handle)) !== FALSE)
    {
        if ($file != '.' && $file != '..')
        {
            closedir($handle);
            return FALSE;
        }
    }
    closedir($handle);
    return TRUE;
}

/**
 * 清空目录
 *
 * @param string $dir 需要清空的目录
 * @param string $del 是否删除
 * @return boolean
 */
function clear_dir($dir, $del = FALSE)
{
    if ($handle = opendir($dir))
    {
        while (false !== ($item = readdir($handle)))
        {
            if ($item != "." && $item != "..")
            {
                if (is_dir("$dir/$item"))
                {
                    clear_dir("$dir/$item");
                }
                else
                {
                    unlink("$dir/$item");
                }
            }
        }
        closedir($handle);
        if ($del) { @rmdir($dir); }
    }
}

/**
 * 修正目录路径
 *
 * @param string $directory 目录
 * @return string
 */
function format_dir($directory)
{
    return str_replace(array('/', './', '.\\', '\\', '//', '\\\\'), DIRECTORY_SEPARATOR, $directory);
}

/**
 * 格式化大小
 *
 * @param integer $size 大小
 * @return string
 */
function format_size($size)
{
    $prec = 3;
    $size = round(abs($size));
    $units = array(0 => " B ", 1 => " KB", 2 => " MB", 3 => " GB", 4 => " TB");
    if ($size == 0) { return str_repeat(" ", $prec)."0$units[0]"; }
    $unit = min(4, floor(log($size) / log(2) / 10));
    $size = $size * pow(2, -10 * $unit);
    $digi = $prec - 1 - floor(log($size) / log(10));
    $size = round($size * pow(10, $digi)) * pow(10, -$digi);
    return $size . $units[$unit];
}

/**
 * 将数组元素以相同的数量重组
 *
 * @param array $records 数组
 * @param integer $cols 每组数量
 * @param mixed $colsKey 填充数据
 * @return array
 */
function format_array($records, $cols = 4, $colsKey = NULL)
{
    if (!is_array($records)) { return NULL; }

    $rows = array();
    while ($col = array_splice($records, 0, $cols))
    {
        $rows[] = $col;
    }

    $max_count = count($rows);
    $count = count($rows[$max_count - 1]);
    if ($count % $cols != 0)
    {
        $temp = $rows[0][0];
        if (!is_array($colsKey) && is_array($temp))
        {
            //$colsKey = array_combine(array_keys($temp), array_fill(0, count($temp), $colsKey));
            $colsKey = array();
        }

        for ($fixcol = 1; $fixcol <= ($cols - $count % $cols); $fixcol++)
        {
            $rows[$max_count - 1][] = $colsKey;
        }
    }
    return $rows;
}

/**
 * 根据数组中相同的值重新构造数组
 *
 * @param array $array 数组
 * @return array
 */
function regroup($array)
{
    $arr_new = $arr_value = array();
    foreach ($array as $k => $v)
    {
        $arr_new[$v][] = $k;
        $arr_value[] = $v;
    }
    return array($arr_value, $arr_new);
}

/**
 * 连接字符
 *
 * @param array $idArray 数组
 * @return string
 */
function self_implode($idArray)
{
    return "'" . implode("','", $idArray) . "'";
}

/**
 * 优化的include_once
 *
 * @param string $filename 文件
 * @return boolean
 */
function include_cache($filename)
{
    static $_importFiles = array();

    $filename = format_dir($filename);
    if (file_exists($filename))
    {
        if (!isset($_importFiles[$filename]))
        {
            include($filename);
            $_importFiles[$filename] = TRUE;
            return TRUE;
        }
        return FALSE;
    }
    return FALSE;
}

/**
 * 优化的require_once
 *
 * @param string $filename 文件
 * @return boolean
 */
function require_cache($filename)
{
    static $_importFiles = array();

    $filename = format_dir($filename);
    if (file_exists($filename))
    {
        if (!isset($_importFiles[$filename]))
        {
            require $filename;
            $_importFiles[$filename] = TRUE;
            return TRUE;
        }
        return FALSE;
    }
    return FALSE;
}

/**
 * 检查字符串中是否存在某个值
 *
 * @param string $haystack 操作字符串
 * @param string $needle   需要检查的字符串
 * @return boolean
 */
function in_string($haystack, $needle)
{
    return !(strpos($haystack, $needle) === FALSE);
}

/**
 * 判断字符串是否email格式
 *
 * @param string $email 需要判断的字符串
 * @return string
 */
function is_email($email)
{
    $atom   = '[-a-z0-9!#$%&\'*+/=?^_`{|}~]';
    $domain = '([a-z]([-a-z0-9]*[a-z0-9]+)?)';
    $regex  = '^' . $atom . '+' . '(\.' . $atom . '+)*' . '@' . '('
            . $domain . '{1,63}\.)+' . $domain . '{2,63}' . '$';

    if (eregi($regex, $email))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**
 * 判断是否为对象实例
 *
 * @param mixed $object 实例对象
 * @param mixed $className 对象名
 * @return boolean
 */
function is_instance_of($object, $className)
{
    return $object instanceof $className;
}

/**
 * 判断提交是否正确
 *
 * @param string $value 需要转换的字符串
 * @return boolean
 */
function is_submit_of($value = '')
{
    empty($value) ? 'isPostBack' : $value;
    if (!empty($_POST[$value]) && $_SERVER['REQUEST_METHOD'] == 'POST')
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**
 * 站点链接
 *
 * @param
 * @return string
 */
function get_site_url()
{
    $uri = $_SERVER['REQUEST_URI']
            ? $_SERVER['REQUEST_URI']
            : ($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

    return 'http://' . $_SERVER['HTTP_HOST'] . substr($uri, 0, strrpos($uri, '/') + 1);
}

/**
 * 站点链接
 *
 * @param
 * @return string
 */
function get_base_url()
{
    $baseurl = '';
    if (empty($_SERVER['HTTP_HOST']))
    {
        $baseurl = 'http://' . $_SERVER['HTTP_HOST'];
    }
    else
    {
      $baseurl = 'http://' . $_SERVER['SERVER_NAME'];
    }
    return $baseurl;
}

/**
 * 获取文件名后缀
 *
 * @param
 * @return string
 */
function get_ext($filename)
{
    return strtolower(trim(substr(strrchr($filename, '.'), 1)));
}

/**
 * 转向
 *
 * @param string $url
 * @param integer $t
 * @return void
 */
function self_redirect($url, $t = 0)
{
    echo "<meta http-equiv='refresh' content='" . $t . "; url={$url}'>";
    exit();
}

/**
 * 将xml数据转换成数组
 *
 * @param string $xml 需要转换的xml数据
 * @return array
 */
function xml_to_array($xml)
{
    $array = (array)(simplexml_load_string($xml));
    foreach ($array as $key => $item)
    {
        $array[$key] = struct_to_array((array)$item);
    }
    return $array;
}
function struct_to_array($item)
{
    if(!is_string($item))
    {
        $item = (array)$item;
        foreach ($item as $key => $val)
        {
            $item[$key] = struct_to_array($val);
        }
    }
    return $item;
}

// 有部分虚拟主机不支持如下两个函数
if (!function_exists('file_put_contents'))
{
    define('FILE_APPEND', 8);
    function file_put_contents($file, $string, $append = '')
    {
        $mode = $append == '' ? 'wb' : 'ab';
        $fp = @fopen($file, $mode) or exit("Can not open file $file !");
        flock($fp, LOCK_EX);
        $stringlen = @fwrite($fp, $string);
        flock($fp, LOCK_UN);
        @fclose($fp);
        return $stringlen;
    }
}

if (!function_exists('file_get_contents'))
{
    define('FILE_APPEND', 8);
    function file_get_contents($filename)
    {
        $content = '';
        if (@$fp = fopen($filename, 'r'))
        {
            @$content = fread($fp, filesize($filename));
            @fclose($fp);
        }
        return $content;
    }
}

?>