<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

function authcode($string, $operation, $key = '')
{
    global $config;

    $key = md5($key ? $key : $config['auth_key']);
    $key_length = strlen($key);

    $string = $operation == 'DECODE' ? base64_decode($string) : substr(md5($string . $key), 0, 8) . $string;
    $string_length = strlen($string);

    $rndkey = $box = array();
    $result = '';

    for ($i = 0; $i <= 255; $i++)
    {
        $rndkey[$i] = ord($key[$i % $key_length]);
        $box[$i] = $i;
    }

    for ($j = $i = 0; $i < 256; $i++)
    {
        $j = ($j + $box[$i] + $rndkey[$i]) % 256;
        $tmp = $box[$i];
        $box[$i] = $box[$j];
        $box[$j] = $tmp;
    }

    for ($a = $j = $i = 0; $i < $string_length; $i++)
    {
        $a = ($a + 1) % 256;
        $j = ($j + $box[$a]) % 256;
        $tmp = $box[$a];
        $box[$a] = $box[$j];
        $box[$j] = $tmp;
        $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }

    if ($operation == 'DECODE')
    {
        if (substr($result, 0, 8) == substr(md5(substr($result, 8) . $key), 0, 8))
        {
            return substr($result, 8);
        }
        else
        {
            return '';
        }
	}
    else
    {
        return str_replace('=', '', base64_encode($result));
    }
}

function import($class, $ext = '.class.php')
{
    static $importClass = array();
    if (isset($importClass[$class]))
    {
        return TRUE;
    }
    else
    {
        $importClass[$class] = TRUE;
    }
    $class_strut = explode('.', $class);
    $classfile = __ROOT__ . '/include/' . str_replace('.', '/', $class) . $ext;
    if (array_pop($class_strut) == '*')
    {
        $tmp_base_class = dirname($classfile);
        $dir = glob($tmp_base_class . '/*' . $ext);
        if ($dir)
        {
            foreach ($dir as $k => $v)
            {
                require_once($v);
            }
        }
        return TRUE;
    }
    else
    {
        require_once($classfile);
        return TRUE;
    }
}

function using($class, $ext = '.class.php')
{
    return import($class, $ext);
}

/**
 * 保存全局数组变量
 *
 * @param $name 变量名称
 * @param $data 数据
 * @param $filename 保存的文件名
 * @return void
 */
function save_array($name, $data, $filename = '')
{
    if (empty($filename)) { $filename = __DATA__ . '/' . $name . '.cache.php'; }
    $content = "<?php\r\nif (!defined('__IN_SY__')) { exit('Access Denied'); }\r\n\$$name = "
             . var_export($data, TRUE) . ";\n?>";
    file_put_contents($filename, $content);
    @chmod($filename, 0777);
}

/**
 * 清空缓存
 *
 * @param
 * @return void
 */
function self_ob_clean()
{
    global $config;

    ob_end_clean();
    if ($config['gzipcompress'] && function_exists('ob_gzhandler'))
    {
        ob_start('ob_gzhandler');
    }
    else
    {
        ob_start();
    }
}

/**
 * 自定义异常处理
 *
 * @param string $message 错误信息
 * @param string $type 异常类型 默认为ThinkException
 * 如果指定的异常类不存在，则直接输出错误信息
 * @return void
 */
function throw_exception($message)
{
}

/**
 * cookie设置
 *
 * @param string $name 键
 * @param string $value 值
 * @param string $lifetime 生存周期(秒)
 * @return void
 */
function set_cookie($name, $value, $lifetime = 0)
{
    global $globals, $config, $_SERVER;

    setcookie($config['cookie_prefix'] . $name,
        $value,
        $lifetime ? ($globals['timestamp'] + $lifetime) : 0,
        $config['cookie_path'],
        $config['cookie_domain'],
        $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

/**
 * 清空cookie
 *
 * @param
 * @return void
 */
function clear_cookie()
{
    global $globals;

    set_cookie('auth', '', -86400 * 365);
    $globals['uid'] = 0;
    $globals['username'] = '';
}

/**
 * 数据库连接
 *
 * @param
 * @return void
 */
function self_mysql_connect()
{
    global $globals, $config;

    include_once(__INCLUDE__ . '/mysql/MySQL.class.php');

    $globals['db'] = new MySQL($config['db_host'],
                        $config['db_username'],
                        $config['db_password'],
                        $config['db_name'],
                        $config['db_pconnect']);
    $globals['db']->setCharset($config['db_charset']);
}

/**
 * 数据库连接对象
 *
 * @param
 * @return MySQL
 */
function DB()
{
    global $globals;
    return $globals['db'];
}

/**
 * 获取当前用户信息
 *
 * @param
 * @return void
 */
function get_user()
{
    global $globals, $config, $cookies;

    if ($cookies['auth'])
    {
        @list($password, $uid) = explode("\t", authcode($cookies['auth'], 'DECODE'));
        $globals['uid'] = intval($uid);
        $expr = array('uid' => $globals['uid'], 'password' => $password);
        if ($globals['uid'])
        {
            if ($globals['member'] = $globals['db']->select(T('session'), $expr, '', TRUE))
            {
                $globals['username'] = addslashes($globals['member']['username']);
            }
            else
            {
                if ($member = $globals['db']->select(T('member'), $expr, '', TRUE))
                {
                    $globals['username'] = addslashes($member['username']);
                    $data = array('uid' => $globals['uid'], 'username' => $globals['username'], 'password' => $password);
                    insert_session($data);
                }
                else
                {
                    $globals['uid'] = 0;
                }
            }
        }
    }

    if (empty($globals['uid']))
    {
        clear_cookie();
    }
    else
    {
        $globals['username'] = $globals['member']['username'];
    }
}

/**
 * 添加session
 *
 * @param $data 数据
 * @return void
 */
function insert_session($data)
{
    global $globals, $settings;

    $settings['onlinehold'] = (integer) $settings['onlinehold'];
    if ($settings['onlinehold'] < 300) { $settings['onlinehold'] = 300; }

    // 删除已存在和超时的用户
    $params = new ArrayObject();
    $sql = 'DELETE FROM ' . T('session') . ' WHERE `uid` = ? OR `lastactivity` < ?';
    $params->append(new SqlParameter(1, $data['uid'], DB_PARAM_INT));
    $params->append(new SqlParameter(2, $globals['timestamp'] - $settings['onlinehold'], DB_PARAM_INT));
    $globals['db']->executeNonQuery($sql, $params);

    // 重新添加在线用户
    $data['lastactivity'] = $globals['timestamp'];
    $globals['member'] = $data;
    $globals['db']->insert(T('session'), $data, TRUE);
}

/**
 * 为表名添加前缀
 *
 * @param $name 表名
 * @return string
 */
function get_table_name($name)
{
    global $config;
    return $config['db_table_prefix'] . $name;
}

/**
 * get_table_name函数别名
 *
 * @param $name 表名
 * @return string
 */
function T($name)
{
    return get_table_name($name);
}

/**
 * 获取分类
 *
 * @param $parentid 父ID
 * @return mixed
 */
function get_type_list($parentid = 0)
{
}

/**
 * 获取分类分类
 *
 * @param $parentid 分类id
 * @return mixed
 */
function get_type_info($typeid)
{
    if (empty($typeid) || !is_numeric($typeid)) { return FALSE; }

//    global $globals;

//    $sql = 'SELECT `typeid`, `name`, `byname`, `parentid`, `orderid`'
//         . ' FROM ' . T('type')
//         . ' WHERE `typeid` = ?'
//         . ' ORDER BY `orderid` DESC;';
//    $params = new ArrayObject();
//    $params->append(new SqlParameter(1, intval($typeid), DB_PARAM_INT));
//    return $globals['db']->executeReader($sql, $params, TRUE);

    global $types;
    $typeid = intval($typeid);
    foreach ($types as $key => $value)
    {
        if ($typeid == $value['typeid']) { return $value; }
    }
    return FALSE;
}

/**
 * 获取类型别名
 *
 * @param $typeid 类型id
 * @return mixed
 */
function get_byname($typeid)
{
    if (empty($typeid) || !is_numeric($typeid)) { return FALSE; }
    global $types;
    $typeid = intval($typeid);
    foreach ($types as $key => $value)
    {
        if ($typeid == $value['typeid']) { return $value['byname']; }
    }
    return FALSE;
}

/**
 * 获取类型的媒体数
 *
 * @param $typeid 类型id
 * @return integer
 */
function get_medianum($typeid)
{
    global $types;
    $typeid = intval($typeid);
    foreach ($types as $key => $value)
    {
        if ($typeid == $value['typeid']) { return $value['medianum']; }
    }
    return 0;
}

/**
 * 获取类型id
 *
 * @param $typeid 类型别名
 * @return integer
 */
function get_typeid($byname)
{
    global $types;
    foreach ($types as $key => $value)
    {
        if ($byname == $value['byname']) { return $value['typeid']; }
    }
    return 0;
}

/**
 * 获取数据
 *
 * @param $mediaid id
 * @return mixed
 */
function get_media_info($mediaid)
{
    if (empty($mediaid) || !is_numeric($mediaid)) { return FALSE; }
    global $globals;
    return $globals['db']->select(T('media'), array('mediaid' => intval($mediaid)), '', TRUE);
}

/**
 * 获取数据
 *
 * @param $typeid 分类id
 * @param $size 数量
 * @param $by 条件
 * @return mixed
 */
function get_media_list($typeid, $size = 6, $by = 'vouch')
{
    global $globals, $settings;
    if (!is_numeric($typeid)) { return FALSE; }
    if (!in_array($by, array('mediaid', 'views', 'createdate', 'vouch', 'hot'))) { return FALSE; }

    $cache_name = 'cache/media_list_' . implode('_', array($typeid, $size, $by));
    // 从缓存文件中取得数据
    import('cache');
    $content = Cache::Get($cache_name);
    if (FALSE !== $content) { return $content; }

    $where = ' WHERE ';
    if (empty($typeid))
    {
        $where .= 1;
    }
    else
    {
        $where .= '`typeid` = ' . intval($typeid);
    }

    if (in_array($by, array('mediaid', 'views', 'createdate')))
    {
        $where .= ' ORDER BY `' . $by . '` DESC';
    }
    if (in_array($by, array('vouch', 'hot')))
    {
        $where .= ' AND `' . $by . '` = 1';
    }

    $sql = 'SELECT `mediaid`, `typeid`, `name`, `color`, `pic`, `uvid`, `views` FROM ' . T('media')
         . $where . ' LIMIT 0,' . $size . ';';
    $content = $globals['db']->executeReader($sql);
    // 缓存
    $onlinehold = empty($settings['onlinehold']) ? 300 : $settings['onlinehold'];
    Cache::Add($cache_name, $content, $onlinehold);

    return $content;
}

/**
 * 解析媒体路径
 *
 * @param $mediaid 媒体id
 * @param $typeid 分类id
 * @return string
 */
function get_media_url($mediaid, $typeid)
{
    global $settings;

    if ($settings['allowrewrite'] || $settings['makehtml'])
    {
        return '/' . get_byname(intval($typeid)) . '/' . intval($mediaid) . '/';
    }
    else
    {
        return '/media.php?typeid=' . intval($typeid) . '&mediaid=' . intval($mediaid);
    }
}

/**
 * 重新排序数组
 *
 * @param $data 数组
 * @param $result 返回重组后的数组
 * @param $parentid 父ID
 * @param $depth 深度
 * @return void
 */
function regroup_array($data, &$result = array(), $parentid = 0, $depth = 0)
{
    static  $i = 0;

    if ($data)
    {
        foreach ($data as $value)
        {
            if ($value['parentid'] == $parentid)
            {
                $value['depth'] = $depth;
                $result[$i] = $value;
                $i++;
                $depth++;
                regroup_array($data, $result, $value['typeid'], $depth--);
            }
        }
    }
}

/**
 * 模板调用
 *
 * @param $template 模板名称
 * @return string
 */
function template($template)
{
    global $settings;

    $tpl_path = in_string($template, '/') ? $template : 'template/' . $settings['template'] . '/' . $template;
    $template_tpl = __DATA__ . '/tpl/' . str_replace('/', '.', $tpl_path) . '.php';

    if (!file_exists($template_tpl)
            || (filemtime(__ROOT__ . '/' . $tpl_path . '.html') > filemtime($template_tpl)))
    {
        require_cache(__INCLUDE__ . '/template.inc.php');
        $content = file_get_contents(__ROOT__ . '/' . $tpl_path . '.html');
        $content = template_parse($content);
        //echo $content;
        file_put_contents($template_tpl, $content);
        @chmod($template_tpl, 0777);
    }
    return $template_tpl;
}

/**
 * 程序执行信息
 *
 * @param
 * @return string
 */
function get_process_info()
{
    global $globals, $config;

    $processTime = number_format((microtime(TRUE) - $globals['starttime']), 6);
    $processString = 'Processed in ' . $processTime . ' second(s), '
                    . $globals['db']->getQueries() . ' queries'
                    . ($config['gzipcompress'] ? ', Gzip enabled' : NULL);

    return $processString;
}

/**
 * 调整输出
 *
 * @param
 * @return void
 */
function ob_out()
{
    global $settings;

    $content = ob_get_contents();

    $preg_searchs = $preg_replaces = array();

    if ($settings['allowrewrite'] || $settings['makehtml'])
    {
        $preg_searchs[] = "/\<a href\=\"type\.php\?typeid\=(\d+)(&page\=(\d+))?\"/ie";
        $preg_searchs[] = "/\<a href\=\"media\.php\?typeid\=(\d+)&mediaid\=(\d+)\"/ie";
        $preg_searchs[] = "/views.php/i";
        $preg_searchs[] = "/search.php/i";

        $preg_replaces[] = "rewrite_type('\\1', '\\3')";
        $preg_replaces[] = "rewrite_media('\\1', '\\2')";
        $preg_replaces[] = $settings['sitepath'] . '/views.php';
        $preg_replaces[] = $settings['sitepath'] . '/search.php';
    }

    if ($preg_searchs) { $content = preg_replace($preg_searchs, $preg_replaces, $content); }

    self_ob_clean();

    echo $content;
}

/**
 * rewrite分类链接
 *
 * @param $typeid 类型id
 * @param $page 当前页数
 * @return string
 */
function rewrite_type($typeid, $page = 0)
{
    global $settings;
    $byname = get_byname($typeid);
    $path = $settings['sitepath'] . '/' . $byname . '/';
    is_numeric($page) && $page > 1 ? intval($page) : 0;
    $page ? ($page == 1 ? $path .= 'index.html' : $path .= 'index_' . $page . '.html') : $path;
    return '<a href="' . $path . '"';
}

/**
 * rewrite链接
 *
 * @param $typeid 类型id
 * @param $page 当前页数
 * @return string
 */
function rewrite_media($typeid, $mediaid)
{
    global $settings;
    $byname = get_byname($typeid);
    $path = $settings['sitepath'] . '/' . $byname . '/' . $mediaid . '/';
    return '<a href="' . $path . '"';
}

/**
 * 跳转链接
 *
 * @param $jump_url 跳转的路径
 * @return void
 */
function jump_url($jump_url)
{
    global $settings;
    if ($jump_url != '')
    {
        // 执行跳转
        header("HTTP/1.1 301 Moved Permanently"); // 面向搜索引擎的友好模式
        header("location:$jump_url");
        exit();
    }
    else
    {
        // 其他异常处理
        header("Content-Language: charset=zh-cn");
        header("Content-type: text/html; charset=UTF-8");
        echo '<P> 因网站升级，可能部分页面不存在，请访问 <a href="' . $settings['siteurl'] . '">网站首页</a> 重新查找您喜爱的影视! ';
        echo '<HR> The page you requested does not exist or has moved, ';
        echo '<P> <a href="' . $settings['siteurl'] . '">Please Visit Our Homepage</a>';
        exit();
    }
}
?>