<?php

class Image
{
    /**
     * 取得图像信息
     *
     * @static
     * @access public
     * @param string $filename 图像文件名，远程文件须将空格编码成%20
     * @return mixed
     */
    public static function getImageInfo($filename)
    {
        $imageInfo = getimagesize($filename);
        if ($imageInfo!== FALSE)
        {
            $imageType = strtolower(substr(image_type_to_extension($imageInfo[2]), 1));
            $imageSize = @filesize($filename);
            $info = array(
                'width' => $imageInfo[0],
                'height' => $imageInfo[1],
                'type' => $imageType,
                'size' => $imageSize,
                'mime' => $imageInfo['mime']
            );
            return $info;
        }
        else
        {
            return FALSE;
        }
    }

    /**
     * 将图像输出到浏览器或文件
     *
     * @static
     * @access public
     * @param string $imgFile 图像文件名
     * @param string $text 文字字符串
     * @param string $width 图像宽度
     * @param string $height 图像高度
     * @return void
     */
    public static function show($imgFile, $width = 80, $height = 30)
    {
        //获取图像文件信息
        $info = Image::getImageInfo($imgFile);
        if ($info !== false)
        {
            $createFun = str_replace('/', 'createfrom', $info['mime']);
            $im = $createFun($imgFile);
            if ($im)
            {
                $imageFun = str_replace('/', '', $info['mime']);
                if ($info['type'] == 'png' || $info['type'] == 'gif')
                {
                    imagealphablending($im, FALSE); //取消默认的混色模式
                    imagesavealpha($im, TRUE); //设定保存完整的 alpha 通道信息
                }
                Header('Content-type: ' . $info['mime']);
                $imageFun($im);
                @ImageDestroy($im);
                return ;
            }
        }
        //获取或者创建图像文件失败则生成空白PNG图片
        $im  = imagecreatetruecolor($width, $height);
        $bgc = imagecolorallocate($im, 255, 255, 255);
        $tc  = imagecolorallocate($im, 0, 0, 0);
        imagefilledrectangle($im, 0, 0, 150, 30, $bgc);
        imagestring($im, 4, 5, 5, 'NO PIC', $tc);
        Image::output($im);
        return ;
    }

    /**
     * 将图像输出到浏览器或文件
     *
     * @static
     * @access public
     * @param resource $im 图像资源
     * @param string $type 图像类型
     * @return void
     */
    public static function output($im, $type = 'png')
    {
        header('Content-type: image/' . $type);
        $imageFun = 'image' . $type;
        $imageFun($im);
        imagedestroy($im);
    }

    /**
     * 保存图像
     *
     * @static
     * @access public
     * @param resource $url 图像资源的路径
     * @param string $filename 文件名
     * @return void
     */
    public static function save($url, $filename)
    {
        import('http');
        $im = Http::quickGet($url);
        $result = file_put_contents($filename, $im);
        if ($result)
        {
            clearstatcache();
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }

}

?>